


pack(n)                Tk Built-In Commands               pack(n)


_________________________________________________________________

NAME
       pack - Geometry manager that packs around edges of cavity

SYNOPSIS
       pack option arg ?arg ...?
_________________________________________________________________


DESCRIPTION
       The pack command is used to communicate with the packer, a
       geometry manager that arranges the children of a parent by
       packing them in order around the edges of the parent.  The
       pack command can have any of several forms,  depending  on
       the option argument:

       pack slave ?slave ...? ?options?
              If the first argument to pack is a window name (any
              value starting with ``.''),  then  the  command  is
              processed in the same way as pack configure.

       pack configure slave ?slave ...? ?options?
              The  arguments  consist of the names of one or more
              slave windows followed by pairs of  arguments  that
              specify how to manage the slaves.  See ``THE PACKER
              ALGORITHM'' below for details on  how  the  options
              are  used by the packer.  The following options are
              supported:

              -after other
                     Other must the name of another window.   Use
                     its master as the master for the slaves, and
                     insert the slaves just after  other  in  the
                     packing order.

              -anchor anchor
                     Anchor  must be a valid anchor position such
                     as n or sw; it specifies where  to  position
                     each  slave in its parcel.  Defaults to cen-
                     ter.

              -before other
                     Other must the name of another window.   Use
                     its master as the master for the slaves, and
                     insert the slaves just before other  in  the
                     packing order.

              -expand boolean
                     Specifies   whether  the  slaves  should  be
                     expanded to consume  extra  space  in  their
                     master.  Boolean may have any proper boolean
                     value, such as 1 or no.  Defaults to 0.




Tk                             4.0                              1





pack(n)                Tk Built-In Commands               pack(n)


              -fill style
                     If a  slave's  parcel  is  larger  than  its
                     requested  dimensions,  this  option  may be
                     used to stretch the slave.  Style must  have
                     one of the following values:

                      none   Give  the slave its requested dimen-
                             sions  plus  any  internal   padding
                             requested  with  -ipadx  or  -ipady.
                             This is the default.

                      x      Stretch the  slave  horizontally  to
                             fill  the entire width of its parcel
                             (except leave  external  padding  as
                             specified by -padx).

                      y      Stretch the slave vertically to fill
                             the  entire  height  of  its  parcel
                             (except  leave  external  padding as
                             specified by -pady).

                      both   Stretch the slave both  horizontally
                             and vertically.

              -in other
                     Insert  the slave(s) at the end of the pack-
                     ing order for the  master  window  given  by
                     other.

              -ipadx amount
                     Amount  specifies how much horizontal inter-
                     nal padding to leave on  each  side  of  the
                     slave(s).   Amount  must  be  a valid screen
                     distance, such as 2 or .5c.  It defaults  to
                     0.

              -ipady amount
                     Amount  specifies how much vertical internal
                     padding  to  leave  on  each  side  of   the
                     slave(s).  Amount  defaults to 0.

              -padx amount
                     Amount  specifies how much horizontal exter-
                     nal padding to leave on  each  side  of  the
                     slave(s).  Amount defaults to 0.

              -pady amount
                     Amount  specifies how much vertical external
                     padding  to  leave  on  each  side  of   the
                     slave(s).  Amount defaults to 0.

              -side side
                     Specifies  which  side  of  the  master  the
                     slave(s) will be packed  against.   Must  be



Tk                             4.0                              2





pack(n)                Tk Built-In Commands               pack(n)


                     left,  right,  top,  or bottom.  Defaults to
                     top.

              If no -in, -after or -before  option  is  specified
              then each of the slaves will be inserted at the end
              of the packing list for its  parent  unless  it  is
              already  managed  by  the  packer (in which case it
              will be left where it is).  If one of these options
              is  specified  then all the slaves will be inserted
              at the specified point.  If any of the  slaves  are
              already  managed  by  the geometry manager then any
              unspecified options for them retain their  previous
              values rather than receiving default values.

       pack forget slave ?slave ...?
              Removes  each  of the slaves from the packing order
              for its  master  and  unmaps  their  windows.   The
              slaves will no longer be managed by the packer.

       pack info slave
              Returns  a list whose elements are the current con- |
              figuration state of the slave given by slave in the |
              same  option-value  form that might be specified to |
              pack configure.  The first two elements of the list |
              are ``-in master'' where master is the slave's mas- |
              ter.

       pack propagate master ?boolean?
              If boolean has a true boolean value such as 1 or on
              then  propagation is enabled for master, which must
              be a  window  name  (see  ``GEOMETRY  PROPAGATION''
              below).   If boolean has a false boolean value then
              propagation is disabled for master.  In  either  of
              these  cases  an  empty  string  is  returned.   If
              boolean is omitted then the command returns 0 or  1
              to   indicate   whether  propagation  is  currently
              enabled for  master.   Propagation  is  enabled  by
              default.

       pack slaves master
              Returns  a list of all of the slaves in the packing
              order for master.  The order of the slaves  in  the
              list  is  the  same  as  their order in the packing
              order.  If master  has  no  slaves  then  an  empty
              string is returned.


THE PACKER ALGORITHM
       For  each  master  the packer maintains an ordered list of
       slaves called the packing  list.   The  -in,  -after,  and
       -before configuration options are used to specify the mas-
       ter for each slave and the slave's position in the packing
       list.   If none of these options is given for a slave then
       the slave is added to the end of the packing list for  its



Tk                             4.0                              3





pack(n)                Tk Built-In Commands               pack(n)


       parent.

       The  packer  arranges  the slaves for a master by scanning
       the packing list in order.  At the time it processes  each
       slave, a rectangular area within the master is still unal-
       located.  This area is called the cavity;  for  the  first
       slave it is the entire area of the master.

       For each slave the packer carries out the following steps:

       [1]    The packer allocates a rectangular parcel  for  the
              slave  along  the  side  of the cavity given by the
              slave's -side option.  If the side is top or bottom
              then  the  width  of the parcel is the width of the
              cavity and its height is the  requested  height  of
              the  slave  plus the -ipady and -pady options.  For
              the left or right side the height of the parcel  is
              the  height  of  the  cavity  and  the width is the
              requested width of the slave plus  the  -ipadx  and
              -padx  options.  The parcel may be enlarged further
              because of the -expand  option  (see  ``EXPANSION''
              below)

       [2]    The  packer  chooses  the  dimensions of the slave.
              The width will normally be  the  slave's  requested
              width  plus  twice its -ipadx option and the height
              will normally be the slave's requested height  plus
              twice  its  -ipady  option.   However, if the -fill
              option is x or both then the width of the slave  is
              expanded  to  fill  the  width of the parcel, minus
              twice the -padx option.  If the -fill option  is  y
              or both then the height of the slave is expanded to
              fill the width of the parcel, minus twice the -pady
              option.

       [3]    The packer positions the slave over its parcel.  If
              the slave is  smaller  than  the  parcel  then  the
              -anchor  option  determines where in the parcel the
              slave will be placed.  If -padx or  -pady  is  non-
              zero,  then  the  given  amount of external padding
              will always be left between the slave and the edges
              of the parcel.

       Once a given slave has been packed, the area of its parcel
       is subtracted from the cavity, leaving a smaller rectangu-
       lar cavity for the next slave.  If a slave doesn't use all
       of its parcel, the unused space in the parcel will not  be
       used  by  subsequent  slaves.  If the cavity should become
       too small to meet the needs of a slave then the slave will
       be  given  whatever  space  is left in the cavity.  If the
       cavity shrinks to zero size, then all remaining slaves  on
       the  packing  list  will be unmapped from the screen until
       the master window becomes large enough to hold them again.




Tk                             4.0                              4





pack(n)                Tk Built-In Commands               pack(n)


EXPANSION
       If  a  master  window is so large that there will be extra
       space left over after all of its slaves have been  packed,
       then the extra space is distributed uniformly among all of
       the slaves for which the -expand  option  is  set.   Extra
       horizontal  space  is  distributed  among  the  expandable
       slaves whose -side is left or right,  and  extra  vertical
       space  is  distributed  among  the expandable slaves whose
       -side is top or bottom.


GEOMETRY PROPAGATION
       The packer normally computes how large a master must be to
       just exactly meet the needs of its slaves, and it sets the
       requested width and height of the master to  these  dimen-
       sions.   This  causes geometry information to propagate up
       through a window hierarchy to a top-level window  so  that
       the  entire  sub-tree sizes itself to fit the needs of the
       leaf windows.  However, the pack propagate command may  be
       used  to turn off propagation for one or more masters.  If
       propagation is disabled then the packer will not  set  the
       requested  width  and  height  of the packer.  This may be
       useful if, for example, you wish for a  master  window  to
       have a fixed size that you specify.


RESTRICTIONS ON MASTER WINDOWS
       The  master for each slave must either be the slave's par-
       ent (the default) or a descendant of the  slave's  parent.
       This  restriction is necessary to guarantee that the slave
       can be placed over any part of its master that is  visible
       without danger of the slave being clipped by its parent.


PACKING ORDER
       If  the master for a slave is not its parent then you must
       make sure that the slave is higher in the  stacking  order
       than  the  master.   Otherwise the master will obscure the
       slave and it will appear  as  if  the  slave  hasn't  been
       packed  correctly.  The easiest way to make sure the slave
       is higher than the master is to create the  master  window
       first:   the  most recently created window will be highest
       in the stacking order.  Or, you  can  use  the  raise  and
       lower  commands to change the stacking order of either the
       master or the slave.


KEYWORDS
       geometry manager, location, packer,  parcel,  propagation,
       size







Tk                             4.0                              5


