/*
 * 32x32.c, a part of the W Window System
 *
 * Copyright (C) 1996 by Eero Tamminen
 *
 * This package is free software; you can redistribute it and/or modify it
 * under the terms specified in the docs/COPYRIGHTS file coming with this
 * package.
 *
 * -- 32x32 wjewel bitmaps
 *
 * NOTES
 * - W needs image bitmap to be long aligned:  8 * 32x32 pieces = 256x32
 *   pixels -> 6 pieces, 'jewel' and border blocks.
 */

#include "jewel.h"

#define BLK_SIZE	32

static unsigned char bitmaps[BLOCKS * BLK_SIZE / 8 * BLK_SIZE] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc0, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x01,
  0xc0, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x01,
  0xc0, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x01,
  0xc0, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x03,
  0xc0, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x03,
  0xc0, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x03,
  0xc0, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x03,
  0xc0, 0x00, 0x00, 0x03, 0xd0, 0x00, 0x00, 0x07,
  0xcf, 0xff, 0xff, 0xc7, 0xcf, 0xff, 0xff, 0xc7,
  0xcf, 0xff, 0xff, 0xc7, 0xcf, 0xff, 0xff, 0xc7,
  0xcf, 0xff, 0xff, 0xc7, 0xcf, 0xff, 0xff, 0xc7,
  0xc0, 0x00, 0x00, 0x07, 0xc8, 0x00, 0x00, 0x0f,
  0xcf, 0xff, 0xff, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcf, 0xff, 0xff, 0x8f, 0xcf, 0xff, 0xff, 0x8f,
  0xcf, 0xff, 0xff, 0x8f, 0xcf, 0xff, 0xff, 0x8f,
  0xc0, 0x03, 0x00, 0x0f, 0xc4, 0x00, 0x00, 0x1f,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x3c, 0x0f, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0xff, 0xff, 0x0f,
  0xc0, 0x04, 0x80, 0x0f, 0xc2, 0x00, 0x00, 0x3f,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x78, 0x1e, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0xff, 0xfe, 0x0f,
  0xc0, 0x09, 0x40, 0x0f, 0xc1, 0x00, 0x00, 0x7f,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0xf0, 0x3c, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x00, 0x00, 0x0f,
  0xc0, 0x10, 0xa0, 0x0f, 0xc0, 0x80, 0x00, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcd, 0xe0, 0x78, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x00, 0x00, 0x0f,
  0xc0, 0x21, 0x50, 0x0f, 0xc0, 0x40, 0x01, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0xc0, 0xf0, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x00, 0x01, 0x0f,
  0xc0, 0x40, 0xa8, 0x0f, 0xc0, 0x20, 0x03, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0x81, 0xe0, 0x4f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x00, 0x03, 0x0f,
  0xc0, 0x81, 0x54, 0x0f, 0xc0, 0x10, 0x07, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0x03, 0xc0, 0xcf,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x0f, 0xc7, 0x0f,
  0xc1, 0x00, 0xaa, 0x0f, 0xc0, 0x08, 0x0f, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xce, 0x07, 0x81, 0xcf,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x0f, 0x8f, 0x0f,
  0xc2, 0x01, 0x55, 0x0f, 0xc0, 0x04, 0x1f, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x0f, 0x03, 0xcf,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x0c, 0x0f, 0x0f,
  0xc4, 0x02, 0xaa, 0x8f, 0xc0, 0x02, 0x3f, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x1e, 0x07, 0x8f,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x0c, 0x0f, 0x0f,
  0xc5, 0x55, 0xff, 0x8f, 0xc0, 0x01, 0x7f, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x3c, 0x0f, 0x0f,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x0c, 0x0f, 0x0f,
  0xc2, 0xab, 0xff, 0x0f, 0xc0, 0x00, 0x7f, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x78, 0x1e, 0x0f,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x08, 0x0f, 0x0f,
  0xc1, 0x55, 0xfe, 0x0f, 0xc0, 0x01, 0xbf, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0xf0, 0x3c, 0x0f,
  0xcc, 0x0f, 0xe0, 0x0f, 0xcf, 0x00, 0x0f, 0x0f,
  0xc0, 0xab, 0xfc, 0x0f, 0xc0, 0x03, 0xdf, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcd, 0xe0, 0x78, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x00, 0x0f, 0x0f,
  0xc0, 0x55, 0xf8, 0x0f, 0xc0, 0x07, 0xef, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0xc0, 0xf0, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x07, 0xff, 0x0f,
  0xc0, 0x2b, 0xf0, 0x0f, 0xc0, 0x0f, 0xf7, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0x81, 0xe0, 0x0f,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x0f, 0xff, 0x0f,
  0xc0, 0x15, 0xe0, 0x0f, 0xc0, 0x1f, 0xfb, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcf, 0x03, 0xc0, 0xcf,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcf, 0x1f, 0xff, 0x0f,
  0xc0, 0x0b, 0xc0, 0x0f, 0xc0, 0x3f, 0xfd, 0xff,
  0xce, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xce, 0x07, 0x81, 0xcf,
  0xcf, 0xf0, 0x1f, 0x8f, 0xce, 0x3f, 0xff, 0x0f,
  0xc0, 0x05, 0x80, 0x0f, 0xc0, 0x7f, 0xfe, 0xff,
  0xcd, 0x55, 0x55, 0x4f, 0xcf, 0xff, 0xff, 0xcf,
  0xcc, 0x00, 0x00, 0x0f, 0xcc, 0x0f, 0x03, 0xcf,
  0xcf, 0xf0, 0x1f, 0x8f, 0xcc, 0x00, 0x00, 0x0f,
  0xc0, 0x03, 0x00, 0x0f, 0xc0, 0xff, 0xff, 0x7f,
  0xca, 0xaa, 0xaa, 0x8f, 0xcf, 0xff, 0xff, 0xcf,
  0xc8, 0x00, 0x00, 0x0f, 0xcc, 0x1e, 0x03, 0x8f,
  0xc8, 0x00, 0x00, 0x0f, 0xc8, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc1, 0xff, 0xff, 0xbf,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc3, 0xff, 0xff, 0xdf,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f,
  0xc0, 0x00, 0x00, 0x0f, 0xc7, 0xff, 0xff, 0xef,
  0xc7, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff,
  0xc7, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff,
  0xc7, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff,
  0xc7, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xf7,
  0xcf, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
  0xcf, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
  0xcf, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff,
  0xcf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xfb,
  0xdf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
  0xdf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
  0xdf, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff,
  0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};


Blocks LargeBlocks =
{
  BLK_SIZE,
  BLK_SIZE,
  bitmaps
};

