//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton
//
// Non-commercial use by individuals
// is permitted.
// 
//

#include <time.h>
#include <dos.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "frand.h"
#include "tg.h"

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define abs(a) (((a)<0) ? -(a) : (a))
#define sign(a) (((a)<0) ? -1 : (a)>0 ? 1 : 0)

tg screen;

//---------------------------------------------------
//
// A real can of worms.
//
// Draw a bunch of worms that crawl around the screen.
//

#define worms (100)
#define segments (50)

typedef struct
{
    int x, y;
} point;

typedef struct
{
    int head;
    int color;
    int heading;
    point body[segments];
} worm;

static point headings[] =
{
    { 0, 1},
    { 1, 1},
    { 1, 0},
    { 1,-1},
    { 0,-1},
    {-1,-1},
    {-1, 0},
    {-1, 1}
};

void
demoWorm(int mode)
{
    worm can[worms];
    int head;
    int tail;
    int i, j, k;
    int x, y;
    int next;

    screen.mode(mode);
    screen.setVisiblePage(0);
    screen.setActivePage(0);
    screen.clear(0);

    fsrand((unsigned) time(NULL));

    for (i = 0; i < worms; i++)
    {
        can[i].head = 0;
        can[i].heading = i & 0x7;
        can[i].color = (i & 0x7f) + 32;
        for (j = 0; j < segments; j++)
        {
            can[i].body[j].x = screen.maxx / 2;
            can[i].body[j].y = screen.maxy / 2;
        }
    }

    while (!kbhit())
    {
        for (i = 0; i < worms; i++)
        {
            tail = head = can[i].head;
            head++;
            if (head >= segments)
            {
                head = 0;
            }
            can[i].head = head;

            screen.pixel(can[i].body[head].x, 
                         can[i].body[head].y, 
                         0);

            if (frand() < (FRAND_MAX / 10))
            {
                if (frand() < (FRAND_MAX / 2))
                {
                    can[i].heading = (can[i].heading + 1) & 0x7;
                }
                else
                {
                    can[i].heading = (can[i].heading - 1) & 0x7;
                }
            }

            x = can[i].body[tail].x;
            y = can[i].body[tail].y;

            x = x + headings[can[i].heading].x;
            y = y + headings[can[i].heading].y;

            next = screen.pixel(x, y);
            k = 0;
            while (next != -1 && 
                   next != 0 && 
                   next != can[i].color && 
                   k < 2)
            {
                can[i].heading = frand() & 0x7;

                x = can[i].body[tail].x;
                y = can[i].body[tail].y;

                x = x + headings[can[i].heading].x;
                y = y + headings[can[i].heading].y;

                next = screen.pixel(x, y);
                k++;
            }

            if (x < 0)
            {
                x = screen.maxx;
            }

            if (x > screen.maxx)
            {
                x = 0;
            }

            if (y < 0)
            {
                y = screen.maxy;
            }

            if (y > screen.maxy)
            {
                y = 0;
            }

            can[i].body[head].x = x;
            can[i].body[head].y = y;

            screen.pixel(x, y, can[i].color);
        }

        screen.drawText(0, 0, 15, screen.modeName);
    }
    getch();
}

//---------------------------------------------------
//
// Draw a terrain map using a simple fractal generation
// technique. Makes pretty pictures.
//

//
// Set up the palette used by this demo.
//

void
setFractPalette()
{
    int i;
    color p[256];

    memset(p, 0xff, sizeof(p));

    p[0].red = 0;
    p[0].green = 0;
    p[0].blue = 0;

    for (i = 1; i <= 64; i++)
    {
        p[i].red = i - 1;
        p[i].green = i - 1;
        p[i].blue = 64 - i;
    }

    screen.setPalette(0, 256, p);
}

//
// Decide whether to increment the depth or to
// decriment the depth.
//

int
plusOrNot(int value)
{
    if (value < 64 && frand() > (FRAND_MAX / 2))
    {
        return min(value + 4, 64);
    }

    return max(value - 4, 1);
}

//
// Recursively visit each pixel and decide what color
// it should be. 
//

void
fillAndSplit(int x, int y, int width, int height, int color)
{
    int width2;
    int height2;

    if (kbhit())
    {
        return;
    }

    width2 = width / 2;
    height2 = height / 2;

    color = plusOrNot(color);

    if (width2 > 0 && height2 > 0)
    {
        fillAndSplit(x, 
                     y, 
                     width2, 
                     height2,
                     color);

        fillAndSplit(x + width2, 
                     y,
                     width - width2,
                     height2,
                     color);

        fillAndSplit(x,
                     y + height2, 
                     width2, 
                     height - height2, 
                     color);

        fillAndSplit(x + width2,
                     y + height2,
                     width - width2, 
                     height - height2, 
                     color);
    }
    else if (width2 > 0)
    {
        fillAndSplit(x, 
                     y, 
                     width2, 
                     height,
                     color);

        fillAndSplit(x + width2, 
                     y,
                     width - width2,
                     height,
                     color);
    }
    else if (height2 > 0)
    {
        fillAndSplit(x, 
                     y, 
                     width, 
                     height2,
                     color);

        fillAndSplit(x,
                     y + height2, 
                     width, 
                     height - height2, 
                     color);
    }
    else
    {
        screen.pixel(x, y, color);
    }
}

//
// Set up and run the demo.
//

void
demoFract(int mode)
{
    int i;
    int activePage = 0;

    screen.mode(mode);
    screen.setVisiblePage(0);
    setFractPalette();
    screen.setColor(255, 255, 0, 0);

    fsrand((unsigned) time(NULL));

    while (!kbhit())
    {
        screen.setActivePage(activePage);
        screen.clear(0);

        fillAndSplit(0, 0, screen.maxx, screen.maxy, 32);

        screen.drawText(0, 0, 255, screen.modeName);
        screen.setVisiblePage(activePage);

        activePage++;
        activePage %= screen.pages;
    }

    getch();
}

//---------------------------------------------------
//
// Demo of line drawing. Gives a feel for the effects
// of different pixel sizes.
//

void
demoLine(int mode)
{
    int activePage = 1;
    int x, y;
    int red = 40;
    int green = 48;

    screen.mode(mode);
    screen.setVisiblePage(0);

    while (!kbhit())
    {
        x = 0;
        while (!kbhit() && x < screen.maxx)
        {
            screen.setActivePage(activePage);
            screen.clear(0);
    
            screen.line(x, 0, screen.maxx - x, screen.maxy, red);
            screen.line(screen.maxx - x, 0, x, screen.maxy, green);
    
            screen.drawText(0, 0, 15, screen.modeName);
            screen.setVisiblePage(activePage);

            activePage++;
            activePage %= screen.pages;
    
            x++;
        }

        y = 0;
        while (!kbhit() && y < screen.maxy)
        {
            screen.setActivePage(activePage);
            screen.clear(0);
    
            screen.line(screen.maxx, y, 0, screen.maxy - y, red);
            screen.line(screen.maxx, screen.maxy - y, 0, y, green);
    
            screen.drawText(0, 0, 15, screen.modeName);
            screen.setVisiblePage(activePage);

            activePage++;
            activePage %= screen.pages;
    
            y++;
        }
    }

    getch();
}

//---------------------------------------------------
//
// Text screen functions
//

#define textPage ((char *)0xb8000)

void
ttMove(int row, int col)
{
    union REGS rg;

    rg.h.ah = 0x02;		/* set cursor position function code */
    rg.h.dl = col;
    rg.h.dh = row;
    rg.h.bh = 0;		/* set screen page number */

    int386(0x10, &rg, &rg);
}

void
ttErasePage()
{
    int i;
    char *ch = textPage;

    for (i = 0; i < (25 * 80); i++)
    {
	*ch++ = ' ';
	*ch++ = 0x17;
    }
}

void
ttPut(int row, int col, char *text)
{
    int n;
    char *ch = textPage + ((row * 80) << 1) + (col << 1);

    while (*text)
    {
	*ch++ = *text++;
	*ch++ = 0x17;
    }
}

//---------------------------------------------------
//
// Ask the user which demo to run and which tweaked
// video mdoe to use.
//

void
main(int argc, char *argv[])
{
    int mode = 0;
    char demo = 0;

    ttErasePage();
    while (TRUE)
    {
        ttPut( 2, 30, "Tweaked Mode Demos");
        ttPut( 4, 34, "Quit  [q]");
        ttPut( 5, 34, "Worms [w]");
        ttPut( 6, 34, "Fract [f]");
        ttPut( 7, 34, "Lines [l]");
        ttPut( 9, 30, "Which Demo [wflq]?");

        ttPut(11, 34, "160x120 [0]");
        ttPut(12, 34, "296x220 [1]");
        ttPut(13, 34, "320x200 [2]");
        ttPut(14, 34, "320x240 [3]");
        ttPut(15, 34, "320x400 [4]");
        ttPut(16, 34, "360x360 [5]");
        ttPut(17, 34, "400x300 [6]");
        ttPut(18, 30, "Which Mode [0123456]?");

        demo = ' ';
        while (NULL == memchr("wflqWFLQ", demo, 8))
        {
            ttMove(9, 48);
            while(!kbhit());
            demo = getche();
        }

        if (demo == 'q')
        {
            exit(0);
        }

        mode = -1;
        while (mode < t160x120  || mode > t400x300)
        {
            ttMove(18, 51);
            while(!kbhit());
            mode = getche() - '0';
        }

        switch (demo)
        {
        case 'w':
        case 'W':
            demoWorm(mode);
            break;

        case 'f':
        case 'F':
            demoFract(mode);
            break;

        case 'l':
        case 'L':
            demoLine(mode);
            break;
        }
        screen.resetMode();
        ttErasePage();
    }
}
