// This program was written by Jrgen Hoffmann in the year 2009
// and compiled under Borland C++ Version 3.1 using the Small model
//
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include <tcp.h>
#include <wattcp.h>

#ifdef __cplusplus
    #define __CPPARGS ...
#else
    #define __CPPARGS
#endif

#define TMPSTACKSIZE 512
unsigned int *tmpstack;
unsigned int reboot0 = 0;
unsigned int reboot1 = 0;
unsigned char recon0, recon1;
unsigned long lastclient;
unsigned int  intsp, intss, intpsp, mypsp;
char far *indos_ptr = NULL;
char far *crite_ptr = NULL;
#define DEADLOCKTIMER 300      // 1092
int tcount0 = 2;
int tcount1, tcount2, tcount3, hdcalled, hdbusy0, hdbusy1, hdreq;
int vcall0, vcall1, vcall2, vcall3, int28, count28, curpos;

int               charstate = 0;
unsigned char      lastchar = 0;
unsigned char        eschar = 0;
unsigned char        enhkbd = 0;
unsigned int  far *kbdflg   = MK_FP(0x0040,0x0017);
unsigned int  far *kbdflg2  = MK_FP(0x0040,0x0096);
unsigned int  far *bufbeg   = MK_FP(0x0040,0x0080);
unsigned int  far *bufhead  = MK_FP(0x0040,0x001A);
unsigned int  far *buftail  = MK_FP(0x0040,0x001C);
unsigned char far *breakey  = MK_FP(0x0040,0x0071);

void intrservice(void);
void setpsp(unsigned int newpsp);

unsigned criterr_ax, criterr_bp, criterr_si;
typedef void interrupt (*IPTRPTR)(__CPPARGS);
IPTRPTR far *int24 = MK_FP(0x0000,0x0024*4);
void interrupt myint24(bp) {
  criterr_ax = _AX;
  criterr_bp = bp;
  criterr_si = _SI;
  _AL = 2;
  }

void trigger_break(void) {
  union  REGS  regs;
  criterr_ax = 0xFF;
  *breakey   = 0x80;
  *buftail   = *bufhead = *bufbeg;
  int86(0x1B, &regs, &regs);
  }

void reboot(void) {
  void interrupt (*rebootadr)(__CPPARGS);
  rebootadr = MK_FP(0xFFFF,0x0000);
  _chain_intr(rebootadr);
  }

#define TMINTR 0X1C
void interrupt (*oldhandler)(__CPPARGS);
void interrupt myhandler(__CPPARGS) {
//  oldhandler();
  if(*int24 != myint24) *int24 = myint24;
  if(!--tcount3) trigger_break();
//if(tcount3 < -700) { if(reboot0) reboot(); }
  if(!--tcount2 || hdreq) {
    hdcalled++;
    if(hdbusy1 || *indos_ptr || *crite_ptr) { hdreq = 1; hdbusy0++; }
    else {
      hdbusy1++;
      hdreq = 0;
      int28 = 0;
      disable();
      intrservice();
      enable();
      tcount2 = 6;
      hdbusy1 = 0;
      }
    }
  _chain_intr(oldhandler);
  }

#define INTR28 0X28
void interrupt (*oldint28)(__CPPARGS);
void interrupt myint28(__CPPARGS) {
//  oldint28();
  if(hdreq) {
    if(hdbusy1 || (*indos_ptr > 1) || *crite_ptr) { tcount2 = 1; hdbusy0++; }
    else {
      hdbusy1++;
      hdreq = 0;
      int28 = 1;
      count28++;
      disable();
      intrservice();
      enable();
      tcount2 = 6;
      hdbusy1 = 0;
      }
    }
  _chain_intr(oldint28);
  }

void PushChar(unsigned char c, unsigned char s, unsigned int flg) {
  union  REGS  regs;
  *kbdflg |= flg;
  regs.h.ah = 0x05;
  regs.h.ch = s;
  regs.h.cl = c;
  int86(0x16, &regs, &regs);
  }

void setpsp(unsigned int newpsp) {
  union  REGS  regs;
  regs.h.ah = 0x50;
  regs.x.bx = newpsp;
  intdos(&regs, &regs);
  }

void dos_c_dup(unsigned int hd0, unsigned int hd1) {
  union  REGS  regs;
  regs.h.ah = 0x46;
  regs.x.bx = hd0;
  regs.x.cx = hd1;
  intdos(&regs, &regs);
  }

void get_dos_pointers(void) {
  union  REGS  regs;
  struct SREGS sregs;
  if(_osmajor > 2) {
    regs.h.ah = 0x34;
    intdosx(&regs, &regs, &sregs);
    if(!regs.x.cflag) indos_ptr = MK_FP(sregs.es,regs.x.bx);
    if((_osmajor==3)&&(_osminor==0)) crite_ptr = indos_ptr - 1;
    else {
      regs.x.ax = 0x5D06;
      intdosx(&regs, &regs, &sregs);
      if(!regs.x.cflag) crite_ptr =MK_FP(sregs.ds,regs.x.si);
      }
    mypsp = getpsp();
    }
  }

int dbglvl = 0;
int doloop = 1;
int scrlen = 25;
char apref = 1;
char fpref = 6;
char *abortseq;
int   abortflg = -1;
int ansimode = 0;
int exitcode = 0;
int menuatconnect = 0;

long int accept_ipad = 0L;
long int accept_mask = 0L;

char *version = "V1.7";
char tempfile[128];
FILE *logfil;

#define MAXSYNTBL 18

struct SynTblEntry {
  char *key;
  char *syn; } stbl[MAXSYNTBL] = {
	 { "EXIT",  "dr"   },        //  0
	 { "MORE",  "sr"   },        //  1
	 { "SYSV",  "sr"   },        //  2
	 { "SYSM",  "sr"   },        //  3
	 { "SETL",  "dr"   },        //  4
	 { "ANSI",  "dr"   },        //  5
	 { "MOREL", "cssr" },        //  6
	 { "SYSVL", "cssr" },        //  7
	 { "SYSML", "cssr" },        //  8
	 { "ACCEP", "v"    },        //  9
	 { "WKDIR", "w"    },        // 10
	 { "LPRMT", "x"    },        // 11
	 { "RPRMT", "y"    },        // 12
	 { "FPRMT", "z"    },        // 13
	 { "SETE",  "dddr" },        // 14
	 { "SYSI",  "ssr"  },        // 15
	 { "SYSIL", "csssr"},        // 16
	 { "SHELL", "sr"   } };      // 17

#define MAXMENTBL 36

char  workdir[129] = "\0";
char *origdir      = NULL;
int   origdrv      = -1;

char refuse[50] = "Access denied";
char *onoff[2]  ={"OFF","ON"};
char rprmt[50]  = "Please enter selection, use '?' to show menu> ";
char fprmt[50]  = "Please select a file: ";
char lprmt0[6]  = { ' ',' ',' ','-',' ',':' };
char lprmt1[50] = "Enter <ESC> to shutdown RMENU> ";
char *lprmt     = lprmt1;
#define LPRMTDBGIDX1 4
#define LPRMTDBGIDX2 3

int nmenu = 0;
struct MenuTblEntry {
   int   ty;
   int   ls;
   char *str[5]; } mtbl[MAXMENTBL+1];

char mkeys[MAXMENTBL+1] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

char transtbl[49] = { 0307,0374,0351,0342,0344,0340,0345,0347,
		      0352,0353,0350,0357,0356,0354,0304,0305,
		      0311,0346,0306,0364,0366,0362,0373,0371,
		      0375,0326,0334,0242,0243,0245,0244,0244,
		      0341,0355,0363,0372,0361,0321,0252,0272,
		      0277,0254,0254,0275,0274,0241,0253,0273,0 };

#define TELNET_PORT 23

tcp_Socket s;
int  socket_open   = 0;
word socket_status = 0;
struct sockaddr sa;
int sal;
char sin[4] = " \r\n";
char iac    = 0;
char iac2   = 0;
char my_ip[16] = "\0";

void menu_file_error(int code, char *text) {
  switch(code) {
    case 0: printf("ERROR cannot open file: %s\n",text); break;
    case 1: printf("ERROR unknown keyword: %s in menu file\n",text); break;
    case 2: printf("ERROR not enough arguments for keyword: %s\n",text); break;
    case 3: printf("ERROR numeric argument expected for keyword: %s\n",text); break;
    case 4: printf("ERROR cannot allocate memory to store menu item\n"); break;
    case 5: printf("ERROR to many (more than 36) entries in menu file\n"); break;
    case 6: printf("ERROR bad IP-address/mask-length:\n"); break;
    case 7: printf("ERROR menu item %s requires DOS V3.0 or higer\n",text); break;
    }
  exit(1);
  }

void set_accept_ip(char *p) {
  char *q,*s;
  int i,j;
  q = p;
  while(*q > ' ') q++;
  if(*q) *q++ = '\0';
  s = strchr(p,'/');
  if(!s || !isdigit(s[1])) menu_file_error(6,s);
  else {
    *s++ = '\0';
    j = atoi(s) & 31;
   accept_ipad = inet_addr(p);
    if(j) {
      accept_mask = 0x80000000L;
      for(i = 1; i < j; i++) accept_mask /= 2;
      accept_ipad &= accept_mask;
      }
    }
  while(*q && (*q <= ' ')) q++;
  if(*q) {
    if(*q != '"') strncpy(refuse,q,49);
    else {
      s = ++q;
      while(*s && (*s != '"')) s++;
      if(*s == '"') *s = '\0';
      s--;
      while((s >= q) && (*s <= ' ')) *(s--) ='\0';
      strncpy(refuse,q,49);
      }
    }
  }

void scan_menu(char *line) {
  int i,j,k;
  char *p, *q;
  p = line;
  while(*p && (*p <= ' ')) p++;
  q = p;
  while(*p > ' ') { *p = toupper(*p); p++; }
  if(*p) *p++ = '\0';
  for(i = 0, k = -1; i < MAXSYNTBL; i++) if(!strcmp(stbl[i].key,q)) k = i;
  if(k < 0) menu_file_error(1,q);
  else if((k>=15)&&(k<=17)&&(indos_ptr==NULL)) menu_file_error(7,stbl[k].key);
  else {
    j = 0;
    mtbl[nmenu].ty = k;
    for(i = 0; i < 4; i++) mtbl[nmenu].str[i] = NULL;
    while(stbl[mtbl[nmenu].ty].syn[j]) {
      while(*p && (*p <= ' ')) p++;
      q = p;
      if(!*q) menu_file_error(2,stbl[mtbl[nmenu].ty].key);
      if(stbl[mtbl[nmenu].ty].syn[j] == 'v') { set_accept_ip(q); return; }
      if(stbl[mtbl[nmenu].ty].syn[j] == 'w') { strncpy(workdir,q,128); return; }
      if(stbl[mtbl[nmenu].ty].syn[j] == 'x') { strncpy(lprmt1,q,49); return; }
      if(stbl[mtbl[nmenu].ty].syn[j] == 'y') { strncpy(rprmt,q,49); return; }
      if(stbl[mtbl[nmenu].ty].syn[j] == 'z') { strncpy(fprmt,q,49); return; }
      if(nmenu >= MAXMENTBL) menu_file_error(5,"");
      if(stbl[mtbl[nmenu].ty].syn[j] == 'r') mtbl[nmenu].ls = j;
      else {
	if(*q == '"') {
	  q++; p++;
	  while(*p && (*p != '"')) p++;
	  if(*p=='"') *p = '\0';p++; }
	else {
	  while(*p > ' ') p++;
	  if(*p) *p++ = '\0'; } }
      if((stbl[mtbl[nmenu].ty].syn[j] == 'd') && !isdigit(*q))
			 menu_file_error(3,stbl[mtbl[nmenu].ty].key);
      if(stbl[mtbl[nmenu].ty].syn[j] == 'c') { *(++q) = '\0'; q--; }
      if((mtbl[nmenu].str[j] = (char *)malloc(strlen(q) + 1)) == NULL)
						   menu_file_error(4,"");
      else strcpy(mtbl[nmenu].str[j],q);
      j++;
      }
    nmenu++;
    }
  }

void read_menu_file(char *fnam) {
  int i;
  FILE *infil;
  char linbuf[128], *p;
  if((infil=fopen(fnam,"rt"))==NULL) menu_file_error(0,fnam);
  else {
    while(!feof(infil)) if(fgets(linbuf, sizeof(linbuf),infil)) {
      p = linbuf;
      while(*p) { if(*p == '\n') *p = '\0'; p++; }
      if(dbglvl&1) {
	p = linbuf;
	while(*p) {
	  if(*p < ' ' && *p >= '\0') fprintf(logfil,"<%02X>",(*p&0xFF));
	  else fprintf(logfil,"%c",*p);
	  p++; }
	fprintf(logfil,"\n"); }
      if(*linbuf) scan_menu(linbuf);
      }
    fclose(infil);
    } /* else */
  if(dbglvl&2) for(i = 0; i < nmenu; i++)
    fprintf(logfil,"%2c: \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\"\n",mkeys[i],stbl[mtbl[i].ty].key,
      mtbl[i].str[0],mtbl[i].str[1],mtbl[i].str[2],mtbl[i].str[3],mtbl[i].str[4]);
  }

void mini_status(char code) {
  static int i;
  static char w[5] = "-\|/";
  int x, y;
  x = wherex();
  y = wherey();
  i = (i+1) & 127;
  cprintf("\r%c%c%c%c",w[i>>5],code,socket_open?'+':'-',lprmt0[LPRMTDBGIDX2]);
  gotoxy(x,y);
  }

int wait_and_get(char lbl) {
  do {
    if(dbglvl&32) mini_status(lbl);
    if(!tcp_tick(&s)) return(-1);
    if(kbhit()) {
      if(getch() == 0x1B) {
	ungetch(0x1B);
	return(-1);
	}
      }
    } while(!sock_dataready(&s));
  return(sock_getc(&s));
  }

int at_virtual_root(char *mask) {
  char cwk[129], *rp, *wp;
  if(!*workdir || strchr(mask,'\\') || strchr(mask,':')) return(0);
  getcwd(cwk,128);
  rp = strchr(workdir,':');
  wp = strchr(cwk,':');
  if((rp != NULL) && (wp != NULL)) { rp = workdir; wp = cwk; }
  else {
    if(rp == NULL) rp = workdir; else rp++;
    if(wp == NULL) wp = cwk;     else wp++;
    }
  if(strnicmp(wp,rp,strlen(wp))) return(0);
  return(1);
  }

int dirlist(char *mask, char *name) {
  int ch,i,j,n;
  unsigned attr = 0xFFFF;
  char temp[35],*p,*w0,*w1,flag;
  struct ffblk fblk;
  flag='\0';
  if(mask[1]=='|') {
    flag = mask[0];
    mask += 2;
    if(flag=='f')                 attr = 0;
    else if(flag=='F')            attr = FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_ARCH;
    else if(toupper(flag)=='D')   attr = FA_DIREC;
    else if(toupper(flag)=='R') { attr = FA_DIREC;
				  if(at_virtual_root(mask)) flag = 'd'; }
    }
  while(sock_dataready(&s)) {tcp_tick(&s); sock_getc(&s);}
  i = findfirst(mask, &fblk, attr);
  sock_puts(&s,"  0: --- abort ---             ");
  for(n = 1; (n < MAXMENTBL) && !i; n++) {
    sprintf(temp,"  %c: %-13s%-10s   %s",mkeys[n],fblk.ff_name,
       ((fblk.ff_attrib & FA_DIREC ) ? "<DIR>" : ""),(n&1)?"\r\n":"");
    if((attr==FA_DIREC)&&(!(fblk.ff_attrib&FA_DIREC)
    ||(flag=='d')&&(!strcmp(fblk.ff_name,".")||!strcmp(fblk.ff_name,"..")))) n--;
    else sock_puts(&s,temp);
    i = findnext(&fblk);
    }
  if(n&1) sock_puts(&s,"\r\n");
  sock_puts(&s,fprmt);
  ch = wait_and_get('D');
  while(sock_dataready(&s)) {tcp_tick(&s); sock_getc(&s);}
  sprintf(temp,"%c\r\n",ch);
  sock_puts(&s,temp);
  p = strchr(mkeys,toupper(ch));
  if(!p || (*p=='0')) return(1);
  else
    if((j = p - mkeys) >= n) return(1);
    else {
    findfirst(mask, &fblk, attr);
    for(n = 1; n < j; n++) {
      if((attr==FA_DIREC)&&(!(fblk.ff_attrib&FA_DIREC)
      ||(flag=='d')&&(!strcmp(fblk.ff_name,".")||!strcmp(fblk.ff_name,"..")))) n--;
      findnext(&fblk);
      }
    strcpy(name,fblk.ff_name); }
  return(0);
  }

void subst(char *dest, char ch, char *src, char *name) {
  char *p, *q;
  if(!*src) strcpy(dest,name);
  else {
    p = src;
    q = dest;
    while(*p) {
      if(*p != ch) *q++ = *p++;
      else { strcpy(q,name); while(*q) q++; p++; } }
    *q = '\0';
    }
  }

void translate(char *s) {
  unsigned char *p;
  p = s;
  while(*p) {
    if(*p >=  128) {
      if(*p <= 175) *p = transtbl[(*p & 0xFF) - 128];
      else switch(*p & 0xFF) {
	case 0xF8: *p = 0xB0; break;  // ''
	case 0xF1: *p = 0xB1; break;  // ''
	case 0xFD: *p = 0xB2; break;  // ''
	case 0xE1: *p = 0xDF; break;  // ''
	case 0xF6: *p = 0xF7; break;  // ''
	default  : if((*p==0xB3)||(*p==0xBA)) *p = '|';
	      else if((*p==0xC4)||(*p==0xCD)) *p = '-';
	      else if((*p>=0xB4)&&(*p<=0xDA)) *p = '+';
	      else *p = 0xB7;
	}
      }
    p++;
    }
  }

unsigned char backtrans(unsigned char c) {
  unsigned char *p;
  if((p = strchr(transtbl,c)) != NULL) return(p - transtbl + 128);
  else if(c == 0xDF) return(0xE1);
  else return(c);
  }

void help_text(void) {
  printf("\n\n\n");
  printf("RMENU %s by Jrgen Hoffmann (2009) j_hoff@hrz1.hrz.tu-darmstadt.de\n\n",version);
  printf("RMENU [/h | /?] [/d<dblevel>] [/f<menufile>] [/t<tempfile>] [/a<ansi>] [/v]\n");
  printf("      [/m[S[!]]] [/s<scrlen>] [/e<a-key>] [/k<f-key>] [/r<delay>] [/c<count>]\n\n");
  printf("MENUFILE:                          (default: RMENU.MEN)\n\n");
  printf("  EXIT     n      Text             SHELL \"prompt\"  Text\n");
  printf("  MORE  filename  Text             MOREL char [a|]mask \"filename\" Text\n");
  printf("  SYSV  \"command\" Text             SYSVL char [a|]mask \"command\"  Text\n");
  printf("  SYSM  \"command\" Text             SYSML char [a|]mask \"command\"  Text\n");
  printf("  SYSI  \"command\" \"abort\" Text     SYSIL char [a|]mask \"command\" \"abort\" Text\n");
  printf("  ACCEP <ip>/<len> [ Text ]        WKDIR [<drive>:]path\n");
  printf("  SETL     n      Text             LPRMT Text\n");
  printf("  SETE   n n n    Text             RPRMT Text\n");
  printf("  ANSI     n      Text             FPRMT Text\n");
  }

void show_menu(void) {
  int i;
  char temp[128];
  for(i = 0; i < nmenu; i++) {
    sprintf(temp,"  %c:  %s\r\n",mkeys[i],mtbl[i].str[mtbl[i].ls]);
    if(ansimode) translate(temp);
    sock_puts(&s,temp);
    }
  }

void show_params(void) {
  char temp[128];
  sprintf(temp,"LINES=%d  ANSI=%s  ALT=",scrlen,onoff[(ansimode!=0)]);
  if(!apref) sprintf(&temp[strlen(temp)],"OFF");
  else sprintf(&temp[strlen(temp)],"^%c",(apref&0x1F)+0x40);
  sprintf(&temp[strlen(temp)],"  FKEY=");
  if(!fpref) sprintf(&temp[strlen(temp)],"OFF");
  else sprintf(&temp[strlen(temp)],"^%c",(fpref&0x1F)+0x40);
  sprintf(&temp[strlen(temp)],"\r\n");
  sock_puts(&s,temp);
  }

void show_accept(void) {
  char tmp1[18], tmp2[18];
  inet_ntoa(tmp1,accept_ipad);
  inet_ntoa(tmp2,accept_mask);
  printf("Restricted to address(es): %s / %s\n",tmp1,tmp2);
  if(fileno(stdout) != fileno(logfil))
    fprintf(logfil,"Restricted to address(es): %s / %s\n",tmp1,tmp2);
  }

typedef struct {
  unsigned char mode;
  unsigned int  columns;
  unsigned int  pagesize;
  unsigned int  pageoffset;
  unsigned int  rowcol[8];
  unsigned int  dummy;
  unsigned char pagenumber;
  unsigned int  ctraddress;
  } VIDEOINFO;

typedef struct {
  unsigned char c;
  unsigned char a;
  } SCRCHR;
typedef union {
  unsigned int w;
  SCRCHR       b;
  } SCRWRD;
typedef SCRWRD SCRLIN[80];
typedef SCRWRD SCRBUF[25][80];

SCRBUF    far *vbuff;
SCRBUF        *vcopy;
VIDEOINFO far *vinfo = MK_FP(0x0040,0x0049);


SCRBUF far *get_video_buffer(SCRBUF far *oldadr) {
  if((vinfo->columns==80)&&(vinfo->ctraddress==0x03B4)) return(MK_FP(0xB000,vinfo->pageoffset));
  if((vinfo->columns==80)&&(vinfo->ctraddress==0x03D4)) return(MK_FP(0xB800,vinfo->pageoffset));
  return(oldadr);
  }

void update_video(void) {
  int i,j,k,m,flg, maxi, maxj;
  unsigned char aa,a0,a1,c,line[130];
  vcall0++;
  vbuff=get_video_buffer(vbuff);
  flg = m = 0;
  maxi = (scrlen < 25) ? scrlen : 25;
  for(i = 0; i < maxi; i++) {
    vcall1++;
    if(_fmemcmp((*vbuff)[i],(*vcopy)[i],sizeof(SCRLIN))) {
      flg = 1;
      vcall2++;
      sprintf(line,"\033[%d;1H\033[K",i+1);
      k = strlen(line);
      maxj = (i < maxi-1) ? 80 : 79;
      for(a0 = j = m = 0; j < maxj; j++) {
	aa = (*vbuff)[i][j].b.a;
	if(m < 8) if(a0 != (a1 = (aa & 0x70))) {
	  if(a1==0x70) strcpy(&line[k],"\033[7m");
	  else         strcpy(&line[k],"\033[0m");
	  k  = strlen(line);
	  a0 = a1;
	  m++;
	  }
	c  = (*vbuff)[i][j].b.c;
	if(!aa || !c || (c > 254)) line[k++] = ' ';
	else if(c < ' ')           line[k++] = '';
	else                       line[k++] = c;
	}
      line[k] = '\0';
      for(; (k > 0) && (line[k] <= ' '); k--) line[k] = '\0';
      if(ansimode) translate(line);
      if(m) strcat(line,"\033[0m");
      if(sock_tbleft(&s) <= strlen(line)) vcall3++;
      else {
	sock_fastwrite(&s,line,strlen(line));
	tcp_tick(&s);
	_fmemcpy((*vcopy)[i],(*vbuff)[i],sizeof(SCRLIN));
	}
      }
    }
  if(vcall0 == 1) for(i = 25; i < scrlen; i++) {
    sprintf(line,"\033[%d;1H\033[K",i+1);
    sock_fastwrite(&s,line,strlen(line));
    tcp_tick(&s);
    }
  k = vinfo->rowcol[vinfo->pagenumber];
  if(flg || (k != curpos)) {
    sprintf(line,"\033[%d;%dH",((k >> 8) & 0xFF) +1,(k & 0xFF) +1);
    sock_fastwrite(&s,line,strlen(line));
    tcp_tick(&s);
    curpos = k;
    }
  }

void show_video(int mode) {
  int beg, end, i, j, k;
  unsigned char line[83];
  SCRBUF screen;
  gettext(1,1,80,25,screen);
  if(!mode) {
    for(beg=-1, i=0; i<24; i++)
      if((screen[i][0].w==243)&&(screen[i][1].w==224)&&(screen[i][2].w==242)) beg=i;
    beg++;
    for(end=25, i=beg; i<24 && end>24; i++)
      if((screen[i][0].w==243)&&(screen[i][1].w==234)&&(screen[i][2].w==242)) end=i;
    end--;
    }
  else {
    beg =  0;
    if(mode==1) end = wherey() -2;
    else end = 24;
    if(mode==3) sock_puts(&s,"\033[0;0H");
    }
  for(i=beg; i <= end; i++) {
    for(j = 0; j < 80; j++) {
      line[j] = screen[i][j].b.c;
      if(!screen[i][j].b.a)              line[j]=' ';
      if((line[j]==0) || (line[j]==255)) line[j]=' ';
      else if(line[j] < ' ')             line[j]='';
      }
    line[80] = '\0';
    for(k = 79; (k > 0) && (line[k] <= ' '); k--) line[k] = '\0';
    if(mode > 2) strcat(line,"\033[K");
    strcat(line,"\r\n");
    if(ansimode) translate(line);
    sock_fastwrite(&s,line,strlen(line));
    tcp_tick(&s);
    }
  }

void more(char *filnam) {
  int ch,i,b,abort;
  int lcount;
  long int curpos, maxpos, tmp;
  char tmpbuf[130], *p;
  FILE *infil;
  lcount = 0;
  curpos = maxpos = 0L;
  if((infil = fopen(filnam,"rt")) == NULL) {
    sprintf(tmpbuf,"ERROR: cannot open file: %s\r\n",filnam);
    sock_puts(&s, tmpbuf); }
  else {
    b = 1;
    ch = '\0';
    abort = 0;
    while(sock_dataready(&s)) {tcp_tick(&s); sock_getc(&s);}
    while(!feof(infil) && !abort) {
      for(i = b; (i < scrlen || toupper(ch) == 'E') && !feof(infil); i++) {
	if(fgets(tmpbuf,sizeof(tmpbuf), infil) != NULL) {
	  curpos = ftell(infil);
	  if(curpos > maxpos) { lcount++; maxpos = curpos; }
	  strcat(tmpbuf,"\r");
	  if(ansimode) translate(tmpbuf);
	  else for(p = tmpbuf; *p; p++) if(*p == -1) *p = ' ';
	  sock_puts(&s, tmpbuf);
	  tcp_tick(&s);
	  }
	} /* for */
      if(i >= scrlen || toupper(ch) == 'E') {
	sock_puts(&s, "--- more --- (<RET>=1line <SPC>=1page h=1/2page u=up b=begin e=end a=abort) ");
	ch = wait_and_get('M');
	if(ch < 0) ch = 'A';
	switch(toupper(ch)) {
	  case '\r': b = scrlen - 1;           break;
	  case 'A' : abort = 1;                break;
	  case 'U' : tmp = (maxpos / lcount) * 2 * (scrlen - 1);
		     if(tmp < curpos) {
		       fseek(infil,(curpos-tmp),0);
		       fgets(tmpbuf,sizeof(tmpbuf), infil);
		       b = 1;                  break;	}
	  case 'B' : b = 1; fseek(infil,0L,0); break;
	  case 'E' : if(curpos < maxpos) fseek(infil,maxpos,0);
		     while(!feof(infil)) {
		       if(fgets(tmpbuf,sizeof(tmpbuf), infil) != NULL) lcount++;
		       maxpos = ftell(infil); }
		     tmp = maxpos - ((maxpos / lcount) * 2 * (scrlen - 1));
		     if(tmp < 0L) tmp = 0L;
		     curpos = tmp;
		     fseek(infil,tmp,0);       break;
	  case 'H' : b = scrlen / 2;           break;
	  default  : b = 1;                    break;
	  } /* switch */
	sock_puts(&s,"\r                                      ");
	sock_puts(&s,"                                        \r");
	} /* if */
      } /* while */
    fclose(infil);
    } /* else */
  }

void more_l(int i) {
  char name[20];
  char temp[130];
  if(!dirlist(mtbl[i].str[1],name)) {
    subst(temp,*mtbl[i].str[0],mtbl[i].str[2],name);
    more(temp); }
  }

int get_textattr(void) {
  struct text_info r;
  gettextinfo(&r);
  return(r.attribute);
  }

unsigned char atable0[10] = { 0x81, 0x78, 0x79, 0x7A, 0x7B,         // 0..4
			      0x7C, 0x7D, 0x7E, 0x7F, 0x80};        // 5..9
unsigned char atable1[26] = { 0x1E, 0x30, 0x2E, 0x20, 0x12,         // A..E
			      0x21, 0x22, 0x23, 0x17, 0x24,         // F..J
			      0x25, 0x26, 0x32, 0x31, 0x18,         // K..O
			      0x19, 0x10, 0x13, 0x1F, 0x14,         // P..T
			      0x16, 0x2F, 0x11, 0x2D, 0x15, 0x2C }; // U..Z
unsigned char etable0[4]  = { 0x48, 0x50, 0x4D, 0x4B };
unsigned char etable1[4]  = { 0x49, 0x51, 0x4F, 0x47 };

void abort_child(void);

void bad_sequence(char pr, char ch, char c2, char c3) {
  if((pr != ch) || (c2 != 0)) PushChar(pr,0,0);
  if(c2 != 0) PushChar(c2,0,0);
  if(c3 != 0) PushChar(c3,0,0);
  PushChar(ch,0,0);
  }

void charservice(unsigned char c) {
  switch(charstate) {
    case  0: // basic state
	     if(fpref && (c==fpref))                 charstate = 1;
	     else if(apref && (c==apref))            charstate = 2;
	     else if(c==0x1B)                        charstate = 3;
	     else if(c==0x0D)  PushChar(0x0D,0x1C,0);                     // <CR>
	     else if(c==0x09)  PushChar(0x09,0x0F,0);                     // <TAB>
	     else if(c==0x08)  PushChar(0x08,0x0E,0);                     // <BS>
	     else if(c==0x0A) {if(lastchar!=0x0D) PushChar(0x0A,0x1C,0);} // <LF>
	     else if(ansimode) PushChar(backtrans(c),0,0);
	     else PushChar(c,0,0);
	     break;
    case  1: // FKEY prefix found
	     if(c==0x1B)                             charstate = 4;
	     else if(toupper(c)=='S')                charstate = 7;
	     else if(toupper(c)=='C')                charstate = 8;
	     else if(toupper(c)=='A')                charstate = 9;
	     else { if(c=='0') PushChar(0,0x44,0);
		    else if((c>='1')&&(c<='9')) PushChar(0,0x3A+(c&0x0F),0);
		    else if(toupper(c)=='R') memset(*vcopy,0,sizeof(SCRBUF));  // <redraw>
		    else if(toupper(c)==abortflg) abort_child();               // <kill>
		    else if(toupper(c)=='T') PushChar(0,0x0F,1);               // <SHIFT/TAB>
		    else if(toupper(c)=='I') PushChar(enhkbd,0x52,0);          // <INS>
		    else if(toupper(c)=='X') PushChar(enhkbd,0x53,0);          // <ERASE>
		    else if(toupper(c)=='U') PushChar(enhkbd,0x84,0x04);       // <CTRL/PgUp>
		    else if(toupper(c)=='D') PushChar(enhkbd,0x76,0x04);       // <CTRL/PdDn>
		    else if(toupper(c)=='H') PushChar(enhkbd,0x77,0x04);       // <CTRL/Home>
		    else if(toupper(c)=='E') PushChar(enhkbd,0x75,0x04);       // <CTRL/End>
		    else if(toupper(c)=='F') PushChar(enhkbd,0x74,0x04);       // <CTRL/-> > (forward)
		    else if(toupper(c)=='B') PushChar(enhkbd,0x73,0x04);       // <CTRL/<- > (back)
		    else bad_sequence(fpref,c,0,0);
						     charstate = 0;
		    }
	     break;
    case  2: // ALT prefix found
	     if((c>='0')&&(c<='9')) PushChar(0,atable0[c&0x0F],8);
	     else if(((c>='A')&&(c<='Z'))||((c>='a')&&(c<='z')))
			   PushChar(0,atable1[toupper(c)-0x41],8);
	     else {if(c!=apref) PushChar(apref,0,0); PushChar(c,0,0);}
						     charstate = 0;
	     break;
    case  3: // <esc> found
	     if((c=='O') || (c=='[')) { eschar = c;  charstate = 5; }
	     else { if(c == 0x1B) PushChar(0x1B,0x01,0);
		    else bad_sequence(0x1B,c,0,0);
						     charstate = 0; }
	     break;
    case  4: // FKEY<esc> found
	     if((c=='O') || (c=='[')) { eschar = c;  charstate = 6; }
	     else { bad_sequence(fpref,c,0x1B,0);    charstate = 0; }
	     break;
    case  5: // <esc>O or <esc>[ found
	     if((c>='A')&&(c<='D')) PushChar(enhkbd,etable0[c-0x41],0);
	     else if((c>='P')&&(c<='S')) PushChar(enhkbd,etable1[c-0x50],0);
	     else bad_sequence(0x1B,c,eschar,0);
						     charstate = 0;
	     break;
    case  6: // FKEY<esc>O or FKEY<esc>[ found
	     if((c>='A')&&(c<='D')) PushChar(enhkbd,etable1[c-0x41],0);
	     else bad_sequence(fpref,c,0x1B,eschar);
						     charstate = 0;
	     break;
    case  7: // FKEY S found
	     if(c=='0') PushChar(0,0x5D,1);
	     else if((c>='1')&&(c<='9')) PushChar(0,0x53+(c&0x0F),1);
	     else bad_sequence(fpref,c,'S',0);
						     charstate = 0;
	     break;
    case  8: // FKEY C found
	     if(c=='0') PushChar(0,0x67,4);
	     else if((c>='1')&&(c<='9')) PushChar(0,0x5D+(c&0x0F),4);
	     else bad_sequence(fpref,c,'C',0);
						     charstate = 0;
	     break;
    case  9: // FKEY A found
	     if(c=='0') PushChar(0,0x71,8);
	     else if((c>='1')&&(c<='9')) PushChar(0,0x67+(c&0x0F),8);
	     else bad_sequence(fpref,c,'A',0);
						     charstate = 0;
	     break;
    }
  lastchar = c;
  }

void abort_child(void) {
  char *p;
  if(!(abortflg & 0xFF00)) {
    charstate = 0;
    abortflg |= 512;
    for(p=abortseq; *p; p++)
      if(*p !='^') charservice(*p);
      else { p++;  charservice(*p & 0x1f); }
    }
  }

void lost_connection(void) {
  abort_child();
  if(reboot0 && !(reboot1--)) reboot();
  if(socket_open) {
    tcp_listen( &s, TELNET_PORT, 0, 0, NULL, 0 );
    sock_mode( &s, TCP_MODE_BINARY );
    socket_open = 0;
    recon0 = 1;
    }
  else if(tcp_established(&s)) {
    sal = sizeof(sa);
    getpeername(&s,&sa,&sal);
    if(lastclient== sa.s_ip) {
      recon0      = 2;
      reboot1     = reboot0;
      socket_open = 1;
      memset(*vcopy,0,sizeof(SCRBUF));
      }
    else {
      sock_close(&s);
      tcp_listen( &s, TELNET_PORT, 0, 0, NULL, 0 );
      sock_mode( &s, TCP_MODE_BINARY );
      recon1 = 1;
      }
    }
  tcp_tick(&s);
  }

void intrservice() {
  intsp = _SP;
  intss = _SS;
  _SP = FP_OFF(&tmpstack[TMPSTACKSIZE]);
  _SS = FP_SEG(&tmpstack[TMPSTACKSIZE]);
  intpsp = getpsp();
  setpsp(mypsp);
  enable();
  tcount3 = DEADLOCKTIMER;
  if(!socket_open||!tcp_tick(&s)) lost_connection();
  else {
    if(!--tcount1) {
      update_video();
      tcount1 = tcount0;
      }
    lastchar = 0;
    *kbdflg &= 0xFFF0;
    while(sock_dataready(&s)) charservice(sock_getc(&s));
    }
  disable();
  setpsp(intpsp);
  _SP = intsp;
  _SS = intss;
}

void report_error(void) {
  char buff[80], *p;
  struct devhdr far *dh;
  int i;
  if(criterr_ax == 0x00FF) strcpy(buff,"\rDEADLOCK");
    else {
    strcpy(buff,"\rA critical error ocurred ");
    p = &buff[strlen(buff)];
    if(!(criterr_ax&0x8000)) sprintf(p,"at drive: %c:",'A'+(criterr_ax&0x00FF));
    else {
      dh = MK_FP(criterr_bp,criterr_si);
      if(!(dh->dh_attr&0x8000)) strcat(buff,"in the FAT copy in memory");
      else {
	strcat(buff,"at device: ");
	p = &buff[strlen(buff)];
	for(i=0; i<8 && dh->dh_name[i] > ' '; i++) *p++ = dh->dh_name[i];
	*p = '\0';
	}
      }
    }
  strcat(buff," (operartion aborted)");
  if(dbglvl&4) fprintf(logfil,"%s\n",buff);
  strcat(buff,"     \r\n");
  sock_puts(&s,buff);
  }

void exec_sysi(int i, int cmd) {
  int n;
  char *p, name[20], temp[130];
  if(!cmd) p = mtbl[i].str[cmd];
  else {
    p = temp;
    if(dirlist(mtbl[i].str[1],name)) p = NULL;
    else subst(p,*mtbl[i].str[0],mtbl[i].str[cmd],name);
    }
  if(p==NULL) return;
  abortseq = mtbl[i].str[cmd+1];
  abortflg &= 255;
  tcount1 = tcount0 >> 1;
  if(!tcount1) tcount1 = 1;
  tcount2 = 4;
  tcount3 = DEADLOCKTIMER;
  criterr_ax = criterr_bp = criterr_si = 0;
  vcall0  = vcall1  = vcall2   = vcall3 = count28 = 0;
  hdbusy0 = hdbusy1 = hdcalled = hdreq  = 0;
  recon0  = recon1  = 0;
  reboot1 = reboot0;
  curpos  = -1;
  printf("\r");
  clreol();
  tmpstack=calloc(TMPSTACKSIZE+1,sizeof(unsigned int));
  vbuff=get_video_buffer(NULL);
  vcopy=calloc(1,sizeof(SCRBUF));
  if((tmpstack!=NULL) && (vcopy!=NULL) && (vbuff!=NULL)) {
    setvect(INTR28, myint28);
    setvect(TMINTR, myhandler);
    n = system(p);
    setvect(TMINTR, oldhandler);
    setvect(INTR28, oldint28);
    if(dbglvl&4) fprintf(logfil,"SYSI: %s --> %d:%d\n",p,n,errno);
    if(dbglvl&16) {
      for(n=0; (n < TMPSTACKSIZE) && (tmpstack[n] == 0); n++) ;
      fprintf(logfil,"MyPSP=%04X    MyStack=%04X:%04X..%04X   size=%-5d used=%d\n",
	     mypsp,FP_SEG(tmpstack),FP_OFF(tmpstack),
	     FP_OFF(&tmpstack[TMPSTACKSIZE]),TMPSTACKSIZE,TMPSTACKSIZE-n);
      fprintf(logfil,"InPSP=%04X    InStack=%04X:%04X	        call=%-6d i28=%-6d busy=%d\n",
	     intpsp,intss,intsp,hdcalled,count28,hdbusy0);
      fprintf(logfil,"Vbuff=%04X:%04X Vcopy=%04X:%04X (%04d)  call=%u/%u/%u/%u\n",FP_SEG(*vbuff),
	     FP_OFF(*vbuff),FP_SEG(*vcopy),FP_OFF(*vcopy),tcount3,vcall0,vcall1,vcall2,vcall3);
      fprintf(logfil,"\n"); }
    if(dbglvl&8) {
      if(recon0==1) fprintf(logfil,"Connection to client lost in SYSI mode\n");
      else if(recon0==2) fprintf(logfil,"Restored connection to client in SYSI mode\n");
      if(recon1) fprintf(logfil,"Denied connection to other client in SYSI mode\n");
      }
    free(vcopy);
    free(tmpstack);
    }
  if(socket_open) show_video(3);
  if(criterr_ax|criterr_bp|criterr_si) report_error();
  *kbdflg &= 0xFFF0;
  while(kbhit()) getch();
  lprmt0[LPRMTDBGIDX1] = '0';
  cprintf("\r%s",lprmt);
  }

int get_line(unsigned char *pr, unsigned char *ln, int maxln) {
  int abort, ch, j, lm, rm, lpr;
  abort = j = lm = 0;
  lpr = strlen(pr);
  rm = 80 - lpr;
  maxln--;
  while(rm < 1) { rm += 20; lm += 20; }
  sock_puts(&s,&pr[lm]);
  do {
    ch =wait_and_get('G');
    if(ch < 0) return(1);
    else {
      if((ch==127)||(ch==8)) { // <DEL> <BS>
	if(j > 0) {
	  ln[--j] = '\0';
	  sock_puts(&s,"\010 \010");
	  }
	else if(strlen(ln) > 0) {
	  j = strlen(ln);
	  lm = 0;
	  rm = 80 - lpr;
	  sock_puts(&s,ln);
	  }
	}
      else if((ch > ' ')||(j&&(ch==' '))) {
	if(j < maxln) {
	  if(ansimode) ln[j++] = backtrans(ch);
	  else         ln[j++] = ch;
	  ln[j] = '\0';
	  if(j < rm) sock_puts(&s,(char *)&ch);
	  else {
	    lm += 20;
	    rm += 20;
	    if(rm > 80) { lm -= (rm -80); rm = 80; }
	    sock_puts(&s,"\r\033[K");
	    if(lm < lpr) sock_puts(&s,&pr[lm]);
	    sock_puts(&s,ln);
	    }
	  }
	}
      else if(ch==3) {               // <CTRL/C>
	j = lm = 0;
	rm = 80 - lpr;
	ln[j] = '\0';
	sock_puts(&s,"\r\033[K");
	sock_puts(&s,&pr[lm]);
	}
      else if(ch==13) {              // <CR>
	ln[j] = '\0';
	sock_puts(&s,"\r\033[K");
	abort = 1;
	}
      }
    } while(!abort);
  while(sock_dataready(&s)) {tcp_tick(&s); sock_getc(&s);}
  j = strlen(ln);
  while((j > 0) && (ln[j]<=' ')) ln[j--] = '\0';
  cprintf("\r%-60s\r%s%s\r\n"," ",pr,ln);
  return(0);
  }

void remote_shell(int i) {
  char prompt[82], line[80], *p, *q;
  char empty[2] = "\003";
  int  loop, l, j;
  loop = 1;
  line[0] = '\0';
  do {
    strcpy(prompt,mtbl[i].str[0]);
    strncat(prompt,getcwd(NULL,80),78-strlen(prompt));
    strcat(prompt,"> ");
    if(get_line(prompt,line,79))      loop = 0;
    else if(!strnicmp(line,"EXIT",4)) loop = 0;
    else if(!strnicmp(line,"SET ",4)) {
      for(p=line; *p && (*p!='='); p++) *p = toupper(*p);
      for(p=&line[4]; *p && (*p<=' '); p++) { }
      if((q = (char *)malloc(strlen(p)+1)) != NULL) {
	strcpy(q,p);
	putenv(q);
	if(q[strlen(q)-1] == '=') {
	  for(l=j=0; environ[l]; l++) if(!strcmp(q,environ[l])) j = l;
	  environ[j] = environ[--l];
	  environ[l] = NULL;
	  }
	}
      }
    else {
      mtbl[MAXMENTBL].str[0] = line;
      mtbl[MAXMENTBL].str[1] = empty;
      if(line[0]) exec_sysi(MAXMENTBL, 0);
      }
    if(!socket_open) loop = 0;
    } while(loop);
  lprmt0[LPRMTDBGIDX1] = '1';
  cprintf("\r%s",lprmt);
  }

void exec_sysv(int i, int cmd) {
  int n;
  char *p;
  char name[20];
  char temp[130];
  int  txtattr;
  txtattr = get_textattr();
  if(!cmd) p = mtbl[i].str[cmd];
  else {
    p = temp;
    if(dirlist(mtbl[i].str[1],name)) p = NULL;
    else subst(p,*mtbl[i].str[0],mtbl[i].str[cmd],name);
    }
  if(p) {
    printf("\r"); clreol();
    cputs("\r"); textattr(0x00); cputs(""); textattr(txtattr); cputs("\r\n");
    n = system(p);
    cputs("\r"); textattr(0x00); cputs(""); textattr(txtattr); cputs("\r\n");
    if(dbglvl&4) fprintf(logfil,"SYSVL: %s --> %d:%d\n",p,n,errno);
    printf("\n");
    show_video(0);
    lprmt0[LPRMTDBGIDX1] = '2';
    cprintf("\r%s",lprmt); }
  }

void exec_sysm(int i, int cmd) {
  int n;
  char name[20];
  char temp[130];
  n = 1;
  if(!cmd) {
    if(*mtbl[i].str[cmd]) strcpy(temp,mtbl[i].str[cmd]);
    else n = 0;
    }
  else {
    if(dirlist(mtbl[i].str[1],name)) n = 0;
    else subst(temp,*mtbl[i].str[0],mtbl[i].str[cmd],name);
    }
  if(n) {
    strcat(temp," > ");
    strcat(temp,tempfile);
    n = system(temp);
    if(dbglvl&4) {
      fprintf(logfil,"\rSYSML: %s --> %d:%d\n",temp,n,errno);
      lprmt0[LPRMTDBGIDX1] = '3';
      cprintf("\r%s",lprmt);
      }
    more(tempfile); }
  }

void exec_menu(char ch) {
  int i;
  char *p;
  p = strchr(mkeys,ch);
  if(p) {
    i = p - mkeys;
    if(i < nmenu) {
      lprmt0[LPRMTDBGIDX2] = ch;
      switch(mtbl[i].ty) {
	case  0: exitcode = atoi(mtbl[i].str[0]); doloop = 0; break;
	case  1: more(mtbl[i].str[0]); break;
	case  2: exec_sysv(i,0);       break;
	case  3: exec_sysm(i,0);       break;
	case  4: if(atoi(mtbl[i].str[0]))
		   scrlen = atoi(mtbl[i].str[0]);
		 show_params();        break;
	case  5: ansimode = atoi(mtbl[i].str[0]);
		 show_params();        break;
	case  6: more_l(i);            break;
	case  7: exec_sysv(i,2);       break;
	case  8: exec_sysm(i,2);       break;
	case 14: if(atoi(mtbl[i].str[0]))
		   ansimode = atoi(mtbl[i].str[0]);
		 if(!atoi(mtbl[i].str[1])
		 || (atoi(mtbl[i].str[1])!=atoi(mtbl[i].str[2]))) {
		   apref = atoi(mtbl[i].str[1]) & 0x1F;
		   fpref = atoi(mtbl[i].str[2]) & 0x1F;
		   }
		 show_params();        break;
	case 15: exec_sysi(i,0);       break;
	case 16: exec_sysi(i,2);       break;
	case 17: remote_shell(i);      break;
	}
      lprmt0[LPRMTDBGIDX2] = '-';
      }
    }
  }

void process_iac(char ch) {
  switch(iac) {
    case 2: iac2 = ch; break;
    case 1: if(dbglvl&16) {
	      if(wherex() > 65) fprintf(logfil,"\n");
	      fprintf(logfil,"<FF><%02X><%02X> ",(iac2&0xFF),(ch&0xFF)); } break;
    }
  if(iac) iac--;
  }

extern unsigned _heaplen = 8192;

void main(int argc, char *argv[])
{
int i;
char *p, filename[128];

  doloop = 1;
  strcpy(filename,argv[0]);
  strcpy(tempfile,filename);
  p = strrchr(filename,'.');
  if(p) {
    *p = '\0';
    strcat(filename,".men"); }
  p = strrchr(tempfile,'.');
  if(p) {
    *p = '\0';
    strcat(tempfile,".tmp"); }
  for(i = 1; i < argc; i++) if(*argv[i]=='-' || *argv[i]=='/') {
    p = argv[i];
    switch(toupper(p[1])) {
      case 'A': ansimode = atoi(&p[2]);     break;
      case 'C': tcount0 = atoi(&p[2]);      break;
      case 'D': dbglvl = atoi(&p[2]);       break;
      case 'E': apref = atoi(&p[2])&0x1F;   break;
      case 'F': strcpy(filename,&p[2]);     break;
      case 'K': fpref = atoi(&p[2]);        break;
      case 'M': menuatconnect = 1;
		if(p[2]&&strchr(mkeys,toupper(p[2]))) {
		  menuatconnect = toupper(p[2]);
		  if(p[3] == '!') menuatconnect |= 512;
		  }     	            break;
      case 'R': reboot0 = atoi(&p[2]) * 3;  break;
      case 'S': scrlen = atoi(&p[2])&0x1F;  break;
      case 'T': strcpy(tempfile,&p[2]);     break;
      case 'V': abortflg = 'K';             break;
      case 'H':
      case '?': help_text(); exit(0);
      } /* switch */
    } /* for */
  if(!tcount0) tcount0 = 1;
  if(!scrlen)  scrlen  = 25;
  if(*kbdflg2 & 0x0010) enhkbd = 0xE0;
  if(apref && (apref==fpref)) { apref=1; fpref=6; }

  if(stdout->flags&_F_TERM) logfil=fdopen(fileno(stdout),"w");
  else {
    logfil=fopen(tempfile,"w");
    dos_c_dup(fileno(stdout),fileno(logfil));
    freopen("CON","w",stdout);
    }

  get_dos_pointers();
  if(dbglvl&32) lprmt = lprmt0;
  read_menu_file(filename);
  if(menuatconnect > ' ')
    if((strchr(mkeys,menuatconnect&0x00FF)-mkeys)>=nmenu) menuatconnect = 1;

  if(workdir[0]) {
    origdir = getcwd(NULL,129);
    origdrv = getdisk();
    chdir(workdir);
    if(workdir[1]==':') setdisk(toupper(workdir[0])-'A');
    }
  oldhandler = getvect(TMINTR);
  oldint28   = getvect(INTR28);
  sock_init();
  tcp_set_debug_state((dbglvl>>6)&3);
  inet_ntoa(my_ip,gethostid());
  printf("RMENU %s listening as %s on port %d\n",version,my_ip,TELNET_PORT);
  if(fileno(stdout) != fileno(logfil))
    fprintf(logfil,"RMENU %s listening as %s on port %d\n",version,my_ip,TELNET_PORT);
  if(accept_ipad != 0L) show_accept();
  tcp_listen( &s, TELNET_PORT, 0, 0, NULL, 0 );
  sock_mode( &s, TCP_MODE_BINARY );
  lprmt0[LPRMTDBGIDX1] = '4';
  cprintf("\r%s",lprmt);

  while(doloop) {
    if(dbglvl&32) mini_status('L');
    if(kbhit()) if(getch() == 27) doloop = 0;
    tcp_tick(&s);
    if(socket_open) {
      if(!tcp_tick(&s)) {
	if(dbglvl&8) {
	  fprintf(logfil,"\rClosing TELNET connection by remote end\n");
	  lprmt0[LPRMTDBGIDX1] = '5';
	  cprintf("\r%s",lprmt);
	  }
	tcp_listen( &s, TELNET_PORT, 0, 0, NULL, 0 );
	sock_mode( &s, TCP_MODE_BINARY );
	socket_open = 0; } /* !tcp_tick - socket now closed */
      else {
	while(sock_dataready(&s)) {
	  sin[0] = (char) sock_getc(&s);
	  if(menuatconnect > ' ') sin[0] = menuatconnect & 0x00FF;
	  if(sin[0] == -1) iac = 2;
	  else if(iac) process_iac(sin[0]);
	  else if(sin[0] > ' ') {
	    sock_puts(&s,sin);
	    if(sin[0] ==  '?') show_menu();
	    else exec_menu(toupper(sin[0]));
	    if(socket_open) sock_puts(&s,rprmt); }
	  }
	} /* else - socket still open */
      } /* socket_open */
    else {
      if(tcp_established(&s)) {
	sal = sizeof(sa);
	getpeername(&s,&sa,&sal );
	if((sa.s_ip & accept_mask) == accept_ipad) {
	  lastclient = sa.s_ip;
	  if(dbglvl&8) {
	    fprintf(logfil,"\rOpening TELNET connection by: %s\n",
				      inet_ntoa(filename,lastclient));
	    lprmt0[LPRMTDBGIDX1] = '6';
	    cprintf("\r%s",lprmt);
	    }
	  socket_open = 1;
	  if(menuatconnect < ' ') {
	    if(menuatconnect) show_menu();
	    else { show_video(1); lprmt0[LPRMTDBGIDX1] = '7'; cprintf("\r%s",lprmt); }
	    sock_puts(&s,rprmt);
	    }
	  else {
	    exec_menu(menuatconnect&0x00FF);
	    if(menuatconnect < 256) sock_puts(&s,rprmt);
            else sock_close(&s);
	    }
	  }
	else {
	  if(dbglvl&8) {
	    fprintf(logfil,"\rRefusing connection to: %s\n",
				 inet_ntoa(filename,sa.s_ip));
	    lprmt0[LPRMTDBGIDX1] = '8';
	    cprintf("\r%s",lprmt);
	    }
	  if(*refuse) {
	    sock_puts(&s,refuse);
	    sock_puts(&s,"\r\n");
	    }
	  sock_close(&s);
	  _ip_delay2(&s, sock_delay, NULL, (int *)&socket_status);
//	  _ip_delay2(&s, sock_delay, NULL, &socket_status);
	  tcp_listen( &s, TELNET_PORT, 0, 0, NULL, 0 );
	  sock_mode( &s, TCP_MODE_BINARY );
	  socket_open = 0;
	  }
	} /* tcp_established */
      } /* else - socket_not_open */
   } /* while */
   printf("\rTerminating ...");
   clreol();
   printf("\r");

  if(socket_open) {
    sock_puts(&s,"\r\n*** server shut down ***\r\n");
    if(dbglvl&8) fprintf(logfil,"\rClosing TELNET connection localy\n");
    sock_close(&s);
    _ip_delay2(&s, sock_delay, NULL, (int *)&socket_status);
//  _ip_delay2(&s, sock_delay, NULL, &socket_status);
    socket_open = 0;
    }
  if(workdir[0]) {
    setdisk(origdrv);
    chdir(origdir);
    }
  if(dbglvl&16) fprintf(logfil,"\rExiting with code: %d\n",exitcode);
  exit(exitcode);

sock_err:
    if(dbglvl&8) switch (socket_status) {
      case  1: fprintf(logfil,"Socked error: closed\n");  break;
      case -1: fprintf(logfil,"Socket error: timeout\n"); break;
      default: fprintf(logfil,"Socket error: unknown code: %d\n",socket_status); break; }
    exit(1);

}