;
;	CTu[`
;	for DOS/V
;	1996/8/8
;	coder .. takapyu
;
	dosseg
	.model	compact,c

GRAPH_SEG	equ	0a000h

G_PSET		equ	0
G_RESET		equ	1
G_OR		equ	2
G_XOR		equ	3
G_AND		equ	4

movseg	macro	seg1,seg2
	push	seg2
	pop	seg1
	endm

	.data
add1		dw	?
add2		dw	?
write_mode	dw	?
line_style	dw	?

	extrn	start_x:word
	extrn	start_y:word
	extrn	end_x:word
	extrn	end_y:word
	extrn	box_wide:word
	extrn	box_high:word
	extrn	color_work:word

	.code

	extrn	gadr_set:near
	extrn	dot_data:byte
	extrn	start_data:byte
	extrn	end_data:byte

;
;	C
;	void line(int sx , int sy , int ex , int ey , int color , int style);
;
	public	line
line	proc	uses	ds es si di,sx:word,sy:word,ex:word,ey:word,color:word,style:word
	mov	dx,03ceh
	mov	ax,0a05h
	out	dx,ax
	mov	ax,0003h
	out	dx,ax
	mov	ax,0007h
	out	dx,ax

	mov	ax,_DATA
	mov	ds,ax
	mov	ax,GRAPH_SEG
	mov	es,ax

	mov	ax,[color]
	mov	ds:[color_work],ax

	mov	dx,[sx]
	mov	cx,[ex]

	mov	bx,[sy]
	mov	ax,[ey]
	cmp	bx,ax
	jc	line_10
	xchg	ax,bx
	xchg	cx,dx
line_10:
	mov	ds:[start_y],bx
	mov	ds:[end_y],ax

	mov	ds:[start_x],dx
	mov	ds:[end_x],cx

	sub	ax,bx
	mov	ds:[box_high],ax
	jnz	line_20
;
;	C
;
	cmp	cx,dx
	jnc	line_15
	xchg	cx,dx
line_15:
	sub	cx,dx
	mov	ds:[box_wide],cx

	mov	ax,ds:[end_x]
	cmp	ax,ds:[start_x]
	jnc	line_17
	xchg	ax,ds:[start_x]
	mov	ds:[end_x],ax
line_17:
	mov	bx,4
	jmp	short	line_50
;
line_20:
	xor	bx,bx
	cmp	cx,dx
	jnc	line_30
	xchg	cx,dx
	inc	bx
line_30:
	sub	cx,dx
	mov	ds:[box_wide],cx
	jnz	line_40
;
;	C
;
	mov	bx,5
	jmp	short	line_50
;
line_40:
	cmp	ax,cx
	jc	line_50
	or	bx,00000010b
line_50:
	shl	bx,1

	mov	ax,[style]
	cmp	ax,0ffffh
	jnz	line_60
; normal line
	call	cs:line_table[bx]
	jmp	short line_ret
line_60:
; dot line
	mov	ds:[line_style],ax
	call	cs:dline_table[bx]
line_ret:
	ret
line	endp

;
;	CWve[u
;
line_table	dw	line_xp
		dw	line_xm
		dw	line_yp
		dw	line_ym
		dw	hline
		dw	vline

dline_table	dw	line_xpd
		dw	line_xmd
		dw	line_ypd
		dw	line_ymd
		dw	line_xpd
		dw	line_ypd

;
;	Cp^[P
;	--__
;           --__
;
line_xp	proc	near
	mov	ax,ds:[box_high]
	mov	cx,ds:[box_wide]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (high - wide)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * high

	sub	bx,cx			; e = (2 * high) - wide
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	inc	cx
xp_loop:
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	or	si,si			; if(e > 0) {
	jle	xp_20			;
					;
	add	di,80			;   y++
	add	si,ds:[add1]		;   e += 2 * (high - wide)
	jmp	short xp_30		;
xp_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * high
xp_30:					; }
	inc	bx			; x++
	and	bx,00000111b
	jnz	xp_50
	inc	di
xp_50:
	loop	xp_loop

	ret
line_xp	endp

;
;	Cp^[Q
;           __--
;	__--
;
line_xm	proc	near
	mov	ax,ds:[box_high]
	mov	cx,ds:[box_wide]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (high - wide)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * high

	sub	bx,cx			; e = (2 * high) - wide
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	inc	cx
xm_loop:
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	or	si,si			; if(e > 0) {
	jle	xm_20			;
					;
	add	di,80			;   y++
	add	si,ds:[add1]		;   e += 2 * (high - wide)
	jmp	short	xm_30		;
xm_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * high
xm_30:					; }
	dec	bx			; x--
	and	bx,00000111b		;
	cmp	bx,00000111b		;
	jnz	xm_50			;
	dec	di			;
xm_50:
	loop	xm_loop

	ret
line_xm	endp

;
;	Cp^[R
;           |
;	     |
;             |
;
line_yp	proc	near
	mov	ax,ds:[box_wide]
	mov	cx,ds:[box_high]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (wide - high)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * wide

	sub	bx,cx			; e = (2 * wide) - high
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	inc	cx
yp_loop:
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	or	si,si			; if(e > 0) {
	jle	yp_20			;
					;
	inc	bx			; x++
	and	bx,00000111b		;
	jnz	yp_10			;
	inc	di			;
yp_10:					;
	add	si,ds:[add1]		;   e += 2 * (wide - high)
	jmp	short	yp_30		;
yp_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * wide
yp_30:					; }
	add	di,80			; y++
	loop	yp_loop

	ret
line_yp	endp

;
;	Cp^[S
;             |
;	     |
;           |
;
line_ym	proc	near
	mov	ax,ds:[box_wide]
	mov	cx,ds:[box_high]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (wide - high)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * wide

	sub	bx,cx			; e = (2 * wide) - high
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	inc	cx
ym_loop:
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	or	si,si			; if(e > 0) {
	jle	ym_20			;
					;
	dec	bx			;   x--
	and	bx,00000111b		;
	cmp	bx,00000111b		;
	jnz	ym_10			;
	dec	di			;
ym_10:					;
	add	si,ds:[add1]		;   e += 2 * (wide - high)
	jmp	short	ym_30		;
ym_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * wide
ym_30:					; }
	add	di,80			; y++
	loop	ym_loop

	ret
line_ym	endp

;
;	C
;         |
;         |
;         |
;
vline	proc
	mov	cx,ds:[box_high]

	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax
	and	bx,00000111b
	mov	ah,cs:dot_data[bx]
	mov	dx,03ceh
	inc	cx
vl_loop:
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	add	di,80
	loop	vl_loop
vl_20:
	ret
vline	endp

;
;	C
;         ------
;
hline	proc
	mov	cx,ds:[end_x]
	mov	dx,ds:[start_x]
	cmp	cx,dx
	jnc	hl_00
	xchg	cx,dx
hl_00:
	mov	si,cx
	sub	si,dx		; si = wide

	mov	ax,dx		; ax = start x
	mov	bx,ds:[start_y]
	call	gadr_set	; start_x , start_y
	mov	di,ax		; ax .. gadr , bx .. dot

	mov	ax,cx		; ax = end x
	mov	ds:[end_x],ax
	mov	cl,3
	shr	ax,cl
	shr	dx,cl		; dx = start x
	sub	ax,dx
	jnz	hl_10

	mov	dx,03ceh
	mov	ah,cs:dot_data[bx]
	mov	cx,si
	inc	cx
hl_loop1:
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	shr	ah,1
	loop	hl_loop1
	jmp	short hl_ret

hl_10:
	mov	cx,ax

	mov	dx,03ceh
	mov	ah,cs:start_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

	inc	di

	dec	cx
	jz	hl_30

	mov	ax,0ff08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
hl_loop2:
	and	byte ptr es:[di],al

	inc	di
	loop	hl_loop2
hl_30:
	mov	bx,ds:[end_x]
	and	bx,00000111b
	mov	ah,cs:end_data[bx]
	mov	al,08h
	out	dx,ax

	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al

hl_ret:
	ret
hline	endp


;
;	Cp^[P
;	--__
;           --__
;
line_xpd	proc	near
	mov	ax,ds:[box_high]
	mov	cx,ds:[box_wide]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (high - wide)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * high

	sub	bx,cx			; e = (2 * high) - wide
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	mov	ax,ds:[line_style]
	inc	cx
xpd_loop:
	ror	ax,1
	jnc	xpd_07

	push	ax
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al
	pop	ax
xpd_07:
	or	si,si			; if(e > 0) {
	jle	xpd_20			;
					;
	add	di,80			;   y++
	add	si,ds:[add1]		;   e += 2 * (high - wide)
	jmp	short xpd_30		;
xpd_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * high
xpd_30:					; }
	inc	bx			; x++
	and	bx,00000111b
	jnz	xpd_50
	inc	di
xpd_50:
	loop	xpd_loop

	ret
line_xpd	endp

;
;	Cp^[Q
;           __--
;	__--
;
line_xmd	proc	near
	mov	ax,ds:[box_high]
	mov	cx,ds:[box_wide]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (high - wide)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * high

	sub	bx,cx			; e = (2 * high) - wide
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	mov	ax,ds:[line_style]
	inc	cx
xmd_loop:
	ror	ax,1
	jnc	xmd_07

	push	ax
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al
	pop	ax
xmd_07:
	or	si,si			; if(e > 0) {
	jle	xmd_20			;
					;
	add	di,80			;   y++
	add	si,ds:[add1]		;   e += 2 * (high - wide)
	jmp	short	xmd_30		;
xmd_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * high
xmd_30:					; }
	dec	bx			; x--
	and	bx,00000111b		;
	cmp	bx,00000111b		;
	jnz	xmd_50			;
	dec	di			;
xmd_50:
	loop	xmd_loop

	ret
line_xmd	endp

;
;	Cp^[R
;           |
;	     |
;             |
;
line_ypd	proc	near
	mov	ax,ds:[box_wide]
	mov	cx,ds:[box_high]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (wide - high)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * wide

	sub	bx,cx			; e = (2 * wide) - high
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	mov	ax,ds:[line_style]
	inc	cx
ypd_loop:
	ror	ax,1
	jnc	ypd_07

	push	ax
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al
	pop	ax
ypd_07:
	or	si,si			; if(e > 0) {
	jle	ypd_20			;
					;
	inc	bx			; x++
	and	bx,00000111b		;
	jnz	ypd_10			;
	inc	di			;
ypd_10:					;
	add	si,ds:[add1]		;   e += 2 * (wide - high)
	jmp	short	ypd_30		;
ypd_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * wide
ypd_30:					; }
	add	di,80			; y++
	loop	ypd_loop

	ret
line_ypd	endp

;
;	Cp^[S
;             |
;	     |
;           |
;
line_ymd	proc	near
	mov	ax,ds:[box_wide]
	mov	cx,ds:[box_high]
	mov	bx,ax
	sub	ax,cx
	shl	ax,1
	mov	ds:[add1],ax		; add1 = 2 * (wide - high)

	shl	bx,1
	mov	ds:[add2],bx		; add2 = 2 * wide

	sub	bx,cx			; e = (2 * wide) - high
	mov	si,bx			; si .. e

	mov	dx,03ceh
	mov	ax,ds:[start_x]
	mov	bx,ds:[start_y]
	call	gadr_set
	mov	di,ax			; di = graph_address
	mov	ax,ds:[line_style]
	inc	cx
ymd_loop:
	ror	ax,1
	jnc	ymd_07

	push	ax
	mov	ah,cs:dot_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,byte ptr ds:[color_work]
	and	byte ptr es:[di],al
	pop	ax
ymd_07:
	or	si,si			; if(e > 0) {
	jle	ymd_20			;
					;
	dec	bx			;   x--
	and	bx,00000111b		;
	cmp	bx,00000111b		;
	jnz	ymd_10			;
	dec	di			;
ymd_10:					;
	add	si,ds:[add1]		;   e += 2 * (wide - high)
	jmp	short	ymd_30		;
ymd_20:					; } else {
	add	si,ds:[add2]		;   e += 2 * wide
ymd_30:					; }
	add	di,80			; y++
	loop	ymd_loop

	ret
line_ymd	endp


	end
