;
;	OtBbN֌WTu[`
;	for DOS/V
;	1996/8/8
;	coder .. takapyu
;
	dosseg
	.model	compact,c
;.stack

GRAPH_SEG	equ	0a000h

F_90	equ	0001h
F_180	equ	0002h
F_270	equ	0003h
F_ROT	equ	0003h
F_FOUR	equ	000ch
F_WIDE	equ	0004h
F_HIGH	equ	0008h
F_BOLD	equ	0010h
F_REV	equ	0020h

F_24	equ	0080h

pushr	macro	list
		irp	reg,<list>
			push	reg
		endm
	endm

popr	macro	list
		irp	reg,<list>
			pop	reg
		endm
	endm

movseg	macro	seg1,seg2
	push	seg2
	pop	seg1
	endm

	.data

	public	start_x
	public	start_y
	public	end_x
	public	end_y
	public	box_wide
	public	box_high
	public	color_work

start_x		dw	?
start_y		dw	?
end_x		dw	?
end_y		dw	?
box_wide	dw	?
box_high	dw	?
cursor_x	dw	?
cursor_y	dw	?
font_pattern	dw	0

sbcs_call	dd	?
sbcs24_call	dd	?
dbcs_call	dd	?
dbcs24_call	dd	?

color_work	db	?
for_color	db	15
back_color	db	0
vmode		db	?

pattern_data	db	8 dup (?)

kanji_buffer	db	128 dup (?)
disp_buffer	db	128 dup (?)

	.code
	public	dot_data
	public	start_data
	public	end_data

start_data	db	11111111b
		db	01111111b
		db	00111111b
		db	00011111b
		db	00001111b
		db	00000111b
		db	00000011b
		db	00000001b

dot_data	db	10000000b
		db	01000000b
		db	00100000b
		db	00010000b
		db	00001000b
		db	00000100b
		db	00000010b
		db	00000001b

end_data	db	10000000b
		db	11000000b
		db	11100000b
		db	11110000b
		db	11111000b
		db	11111100b
		db	11111110b
		db	11111111b

start_rdata	db	00000000b
		db	10000000b
		db	11000000b
		db	11100000b
		db	11110000b
		db	11111000b
		db	11111100b
		db	11111110b

dot_rdata	db	01111111b
		db	10111111b
		db	11011111b
		db	11101111b
		db	11110111b
		db	11111011b
		db	11111101b
		db	11111110b

end_rdata	db	01111111b
		db	00111111b
		db	00011111b
		db	00001111b
		db	00000111b
		db	00000011b
		db	00000001b
		db	00000000b

;
;	hԂ
;	void box_fill(int sx , int sy , int ex , int ey , int color , int pattern);
;	sx , sy  .. ̍W
;	ex , ey  .. E̍W
;	color    .. pbgR[h
;
	public	box_fill
box_fill	proc	uses ds es si di,sx:word,sy:word,ex:word,ey:word,color:word,pattern:word
	mov	dx,03ceh
	mov	ax,0005h
	out	dx,ax
	mov	ax,0f01h
	out	dx,ax
	mov	al,00h
	mov	ah,BYTE PTR [color]
	out	dx,ax
	mov	al,03h
	mov	ah,BYTE PTR [pattern]
	out	dx,ax

	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[sx]

	xor	di,di
	or	ax,ax
	jns	fill_01
	xor	ax,ax
	inc	di
fill_01:
	mov	bx,[ex]

	or	bx,bx
	jns	fill_02
	xor	bx,bx
	inc	di
fill_02:
	cmp	di,2
	jz	fill_ret1

	cmp	bx,ax
	jnc	fill_10
	xchg	ax,bx
fill_10:
	xor	di,di
	cmp	ax,640
	jc	fill_11
	mov	ax,639
	inc	di
fill_11:
	mov	ds:[start_x],ax

	cmp	bx,640
	jc	fill_12
	mov	bx,639
	inc	di
fill_12:
	mov	ds:[end_x],bx

	cmp	di,2
	jnz	fill_14
fill_ret1:
	ret
fill_14:
	sub	bx,ax
	mov	ds:[box_wide],bx

	xor	di,di
	mov	bx,[sy]
	or	bx,bx
	jns	fill_15
	xor	bx,bx
	inc	di
fill_15:
	mov	cx,[ey]
	or	cx,cx
	jns	fill_16
	xor	cx,cx
	inc	di
fill_16:
	cmp	di,2
	jz	fill_ret

	cmp	cx,bx
	jnc	fill_20
	xchg	bx,cx
fill_20:
	xor	di,di
	cmp	bx,479
	jc	fill_21
	mov	bx,479
	inc	di
fill_21:
	mov	ds:[start_y],bx

	cmp	cx,479
	jc	fill_22
	mov	cx,479
	inc	di
fill_22:
	mov	ds:[end_y],cx

	cmp	di,2
	jz	fill_ret

	sub	cx,bx
	mov	ds:[box_high],cx

	call	gadr_set	; start_x , start_y

	mov	di,ax		; ax .. gadr , bx .. dot
	mov	ax,GRAPH_SEG
	mov	es,ax

	call	fill_set

fill_ret:
	ret
box_fill	endp


;
;	BOX FILL PSET
;
fill_set	proc	near
	mov	ax,ds:[end_x]
	mov	cl,3
	shr	ax,cl
	mov	dx,ds:[start_x]
	shr	dx,cl
	mov	cx,ax
	sub	cx,dx
	jnz	fill_s50
;
	mov	dl,cs:dot_data[bx]	; dl = start dot pattern

	mov	bx,ds:[start_y]
	and	bx,00000111b
	add	bx,offset DGROUP:pattern_data

	mov	cx,ds:[box_high]
	inc	cx
fill_sloop0:
	push	cx
	push	di

	mov	ah,dl			; start dot pattern set
	push	dx

	mov	dx,03ceh

	mov	cx,ds:[box_wide]
	inc	cx
fill_sloop1:
	push	ax
	mov	al,08h
	out	dx,ax
	or	BYTE PTR es:[di],ah
	pop	ax

	shr	ah,1
	loop	fill_sloop1

	pop	dx
	pop	di

	add	di,80			; 1 line down
	inc	bx
	cmp	bx,offset DGROUP:pattern_data+8
	jc	fill_s20
	mov	bx,offset DGROUP:pattern_data
fill_s20:
	pop	cx
	loop	fill_sloop0
	jmp	fill_sret
;
;
fill_s50:
	mov	si,cx			; si = wide loop count
	mov	dl,cs:start_data[bx]	; dl = start bit pattern
	mov	bx,ds:[end_x]
	and	bx,00000111b
	mov	dh,cs:end_data[bx]	; dh = end bit pattern

	mov	bx,ds:[start_y]
	and	bx,00000111b
	add	bx,offset DGROUP:pattern_data

	mov	cx,ds:[box_high]	; cx = high loop count
	inc	cx
fill_sloop2:
	push	cx
	push	di

	mov	ah,dl
	push	dx
	mov	dx,03ceh
	mov	al,08h
	out	dx,ax
	pop	dx
	mov	al,BYTE PTR ds:[bx]
	or	BYTE PTR es:[di],al

	inc	di

	mov	cx,si			; wide loop count set
	dec	cx
	jz	fill_s60
fill_sloop3:
	push	dx
	mov	dx,03ceh
	mov	ax,0ff08h
	out	dx,ax
	pop	dx
	mov	al,BYTE PTR ds:[bx]
	or	BYTE PTR es:[di],al
	inc	di
	loop	fill_sloop3
fill_s60:
	mov	ah,dh
	push	dx
	mov	dx,03ceh
	mov	al,08h
	out	dx,ax
	pop	dx
	mov	al,BYTE PTR ds:[bx]
	or	BYTE PTR es:[di],al

	pop	di

	add	di,80		; 1 line down
	inc	bx
	cmp	bx,offset DGROUP:pattern_data+8
	jc	fill_s80
	mov	bx,offset DGROUP:pattern_data
fill_s80:
	pop	cx
	loop	fill_sloop2

fill_sret:
	ret
fill_set	endp

;
;	\
;	void box(int sx , int sy , int ex , int ey , int color);
;	sx , sy  .. ̍W
;	ex , ey  .. E̍W
;	color    .. pbgR[h
;
	public	box
box	proc	uses ds es si di,sx:word,sy:word,ex:word,ey:word,color:word
	mov	dx,03ceh
	mov	ax,0a05h
	out	dx,ax
	mov	ax,0003h
	out	dx,ax
	mov	ax,0007h
	out	dx,ax

	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[color]
	mov	ds:[color_work],al

	mov	ax,[sx]
	mov	bx,[ex]
	cmp	bx,ax
	jnc	box_10
	xchg	ax,bx
box_10:
	mov	ds:[start_x],ax
	mov	ds:[end_x],bx
	sub	bx,ax
	mov	ds:[box_wide],bx

	mov	bx,[sy]
	mov	cx,[ey]
	cmp	cx,bx
	jnc	box_20
	xchg	bx,cx
box_20:
	mov	ds:[start_y],bx
	mov	ds:[end_y],cx
	sub	cx,bx
	mov	ds:[box_high],cx

	call	gadr_set	; start_x , start_y

	mov	di,ax		; ax .. gadr , bx .. dot
	mov	si,ax
	mov	ax,GRAPH_SEG
	mov	es,ax

	jcxz	box_40
box_loop:
	add	si,80
	loop	box_loop
box_40:
	call	box_set

	ret
box	endp


;
;	BOX PSET
;
box_set	proc	near
	push	di

	mov	ax,ds:[end_x]
	mov	cl,3
	shr	ax,cl
	mov	dx,ds:[start_x]
	shr	dx,cl
	mov	cx,ax
	sub	cx,dx
	jnz	box_s10

	mov	dx,03ceh

	mov	ah,cs:dot_data[bx]
	mov	cx,ds:[box_wide]
	inc	cx
box_sloop1:
	mov	al,08h
	out	dx,ax			; pattern
	mov	al,ds:[color_work]
	and	BYTE PTR es:[di],al	; top
	and	BYTE PTR es:[si],al	; bottom
	shr	ah,1
	loop	box_sloop1

	mov	bx,ds:[end_x]
	and	bx,00000111b
	mov	ah,cs:dot_data[bx]
	jmp	box_s30

box_s10:
	mov	dx,03ceh

	mov	ah,cs:start_data[bx]
	mov	al,08h
	out	dx,ax

	mov	al,ds:[color_work]
	and	BYTE PTR es:[di],al	; top
	and	BYTE PTR es:[si],al	; bottom
	inc	di
	inc	si

	dec	cx
	jz	box_s20

	mov	ax,0ff08h
	out	dx,ax
box_sloop2:
	mov	al,ds:[color_work]
	and	BYTE PTR es:[di],al
	and	BYTE PTR es:[si],al
	inc	di
	inc	si
	loop	box_sloop2
box_s20:
	mov	bx,ds:[end_x]
	and	bx,00000111b

	mov	ah,cs:end_data[bx]
	mov	al,08h
	out	dx,ax
	mov	al,ds:[color_work]
	and	BYTE PTR es:[di],al
	and	BYTE PTR es:[si],al

	mov	ah,cs:dot_data[bx]
box_s30:
	pop	si

	mov	cx,ds:[box_high]
	or	cx,cx
	jz	box_s50
	dec	cx
	jz	box_s50

	mov	bx,ds:[start_x]
	and	bx,00000111b
	mov	al,cs:dot_data[bx]

	mov	bx,ax
box_sloop3:
	add	di,80
	add	si,80

	mov	ah,bh
	mov	al,08h
	out	dx,ax
	mov	al,ds:[color_work]
	and	BYTE PTR es:[di],al		; ah

	mov	ah,bl
	mov	al,08h
	out	dx,ax
	mov	al,ds:[color_work]
	and	BYTE PTR es:[si],al		; al

	loop	box_sloop3
box_s50:
	ret
box_set	endp

;
;	J[ݒ
;	void gcolor(int for_color , int back_color);
;	  for_color  .. OiF
;	  back_color .. wiF
;
	public	gcolor
gcolor	proc	uses ds,fc:word,bc:word
	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[fc]
	mov	ds:[for_color],al
	mov	ax,[bc]
	mov	ds:[back_color],al
	ret
gcolor	endp

;
;	\ʒuw
;	void glocate(int x , int y);
;	  x .. wW(1 dot P)
;	  y .. xW(1 dot P)
;
	public	glocate
glocate	proc	uses ds,xx:word,yy:word
	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[xx]
	mov	ds:[cursor_x],ax
	mov	ax,[yy]
	mov	ds:[cursor_y],ax
	ret
glocate	endp

;
;	tHgp^[ݒ
;	void gfont_pattern(int font_pattern);
;	  font_pattern .. tHgp^[
;
	public	gfont_pattern
gfont_pattern	proc	uses ds,pat:word
	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[pat]
	mov	ds:[font_pattern],ax
	ret
gfont_pattern	endp


;
;	\
;	void gputs(unsigned char far *buff);
;	buff    .. 
;
	public	gputs
gputs	proc	uses ds es si di,buff:dword
	cld

	mov	ax,_DATA
	mov	ds,ax

	mov	dx,03ceh
	mov	ax,0005h
	out	dx,ax
	mov	ax,0f01h
	out	dx,ax
	mov	ah,ds:[back_color]
	mov	al,00h
	out	dx,ax
	mov	ax,0007h
	out	dx,ax
	mov	ax,0003h
	out	dx,ax
	mov	ax,0ff08h
	out	dx,ax

	mov	ax,GRAPH_SEG
	mov	es,ax
	mov	bx,0ffffh
	mov	es:[bx],BYTE PTR 0ffh
	mov	al,BYTE PTR es:[bx]

	mov	ax,0305h
	out	dx,ax
	mov	ah,ds:[for_color]
	mov	al,00h
	out	dx,ax

	mov	ax,ds:[cursor_x]
	mov	bx,ds:[cursor_y]
	mov	di,ds:[font_pattern]
	lds	si,[buff]
g_loop:
	mov	dh,BYTE PTR ds:[si]
	inc	si
	cmp	dh,00h
	jz	g_break
;
;	kanji 1 byte check
;
	cmp	dh,81h			; code < 81h ?
	jc	ghan_put			;  -> han
	cmp	dh,9fh+1		; 81h <= code <= 9fh
	jc	gkanji_put		;  -> zen
	cmp	dh,0e0h			; 9fh < code < 0e0h
	jc	ghan_put			;  -> han
	cmp	dh,0fch+1		; 0e0h <= code <= 0fch
	jc	gkanji_put
;
ghan_put:
	call	han_font_putc
	jmp	short g_loop

gkanji_put:
	mov	dl,BYTE PTR ds:[si]
	inc	si
	cmp	dl,00h
	jz	g_break

	call	zen_font_putc

	jmp	short g_loop
g_break:
	ret
gputs	endp

;
;	ptHg\
;	  in:  ax .. X
;              bx .. Y
;              di .. color
;              dh .. code
;
han_font_putc	proc	near
	pushr	<ds,es,si,di>
	pushr	<ax,bx>
	pushr	<ax,bx>
	push	di

	assume	es:DGROUP
	test	di,F_24
	jz	fh_10

	mov	ax,_DATA
	mov	es,ax
	mov	si,offset DGROUP:disp_buffer
	xor	ch,ch
	mov	cl,dh
	call	es:sbcs24_call

	pop	dx
	jmp	short fh_20

fh_10:
	mov	ax,_DATA
	mov	es,ax
	mov	si,offset DGROUP:kanji_buffer
	xor	ch,ch
	mov	cl,dh
	call	es:sbcs_call

han_draw:
	pop	dx
	call	han_effect	; kanji_buffer -> disp_buffer
fh_20:
	popr	<bx,ax>
	call	gadr_set
	mov	di,ax
	mov	ax,GRAPH_SEG
	mov	es,ax
	mov	ax,_DATA
	mov	ds,ax
	mov	si,offset DGROUP:disp_buffer

	test	dx,F_24
	jz	fh_30

	mov	cx,24		; y
	mov	bx,16		; x
	jmp	short fh_50
fh_30:
	mov	cx,16		; y
	mov	bx,8		; x
	test	dx,F_HIGH
	jz	fh_40
	shl	cx,1		; y * 2
fh_40:
	test	dx,F_WIDE
	jz	fh_50
	shl	bx,1		; x * 2
fh_50:
	push	bx
	call	gput_all
	pop	cx

	popr	<bx,ax>
	add	ax,cx		; X += 1 or 2
	popr	<di,si,es,ds>
	ret
han_font_putc	endp


;
;	SptHg\
;	  in:  ax .. X
;              bx .. Y
;              di .. font attrib
;              dx .. code
;
zen_font_putc	proc	near
	pushr	<ds,es,si,di>
	pushr	<ax,bx>
	pushr	<ax,bx>
	push	di
;
;	font data read
;
	test	di,F_24
	jnz	z24_read

	assume	es:DGROUP
	mov	ax,_DATA
	mov	es,ax
	mov	si,offset DGROUP:kanji_buffer
	mov	cx,dx
	call	es:dbcs_call

	pop	dx
	call	zen_effect
	jmp	fz_00

z24_read:
	mov	cx,_DATA
	mov	es,cx
	mov	si,offset DGROUP:disp_buffer
	mov	cx,dx
	call	es:dbcs24_call

	pop	dx
;
;	data write
;
fz_00:
	popr	<bx,ax>
	call	gadr_set
	mov	di,ax
	mov	ax,GRAPH_SEG
	mov	es,ax
	mov	ax,_DATA
	mov	ds,ax
	mov	si,offset DGROUP:disp_buffer

	mov	cx,24
	mov	bx,cx
	test	dx,F_24
	jnz	fz_20

	mov	cx,16		; y
	mov	bx,cx		; x
	test	dx,F_HIGH
	jz	fz_10
	shl	cx,1		; y * 2
fz_10:
	test	dx,F_WIDE
	jz	fz_20
	shl	bx,1		; x * 2
fz_20:
	push	bx
	call	gput_all	; cx .. Y  ,  ax .. X
	pop	cx

	popr	<bx,ax>
	add	ax,cx		; X += 1 or 2
	popr	<di,si,es,ds>
	ret
zen_font_putc	endp

;
;	OtBbN\
;	  in:   bx      .. wide
;               cx      .. high
;               es:[di] .. graphic address
;               ds:[si] .. data address
;
gput_all	proc	near
	shr	bx,1
	shr	bx,1
	shr	bx,1	; bx /= 8
ga_loop1:
	push	cx
	mov	cx,bx
	push	di

ga_loop2:
	rep	movsb
;	mov	al,es:[di]
;	lodsb		; es:[di++] = ds:[si++]
;	stosb
;	loop	ga_loop2

	pop	di

	add	di,80

	pop	cx
	loop	ga_loop1

	ret
gput_all	endp

;
;	SptHgH
;         in:  dx .. 
;                    bit0,1 .. ]
;                    bit2   .. {	no change
;                    bit3   .. c{	no change
;                    bit4   .. Α	no change
;                    bit5   .. 
;                    bit6   .. ʂ
;                    bit7   .. ]
;              DGROUP:kanji_buffer .. tHg
;	  out: DGROUP:disp_buffer  .. H̃tHgf[^
;
zen_effect	proc	near
	mov	bx,_DATA
	mov	ds,bx
	mov	es,bx

	mov	si,offset DGROUP:kanji_buffer
	mov	di,offset DGROUP:disp_buffer

	test	dx,F_ROT
	jz	ez_00
	call	zen_rot
ez_00:
	mov	cx,32/2

	test	dx,F_FOUR
	jz	ez_30
;
;	wide & high
;
ez_loop0:
	lodsw			; ax = ds:[si++]

	push	cx

	test	dx,F_WIDE
	jz	ez_10

	mov	bx,ax
	call	wide_data_one
	stosw			; es:[di++] = ax
	mov	cx,ax		; cx .. keep data
	xchg	bh,bl
	call	wide_data_one
	stosw			; es:[di++] = ax

	test	dx,F_HIGH
	jz	ez_20

	xchg	ax,cx
	stosw			; es:[di++] = ax
	xchg	ax,cx
	stosw			; es:[di++] = ax
	jmp	short ez_20
ez_10:
	stosw			; es:[di++] = ax

	test	dx,F_HIGH
	jz	ez_20

	stosw			; es:[di++] = ax
ez_20:
	pop	cx
	loop	ez_loop0
	jmp	short	ez_40
;
;	normal	trans
;
ez_30:
	rep	movsw			; es:[di++] = ds:[si++]
;
;	bold & rev
;
ez_40:
	test	dx,F_REV+F_BOLD
	jz	ez_ret

	test	dx,F_WIDE
	jz	ez_50
	call	rev_bold32
	jmp	short	ez_ret
ez_50:
	call	rev_bold16
ez_ret:
	ret
zen_effect	endp

;
;	Sp]
;
zen_rot	proc	near
	mov	cx,32/2
	rep	movsw	; disp <- kanji

	mov	di,offset DGROUP:kanji_buffer
	xor	ax,ax
	mov	cx,32/2
	rep	stosw	; work zero clear

	mov	di,offset DGROUP:kanji_buffer
	mov	si,offset DGROUP:disp_buffer

	push	dx
	and	dx,F_ROT
	cmp	dx,F_90
	jnz	zr_10
	call	zen_rot90
	jmp	short zr_ret
zr_10:
	cmp	dx,F_180
	jnz	zr_20
	call	zen_rot180
	jmp	short zr_ret
zr_20:
	call	zen_rot270
zr_ret:
	mov	si,offset DGROUP:kanji_buffer
	mov	di,offset DGROUP:disp_buffer
	pop	dx
	ret
zen_rot	endp

;
;	Sp90x]
;
zen_rot90	proc	near
	mov	cx,16
	mov	dx,0100h		; set bit
zr9_loop0:
	push	cx
	mov	bx,0080h		; check bit
	push	di
	mov	cx,16
zr9_loop1:
	test	bx,word ptr ds:[si]
	jz	zr9_10
	or	word ptr es:[di],dx
zr9_10:
	add	di,2
	shr	bl,1
	rcr	bh,1
	loop	zr9_loop1
	pop	di

	add	si,2
	shl	dh,1
	rcl	dl,1
	pop	cx
	loop	zr9_loop0

	ret
zen_rot90	endp

;
;	Sp270x]
;
zen_rot270	proc	near
	mov	cx,16
	mov	dx,0080h		; set bit
zr27_loop0:
	push	cx
	mov	bx,0100h		; check bit
	push	di
	mov	cx,16
zr27_loop1:
	test	bx,word ptr ds:[si]
	jz	zr27_10
	or	word ptr es:[di],dx
zr27_10:
	add	di,2
	shl	bh,1
	rcl	bl,1
	loop	zr27_loop1
	pop	di

	add	si,2
	shr	dl,1
	rcr	dh,1
	pop	cx
	loop	zr27_loop0

	ret
zen_rot270	endp

;
;	Sp180x]
;
zen_rot180	proc	near
	add	si,32-2

	mov	cx,16
zr18_loop0:
	push	cx
	mov	cx,16
	mov	bx,0100h
	mov	dx,0080h
zr18_loop1:
	test	bx,word ptr ds:[si]
	jz	zr18_10
	or	word ptr es:[di],dx
zr18_10:
	shl	bh,1
	rcl	bl,1
	shr	dl,1
	rcr	dh,1
	loop	zr18_loop1

	pop	cx
	add	di,2
	sub	si,2
	loop	zr18_loop0

	ret
zen_rot180	endp

;
;	16 dot ̃{[h & ]
;
rev_bold16	proc	near
	mov	si,offset DGROUP:disp_buffer
	mov	di,si
	mov	cx,32
rb_loop:
	lodsw			; ax = ds:[si++]
	test	dx,F_BOLD
	jz	rb_10
; bold
	mov	bx,ax
;;1996/11/25
;	shr	bl,1
;	rcr	bh,1
	shl	bh,1
	rcl	bl,1
;;
	or	ax,bx
rb_10:
	test	dx,F_REV
	jz	rb_20
; rev
	not	ax
rb_20:
	stosw			; es:[di++] = ax
	loop	rb_loop
	ret
rev_bold16	endp

;
;	8 dot ̃{[h & ]
;
rev_bold8	proc	near
	mov	si,offset DGROUP:disp_buffer
	mov	di,si
	mov	cx,32
rb8_loop:
	lodsb			; al = ds:[si++]
	test	dx,F_BOLD
	jz	rb8_10
; bold
	mov	ah,al
;;1996/11/25
;	shr	al,1
	shl	al,1
;;
	or	al,ah
rb8_10:
	test	dx,F_REV
	jz	rb8_20
; rev
	not	al
rb8_20:
	stosb			; es:[di++] = al
	loop	rb8_loop
	ret
rev_bold8	endp

;
;	32 dot ̃{[h & ]
;
rev_bold32	proc	near
	mov	si,offset DGROUP:disp_buffer
	mov	di,si
	mov	cx,32
rb32_loop:
	push	cx

	lodsw			; ax = ds:[si++]
	mov	bx,ax
	lodsw			; ax = ds:[si++]

	test	dx,F_BOLD
	jz	rb32_10
; bold
	push	dx
	mov	dx,bx
	mov	cx,ax

	shr	dl,1
	rcr	dh,1
	rcr	cl,1
	rcr	ch,1
	or	bx,dx
	or	ax,cx
	pop	dx
rb32_10:
	test	dx,F_REV
	jz	rb32_20
; rev
	not	bx
	not	ax
rb32_20:
	xchg	ax,bx
	stosw			; es:[di++] = ax
	xchg	ax,bx
	stosw			; es:[di++] = ax

	pop	cx
	loop	rb32_loop
	ret
rev_bold32	endp

;
;	{
;	  in:    bl .. byte data
;         out:   ax .. word data
;         break: ax,bl
;
wide_data_one	proc	near
	push	cx
	xor	ax,ax
	mov	cx,8
wd_loop:
	shr	al,1
	rcr	ah,1
	shr	al,1
	rcr	ah,1	; ax >>= 2

	shr	bl,1
	jnc	wd_10
	or	al,11000000b
wd_10:
	loop	wd_loop
	pop	cx
	ret
wide_data_one	endp


;
;	ptHgH
;         in:  dx .. 
;                    bit0,1 .. ]
;                    bit2   .. {	no change
;                    bit3   .. c{	no change
;                    bit4   .. Α	no change
;                    bit5   .. 
;                    bit6   .. ʂ
;                    bit7   .. ]
;              DGROUP:kanji_buffer .. tHgf[^
;	  out: DGROUP:disp_buffer  .. H̃tHgf[^
;
han_effect	proc	near
	mov	bx,_DATA
	mov	ds,bx
	mov	es,bx

	mov	si,offset DGROUP:kanji_buffer
	mov	di,offset DGROUP:disp_buffer
	mov	cx,16

	test	dx,F_FOUR
	jz	eh_30
;
;	wide & high
;
eh_loop0:
	lodsb			; ax = ds:[si++]

	push	cx

	test	dx,F_WIDE
	jz	eh_10

	mov	bl,al
	call	wide_data_one
	stosw			; es:[di++] = ax

	test	dx,F_HIGH
	jz	eh_20

	stosw			; es:[di++] = ax
	jmp	short eh_20
eh_10:
	stosb			; es:[di++] = al

	test	dx,F_HIGH
	jz	eh_20

	stosb			; es:[di++] = al
eh_20:
	pop	cx
	loop	eh_loop0
	jmp	short	eh_40
;
;	normal	trans
;
eh_30:
	rep	movsb			; es:[di++] = ds:[si++]
;
;	bold & rev
;
eh_40:
	test	dx,F_REV+F_BOLD
	jz	eh_ret

	test	dx,F_WIDE
	jz	eh_50
	call	rev_bold16
	jmp	short	eh_ret
eh_50:
	call	rev_bold8
eh_ret:
	ret
han_effect	endp

;
;	_ł
;	void pset(int pos_x , int pos_y , int color);
;	pos_x , pos_y  .. W
;	color          .. pbgR[h
;
	public	pset
pset	proc	uses es di,pos_x:word,pos_y:word,color:word
	mov	ax,[pos_x]
	mov	bx,[pos_y]
	call	gadr_set	; start_x , start_y
	mov	di,ax
	mov	ax,GRAPH_SEG
	mov	es,ax

	mov	dx,03ceh
	mov	ax,0a05h
	out	dx,ax
	mov	ax,0003h
	out	dx,ax
	mov	ax,0007h
	out	dx,ax

	mov	al,08h
	mov	ah,cs:dot_data[bx]
	out	dx,ax

	mov	al,BYTE PTR [color]
	and	BYTE PTR es:[di],al
	ret
pset	endp

;
;	OtBbN
;	  void graph_init(void);
;
	public	graph_init
graph_init	proc	uses	ds es
	mov	bx,_DATA
	mov	ds,bx

	mov	ah,0fh
	int	10h
	mov	ds:[vmode],al

	push	bp
	mov	ax,5000h
	mov	bx,0000h
	mov	dx,0810h
	mov	bp,0
	int	15h

	mov	word ptr ds:[sbcs_call],bx
	mov	word ptr ds:[sbcs_call+2],es
	mov	word ptr ds:[sbcs24_call],bx
	mov	word ptr ds:[sbcs24_call+2],es

	mov	ax,5000h
	mov	bx,0100h
	mov	dx,1010h
	int	15h

	mov	word ptr ds:[dbcs_call],bx
	mov	word ptr ds:[dbcs_call+2],es
	mov	word ptr ds:[dbcs24_call],bx
	mov	word ptr ds:[dbcs24_call+2],es

	mov	ax,5000h
	mov	bx,0000h
	mov	dx,0c18h
	int	15h
	jc	gi_10

	mov	word ptr ds:[sbcs24_call],bx
	mov	word ptr ds:[sbcs24_call+2],es
gi_10:
	mov	ax,5000h
	mov	bx,0100h
	mov	dx,1818h
	int	15h
	jc	gi_20

	mov	word ptr ds:[dbcs24_call],bx
	mov	word ptr ds:[dbcs24_call+2],es
gi_20:
	pop	bp

	mov	ax,0012h
	int	10h

	ret
graph_init	endp

;
;	OtBbNI
;	  void graph_end(void);
;
	public	graph_end
graph_end	proc	uses	ds
	mov	bx,_DATA
	mov	ds,bx

	mov	ah,00h
	mov	al,ds:[vmode]
	int	10h

	ret
graph_end	endp

;
;	VGA OtBbNAhX߂
;	in  : ax .. XW
;	      bx .. YW
;	out : ax .. AhX
;	      bx .. Vtg
;	break:
;	      ax,bx
;
	public	gadr_set
gadr_set	proc	near
	push	cx

	mov	cx,ax
	and	cx,00000111B	; dx % 8
	push	cx

	mov	cl,3
	shr	ax,cl		; ax / 8

	inc	cl
	shl	bx,cl		; x16
	add	ax,bx
	add	bx,bx
	add	bx,bx		; x64
	add	ax,bx

	pop	bx
	pop	cx

	ret
gadr_set	endp

;
;	C[W\
;	void gimage(unsigned char far *buff);
;	buff    .. C[Wf[^
;
	public	gimage
gimage	proc	uses ds es si di,buff:dword
	mov	ax,_DATA
	mov	ds,ax

	mov	dx,03ceh
	mov	ax,0005h
	out	dx,ax
	mov	ax,0f01h
	out	dx,ax
	mov	ah,ds:[back_color]
	mov	al,00h
	out	dx,ax
	mov	ax,0007h
	out	dx,ax
	mov	ax,0003h
	out	dx,ax
	mov	ax,0ff08h
	out	dx,ax

	mov	ax,GRAPH_SEG
	mov	es,ax
	mov	bx,0ffffh
	mov	es:[bx],BYTE PTR 0ffh
	mov	al,BYTE PTR es:[bx]

	mov	ax,0305h
	out	dx,ax
	mov	ah,ds:[for_color]
	mov	al,00h
	out	dx,ax

	mov	ax,ds:[cursor_x]
	mov	bx,ds:[cursor_y]
	call	gadr_set
	mov	di,ax
	mov	ax,GRAPH_SEG
	mov	es,ax

	lds	si,[buff]
	lodsb
	xor	ah,ah
	shl	ax,1
	shl	ax,1
	shl	ax,1		; x8
	mov	bx,ax

	xor	ch,ch
	mov	cl,ds:[si]
	inc	si

	call	gput_all

	ret
gimage	endp

;
;	pbgݒ
;	void palette_set(unsigned char far *buff , int no);
;	   buff .. pbgf[^
;	   no   .. ݒ肷pbg
;
palette_table	db	0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0

	public	pallet_set
palette_set	proc	uses es,buff:dword,no:word
	mov	ax,1012h
	mov	bx,0
	mov	cx,[no]
	les	dx,[buff]
	int	10h

	mov	ax,1002h
	push	cs
	pop	es
	mov	dx,offset palette_table
	int	10h
	ret
palette_set	endp

	end
