/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * This code is based on crt0.S by DJ Delorie.
 */


#include "stubinfo.h"


/*****************************************************************************\
 * Interface to 32-bit executable (from stub.asm)
 *
 *   eip	according to ELF header
 *   cs		32-bit flat code segment
 *   ds		32-bit flat data segment
 *   fs		selector for transferbuffer (fs:0 is stubinfo)
 *   ss:sp	temporary stack in transferbuffer
 *   <others>	All unspecified registers have unspecified values in them.
 *
 * stubinfo_magic		"dELFstub, v M.mm"
 * stubinfo_size		bytes in stubinfo structure
 * stubinfo_minstack		minimum amount of DPMI stack space
 * stubinfo_memory_handle	DPMI memory handle
 * stubinfo_initial_size	size of initial segment
 * stubinfo_minkeep		amount of automatic real-mode buffer
 * stubinfo_ds_selector		our DS selector (used for transfer buffer)
 * stubinfo_ds_segment		our DS segment (used for simulated calls)
 * stubinfo_psp_selector	PSP selector
 * stubinfo_cs_selector		to be freed
 * stubinfo_env_size		number of bytes of environment
 * stubinfo_basename		base name of executable to load (asciiz if < 8)
 * stubinfo_argv0		used ONLY by the application (asciiz if < 16)
 * stubinfo_dpmi_server		used by stub to load DPMI server
 * stubinfo_vaddr		negative VADDR
 * stubinfo_block		program addr
 * stubinfo_file		source file
 * stubinfo_offs		inExe
\*****************************************************************************/


		.text

		.type	_end, @object


		.globl	_start
		.type	_start, @function
		.p2align 4
_start:
	/* set up PIC frame */
		movl	%fs:(STUBINFO_VADDR), %ebx
	/* set up (s)brk */
		leal	_end(%ebx), %eax
		leal	__what_size_app_thinks_it_is(%ebx), %edi
		movl	%eax, (%edi)
		movl	%fs:(STUBINFO_BLOCK), %eax
		leal	__djgpp_base_address(%ebx), %edi
		movl	%eax, (%edi)
		addl	%fs:(STUBINFO_INITIAL_SIZE), %eax
		leal	__what_size_dpmi_thinks_we_are(%ebx), %edi
		movl	%eax, (%edi)
		leal	8+__djgpp_memory_handle_list(%ebx), %eax
		leal	__djgpp_memory_handle_pointer(%ebx), %edi
		movl	%eax, (%edi)
	/* copy stubinfo */
		cld
		pushl	%ds
		popl	%es
		leal	_stubinfo_data(%ebx), %edi
		pushl	%edi
		xorl	%esi, %esi
		movl	$(84/*STUBINFO_END*/>>2), %ecx
		.byte	100
		rep;	movsl
		popl	%edi
		leal	_stubinfo(%ebx), %esi
		movl	%edi, (%esi)
	/* create an alias for DS */
		leal	__djgpp_ds_alias(%ebx), %eax
		movl	%ds, (%eax)
		pushl	%ebx
		movw	%ds, %bx
		movw	$0x000a, %ax
		int	$0x31
		popl	%ebx
		jc	exit_error_alias
	/* XXX do we have to set it further? access/limit? */
		movw	%ax, %ds
	/* set up stack: MAX(minstack, _stklen) */
		leal	_stklen(%ebx), %esi
		movl	(%esi), %edx
		movl	STUBINFO_MINSTACK(%edi), %eax
		cmpl	%eax, %edx
		jnb	0f
		movl	%eax, %edx
	0:
		andb	$0xf0, %dl
		movl	%edx, (%esi)
		pushl	%edx
		call	mysbrk
		popl	%edx
		cmpl	$-1, %eax
		je	exit_error_stack
		leal	__djgpp_stack_limit(%ebx), %esi
		movl	%eax, (%esi)
		addl	%eax, %edx
		leal	__djgpp_stack_top(%ebx), %esi
		movl	%edx, (%esi)
		movw	%ds, %cx
		movw	%cx, %ss
		movl	%edx, %esp
	/* load all required objects */
		leal	objects(%ebx), %eax
		pushl	%eax
		leal	the_core_src(%ebx), %eax
		pushl	%eax
		movl	%fs:(STUBINFO_BLOCK), %eax
		pushl	%eax
		xorl	%eax, %eax
		movw	%fs:(STUBINFO_OFFS), %ax
		pushl	%eax
		movw	%fs:(STUBINFO_FILE), %ax
		pushl	%eax
		call	__elf_load
		addl	$16, %esp
		popl	%edx
		testl	%eax, %eax
		jz	exit_error_load
	/* relocate/link objects */
		leal	__djgpp_ds_alias(%ebx), %ecx
		movl	(%ecx), %ecx
		pushl	%ecx
		leal	exit32_first_byte(%ebx), %ecx
		pushl	%ecx
		leal	__djgpp_memory_handle_pointer(%ebx), %ecx
		movl	(%ecx), %ecx
		pushl	%ecx
		leal	__djgpp_memory_handle_list(%ebx), %ecx
		pushl	%ecx
		pushl	%eax
		pushl	%edx
		call	__elf_link
		popl	%edx
		popl	%ebp
		popl	%ecx
		popl	%edx
		popl	%esi
		popl	%ebx
		testl	%eax, %eax
		jnz	exit_error_link
		movl	$_init, 8(%ebp)
		movl	$_fini, 12(%ebp)
		movl	%ebp, the_core
	/* go to startup code */
		xorl	%ebp, %ebp
		call	__crt1_startup
		jmp	exit_normal
		.size	_start, .-_start


		.globl	__exit
		.type	__exit, @function
		.p2align 4
__exit:
		movb	4(%esp), %al
exit_normal:
		pushl	%ds
		popl	%fs
		movl	__djgpp_ds_alias, %ebx
		movl	$_stubinfo_data, %edi
		movw	STUBINFO_DS_SELECTOR(%edi), %ss
		movzwl	STUBINFO_MINKEEP(%edi), %esp
		movl	$__djgpp_memory_handle_list, %ecx
		movl	__djgpp_memory_handle_pointer, %edx
		movl	$exit32_first_byte, %esi
exit_common:
	/* DS:ESI -> exit32_helper
	 * FS:EDI -> stubinfo
	 * DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 * EBX    =  DS alias
	 * AL     =  error code
	 * stack  -> transferbuffer
	 */
		pushl	%eax
		call	free_blocks
		popl	%edx
		cld
		movl	$(exit32_last_byte - exit32_first_byte), %ecx
		xorl	%eax, %eax
		movw	%fs:STUBINFO_DS_SEGMENT(%edi), %ax
		shl	$4, %eax
		pushl	%ds
		popl	%es
		pushl	%edi
		movl	%eax, %edi
		rep;	movsb
		popl	%edi
		pushl	%eax
		movw	%fs:2+STUBINFO_MEMORY_HANDLE(%edi), %si
		movl	%fs:STUBINFO_MEMORY_HANDLE(%edi), %edi
		pushl	%ds
		movl	%ebx, %ds
		popl	%ebx
		movw	$0x0001, %ax
		int	$0x31
		ret

exit_error_load:
	/* FS:0   -> transferbuffer
	 * EBX    =  PIC frame
	 */
		movw	%fs:(STUBINFO_DS_SELECTOR), %ss
		movzwl	%fs:(STUBINFO_MINKEEP), %esp
exit_error_stack:
exit_error_alias:
	/* FS:0   -> transferbuffer
	 * EBX    =  PIC frame
	 * stack  -> transferbuffer
	 */
		leal	__djgpp_memory_handle_pointer(%ebx), %edx
		movl	(%edx), %edx
		leal	__djgpp_memory_handle_list(%ebx), %ecx
		leal	exit32_first_byte(%ebx), %esi
		leal	__djgpp_ds_alias(%ebx), %ebx
		movl	(%ebx), %ebx
		xorl	%edi, %edi
		movb	$-1, %al
		jmp	exit_common
exit_error_link:
	/* FS:0   -> transferbuffer
	 * DS:ESI -> exit32_helper
	 * DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 * EBX    =  DS alias
	 */
		movw	%fs:(STUBINFO_DS_SELECTOR), %ss
		movzwl	%fs:(STUBINFO_MINKEEP), %esp
		xorl	%edi, %edi
		movb	$-1, %al
		jmp	exit_common

free_blocks:
	/* DS:ECX -> __djgpp_memory_handle_list
	 * EDX    =  __djgpp_memory_handle_pointer
	 */
		pushl	%esi
		pushl	%edi
	0:
		addl	$8, %ecx
		cmpl	%ecx, %edx
		je	1f
		movl	(%ecx), %edi
		movw	2(%ecx), %si
		movw	$0x0502, %ax
		int	$0x31
		jmp	0b
	1:
		popl	%edi
		popl	%esi
		ret

exit32_first_byte:
	/* SI:DI = memory handle to free
	 * DL    = error code
	 */
		movw	$0x0502, %ax
		int	$0x31
		movb	%dl, %al
		movb	$0x4c, %ah
		int	$0x21
exit32_last_byte:
		.size	__exit, .-__exit


		.globl	mysbrk
		.type	mysbrk, @function
		.p2align 4
mysbrk:
		movl	%fs:(STUBINFO_VADDR), %edx
		leal	_crt0_startup_flags(%edx), %eax
		pushl	%eax
		leal	__djgpp_ds_alias(%edx), %eax
		pushl	%eax
		leal	__djgpp_selector_limit(%edx), %eax
		pushl	%eax
		leal	__djgpp_memory_handle_size(%edx), %eax
		pushl	%eax
		leal	__djgpp_memory_handle_list(%edx), %eax
		pushl	%eax
		leal	__djgpp_memory_handle_pointer(%edx), %eax
		pushl	%eax
		leal	__what_we_return_to_app_as_old_size(%edx), %eax
		pushl	%eax
		leal	__what_size_dpmi_thinks_we_are(%edx), %eax
		pushl	%eax
		leal	__what_size_app_thinks_it_is(%edx), %eax
		pushl	%eax
		movl	(%eax), %eax
		jmp	sbrk_common


		.globl	__sbrk
		.type	__sbrk, @function
		.p2align 4
__sbrk:
		movl	__what_size_app_thinks_it_is, %eax
		pushl	$_crt0_startup_flags
		pushl	$__djgpp_ds_alias
		pushl	$__djgpp_selector_limit
		pushl	$__djgpp_memory_handle_size
		pushl	$__djgpp_memory_handle_list
		pushl	$__djgpp_memory_handle_pointer
		pushl	$__what_we_return_to_app_as_old_size
		pushl	$__what_size_dpmi_thinks_we_are
		pushl	$__what_size_app_thinks_it_is
sbrk_common:
		movl	40(%esp), %ecx			/* Increment size */
		addl	%ecx, %eax
		jnc	brk_common
	/* Carry is only set if a negative increment or wrap happens.  Negative
	   increment is semi-OK, wrap (only for multiple zone sbrk) isn't. */
		test	$0x80000000, %ecx		/* Clears carry */
		jnz	brk_common

		movl	$-1, %eax
		addl	$36, %esp
		ret


		.globl	__brk
		.type	__brk, @function
		.p2align 4
__brk:
		movl	4(%esp), %eax
		pushl	$_crt0_startup_flags
		pushl	$__djgpp_ds_alias
		pushl	$__djgpp_selector_limit
		pushl	$__djgpp_memory_handle_size
		pushl	$__djgpp_memory_handle_list
		pushl	$__djgpp_memory_handle_pointer
		pushl	$__what_we_return_to_app_as_old_size
		pushl	$__what_size_dpmi_thinks_we_are
		pushl	$__what_size_app_thinks_it_is

brk_common:
		pushl	%ebp
		leal	4(%esp), %ebp

#define WHAT_SIZE_APP_THINKS_IT_IS		0
#define WHAT_SIZE_DPMI_THINKS_WE_ARE		4
#define WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE	8
#define DJGPP_MEMORY_HANDLE_POINTER		12
#define DJGPP_MEMORY_HANDLE_LIST		16
#define DJGPP_MEMORY_HANDLE_SIZE		20
#define DJGPP_SELECTOR_LIMIT			24
#define DJGPP_DS_ALIAS				28
#define CRT0_STARTUP_FLAGS			32

#define GET(a, b)	movl	a(%ebp), b; movl	(b), b
#define SET(a, b)	movl	b(%ebp), %ebx; movl	a, (%ebx)
#define SET2(a, b, c)	movl	b(%ebp), c; movl	a, (c)

		pushl	%ebx
		pushl	%esi
		pushl	%edi

		GET	(WHAT_SIZE_APP_THINKS_IT_IS, %edx)	/* save info */
		SET	(%edx, WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE)
		SET	(%eax, WHAT_SIZE_APP_THINKS_IT_IS)

		pushl	%eax
	/* check all blocks */
		GET	(DJGPP_MEMORY_HANDLE_POINTER, %edx)
		movl	DJGPP_MEMORY_HANDLE_LIST(%ebp), %esi
		movl	%edx, %ecx
		subl	%esi, %ecx
		shrl	$1, %ecx
		addl	DJGPP_MEMORY_HANDLE_SIZE(%ebp), %ecx
	0:
		subl	$8, %edx
		subl	$4, %ecx
		cmpl	%edx, %esi
		je	1f
		movl	4(%edx), %ebx
		cmpl	%eax, %ebx
		ja	0b
		addl	(%ecx), %ebx
		cmpl	%eax, %ebx
		jbe	0b
	/* free all blocks allocated after this one */
		SET2	(%ebx, WHAT_SIZE_DPMI_THINKS_WE_ARE, %edi)
		GET	(DJGPP_MEMORY_HANDLE_POINTER, %ecx)
		addl	$8, %edx
		SET	(%edx, DJGPP_MEMORY_HANDLE_POINTER)
	2:
		cmpl	%ecx, %edx
		jae	1f
		movl	(%edx), %edi
		movw	2(%edx), %si
		movw	$0x0502, %ax
		int	$0x31
		movl	$0, (%edx)
		addl	$8, %edx
		jmp	2b
	1:
		popl	%eax

		movl	WHAT_SIZE_DPMI_THINKS_WE_ARE(%ebp), %ebx
		cmpl	(%ebx), %eax				/* don't bother shrinking */
		jbe	brk_nochange

	/* Current allocation not large enough, get another block */
		GET	(WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE, %ecx)
		subl	%ecx, %eax
	14:
		pushl	%eax					/* Save orig */

/* Prevent handle exhaustion:  Block size of later allocated handles is larger.
   Block Size = 2^(16+handle#/32) which allows 512Mb on default 256 handles. */

		GET	(DJGPP_MEMORY_HANDLE_POINTER, %ecx)
		xorl	%edx, %edx
		subl	DJGPP_MEMORY_HANDLE_LIST(%ebp), %ecx	/* 8*hand# */
		shrl	$8, %ecx	/* hand#/32, tuneable, big shifts = old way */
		incl	%edx					/* EDX = 1 */
		addb	$16, %cl				/* 2^16=64K */
		shll	%cl, %edx
		decl	%edx
		movl	%edx, %ecx
		notl	%edx
		addl	%ecx, %eax			/* Round up to block */
		andl	%edx, %eax

		movl	%eax, %edx				/* Save size */
		movl	%eax, %ecx
		movl	%eax, %ebx
		shrl	$16, %ebx				/* BX:CX size */
		movw	$0x501,%ax
		int	$0x31
		popl	%eax					/* Orig size */
		jc	brk_error

		pushw	%bx
		pushw	%cx
		popl	%ecx					/* Linear address */
	15:
		pushl	%edx					/* Size */
		call	lock_memory

		movl	WHAT_SIZE_DPMI_THINKS_WE_ARE(%ebp), %ebx
		cmpl	%ecx, (%ebx)				/* Back to back ? */
		je	4f
		SET	(%ecx, WHAT_SIZE_DPMI_THINKS_WE_ARE)
		SET	(%ecx, WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE)
	4:
		GET	(WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE, %ebx)	/* Base for new block */
		addl	%ebx, %eax					/* Final address */
		SET	(%eax, WHAT_SIZE_APP_THINKS_IT_IS)
	/* Note - save adjusted memory base and memory handle SI:DI here */
		GET	(DJGPP_MEMORY_HANDLE_POINTER, %ebx)
		movl	%edi, (%ebx)
		movw	%si, 2(%ebx)
		movl	%ecx, 4(%ebx)
		leal	8(%ebx), %edi
	/* Handle Offset / 2 = Offset into Size Array */
		subl	DJGPP_MEMORY_HANDLE_LIST(%ebp), %ebx
		shrl	$1, %ebx
		addl	DJGPP_MEMORY_HANDLE_SIZE(%ebp), %ebx
		movl	%edx, (%ebx)
		movl	DJGPP_MEMORY_HANDLE_LIST(%ebp), %ebx
		addl	$2040, %ebx
		cmpl	%ebx, %edi				/* At end? */
		je	11f
		SET	(%edi, DJGPP_MEMORY_HANDLE_POINTER)	/* Only if not at end */
	11:
		addl	%ecx, %edx				/* Final address */
		decl	%edx					/* Limit to end */
	/* If we get a block at a lower address we must skip the limit change */
		GET	(DJGPP_SELECTOR_LIMIT, %ebx)
		cmpl	%ebx, %edx
		jbe	12f
	/* XXX change limit here */
	12:
		incl	%edx					/* Size not limit */
		movl	CRT0_STARTUP_FLAGS(%ebp), %ebx
		testb	$0x60, (%ebx)				/* include/crt0.h */
		jz	no_fill_sbrk_memory
		pushl	%ds
		popl	%es

		GET	(WHAT_SIZE_DPMI_THINKS_WE_ARE, %edi)	/* set all newly resized bytes zero */
		movl	%edx, %ecx					/* Limit */
		subl	%edi, %ecx			/* Adjust count for base */
		xorl	%eax, %eax
		testb	$0x40, (%ebx)
		jz	no_deadbeef
		movl	$0xdeadbeef, %eax		/* something really easy to spot */
no_deadbeef:
		shrl	$2, %ecx			/* div 4 Longwords not bytes */
		cld
		rep
		stosl
no_fill_sbrk_memory:
		SET	(%edx, WHAT_SIZE_DPMI_THINKS_WE_ARE)

brk_nochange:					/* successful return */
		GET	(WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE, %eax)
		jmp	brk_return

brk_error:					/* error return */
		GET	(WHAT_WE_RETURN_TO_APP_AS_OLD_SIZE, %eax)
		SET	(%eax, WHAT_SIZE_APP_THINKS_IT_IS)
		movl	$-1, %eax

brk_return:
		popl	%edi
		popl	%esi
		popl	%ebx

		popl	%ebp
		addl	$36, %esp
		ret
		.size	__brk, .-__brk
		.size	__sbrk, .-__sbrk
		.size	mysbrk, .-mysbrk


		.type	lock_memory, @function
lock_memory:
	/* BX:CX should be linear address; size is pushed on stack */
		pushl	%esi
		pushl	%edi
		pushl	%eax
		GET	(CRT0_STARTUP_FLAGS, %eax)
		testb	$0x10, 1(%eax)				/* include/crt0.h */
		jz	13f
		movl	16(%esp),%edi
		movw	18(%esp),%si
		movw	$0x600,%ax
		int	$0x31
	13:
		popl	%eax
		popl	%edi
		popl	%esi
		ret	$4			/* Pop the argument */
		.size	lock_memory, .-lock_memory


		.data

the_core_src:	.asciz	"/*core*/"

		.p2align 4

		.lcomm	_stubinfo_data, 84

		.comm	_stubinfo, 4
		.comm	_stklen, 4
		.comm	_crt0_startup_flags, 4

		.comm	the_core, 4
		.comm	objects, 8

		.type	__what_size_app_thinks_it_is, @object
		.size	__what_size_app_thinks_it_is, 4
__what_size_app_thinks_it_is:
		.long	0
		.type	__what_size_dpmi_thinks_we_are, @object
		.size	__what_size_dpmi_thinks_we_are, 4
__what_size_dpmi_thinks_we_are:
		.long	0
		.type	__what_we_return_to_app_as_old_size, @object
		.size	__what_we_return_to_app_as_old_size, 4
__what_we_return_to_app_as_old_size:
		.long	0

		.type	__djgpp_memory_handle_pointer, @object
		.size	__djgpp_memory_handle_pointer, 4
__djgpp_memory_handle_pointer:
		.long	0

		.comm	__djgpp_stack_top, 4
		.comm	__djgpp_stack_limit, 4
		.comm	__djgpp_ds_alias, 4
		.comm	__djgpp_selector_limit, 4
		.comm	__djgpp_base_address, 4

		.comm	__djgpp_memory_handle_list, 2048	/* Enough for 256 handles */
		.comm	__djgpp_memory_handle_size, 1024	/* Enough for 256 handles */


		.text

		.globl	_crt0_init_mcount
		.type	_crt0_init_mcount, @function
		.p2align 4
_crt0_init_mcount:
#ifdef IN_GCRT0
		jmp	_mcount_init
#else
		ret
#endif
		.size	_crt0_init_mcount, .-_crt0_init_mcount


		.weak	_init
		.weak	_fini
