
                org     0x0100
_main:
                call    start

                mov     ax,0x4c00
                int     0x21

        align           0x10
load_regs:
                dd      0x00000010
                dd      0
                dd      return;0x00000000
                dd      0,0,0,0x0000fffc
                dd      0,0,0,0
                dd      0xffff0ff0,0x00000400 ; dr6, dr7
                dd      0 ; ltr selector
                dd      0 ; lldt selector
                dw      0,0,0,0
                dw      0,0,0,0
                dw      0,0,0,0
TSS_Cache       dd      00008900h,tss      ,00000800h;tss_lt; not loaded?
IDT_Cache       dd      00000000h,00000000h,000003ffh
Gdt_Cache       dd      00000000h,gdt      ,00000048h ; 0 19a8e 27
Ldt_Cache       dd      00008200h,ldt0     ,00000088h ; not loaded
GS_Cache        dd      00009300h,00000000h,0000ffffh ; 199c0
FS_Cache        dd      00009300h,00000000h,0000ffffh ; 199c0
;DS_Cache        dd      00009300h,00000000h,0000ffffh ; 199c0
DS_Cache        dd      00009300h,00000000h,000fffffh ; 199c0
SS_Cache        dd      00009300h,00000000h,0000ffffh ; 1ba10
CS_Cache        dd      00009a00h,00000000h,0000ffffh ; 16f50
;ES_Cache        dd      00009300h,00000000h,0000ffffh ; 199c0
ES_Cache        dd      00009300h,00000000h,000fffffh ; 199c0

interim_gdt     resb    0x88

gdt:            dw      0x0048,gdt   ,0x0000,0x0000
                dw      0xffff,0x0000,0x9a00,0x0011 ; code
                dw      0xffff,0x0000,0x9200,0x008f ; data
                dw      0x0000,0x0000,0x9200,0x001f ; data
                dw      0x0048,gdt   ,0x8200,0x0010
                dw      tss_lt,tss   ,0x8900,0x0010 ; tss
ldt:            dw      0x0010,ldt0  ,0x8200,0x0010
                dw      0xffff,0x0000,0x9a00,0x00cf     ; 0x38
                dw      0x1000,0x0000,0x9200,0x00d0

idtp:           dw      0x0800,idt0,0x0000
idtr:           dw      0x03ff,0x0000,0x0000 ; to return to real mode...!
gdtr:           dw      0x0048,gdt,0x0000               ;dw limit dd base

ldt0:           dw      0x0000,0x0000,0x0000,0x0000
                dw      0x0010,ldt0  ,0x8400,0x0010     ; 0x30

;sseg:           dd      0x0000fffe,0x18 ; 0xffee (?) fill in before using

ivt_extern:     popa
                iret
ivr_normal:
               mov     ax,[bp+0x0e]
                call    wordhexout
                jmp     ivr_ret
bytehexout:     ;call   nybblehexout
                ret

        align           0x10
ivtlabel:
               pusha           ; sp -= 0x10
                mov     bp,sp
               mov ax,[bp+0x10] ; ip
                movzx   eax,ax
               mov dx,cs
               cmp dx,[bp+0x12] ; cs
               jne      ivt_extern
               ;cmp si,new_ivr-5
               ;jb       ivt_extern
               ;cmp si,new_ivr+0xfb
               ;ja       ivt_extern
               ;mov     ax,si
               sub     ax,new_ivr-4
                mov     bx,ivr_defaults
                push cs
                pop ds
                xlat                    ; mov al,[bx+al]
                cmp     al,2
                jne     ivr_normal
               mov     al,0x20
               out     0x20,al
ivr_ret:
               popa
                pop     ax      ; ip as int 3
                pop     ax      ; cs as int 3
                pop     ax      ; flags as int 3
               iret
        times 8 nop ; eax,ax; ds=cs
;
;        times 47 nop                    ; 0x2f
        times 3 db      0xcc
        jmp short ivtlabel
new_ivr:
        times 0x100-52 db 0xcc
old_ivt:
        times 0x100 dd  0x90909090
ivr_defaults:
                db      1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2
                db      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
                db      3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
                db      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4
wordhexout:
                push    ds
                push    cs
                pop     ds
                push    ax
                mov     al,ah
                call    nybblehexout
                pop     ax
                call    nybblehexout
                pop     ds
                ret
nybblehexout:
                push    ax
                push    ax
                push    cx
                mov     cl,4
                shr     al,cl
                pop     cx
                cmp     al,0x0a
                jb      nybblehexout1
                add     al,7
nybblehexout1:
                add     al,0x30
                call    byteout
                pop     ax
                and     al,0x0F
                cmp     al,0x0a
                jb      nybblehexout2
                add     al,7
nybblehexout2:
                add     al,0x30
                call    byteout
                pop     ax
                ret
byteout:
                push    ax
                push    dx
                mov     dl,al
                mov     ah,2
                int     0x21
                pop     dx
                pop     ax
                ret

dwordhexout:
                push    edx
                mov     edx,eax
                shr     eax,0x10
                movzx   eax,ax
                call    wordhexout
                mov     eax,edx
                movzx   eax,ax
                call    wordhexout
                pop     edx
                ret

fn              db      "0001.ELF",0
fh              dw      0
fcr             dd      0x00000000
pos             dd      0x100000

file_load__ret:
                ret

file_load:
                push    cs
                pop     ds
                mov     dx,fn
                mov     ax,0x3d00
                mov     cl,0
                int     0x21
                ;pushf
                ;popf
                jc      file_load__ret
                mov     bx,ax
                mov     [fh],bx
                ;mov     ebp,cr0
                ;mov     [fcr],ebp
mid_read:
                mov     bx,cs
                mov     ds,bx
                mov     es,bx
                mov     fs,bx
                mov     gs,bx
                xor     ebx,ebx
                mov     bx,[fh]
                ;mov     ebp,[fcr]
                ;mov     cr0,ebp
                mov     ax,cs
                add     ax,0x1000
                mov     ds,ax
                mov     dx,0x0000
                mov     cx,0x8000
                mov     ah,0x3f
                int     0x21            ; freeze with bochs on 2nd pass
                ;pushf
                ;call    wordhexout      ; xax not preserved
                ;popf
                jc      file_load_ret

                push    ax
                push    ds
;                call    wordhexout

                call    frm             ;es=0

                mov     ax,0
                mov     es,ax           ; not needed
                mov     ax,cs
                add     ax,0x1000
                mov     ds,ax

                mov     si,0
                mov     edi,[cs:pos]
                mov     cx,0x8000/4
        a32     rep     movsd
                mov     [cs:pos],edi
                xor     edi,edi

                pop     ds
                call    rmode

                pop     ax

                cmp     ax,0x8000       ; so I preserve ax
                je      _cont
                mov     ah,0x3e
                push    cs
                pop     ds
                
                mov     bx,[fh]
                int     0x21            ; close file
                jmp     file_load_ret
_cont:
                jmp     mid_read
file_load_ret:
                ret

ctor:
                mov     ax,cs
                movzx   eax,ax
                mov     edx,eax
                mov     ds,ax
                shl     eax,4
                ;mov     ebx,eax
                ;add     ebx,gdt
;                call    dwordhexout

                mov     bx,gdt
                add     [bx+0x0a],ax
                adc byte [bx+0x0c],1 ; this is a .com file at 0x1xxxx
                add     [bx+0x12],ax
                adc byte [bx+0x14],1 ; ^
;                add     [gdtr+4],dx
                add     [gdtr+2],eax
;                adc word [gdtr+4],1 ; ^

;                jmp     return

                lea     di,[load_regs]
                ;mov     ax,cs
                mov     [di+0x4c],cs
                mov     [di+0x48],ss
                add     [di+0x58],eax ; tss = tss
                ;add     [di+0x64],eax ; idt = 0
                add     [di+0x70],eax ; gdt = gdtr
                add     [di+0x7c],eax ; ldt = ldt0
                ;add     [di+0x88],eax ; gs
                ;add     [di+0x94],eax ; fs
                add     [di+0xa0],eax ; ds
                add     [di+0xac],eax ; ss
                add     [di+0xb8],eax ; cs
                add     [di+0xc4],eax ; es
                xor     eax,eax

                mov word [di+8],return
                push    ds
                pop     es

;                jmp word 0x0000:0xbf84  ; 0xbf84 for loadall386
return:
                ret



frm:
                mov     bx,0x0000
                mov     ax,cs
                mov     ds,ax
;                mov     si,es
                mov     es,ax
;                pushfd                  ; assuming ss valid since we are called
                mov     ds,ax
                mov     fs,ax
                mov     gs,ax
                cli
                mov     edx,cr0
                or      dl,0x01
                mov     cr0,edx
        o32     lgdt    [gdtr]          ; indirect as *
                push dword 0x00000008
                push dword pmodepoint
        o32     retf
pmodepoint:
;                push    cs
;                pop     es
;                mov     eax,cr0
;                or      al,1
;                cli
;                mov     cr0,eax
;        o32     lgdt    [gdtr]
;                push dword 0x00000008
;                push dword l0001
;        o32     retf
;l0001:
                mov     bx,es
                mov     dx,0x0010
                mov     ds,dx
                mov     es,dx
                mov     fs,dx
                mov     gs,dx
                and     al,0xfe
                mov     cr0,eax
                push word 0x0000
                push    bx
                push dword l0002
        o32     retf
l0002:
                sti
                mov     ax,0
                mov     es,ax
                mov     ds,ax
                mov     fs,ax
                mov     gs,ax
                mov     ax,0x0707
                mov     edi,0xb8000
                mov     cx,80*25
; o32?
                cld
;        a32     rep     stosw

                mov     edi,0x00000000

                ret

rmode:
                call word 0x0000:0xbf80 ; load2 0006.bin before running

                mov     ax,cs
                mov     ds,ax
                mov     es,ax
;                call    wordhexout

                ret

tidyelf:        db      0x7f,"ELF",1,1,1,0
entry:          dd      0,0

start_ret:
                ret

start:
                call    ctor
                call    file_load
                ;ret
                call    frm
;                jmp     no_file

                mov     bx,0
                mov     es,bx
                mov     edi,0x00100000
                mov     ax,cs
                ;mov     es,ax
                ;add     ax,0x1000      ; thats where we loaded each chunk
                mov     ds,ax

                mov     esi,tidyelf
                mov     ecx,00000008
        a32     rep     cmpsb
                jne     start_ret
;                mov     eax,[es:edi]
                add     edi,0x0000000a
                cmp byte [es:edi],03    ;word
                jne     start_ret
                add     edi,00000006
                mov     eax,[es:edi]
                mov     [entry],eax     ; right, no support for 64bit
                call    dwordhexout
                mov     cx,[es:edi+0x14]
                movzx   ecx,cx
                mov     ax,cx
                ;call    wordhexout
                ;mov     cx,5
                mov     dx,[es:edi+0x12]
                mov     ax,dx
                ;call    wordhexout
                add     edi,[es:edi+04]
                sub     edi,0x00000018
                or      cx,cx
                jz      no_file         ; nasm output
program_head:
                mov     eax,[es:edi+8]
                call    dwordhexout     ; 0x1,0x0
                mov     eax,[es:edi+0x10]
                ;call    dwordhexout     ; 0x0805903c,0
                mov     eax,[es:edi+0x14]
                ;call    dwordhexout
                mov     eax,[es:edi+0]
                call    dwordhexout
                add     di,dx
                loop    program_head

                mov     ax,0x1234
                call    wordhexout

;                mov     esi,0


;                mov     [new_ivr+03],0x

no_file:
                jmp     no_ivt
                mov     bx,cs
                mov     cx,0


                mov     edi,old_ivt     ; just use cs
                mov     es,bx
                mov     ds,cx
                mov     esi,0
                mov     cx,0x100
                cli
                rep     movsd
                ;mov     ds,bx
                mov     es,cx
                mov     di,0
                ;mov     si,new_ivr-5
                mov     cx,0x100
                mov     ax,bx
                shl     eax,0x10
                mov     ax,new_ivr-5
funny_loop:
                stosd
                inc     ax
                loop    funny_loop
                sti
                int     0x09
                mov     ds,bx
                mov     es,cx
                mov     si,old_ivt
                mov     di,0
                mov     cx,0x100
                cli
                rep     movsd
                sti

; check a mutex/semaphore
; use pushad at ivr_new
; hlt a few cycles (right here) to see which ones occur

                hlt
                hlt
                hlt
                hlt
                hlt
no_ivt:
_ret:
                ret

                ;call    wordhexout
; -------------------------------------------------------------------------
; -------------------------------------------------------------------------
queer_task:
                hlt
                jmp     queer_task


        bits            32
h:
                pushad
                push    es
                push dword 0x00000040
                pop     es
;;              push word 0x0010
                mov     edi,0x000b8000
                mov     cx,80*25
                mov     ax,0x0707
                rep     stosw
                pop     es
                popad
                sti
                iret

        bits            16              ; prolly superfluous as data follows


; ------stack--------------------------------------------------------------
        align           16
tss:
                dd      0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dw      0,0
                dd      queer_task      ; eip
                dd      0x00207206      ; eflags
                dd      0,0,0,0,0,0,0,0 ; regs


                dw      0x10,0          ; dcsddd(ldt)io
                dw      0x08,0
                dw      0x18,0
                dw      0x10,0
                dw      0x10,0
                dw      0x10,0
                dw      0x0000,io_offset ; 0x0001 for debug exceptions
io_offset:      dd      0x0, 0,0, 0,0, 0,0
                dd      0x0, 0,0, 0,0, 0,0 ; 128 bytes == 65536 bits
tss_lt          equ     $-tss

        align           0x10

 ;9&5/6/7/e/f
idt0:
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000 ; 0x0f

                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000 ; 0x1f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x2f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x3f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x4f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x5f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x6f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x7f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x8f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x9f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xaf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xbf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xcf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xdf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xef

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xff
idt_anew        dw      0,0,0 ; selector first
idt_limit:
offset          equ     $-$$
completion      equ     0x10000-0xbf80-offset
stack           equ     completion-2
        times completion db 0x90
;

