
                org     0xbf80          ; right after himemx.sys+sysskel.sys

_main:
;               call word 0:callpoint
                jmp     callpoint
;               jmp     _done
;               jmp     start
_done:          retf
                jmp     loadall

; ------data---------------------------------------------------------------
runstack        dw      0
runseg          dw      0
newstack        dw      0xfffe
                dw      0
data01:
cseg            dd      0,0             ; eip,cs of indirect jmp as cs = 0

data02:
gdt:            dw      0x0048,gdt   ,0x0000,0x0000
                dw      0xffff,0x0000,0x9a00,0x0011
                dw      0xffff,0x0000,0x9200,0x0000
                dw      0x0000,0x0000,0x9200,0x0011
                dw      0x0048,gdt   ,0x8200,0x0010
                dw      tss_lt,tss   ,0x8900,0x0010
ldt:            dw      0x0010,ldt0  ,0x8200,0x0010
                dw      0xffff,0x0000,0x9a00,0x00cf     ; 0x38
                dw      0x1000,0x0000,0x9200,0x00d0

idtp:           dw      0x0800,idt0,0x0000
idtr:           dw      0x03ff,0x0000,0x0000 ; to return to real mode...!
gdtr:           dw      0x0048,gdt,0x0000               ;dw limit dd base

ldt0:           dw      0x0000,0x0000,0x0000,0x0000
                dw      0x0010,ldt0  ,0x8400,0x0010     ; 0x30

sseg:           dd      0x0000fffe,0x18 ; 0xffee (?) fill in before using

; ------frm to rm----------------------------------------------------------
; gdt: (see .lst file for gdt info)

sseg_rm:        dw      0,0

code:
                movzx   eax,ax
                add dword [cseg],next01
                jmp dword far [cseg]
next01:
                push dword 0x00000000
                push dword next015
        o32     retf
next015:
                mov     [sseg_rm],sp
;               jmp     _ret
;               jmp     next03

                mov     [sseg],esp


callpoint:
                mov     ax,0x0000       ; preserve flags
                mov     ds,ax
                mov     si,es
                mov     es,ax
                pushfd                  ; assuming ss valid since we are called
                cli
                mov     edx,cr0
                or      dl,0x01
                mov     cr0,edx
        o32     lgdt    [gdtr]          ; indirect as *
                push dword 0x00000008
                push dword pmodepoint
        o32     retf
pmodepoint:

                mov     ax,0x0010
                mov     ds,ax
                mov     [sseg_rm],sp
                mov     bp,ss
                mov     [sseg_rm+2],bp
                mov     es,ax
                mov     fs,ax
                mov     gs,ax
                lss     esp,[sseg]
                push dword 0x00000008
                push dword next02
        o32     retf
next02:
                xor     eax,eax
                mov     cr3,eax

                mov     ax,0x0038
        o32     lidt    [idtp]
jmppoint:
                lidt    [idtr]
                mov     edx,cr0
                and     dl,0xfe
                mov     cr0,edx

                push dword 0x0000        ; cs
                push dword next03
        o32     retf
next03:
                xor     ax,ax
                mov     ds,ax
                mov     es,ax
                lss     sp,[sseg_rm]



                popfd
                mov     es,si
retpoint:       jmp     _done
;                retf
; ------


                sti
                jmp     _ret

; ------main---------------------------------------------------------------
start:
                push    ax
                xor     ax,ax
                mov     ds,ax
                mov     ax,ss
                mov     [runseg],ax     ; should be 0x0000
                pop     ax
                mov     [runstack],sp   ; esp for flat real mode?
                lss     sp,[newstack]

                pushad                   ; no way to pushaq nor o64
                xor     ax,ax
                mov     es,ax
;                call near 0xbe32        ; wordhexout, see 11.lst for 11.sys
                ;mov     ax,offset       ; 0x002c (varies)
;                mov     ax,$            ; 0xbf9e
                mov     ax,idt_limit
                call near 0xbe32        ; wordhexout
                jmp     code

_ret:
                popad
                lss     sp,[runstack]
                jmp     _done


; -------------------------------------------------------------------------
loadall:
;                sub     esp,4
                ;rol     edi,0x10
                call word 0:callpoint   ; ds=0 es?
                ;mov     ax,di
;                call near 0xbe32        ; wordhexout
                ;rol     edi,0x10
                ;mov     ax,di
;                call near 0xbe32        ; wordhexout
                mov     ax,es
;                call near 0xbe32        ; wordhexout

                mov     ds,ax           ; not 0; reserved space after load tbl
                mov     esi,edi
                mov     ecx,20+22+(6*10)

;loop_data1:
;                lodsw
;                push    ecx
;                call near 0xbe32        ; wordhexout
;                pop     ecx
;                loop    loop_data1

                mov     eax,[esi]
                and     al,1
                jz      _load_noret
                jmp     _load_ret
_load_noret:
                add     esi,84          ; also sub esi,84
                add     edi,ecx
                add     edi,ecx
                mov     eax,ds
                shl     eax,4
                add     eax,edi         ; not a seg (was ???please fix ds:esi)
                mov     ebx,ds ; is ds read-only???
                ;shl     ebx,4
                ;mov     dx,0
                ;mov     ds,dx          ; replaced by callpoint

                ;xor     bx,bx  ; eax unused?
                mov     ds,bx ; reloaded?
                mov     [edi+2],eax     ; gdt base
                ;mov     esi,edi
                mov     cx,0x0058*8
                mov word [edi],0x0058*8 ; gdt current limit

                mov     eax,[esi+((12*0)+4)]
                mov     [edi+2+(8*1)],ax
                shr     eax,0x10
                mov     [edi+6+(8*1)],al
                mov byte [edi+5+(8*1)],0x00
                mov     ax,[esi+((12*0)+8)]
                mov     [edi+(8*1)],ax
                mov     al,[esi+((12*0)+1)]
                mov     [edi+5+(8*1)],al ; 0x08 tr/tss

                mov     eax,[esi+((12*3)+4)]
                mov     [edi+2+(8*2)],ax
                shr     eax,0x10
                mov     [edi+6+(8*2)],al
                mov byte [edi+5+(8*2)],0x00
                mov     ax,[esi+((12*3)+8)]
                mov     [edi+(8*2)],ax
                mov     al,[esi+((12*3)+1)]
                mov     [edi+5+(8*2)],al ; 0x10 ldt

                mov     eax,[esi+((12*4)+4)]
                mov     [edi+2+(8*3)],ax
                shr     eax,0x10
                mov     [edi+6+(8*3)],al
                mov byte [edi+5+(8*3)],0x00
                mov     ax,[esi+((12*4)+8)]
                mov     [edi+(8*3)],ax
                mov     al,[esi+((12*4)+1)]
                mov     [edi+5+(8*3)],al ; 0x18 gs
                or byte [edi+5+(8*3)],0x82

                mov     eax,[esi+((12*5)+4)]
                mov     [edi+2+(8*4)],ax
                shr     eax,0x10
                mov     [edi+6+(8*4)],al
                mov byte [edi+5+(8*4)],0x00
                mov     ax,[esi+((12*5)+8)]
                mov     [edi+(8*4)],ax
                mov     al,[esi+((12*5)+1)]
                mov     [edi+5+(8*4)],al ; 0x20 fs
                or byte [edi+5+(8*4)],0x82

                mov     eax,[esi+((12*6)+4)]
                mov     [edi+2+(8*5)],ax
                shr     eax,0x10
                mov     [edi+6+(8*5)],al
                mov byte [edi+5+(8*5)],0x00
                mov     ax,[esi+((12*6)+8)]
                mov     [edi+(8*5)],ax
                mov     al,[esi+((12*6)+1)]
                and     al,0xfb
                mov     [edi+5+(8*5)],al ; 0x28 ds
                or byte [edi+5+(8*5)],0x80
                test    al,0x02
                jnz     load_no_gdt
                mov     bp,0x0013
                test    al,0x08
                jz      load_no_gdt
                or byte [edi+5+(8*5)],0x02 ; at least a readable exec seg
load_no_gdt:
                mov     eax,[esi+((12*7)+4)]
                mov     [edi+2+(8*6)],ax
                shr     eax,0x10
                mov     [edi+6+(8*6)],al
                mov byte [edi+5+(8*6)],0x00
                mov     ax,[esi+((12*7)+8)]
                mov     [edi+(8*6)],ax
                mov     al,[esi+((12*7)+1)]
                mov     [edi+5+(8*6)],al ; 0x30 ss
                or byte [edi+5+(8*6)],0x82

                mov     eax,[esi+((12*8)+4)]
                mov     [edi+2+(8*7)],ax
                shr     eax,0x10
                mov     [edi+6+(8*7)],al ; *1?
                mov byte [edi+5+(8*7)],0x00
                mov     ax,[esi+((12*8)+8)]
                mov     [edi+(8*7)],ax
                mov     al,[esi+((12*8)+1)]
                mov     [edi+5+(8*7)],al ; 0x38 cs
                or byte [edi+5+(8*7)],0x82

                mov     eax,[esi+((12*9)+4)]
                mov     [edi+2+(8*8)],ax
                shr     eax,0x10
                mov     [edi+6+(8*8)],al ; *1?
                mov byte [edi+5+(8*8)],0x00
                mov     ax,[esi+((12*9)+8)]
                mov     [edi+(8*8)],ax
                mov     al,[esi+((12*9)+1)]
                mov     [edi+5+(8*8)],al ; 0x40 es
                or byte [edi+5+(8*8)],0x82

                mov     eax,0
                mov     [edi+2+(8*9)],ax
                shr     eax,0x10
                mov     [edi+6+(8*9)],al
                mov byte [edi+5+(8*9)],0x00
                mov     ax,0xffff
                mov     [edi+(8*9)],ax
                mov     al,0x9a
                mov     [edi+5+(8*9)],al ; 0x48 cs-pmode

                mov     eax,[esi+((12*6)+4)] ; same as ds
                mov     [edi+2+(8*10)],ax
                shr     eax,0x10
                mov     [edi+6+(8*10)],al
                mov byte [edi+5+(8*10)],0x00
                mov     ax,[esi+((12*6)+8)]
                mov     [edi+(8*10)],ax
                mov     al,0x92         ; with permission to read
                mov     [edi+5+(8*10)],al ; 0x50 cs-pmode

                push    edi
;loop_data1:
;               lodsw
;;              push    ecx
;               call near 0xbe32
;;              pop     ecx
;               loop    loop_data1
                pop     edi

                push    esi
                xor     eax,eax
                mov     es,ax
                mov     eax,[esi+((12*1)+4)]
                mov     [es:idt_anew+0x02],eax
                ;call near 0xbe32       ; wordhexout
                ;shr    eax,0x10
                ;call near 0xbe32       ; wordhexout
                mov     eax,[esi+((12*1)+8)]
                mov     [es:idt_anew],ax ; limit
                ;call near 0xbe32       ; wordhexout
                mov     esi,edi
                mov     edi,idt_limit
                rep     movsb
                pop     esi
                push word [esi+(12*2)+8] ; stabilize gdt
                pop word [esi+(12*2)+2] ; (overwrote the ret in the .exe)

;               mov     eax,ds
;               shl     eax,4
;               add     edi,eax
                xor     eax,eax
                mov     bx,ds
                mov     ds,ax           ; zero sooner, check ds+e?i above

;               mov     ax,0x0058       ; not yet, update gdt limit above
                cli
                mov     eax,cr0
                or      al,1
                mov     cr0,eax
;               mov     ax,0x0050
;               mov     ds,ax
        o32     lgdt    [idt_limit]
                push dword 0x00000048
                push dword _load_pmode
        o32     retf
_load_pmode:
        o32     lidt    [cs:idt_anew] ; no problem with rcollins' idt_base
                mov     ax,0x0008
                movzx   eax,ax
                ltr     ax
                mov     ax,0x0010
                lldt    ax
                mov     ax,0x0018
                mov     gs,ax
                mov     ax,0x0020
                mov     fs,ax
                mov     ax,0x0028
                mov     ds,ax
                mov     ax,0x0040
                mov     es,ax
                mov     di,ss
                ;mov    edi,esp
                mov     ax,0x0018;30
                mov     ss,ax
                mov     esp,esp
                rcl     dl,1

                cmp     bp,0x0013
                je      load_not_gdt
                ;mov    ecx,[esi-84+52]
                ;mov    eax,[esi-84+56]
;???unhonored???        o32     lgdt    [esi+(12*2)+2]
load_not_gdt:
;               ltr     cx ; rcollins' gdt doesn't carry this selector?
;               lldt    ax ; rcollins' gdt doesn't carry this selector?

;??     o32     lidt    [cs:idtr]       ; this looks about the same
;       o32     lidt    [cs:idt_anew]   ; no problems with rcollins' IDT base
;               jmp     loaded_pmode
;loaded_pmode:
                mov     eax,cr0
                and     al,0xfe
                mov     cr0,eax
                push dword 0x00000000
                push dword load_rmode
        o32     retf
load_rmode:
                mov     ss,di           ; yes di is frobbed, see above? wait bp
                mov     esp,esp
                mov     ds,bx
                sub     esi,84
                mov     ax,[esi+72]
                push dword [esi+04]     ; ss??
                popfd
                rcr     dl,1
;               add     esp,4           ; o32 retf should suffice
                mov     ss,eax
                mov     esp,[esi+24]
                sti
                mov     eax,[esi+80]
                mov     es,eax
                mov     eax,[esi+64]
                mov     fs,eax
                mov     eax,[esi+76]
                mov     gs,eax
                mov     [cs:load_jmpbuf+0x04],ax ; ds not loaded yet; cs == 0
                mov     eax,[esi+60]
                mov     gs,eax
                mov     eax,[esi+44]
                mov     dr6,eax
                mov     eax,[esi+48]
                mov     dr7,eax
                mov     eax,[esi+68]
                mov     ebp,[esi+20]
                mov     [esi+20],eax
                mov     eax,[esi+40]
                mov     ecx,[esi+36]
                mov     edx,[esi]
                mov     cr0,edx
                mov     edx,[esi+32]
                mov     ebx,[esi+28]
                mov     edi,load_jmpbuf
                mov     edi,[esi+08]
                mov     [cs:load_jmpbuf],edi
                mov     edi,[esi+12]
                lds     esi,[esi+16]
                jmp far dword [cs:load_jmpbuf]
load_jmpbuf:    dw      0,0,0

; see .lst file to make sure each register is accounted for as loadall

;loop_data1:
;               lodsw
;               push    ecx
;               call near 0xbe32        ; wordhexout
;               pop     ecx
;               loop    loop_data1
_load_ret:
                mov     ah,0x4c
                int     0x21

; 1. break if cr0 contains a pmode value (&1)
; 2. jmp to pmode (descript.asm?)
; 3. load descriptors
; 4. load gdt,idt
; 5. ldt, tr, fs, gs, ds, es, ss
; 6. load cr0 (real mode)
; 7. load real mode segment values
; 8. load gp registers
; n. far jmp

; -------------------------------------------------------------------------
queer_task:
                hlt
                jmp     queer_task

        bits            32
h:
                pushad
                push    es
                push dword 0x00000040
                pop     es
;;              push word 0x0010
                mov     edi,0x000b8000
                mov     cx,80*25
                mov     ax,0x0707
                rep     stosw
                pop     es
                popad
                sti
                iret

        bits            16              ; prolly superfluous as data follows

; ------stack--------------------------------------------------------------
tss:
                dd      0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dd      0xfffffffe
                dw      0x18,0
                dw      0,0
                dd      queer_task      ; eip
                dd      0x00207206      ; eflags
                dd      0,0,0,0,0,0,0,0 ; regs


                dw      0x10,0          ; dcsddd(ldt)io
                dw      0x08,0
                dw      0x18,0
                dw      0x10,0
                dw      0x10,0
                dw      0x10,0
                dw      0x0000,io_offset ; 0x0001 for debug exceptions
io_offset:      dd      0x0, 0,0, 0,0, 0,0
                dd      0x0, 0,0, 0,0, 0,0 ; 128 bytes == 65536 bits
tss_lt          equ     $-tss

        align           0x10

 ;9&5/6/7/e/f
idt0:
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000 ; 0x0f

                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000
                dw      h,0x38,0x8e00,0x0000, h,0x38,0x8e00,0x0000 ; 0x1f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x2f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x3f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x4f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x5f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x6f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x7f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x8f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0x9f

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xaf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xbf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xcf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xdf

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xef

                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000
                dw      h,8,0x8e00,0x0000, h,8,0x8e00,0x0000 ; 0xff
idt_anew        dw      0,0,0 ; selector first
idt_limit:
offset          equ     $-$$
completion      equ     0x10000-0xbf80-offset
stack           equ     completion-2
        times completion db 0x90
;
;
