/*
 * dllink - dynamic linking system
 * Version:  0.1
 *
 * Copyright (C) 2005  Daniel Borca   All Rights Reserved.
 *
 * dllink is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * dllink is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Make; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * This code is loosely based on Stonewheel 0.0.8 by Burton Radons
 * (loth@pacificcoast.net), repackaged by Peter Wang (tjaden@psynet.net)
 */


#ifndef INTERNAL_H_included
#define INTERNAL_H_included

#define csst_import   0
#define csst_export   1
#define csst_unknown  2
#define csst_weak     0x40000000

#define csr_unknown   0
#define csr_type1     1
#define csr_type2     2
#define csr_type3     3
#define csr_type4     4
#define csr_fixed     0x40000000

typedef struct stone_object stone_object;

typedef struct stone_sym {
    char *name;			/* Symbol name */
    int value;			/* Value */
    int type;			/* csst_ */
    stone_object *obj;		/* Pointer for where it resolved to */
    struct stone_sym *sym;	/* Symbol entry (in owner object) */
} stone_sym;

typedef struct stone_rel {
    char *off;			/* Offset */
    int type;			/* csr */
    stone_sym *sym;		/* Relocation symbol */
    int addend;			/* Addend */
} stone_rel;

struct stone_object {
    struct stone_object *next, *prev;

    void (*init) (void);
    void (*fini) (void);

    const char *src;		/* Source file (For debugging) */
    char *code;			/* Imported code */
    int len;			/* Code length */

    int link;			/* Set if linked */
    int user;			/* Symbols that need this module */
    int mode;			/* RTLD_LAZY or RTLD_NOW */
    int type;			/* ET_EXEC or ET_DYN */

    int nsym;			/* Number of symbols */
    stone_sym *sym;		/* List of symbols */

    int nsyn;			/* Number of symbols */
    stone_sym *syn;		/* List of symbols */

    int nrel;			/* Number of relocations */
    stone_rel *rel;		/* List of relocations */

    int ndep;			/* Number of dependencies */
    char **dep;			/* List of dependencies */
};

#endif
