;!nasm -f bin -w-macro-params -o comring.com

; ComRing - serial line packet driver (eth emulation) - version 1.20
; Copyright (C) 1997, 1998 Jan Bobrowski <jb@wizard.ae.krakow.pl>
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License version 2 as published by
; the Free Software Foundation.
;
; This program is distributed in the hope that it will be useful, but WITHOUT
; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
; more details.

%define MAJOR 1
%define MINOR 20

;%define P386	;undef or P286 or P386
%define maxhandles 11	;max number of handles open

%define sendbuf 128	;address of small packet buffer
%include "jb.def"
%define ? 0

	org 100h
	jmp install

%ifdef P386
%define P286
%endif

%macro addd 2
add word [%1+0],%2
adc word [%1+2],byte 0
%endm

%macro incd 1
%ifdef P386
inc dword [%1]
%else
addd %1,byte 1
%endif
%endm

%macro shl_ 2
%ifdef P286
shl %1,%2
%else
times %2 shl %1,1 ;???
%endif
%endm

%macro shr_ 2
%ifdef P286
shr %1,%2
%else
times %2 shr %1,1 ;???
%endif
%endm

struc iocb
.buffer	resd 1
.length	resw 1
.flags	resb 1
.code	resb 1
.upcall	resd 1
.reserv	resb 4
.nx	resd 1
.crflg	resb 1
endstruc

struc entry
.handle	  resw 1
.type	  resw 1
.receiver resd 1
endstruc

header:
recvDst db ?	; destination
recvSrc db ?	; source
recvTtl db ?	; time to live & attrs
recvLen dw ?	; length
%assign headerlen $-header

;recvTtl fields:
%define MaskTTL	  0Fh
%define ComprIPX  bit4
%define OddLenIPX bit5
%define MaskResvd bit6|bit7

;node info flags:
%define SourceFlg 11h
%define MissedFlg 22h
%define DroppdFlg 44h

myid	db 0
ttl	db 1
retrf	db 0
rcvdf	db 0
sentAAf db 0
rcvdAAf db 0

sndcrc dw 0
rcvcrc dw 0

recvgbuf dw recvbuf0
recvdbuf dw recvbuf1
recvbuf0: times 1514+2 db ?
recvbuf1: times 1514+2 db ?

recvstack: times 64-4 dw ?
rcv_inisp:
	dw 0,0,0
	dw recv_start

rcv_sp dw rcv_inisp
rcv_ss dw ?
frg_sp dw ?
frg_ss dw ?

TypeTable:
dw maxhandles+1
dw 3 ;mode
htable:	times maxhandles dw 0,0,0,0
typtabend:
hdeflt:	dw 0,0xFFFF,0,0

cacheType dw 0
cacheEntry dw 0

;=========================================== send

head dw transbuf
tail dw transbuf
transbuf times 2270 db ?
transbufend:
%assign transbuflen transbufend-transbuf

putrb:
	push di
	mov di,[cs:head]
	mov [cs:di],al
	inc di
	cmp di,transbufend
	if nc, sub di,transbuflen
	cmp di,[cs:tail]
	mov [cs:head],di
	pop di
	jnz resetbuf.r

	incd errors_out

resetbuf:
	push es,di
	mov es,di,cs
	mov di,transbuf
	mov [cs:tail],di
	mov ax,0xFFAA
	stosw
	stosw
	mov [cs:head],di
	pop di,es
.r	ret

;=========================================== irq

port_IER dw ?
port_IDR dw ?
port_LCR dw ?
port_LSR dw ?
%define port_FCR port_IDR
eoicmd db ?

irq.jmp:
	pop dx,ax
	jmp far [cs:oldirq]

	db 'ComRing '
oldirq	dd 0
	db 'STDREZ'

irq:
	push ax,dx
	mov dx,[cs:port_IDR]
	in al,dx
	test al,bit0
	jnz irq.jmp

	push cx,bx,si,di
	push ds,es
	mov ds,ax,cs
	mov es,ax
	cld

	mov dx,[port_LSR]
	in al,dx
	test al,0Eh
	stc
	jnz irecv
	test al,bit0
	jz itrans

;- - - - - - - - - - - - - - - - - - receiving...
irecv:	mov [frg_ss],ss	 ;(don't change cf!)
	mov [frg_sp],sp
	mov ss,ax,cs
	mov sp,[rcv_sp]
	pop di,si,cx
	jnc recvrb.a
	ret

recvrb:
	mov dx,[port_LSR]
	in al,dx
	and al,0Fh
	jz .e
	cmp al,2
	cmc
.a	mov dx,[port]
	in al,dx
	ret

.e	push cx,si,di
	mov [rcv_sp],sp
	mov ss,[frg_ss]
	mov sp,[frg_sp]
;- - - - - - - - - - - - - - - - - - - -

itrans:	call transmit
	mov al,[eoicmd]
	out 20h,al

	cmp byte [rcvdf],1
	jnz mulplx.r
;- - - - - - - - - - - - - - - - - - - multiplexor
mulplx:
	inc byte [rcvdf]
	sti

	push bp ;for buggy handlers
	mov si,[recvdbuf]
	mov ax,[si+2+6+6]  ;type (protocol)

	mov bx,[cacheEntry]
	test bx
	jz .a
	cmp ax,[cacheType]
	jz .b

.a	call getEntry
	jnz .c	;ignore (not lost?)

	mov [cacheEntry],bx
	mov [cacheType],ax

.b	mov [receiver+0],ax,[bx+entry.receiver+0]
	mov [receiver+2],ax,[bx+entry.receiver+2]
	sub bx,htable-8
	shr bx,3	;handle

	lodsw
	mov dx,ax	;len
	mov cx,ax
	xor ax,ax
	push bx,si
	call far [receiver]
	pop si,bx
	mov ds,ax,cs

	mov ax,es
	or ax,di
	jz .d		;drop

	cld
	push di,cx
	rep movsb
	pop cx,si

	mov byte [cs:rcvdf],0

	mov ds,ax,es
	mov ax,1
	call far [cs:receiver]
	mov ds,ax,cs

.c	mov byte [rcvdf],0
	pop bp
;- - - - - - - - - - - - - - - - - - -

.r	pop es,ds
	pop di,si,bx,cx
	pop dx,ax
	iret

.d	cli
	incd packets_lost
	jmp .c

receiver dd ?

;======================================== transmitter

transmit:
	mov si,[tail]
	mov dx,[port_LSR]
	in al,dx
	test al,bit5
	jz .full

	mov cx,[txFifo]
	mov dx,[port]
.0:	cmp si,[head]
	jz .empty
	lodsb
	out dx,al
	cmp si,transbufend
	loopnz .0
	jnz .full
	sub si,transbuflen
	test cx
	jnz .0

.full	mov [tail],si
	mov al,7
.noq:	mov dx,[port_IER]
	out dx,al		;more to send
	ret

.empty	mov [tail],si
	cmp byte [retrf],0
	mov al,5
	jnz .noq		;nothing to send
	cmp word [firstiocb],-1
	jz .noq

;- - - - - - - - - - - - - - - - - - - sender

sender:	les di,[firstiocb]
	mov [firstiocb+0],ax,[es:di+iocb.nx+0]
	mov [firstiocb+2],ax,[es:di+iocb.nx+2]

	lds si,[es:di+iocb.buffer]
	mov cx,[es:di+iocb.length]

	incd cs:packets_out
	addd cs:bytes_out,cx

	call put_break
	mov al,[si+5]
	call putb	;dest
	mov al,[cs:myid]
	call putb	;src
	mov al,[cs:ttl]
	or al,[es:di+iocb.crflg]
	call putb	;ttl
	test byte [es:di+iocb.crflg],ComprIPX
	jnz .cipx

	sub cx,12
	mov ax,cx
	call putw
	add si,12

.0:	lodsb
	call putb
	loop .0

	mov ax,[cs:sndcrc]
	call putw

	or byte [es:di+iocb.flags],bit0
	mov byte [es:di+iocb.code],0
	test byte [es:di+iocb.flags],bit1

	if nz, call far [es:di+iocb.upcall]

	mov ds,ax,cs
	jmp transmit
			;send compressed IPX
.cipx:	sub cx,14+30-4
	mov ax,cx
	call putw
	mov ax,[si+14+6+10]
	call putw
	add si,14+30-2
	sub cx,2
	jmp .0

;===================================== send/recv byte

;	send:			  receive:
;  AA FF -> AA FE FF		AA FE -> AA
;  AA FE -> AA FE FE		AA FF -> AA break
;  break -> AA FF
;
; to fix: break should be encoded as line break signal rather
; than byte sequence

recvb:	call recvrb
	jc .r0
	cmp al,0AAh
	jz .r1
	cmp byte [rcvdAAf],0
	jz .r2
	mov byte [rcvdAAf],0
	cmp al,0FEh
	jz recvb
	cmc
	jnc .r2
.r0	mov word [rcvcrc],0
	ret ;cf=1

.r1	mov byte [rcvdAAf],1
.r2	rol word [rcvcrc],1
	xor [rcvcrc],al
	ret ;cf=0

recvw:	call recvb
	jc .r
	push ax
	call recvb
	pop dx
	mov ah,al
	mov al,dl
.r	ret

putw:	call putb
	mov al,ah

putb: 	rol word [cs:sndcrc],1
	xor [cs:sndcrc],al
	cmp al,0AAh
	jz .s2
	cmp byte [cs:sentAAf],0
	jz .s1
	mov byte [cs:sentAAf],0
	cmp al,0FEh
	jc .s1
	push ax
	mov al,0FEh
	call putrb
	pop ax
.s1:	jmp putrb

.s2:	mov byte [cs:sentAAf],1
	jmp putrb

put_break:
	mov word [cs:sndcrc],0
	mov al,0AAh
	call putrb
	mov al,0FFh
	jmp putrb

;========================================== rx thread

missed:
	mov al,MissedFlg
	mov ah,[recvDst]
	call markn

recv_start:
recv0:
	call recvb
	jnc recv0
recv1:
	call recvb
	jc recv1

	mov di,header
	stosb
	mov cx,headerlen-1
.0:	call recvb
	jc recv1
	stosb
	loop .0

	test byte [recvTtl],MaskResvd
	jnz recv0
	mov dl,[myid]
	cmp [recvSrc],dl
	jz missed	;my packet

	mov cx,[recvLen]
	dec cx
	cmp cx,1502
	ja recv0
	inc cx

	mov al,[recvDst]
	cmp al,dl
	jz recvpkt
	cmp al,0FFh
	jz rrtrpkt

;- - - - - - - - - - - - - - - - - retransmission
retrpkt:
	call retrhdr
	jc recv0

.0:	call recvb
	jc .err
	call putb
	loop .0

	call chkcrc
	jc .err
	mov ax,[sndcrc]
	call putw

	call markSrcF
	dec byte [retrf]
	jmp recv0

.err	call put_break
	dec byte [retrf]
	jmp recv1

;- - - - - - - - - - - - - - - - - - - receiving
recvpkt:
	call cpyhdr
	;jc recv0
.r2:
.0:	call recvb
	jc RXerror1
	stosb
	loop .0

	call chkcrc
	jnc recvd

RXerror0:
	incd errors_in
	jmp recv0

;- - - - - - - - - - - - - - retransmission & receiving
rrtrpkt:
	call cpyhdr
	;jc retrpkt
	call retrhdr
	jc recvpkt.r2

.0:	call recvb
	jc .err
	stosb
	call putb
	loop .0

	call chkcrc
	jc .err
	mov ax,[sndcrc]
	call putw

	dec byte [retrf]
	jmp recvd

.err:	call put_break
	dec byte [retrf]

RXerror1:
	incd errors_in
	jmp recv1

;- - - - - - - - - - - - - - - - - - - - - - - - -

recvd:				;packet received
	call markSrcF

	test byte [recvTtl],ComprIPX
	jz .noipx
			;decompress IPX (stage II)
	mov si,[recvgbuf]
	mov di,si
	add di,byte 2+14+6
	add si,byte 2
	call .ipxadr
	mov ax,[di+2+4+6-2]
	stosw
	call .ipxadr

.noipx:
	incd packets_in
	mov di,[recvgbuf]
	mov cx,[di]
	addd bytes_in,cx

	cmp byte [rcvdf],2
	jz .lost	; during receiver calling

	xchg [recvdbuf],di
	mov [recvgbuf],di
	mov byte [rcvdf],1
	jmp recv0

.ipxadr:
	xor ax,ax
	stosw
	stosw		; network address
	movsw
	movsw
	movsw		; node address
	ret

.lost:	incd packets_lost
	jmp recv0

			;retransmission of header
retrhdr:
	test byte [recvTtl],MaskTTL
	jz .x
	dec byte [recvTtl]
	call put_break
	mov byte [retrf],1
	push cx
	mov si,header
	mov cx,headerlen
.0:	lodsb
	call putb
	loop .0
	pop cx
	clc
	ret ;cf=0 ok

.x:	mov al,DroppdFlg
	mov ah,[recvSrc]
	call markn
	stc
	ret

			;copying of header
cpyhdr:
	mov di,[recvgbuf]
	mov ax,cx
	add ax,12
	stosw
	mov al,[recvDst]
	call genetha
	mov al,[recvSrc]
	call genetha
	test byte [recvTtl],ComprIPX
	jz .ret
			;decompress IPX hdr (stage I)
	mov ax,3781h
	stosw
	mov ax,-1
	stosw

	mov ax,[di-4-6-6-2] ;length
	add ax,2+30-4
	mov [di-4-6-6-2],ax
	sub ax,14
	test byte [recvTtl],OddLenIPX
	if nz, dec ax
	xchg ah,al
	stosw

	mov ax,0400h
	stosw
	add di,10+10
		; to be continued...
.ret	ret

genetha:
	cmp al,-1
	jz .b
	mov [es:di+5],al
	xor ax,ax
	stosw
	stosw
	stosb
	inc di
	ret

.b	mov ah,al
	stosw
	stosw
	stosw
	ret

chkcrc:	push word [rcvcrc]
	call recvw
	pop dx
	jc .r
	cmp ax,dx
	jz .r
	stc
.r	ret

getEntry:
	mov bx,htable
.0	cmp byte [bx+entry.handle],0
	jz .n
	cmp [bx+entry.type],ax
	jz .ret
.a	add bx,byte entry_size
	cmp bx,hdeflt
	jc .0
	cmp byte [bx+entry.handle],maxhandles+1
.ret	ret

.n	mov cx,bx
	jmp .a

; INTERFACE

%define BAD_HANDLE 1	; Invalid handle number
%define NO_CLASS 2	; No interfaces of specified class found
%define NO_TYPE 3	; No interfaces of specified type found
%define NO_NUMBER 4	; No interfaces of specified number found
%define BAD_TYPE 5	; Bad packet type specified
%define NO_MULTICAST 6	; This interface does not support multicast
%define CANT_TERMINATE 7; This packet driver cannot terminate
%define BAD_MODE 8	; An invalid receiver mode was specified
%define NO_SPACE 9	; Operation failed because of insufficient space
%define TYPE_INUSE 10	; The type had previously been accessed, and not released
%define BAD_COMMAND 11	; The command was out of range, or not implemented
%define CANT_SEND 12	; The packet couldn't be sent (usually hardware error)
%define CANT_SET 13	; Hardware address couldn't be changed (more than 1handle open)
%define BAD_ADDRESS 14	; Hardware address has bad length or format
%define CANT_RESET 15	; Couldn't reset interface (more than 1 handle open)
%define BAD_ARGUMENT 1	;????

%define bp_f	+4+2
%define bp_ds	-2
%define bp_si	-4

	db 'ComRing '
	dd 0
	db 'STDREZ'
pktdrvr:
	jmp short .p
	db 0 ;padding

	db 'PKT DRVR',0

.p	sti
	push bp
	mov bp,sp
	push ds,si
	cmp ah,30
	ja badfun

	push ax
	mov al,ah
	cbw
	add ax,ax
	mov si,ax
	mov ds,ax,cs
	pop ax

	cld
	jmp [si+funtab]

funtab: dw badfun,drvinf,acctype,reltype	;4
	dw sendpkt,sigterm,getaddr,resetif	;8
	dw badfun,badfun,getpar,badfun		;12
	dw assend,droppkt			;14
	times 20-14 dw badfun			;20
	dw getrmode				;21
	times 24-21 dw badfun			;24
	dw getstat				;25
	times 30-25 dw badfun			;30
	dw getstruc

badfun:
	mov dh,BAD_COMMAND
reterr:
	or byte [bp+bp_f],1
	pop si,ds,bp
	iret

;-------------------------------------- #1 driver info
pname: db 'ComRing',0

drvinf:
	mov bx,(MAJOR<<8)+MINOR	;version
	mov cx,100h
	mov dx,0 		;drv type
	mov word [bp+bp_ds],ds
	mov word [bp+bp_si],pname
	mov al,5

retok:	and byte [bp+bp_f],0FEh
	pop si,ds,bp
	iret

;-------------------------------------- #2 access type

e_NoClass:
	mov dh,NO_CLASS
	jmp reterr

acctype:
	cmp al,1	;ethernet
	jnz e_NoClass
	cli

	test cx
	jnz .a
	mov bx,hdeflt
	cmp word [bx],0
	jz .d
	jmp e_TypeInuse

.a:	cmp cx,2
	jnz e_BadType

	push ds
	lds si,[bp+bp_si]
	lodsw
	pop ds

	xor cx,cx
	call getEntry
	jnz .b
	cmp byte [bx+entry.handle],maxhandles+1
	jnz e_TypeInuse
.b	test cx
	jz e_NoSpace
	mov bx,cx

	mov [bx+entry.type],ax
.d	mov [bx+entry.receiver+0],di
	mov [bx+entry.receiver+2],es
	mov ax,bx
	sub ax,htable-8
	shr_ ax,3
	mov [bx+entry.handle],ax
	jmp retok

e_NoSpace:
	mov dh,NO_SPACE
	jmp reterr

e_BadType:
	mov dh,BAD_TYPE
	jmp reterr

e_TypeInuse:
	mov dh,TYPE_INUSE
	jmp reterr

;-------------------------------------- #3 release type

reltype:
	cmp bx,maxhandles+1
	ja e_BadHandle	;handle can be 1...maxhandles+1
	dec bx
	shl_ bx,3
	xor ax,ax
	xchg word [htable+bx],ax
	and ax,ax
	jz e_BadHandle
	mov word [cacheEntry],0
	jmp retok

e_BadHandle:
	mov dh,BAD_HANDLE
	jmp reterr

;-------------------------------------- #4  send pkt
;					#12 as send pkt

sendIocb:
	dd 0
	dw 0
	db bit0
	db 0
	dw 0
	times 4 db 0
	times 8 db 0

sendpkt:
	mov si,[bp+bp_si]
	mov dx,[bp+bp_ds]
	mov es,ax,cs

	mov al,0
.0:	xchg [sendIocb+iocb.flags],al
	and al,al
	jz .0

	cmp cx,128
	pushf
	ja .long

	mov di,sendbuf
	mov ds,dx
	push cx
	rep movsb
	pop cx

	mov ds,dx,cs
	mov si,sendbuf

.long	mov es,ax,cs
	mov di,sendIocb
	mov [di+iocb.buffer+0],si
	mov [di+iocb.buffer+2],dx
	mov [di+iocb.length],cx
	mov byte [di+iocb.flags],0
	call assend1
	jc .err0

	popf
	jbe .r

.1:     hlt
	test byte [sendIocb+iocb.flags],bit0
	jz .1

.r	jmp retok

.err0	popf
	mov byte [sendIocb+iocb.flags],1
.err1   cli
	incd errors_out
	mov dh,CANT_SEND
	jmp reterr

firstiocb dd 0FFFFFFFFh

assend:	call assend1
	jc sendpkt.err1
	jmp retok

assend1.ret:
	 ret

assend1:
	mov ax,[es:di+iocb.length]
	sub ax,1515
	cmp ax,14-1515
	jc .ret

;	cmp word [es:di+iocb.length],14
;	jc .ret
;	cmp word [es:di+iocb.length],1515
;	cmc
;	jc .ret

	lds si,[es:di]
	call chkaddr
	jc .done

	mov word [es:di+iocb.nx],-1

	mov si,firstiocb-16
	mov ds,ax,cs
	cli
	jmp short .q

.0:	lds si,[si+iocb.nx]
.q:	cmp word [si+iocb.nx],-1
	jnz .0

	mov [si+iocb.nx+2],es
	mov [si+iocb.nx+0],di
	sti

	call chkipx
	mov ds,ax,cs
	cli
	call transmit
.ok     sti
	clc
	ret

.done	mov al,bit0
	xchg [es:di+iocb.flags],al
	test al,bit1
	jz .ok
	call far [es:di+iocb.upcall]
	jmp short .ok

chkaddr:
	mov ax,[si]
	cmp ax,[si+2]
	jnz .n
	cmp ax,[si+4]
	jnz .a
	inc ax
	jz .ret
.n	stc
.ret	ret

;.a	mov ax,[si+4]
;	cmp ax,'Z'<<8
;	ja .n
;	cmp ax,'A'<<8
;	ret

.a	mov ax,[si+4]
	sub ax,('Z'+1)<<8
	cmp ax,('A'-'Z'-1)<<8
	ret

;Packets identified as IPX:
;  DD DD DD DD DD DD	- destination
;  SS SS SS SS SS SS	- source
;  81 37		- ipx protocol
;  FF FF
;  LL LL		- length of packet minus 14 or 15 (OddLenIPX)
;  00 04
;  00 00 00 00 DD DD DD DD DD DD
;  ?? ??		- NOT REMOVED!
;  00 00 00 00 SS SS SS SS SS SS

chkipx:
		; es:di -> iocb
	mov byte [es:di+iocb.crflg],0
	push es,di
	mov cx,[es:di+iocb.length]
	cmp cx,14+30+2
	jc .pr

	lds si,[es:di]
	add si,12
	lodsw	;8137
	cmp ax,3781h
	jnz .pr
	lodsw	;FFFF
	inc ax
	jnz .pr
	lodsw	;len
	xchg ah,al
	sub cx,ax
	sub cx,14
	jz .even
	dec cx
	jnz .pr
	mov byte [es:di+iocb.crflg],OddLenIPX
.even:	lodsw	;0004
	cmp ax,0400h
	jnz .pr

	les di,[es:di]
	call .chkadr
	jnz .pr
	inc si,si
	call .chkadr

.pr:	pop di,es
	if z, or byte [es:di+iocb.crflg],ComprIPX
	mov ds,ax,cs
	ret

.chkadr	xchg si,di
	mov al,0
	mov cx,4
	repz scasb
	xchg di,si
	jnz .r
	mov cx,6
	repz cmpsb
.r	ret

;-------------------------------------- #5 terminate

sigterm:
	mov es,di,cx
	mov di,firstiocb-16
	cli
	jmp .q

.0:	mov byte [es:di+iocb.code],CANT_SEND
	or byte [es:di+iocb.flags],bit0
	test byte [es:di+iocb.flags],bit1
	jz .q
	push es,di
	call far [es:di+iocb.upcall]
	pop di,es
.q:	les di,[di+iocb.nx]
	cmp di,-1
	jnz .0

	mov byte [pktdrvr+3],0

	pop si,ds,bp
	mov dx,0
	mov ds,dx
	push word [21h*4+2]
	push word [21h*4+0]
	mov ah,25h
	mov al,[cs:pktint]
	int 21h

	mov ah,25h
	mov al,[cs:comint]
	mov ds,[cs:oldirq+2]
	mov dx,[cs:oldirq+0]
	int 21h

	mov es,ax,cs
	mov ah,49h
	retf

;-------------------------------------- #6 get address

getaddr:
	mov al,[myid]
	cld
	call genetha
	jmp retok

;-------------------------------------- #7 reset interface

resetif:
	cli
	mov dx,[port_LCR]
	mov al,bit7
	out dx,al
	mov ax,[baudiv]
	mov dx,[port]
	out dx,ax
	mov dx,[port_LCR]
	mov al,0
	out dx,al ;LCR

	mov dx,[port_FCR]
	mov al,10000001b
	out dx,al ;FIFO

	mov dx,[port_LCR]
	mov al,03
	out dx,al ; 8n1

	call resetbuf
	jmp retok

;-------------------------------------- #10 get param.

getpar:
	mov es,ax,cs
	mov di,param
	jmp retok

param:	db 1,11
	db 14
	db 6
	dw 1514
	dw 0
	dw 0,0
comint	db 0,0

;-------------------------------------- #13 drop pkt

droppkt:
	mov cx,es
	mov si,firstiocb-iocb.nx
	cli
	jmp .q

.0:	lds si,[si+iocb.nx]
.q:	cmp word [si+iocb.nx],-1
	jz .x
	cmp [si+iocb.nx+0],di
	jnz .0
	cmp [si+iocb.nx+2],cx
	jnz .0

%ifndef P386
	mov [si+iocb.nx+0],ax,[es:di+iocb.nx+0]
	mov [si+iocb.nx+2],ax,[es:di+iocb.nx+2]
%else
	mov [si+iocb.nx],eax,[es:di+iocb.nx]
%endif

.x	mov ds,ax,es
	jmp retok

;-------------------------------------- #21 get recv mode
getrmode:
	mov ax,3
	jmp retok

;-------------------------------------- #24 get statistics
;					#30 get structure

getstat:
	mov si,Stat
	;jmp retstruc

retstruc:
	mov word [bp+bp_ds],cs
	mov word [bp+bp_si],si
	jmp retok

getstruc:
	cmp bx,byte 1
	jz getstat

	cmp bx,byte 10
	mov si,UartCfg
	jz retstruc

	cmp bx,byte 13
	mov si,TypeTable
	jz retstruc

	cmp bx,32768
	mov si,CRNodes
	jz retstruc

	mov dh,BAD_ARGUMENT
	jmp reterr

Stat:
packets_in	dd 0
packets_out	dd 0
bytes_in	dd 0
bytes_out	dd 0
errors_in	dd 0
errors_out	dd 0
packets_lost	dd 0

UartCfg:
uarts	dw 8250
comnr	dw 0
port	dw -1
comirq	db -1
pattr	db 3	;?
clrbda	db 0	;was removed from COM table
rtscts	db 0
baud	dd 115200
baudiv	dw 0

txFifo	dw 1	;length of tx fifo

CRNodes:	; will be changed..
times 256 db 0

markSrcF:	; called from engine
	mov al,SourceFlg
	mov ah,[recvSrc]
markn:
	mov bl,ah
	mov bh,0
	or [CRNodes+bx],al
	ret

;--------------------------------------

pktint db 60h

; INSTALL
%macro write 1
	mov si,%1
	call wascii
%endm

install:
	mov dx,txinf
	mov ah,9
	int 21h

	call args
	call coopt

	mov ax,[port]
	inc ax
	mov [port_IER],ax ;port+1
	inc ax
	mov [port_IDR],ax ;port+2
	inc ax
	mov [port_LCR],ax ;port+3
	add ax,2
	mov [port_LSR],ax ;port+5

	call chkuart
	call chkfifo

	mov al,[comirq]
	add al,8
	mov [comint],al
	add al,60h-8
	mov [eoicmd],al

	call resetbuf
	mov [rcv_ss],cs
			;init
	mov dx,[port]
	add dx,4
	mov al,0
	out dx,al	;+4
	inc dx
	in al,dx	;+5
	mov dx,[port]
	in al,dx	;+0
	add dx,6
	in al,dx	;+6

	call calcbaud	;set baudiv

	mov al,byte [comint]
	mov ah,35h
	int 21h
	mov [oldirq+0],bx
	mov [oldirq+2],es
	mov es,ax,cs
	mov dx,irq
	mov al,[comint]
	mov ah,25h
	int 21h
			; init irq
	cli
	mov ah,0FEh
	mov cl,[comirq]
	rol ah,cl
	in al,21h
	and al,ah
	out 21h,al
	mov dx,[port_IER]
	mov al,5
	out dx,al ;IER
	add dx,3
	mov al,0Bh
	out dx,al ;MCR
	sti

	mov ah,7
	pushf
	push cs
	call pktdrvr	;reset pktdrvr

	call transmit

	mov al,[pktint]
	mov ah,25h
	mov dx,pktdrvr
	int 21h

	call wrpars

	mov es,[2Ch]
	mov ah,49h
	int 21h		;release environment

	mov ax,3100h
;	mov dx,(install+15)/16
mov dx,install+15
shr_ dx,4
	int 21h 	;install as TSR

coopt.e1:
	mov bx,txcnp
	jmp insterr

coopt:
	cmp byte [comnr],0
	jz .o4
	cmp word [port],-1
	jnz .e1 ;p&c

.o1:	cmp byte [comirq],-1
	jnz .o2

	mov ah,[comnr]
	dec ah
	and ah,1
	mov al,4
	sub al,ah
	mov [comirq],al

.o2:	push es
	mov es,ax,40h
	mov bx,[comnr]
	dec bx
	add bx,bx
	mov ax,[es:bx]
	pop es
	test ax
	jz .e2
	mov [port],ax
.r	ret

.e2:	mov bx,txnport
	mov al,byte [comnr]
	dec al
	add [bx+3],al
	jmp insterr

.o3:	mov byte [comnr],2
	jmp .o1

.o4:	cmp word [port],-1
	jz .o3
	cmp byte [comirq],-1
	jnz .r
		;no irq
.e3:	mov bx,txnirq
	jmp insterr

calcbaud:
	cmp word [baud+2],0
	jnz .b
	cmp word [baud+0],150
	if c, mov word [baud+0],150
	cmp word [baud+0],57600
	ja .b
	mov ax,49664
	mov dx,1
	div word [baud]
	mov [baudiv],ax
	cmp ax,1
	mov bx,ax
	mov dx,1
	mov ax,49664
	div bx
	mov word [baud],ax
	ret

.b	mov ax,1
	mov [baudiv],ax
	mov [baud+2],ax
	mov word [baud+0],49664
	ret

chkuart:
	mov dx,[port]
	add dx,3
	mov al,1Bh
	out dx,al
	in al,dx
	cmp al,1Bh
	jnz i_UartNotFound
	mov al,3
	out dx,al
	in al,dx
	cmp al,3
	jnz i_UartNotFound

		;UART found
	add dx,7-3
	mov al,0A5h
	out dx,al
	in al,dx
	cmp al,0A5h
	jnz .r

	sub dx,7-2
	mov al,1
	out dx,al
	in al,dx
	mov bh,al
	mov al,0
	out dx,al ;?
	and bh,11000000b
	cmp bh,11000000b
	mov ax,16450
	jnz .r

	mov ax,16550 ;16550+
.r	mov [uarts],ax
	ret

i_UartNotFound:
	mov bx,txnut
	jmp insterr

			;check fifo (even if it's 8250)
chkfifo:
	mov dx,[port_LCR]
	mov al,bit7
	out dx,al
	mov dx,[port]
	mov al,12
	out dx,al
	inc dx
	mov al,0
	out dx,al	;9600 baud

	mov dx,[port_LCR]
	mov al,000000011b
	out dx,al	;8n1

	inc dx	;MCR
	mov al,bit4
	out dx,al	;loop

	mov dx,[port_FCR]
	mov al,0xC7
	out dx,al	;fifo

	mov al,0
	mov dx,[port]
	mov cx,64
.0:	out dx,al
	inc al
	loop .0

.1:	call .c
	jz .1

	mov dx,[port]
	mov al,-1
	out dx,al

.2:	call .c
	mov dx,[port_LSR]
	in al,dx
	test al,bit6
	jz .2

	mov dx,[port_IDR]
	inc dx	;MCR
	mov al,0
	out dx,al

	cmp cl,1
	adc cl,0
	mov [txFifo],cx
	ret

.c:	mov dx,[port_LSR]
	in al,dx
	test al,bit0
	jz .ret
	mov dx,[port]
	in al,dx
	cmp al,cl
	jnz .ret
	inc cx
.ret	ret


insterr:
	write txerr
	mov si,bx
	call wascii
	write crlf
	mov ax,4C01h
	int 21h

txnut db 'no UART detectet at specified location',0
txcnp db 'both com and port specified',0
txnport db 'com1: no such device',0
txnirq db 'irq not set',0
txval db 'value out of range',0
txnval db 'value not set',0
txerr: db 'error: ',0
txbid: db 'wrong id',0

;====================================== parameters
parlst: db 'com',1
	db 'baud=',1
	db 'nodes=',1
	db 'port=',1
	db 'irq=',1
	db 'int=',1,1

paradr: dw p_com,p_baud,p_num,p_port,p_irq,p_int

args:
	mov si,80h
	lodsb
	cbw
	mov bx,ax
	mov [si+bx],bh

.2:	lodsb
	dec al
	cmp al,32
	jc .2
	inc al
	jz .c

	dec si
	cmp byte [si+1],' '
	ja .a
	cmp byte [myid],0
	jnz .e

	and al,~32
	cmp al,'A'
	jc erid
	cmp al,'Z'
	ja erid
	mov [myid],al
	inc si
	jmp .2

.a:	mov dx,si
	mov bx,paradr
	mov di,parlst
	mov al,1
	mov cx,-1

.0	repz cmpsb
	cmp [di-1],al
	jz .b
	mov si,dx
	add bx,2
	repnz scasb
	cmp [di],al
	jnz .0

.e:	push si
	write txsnx
	pop si
	mov al,' '
.1:	mov dl,al
	mov ah,2
	int 21h
	lodsb
	cmp al,' '
	ja .1
	mov ax,4C00h
	int 21h

.b	dec si
	call [bx]
	jmp .2

.c	cmp byte [myid],0
	jnz p_com.r
	jmp help

txsnx: db 'syntax error:',0

erid:	mov bx,txbid
	jmp insterr

p_com:	call rdecd
	test dx
	jnz erval
	cmp ax,4
	ja erval
	mov [comnr],ax
.r:	ret

erval:	mov bx,txval
	jmp insterr

p_baud:	call rdecd
	cmp byte [si],'k'
	jz .a
	test dx
	jnz .b
	cmp ax,150
	jnc .b
	dec si
.a:	inc si
	test dx
	mov dx,2
	jnz .b
	mov dx,1000
	mul dx
.b:	mov [baud+0],ax
	mov [baud+2],dx
	ret

p_port:	call rhexw
	mov [port],ax
	ret

p_irq:	call rdecb
	cmp al,8
	jnc erval
	mov [comirq],al
	ret

p_num:	call rdecb
	dec ax,ax
	cmp ax,16
	jae erval
	mov [ttl],al
	ret

p_int:	call rhexw
	test ah
	jnz erval
	mov [pktint],al
	ret

rdecb:	call rdecw
	test ah
	jnz erval
	ret

rdecw:	call rdecd
	test dx
	jnz erval
	ret

rdecd:	call rdecc
	jc .e2
	mov cx,ax
	xor dx,dx
.0:	call rdecc
	jc .r
	push ax,dx
	mov ax,10
	mul cx
	mov cx,ax
	mov bx,dx
	pop dx
	mov ax,10
	mul dx
	test dx
	jnz .e1
	mov dx,bx
	add dx,ax
	pop bx
	add cx,bx
	adc dx,0
	jnc .0
.e1:	jmp erval

.e2:	mov bx,txnval
	jmp insterr

.r:	dec si
	mov ax,cx
	ret

rdecc:	lodsb
	sub al,'0'
	jc .r
	cmp al,10
	cmc
	jc .r
	cbw
.r	ret


rhexw:	call rhexc
	jc rdecd.e2
	cbw
	mov cx,ax
.0:	call rhexc
	jc rdecd.r
	test ch,0F0h
	jnz rdecd.e1
	shl_ cx,4
	add cl,al
	jmp .0

rhexc:	lodsb
	sub al,'0'
	jc .r
	cmp al,10
	jc .h
	cmp al,'a'-'0'
	if ae, sub al,32
	cmp al,'A'-'0'
	jc .r
	cmp al,'F'-'0'+1
	cmc
	jc .r
	sub al,'A'-'0'-10
.h:	clc
.r	ret

;====================================== info

wrpars:
	write crlf
	cmp byte [comnr],0
	jz .a
	write txcom
	mov dl,[comnr]
	add dl,'0'
	mov ah,2
	int 21h
	mov dl,' '
	int 21h
.a:	write txuart
	xor dx,dx
	mov ax,[uarts]
	call wdecw
	write txport
	mov ax,[port]
	call whexw
	write txirq
	mov al,[comirq]
	call wdecb
	write txbaud
	mov ax,[baud+0]
	mov dx,[baud+2]
	call wdecd
	write txfifo
	mov ax,[txFifo]
	call wdecw

	write txint
	mov al,[pktint]
	call whexb
	write txid
	mov dl,[myid]
	mov ah,2
	int 21h
	write txttl
	mov al,[ttl]
	call wdecb
	write txeth
	call wrieth
	write crlf
	ret

%define dig2(x) ('0'+(x)/10 % 10),('0'+(x) % 10)

txinf: db 13,10,'ComRing ',MAJOR+'0','.',dig2(MINOR)
%ifdef BETA
db 'b',BETA+'0'
%endif
db '  serial line packet driver  freeware by Jan Bobrowski 1997,8',13,10,36
txid: db ' id=',0
txttl: db ' ttl=',0
txeth: db 13,10,'ethernet address: ',0
txcom: db 'com',0
txuart: db 'uart=',0
txport: db ' port=',0
txfifo: db ' fifo=',0
txirq: db ' irq=',0
txbaud: db ' baud=',0
txint: db 13,10,'int=',0
crlf: db 13,10,0

wrieth:
	mov al,[myid]
	mov di,sendbuf
	mov si,di
	call genetha
	mov cx,6
	jmp .a

.1:	mov dl,':'
	mov ah,2
	int 21h
.a:	lodsb
	call whexb
	loop .1
	ret

wzero:	mov ah,2
	mov dl,'0'
	int 21h
	ret

wdecb:	mov ah,0
wdecw:	xor dx,dx
wdecd:	test ax
	jnz .a
	test dx
	jz wzero
.a:	mov bx,10000
	div bx
	mov bl,0
	push dx
	call .b
	pop ax

.b:	mov dl,100
	div dl
	push ax
	call .c
	pop ax
	mov al,ah

.c:	aam
	mov dx,'00'
	add dx,ax
	xchg dh,dl
	mov ah,2
	call .d
	mov dl,dh
.d:	cmp dl,'0'
	jnz .e
	test bl
	jz .r
.e:	mov bl,dl
	int 21h
.r	ret

whexw:	cmp ax,1000h
	jnc .a
	push ax
	xchg ah,al
	mov bx,hexdig
	xlatb
	mov dl,al
	mov ah,2
	int 21h
	jmp .b

.a:	push ax
	mov al,ah
	call whexb
.b:	pop ax

whexb:
	aam 16
	mov bx,hexdig
	xlatb
	xchg ah,al
	xlatb
	mov dx,ax
	mov ah,2
	int 21h
	mov dl,dh
	int 21h
	ret

hexdig: db '0123456789ABCDEF'

wascii.0:
	mov ah,2
	mov dl,al
	int 21h
wascii:	lodsb
	test al
	jnz .0
	ret

;====================================== help

help:	write txhelp
	mov ax,4C02h
	int 21h

txhelp:	db 13,10
db 'syntax:  comring id [parameter]...',13,10
db 'id: single letter identifying your computer (A..Z)',13,10
db 'parameters:'
db	 '	com#	com port [2] (or port=# irq=#)',13,10
db '		baud=#	baud rate [115200]',13,10
db '		nodes=#	max number of computers [3]',13,10
db '		int=#	interrupt for packet driver (hex) [60]',13,10
db 0

