#ifndef __COMPACT__
#error Compact model!
#endif
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>

#define cli __emit__(0xFA)
#define sti __emit__(0xFB)

struct Stat
{
	unsigned long packets_in;
	unsigned long packets_out;
	unsigned long bytes_in;
	unsigned long bytes_out;
	unsigned long errors_in;
	unsigned long errors_out;
	unsigned long packets_lost;
};

struct Param
{
	unsigned char major_rev;
	unsigned char minor_rev;
	unsigned char length;
	unsigned char addr_len;
	unsigned short mtu;
	unsigned short multicast_aval;
	unsigned short rcv_bufs;
	unsigned short xmt_bufs;
	unsigned short int_num;
};

struct UartConf
{
	unsigned uart;
	unsigned port;
	unsigned io8250;
	unsigned char irq;
	unsigned char pattr;
	unsigned char clrbda;
	unsigned char rtscts;
	unsigned long baud;
	unsigned bauddiv;
};

struct TypeEntry
{
	unsigned short handle;
	unsigned short type;
	void far* upcall;
};

struct TypeTable
{
	short maxentries;
	short currentmode;
	struct TypeEntry table[1];
};

struct Regs
{
	unsigned char r_al,r_ah;
	unsigned r_bx, r_cx, r_dx;
	unsigned r_bp, r_si, r_di;
	unsigned r_ds, r_es, r_flags;
} R;

#define al R.r_al
#define ah R.r_ah
#define bx R.r_bx
#define bl (R.r_bx&0xFF)
#define bh (R.r_bx>>8)
#define cx R.r_cx
#define ch (R.r_cx>>8)
#define dx R.r_dx
#define bp R.r_bp
#define si R.r_si
#define di R.r_di
#define es R.r_es
#define ds R.r_ds
#define flags R.r_flags
#define dssi MK_FP(R.r_ds,R.r_si)
#define esdi MK_FP(R.r_es,R.r_di)

int pktint;
int allow_alloc=0;
int print_clients=0;

int pkt(int f)
{
	ah=f;
	intr(pktint,(struct REGPACK*)&R);
	if(flags&1)
		return dx>>8;
	return 0;
}

#define S "\t  "
#define ErrTmpl S "error fn.%d - BAD HANDLE (old driver)\n"

char* func[]={"basic","extended","?","?","high-perf","high-perf&extended"};

char* getfunc(int f)
{
	if(f<=0||f>6) return "?";
	return func[--f];
}

char* frameid(int p)
{
	static char id[4];
	id[0]='5'+(p&3);
	id[1]=(p&8)?(p&16)?'e':'o':'n';
	id[2]=(p&4)?'2':'1';
	id[3]=0;
	return id;
}

char* className(int c)
{
	char* t[]={"\1ether","\6slip","\13803.2","\15x.25","\20ppp (no lcp)","\22ppp",0},**p=t;
	do {
		if(**p==c) return *p+1;
		p++;
	} while(*p);
	return 0;
}

int pktInfo(int i)
{
	int err;
	int addrlen=0;
	char* cn;
	char far* ss=*(char far* far*)MK_FP(0,4*i);

	if(strcmp(ss+3,"PKT DRVR"))
		return 0;
	pktint=i;

	al=0xFF;
	err=pkt(1);
	if(al==0xFF)
		return 0;
	if(err) {
		if(err==1) printf(ErrTmpl,1);
		return 1;
	}

	cn=className(ch);
	
	printf("\n%-9s ver=%d.%d int=%02Xh class=",(char*)dssi,bh,bl,i);
	if(cn) printf("%s",cn);
	else printf("%d",ch);
	printf(" type=%d func=%s\n",dx,getfunc(al));
	if(ch==1)
		addrlen=6;

	err=pkt(10);
	if(!err) {
		struct Param* p=(struct Param*)esdi;
		int ii=p->int_num;
		printf(S "specification=%d.%d mtu=%d postEOIint=",
			p->major_rev,p->minor_rev,p->mtu);
		printf(ii?"%02Xh":"none",ii);
		if(ii>=8&&ii<16) printf(" (irq=%d)",ii-8);
		if(ii>=0x70&&ii<0x78) printf(" (irq %d)",ii-0x70+8);
		putchar('\n');
		addrlen=p->addr_len;
	}

	bx=10;
	err=pkt(30);
	if(!err) {
		struct UartConf u;
		cli; memcpy(&u,dssi,sizeof(u)); sti;
		printf(S);
		if(u.port) printf("com%d ",u.port);
		printf("uart=%d io=%03X irq=%d baud=%ld frame=%s\n",
			u.uart,u.io8250,u.irq,u.baud,frameid(u.pattr));
		//printf(S"pattr=%d clrbda=%d rtscts=%d\n",u.pattr,u.clrbda,u.rtscts);
	}

	if(addrlen) {
		unsigned char addr[256];
		cx=addrlen;
		es=FP_SEG(addr);
		di=FP_OFF(addr);
		err=pkt(6);
		if(err==1) printf(ErrTmpl,6);
		else {
			int n;
			printf(S "address=%02X",addr[0]);
			for(n=1;n<addrlen;n++) printf(":%02X",addr[n]);
			printf("\n");
		}
	}
	return 1;
}

int pktStat()
{
	int err;
	struct Stat s;
	int h=0xFFFF;

	err=pkt(24);
	if(err==1) {
		if(allow_alloc) {
			al=1; /**/
			bx=-1; dx=1;
			cx=2; ds=FP_SEG(&h); si=FP_OFF(&h);
			es=di=0;
			cli;
			if(0==pkt(2)) {
				bx=h=ah<<8|al;
				err=pkt(24);
				bx=h;
				pkt(3);
			}
			sti;
		}
		if(err) {	
			printf(ErrTmpl,24);
			return 0;
		}
	}

	if(err) {
		printf(S "no statistics\n");
		return 0;
	}

	cli; memcpy(&s,dssi,sizeof s); sti;
	printf(S "RX packets:%lu bytes:%lu errors:%lu lost:%lu\n",
		s.packets_in,s.bytes_in,s.errors_in,s.packets_lost);
	printf(S "TX packets:%lu bytes:%lu errors:%lu\n",
		s.packets_out,s.bytes_out,s.errors_out);

	return 1;

}

#define wordAt(S,O) (*(unsigned*)MK_FP(S,O))
#define byteAt(S,O) (*(unsigned char*)MK_FP(S,O))

char* blkOwner(unsigned p)
{
	unsigned s;
	static char name[9];
	ah=0x52;
	intr(0x21,(struct REGPACK*)&R);
	s=wordAt(es,bx-2);
	if(p<s) return 0;
	for(;;) {
		unsigned ns=s+1+wordAt(s,3);
		if(p<ns) break;
		if(byteAt(s,0)==0x5A) return 0;
		s=ns;
	}
	p=wordAt(s,1);
	if(p==0||p==8) return 0;
	strncpy(name,MK_FP(p-1,8),8);
	return name;
}

int pktHandles()
{
	int n,l,ce=0;
	struct TypeEntry *t;

	printf("\n" S "clients:");

	bx=13;
	if( pkt(30) ) {
		printf(" no information\n");
		return 0;
	}
	t=((struct TypeTable*)dssi)->table;
	l=((struct TypeTable*)dssi)->maxentries;

	for(n=0;n<l;n++,t++) {
		int m;
		char* o;
		if(t->handle==0) continue;
		if(ce) printf("\t\t  ");
		printf("%5d: ",t->handle);
		if(t->type!=0xFFFF) printf("%04X",(t->type>>8)|(t->type<<8));
		else printf("****");
		o=blkOwner(FP_SEG(t->upcall));
		if(!o) o="";
		printf("  %-8s  %p",o,t->upcall);
		putchar('\n');
		ce++;
	}
	if(ce==0) printf(" none\n");

	return 1;
}

int lookPD(int i)
{
	pktint=i;
	if( !pktInfo(i) ) return 0;
	pktStat();
	if(print_clients) pktHandles();
	return 1;
}

void xhelp()
{
	printf("PDstat - dump Packet Driver statistics - freeware by Jan Bobrowski 1997,8\n"
	       "usage: pdstat [-ca] [int]\n"
	       "  -c  list clients\n"
	       "  -a  allow temporary type allocation (when BAD HANDLE)\n");
	exit(1);
}

main(int argc,char** arg)
{
	int i,n=0;
	arg++; argc--;
	while(argc>=1 && **arg=='-') {
		arg[0]++;
		do switch(**arg) {
			case 'c': print_clients=1; break;
			case 'a': allow_alloc=1; break;
			default: xhelp();
		} while(*++*arg);
		arg++; argc--;
	}
	if(argc>1) xhelp();
	if(argc==1) {
		if(0==sscanf(*arg,"%X",&i)) xhelp();
		else n=lookPD(i);
	} else
		for(i=0x20;i<=0xFF;i++) n+=lookPD(i);
	if(n==0) printf("Packet Driver not found.\n");
	return 0;
}

