;!nasm -f bin -o crtest.com -w-macro-params
%include "jb.def"

%define PKTSIZE 256

%macro intpkt 0
call _intpkt
%endm

	org 100h

start:	mov dx,int23h
	mov ax,2523h
	int 21h
	call findCR
	jnc .i

	mov dx,txncr
.err:	mov ah,9
	int 21h
	mov ax,4C01h
	int 21h

.i:	call getad

	mov bx,32768
	mov ah,30
	intpkt
	jc .n
	add si,'A'
	mov [cs:crn+0],si
	mov [cs:crn+2],ds
	mov ds,ax,cs
.n:
	mov ax,0201h
	mov bx,-1
	mov dl,1
	;mov si,?
	xor cx,cx
	mov di,receiver
	intpkt
	jnc .i2

	mov dx,txnhd
	jmp .err

.i2:	mov [handle],ax

	mov dx,txrx
	mov ah,9
	int 21h
	call getcur
	call draw

.0:	int 28h
	call send
	call sync
	jz .0
	call chkcrn
	call dcolors
	call inout
	mov ah,1
	int 16h
	jz .0
	mov ah,0
	int 16h

	mov ah,3
	mov bx,[handle]
	intpkt

	mov es,ax,cs
	mov di,iocb
	mov ah,13
	intpkt

	mov cx,5
.1:	push cx
	call wait1
	call dcolors
	pop cx
	loop .1

	call inout
	call wsrcs

	mov ax,4C00h
	int 21h
ret

handle dw 0
rcvd dd 0
sent dd 0

receiver:
	cmp ax,1
	jz .r1

	mov es,di,cs
	mov di,rbuf
	retf

.r1:	mov al,[rbuf+6+5]
	mov dl,al
	mov dh,[cs:rcclr]
	sub al,'A'
	les di,[cs:scrline]
	cbw
	mov bx,ax
	mov byte [cs:bx+rctab],7
	mov byte [cs:bx+rctabf],1
	add bx,bx
	mov [es:di+bx],dx
	add word [cs:rcvd+0],byte 1
	adc word [cs:rcvd+2],byte 0
	retf

transmitter:
	add word [cs:sent+0],byte 1
	adc word [cs:sent+2],byte 0
	retf

chkcrn:	mov ax,[crn]
	or ax,[crn+2]
	jz .ret

	les di,[scrline]
	mov bp,rctab
	lds si,[crn]
	mov bl,'A'
	mov cx,'Z'-'A'+1
.0	lodsb
	test al,1
	jz .a
	and byte [si-1],~1
	mov al,[bp]
	sub al,4
	cmp al,8-4
	jc .a
	mov byte [bp],15
	mov [es:di],bl
.a:	inc bp,bl,di,di
	loop .0
	mov ds,ax,cs

.ret	ret

dcolors:
	mov bx,[colors]
	les di,[scrline]
	inc di
	mov si,rctab
	mov cl,'A'
.0:	cmp cl,[node]
	jz .c
	mov al,[si]
	mov ah,al
	xlatb
	mov [es:di],al
	test ah,7
	jz .c
	dec ah
	mov [si],ah
.c:	inc si,di,di
	inc cl
	cmp cl,'Z'
	jbe .0
	ret

send:	mov di,iocb1
	call .s
	mov di,iocb2

.s	test byte [di+iocb.flags],1
	jz .ret

	mov es,ax,cs
	mov [di+iocb+2],ax
	mov [di+iocb.upcall+2],ax
	mov byte [di+iocb.flags],2

	mov ah,12
	intpkt

.ret	ret

getad:
	mov es,ax,cs
	mov di,addr
	mov cx,6
	mov ah,6
	intpkt
	mov al,[addr+5]
	mov [node],al
	ret

draw:
	les di,[scrline]
	mov cx,'Z'-'A'+1
	cld

	mov ax,[crn]
	or ax,[crn+2]
	jz .n

	lds si,[crn]
	mov bl,'A'
	mov ah,01h

.0	and byte [si],~1
	lodsb
	test al,10h
	mov al,'.'
	if nz,mov al,bl
	stosw
	inc bl
	loop .0	

	mov ds,ax,cs
.n
	mov ax,0100h|''
	rep stosw

	mov al,[node]
	mov bl,al
	sub bl,'A'
	mov bh,0
	mov ah,[myclr]
	add bx,bx
	les di,[scrline]
	mov [es:di+bx],ax
	ret

time db 0

sync:	mov es,ax,0040h
	mov al,[es:006Ch]
	cmp al,[time]
	mov [time],al
	ret

wait1:	call sync
	jz wait1
	ret

findCR:
.0:	mov al,[_intpkt+1]
	mov ah,35h
	int 21h
	add bx,3
	mov di,bx
	mov si,txpkt
	mov cx,8
	repz cmpsb
	jnz .nf

	mov ax,01FFh
	intpkt
	jc .nf
	inc al
	jz .nf
	mov es,ax,cs
	mov di,txcri
	mov cx,7
	repz cmpsb
	jz .fnd

.nf:	inc byte [_intpkt+1]
	jnz .0
	stc
	mov ds,ax,cs
	ret

.fnd:	clc
	mov ds,ax,cs
	ret

txpkt: db 'PKT DRVR',0
txcri: db 'ComRing',0

_intpkt:
	int 0
	ret

getcur:
	mov ah,0Fh
	int 10h
	push ax
	cmp al,7
	jnz .g1
	mov byte [scrline+3],0B0h

	mov [myclr],ax,[m_myclr]
	mov word [colors],mono

.g1:	mov ah,3
	int 10h
	pop ax
	add dx,0FF05h
	mov al,ah
	mul dh
	mov dh,0
	add ax,dx
	add ax,ax
	mov [scrline],ax
	ret

wsrcs:	mov dx,txsrc
	mov ah,9
	int 21h
	mov cl,0
	mov si,rctabf
	mov dl,'A'
	mov ah,2
.0:	lodsb
	add cl,al
	test al
	if nz, int 21h
	inc dl
	cmp dl,'Z'
	jbe .0
	test cl
	mov dx,crlf
	mov ah,9
	int 21h
	ret

txsrc: db 13,10,'rcvd from: $'
txout: db 13,'out: $'
txin: db ' in: $'

inout:	mov dx,txout
	mov ah,9
	int 21h
	cli
	mov ax,[sent+0]
	mov dx,[sent+2]
	sti
	call wdecd
	mov dx,txin
	mov ah,9
	int 21h
	mov ax,[rcvd+0]
	mov dx,[rcvd+2]

wdecd:	test ax
	jnz .w1
	test dx
	jz  .w0
.w1:	mov bx,10000
	div bx
	mov bl,0
	push dx
	call .w2
	pop ax

.w2:	mov dl,100
	div dl
	push ax
	call .w3
	pop ax
	mov al,ah

.w3:	aam
	mov dx,'00'
	add dx,ax
	xchg dh,dl
	mov ah,2
	call .w4
	mov dl,dh
.w4:	cmp dl,'0'
	jnz .w5
	test bl
	jz .ret
.w5:	mov bl,dl
	int 21h
.ret	ret

.w0:	mov ah,2
	mov dl,'0'
	int 21h
	ret

int23h:
	push ax,bx,cx,dx,si,di,es
	mov bx,[cs:handle]
	test bx
	jz .i
	mov ah,3
	intpkt
.i:	mov es,ax,cs
	mov di,iocb
	mov ah,13
	intpkt
	pop es,di,si,dx,cx,bx,ax
	stc
	retf

struc iocb
.buffer	resd 1
.length	resw 1
.flags	resb 1
.code	resb 1
.upcall	resd 1
.reserv	resb 4
.nx	resd 1
.crflg	resb 1
endstruc

iocb1:	dw sbuf,0
	dw PKTSIZE
.flags	db 1,0
.upcall	dw transmitter,0
	dd 0,0,0

iocb2:	dw sbuf,0
	dw PKTSIZE
.flags	db 1,0
.upcall	dw transmitter,0
	dd 0,0,0

scrline dd 0B8000000h
crn:	dd 0

sbuf:	db -1,-1,-1,-1,-1,-1
	db 0,0,0,0,0,0
	dw 0

rctab:	times 'Z'-'A'+1 db 0
rctabf:	times 'Z'-'A'+1 db 0

colors dw clrtab

clrtab:	db 01,01,01,01,08,04,0Ch,0Eh
	;db 01,01,01,01,08,02,02,0Ah,0Bh
	db 01,01,01,01,09,09,09,0Bh
mono:	db 07,07,07,07,0Fh,0Fh,0Fh,1Fh
	db 07,07,07,07,01,01,01,01

myclr	db 09h
rcclr	db 0Fh

m_myclr	db 10h
m_rcclr	db 1Fh

txncr: db 'ComRing not found',13,10,36
txnhd: db "Can't get a handle",13,10,36

txrx:	db 13,10,'Your node: '
node	db '?',13,10
;	db 'Nodes from which packets are being received',13,10
	db 'Rx:'
crlf:	db 13,10,'$'

segment .bss

addr resb 6
rbuf resb 1514
