/**************************************************************************
 * bakapi.c by sparky4                                                    *
 * based on pixel.c                                                       *
 * pixel.c                                                                *
 * written by David Brackeen                                              *
 * http://www.brackeen.com/home/vga/                                      *
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>

#define VIDEO_INT           0x10      /* the BIOS video interrupt. */
#define WRITE_DOT           0x0C      /* BIOS func to plot a pixel. */
#define SET_MODE            0x00      /* BIOS func to set the video mode. */
#define VGA_256_COLOR_MODE  0x13      /* use to set 256-color mode. */
#define TEXT_MODE           0x03      /* use to set 80x25 text mode. */

#define SW                  320       /* width in pixels of mode 0x13 */
#define SH                  200       /* height in pixels of mode 0x13 */
#define NUM_COLORS          256       /* number of colors in mode 0x13 */

#define BONK        400

typedef unsigned char  byte;
typedef unsigned short word;

// switch variables
int bakax=0, bakay=0;
// plot point variables
int x=0, y=0;

/**************************************************************************
 *  set_mode                                                              *
 *     Sets the video mode.                                               *
 **************************************************************************/
void set_mode(byte mode){
  union REGS regs;

  regs.h.ah = SET_MODE;
  regs.h.al = mode;
  int86(VIDEO_INT, &regs, &regs);
}

/**************************************************************************
 *  plot_pixel_slow                                                       *
 *    Plot a pixel by using BIOS function 0x0C (Write Dot).               *
 **************************************************************************/
void plot_pixel_slow(int x,int y,byte color){
  union REGS regs;

  regs.h.ah = WRITE_DOT;
  regs.h.al = color;
  regs.x.cx = x;
  regs.x.dx = y;
  int86(VIDEO_INT, &regs, &regs);
}

// king_crimson's code
void plot_pixel_fast(unsigned long x, unsigned long y, byte color) {
  byte far *vidptr;
  vidptr = (byte far *)(0xA0000000L + y*SW + x);
  *vidptr = color;
}

/*-----------ding-------------*/
void ding(int q){
  int d3y,color;
  word i;

  color=rand()%NUM_COLORS;

  for(i=0;i<BONK;i++){ // the number variable make the colors more noticable
    if(q==1){
      if(x==SW){bakax=0;}
      if(x==0){bakax=1;}
      if(y==SH){bakay=0;}
      if(y==0){bakay=1;}
    }else if(q==3){
      if(x!=SW||y!=SH){
        if(x==0){bakax=1;bakay=-1;d3y=1;}
        if(y==0){bakax=1;bakay=0;d3y=1;}
        if(x==SW){bakax=-1;bakay=-1;d3y=1;}
        if(y==SH){bakax=1;bakay=0;d3y=1;}
      }else if(x==SW&&y==SH) x=y=0;
    }
    if(q==3){
      if(d3y){
        if(bakay<0){
          y--;
          d3y--;
        }else
        if(bakay>0){
          y++;
          d3y--;
        }
      }
      if(bakax<0){
        x--;
      }else
      if(bakax>0){
        x++;
      }
    }else{
      if(!bakax){
        x--;
      }else{
        x++;
      }
      if(!bakay){
        y--;
      }else{
        y++;
      }
    }
    // plot the pixel
    plot_pixel_fast(x,y,color);
    if(q==2) plot_pixel_fast(rand()%SW,rand()%SH,0);
    if(q==2||q==4){
      bakax=rand()&0x1;
      bakay=rand()&0x1;
    }
  }
}

/*-----------Main-------------*/
void main(){
  int key,d;
  // main variables
  d=1; // switch variable
  key=4; // default screensaver number

  set_mode(VGA_256_COLOR_MODE);       /* set the video mode. */

  // screen savers
  while(d!=0){ // on!
    if(!kbhit()){ // conditions of screen saver
      ding(key);
    }else{
      set_mode(TEXT_MODE);                /* set the video mode back to text mode. */
      // user imput switch
      printf("Enter 1, 2, 3 or 4 to run a screensaver, or enter 5 to quit.\n", getch());  // prompt the user
      scanf("%d", &key);
      if(key==3){x=y=0;} // crazy screen saver wwww
      if(key==5) d=0;
      set_mode(VGA_256_COLOR_MODE);       /* set the video mode. */
    }
  } // else off
  set_mode(TEXT_MODE);                /* set the video mode back to text mode. */
  printf("bakapi ver. 1.0 is made by sparky4~ feel free to use it ^^\nLicence: GPL");

  return;
}
