--thanks to everyone who helped me with the code --mary4
--http://forums.kleientertainment.com/topic/67141-winnie-the-mauderer-refinement/ && http://forums.kleientertainment.com/topic/85956-winnie-the-mauderer-refinement-2/
--arigatou kure-kun~ for balance advice!, Nerune for adding the damage multiplier code and fixing the knife bug!, and Hekkaryk for the config stuff <3
--licence is GNU LGPLv3 i think?? wwww

local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
	Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {
	"knife_winnie"
}

-- Custom starting items
local start_inv = {
	"knife_winnie"
}

local function SanityDelta(inst, data)
	if inst.components.sanity and inst.components.combat then
		local sanity = inst.components.sanity:GetPercent()
		inst.components.combat.damagemultiplier = ((1+TUNING.winnie_global_vars.co_dm) - sanity)
	end
end

--sanity wwww
local function resetbloodlust(inst)
	inst.crazytime = 240 * math.random(1,4)-- 1 day = 480s
--	print(string.format("[winnie|resetbloodlust()] inst.bloodlust=%s	inst.requirekills=%s	dapperness=%s",
--		tostring(inst.bloodlust), tostring(inst.requirekills), tostring(inst.components.sanity.dapperness)))
	if inst.bloodlust then
		inst.bloodlust:Cancel()
		inst.bloodlust = nil
	end
	if inst.requirekills then
		inst.requirekills = nil
		inst.components.sanity.dapperness = inst.components.sanity.dapperness + inst.sanitydap
		inst.components.sanity.neg_aura_mult = inst.components.sanity.neg_aura_mult + inst.sanitydap
		if inst.revivemute==0 then
			inst.components.talker:Say("Much better!~")
		else
			inst.revivemute=0
		end
	end
	inst.bloodlust = inst:DoTaskInTime(inst.crazytime,
		function()
			inst.components.sanity.dapperness = inst.components.sanity.dapperness - inst.sanitydap
			inst.components.sanity.neg_aura_mult = inst.components.sanity.neg_aura_mult - inst.sanitydap
			inst.requirekills = true
			if inst.revivemute==0 then
				inst.components.talker:Say("I NEED TO KILL!!")
			else
				inst.revivemute=0
			end
		end)
end

local function OnIsFullmoon(inst, isfullmoon)
	if isfullmoon then
		--inst.components.sanity.rate_modifier = 8
		inst.components.sanity.night_drain_mult = 8--(inst.sanitydap)
		inst.components.sanity.neg_aura_mult = 8--inst.sanitydap
	else
		inst.components.sanity.night_drain_mult = TUNING.WENDY_SANITY_MULT
		inst.components.sanity.neg_aura_mult = TUNING.WENDY_SANITY_MULT
	end
end

local function IsValidVictim(victim)
	return victim ~= nil
		and not (--??(not victim:HasTag("prey") and not victim:HasTag("hostile")) or
				victim:HasTag("veggie") or
				victim:HasTag("structure") or
				victim:HasTag("wall") or
				victim:HasTag("companion") or
				victim:HasTag("smashable"))
		and victim.components.health ~= nil
		and victim.components.combat ~= nil
end

local CRAZYBORN_STORE_TIME = 4
local CRAZYBORN_DECAY_TIME = 8
local CRAZYBORN_TRIGGER_THRESHOLD = 1

local function onattack(inst, data)
-- 	print(string.format("[winnie|onattack(%s,%s)]#1 data=%s",
-- 		tostring(inst), tostring(data), type(data) ~= "table" and "???" or tabletodictstring(data)
-- 	))
	local victim = data.target
	if not inst.components.health:IsDead() and IsValidVictim(victim) then
		local total_health = victim.components.health:GetMaxWithPenalty()
		local damage = data.weapon ~= nil and data.weapon.components.weapon.damage or inst.components.combat.defaultdamage
		local percent = (damage <= 0 and 0)
			or (total_health <= 0 and math.huge)
			or damage / total_health
		local pee
		if victim.components.combat.defaultdamage==0 then
			pee=4 * math.random(1,6)
		else
			pee=0
		end
		--math and clamp does account for 0 and infinite cases
		local delta = math.clamp(victim.components.combat.defaultdamage+pee * 0.25 * percent, .01, 2)

		--decay stored crazyborn
		if inst.crazyborn > 0 then
			local dt = GetTime() - inst.crazyborn_time - CRAZYBORN_STORE_TIME
			if dt >= CRAZYBORN_DECAY_TIME then
				inst.crazyborn = 0
			elseif dt > 0 then
				local k = dt / CRAZYBORN_DECAY_TIME
				inst.crazyborn = Lerp(inst.crazyborn, 0, k * k)
			end
		end
-- 		print(string.format("[winnie|onattack(%s,%s)]#2 total_health=%s, damage=%s, percent=%s, delta=%s, inst.crazyborn=%s",
-- 			tostring(inst), tostring(data), tostring(total_health), tostring(damage), tostring(percent), tostring(delta), tostring(inst.crazyborn)
-- 		))
		--store new crazyborn
		inst.crazyborn = inst.crazyborn + delta
		inst.crazyborn_time = GetTime()

		--consume crazyborn if enough has been stored
		if inst.crazyborn > CRAZYBORN_TRIGGER_THRESHOLD then
-- 			print(string.format("[winnie|onattack(%s,%s)]#3a apply crazyborn bonuses", tostring(inst), tostring(data)))
			if math.random(0,100)<TUNING.winnie_global_vars.co_hc then inst.components.health:DoDelta(inst.crazyborn*TUNING.winnie_global_vars.co_hr, false, "crazyborn") end
			if math.random(0,100)<TUNING.winnie_global_vars.co_sc then inst.components.sanity:DoDelta(inst.crazyborn*TUNING.winnie_global_vars.co_sr) end
			inst.crazyborn = 0
-- 		else
-- 			print(string.format("[winnie|onattack(%s,%s)]#3b crazyborn %s it not over threshold %s yet",
-- 				tostring(inst), tostring(data), tostring(inst.crazyborn), tostring(CRAZYBORN_TRIGGER_THRESHOLD)
-- 			))
		end
	end
end

local function ondeath(inst, deadthing, killer)
--	print(string.format("[winnie|ondeath(%s)]#1", tostring(inst)))
	if deadthing ~= nil and inst then --if player did not become pepperoni
		local _isneardeadthing = deadthing ~= nil and deadthing:IsValid() and inst:IsNear(deadthing, 16) or nil
		local _destdeadthing = deadthing ~= nil and deadthing:IsValid() and inst:IsValid() and inst:GetDistanceSqToInst(deadthing) or nil
		local _isnearkiller = killer ~= nil and killer:IsValid() and inst:IsNear(killer, 16) or nil
		local _destkiller = killer ~= nil and killer:IsValid() and inst:IsValid() and inst:GetDistanceSqToInst(killer) or nil
		--IsValidVictim(deadthing)=%s, deadthing:IsValid()=%s,
		--tostring(IsValidVictim(deadthing)),
-- 		print(string.format("[winnie|ondeath(%s,%s,%s)]#1 _isneardeadthing=%s, _destdeadthing=%s, _isnearkiller=%s, _destkiller=%s",
-- 			tostring(inst), tostring(deadthing), tostring(killer),
-- 			tostring(_isneardeadthing), tostring(_destdeadthing), tostring(_isnearkiller), tostring(_destkiller)
-- 		))
		if IsValidVictim(deadthing) and deadthing:IsValid() then
				if not inst:IsNear(deadthing, 16) then
--						print(string.format("[winnie|ondeath(%s,%s,%s)]#2 deadthing is not near inst", tostring(inst), tostring(deadthing), tostring(killer)))
						return
				elseif deadthing == inst then
						return
-- 				elseif killer == nil or not inst:IsNear(killer, 16) then
-- 						print(string.format("[winnie|ondeath(%s,%s,%s)]#3 killer is not near inst", tostring(inst), tostring(deadthing), tostring(killer)))
-- 						return
				end
				local pee
			if deadthing.components.combat.defaultdamage==0 then
				pee=4 * math.random(1,6)
			else
				pee=0
			end
			--math and clamp does account for 0 and infinite cases
			local delta = math.clamp(deadthing.components.combat.defaultdamage+pee * 0.50, .01, 2)--(deadthing.components.combat.defaultdamage)+pee
--			print(string.format("[winnie|ondeath(%s,%s,%s)]#4 delta=%s", tostring(inst), tostring(deadthing), tostring(killer), tostring(delta)))
			if math.random(0,100)<TUNING.winnie_global_vars.co_hc then inst.components.health:DoDelta(delta*TUNING.winnie_global_vars.co_hr) end
			if math.random(0,100)<TUNING.winnie_global_vars.co_sc then inst.components.sanity:DoDelta(delta*TUNING.winnie_global_vars.co_sr) end
		end
--	else
--		print(string.format("[winnie|ondeath(%s)]#5 deadthing is nil or winnie", tostring(inst)))
	end
	inst.crazyborn = 0
end

local function onkilled(inst, deadthing, killer)
--	print(string.format("[winnie|onkilled(%s)]#1", tostring(inst)))
	resetbloodlust(inst) -- inst being the player
	ondeath(inst, deadthing, killer)
end

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "esctemplate_speed_mod", 1)
	OnIsFullmoon(inst, TheWorld.state.isfullmoon)
	inst.revivemute = 1	--muting winnie when she gets revived~
	resetbloodlust(inst)
	inst.revivemute=0 --ok speak!
	inst:ListenForEvent("sanitydelta", function(inst, data) SanityDelta(inst, data) end, inst)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * TUNING.winnie_global_vars.co_rs)--1.02
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * TUNING.winnie_global_vars.co_rs)--1.02
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
	inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "winnie_speed_mod")
	inst:StopWatchingWorldState("isfullmoon", OnIsFullmoon)
	inst.revivemute = 1	--muting winnie when she gets pepperonied~
	--[[inst.crazytime=nil inst.bloodlust:Cancel() inst.bloodlust = nil inst.requirekills = nil	--turn off crazy time ww]]
	   inst:RemoveEventCallback("sanitydelta", function(inst, data) SanityDelta(inst, data) end, inst)
end

-- When loading or spawning the character
local function onload(inst)
	inst:WatchWorldState("isfullmoon", OnIsFullmoon)
	inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
	inst:ListenForEvent("ms_becameghost", onbecameghost)
	if inst:HasTag("playerghost") then
		onbecameghost(inst)
	else
		onbecamehuman(inst)
	end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst)
	inst:AddTag("crazy_killer")
	inst:AddTag("winnie")
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "winnie.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	inst:ListenForEvent("killed", function(player, data) onkilled(inst, data.victim, player) end)
	inst:ListenForEvent("onattackother", onattack)
	inst:ListenForEvent("death", function(player, data) ondeath(inst, data ~= nil and data.afflicter and inst or nil, player) end)--wank!! wwww
	inst:ListenForEvent("entity_death", function(wrld, data) ondeath(inst, data.inst) end, TheWorld)

	inst.crazyborn = 0
	inst.crazyborn_time = 0
	inst.sanitydap = 1 -- amount to increase/decrease dapperness
	inst.revivemute = 0 -- crazy time muting for dead of reviving

	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
	--inst.talker_path_override = "dontstarve_DLC001/characters/"

	-- Stats
	inst.components.health:SetMaxHealth(TUNING.winnie_global_vars.co_hp)
	inst.components.hunger:SetMax(TUNING.winnie_global_vars.co_hu)
	inst.components.sanity:SetMax(TUNING.winnie_global_vars.co_sa)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * TUNING.winnie_global_vars.co_rs)--1.02
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * TUNING.winnie_global_vars.co_rs)--1.02
	resetbloodlust(inst) -- inst being the player
	OnIsFullmoon(inst, TheWorld.state.isfullmoon)

	-- Damage multiplier (optional)
----	inst.components.combat.damagemultiplier = 1.32--1.75
--++	inst.components.combat.damagemultiplier = 2-(0.5*inst.components.sanity.current/40)

	-- Hunger rate (optional)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * TUNING.winnie_global_vars.co_ht)--1.2
----	inst.components.hunger.hungerrate = TUNING.winnie_global_vars.co_ht * TUNING.WILSON_HUNGER_RATE

	inst.OnLoad = onload
	inst.OnNewSpawn = onload
end

return MakePlayerCharacter("winnie", prefabs, assets, common_postinit, master_postinit, start_inv)
