local assets =
{
	Asset("ANIM", "anim/guetapens.zip"),
	Asset("ANIM", "anim/swap_guetapens.zip"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_guetapens", "guetapens")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("guetapens")
	inst.AnimState:SetBuild("guetapens")
	inst.AnimState:PlayAnimation("idle")

	inst:AddTag("sharp")
	inst:AddTag("pointy")

	inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE*0.75)

	-------

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(TUNING.NIGHTSWORD_USES*1.75)
	inst.components.finiteuses:SetUses(TUNING.NIGHTSWORD_USES*1.75)
	inst.components.finiteuses:SetOnFinished(inst.Remove)

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "guetapens"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/guetapens.xml"

	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.dapperness = TUNING.CRAZINESS_MED*0.75

	MakeHauntableLaunch(inst)

	MakeLargeBurnable(inst)

	return inst
end

return Prefab("knife_winnie", fn, assets)
