-- This information tells other players more about the mod
name = "Winnie"
description = "Adds Winnie the Marauder into your game."
author = "calamity dan & mary4"
version = "1.6.4.8b" -- This is the version of the template. Change it to your own number.

-- This is the URL name of the mod's thread on the forum; the part after the ? and before the first & in the url
--forumthread = "/topic/67141-winnie-the-mauderer-refinement/"
forumthread = "/topic/85956-winnie-the-mauderer-refinement-2/"

-- This lets other players know if your mod is out of date, update it to match the current version in the game
api_version = 10

-- Compatible with Don't Starve Together
dst_compatible = true

-- Not compatible with Don't Starve
dont_starve_compatible = false
reign_of_giants_compatible = false

-- Character mods need this set to true
all_clients_require_mod = true

icon_atlas = "modicon.xml"
icon = "modicon.tex"

-- The mod's tags displayed on the server list
server_filter_tags = {
"character",
"winnie",
"CRAZY",
}

local function option(_description, _data)
	if _description ~= nil and _data ~= nil then
		return {description = _description, data = _data}
	end
end

local function option_n(value, mult)
	local val = mult and mult or 0
	return option(value, value + val) -- there is no "GLOBAL" here, and "tonumber(string)" is nil
end

-- returns set of options from min to max by step - skips overhead if it's not reached in step (last returned option will always be below max)
local function options_range(min, max, step, mult)
    local array = {}
    local index = 1
    for i = min, max, step do
        array[index] = option_n(i, mult)
        index = index + 1
    end
    return array
end

local function field(name, label, hover, options, default)
	return {
		name = name,
		label = label,
		hover = hover,
		options = options,
		default = default
	}
end

configuration_options = {
	field("co_hp","Health","Max health of Winnie",options_range(40, 4000, 10),150),
	field("co_hu","Hunger","Max hunger of Winnie",options_range(40, 4000, 10),150),
	field("co_sa","Sanity","Max sanity of Winnie",options_range(40, 4000, 10),80),
--	field("co_dm","Damage multiplier","Damage multiplier of Winnie",options_range(0.1, 4, 0.1, 10),1.2),	--TUNING.WATHGRITHR_DAMAGE_MULT == 1.2
--	field("co_hr","Health regeneration multiplier","Health regeneration multiplier of Winnie",options_range(0, 4, 0.1, 10),1),
--	field("co_sr","Sanity regeneration multiplier","Sanity regeneration multiplier of Winnie",options_range(0, 4, 0.1, 10),1),
--	field("co_ht","Hunger rate multiplier","Hunger rate multiplier of Winnie",options_range(0.1, 4, 0.1, 10),1.6),
--	field("co_rs","Run speed multiplier","Run speed multiplier of Winnie",options_range(1, 2, 0.01, 100),1.2)
	field("co_dm","Damage multiplier","Damage multiplier of Winnie\n(Due to a Klei bug, the original value is x10)[default is 1.2=1.2x10=12]",options_range(1, 40, 1),12),	--TUNING.WATHGRITHR_DAMAGE_MULT == 1.2
	field("co_hr","Health regeneration multiplier","Health regeneration multiplier of Winnie\n(Due to a Klei bug, the original value is x10)[default is 1=1x10=10]",options_range(0, 40, 1),10),
	field("co_sr","Sanity regeneration multiplier","Sanity regeneration multiplier of Winnie\n(Due to a Klei bug, the original value is x10)[default is 1=1x10=10]",options_range(0, 40, 1),10),
	field("co_hc","Health % chance multiplier","Health regeneration % chance of Winnie",options_range(0, 100, 25),75),
	field("co_sc","Sanity % chance multiplier","Sanity regeneration % chance of Winnie",options_range(0, 100, 25),75),
	field("co_ht","Hunger rate multiplier","Hunger rate multiplier of Winnie\n(Due to a Klei bug, the original value is x10)[default is 1.6=1.6x10=16]",options_range(1, 40, 1),12),
	field("co_rs","Run speed multiplier","Run speed multiplier of Winnie\n(Due to a Klei bug, the original value is x100)[default is 1.2=1.2x100=120]",options_range(100, 200, 1),120)--++,
--++	field("co_kd","Winnie's knife damage = NIGHTSWORD_DAMAGE/(this value)",options_range(1, 400, 25),175),
--++	field("co_ku","Winnie's knife uses = TUNING.NIGHTSWORD_USES*(this value)",options_range(1, 400, 25),175),
--++	field("co_kc","Winnie's knife craziness = CRAZINESS_MED/(this value)",options_range(1, 400, 25),175)

}
