/*
 *  sys/mman.h We need this for the mmap/mprotect system calls
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2002-2014 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_MMAN_H_INCLUDED
#define _SYS_MMAN_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SYS_TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

/* From <bits/mman.h> */

#define PROT_READ       0x1             /* Page can be read.  */
#define PROT_WRITE      0x2             /* Page can be written.  */
#define PROT_EXEC       0x4             /* Page can be executed.  */
#define PROT_NONE       0x0             /* Page can not be accessed.  */
#define PROT_GROWSDOWN  0x01000000      /* Extend change to start of
                                           growsdown vma (mprotect only).  */
#define PROT_GROWSUP    0x02000000      /* Extend change to start of
                                           growsup vma (mprotect only).  */

/* Sharing types (must choose one and only one of these).  */
#define MAP_SHARED      0x01            /* Share changes.  */
#define MAP_PRIVATE     0x02            /* Changes are private.  */
#ifdef __USE_MISC
# define MAP_TYPE       0x0f            /* Mask for type of mapping.  */
#endif

/* Other flags.  */
#define MAP_FIXED       0x10            /* Interpret addr exactly.  */
#ifdef __USE_MISC
# define MAP_FILE       0
# define MAP_ANONYMOUS  0x20            /* Don't use a file.  */
# define MAP_ANON       MAP_ANONYMOUS
#endif

/* These are Linux-specific.  */
#ifdef __USE_MISC
# define MAP_GROWSDOWN  0x00100         /* Stack-like segment.  */
# define MAP_DENYWRITE  0x00800         /* ETXTBSY */
# define MAP_EXECUTABLE 0x01000         /* Mark it as an executable.  */
# define MAP_LOCKED     0x02000         /* Lock the mapping.  */
# define MAP_NORESERVE  0x04000         /* Don't check for reservations.  */
# define MAP_POPULATE   0x08000         /* Populate (prefault) pagetables.  */
# define MAP_NONBLOCK   0x10000         /* Do not block on IO.  */
#endif

/* Flags to `msync'.  */
#define MS_ASYNC        1               /* Sync memory asynchronously.  */
#define MS_SYNC         4               /* Synchronous memory sync.  */
#define MS_INVALIDATE   2               /* Invalidate the caches.  */

/* Flags for `mlockall'.  */
#define MCL_CURRENT     1               /* Lock all currently mapped pages.  */
#define MCL_FUTURE      2               /* Lock all additions to address
                                           space.  */

/* End <bits/mman.h> */

/* Return value of `mmap' in case of an error.  */
#define MAP_FAILED      ((void *) -1)

_WCRTLINK extern void *mmap( void *__addr, size_t __len, int __prot, int __flags, int __fd, off_t __offset );
_WCRTLINK extern int munmap( void *__addr, size_t __len );
_WCRTLINK extern int mprotect( void *__addr, size_t __len, int __prot );
_WCRTLINK extern int msync( void *__addr, size_t __len, int __flags );
_WCRTLINK extern int mlock( const void *__addr, size_t __len );
_WCRTLINK extern int munlock( const void *__addr, size_t __len );
_WCRTLINK extern int mlockall( int __flags );
_WCRTLINK extern int munlockall( void );

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_SYS_MMAN_H_INCLUDED */
