/*
 *  arch/mips/sys/socket.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

/* For setsockopt(2) */
#define SOL_SOCKET      0xffff

#define SO_DEBUG        0x0001  /* Record debugging information.  */
#define SO_REUSEADDR    0x0004  /* Allow reuse of local addresses.  */
#define SO_KEEPALIVE    0x0008  /* Keep connections alive and send SIGPIPE when they die.  */
#define SO_DONTROUTE    0x0010  /* Don't do local routing.  */
#define SO_BROADCAST    0x0020  /* Allow transmission of broadcast messages.  */
#define SO_LINGER       0x0080  /* Block on close of a reliable socket to transmit pending data.  */
#define SO_OOBINLINE    0x0100  /* Receive out-of-band data in-band.  */
/* #define SO_REUSEPORT 0x0200  Allow local address and port reuse - future addition.  */
#define SO_TYPE         0x1008  /* Compatible name for SO_STYLE.  */
#define SO_STYLE        SO_TYPE /* Synonym */
#define SO_ERROR        0x1007  /* get error status and clear */
#define SO_SNDBUF       0x1001  /* Send buffer size. */
#define SO_RCVBUF       0x1002  /* Receive buffer. */
#define SO_SNDLOWAT     0x1003  /* send low-water mark */
#define SO_RCVLOWAT     0x1004  /* receive low-water mark */
#define SO_SNDTIMEO     0x1005  /* send timeout */
#define SO_RCVTIMEO     0x1006  /* receive timeout */
#define SO_ACCEPTCONN   0x1009

/* linux-specific, might as well be the same as on i386 */
#define SO_NO_CHECK     11
#define SO_PRIORITY     12
#define SO_BSDCOMPAT    14

#define SO_PASSCRED     17
#define SO_PEERCRED     18

/* Security levels - as per NRL IPv6 - don't actually do anything */
#define SO_SECURITY_AUTHENTICATION      22
#define SO_SECURITY_ENCRYPTION_TRANSPORT    23
#define SO_SECURITY_ENCRYPTION_NETWORK      24

#define SO_BINDTODEVICE     25

/* Socket filtering */
#define SO_ATTACH_FILTER    26
#define SO_DETACH_FILTER    27

#define SO_PEERNAME         28
#define SO_TIMESTAMP        29
#define SCM_TIMESTAMP       SO_TIMESTAMP

#define SO_PEERSEC          30

#define SOCK_DGRAM      1
#define SOCK_STREAM     2
#define SOCK_RAW        3
#define SOCK_RDM        4
#define SOCK_SEQPACKET  5
#define SOCK_PACKET     10
#define SOCK_MAX        (SOCK_PACKET+1)

