/*
 *  arch/mips/siginfo.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifdef __cplusplus
 #ifndef _STDCLOCK_T_DEFINED
 #define _STDCLOCK_T_DEFINED
  namespace std {
    typedef unsigned long clock_t;
  }
 #endif
 #ifndef _CLOCK_T_DEFINED
 #define _CLOCK_T_DEFINED
  using std::clock_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _CLOCK_T_DEFINED
 #define _CLOCK_T_DEFINED
  typedef unsigned long clock_t;
 #endif
#endif /* __cplusplus not defined */

union sigval {
    int         sival_int;
    void        *sival_ptr;
};

/* Generic definition of siginfo struct borrowed from
 * the musl-libc implementation.
 */
struct siginfo {
    int si_signo, si_errno, si_code;
    union {
        char __pad[128 - 2*sizeof(int) - sizeof(long)];
        struct {
            union {
                struct {
                    pid_t si_pid;
                    uid_t si_uid;
                } __piduid;
                struct {
                    int si_timerid;
                    int si_overrun;
                } __timer;
            } __first;
            union {
                union sigval si_value;
                struct {
                    int si_status;
                    clock_t si_utime, si_stime;
                } __sigchld;
            } __second;
        } __si_common;
        struct {
            void *si_addr;
            short si_addr_lsb;
        } __sigfault;
        struct {
            long si_band;
            int si_fd;
        } __sigpoll;
        struct {
            void *si_call_addr;
            int si_syscall;
            unsigned si_arch;
        } __sigsys;
    } __si_fields;
};
#define si_pid      __si_fields.__si_common.__first.__piduid.si_pid
#define si_uid      __si_fields.__si_common.__first.__piduid.si_uid
#define si_status   __si_fields.__si_common.__second.__sigchld.si_status
#define si_utime    __si_fields.__si_common.__second.__sigchld.si_utime
#define si_stime    __si_fields.__si_common.__second.__sigchld.si_stime
#define si_value    __si_fields.__si_common.__second.si_value
#define si_addr     __si_fields.__sigfault.si_addr
#define si_addr_lsb __si_fields.__sigfault.si_addr_lsb
#define si_band     __si_fields.__sigpoll.si_band
#define si_fd       __si_fields.__sigpoll.si_fd
#define si_timerid  __si_fields.__si_common.__first.__timer.si_timerid
#define si_overrun  __si_fields.__si_common.__first.__timer.si_overrun
#define si_ptr      si_value.sival_ptr
#define si_int      si_value.sival_int
#define si_call_addr __si_fields.__sigsys.si_call_addr
#define si_syscall  __si_fields.__sigsys.si_syscall
#define si_arch     __si_fields.__sigsys.si_arch
