/*
 *  ws2tcpip.h  Windows Sockets (version 2) TCP/IP functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WS2TCPIP_H_
#define _WS2TCPIP_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <winsock2.h>
#include <ws2ipdef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Windows Sockets TCP/IP primitive data types */
typedef int socklen_t;

/* UDP socket options */
#define UDP_NOCHECKSUM          1
#define UDP_CHECKSUM_COVERAGE   20

/* Error codes for getaddrinfo() */
#define EAI_AGAIN           WSATRY_AGAIN
#define EAI_BADFLAGS        WSAEINVAL
#define EAI_FAIL            WSANO_RECOVERY
#define EAI_FAMILY          WSAEAFNOSUPPORT
#define EAI_MEMORY          WSA_NOT_ENOUGH_MEMORY
#define EAI_NOSECURENAME    WSA_SECURE_HOST_NOT_FOUND
#define EAI_NONAME          WSAHOST_NOT_FOUND
#define EAI_SERVICE         WSATYPE_NOT_FOUND
#define EAI_SOCKTYPE        WSAESOCKTNOSUPPORT
#define EAI_IPSECPOLICY     WSA_IPSEC_NAME_POLICY_ERROR
#define EAI_NODATA          EAI_NONAME

/* Maximum sizes */
#define GAI_STRERROR_BUFFER_SIZE    1024

/* Address information (structure defined in ws2def.h) */
#ifdef UNICODE
typedef ADDRINFOW   ADDRINFOT;
typedef ADDRINFOW   *PADDRINFOT;
#else
typedef ADDRINFOA   ADDRINFOT;
typedef ADDRINFOA   *PADDRINFOT;
#endif
typedef ADDRINFOA   ADDRINFO;
typedef ADDRINFOA   *LPADDRINFO;

/* Address information (extended version) (structure defined in ws2def.h) */
#if (_WIN32_WINNT >= 0x0600)
#ifdef UNICODE
typedef ADDRINFOEXW     ADDRINFOEX;
typedef ADDRINFOEXW     *PADDRINFOEX;
#else
typedef ADDRINFOEXA     ADDRINFOEX;
typedef ADDRINFOEXA     *PADDRINFOEX;
#endif
#endif

/* Lookup service completion routine */
#if (_WIN32_WINNT >= 0x0600)
typedef void (CALLBACK *LPLOOKUPSERVICE_COMPLETION_ROUTINE)( DWORD, DWORD, LPWSAOVERLAPPED );
#endif

/* Functions in WS2_32.DLL */
WINSOCK_API_LINKAGE VOID WSAAPI     freeaddrinfo( PADDRINFOA );
WINSOCK_API_LINKAGE INT WSAAPI      getaddrinfo( PCSTR, PCSTR, const ADDRINFOA *, PADDRINFOA * );
WINSOCK_API_LINKAGE INT WSAAPI      getnameinfo( const SOCKADDR *, socklen_t, PCHAR, DWORD, PCHAR, DWORD, INT );
#if (_WIN32_WINNT >= 0x0600)
WINSOCK_API_LINKAGE void WSAAPI     FreeAddrInfoEx( PADDRINFOEXA );
WINSOCK_API_LINKAGE void WSAAPI     FreeAddrInfoExW( PADDRINFOEXW );
WINSOCK_API_LINKAGE INT WSAAPI      GetAddrInfoExA( PCSTR, PCSTR, DWORD, LPGUID, const ADDRINFOEXA *, PADDRINFOEXA *, struct timeval *, LPOVERLAPPED, LPLOOKUPSERVICE_COMPLETION_ROUTINE, LPHANDLE );
WINSOCK_API_LINKAGE INT WSAAPI      GetAddrInfoExW( PCWSTR, PCWSTR, DWORD, LPGUID, const ADDRINFOEXW *, PADDRINFOEXW *, struct timeval *, LPOVERLAPPED, LPLOOKUPSERVICE_COMPLETION_ROUTINE, LPHANDLE );
WINSOCK_API_LINKAGE INT WSAAPI      SetAddrInfoExA( PCSTR, PCSTR, SOCKET_ADDRESS *, DWORD, LPBLOB, DWORD, DWORD, LPGUID, struct timeval *, LPOVERLAPPED, LPLOOKUPSERVICE_COMPLETION_ROUTINE, LPHANDLE );
WINSOCK_API_LINKAGE INT WSAAPI      SetAddrInfoExW( PCWSTR, PCWSTR, SOCKET_ADDRESS *, DWORD, LPBLOB, DWORD, DWORD, LPGUID, struct timeval *, LPOVERLAPPED, LPLOOKUPSERVICE_COMPLETION_ROUTINE, LPHANDLE );
#endif
#if (NTDDI_VERSION >= 0x05010200) || (_WIN32_WINNT >= 0x0502)
WINSOCK_API_LINKAGE VOID WSAAPI     FreeAddrInfoW( PADDRINFOW );
WINSOCK_API_LINKAGE INT WSAAPI      GetAddrInfoW( PCWSTR, PCWSTR, const ADDRINFOW *, PADDRINFOW * );
WINSOCK_API_LINKAGE INT WSAAPI      GetNameInfoW( const SOCKADDR *, socklen_t, PWCHAR, DWORD, PWCHAR, DWORD, INT );
#endif
#if (NTDDI_VERSION >= 0x06000000)
WINSOCK_API_LINKAGE PCWSTR WSAAPI   InetNtopW( INT, PVOID, PWSTR, size_t );
WINSOCK_API_LINKAGE INT WSAAPI      InetPtonW( INT, PCWSTR, PVOID );
WINSOCK_API_LINKAGE PCSTR WSAAPI    inet_ntop( INT, PVOID, PSTR, size_t );
WINSOCK_API_LINKAGE INT WSAAPI      inet_pton( INT, PCSTR, PVOID );
#endif

/* Aliases */
#if (_WIN32_WINNT >= 0x0600)
    #define FreeAddrInfoExA FreeAddrInfoEx
#endif
#if (NTDDI_VERSION >= 0x05010200) || (_WIN32_WINNT >= 0x0502)
    #define FreeAddrInfoA   freeaddrinfo
    #define GetAddrInfoA    getaddrinfo
    #define GetNameInfoA    getnameinfo
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define InetNtopA       inet_ntop
    #define InetPtonA       inet_pton
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #if (_WIN32_WINNT >= 0x0600)
        #define FreeAddrInfoEx  FreeAddrInfoExW
        #define GetAddrInfoEx   GetAddrInfoExW
        #define SetAddrInfoEx   SetAddrInfoExW
    #endif
    #if (NTDDI_VERSION >= 0x05010200) || (_WIN32_WINNT >= 0x0502)
        #define FreeAddrInfo    FreeAddrInfoW
        #define GetAddrInfo     GetAddrInfoW
        #define GetNameInfo     GetNameInfoW
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define InetNtop        InetNtopW
        #define InetPton        InetPtonW
    #endif
#else
    #if (_WIN32_WINNT >= 0x0600)
        #define GetAddrInfoEx   GetAddrInfoExA
        #define SetAddrInfoEx   SetAddrInfoExW
    #endif
    #if (NTDDI_VERSION >= 0x05010200) || (_WIN32_WINNT >= 0x0502)
        #define FreeAddrInfo    FreeAddrInfoA
        #define GetAddrInfo     GetAddrInfoW
        #define GetNameInfo     GetNameInfoA
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define InetNtop        InetNtopA
        #define InetPton        InetPtonA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WS2TCPIP_H_ */
