/*
 *  wlantype.h / wlantypes.h    WLAN data types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __WLANTYPES_H__
#define __WLANTYPES_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* 802.11 SSID maximum length */
#define DOT11_SSID_MAX_LENGTH   32

/* 802.11 BSS types */
typedef enum _DOT11_BSS_TYPE {
    dot11_BSS_type_infrastructure   = 1,
    dot11_BSS_type_independent      = 2,
    dot11_BSS_type_any              = 3
} DOT11_BSS_TYPE;
typedef DOT11_BSS_TYPE  *PDOT11_BSS_TYPE;

/* 802.11 SSID */
typedef struct _DOT11_SSID {
    ULONG   uSSIDLength;
    UCHAR   ucSSID[DOT11_SSID_MAX_LENGTH];
} DOT11_SSID;
typedef DOT11_SSID  *PDOT11_SSID;

/* 802.11 authentication algorithms */
typedef enum _DOT11_AUTH_ALGORITHM {
    DOT11_AUTH_ALGO_80211_OPEN          = 1,
    DOT11_AUTH_ALGO_80211_SHARED_KEY    = 2,
    DOT11_AUTH_ALGO_WPA                 = 3,
    DOT11_AUTH_ALGO_WPA_PSK             = 4,
    DOT11_AUTH_ALGO_WPA_NONE            = 5,
    DOT11_AUTH_ALGO_WPA_RSNA            = 6,
    DOT11_AUTH_ALGO_WPA_RSNA_PSK        = 7,
    DOT11_AUTH_ALGO_IHV_START           = 0x80000000,
    DOT11_AUTH_ALGO_IHV_END             = 0xFFFFFFFF
} DOT11_AUTH_ALGORITHM;
typedef DOT11_AUTH_ALGORITHM    *PDOT11_AUTH_ALGORITHM;

/* 802.11 authentication algorithm alternate names */
#define DOT11_AUTH_ALGORITHM_OPEN_SYSTEM    DOT11_AUTH_ALGO_80211_OPEN
#define DOT11_AUTH_ALGORITHM_SHARED_KEY     DOT11_AUTH_ALGO_80211_SHARED_KEY
#define DOT11_AUTH_ALGORITHM_WPA            DOT11_AUTH_ALGO_WPA
#define DOT11_AUTH_ALGORITHM_WPA_PSK        DOT11_AUTH_ALGO_WPA_PSK
#define DOT11_AUTH_ALGORITHM_WPA_NONE       DOT11_AUTH_ALGO_WPA_NONE
#define DOT11_AUTH_ALGORITHM_RSNA           DOT11_AUTH_ALGO_RSNA
#define DOT11_AUTH_ALGORITHM_RSNA_PSK       DOT11_AUTH_ALGO_RSNA_PSK

/* 802.11 cipher algorithms */
typedef enum _DOT11_CIPHER_ALGORITHM {
    DOT11_CIPHER_ALGO_NONE          = 0x00000000,
    DOT11_CIPHER_ALGO_WEP40         = 0x00000001,
    DOT11_CIPHER_ALGO_TKIP          = 0x00000002,
    DOT11_CIPHER_ALGO_CCMP          = 0x00000004,
    DOT11_CIPHER_ALGO_WEP104        = 0x00000005,
    DOT11_CIPHER_ALGO_WPA_USE_GROUP = 0x00000100,
    DOT11_CIPHER_ALGO_RSN_USE_GROUP = 0x00000100,
    DOT11_CIPHER_ALGO_WEP           = 0x00000101,
    DOT11_CIPHER_ALGO_IHV_START     = 0x80000000,
    DOT11_CIPHER_ALGO_IHV_END       = 0xFFFFFFFF
} DOT11_CIPHER_ALGORITHM;
typedef DOT11_CIPHER_ALGORITHM  *PDOT11_CIPHER_ALGORITHM;

/* 802.11 authentication cipher pair */
typedef struct DOT11_AUTH_CIPHER_PAIR {
    DOT11_AUTH_ALGORITHM    AuthAlgoId;
    DOT11_CIPHER_ALGORITHM  CipherAlgoId;
} DOT11_AUTH_CIPHER_PAIR;
typedef DOT11_AUTH_CIPHER_PAIR  *PDOT11_AUTH_CIPHER_PAIR;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __WLANTYPES_H__ */
