/*
 *  winsock.h   Windows Sockets functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifndef _WINDOWS_
    #include <windows.h>
#endif
#include <inaddr.h>
#include <qos.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive types from Unix */
typedef unsigned char       u_char;
typedef unsigned short      u_short;
typedef unsigned int        u_int;
typedef unsigned long       u_long;

/* Socket data type */
typedef UINT_PTR    SOCKET;

/* Number of sockets in fd_set (can be overriden by the user) */
#ifndef FD_SETSIZE
    #define FD_SETSIZE  64
#endif

/* Flags to define ioctlsocket() commands */
#define IOCPARM_MASK    0x0000007F
#define IOC_VOID        0x20000000
#define IOC_OUT         0x40000000
#define IOC_IN          0x80000000
#define IOC_INOUT       (IOC_IN | IOC_OUT)

/* Macros to define ioctlsocket() commands */
#define _IO( p1, p2 )       (IOC_VOID | ((p1) << 8) | (p2))
#define _IOR( p1, p2, p3 ) \
    (IOC_OUT | (((long)sizeof( p3 ) & IOCPARM_MASK) << 16) | ((p1) << 8) | (p2))
#define _IOW( p1, p2, p3 ) \
    (IOC_IN | (((long)sizeof( p3 ) & IOCPARM_MASK) << 16) | ((p1) << 8) | (p2))

/* Commands for ioctlsocket() */
#define FIONREAD    _IOR( 'f', 127, u_long )
#define FIONBIO     _IOW( 'f', 126, u_long )
#define FIOASYNC    _IOW( 'f', 125, u_long )
#define SIOCSHIWAT  _IOW( 's', 0, u_long )
#define SIOCGHIWAT  _IOR( 's', 1, u_long )
#define SIOCSLOWAT  _IOW( 's', 2, u_long )
#define SIOCGLOWAT  _IOR( 's', 3, u_long )
#define SIOCATMARK  _IOR( 's', 7, u_long )

/* IP protocols */
#define IPPROTO_IP      0
#define IPPROTO_ICMP    1
#define IPPROTO_IGMP    2
#define IPPROTO_GGP     3
#define IPPROTO_TCP     6
#define IPPROTO_PUP     12
#define IPPROTO_UDP     17
#define IPPROTO_IDP     22
#define IPPROTO_ND      77
#define IPPROTO_RAW     255
#define IPPROTO_MAX     256

/* IP port numbers */
#define IPPORT_ECHO         7
#define IPPORT_DISCARD      9
#define IPPORT_SYSTAT       11
#define IPPORT_DAYTIME      13
#define IPPORT_NETSTAT      15
#define IPPORT_FTP          21
#define IPPORT_TELNET       23
#define IPPORT_SMTP         25
#define IPPORT_TIMESERVER   37
#define IPPORT_NAMESERVER   42
#define IPPORT_WHOIS        43
#define IPPORT_MTP          57
#define IPPORT_TFTP         69
#define IPPORT_RJE          77
#define IPPORT_FINGER       79
#define IPPORT_TTYLINK      87
#define IPPORT_SUPDUP       95
#define IPPORT_EXECSERVER   512
#define IPPORT_LOGINSERVER  513
#define IPPORT_CMDSERVER    514
#define IPPORT_EFSSERVER    520
#define IPPORT_BIFFUDP      512
#define IPPORT_WHOSERVER    513
#define IPPORT_ROUTESERVER  520
#define IPPORT_RESERVED     1024

/* Link numbers */
#define IMPLINK_IP          155
#define IMPLINK_LOWEXPER    156
#define IMPLINK_HIGHEXPER   158

/* Constants to manipulate Internet addresses */
#define IN_CLASSA_NET       0xFF000000L
#define IN_CLASSA_NSHIFT    24
#define IN_CLASSA_HOST      0x00FFFFFFL
#define IN_CLASSA_MAX       128
#define IN_CLASSB_NET       0xFFFF0000L
#define IN_CLASSB_NSHIFT    16
#define IN_CLASSB_HOST      0x0000FFFFL
#define IN_CLASSB_MAX       65536
#define IN_CLASSC_NET       0xFFFFFF00L
#define IN_CLASSC_NSHIFT    8
#define IN_CLASSC_HOST      0x000000FFL
#define INADDR_ANY          0x00000000L
#define INADDR_LOOPBACK     0x7F000001L
#define INADDR_BROADCAST    0xFFFFFFFFL
#define INADDR_NONE         0xFFFFFFFFL

/* Macros to manipulate Internet addresses */
#define IN_CLASSA( x )  (((long)(x) & 0x80000000L) == 0)
#define IN_CLASSB( x )  (((long)(x) & 0xC0000000L) == 0x80000000L)
#define IN_CLASSC( x )  (((long)(x) & 0xE0000000L) == 0xC0000000L)

/* String lengths */
#define WSADESCRIPTION_LEN  256
#define WSASYS_STATUS_LEN   128

/* IP options for getsockopt() and setsockopt() */
#define IP_OPTIONS          1
#define IP_MULTICAST_IF     2
#define IP_MULTICAST_TTL    3
#define IP_MULTICAST_LOOP   4
#define IP_ADD_MEMBERSHIP   5
#define IP_DROP_MEMBERSHIP  6
#define IP_TTL              7
#define IP_TOS              8
#define IP_DONTFRAGMENT     9

/* Miscellaneous IP constants */
#define IP_DEFAULT_MULTICAST_TTL    1
#define IP_DEFAULT_MULTICAST_LOOP   1
#define IP_MAX_MEMBERSHIPS          20

/* Socket special values */
#define INVALID_SOCKET  0xFFFFFFFF
#define SOCKET_ERROR    (-1)

/* Socket types */
#define SOCK_STREAM     1
#define SOCK_DGRAM      2
#define SOCK_RAW        3
#define SOCK_RDM        4
#define SOCK_SEQPACKET  5

/* Socket option flags */
#define SO_DEBUG            0x0001
#define SO_ACCEPTCONN       0x0002
#define SO_REUSEADDR        0x0004
#define SO_KEEPALIVE        0x0008
#define SO_DONTROUTE        0x0010
#define SO_BROADCAST        0x0020
#define SO_USELOOPBACK      0x0040
#define SO_LINGER           0x0080
#define SO_OOBINLINE        0x0100
#define SO_DONTLINGER       (u_int)(~SO_LINGER)

/* Other socket options */
#define SO_SNDBUF                   0x1001
#define SO_RCVBUF                   0x1002
#define SO_SNDLOWAT                 0x1003
#define SO_RCVLOWAT                 0x1004
#define SO_SNDTIMEO                 0x1005
#define SO_RCVTIMEO                 0x1006
#define SO_ERROR                    0x1007
#define SO_TYPE                     0x1008
#define SO_CONNDATA                 0x7000
#define SO_CONNOPT                  0x7001
#define SO_DISCDATA                 0x7002
#define SO_DISCOPT                  0x7003
#define SO_CONNDATALEN              0x7004
#define SO_CONNOPTLEN               0x7005
#define SO_DISCDATALEN              0x7006
#define SO_DISCOPTLEN               0x7007
#define SO_OPENTYPE                 0x7008
#define SO_MAXDG                    0x7009
#define SO_MAXPATHDG                0x700A
#define SO_UPDATE_ACCEPT_CONTEXT    0x700B
#define SO_CONNECT_TIME             0x700C

/* Socket option synchronous alert flags */
#define SO_SYNCHRONOUS_ALERT    0x0010
#define SO_SYNCHRONOUS_NONALERT 0x0020

/* TCP options */
#define TCP_NODELAY     0x0001
#define TCP_BSDURGENT   0x7000

/* Address families */
#define AF_UNSPEC       0
#define AF_UNIX         1
#define AF_INET         2
#define AF_IMPLINK      3
#define AF_PUP          4
#define AF_CHAOS        5
#define AF_IPX          6
#define AF_NS           6
#define AF_ISO          7
#define AF_OSI          AF_ISO
#define AF_ECMA         8
#define AF_DATAKIT      9
#define AF_CCITT        10
#define AF_SNA          11
#define AF_DECnet       12
#define AF_DLI          13
#define AF_LAT          14
#define AF_HYLINK       15
#define AF_APPLETALK    16
#define AF_NETBIOS      17
#define AF_VOICEVIEW    18
#define AF_FIREFOX      19
#define AF_UNKNOWN1     20
#define AF_BAN          21
#define AF_MAX          22

/* Protocol families */
#define PF_UNSPEC       AF_UNSPEC
#define PF_UNIX         AF_UNIX
#define PF_INET         AF_INET
#define PF_IMPLINK      AF_IMPLINK
#define PF_PUP          AF_PUP
#define PF_CHAOS        AF_CHAOS
#define PF_NS           AF_NS
#define PF_IPX          AF_IPX
#define PF_ISO          AF_ISO
#define PF_OSI          AF_OSI
#define PF_ECMA         AF_ECMA
#define PF_DATAKIT      AF_DATAKIT
#define PF_CCITT        AF_CCITT
#define PF_SNA          AF_SNA
#define PF_DECnet       AF_DECnet
#define PF_DLI          AF_DLI
#define PF_LAT          AF_LAT
#define PF_HYLINK       AF_HYLINK
#define PF_APPLETALK    AF_APPLETALK
#define PF_VOICEVIEW    AF_VOICEVIEW
#define PF_FIREFOX      AF_FIREFOX
#define PF_UNKNOWN1     AF_UNKNOWN1
#define PF_BAN          AF_BAN
#define PF_MAX          AF_MAX

/* Special level number for getsockopt() and setsockopt() */
#define SOL_SOCKET  0xFFFF

/* Maximum queue length for listen() */
#define SOMAXCONN   5

/* Socket message flags */
#define MSG_OOB         0x00000001L
#define MSG_PEEK        0x00000002L
#define MSG_DONTROUTE   0x00000004L
#define MSG_PARTIAL     0x00008000L

/* Maximum size of a gethostby*() structure */
#define MAXGETHOSTSTRUCT    1024

/* WSAAsyncSelect() flags */
#define FD_READ     0x01
#define FD_WRITE    0x02
#define FD_OOB      0x04
#define FD_ACCEPT   0x08
#define FD_CONNECT  0x10
#define FD_CLOSE    0x20

/* Old names of socket error codes (defined in winerror.h) */
#define HOST_NOT_FOUND  WSAHOST_NOT_FOUND
#define TRY_AGAIN       WSATRY_AGAIN
#define NO_RECOVERY     WSANO_RECOVERY
#define NO_DATA         WSANO_DATA
#define WSANO_ADDRESS   WSANO_DATA
#define NO_ADDRESS      WSANO_ADDRESS

/* TransmitFile() flags */
#define TF_DISCONNECT   0x00000001L
#define TF_REUSE_SOCKET 0x00000002L
#define TF_WRITE_BEHIND 0x00000004L

/* Set of sockets */
typedef struct fd_set {
    u_int   fd_count;
    SOCKET  fd_array[FD_SETSIZE];
} fd_set;

/* Time value */
#ifndef _TIMEVAL_DEFINED
#define _TIMEVAL_DEFINED

struct timeval {
    long        tv_sec;     /* seconds */
    long        tv_usec;    /* and microseconds */
};

/*
 * Operations on timevals.
 *
 * NB: timercmp does not work for >= or <=.
 */
#define timerisset(tvp)         ((tvp)->tv_sec || (tvp)->tv_usec)
#define timercmp(tvp, uvp, cmp) ((tvp)->tv_sec cmp (uvp)->tv_sec) || \
    (tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp (uvp)->tv_usec )
#define timerclear(tvp)         ((tvp)->tv_sec = (tvp)->tv_usec = 0)

#endif

/* Host entity */
struct hostent {
    char    *h_name;
    char    **h_aliases;
    short   h_addrtype;
    short   h_length;
    char    **h_addr_list;
};
#define h_addr  h_addr_list[0]

/* Network entity */
struct netent {
    char    *n_name;
    char    **n_aliases;
    short   n_addrtype;
    u_long  n_net;
};

/* Server entity */
struct servent {
    char    *s_name;
    char    **s_aliases;
    short   s_port;
    char    *s_proto;
};

/* Protocol entity */
struct protoent {
    char    *p_name;
    char    **p_aliases;
    short   p_proto;
};

/* Internet socket address */
struct sockaddr_in {
    short           sin_family;
    u_short         sin_port;
    struct in_addr  sin_addr;
    char            sin_zero[8];
};

/* WSA data */
typedef struct WSAData {
    WORD            wVersion;
    WORD            wHighVersion;
    char            szDescription[WSADESCRIPTION_LEN + 1];
    char            szSystemStatus[WSASYS_STATUS_LEN + 1];
    unsigned short  iMaxSockets;
    unsigned short  iMaxUdpDg;
    char            *lpVendorInfo;
} WSADATA;
typedef WSADATA *LPWSADATA;

/* IP_ADD_MEMBERSHIP and IP_DROP_MEMBERSHIP parameters */
struct ip_mreq {
    struct in_addr  imr_multiaddr;
    struct in_addr  imr_interface;
};

/* Socket address */
struct sockaddr {
    u_short sa_family;
    char    sa_data[14];
};

/* Socket protocol */
struct sockproto {
    u_short sp_family;
    u_short sp_protocol;
};

/* SO_LINGER information */
struct linger {
    u_short l_onoff;
    u_short l_linger;
};

/* TransmitFile() buffers */
typedef struct _TRANSMIT_FILE_BUFFERS {
    PVOID   Head;
    DWORD   HeadLength;
    PVOID   Tail;
    DWORD   TailLength;
} TRANSMIT_FILE_BUFFERS;
typedef TRANSMIT_FILE_BUFFERS   *PTRANSMIT_FILE_BUFFERS;
typedef TRANSMIT_FILE_BUFFERS   *LPTRANSMIT_FILE_BUFFERS;

/* Win32-style names for structures */
typedef struct sockaddr     SOCKADDR;
typedef struct sockaddr     *PSOCKADDR;
typedef struct sockaddr     *LPSOCKADDR;
typedef struct sockaddr_in  SOCKADDR_IN;
typedef struct sockaddr_in  *PSOCKADDR_IN;
typedef struct sockaddr_in  *LPSOCKADDR_IN;
typedef struct linger       LINGER;
typedef struct linger       *PLINGER;
typedef struct linger       *LPLINGER;
typedef struct fd_set       FD_SET;
typedef struct fd_set       *PFD_SET;
typedef struct fd_set       *LPFD_SET;
typedef struct hostent      HOSTENT;
typedef struct hostent      *PHOSTENT;
typedef struct hostent      *LPHOSTENT;
typedef struct servent      SERVENT;
typedef struct servent      *PSERVENT;
typedef struct servent      *LPSERVENT;
typedef struct protoent     PROTOENT;
typedef struct protoent     *PPROTOENT;
typedef struct protoent     *LPPROTOENT;
typedef struct timeval      TIMEVAL;
typedef struct timeval      *PTIMEVAL;
typedef struct timeval      *LPTIMEVAL;

/* Functions in WSOCK32.DLL */
BOOL PASCAL             AcceptEx( SOCKET, SOCKET, PVOID, DWORD, DWORD, DWORD, LPDWORD, LPOVERLAPPED );
VOID PASCAL             GetAcceptExSockaddrs( PVOID, DWORD, DWORD, DWORD, struct sockaddr **, LPINT, struct sockaddr **, LPINT );
BOOL PASCAL             TransmitFile( SOCKET, HANDLE, DWORD, DWORD, LPOVERLAPPED, LPTRANSMIT_FILE_BUFFERS, DWORD );
HANDLE PASCAL           WSAAsyncGetHostByAddr( HWND, u_int, const char *, int, int, char *, int );
HANDLE PASCAL           WSAAsyncGetHostByName( HWND, u_int, const char *, char *, int );
HANDLE PASCAL           WSAAsyncGetProtoByName( HWND, u_int, const char *, char *, int );
HANDLE PASCAL           WSAAsyncGetProtoByNumber( HWND, u_int, int, char *, int );
HANDLE PASCAL           WSAAsyncGetServByName( HWND, u_int, const char *, const char *, char *, int );
HANDLE PASCAL           WSAAsyncGetServByPort( HWND, u_int, int, const char *, char *, int );
int PASCAL              WSAAsyncSelect( SOCKET, HWND, u_int, long );
int PASCAL              WSACancelAsyncRequest( HANDLE );
int PASCAL              WSACancelBlockingCall( void );
int PASCAL              WSACleanup( void );
int PASCAL              WSAGetLastError( void );
BOOL PASCAL             WSAIsBlocking( void );
int PASCAL              WSARecvEx( SOCKET, char *, int, int * );
FARPROC PASCAL          WSASetBlockingHook( FARPROC );
void PASCAL             WSASetLastError( int );
int PASCAL              WSAStartup( WORD, LPWSADATA );
int PASCAL              WSAUnhookBlockingHook( void );
int PASCAL              __WSAFDIsSet( SOCKET, fd_set * );
SOCKET PASCAL           accept( SOCKET, struct sockaddr *, int * );
int PASCAL              bind( SOCKET, const struct sockaddr *, int );
int PASCAL              closesocket( SOCKET );
int PASCAL              connect( SOCKET, const struct sockaddr *, int );
struct hostent * PASCAL gethostbyaddr( const char *, int, int );
struct hostent * PASCAL gethostbyname( const char * );
int PASCAL              gethostname( char *, int );
int PASCAL              getpeername( SOCKET, struct sockaddr *, int * );
struct protoent * PASCAL    getprotobyname( const char * );
struct protoent * PASCAL    getprotobynumber( int );
struct servent * PASCAL getservbyname( const char *, const char * );
struct servent * PASCAL getservbyport( int, const char * );
int PASCAL              getsockname( SOCKET, struct sockaddr *, int * );
int PASCAL              getsockopt( SOCKET, int, int, char *, int * );
u_long PASCAL           htonl( u_long );
u_short PASCAL          htons( u_short );
unsigned long PASCAL    inet_addr( const char * );
char * PASCAL           inet_ntoa( struct in_addr );
int PASCAL              ioctlsocket( SOCKET, long, u_long * );
int PASCAL              listen( SOCKET, int );
u_long PASCAL           ntohl( u_long );
u_short PASCAL          ntohs( u_short );
int PASCAL              recv( SOCKET, char *, int, int );
int PASCAL              recvfrom( SOCKET, char *, int, int, struct sockaddr *, int * );
int PASCAL              select( int, fd_set *, fd_set *, fd_set *, const struct timeval * );
int PASCAL              send( SOCKET, const char *, int, int );
int PASCAL              sendto( SOCKET, const char *, int, int, const struct sockaddr *, int );
int PASCAL              setsockopt( SOCKET, int, int, const char *, int );
int PASCAL              shutdown( SOCKET, int );
SOCKET PASCAL           socket( int, int, int );

/* Macros to manipulate the fd_set structure */
#define FD_CLR( p1, p2 ) \
    { \
        u_int __counter; \
        __counter = 0; \
        while( __counter < ((fd_set *)(p2))->fd_count && \
            ((fd_set *)(p2))->fd_array[__counter] != p1 ) { \
            __counter++; \
        } \
        if( ((fd_set *)(p2))->fd_array[__counter] == p1 ) { \
            for( ; __counter < ((fd_set *)(p2))->fd_count - 1; __counter++ ) { \
                ((fd_set *)(p2))->fd_array[__counter] = \
                    ((fd_set *)(p2))->fd_array[__counter - 1]; \
            } \
            ((fd_set *)(p2))->fd_count--; \
        } \
    }
#define FD_SET( p1, p2 ) \
    if( ((fd_set *)(p2))->fd_count < FD_SETSIZE ) { \
        ((fd_set *)(p2))->fd_array[((fd_set *)(p2))->fd_count++] = p1; \
    }
#define FD_ZERO( x )        (((fd_set *)(x))->fd_count = 0)
#define FD_ISSET( p1, p2 )  __WSAFDIsSet( (SOCKET)(p1), (fd_set *)(p2) )

/* Macros to manipulate the parameters to asynchronous completion messages */
#define WSAMAKEASYNCREPLY( p1, p2 )     MAKELONG( p1, p2 )
#define WSAMAKESELECTREPLY( p1, p2 )    MAKELONG( p1, p2 )
#define WSAGETASYNCBUFLEN( x )          LOWORD( x )
#define WSAGETASYNCERROR( x )           HIWORD( x )
#define WSAGETSELECTEVENT( x )          LOWORD( x )
#define WSAGETSELECTERROR( x )          HIWORD( x )

/* Macro for compatiblity */
#define h_errno WSAGetLastError()

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINSOCKAPI_ */
