/*
 *  windowsx.h  Win32 extension macros
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_WINDOWSX
#define _INC_WINDOWSX

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* These macro is used by other macros to invoke SendMessage().  It is shared with
 * several other header files.
 */
#ifndef SNDMSG
    #ifdef __cplusplus
        #define SNDMSG  ::SendMessage
    #else
        #define SNDMSG  SendMessage
    #endif
#endif

/* Extra message for compatibility with Win16 */
#define WM_CTLCOLOR 0x0019

/* Message cracker macros */
#define HANDLE_MSG( x, p1, f ) \
    case (p1): \
        return HANDLE_##p1( x, wParam, lParam, f )
#define HANDLE_WM_COMPACTING( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1) ), 0L)
#define FORWARD_WM_COMPACTING( x, p, f ) \
    (void)(f)( x, WM_COMPACTING, (WPARAM)(UINT)(p), 0L )
#define HANDLE_WM_WININICHANGE( x, p1, p2, f ) \
    ((f)( x, (LPCTSTR)(p2) ), 0L)
#define FORWARD_WM_WININICHANGE( x, p, f ) \
    (void)(f)( x, WM_WININICHANGE, 0, (LPARAM)(LPCTSTR)(p) )
#define HANDLE_WM_SYSCOLORCHANGE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_SYSCOLORCHANGE( x, f ) \
    (void)(f)( x, WM_SYSCOLORCHANGE, 0, 0L )
#define HANDLE_WM_QUERYNEWPALETTE( x, p1, p2, f ) \
    MAKELRESULT( (BOOL)(f)( x ), 0 )
#define FORWARD_WM_QUERYNEWPALETTE( x, f ) \
    (BOOL)(DWORD)(f)( x, WM_QUERYNEWPALETTE, 0, 0L )
#define HANDLE_WM_PALETTEISCHANGING( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_PALETTEISCHANGING( x, p, f ) \
    (void)(f)( x, WM_PALETTEISCHANGING, (WPARAM)(HWND)(p), 0L )
#define HANDLE_WM_PALETTECHANGED( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_PALETTECHANGED( x, p, f ) \
    (void)(f)( x, WM_PALETTECHANGED, (WPARAM)(HWND)(p), 0L )
#define HANDLE_WM_FONTCHANGE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_FONTCHANGE( x, f ) \
    (void)(f)( x, WM_FONTCHANGE, 0, 0L )
#define HANDLE_WM_SPOOLERSTATUS( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), (int)(short)LOWORD( p2 ) ), 0L)
#define FORWARD_WM_SPOOLERSTATUS( x, p1, p2, f ) \
    (void)(f)( x, WM_SPOOLERSTATUS, (WPARAM)(p1), MAKELPARAM( p2, 0 ) )
#define HANDLE_WM_DEVMODECHANGE( x, p1, p2, f ) \
    ((f)( x, (LPCTSTR)(p2) ), 0L)
#define FORWARD_WM_DEVMODECHANGE( x, p, f ) \
    (void)(f)( x, WM_DEVMODECHANGE, 0, (LPARAM)(LPCTSTR)(p) )
#define HANDLE_WM_TIMECHANGE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_TIMECHANGE( x, f ) \
    (void)(f)( x, WM_TIMECHANGE, 0, 0L )
#define HANDLE_WM_POWER( x, p1, p2, f ) \
    ((f)( x, (int)(p1) ), 0L)
#define FORWARD_WM_POWER( x, p, f ) \
    (void)(f)( x, WM_POWER, (WPARAM)(int)(p), 0L )
#define HANDLE_WM_QUERYENDSESSION( x, p1, p2, f ) \
    MAKELRESULT( (BOOL)(f)( x ), 0L )
#define FORWARD_WM_QUERYENDSESSION( x, p ) \
    (BOOL)(DWORD)(f)( x, WM_QUERYENDSESSION, 0, 0L )
#define HANDLE_WM_ENDSESSION( x, p1, p2, f ) \
    ((f)( x, (BOOL)(p1) ), 0L)
#define FORWARD_WM_ENDSESSION( x, p, f ) \
    (void)(f)( x, WM_ENDSESSION, (WPARAM)(BOOL)(p), 0L )
#define HANDLE_WM_QUIT( x, p1, p2, f ) \
    ((f)( x, (int)(p1) ), 0L)
#define FORWARD_WM_QUIT( x, p, f ) \
    (void)(f)( x, WM_QUIT, (WPARAM)(p), 0L )
#define HANDLE_WM_SYSTEMERROR( x, p1, p2, f )   0L
#define FORWARD_WM_SYSTEMERROR( x, p, f )       0L
#define HANDLE_WM_CREATE( x, p1, p2, f ) \
    ((f)( x, (LPCREATESTRUCT)(p2) ) ? 0L : (LRESULT)-1L)
#define FORWARD_WM_CREATE( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_CREATE, 0, (LPARAM)(LPCREATESTRUCT)(p) )
#define HANDLE_WM_NCCREATE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (LPCREATESTRUCT)(p2) )
#define FORWARD_WM_NCCREATE( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_NCCREATE, 0, (LPARAM)(LPCREATESTRUCT)(p) )
#define HANDLE_WM_DESTROY( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_DESTROY( x, f ) \
    (void)(f)( x, WM_DESTROY, 0, 0L )
#define HANDLE_WM_NCDESTROY( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_NCDESTROY( x, f ) \
    (void)(f)( x, WM_NCDESTROY, 0, 0L )
#define HANDLE_WM_SHOWWINDOW( x, p1, p2, f ) \
    ((f)( x, (BOOL)(p1), (UINT)(p2) ), 0L)
#define FORWARD_WM_SHOWWINDOW( x, p1, p2, f ) \
    (void)(f)( x, WM_SHOWWINDOW, (WPARAM)(BOOL)(p1), (LPARAM)(UINT)(p2) )
#define HANDLE_WM_SETREDRAW( x, p1, p2, f ) \
    ((f)( x, (BOOL)(p1) ), 0L)
#define FORWARD_WM_SETREDRAW( x, p, f ) \
    (void)(f)( x, WM_SETREDRAW, (WPARAM)(BOOL)(p), 0L )
#define HANDLE_WM_ENABLE( x, p1, p2, f ) \
    ((f)( x, (BOOL)(p1) ), 0L)
#define FORWARD_WM_ENABLE( x, p, f ) \
    (void)(f)( x, WM_ENABLE, (WPARAM)(BOOL)(p1), 0L )
#define HANDLE_WM_SETTEXT( x, p1, p2, f ) \
    ((f)( x, (LPCTSTR)(p2) ), 0L)
#define FORWARD_WM_SETTEXT( x, p, f ) \
    (void)(f)( x, WM_SETTEXT, 0, (LPARAM)(LPCTSTR)(p) )
#define HANDLE_WM_GETTEXT( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x, (int)(p1), (LPTSTR)(p2) )
#define FORWARD_WM_GETTEXT( x, p1, p2, f ) \
    (int)(DWORD)(f)( x, WM_GETTEXT, (WPARAM)(int)(p1), (LPARAM)(LPTSTR)(p2) )
#define HANDLE_WM_GETTEXTLENGTH( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x )
#define FORWARD_WM_GETTEXTLENGTH( x, f ) \
    (int)(DWORD)(f)( x, WM_GETTEXTLENGTH, 0, 0L )
#define HANDLE_WM_WINDOWPOSCHANGING( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (LPWINDOWPOS)(p2) )
#define FORWARD_WM_WINDOWPOSCHANGING( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_WINDOWPOSCHANGING, 0, (LPARAM)(LPWINDOWPOS)(p) )
#define HANDLE_WM_WINDOWPOSCHANGED( x, p1, p2, f ) \
    ((f)( x, (const LPWINDOWPOS)(p2) ), 0L)
#define FORWARD_WM_WINDOWPOSCHANGED( x, p, f ) \
    (void)(f)( x, WM_WINDOWPOSCHANGED, 0, (LPARAM)(const LPWINDOWPOS)(p) )
#define HANDLE_WM_MOVE( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_MOVE( x, p1, p2, f ) \
    (void)(f)( x, WM_MOVE, 0, MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_SIZE( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_SIZE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_SIZE, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_CLOSE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_CLOSE( x, f ) \
    (void)(f)( x, WM_CLOSE, 0, 0L )
#define HANDLE_WM_QUERYOPEN( x, p1, p2, f ) \
    MAKELRESULT( (BOOL)(f)( x ), 0 )
#define FORWARD_WM_QUERYOPEN( x, f ) \
    (BOOL)(DWORD)(f)( x, WM_QUERYOPEN, 0, 0L )
#define HANDLE_WM_GETMINMAXINFO( x, p1, p2, f ) \
    ((f)( x, (LPMINMAXINFO)(p2) ), 0L)
#define FORWARD_WM_GETMINMAXINFO( x, p, f ) \
    (void)(f)( x, WM_GETMINMAXINFO, 0, (LPARAM)(LPMINMAXINFO)(p) )
#define HANDLE_WM_PAINT( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_PAINT( x, f ) \
    (void)(f)( x, WM_PAINT, 0, 0L )
#define HANDLE_WM_ERASEBKGND( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (HDC)(p1) )
#define FORWARD_WM_ERASEBKGND( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_ERASEBKGND, (WPARAM)(HDC)(p), 0L )
#define HANDLE_WM_ICONERASEBKGND( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (HDC)(p1) )
#define FORWARD_WM_ICONERASEBKGND( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_ICONERASEBKGND, (WPARAM)(HDC)(p), 0L )
#define HANDLE_WM_NCPAINT( x, p1, p2, f ) \
    ((f)( x, (HRGN)(p1) ), 0L)
#define FORWARD_WM_NCPAINT( x, p, f ) \
    (void)(f)( x, WM_NCPAINT, (WPARAM)(HRGN)( p ), 0L )
#define HANDLE_WM_NCCALCSIZE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(f)( x, (BOOL)(p1), (NCCALCSIZE_PARAMS *)(p2) )
#define FORWARD_WM_NCCALCSIZE( x, p1, p2, f ) \
    (UINT)(DWORD)(f)( x, WM_NCCALCSIZE, (WPARAM)(p1), (LPARAM)(NCCALCSIZE_PARAMS *)(p2) )
#define HANDLE_WM_NCHITTEST( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ) )
#define FORWARD_WM_NCHITTEST( x, p1, p2, f ) \
    (UINT)(DWORD)(f)( x, WM_NCHITTEST, 0, MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_QUERYDRAGICON( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(f)( x )
#define FORWARD_WM_QUERYDRAGICON( x, f ) \
    (HICON)(UINT)(DWORD)(f)( x, WM_QUERYDRAGICON, 0, 0L )
#ifdef _INC_SHELLAPI
    #define HANDLE_WM_DROPFILES( x, p1, p2, f ) \
        ((f)( x, (HDROP)(p1) ), 0L)
    #define FORWARD_WM_DROPFILES( x, p, f ) \
        (void)(f)( x, WM_DROPFILES, (WPARAM)(HDROP)(p), 0L )
#endif
#define HANDLE_WM_ACTIVATE( x, p1, p2, f ) \
    ((f)( x, (UINT)LOWORD( p1 ), (HWND)(p2), (BOOL)HIWORD( p1 ) ), 0L)
#define FORWARD_WM_ACTIVATE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_ACTIVATE, MAKEWPARAM( p1, p3 ), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_ACTIVATEAPP( x, p1, p2, f ) \
    ((f)( x, (BOOL)(p1), (DWORD)(p2) ), 0L)
#define FORWARD_WM_ACTIVATEAPP( x, p1, p2, f ) \
    (void)(f)( x, WM_ACTIVATEAPP, (WPARAM)(BOOL)(p1), (LPARAM)(p2) )
#define HANDLE_WM_NCACTIVATE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (BOOL)(p1), 0, 0 )
#define FORWARD_WM_NCACTIVATE( x, p1, p2, p3, f ) \
    (BOOL)(DWORD)(f)( x, WM_NCACTIVATE, (WPARAM)(BOOL)(p1), 0L )
#define HANDLE_WM_SETFOCUS( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_SETFOCUS( x, p, f ) \
    (void)(f)( x, WM_SETFOCUS, (WPARAM)(HWND)(p), 0L )
#define HANDLE_WM_KILLFOCUS( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_KILLFOCUS( x, p, f ) \
    (void)(f)( x, WM_KILLFOCUS, (WPARAM)(HWND)(p), 0L )
#define HANDLE_WM_KEYDOWN( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), TRUE, (int)(short)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_KEYDOWN( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_KEYDOWN, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_KEYUP( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), FALSE, (int)(short)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L )
#define FORWARD_WM_KEYUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_KEYUP, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_CHAR( x, p1, p2, f ) \
    ((f)( x, (TCHAR)(p1), (int)(short)LOWORD( p2 ) ), 0L)
#define FORWARD_WM_CHAR( x, p1, p2, f ) \
    (void)(f)( x, WM_CHAR, (WPARAM)(TCHAR)(p1), MAKELPARAM( p2, 0 ) )
#define HANDLE_WM_DEADCHAR( x, p1, p2, f ) \
    ((f)( x, (TCHAR)(p1), (int)(short)LOWORD( p2 ) ), 0L)
#define FORWARD_WM_DEADCHAR( x, p1, p2, f ) \
    (void)(f)( x, WM_DEADCHAR, (WPARAM)(TCHAR)(p1), MAKELPARAM( p2, 0 ) )
#define HANDLE_WM_SYSKEYDOWN( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), TRUE, (int)(short)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_SYSKEYDOWN( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_SYSKEYDOWN, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_SYSKEYUP( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), FALSE, (int)(short)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_SYSKEYUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_SYSKEYUP, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_SYSCHAR( x, p1, p2, f ) \
    ((f)( x, (TCHAR)(p1), (int)(short)LOWORD( p2 ) ), 0L)
#define FORWARD_WM_SYSCHAR( x, p1, p2, f ) \
    (void)(f)( x, WM_SYSCHAR, (WPARAM)(TCHAR)(p1), MAKELPARAM( p2, 0 ) )
#define HANDLE_WM_SYSDEADCHAR( x, p1, p2, f ) \
    ((f)( x, (TCHAR)(p1), (int)(short)LOWORD( p2 ) ), 0L)
#define FORWARD_WM_SYSDEADCHAR( x, p1, p2, f ) \
    (void)(f)( x, WM_SYSDEADCHAR, (WPARAM)(TCHAR)(p1), MAKELPARAM( p2, 0 ) )
#define HANDLE_WM_MOUSEMOVE( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_MOUSEMOVE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_MOUSEMOVE, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_LBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_LBUTTONDOWN( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, (p1) ? WM_LBUTTONDBLCLK : WM_LBUTTONDOWN, (WPARAM)(UINT)(p4), \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_LBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_LBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_LBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_LBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_RBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_RBUTTONDOWN( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, (p1) ? WM_RBUTTONDBLCLK : WM_RBUTTONDOWN, (WPARAM)(UINT)(p4), \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_RBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_RBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_RBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_RBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_MBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_MBUTTONDOWN( x, p1, p2, p3, p4 ) \
    (void)(f)( x, (p1) ? WM_MBUTTONDBLCLK : WM_MBUTTONDOWN, (WPARAM)(UINT)(p4), \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_MBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_MBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_MBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_MBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_MOUSEWHEEL( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), \
    (int)(short)HIWORD( p1 ), (int)(short)LOWORD( p1 ) ), 0L)
#define FORWARD_WM_MOUSEWHEEL( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, WM_MOUSEWHEEL, MAKEWPARAM( p4, p3 ), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_NCMOUSEMOVE( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCMOUSEMOVE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_NCMOUSEMOVE, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) ), 0L)
#define HANDLE_WM_NCLBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCLBUTTONDOWN( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, (p1) ? WM_NCLBUTTONDBLCLK : WM_NCLBUTTONDOWN, (WPARAM)(UINT)p4, \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_NCLBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_NCLBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCLBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_NCLBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_NCRBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCRBUTTONDOWN( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, (p1) ? WM_NCRBUTTONDBLCLK : WM_NCRBUTTONDOWN, (WPARAM)(UINT)p4, \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_NCRBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_NCRBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCRBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_NCRBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_NCMBUTTONDOWN( x, p1, p2, f ) \
    ((f)( x, FALSE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCMBUTTONDOWN( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, (p1) ? WM_NCMBUTTONDBLCLK : WM_NCMBUTTONDOWN, (WPARAM)(UINT)p4, \
    MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_NCMBUTTONDBLCLK( x, p1, p2, f ) \
    ((f)( x, TRUE, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define HANDLE_WM_NCMBUTTONUP( x, p1, p2, f ) \
    ((f)( x, (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ), (UINT)(p1) ), 0L)
#define FORWARD_WM_NCMBUTTONUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_NCMBUTTONUP, (WPARAM)(UINT)(p3), MAKELPARAM( p1, p2 ) )
#define HANDLE_WM_MOUSEACTIVATE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x, (HWND)(p1), (UINT)LOWORD( p2 ), (UINT)HIWORD( p2 ) )
#define FORWARD_WM_MOUSEACTIVATE( x, p1, p2, p3, f ) \
    (int)(DWORD)(f)( x, WM_MOUSEACTIVATE, (WPARAM)(HWND)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_CANCELMODE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_CANCELMODE( x, f ) \
    (void)(f)( x, WM_CANCELMODE, 0, 0L )
#define HANDLE_WM_TIMER( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1) ), 0L)
#define FORWARD_WM_TIMER( x, p, f ) \
    (void)(f)( x, WM_TIMER, (WPARAM)(UINT)(p), 0L )
#define HANDLE_WM_INITMENU( x, p1, p2, f ) \
    ((f)( x, (HMENU)(p1) ), 0L)
#define FORWARD_WM_INITMENU( x, p, f ) \
    (void)(f)( x, WM_INITMENU, (WPARAM)(HMENU)(p), 0L )
#define HANDLE_WM_INITMENUPOPUP( x, p1, p2, f ) \
    ((f)( x, (HMENU)(p1), (UINT)LOWORD( p2 ), (BOOL)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_INITMENUPOPUP( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_INITMENUPOPUP, (WPARAM)(HMENU)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_MENUSELECT( x, p1, p2, f ) \
    ((f)( x, (HMENU)(p2), (HIWORD( p1 ) & MF_POPUP) ? 0L : (int)LOWORD( p1 ), \
    (HIWORD( p1 ) & MF_POPUP) ? GetSubMenu( (HMENU)(p2), LOWORD( p1 ) ) : 0L, \
    (UINT)(((short)HIWORD( p1 ) == -1) ? 0xFFFFFFFFL : HIWORD( p1 )) ), 0L)
#define FORWARD_WM_MENUSELECT( x, p1, p2, p3, p4, f ) \
    (void)(f)( x, WM_MENUSELECT, MAKEWPARAM( p2, p4 ), \
    (LPARAM)(HMENU)((p1) ? (p1) : (p3)) )
#define HANDLE_WM_MENUCHAR( x, p1, p2, f ) \
    (LRESULT)(DWORD)(f)( x, (UINT)LOWORD( p1 ), (UINT)HIWORD( p1 ), (HMENU)(p2) )
#define FORWARD_WM_MENUCHAR( x, p1, p2, p3, f ) \
    (DWORD)(f)( x, WM_MENUCHAR, MAKEWPARAM( p2, (WORD)(p1) ), (LPARAM)(HMENU)(p3) )
#define HANDLE_WM_COMMAND( x, p1, p2, f ) \
    ((f)( x, (int)LOWORD( p1 ), (HWND)(p2), (UINT)HIWORD( p1 ) ), 0L)
#define FORWARD_WM_COMMAND( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_COMMAND, MAKEWPARAM( (UINT)(p1), (UINT)(p3) ), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_HSCROLL( x, p1, p2, f ) \
    ((f)( x, (HWND)(p2), (UINT)LOWORD( p1 ), (int)(short)HIWORD( p1 ) ), 0L)
#define FORWARD_WM_HSCROLL( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_HSCROLL, MAKEWPARAM( (UINT)(int)(p2), (UINT)(int)(p3) ), \
    (LPARAM)(HWND)(p1) )
#define HANDLE_WM_VSCROLL( x, p1, p2, f ) \
    ((f)( x, (HWND)(p2), (UINT)LOWORD( p1 ), (int)(short)HIWORD( p1 ) ), 0L)
#define FORWARD_WM_VSCROLL( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_VSCROLL, MAKEWPARAM( (UINT)(int)(p2), (UINT)(int)(p3) ), \
    (LPARAM)(HWND)(p1) )
#define HANDLE_WM_CUT( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_CUT( x, f ) \
    (void)(f)( x, WM_CUT, 0, 0L )
#define HANDLE_WM_COPY( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_COPY( x, f ) \
    (void)(f)( x, WM_COPY, 0, 0L )
#define HANDLE_WM_PASTE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_PASTE( x, f ) \
    (void)(f)( x, WM_PASTE, 0, 0L )
#define HANDLE_WM_CLEAR( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_CLEAR( x, f ) \
    (void)(f)( x, WM_CLEAR, 0, 0L )
#define HANDLE_WM_UNDO( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_UNDO( x, f ) \
    (void)(f)( x, WM_UNDO, 0, 0L )
#define HANDLE_WM_RENDERFORMAT( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HANDLE)(f)( x, (UINT)(p1) )
#define FORWARD_WM_RENDERFORMAT( x, p, f ) \
    (HANDLE)(UINT_PTR)(f)( x, WM_RENDERFORMAT, (WPARAM)(UINT)(p), 0L )
#define HANDLE_WM_RENDERALLFORMATS( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_RENDERALLFORMATS( x, f ) \
    (void)(f)( x, WM_RENDERALLFORMATS, 0, 0L )
#define HANDLE_WM_DESTROYCLIPBOARD( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_DESTROYCLIPBOARD( x, f ) \
    (void)(f)( x, WM_DESTROYCLIPBOARD, 0, 0L )
#define HANDLE_WM_DRAWCLIPBOARD( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_DRAWCLIPBOARD( x, f ) \
    (void)(f)( x, WM_DRAWCLIPBOARD, 0, 0L )
#define HANDLE_WM_PAINTCLIPBOARD( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (const LPPAINTSTRUCT)GlobalLock( (HGLOBAL)(p2) ) ), \
    GlobalUnlock( (HGLOBAL)(p2) ), 0L)
#define FORWARD_WM_PAINTCLIPBOARD( x, p1, p2, f ) \
    (void)(f)( x, WM_PAINTCLIPBOARD, (WPARAM)(HWND)(p1), (LPARAM)(LPPAINTSTRUCT)(p2) )
#define HANDLE_WM_SIZECLIPBOARD( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (const LPRECT)GlobalLock( (HGLOBAL)(p2) ) ), \
    GlobalUnlock( (HGLOBAL)(p2) ), 0L)
#define FORWARD_WM_SIZECLIPBOARD( x, p1, p2, f ) \
    (void)(f)( x, WM_SIZECLIPBOARD, (WPARAM)(HWND)(p1), (LPARAM)(LPRECT)(p2) )
#define HANDLE_WM_VSCROLLCLIPBOARD( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (UINT)LOWORD( p2 ), (int)(short)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_VSCROLLCLIPBOARD( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_VSCROLLCLIPBOARD, (WPARAM)(HWND)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_HSCROLLCLIPBOARD( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (UINT)LOWORD( p2 ), (int)(short)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_HSCROLLCLIPBOARD( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_HSCROLLCLIPBOARD, (WPARAM)(HWND)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_ASKCBFORMATNAME( x, p1, p2, f ) \
    ((f)( x, (int)(p1), (LPTSTR)(p2) ), 0L)
#define FORWARD_WM_ASKCBFORMATNAME( x, p1, p2, f ) \
    (void)(f)( x, WM_ASKCBFORMATNAME, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define HANDLE_WM_CHANGECBCHAIN( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (HWND)(p2) ), 0L)
#define FORWARD_WM_CHANGECBCHAIN( x, p1, p2, f ) \
    (void)(f)( x, WM_CHANGECBCHAIN, (WPARAM)(HWND)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_SETCURSOR( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (HWND)(p1), (UINT)LOWORD( p2 ), (UINT)HIWORD( p2 ) )
#define FORWARD_WM_SETCURSOR( x, p1, p2, p3, f ) \
    (BOOL)(DWORD)(f)( x, WM_SETCURSOR, (WPARAM)(HWND)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_SYSCOMMAND( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), (int)(short)LOWORD( p2 ), (int)(short)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_SYSCOMMAND( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_SYSCOMMAND, (WPARAM)(UINT)(p1), MAKELPARAM( p2, p3 ) )
#define HANDLE_WM_MDICREATE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(f)( x, (LPMDICREATESTRUCT)(p2) )
#define FORWARD_WM_MDICREATE( x, p, f ) \
    (HWND)(UINT)(DWORD)(f)( x, WM_MDICREATE, 0, (LPARAM)(LPMDICREATESTRUCT)(p) )
#define HANDLE_WM_MDIDESTROY( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_MDIDESTROY( x, p, f ) \
    (void)(f)( x, WM_MDIDESTROY, (WPARAM)(p), 0L )
#define HANDLE_WM_MDIACTIVATE( x, p1, p2, f ) \
    ((f)( x, (BOOL)((p2) == (LPARAM)(x)), (HWND)(p2), (HWND)(p1) ), 0L)
#define FORWARD_WM_MDIACTIVATE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_MDIACTIVATE, (WPARAM)(p2), (LPARAM)(p1) )
#define HANDLE_WM_MDIRESTORE( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_MDIRESTORE( x, p, f ) \
    (void)(f)( x, WM_MDIRESTORE, (WPARAM)(p), 0L)
#define HANDLE_WM_MDINEXT( x, p1, p2, f ) \
    (LRESULT)(HWND)(f)( x, (HWND)(p1), (BOOL)(p2) )
#define FORWARD_WM_MDINEXT( x, p1, p2, f ) \
    (HWND)(UINT_PTR)(f)( x, WM_MDINEXT, (WPARAM)(p1), (LPARAM)(p2) )
#define HANDLE_WM_MDIMAXIMIZE( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1) ), 0L)
#define FORWARD_WM_MDIMAXIMIZE( x, p, f ) \
    (void)(f)( x, WM_MDIMAXMIZE, (WPARAM)(p), 0L )
#define HANDLE_WM_MDITILE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(f)( x, (UINT)(p1) )
#define FORWARD_WM_MDITILE( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_MDITILE, (WPARAM)(p), 0L )
#define HANDLE_WM_MDICASCADE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(f)( x, (UINT)(p1) )
#define FORWARD_WM_MDICASCADE( x, p, f ) \
    (BOOL)(DWORD)(f)( x, WM_MDICASCADE, (WPARAM)(p), 0L )
#define HANDLE_WM_MDIICONARRANGE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_MDIICONARRANGE( x, f ) \
    (void)(f)( x, WM_MDIICONARRANGE, 0, 0L )
#define HANDLE_WM_MDIGETACTIVE( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(f)( x )
#define FORWARD_WM_MDIGETACTIVE( x, f ) \
    (HWND)(UINT_PTR)(f)( x, WM_MDIGETACTIVE, 0, 0L )
#define HANDLE_WM_MDISETMENU( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(f)( x, (BOOL)(p1), (HMENU)(p1), (HMENU)(p2) )
#define FORWARD_WM_MDISETMENU( x, p1, p2, p3, f ) \
    (HMENU)(UINT_PTR)(f)( x, WM_MDISETMENU, (WPARAM)((p1) ? (p2) : 0), (LPARAM)(p3) )
#define HANDLE_WM_CHILDACTIVATE( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_CHILDACTIVATE( x, f ) \
    (void)(f)( x, WM_CHILDACTIVATE, 0, 0L )
#define HANDLE_WM_INITDIALOG( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(BOOL)(f)( x, (HWND)(p1), p2 )
#define FORWARD_WM_INITDIALOG( x, p1, p2, f ) \
    (BOOL)(DWORD)(f)( x, WM_INITDIALOG, (WPARAM)(HWND)(p1), p2 )
#define HANDLE_WM_NEXTDLGCTL( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HWND)(f)( x, (HWND)(p1), (BOOL)(p2) )
#define FORWARD_WM_NEXTDLGCTL( x, p1, p2, f ) \
    (HWND)(UINT_PTR)(f)( x, WM_NEXTDLGCTL, (WPARAM)(HWND)(p1), (LPARAM)(p2) )
#define HANDLE_WM_PARENTNOTIFY( x, p1, p2, f ) \
    ((f)( x, (UINT)LOWORD( p1 ), (HWND)(p2), (UINT)HIWORD( p1) ), 0L)
#define FORWARD_WM_PARENTNOTIFY( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_PARENTNOTIFY, MAKEWPARAM( p1, p3 ), (LPARAM)(p2) )
#define HANDLE_WM_ENTERIDLE( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), (HWND)(p2) ), 0L)
#define FORWARD_WM_ENTERIDLE( x, p1, p2, f ) \
    (void)(f)( x, WM_ENTERIDLE, (WPARAM)(UINT)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_GETDLGCODE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(UINT)(f)( x, (LPMSG)(p2) )
#define FORWARD_WM_GETDLGCODE( x, p, f ) \
    (UINT)(DWORD)(f)( x, WM_GETDLGCODE, ((p) ? (p)->wParam : 0), (LPARAM)(LPMSG)(p) )
#define HANDLE_WM_CTLCOLORMSGBOX( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_MSGBOX )
#define FORWARD_WM_CTLCOLORMSGBOX( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORMSGBOX, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLOREDIT( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_EDIT )
#define FORWARD_WM_CTLCOLOREDIT( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLOREDIT, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLORLISTBOX( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_LISTBOX )
#define FORWARD_WM_CTLCOLORLISTBOX( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORLISTBOX, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLORBTN( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_BTN )
#define FORWARD_WM_CTLCOLORBTN( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORBTN, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLORDLG( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_DLG )
#define FORWARD_WM_CTLCOLORDLG( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORDLG, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLORSCROLLBAR( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_SCROLLBAR )
#define FORWARD_WM_CTLCOLORSCROLLBAR( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORSCROLLBAR, (WPARAM)(HDC)(p1), \
    (LPARAM)(HWND)(p2) )
#define HANDLE_WM_CTLCOLORSTATIC( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HBRUSH)(f)( x, (HDC)(p1), (HWND)(p2), CTLCOLOR_STATIC )
#define FORWARD_WM_CTLCOLORSTATIC( x, p1, p2, f ) \
    (HBRUSH)(UINT_PTR)(f)( x, WM_CTLCOLORSTATIC, (WPARAM)(HDC)(p1), (LPARAM)(HWND)(p2) )
#define HANDLE_WM_SETFONT( x, p1, p2, f ) \
    ((f)( x, (HFONT)(p1), (BOOL)(p2) ), 0L)
#define FORWARD_WM_SETFONT( x, p1, p2, f ) \
    (void)(f)( x, WM_SETFONT, (WPARAM)(HFONT)(p1), (LPARAM)(BOOL)(p2) )
#define HANDLE_WM_GETFONT( x, p1, p2, f ) \
    (LRESULT)(UINT_PTR)(HFONT)(f)( x )
#define FORWARD_WM_GETFONT( x, f ) \
    (HFONT)(UINT_PTR)(f)( x, WM_GETFONT, 0, 0L )
#define HANDLE_WM_DRAWITEM( x, p1, p2, f ) \
    ((f)( x, (const DRAWITEMSTRUCT *)(p2) ), 0L)
#define FORWARD_WM_DRAWITEM( x, p, f ) \
    (void)(f)( x, WM_DRAWITEM, (WPARAM)(((const DRAWITEMSTRUCT *)(p))->CtlID), \
    (LPARAM)(const DRAWITEMSTRUCT *)(p) )
#define HANDLE_WM_MEASUREITEM( x, p1, p2, f ) \
    ((f)( x, (MEASUREITEMSTRUCT *)(p2) ), 0L)
#define FORWARD_WM_MEASUREITEM( x, p, f ) \
    (void)(f)( x, WM_MEASUREITEM, (WPARAM)(((MEASUREITEMSTRUCT *)(p))->CtlID), \
    (LPARAM)(MEASUREITEMSTRUCT *)(p) )
#define HANDLE_WM_DELETEITEM( x, p1, p2, f ) \
    ((f)( x, (const DELETEITEMSTRUCT *)(p2) ), 0L)
#define FORWARD_WM_DELETEITEM( x, p, f ) \
    (void)(f)( x, WM_DELETEITEM, (WPARAM)(((const DELETEITEMSTRUCT *)(p))->CtlID), \
    (LPARAM)(const DELETEITEMSTRUCT *)(p) )
#define HANDLE_WM_COMPAREITEM( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x, (const COMPAREITEMSTRUCT *)(p) )
#define FORWARD_WM_COMPAREITEM( x, p, f ) \
    (int)(DWORD)(f)( x, WM_COMPAREITEM, \
    (WPARAM)(((const COMPAREITEMSTRUCT *)(p))->CtlID), \
    (LPARAM)(const COMPAREITEMSTRUCT *)(p) )
#define HANDLE_WM_VKEYTOITEM( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x, (UINT)LOWORD( p1 ), (HWND)(p2), \
    (int)(short)HIWORD( p1 ) )
#define FORWARD_WM_VKEYTOITEM( x, p1, p2, p3, f ) \
    (int)(DWORD)(f)( x, WM_VKEYTOITEM, MAKEWPARAM( p1, p3 ), (LPARAM)(p2) )
#define HANDLE_WM_CHARTOITEM( x, p1, p2, f ) \
    (LRESULT)(DWORD)(int)(f)( x, (UINT)LOWORD( p1 ), (HWND)(p2), \
    (int)(short)HIWORD( p1 ) )
#define FORWARD_WM_CHARTOITEM( x, p1, p2, p3, f ) \
    (int)(DWORD)(f)( x, WM_CHARTOITEM, MAKEWPARAM( (UINT)(p1), (UINT)(p3) ), \
    (LPARAM)(p2) )
#define HANDLE_WM_QUEUESYNC( x, p1, p2, f ) \
    ((f)( x ), 0L)
#define FORWARD_WM_QUEUESYNC( x, f ) \
    (void)(f)( x, WM_QUEUESYNC, 0, 0L )
#if (WINVER >= 0x030A)
    #define HANDLE_WM_COMMNOTIFY( x, p1, p2, f ) \
        ((f)( x, (int)(p1), (UINT)LOWORD( p2 ) ), 0L)
    #define FORWARD_WM_COMMNOTIFY( x, p1, p2, f ) \
        (void)(f)( x, WM_COMMNOTIFY, (WPARAM)(p1), MAKELPARAM( p2, 0 ) )
#endif
#define HANDLE_WM_DISPLAYCHANGE( x, p1, p2, f ) \
    ((f)( x, (UINT)(p1), (UINT)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_DISPLAYCHANGE( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_DISPLAYCHANGE, (WPARAM)(UINT)(p1), MAKELPARAM( (UINT)(p1), \
    (UINT)(p2) ) )
#define HANDLE_WM_DEVICECHANGE( x, p1, p2, f ) \
    (LRESULT)(DWORD)(BOOL)(f)( x, (UINT)(p1), (DWORD)(p1) )
#define FORWARD_WM_DEVICECHANGE( x, p1, p2, f ) \
    (BOOL)(DWORD)(f)( x, WM_DEVICECHANGE, (WPARAM)(UINT)(p1), (LPARAM)(DWORD)(p2) )
#define HANDLE_WM_CONTEXTMENU( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (UINT)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_CONTEXTMENU( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_CONTEXTMENU, (WPARAM)(HWND)(p1), MAKELPARAM( (UINT)(p1), (UINT)(p2) ) )
#define HANDLE_WM_COPYDATA( x, p1, p2, f ) \
    ((f)( x, (HWND)(p1), (PCOPYDATASTRUCT)(p2) ), 0L)
#define FORWARD_WM_COPYDATA( x, p1, p2, f ) \
    (BOOL)(UINT)(DWORD)(f)( x, WM_COPYDATA, (WPARAM)(p1), (LPARAM)(p2) )
#define HANDLE_WM_HOTKEY( x, p1, p2, f ) \
    ((f)( x, (int)(p1), (UINT)LOWORD( p2 ), (UINT)HIWORD( p2 ) ), 0L)
#define FORWARD_WM_HOTKEY( x, p1, p2, p3, f ) \
    (void)(f)( x, WM_HOTKEY, (WPARAM)(p1), MAKELPARAM( p1, p2 ) )

/* Message parameter packing macros */
#define GET_WPARAM( p1, p2 )                    (p1)
#define GET_LPARAM( p1, p2 )                    (p2)
#ifndef GET_X_LPARAM
    #define GET_X_LPARAM( p )                   ((int)(short)LOWORD( p ))
#endif
#ifndef GET_Y_LPARAM
    #define GET_Y_LPARAM( p )                   ((int)(short)HIWORD( p ))
#endif
#define GET_WM_ACTIVATE_STATE( p1, p2 )         LOWORD( p1 )
#define GET_WM_ACTIVATE_FMINIMIZED( p1, p2 )    (BOOL)HIWORD( p1 )
#define GET_WM_ACTIVATE_HWND( p1, p2 )          (HWND)(p2)
#define GET_WM_ACTIVATE_MPS( p1, p2, p3 )       (WPARAM)MAKELONG( p1, p2 ), (LPARAM)(p3)
#define GET_WM_CHARTOITEM_CHAR( p1, p2 )        (TCHAR)LOWORD( p1 )
#define GET_WM_CHARTOITEM_POS( p1, p2 )         HIWORD( p1 )
#define GET_WM_CHARTOITEM_HWND( p1, p2 )        (HWND)(p2)
#define GET_WM_CHARTOITEM_MPS( p1, p2, p3 )     (WPARAM)MAKELONG( p2, p1 ), (LPARAM)(p3)
#define GET_WM_COMMAND_ID( p1, p2 )             LOWORD( p1 )
#define GET_WM_COMMAND_HWND( p1, p2 )           (HWND)(p2)
#define GET_WM_COMMAND_CMD( p1, p2 )            HIWORD( p1 )
#define GET_WM_COMMAND_MPS( p1, p2, p3 )        (WPARAM)MAKELONG( p1, p3 ), (LPARAM)(p2)
#define GET_WM_CTLCOLOR_HDC( p1, p2, p3 )       (HDC)(p1)
#define GET_WM_CTLCOLOR_HWND( p1, p2, p3 )      (HWND)(p1)
#define GET_WM_CTLCOLOR_TYPE( p1, p2, p3 )      (WORD)((p3) - WM_CTLCOLORMSGBOX)
#define GET_WM_CTLCOLOR_MSG( x )                (WORD)(WM_CTLCOLORMSGBOX + (x))
#define GET_WM_CTLCOLOR_MPS( p1, p2, p3 )       (WPARAM)(p1), (LPARAM)(p2)
#define GET_WM_MENUSELECT_CMD( p1, p2 )         LOWORD( p1 )
#define GET_WM_MENUSELECT_FLAGS( p1, p2 )       (UINT)(int)(short)HIWORD( p1 )
#define GET_WM_MENUSELECT_HMENU( p1, p2 )       (HMENU)(p2)
#define GET_WM_MENUSELECT_MPS( p1, p2, p3 )     (WPARAM)MAKELONG( p1, p2 ), (LPARAM)(p3)
#define GET_WM_MDIACTIVATE_FACTIVATE( p1, p2, p3 )  ((p3) == (LPARAM)(p1))
#define GET_WM_MDIACTIVATE_HWNDDEACT( p1, p2 )  (HWND)(p1)
#define GET_WM_MDIACTIVATE_HWNDACTIVATE( p1, p2 )   (HWND)(p2)
#define GET_WM_MDIACTIVATE_MPS( p1, p2, p3 )    (WPARAM)(p3), 0L
#define GET_WM_MDISETMENU_MPS( p1, p2 )         (WPARAM)(p1), (LPARAM)(p2)
#define GET_WM_MENUCHAR_CHAR( p1, p2 )          (TCHAR)LOWORD( p1 )
#define GET_WM_MENUCHAR_HMENU( p1, p2 )         (HMENU)(p2)
#define GET_WM_MENUCHAR_FMENU( p1, p2 )         (BOOL)HIWORD( p1 )
#define GET_WM_MENUCHAR_MPS( p1, p2, p3 )       (WPARAM)MAKELONG( p1, p3 ), (LPARAM)(p2)
#define GET_WM_PARENTNOTIFY_MSG( p1, p2 )       LOWORD( p1 )
#define GET_WM_PARENTNOTIFY_ID( p1, p2 )        HIWORD( p1 )
#define GET_WM_PARENTNOTIFY_HWNDCHILD( p1, p2 ) (HWND)(p2)
#define GET_WM_PARENTNOTIFY_X( p1, p2 )         (int)(short)LOWORD( p2 )
#define GET_WM_PARENTNOTIFY_Y( p1, p2 )         (int)(short)HIWORD( p2 )
#define GET_WM_PARENTNOTIFY_MPS( p1, p2, p3 )   (WPARAM)MAKELONG( p2, p1 ), (LPARAM)(p3)
#define GET_WM_PARENTNOTIFY2_MPS( p1, p2, p3 ) \
    (WPARAM)MAKELONG( 0, p1 ), MAKELONG( p2, p3 )
#define GET_WM_VKEYTOITEM_CODE( p1, p2 )        (int)(short)LOWORD( p1 )
#define GET_WM_VKEYTOITEM_ITEM( p1, p2 )        HIWORD( p1 )
#define GET_WM_VKEYTOITEM_HWND( p1, p2 )        (HWND)(p2)
#define GET_WM_VKEYTOITEM_MPS( p1, p2, p3 )     (WPARAM)MAKELONG( p2, p1 ), (LPARAM)(p3)
#define GET_EM_SETSEL_START( p1, p2 )           (INT)(p1)
#define GET_EM_SETSEL_END( p1, p2 )             (p2)
#define GET_EM_SETSEL_MPS( p1, p2 )             (WPARAM)(p1), (LPARAM)(p2)
#define GET_EM_LINESCROLL_MPS( p1, p2 )         (WPARAM)(p1), (LPARAM)(p2)
#define GET_WM_CHANGECBCHAIN_HWNDNEXT( p1, p2 ) (HWND)(p2)
#define GET_WM_HSCROLL_CODE( p1, p2 )           LOWORD( p1 )
#define GET_WM_HSCROLL_POS( p1, p2 )            HIWORD( p1 )
#define GET_WM_HSCROLL_HWND( p1, p2 )           (HWND)(p2)
#define GET_WM_HSCROLL_MPS( p1, p2, p3 )        (WPARAM)MAKELONG( p1, p2 ), (LPARAM)(p3)
#define GET_WM_VSCROLL_CODE( p1, p2 )           LOWORD( p1 )
#define GET_WM_VSCROLL_POS( p1, p2 )            HIWORD( p1 )
#define GET_WM_VSCROLL_HWND( p1, p2 )           (HWND)(p2)
#define GET_WM_VSCROLL_MPS( p1, p2, p3 )        (WPARAM)MAKELONG( p1, p2 ), (LPARAM)(p3)

/* Macro for Win16 compatibility */
#ifndef DECLARE_HANDLE32
    #define DECLARE_HANDLE32    DECLARE_HANDLE
#endif

/* C runtime aliases */
#define _ncalloc    calloc
#define _nexpand    _expand
#define _ffree      free
#define _fmalloc    malloc
#define _fmemccpy   _memccpy
#define _fmemchr    memchr
#define _fmemcmp    memcmp
#define _fmemcpy    memcpy
#define _fmemicmp   _memicmp
#define _fmemmove   memmove
#define _fmemset    memset
#define _fmsize     _msize
#define _frealloc   realloc
#define _fstrcat    strcat
#define _fstrchr    strchr
#define _fstrcmp    strcmp
#define _fstrcpy    strcpy
#define _fstrcspn   strcspn
#define _fstrdup    _strdup
#define _fstricmp   _stricmp
#define _fstrlen    strlen
#define _fstrlwr    _strlwr
#define _fstrncat   strncat
#define _fstrncmp   strncmp
#define _fstrncpy   strncpy
#define _fstrnicmp  _strnicmp
#define _fstrnset   _strnset
#define _fstrpbrk   strpbrk
#define _fstrrchr   strrchr
#define _fstrrev    _strrev
#define _fstrset    _strset
#define _fstrspn    strspn
#define _fstrstr    strstr
#define _fstrtok    strtok
#define _fstrupr    _strupr
#define _nfree      free
#define _nmalloc    malloc
#define _nmsize     _msize
#define _nrealloc   realloc
#define _nstrdup    _strdup
#define hmemcpy     MoveMemory

/* Functions implemented as macros */
#define GetInstanceModule( x )      (HMODULE)(x)
#define GlobalPtrHandle( x )        ((HGLOBAL)GlobalHandle( x ))
#define GlobalLockPtr( x )          ((BOOL)GlobalLock( GlobalPtrHandle( x ) ))
#define GlobalUnlockPtr( x )        GlobalUnlock( GlobalPtrHandle( x ) )
#define GlobalAllocPtr( p1, p2 )    GlobalLock( GlobalAlloc( p1, p2 ) )
#define GlobalReAllocPtr( x, p1, p2 ) \
    (GlobalUnlockPtr( x ), GlobalLock( GlobalReAlloc( GlobalPtrHandle( x ), p1, p2 ) ))
#define GlobalFreePtr( x ) \
    (GlobalUnlockPtr( x ), (BOOL)(ULONG_PTR)GlobalFree( GlobalPtrHandle( x ) ))
#define DeletePen( x )              DeleteObject( (HGDIOBJ)(HPEN)(x) )
#define SelectPen( x, p )           ((HPEN)SelectObject( x, (HGDIOBJ)(HPEN)(x) ))
#define GetStockPen( x )            ((HPEN)GetStockObject( x ))
#define DeleteBrush( x )            DeleteObject( (HGDIOBJ)(HBRUSH)(x) )
#define SelectBrush( x, p )         ((HBRUSH)SelectObject( x, (HGDIOBJ)(HBRUSH)(x) ))
#define GetStockBrush( x )          ((HBRUSH)GetStockObject( x ))
#define DeleteRgn( x )              DeleteObject( (HGDIOBJ)(HRGN)(x) )
#define CopyRgn( x, p )             CombineRgn( x, p, 0, RGN_COPY )
#define IntersectRgn( x, p1, p2 )   CombineRgn( x, p1, p2, RGN_AND )
#define SubtractRgn( x, p1, p2 )    CombineRgn( x, p1, p2, RGN_DIFF )
#define UnionRgn( x, p1, p2 )       CombineRgn( x, p1, p2, RGN_OR )
#define XorRgn( x, p1, p2 )         CombineRgn( x, p1, p2, RGN_XOR )
#define DeletePalette( x )          DeleteObject( (HGDIOBJ)(HPALETTE)(x) )
#define DeleteFont( x )             DeleteObject( (HGDIOBJ)(HFONT)(x) )
#define SelectFont( x, p )          ((HFONT)SelectObject( x, (HGDIOBJ)(HFONT)(p) ))
#define GetStockFont( x )           ((HFONT)GetStockObject( x ))
#define DeleteBitmap( x )           DeleteObject( (HGDIOBJ)(HBITMAP)(x) )
#define SelectBitmap( x, p )        ((HBITMAP)SelectObject( x, (HGDIOBJ)(HBITMAP)(p) ))
#define InsetRect( x, p1, p2 )      InflateRect( x, -(p1), -(p2) )
#define GetWindowInstance( x )      ((HMODULE)GetWindowLongPtr( x, GWLP_HINSTANCE ))
#define GetWindowStyle( x )         ((DWORD)GetWindowLong( x, GWL_STYLE ))
#define GetWindowExStyle( x )       ((DWORD)GetWindowLong( x, GWL_EXSTYLE ))
#define GetWindowOwner( x )         GetWindow( x, GW_OWNER )
#define GetFirstChild( x )          GetTopWindow( x )
#define GetFirstSibling( x )        GetWindow( x, GW_HWNDFIRST )
#define GetLastSibling( x )         GetWindow( x, GW_HWNDLAST )
#define GetNextSibling( x )         GetWindow( x, GW_HWNDNEXT )
#define GetPrevSibling( x )         GetWindow( x, GW_HWNDPREV )
#define GetWindowID( x )            GetDlgCtrlID( x )
#define SetWindowRedraw( x, p ) \
    ((void)SNDMSG( x, WM_SETREDRAW, (WPARAM)(BOOL)(p), 0L ))
#define SubclassWindow( x, p ) \
    ((WNDPROC)SetWindowLongPtr( x, GWLP_WNDPROC, (LPARAM)(WNDPROC)(p) ))
#define IsMinimized( x )            IsIconic( x )
#define IsMaximized( x )            IsZoomed( x )
#define IsRestored( x ) \
    ((GetWindowStyle( x ) & (WS_MINIMIZE | WS_MAXIMIZE)) == 0L)
#define SetWindowFont( x, p1, p2 )  FORWARD_WM_SETFONT( x, p1, p2, SNDMSG )
#define GetWindowFont( x )          FORWARD_WM_GETFONT( x, SNDMSG )
#if (WINVER >= 0x030A)
    #define MapWindowRect( p1, p2, p3 ) \
        MapWindowPoints( p1, p2, (POINT *)(p3), 2 )
#endif
#define IsLButtonDown()             (GetKeyState( VK_LBUTTON ) < 0)
#define IsRButtonDown()             (GetKeyState( VK_RBUTTON ) < 0)
#define IsMButtonDown()             (GetKeyState( VK_MBUTTON ) < 0)
#define SubclassDialog( x, p ) \
    SetWindowLongPtr( x, DWLP_DLGPROC, (LPARAM)(p) )
#define SetDlgMsgResult( x, p1, p2 ) \
    (((p1) == WM_CTLCOLORMSGBOX || (p1) == WM_CTLCOLOREDIT || \
    (p1) == WM_CTLCOLORLISTBOX || (p1) == WM_CTLCOLORBTN || (p1) == WM_CTLCOLORDLG || \
    (p1) == WM_CTLCOLORSCROLLBAR || (p1) == WM_CTLCOLORSTATIC || \
    (p1) == WM_COMPAREITEM || (p1) == WM_VKEYTOITEM || (p1) == WM_CHARTOITEM || \
    (p1) == WM_QUERYDRAGICON || (p1) == WM_INITDIALOG) ? (BOOL)(p2) : \
    (SetWindowLongPtr( x, DWLP_MSGRESULT, (LPARAM)(LRESULT)(p2) ), TRUE))
#define DefDlgProcEx( x, p1, p2, p3, p4 ) \
    (*(p4) = TRUE, DefDlgProc( x, p1, p2, p3 ))
#define CheckDefDlgRecursion( x ) \
    if( *(x) ) { \
        *(x) = FALSE; \
        return FALSE; \
    }
#define Static_Enable( x, p )       EnableWindow( x, p )
#define Static_GetText( x, p1, p2 ) GetWindowText( x, p1, p2 )
#define Static_GetTextLength( x )   GetWindowTextLength( x )
#define Static_SetText( x, p )      SetWindowText( x, p )
#define Static_SetIcon( x, p ) \
    (HICON)(UINT_PTR)SNDMSG( x, STM_SETICON, (WPARAM)(HICON)(p), 0L )
#define Static_GetIcon( x, p ) \
    (HICON)(UINT_PTR)SNDMSG( x, STM_GETICON, 0, 0L )
#define Button_Enable( x, p )       EnableWindow( x, p )
#define Button_GetText( x, p1, p2 ) GetWindowText( x, p1, p2 )
#define Button_GetTextLength( x )   GetWindowTextLength( x )
#define Button_SetText( x, p )      SetWindowText( x, p )
#define Button_GetCheck( x ) \
    (int)(DWORD)SNDMSG( x, BM_GETCHECK, 0, 0L )
#define Button_SetCheck( x, p ) \
    (void)SNDMSG( x, BM_SETCHECK, (WPARAM)(int)(p), 0L )
#define Button_GetState( x ) \
    (int)(DWORD)SNDMSG( x, BM_GETSTATE, 0, 0L )
#define Button_SetState( x, p ) \
    (UINT)(DWORD)SNDMSG( x, BM_SETSTATE, (WPARAM)(int)(p), 0L )
#define Button_SetStyle( x, p1, p2 ) \
    (void)SNDMSG( x, BM_SETSTYLE, (WPARAM)LOWORD( p1 ), \
    MAKELPARAM( ((p2) ? TRUE : FALSE), 0 ) )
#define Edit_Enable( x, p )         EnableWindow( x, p )
#define Edit_GetText( x, p1, p2 )   GetWindowText( x, p1, p2 )
#define Edit_GetTextLength( x )     GetWindowTextLength( x )
#define Edit_SetText( x, p )        SetWindowText( x, p )
#define Edit_LimitText( x, p ) \
    (void)SNDMSG( x, EM_LIMITTEXT, (WPARAM)(p), 0L )
#define Edit_GetLineCount( x ) \
    (int)(DWORD)SNDMSG( x, EM_GETLINECOUNT, 0, 0L )
#define Edit_GetLine( x, p1, p2, p3 ) \
    ((*((int *)(p2)) = (p3)), (int)(DWORD)SNDMSG( x, EM_GETLINE, (WPARAM)(int)(p1), \
    (LPARAM)(LPTSTR)(p2) ))
#define Edit_GetRect( x, p ) \
    (void)SNDMSG( x, EM_GETRECT, 0, (LPARAM)(RECT *)(p) )
#define Edit_SetRect( x, p ) \
    (void)SNDMSG( x, EM_SETRECT, 0, (LPARAM)(const RECT *)(p) )
#define Edit_SetRectNoPaint( x, p ) \
    (void)SNDMSG( x, EM_SETRECTNP, 0, (LPARAM)(const RECT *)(p) )
#define Edit_GetSel( x ) \
    (DWORD)SNDMSG( x, EM_GETSEL, 0, 0L )
#define Edit_SetSel( x, p1, p2 ) \
    (void)SNDMSG( x, EM_SETSEL, p1, p2 ) 
#define Edit_ReplaceSel( x, p ) \
    (void)SNDMSG( x, EM_REPLACESEL, 0, (LPARAM)(LPCTSTR)(p) )
#define Edit_GetModify( x ) \
    (BOOL)(DWORD)SNDMSG( x, EM_GETMODIFY, 0, 0L )
#define Edit_SetModify( x, p ) \
    (void)SNDMSG( x, EM_SETMODIFY, (WPARAM)(UINT)(p), 0L )
#define Edit_ScrollCaret( x ) \
    (BOOL)(DWORD)SNDMSG( x, EM_SCROLLCARET, 0, 0L )
#define Edit_LineFromChar( x, p ) \
    (int)(DWORD)SNDMSG( x, EM_LINEFROMCHAR, (WPARAM)(int)(p), 0L )
#define Edit_LineIndex( x, p ) \
    (int)(DWORD)SNDMSG( x, EM_LINEINDEX, (WPARAM)(int)(p), 0L )
#define Edit_LineLength( x, p ) \
    (int)(DWORD)SNDMSG( x, EM_LINELENGTH, (WPARAM)(int)(p), 0L )
#define Edit_Scroll( x, p1, p2 ) \
    (void)SNDMSG( x, EM_LINESCROLL, (WPARAM)(p2), (LPARAM)(p1) )
#define Edit_CanUndo( x ) \
    (BOOL)(DWORD)SNDMSG( x, EM_CANUNDO, 0, 0L )
#define Edit_Undo( x ) \
    (BOOL)(DWORD)SNDMSG( x, EM_UNDO, 0, 0L )
#define Edit_EmptyUndoBuffer( x ) \
    (void)SNDMSG( x, EM_EMPTYUNDOBUFFER, 0, 0L )
#define Edit_SetPasswordChar( x, p ) \
    (void)SNDMSG( x, EM_SETPASSWORDCHAR, (WPARAM)(UINT)(p), 0L )
#define Edit_SetTabStops( x, p1, p2 ) \
    (void)SNDMSG( x, EM_SETTABSTOPS, (WPARAM)(int)(p1), (LPARAM)(const int *)(p2) )
#define Edit_FmtLines( x, p ) \
    (BOOL)(DWORD)SNDMSG( x, EM_FMTLINES, (WPARAM)(BOOL)(p), 0L )
#define Edit_GetHandle( x ) \
    (HLOCAL)(UINT_PTR)SNDMSG( x, EM_GETHANDLE, 0, 0L )
#define Edit_SetHandle( x, p ) \
    (void)SNDMSG( x, EM_SETHANDLE, (WPARAM)(UINT_PTR)(HLOCAL)(p), 0L )
#if (WINVER >= 0x030A)
    #define Edit_GetFirstVisibleLine( x ) \
        (int)(DWORD)SNDMSG( x, EM_GETFIRSTVISIBLELINE, 0, 0L )
    #define Edit_SetReadOnly( x, p ) \
        (BOOL)(DWORD)SNDMSG( x, EM_SETREADONLY, (WPARAM)(BOOL)(p), 0L )
    #define Edit_GetPasswordChar( x ) \
        (TCHAR)(DWORD)SNDMSG( x, EM_GETPASSWORDCHAR, 0, 0L )
    #define Edit_SetWordBreakProc( x, p ) \
        (void)SNDMSG( x, EM_SETWORDBREAKPROC, 0, (LPARAM)(EDITWORDBREAKPROC)(p) )
    #define Edit_GetWordBreakProc( x ) \
        (EDITWORDBREAKPROC)SNDMSG( x, EM_GETWORDBREAKPROC, 0, 0L )
#endif
#define ScrollBar_Enable( x, p )    EnableScrollBar( x, SB_CTL, p )
#define ScrollBar_Show( x, p )      ShowWindow( x, (p) ? SW_SHOWNORMAL : SW_HIDE )
#define ScrollBar_SetPos( x, p1, p2 ) \
    SetScrollPos( x, SB_CTL, p1, p2 )
#define ScrollBar_GetPos( x ) \
    GetScrollPos( x, SB_CTL )
#define ScrollBar_SetRange( x, p1, p2, p3 ) \
    SetScrollRange( x, SB_CTL, p1, p2, p3 )
#define ScrollBar_GetRange( x, p1, p2 ) \
    GetScrollRange( x, SB_CTL, p1, p2 )
#define ListBox_Enable( x, p )      EnableWindow( x, p )
#define ListBox_GetCount( x ) \
    (int)(DWORD)SNDMSG( x, LB_GETCOUNT, 0, 0L )
#define ListBox_ResetContent( x ) \
    (BOOL)(DWORD)SNDMSG( x, LB_RESETCONTENT, 0, 0L )
#define ListBox_AddString( x, p ) \
    (int)(DWORD)SNDMSG( x, LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)(p) )
#define ListBox_InsertString( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, LB_INSERTSTRING, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ListBox_AddItemData( x, p ) \
    (int)(DWORD)SNDMSG( x, LB_ADDSTRING, 0, (LPARAM)(p) )
#define ListBox_InsertItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, LB_INSERTSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define ListBox_DeleteString( x, p ) \
    (int)(DWORD)SNDMSG( x, LB_DELETESTRING, (WPARAM)(int)(p), 0L )
#define ListBox_GetTextLen( x, p ) \
    (int)(DWORD)SNDMSG( x, LB_GETTEXTLEN, (WPARAM)(int)(p), 0L )
#define ListBox_GetText( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, LB_GETTEXT, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ListBox_GetItemData( x, p ) \
    (LRESULT)(ULONG_PTR)SNDMSG( x, LB_GETITEMDATA, (WPARAM)(int)(p), 0L )
#define ListBox_SetItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, LB_SETITEMDATA, (WPARAM)(int)(p1), (LPARAM)(p2) )
#if (WINVER >= 0x030A)
    #define ListBox_FindString( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_FINDSTRING, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
    #define ListBox_FindItemData( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_FINDSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
    #define ListBox_SetSel( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_SETSEL, (WPARAM)(BOOL)(p1), (LPARAM)(p2) )
    #define ListBox_SelItemRange( x, p1, p2, p3 ) \
        (int)(DWORD)SNDMSG( x, LB_SELITEMRANGE, (WPARAM)(BOOL)(p1), MAKELPARAM( p2, p3 ) )
    #define ListBox_GetCurSel( x ) \
        (int)(DWORD)SNDMSG( x, LB_GETCURSEL, 0, 0L )
    #define ListBox_SetCurSel( x, p ) \
        (int)(DWORD)SNDMSG( x, LB_SETCURSEL, (WPARAM)(int)(p), 0L )
    #define ListBox_SelectString( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_SELECTSTRING, (WPARAM)(int)(p1), \
        (LPARAM)(LPCTSTR)(p2) )
    #define ListBox_SelectItemData( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_SELECTSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
    #define ListBox_GetSel( x, p ) \
        (int)(DWORD)SNDMSG( x, LB_GETSEL, (WPARAM)(int)(p), 0L )
    #define ListBox_GetSelCount( x ) \
        (int)(DWORD)SNDMSG( x, LB_GETSELCOUNT, 0, 0L )
    #define ListBox_GetTopIndex( x ) \
        (int)(DWORD)SNDMSG( x, LB_GETTOPINDEX, 0, 0L )
    #define ListBox_GetSelItems( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_GETSELITEMS, (WPARAM)(int)(p1), (LPARAM)(int *)(p2) )
    #define ListBox_SetTopIndex( x, p ) \
        (int)(DWORD)SNDMSG( x, LB_SETTOPINDEX, (WPARAM)(int)(p), 0L )
    #define ListBox_SetColumnWidth( x, p ) \
        (void)SNDMSG( x, LB_SETCOLUMNWIDTH, (WPARAM)(int)(p), 0L )
    #define ListBox_GetHorizontalExtent( x ) \
        (int)(DWORD)SNDMSG( x, LB_GETHORIZONTALEXTENT, 0, 0L )
    #define ListBox_SetHorizontalExtent( x, p ) \
        (void)SNDMSG( x, LB_SETHORIZONTALEXTENT, (WPARAM)(int)(p), 0L )
    #define ListBox_SetTabStops( x, p1, p2 ) \
        (BOOL)(DWORD)SNDMSG( x, LB_SETTABSTOPS, (WPARAM)(int)(p1), (LPARAM)(int *)(p2) )
    #define ListBox_GetItemRect( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_GETITEMRECT, (WPARAM)(int)(p1), (LPARAM)(RECT *)(p2) )
    #define ListBox_SetCaretIndex( x, p ) \
        (int)(DWORD)SNDMSG( x, LB_SETCARETINDEX, (WPARAM)(int)(p), 0L )
    #define ListBox_GetCaretIndex( x ) \
        (int)(DWORD)SNDMSG( x, LB_GETCARETINDEX, 0, 0L )
    #define ListBox_FindStringExact( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_FINDSTRINGEXACT, (WPARAM)(int)(p1), \
        (LPARAM)(LPCTSTR)(p2) )
    #define ListBox_SetItemHeight( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, LB_SETITEMHEIGHT, (WPARAM)(int)(p1), MAKELPARAM( p2, 0 ) )
    #define ListBox_GetItemHeight( x, p ) \
        (int)(DWORD)SNDMSG( x, LB_GETITEMHEIGHT, (WPARAM)(int)(p), 0L )
#endif
#define ListBox_Dir( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, LB_DIR, (WPARAM)(UINT)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ComboBox_Enable( x, p )     EnableWindow( x, p )
#define ComboBox_GetText( x, p1, p2 )   GetWindowText( x, p1, p2 )
#define ComboBox_GetTextLength( x ) GetWindowTextLength( x )
#define ComboBox_SetText( x, p )    SetWindowText( x, p )
#define ComboBox_LimitText( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_LIMITTEXT, (WPARAM)(int)(p), 0L )
#define ComboBox_GetEditSel( x ) \
    (DWORD)SNDMSG( x, CB_GETEDITSEL, 0, 0L )
#define ComboBox_SetEditSel( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_SETEDITSEL, 0, MAKELPARAM( p1, p2 ) )
#define ComboBox_GetCount( x ) \
    (int)(DWORD)SNDMSG( x, CB_GETCOUNT, 0, 0L )
#define ComboBox_ResetContent( x ) \
    (int)(DWORD)SNDMSG( x, CB_RESETCONTENT, 0, 0L )
#define ComboBox_AddString( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)(p) )
#define ComboBox_InsertString( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_INSERTSTRING, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ComboBox_AddItemData( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_ADDSTRING, 0, (LPARAM)(p) )
#define ComboBox_InsertItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_INSERTSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define ComboBox_DeleteString( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_DELETESTRING, (WPARAM)(int)(p), 0L )
#define ComboBox_GetLBTextLen( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_GETLBTEXTLEN, (WPARAM)(int)(p), 0L )
#define ComboBox_GetLBText( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_GETLBTEXT, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ComboBox_GetItemData( x, p ) \
    (LRESULT)(ULONG_PTR)SNDMSG( x, CB_GETITEMDATA, (WPARAM)(int)(p), 0L )
#define ComboBox_SetItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_SETITEMDATA, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define ComboBox_FindString( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_FINDSTRING, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ComboBox_FindItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_FINDSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define ComboBox_GetCurSel( x ) \
    (int)(DWORD)SNDMSG( x, CB_GETCURSEL, 0, 0L )
#define ComboBox_SetCurSel( x, p ) \
    (int)(DWORD)SNDMSG( x, CB_SETCURSEL, (WPARAM)(int)(p), 0L )
#define ComboBox_SelectString( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_SELECTSTRING, (WPARAM)(int)(p1), (LPARAM)(LPCTSTR)(p2) )
#define ComboBox_SelectItemData( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_SELECTSTRING, (WPARAM)(int)(p1), (LPARAM)(p2) )
#define ComboBox_Dir( x, p1, p2 ) \
    (int)(DWORD)SNDMSG( x, CB_DIR, (WPARAM)(UINT)(p1), (LPARAM)(LPCSTR)(p2) )
#define ComboBox_ShowDropdown( x, p ) \
    (BOOL)(DWORD)SNDMSG( x, CB_SHOWDROPDOWN, (WPARAM)(BOOL)(p), 0L )
#if (WINVER >= 0x030A)
    #define ComboBox_FindStringExact( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, CB_FINDSTRINGEXACT, (WPARAM)(int)(p1), \
        (LPARAM)(LPCTSTR)(p2) )
    #define ComboBox_GetDroppedState( x ) \
        (BOOL)(DWORD)SNDMSG( x, CB_GETDROPPEDSTATE, 0, 0L )
    #define ComboBox_GetDroppedControlRect( x, p ) \
        (void)SNDMSG( x, CB_GETDROPPEDCONTROLRECT, 0, (LPARAM)(RECT *)(p) )
    #define ComboBox_GetItemHeight( x ) \
        (int)(DWORD)SNDMSG( x, CB_GETITEMHEIGHT, 0, 0L )
    #define ComboBox_SetItemHeight( x, p1, p2 ) \
        (int)(DWORD)SNDMSG( x, CB_SETITEMHEIGHT, (WPARAM)(int)(p1), (LPARAM)(int)(p2) )
    #define ComboBox_GetExtendedUI( x ) \
        (UINT)(DWORD)SNDMSG( x, CB_GETEXTENDEDUI, 0, 0L )
    #define ComboBox_SetExtendedUI( x, p ) \
        (int)(DWORD)SNDMSG( x, CB_SETEXTENDEDUI, (WPARAM)(UINT)(p), 0L )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_WINDOWSX */
