/*
 *  oledlg.h    OLE dialog functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _OLEDLG_H_
#define _OLEDLG_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <prsht.h>

#ifdef __cplusplus
extern "C" {
#endif

/* OLE dialog control identifiers */
#define IDC_OLEUIHELP           99
#define IDC_IO_CREATENEW        2100
#define IDC_IO_CREATEFROMFILE   2101
#define IDC_IO_LINKFILE         2102
#define IDC_IO_OBJECTTYPELIST   2103
#define IDC_IO_DISPLAYASICON    2104
#define IDC_IO_CHANGEICON       2105
#define IDC_IO_FILE             2106
#define IDC_IO_FILEDISPLAY      2107
#define IDC_IO_RESULTIMAGE      2108
#define IDC_IO_RESULTTEXT       2109
#define IDC_IO_ICONDISPLAY      2110
#define IDC_IO_OBJECTTYPETEXT   2111
#define IDC_IO_FILETEXT         2112
#define IDC_IO_FILETYPE         2113
#define IDC_IO_INSERTCONTROL    2114
#define IDC_IO_ADDCONTROL       2115
#define IDC_IO_CONTROLTYPELIST  2116
#define IDC_PS_PASTE            500
#define IDC_PS_PASTELINK        501
#define IDC_PS_SOURCETEXT       502
#define IDC_PS_PASTELIST        503
#define IDC_PS_PASTELINKLIST    504
#define IDC_PS_DISPLAYLIST      505
#define IDC_PS_DISPLAYASICON    506
#define IDC_PS_ICONDISPLAY      507
#define IDC_PS_CHANGEICON       508
#define IDC_PS_RESULTIMAGE      509
#define IDC_PS_RESULTTEXT       510
#define IDC_CI_GROUP            120
#define IDC_CI_CURRENT          121
#define IDC_CI_CURRENTICON      122
#define IDC_CI_DEFAULT          123
#define IDC_CI_DEFAULTICON      124
#define IDC_CI_FROMFILE         125
#define IDC_CI_FROMFILEEDIT     126
#define IDC_CI_ICONLIST         127
#define IDC_CI_LABEL            128
#define IDC_CI_LABELEDIT        129
#define IDC_CI_BROWSE           130
#define IDC_CI_ICONDISPLAY      131
#define IDC_CV_OBJECTTYPE       150
#define IDC_CV_DISPLAYASICON    152
#define IDC_CV_CHANGEICON       153
#define IDC_CV_ACTIVATELIST     154
#define IDC_CV_CONVERTTO        155
#define IDC_CV_ACTIVATEAS       156
#define IDC_CV_RESULTTEXT       157
#define IDC_CV_CONVERTLIST      158
#define IDC_CV_ICONDISPLAY      165
#define IDC_EL_CHANGESOURCE     201
#define IDC_EL_AUTOMATIC        202
#define IDC_EL_LINKSLISTBOX     206
#define IDC_EL_CANCELLINK       209
#define IDC_EL_UPDATENOW        210
#define IDC_EL_OPENSOURCE       211
#define IDC_EL_MANUAL           212
#define IDC_EL_LINKSOURCE       216
#define IDC_EL_LINKTYPE         217
#define IDC_EL_COL1             220
#define IDC_EL_COL2             221
#define IDC_EL_COL3             222
#define IDC_BZ_RETRY            600
#define IDC_BZ_ICON             601
#define IDC_BZ_MESSAGE1         602
#define IDC_BZ_SWITCHTO         604
#define IDC_UL_METER            1029
#define IDC_UL_STOP             1030
#define IDC_UL_PERCENT          1031
#define IDC_UL_PROGRESS         1032
#define IDC_PU_LINKS            900
#define IDC_PU_TEXT             901
#define IDC_PU_CONVERT          902
#define IDC_PU_ICON             908
#define IDC_GP_OBJECTNAME       1009
#define IDC_GP_OBJECTTYPE       1010
#define IDC_GP_OBJECTSIZE       1011
#define IDC_GP_CONVERT          1013
#define IDC_GP_OBJECTICON       1014
#define IDC_GP_OBJECTLOCATION   1022
#define IDC_VP_PERCENT          1000
#define IDC_VP_CHANGEICON       1001
#define IDC_VP_EDITABLE         1002
#define IDC_VP_ASICON           1003
#define IDC_VP_RELATIVE         1005
#define IDC_VP_SPIN             1006
#define IDC_VP_SCALETXT         1034
#define IDC_VP_ICONDISPLAY      1021
#define IDC_VP_RESULTIMAGE      1033
#define IDC_LP_OPENSOURCE       1006
#define IDC_LP_UPDATENOW        1007
#define IDC_LP_BREAKLINK        1008
#define IDC_LP_LINKSOURCE       1012
#define IDC_LP_CHANGESOURCE     1015
#define IDC_LP_AUTOMATIC        1016
#define IDC_LP_MANUAL           1017
#define IDC_LP_DATE             1018
#define IDC_LP_TIME             1019

/* OLE dialog identifiers */
#define IDD_INSERTOBJECT        1000
#define IDD_CHANGEICON          1001
#define IDD_CONVERT             1002
#define IDD_PASTESPECIAL        1003
#define IDD_EDITLINKS           1004
#define IDD_BUSY                1006
#define IDD_UPDATELINKS         1007
#define IDD_CHANGESOURCE        1009
#define IDD_INSERTFILEBROWSE    1010
#define IDD_CHANGEICONBROWSE    1011
#define IDD_CONVERTONLY         1012
#define IDD_CHANGESOURCE4       1013
#define IDD_GNRLPROPS           1100
#define IDD_VIEWPROPS           1101
#define IDD_LINKPROPS           1102
#define IDD_CONVERT4            1103
#define IDD_CONVERTONLY4        1104
#define IDD_EDITLINKS4          1105
#define IDD_GNRLPROPS4          1106
#define IDD_LINKPROPS4          1107
#define IDD_PASTESPECIAL4       1108

/* Dialog identifiers for OleUIPromptUser() */
#define IDD_CANNOTUPDATELINK        1008
#define IDD_LINKSOURCEUNAVAILABLE   1020
#define IDD_SERVERNOTFOUND          1023
#define IDD_OUTOFMEMORY             1024
#define IDD_SERVERNOTREGW           1021
#define IDD_LINKTYPECHANGEDW        1022
#define IDD_SERVERNOTREGA           1025
#define IDD_LINKTYPECHANGEDA        1026
#ifdef UNICODE
    #define IDD_SERVERNOTREG        IDD_SERVERNOTREGW
    #define IDD_LINKTYPECHANGED     IDD_LINKTYPECHANGEDW
#else
    #define IDD_SERVERNOTREG        IDD_SERVERNOTREGA
    #define IDD_LINKTYPECHANGED     IDD_LINKTYPECHANGEDA
#endif

/* OLE standard delimiter */
#define OLESTDDELIM TEXT("\\")

/* OLE dialog registered messages */
#define SZOLEUI_MSG_HELP            TEXT("OLEUI_MSG_HELP")
#define SZOLEUI_MSG_ENDDIALOG       TEXT("OLEUI_MSG_ENDDIALOG")
#define SZOLEUI_MSG_BROWSE          TEXT("OLEUI_MSG_BROWSE")
#define SZOLEUI_MSG_CHANGEICON      TEXT("OLEUI_MSG_CHANGEICON")
#define SZOLEUI_MSG_CLOSEBUSYDIALOG TEXT("OLEUI_MSG_CLOSEBUSYDIALOG")
#define SZOLEUI_MSG_CONVERT         TEXT("OLEUI_MSG_CONVERT")
#define SZOLEUI_MSG_CHANGESOURCE    TEXT("OLEUI_MSG_CHANGESOURCE")
#define SZOLEUI_MSG_ADDCONTROL      TEXT("OLEUI_MSG_ADDCONTROL")
#define SZOLEUI_MSG_BROWSE_OFN      TEXT("OLEUI_MSG_BROWSE_OFN")

/* Identifiers for SZOLEUI_MSG_BROWSE_OFN */
#define ID_BROWSE_CHANGEICON    1
#define ID_BROWSE_INSERTFILE    2
#define ID_BROWSE_ADDCONTROL    3
#define ID_BROWSE_CHANGESOURCE  4

/* OLE dialog return codes */
#define OLEUI_FALSE                     0
#define OLEUI_SUCCESS                   1
#define OLEUI_OK                        1
#define OLEUI_CANCEL                    2
#define OLEUI_ERR_STANDARDMIN           100
#define OLEUI_ERR_OLEMEMALLOC           100
#define OLEUI_ERR_STRUCTURENULL         101
#define OLEUI_ERR_STRUCTUREINVALID      102
#define OLEUI_ERR_CBSTRUCTINCORRECT     103
#define OLEUI_ERR_HWNDOWNERINVALID      104
#define OLEUI_ERR_LPSZCAPTIONINVALID    105
#define OLEUI_ERR_LPFNHOOKINVALID       106
#define OLEUI_ERR_HINSTANCEINVALID      107
#define OLEUI_ERR_LPSZTEMPLATEINVALID   108
#define OLEUI_ERR_HRESOURCEINVALID      109
#define OLEUI_ERR_FINDTEMPLATEFAILURE   110
#define OLEUI_ERR_LOADTEMPLATEFAILURE   111
#define OLEUI_ERR_DIALOGFAILURE         112
#define OLEUI_ERR_LOCALMEMALLOC         113
#define OLEUI_ERR_GLOBALMEMALLOC        114
#define OLEUI_ERR_LOADSTRING            115
#define OLEUI_ERR_STANDARDMAX           116

/* OleUIInsertObject() flags */
#define IOF_SHOWHELP                0x00000001L
#define IOF_SELECTCREATENEW         0x00000002L
#define IOF_SELECTCREATEFROMFILE    0x00000004L
#define IOF_CHECKLINK               0x00000008L
#define IOF_CHECKDISPLAYASICON      0x00000010L
#define IOF_CREATENEWOBJECT         0x00000020L
#define IOF_CREATEFILEOBJECT        0x00000040L
#define IOF_CREATELINKOBJECT        0x00000080L
#define IOF_DISABLELINK             0x00000100L
#define IOF_VERIFYSERVERSEXIST      0x00000200L
#define IOF_DISABLEDISPLAYASICON    0x00000400L
#define IOF_HIDECHANGEICON          0x00000800L
#define IOF_SHOWINSERTCONTROL       0x00001000L
#define IOF_SELECTCREATECONTROL     0x00002000L

/* OleUIInsertObject() error codes */
#define OLEUI_IOERR_LPSZFILEINVALID         (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_IOERR_LPSZLABELINVALID        (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_IOERR_HICONINVALID            (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_IOERR_LPFORMATETCINVALID      (OLEUI_ERR_STANDARDMAX + 3)
#define OLEUI_IOERR_PPVOBJINVALID           (OLEUI_ERR_STANDARDMAX + 4)
#define OLEUI_IOERR_LPIOLECLIENTSITEINVALID (OLEUI_ERR_STANDARDMAX + 5)
#define OLEUI_IOERR_LPISTORAGEINVALID       (OLEUI_ERR_STANDARDMAX + 6)
#define OLEUI_IOERR_SCODEHASERROR           (OLEUI_ERR_STANDARDMAX + 7)
#define OLEUI_IOERR_LPCLSIDEXCLUDEINVALID   (OLEUI_ERR_STANDARDMAX + 8)
#define OLEUI_IOERR_CCHFILEINVALID          (OLEUI_ERR_STANDARDMAX + 9)

/* Maximum link types */
#define PS_MAXLINKTYPES 8

/* OleUIPasteSpecial() flags */
#define PSF_SHOWHELP                0x00000001L
#define PSF_SELECTPASTE             0x00000002L
#define PSF_SELECTPASTELINK         0x00000004L
#define PSF_CHECKDISPLAYASICON      0x00000008L
#define PSF_DISABLEDISPLAYASICON    0x00000010L
#define PSF_HIDECHANGEICON          0x00000020L
#define PSF_STAYONCLIPBOARDCHANGE   0x00000040L
#define PSF_NOREFRESHDATAOBJECT     0x00000080L

/* OleUIPasteSpecial() error codes */
#define OLEUI_IOERR_SRCDATAOBJECTINVALID    (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_IOERR_ARRPASTEENTRIESINVALID  (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_IOERR_ARRLINKTYPESINVALID     (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_PSERR_CLIPBOARDCHANGED        (OLEUI_ERR_STANDARDMAX + 3)
#define OLEUI_PSERR_GETCLIPBOARDFAILED      (OLEUI_ERR_STANDARDMAX + 4)

/* OleUIEditLinks() error codes */
#define OLEUI_ELERR_LINKCNTRNULL    (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_ELERR_LINKCNTRINVALID (OLEUI_ERR_STANDARDMAX + 1)

/* OleUIEditLinks() flags */
#define ELF_SHOWHELP            0x00000001L
#define ELF_DISABLEUPDATENOW    0x00000002L
#define ELF_DISABLEOPENSOURCE   0x00000004L
#define ELF_DISABLECHANGESOURCE 0x00000008L
#define ELF_DISABLECANCELLINK   0x00000010L

/* OleUIChangeIcon() flags */
#define CIF_SHOWHELP        0x00000001L
#define CIF_SELECTCURRENT   0x00000002L
#define CIF_SELECTDEFAULT   0x00000004L
#define CIF_SELECTFROMFILE  0x00000008L
#define CIF_USEICONEXE      0x00000010L

/* OleUIChangeIcon() error codes */
#define OLEUI_CIERR_MUSTHAVECLSID           (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_CIERR_MUSTHAVECURRENTMETAFILE (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_CIERR_SZICONEXEINVALID        (OLEUI_ERR_STANDARDMAX + 2)

/* Change icon dialog window properties */
#define PROP_HWND_CHGICONDLG    TEXT("HWND_CIDLG")

/* OleUIConvert() flags */
#define CF_SHOWHELPBUTTON       0x00000001L
#define CF_SETCONVERTDEFAULT    0x00000002L
#define CF_SETACTIVATEDEFAULT   0x00000004L
#define CF_SELECTCONVERTTO      0x00000008L
#define CF_SELECTACTIVATEAS     0x00000010L
#define CF_DISABLEDISPLAYASICON 0x00000020L
#define CF_DISABLEACTIVATEAS    0x00000040L
#define CF_HIDECHANGEICON       0x00000080L
#define CF_CONVERTONLY          0x00000100L

/* OleUIConvert() error codes */
#define OLEUI_CTERR_CLASSIDINVALID      (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_CTERR_DVASPECTINVALID     (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_CTERR_CBFORMATINVALID     (OLEUI_ERR_STANDARDMAX + 3)
#define OLEUI_CTERR_HMETAPICTINVALID    (OLEUI_ERR_STANDARDMAX + 4)
#define OLEUI_CTERR_STRINGINVALID       (OLEUI_ERR_STANDARDMAX + 5)

/* OleUIBusy() flags */
#define BZ_DISABLECANCELBUTTON      0x00000001L
#define BZ_DISABLESWITCHTOBUTTON    0x00000002L
#define BZ_DISABLERETRYBUTTON       0x00000004L
#define BZ_NOTRESPONDINGDIALOG      0x00000008L

/* OleUIBusy() error codes */
#define OLEUI_BZERR_HTASKINVALID    (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_BZ_SWITCHTOSELECTED   (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_BZ_RETRYSELECTED      (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_BZ_CALLUNBLOCKED      (OLEUI_ERR_STANDARDMAX + 3)

/* OleUIChangeSource() flags */
#define CSF_SHOWHELP        0x00000001L
#define CSF_VALIDSOURCE     0x00000002L
#define CSF_ONLYGETSOURCE   0x00000004L
#define CSF_EXPLORER        0x00000008L

/* OleUIChangeSource() error codes */
#define OLEUI_CSERR_LINKCNTRNULL        (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_CSERR_LINKCNTRINVALID     (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_CSERR_FROMNOTNULL         (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_CSERR_TONOTNULL           (OLEUI_ERR_STANDARDMAX + 3)
#define OLEUI_CSERR_SOURCENULL          (OLEUI_ERR_STANDARDMAX + 4)
#define OLEUI_CSERR_SOURCEINVALID       (OLEUI_ERR_STANDARDMAX + 5)
#define OLEUI_CSERR_SOURCEPARSERROR     (OLEUI_ERR_STANDARDMAX + 6)
#define OLEUI_CSERR_SOURCEPARSEERROR    (OLEUI_ERR_STANDARDMAX + 6)

/* View properties flags */
#define VPF_SELECTRELATIVE  0x00000001L
#define VPF_DISABLERELATIVE 0x00000002L
#define VPF_DISABLESCALE    0x00000004L

/* OleUIObjectProperties() flags */
#define OPF_OBJECTISLINK    0x00000001L
#define OPF_NOFILLDEFAULT   0x00000002L
#define OPF_SHOWHELP        0x00000004L
#define OPF_DISABLECONVERT  0x00000008L

/* OleUIObjectProperties() error codes */
#define OLEUI_OPERR_SUBPROPNULL             (OLEUI_ERR_STANDARDMAX + 0)
#define OLEUI_OPERR_SUBPROPINVALID          (OLEUI_ERR_STANDARDMAX + 1)
#define OLEUI_OPERR_PROPSHEETNULL           (OLEUI_ERR_STANDARDMAX + 2)
#define OLEUI_OPERR_PROPSHEETINVALID        (OLEUI_ERR_STANDARDMAX + 3)
#define OLEUI_OPERR_SUBPROP                 (OLEUI_ERR_STANDARDMAX + 4)
#define OLEUI_OPERR_PROPSINVALID            (OLEUI_ERR_STANDARDMAX + 5)
#define OLEUI_OPERR_PROPSINCORRECT          (OLEUI_ERR_STANDARDMAX + 6)
#define OLEUI_OPERR_INVALIDPAGES            (OLEUI_ERR_STANDARDMAX + 7)
#define OLEUI_OPERR_NOTSUPPORTED            (OLEUI_ERR_STANDARDMAX + 8)
#define OLEUI_OPERR_DLGPROCNOTNULL          (OLEUI_ERR_STANDARDMAX + 9)
#define OLEUI_OPERR_LPARAMNOTZERO           (OLEUI_ERR_STANDARDMAX + 10)
#define OLEUI_GPERR_STRINGINVALID           (OLEUI_ERR_STANDARDMAX + 11)
#define OLEUI_GPERR_CLASSIDINVALID          (OLEUI_ERR_STANDARDMAX + 12)
#define OLEUI_GPERR_LPCLSIDEXCLUDEINVALID   (OLEUI_ERR_STANDARDMAX + 13)
#define OLEUI_GPERR_CBFORMATINVALID         (OLEUI_ERR_STANDARDMAX + 14)
#define OLEUI_VPERR_METAPICTINVALID         (OLEUI_ERR_STANDARDMAX + 15)
#define OLEUI_VPERR_DVASPECTINVALID         (OLEUI_ERR_STANDARDMAX + 16)
#define OLEUI_VPERR_LINKCNTRNULL            (OLEUI_ERR_STANDARDMAX + 17)
#define OLEUI_VPERR_LINKCNTRINVALID         (OLEUI_ERR_STANDARDMAX + 18)
#define OLEUI_OPERR_PROPERTYSHEET           (OLEUI_ERR_STANDARDMAX + 19)
#define OLEUI_OPERR_OBJINFOINVALID          (OLEUI_ERR_STANDARDMAX + 20)
#define OLEUI_OPERR_LINKINFOINVALID         (OLEUI_ERR_STANDARDMAX + 21)

/* PSM_QUERYSIBLINGS indices for object properties */
#define OLEUI_QUERY_GETCLASSID  0xFF00
#define OLEUI_QUERY_LINKBROKEN  0xFF01

/* OLE dialog hook function */
typedef UINT (CALLBACK *LPFNOLEUIHOOK)( HWND, UINT, WPARAM, LPARAM );

/* OleUIInsertObject() parameters */
typedef struct tagOLEUIINSERTOBJECTA {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCSTR          lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCSTR          lpszTemplate;
    HRSRC           hResource;
    CLSID           clsid;
    LPSTR           lpszFile;
    UINT            cchFile;
    UINT            cClsidExclude;
    LPCLSID         lpClsidExclude;
    IID             iid;
    DWORD           oleRender;
    LPFORMATETC     lpFormatEtc;
    LPOLECLIENTSITE lpIOleClientSite;
    LPSTORAGE       lpIStorage;
    LPVOID          *ppvObj;
    SCODE           sc;
    HGLOBAL         hMetaPict;
} OLEUIINSERTOBJECTA;
typedef OLEUIINSERTOBJECTA      *POLEUIINSERTOBJECTA;
typedef OLEUIINSERTOBJECTA      *LPOLEUIINSERTOBJECTA;
typedef struct tagOLEUIINSERTOBJECTW {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCWSTR         lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCWSTR         lpszTemplate;
    HRSRC           hResource;
    CLSID           clsid;
    LPWSTR          lpszFile;
    UINT            cchFile;
    UINT            cClsidExclude;
    LPCLSID         lpClsidExclude;
    IID             iid;
    DWORD           oleRender;
    LPFORMATETC     lpFormatEtc;
    LPOLECLIENTSITE lpIOleClientSite;
    LPSTORAGE       lpIStorage;
    LPVOID          *ppvObj;
    SCODE           sc;
    HGLOBAL         hMetaPict;
} OLEUIINSERTOBJECTW;
typedef OLEUIINSERTOBJECTW      *POLEUIINSERTOBJECTW;
typedef OLEUIINSERTOBJECTW      *LPOLEUIINSERTOBJECTW;
#ifdef UNICODE
typedef OLEUIINSERTOBJECTW      OLEUIINSERTOBJECT;
typedef POLEUIINSERTOBJECTW     POLEUIINSERTOBJECT;
typedef LPOLEUIINSERTOBJECTW    LPOLEUIINSERTOBJECT;
#else
typedef OLEUIINSERTOBJECTA      OLEUIINSERTOBJECT;
typedef POLEUIINSERTOBJECTA     POLEUIINSERTOBJECT;
typedef LPOLEUIINSERTOBJECTA    LPOLEUIINSERTOBJECT;
#endif

/* OleUIPasteSpecial() entry flags */
typedef enum tagOLEUIPASTEFLAG {
    OLEUIPASTE_PASTEONLY    = 0,
    OLEUIPASTE_LINKTYPE1    = 1,
    OLEUIPASTE_LINKTYPE2    = 2,
    OLEUIPASTE_LINKTYPE3    = 4,
    OLEUIPASTE_LINKTYPE4    = 8,
    OLEUIPASTE_LINKTYPE5    = 16,
    OLEUIPASTE_LINKTYPE6    = 32,
    OLEUIPASTE_LINKTYPE7    = 64,
    OLEUIPASTE_LINKTYPE8    = 128,
    OLEUIPASTE_PASTE        = 512,
    OLEUIPASTE_LINKANYTYPE  = 1024,
    OLEUIPASTE_ENABLEICON   = 2048
} OLEUIPASTEFLAG;

/* OleUIPasteSpecial() entry */
typedef struct tagOLEUIPASTEENTRYA {
    FORMATETC   fmtetc;
    LPCSTR      lpstrFormatName;
    LPCSTR      lpstrResultText;
    DWORD       dwFlags;
    DWORD       dwScratchSpace;
} OLEUIPASTEENTRYA;
typedef OLEUIPASTEENTRYA    *POLEUIPASTEENTRYA;
typedef OLEUIPASTEENTRYA    *LPOLEUIPASTEENTRYA;
typedef struct tagOLEUIPASTEENTRYW {
    FORMATETC   fmtetc;
    LPCWSTR     lpstrFormatName;
    LPCWSTR     lpstrResultText;
    DWORD       dwFlags;
    DWORD       dwScratchSpace;
} OLEUIPASTEENTRYW;
typedef OLEUIPASTEENTRYW    *POLEUIPASTEENTRYW;
typedef OLEUIPASTEENTRYW    *LPOLEUIPASTEENTRYW;
#ifdef UNICODE
typedef OLEUIPASTEENTRYW    OLEUIPASTEENTRY;
typedef POLEUIPASTEENTRYW   POLEUIPASTEENTRY;
typedef LPOLEUIPASTEENTRYW  LPOLEUIPASTEENTRY;
#else
typedef OLEUIPASTEENTRYA    OLEUIPASTEENTRY;
typedef POLEUIPASTEENTRYA   POLEUIPASTEENTRY;
typedef LPOLEUIPASTEENTRYA  LPOLEUIPASTEENTRY;
#endif

/* OleUIPasteSpecial() parameters */
typedef struct tagOLEUIPASTESPECIALA {
    DWORD               cbStruct;
    DWORD               dwFlags;
    HWND                hWndOwner;
    LPCSTR              lpszCaption;
    LPFNOLEUIHOOK       lpfnHook;
    LPARAM              lCustData;
    HINSTANCE           hInstance;
    LPCSTR              lpszTemplate;
    HRSRC               hResource;
    LPDATAOBJECT        lpSrcDataObj;
    LPOLEUIPASTEENTRYA  arrPasteEntries;
    int                 cPasteEntries;
    UINT                *arrLinkTypes;
    int                 cLinkTypes;
    UINT                cClsidExclude;
    LPCLSID             lpClsidExclude;
    int                 nSelectedIndex;
    BOOL                fLink;
    HGLOBAL             hMetaPict;
    SIZEL               sizel;
} OLEUIPASTESPECIALA;
typedef OLEUIPASTESPECIALA      *POLEUIPASTESPECIALA;
typedef OLEUIPASTESPECIALA      *LPOLEUIPASTESPECIALA;
typedef struct tagOLEUIPASTESPECIALW {
    DWORD               cbStruct;
    DWORD               dwFlags;
    HWND                hWndOwner;
    LPCWSTR             lpszCaption;
    LPFNOLEUIHOOK       lpfnHook;
    LPARAM              lCustData;
    HINSTANCE           hInstance;
    LPCWSTR             lpszTemplate;
    HRSRC               hResource;
    LPDATAOBJECT        lpSrcDataObj;
    LPOLEUIPASTEENTRYW  arrPasteEntries;
    int                 cPasteEntries;
    UINT                *arrLinkTypes;
    int                 cLinkTypes;
    UINT                cClsidExclude;
    LPCLSID             lpClsidExclude;
    int                 nSelectedIndex;
    BOOL                fLink;
    HGLOBAL             hMetaPict;
    SIZEL               sizel;
} OLEUIPASTESPECIALW;
typedef OLEUIPASTESPECIALW      *POLEUIPASTESPECIALW;
typedef OLEUIPASTESPECIALW      *LPOLEUIPASTESPECIALW;
#ifdef UNICODE
typedef OLEUIPASTESPECIALW      OLEUIPASTESPECIAL;
typedef POLEUIPASTESPECIALW     POLEUIPASTESPECIAL;
typedef LPOLEUIPASTESPECIALW    LPOLEUIPASTESPECIAL;
#else
typedef OLEUIPASTESPECIALA      OLEUIPASTESPECIAL;
typedef POLEUIPASTESPECIALA     POLEUIPASTESPECIAL;
typedef LPOLEUIPASTESPECIALA    LPOLEUIPASTESPECIAL;
#endif

/* IOleUILinkContainer interface */
#undef INTERFACE
#define INTERFACE   IOleUILinkContainerA
DECLARE_INTERFACE_( IOleUILinkContainerA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUILinkContainerA methods */
    STDMETHOD_( DWORD, GetNextLink )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLinkUpdateOptions )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetLinkUpdateOptions )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetLinkSource )( THIS_ DWORD, LPSTR, ULONG, ULONG *, BOOL ) PURE;
    STDMETHOD( GetLinkSource )( THIS_ DWORD, LPSTR *, ULONG *, LPSTR *, LPSTR *, BOOL *, BOOL * ) PURE;
    STDMETHOD( OpenLinkSource )( THIS_ DWORD ) PURE;
    STDMETHOD( UpdateLink )( THIS_ DWORD, BOOL, BOOL ) PURE;
    STDMETHOD( CancelLink )( THIS_ DWORD ) PURE;
};
typedef IOleUILinkContainerA        *LPOLEUILINKCONTAINERA;
#undef INTERFACE
#define INTERFACE   IOleUILinkContainerW
DECLARE_INTERFACE_( IOleUILinkContainerW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUILinkContainerW methods */
    STDMETHOD_( DWORD, GetNextLink )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLinkUpdateOptions )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetLinkUpdateOptions )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetLinkSource )( THIS_ DWORD, LPWSTR, ULONG, ULONG *, BOOL ) PURE;
    STDMETHOD( GetLinkSource )( THIS_ DWORD, LPWSTR *, ULONG *, LPWSTR *, LPWSTR *, BOOL *, BOOL * ) PURE;
    STDMETHOD( OpenLinkSource )( THIS_ DWORD ) PURE;
    STDMETHOD( UpdateLink )( THIS_ DWORD, BOOL, BOOL ) PURE;
    STDMETHOD( CancelLink )( THIS_ DWORD ) PURE;
};
typedef IOleUILinkContainerW        *LPOLEUILINKCONTAINERW;
#ifdef UNICODE
    #define IOleUILinkContainer     IOleUILinkContainerW
    #define IOleUILinkContainerVtbl IOleUILinkContainerWVtbl
    #define LPOLEUILINKCONTAINER    LPOLEUILINKCONTAINERW
#else
    #define IOleUILinkContainer     IOleUILinkContainerA
    #define IOleUILinkContainerVtbl IOleUILinkContainerAVtbl
    #define LPOLEUILINKCONTAINER    LPOLEUILINKCONTAINERA
#endif

/* OleUIEditLinks() parameters */
typedef struct tagOLEUIEDITLINKSA {
    DWORD                   cbStruct;
    DWORD                   dwFlags;
    HWND                    hWndOwner;
    LPCSTR                  lpszCaption;
    LPFNOLEUIHOOK           lpfnHook;
    LPARAM                  lCustData;
    HINSTANCE               hInstance;
    LPCSTR                  lpszTemplate;
    HRSRC                   hResource;
    LPOLEUILINKCONTAINERA   lpOleUILinkContainer;
} OLEUIEDITLINKSA;
typedef OLEUIEDITLINKSA     *POLEUIEDITLINKSA;
typedef OLEUIEDITLINKSA     *LPOLEUIEDITLINKSA;
typedef struct tagOLEUIEDITLINKSW {
    DWORD                   cbStruct;
    DWORD                   dwFlags;
    HWND                    hWndOwner;
    LPCWSTR                 lpszCaption;
    LPFNOLEUIHOOK           lpfnHook;
    LPARAM                  lCustData;
    HINSTANCE               hInstance;
    LPCWSTR                 lpszTemplate;
    HRSRC                   hResource;
    LPOLEUILINKCONTAINERW   lpOleUILinkContainer;
} OLEUIEDITLINKSW;
typedef OLEUIEDITLINKSW     *POLEUIEDITLINKSW;
typedef OLEUIEDITLINKSW     *LPOLEUIEDITLINKSW;
#ifdef UNICODE
typedef OLEUIEDITLINKSW     OLEUIEDITLINKS;
typedef POLEUIEDITLINKSW    POLEUIEDITLINKS;
typedef LPOLEUIEDITLINKSW   LPOLEUIEDITLINKS;
#else
typedef OLEUIEDITLINKSA     OLEUIEDITLINKS;
typedef POLEUIEDITLINKSA    POLEUIEDITLINKS;
typedef LPOLEUIEDITLINKSA   LPOLEUIEDITLINKS;
#endif

/* OleUIChangeIcon() parameters */
typedef struct tagOLEUICHANGEICONA {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCSTR          lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCSTR          lpszTemplate;
    HRSRC           hResource;
    HGLOBAL         hMetaPict;
    CLSID           clsid;
    CHAR            szIconExe[MAX_PATH];
    int             cchIconExe;
} OLEUICHANGEICONA;
typedef OLEUICHANGEICONA    *POLEUICHANGEICONA;
typedef OLEUICHANGEICONA    *LPOLEUICHANGEICONA;
typedef struct tagOLEUICHANGEICONW {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCWSTR         lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCWSTR         lpszTemplate;
    HRSRC           hResource;
    HGLOBAL         hMetaPict;
    CLSID           clsid;
    WCHAR           szIconExe[MAX_PATH];
    int             cchIconExe;
} OLEUICHANGEICONW;
typedef OLEUICHANGEICONW    *POLEUICHANGEICONW;
typedef OLEUICHANGEICONW    *LPOLEUICHANGEICONW;
#ifdef UNICODE
typedef OLEUICHANGEICONW    OLEUICHANGEICON;
typedef POLEUICHANGEICONW   POLEUICHANGEICON;
typedef LPOLEUICHANGEICONW  LPOLEUICHANGEICON;
#else
typedef OLEUICHANGEICONA    OLEUICHANGEICON;
typedef POLEUICHANGEICONA   POLEUICHANGEICON;
typedef LPOLEUICHANGEICONA  LPOLEUICHANGEICON;
#endif

/* OleUIConvert() parameters */
typedef struct tagOLEUICONVERTA {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCSTR          lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCSTR          lpszTemplate;
    HRSRC           hResource;
    CLSID           clsid;
    CLSID           clsidConvertDefault;
    CLSID           clsidActivateDefault;
    CLSID           clsidNew;
    DWORD           dvAspect;
    WORD            wFormat;
    BOOL            fIsLinkedObject;
    HGLOBAL         hMetaPict;
    LPSTR           lpszUserType;
    BOOL            fObjectsIconChanged;
    LPSTR           lpszDefLabel;
    UINT            cClsidExclude;
    LPCLSID         lpClsidExclude;
} OLEUICONVERTA;
typedef OLEUICONVERTA   *POLEUICONVERTA;
typedef OLEUICONVERTA   *LPOLEUICONVERTA;
typedef struct tagOLEUICONVERTW {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCWSTR         lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCWSTR         lpszTemplate;
    HRSRC           hResource;
    CLSID           clsid;
    CLSID           clsidConvertDefault;
    CLSID           clsidActivateDefault;
    CLSID           clsidNew;
    DWORD           dvAspect;
    WORD            wFormat;
    BOOL            fIsLinkedObject;
    HGLOBAL         hMetaPict;
    LPWSTR          lpszUserType;
    BOOL            fObjectsIconChanged;
    LPWSTR          lpszDefLabel;
    UINT            cClsidExclude;
    LPCLSID         lpClsidExclude;
} OLEUICONVERTW;
typedef OLEUICONVERTW   *POLEUICONVERTW;
typedef OLEUICONVERTW   *LPOLEUICONVERTW;
#ifdef UNICODE
typedef OLEUICONVERTW   OLEUICONVERT;
typedef POLEUICONVERTW  POLEUICONVERT;
typedef LPOLEUICONVERTW LPOLEUICONVERT;
#else
typedef OLEUICONVERTA   OLEUICONVERT;
typedef POLEUICONVERTA  POLEUICONVERT;
typedef LPOLEUICONVERTA LPOLEUICONVERT;
#endif

/* OleUIBusy() parameters */
typedef struct tagOLEUIBUSYA {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCSTR          lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCSTR          lpszTemplate;
    HRSRC           hResource;
    HTASK           hTask;
    HWND            *lphWndDialog;
} OLEUIBUSYA;
typedef OLEUIBUSYA      *POLEUIBUSYA;
typedef OLEUIBUSYA      *LPOLEUIBUSYA;
typedef struct tagOLEUIBUSYW {
    DWORD           cbStruct;
    DWORD           dwFlags;
    HWND            hWndOwner;
    LPCWSTR         lpszCaption;
    LPFNOLEUIHOOK   lpfnHook;
    LPARAM          lCustData;
    HINSTANCE       hInstance;
    LPCWSTR         lpszTemplate;
    HRSRC           hResource;
    HTASK           hTask;
    HWND            *lphWndDialog;
} OLEUIBUSYW;
typedef OLEUIBUSYW      *POLEUIBUSYW;
typedef OLEUIBUSYW      *LPOLEUIBUSYW;
#ifdef UNICODE
typedef OLEUIBUSYW      OLEUIBUSY;
typedef POLEUIBUSYW     POLEUIBUSY;
typedef LPOLEUIBUSYW    LPOLEUIBUSY;
#else
typedef OLEUIBUSYA      OLEUIBUSY;
typedef POLEUIBUSYA     POLEUIBUSY;
typedef LPOLEUIBUSYA    LPOLEUIBUSY;
#endif

/* OleUIChangeSource() parameters */
typedef struct tagOLEUICHANGESOURCEA {
    DWORD                   cbStruct;
    DWORD                   dwFlags;
    HWND                    hWndOwner;
    LPCSTR                  lpszCaption;
    LPFNOLEUIHOOK           lpfnHook;
    LPARAM                  lCustData;
    HINSTANCE               hInstance;
    LPCSTR                  lpszTemplate;
    HRSRC                   hResource;
    OPENFILENAMEA           *lpOFN;
    DWORD                   dwReserved1[4];
    LPOLEUILINKCONTAINERA   lpOleUILinkContainer;
    DWORD                   dwLink;
    LPSTR                   lpszDisplayName;
    ULONG                   nFileLength;
    LPSTR                   lpszFrom;
    LPSTR                   lpszTo;
} OLEUICHANGESOURCEA;
typedef OLEUICHANGESOURCEA      *POLEUICHANGESOURCEA;
typedef OLEUICHANGESOURCEA      *LPOLEUICHANGESOURCEA;
typedef struct tagOLEUICHANGESOURCEW {
    DWORD                   cbStruct;
    DWORD                   dwFlags;
    HWND                    hWndOwner;
    LPCWSTR                 lpszCaption;
    LPFNOLEUIHOOK           lpfnHook;
    LPARAM                  lCustData;
    HINSTANCE               hInstance;
    LPCWSTR                 lpszTemplate;
    HRSRC                   hResource;
    OPENFILENAMEW           *lpOFN;
    DWORD                   dwReserved1[4];
    LPOLEUILINKCONTAINERW   lpOleUILinkContainer;
    DWORD                   dwLink;
    LPWSTR                  lpszDisplayName;
    ULONG                   nFileLength;
    LPWSTR                  lpszFrom;
    LPWSTR                  lpszTo;
} OLEUICHANGESOURCEW;
typedef OLEUICHANGESOURCEW      *POLEUICHANGESOURCEW;
typedef OLEUICHANGESOURCEW      *LPOLEUICHANGESOURCEW;
#ifdef UNICODE
typedef OLEUICHANGESOURCEW      OLEUICHANGESOURCE;
typedef POLEUICHANGESOURCEW     POLEUICHANGESOURCE;
typedef LPOLEUICHANGESOURCEW    LPOLEUICHANGESOURCE;
#else
typedef OLEUICHANGESOURCEA      OLEUICHANGESOURCE;
typedef POLEUICHANGESOURCEA     POLEUICHANGESOURCE;
typedef LPOLEUICHANGESOURCEA    LPOLEUICHANGESOURCE;
#endif

/* IOleUIObjInfo interface */
#undef INTERFACE
#define INTERFACE   IOleUIObjInfoA
DECLARE_INTERFACE_( IOleUIObjInfoA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUIObjInfoW methods */
    STDMETHOD( GetObjectInfo )( THIS_ DWORD, DWORD *, LPSTR *, LPSTR *, LPSTR *, LPSTR * ) PURE;
    STDMETHOD( GetConvertInfo )( THIS_ DWORD, CLSID *, WORD *, CLSID *, LPCLSID *, UINT * ) PURE;
    STDMETHOD( ConvertObject )( THIS_ DWORD, REFCLSID ) PURE;
    STDMETHOD( GetViewInfo )( THIS_ DWORD, HGLOBAL *, DWORD *, int * ) PURE;
    STDMETHOD( SetViewInfo )( THIS_ DWORD, HGLOBAL, DWORD, int, BOOL ) PURE;
};
typedef IOleUIObjInfoA          *LPOLEUIOBJINFOA;
#undef INTERFACE
#define INTERFACE   IOleUIObjInfoW
DECLARE_INTERFACE_( IOleUIObjInfoW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUIObjInfoW methods */
    STDMETHOD( GetObjectInfo )( THIS_ DWORD, DWORD *, LPWSTR *, LPWSTR *, LPWSTR *, LPWSTR * ) PURE;
    STDMETHOD( GetConvertInfo )( THIS_ DWORD, CLSID *, WORD *, CLSID *, LPCLSID *, UINT * ) PURE;
    STDMETHOD( ConvertObject )( THIS_ DWORD, REFCLSID ) PURE;
    STDMETHOD( GetViewInfo )( THIS_ DWORD, HGLOBAL *, DWORD *, int * ) PURE;
    STDMETHOD( SetViewInfo )( THIS_ DWORD, HGLOBAL, DWORD, int, BOOL ) PURE;
};
typedef IOleUIObjInfoW          *LPOLEUIOBJINFOW;
#ifdef UNICODE
    #define IOleUIObjInfo       IOleUIObjInfoW
    #define IOleUIObjInfoVtbl   IOleUIObjInfoWVtbl
    #define LPOLEUIOBJINFO      LPOLEUIOBJINFOW
#else
    #define IOleUIObjInfo       IOleUIObjInfoA
    #define IOleUIObjInfoVtbl   IOleUIObjInfoAVtbl
    #define LPOLEUIOBJINFO      LPOLEUIOBJINFOA
#endif

/* IOleUILinkInfo interface */
#undef INTERFACE
#define INTERFACE   IOleUILinkInfoA
DECLARE_INTERFACE_( IOleUILinkInfoA, IOleUILinkContainerA ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUILinkContainerW methods */
    STDMETHOD_( DWORD, GetNextLink )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLinkUpdateOptions )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetLinkUpdateOptions )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetLinkSource )( THIS_ DWORD, LPSTR, ULONG, ULONG *, BOOL ) PURE;
    STDMETHOD( GetLinkSource )( THIS_ DWORD, LPSTR *, ULONG *, LPSTR *, LPSTR *, BOOL *, BOOL * ) PURE;
    STDMETHOD( OpenLinkSource )( THIS_ DWORD ) PURE;
    STDMETHOD( UpdateLink )( THIS_ DWORD, BOOL, BOOL ) PURE;
    STDMETHOD( CancelLink )( THIS_ DWORD ) PURE;

    /* IOleUILinkInfoW methods */
    STDMETHOD( GetLastUpdate )( THIS_ DWORD, FILETIME * ) PURE;
};
typedef IOleUILinkInfoA         *LPOLEUILINKINFOA;
#undef INTERFACE
#define INTERFACE   IOleUILinkInfoW
DECLARE_INTERFACE_( IOleUILinkInfoW, IOleUILinkContainerW ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOleUILinkContainerW methods */
    STDMETHOD_( DWORD, GetNextLink )( THIS_ DWORD ) PURE;
    STDMETHOD( SetLinkUpdateOptions )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetLinkUpdateOptions )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetLinkSource )( THIS_ DWORD, LPWSTR, ULONG, ULONG *, BOOL ) PURE;
    STDMETHOD( GetLinkSource )( THIS_ DWORD, LPWSTR *, ULONG *, LPWSTR *, LPWSTR *, BOOL *, BOOL * ) PURE;
    STDMETHOD( OpenLinkSource )( THIS_ DWORD ) PURE;
    STDMETHOD( UpdateLink )( THIS_ DWORD, BOOL, BOOL ) PURE;
    STDMETHOD( CancelLink )( THIS_ DWORD ) PURE;

    /* IOleUILinkInfoW methods */
    STDMETHOD( GetLastUpdate )( THIS_ DWORD, FILETIME * ) PURE;
};
typedef IOleUILinkInfoW         *LPOLEUILINKINFOW;
#ifdef UNICODE
    #define IOleUILinkInfo      IOleUILinkInfoW
    #define IOleUILinkInfoVtbl  IOleUILinkInfoWVtbl
    #define LPOLEUILINKINFO     LPOLEUILINKINFOW
#else
    #define IOleUILinkInfo      IOleUILinkInfoA
    #define IOleUILinkInfoVtbl  IOleUILinkInfoAVtbl
    #define LPOLEUILINKINFO     LPOLEUILINKINFOA
#endif

/* General properties */
typedef struct tagOLEUIGNRLPROPSA {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSA *lpOP;
} OLEUIGNRLPROPSA;
typedef OLEUIGNRLPROPSA     *POLEUIGNRLPROPSA;
typedef OLEUIGNRLPROPSA     *LPOLEUIGNRLPROPSA;
typedef struct tagOLEUIGNRLPROPSW {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSW *lpOP;
} OLEUIGNRLPROPSW;
typedef OLEUIGNRLPROPSW     *POLEUIGNRLPROPSW;
typedef OLEUIGNRLPROPSW     *LPOLEUIGNRLPROPSW;
#ifdef UNICODE
typedef OLEUIGNRLPROPSW     OLEUIGNRLPROPS;
typedef POLEUIGNRLPROPSW    POLEUIGNRLPROPS;
typedef LPOLEUIGNRLPROPSW   LPOLEUIGNRLPROPS;
#else
typedef OLEUIGNRLPROPSA     OLEUIGNRLPROPS;
typedef POLEUIGNRLPROPSA    POLEUIGNRLPROPS;
typedef LPOLEUIGNRLPROPSA   LPOLEUIGNRLPROPS;
#endif

/* View properties */
typedef struct tagOLEUIVIEWPROPSA {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSA *lpOP;
    int                         nScaleMin;
    int                         nScaleMax;
} OLEUIVIEWPROPSA;
typedef OLEUIVIEWPROPSA     *POLEUIVIEWPROPSA;
typedef OLEUIVIEWPROPSA     *LPOLEUIVIEWPROPSA;
typedef struct tagOLEUIVIEWPROPSW {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSW *lpOP;
    int                         nScaleMin;
    int                         nScaleMax;
} OLEUIVIEWPROPSW;
typedef OLEUIVIEWPROPSW     *POLEUIVIEWPROPSW;
typedef OLEUIVIEWPROPSW     *LPOLEUIVIEWPROPSW;
#ifdef UNICODE
typedef OLEUIVIEWPROPSW     OLEUIVIEWPROPS;
typedef POLEUIVIEWPROPSW    POLEUIVIEWPROPS;
typedef LPOLEUIVIEWPROPSW   LPOLEUIVIEWPROPS;
#else
typedef OLEUIVIEWPROPSA     OLEUIVIEWPROPS;
typedef POLEUIVIEWPROPSA    POLEUIVIEWPROPS;
typedef LPOLEUIVIEWPROPSA   LPOLEUIVIEWSPROPS;
#endif

/* Link properties */
typedef struct tagOLEUILINKPROPSA {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSA *lpOP;
} OLEUILINKPROPSA;
typedef OLEUILINKPROPSA     *POLEUILINKPROPSA;
typedef OLEUILINKPROPSA     *LPOLEUILINKPROPSA;
typedef struct tagOLEUILINKPROPSW {
    DWORD                       cbStruct;
    DWORD                       dwFlags;
    DWORD                       dwReserved1[2];
    LPFNOLEUIHOOK               lpfnHook;
    LPARAM                      lCustData;
    DWORD                       dwReserved2[3];
    struct tagOLEUIOBJECTPROPSW *lpOP;
} OLEUILINKPROPSW;
typedef OLEUILINKPROPSW     *POLEUILINKPROPSW;
typedef OLEUILINKPROPSW     *LPOLEUILINKPROPSW;
#ifdef UNICODE
typedef OLEUILINKPROPSW     OLEUILINKPROPS;
typedef POLEUILINKPROPSW    POLEUILINKPROPS;
typedef LPOLEUILINKPROPSW   LPOLEUILINKPROPS;
#else
typedef OLEUILINKPROPSA     OLEUILINKPROPS;
typedef POLEUILINKPROPSA    POLEUILINKPROPS;
typedef LPOLEUILINKPROPSA   LPOLEUILINKPROPS;
#endif

/* OleUIObjectProperties() parameters */
typedef struct tagOLEUIOBJECTPROPSA {
    DWORD               cbStruct;
    DWORD               dwFlags;
    LPPROPSHEETHEADERA  lpPS;
    DWORD               dwObject;
    LPOLEUIOBJINFOA     lpObjInfo;
    DWORD               dwLink;
    LPOLEUILINKINFOA    lpLinkInfo;
    LPOLEUIGNRLPROPSA   lpGP;
    LPOLEUIVIEWPROPSA   lpVP;
    LPOLEUILINKPROPSA   lpLP;
} OLEUIOBJECTPROPSA;
typedef OLEUIOBJECTPROPSA   *POLEUIOBJECTPROPSA;
typedef OLEUIOBJECTPROPSA   *LPOLEUIOBJECTPROPSA;
typedef struct tagOLEUIOBJECTPROPSW {
    DWORD               cbStruct;
    DWORD               dwFlags;
    LPPROPSHEETHEADERW  lpPS;
    DWORD               dwObject;
    LPOLEUIOBJINFOW     lpObjInfo;
    DWORD               dwLink;
    LPOLEUILINKINFOW    lpLinkInfo;
    LPOLEUIGNRLPROPSW   lpGP;
    LPOLEUIVIEWPROPSW   lpVP;
    LPOLEUILINKPROPSW   lpLP;
} OLEUIOBJECTPROPSW;
typedef OLEUIOBJECTPROPSW   *POLEUIOBJECTPROPSW;
typedef OLEUIOBJECTPROPSW   *LPOLEUIOBJECTPROPSW;
#ifdef UNICODE
typedef OLEUIOBJECTPROPSW   OLEUIOBJECTPROPS;
typedef POLEUIOBJECTPROPSW  POLEUIOBJECTPROPS;
typedef LPOLEUIOBJECTPROPSW LPOLEUIOBJECTPROPS;
#else
typedef OLEUIOBJECTPROPSA   OLEUIOBJECTPROPS;
typedef POLEUIOBJECTPROPSA  POLEUIOBJECTPROPS;
typedef LPOLEUIOBJECTPROPSA LPOLEUIOBJECTPROPS;
#endif

/* Functions in OLEDLG.DLL */
STDAPI_( BOOL ) OleUIAddVerbMenuA( LPOLEOBJECT, LPCSTR, HMENU, UINT, UINT, UINT, BOOL, UINT, HMENU * );
STDAPI_( BOOL ) OleUIAddVerbMenuW( LPOLEOBJECT, LPCWSTR, HMENU, UINT, UINT, UINT, BOOL, UINT, HMENU * );
STDAPI_( UINT ) OleUIBusyA( LPOLEUIBUSYA );
STDAPI_( UINT ) OleUIBusyW( LPOLEUIBUSYW );
STDAPI_( BOOL ) OleUICanConvertOrActiveAs( REFCLSID, BOOL, WORD );
STDAPI_( UINT ) OleUIChangeIconA( LPOLEUICHANGEICONA );
STDAPI_( UINT ) OleUIChangeIconW( LPOLEUICHANGEICONW );
STDAPI_( UINT ) OleUIChangeSourceA( LPOLEUICHANGESOURCEA );
STDAPI_( UINT ) OleUIChangeSourceW( LPOLEUICHANGESOURCEW );
STDAPI_( UINT ) OleUIConvertA( LPOLEUICONVERTA );
STDAPI_( UINT ) OleUIConvertW( LPOLEUICONVERTW );
STDAPI_( UINT ) OleUIEditLinksA( LPOLEUIEDITLINKSA );
STDAPI_( UINT ) OleUIEditLinksW( LPOLEUIEDITLINKSW );
STDAPI_( UINT ) OleUIInsertObjectA( LPOLEUIINSERTOBJECTA );
STDAPI_( UINT ) OleUIInsertObjectW( LPOLEUIINSERTOBJECTW );
STDAPI_( UINT ) OleUIObjectPropertiesA( LPOLEUIOBJECTPROPSA );
STDAPI_( UINT ) OleUIObjectPropertiesW( LPOLEUIOBJECTPROPSW );
STDAPI_( UINT ) OleUIPasteSpecialA( LPOLEUIPASTESPECIALA );
STDAPI_( UINT ) OleUIPasteSpecialW( LPOLEUIPASTESPECIALW );
STDAPIV_( int ) OleUIPromptUserA( int, HWND, ... );
STDAPIV_( int ) OleUIPromptUserW( int, HWND, ... );
STDAPI_( BOOL ) OleUIUpdateLinksA( LPOLEUILINKCONTAINERA, HWND, LPSTR, int );
STDAPI_( BOOL ) OleUIUpdateLinksW( LPOLEUILINKCONTAINERW, HWND, LPWSTR, int );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define OleUIAddVerbMenu        OleUIAddVerbMenuW
    #define OleUIBusy               OleUIBusyW
    #define OleUIChangeIcon         OleUIChangeIconW
    #define OleUIChangeSource       OleUIChangeSourceW
    #define OleUIConvert            OleUIConvertW
    #define OleUIEditLinks          OleUIEditLinksW
    #define OleUIInsertObject       OleUIInsertObjectW
    #define OleUIObjectProperties   OleUIObjectPropertiesW
    #define OleUIPasteSpecial       OleUIPasteSpecialW
    #define OleUIPromptUser         OleUIPromptUserW
    #define OleUIUpdateLinks        OleUIUpdateLinksW
#else
    #define OleUIAddVerbMenu        OleUIAddVerbMenuA
    #define OleUIBusy               OleUIBusyA
    #define OleUIChangeIcon         OleUIChangeIconA
    #define OleUIChangeSource       OleUIChangeSourceA
    #define OleUIConvert            OleUIConvertA
    #define OleUIEditLinks          OleUIEditLinksA
    #define OleUIInsertObject       OleUIInsertObjectA
    #define OleUIObjectProperties   OleUIObjectPropertiesA
    #define OleUIPasteSpecial       OleUIPasteSpecialA
    #define OleUIPromptUser         OleUIPromptUserA
    #define OleUIUpdateLinks        OleUIUpdateLinksA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _OLEDLG_H_ */
