/*
 *  objidl.h    Definition of basic COM interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __objidl_h__
#define __objidl_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <unknwn.h>
#include <wtypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IAdviseSink           IAdviseSink;
typedef interface IAsyncManager         IAsyncManager;
typedef interface IEnumString           IEnumString;
typedef interface IMoniker              IMoniker;
typedef interface IRunningObjectTable   IRunningObjectTable;
typedef interface IStorage              IStorage;
typedef interface IStream               IStream;
typedef interface ISynchronize          ISynchronize;

/* String name block */
typedef LPOLESTR    *SNB;

/* Pointer to clipboard format */
typedef CLIPFORMAT  *LPCLIPFORMAT;

/* RPC OLE data representation */
typedef unsigned long   RPCOLEDATAREP;

/* Apartment identifier data type */
typedef DWORD   APARTMENTID;

/* OLE authentication defaults */
#if (_WIN32_WINNT >= 0x0400)
    #define COLE_DEFAULT_PRINCIPAL  ((OLECHAR *)-1)
    #define COLE_DEFAULT_AUTHINFO   ((void *)-1)
#endif

/* COM server information */
typedef struct _COSERVERINFO {
    DWORD       dwReserved1;
    LPWSTR      pwszName;
    COAUTHINFO  *pAuthInfo;
    DWORD       dwReserved2;
} COSERVERINFO;

/* External connection flags */
typedef enum tagEXTCONN {
    EXTCONN_STRONG      = 0x00000001,
    EXTCONN_WEAK        = 0x00000002,
    EXTCONN_CALLABLE    = 0x00000004
} EXTCONN;

/* IMultiQI::MultipleQueryInterfaces() parameters */
typedef struct tagMULTI_QI {
    const IID   *pIID;
    IUnknown    *pItf;
    HRESULT     hr;
} MULTI_QI;

/* Bind options */
typedef struct tagBIND_OPTS {
    DWORD   cbStruct;
    DWORD   grfFlags;
    DWORD   grfMode;
    DWORD   dwTickCountDeadline;
} BIND_OPTS;
typedef BIND_OPTS   *LPBIND_OPTS;

/* Bind options (version 2) */
#ifdef __cplusplus
typedef struct tagBIND_OPTS2 : public tagBIND_OPTS {
    DWORD           dwTrackFlags;
    DWORD           dwClassContext;
    LCID            locale;
    COSERVERINFO    *pServerInfo;
} BIND_OPTS2;
#else
typedef struct tagBIND_OPTS2 {
    DWORD           cbStruct;
    DWORD           grfFlags;
    DWORD           grfMode;
    DWORD           dwTickCountDeadline;
    DWORD           dwTrackFlags;
    DWORD           dwClassContext;
    LCID            locale;
    COSERVERINFO    *pServerInfo;
} BIND_OPTS2;
#endif
typedef BIND_OPTS2  *LPBIND_OPTS2;

/* Bind options (version 3) */
#ifdef __cplusplus
typedef struct tagBIND_OPTS3 : public tagBIND_OPTS2 {
    HWND    hwnd;
} BIND_OPTS3;
#else
typedef struct tagBIND_OPTS3 {
    DWORD           cbStruct;
    DWORD           grfFlags;
    DWORD           grfMode;
    DWORD           dwTickCountDeadline;
    DWORD           dwTrackFlags;
    DWORD           dwClassContext;
    LCID            locale;
    COSERVERINFO    *pServerInfo;
} BIND_OPTS3;
#endif
typedef BIND_OPTS3  *LPBIND_OPTS3;

/* Bind flags */
typedef enum tagBIND_FLAGS {
    BIND_MAYBOTHERUSER      = 1,
    BIND_JUSTTEXTEXISTENCE  = 2
} BIND_FLAGS;

/* System moniker types */
typedef enum tagMKSYS {
    MKSYS_NONE              = 0,
    MKSYS_GENERICCOMPOSITE  = 1,
    MKSYS_FILEMONIKER       = 2,
    MKSYS_ANTIMONIKER       = 3,
    MKSYS_ITEMMONIKER       = 4,
    MKSYS_POINTERMONIKER    = 5,
    MKSYS_CLASSMONIKER      = 7,
    MKSYS_OBJREFMONIKER     = 8,
    MKSYS_SESSIONMONIKER    = 9,
    MKSYS_LUAMONIKER        = 10
} MKSYS;

/* Moniker reductions */
typedef enum tagMKREDUCE {
    MKRREDUCE_ONE           = 3 << 16,
    MKRREDUCE_TOUSER        = 2 << 16,
    MKRREDUCE_THROUGHUSER   = 1 << 16,
    MKRREDUCE_ALL           = 0 << 16
} MKRREDUCE;

/* Static storage */
typedef struct tagSTATSTG {
    LPOLESTR        pwcsName;
    DWORD           type;
    ULARGE_INTEGER  cbSize;
    FILETIME        mtime;
    FILETIME        ctime;
    FILETIME        atime;
    DWORD           grfMode;
    DWORD           grfLocksSupported;
    CLSID           clsid;
    DWORD           grfStateBits;
    DWORD           reserved;
} STATSTG;

/* Storage types */
typedef enum tagSTGTY {
    STGTY_STORAGE   = 1,
    STGTY_STREAM    = 2,
    STGTY_LOCKBYTES = 3,
    STGTY_PROPERTY  = 4
} STGTY;

/* Stream seek values */
typedef enum tagSTREAM_SEEK {
    STREAM_SEEK_SET = 0,
    STREAM_SEEK_CUR = 1,
    STREAM_SEEK_END = 2
} STREAM_SEEK;

/* Lock types */
typedef enum tagLOCKTYPE {
    LOCK_WRITE      = 1,
    LOCK_EXCLUSIVE  = 2,
    LOCK_ONLYONCE   = 4
} LOCKTYPE;

/* Data/view target device */
typedef struct tagDVTARGETDEVICE {
    DWORD   tdSize;
    WORD    tdDriverNameOffset;
    WORD    tdDeviceNameOffset;
    WORD    tdPortNameOffset;
    WORD    tdExtDevmodeOffset;
    BYTE    tdData[1];
} DVTARGETDEVICE;

/* Data format information */
typedef struct tagFORMATETC {
    CLIPFORMAT      cfFormat;
    DVTARGETDEVICE  *ptd;
    DWORD           dwAspect;
    LONG            lindex;
    DWORD           tymed;
} FORMATETC;
typedef FORMATETC   *LPFORMATETC;

/* Advise flags */
typedef enum tagADVF {
    ADVF_NODATA             = 1,
    ADVF_PRIMEFIRST         = 2,
    ADVF_ONLYONCE           = 4,
    ADVF_DATAONSTOP         = 64,
    ADVFCACHE_NOHANDLER     = 8,
    ADVFCACHE_FORCEBUILTIN  = 16,
    ADVFCACHE_ONSAVE        = 32
} ADVF;

/* Static data */
typedef struct tagSTATDATA {
    FORMATETC   formatetc;
    DWORD       advf;
    IAdviseSink *pAdvSink;
    DWORD       dwConnection;
} STATDATA;
typedef STATDATA    *LPSTATDATA;

/* Type media */
typedef enum tagTYMED {
    TYMED_HGLOBAL   = 1,
    TYMED_FILE      = 2,
    TYMED_ISTREAM   = 4,
    TYMED_ISTORAGE  = 8,
    TYMED_GDI       = 16,
    TYMED_MFPICT    = 32,
    TYMED_ENHMF     = 64,
    TYMED_NULL      = 0
} TYMED;

/* Storage medium */
typedef struct tagSTGMEDIUM {
    DWORD       tymed;
    union {
        HBITMAP         hBitmap;
        HMETAFILEPICT   hMetaFilePict;
        HENHMETAFILE    hEnhMetaFile;
        HGLOBAL         hGlobal;
        LPOLESTR        lpszFileName;
        IStream         *pstm;
        IStorage        *pstg;
#ifdef NONAMELESSUNION
    } u;
#else
    };
#endif
    IUnknown    *pUnkForRelease;
} STGMEDIUM;
typedef STGMEDIUM   *LPSTGMEDIUM;

/* Flag storage medium */
typedef struct _FLAG_STGMEDIUM {
    long        ContextFlags;
    long        fPassOwnership;
    STGMEDIUM   Stgmed;
} FLAG_STGMEDIUM;

/* Data format direction */
typedef enum tagDATADIR {
    DATADIR_GET = 1,
    DATADIR_SET = 2
} DATADIR;

/* IMessageFilter::HandleInComingCall() call types */
typedef enum tagCALLTYPE {
    CALLTYPE_TOPLEVEL               = 1,
    CALLTYPE_NESTED                 = 2,
    CALLTYPE_ASYNC                  = 3,
    CALLTYPE_TOPLEVEL_CALLPENDING   = 4,
    CALLTYPE_ASYNC_CALLPENDING      = 5
} CALLTYPE;

/* Server call status values */
typedef enum tagSERVERCALL {
    SERVERCALL_ISHANDLED    = 0,
    SERVERCALL_REJECTED     = 1,
    SERVERCALL_RETRYLATER   = 2
} SERVERCALL;

/* Pending types */
typedef enum tagPENDINGTYPE {
    PENDINGTYPE_TOPLEVEL    = 1,
    PENDINGTYPE_NESTED      = 2
} PENDINGTYPE;

/* IMessageFilter::MessagePending() return values */
typedef enum tagPENDINGMSG {
    PENDINGMSG_CANCELCALL       = 0,
    PENDINGMSG_WAITNOPROCESS    = 1,
    PENDINGMSG_WAITDEFPROCESS   = 2
} PENDINGMSG;

/* Interface information */
typedef struct tagINTERFACEINFO {
    IUnknown    *pUnk;
    IID         iid;
    WORD        wMethod;
} INTERFACEINFO;
typedef INTERFACEINFO   *LPINTERFACEINFO;

/* RPC OLE message */
typedef struct tagRPCOLEMESSAGE {
    void            *reserved1;
    RPCOLEDATAREP   dataRepresentation;
    void            *Buffer;
    ULONG           cbBuffer;
    ULONG           iMethod;
    void            *reserved2[5];
    ULONG           rpcFlags;
} RPCOLEMESSAGE;
typedef RPCOLEMESSAGE   *PRPCOLEMESSAGE;

/* Channel hook call information */
#if (_WIN32_WINNT >= 0x0400)
typedef struct SChannelHookCallInfo {
    IID     iid;
    DWORD   cbSize;
    GUID    uCausality;
    DWORD   dwServerPid;
    DWORD   iMethod;
    void    *pObject;
} SChannelHookCallInfo;
#endif

/* OLE authentication service */
#if (_WIN32_WINNT >= 0x0400)
typedef struct tagSOLE_AUTHENTICATION_SERVICE {
    DWORD   dwAuthnSvc;
    DWORD   dwAuthzSvc;
    OLECHAR *pPrincipalName;
    HRESULT hr;
} SOLE_AUTHENTICATION_SERVICE;
typedef SOLE_AUTHENTICATION_SERVICE *PSOLE_AUTHENTICATION_SERVICE;
#endif

/* OLE authentication capabilities */
#if (_WIN32_WINNT >= 0x0400)
typedef enum tagEOLE_AUTHENTICATION_CAPABILITIES {
    EOAC_NONE               = 0x00000000,
    EOAC_MUTUAL_AUTH        = 0x00000001,
    EOAC_STATIC_CLOAKING    = 0x00000020,
    EOAC_DYNAMIC_CLOAKING   = 0x00000040,
    EOAC_ANY_AUTHORITY      = 0x00000080,
    EOAC_MAKE_FULLSIC       = 0x00000100,
    EOAC_DEFAULT            = 0x00000800,
    EOAC_SECURE_REFS        = 0x00000002,
    EOAC_ACCESS_CONTROL     = 0x00000004,
    EOAC_APPID              = 0x00000008,
    EOAC_DYNAMIC            = 0x00000010,
    EOAC_REQUIRE_FULLSIC    = 0x00000200,
    EOAC_AUTO_IMPERSONATE   = 0x00000400,
    EOAC_NO_CUSTOM_MARSHAL  = 0x00002000,
    EOAC_DISABLE_AAA        = 0x00001000
} EOLE_AUTHENTICATION_CAPABILITIES;
#endif

/* OLE authentication information */
#if (_WIN32_WINNT >= 0x0400)
typedef struct tagSOLE_AUTHENTICATION_INFO {
    DWORD   dwAuthnSvc;
    DWORD   dwAuthzSvc;
    void    *pAuthInfo;
} SOLE_AUTHENTICATION_INFO;
typedef SOLE_AUTHENTICATION_INFO    *PSOLE_AUTHENTICATION_INFO;
#endif

/* OLE authentication list */
#if (_WIN32_WINNT >= 0x0400)
typedef struct tagSOLE_AUTHENTICATION_LIST {
    DWORD                       cAuthInfo;
    SOLE_AUTHENTICATION_INFO    *aAuthInfo;
} SOLE_AUTHENTICATION_LIST;
typedef SOLE_AUTHENTICATION_LIST    *PSOLE_AUTHENTICATION_LIST;
#endif

/* COM binding properties */
#if (_WIN32_WINNT >= 0x0400)
typedef enum {
    COMBND_RPCTIMEOUT       = 0x00000001,
    COMBND_SERVER_LOCALITY  = 0x00000002
} RPCOPT_PROPERTIES;
#endif

/* Server locality values */
#if (_WIN32_WINNT >= 0x0400)
typedef enum {
    SERVER_LOCALITY_PROCESS_LOCAL   = 0,
    SERVER_LOCALITY_MACHINE_LOCAL   = 1,
    SERVER_LOCALITY_REMOTE          = 2
} RPCOPT_SERVER_LOCALITY_VALUES;
#endif

/* COM global properties */
#if (_WIN32_WINNT >= 0x0400)
typedef enum {
    COMGLB_EXCEPTION_HANDLING       = 1,
    COMGLB_APPID                    = 2,
    COMGLB_RPC_THREADPOOL_SETTING   = 3
} GLOBALOPT_PROPERTIES;
#endif

/* COM global exception handling values */
#if (_WIN32_WINNT >= 0x0400)
typedef enum {
    COMGLB_EXCEPTION_HANDLE             = 0,
    COMGLB_EXCEPTION_DONOT_HANDLE_FATAL = 1,
    COMGLB_EXCEPTION_DONOT_HANDLE       = COMGLB_EXCEPTION_DONOT_HANDLE_FATAL,
    COMGLB_EXCEPTION_DONOT_HANDLE_ANY   = 2
} GLOBALOPT_EH_VALUES;
#endif

/* COM global RPC thread pool values */
#if (_WIN32_WINNT >= 0x0400)
typedef enum {
    COMGLB_RPC_THREADPOOL_SETTING_DEFAULT_POOL  = 0,
    COMGLB_RPC_THREADPOOL_SETTING_PRIVATE_POOL  = 1
} GLOBALOPT_RPCTP_VALUES;
#endif

/* Storage layout */
typedef struct tagStorageLayout {
    DWORD           LayoutType;
    OLECHAR         *pwcsElementName;
    LARGE_INTEGER   cOffset;
    LARGE_INTEGER   cBytes;
} StorageLayout;

/* DCOM call states */
typedef enum tagDCOM_CALL_STATE {
    DCOM_NONE           = 0x00000000,
    DCOM_CALL_COMPLETE  = 0x00000001,
    DCOM_CALL_CANCELED  = 0x00000002
} DCOM_CALL_STATE;

/* Application types */
typedef enum tagApplicationType {
    ServerApplication   = 0,
    LibraryApplication  = 1
} ApplicationType;

/* Shutdown types */
typedef enum tagShutdownType {
    IdleShutdown    = 0,
    ForcedShutdown  = 1
} ShutdownType;

/* Apartment types */
typedef enum _APTTYPE {
    APTTYPE_CURRENT = -1,
    APTTYPE_STA     = 0,
    APTTYPE_MTA     = 1,
    APTTYPE_NA      = 2,
    APTTYPE_MAINSTA = 3
} APTTYPE;

/* Apartment type qualifiers */
typedef enum _APTTYPEQUALIFIER {
    APTTYPEQUALIFIER_NONE               = 0,
    APTTYPEQUALIFIER_IMPLICIT_MTA       = 1,
    APTTYPEQUALIFIER_NA_ON_MTA          = 2,
    APTTYPEQUALIFIER_NA_ON_STA          = 3,
    APTTYPEQUALIFIER_NA_ON_IMPLICIT_MTA = 4,
    APTTYPEQUALIFIER_NA_ON_MAINSTA      = 5
} APTTYPEQUALIFIER;

/* Thread types */
typedef enum _THDTYPE {
    THDTYPE_BLOCKMESSAGES   = 0,
    THDTYPE_PROCESSMESSAGES = 1
} THDTYPE;
 
/* IMarshal interface */
#undef INTERFACE
#define INTERFACE   IMarshal
DECLARE_INTERFACE_( IMarshal, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMarshal methods */
    STDMETHOD( GetUnmarshalClass )( THIS_ REFIID, void *, DWORD, void *, DWORD, CLSID * ) PURE;
    STDMETHOD( GetMarshalSizeMax )( THIS_ REFIID, void *, DWORD, void *, DWORD, DWORD * ) PURE;
    STDMETHOD( MarshalInterface )( THIS_ IStream *, REFIID, void *, DWORD, void *, DWORD ) PURE;
    STDMETHOD( UnmarshalInterface )( THIS_ IStream *, REFIID, void ** ) PURE;
    STDMETHOD( ReleaseMarshalData )( THIS_ IStream * ) PURE;
    STDMETHOD( DisconnectObject )( THIS_ DWORD ) PURE;
};
typedef IMarshal    *LPMARSHAL;

/* IMarshal2 interface */
#undef INTERFACE
#define INTERFACE   IMarshal2
DECLARE_INTERFACE_( IMarshal2, IMarshal ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMarshal methods */
    STDMETHOD( GetUnmarshalClass )( THIS_ REFIID, void *, DWORD, void *, DWORD, CLSID * ) PURE;
    STDMETHOD( GetMarshalSizeMax )( THIS_ REFIID, void *, DWORD, void *, DWORD, DWORD * ) PURE;
    STDMETHOD( MarshalInterface )( THIS_ IStream *, REFIID, void *, DWORD, void *, DWORD ) PURE;
    STDMETHOD( UnmarshalInterface )( THIS_ IStream *, REFIID, void ** ) PURE;
    STDMETHOD( ReleaseMarshalData )( THIS_ IStream * ) PURE;
    STDMETHOD( DisconnectObject )( THIS_ DWORD ) PURE;
};
typedef IMarshal2   *LPMARSHAL2;

/* IMalloc interface */
#undef INTERFACE
#define INTERFACE   IMalloc
DECLARE_INTERFACE_( IMalloc, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMalloc methods */
    STDMETHOD_( void *, Alloc )( THIS_ SIZE_T ) PURE;
    STDMETHOD_( void *, Realloc )( THIS_ void *, SIZE_T ) PURE;
    STDMETHOD_( void, Free )( THIS_ void * ) PURE;
    STDMETHOD_( SIZE_T, GetSize )( THIS_ void * ) PURE;
    STDMETHOD_( int, DidAlloc )( THIS_ void * ) PURE;
    STDMETHOD_( void, HeapMinimize )( THIS ) PURE;
};
typedef IMalloc *LPMALLOC;

/* IMallocSpy interface */
#undef INTERFACE
#define INTERFACE   IMallocSpy
DECLARE_INTERFACE_( IMallocSpy, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMallocSpy methods */
    STDMETHOD_( SIZE_T, PreAlloc )( THIS_ SIZE_T ) PURE;
    STDMETHOD_( void *, PostAlloc )( THIS_ void * ) PURE;
    STDMETHOD_( void *, PreFree )( THIS_ void *, BOOL ) PURE;
    STDMETHOD_( void, PostFree )( THIS_ BOOL ) PURE;
    STDMETHOD_( SIZE_T, PreRealloc )( THIS_ void *, SIZE_T, void **, BOOL ) PURE;
    STDMETHOD_( void *, PostRealloc )( THIS_ void *, BOOL ) PURE;
    STDMETHOD_( void *, PreGetSize )( THIS_ void *, BOOL ) PURE;
    STDMETHOD_( SIZE_T, PostGetSize )( THIS_ SIZE_T, BOOL ) PURE;
    STDMETHOD_( void *, PreDidAlloc )( THIS_ void *, BOOL ) PURE;
    STDMETHOD_( int, PostDidAlloc )( THIS_ void *, BOOL, int ) PURE;
    STDMETHOD_( void, PreHeapMinimize )( THIS ) PURE;
    STDMETHOD_( void, PostHeapMinimize )( THIS ) PURE;
};
typedef IMallocSpy  *LPMALLOCSPY;

/* IStdMarshalInfo interface */
#undef INTERFACE
#define INTERFACE   IStdMarshalInfo
DECLARE_INTERFACE_( IStdMarshalInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IStdMarshalInfo methods */
    STDMETHOD( GetClassForHandler )( THIS_ DWORD, void *, CLSID * ) PURE;
};
typedef IStdMarshalInfo *LPSTDMARSHALINFO;

/* IExternalConnection interface */
#undef INTERFACE
#define INTERFACE   IExternalConnection
DECLARE_INTERFACE_( IExternalConnection, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IExternalConnection methods */
    STDMETHOD_( DWORD, AddConnection )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD_( DWORD, ReleaseConnection )( THIS_ DWORD, DWORD, BOOL ) PURE;
};
typedef IExternalConnection *LPEXTERNALCONNECTION;

/* IMultiQI interface */
#undef INTERFACE
#define INTERFACE   IMultiQI
DECLARE_INTERFACE_( IMultiQI, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMultiQI methods */
    STDMETHOD( QueryMultipleInterfaces )( THIS_ ULONG, MULTI_QI * ) PURE;
};
typedef IMultiQI    *LPMULTIQI;

/* IInternalUnknown interface */
#undef INTERFACE
#define INTERFACE   IInternalUnknown
DECLARE_INTERFACE_( IInternalUnknown, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IInternalUnknown methods */
    STDMETHOD( QueryInternalInterface )( THIS_ REFIID, void ** ) PURE;
};

/* IEnumUnknown interface */
#undef INTERFACE
#define INTERFACE   IEnumUnknown
DECLARE_INTERFACE_( IEnumUnknown, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumUnknown methods */
    STDMETHOD( Next )( THIS_ ULONG, IUnknown **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumUnknown ** ) PURE;
};
typedef IEnumUnknown    *LPENUMUNKNOWN;

/* IBindCtx interface */
#undef INTERFACE
#define INTERFACE   IBindCtx
DECLARE_INTERFACE_( IBindCtx, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IBindCtx methods */
    STDMETHOD( RegisterObjectBound )( THIS_ IUnknown * ) PURE;
    STDMETHOD( RevokeObjectBound )( THIS_ IUnknown * ) PURE;
    STDMETHOD( ReleaseBoundObjects )( THIS ) PURE;
    STDMETHOD( SetBindOptions )( THIS_ BIND_OPTS * ) PURE;
    STDMETHOD( GetBindOptions )( THIS_ BIND_OPTS * ) PURE;
    STDMETHOD( GetRunningObjectTable )( THIS_ IRunningObjectTable ** ) PURE;
    STDMETHOD( RegisterObjectParam )( THIS_ LPOLESTR, IUnknown * ) PURE;
    STDMETHOD( GetObjectParam )( THIS_ LPOLESTR, IUnknown ** ) PURE;
    STDMETHOD( EnumObjectParam )( THIS_ IEnumString ** ) PURE;
    STDMETHOD( RevokeObjectParam )( THIS_ LPOLESTR ) PURE;
};
typedef IBindCtx    *LPBC;
typedef IBindCtx    *LPBINDCTX;

/* IEnumMoniker interface */
#undef INTERFACE
#define INTERFACE   IEnumMoniker
DECLARE_INTERFACE_( IEnumMoniker, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumMoniker methods */
    STDMETHOD( Next )( THIS_ ULONG, IMoniker **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumMoniker ** ) PURE;
};
typedef IEnumMoniker    *LPENUMMONIKER;

/* IRunnableObject interface */
#undef INTERFACE
#define INTERFACE   IRunnableObject
DECLARE_INTERFACE_( IRunnableObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRunnableObject methods */
    STDMETHOD( GetRunningClass )( THIS_ LPCLSID ) PURE;
    STDMETHOD( Run )( THIS_ LPBINDCTX ) PURE;
    STDMETHOD_( BOOL, IsRunning )( THIS ) PURE;
    STDMETHOD( LockRunning )( THIS_ BOOL, BOOL ) PURE;
    STDMETHOD( SetContainedObject )( THIS_ BOOL ) PURE;
};
typedef IRunnableObject *LPRUNNABLEOBJECT;

/* IRunningObjectTable interface */
#undef INTERFACE
#define INTERFACE   IRunningObjectTable
DECLARE_INTERFACE_( IRunningObjectTable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRunningObjectTable methods */
    STDMETHOD( Register )( THIS_ DWORD, IUnknown *, IMoniker *, DWORD * ) PURE;
    STDMETHOD( Revoke )( THIS_ DWORD ) PURE;
    STDMETHOD( IsRunning )( THIS_ IMoniker * ) PURE;
    STDMETHOD( GetObject )( THIS_ IMoniker *, IUnknown ** ) PURE;
    STDMETHOD( NoteChangeTime )( THIS_ DWORD, FILETIME * ) PURE;
    STDMETHOD( GetTimeOfLastChange )( THIS_ IMoniker *, FILETIME * ) PURE;
    STDMETHOD( EnumRunning )( THIS_ IEnumMoniker ** ) PURE;
};
typedef IRunningObjectTable *LPRUNNINGOBJECTTABLE;

/* IPersist interface */
#undef INTERFACE
#define INTERFACE   IPersist
DECLARE_INTERFACE_( IPersist, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
};
typedef IPersist    *LPPERSIST;

/* IPersistStream interface */
#undef INTERFACE
#define INTERFACE   IPersistStream
DECLARE_INTERFACE_( IPersistStream, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
    
    /* IPersistStream methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ IStream * ) PURE;
    STDMETHOD( Save )( THIS_ IStream *, BOOL ) PURE;
    STDMETHOD( GetSizeMax )( THIS_ ULARGE_INTEGER * ) PURE;
};
typedef IPersistStream  *LPPERSISTSTREAM;

/* IMoniker interface */
#undef INTERFACE
#define INTERFACE   IMoniker
DECLARE_INTERFACE_( IMoniker, IPersistStream ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
    
    /* IPersistStream methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ IStream * ) PURE;
    STDMETHOD( Save )( THIS_ IStream *, BOOL ) PURE;
    STDMETHOD( GetSizeMax )( THIS_ ULARGE_INTEGER * ) PURE;
    
    /* IMoniker methods */
    STDMETHOD( BindToObject )( THIS_ IBindCtx *, IMoniker *, REFIID, void ** ) PURE;
    STDMETHOD( BindToStorage )( THIS_ IBindCtx *, IMoniker *, REFIID, void ** ) PURE;
    STDMETHOD( Reduce )( THIS_ IBindCtx *, DWORD, IMoniker **, IMoniker ** ) PURE;
    STDMETHOD( ComposeWith )( THIS_ IMoniker *, BOOL, IMoniker ** ) PURE;
    STDMETHOD( Enum )( THIS_ BOOL, IEnumMoniker ** ) PURE;
    STDMETHOD( IsEqual )( THIS_ IMoniker * ) PURE;
    STDMETHOD( Hash )( THIS_ DWORD * ) PURE;
    STDMETHOD( IsRunning )( THIS_ IBindCtx *, IMoniker *, IMoniker * ) PURE;
    STDMETHOD( GetTimeOfLastChange )( THIS_ IBindCtx *, IMoniker *, FILETIME * ) PURE;
    STDMETHOD( Inverse )( THIS_ IMoniker ** ) PURE;
    STDMETHOD( CommonPrefixWith )( THIS_ IMoniker *, IMoniker ** ) PURE;
    STDMETHOD( RelativePathTo )( THIS_ IMoniker *, IMoniker ** ) PURE;
    STDMETHOD( GetDisplayName )( THIS_ IBindCtx *, IMoniker *, LPOLESTR * ) PURE;
    STDMETHOD( ParseDisplayName )( THIS_ IBindCtx *, IMoniker *, LPOLESTR, ULONG *, IMoniker ** ) PURE;
    STDMETHOD( IsSystemMoniker )( THIS_ DWORD * ) PURE;
};
typedef IMoniker    *LPMONIKER;

/* IROTData interface */
#undef INTERFACE
#define INTERFACE   IROTData
DECLARE_INTERFACE_( IROTData, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IROTData methods */
    STDMETHOD( GetComparisonData )( THIS_ byte *, ULONG, ULONG * ) PURE;
};

/* IEnumString interface */
#undef INTERFACE
#define INTERFACE   IEnumString
DECLARE_INTERFACE_( IEnumString, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumString methods */
    STDMETHOD( Next )( THIS_ ULONG, LPOLESTR *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumString ** ) PURE;
};
typedef IEnumString *LPENUMSTRING;

/* ISequentialStream interface */
#undef INTERFACE
#define INTERFACE   ISequentialStream
DECLARE_INTERFACE_( ISequentialStream, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISequentialStream methods */
    STDMETHOD( Read )( THIS_ void *, ULONG, ULONG * ) PURE;
    STDMETHOD( Write )( THIS_ void const *, ULONG, ULONG * ) PURE;
};

/* IStream interface */
#undef INTERFACE
#define INTERFACE   IStream
DECLARE_INTERFACE_( IStream, ISequentialStream ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISequentialStream methods */
    STDMETHOD( Read )( THIS_ void *, ULONG, ULONG * ) PURE;
    STDMETHOD( Write )( THIS_ void const *, ULONG, ULONG * ) PURE;
    
    /* IStream methods */
    STDMETHOD( Seek )( THIS_ LARGE_INTEGER, DWORD, ULARGE_INTEGER * ) PURE;
    STDMETHOD( SetSize )( THIS_ ULARGE_INTEGER ) PURE;
    STDMETHOD( CopyTo )( THIS_ IStream *, ULARGE_INTEGER, ULARGE_INTEGER *, ULARGE_INTEGER * ) PURE;
    STDMETHOD( Commit )( THIS_ DWORD ) PURE;
    STDMETHOD( Revert )( THIS ) PURE;
    STDMETHOD( LockRegion )( THIS_ ULARGE_INTEGER, ULARGE_INTEGER, DWORD ) PURE;
    STDMETHOD( UnlockRegion )( THIS_ ULARGE_INTEGER, ULARGE_INTEGER, DWORD ) PURE;
    STDMETHOD( Stat )( THIS_ STATSTG *, DWORD ) PURE;
    STDMETHOD( Clone )( THIS_ IStream ** ) PURE;
};
typedef IStream *LPSTREAM;

/* IEnumSTATSTG interface */
#undef INTERFACE
#define INTERFACE   IEnumSTATSTG
DECLARE_INTERFACE_( IEnumSTATSTG, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumSTATSTG methods */
    STDMETHOD( Next )( THIS_ ULONG, STATSTG *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumSTATSTG ** ) PURE;
};
typedef IEnumSTATSTG    *LPENUMSTATSTG;

/* IStorage interface */
#undef INTERFACE
#define INTERFACE   IStorage
DECLARE_INTERFACE_( IStorage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IStorage methods */
    STDMETHOD( CreateStream )( THIS_ const OLECHAR *, DWORD, DWORD, DWORD, IStream ** ) PURE;
    STDMETHOD( OpenStream )( THIS_ const OLECHAR *, void *, DWORD, DWORD, IStream ** ) PURE;
    STDMETHOD( CreateStorage )( THIS_ const OLECHAR *, DWORD, DWORD, DWORD, IStorage ** ) PURE;
    STDMETHOD( OpenStorage )( THIS_ const OLECHAR *, IStorage *, DWORD, SNB, DWORD, IStorage ** ) PURE;
    STDMETHOD( CopyTo )( THIS_ DWORD, IID const *, SNB, IStorage * ) PURE;
    STDMETHOD( MoveElementTo )( THIS_ const OLECHAR *, IStorage *, const OLECHAR *, DWORD ) PURE;
    STDMETHOD( Commit )( THIS_ DWORD ) PURE;
    STDMETHOD( Revert )( THIS ) PURE;
    STDMETHOD( EnumElements )( THIS_ DWORD, void *, DWORD, IEnumSTATSTG ** ) PURE;
    STDMETHOD( DestroyElement )( THIS_ const OLECHAR * ) PURE;
    STDMETHOD( RenameElement )( THIS_ const OLECHAR *, const OLECHAR * ) PURE;
    STDMETHOD( SetElementTimes )( THIS_ const OLECHAR *, FILETIME const *, FILETIME const *, FILETIME const * ) PURE;
    STDMETHOD( SetClass )( THIS_ REFCLSID ) PURE;
    STDMETHOD( SetStateBits )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( Stat )( THIS_ STATSTG *, DWORD ) PURE;
};
typedef IStorage    *LPSTORAGE;

/* IPersistFile interface */
#undef INTERFACE
#define INTERFACE   IPersistFile
DECLARE_INTERFACE_( IPersistFile, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
    
    /* IPersistFile methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ LPCOLESTR, DWORD ) PURE;
    STDMETHOD( Save )( THIS_ LPCOLESTR, BOOL ) PURE;
    STDMETHOD( SaveCompleted )( THIS_ LPCOLESTR ) PURE;
    STDMETHOD( GetCurFile )( THIS_ LPOLESTR * ) PURE;
};
typedef IPersistFile    *LPPERSISTFILE;

/* IPersistStorage interface */
#undef INTERFACE
#define INTERFACE   IPersistStorage
DECLARE_INTERFACE_( IPersistStorage, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;
    
    /* IPersistStorage methods */
    STDMETHOD( IsDirty )( THIS ) PURE;
    STDMETHOD( InitNew )( THIS_ IStorage * ) PURE;
    STDMETHOD( Load )( THIS_ IStorage * ) PURE;
    STDMETHOD( Save )( THIS_ IStorage *, BOOL ) PURE;
    STDMETHOD( SaveCompleted )( THIS_ IStorage * ) PURE;
    STDMETHOD( HandsOffStorage )( THIS ) PURE;
};
typedef IPersistStorage *LPPERSISTSTORAGE;

/* ILockBytes interface */
#undef INTERFACE
#define INTERFACE   ILockBytes
DECLARE_INTERFACE_( ILockBytes, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ILockBytes methods */
    STDMETHOD( ReadAt )( THIS_ ULARGE_INTEGER, void *, ULONG, ULONG * ) PURE;
    STDMETHOD( WriteAt )( THIS_ ULARGE_INTEGER, void const *, ULONG, ULONG * ) PURE;
    STDMETHOD( Flush )( THIS ) PURE;
    STDMETHOD( SetSize )( THIS_ ULARGE_INTEGER ) PURE;
    STDMETHOD( LockRegion )( THIS_ ULARGE_INTEGER, ULARGE_INTEGER, DWORD ) PURE;
    STDMETHOD( UnlockRegion )( THIS_ ULARGE_INTEGER, ULARGE_INTEGER, DWORD ) PURE;
    STDMETHOD( Stat )( THIS_ STATSTG *, DWORD ) PURE;
};
typedef ILockBytes  *LPLOCKBYTES;

/* IEnumFORMATETC interface */
#undef INTERFACE
#define INTERFACE   IEnumFORMATETC
DECLARE_INTERFACE_( IEnumFORMATETC, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumFORMATETC methods */
    STDMETHOD( Next )( THIS_ ULONG, FORMATETC *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumFORMATETC ** ) PURE;
};
typedef IEnumFORMATETC  *LPENUMFORMATETC;

/* IEnumSTATDATA interface */
#undef INTERFACE
#define INTERFACE   IEnumSTATDATA
DECLARE_INTERFACE_( IEnumSTATDATA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IEnumSTATDATA methods */
    STDMETHOD( Next )( THIS_ ULONG, STATDATA *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumSTATDATA ** ) PURE;
};
typedef IEnumSTATDATA   *LPENUMSTATDATA;

/* IRootStorage interface */
#undef INTERFACE
#define INTERFACE   IRootStorage
DECLARE_INTERFACE_( IRootStorage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRootStorage methods */
    STDMETHOD( SwitchToFile )( THIS_ LPOLESTR ) PURE;
};
typedef IRootStorage    *LPROOTSTORAGE;

/* IAdviseSink interface */
#undef INTERFACE
#define INTERFACE   IAdviseSink
DECLARE_INTERFACE_( IAdviseSink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAdviseSink methods */
    STDMETHOD_( void, OnDataChange )( THIS_ FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD_( void, OnViewChange )( THIS_ DWORD, LONG ) PURE;
    STDMETHOD_( void, OnRename )( THIS_ IMoniker * ) PURE;
    STDMETHOD_( void, OnSave )( THIS ) PURE;
    STDMETHOD_( void, OnClose )( THIS ) PURE;
};
typedef IAdviseSink *LPADVISESINK;

/* IAdviseSink2 interface */
#undef INTERFACE
#define INTERFACE   IAdviseSink2
DECLARE_INTERFACE_( IAdviseSink2, IAdviseSink ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAdviseSink methods */
    STDMETHOD_( void, OnDataChange )( THIS_ FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD_( void, OnViewChange )( THIS_ DWORD, LONG ) PURE;
    STDMETHOD_( void, OnRename )( THIS_ IMoniker * ) PURE;
    STDMETHOD_( void, OnSave )( THIS ) PURE;
    STDMETHOD_( void, OnClose )( THIS ) PURE;
    
    /* IAdviseSink2 methods */
    STDMETHOD_( void, OnLinkSrcChange )( THIS_ IMoniker * ) PURE;
};
typedef IAdviseSink2    *LPADVISESINK2;

/* IDataObject interface */
#undef INTERFACE
#define INTERFACE   IDataObject
DECLARE_INTERFACE_( IDataObject, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDataObject methods */
    STDMETHOD( GetData )( THIS_ FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD( GetDataHere )( THIS_ FORMATETC *, STGMEDIUM * ) PURE;
    STDMETHOD( QueryGetData )( THIS_ FORMATETC * ) PURE;
    STDMETHOD( GetCanonicalFormatEtc )( THIS_ FORMATETC *, FORMATETC * ) PURE;
    STDMETHOD( SetData )( THIS_ FORMATETC *, STGMEDIUM *, BOOL ) PURE;
    STDMETHOD( EnumFormatEtc )( THIS_ DWORD, IEnumFORMATETC ** ) PURE;
    STDMETHOD( DAdvise )( THIS_ FORMATETC *, DWORD, IAdviseSink *, DWORD * ) PURE;
    STDMETHOD( DUnadvise )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumDAdvise )( THIS_ IEnumSTATDATA ** ) PURE;
};
typedef IDataObject *LPDATAOBJECT;

/* IDataAdviseHolder interface */
#undef INTERFACE
#define INTERFACE   IDataAdviseHolder
DECLARE_INTERFACE_( IDataAdviseHolder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDataAdviseHolder methods */
    STDMETHOD( Advise )( THIS_ IDataObject *, FORMATETC *, DWORD, IAdviseSink *, DWORD * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumAdvise )( THIS_ IEnumSTATDATA ** ) PURE;
    STDMETHOD( SendOnDataChange )( THIS_ IDataObject *, DWORD, DWORD ) PURE;
};
typedef IDataAdviseHolder   *LPDATAADVISEHOLDER;

/* IMessageFilter interface */
#undef INTERFACE
#define INTERFACE   IMessageFilter
DECLARE_INTERFACE_( IMessageFilter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IMessageFilter methods */
    STDMETHOD_( DWORD, HandleInComingCall )( THIS_ DWORD, HTASK, DWORD, LPINTERFACEINFO ) PURE;
    STDMETHOD_( DWORD, RetryRejectedCall )( THIS_ HTASK, DWORD, DWORD ) PURE;
    STDMETHOD_( DWORD, MessagePending )( THIS_ HTASK, DWORD, DWORD ) PURE;
};
typedef IMessageFilter  *LPMESSAGEFILTER;

/* IRpcChannelBuffer interface */
#undef INTERFACE
#define INTERFACE   IRpcChannelBuffer
DECLARE_INTERFACE_( IRpcChannelBuffer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcChannelBuffer methods */
    STDMETHOD( GetBuffer )( THIS_ RPCOLEMESSAGE *, REFIID ) PURE;
    STDMETHOD( SendReceive )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( FreeBuffer )( THIS_ RPCOLEMESSAGE * ) PURE;
    STDMETHOD( GetDestCtx )( THIS_ DWORD *, void ** ) PURE;
    STDMETHOD( IsConnected )( THIS ) PURE;
};

/* IRpcChannelBuffer2 interface */
#undef INTERFACE
#define INTERFACE   IRpcChannelBuffer2
DECLARE_INTERFACE_( IRpcChannelBuffer2, IRpcChannelBuffer ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcChannelBuffer methods */
    STDMETHOD( GetBuffer )( THIS_ RPCOLEMESSAGE *, REFIID ) PURE;
    STDMETHOD( SendReceive )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( FreeBuffer )( THIS_ RPCOLEMESSAGE * ) PURE;
    STDMETHOD( GetDestCtx )( THIS_ DWORD *, void ** ) PURE;
    STDMETHOD( IsConnected )( THIS ) PURE;
    
    /* IRpcChannelBuffer2 methods */
    STDMETHOD( GetProtocolVersion )( THIS_ DWORD * ) PURE;
};

/* IAsyncRpcChannelBuffer interface */
#undef INTERFACE
#define INTERFACE   IAsyncRpcChannelBuffer
DECLARE_INTERFACE_( IAsyncRpcChannelBuffer, IRpcChannelBuffer2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcChannelBuffer methods */
    STDMETHOD( GetBuffer )( THIS_ RPCOLEMESSAGE *, REFIID ) PURE;
    STDMETHOD( SendReceive )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( FreeBuffer )( THIS_ RPCOLEMESSAGE * ) PURE;
    STDMETHOD( GetDestCtx )( THIS_ DWORD *, void ** ) PURE;
    STDMETHOD( IsConnected )( THIS ) PURE;
    
    /* IRpcChannelBuffer2 methods */
    STDMETHOD( GetProtocolVersion )( THIS_ DWORD * ) PURE;
    
    /* IAsyncRpcChannelBuffer methods */
    STDMETHOD( Send )( THIS_ RPCOLEMESSAGE *, ISynchronize *, ULONG * ) PURE;
    STDMETHOD( Receive )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( GetDestCtxEx )( THIS_ RPCOLEMESSAGE *, DWORD *, void ** ) PURE;
};

/* IRpcChannelBuffer3 interface */
#undef INTERFACE
#define INTERFACE   IRpcChannelBuffer3
DECLARE_INTERFACE_( IRpcChannelBuffer3, IRpcChannelBuffer2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcChannelBuffer methods */
    STDMETHOD( GetBuffer )( THIS_ RPCOLEMESSAGE *, REFIID ) PURE;
    STDMETHOD( SendReceive )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( FreeBuffer )( THIS_ RPCOLEMESSAGE * ) PURE;
    STDMETHOD( GetDestCtx )( THIS_ DWORD *, void ** ) PURE;
    STDMETHOD( IsConnected )( THIS ) PURE;
    
    /* IRpcChannelBuffer2 methods */
    STDMETHOD( GetProtocolVersion )( THIS_ DWORD * ) PURE;
    
    /* IRpcChannelBuffer3 methods */
    STDMETHOD( Send )( THIS_ RPCOLEMESSAGE *, ULONG * ) PURE;
    STDMETHOD( Receive )( THIS_ RPCOLEMESSAGE *, ULONG, ULONG * ) PURE;
    STDMETHOD( Cancel )( THIS_ RPCOLEMESSAGE * ) PURE;
    STDMETHOD( GetCallContext )( THIS_ RPCOLEMESSAGE *, REFIID, void ** ) PURE;
    STDMETHOD( GetDestCtxEx )( THIS_ RPCOLEMESSAGE *, DWORD *, void ** ) PURE;
    STDMETHOD( GetState )( THIS_ RPCOLEMESSAGE *, DWORD * ) PURE;
    STDMETHOD( RegisterAsync )( THIS_ RPCOLEMESSAGE *, IAsyncManager * ) PURE;
};

/* IRpcSyntaxNegotiate interface */
#undef INTERFACE
#define INTERFACE   IRpcSyntaxNegotiate
DECLARE_INTERFACE_( IRpcSyntaxNegotiate, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcSyntaxNegotiate methods */
    STDMETHOD( NegotiateSyntax )( THIS_ RPCOLEMESSAGE * ) PURE;
};

/* IRpcProxyBuffer interface */
#undef INTERFACE
#define INTERFACE   IRpcProxyBuffer
DECLARE_INTERFACE_( IRpcProxyBuffer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcProxyBuffer methods */
    STDMETHOD( Connect )( THIS_ IRpcChannelBuffer * ) PURE;
    STDMETHOD_( void, Disconnect )( THIS ) PURE;
};

/* IRpcStubBuffer interface */
#undef INTERFACE
#define INTERFACE   IRpcStubBuffer
DECLARE_INTERFACE_( IRpcStubBuffer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcStubBuffer methods */
    STDMETHOD( Connect )( THIS_ IUnknown * ) PURE;
    STDMETHOD_( void, Disconnect )( THIS ) PURE;
    STDMETHOD( Invoke )( THIS_ RPCOLEMESSAGE *, IRpcChannelBuffer * ) PURE;
    STDMETHOD_( IRpcStubBuffer *, IsIIDSupported )( THIS_ REFIID ) PURE;
    STDMETHOD_( ULONG, CountRefs )( THIS ) PURE;
    STDMETHOD( DebugServerQueryInterface )( THIS_ void ** ) PURE;
    STDMETHOD_( void, DebugServerRelease )( THIS_ void * ) PURE;
};

/* IPSFactoryBuffer interface */
#undef INTERFACE
#define INTERFACE   IPSFactoryBuffer
DECLARE_INTERFACE_( IPSFactoryBuffer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPSFactoryBuffer methods */
    STDMETHOD( CreateProxy )( THIS_ IUnknown *, REFIID, IRpcProxyBuffer *, void ** ) PURE;
    STDMETHOD( CreateStub )( THIS_ REFIID, IUnknown *, IRpcStubBuffer * ) PURE;
};

/* IChannelHook interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IChannelHook
DECLARE_INTERFACE_( IChannelHook, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IChannelHook methods */
    STDMETHOD_( void, ClientGetSize )( THIS_ REFGUID, REFIID, ULONG * ) PURE;
    STDMETHOD_( void, ClientFillBuffer )( THIS_ REFGUID, REFIID, ULONG *, void * ) PURE;
    STDMETHOD_( void, ClientNotify )( THIS_ REFGUID, REFIID, ULONG, void *, DWORD, HRESULT ) PURE;
    STDMETHOD_( void, ServerNotify )( THIS_ REFGUID, REFIID, ULONG, void *, DWORD ) PURE;
    STDMETHOD_( void, ServerGetSize )( THIS_ REFGUID, REFIID, HRESULT, ULONG * ) PURE;
    STDMETHOD_( void, ServerFillBuffer )( THIS_ REFGUID, REFIID, ULONG *, void *, HRESULT ) PURE;
};
#endif

/* IClientSecurity interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IClientSecurity
DECLARE_INTERFACE_( IClientSecurity, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IClientSecurity methods */
    STDMETHOD( QueryBlanket )( THIS_ IUnknown *, DWORD *, DWORD *, OLECHAR **, DWORD *, DWORD *, void **, DWORD * ) PURE;
    STDMETHOD( SetBlanket )( THIS_ IUnknown *, DWORD, DWORD, OLECHAR *, DWORD, DWORD, void *, DWORD ) PURE;
    STDMETHOD( CopyProxy )( THIS_ IUnknown *, IUnknown ** ) PURE;
};
#endif

/* IServerSecurity interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IServerSecurity
DECLARE_INTERFACE_( IServerSecurity, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IServerSecurity methods */
    STDMETHOD( QueryBlanket )( THIS_ DWORD *, DWORD *, OLECHAR **, DWORD *, DWORD *, void **, DWORD * ) PURE;
    STDMETHOD( ImpersonateClient )( THIS ) PURE;
    STDMETHOD( RevertToSelf )( THIS ) PURE;
    STDMETHOD_( BOOL, IsImpersonating )( THIS ) PURE;
};
#endif

/* IClassActivator interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IClassActivator
DECLARE_INTERFACE_( IClassActivator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IClassActivator methods */
    STDMETHOD( GetClassObject )( THIS_ REFCLSID, DWORD, LCID, REFIID, void ** ) PURE;
};
#endif

/* IRpcOptions interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IRpcOptions
DECLARE_INTERFACE_( IRpcOptions, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcOptions methods */
    STDMETHOD( Set )( THIS_ IUnknown *, RPCOPT_PROPERTIES, ULONG_PTR ) PURE;
    STDMETHOD( Query )( THIS_ IUnknown *, RPCOPT_PROPERTIES, ULONG_PTR * ) PURE;
};
#endif

/* IGlobalOptions interface */
#if (_WIN32_WINNT >= 0x0400)
#undef INTERFACE
#define INTERFACE   IGlobalOptions
DECLARE_INTERFACE_( IGlobalOptions, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IGlobalOptions methods */
    STDMETHOD( Set )( THIS_ GLOBALOPT_PROPERTIES, ULONG_PTR ) PURE;
    STDMETHOD( Query )( THIS_ GLOBALOPT_PROPERTIES, ULONG_PTR * ) PURE;
};
#endif

/* IFillLockBytes interface */
#undef INTERFACE
#define INTERFACE   IFillLockBytes
DECLARE_INTERFACE_( IFillLockBytes, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IFillLockBytes methods */
    STDMETHOD( FillAppend )( THIS_ void const *, ULONG, ULONG * ) PURE;
    STDMETHOD( FillAt )( THIS_ ULARGE_INTEGER, void const *, ULONG, ULONG * ) PURE;
    STDMETHOD( SetFillSize )( THIS_ ULARGE_INTEGER ) PURE;
    STDMETHOD( Terminate )( THIS_ BOOL ) PURE;
};

/* IProgressNotify interface */
#undef INTERFACE
#define INTERFACE   IProgressNotify
DECLARE_INTERFACE_( IProgressNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IProgressNotify methods */
    STDMETHOD( OnProgress )( THIS_ DWORD, DWORD, BOOL, BOOL ) PURE;
};

/* ILayoutStorage interface */
#undef INTERFACE
#define INTERFACE   ILayoutStorage
DECLARE_INTERFACE_( ILayoutStorage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ILayoutStorage methods */
    STDMETHOD( LayoutScript )( THIS_ StorageLayout *, DWORD, DWORD ) PURE;
    STDMETHOD( BeginMonitor )( THIS ) PURE;
    STDMETHOD( EndMonitor )( THIS ) PURE;
    STDMETHOD( ReLayoutDocfile )( THIS_ OLECHAR * ) PURE;
    STDMETHOD( ReLayoutDocfileOnILockBytes )( THIS_ ILockBytes * ) PURE;
};

/* IBlockingLock interface */
#undef INTERFACE
#define INTERFACE   IBlockingLock
DECLARE_INTERFACE_( IBlockingLock, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IBlockingLock methods */
    STDMETHOD( Lock )( THIS_ DWORD ) PURE;
    STDMETHOD( Unlock )( THIS ) PURE;
};

/* ITimeAndNoticeControl interface */
#undef INTERFACE
#define INTERFACE   ITimeAndNoticeControl
DECLARE_INTERFACE_( ITimeAndNoticeControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ITimeAndNoticeControl methods */
    STDMETHOD( SuppressChanges )( THIS_ DWORD, DWORD ) PURE;
};

/* IOplockStorage interface */
#undef INTERFACE
#define INTERFACE   IOplockStorage
DECLARE_INTERFACE_( IOplockStorage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IOplockStorage methods */
    STDMETHOD( CreateStorageEx )( THIS_ LPCWSTR, DWORD, DWORD, DWORD, REFIID, void ** ) PURE;
    STDMETHOD( OpenStorageEx )( THIS_ LPCWSTR, DWORD, DWORD, DWORD, REFIID, void ** ) PURE;
};

/* ISurrogate interface */
#undef INTERFACE
#define INTERFACE   ISurrogate
DECLARE_INTERFACE_( ISurrogate, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISurrogate methods */
    STDMETHOD( LoadDllServer )( THIS_ REFCLSID ) PURE;
    STDMETHOD( FreeSurrogate )( THIS ) PURE;
};
typedef ISurrogate  *LPSURROGATE;

/* IGlobalInterfaceTable interface */
#undef INTERFACE
#define INTERFACE   IGlobalInterfaceTable
DECLARE_INTERFACE_( IGlobalInterfaceTable, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IGlobalInterfaceTable methods */
    STDMETHOD( RegisterInterfaceInGlobal )( THIS_ IUnknown *, REFIID, DWORD * ) PURE;
    STDMETHOD( RevokeInterfaceFromGlobal )( THIS_ DWORD ) PURE;
    STDMETHOD( GetInterfaceFromGlobal )( THIS_ DWORD, REFIID, void ** ) PURE;
};
typedef IGlobalInterfaceTable   *LPGLOBALINTERFACETABLE;

/* IDirectWriterLock interface */
#undef INTERFACE
#define INTERFACE   IDirectWriterLock
DECLARE_INTERFACE_( IDirectWriterLock, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDirectWriterLock methods */
    STDMETHOD( WaitForWriteAccess )( THIS_ DWORD ) PURE;
    STDMETHOD( ReleaseWriteAccess )( THIS ) PURE;
    STDMETHOD( HaveWriteAccess )( THIS ) PURE;
};

/* ISynchronize interface */
#undef INTERFACE
#define INTERFACE   ISynchronize
DECLARE_INTERFACE_( ISynchronize, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISynchronize methods */
    STDMETHOD( Wait )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( Signal )( THIS ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
};

/* ISynchronizeHandle interface */
#undef INTERFACE
#define INTERFACE   ISynchronizeHandle
DECLARE_INTERFACE_( ISynchronizeHandle, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISynchronizeHandle methods */
    STDMETHOD( GetHandle )( THIS_ HANDLE * ) PURE;
};

/* ISynchronizeEvent interface */
#undef INTERFACE
#define INTERFACE   ISynchronizeEvent
DECLARE_INTERFACE_( ISynchronizeEvent, ISynchronizeHandle ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISynchronizeHandle methods */
    STDMETHOD( GetHandle )( THIS_ HANDLE * ) PURE;
    
    /* ISynchronizeEvent methods */
    STDMETHOD( SetEventHandle )( THIS_ HANDLE * ) PURE;
};

/* ISynchronizeContainer interface */
#undef INTERFACE
#define INTERFACE   ISynchronizeContainer
DECLARE_INTERFACE_( ISynchronizeContainer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISynchronizeContainer methods */
    STDMETHOD( AddSynchronize )( THIS_ ISynchronize * ) PURE;
    STDMETHOD( WaitMultiple )( THIS_ DWORD, DWORD, ISynchronize ** ) PURE;
};

/* ISynchronizeMutex interface */
#undef INTERFACE
#define INTERFACE   ISynchronizeMutex
DECLARE_INTERFACE_( ISynchronizeMutex, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISynchronizeMutex methods */
    STDMETHOD( ReleaseMutex )( THIS ) PURE;
};

/* ICancelMethodCalls interface */
#undef INTERFACE
#define INTERFACE   ICancelMethodCalls
DECLARE_INTERFACE_( ICancelMethodCalls, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICancelMethodCalls methods */
    STDMETHOD( Cancel )( THIS_ ULONG ) PURE;
    STDMETHOD( TestCancel )( THIS ) PURE;
};
typedef ICancelMethodCalls  *LPCANCELMETHODCALLS;

/* IAsyncManager interface */
#undef INTERFACE
#define INTERFACE   IAsyncManager
DECLARE_INTERFACE_( IAsyncManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAsyncManager methods */
    STDMETHOD( CompleteCall )( THIS_ HRESULT ) PURE;
    STDMETHOD( GetCallContext )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( GetState )( THIS_ ULONG * ) PURE;
};

/* ICallFactory interface */
#undef INTERFACE
#define INTERFACE   ICallFactory
DECLARE_INTERFACE_( ICallFactory, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ICallFactory methods */
    STDMETHOD( CreateCall )( THIS_ REFIID, IUnknown *, REFIID, IUnknown ** ) PURE;
};

/* IRpcHelper interface */
#undef INTERFACE
#define INTERFACE   IRpcHelper
DECLARE_INTERFACE_( IRpcHelper, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IRpcHelper methods */
    STDMETHOD( GetDCOMProtocolVersion )( THIS_ DWORD * ) PURE;
    STDMETHOD( GetIIDFromOBJREF )( THIS_ void *, IID ** ) PURE;
};

/* IReleaseMarshalBuffers interface */
#undef INTERFACE
#define INTERFACE   IReleaseMarshalBuffers
DECLARE_INTERFACE_( IReleaseMarshalBuffers, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IReleaseMarshalBuffers methods */
    STDMETHOD( ReleaseMarshalBuffers )( THIS_ RPCOLEMESSAGE *, DWORD, IUnknown * ) PURE;
};

/* IWaitMultiple interface */
#undef INTERFACE
#define INTERFACE   IWaitMultiple
DECLARE_INTERFACE_( IWaitMultiple, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IWaitMultiple methods */
    STDMETHOD( WaitMultiple )( THIS_ DWORD, ISynchronize ** ) PURE;
    STDMETHOD( AddSynchronize )( THIS_ ISynchronize * ) PURE;
};

/* IUrlMon interface */
#undef INTERFACE
#define INTERFACE   IUrlMon
DECLARE_INTERFACE_( IUrlMon, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IUrlMon methods */
    STDMETHOD( AsyncGetClassBits )( THIS_ REFCLSID, LPCWSTR, LPCWSTR, DWORD, DWORD, LPCWSTR, IBindCtx *, DWORD, REFIID, DWORD ) PURE;
};

/* IForegroundTransfer interface */
#undef INTERFACE
#define INTERFACE   IForegroundTransfer
DECLARE_INTERFACE_( IForegroundTransfer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IForegroundTransfer methods */
    STDMETHOD( AllowForegroundTransfer )( THIS_ void * ) PURE;
};

/* IAddrTrackingControl interface */
#undef INTERFACE
#define INTERFACE   IAddrTrackingControl
DECLARE_INTERFACE_( IAddrTrackingControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAddrTrackingControl methods */
    STDMETHOD( EnableCOMDynamicAddrTracking )( THIS ) PURE;
    STDMETHOD( DisableCOMDynamicAddrTracking )( THIS ) PURE;
};
typedef IAddrTrackingControl    *LPADDRTRACKINGCONTROL;

/* IAddrExclusionControl interface */
#undef INTERFACE
#define INTERFACE   IAddrExclusionControl
DECLARE_INTERFACE_( IAddrExclusionControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IAddrExclusionControl methods */
    STDMETHOD( GetCurrentAddrExclusionList )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( UpdateAddrExclusionList )( THIS_ IUnknown * ) PURE;
};
typedef IAddrExclusionControl   *LPADDREXCLUSIONCONTROL;

/* IPipeByte interface */
#undef INTERFACE
#define INTERFACE   IPipeByte
DECLARE_INTERFACE_( IPipeByte, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPipeByte methods */
    STDMETHOD( Pull )( THIS_ BYTE *, ULONG, ULONG * ) PURE;
    STDMETHOD( Push )( THIS_ BYTE *, ULONG ) PURE;
};

/* IPipeLong interface */
#undef INTERFACE
#define INTERFACE   IPipeLong
DECLARE_INTERFACE_( IPipeLong, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPipeLong methods */
    STDMETHOD( Pull )( THIS_ LONG *, ULONG, ULONG * ) PURE;
    STDMETHOD( Push )( THIS_ LONG *, ULONG ) PURE;
};

/* IPipeDouble interface */
#undef INTERFACE
#define INTERFACE   IPipeDouble
DECLARE_INTERFACE_( IPipeDouble, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPipeDouble methods */
    STDMETHOD( Pull )( THIS_ DOUBLE *, ULONG, ULONG * ) PURE;
    STDMETHOD( Push )( THIS_ DOUBLE *, ULONG ) PURE;
};

/* IThumbnailExtractor interface */
#undef INTERFACE
#define INTERFACE   IThumbnailExtractor
DECLARE_INTERFACE_( IThumbnailExtractor, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IThumbnailExtractor methods */
    STDMETHOD( ExtractThumbnail )( THIS_ IStorage *, ULONG, ULONG, ULONG *, ULONG *, HBITMAP * ) PURE;
    STDMETHOD( OnFileUpdated )( THIS_ IStorage * ) PURE;
};

/* IDummyHICONIncluder interface */
#undef INTERFACE
#define INTERFACE   IDummyHICONIncluder
DECLARE_INTERFACE_( IDummyHICONIncluder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IDummyHICONIncluder methods */
    STDMETHOD( Dummy )( THIS_ HICON, HDC ) PURE;
};

/* IProcessLock interface */
#undef INTERFACE
#define INTERFACE   IProcessLock
DECLARE_INTERFACE_( IProcessLock, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IProcessLock methods */
    STDMETHOD_( ULONG, AddRefOnProcess )( THIS ) PURE;
    STDMETHOD_( ULONG, ReleaseOnProcess )( THIS ) PURE;
};

/* ISurrogateService interface */
#undef INTERFACE
#define INTERFACE   ISurrogateService
DECLARE_INTERFACE_( ISurrogateService, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* ISurrogateService methods */
    STDMETHOD( Init )( THIS_ REFGUID, IProcessLock *, BOOL * ) PURE;
    STDMETHOD( ApplicationLaunch )( THIS_ REFGUID, ApplicationType ) PURE;
    STDMETHOD( ApplicationFree )( THIS_ REFGUID ) PURE;
    STDMETHOD( CatalogRefresh )( THIS_ ULONG ) PURE;
    STDMETHOD( ProcessShutdown )( THIS_ ShutdownType ) PURE;
};

/* IComThreadingInfo interface */
#undef INTERFACE
#define INTERFACE   IComThreadingInfo
DECLARE_INTERFACE_( IComThreadingInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IComThreadingInfo methods */
    STDMETHOD( GetCurrentApartmentType )( THIS_ APTTYPE * ) PURE;
    STDMETHOD( GetCurrentThreadType )( THIS_ THDTYPE * ) PURE;
    STDMETHOD( GetCurrentLogicalThreadId )( THIS_ GUID * ) PURE;
    STDMETHOD( SetCurrentLogicalThreadId )( THIS_ REFGUID ) PURE;
};

/* IProcessInitControl interface */
#undef INTERFACE
#define INTERFACE   IProcessInitControl
DECLARE_INTERFACE_( IProcessInitControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IProcessInitControl methods */
    STDMETHOD( ResetInitializerTimeout )( THIS_ DWORD ) PURE;
};

/* IInitializeSpy interface */
#if (_WIN32_WINNT >= 0x0501)
#undef INTERFACE
#define INTERFACE   IInitializeSpy
DECLARE_INTERFACE_( IInitializeSpy, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IInitializeSpy methods */
    STDMETHOD( PreInitialize )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( PostInitialize )( THIS_ HRESULT, DWORD, DWORD ) PURE;
    STDMETHOD( PreUninitialize )( THIS_ DWORD ) PURE;
    STDMETHOD( PostUninitialize )( THIS_ DWORD ) PURE;
};
typedef IInitializeSpy  *LPINITIALIZESPY;
#endif

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define IMarshal_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMarshal_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMarshal_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMarshal_GetUnmarshalClass( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetUnmarshalClass( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal_GetMarshalSizeMax( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetMarshalSizeMax( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal_MarshalInterface( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->MarshalInterface( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal_UnmarshalInterface( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnmarshalInterface( x, p1, p2, p3 )
    #define IMarshal_ReleaseMarshalData( x, p ) \
        (x)->lpVtbl->ReleaseMarshalData( x, p )
    #define IMarshal_DisconnectObject( x, p ) \
        (x)->lpVtbl->DisconnectObject( x, p )
    #define IMarshal2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMarshal2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMarshal2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMarshal2_GetUnmarshalClass( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetUnmarshalClass( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal2_GetMarshalSizeMax( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetMarshalSizeMax( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal2_MarshalInterface( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->MarshalInterface( x, p1, p2, p3, p4, p5, p6 )
    #define IMarshal2_UnmarshalInterface( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnmarshalInterface( x, p1, p2, p3 )
    #define IMarshal2_ReleaseMarshalData( x, p ) \
        (x)->lpVtbl->ReleaseMarshalData( x, p )
    #define IMarshal2_DisconnectObject( x, p ) \
        (x)->lpVtbl->DisconnectObject( x, p )
    #define IMalloc_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMalloc_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMalloc_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMalloc_Alloc( x, p ) \
        (x)->lpVtbl->Alloc( x, p )
    #define IMalloc_Realloc( x, p1, p2 ) \
        (x)->lpVtbl->Realloc( x, p1, p2 )
    #define IMalloc_Free( x, p ) \
        (x)->lpVtbl->Free( x, p )
    #define IMalloc_GetSize( x, p ) \
        (x)->lpVtbl->GetSize( x, p )
    #define IMalloc_DidAlloc( x, p ) \
        (x)->lpVtbl->DidAlloc( x, p )
    #define IMalloc_HeapMinimize( x ) \
        (x)->lpVtbl->HeapMinimize( x )
    #define IMallocSpy_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMallocSpy_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMallocSpy_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMallocSpy_PreAlloc( x, p ) \
        (x)->lpVtbl->PreAlloc( x, p )
    #define IMallocSpy_PostAlloc( x, p ) \
        (x)->lpVtbl->PostAlloc( x, p )
    #define IMallocSpy_PreFree( x, p1, p2 ) \
        (x)->lpVtbl->PreFree( x, p1, p2 )
    #define IMallocSpy_PostFree( x, p ) \
        (x)->lpVtbl->PostFree( x, p )
    #define IMallocSpy_PreRealloc( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PreRealloc( x, p1, p2, p3, p4 )
    #define IMallocSpy_PostRealloc( x, p1, p2 ) \
        (x)->lpVtbl->PostRealloc( x, p1, p2 )
    #define IMallocSpy_PreGetSize( x, p1, p2 ) \
        (x)->lpVtbl->PreGetSize( x, p1, p2 )
    #define IMallocSpy_PostGetSize( x, p1, p2 ) \
        (x)->lpVtbl->PostGetSize( x, p1, p2 )
    #define IMallocSpy_PreDidAlloc( x, p1, p2 ) \
        (x)->lpVtbl->PreDidAlloc( x, p1, p2 )
    #define IMallocSpy_PostDidAlloc( x, p1, p2, p3 ) \
        (x)->lpVtbl->PostDidAlloc( x, p1, p2, p3 )
    #define IMallocSpy_PreHeapMinimize( x ) \
        (x)->lpVtbl->PreHeapMinimize( x )
    #define IMallocSpy_PostHeapMinimize( x ) \
        (x)->lpVtbl->PostHeapMinimize( x )
    #define IStdMarshalInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IStdMarshalInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IStdMarshalInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IStdMarshalInfo_GetClassForHandler( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetClassForHandler( x, p1, p2, p3 )
    #define IExternalConnection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IExternalConnection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IExternalConnection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IExternalConnection_AddConnection( x, p1, p2 ) \
        (x)->lpVtbl->AddConnection( x, p1, p2 )
    #define IExternalConnection_ReleaseConnection( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReleaseConnection( x, p1, p2, p3 )
    #define IMultiQI_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMultiQI_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMultiQI_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMultiQI_QueryMultipleInterfaces( x, p1, p2 ) \
        (x)->lpVtbl->QueryMultipleInterfaces( x, p1, p2 )
    #define IInternalUnknown_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IInternalUnknown_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IInternalUnknown_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IInternalUnknown_QueryInternalInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInternalInterface( x, p1, p2 )
    #define IEnumUnknown_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumUnknown_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumUnknown_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumUnknown_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumUnknown_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumUnknown_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumUnknown_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IBindCtx_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBindCtx_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBindCtx_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBindCtx_RegisterObjectBound( x, p ) \
        (x)->lpVtbl->RegisterObjectBound( x, p )
    #define IBindCtx_RevokeObjectBound( x, p ) \
        (x)->lpVtbl->RevokeObjectBound( x, p )
    #define IBindCtx_ReleaseBoundObjects( x ) \
        (x)->lpVtbl->ReleaseBoundObjects( x )
    #define IBindCtx_SetBindOptions( x, p ) \
        (x)->lpVtbl->SetBindOptions( x, p )
    #define IBindCtx_GetBindOptions( x, p ) \
        (x)->lpVtbl->GetBindOptions( x, p )
    #define IBindCtx_GetRunningObjectTable( x, p ) \
        (x)->lpVtbl->GetRunningObjectTable( x, p )
    #define IBindCtx_RegisterObjectParam( x, p1, p2 ) \
        (x)->lpVtbl->RegisterObjectParam( x, p1, p2 )
    #define IBindCtx_GetObjectParam( x, p1, p2 ) \
        (x)->lpVtbl->GetObjectParam( x, p1, p2 )
    #define IBindCtx_EnumObjectParam( x, p ) \
        (x)->lpVtbl->EnumObjectParam( x, p )
    #define IBindCtx_RevokeObjectParam( x, p ) \
        (x)->lpVtbl->RevokeObjectParam( x, p )
    #define IEnumMoniker_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumMoniker_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumMoniker_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumMoniker_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumMoniker_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumMoniker_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumMoniker_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IRunnableObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRunnableObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRunnableObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRunnableObject_GetRunningClass( x, p ) \
        (x)->lpVtbl->GetRunningClass( x, p )
    #define IRunnableObject_Run( x, p ) \
        (x)->lpVtbl->Run( x, p )
    #define IRunnableObject_IsRunning( x ) \
        (x)->lpVtbl->IsRunning( x )
    #define IRunnableObject_LockRunning( x, p1, p2 ) \
        (x)->lpVtbl->LockRunning( x, p1, p2 )
    #define IRunnableObject_SetContainedObject( x, p ) \
        (x)->lpVtbl->SetContainedObject( x, p )
    #define IRunningObjectTable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRunningObjectTable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRunningObjectTable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRunningObjectTable_Register( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Register( x, p1, p2, p3, p4 )
    #define IRunningObjectTable_Revoke( x, p ) \
        (x)->lpVtbl->Revoke( x, p )
    #define IRunningObjectTable_IsRunning( x, p ) \
        (x)->lpVtbl->IsRunning( x, p )
    #define IRunningObjectTable_GetObject( x, p1, p2 ) \
        (x)->lpVtbl->GetObject( x, p1, p2 )
    #define IRunningObjectTable_NoteChangeTime( x, p1, p2 ) \
        (x)->lpVtbl->NoteChangeTime( x, p1, p2 )
    #define IRunningObjectTable_GetTimeOfLastChange( x, p1, p2 ) \
        (x)->lpVtbl->GetTimeOfLastChange( x, p1, p2 )
    #define IRunningObjectTable_EnumRunning( x, p ) \
        (x)->lpVtbl->EnumRunning( x, p )
    #define IPersist_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersist_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersist_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersist_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistStream_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistStream_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistStream_Load( x, p ) \
        (x)->lpVtbl->Load( x, p )
    #define IPersistStream_Save( x, p1, p2 ) \
        (x)->lpVtbl->Save( x, p1, p2 )
    #define IPersistStream_GetSizeMax( x, p ) \
        (x)->lpVtbl->GetSizeMax( x, p )
    #define IMoniker_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMoniker_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMoniker_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMoniker_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IMoniker_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IMoniker_Load( x, p ) \
        (x)->lpVtbl->Load( x, p )
    #define IMoniker_Save( x, p1, p2 ) \
        (x)->lpVtbl->Save( x, p1, p2 )
    #define IMoniker_GetSizeMax( x, p ) \
        (x)->lpVtbl->GetSizeMax( x, p )
    #define IMoniker_BindToObject( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BindToObject( x, p1, p2, p3, p4 )
    #define IMoniker_BindToStorage( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->BindToStorage( x, p1, p2, p3, p4 )
    #define IMoniker_Reduce( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Reduce( x, p1, p2, p3, p4 )
    #define IMoniker_ComposeWith( x, p1, p2, p3 ) \
        (x)->lpVtbl->ComposeWith( x, p1, p2, p3 )
    #define IMoniker_Enum( x, p1, p2 ) \
        (x)->lpVtbl->Enum( x, p1, p2 )
    #define IMoniker_IsEqual( x, p ) \
        (x)->lpVtbl->IsEqual( x, p )
    #define IMoniker_Hash( x, p ) \
        (x)->lpVtbl->Hash( x, p )
    #define IMoniker_IsRunning( x, p1, p2, p3 ) \
        (x)->lpVtbl->IsRunning( x, p1, p2, p3 )
    #define IMoniker_GetTimeOfLastChange( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTimeOfLastChange( x, p1, p2, p3 )
    #define IMoniker_Inverse( x, p ) \
        (x)->lpVtbl->Inverse( x, p )
    #define IMoniker_CommonPrefixWith( x, p1, p2 ) \
        (x)->lpVtbl->CommonPrefixWith( x, p1, p2 )
    #define IMoniker_RelativePathTo( x, p1, p2 ) \
        (x)->lpVtbl->RelativePathTo( x, p1, p2 )
    #define IMoniker_GetDisplayName( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDisplayName( x, p1, p2, p3 )
    #define IMoniker_ParseDisplayName( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->ParseDisplayName( x, p1, p2, p3, p4, p5 )
    #define IMoniker_IsSystemMoniker( x, p ) \
        (x)->lpVtbl->IsSystemMoniker( x, p )
    #define IROTData_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IROTData_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IROTData_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IROTData_GetComparisonData( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetComparisonData( x, p1, p2, p3 )
    #define IEnumString_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumString_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumString_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumString_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumString_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumString_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumString_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define ISequentialStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISequentialStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISequentialStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISequentialStream_Read( x, p1, p2, p3 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3 )
    #define ISequentialStream_Write( x, p1, p2, p3 ) \
        (x)->lpVtbl->Write( x, p1, p2, p3 )
    #define IStream_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IStream_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IStream_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IStream_Read( x, p1, p2, p3 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3 )
    #define IStream_Write( x, p1, p2, p3 ) \
        (x)->lpVtbl->Write( x, p1, p2, p3 )
    #define IStream_Seek( x, p1, p2, p3 ) \
        (x)->lpVtbl->Seek( x, p1, p2, p3 )
    #define IStream_SetSize( x, p ) \
        (x)->lpVtbl->SetSize( x, p )
    #define IStream_CopyTo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CopyTo( x, p1, p2, p3, p4 )
    #define IStream_Commit( x, p ) \
        (x)->lpVtbl->Commit( x, p )
    #define IStream_Revert( x ) \
        (x)->lpVtbl->Revert( x )
    #define IStream_LockRegion( x, p1, p2, p3 ) \
        (x)->lpVtbl->LockRegion( x, p1, p2, p3 )
    #define IStream_UnlockRegion( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnlockRegion( x, p1, p2, p3 )
    #define IStream_Stat( x, p1, p2 ) \
        (x)->lpVtbl->Stat( x, p1, p2 )
    #define IStream_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumSTATSTG_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumSTATSTG_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumSTATSTG_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumSTATSTG_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumSTATSTG_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumSTATSTG_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumSTATSTG_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IStorage_CreateStream( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->CreateStream( x, p1, p2, p3, p4, p5 )
    #define IStorage_OpenStream( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->OpenStream( x, p1, p2, p3, p4, p5 )
    #define IStorage_CreateStorage( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->CreateStorage( x, p1, p2, p3, p4, p5 )
    #define IStorage_OpenStorage( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->OpenStorage( x, p1, p2, p3, p4, p5, p6 )
    #define IStorage_CopyTo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CopyTo( x, p1, p2, p3, p4 )
    #define IStorage_MoveElementTo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->MoveElementTo( x, p1, p2, p3, p4 )
    #define IStorage_Commit( x, p ) \
        (x)->lpVtbl->Commit( x, p )
    #define IStorage_Revert( x ) \
        (x)->lpVtbl->Revert( x )
    #define IStorage_EnumElements( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumElements( x, p1, p2, p3, p4 )
    #define IStorage_DestroyElement( x, p ) \
        (x)->lpVtbl->DestroyElement( x, p )
    #define IStorage_RenameElement( x, p1, p2 ) \
        (x)->lpVtbl->RenameElement( x, p1, p2 )
    #define IStorage_SetElementTimes( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetElementTimes( x, p1, p2, p3, p4 )
    #define IStorage_SetClass( x, p ) \
        (x)->lpVtbl->SetClass( x, p )
    #define IStorage_SetStateBits( x, p1, p2 ) \
        (x)->lpVtbl->SetStateBits( x, p1, p2 )
    #define IStorage_Stat( x, p1, p2 ) \
        (x)->lpVtbl->Stat( x, p1, p2 )
    #define IPersistFile_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistFile_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistFile_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistFile_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistFile_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistFile_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IPersistFile_Save( x, p1, p2 ) \
        (x)->lpVtbl->Save( x, p1, p2 )
    #define IPersistFile_SaveCompleted( x, p ) \
        (x)->lpVtbl->SaveCompleted( x, p )
    #define IPersistFile_GetCurFile( x, p ) \
        (x)->lpVtbl->GetCurFile( x, p )
    #define IPersistStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistStorage_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistStorage_IsDirty( x ) \
        (x)->lpVtbl->IsDirty( x )
    #define IPersistStorage_InitNew( x, p ) \
        (x)->lpVtbl->InitNew( x, p )
    #define IPersistStorage_Load( x, p ) \
        (x)->lpVtbl->Load( x, p )
    #define IPersistStorage_Save( x, p1, p2 ) \
        (x)->lpVtbl->Save( x, p1, p2 )
    #define IPersistStorage_SaveCompleted( x, p ) \
        (x)->lpVtbl->SaveCompleted( x, p )
    #define IPersistStorage_HandsOffStorage( x ) \
        (x)->lpVtbl->HandsOffStorage( x )
    #define ILockBytes_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ILockBytes_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ILockBytes_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ILockBytes_ReadAt( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ReadAt( x, p1, p2, p3, p4 )
    #define ILockBytes_WriteAt( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->WriteAt( x, p1, p2, p3, p4 )
    #define ILockBytes_Flush( x ) \
        (x)->lpVtbl->Flush( x )
    #define ILockBytes_SetSize( x, p ) \
        (x)->lpVtbl->SetSize( x, p )
    #define ILockBytes_LockRegion( x, p1, p2, p3 ) \
        (x)->lpVtbl->LockRegion( x, p1, p2, p3 )
    #define ILockBytes_UnlockRegion( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnlockRegion( x, p1, p2, p3 )
    #define ILockBytes_Stat( x, p1, p2 ) \
        (x)->lpVtbl->Stat( x, p1, p2 )
    #define IEnumFORMATETC_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumFORMATETC_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumFORMATETC_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumFORMATETC_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumFORMATETC_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumFORMATETC_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumFORMATETC_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumSTATDATA_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumSTATDATA_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumSTATDATA_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumSTATDATA_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumSTATDATA_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumSTATDATA_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumSTATDATA_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IRootStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRootStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRootStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAdviseSink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAdviseSink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAdviseSink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAdviseSink_OnDataChange( x, p1, p2 ) \
        (x)->lpVtbl->OnDataChange( x, p1, p2 )
    #define IAdviseSink_OnViewChange( x, p1, p2 ) \
        (x)->lpVtbl->OnViewChange( x, p1, p2 )
    #define IAdviseSink_OnRename( x, p ) \
        (x)->lpVtbl->OnRename( x, p )
    #define IAdviseSink_OnSave( x ) \
        (x)->lpVtbl->OnSave( x )
    #define IAdviseSink_OnClose( x ) \
        (x)->lpVtbl->OnClose( x )
    #define IAdviseSink2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAdviseSink2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAdviseSink2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAdviseSink2_OnDataChange( x, p1, p2 ) \
        (x)->lpVtbl->OnDataChange( x, p1, p2 )
    #define IAdviseSink2_OnViewChange( x, p1, p2 ) \
        (x)->lpVtbl->OnViewChange( x, p1, p2 )
    #define IAdviseSink2_OnRename( x, p ) \
        (x)->lpVtbl->OnRename( x, p )
    #define IAdviseSink2_OnSave( x ) \
        (x)->lpVtbl->OnSave( x )
    #define IAdviseSink2_OnClose( x ) \
        (x)->lpVtbl->OnClose( x )
    #define IAdviseSink2_OnLinkSrcChange( x, p ) \
        (x)->lpVtbl->OnLinkSrcChange( x, p )
    #define IDataObject_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDataObject_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDataObject_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDataObject_GetData( x, p1, p2 ) \
        (x)->lpVtbl->GetData( x, p1, p2 )
    #define IDataObject_GetDataHere( x, p1, p2 ) \
        (x)->lpVtbl->GetDataHere( x, p1, p2 )
    #define IDataObject_QueryGetData( x, p ) \
        (x)->lpVtbl->QueryGetData( x, p )
    #define IDataObject_GetCanonicalFormatEtc( x, p1, p2 ) \
        (x)->lpVtbl->GetCanonicalFormatEtc( x, p1, p2 )
    #define IDataObject_SetData( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetData( x, p1, p2, p3 )
    #define IDataObject_EnumFormatEtc( x, p1, p2 ) \
        (x)->lpVtbl->EnumFormatEtc( x, p1, p2 )
    #define IDataObject_DAdvise( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->DAdvise( x, p1, p2, p3, p4 )
    #define IDataObject_DUnadvise( x, p ) \
        (x)->lpVtbl->DUnadvise( x, p )
    #define IDataObject_EnumDAdvise( x, p ) \
        (x)->lpVtbl->EnumDAdvise( x, p )
    #define IDataAdviseHolder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDataAdviseHolder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDataAdviseHolder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDataAdviseHolder_Advise( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->Advise( x, p1, p2, p3, p4, p5 )
    #define IDataAdviseHolder_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IDataAdviseHolder_EnumAdvise( x, p ) \
        (x)->lpVtbl->EnumAdvise( x, p )
    #define IDataAdviseHolder_SendOnDataChange( x, p1, p2, p3 ) \
        (x)->lpVtbl->SendOnDataChange( x, p1, p2, p3 )
    #define IMessageFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMessageFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMessageFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMessageFilter_HandleInComingCall( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->HandleInComingCall( x, p1, p2, p3, p4 )
    #define IMessageFilter_RetryRejectedCall( x, p1, p2 ) \
        (x)->lpVtbl->RetryRejectedCall( x, p1, p2 )
    #define IMessageFilter_MessagePending( x, p1, p2, p3 ) \
        (x)->lpVtbl->MessagePending( x, p1, p2, p3 )
    #define IRpcChannelBuffer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcChannelBuffer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcChannelBuffer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcChannelBuffer_GetBuffer( x, p1, p2 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2 )
    #define IRpcChannelBuffer_SendReceive( x, p1, p2 ) \
        (x)->lpVtbl->SendReceive( x, p1, p2 )
    #define IRpcChannelBuffer_FreeBuffer( x, p ) \
        (x)->lpVtbl->FreeBuffer( x, p )
    #define IRpcChannelBuffer_GetDestCtx( x, p1, p2 ) \
        (x)->lpVtbl->GetDestCtx( x, p1, p2 )
    #define IRpcChannelBuffer_IsConnected( x ) \
        (x)->lpVtbl->IsConnected( x )
    #define IRpcChannelBuffer2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcChannelBuffer2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcChannelBuffer2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcChannelBuffer2_GetBuffer( x, p1, p2 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2 )
    #define IRpcChannelBuffer2_SendReceive( x, p1, p2 ) \
        (x)->lpVtbl->SendReceive( x, p1, p2 )
    #define IRpcChannelBuffer2_FreeBuffer( x, p ) \
        (x)->lpVtbl->FreeBuffer( x, p )
    #define IRpcChannelBuffer2_GetDestCtx( x, p1, p2 ) \
        (x)->lpVtbl->GetDestCtx( x, p1, p2 )
    #define IRpcChannelBuffer2_IsConnected( x ) \
        (x)->lpVtbl->IsConnected( x )
    #define IRpcChannelBuffer2_GetProtocolVersion( x, p ) \
        (x)->lpVtbl->GetProtocolVersion( x, p )
    #define IAsyncRpcChannelBuffer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAsyncRpcChannelBuffer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAsyncRpcChannelBuffer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAsyncRpcChannelBuffer_GetBuffer( x, p1, p2 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2 )
    #define IAsyncRpcChannelBuffer_SendReceive( x, p1, p2 ) \
        (x)->lpVtbl->SendReceive( x, p1, p2 )
    #define IAsyncRpcChannelBuffer_FreeBuffer( x, p ) \
        (x)->lpVtbl->FreeBuffer( x, p )
    #define IAsyncRpcChannelBuffer_GetDestCtx( x, p1, p2 ) \
        (x)->lpVtbl->GetDestCtx( x, p1, p2 )
    #define IAsyncRpcChannelBuffer_IsConnected( x ) \
        (x)->lpVtbl->IsConnected( x )
    #define IAsyncRpcChannelBuffer_GetProtocolVersion( x, p ) \
        (x)->lpVtbl->GetProtocolVersion( x, p )
    #define IAsyncRpcChannelBuffer_Send( x, p1, p2, p3 ) \
        (x)->lpVtbl->Send( x, p1, p2, p3 )
    #define IAsyncRpcChannelBuffer_Receive( x, p1, p2 ) \
        (x)->lpVtbl->Receive( x, p1, p2 )
    #define IAsyncRpcChannelBuffer_GetDestCtxEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDestCtxEx( x, p1, p2, p3 )
    #define IRpcChannelBuffer3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcChannelBuffer3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcChannelBuffer3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcChannelBuffer3_GetBuffer( x, p1, p2 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2 )
    #define IRpcChannelBuffer3_SendReceive( x, p1, p2 ) \
        (x)->lpVtbl->SendReceive( x, p1, p2 )
    #define IRpcChannelBuffer3_FreeBuffer( x, p ) \
        (x)->lpVtbl->FreeBuffer( x, p )
    #define IRpcChannelBuffer3_GetDestCtx( x, p1, p2 ) \
        (x)->lpVtbl->GetDestCtx( x, p1, p2 )
    #define IRpcChannelBuffer3_IsConnected( x ) \
        (x)->lpVtbl->IsConnected( x )
    #define IRpcChannelBuffer3_GetProtocolVersion( x, p ) \
        (x)->lpVtbl->GetProtocolVersion( x, p )
    #define IRpcChannelBuffer3_Send( x, p1, p2 ) \
        (x)->lpVtbl->Send( x, p1, p2 )
    #define IRpcChannelBuffer3_Receive( x, p1, p2, p3 ) \
        (x)->lpVtbl->Receive( x, p1, p2, p3 )
    #define IRpcChannelBuffer3_Cancel( x, p ) \
        (x)->lpVtbl->Cancel( x, p )
    #define IRpcChannelBuffer3_GetCallContext( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCallContext( x, p1, p2, p3 )
    #define IRpcChannelBuffer3_GetDestCtxEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDestCtxEx( x, p1, p2, p3 )
    #define IRpcChannelBuffer3_GetState( x, p1, p2 ) \
        (x)->lpVtbl->GetState( x, p1, p2 )
    #define IRpcChannelBuffer3_RegisterAsync( x, p1, p2 ) \
        (x)->lpVtbl->RegisterAsync( x, p1, p2 )
    #define IRpcSyntaxNegotiate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcSyntaxNegotiate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcSyntaxNegotiate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcSyntaxNegotiate_NegotiateSyntax( x, p ) \
        (x)->lpVtbl->NegotiateSyntax( x, p )
    #define IRpcProxyBuffer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcProxyBuffer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcProxyBuffer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcProxyBuffer_Connect( x, p ) \
        (x)->lpVtbl->Connect( x, p )
    #define IRpcProxyBuffer_Disconnect( x ) \
        (x)->lpVtbl->Disconnect( x )
    #define IRpcStubBuffer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcStubBuffer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcStubBuffer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcStubBuffer_Connect( x, p ) \
        (x)->lpVtbl->Connect( x, p )
    #define IRpcStubBuffer_Disconnect( x ) \
        (x)->lpVtbl->Disconnect( x )
    #define IRpcStubBuffer_Invoke( x, p1, p2 ) \
        (x)->lpVtbl->Invoke( x, p1, p2 )
    #define IRpcStubBuffer_IsIIDSupported( x, p ) \
        (x)->lpVtbl->IsIIDSupported( x, p )
    #define IRpcStubBuffer_CountRefs( x ) \
        (x)->lpVtbl->CountRefs( x )
    #define IRpcStubBuffer_DebugServerQueryInterface( x, p ) \
        (x)->lpVtbl->DebugServerQueryInterface( x, p )
    #define IRpcStubBuffer_DebugServerRelease( x, p ) \
        (x)->lpVtbl->DebugServerRelease( x, p )
    #define IPSFactoryBuffer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPSFactoryBuffer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPSFactoryBuffer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #if (_WIN32_WINNT >= 0x0400)
        #define IChannelHook_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IChannelHook_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IChannelHook_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IChannelHook_ClientGetSize( x, p1, p2, p3 ) \
            (x)->lpVtbl->ClientGetSize( x, p1, p2, p3 )
        #define IChannelHook_ClientFillBuffer( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->ClientFillBuffer( x, p1, p2, p3, p4 )
        #define IChannelHook_ClientNotify( x, p1, p2, p3, p4, p5, p6 ) \
            (x)->lpVtbl->ClientNotify( x, p1, p2, p3, p4, p5, p6 )
        #define IChannelHook_ServerNotify( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->ServerNotify( x, p1, p2, p3, p4, p5 )
        #define IChannelHook_ServerGetSize( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->ServerGetSize( x, p1, p2, p3, p4 )
        #define IChannelHook_ServerFillBuffer( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->ServerFillBuffer( x, p1, p2, p3, p4, p5 )
        #define IClientSecurity_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IClientSecurity_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IClientSecurity_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IClientSecurity_QueryBlanket( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
            (x)->lpVtbl->QueryBlanket( x, p1, p2, p3, p4, p5, p6, p7, p8 )
        #define IClientSecurity_SetBlanket( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
            (x)->lpVtbl->SetBlanket( x, p1, p2, p3, p4, p5, p6, p7, p8 )
        #define IClientSecurity_CopyProxy( x, p1, p2 ) \
            (x)->lpVtbl->CopyProxy( x, p1, p2 )
        #define IServerSecurity_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IServerSecurity_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IServerSecurity_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IServerSecurity_QueryBlanket( x, p1, p2, p3, p4, p5, p6, p7 ) \
            (x)->lpVtbl->QueryBlanket( x, p1, p2, p3, p4, p5, p6, p7 )
        #define IServerSecurity_ImpersonateClient( x ) \
            (x)->lpVtbl->ImpersonateClient( x )
        #define IServerSecurity_RevertToSelf( x ) \
            (x)->lpVtbl->RevertToSelf( x )
        #define IServerSecurity_IsImpersonating( x ) \
            (x)->lpVtbl->IsImpersonating( x )
        #define IClassActivator_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IClassActivator_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IClassActivator_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IClassActivator_GetClassObject( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->GetClassObject( x, p1, p2, p3, p4, p5 )
        #define IRpcOptions_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IRpcOptions_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IRpcOptions_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IRpcOptions_Set( x, p1, p2, p3 ) \
            (x)->lpVtbl->Set( x, p1, p2, p3 )
        #define IRpcOptions_Query( x, p1, p2, p3 ) \
            (x)->lpVtbl->Query( x, p1, p2, p3 )
        #define IGlobalOptions_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IGlobalOptions_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IGlobalOptions_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IGlobalOptions_Set( x, p1, p2 ) \
            (x)->lpVtbl->Set( x, p1, p2 )
        #define IGlobalOptions_Query( x, p1, p2 ) \
            (x)->lpVtbl->Query( x, p1, p2 )
    #endif
    #define IFillLockBytes_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFillLockBytes_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFillLockBytes_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFillLockBytes_FillAppend( x, p1, p2, p3 ) \
        (x)->lpVtbl->FillAppend( x, p1, p2, p3 )
    #define IFillLockBytes_FillAt( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FillAt( x, p1, p2, p3, p4 )
    #define IFillLockBytes_SetFillSize( x, p ) \
        (x)->lpVtbl->SetFillSize( x, p )
    #define IFillLockBytes_Terminate( x, p ) \
        (x)->lpVtbl->Terminate( x, p )
    #define IProgressNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProgressNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProgressNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProgressNotify_OnProgress( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnProgress( x, p1, p2, p3, p4 )
    #define ILayoutStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ILayoutStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ILayoutStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ILayoutStorage_LayoutScript( x, p1, p2, p3 ) \
        (x)->lpVtbl->LayoutScript( x, p1, p2, p3 )
    #define ILayoutStorage_BeginMonitor( x ) \
        (x)->lpVtbl->BeginMonitor( x )
    #define ILayoutStorage_EndMonitor( x ) \
        (x)->lpVtbl->EndMonitor( x )
    #define ILayoutStorage_ReLayoutDocfile( x, p ) \
        (x)->lpVtbl->ReLayoutDocfile( x, p )
    #define ILayoutStorage_ReLayoutDocfileOnILockBytes( x, p ) \
        (x)->lpVtbl->ReLayoutDocfileOnILockBytes( x, p )
    #define IBlockingLock_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBlockingLock_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBlockingLock_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBlockingLock_Lock( x, p ) \
        (x)->lpVtbl->Lock( x, p )
    #define IBlockingLock_Unlock( x ) \
        (x)->lpVtbl->Unlock( x )
    #define ITimeAndNoticeControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ITimeAndNoticeControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ITimeAndNoticeControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ITimeAndNoticeControl_SuppressChanges( x, p1, p2 ) \
        (x)->lpVtbl->SuppressChanges( x, p1, p2 )
    #define IOplockStorage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOplockStorage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOplockStorage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOplockStorage_CreateStorageEx( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->CreateStorageEx( x, p1, p2, p3, p4, p5, p6 )
    #define IOplockStorage_OpenStorageEx( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->OpenStorageEx( x, p1, p2, p3, p4, p5, p6 )
    #define ISurrogate_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISurrogate_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISurrogate_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISurrogate_LoadDllServer( x, p ) \
        (x)->lpVtbl->LoadDllServer( x, p )
    #define ISurrogate_FreeSurrogate( x ) \
        (x)->lpVtbl->FreeSurrogate( x )
    #define IGlobalInterfaceTable_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGlobalInterfaceTable_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGlobalInterfaceTable_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGlobalInterfaceTable_RegisterInterfaceInGlobal( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterInterfaceInGlobal( x, p1, p2, p3 )
    #define IGlobalInterfaceTable_RevokeInterfaceFromGlobal( x, p ) \
        (x)->lpVtbl->RevokeInterfaceFromGlobal( x, p )
    #define IGlobalInterfaceTable_GetInterfaceFromGlobal( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetInterfaceFromGlobal( x, p1, p2, p3 )
    #define IDirectWriterLock_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectWriterLock_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectWriterLock_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectWriterLock_WaitForWriteAccess( x, p ) \
        (x)->lpVtbl->WaitForWriteAccess( x, p )
    #define IDirectWriterLock_ReleaseWriteAccess( x ) \
        (x)->lpVtbl->ReleaseWriteAccess( x )
    #define IDirectWriterLock_HaveWriteAccess( x ) \
        (x)->lpVtbl->HaveWriteAccess( x )
    #define ISynchronize_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISynchronize_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISynchronize_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISynchronize_Wait( x, p1, p2 ) \
        (x)->lpVtbl->Wait( x, p1, p2 )
    #define ISynchronize_Signal( x ) \
        (x)->lpVtbl->Signal( x )
    #define ISynchronize_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define ISynchronizeHandle_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISynchronizeHandle_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISynchronizeHandle_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISynchronizeHandle_GetHandle( x, p ) \
        (x)->lpVtbl->GetHandle( x, p )
    #define ISynchronizeEvent_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISynchronizeEvent_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISynchronizeEvent_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISynchronizeEvent_GetHandle( x, p ) \
        (x)->lpVtbl->GetHandle( x, p )
    #define ISynchronizeEvent_SetEventHandle( x, p ) \
        (x)->lpVtbl->SetEventHandle( x, p )
    #define ISynchronizeContainer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISynchronizeContainer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISynchronizeContainer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISynchronizeContainer_AddSynchronize( x, p ) \
        (x)->lpVtbl->AddSynchronize( x, p )
    #define ISynchronizeContainer_WaitMultiple( x, p1, p2, p3 ) \
        (x)->lpVtbl->WaitMultiple( x, p1, p2, p3 )
    #define ISynchronizeMutex_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISynchronizeMutex_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISynchronizeMutex_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISynchronizeMutex_ReleaseMutex( x ) \
        (x)->lpVtbl->ReleaseMutex( x )
    #define ICancelMethodCalls_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICancelMethodCalls_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICancelMethodCalls_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICancelMethodCalls_Cancel( x, p ) \
        (x)->lpVtbl->Cancel( x, p )
    #define ICancelMethodCalls_TestCancel( x ) \
        (x)->lpVtbl->TestCancel( x )
    #define IAsyncManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAsyncManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAsyncManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAsyncManager_CompleteCall( x, p ) \
        (x)->lpVtbl->CompleteCall( x, p )
    #define IAsyncManager_GetCallContext( x, p1, p2 ) \
        (x)->lpVtbl->GetCallContext( x, p1, p2 )
    #define IAsyncManager_GetState( x, p ) \
        (x)->lpVtbl->GetState( x, p )
    #define ICallFactory_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICallFactory_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICallFactory_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICallFactory_CreateCall( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateCall( x, p1, p2, p3, p4 )
    #define IRpcHelper_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRpcHelper_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRpcHelper_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRpcHelper_GetDCOMProtocolVersion( x, p ) \
        (x)->lpVtbl->GetDCOMProtocolVersion( x, p )
    #define IRpcHelper_GetIIDFromOBJREF( x, p1, p2 ) \
        (x)->lpVtbl->GetIIDFromOBJREF( x, p1, p2 )
    #define IReleaseMarshalBuffers_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IReleaseMarshalBuffers_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IReleaseMarshalBuffers_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IReleaseMarshalBuffers_ReleaseMarshalBuffers( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReleaseMarshalBuffers( x, p1, p2, p3 )
    #define IWaitMultiple_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IWaitMultiple_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IWaitMultiple_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IWaitMultiple_WaitMultiple( x, p1, p2 ) \
        (x)->lpVtbl->WaitMultiple( x, p1, p2 )
    #define IWaitMultiple_AddSynchronize( x, p ) \
        (x)->lpVtbl->AddSynchronize( x, p )
    #define IUrlMon_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IUrlMon_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IUrlMon_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IUrlMon_AsyncGetClassBits( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 ) \
        (x)->lpVtbl->AsyncGetClassBits( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10 )
    #define IForegroundTransfer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IForegroundTransfer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IForegroundTransfer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IForegroundTransfer_AllowForegroundTransfer( x, p ) \
        (x)->lpVtbl->AllowForegroundTransfer( x, p )
    #define IAddrTrackingControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAddrTrackingControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAddrTrackingControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAddrTrackingControl_EnableCOMDynamicAddrTracking( x ) \
        (x)->lpVtbl->EnableCOMDynamicAddrTracking( x )
    #define IAddrTrackingControl_DisableCOMDynamicAddrTracking( x ) \
        (x)->lpVtbl->DisableCOMDynamicAddrTracking( x )
    #define IAddrExclusionControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAddrExclusionControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAddrExclusionControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAddrExclusionControl_GetCurrentAddrExclusionList( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentAddrExclusionList( x, p1, p2 )
    #define IAddrExclusionControl_UpdateAddrExclusionList( x, p ) \
        (x)->lpVtbl->UpdateAddrExclusionList( x, p )
    #define IPipeByte_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPipeByte_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPipeByte_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPipeByte_Pull( x, p1, p2, p3 ) \
        (x)->lpVtbl->Pull( x, p1, p2, p3 )
    #define IPipeByte_Push( x, p1, p2 ) \
        (x)->lpVtbl->Push( x, p1, p2 )
    #define IPipeLong_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPipeLong_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPipeLong_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPipeLong_Pull( x, p1, p2, p3 ) \
        (x)->lpVtbl->Pull( x, p1, p2, p3 )
    #define IPipeLong_Push( x, p1, p2 ) \
        (x)->lpVtbl->Push( x, p1, p2 )
    #define IPipeDouble_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPipeDouble_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPipeDouble_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPipeDouble_Pull( x, p1, p2, p3 ) \
        (x)->lpVtbl->Pull( x, p1, p2, p3 )
    #define IPipeDouble_Push( x, p1, p2 ) \
        (x)->lpVtbl->Push( x, p1, p2 )
    #define IThumbnailExtractor_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IThumbnailExtractor_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IThumbnailExtractor_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IThumbnailExtractor_ExtractThumbnail( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ExtractThumbnail( x, p1, p2, p3, p4, p5, p6 )
    #define IThumbnailExtractor_OnFileUpdated( x, p ) \
        (x)->lpVtbl->OnFileUpdated( x, p )
    #define IDummyHICONIncluder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDummyHICONIncluder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDummyHICONIncluder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDummyHICONIncluder_Dummy( x, p1, p2 ) \
        (x)->lpVtbl->Dummy( x, p1, p2 )
    #define IProcessLock_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProcessLock_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProcessLock_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProcessLock_AddRefOnProcess( x ) \
        (x)->lpVtbl->AddRefOnProcess( x )
    #define IProcessLock_ReleaseOnProcess( x ) \
        (x)->lpVtbl->ReleaseOnProcess( x )
    #define IComThreadingInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IComThreadingInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IComThreadingInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IComThreadingInfo_GetCurrentApartmentType( x, p ) \
        (x)->lpVtbl->GetCurrentApartmentType( x, p )
    #define IComThreadingInfo_GetCurrentThreadType( x, p ) \
        (x)->lpVtbl->GetCurrentThreadType( x, p )
    #define IComThreadingInfo_GetCurrentLogicalThreadId( x, p ) \
        (x)->lpVtbl->GetCurrentLogicalThreadId( x, p )
    #define IComThreadingInfo_SetCurrentLogicalThreadId( x, p ) \
        (x)->lpVtbl->SetCurrentLogicalThreadId( x, p )
    #define IProcessInitControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IProcessInitControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IProcessInitControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IProcessInitControl_ResetInitializerTimeout( x, p ) \
        (x)->lpVtbl->ResetInitializerTimeout( x, p )
    #if (_WIN32_WINNT >= 0x0501)
        #define IInitializeSpy_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IInitializeSpy_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IInitializeSpy_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IInitializeSpy_PreInitialize( x, p1, p2 ) \
            (x)->lpVtbl->PreInitialize( x, p1, p2 )
        #define IInitializeSpy_PostInitialize( x, p1, p2, p3 ) \
            (x)->lpVtbl->PostInitialize( x, p1, p2, p3 )
        #define IInitializeSpy_PreUninitialize( x, p ) \
            (x)->lpVtbl->PreUninitialize( x, p )
        #define IInitializeSpy_PostUninitialize( x, p ) \
            (x)->lpVtbl->PostUninitialize( x, p )
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID      __cdecl IID_IMarshal;
EXTERN_C const IID      __cdecl IID_IMarshal2;
EXTERN_C const IID      __cdecl IID_IMalloc;
EXTERN_C const IID      __cdecl IID_IMallocSpy;
EXTERN_C const IID      __cdecl IID_IStdMarshalInfo;
EXTERN_C const IID      __cdecl IID_IExternalConnection;
EXTERN_C const IID      __cdecl IID_IMultiQI;
EXTERN_C const IID      __cdecl IID_IInternalUnknown;
EXTERN_C const IID      __cdecl IID_IEnumUnknown;
EXTERN_C const IID      __cdecl IID_IBindCtx;
EXTERN_C const IID      __cdecl IID_IEnumMoniker;
EXTERN_C const IID      __cdecl IID_IRunnableObject;
EXTERN_C const IID      __cdecl IID_IRunningObjectTable;
EXTERN_C const IID      __cdecl IID_IPersist;
EXTERN_C const IID      __cdecl IID_IPersistStream;
EXTERN_C const IID      __cdecl IID_IMoniker;
EXTERN_C const IID      __cdecl IID_IROTData;
EXTERN_C const IID      __cdecl IID_IEnumString;
EXTERN_C const IID      __cdecl IID_ISequentialStream;
EXTERN_C const IID      __cdecl IID_IStream;
EXTERN_C const IID      __cdecl IID_IEnumSTATSTG;
EXTERN_C const IID      __cdecl IID_IStorage;
EXTERN_C const IID      __cdecl IID_IPersistFile;
EXTERN_C const IID      __cdecl IID_IPersistStorage;
EXTERN_C const IID      __cdecl IID_ILockBytes;
EXTERN_C const IID      __cdecl IID_IEnumFORMATETC;
EXTERN_C const IID      __cdecl IID_IEnumSTATDATA;
EXTERN_C const IID      __cdecl IID_IRootStorage;
EXTERN_C const IID      __cdecl IID_IAdviseSink;
EXTERN_C const IID      __cdecl IID_IAdviseSink2;
EXTERN_C const IID      __cdecl IID_IDataObject;
EXTERN_C const IID      __cdecl IID_IDataAdviseHolder;
EXTERN_C const IID      __cdecl IID_IMessageFilter;
EXTERN_C const IID      __cdecl IID_IRpcChannelBuffer;
EXTERN_C const IID      __cdecl IID_IRpcChannelBuffer2;
EXTERN_C const IID      __cdecl IID_IAsyncRpcChannelBuffer;
EXTERN_C const IID      __cdecl IID_IRpcChannelBuffer3;
EXTERN_C const IID      __cdecl IID_IRpcSyntaxNegotiate;
EXTERN_C const IID      __cdecl IID_IRpcProxyBuffer;
EXTERN_C const IID      __cdecl IID_IRpcStubBuffer;
EXTERN_C const IID      __cdecl IID_IPSFactoryBuffer;
#if (_WIN32_WINNT >= 0x0400)
EXTERN_C const IID      __cdecl IID_IChannelHook;
EXTERN_C const IID      __cdecl IID_IClientSecurity;
EXTERN_C const IID      __cdecl IID_IServerSecurity;
EXTERN_C const IID      __cdecl IID_IClassActivator;
EXTERN_C const IID      __cdecl IID_IRpcOptions;
EXTERN_C const IID      __cdecl IID_IGlobalOptions;
#endif
EXTERN_C const IID      __cdecl IID_IFillLockBytes;
EXTERN_C const IID      __cdecl IID_IProgressNotify;
EXTERN_C const IID      __cdecl IID_ILayoutStorage;
EXTERN_C const IID      __cdecl IID_IBlockingLock;
EXTERN_C const IID      __cdecl IID_ITimeAndNoticeControl;
EXTERN_C const IID      __cdecl IID_IOplockStorage;
EXTERN_C const IID      __cdecl IID_ISurrogate;
EXTERN_C const IID      __cdecl IID_IGlobalInterfaceTable;
EXTERN_C const IID      __cdecl IID_IDirectWriterLock;
EXTERN_C const IID      __cdecl IID_ISynchronize;
EXTERN_C const IID      __cdecl IID_ISynchronizeHandle;
EXTERN_C const IID      __cdecl IID_ISynchronizeEvent;
EXTERN_C const IID      __cdecl IID_ISynchronizeContainer;
EXTERN_C const IID      __cdecl IID_ISynchronizeMutex;
EXTERN_C const IID      __cdecl IID_ICancelMethodCalls;
EXTERN_C const IID      __cdecl IID_IAsyncManager;
EXTERN_C const IID      __cdecl IID_ICallFactory;
EXTERN_C const IID      __cdecl IID_IRpcHelper;
EXTERN_C const IID      __cdecl IID_IReleaseMarshalBuffers;
EXTERN_C const IID      __cdecl IID_IWaitMultiple;
EXTERN_C const IID      __cdecl IID_IUrlMon;
EXTERN_C const IID      __cdecl IID_IForegroundTransfer;
EXTERN_C const IID      __cdecl IID_IAddrTrackingControl;
EXTERN_C const IID      __cdecl IID_IAddrExclusionControl;
EXTERN_C const IID      __cdecl IID_IPipeByte;
EXTERN_C const IID      __cdecl IID_IPipeLong;
EXTERN_C const IID      __cdecl IID_IPipeDouble;
EXTERN_C const IID      __cdecl IID_IThumbnailExtractor;
EXTERN_C const IID      __cdecl IID_IDummyHICONIncluder;
EXTERN_C const IID      __cdecl IID_IProcessLock;
EXTERN_C const IID      __cdecl IID_ISurrogateService;
EXTERN_C const IID      __cdecl IID_IComThreadingInfo;
EXTERN_C const IID      __cdecl IID_IProcessInitControl;
#if (_WIN32_WINNT >= 0x0501)
EXTERN_C const IID      __cdecl IID_IInitializeSpy;
#endif
EXTERN_C const FMTID    __cdecl FMTID_SummaryInformation;
EXTERN_C const FMTID    __cdecl FMTID_DocSummaryInformation;
EXTERN_C const FMTID    __cdecl FMTID_UserDefinedProperties;
EXTERN_C const FMTID    __cdecl FMTID_DiscardableInformation;
EXTERN_C const FMTID    __cdecl FMTID_ImageSummaryInformation;
EXTERN_C const FMTID    __cdecl FMTID_AudioSummaryInformation;
EXTERN_C const FMTID    __cdecl FMTID_VideoSummaryInformation;
EXTERN_C const FMTID    __cdecl FMTID_MediaFileSummaryInformation;

#endif /* __objidl_h__ */
