/*
 *  ntddndis.h  Network Driver Interface Specification (NDIS) device I/O control codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDDNDIS_
#define _NTDDNDIS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #include <ifdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef ULONG                       NDIS_OID;
typedef ULONG                       *PNDIS_OID;
typedef ULONG                       NDIS_802_11_TX_POWER_LEVEL;
typedef LONG                        NDIS_802_11_RSSI;
typedef ULONG                       NDIS_802_11_KEY_INDEX;
typedef ULONGLONG                   NDIS_802_11_KEY_RSC;
typedef ULONG                       NDIS_802_11_FRAGMENTATION_THRESHOLD;
typedef ULONG                       NDIS_802_11_RTS_THRESHOLD;
typedef ULONG                       NDIS_802_11_ANTENNA;
#ifndef IP_EXPORT_INCLUDED
typedef ULONG                       IPAddr;
typedef ULONG                       IPMask;
#endif
typedef ULONG                       SPI_TYPE;
typedef ULONG                       NDIS_VLAN_ID;
typedef ULONG                       Priority_802_3;
#ifndef _NDIS_
typedef int                         NDIS_STATUS;
typedef int                         *PNDIS_STATUS;
#endif
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef IF_COUNTED_STRING           NDIS_IF_COUNTED_STRING;
typedef IF_COUNTED_STRING           *PNDIS_IF_COUNTED_STRING;
typedef IF_PHYSICAL_ADDRESS         NDIS_IF_PHYSICAL_ADDRESS;
typedef IF_PHYSICAL_ADDRESS         *PNDIS_IF_PHYSICAL_ADDRESS;
typedef NET_IF_MEDIA_CONNECT_STATE  NDIS_MEDIA_CONNECT_STATE;
typedef NET_IF_MEDIA_CONNECT_STATE  *PNDIS_MEDIA_CONNECT_STATE;
typedef NET_IF_MEDIA_DUPLEX_STATE   NDIS_MEDIA_DUPLEX_STATE;
typedef NET_IF_MEDIA_DUPLEX_STATE   *PNDIS_MEDIA_DUPLEX_STATE;
typedef ULONG                       NDIS_PORT_NUMBER;
typedef ULONG                       *PNDIS_PORT_NUMBER;
#if NDIS_SUPPORT_NDIS620
typedef ULONG                       NDIS_RECEIVE_QUEUE_ID;
typedef ULONG                       *PNDIS_RECEIVE_QUEUE_ID;
typedef ULONG                       NDIS_RECEIVE_QUEUE_GROUP_ID;
typedef ULONG                       *PNDIS_RECEIVE_QUEUE_GROUP_ID;
typedef ULONG                       NDIS_RECEIVE_FILTER_ID;
typedef ULONG                       *PNDIS_RECEIVE_FILTER_ID;
typedef NDIS_IF_COUNTED_STRING      NDIS_QUEUE_NAME;
typedef NDIS_IF_COUNTED_STRING      *PNDIS_QUEUE_NAME;
typedef NDIS_IF_COUNTED_STRING      NDIS_VM_NAME;
typedef NDIS_IF_COUNTED_STRING      *PNDIS_VM_NAME;
#endif
#endif

/* NDIS device name */
#define DD_NDIS_DEVICE_NAME "\\Device\\UNKNOWN"

/* Macro to make NDIS device I/O control codes */
#define _NDIS_CONTROL_CODE( p1, p2 ) \
    CTL_CODE( FILE_DEVICE_PHYSICAL_NETCARD, p1, p2, FILE_ANY_ACCESS )

/* NDIS device I/O control codes */
#define IOCTL_NDIS_QUERY_GLOBAL_STATS   _NDIS_CONTROL_CODE( 0, METHOD_OUT_DIRECT )
#define IOCTL_NDIS_QUERY_ALL_STATS      _NDIS_CONTROL_CODE( 1, METHOD_OUT_DIRECT )
#define IOCTL_NDIS_DO_PNP_OPERATION     _NDIS_CONTROL_CODE( 2, METHOD_BUFFERED )
#define IOCTL_NDIS_QUERY_SELECTED_STATS _NDIS_CONTROL_CODE( 3, METHOD_OUT_DIRECT )
#define IOCTL_NDIS_ENUMERATE_INTERFACES _NDIS_CONTROL_CODE( 4, METHOD_BUFFERED )
#define IOCTL_NDIS_ADD_TDI_DEVICE       _NDIS_CONTROL_CODE( 5, METHOD_BUFFERED )
#define IOCTL_NDIS_GET_LOG_DATA         _NDIS_CONTROL_CODE( 6, METHOD_OUT_DIRECT )
#define IOCTL_NDIS_GET_VERSION          _NDIS_CONTROL_CODE( 7, METHOD_BUFFERED )

/* NDIS object types */
#define NDIS_OBJECT_TYPE_DEFAULT                                            0x80
#define NDIS_OBJECT_TYPE_MINIPORT_INIT_PARAMETERS                           0x81
#define NDIS_OBJECT_TYPE_SG_DMA_DESCRIPTION                                 0x83
#define NDIS_OBJECT_TYPE_MINIPORT_INTERRUPT                                 0x84
#define NDIS_OBJECT_TYPE_DEVICE_OBJECT_ATTRIBUTES                           0x85
#define NDIS_OBJECT_TYPE_BIND_PARAMETERS                                    0x86
#define NDIS_OBJECT_TYPE_OPEN_PARAMETERS                                    0x87
#define NDIS_OBJECT_TYPE_RSS_CAPABILITIES                                   0x88
#define NDIS_OBJECT_TYPE_RSS_PARAMETERS                                     0x89
#define NDIS_OBJECT_TYPE_MINIPORT_DRIVER_CHARACTERISTICS                    0x8A
#define NDIS_OBJECT_TYPE_FILTER_DRIVER_CHARACTERISTICS                      0x8B
#define NDIS_OBJECT_TYPE_FILTER_PARTIAL_CHARACTERISTICS                     0x8C
#define NDIS_OBJECT_TYPE_FILTER_ATTRIBUTES                                  0x8D
#define NDIS_OBJECT_TYPE_CLIENT_CHIMNEY_OFFLOAD_GENERIC_CHARACTERISTICS     0x8E
#define NDIS_OBJECT_TYPE_PROVIDER_CHIMNEY_OFFLOAD_GENERIC_CHARACTERISTICS   0x8F
#define NDIS_OBJECT_TYPE_CO_PROTOCOL_CHARACTERISTICS                        0x90
#define NDIS_OBJECT_TYPE_CO_MINIPORT_CHARACTERISTICS                        0x91
#define NDIS_OBJECT_TYPE_MINIPORT_PNP_CHARACTERISTICS                       0x92
#define NDIS_OBJECT_TYPE_CLIENT_CHIMNEY_OFFLOAD_CHARACTERISTICS             0x93
#define NDIS_OBJECT_TYPE_PROVIDER_CHIMENY_OFFLOAD_CHARACTERISTICS           0x94
#define NDIS_OBJECT_TYPE_PROTOCOL_DRIVER_CHARACTERISTICS                    0x95
#define NDIS_OBJECT_TYPE_REQUEST_EX                                         0x96
#define NDIS_OBJECT_TYPE_OID_REQUEST                                        0x96
#define NDIS_OBJECT_TYPE_TIMER_CHARACTERISTICS                              0x97
#define NDIS_OBJECT_TYPE_STATUS_INDICATION                                  0x98
#define NDIS_OBJECT_TYPE_FILTER_ATTACH_PARAMETERS                           0x99
#define NDIS_OBJECT_TYPE_FILTER_PAUSE_PARAMETERS                            0x9A
#define NDIS_OBJECT_TYPE_FILTER_RESTART_PARAMETERS                          0x9B
#define NDIS_OBJECT_TYPE_PORT_CHARACTERISTICS                               0x9C
#define NDIS_OBJECT_TYPE_PORT_STATE                                         0x9D
#define NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES           0x9E
#define NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES                0x9F
#define NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES                0xA0
#define NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES          0xA1
#define NDIS_OBJECT_TYPE_RESTART_GENERAL_ATTRIBUTES                         0xA2
#define NDIS_OBJECT_TYPE_PROTOCOL_RESTART_PARAMETERS                        0xA3
#define NDIS_OBJECT_TYPE_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES        0xA4
#define NDIS_OBJECT_TYPE_CO_CALL_MANAGER_OPTIONAL_HANDLERS                  0xA5
#define NDIS_OBJECT_TYPE_CO_CLIENT_OPTIONAL_HANDLERS                        0xA6
#define NDIS_OBJECT_TYPE_OFFLOAD                                            0xA7
#define NDIS_OBJECT_TYPE_OFFLOAD_ENCAPSULATION                              0xA8
#define NDIS_OBJECT_TYPE_CONFIGURATION_OBJECT                               0xA9
#define NDIS_OBJECT_TYPE_DRIVER_WRAPPER_OBJECT                              0xAA
#if NDIS_SUPPORT_NDIS61
    #define NDIS_OBJECT_TYPE_HD_SPLIT_ATTRIBUTES                            0xAB
#endif
#define NDIS_OBJECT_TYPE_NSI_NETWORK_RW_STRUCT                              0xAC
#define NDIS_OBJECT_TYPE_NSI_COMPARTMENT_RW_STRUCT                          0xAD
#define NDIS_OBJECT_TYPE_NSI_INTERFACE_PERSIST_RW_STRUCT                    0xAE
#if NDIS_SUPPORT_NDIS61
    #define NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_HARDWARE_ASSIST_ATTRIBUTES    0xAF
#endif
#if NDIS_SUPPORT_NDIS620
    #define NDIS_OBJECT_TYPE_SHARED_MEMORY_PROVIDER_CHARACTERISTICS         0xB0
    #define NDIS_OBJECT_TYPE_RSS_PROCESSOR_INFO                             0xB1
#endif

/* NDIS object header revision number */
#define NDIS_OBJECT_REVISION_1  1

/* NDIS statistics flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_STATISTICS_FLAGS_VALID_DIRECTED_FRAMES_RCV     0x00000001L
    #define NDIS_STATISTICS_FLAGS_VALID_MULTICAST_FRAMES_RCV    0x00000002L
    #define NDIS_STATISTICS_FLAGS_VALID_BROADCAST_FRAMES_RCV    0x00000004L
    #define NDIS_STATISTICS_FLAGS_VALID_BYTES_RCV               0x00000008L
    #define NDIS_STATISTICS_FLAGS_VALID_RCV_DISCARDS            0x00000010L
    #define NDIS_STATISTICS_FLAGS_VALID_RCV_ERROR               0x00000020L
    #define NDIS_STATISTICS_FLAGS_VALID_DIRECTED_FRAMES_XMIT    0x00000040L
    #define NDIS_STATISTICS_FLAGS_VALID_MULTICAST_FRAMES_XMIT   0x00000080L
    #define NDIS_STATISTICS_FLAGS_VALID_BROADCAST_FRAMES_XMIT   0x00000100L
    #define NDIS_STATISTICS_FLAGS_VALID_BYTES_XMIT              0x00000200L
    #define NDIS_STATISTICS_FLAGS_VALID_XMIT_ERROR              0x00000400L
    #define NDIS_STATISTICS_FLAGS_VALID_XMIT_DISCARDS           0x00008000L
    #define NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_RCV      0x00010000L
    #define NDIS_STATISTICS_FLAGS_VALID_MULTICAST_BYTES_RCV     0x00020000L
    #define NDIS_STATISTICS_FLAGS_VALID_BROADCAST_BYTES_RCV     0x00040000L
    #define NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_XMIT     0x00080000L
    #define NDIS_STATISTICS_FLAGS_VALID_MULTICAST_BYTES_XMIT    0x00100000L
    #define NDIS_STATISTICS_FLAGS_VALID_BROADCAST_BYTES_XMIT    0x00200000L
#endif

/* NDIS statistics information revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_STATISTICS_INFO_REVISION_1 1
#endif

/* NDIS interrupt moderation flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_INTERRUPT_MODERATION_CHANGE_NEEDS_RESET        0x00000001L
    #define NDIS_INTERRUPT_MODERATION_CHANGE_NEEDS_REINITIALIZE 0x00000002L
#endif

/* NDIS interrupt moderation parameters revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_INTERRUPT_MODERATION_PARAMETERS_REVISION_1 1
#endif

/* NDIS timeout deferred procedure call request capabilities revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES_REVISION_1    1
#endif

/* NDIS PCI device custom properties revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OBJECT_TYPE_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_1    1
#endif
#if (NTDDI_VERSION >= 0x06010000) || NDIS_SUPPORT_NDIS620
    #define NDIS_OBJECT_TYPE_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_2    2
#endif

/* Object identifiers */
#define OID_GEN_SUPPORTED_LIST                          0x00010101L
#define OID_GEN_HARDWARE_STATUS                         0x00010102L
#define OID_GEN_MEDIA_SUPPORTED                         0x00010103L
#define OID_GEN_MEDIA_IN_USE                            0x00010104L
#define OID_GEN_MAXIMUM_LOOKAHEAD                       0x00010105L
#define OID_GEN_MAXIMUM_FRAME_SIZE                      0x00010106L
#define OID_GEN_LINK_SPEED                              0x00010107L
#define OID_GEN_TRANSMIT_BUFFER_SPACE                   0x00010108L
#define OID_GEN_RECEIVE_BUFFER_SPACE                    0x00010109L
#define OID_GEN_TRANSMIT_BLOCK_SIZE                     0x0001010AL
#define OID_GEN_RECEIVE_BLOCK_SIZE                      0x0001010BL
#define OID_GEN_VENDOR_ID                               0x0001010CL
#define OID_GEN_VENDOR_DESCRIPTION                      0x0001010DL
#define OID_GEN_CURRENT_PACKET_FILTER                   0x0001010EL
#define OID_GEN_CURRENT_LOOKAHEAD                       0x0001010FL
#define OID_GEN_DRIVER_VERSION                          0x00010110L
#define OID_GEN_MAXIMUM_TOTAL_SIZE                      0x00010111L
#define OID_GEN_PROTOCOL_OPTIONS                        0x00010112L
#define OID_GEN_MAC_OPTIONS                             0x00010113L
#define OID_GEN_MEDIA_CONNECT_STATUS                    0x00010114L
#define OID_GEN_MAXIMUM_SEND_PACKETS                    0x00010115L
#define OID_GEN_VENDOR_DRIVER_VERSION                   0x00010116L
#define OID_GEN_SUPPORTED_GUIDS                         0x00010117L
#define OID_GEN_NETWORK_LAYER_ADDRESSES                 0x00010118L
#define OID_GEN_TRANSPORT_HEADER_OFFSET                 0x00010119L
#define OID_GEN_MEDIA_CAPABILITIES                      0x00010201L
#define OID_GEN_PHYSICAL_MEDIUM                         0x00010202L
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define OID_GEN_RECEIVE_SCALE_CAPABILITIES          0x00010203L
    #define OID_GEN_RECEIVE_SCALE_PARAMETERS            0x00010204L
    #define OID_GEN_MAC_ADDRESS                         0x00010205L
    #define OID_GEN_MAX_LINK_SPEED                      0x00010206L
    #define OID_GEN_LINK_STATE                          0x00010207L
    #define OID_GEN_LINK_PARAMETERS                     0x00010208L
    #define OID_GEN_INTERRUPT_MODERATION                0x00010209L
    #define OID_GEN_ENUMERATE_PORTS                     0x0001020DL
    #define OID_GEN_PORT_STATE                          0x0001020EL
    #define OID_GEN_PORT_AUTHENTICATION_PARAMETERS      0x0001020FL
    #define OID_GEN_TIMEOUT_DPC_REQUEST_CAPABILITIES    0x00010210L
    #define OID_GEN_PCI_DEVICE_CUSTOM_PROPERTIES        0x00010211L
    #define OID_GEN_PHYSICAL_MEDIUM_EX                  0x00010213L
#endif
#define OID_GEN_MACHINE_NAME                            0x0001021AL
#define OID_GEN_RNDIS_CONFIG_PARAMETER                  0x0001021BL
#define OID_GEN_VLAN_ID                                 0x0001021CL
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define OID_GEN_MINIPORT_RESTART_ATTRIBUTES         0x0001021DL
    #if NDIS_SUPPORT_NDIS61
        #define OID_GEN_HD_SPLIT_PARAMETERS             0x0001021EL
    #endif
    #define OID_GEN_RECEIVE_HASH                        0x0001021FL
    #if NDIS_SUPPORT_NDIS61
        #define OID_GEN_HD_SPLIT_CURRENT_CONFIG         0x00010220L
    #endif
    #define OID_GEN_PROMISCUOUS_MODE                    0x00010280L
    #define OID_GEN_LAST_CHANGE                         0x00010281L
    #define OID_GEN_DISCONTINUITY_TIME                  0x00010282L
    #define OID_GEN_OPERATIONAL_STATUS                  0x00010283L
    #define OID_GEN_XMIT_LINK_SPEED                     0x00010284L
    #define OID_GEN_RCV_LINK_SPEED                      0x00010285L
    #define OID_GEN_UNKNOWN_PROTOS                      0x00010286L
    #define OID_GEN_INTERFACE_INFO                      0x00010287L
    #define OID_GEN_ADMIN_STATUS                        0x00010288L
    #define OID_GEN_ALIAS                               0x00010289L
    #define OID_GEN_MEDIA_CONNECT_STATUS_EX             0x0001028AL
    #define OID_GEN_LINK_SPEED_EX                       0x0001028BL
    #define OID_GEN_MEDIA_DUPLEX_STATE                  0x0001028CL
    #define OID_GEN_IP_OPER_STATUS                      0x0001028DL
    #define OID_WWAN_DRIVER_CAPS                        0x0E010100L
    #define OID_WWAN_DEVICE_CAPS                        0x0E010101L
    #define OID_WWAN_READY_INFO                         0x0E010102L
    #define OID_WWAN_RADIO_STATE                        0x0E010103L
    #define OID_WWAN_PIN                                0x0E010104L
    #define OID_WWAN_PIN_LIST                           0x0E010105L
    #define OID_WWAN_HOME_PROVIDER                      0x0E010106L
    #define OID_WWAN_PREFERRED_PROVIDERS                0x0E010107L
    #define OID_WWAN_VISIBLE_PROVIDERS                  0x0E010108L
    #define OID_WWAN_REGISTER_STATE                     0x0E010109L
    #define OID_WWAN_PACKET_SERVICE                     0x0E01010AL
    #define OID_WWAN_SIGNAL_STATE                       0x0E01010BL
    #define OID_WWAN_CONNECT                            0x0E01010CL
    #define OID_WWAN_PROVISIONED_CONTEXTS               0x0E01010DL
    #define OID_WWAN_SERVICE_ACTIVATION                 0x0E01010EL
    #define OID_WWAN_SMS_CONFIGURATION                  0x0E01010FL
    #define OID_WWAN_SMS_READ                           0x0E010110L
    #define OID_WWAN_SMS_SEND                           0x0E010111L
    #define OID_WWAN_SMS_DELETE                         0x0E010112L
    #define OID_WWAN_SMS_STATUS                         0x0E010113L
    #define OID_WWAN_VENDOR_SPECIFIC                    0x0E010114L
#endif
#define OID_GEN_XMIT_OK                                 0x00020101L
#define OID_GEN_RCV_OK                                  0x00020102L
#define OID_GEN_XMIT_ERROR                              0x00020103L
#define OID_GEN_RCV_ERROR                               0x00020104L
#define OID_GEN_RCV_NO_BUFFER                           0x00020105L
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define OID_GEN_STATISTICS                          0x00020106L
#endif
#define OID_GEN_DIRECTED_BYTES_XMIT                     0x00020201L
#define OID_GEN_DIRECTED_FRAMES_XMIT                    0x00020202L
#define OID_GEN_MULTICAST_BYTES_XMIT                    0x00020203L
#define OID_GEN_MULTICAST_FRAMES_XMIT                   0x00020204L
#define OID_GEN_BROADCAST_BYTES_XMIT                    0x00020205L
#define OID_GEN_BROADCAST_FRAMES_XMIT                   0x00020206L
#define OID_GEN_DIRECTED_BYTES_RCV                      0x00020207L
#define OID_GEN_DIRECTED_FRAMES_RCV                     0x00020208L
#define OID_GEN_MULTICAST_BYTES_RCV                     0x00020209L
#define OID_GEN_MULTICAST_FRAMES_RCV                    0x0002020AL
#define OID_GEN_BROADCAST_BYTES_RCV                     0x0002020BL
#define OID_GEN_BROADCAST_FRAMES_RCV                    0x0002020CL
#define OID_GEN_RCV_CRC_ERROR                           0x0002020DL
#define OID_GEN_TRANSMIT_QUEUE_LENGTH                   0x0002020EL
#define OID_GEN_GET_TIME_CAPS                           0x0002020FL
#define OID_GEN_GET_NETCARD_TIME                        0x00020210L
#define OID_GEN_NETCARD_LOAD                            0x00020211L
#define OID_GEN_DEVICE_PROFILE                          0x00020212L
#define OID_GEN_INIT_TIME_MS                            0x00020213L
#define OID_GEN_RESET_COUNTS                            0x00020214L
#define OID_GEN_MEDIA_SENSE_COUNTS                      0x00020215L
#define OID_GEN_FRIENDLY_NAME                           0x00020216L
#if (NTDDI_VERSION >= 0x06000000)
    #define OID_GEN_BYTES_RCV                           0x00020219L
    #define OID_GEN_BYTES_XMIT                          0x0002021AL
    #define OID_GEN_RCV_DISCARDS                        0x0002021BL
    #define OID_GEN_XMIT_DISCARDS                       0x0002021CL
#endif
#define OID_GEN_CO_SUPPORTED_LIST                       OID_GEN_SUPPORTED_LIST
#define OID_GEN_CO_HARDWARE_STATUS                      OID_GEN_HARDWARE_STATUS
#define OID_GEN_CO_MEDIA_SUPPORTED                      OID_GEN_MEDIA_SUPPORTED
#define OID_GEN_CO_MEDIA_IN_USE                         OID_GEN_MEDIA_IN_USE
#define OID_GEN_CO_LINK_SPEED                           OID_GEN_LINK_SPEED
#define OID_GEN_CO_VENDOR_ID                            OID_GEN_VENDOR_ID
#define OID_GEN_CO_VENDOR_DESCRIPTION                   OID_GEN_VENDOR_DESCRIPTION
#define OID_GEN_CO_DRIVER_VERSION                       OID_GEN_DRIVER_VERSION
#define OID_GEN_CO_PROTOCOL_OPTIONS                     OID_GEN_PROTOCOL_OPTIONS
#define OID_GEN_CO_MAC_OPTIONS                          OID_GEN_MAC_OPTIONS
#define OID_GEN_CO_MEDIA_CONNECT_STATUS                 OID_GEN_MEDIA_CONNECT_STATUS
#define OID_GEN_CO_VENDOR_DRIVER_VERSION                OID_GEN_VENDOR_DRIVER_VERSION
#define OID_GEN_CO_SUPPORTED_GUIDS                      OID_GEN_SUPPORTED_GUIDS
#define OID_GEN_CO_GET_TIME_CAPS                        OID_GEN_GET_TIME_CAPS
#define OID_GEN_CO_GET_NETCARD_TIME                     OID_GEN_GET_NETCARD_TIME
#define OID_GEN_CO_MINIMUM_LINK_SPEED                   0x00020120L
#define OID_GEN_CO_XMIT_PDUS_OK                         OID_GEN_XMIT_OK
#define OID_GEN_CO_RCV_PDUS_OK                          OID_GEN_RCV_OK
#define OID_GEN_CO_XMIT_PDUS_ERROR                      OID_GEN_XMIT_ERROR
#define OID_GEN_CO_RCV_PDUS_ERROR                       OID_GEN_RCV_ERROR
#define OID_GEN_CO_RCV_PDUS_NO_BUFFER                   OID_GEN_RCV_NO_BUFFER
#define OID_GEN_CO_RCV_CRC_ERROR                        OID_GEN_RCV_CRC_ERROR
#define OID_GEN_CO_TRANSMIT_QUEUE_LENGTH                OID_GEN_TRANSMIT_QUEUE_LENGTH
#define OID_GEN_CO_BYTES_XMIT                           OID_GEN_DIRECTED_BYTES_XMIT
#define OID_GEN_CO_BYTES_RCV                            OID_GEN_DIRECTED_BYTES_RCV
#define OID_GEN_CO_NETCARD_LOAD                         OID_GEN_NETCARD_LOAD
#define OID_GEN_CO_DEVICE_PROFILE                       OID_GEN_DEVICE_PROFILE
#define OID_GEN_CO_BYTES_XMIT_OUTSTANDING               0x00020221L
#define OID_802_3_PERMANENT_ADDRESS                     0x01010101L
#define OID_802_3_CURRENT_ADDRESS                       0x01010102L
#define OID_802_3_MULTICAST_LIST                        0x01010103L
#define OID_802_3_MAXIMUM_LIST_SIZE                     0x01010104L
#define OID_802_3_MAC_OPTIONS                           0x01010105L
#define OID_802_3_RCV_ERROR_ALIGNMENT                   0x01020101L
#define OID_802_3_XMIT_ONE_COLLISION                    0x01020102L
#define OID_802_3_XMIT_MORE_COLLISIONS                  0x01020103L
#define OID_802_3_XMIT_DEFERRED                         0x01020201L
#define OID_802_3_XMIT_MAX_COLLISIONS                   0x01020202L
#define OID_802_3_RCV_OVERRUN                           0x01020203L
#define OID_802_3_XMIT_UNDERRUN                         0x01020204L
#define OID_802_3_XMIT_HEARTBEAT_FAILURE                0x01020205L
#define OID_802_3_XMIT_TIMES_CRS_LOST                   0x01020206L
#define OID_802_3_XMIT_LATE_COLLISIONS                  0x01020207L
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define OID_802_3_ADD_MULTICAST_ADDRESS             0x01010208L
    #define OID_802_3_DELETE_MULTICAST_ADDRESS          0x01010209L
#endif
#define OID_802_5_PERMANENT_ADDRESS                     0x02010101L
#define OID_802_5_CURRENT_ADDRESS                       0x02010102L
#define OID_802_5_CURRENT_FUNCTIONAL                    0x02010103L
#define OID_802_5_CURRENT_GROUP                         0x02010104L
#define OID_802_5_LAST_OPEN_STATUS                      0x02010105L
#define OID_802_5_CURRENT_RING_STATUS                   0x02010106L
#define OID_802_5_CURRENT_RING_STATE                    0x02010107L
#define OID_802_5_LINE_ERRORS                           0x02020101L
#define OID_802_5_LOST_FRAMES                           0x02020102L
#define OID_802_5_BURST_ERRORS                          0x02020201L
#define OID_802_5_AC_ERRORS                             0x02020202L
#define OID_802_5_ABORT_DELIMETERS                      0x02020203L
#define OID_802_5_FRAME_COPIED_ERRORS                   0x02020204L
#define OID_802_5_FREQUENCY_ERRORS                      0x02020205L
#define OID_802_5_TOKEN_ERRORS                          0x02020206L
#define OID_802_5_INTERNAL_ERRORS                       0x02020207L
#define OID_FDDI_LONG_PERMANENT_ADDR                    0x03010101L
#define OID_FDDI_LONG_CURRENT_ADDR                      0x03010102L
#define OID_FDDI_LONG_MULTICAST_LIST                    0x03010103L
#define OID_FDDI_LONG_MAX_LIST_SIZE                     0x03010104L
#define OID_FDDI_SHORT_PERMANENT_ADDR                   0x03010105L
#define OID_FDDI_SHORT_CURRENT_ADDR                     0x03010106L
#define OID_FDDI_SHORT_MULTICAST_LIST                   0x03010107L
#define OID_FDDI_SHORT_MAX_LIST_SIZE                    0x03010108L
#define OID_FDDI_ATTACHMENT_TYPE                        0x03020101L
#define OID_FDDI_UPSTREAM_NODE_LONG                     0x03020102L
#define OID_FDDI_DOWNSTREAM_NODE_LONG                   0x03020103L
#define OID_FDDI_FRAME_ERRORS                           0x03020104L
#define OID_FDDI_FRAMES_LOST                            0x03020105L
#define OID_FDDI_RING_MGT_STATE                         0x03020106L
#define OID_FDDI_LCT_FAILURES                           0x03020107L
#define OID_FDDI_LEM_REJECTS                            0x03020108L
#define OID_FDDI_LCONNECTION_STATE                      0x03020109L
#define OID_FDDI_SMT_STATION_ID                         0x03030201L
#define OID_FDDI_SMT_OP_VERSION_ID                      0x03030202L
#define OID_FDDI_SMT_HI_VERSION_ID                      0x03030203L
#define OID_FDDI_SMT_LO_VERSION_ID                      0x03030204L
#define OID_FDDI_SMT_MANUFACTURER_DATA                  0x03030205L
#define OID_FDDI_SMT_USER_DATA                          0x03030206L
#define OID_FDDI_SMT_MIB_VERSION_ID                     0x03030207L
#define OID_FDDI_SMT_MAC_CT                             0x03030208L
#define OID_FDDI_SMT_NON_MASTER_CT                      0x03030209L
#define OID_FDDI_SMT_MASTER_CT                          0x0303020AL
#define OID_FDDI_SMT_AVAILABLE_PATHS                    0x0303020BL
#define OID_FDDI_SMT_CONFIG_CAPABILITIES                0x0303020CL
#define OID_FDDI_SMT_CONFIG_POLICY                      0x0303020DL
#define OID_FDDI_SMT_CONNECTION_POLICY                  0x0303020EL
#define OID_FDDI_SMT_T_NOTIFY                           0x0303020FL
#define OID_FDDI_SMT_STAT_RPT_POLICY                    0x03030210L
#define OID_FDDI_SMT_TRACE_MAX_EXPIRATION               0x03030211L
#define OID_FDDI_SMT_PORT_INDEXES                       0x03030212L
#define OID_FDDI_SMT_MAC_INDEXES                        0x03030213L
#define OID_FDDI_SMT_BYPASS_PRESENT                     0x03030214L
#define OID_FDDI_SMT_ECM_STATE                          0x03030215L
#define OID_FDDI_SMT_CF_STATE                           0x03030216L
#define OID_FDDI_SMT_HOLD_STATE                         0x03030217L
#define OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG             0x03030218L
#define OID_FDDI_SMT_STATION_STATUS                     0x03030219L
#define OID_FDDI_SMT_PEER_WRAP_FLAG                     0x0303021AL
#define OID_FDDI_SMT_MSG_TIME_STAMP                     0x0303021BL
#define OID_FDDI_SMT_TRANSITION_TIME_STAMP              0x0303021CL
#define OID_FDDI_SMT_SET_COUNT                          0x0303021DL
#define OID_FDDI_SMT_LAST_SET_STATION_ID                0x0303021EL
#define OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS             0x0303021FL
#define OID_FDDI_MAC_BRIDGE_FUNCTIONS                   0x03030220L
#define OID_FDDI_MAC_T_MAX_CAPABILITY                   0x03030221L
#define OID_FDDI_MAC_TVX_CAPABILITY                     0x03030222L
#define OID_FDDI_MAC_AVAILABLE_PATHS                    0x03030223L
#define OID_FDDI_MAC_CURRENT_PATH                       0x03030224L
#define OID_FDDI_MAC_UPSTREAM_NBR                       0x03030225L
#define OID_FDDI_MAC_DOWNSTREAM_NBR                     0x03030226L
#define OID_FDDI_MAC_OLD_UPSTREAM_NBR                   0x03030227L
#define OID_FDDI_MAC_OLD_DOWNSTREAM_NBR                 0x03030228L
#define OID_FDDI_MAC_DUP_ADDRESS_TEST                   0x03030229L
#define OID_FDDI_MAC_REQUESTED_PATHS                    0x0303022AL
#define OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE               0x0303022BL
#define OID_FDDI_MAC_INDEX                              0x0303022CL
#define OID_FDDI_MAC_SMT_ADDRESS                        0x0303022DL
#define OID_FDDI_MAC_LONG_GRP_ADDRESS                   0x0303022EL
#define OID_FDDI_MAC_SHORT_GRP_ADDRESS                  0x0303022FL
#define OID_FDDI_MAC_T_REQ                              0x03030230L
#define OID_FDDI_MAC_T_NEG                              0x03030231L
#define OID_FDDI_MAC_T_MAX                              0x03030232L
#define OID_FDDI_MAC_TVX_VALUE                          0x03030233L
#define OID_FDDI_MAC_T_PRI0                             0x03030234L
#define OID_FDDI_MAC_T_PRI1                             0x03030235L
#define OID_FDDI_MAC_T_PRI2                             0x03030236L
#define OID_FDDI_MAC_T_PRI3                             0x03030237L
#define OID_FDDI_MAC_T_PRI4                             0x03030238L
#define OID_FDDI_MAC_T_PRI5                             0x03030239L
#define OID_FDDI_MAC_T_PRI6                             0x0303023AL
#define OID_FDDI_MAC_FRAME_CT                           0x0303023BL
#define OID_FDDI_MAC_COPIED_CT                          0x0303023CL
#define OID_FDDI_MAC_TRANSMIT_CT                        0x0303023DL
#define OID_FDDI_MAC_TOKEN_CT                           0x0303023EL
#define OID_FDDI_MAC_ERROR_CT                           0x0303023FL
#define OID_FDDI_MAC_LOST_CT                            0x03030240L
#define OID_FDDI_MAC_TVX_EXPIRED_CT                     0x03030241L
#define OID_FDDI_MAC_NOT_COPIED_CT                      0x03030242L
#define OID_FDDI_MAC_LATE_CT                            0x03030243L
#define OID_FDDI_MAC_RING_OP_CT                         0x03030244L
#define OID_FDDI_MAC_FRAME_ERROR_THRESHOLD              0x03030245L
#define OID_FDDI_MAC_FRAME_ERROR_RATIO                  0x03030246L
#define OID_FDDI_MAC_NOT_COPIED_THRESHOLD               0x03030247L
#define OID_FDDI_MAC_NOT_COPIED_RATIO                   0x03030248L
#define OID_FDDI_MAC_RMT_STATE                          0x03030249L
#define OID_FDDI_MAC_DA_FLAG                            0x0303024AL
#define OID_FDDI_MAC_UNDA_FLAG                          0x0303024BL
#define OID_FDDI_MAC_FRAME_ERROR_FLAG                   0x0303024CL
#define OID_FDDI_MAC_NOT_COPIED_FLAG                    0x0303024DL
#define OID_FDDI_MAC_MA_UNITDATA_AVAILABLE              0x0303024EL
#define OID_FDDI_MAC_HARDWARE_PRESENT                   0x0303024FL
#define OID_FDDI_MAC_MA_UNITDATA_ENABLE                 0x03030250L
#define OID_FDDI_PATH_INDEX                             0x03030251L
#define OID_FDDI_PATH_RING_LATENCY                      0x03030252L
#define OID_FDDI_PATH_TRACE_STATUS                      0x03030253L
#define OID_FDDI_PATH_SBA_PAYLOAD                       0x03030254L
#define OID_FDDI_PATH_SBA_OVERHEAD                      0x03030255L
#define OID_FDDI_PATH_CONFIGURATION                     0x03030256L
#define OID_FDDI_PATH_T_R_MODE                          0x03030257L
#define OID_FDDI_PATH_SBA_AVAILABLE                     0x03030258L
#define OID_FDDI_PATH_TVX_LOWER_BOUND                   0x03030259L
#define OID_FDDI_PATH_T_MAX_LOWER_BOUND                 0x0303025AL
#define OID_FDDI_PATH_MAX_T_REQ                         0x0303025BL
#define OID_FDDI_PORT_MY_TYPE                           0x0303025CL
#define OID_FDDI_PORT_NEIGHBOR_TYPE                     0x0303025DL
#define OID_FDDI_PORT_CONNECTION_POLICIES               0x0303025EL
#define OID_FDDI_PORT_MAC_INDICATED                     0x0303025FL
#define OID_FDDI_PORT_CURRENT_PATH                      0x03030260L
#define OID_FDDI_PORT_REQUESTED_PATHS                   0x03030261L
#define OID_FDDI_PORT_MAC_PLACEMENT                     0x03030262L
#define OID_FDDI_PORT_AVAILABLE_PATHS                   0x03030263L
#define OID_FDDI_PORT_MAC_LOOP_TIME                     0x03030264L
#define OID_FDDI_PORT_PMD_CLASS                         0x03030265L
#define OID_FDDI_PORT_CONNECTION_CAPABILITIES           0x03030266L
#define OID_FDDI_PORT_INDEX                             0x03030267L
#define OID_FDDI_PORT_MAINT_LS                          0x03030268L
#define OID_FDDI_PORT_BS_FLAG                           0x03030269L
#define OID_FDDI_PORT_PC_LS                             0x0303026AL
#define OID_FDDI_PORT_EB_ERROR_CT                       0x0303026BL
#define OID_FDDI_PORT_LCT_FAIL_CT                       0x0303026CL
#define OID_FDDI_PORT_LER_ESTIMATE                      0x0303026DL
#define OID_FDDI_PORT_LEM_REJECT_CT                     0x0303026EL
#define OID_FDDI_PORT_LEM_CT                            0x0303026FL
#define OID_FDDI_PORT_LER_CUTOFF                        0x03030270L
#define OID_FDDI_PORT_LER_ALARM                         0x03030271L
#define OID_FDDI_PORT_CONNECT_STATE                     0x03030272L
#define OID_FDDI_PORT_PCM_STATE                         0x03030273L
#define OID_FDDI_PORT_PC_WITHHOLD                       0x03030274L
#define OID_FDDI_PORT_LER_FLAG                          0x03030275L
#define OID_FDDI_PORT_HARDWARE_PRESENT                  0x03030276L
#define OID_FDDI_SMT_STATION_ACTION                     0x03030277L
#define OID_FDDI_PORT_ACTION                            0x03030278L
#define OID_FDDI_IF_DESCR                               0x03030279L
#define OID_FDDI_IF_TYPE                                0x0303027AL
#define OID_FDDI_IF_MTU                                 0x0303027BL
#define OID_FDDI_IF_SPEED                               0x0303027CL
#define OID_FDDI_IF_PHYS_ADDRESS                        0x0303027DL
#define OID_FDDI_IF_ADMIN_STATUS                        0x0303027EL
#define OID_FDDI_IF_OPER_STATUS                         0x0303027FL
#define OID_FDDI_IF_LAST_CHANGE                         0x03030280L
#define OID_FDDI_IF_IN_OCTETS                           0x03030281L
#define OID_FDDI_IF_IN_UCAST_PKTS                       0x03030282L
#define OID_FDDI_IF_IN_NUCAST_PKTS                      0x03030283L
#define OID_FDDI_IF_IN_DISCARDS                         0x03030284L
#define OID_FDDI_IF_IN_ERRORS                           0x03030285L
#define OID_FDDI_IF_IN_UNKNOWN_PROTOS                   0x03030286L
#define OID_FDDI_IF_OUT_OCTETS                          0x03030287L
#define OID_FDDI_IF_OUT_UCAST_PKTS                      0x03030288L
#define OID_FDDI_IF_OUT_NUCAST_PKTS                     0x03030289L
#define OID_FDDI_IF_OUT_DISCARDS                        0x0303028AL
#define OID_FDDI_IF_OUT_ERRORS                          0x0303028BL
#define OID_FDDI_IF_OUT_QLEN                            0x0303028CL
#define OID_FDDI_IF_SPECIFIC                            0x0303028DL
#define OID_WAN_PERMANENT_ADDRESS                       0x04010101L
#define OID_WAN_CURRENT_ADDRESS                         0x04010102L
#define OID_WAN_QUALITY_OF_SERVICE                      0x04010103L
#define OID_WAN_PROTOCOL_TYPE                           0x04010104L
#define OID_WAN_MEDIUM_SUBTYPE                          0x04010105L
#define OID_WAN_HEADER_FORMAT                           0x04010106L
#define OID_WAN_GET_INFO                                0x04010107L
#define OID_WAN_SET_LINK_INFO                           0x04010108L
#define OID_WAN_GET_LINK_INFO                           0x04010109L
#define OID_WAN_LINE_COUNT                              0x0401010AL
#define OID_WAN_PROTOCOL_CAPS                           0x0401010BL
#define OID_WAN_GET_BRIDGE_INFO                         0x0401020AL
#define OID_WAN_SET_BRIDGE_INFO                         0x0401020BL
#define OID_WAN_GET_COMP_INFO                           0x0401020CL
#define OID_WAN_SET_COMP_INFO                           0x0401020DL
#define OID_WAN_GET_STATS_INFO                          0x0401020EL
#define OID_WAN_CO_GET_INFO                             0x04010180L
#define OID_WAN_CO_SET_LINK_INFO                        0x04010181L
#define OID_WAN_CO_GET_LINK_INFO                        0x04010182L
#define OID_WAN_CO_GET_COMP_INFO                        0x04010280L
#define OID_WAN_CO_SET_COMP_INFO                        0x04010281L
#define OID_WAN_CO_GET_STATS_INFO                       0x04010282L
#define OID_LTALK_CURRENT_NODE_ID                       0x05010102L
#define OID_LTALK_IN_BROADCASTS                         0x05020101L
#define OID_LTALK_IN_LENGTH_ERRORS                      0x05020102L
#define OID_LTALK_OUT_NO_HANDLERS                       0x05020201L
#define OID_LTALK_COLLISIONS                            0x05020202L
#define OID_LTALK_DEFERS                                0x05020203L
#define OID_LTALK_NO_DATA_ERRORS                        0x05020204L
#define OID_LTALK_RANDOM_CTS_ERRORS                     0x05020205L
#define OID_LTALK_FCS_ERRORS                            0x05020206L
#define OID_ARCNET_PERMANENT_ADDRESS                    0x06010101L
#define OID_ARCNET_CURRENT_ADDRESS                      0x06010102L
#define OID_ARCNET_RECONFIGURATIONS                     0x06020201L
#define OID_TAPI_ACCEPT                                 0x07030101L
#define OID_TAPI_ANSWER                                 0x07030102L
#define OID_TAPI_CLOSE                                  0x07030103L
#define OID_TAPI_CLOSE_CALL                             0x07030104L
#define OID_TAPI_CONDITIONAL_MEDIA_DETECTION            0x07030105L
#define OID_TAPI_CONFIG_DIALOG                          0x07030106L
#define OID_TAPI_DEV_SPECIFIC                           0x07030107L
#define OID_TAPI_DIAL                                   0x07030108L
#define OID_TAPI_DROP                                   0x07030109L
#define OID_TAPI_GET_ADDRESS_CAPS                       0x0703010AL
#define OID_TAPI_GET_ADDRESS_ID                         0x0703010BL
#define OID_TAPI_GET_ADDRESS_STATUS                     0x0703010CL
#define OID_TAPI_GET_CALL_ADDRESS_ID                    0x0703010DL
#define OID_TAPI_GET_CALL_INFO                          0x0703010EL
#define OID_TAPI_GET_CALL_STATUS                        0x0703010FL
#define OID_TAPI_GET_DEV_CAPS                           0x07030110L
#define OID_TAPI_GET_DEV_CONFIG                         0x07030111L
#define OID_TAPI_GET_EXTENSION_ID                       0x07030112L
#define OID_TAPI_GET_ID                                 0x07030113L
#define OID_TAPI_GET_LINE_DEV_STATUS                    0x07030114L
#define OID_TAPI_MAKE_CALL                              0x07030115L
#define OID_TAPI_NEGOTIATE_EXT_VERSION                  0x07030116L
#define OID_TAPI_OPEN                                   0x07030117L
#define OID_TAPI_PROVIDER_INITIALIZE                    0x07030118L
#define OID_TAPI_PROVIDER_SHUTDOWN                      0x07030119L
#define OID_TAPI_SECURE_CALL                            0x0703011AL
#define OID_TAPI_SELECT_EXT_VERSION                     0x0703011BL
#define OID_TAPI_SEND_USER_USER_INFO                    0x0703011CL
#define OID_TAPI_SET_APP_SPECIFIC                       0x0703011DL
#define OID_TAPI_SET_CALL_PARAMS                        0x0703011EL
#define OID_TAPI_SET_DEFAULT_MEDIA_DETECTION            0x0703011FL
#define OID_TAPI_SET_DEV_CONFIG                         0x07030120L
#define OID_TAPI_SET_MEDIA_MODE                         0x07030121L
#define OID_TAPI_SET_STATUS_MESSAGES                    0x07030122L
#define OID_TAPI_GATHER_DIGITS                          0x07030123L
#define OID_TAPI_MONITOR_DIGITS                         0x07030124L
#define OID_ATM_SUPPORTED_VC_RATES                      0x08010101L
#define OID_ATM_SUPPORTED_SERVICE_CATEGORY              0x08010102L
#define OID_ATM_SUPPORTED_AAL_TYPES                     0x08010103L
#define OID_ATM_HW_CURRENT_ADDRESS                      0x08010104L
#define OID_ATM_MAX_ACTIVE_VCS                          0x08010105L
#define OID_ATM_MAX_ACTIVE_VCI_BITS                     0x08010106L
#define OID_ATM_MAX_ACTIVE_VPI_BITS                     0x08010107L
#define OID_ATM_MAX_AAL0_PACKET_SIZE                    0x08010108L
#define OID_ATM_MAX_AAL1_PACKET_SIZE                    0x08010109L
#define OID_ATM_MAX_AAL34_PACKET_SIZE                   0x0801010AL
#define OID_ATM_MAX_AAL5_PACKET_SIZE                    0x0801010BL
#define OID_ATM_SIGNALING_VPIVCI                        0x08010201L
#define OID_ATM_ASSIGNED_VPI                            0x08010202L
#define OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES            0x08010203L
#define OID_ATM_RELEASE_ACCESS_NET_RESOURCES            0x08010204L
#define OID_ATM_ILMI_VPIVCI                             0x08010205L
#define OID_ATM_DIGITAL_BROADCAST_VPIVCI                0x08010206L
#define OID_ATM_GET_NEAREST_FLOW                        0x08010207L
#define OID_ATM_ALIGNMENT_REQUIRED                      0x08010208L
#define OID_ATM_LECS_ADDRESS                            0x08010209L
#define OID_ATM_SERVICE_ADDRESS                         0x0801020AL
#define OID_ATM_CALL_PROCEEDING                         0x0801020BL
#define OID_ATM_CALL_ALERTING                           0x0801020CL
#define OID_ATM_PARTY_ALERTING                          0x0801020DL
#define OID_ATM_CALL_NOTIFY                             0x0801020EL
#define OID_ATM_MY_IP_NM_ADDRESS                        0x0801020FL
#define OID_ATM_RCV_CELLS_OK                            0x08020101L
#define OID_ATM_XMIT_CELLS_OK                           0x08020102L
#define OID_ATM_RCV_CELLS_DROPPED                       0x08020103L
#define OID_ATM_RCV_INVALID_VPI_VCI                     0x08020201L
#define OID_ATM_CELLS_HEC_ERROR                         0x08020202L
#define OID_ATM_RCV_REASSEMBLY_ERROR                    0x08020203L
#define OID_802_11_BSSID                                0x0D010101L
#define OID_802_11_SSID                                 0x0D010102L
#define OID_802_11_NETWORK_TYPES_SUPPORTED              0x0D010203L
#define OID_802_11_NETWORK_TYPE_IN_USE                  0x0D010204L
#define OID_802_11_TX_POWER_LEVEL                       0x0D010205L
#define OID_802_11_RSSI                                 0x0D010206L
#define OID_802_11_RSSI_TRIGGER                         0x0D010207L
#define OID_802_11_INFRASTRUCTURE_MODE                  0x0D010108L
#define OID_802_11_FRAGMENTATION_THRESHOLD              0x0D010209L
#define OID_802_11_RTS_THRESHOLD                        0x0D01020AL
#define OID_802_11_NUMBER_OF_ANTENNAS                   0x0D01020BL
#define OID_802_11_RX_ANTENNA_SELECTED                  0x0D01020CL
#define OID_802_11_TX_ANTENNA_SELECTED                  0x0D01020DL
#define OID_802_11_SUPPORTED_RATES                      0x0D01020EL
#define OID_802_11_DESIRED_RATES                        0x0D010210L
#define OID_802_11_CONFIGURATION                        0x0D010211L
#define OID_802_11_STATISTICS                           0x0D010212L
#define OID_802_11_ADD_WEP                              0x0D010113L
#define OID_802_11_REMOVE_WEP                           0x0D010114L
#define OID_802_11_DISASSOCIATE                         0x0D010115L
#define OID_802_11_POWER_MODE                           0x0D010216L
#define OID_802_11_BSSID_LIST                           0x0D010217L
#define OID_802_11_AUTHENTICATION_MODE                  0x0D010118L
#define OID_802_11_PRIVACY_FILTER                       0x0D010119L
#define OID_802_11_BSSID_LIST_SCAN                      0x0D01011AL
#define OID_802_11_WEP_STATUS                           0x0D01011BL
#define OID_802_11_ENCRYPTION_STATUS                    OID_802_11_WEP_STATUS
#define OID_802_11_RELOAD_DEFAULTS                      0x0D01011CL
#define OID_802_11_ADD_KEY                              0x0D01011DL
#define OID_802_11_REMOVE_KEY                           0x0D01011EL
#define OID_802_11_ASSOCIATION_INFORMATION              0x0D01011FL
#define OID_802_11_TEST                                 0x0D010120L
#define OID_802_11_MEDIA_STREAM_MODE                    0x0D010121L
#define OID_802_11_CAPABILITY                           0x0D010122L
#define OID_802_11_PMKID                                0x0D010123L
#define OID_802_11_NON_BCAST_SSID_LIST                  0x0D010124L
#define OID_802_11_RADIO_STATUS                         0x0D010125L
#define OID_IRDA_RECEIVING                              0x0A010100L
#define OID_IRDA_TURNAROUND_TIME                        0x0A010101L
#define OID_IRDA_SUPPORTED_SPEEDS                       0x0A010102L
#define OID_IRDA_LINK_SPEED                             0x0A010103L
#define OID_IRDA_MEDIA_BUSY                             0x0A010104L
#define OID_IRDA_EXTRA_RCV_BOFS                         0x0A010200L
#define OID_IRDA_RATE_SNIFF                             0x0A010201L
#define OID_IRDA_UNICAST_LIST                           0x0A010202L
#define OID_IRDA_MAX_UNICAST_LIST_SIZE                  0x0A010203L
#define OID_IRDA_MAX_RECEIVE_WINDOW_SIZE                0x0A010204L
#define OID_IRDA_MAX_SEND_WINDOW_SIZE                   0x0A010205L
#define OID_1394_LOCAL_NODE_INFO                        0x0C010101L
#define OID_1394_VC_INFO                                0x0C010102L
#define OID_CO_ADD_PVC                                  0xFE000001L
#define OID_CO_DELETE_PVC                               0xFE000002L
#define OID_CO_GET_CALL_INFORMATION                     0xFE000003L
#define OID_CO_ADD_ADDRESS                              0xFE000004L
#define OID_CO_DELETE_ADDRESS                           0xFE000005L
#define OID_CO_GET_ADDRESSES                            0xFE000006L
#define OID_CO_ADDRESS_CHANGE                           0xFE000007L
#define OID_CO_SIGNALING_ENABLED                        0xFE000008L
#define OID_CO_SIGNALING_DISABLED                       0xFE000009L
#define OID_CO_AF_CLOSE                                 0xFE00000AL
#define OID_CO_TAPI_CM_CAPS                             0xFE001001L
#define OID_CO_TAPI_LINE_CAPS                           0xFE001002L
#define OID_CO_TAPI_ADDRESS_CAPS                        0xFE001003L
#define OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS           0xFE001004L
#define OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS           0xFE001005L
#define OID_CO_TAPI_TRANSLATE_TAPI_SAP                  0xFE001006L
#define OID_CO_TAPI_GET_CALL_DIAGNOSTICS                0xFE001007L
#define OID_CO_TAPI_REPORT_DIGITS                       0xFE001008L
#define OID_CO_TAPI_DONT_REPORT_DIGITS                  0xFE001009L
#define OID_PNP_CAPABILITIES                            0xFD010100L
#define OID_PNP_SET_POWER                               0xFD010101L
#define OID_PNP_QUERY_POWER                             0xFD010102L
#define OID_PNP_ADD_WAKE_UP_PATTERN                     0xFD010103L
#define OID_PNP_REMOVE_WAKE_UP_PATTERN                  0xFD010104L
#define OID_PNP_WAKE_UP_PATTERN_LIST                    0xFD010105L
#define OID_PNP_ENABLE_WAKE_UP                          0xFD010106L
#define OID_PNP_WAKE_UP_OK                              0xFD020200L
#define OID_PNP_WAKE_UP_ERROR                           0xFD020201L
#if (NTDDI_VERSION >= 0x06010000) || NDIS_SUPPORT_NDIS620
    #define OID_PM_CURRENT_CAPABILITIES                 0xFD010107L
    #define OID_PM_HARDWARE_CAPABILITIES                0xFD010108L
    #define OID_PM_PARAMETERS                           0xFD010109L
    #define OID_PM_ADD_WOL_PATTERN                      0xFD01010AL
    #define OID_PM_REMOVE_WOL_PATTERN                   0xFD01010BL
    #define OID_PM_WOL_PATTERN_LIST                     0xFD01010CL
    #define OID_PM_ADD_PROTOCOL_OFFLOAD                 0xFD01010DL
    #define OID_PM_GET_PROTOCOL_OFFLOAD                 0xFD01010EL
    #define OID_PM_REMOVE_PROTOCOL_OFFLOAD              0xFD01010FL
    #define OID_PM_PROTOCOL_OFFLOAD_LIST                0xFD010110L
    #define OID_RECEIVE_FILTER_HARDWARE_CAPABILITIES    0x00010221L
    #define OID_RECEIVE_FILTER_GLOBAL_PARAMETERS        0x00010222L
    #define OID_RECEIVE_FILTER_ALLOCATE_QUEUE           0x00010223L
    #define OID_RECEIVE_FILTER_FREE_QUEUE               0x00010224L
    #define OID_RECEIVE_FILTER_ENUM_QUEUES              0x00010225L
    #define OID_RECEIVE_FILTER_QUEUE_PARAMETERS         0x00010226L
    #define OID_RECEIVE_FILTER_SET_FILTER               0x00010227L
    #define OID_RECEIVE_FILTER_CLEAR_FILTER             0x00010228L
    #define OID_RECEIVE_FILTER_ENUM_FILTERS             0x00010229L
    #define OID_RECEIVE_FILTER_PARAMETERS               0x0001022AL
    #define OID_RECEIVE_FILTER_QUEUE_ALLOCATION_COMPLETE    0x0001022BL
    #define OID_RECEIVE_FILTER_CURRENT_CAPABILITIES     0x0001022DL
    #define OID_NIC_SWITCH_HARDWARE_CAPABILITIES        0x0001022EL
    #define OID_NIC_SWITCH_CURRENT_CAPABILITIES         0x0001022FL
#endif
#define OID_TCP_TASK_OFFLOAD                            0xFC010201L
#define OID_TCP_TASK_IPSEC_ADD_SA                       0xFC010202L
#define OID_TCP_TASK_IPSEC_DELETE_SA                    0xFC010203L
#define OID_TCP_SAN_SUPPORT                             0xFC010204L
#define OID_TCP_TASK_IPSEC_ADD_UDPESP_SA                0xFC010205L
#define OID_TCP_TASK_IPSEC_DELETE_UDPESP_SA             0xFC010206L
#define OID_TCP4_OFFLOAD_STATS                          0xFC010207L
#define OID_TCP5_OFFLOAD_STATS                          0xFC010208L
#define OID_IP4_OFFLOAD_STATS                           0xFC010209L
#define OID_IP6_OFFLOAD_STATS                           0xFC01020AL
#define OID_TCP_OFFLOAD_CURRENT_CONFIG                  0xFC01020BL
#define OID_TCP_OFFLOAD_PARAMETERS                      0xFC01020CL
#define OID_TCP_OFFLOAD_HARDWARE_CAPABILITIES           0xFC01020DL
#define OID_TCP_CONNECTION_OFFLOAD_CURRENT_CONFIG       0xFC01020EL
#define OID_TCP_CONNECTION_OFFLOAD_HARDWARE_CAPABILITIES    0xFC01020FL
#define OID_OFFLOAD_ENCAPSULATION                       0x0101010AL
#if NDIS_SUPPORT_NDIS61
    #define OID_TCP_TASK_IPSEC_OFFLOAD_V2_ADD_SA        0xFC030202L
    #define OID_TCP_TASK_IPSEC_OFFLOAD_V2_DELETE_SA     0xFC030203L
    #define OID_TCP_TASK_IPSEC_OFFLOAD_V2_UPDATE_SA     0xFC030204L
#endif
#define OID_FFP_SUPPORT                                 0xFC010210L
#define OID_FFP_FLUSH                                   0xFC010211L
#define OID_FFP_CONTROL                                 0xFC010212L
#define OID_FFP_PARAMS                                  0xFC010213L
#define OID_FFP_DATA                                    0xFC010214L
#define OID_FFP_DRIVER_STATS                            0xFC020210L
#define OID_FFP_ADAPTER_STATS                           0xFC020211L
#define OID_TCP_CONNECTION_OFFLOAD_PARAMETERS           0xFC030201L
#if (NTDDI_VERSION >= 0x06010000) || NDIS_SUPPORT_NDIS620
    #define OID_TUNNEL_INTERFACE_SET_OID                0x0F010106L
    #define OID_TUNNEL_INTERFACE_RELEASE_OID            0x0F010107L
#endif

/* NDIS 802.3 MAC option flags */
#define NDIS_802_3_MAC_OPTION_PRIORITY  0x00000001L

/* NDIS Ethernet frame types */
#define NDIS_ETH_TYPE_IPV4          0x0800
#define NDIS_ETH_TYPE_ARP           0x0806
#define NDIS_ETH_TYPE_IPV6          0x86DD
#define NDIS_ETH_TYPE_802_1X        0x888E
#define NDIS_ETH_TYPE_802_1Q        0x8100
#define NDIS_ETH_TYPE_SLOW_PROTOCOL 0x8809

/* NDIS 802.11 lengths */
#define NDIS_802_11_LENGTH_SSID     32
#define NDIS_802_11_LENGTH_RATES    8
#define NDIS_802_11_LENGTH_RATES_EX 16

/* NDIS 802.11 authentication request masks */
#define NDIS_802_11_AUTH_REQUEST_AUTH_FIELDS    0x0F
#define NDIS_802_11_AUTH_REQUEST_REAUTH         0x01
#define NDIS_802_11_AUTH_REQUEST_KEYUPDATE      0x02
#define NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR 0x06
#define NDIS_802_11_AUTH_REQUEST_GROUP_ERROR    0x0E

/* NDIS 802.11 PMKID candidate flags */
#define NDIS_802_11_PMKID_CANDIDATE_PREAUTH_ENABLED 0x01

/* NDIS 802.11 request fixed information elements flags */
#define NDIS_802_11_AI_REQFI_CAPABILITIES       1
#define NDIS_802_11_AI_REQFI_LISTENINTERVAL     2
#define NDIS_802_11_AI_REQFI_CURRENTAPADDRESS   4

/* NDIS 802.11 response fixed information elements flags */
#define NDIS_802_11_AI_RESFI_CAPABILITIES   1
#define NDIS_802_11_AI_RESFI_STATUSCODE     2
#define NDIS_802_11_AI_RESFI_ASSOCIATIONID  4

/* NDIS PNP wake-up flags */
#define NDIS_PNP_WAKE_UP_MAGIC_PACKET   0x00000001L
#define NDIS_PNP_WAKE_UP_PATTERN_MATCH  0x00000002L
#define NDIS_PNP_WAKE_UP_LINK_CHANGE    0x00000004L

/* Offload constants */
#define OFFLOAD_MAX_SAS     3
#define OFFLOAD_INBOUND_SA  0x0001
#define OFFLOAD_OUTBOUND_SA 0x0002

/* NDIS protocol identifiers */
#define NDIS_PROTOCOL_ID_DEFAULT    0x00
#define NDIS_PROTOCOL_ID_TCP_IP     0x02
#define NDIS_PROTOCOL_ID_IPX        0x06
#define NDIS_PROTOCOL_ID_NBF        0x07
#define NDIS_PROTOCOL_ID_MAX        0x0F
#define NDIS_PROTOCOL_ID_MASK       0x0F

/* Time capability flags */
#define READABLE_LOCAL_CLOCK            0x00000001L
#define CLOCK_NETWORK_DERIVED           0x00000002L
#define CLOCK_PRECISION                 0x00000004L
#define RECEIVE_TIME_INDICATION_CAPABLE 0x00000008L
#define TIMED_SEND_CAPABLE              0x00000010L
#define TIME_STAMP_CAPABLE              0x00000020L

/* NDIS device wake-up capability flags */
#define NDIS_DEVICE_WAKE_UP_ENABLE                  0x00000001L
#define NDIS_DEVICE_WAKE_ON_PATTERN_MATCH_ENABLE    0x00000002L
#define NDIS_DEVICE_WAKE_ON_MAGIC_PACKET_ENABLE     0x00000004L

/* WAN protocol capability flags */
#define WAN_PROTOCOL_KEEPS_STATS    0x00000001L

/* NDIS GUID flags */
#define fNDIS_GUID_TO_OID                   0x00000001L
#define fNDIS_GUID_TO_STATUS                0x00000002L
#define fNDIS_GUID_ANSI_STRING              0x00000004L
#define fNDIS_GUID_UNICODE_STRING           0x00000008L
#define fNDIS_GUID_ARRAY                    0x00000010L
#define fNDIS_GUID_ALLOW_READ               0x00000020L
#define fNDIS_GUID_ALLOW_WRITE              0x00000040L
#define fNDIS_GUID_METHOD                   0x00000080L
#define fNDIS_GUID_SUPPORT_COMMON_HEADER    0x00000200L

/* NDIS packet types */
#define NDIS_PACKET_TYPE_DIRECTED       0x00000001L
#define NDIS_PACKET_TYPE_MULTICAST      0x00000002L
#define NDIS_PACKET_TYPE_ALL_MULTICAST  0x00000004L
#define NDIS_PACKET_TYPE_BROADCAST      0x00000008L
#define NDIS_PACKET_TYPE_SOURCE_ROUTING 0x00000010L
#define NDIS_PACKET_TYPE_PROMISCUOUS    0x00000020L
#define NDIS_PACKET_TYPE_SMT            0x00000040L
#define NDIS_PACKET_TYPE_ALL_LOCAL      0x00000080L
#define NDIS_PACKET_TYPE_GROUP          0x00001000L
#define NDIS_PACKET_TYPE_ALL_FUNCTIONAL 0x00002000L
#define NDIS_PACKET_TYPE_FUNCTIONAL     0x00004000L
#define NDIS_PACKET_TYPE_MAC_FRAME      0x00008000L
#define NDIS_PACKET_TYPE_NO_LOCAL       0x00010000L

/* NDIS ring status values */
#define NDIS_RING_SIGNAL_LOSS           0x00008000L
#define NDIS_RING_HARD_ERROR            0x00004000L
#define NDIS_RING_SOFT_ERROR            0x00002000L
#define NDIS_RING_TRANSMIT_BEACON       0x00001000L
#define NDIS_RING_LOBE_WIRE_FAULT       0x00000800L
#define NDIS_RING_AUTO_REMOVAL_ERROR    0x00000400L
#define NDIS_RING_REMOVE_RECEIVED       0x00000200L
#define NDIS_RING_COUNTER_OVERFLOW      0x00000100L
#define NDIS_RING_SINGLE_STATION        0x00000080L
#define NDIS_RING_RING_RECOVERY         0x00000040L

/* NDIS protocol options */
#define NDIS_PROT_OPTION_ESTIMATED_LENGTH   0x00000001L
#define NDIS_PROT_OPTION_NO_LOOPBACK        0x00000002L
#define NDIS_PROT_OPTION_NO_RSVD_ON_RCVPKT  0x00000004L
#define NDIS_PROT_OPTION_SEND_RESTRICTED    0x00000008L

/* NDIS MAC options */
#define NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA             0x00000001L
#define NDIS_MAC_OPTION_RECEIVE_SERIALIZED              0x00000002L
#define NDIS_MAC_OPTION_TRANSFERS_NOT_PEND              0x00000004L
#define NDIS_MAC_OPTION_NO_LOOPBACK                     0x00000008L
#define NDIS_MAC_OPTION_FULL_DUPLEX                     0x00000010L
#define NDIS_MAC_OPTION_EOTX_INDICATION                 0x00000020L
#define NDIS_MAC_OPTION_8021P_PRIORITY                  0x00000040L
#define NDIS_MAC_OPTION_SUPPORTS_MAC_ADDRESS_OVERWRITE  0x00000080L
#define NDIS_MAC_OPTION_RECEIVE_AT_DPC                  0x00000100L
#define NDIS_MAC_OPTION_8021Q_VLAN                      0x00000200L

/* NDIS media capability flags */
#define NDIS_MEDIA_CAP_TRANSMIT 0x00000001L
#define NDIS_MEDIA_CAP_RECEIVE  0x00000002L

/* NDIS CO MAC options */
#define NDIS_CO_MAC_OPTION_DYNAMIC_LINK_SPEED   0x00000001L

/* Macro to make a network LUID */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_MAKE_NET_LUID( x, p1, p2 ) \
        { \
            (x)->Info.IfType = p1; \
            (x)->Info.NetLuidIndex = p2; \
            (x)->Info.Reserved = 0; \
        }
#endif

/* NDIS interface string lengths */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_IF_MAX_STRING_SIZE         IF_MAX_STRING_SIZE
    #define NDIS_MAX_PHYS_ADDRESS_LENGTH    IF_MAX_PHYS_ADDRESS_LENGTH
#endif

/* NDIS link state flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_LINK_STATE_XMIT_LINK_SPEED_AUTO_NEGOTIATED 0x00000001L
    #define NDIS_LINK_STATE_RCV_LINK_SPEED_AUTO_NEGOTIATED  0x00000002L
    #define NDIS_LINK_STATE_DUPLEX_AUTO_NEGOTIATED          0x00000004L
    #define NDIS_LINK_STATE_PAUSE_FUNCTIONS_AUTO_NEGOTIATED 0x00000008L
#endif

/* NDIS link state revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_LINK_STATE_REVISION_1  1
#endif

/* NDIS link parameters revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_LINK_PARAMETERS_REVISION_1 1
#endif

/* NDIS operational state revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OPER_STATE_REVISION_1  1
#endif

/* Maximum number of address families */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define MAXIMUM_IP_OPER_STATUS_ADDRESS_FAMILIES_SUPPORTED   32
#endif

/* NDIS IP operational status information revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_IP_OPER_STATUS_INFO_REVISION_1 1
#endif

/* NDIS IP operational state revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_IP_OPER_STATE_REVISION_1   1
#endif

/* NDIS offload parameter values */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OFFLOAD_PARAMETERS_TX_RX_DISABLED                  1
    #define NDIS_OFFLOAD_PARAMETERS_TX_ENABLED_RX_DISABLED          2
    #define NDIS_OFFLOAD_PARAMETERS_RX_ENABLED_TX_DISABLED          3
    #define NDIS_OFFLOAD_PARAMETERS_TX_RX_ENABLED                   4
    #define NDIS_OFFLOAD_PARAMETERS_LSOV1_DISABLED                  1
    #define NDIS_OFFLOAD_PARAMETERS_LSOV1_ENABLED                   2
    #define NDIS_OFFLOAD_PARAMETERS_IPSECV1_DISABLED                1
    #define NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_ENABLED              2
    #define NDIS_OFFLOAD_PARAMETERS_IPSECV1_ESP_ENABLED             3
    #define NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_AND_ESP_ENABLED      4
    #define NDIS_OFFLOAD_PARAMETERS_LSOV2_DISABLED                  1
    #define NDIS_OFFLOAD_PARAMETERS_LSOV2_ENABLED                   2
    #if NDIS_SUPPORT_NDIS61
        #define NDIS_OFFLOAD_PARAMETERS_IPSECV2_DISABLED            1
        #define NDIS_OFFLOAD_PARAMETERS_IPSECV2_AH_ENABLED          2
        #define NDIS_OFFLOAD_PARAMETERS_IPSECV2_ESP_ENABLED         3
        #define NDIS_OFFLOAD_PARAMETERS_IPSECV2_AH_AND_ESP_ENABLED  4
    #endif
    #define NDIS_OFFLOAD_PARAMETERS_CONNECTION_OFFLOAD_DISABLED     1
    #define NDIS_OFFLOAD_PARAMETERS_CONNECTION_OFFLOAD_ENABLED      2
#endif

/* NDIS offload values */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OFFLOAD_NOT_SUPPORTED  0
    #define NDIS_OFFLOAD_SUPPORTED      1
    #define NDIS_OFFLOAD_SET_NO_CHANGE  0
    #define NDIS_OFFLOAD_SET_ON         1
    #define NDIS_OFFLOAD_SET_OFF        2
#endif

/* NDIS encapsulation types */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_ENCAPSULATION_NOT_SUPPORTED                0x00000000L
    #define NDIS_ENCAPSULATION_NULL                         0x00000001L
    #define NDIS_ENCAPSULATION_IEEE_802_3                   0x00000002L
    #define NDIS_ENCAPSULATION_IEEE_802_3_P_AND_Q           0x00000004L
    #define NDIS_ENCAPSULATION_IEEE_802_3_P_AND_Q_IN_OOB    0x00000008L
    #define NDIS_ENCAPSULATION_IEEE_LLC_SNAP_ROUTED         0x00000010L
#endif

/* NDIS offload parameters revision numbers */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OFFLOAD_PARAMETERS_REVISION_1      1
    #if NDIS_SUPPORT_NDIS61
        #define NDIS_OFFLOAD_PARAMETERS_REVISION_2  2
    #endif
#endif

/* IPsec offload authentication algorithm flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_MD5         0x00000001L
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_SHA_1       0x00000002L
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_SHA_256     0x00000004L
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_AES_GCM_128 0x00000008L
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_AES_GCM_192 0x00000010L
    #define IPSEC_OFFLOAD_V2_AUTHENTICATION_AES_GCM_256 0x00000020L
#endif

/* IPsec offload encryption algorithm flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_NONE        0x00000001L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_DES_CBC     0x00000002L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_3_DES_CBC   0x00000004L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_GCM_128 0x00000008L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_GCM_192 0x00000010L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_GCM_256 0x00000020L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_CBC_128 0x00000040L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_CBC_192 0x00000080L
    #define IPSEC_OFFLOAD_V2_ENCRYPTION_AES_CBC_256 0x00000100L
#endif

/* NDIS offload flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OFFLOAD_FLAGS_GROUP_CHECKSUM_CAPABILITIES  0x00000001L
#endif

/* NDIS offload revision numbers */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_OFFLOAD_REVISION_1     1
    #if NDIS_SUPPORT_NDIS61
        #define NDIS_OFFLOAD_REVISION_2 2
    #endif
#endif

/* NDIS TCP connection offload revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_TCP_CONNECTION_OFFLOAD_REVISION_1      1
    #if NDIS_SUPPORT_NDIS61
        #define NDIS_TCP_CONNECTION_OFFLOAD_REVISION_2  2
    #endif
#endif

/* NDIS port constants */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_MAXIMUM_PORTS          0x01000000L
    #define NDIS_DEFAULT_PORT_NUMBER    0L
#endif

/* NDIS port state revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_PORT_STATE_REVISION_1  1
#endif

/* NDIS port authentication parameters revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_PORT_AUTHENTICATION_PARAMETERS_REVISION_1  1
#endif

/* NDIS port characteristic flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_PORT_CHAR_USE_DEFAULT_AUTH_SETTINGS    0x00000001L
#endif

/* NDIS port characteristics revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_PORT_CHARACTERISTICS_REVISION_1    1
#endif

/* NDIS port array revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_PORT_ARRAY_REVISION_1  1
#endif

/* NDIS WMI constants */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_WMI_DEFAULT_METHOD_ID          1
    #define NDIS_WMI_OBJECT_TYPE_SET            0x01
    #define NDIS_WMI_OBJECT_TYPE_METHOD         0x02
    #define NDIS_WMI_OBJECT_TYPE_EVENT          0x03
    #define NDIS_WMI_OBJECT_TYPE_ENUM_ADAPTER   0x04
    #define NDIS_WMI_OBJECT_TYPE_OUTPUT_INFO    0x05
#endif

/* NDIS WMI revision numbers */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_WMI_METHOD_HEADER_REVISION_1   1
    #define NDIS_WMI_SET_HEADER_REVISION_1      1
    #define NDIS_WMI_EVENT_HEADER_REVISION_1    1
    #define NDIS_WMI_ENUM_ADAPTER_REVISION_1    1
    #define NDIS_WMI_OUTPUT_INFO_REVISION_1     1
#endif

/* NDIS device types */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_DEVICE_TYPE_ENDPOINT   0x00000001L
#endif

/* NDIS HD split parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_PARAMETERS_REVISION_1 1
#endif

/* NDIS HD split combine flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_COMBINE_ALL_HEADERS   0x00000001L
#endif

/* NDIS HD split current configuration revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_CURRENT_CONFIG_REVISION_1 1
#endif

/* NDIS HD split capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_CAPS_SUPPORTS_HEADER_DATA_SPLIT       0x00000001L
    #define NDIS_HD_SPLIT_CAPS_SUPPORTS_IPV4_OPTIONS            0x00000002L
    #define NDIS_HD_SPLIT_CAPS_SUPPORTS_IPV6_EXTENSION_HEADERS  0x00000004L
    #define NDIS_HD_SPLIT_CAPS_SUPPORTS_TCP_OPTIONS             0x00000008L
#endif

/* NDIS HD split flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
    #define NDIS_HD_SPLIT_ENABLE_HEADER_DATA_SPLIT  0x00000001L
#endif

/* NDIS power management WOL supported pattern capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_WOL_BITMAP_PATTERN_SUPPORTED            0x00000001L
    #define NDIS_PM_WOL_MAGIC_PACKET_SUPPORTED              0x00000002L
    #define NDIS_PM_WOL_IPV4_TCP_SYN_SUPPORTED              0x00000004L
    #define NDIS_PM_WOL_IPV6_TCP_SYN_SUPPORTED              0x00000008L
    #define NDIS_PM_WOL_IPV4_DEST_ADDR_WILDCARD_SUPPORTED   0x00000200L
    #define NDIS_PM_WOL_IPV6_DEST_ADDR_WILDCARD_SUPPORTED   0x00000800L
    #define NDIS_PM_WOL_EAPOL_REQUEST_ID_MESSAGE_SUPPORTED  0x00010000L
#endif

/* NDIS power management WOL enabled pattern capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_WOL_BITMAP_PATTERN_ENABLED              0x00000001L
    #define NDIS_PM_WOL_MAGIC_PACKET_ENABLED                0x00000002L
    #define NDIS_PM_WOL_IPV4_TCP_SYN_ENABLED                0x00000004L
    #define NDIS_PM_WOL_IPV6_TCP_SYN_ENABLED                0x00000008L
    #define NDIS_PM_WOL_IPV4_DEST_ADDR_WILDCARD_ENABLED     0x00000200L
    #define NDIS_PM_WOL_IPV6_DEST_ADDR_WILDCARD_ENABLED     0x00000800L
    #define NDIS_PM_WOL_EAPOL_REQUEST_ID_MESSAGE_ENABLED    0x00010000L
#endif

/* NDIS power management WOL priority values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_WOL_PRIORITY_LOWEST     0xFFFFFFFFL
    #define NDIS_PM_WOL_PRIORITY_NORMAL     0x10000000L
    #define NDIS_PM_WOL_PRIORITY_HIGHEST    0x00000001L
#endif

/* NDIS power management protocol supported offload capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_PROTOCOL_OFFLOAD_ARP_SUPPORTED              0x00000001L
    #define NDIS_PM_PROTOCOL_OFFLOAD_NS_SUPPORTED               0x00000002L
    #define NDIS_PM_PROTOCOL_OFFLOAD_80211_RSN_REKEY_SUPPORTED  0x00000080L
#endif

/* NDIS power management protocol enabled offload capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_PROTOCOL_OFFLOAD_ARP_ENABLED                0x00000001L
    #define NDIS_PM_PROTOCOL_OFFLOAD_NS_ENABLED                 0x00000002L
    #define NDIS_PM_PROTOCOL_OFFLOAD_80211_RSN_REKEY_ENABLED    0x00000080L
#endif

/* NDIS power management protocol offload priority values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_PROTOCOL_OFFLOAD_PRIORITY_LOWEST    0xFFFFFFFFL
    #define NDIS_PM_PROTOCOL_OFFLOAD_PRIORITY_NORMAL    0x10000000L
    #define NDIS_PM_PROTOCOL_OFFLOAD_PRIORITY_HIGHEST   0x00000001L
#endif

/* NDIS power management wakeup flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_WAKE_ON_LINK_CHANGE_ENABLED 0x00000001L
#endif

/* NDIS power management maximum string size */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_MAX_STRING_SIZE 64
#endif

/* NDIS power management capabilities revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_CAPABILITIES_REVISION_1 1
#endif

/* NDIS power management parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_PARAMETERS_REVISION_1   1
#endif

/* EAPOL request identifier WOL flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define EAPOL_REQUEST_ID_WOL_FLAG_MUST_ENCRYPT  0x00000001L
#endif

/* NDIS power management pattern identifier special values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_MAX_PATTERN_ID      0x0000FFFFL
    #define NDIS_PM_PRIVATE_PATTERN_ID  0x00000001L
#endif

/* NDIS power management WOL pattern revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_WOL_PATTERN_REVISION_1  1
#endif

/* 802.11 RSN handshake parameter lengths */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define DOT11_RSN_KEK_LENGTH    16
    #define DOT11_RSN_KCK_LENGTH    16
#endif

/* NDIS power management protocol offload revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_PM_PROTOCOL_OFFLOAD_REVISION_1 1
#endif

/* NDIS WMI power management administrator configuration revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_WMI_PM_ADMIN_CONFIG_REVISION_1 1
#endif

/* NDIS WMI power management active capabilities revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_WMI_PM_ACTIVE_CAPABILITIES_REVISION_1  1
#endif

/* NDIS receive filter supported header flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_SUPPORTED    0x00000001L
#endif

/* NDIS receive filter supported MAC header field flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_DEST_ADDR_SUPPORTED      0x00000001L
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_SOURCE_ADDR_SUPPORTED    0x00000002L
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_PROTOCOL_SUPPORTED       0x00000004L
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_VLAN_ID_SUPPORTED        0x00000008L
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_PRIORITY_SUPPORTED       0x00000010L
#endif

/* NDIS receive filter supported filter test flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_TEST_HEADER_FIELD_EQUAL_SUPPORTED       0x00000001L
    #define NDIS_RECEIVE_FILTER_TEST_HEADER_FIELD_MASK_EQUAL_SUPPORTED  0x00000002L
#endif

/* NDIS receive filter supported queue property flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_MSI_X_SUPPORTED             0x00000001L
    #define NDIS_RECEIVE_FILTER_VM_QUEUE_SUPPORTED          0x00000002L
    #define NDIS_RECEIVE_FILTER_LOOKAHEAD_SPLIT_SUPPORTED   0x00000004L
#endif

/* NDIS receive filter enabled filter type flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_VMQ_FILTERS_ENABLED 0x00000001L
#endif

/* NDIS receive filter enabled queue type flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_VM_QUEUES_ENABLED   0x00000001L
#endif

/* NDIS receive filter capabilities revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_CAPABILITIES_REVISION_1 1
#endif

/* NDIS NIC switch capabilities revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_NIC_SWITCH_CAPABILITIES_REVISION_1 1
#endif

/* NDIS receive filter global parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_GLOBAL_PARAMETERS_REVISION_1    1
#endif

/* NDIS identifier default values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_DEFAULT_RECEIVE_QUEUE_ID       0L
    #define NDIS_DEFAULT_RECEIVE_QUEUE_GROUP_ID 0L
    #define NDIS_DEFAULT_RECEIVE_FILTER_ID      0L
#endif

/* NDIS receive filter field flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_MAC_HEADER_VLAN_UNTAGGED_OR_ZERO    0x00000001L
#endif

/* NDIS receive filter field parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_FIELD_PARAMETERS_REVISION_1 1
#endif

/* NDIS receive filter parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_PARAMETERS_REVISION_1   1
#endif

/* NDIS receive filter clear parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_CLEAR_PARAMETERS_REVISION_1 1
#endif

/* NDIS receive queue parameters flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_PER_QUEUE_RECEIVE_INDICATION  0x00000001L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_LOOKAHEAD_SPLIT_REQUIRED      0x00000002L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_FLAGS_CHANGED                 0x00010000L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_PROCESSOR_AFFINITY_CHANGED    0x00020000L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_SUGGESTED_RECV_BUFFER_NUMBERS_CHANGED 0x00040000L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_NAME_CHANGED                  0x00080000L
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_CHANGE_MASK                   0xFFFF0000L
#endif

/* NDIS receive queue parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_PARAMETERS_REVISION_1    1
#endif

/* NDIS receive queue free parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_FREE_PARAMETERS_REVISION_1   1
#endif

/* NDIS receive queue information revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_INFO_REVISION_1  1
#endif

/* NDIS receive queue information array revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_INFO_ARRAY_REVISION_1    1
#endif

/* NDIS receive filter information array revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_FILTER_INFO_ARRAY_REVISION_1   1
#endif

/* NDIS receive queue allocation complete parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_PARAMETERS_REVISION_1    1
#endif

/* NDIS receive queue allocation complete array revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_ARRAY_REVISION_1 1
#endif

/* NDIS receive scale capabilities revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RECEIVE_SCALE_CAPABILITIES_REVISION_1  1
#endif

/* NDIS receive scale capability flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RSS_CAPS_MESSAGE_SIGNALED_INTERRUPTS   0x01000000L
    #define NDIS_RSS_CAPS_CLASSIFICATION_AT_ISR         0x02000000L
    #define NDIS_RSS_CAPS_CLASSIFICATION_AT_DPC         0x04000000L
    #if NDIS_SUPPORT_NDIS620
        #define NDIS_RSS_CAPS_USING_MSI_X               0x08000000L
    #endif
    #define NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV4            0x00000100L
    #define NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV6            0x00000200L
    #define NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV6_EX         0x00000400L
#endif

/* NDIS hash functions */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NdisHashFunctionToeplitz    0x00000001L
    #define NDIS_HASH_FUNCTION_MASK     0x000000FFL
    #define NDIS_HASH_TYPE_MASK         0x00FFFF00L
#endif

/* Macros to manipulate hash information */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RSS_HASH_FUNC_FROM_HASH_INFO( x ) \
        ((x) & NDIS_HASH_FUNCTION_MASK)
    #define NDIS_RSS_HASH_TYPE_FROM_HASH_INFO( x ) \
        ((x) & NDIS_HASH_TYPE_MASK)
    #define NDIS_RSS_HASH_INFO_FROM_TYPE_AND_FUNC( p1, p2 ) \
        ((p1) | (p2))
#endif

/* NDIS hash types */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_HASH_IPV4          0x00000100L
    #define NDIS_HASH_TCP_IPV4      0x00000200L
    #define NDIS_HASH_IPV6          0x00000400L
    #define NDIS_HASH_IPV6_EX       0x00000800L
    #define NDIS_HASH_TCP_IPV6      0x00001000L
    #define NDIS_HASH_TCP_IPV6_EX   0x00002000L
#endif

/* Unchanged parameter flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RSS_PARAM_FLAG_BASE_CPU_UNCHANGED  0x0001
    #define NDIS_RSS_PARAM_FLAG_HASH_INFO_UNCHANGED 0x0002
    #define NDIS_RSS_PARAM_FLAG_ITABLE_UNCHANGED    0x0004
    #define NDIS_RSS_PARAM_FLAG_HASH_KEY_UNCHANGED  0x0008
    #define NDIS_RSS_PARAM_FLAG_DISABLE_RSS         0x0010
#endif

/* Sizes */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RSS_INDIRECTION_TABLE_SIZE_REVISION_1  128
    #define NDIS_RSS_HASH_SECRET_KEY_SIZE_REVISION_1    40
#endif

/* NDIS receive scale parameters revision numbers */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RECEIVE_SCALE_PARAMETERS_REVISION_1        1
    #if NDIS_SUPPORT_NDIS620
        #define NDIS_RECEIVE_SCALE_PARAMETERS_REVISION_2    2
    #endif
#endif

/* Maximum sizes */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RSS_INDIRECTION_TABLE_MAX_SIZE_REVISION_1      128
    #define NDIS_RSS_HASH_SECRET_KEY_MAX_SIZE_REVISION_1        40
    #if NDIS_SUPPORT_NDIS620
        #define NDIS_RSS_INDIRECTION_TABLE_MAX_SIZE_REVISION_2  \
            (128 * sizeof( PROCESSOR_NUMBER ))
        #define NDIS_RSS_HASH_SECRET_KEY_MAX_SIZE_REVISION_2    40
    #endif
#endif

/* NDIS receive hash flags */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RECEIVE_HASH_FLAG_ENABLE_HASH          0x00000001L
    #define NDIS_RECEIVE_HASH_FLAG_HASH_INFO_UNCHANGED  0x00000002L
    #define NDIS_RECEIVE_HASH_FLAG_HASH_KEY_UNCHANGED   0x00000004L
#endif

/* NDIS receive hash parameters revision number */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    #define NDIS_RECEIVE_HASH_PARAMETERS_REVISION_1 1
#endif

/* NDIS RSS processor information revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_RSS_PROCESSOR_INFO_REVISION_1  1
#endif

/* NDIS system processor information (extended version) revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_SYSTEM_PROCESSOR_INFO_EX_REVISION_1    1
#endif

/* NDIS hypervisor information flags */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_HYPERVISOR_INFO_FLAG_HYPERVISOR_PRESENT    0x00000001L
#endif

/* NDIS hypervisor information revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_HYPERVISOR_INFO_REVISION_1 1
#endif

/* NDIS WMI receive queue parameters revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_WMI_RECEIVE_QUEUE_PARAMETERS_REVISION_1    1
#endif

/* NDIS WMI receive queue information revision number */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
    #define NDIS_WMI_RECEIVE_QUEUE_INFO_REVISION_1  1
#endif

/* NDIS statistics value */
typedef struct _NDIS_STATISTICS_VALUE {
    NDIS_OID    Oid;
    ULONG       DataLength;
    UCHAR       Data[1];
} NDIS_STATISTICS_VALUE;
typedef NDIS_STATISTICS_VALUE   *PNDIS_STATISTICS_VALUE;

/* NDIS statistics value (extended version) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_STATISTICS_VALUE_EX {
    NDIS_OID    Oid;
    ULONG       DataLength;
    ULONG       Length;
    UCHAR       Data[1];
} NDIS_STATISTICS_VALUE_EX;
typedef NDIS_STATISTICS_VALUE_EX    *PNDIS_STATISTICS_VALUE_EX;
#endif

/* NDIS variable data description */
typedef struct _NDIS_VAR_DATA_DESC {
    USHORT      Length;
    USHORT      MaximumLength;
    ULONG_PTR   Offset;
} NDIS_VAR_DATA_DESC;
typedef NDIS_VAR_DATA_DESC  *PNDIS_VAR_DATA_DESC;

/* NDIS object header */
typedef struct _NDIS_OBJECT_HEADER {
    UCHAR   Type;
    UCHAR   Revision;
    USHORT  Size;
} NDIS_OBJECT_HEADER;
typedef NDIS_OBJECT_HEADER  *PNDIS_OBJECT_HEADER;

/* NDIS statistics information */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_STATISTICS_INFO {
    NDIS_OBJECT_HEADER  Header;
    ULONG               SupportedStatistics;
    ULONG64             ifInDiscards;
    ULONG64             ifInErrors;
    ULONG64             ifHCInOctets;
    ULONG64             ifHCInUcastPkts;
    ULONG64             ifHCInMulticastPkts;
    ULONG64             ifHCInBroadcastPkts;
    ULONG64             ifHCOutOctets;
    ULONG64             ifHCOutUcastPkts;
    ULONG64             ifHCOutMulticastPkts;
    ULONG64             ifHCOutBroadcastPkts;
    ULONG64             ifOutErrors;
    ULONG64             ifOutDiscards;
    ULONG64             ifHCInUcastOctets;
    ULONG64             ifHCInMulticastOctets;
    ULONG64             ifHCInBroadcastOctets;
    ULONG64             ifHCOutUcastOctets;
    ULONG64             ifHCOutMulticastOctets;
    ULONG64             ifHCOutBroadcastOctets;
} NDIS_STATISTICS_INFO;
typedef NDIS_STATISTICS_INFO    *PNDIS_STATISTICS_INFO;
#endif

/* NDIS interrupt moderation values */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_INTERRUPT_MODERATION {
    NdisInterruptModerationUnknown      = 0,
    NdisInterruptModerationNotSupported = 1,
    NdisInterruptModerationEnabled      = 2,
    NdisInterruptModerationDisabled     = 3
} NDIS_INTERRUPT_MODERATION;
typedef NDIS_INTERRUPT_MODERATION   *PNDIS_INTERRUPT_MODERATION;
#endif

/* NDIS interrupt moderation parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_INTERRUPT_MODERATION_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_INTERRUPT_MODERATION   InterruptModeration;
} NDIS_INTERRUPT_MODERATION_PARAMETERS;
typedef NDIS_INTERRUPT_MODERATION_PARAMETERS    *PNDIS_INTERRUPT_MODERATION_PARAMETERS;
#endif

/* NDIS timeout deferred procedure call request capabilities */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               TimeoutArrayLength;
    ULONG               TimeoutArray[1];
} NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES;
typedef NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES   *PNDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES;
#endif

/* NDIS PCI device custom properties */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PCI_DEVICE_CUSTOM_PROPERTIES {
    NDIS_OBJECT_HEADER  Header;
    UINT32              DeviceType;
    UINT32              CurrentSpeedAndMode;
    UINT32              CurrentPayloadSize;
    UINT32              MaxPayloadSize;
    UINT32              MaxReadRequestSize;
    UINT32              CurrentLinkSpeed;
    UINT32              CurrentLinkWidth;
    UINT32              MaxLinkSpeed;
    UINT32              MaxLinkWidth;
#if (NTDDI_VERSION >= 0x06010000) || NDIS_SUPPORT_NDIS620
    UINT32              PciExpressVersion;
    UINT32              InterruptType;
    UINT32              MaxInterruptMessages;
#endif
} NDIS_PCI_DEVICE_CUSTOM_PROPERTIES;
typedef NDIS_PCI_DEVICE_CUSTOM_PROPERTIES   *PNDIS_PCI_DEVICE_CUSTOM_PROPERTIES;
#endif

/* NDIS 802.11 status types */
typedef enum _NDIS_802_11_STATUS_TYPE {
    Ndis802_11StatusType_Authentication         = 0,
    Ndis802_11StatusType_MediaStreamMode        = 1,
    Ndis802_11StatusType_PMKID_CandidateList    = 2,
    Ndis802_11StatusTypeMax                     = 3
} NDIS_802_11_STATUS_TYPE;
typedef NDIS_802_11_STATUS_TYPE *PNDIS_802_11_STATUS_TYPE;

/* NDIS 802.11 MAC address */
typedef UCHAR   NDIS_802_11_MAC_ADDRESS[6];

/* NDIS 802.11 status indication */
typedef struct _NDIS_802_11_STATUS_INDICATION {
    NDIS_802_11_STATUS_TYPE StatusType;
} NDIS_802_11_STATUS_INDICATION;
typedef NDIS_802_11_STATUS_INDICATION   *PNDIS_802_11_STATUS_INDICATION;

/* NDIS 802.11 authentication request */
typedef struct _NDIS_802_11_AUTHENTICATION_REQUEST {
    ULONG                   Length;
    NDIS_802_11_MAC_ADDRESS Bssid;
    ULONG                   Flags;
} NDIS_802_11_AUTHENTICATION_REQUEST;
typedef NDIS_802_11_AUTHENTICATION_REQUEST  *PNDIS_802_11_AUTHENTICATION_REQUEST;

/* PMKID candidate */
typedef struct _PMKID_CANDIDATE {
    NDIS_802_11_MAC_ADDRESS BSSID;
    ULONG                   Flags;
} PMKID_CANDIDATE;
typedef PMKID_CANDIDATE *PPMKID_CANDIDATE;

/* NDIS 802.11 PMKID candidate list */
typedef struct _NDIS_802_11_PMKID_CANDIDATE_LIST {
    ULONG           Version;
    ULONG           NumCandidates;
    PMKID_CANDIDATE CandidateList[1];
} NDIS_802_11_PMKID_CANDIDATE_LIST;
typedef NDIS_802_11_PMKID_CANDIDATE_LIST    *PNDIS_802_11_PMKID_CANDIDATE_LIST;

/* NDIS 802.11 network types */
typedef enum _NDIS_802_11_NETWORK_TYPE {
    Ndis802_11FH                = 0,
    Ndis802_11DS                = 1,
    Ndis802_11OFDM5             = 2,
    Ndis802_11OFDM24            = 3,
    Ndis802_11Automode          = 4,
    Ndis802_11NetworkTypeMax    = 5
} NDIS_802_11_NETWORK_TYPE;
typedef NDIS_802_11_NETWORK_TYPE    *PNDIS_802_11_NETWORK_TYPE;

/* NDIS 802.11 network type list */
typedef struct _NDIS_802_11_NETWORK_TYPE_LIST {
    ULONG                       NumberOfItems;
    NDIS_802_11_NETWORK_TYPE    NetworkType[1];
} NDIS_802_11_NETWORK_TYPE_LIST;
typedef NDIS_802_11_NETWORK_TYPE_LIST   *PNDIS_802_11_NETWORK_TYPE_LIST;

/* NDIS 802.11 power modes */
typedef enum _NDIS_802_11_POWER_MODE {
    Ndis802_11PowerModeCAM      = 0,
    Ndis802_11PowerModeMAX_PSP  = 1,
    Ndis802_11PowerModeFast_PSP = 2,
    Ndis802_11PowerModeMax      = 3
} NDIS_802_11_POWER_MODE;
typedef NDIS_802_11_POWER_MODE  *PNDIS_802_11_POWER_MODE;

/* NDIS 802.11 frequency hopping configuration */
typedef struct _NDIS_802_11_CONFIGURATION_FH {
    ULONG   Length;
    ULONG   HopPattern;
    ULONG   HopSet;
    ULONG   DwellTime;
} NDIS_802_11_CONFIGURATION_FH;
typedef NDIS_802_11_CONFIGURATION_FH    *PNDIS_802_11_CONFIGURATION_FH;

/* NDIS 802.11 configuration */
typedef struct _NDIS_802_11_CONFIGURATION {
    ULONG                           Length;
    ULONG                           BeaconPeriod;
    ULONG                           ATIMWindow;
    ULONG                           DSConfig;
    NDIS_802_11_CONFIGURATION_FH    FHConfig;
} NDIS_802_11_CONFIGURATION;
typedef NDIS_802_11_CONFIGURATION   *PNDIS_802_11_CONFIGURATION;

/* NDIS 802.11 statistics */
typedef struct _NDIS_802_11_STATISTICS {
    ULONG           Length;
    LARGE_INTEGER   TransmittedFragmentCount;
    LARGE_INTEGER   MulticastTransmittedFrameCount;
    LARGE_INTEGER   FailedCount;
    LARGE_INTEGER   RetryCount;
    LARGE_INTEGER   MultipleRetryCount;
    LARGE_INTEGER   RTSSuccessCount;
    LARGE_INTEGER   RTSFailureCount;
    LARGE_INTEGER   ACKFailureCount;
    LARGE_INTEGER   FrameDuplicateCount;
    LARGE_INTEGER   ReceivedFragmentCount;
    LARGE_INTEGER   MulticastReceivedFrameCount;
    LARGE_INTEGER   FCSErrorCount;
    LARGE_INTEGER   TKIPLocalMICFailures;
    LARGE_INTEGER   TKIPICVErrorCount;
    LARGE_INTEGER   TKIPCounterMeasuresInvoked;
    LARGE_INTEGER   TKIPReplays;
    LARGE_INTEGER   CCMPFormatErrors;
    LARGE_INTEGER   CCMPReplays;
    LARGE_INTEGER   CCMPDecryptErrors;
    LARGE_INTEGER   FourWayHandshakeFailures;
    LARGE_INTEGER   WEPUndecryptableCount;
    LARGE_INTEGER   WEPICVErrorCount;
    LARGE_INTEGER   DecryptSuccessCount;
    LARGE_INTEGER   DecryptFailureCount;
} NDIS_802_11_STATISTICS;
typedef NDIS_802_11_STATISTICS  *PNDIS_802_11_STATISTICS;

/* NDIS 802.11 key */
typedef struct _NDIS_802_11_KEY {
    ULONG                   Length;
    ULONG                   KeyIndex;
    ULONG                   KeyLength;
    NDIS_802_11_MAC_ADDRESS BSSID;
    NDIS_802_11_KEY_RSC     KeyRSC;
    UCHAR                   KeyMaterial[1];
} NDIS_802_11_KEY;
typedef NDIS_802_11_KEY *PNDIS_802_11_KEY;

/* NDIS 802.11 remove key */
typedef struct _NDIS_802_11_REMOVE_KEY {
    ULONG                   Length;
    ULONG                   KeyIndex;
    NDIS_802_11_MAC_ADDRESS BSSID;
} NDIS_802_11_REMOVE_KEY;
typedef NDIS_802_11_REMOVE_KEY  *PNDIS_802_11_REMOVE_KEY;

/* NDIS 802.11 WEP */
typedef struct _NDIS_802_11_WEP {
    ULONG   Length;
    ULONG   KeyIndex;
    ULONG   KeyLength;
    UCHAR   KeyMaterial[1];
} NDIS_802_11_WEP;
typedef NDIS_802_11_WEP *PNDIS_802_11_WEP;

/* NDIS 802.11 network infrastructures */
typedef enum _NDIS_802_11_NETWORK_INFRASTRUCTURE {
    Ndis802_11IBSS              = 0,
    Ndis802_11Infrastructure    = 1,
    Ndis802_11AutoUnknown       = 2,
    Ndis802_11InfrastructureMax = 3
} NDIS_802_11_NETWORK_INFRASTRUCTURE;
typedef NDIS_802_11_NETWORK_INFRASTRUCTURE  *PNDIS_802_11_NETWORK_INFRASTRUCTURE;

/* NDIS 802.11 authentication modes */
typedef enum _NDIS_802_11_AUTHENTICATION_MODE {
    Ndis802_11AuthModeOpen          = 0,
    Ndis802_11AuthModeShared        = 1,
    Ndis802_11AuthModeAuthSwitch    = 2,
    Ndis802_11AuthModeWPA           = 3,
    Ndis802_11AuthModeWPAPSK        = 4,
    Ndis802_11AuthModeWPANone       = 5,
    Ndis802_11AuthModeWPA2          = 6,
    Ndis802_11AuthModeWPA2PSK       = 7,
    Ndis802_11AuthModeMax           = 8
} NDIS_802_11_AUTHENTICATION_MODE;
typedef NDIS_802_11_AUTHENTICATION_MODE *PNDIS_802_11_AUTHENTICATION_MODE;

/* NDIS 802.11 rates */
typedef UCHAR   NDIS_802_11_RATES[NDIS_802_11_LENGTH_RATES];
typedef UCHAR   NDIS_802_11_RATES_EX[NDIS_802_11_LENGTH_RATES_EX];

/* NDIS 802.11 SSID */
typedef struct _NDIS_802_11_SSID {
    ULONG   SsidLength;
    UCHAR   Ssid[NDIS_802_11_LENGTH_SSID];
} NDIS_802_11_SSID;
typedef NDIS_802_11_SSID    *PNDIS_802_11_SSID;

/* NDIS WLAN BSSID */
typedef struct _NDIS_WLAN_BSSID {
    ULONG                               Length;
    NDIS_802_11_MAC_ADDRESS             MacAddress;
    UCHAR                               Reserved[2];
    NDIS_802_11_SSID                    Ssid;
    ULONG                               Privacy;
    NDIS_802_11_RSSI                    Rssi;
    NDIS_802_11_NETWORK_TYPE            NetworkTypeInUse;
    NDIS_802_11_CONFIGURATION           Configuration;
    NDIS_802_11_NETWORK_INFRASTRUCTURE  InfrastructureMode;
    NDIS_802_11_RATES                   SupportedRates;
} NDIS_WLAN_BSSID;
typedef NDIS_WLAN_BSSID *PNDIS_WLAN_BSSID;

/* NDIS 802.11 BSSID list */
typedef struct _NDIS_802_11_BSSID_LIST {
    ULONG           NumberOfItems;
    NDIS_WLAN_BSSID Bssid[1];
} NDIS_802_11_BSSID_LIST;
typedef NDIS_802_11_BSSID_LIST  *PNDIS_802_11_BSSID_LIST;

/* NDIS WLAN BSSID (extended version) */
typedef struct _NDIS_WLAN_BSSID_EX {
    ULONG                               Length;
    NDIS_802_11_MAC_ADDRESS             MacAddress;
    UCHAR                               Reserved[2];
    NDIS_802_11_SSID                    Ssid;
    ULONG                               Privacy;
    NDIS_802_11_RSSI                    Rssi;
    NDIS_802_11_NETWORK_TYPE            NetworkTypeInUse;
    NDIS_802_11_CONFIGURATION           Configuration;
    NDIS_802_11_NETWORK_INFRASTRUCTURE  InfrastructureMode;
    NDIS_802_11_RATES_EX                SupportedRates;
    ULONG                               IELength;
    UCHAR                               IEs[1];
} NDIS_WLAN_BSSID_EX;
typedef NDIS_WLAN_BSSID_EX  *PNDIS_WLAN_BSSID_EX;

/* NDIS 802.11 BSSID list (extended version) */
typedef struct _NDIS_802_11_BSSID_LIST_EX {
    ULONG           NumberOfItems;
    NDIS_WLAN_BSSID Bssid[1];
} NDIS_802_11_BSSID_LIST_EX;
typedef NDIS_802_11_BSSID_LIST_EX   *PNDIS_802_11_BSSID_LIST_EX;

/* NDIS 802.11 fixed information elements */
typedef struct _NDIS_802_11_FIXED_IEs {
    UCHAR   Timestamp[8];
    USHORT  BeaconInterval;
    USHORT  Capabilities;
} NDIS_802_11_FIXED_IEs;
typedef NDIS_802_11_FIXED_IEs   *PNDIS_802_11_FIXED_IEs;

/* NDIS 802.11 variable information elements */
typedef struct _NDIS_802_11_VARIABLE_IEs {
    UCHAR   ElementID;
    UCHAR   Length;
    UCHAR   data[1];
} NDIS_802_11_VARIABLE_IEs;
typedef NDIS_802_11_VARIABLE_IEs    *PNDIS_802_11_VARIABLE_IEs;

/* NDIS 802.11 privacy filters */
typedef enum _NDIS_802_11_PRIVACY_FILTER {
    Ndis802_11PrivFilterAcceptAll   = 0,
    Ndis802_11PrivFilter8021xWEP    = 1
} NDIS_802_11_PRIVACY_FILTER;
typedef NDIS_802_11_PRIVACY_FILTER  *PNDIS_802_11_PRIVACY_FILTER;

/* NDIS 802.11 WEP status values */
typedef enum _NDIS_802_11_WEP_STATUS {
    Ndis802_11WEPEnabled                = 0,
    Ndis802_11Encryption1Enabled        = Ndis802_11WEPEnabled,
    Ndis802_11WEPDisabled               = 1,
    Ndis802_11EncryptionDisabled        = Ndis802_11WEPDisabled,
    Ndis802_11WEPKeyAbsent              = 2,
    Ndis802_11Encryption1KeyAbsent      = Ndis802_11WEPKeyAbsent,
    Ndis802_11WEPNotSupported           = 3,
    Ndis802_11EncryptionNotSupported    = Ndis802_11WEPNotSupported,
    Ndis802_11Encryption2Enabled        = 4,
    Ndis802_11Encryption2KeyAbsent      = 5,
    Ndis802_11Encryption3Enabled        = 6,
    Ndis802_11Encryption3KeyAbsent      = 7
} NDIS_802_11_WEP_STATUS;
typedef NDIS_802_11_WEP_STATUS  *PNDIS_802_11_WEP_STATUS;
typedef NDIS_802_11_WEP_STATUS  NDIS_802_11_ENCRYPTION_STATUS;
typedef NDIS_802_11_WEP_STATUS  *PNDIS_802_11_ENCRYPTION_STATUS;

/* NDIS 802.11 reload defaults */
typedef enum _NDIS_802_11_RELOAD_DEFAULTS {
    Ndis802_11ReloadWEPKeys = 0
} NDIS_802_11_RELOAD_DEFAULTS;
typedef NDIS_802_11_RELOAD_DEFAULTS *PNDIS_802_11_RELOAD_DEFAULTS;

/* NDIS 802.11 associatin information request fixed information elements */
typedef struct _NDIS_802_11_AI_REQFI {
    USHORT                  Capabilities;
    USHORT                  ListenInterval;
    NDIS_802_11_MAC_ADDRESS CurrentAPAddress;
} NDIS_802_11_AI_REQFI;
typedef NDIS_802_11_AI_REQFI    *PNDIS_802_11_AI_REQFI;

/* NDIS 802.11 association information response fixed information elements */
typedef struct _NDIS_802_11_AI_RESFI {
    USHORT  Capabilities;
    USHORT  StatusCode;
    USHORT  AssociationId;
} NDIS_802_11_AI_RESFI;
typedef NDIS_802_11_AI_RESFI    *PNDIS_802_11_AI_RESFI;

/* NDIS 802.11 association information */
typedef struct _NDIS_802_11_ASSOCIATION_INFORMATION {
    ULONG                   Length;
    USHORT                  AvailableRequestFixedIEs;
    NDIS_802_11_AI_REQFI    RequestFixedIEs;
    ULONG                   RequestIELength;
    ULONG                   OffsetRequestIEs;
    USHORT                  AvailableResponseFixedIEs;
    NDIS_802_11_AI_RESFI    ResponseFixedIEs;
    ULONG                   ResponseIELength;
    ULONG                   OffsetResponseIEs;
} NDIS_802_11_ASSOCIATION_INFORMATION;
typedef NDIS_802_11_ASSOCIATION_INFORMATION *PNDIS_802_11_ASSOCIATION_INFORMATION;

/* NDIS 802.11 authentication event */
typedef struct _NDIS_802_11_AUTHENTICATION_EVENT {
    NDIS_802_11_STATUS_INDICATION       Status;
    NDIS_802_11_AUTHENTICATION_REQUEST  Request[1];
} NDIS_802_11_AUTHENTICATION_EVENT;
typedef NDIS_802_11_AUTHENTICATION_EVENT    *PNDIS_802_11_AUTHENTICATION_EVENT;

/* NDIS 802.11 test */
typedef struct _NDIS_802_11_TEST {
    ULONG   Length;
    ULONG   Type;
    union {
        NDIS_802_11_AUTHENTICATION_EVENT    AuthenticationEvent;
        NDIS_802_11_RSSI                    RssiTrigger;
    };
} NDIS_802_11_TEST;
typedef NDIS_802_11_TEST    *PNDIS_802_11_TEST;

/* NDIS 802.11 media stream modes */
typedef enum _NDIS_802_11_MEDIA_STREAM_MODE {
    Ndis802_11MediaStreamOff    = 0,
    Ndis802_11MediaStreamOn     = 1
} NDIS_802_11_MEDIA_STREAM_MODE;
typedef NDIS_802_11_MEDIA_STREAM_MODE   *PNDIS_802_11_MEDIA_STREAM_MODE;

/* NDIS 802.11 PMKID value */
typedef UCHAR   NDIS_802_11_PMKID_VALUE[16];

/* BSSID information */
typedef struct _BSSID_INFO {
    NDIS_802_11_MAC_ADDRESS BSSID;
    NDIS_802_11_PMKID_VALUE PMKID;
} BSSID_INFO;
typedef BSSID_INFO  *PBSSID_INFO;

/* NDIS 802.11 PMKID */
typedef struct _NDIS_802_11_PMKID {
    ULONG       Length;
    ULONG       BSSIDInfoCount;
    BSSID_INFO  BSSIDInfo[1];
} NDIS_802_11_PMKID;
typedef NDIS_802_11_PMKID   *PNDIS_802_11_PMKID;

/* NDIS 802.11 authentication encryption */
typedef struct _NDIS_802_11_AUTHENTICATION_ENCRYPTION {
    NDIS_802_11_AUTHENTICATION_MODE AuthModeSupported;
    NDIS_802_11_ENCRYPTION_STATUS   EncryptStatusSupported;
} NDIS_802_11_AUTHENTICATION_ENCRYPTION;
typedef NDIS_802_11_AUTHENTICATION_ENCRYPTION   *PNDIS_802_11_AUTHENTICATION_ENCRYPTION;

/* NDIS 802.11 capability */
typedef struct _NDIS_802_11_CAPABILITY {
    ULONG                                   Length;
    ULONG                                   Version;
    ULONG                                   NoOfPMKIDs;
    ULONG                                   NoOfAuthEncryptPairsSupported;
    NDIS_802_11_AUTHENTICATION_ENCRYPTION   AuthenticationEncryptionSupported[1];
} NDIS_802_11_CAPABILITY;
typedef NDIS_802_11_CAPABILITY *PNDIS_802_11_CAPABILITY;

/* NDIS 802.11 non-broadcast SSID list */
typedef struct _NDIS_802_11_NON_BCAST_SSID_LIST {
    ULONG               NumberOfItems;
    NDIS_802_11_SSID    Non_Bcast_Ssid[1];
} NDIS_802_11_NON_BCAST_SSID_LIST;
typedef NDIS_802_11_NON_BCAST_SSID_LIST *PNDIS_802_11_NON_BCAST_SSID_LIST;

/* NDIS 802.11 radio status values */
typedef enum _NDIS_802_11_RADIO_STATUS {
    Ndis802_11RadioStatusOn                     = 1,
    Ndis802_11RadioStatusHardwareOff            = 2,
    Ndis802_11RadioStatusSoftwareOff            = 3,
    Ndis802_11RadioStatusHardwareSoftwareOff    = 4,
    Ndis802_11RadioStatusMax                    = 5
} NDIS_802_11_RADIO_STATUS;
typedef NDIS_802_11_RADIO_STATUS    *PNDIS_802_11_RADIO_STATUS;

/* NDIS CO device profile */
typedef struct NDIS_CO_DEVICE_PROFILE {
    NDIS_VAR_DATA_DESC  DeviceDescription;
    NDIS_VAR_DATA_DESC  DevSpecificInfo;
    ULONG               ulTAPISupplementaryPassThru;
    ULONG               ulAddressModes;
    ULONG               ulNumAddresses;
    ULONG               ulBearerModes;
    ULONG               ulMaxTxRate;
    ULONG               ulMinTxRate;
    ULONG               ulMaxRxRate;
    ULONG               ulMinRxRate;
    ULONG               ulMediaModes;
    ULONG               ulGenerateToneModes;
    ULONG               ulGenerateToneMaxNumFreq;
    ULONG               ulGenerateDigitModes;
    ULONG               ulMonitorToneMaxNumFreq;
    ULONG               ulMonitorToneMaxNumEntries;
    ULONG               ulMonitorDigitModes;
    ULONG               ulGatherDigitsMinTimeout;
    ULONG               ulGatherDigitsMaxTimeout;
    ULONG               ulDevCapFlags;
    ULONG               ulMaxNumActiveCalls;
    ULONG               ulAnswerMode;
    ULONG               ulUUIAcceptSize;
    ULONG               ulUUIAnswerSize;
    ULONG               ulUUIMakeCallSize;
    ULONG               ulUUIDropSize;
    ULONG               ulUUISendUserUserInfoSize;
    ULONG               ulUUICallInfoSize;
} NDIS_CO_DEVICE_PROFILE;
typedef NDIS_CO_DEVICE_PROFILE  *PNDIS_CO_DEVICE_PROFILE;

/* Offload operations */
typedef enum _OFFLOAD_OPERATION_E {
    AUTHENTICATE    = 1,
    ENCRYPT         = 2
} OFFLOAD_OPERATION_E;

/* Offload algorithm information */
typedef struct _OFFLOAD_ALGO_INFO {
    ULONG   algoIdentifier;
    ULONG   algoKeylen;
    ULONG   algoRounds;
} OFFLOAD_ALGO_INFO;
typedef OFFLOAD_ALGO_INFO   *POFFLOAD_ALGO_INFO;

/* Offload conformance algorithms */
typedef enum _OFFLOAD_CONF_ALGO {
    OFFLOAD_IPSEC_CONF_NONE     = 0,
    OFFLOAD_IPSEC_CONF_DES      = 1,
    OFFLOAD_IPSEC_CONF_3_DES    = 3,
    OFFLOAD_IPSEC_CONF_MAX      = 4
} OFFLOAD_CONF_ALGO;

/* Offload integrity algorithms */
typedef enum _OFFLOAD_INTEGRITY_ALGO {
    OFFLOAD_IPSEC_INTEGRITY_NONE    = 0,
    OFFLOAD_IPSEC_INTEGRITY_MD5     = 1,
    OFFLOAD_IPSEC_INTEGRITY_SHA     = 2,
    OFFLOAD_IPSEC_INTEGRITY_MAX     = 3
} OFFLOAD_INTEGRITY_ALGO;

/* Offload security association */
typedef struct _OFFLOAD_SECURITY_ASSOCIATION {
    OFFLOAD_OPERATION_E Operation;
    SPI_TYPE            SPI;
    OFFLOAD_ALGO_INFO   IntegrityAlgo;
    OFFLOAD_ALGO_INFO   ConfAlgo;
    OFFLOAD_ALGO_INFO   Reserved;
} OFFLOAD_SECURITY_ASSOCIATION;
typedef OFFLOAD_SECURITY_ASSOCIATION    *POFFLOAD_SECURITY_ASSOCIATION;

/* Offload IPsec add SA */
typedef struct _OFFLOAD_IPSEC_ADD_SA {
    IPAddr                          SrcAddr;
    IPMask                          SrcMask;
    IPAddr                          DestAddr;
    IPMask                          DestMask;
    ULONG                           Protocol;
    USHORT                          SrcPort;
    USHORT                          DestPort;
    IPAddr                          SrcTunnelAddr;
    IPAddr                          DestTunnelAddr;
    USHORT                          Flags;
    SHORT                           NumSAs;
    OFFLOAD_SECURITY_ASSOCIATION    SecAssoc[OFFLOAD_MAX_SAS];
    HANDLE                          OffloadHandle;
    ULONG                           KeyLen;
    UCHAR                           KeyMat[1];
} OFFLOAD_IPSEC_ADD_SA;
typedef OFFLOAD_IPSEC_ADD_SA    *POFFLOAD_IPSEC_ADD_SA;

/* Offload IPsec remove SA */
typedef struct _OFFLOAD_IPSEC_REMOVE_SA {
    HANDLE  OffloadHandle;
} OFFLOAD_IPSEC_REMOVE_SA;
typedef OFFLOAD_IPSEC_REMOVE_SA *POFFLOAD_IPSEC_REMOVE_SA;

/* UDP encapsulation types */
typedef enum _UDP_ENCAP_TYPE {
    OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_IKE      = 0,
    OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_OTHER    = 1
} UDP_ENCAP_TYPE;
typedef UDP_ENCAP_TYPE  *PUDP_ENCAP_TYPE;

/* Offload IPsec UDP encapsulation type entry */
typedef struct _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY {
    UDP_ENCAP_TYPE  UdpEncapType;
    USHORT          DstEncapPort;
} OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY;
typedef OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY    *POFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY;

/* Offload IPsec add UDP SA */
typedef struct _OFFLOAD_IPSEC_ADD_UDPESP_SA {
    IPAddr                                  SrcAddr;
    IPMask                                  SrcMask;
    IPAddr                                  DstAddr;
    IPMask                                  DstMask;
    ULONG                                   Protocol;
    USHORT                                  SrcPort;
    USHORT                                  DstPort;
    IPAddr                                  SrcTunnelAddr;
    IPAddr                                  DstTunnelAddr;
    USHORT                                  Flags;
    SHORT                                   NumSAs;
    OFFLOAD_SECURITY_ASSOCIATION            SecAssoc[OFFLOAD_MAX_SAS];
    HANDLE                                  OffloadHandle;
    OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY    EncapTypeEntry;
    HANDLE                                  EncapTypeEntryOffldHandle;
    ULONG                                   KeyLen;
    UCHAR                                   KeyMat[1];
} OFFLOAD_IPSEC_ADD_UDPESP_SA;
typedef OFFLOAD_IPSEC_ADD_UDPESP_SA *POFFLOAD_IPSEC_ADD_UDPESP_SA;

/* Offload IPsec delete UDP SA */
typedef struct _OFFLOAD_IPSEC_DELETE_UDPESP_SA {
    HANDLE  OffloadHandle;
    HANDLE  EncapTypeEntryOffldHandle;
} OFFLOAD_IPSEC_DELETE_UDPESP_SA;
typedef OFFLOAD_IPSEC_DELETE_UDPESP_SA  *POFFLOAD_IPSEC_DELETE_UDPESP_SA;

/* NDIS mediums */
typedef enum _NDIS_MEDIUM {
    NdisMedium802_3         = 0,
    NdisMedium802_5         = 1,
    NdisMediumFddi          = 2,
    NdisMediumWan           = 3,
    NdisMediumLocalTalk     = 4,
    NdisMediumDix           = 5,
    NdisMediumArcnetRaw     = 6,
    NdisMediumArcnet878_2   = 7,
    NdisMediumAtm           = 8,
    NdisMediumWirelessWan   = 9,
    NdisMediumIrda          = 10,
    NdisMediumBpc           = 11,
    NdisMediumCoWan         = 12,
    NdisMedium1394          = 13,
    NdisMediumInfiniBand    = 14,
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
    NdisMediumTunnel        = 15,
    NdisMediumNative802_11  = 16,
    NdisMediumLoopback      = 17,
#if (NTDDI_VERSION >= 0x06010000)
    NdisMediumWiMAX         = 18,
    NdisMediumIP            = 19,
    NdisMediumMax           = 20,
#else
    NdisMediumMax           = 18
#endif
#else
    NdisMediumMax           = 15
#endif
} NDIS_MEDIUM;
typedef NDIS_MEDIUM *PNDIS_MEDIUM;

/* NDIS physical mediums */
typedef enum _NDIS_PHYSICAL_MEDIUM {
    NdisPhysicalMediumUnspecified   = 0,
    NdisPhysicalMediumWirelessLan   = 1,
    NdisPhysicalMediumCableModem    = 2,
    NdisPhysicalMediumPhoneLine     = 3,
    NdisPhysicalMediumPowerLine     = 4,
    NdisPhysicalMediumDSL           = 5,
    NdisPhysicalMediumFibreChannel  = 6,
    NdisPhysicalMedium1394          = 7,
    NdisPhysicalMediumWirelessWan   = 8,
    NdisPhysicalMediumNative802_11  = 9,
    NdisPhysicalMediumBluetooth     = 10,
    NdisPhysicalMediumInfiniband    = 11,
    NdisPhysicalMediumWiMax         = 12,
    NdisPhysicalMediumUWB           = 13,
    NdisPhysicalMedium802_3         = 14,
    NdisPhysicalMedium802_5         = 15,
    NdisPhysicalMediumIrda          = 16,
    NdisPhysicalMediumWiredWAN      = 17,
    NdisPhysicalMediumWiredCoWan    = 18,
    NdisPhysicalMediumOther         = 19,
    NdisPhysicalMediumMax           = 20
} NDIS_PHYSICAL_MEDIUM;
typedef NDIS_PHYSICAL_MEDIUM    *PNDIS_PHYSICAL_MEDIUM;

/* Transport header offset */
typedef struct _TRANSPORT_HEADER_OFFSET {
    USHORT  ProtocolType;
    USHORT  HeaderOffset;
} TRANSPORT_HEADER_OFFSET;
typedef TRANSPORT_HEADER_OFFSET *PTRANSPORT_HEADER_OFFSET;

/* Network address */
typedef struct _NETWORK_ADDRESS {
    USHORT  AddressLength;
    USHORT  AddressType;
    UCHAR   Address[1];
} NETWORK_ADDRESS;
typedef NETWORK_ADDRESS *PNETWORK_ADDRESS;

/* Network address list */
typedef struct _NETWORK_ADDRESS_LIST {
    LONG            AddressCount;
    USHORT          AddressType;
    NETWORK_ADDRESS Address[1];
} NETWORK_ADDRESS_LIST;
typedef NETWORK_ADDRESS_LIST    *PNETWORK_ADDRESS_LIST;

/* IP network address */
typedef struct _NETWORK_ADDRESS_IP {
    USHORT  sin_port;
    ULONG   in_addr;
    UCHAR   sin_zero[8];
} NETWORK_ADDRESS_IP;
typedef NETWORK_ADDRESS_IP  *PNETWORK_ADDRESS_IP;

/* IPX network address */
typedef struct _NETWORK_ADDRESS_IPX {
    ULONG   NetworkAddress;
    UCHAR   NodeAddress[6];
    USHORT  Socket;
} NETWORK_ADDRESS_IPX;
typedef NETWORK_ADDRESS_IPX *PNETWORK_ADDRESS_IPX;

/* NDIS hardware status values */
typedef enum _NDIS_HARDWARE_STATUS {
    NdisHardwareStatusReady         = 0,
    NdisHardwareStatusInitializing  = 1,
    NdisHardwareStatusReset         = 2,
    NdisHardwareStatusClosing       = 3,
    NdisHardwareStatusNotReady      = 4
} NDIS_HARDWARE_STATUS;
typedef NDIS_HARDWARE_STATUS    *PNDIS_HARDWARE_STATUS;

/* General get time capabilities */
typedef struct _GEN_GET_TIME_CAPS {
    ULONG   Flags;
    ULONG   ClockPrecision;
} GEN_GET_TIME_CAPS;
typedef GEN_GET_TIME_CAPS   *PGEN_GET_TIME_CAPS;

/* General get network card time */
typedef struct _GEN_GET_NETCARD_TIME {
    ULONGLONG   ReadTime;
} GEN_GET_NETCARD_TIME;
typedef GEN_GET_NETCARD_TIME    *PGEN_GET_NETCARD_TIME;

/* NDIS packet pattern */
typedef struct _NDIS_PM_PACKET_PATTERN {
    ULONG   Priority;
    ULONG   Reserved;
    ULONG   MaskSize;
    ULONG   PatternOffset;
    ULONG   PatternSize;
    ULONG   PatternFlags;
} NDIS_PM_PACKET_PATTERN;
typedef NDIS_PM_PACKET_PATTERN  *PNDIS_PM_PACKET_PATTERN;

/* NDIS device power states */
typedef enum _NDIS_DEVICE_POWER_STATE {
    NdisDeviceStateUnspecified  = 0,
    NdisDeviceStateD0           = 1,
    NdisDeviceStateD1           = 2,
    NdisDeviceStateD2           = 3,
    NdisDeviceStateD3           = 4,
    NdisDeviceStateMaximum      = 5
} NDIS_DEVICE_POWER_STATE;
typedef NDIS_DEVICE_POWER_STATE *PNDIS_DEVICE_POWER_STATE;

/* NDIS wake-up capabilities */
typedef struct _NDIS_PM_WAKE_UP_CAPABILITIES {
    NDIS_DEVICE_POWER_STATE MinMagicPacketWakeUp;
    NDIS_DEVICE_POWER_STATE MinPatternWakeUp;
    NDIS_DEVICE_POWER_STATE MinLinkChangeWakeUp;
} NDIS_PM_WAKE_UP_CAPABILITIES;
typedef NDIS_PM_WAKE_UP_CAPABILITIES    *PNDIS_PM_WAKE_UP_CAPABILITIES;

/* NDIS Plug and Play capabilities */
typedef struct _NDIS_PNP_CAPABILITIES {
    ULONG                           Flags;
    NDIS_PM_WAKE_UP_CAPABILITIES    WakeUpCapabilities;
} NDIS_PNP_CAPABILITIES;
typedef NDIS_PNP_CAPABILITIES   *PNDIS_PNP_CAPABILITIES;

/* NDIS FDDI attachment types */
typedef enum _NDIS_FDDI_ATTACHMENT_TYPE {
    NdisFddiTypeIsolated    = 1,
    NdisFddiTypeLocalA      = 2,
    NdisFddiTypeLocalB      = 3,
    NdisFddiTypeLocalAB     = 4,
    NdisFddiTypeLocalS      = 5,
    NdisFddiTypeWrapA       = 6,
    NdisFddiTypeWrapB       = 7,
    NdisFddiTypeWrapAB      = 8,
    NdisFddiTypeWrapS       = 9,
    NdisFddiTypeCWrapA      = 10,
    NdisFddiTypeCWrapB      = 11,
    NdisFddiTypeCWrapS      = 12,
    NdisFddiTypeThrough     = 13
} NDIS_FDDI_ATTACHMENT_TYPE;
typedef NDIS_FDDI_ATTACHMENT_TYPE   *PNDIS_FDDI_ATTACHMENT_TYPE;

/* NDIS FDDI ring management states */
typedef enum _NDIS_FDDI_RING_MGT_STATE {
    NdisFddiRingIsolated            = 1,
    NdisFddiRingNonOperational      = 2,
    NdisFddiRingOperational         = 3,
    NdisFddiRingDetect              = 4,
    NdisFddiRingNonOperationalDup   = 5,
    NdisFddiRingOperationalDup      = 6,
    NdisFddiRingDirected            = 7,
    NdisFddiRingTrace               = 8
} NDIS_FDDI_RING_MGT_STATE;
typedef NDIS_FDDI_RING_MGT_STATE    *PNDIS_FDDI_RING_MGT_STATE;

/* NDIS FDDI local connection states */
typedef enum _NDIS_FDDI_LCONNECTION_STATE {
    NdisFddiStateOff            = 1,
    NdisFddiStateBreak          = 2,
    NdisFddiStateTrace          = 3,
    NdisFddiStateConnect        = 4,
    NdisFddiStateNext           = 5,
    NdisFddiStateSignal         = 6,
    NdisFddiStateJoin           = 7,
    NdisFddiStateVerify         = 8,
    NdisFddiStateActive         = 9,
    NdisFddiStateMaintenance    = 10
} NDIS_FDDI_LCONNECTION_STATE;
typedef NDIS_FDDI_LCONNECTION_STATE *PNDIS_FDDI_LCONNECTION_STATE;

/* NDIS WAN medium subtypes */
typedef enum _NDIS_WAN_MEDIUM_SUBTYPE {
    NdisWanMediumHub        = 0,
    NdisWanMediumX_25       = 1,
    NdisWanMediumIsdn       = 2,
    NdisWanMediumSerial     = 3,
    NdisWanMediumFrameRelay = 4,
    NdisWanMediumAtm        = 5,
    NdisWanMediumSonet      = 6,
    NdisWanMediumSW56K      = 7,
    NdisWanMediumPPTP       = 8,
    NdisWanMediumL2TP       = 9,
    NdisWanMediumIrda       = 10,
    NdisWanMediumParallel   = 11,
#if (NTDDI_VERSION >= 0x06000000)
    NdisWanMediumPppoe      = 12,
    NdisWanMediumSSTP       = 13,
    NdisWanMediumAgileVPN   = 14
#else
    NdisWanMediumPppoe      = 12
#endif
} NDIS_WAN_MEDIUM_SUBTYPE;
typedef NDIS_WAN_MEDIUM_SUBTYPE *PNDIS_WAN_MEDIUM_SUBTYPE;

/* NDIS WAN header formats */
typedef enum _NDIS_WAN_HEADER_FORMAT {
    NdisWanHeaderNative     = 0,
    NdisWanHeaderEthernet   = 1
} NDIS_WAN_HEADER_FORMAT;
typedef NDIS_WAN_HEADER_FORMAT  *PNDIS_WAN_HEADER_FORMAT;

/* NDIS WAN quality values */
typedef enum _NDIS_WAN_QUALITY {
    NdisWanRaw          = 1,
    NdisWanErrorControl = 2,
    NdisWanReliable     = 3
} NDIS_WAN_QUALITY;
typedef NDIS_WAN_QUALITY    *PNDIS_WAN_QUALITY;

/* NDIS WAN protocol capabilities */
typedef struct _NDIS_WAN_PROTOCOL_CAPS {
    ULONG   Flags;
    ULONG   Reserved;
} NDIS_WAN_PROTOCOL_CAPS;
typedef NDIS_WAN_PROTOCOL_CAPS  *PNDIS_WAN_PROTOCOL_CAPS;

/* NDIS 802.5 ring states */
typedef enum _NDIS_802_5_RING_STATE {
    NdisRingStateOpened         = 1,
    NdisRingStateClosed         = 2,
    NdisRingStateOpening        = 3,
    NdisRingStateClosing        = 4,
    NdisRingStateOpenFailure    = 5,
    NdisRingStateRingFailure    = 6
} NDIS_802_5_RING_STATE;
typedef NDIS_802_5_RING_STATE   *PNDIS_802_5_RING_STATE;

/* NDIS media states */
typedef enum _NDIS_MEDIA_STATE {
    NdisMediaStateConnected     = 1,
    NdisMediaStateDisconnected  = 2
} NDIS_MEDIA_STATE;
typedef NDIS_MEDIA_STATE    *PNDIS_MEDIA_STATE;

/* NDIS CO link speed */
typedef struct _NDIS_CO_LINK_SPEED {
    ULONG   Outbound;
    ULONG   Inbound;
} NDIS_CO_LINK_SPEED;
typedef NDIS_CO_LINK_SPEED  *PNDIS_CO_LINK_SPEED;

/* NDIS link speed */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_LINK_SPEED {
    ULONG64 XmitLinkSpeed;
    ULONG64 RcvLinkSpeed;
} NDIS_LINK_SPEED;
typedef NDIS_LINK_SPEED *PNDIS_LINK_SPEED;
#endif

/* NDIS GUID */
typedef struct _NDIS_GUID {
    GUID    Guid;
    union {
        NDIS_OID    Oid;
        NDIS_STATUS Status;
    };
    ULONG   Size;
    ULONG   Flags;
} NDIS_GUID;
typedef NDIS_GUID   *PNDIS_GUID;

/* NDIS IRDA packet information */
typedef struct _NDIS_IRDA_PACKET_INFO {
    ULONG   ExtraBOFs;
    ULONG   MinTurnAroundTime;
} NDIS_IRDA_PACKET_INFO;
typedef NDIS_IRDA_PACKET_INFO   *PNDIS_IRDA_PACKET_INFO;

/* NDIS supported pause functions */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_SUPPORTED_PAUSE_FUNCTIONS {
    NdisPauseFunctionsUnsupported       = 0,
    NdisPauseFunctionsSendOnly          = 1,
    NdisPauseFunctionsReceiveOnly       = 2,
    NdisPauseFunctionsSendAndReceive    = 3,
    NdisPauseFunctionsUnknown           = 4
} NDIS_SUPPORTED_PAUSE_FUNCTIONS;
typedef NDIS_SUPPORTED_PAUSE_FUNCTIONS  *PNDIS_SUPPORTED_PAUSE_FUNCTIONS;
#endif

/* NDIS link state */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_LINK_STATE {
    NDIS_OBJECT_HEADER              Header;
    NDIS_MEDIA_CONNECT_STATE        MediaConnectState;
    NDIS_MEDIA_DUPLEX_STATE         MediaDuplexState;
    ULONG64                         XmitLinkSpeed;
    ULONG64                         RcvLinkSpeed;
    NDIS_SUPPORTED_PAUSE_FUNCTIONS  PauseFunctions;
    ULONG                           AutoNegotiationFlags;
} NDIS_LINK_STATE;
typedef NDIS_LINK_STATE *PNDIS_LINK_STATE;
#endif

/* NDIS link parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_LINK_PARAMETERS {
    NDIS_OBJECT_HEADER              Header;
    NDIS_MEDIA_DUPLEX_STATE         MediaDuplexState;
    ULONG64                         XmitLinkSpeed;
    ULONG64                         RcvLinkSpeed;
    NDIS_SUPPORTED_PAUSE_FUNCTIONS  PauseFunctions;
    ULONG                           AutoNegotiationFlags;
} NDIS_LINK_PARAMETERS;
typedef NDIS_LINK_PARAMETERS    *PNDIS_LINK_PARAMETERS;
#endif

/* NDIS operational state */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_OPER_STATE {
    NDIS_OBJECT_HEADER  Header;
    NET_IF_OPER_STATUS  OperationalStatus;
    ULONG               OperationalStatusFlags;
} NDIS_OPER_STATE;
typedef NDIS_OPER_STATE *PNDIS_OPER_STATE;
#endif

/* NDIS IP operational status */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_IP_OPER_STATUS {
    ULONG               AddressFamily;
    NET_IF_OPER_STATUS  OperationalStatus;
    ULONG               OperationalStatusFlags;
} NDIS_IP_OPER_STATUS;
typedef NDIS_IP_OPER_STATUS *PNDIS_IP_OPER_STATUS;
#endif

/* NDIS IP operational status information */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_IP_OPER_STATUS_INFO {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               NumberofAddressFamiliesReturned;
    NDIS_IP_OPER_STATUS IpOperationalStatus[MAXIMUM_IP_OPER_STATUS_ADDRESS_FAMILIES_SUPPORTED];
} NDIS_IP_OPER_STATUS_INFO;
typedef NDIS_IP_OPER_STATUS_INFO    *PNDIS_IP_OPER_STATUS_INFO;
#endif

/* NDIS IP operational state */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_IP_OPER_STATE {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    NDIS_IP_OPER_STATUS IpOperationalStatus;
} NDIS_IP_OPER_STATE;
typedef NDIS_IP_OPER_STATE  *PNDIS_IP_OPER_STATE;
#endif

/* NDIS offload parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_OFFLOAD_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    UCHAR               IPv4Checksum;
    UCHAR               TCPIPv4Checksum;
    UCHAR               UDPIPv4Checksum;
    UCHAR               TCPIPv6Checksum;
    UCHAR               UDPIPv6Checksum;
    UCHAR               LsoV1;
    UCHAR               IPsecV1;
    UCHAR               LsoV2IPv4;
    UCHAR               LsoV2IPv6;
    UCHAR               TcpConnectionIPv4;
    UCHAR               TcpConnectionIPv6;
    ULONG               Flags;
#if NDIS_SUPPORT_NDIS61
    UCHAR               IPsecV2;
    UCHAR               IPsecV2IPv4;
    UCHAR               Reserved1;
    UCHAR               Reserved2;
#endif
} NDIS_OFFLOAD_PARAMETERS;
typedef NDIS_OFFLOAD_PARAMETERS *PNDIS_OFFLOAD_PARAMETERS;
#endif

/* NDIS TCP large send offload (version 1) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TCP_LARGE_SEND_OFFLOAD_V1 {
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
        ULONG   TcpOptions  : 2;
        ULONG   IpOptions   : 2;
    } IPv4;
} NDIS_TCP_LARGE_SEND_OFFLOAD_V1;
typedef NDIS_TCP_LARGE_SEND_OFFLOAD_V1  *PNDIS_TCP_LARGE_SEND_OFFLOAD_V1;
#endif

/* NDIS TCP/IP checksum offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TCP_IP_CHECKSUM_OFFLOAD {
    struct {
        ULONG   Encapsulation;
        ULONG   IpOptionsSupported  : 2;
        ULONG   TcpOptionsSupported : 2;
        ULONG   TcpChecksum         : 2;
        ULONG   UdpChecksum         : 2;
        ULONG   IpChecksum          : 2;
    } IPv4Checksum;
    struct {
        ULONG   Encapsulation;
        ULONG   IpOptionsSupported  : 2;
        ULONG   TcpOptionsSupported : 2;
        ULONG   TcpChecksum         : 2;
        ULONG   UdpChecksum         : 2;
        ULONG   IpChecksum          : 2;
    } IPv4Receive;
    struct {
        ULONG   Encapsulation;
        ULONG   IpExtensionHeadersSupported : 2;
        ULONG   TcpOptionsSupported         : 2;
        ULONG   TcpChecksum                 : 2;
        ULONG   UdpChecksum                 : 2;
    } IPv6Transmit;
    struct {
        ULONG   Encapsulation;
        ULONG   IpExtensionHeadersSupported : 2;
        ULONG   TcpOptionsSupported         : 2;
        ULONG   TcpChecksum                 : 2;
        ULONG   UdpChecksum                 : 2;
    } IPv6Receive;
} NDIS_TCP_IP_CHECKSUM_OFFLOAD;
typedef NDIS_TCP_IP_CHECKSUM_OFFLOAD    *PNDIS_TCP_IP_CHECKSUM_OFFLOAD;
#endif

/* NDIS IPsec offload (version 1) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_IPSEC_OFFLOAD_V1 {
    struct {
        ULONG   Encapsulation;
        ULONG   AhEspCombined;
        ULONG   TransportTunnelCombined;
        ULONG   IPv4Options;
        ULONG   Flags;
    } Supported;
    struct {
        ULONG   Md5         : 2;
        ULONG   Sha_1       : 2;
        ULONG   Transport   : 2;
        ULONG   Tunnel      : 2;
        ULONG   Send        : 2;
        ULONG   Receive     : 2;
    } IPv4AH;
    struct {
        ULONG   Des         : 2;
        ULONG   Reserved    : 2;
        ULONG   TripleDes   : 2;
        ULONG   NullEsp     : 2;
        ULONG   Transport   : 2;
        ULONG   Tunnel      : 2;
        ULONG   Send        : 2;
        ULONG   Receive     : 2;
    } IPv4ESP;
} NDIS_IPSEC_OFFLOAD_V1;
typedef NDIS_IPSEC_OFFLOAD_V1   *PNDIS_IPSEC_OFFLOAD_V1;
#endif

/* NDIS TCP large send offload (version 2) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TCP_LARGE_SEND_OFFLOAD_V2 {
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
    } IPv4;
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
        ULONG   IpExtensionHeadersSupported : 2;
        ULONG   TcpOptionsSupported         : 2;
    } IPv6;
} NDIS_TCP_LARGE_SEND_OFFLOAD_V2;
typedef NDIS_TCP_LARGE_SEND_OFFLOAD_V2  *PNDIS_TCP_LARGE_SEND_OFFLOAD_V2;
#endif

/* NDIS IPsec offload (version 2) */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
typedef struct _NDIS_IPSEC_OFFLOAD_V2 {
    ULONG   Encapsulation;
    BOOLEAN IPv6Supported;
    BOOLEAN IPv4Options;
    BOOLEAN IPv6NonIPsecExtensionHeaders;
    BOOLEAN Ah;
    BOOLEAN Esp;
    BOOLEAN AhEspCombined;
    BOOLEAN Transport;
    BOOLEAN Tunnel;
    BOOLEAN TransportTunnelCombined;
    BOOLEAN LsoSupported;
    BOOLEAN ExtendedSequenceNumbers;
    ULONG   UdpEsp;
    ULONG   AuthenticationAlgorithms;
    ULONG   EncryptionAlgorithms;
    ULONG   SaOffloadCapacity;
} NDIS_IPSEC_OFFLOAD_V2;
typedef NDIS_IPSEC_OFFLOAD_V2   *PNDIS_IPSEC_OFFLOAD_V2;
#endif

/* NDIS offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_OFFLOAD {
    NDIS_OBJECT_HEADER              Header;
    NDIS_TCP_IP_CHECKSUM_OFFLOAD    Checksum;
    NDIS_TCP_LARGE_SEND_OFFLOAD_V1  LsoV1;
    NDIS_IPSEC_OFFLOAD_V1           IPsecV1;
    NDIS_TCP_LARGE_SEND_OFFLOAD_V2  LsoV2;
    ULONG                           Flags;
#if NDIS_SUPPORT_NDIS61
    NDIS_IPSEC_OFFLOAD_V2           IPsecV2;
#endif
} NDIS_OFFLOAD;
typedef NDIS_OFFLOAD    *PNDIS_OFFLOAD;
#endif

/* NDIS WMI TCP large send offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1 {
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
        ULONG   TcpOptions;
        ULONG   IpOptions;
    } IPv4;
} NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1;
typedef NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1  *PNDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1;
#endif

/* NDIS WMI TCP/IP checksum offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD {
    struct {
        ULONG   Encapsulation;
        ULONG   IpOptionsSupported;
        ULONG   TcpOptionsSupported;
        ULONG   TcpChecksum;
        ULONG   UdpChecksum;
        ULONG   IpChecksum;
    } IPv4Transmit;
    struct {
        ULONG   Encapsulation;
        ULONG   IpOptionsSupported;
        ULONG   TcpOptionsSupported;
        ULONG   TcpChecksum;
        ULONG   UdpChecksum;
        ULONG   IpChecksum;
    } IPv4Receive;
    struct {
        ULONG   Encapsulation;
        ULONG   IpExtensionHeadersSupported;
        ULONG   TcpOptionsSupported;
        ULONG   TcpChecksum;
        ULONG   UdpChecksum;
    } IPv6Transmit;
    struct {
        ULONG   Encapsulation;
        ULONG   IpExtensionHeadersSupported;
        ULONG   TcpOptionsSupported;
        ULONG   TcpChecksum;
        ULONG   UdpChecksum;
    } IPv6Receive;
} NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD;
typedef NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD    *PNDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD;
#endif

/* NDIS WMI IPsec offload (version 1) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_IPSEC_OFFLOAD_V1 {
    struct {
        ULONG   Encapsulation;
        ULONG   AhEspCombined;
        ULONG   TransportTunnelCombined;
        ULONG   IPv4Options;
        ULONG   Flags;
    } Supported;
    struct {
        ULONG   Md5;
        ULONG   Sha_1;
        ULONG   Transport;
        ULONG   Tunnel;
        ULONG   Send;
        ULONG   Receive;
    } IPv4AH;
    struct {
        ULONG   Des;
        ULONG   Reserved;
        ULONG   TripleDes;
        ULONG   NullEsp;
        ULONG   Transport;
        ULONG   Tunnel;
        ULONG   Send;
        ULONG   Receive;
    } IPv4ESP;
} NDIS_WMI_IPSEC_OFFLOAD_V1;
typedef NDIS_WMI_IPSEC_OFFLOAD_V1   *PNDIS_WMI_IPSEC_OFFLOAD_V1;
#endif

/* NDIS WMI TCP large send offload (version 2) */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2 {
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
    } IPv4;
    struct {
        ULONG   Encapsulation;
        ULONG   MaxOffLoadSize;
        ULONG   MinSegmentCount;
        ULONG   IpExtensionHeadersSupported;
        ULONG   TcpOptionsSupported;
    } IPv6;
} NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2;
typedef NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2  *PNDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2;
#endif

/* NDIS WMI offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_OFFLOAD {
    NDIS_OBJECT_HEADER                  Header;
    NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD    Checksum;
    NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1  LsoV1;
    NDIS_WMI_IPSEC_OFFLOAD_V1           IPsecV1;
    NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2  LsoV2;
    ULONG                               Flags;
#if NDIS_SUPPORT_NDIS61
    NDIS_IPSEC_OFFLOAD_V2               IPsecV2;
#endif
} NDIS_WMI_OFFLOAD;
typedef NDIS_WMI_OFFLOAD    *PNDIS_WMI_OFFLOAD;
#endif

/* NDIS TCP connection offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_TCP_CONNECTION_OFFLOAD {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Encapsulation;
    ULONG               SupportIPv4                 : 2;
    ULONG               SupportIPv6                 : 2;
    ULONG               SupportIPv6ExtensionHeaders : 2;
    ULONG               SupportSack                 : 2;
#if NDIS_SUPPORT_NDIS61
    ULONG               CongestionAlgorithm         : 4;
#endif
    ULONG               TcpConnectionOffloadCapacity;
    ULONG               Flags;
} NDIS_TCP_CONNECTION_OFFLOAD;
typedef NDIS_TCP_CONNECTION_OFFLOAD *PNDIS_TCP_CONNECTION_OFFLOAD;
#endif

/* NDIS WMI TCP connection offload */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_TCP_CONNECTION_OFFLOAD {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Encapsulation;
    ULONG               SupportIPv4;
    ULONG               SupportIPv6;
    ULONG               SupportIPv6ExtensionHeaders;
    ULONG               SupportSack;
    ULONG               TcpConnectionOffloadCapacity;
    ULONG               Flags;
} NDIS_WMI_TCP_CONNECTION_OFFLOAD;
typedef NDIS_WMI_TCP_CONNECTION_OFFLOAD *PNDIS_WMI_TCP_CONNECTION_OFFLOAD;
#endif

/* NDIS port types */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_PORT_TYPE {
    NdisPortTypeUndefined       = 0,
    NdisPortTypeBridge          = 1,
    NdisPortTypeRasConnection   = 2,
    NdisPortType8021xSupplicant = 3,
    NdisPortTypeMax             = 4
} NDIS_PORT_TYPE;
typedef NDIS_PORT_TYPE  *PNDIS_PORT_TYPE;
#endif

/* NDIS port authorization states */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_PORT_AUTHORIZATION_STATE {
    NdisPortAuthorizationUnknown    = 0,
    NdisPortAuthorized              = 1,
    NdisPortUnauthorized            = 2,
    NdisPortReauthorizing           = 3
} NDIS_PORT_AUTHORIZATION_STATE;
typedef NDIS_PORT_AUTHORIZATION_STATE   *PNDIS_PORT_AUTHORIZATION_STATE;
#endif

/* NDIS port control states */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_PORT_CONTROL_STATE {
    NdisPortControlStateUnknown         = 0,
    NdisPortControlStateControlled      = 1,
    NdisPortControlStateUncontrolled    = 2
} NDIS_PORT_CONTROLL_STATE;
typedef NDIS_PORT_CONTROLL_STATE    *PNDIS_PORT_CONTROLL_STATE;
#endif

/* NDIS port state */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PORT_STATE {
    NDIS_OBJECT_HEADER              Header;
    NDIS_MEDIA_CONNECT_STATE        MediaConnectState;
    ULONG64                         XmitLinkSpeed;
    ULONG64                         RcvLinkSpeed;
    NET_IF_DIRECTION_TYPE           Direction;
    NDIS_PORT_CONTROLL_STATE        SendControlState;
    NDIS_PORT_CONTROLL_STATE        RcvControlState;
    NDIS_PORT_AUTHORIZATION_STATE   SendAuthorizationState;
    NDIS_PORT_AUTHORIZATION_STATE   RcvAuthorizationState;
    ULONG                           Flags;
} NDIS_PORT_STATE;
typedef NDIS_PORT_STATE *PNDIS_PORT_STATE;
#endif

/* NDIS port authentication parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PORT_AUTHENTICATION_PARAMETERS {
    NDIS_OBJECT_HEADER              Header;
    NDIS_PORT_CONTROLL_STATE        SendControlState;
    NDIS_PORT_CONTROLL_STATE        RcvControlState;
    NDIS_PORT_AUTHORIZATION_STATE   SendAuthorizationState;
    NDIS_PORT_AUTHORIZATION_STATE   RcvAuthorizationState;
} NDIS_PORT_AUTHENTICATION_PARAMETERS;
typedef NDIS_PORT_AUTHENTICATION_PARAMETERS *PNDIS_PORT_AUTHENTICATION_PARAMETERS;
#endif

/* NDIS port characteristics */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PORT_CHARACTERISTICS {
    NDIS_OBJECT_HEADER              Header;
    NDIS_PORT_NUMBER                PortNumber;
    ULONG                           Flags;
    NDIS_PORT_TYPE                  Type;
    NDIS_MEDIA_CONNECT_STATE        MediaConnectState;
    ULONG64                         XmitLinkSpeed;
    ULONG64                         RcvLinkSpeed;
    NET_IF_DIRECTION_TYPE           Direction;
    NDIS_PORT_CONTROLL_STATE        SendControlState;
    NDIS_PORT_CONTROLL_STATE        RcvControlState;
    NDIS_PORT_AUTHORIZATION_STATE   SendAuthorizationState;
    NDIS_PORT_AUTHORIZATION_STATE   RcvAuthorizationState;
} NDIS_PORT_CHARACTERISTICS;
typedef NDIS_PORT_CHARACTERISTICS   *PNDIS_PORT_CHARACTERISTICS;
#endif

/* NDIS port */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PORT {
    struct _NDIS_PORT           *Next;
    PVOID                       NdisReserved;
    PVOID                       MiniportReserved;
    PVOID                       ProtocolReserved;
    NDIS_PORT_CHARACTERISTICS   PortCharacteristics;
} NDIS_PORT;
typedef NDIS_PORT   *PNDIS_PORT;
#endif

/* NDIS port array */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_PORT_ARRAY {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       NumberOfPorts;
    ULONG                       OffsetFirstPort;
    ULONG                       ElementSize;
    NDIS_PORT_CHARACTERISTICS   Ports[1];
} NDIS_PORT_ARRAY;
typedef NDIS_PORT_ARRAY *PNDIS_PORT_ARRAY;
#endif

/* NDIS network change types */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_NETWORK_CHANGE_TYPE {
    NdisPossibleNetworkChange           = 1,
    NdisDefinitelyNetworkChange         = 2,
    NdisNetworkChangeFromMediaConnect   = 3,
    NdisNetworkChangeMax                = 4
} NDIS_NETWORK_CHANGE_TYPE;
typedef NDIS_NETWORK_CHANGE_TYPE    *PNDIS_NETWORK_CHANGE_TYPE;
#endif

/* NDIS WMI method header */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_METHOD_HEADER {
    NDIS_OBJECT_HEADER  Header;
    NDIS_PORT_NUMBER    PortNumber;
    NET_LUID            NetLuid;
    ULONG64             RequestId;
    ULONG               Timeout;
    UCHAR               Padding[4];
} NDIS_WMI_METHOD_HEADER;
typedef NDIS_WMI_METHOD_HEADER  *PNDIS_WMI_METHOD_HEADER;
#endif

/* NDIS WMI set header */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_SET_HEADER {
    NDIS_OBJECT_HEADER  Header;
    NDIS_PORT_NUMBER    PortNumber;
    NET_LUID            NetLuid;
    ULONG64             RequestId;
    ULONG               Timeout;
    UCHAR               Padding[4];
} NDIS_WMI_SET_HEADER;
typedef NDIS_WMI_SET_HEADER *PNDIS_WMI_SET_HEADER;
#endif

/* NDIS WMI event header */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_EVENT_HEADER {
    NDIS_OBJECT_HEADER  Header;
    NET_IFINDEX         IfIndex;
    NET_LUID            NetLuid;
    ULONG64             RequestId;
    NDIS_PORT_NUMBER    PortNumber;
    ULONG               DeviceNameLength;
    ULONG               DeviceNameOffset;
    UCHAR               Padding[4];
} NDIS_WMI_EVENT_HEADER;
typedef NDIS_WMI_EVENT_HEADER   *PNDIS_WMI_EVENT_HEADER;
#endif

/* NDIS WMI enumerate adapter */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_WMI_ENUM_ADAPTER {
    NDIS_OBJECT_HEADER  Header;
    NET_IFINDEX         IfIndex;
    NET_LUID            NetLuid;
    USHORT              DeviceNameLength;
    CHAR                DeviceName[1];
} NDIS_WMI_ENUM_ADAPTER;
typedef NDIS_WMI_ENUM_ADAPTER   *PNDIS_WMI_ENUM_ADAPTER;
#endif

/* NDIS WMI output information */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct NDIS_WMI_OUTPUT_INFO {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    UCHAR               SupportedRevision;
    ULONG               DataOffset;
} NDIS_WMI_OUTPUT_INFO;
typedef NDIS_WMI_OUTPUT_INFO    *PNDIS_WMI_OUTPUT_INFO;
#endif

/* NDIS HD split parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
typedef struct _NDIS_HD_SPLIT_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               HDSplitCombineFlags;
} NDIS_HD_SPLIT_PARAMETERS;
typedef NDIS_HD_SPLIT_PARAMETERS    *PNDIS_HD_SPLIT_PARAMETERS;
#endif

/* NDIS HD split current configuration */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS61
typedef struct _NDIS_HD_SPLIT_CURRENT_CONFIG {
    NDIS_OBJECT_HEADER  Header;
    ULONG               HardwareCapabilities;
    ULONG               CurrentCapabilities;
    ULONG               HDSplitFlags;
    ULONG               HDSplitCombineFlags;
    ULONG               BackfillSize;
    ULONG               MaxHeaderSize;
} NDIS_HD_SPLIT_CURRENT_CONFIG;
typedef NDIS_HD_SPLIT_CURRENT_CONFIG    *PNDIS_HD_SPLIT_CURRENT_CONFIG;
#endif

/* NDIS power management WOL packet types */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_PM_WOL_PACKET {
    NdisPMWoLPacketUnspecified              = 0,
    NdisPMWoLPacketBitmapPattern            = 1,
    NdisPMWoLPacketMagicPacket              = 2,
    NdisPMWoLPacketIPv4TcpSyn               = 3,
    NdisPMWoLPacketIPv6TcpSyn               = 4,
    NdisPMWoLPacketEapolRequestIdMessage    = 5,
    NdisPMWoLPacketMaximum                  = 6
} NDIS_PM_WOL_PACKET;
typedef NDIS_PM_WOL_PACKET  *PNDIS_PM_WOL_PACKET;
#endif

/* NDIS power management protocol offload types */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_PM_PROTOCOL_OFFLOAD_TYPE {
    NdisPMProtocolOffloadIdUnspecified  = 0,
    NdisPMProtocolOffloadIdIpv4ARP      = 1,
    NdisPMProtocolOffloadIdIPv6Ns       = 2,
    NdisPMProtocolOffload80211RSNRekey  = 3,
    NdisPMProtocolOffloadIdMaximum      = 4
} NDIS_PM_PROTOCOL_OFFLOAD_TYPE;
typedef NDIS_PM_PROTOCOL_OFFLOAD_TYPE   *PNDIS_PM_PROTOCOL_OFFLOAD_TYPE;
#endif

/* NDIS power management counted string */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PM_COUNTED_STRING {
    USHORT  Length;
    WCHAR   String[NDIS_PM_MAX_STRING_SIZE + 1];
} NDIS_PM_COUNTED_STRING;
typedef NDIS_PM_COUNTED_STRING  *PNDIS_PM_COUNTED_STRING;
#endif

/* NDIS power management capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PM_CAPABILITIES {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    ULONG                   SupportedWoLPacketPatterns;
    ULONG                   NumTotalWoLPatterns;
    ULONG                   MaxWoLPatternSize;
    ULONG                   MaxWoLPatternOffset;
    ULONG                   MaxWoLPacketSaveBuffer;
    ULONG                   SupportedProtocolOffloads;
    ULONG                   NumArpOffloadIPv4Addresses;
    ULONG                   NumNSOffloadIPv6Addresses;
    NDIS_DEVICE_POWER_STATE MinMagicPacketWakeUp;
    NDIS_DEVICE_POWER_STATE MinPatternWakeUp;
    NDIS_DEVICE_POWER_STATE MinLinkChangeWakeUp;
} NDIS_PM_CAPABILITIES;
typedef NDIS_PM_CAPABILITIES    *PNDIS_PM_CAPABILITIES;
#endif

/* NDIS power management parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PM_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               EnabledWoLPacketPatterns;
    ULONG               EnabledProtocolOffloads;
    ULONG               WakeUpFlags;
} NDIS_PM_PARAMETERS;
typedef NDIS_PM_PARAMETERS  *PNDIS_PM_PARAMETERS;
#endif

/* NDIS power management WOL pattern */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PM_WOL_PATTERN {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    ULONG                   Priority;
    NDIS_PM_WOL_PACKET      WoLPacketType;
    NDIS_PM_COUNTED_STRING  FriendlyName;
    ULONG                   PatternId;
    ULONG                   NextWoLPatternOffset;
    union _WOL_PATTERN {
        struct _IPV4_TCP_SYN_WOL_PACKET_PARAMETERS {
            ULONG   Flags;
            UCHAR   IPv4SourceAddress[4];
            UCHAR   IPv4DestAddress[4];
            USHORT  TCPSourcePortNumber;
            USHORT  TCPDestPortNumber;
        } IPv4TcpSynParameters;
        struct _IPV6_TCP_SYN_WOL_PACKET_PARAMETERS {
            ULONG   Flags;
            UCHAR   IPv6SourceAddress[16];
            UCHAR   IPv6DestAddress[16];
            USHORT  TCPSourcePortNumber;
            USHORT  TCPDestPortNumber;
        } IPv6TcpSynParameters;
        struct _EAPOL_REQUEST_ID_MESSAGE_WOL_PACKET_PARAMETERS {
            ULONG   Flags;
        } EapolRequestIdMessageParameters;
        struct _WOL_BITMAP_PATTERN {
            ULONG   Flags;
            ULONG   MaskOffset;
            ULONG   MaskSize;
            ULONG   PatternOffset;
            ULONG   PatternSize;
        } WoLBitMapPattern;
    } WoLPattern;
} NDIS_PM_WOL_PATTERN;
typedef NDIS_PM_WOL_PATTERN *PNDIS_PM_WOL_PATTERN;
#endif

/* NDIS power management protocol offload */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PM_PROTOCOL_OFFLOAD {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           Flags;
    ULONG                           Priority;
    NDIS_PM_PROTOCOL_OFFLOAD_TYPE   ProtocolOffloadType;
    NDIS_PM_COUNTED_STRING          FriendlyName;
    ULONG                           ProtocolOffloadId;
    ULONG                           NextProtocolOffloadOffset;
    union _PROTOCOL_OFFLOAD_PARAMETERS {
        struct _IPV4_ARP_PARAMETERS {
            ULONG   Flags;
            UCHAR   RemoteIPv4Address[4];
            UCHAR   HostIPv4Address[4];
            UCHAR   MacAddress[6];
        } IPv4ARPParameters;
        struct _IPV6_NS_PARAMETERS {
            ULONG   Flags;
            UCHAR   RemoteIPv6Address[16];
            UCHAR   SolicitedNodeIPv6Address[16];
            UCHAR   MacAddress[6];
            UCHAR   TargetIPv6Addresses[2][16];
        } IPv6NSParameters;
        struct _DOT11_RSN_REKEY_PARAMETERS {
            ULONG       Flags;
            UCHAR       KCK[DOT11_RSN_KCK_LENGTH];
            UCHAR       KEK[DOT11_RSN_KEK_LENGTH];
            ULONGLONG   KeyReplayCounter;
        } Dot11RSNRekeyParameters;
    } ProtocolOffloadParameters;
} NDIS_PM_PROTOCOL_OFFLOAD;
typedef NDIS_PM_PROTOCOL_OFFLOAD    *PNDIS_PM_PROTOCOL_OFFLOAD;
#endif

/* NDIS power management administrator configuration states */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_PM_ADMIN_CONFIG_STATE {
    NdisPMAdminConfigUnspecified    = 0,
    NdisPMAdminConfigDisabled       = 1,
    NdisPMAdminConfigEnabled        = 2
} NDIS_PM_ADMIN_CONFIG_STATE;
typedef NDIS_PM_ADMIN_CONFIG_STATE  *PNDIS_PM_ADMIN_CONFIG_STATE;
#endif

/* NDIS WMI power management administrator configuration */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_WMI_PM_ADMIN_CONFIG {
    NDIS_OBJECT_HEADER          Header;
    NDIS_PM_ADMIN_CONFIG_STATE  WakeOnPattern;
    NDIS_PM_ADMIN_CONFIG_STATE  WakeOnMagicPacket;
    NDIS_PM_ADMIN_CONFIG_STATE  DeviceSleepOnDisconnect;
    NDIS_PM_ADMIN_CONFIG_STATE  PMARPOffload;
    NDIS_PM_ADMIN_CONFIG_STATE  PMNSOffload;
    NDIS_PM_ADMIN_CONFIG_STATE  PMWiFiRekeyOffload;
} NDIS_WMI_PM_ADMIN_CONFIG;
typedef NDIS_WMI_PM_ADMIN_CONFIG    *PNDIS_WMI_PM_ADMIN_CONFIG;
#endif

/* NDIS power management capability states */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_PM_CAPABILITY_STATE {
    NdisPMAdminConfigUnsupported    = 0,
    NdisPMAdminConfigInactive       = 1,
    NdisPMAdminConfigActive         = 2
} NDIS_PM_CAPABILITY_STATE;
typedef NDIS_PM_CAPABILITY_STATE    *PNDIS_PM_CAPABILITY_STATE;
#endif

/* NDIS WMI power management active capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_WMI_PM_ACTIVE_CAPABILITIES {
    NDIS_OBJECT_HEADER          Header;
    NDIS_PM_CAPABILITY_STATE    WakeOnPattern;
    NDIS_PM_CAPABILITY_STATE    WakeOnMagicPacket;
    NDIS_PM_CAPABILITY_STATE    DeviceSleepOnDisconnect;
    NDIS_PM_CAPABILITY_STATE    PMARPOffload;
    NDIS_PM_CAPABILITY_STATE    PMNSOffload;
    NDIS_PM_CAPABILITY_STATE    PMWiFiRekeyOffload;
} NDIS_WMI_PM_ACTIVE_CAPABILITIES;
typedef NDIS_WMI_PM_ACTIVE_CAPABILITIES *PNDIS_WMI_PM_ACTIVE_CAPABILITIES;
#endif

/* NDIS receive filter capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_CAPABILITIES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               EnabledFilterTypes;
    ULONG               EnabledQueueTypes;
    ULONG               NumQueues;
    ULONG               SupportedQueueProperties;
    ULONG               SupportedFilterTests;
    ULONG               SupportedHeaders;
    ULONG               SupportedMacHeaderFields;
    ULONG               MaxMacHeaderFilters;
    ULONG               MaxQueueGroups;
    ULONG               MaxQueuesPerQueueGroup;
    ULONG               MinLookaheadSplitSize;
    ULONG               MaxLookaheadSplitSize;
} NDIS_RECEIVE_FILTER_CAPABILITIES;
typedef NDIS_RECEIVE_FILTER_CAPABILITIES    *PNDIS_RECEIVE_FILTER_CAPABILITIES;
#endif

/* NDIS NIC switch capabilities */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_NIC_SWITCH_CAPABILITIES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               NdisReserved1;
    ULONG               NumTotalMacAddresses;
    ULONG               NumMacAddressesPerPort;
    ULONG               NumVlansPerPort;
    ULONG               NdisReserved2;
    ULONG               NdisReserved3;
} NDIS_NIC_SWITCH_CAPABILITIES;
typedef NDIS_NIC_SWITCH_CAPABILITIES    *PNDIS_NIC_SWITCH_CAPABILITIES;
#endif

/* NDIS receive filter global parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_GLOBAL_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               EnabledFilterTypes;
    ULONG               EnabledQueueTypes;
} NDIS_RECEIVE_FILTER_GLOBAL_PARAMETERS;
typedef NDIS_RECEIVE_FILTER_GLOBAL_PARAMETERS   *PNDIS_RECEIVE_FILTER_GLOBAL_PARAMETERS;
#endif

/* NDIS receive filter types */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_RECEIVE_FILTER_TYPE {
    NdisReceiveFilterTypeUndefined  = 0,
    NdisReceiveFilterTypeVMQueue    = 1,
    NdisReceiveFilterTypeMaximum    = 2
} NDIS_RECEIVE_FILTER_TYPE;
typedef NDIS_RECEIVE_FILTER_TYPE    *PNDIS_RECEIVE_FILTER_TYPE;
#endif

/* NDIS frame header values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_FRAME_HEADER {
    NdisFrameHeaderUndefined    = 0,
    NdisFrameHeaderMac          = 1,
    NdisFrameHeaderMaximum      = 2
} NDIS_FRAME_HEADER;
typedef NDIS_FRAME_HEADER   *PNDIS_FRAME_HEADER;
#endif

/* NDIS MAC header fields */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_MAC_HEADER_FIELD {
    NdisMacHeaderFieldUndefined             = 0,
    NdisMacHeaderFieldDestinationAddress    = 1,
    NdisMacHeaderFieldSourceAddress         = 2,
    NdisMacHeaderFieldVlanId                = 3,
    NdisMacHeaderFieldPriority              = 4,
    NdisMacHeaderFieldMaximum               = 5
} NDIS_MAC_HEADER_FIELD;
typedef NDIS_MAC_HEADER_FIELD   *PNDIS_MAC_HEADER_FIELD;
#endif

/* NDIS receive filter test values */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_RECEIVE_FILTER_TEST {
    NdisReceiveFilterTestUndefined  = 0,
    NdisReceiveFilterTestEqual      = 1,
    NdisReceiveFilterTestMaskEqual  = 2,
    NdisReceiveFilterTestMaximum    = 3
} NDIS_RECEIVE_FILTER_TEST;
typedef NDIS_RECEIVE_FILTER_TEST    *PNDIS_RECEIVE_FILTER_TEST;
#endif

/* NDIS receive filter field parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_FIELD_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_FRAME_HEADER           FrameHeader;
    NDIS_RECEIVE_FILTER_TEST    ReceiveFilterTest;
    union _HEADER_FIELD {
        NDIS_MAC_HEADER_FIELD   MacHeaderField;
    } HeaderField;
    union _FIELD_VALUE {
        UCHAR   FieldByteValue;
        USHORT  FieldShortValue;
        ULONG   FieldLongValue;
        ULONG64 FieldLong64Value;
        UCHAR   FieldByteArrayValue[16];
    } FieldValue;
    union _RESULT_VALUE {
        UCHAR   ResultByteValue;
        USHORT  ResultShortValue;
        ULONG   ResultLongValue;
        ULONG64 ResultLong64Value;
        UCHAR   ResultByteArrayValue[16];
    } ResultValue;
} NDIS_RECEIVE_FILTER_FIELD_PARAMETERS;
typedef NDIS_RECEIVE_FILTER_FIELD_PARAMETERS    *PNDIS_RECEIVE_FILTER_FIELD_PARAMETERS;
#endif

/* NDIS receive filter parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_RECEIVE_FILTER_TYPE    FilterType;
    NDIS_RECEIVE_QUEUE_ID       QueueId;
    NDIS_RECEIVE_FILTER_ID      FilterId;
    ULONG                       FieldParametersArrayOffset;
    ULONG                       FieldParametersArrayNumElements;
    ULONG                       FieldParametersArrayElementSize;
    ULONG                       RequestedFilterIdBitCount;
} NDIS_RECEIVE_FILTER_PARAMETERS;
typedef NDIS_RECEIVE_FILTER_PARAMETERS  *PNDIS_RECEIVE_FILTER_PARAMETERS;
#endif

/* NDIS receive filter clear parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_CLEAR_PARAMETERS {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NDIS_RECEIVE_QUEUE_ID   QueueId;
    NDIS_RECEIVE_FILTER_ID  FilterId;
} NDIS_RECEIVE_FILTER_CLEAR_PARAMETERS;
typedef NDIS_RECEIVE_FILTER_CLEAR_PARAMETERS    *PNDIS_RECEIVE_FILTER_CLEAR_PARAMETERS;
#endif

/* NDIS receive queue types */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_RECEIVE_QUEUE_TYPE {
    NdisReceiveQueueTypeUnspecified = 0,
    NdisReceiveQueueTypeVMQueue     = 1,
    NdisReceiveQueueTypeMaximum     = 2
} NDIS_RECEIVE_QUEUE_TYPE;
typedef NDIS_RECEIVE_QUEUE_TYPE *PNDIS_RECEIVE_QUEUE_TYPE;
#endif

/* NDIS receive queue parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_RECEIVE_QUEUE_TYPE     QueueType;
    NDIS_RECEIVE_QUEUE_ID       QueueId;
    NDIS_RECEIVE_QUEUE_GROUP_ID QueueGroupId;
    GROUP_AFFINITY              ProcessorAffinity;
    ULONG                       NumSuggestedReceiveBuffers;
    ULONG                       MSIXTableEntry;
    ULONG                       LookaheadSize;
    NDIS_VM_NAME                VmName;
    NDIS_QUEUE_NAME             QueueName;
} NDIS_RECEIVE_QUEUE_PARAMETERS;
typedef NDIS_RECEIVE_QUEUE_PARAMETERS   *PNDIS_RECEIVE_QUEUE_PARAMETERS;
#endif

/* NDIS receive queue free parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_FREE_PARAMETERS {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NDIS_RECEIVE_QUEUE_ID   QueueId;
} NDIS_RECEIVE_QUEUE_FREE_PARAMETERS;
typedef NDIS_RECEIVE_QUEUE_FREE_PARAMETERS  *PNDIS_RECEIVE_QUEUE_FREE_PARAMETERS;
#endif

/* NDIS receive queue operational states */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE {
    NdisReceiveQueueOperationalStateUndefined   = 0,
    NdisReceiveQueueOperationalStateRunning     = 1,
    NdisReceiveQueueOperationalStatePaused      = 2,
    NdisReceiveQueueOperationalStateDmaStopped  = 3,
    NdisReceiveQueueOperationalStateMaximum     = 4
} NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE;
typedef NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE    *PNDIS_RECEIVE_QUEUE_OPERATIONAL_STATE;
#endif

/* NDIS receive queue information */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_INFO {
    NDIS_OBJECT_HEADER                      Header;
    ULONG                                   Flags;
    NDIS_RECEIVE_QUEUE_TYPE                 QueueType;
    NDIS_RECEIVE_QUEUE_ID                   QueueId;
    NDIS_RECEIVE_QUEUE_GROUP_ID             QueueGroupId;
    NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE    QueueState;
    GROUP_AFFINITY                          ProcessorAffinity;
    ULONG                                   NumSuggestedReceiveBuffers;
    ULONG                                   MSIXTableEntry;
    ULONG                                   LookaheadSize;
    NDIS_VM_NAME                            VmName;
    NDIS_QUEUE_NAME                         QueueName;
} NDIS_RECEIVE_QUEUE_INFO;
typedef NDIS_RECEIVE_QUEUE_INFO *PNDIS_RECEIVE_QUEUE_INFO;
#endif

/* NDIS receive queue information array */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_INFO_ARRAY {
    NDIS_OBJECT_HEADER  Header;
    ULONG               FirstElementOffset;
    ULONG               NumElements;
    ULONG               ElementSize;
} NDIS_RECEIVE_QUEUE_INFO_ARRAY;
typedef NDIS_RECEIVE_QUEUE_INFO_ARRAY   *PNDIS_RECEIVE_QUEUE_INFO_ARRAY;
#endif

/* NDIS receive filter information */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_INFO {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_RECEIVE_FILTER_TYPE    FilterType;
    NDIS_RECEIVE_FILTER_ID      FilterId;
} NDIS_RECEIVE_FILTER_INFO;
typedef NDIS_RECEIVE_FILTER_INFO    *PNDIS_RECEIVE_FILTER_INFO;
#endif

/* NDIS receive filter information array */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_FILTER_INFO_ARRAY {
    NDIS_OBJECT_HEADER      Header;
    NDIS_RECEIVE_QUEUE_ID   QueueId;
    ULONG                   FirstElementOffset;
    ULONG                   NumElements;
    ULONG                   ElementSize;
} NDIS_RECEIVE_FILTER_INFO_ARRAY;
typedef NDIS_RECEIVE_FILTER_INFO_ARRAY  *PNDIS_RECEIVE_FILTER_INFO_ARRAY;
#endif

/* NDIS receive queue allocation complete parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_PARAMETERS {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NDIS_RECEIVE_QUEUE_ID   QueueId;
    NDIS_STATUS             CompletionStatus;
} NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_PARAMETERS;
typedef NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_PARAMETERS   *PNDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_PARAMETERS;
#endif

/* NDIS receive queue allocation complete array */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_ARRAY {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               FirstElementOffset;
    ULONG               NumElements;
    ULONG               ElementSize;
} NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_ARRAY;
typedef NDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_ARRAY    *PNDIS_RECEIVE_QUEUE_ALLOCATION_COMPLETE_ARRAY;
#endif

/* NDIS receive scale capabilities */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_RECEIVE_SCALE_CAPABILITIES {
    NDIS_OBJECT_HEADER  Header;
    ULONG               CapabilitiesFlags;
    ULONG               NumberOfInterruptMessages;
    ULONG               NumberOfReceiveQueues;
} NDIS_RECEIVE_SCALE_CAPABILITIES;
typedef NDIS_RECEIVE_SCALE_CAPABILITIES *PNDIS_RECEIVE_SCALE_CAPABILITIES;
#endif

/* NDIS receive scale parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_RECEIVE_SCALE_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    USHORT              Flags;
    USHORT              BaseCpuNumber;
    ULONG               HashInformation;
    USHORT              IndirectionTableSize;
    ULONG               IndirectionTableOffset;
    USHORT              HashSecretKeySize;
    ULONG               HashSecretKeyOffset;
#if NDIS_SUPPORT_NDIS620
    ULONG               ProcessorMasksOffset;
    ULONG               NumberOfProcessorMasks;
    ULONG               ProcessorMasksEntrySize;
#endif
} NDIS_RECEIVE_SCALE_PARAMETERS;
typedef NDIS_RECEIVE_SCALE_PARAMETERS   *PNDIS_RECEIVE_SCALE_PARAMETERS;
#endif

/* NDIS receive hash parameters */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef struct _NDIS_RECEIVE_HASH_PARAMETERS {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    ULONG               HashInformation;
    USHORT              HashSecretKeySize;
    ULONG               HashSecretKeyOffset;
} NDIS_RECEIVE_HASH_PARAMETERS;
typedef NDIS_RECEIVE_HASH_PARAMETERS    *PNDIS_RECEIVE_HASH_PARAMETERS;
#endif

/* NDIS processor vendors */
#if (NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6
typedef enum _NDIS_PROCESSOR_VENDOR {
    NdisProcessorVendorUnknown      = 0,
    NdisProcessorVendorGenuinIntel  = 1,
    NdisProcessorVendorGenuineIntel = NdisProcessorVendorGenuinIntel,
    NdisProcessorVendorAuthenticAMD = 2
} NDIS_PROCESSOR_VENDOR;
typedef NDIS_PROCESSOR_VENDOR   *PNDIS_PROCESSOR_VENDOR;
#endif

/* NDIS RSS processor */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RSS_PROCESSOR {
    PROCESSOR_NUMBER    ProcNum;
    USHORT              PreferenceIndex;
    USHORT              Reserved;
} NDIS_RSS_PROCESSOR;
typedef NDIS_RSS_PROCESSOR  *PNDIS_RSS_PROCESSOR;
#endif

/* NDIS RSS processor information */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_RSS_PROCESSOR_INFO {
    NDIS_OBJECT_HEADER  Header;
    ULONG               Flags;
    PROCESSOR_NUMBER    RssBaseProcessor;
    ULONG               MaxNumRssProcessors;
    USHORT              PreferredNumaNode;
    ULONG               RssProcessorArrayOffset;
    ULONG               RssProcessorCount;
    ULONG               RssProcessorEntrySize;
} NDIS_RSS_PROCESSOR_INFO;
typedef NDIS_RSS_PROCESSOR_INFO *PNDIS_RSS_PROCESSOR_INFO;
#endif

/* NDIS processor information (extended version) */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_PROCESSOR_INFO_EX {
    PROCESSOR_NUMBER    ProcNum;
    ULONG               SocketId;
    ULONG               CoreId;
    ULONG               HyperThreadId;
    USHORT              NodeId;
    USHORT              NodeDistance;
} NDIS_PROCESSOR_INFO_EX;
typedef NDIS_PROCESSOR_INFO_EX  *PNDIS_PROCESSOR_INFO_EX;
#endif

/* NDIS system processor information (extended version) */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_SYSTEM_PROCESSOR_INFO_EX {
    NDIS_OBJECT_HEADER      Header;
    ULONG                   Flags;
    NDIS_PROCESSOR_VENDOR   ProcessorVendor;
    ULONG                   NumSockets;
    ULONG                   NumCores;
    ULONG                   NumCoresPerSocket;
    ULONG                   MaxHyperThreadingProcsPerCore;
    ULONG                   ProcessorInfoOffset;
    ULONG                   NumberOfProcessors;
    ULONG                   ProcessorInfoEntrySize;
} NDIS_SYSTEM_PROCESSOR_INFO_EX;
typedef NDIS_SYSTEM_PROCESSOR_INFO_EX   *PNDIS_SYSTEM_PROCESSOR_INFO_EX;
#endif

/* NDIS hypervisor partition types */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef enum _NDIS_HYPERVISOR_PARTITION_TYPE {
    NdisHypervisorPartitionTypeUnknown      = 0,
    NdisHypervisorPartitionTypeMsHvParent   = 1,
    NdisHypervisorPartitionMsHvChild        = 2,
    NdisHypervisorPartitionTypeMax          = 3
} NDIS_HYPERVISOR_PARTITION_TYPE;
typedef NDIS_HYPERVISOR_PARTITION_TYPE  *PNDIS_HYPERVISOR_PARTITION_TYPE;
#endif

/* NDIS hypervisor information */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_HYPERVISOR_INFO {
    NDIS_OBJECT_HEADER              Header;
    ULONG                           Flags;
    NDIS_HYPERVISOR_PARTITION_TYPE  PartitionType;
} NDIS_HYPERVISOR_INFO;
typedef NDIS_HYPERVISOR_INFO    *PNDIS_HYPERVISOR_INFO;
#endif

/* NDIS WMI group affinity */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_WMI_GROUP_AFFINITY {
    ULONG64 Mask;
    USHORT  Group;
    USHORT  Reserved[3];
} NDIS_WMI_GROUP_AFFINITY;
typedef NDIS_WMI_GROUP_AFFINITY *PNDIS_WMI_GROUP_AFFINITY;
#endif

/* NDIS WMI receive queue parameters */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_WMI_RECEIVE_QUEUE_PARAMETERS {
    NDIS_OBJECT_HEADER          Header;
    ULONG                       Flags;
    NDIS_RECEIVE_QUEUE_TYPE     QueueType;
    NDIS_RECEIVE_QUEUE_ID       QueueId;
    NDIS_RECEIVE_QUEUE_GROUP_ID QueueGroupId;
    NDIS_WMI_GROUP_AFFINITY     ProcessorAffinity;
    ULONG                       NumSuggestedReceiveBuffers;
    ULONG                       MSIXTableEntry;
    ULONG                       LookaheadSize;
    NDIS_VM_NAME                VmName;
    NDIS_QUEUE_NAME             QueueName;
} NDIS_WMI_RECEIVE_QUEUE_PARAMETERS;
typedef NDIS_WMI_RECEIVE_QUEUE_PARAMETERS   *PNDIS_WMI_RECEIVE_QUEUE_PARAMETERS;
#endif

/* NDIS WMI receive queue information */
#if ((NTDDI_VERSION >= 0x06000000) || NDIS_SUPPORT_NDIS6) && NDIS_SUPPORT_NDIS620
typedef struct _NDIS_WMI_RECEIVE_QUEUE_INFO {
    NDIS_OBJECT_HEADER                      Header;
    ULONG                                   Flags;
    NDIS_RECEIVE_QUEUE_TYPE                 QueueType;
    NDIS_RECEIVE_QUEUE_ID                   QueueId;
    NDIS_RECEIVE_QUEUE_GROUP_ID             QueueGroupId;
    NDIS_RECEIVE_QUEUE_OPERATIONAL_STATE    QueueState;
    NDIS_WMI_GROUP_AFFINITY                 ProcessorAffinity;
    ULONG                                   NumSuggestedReceiveBuffers;
    ULONG                                   MSIXTableEntry;
    ULONG                                   LookaheadSize;
    NDIS_VM_NAME                            VmName;
    NDIS_QUEUE_NAME                         QueueName;
} NDIS_WMI_RECEIVE_QUEUE_INFO;
typedef NDIS_WMI_RECEIVE_QUEUE_INFO *PNDIS_WMI_RECEIVE_QUEUE_INFO;
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDDNDIS_ */
