/*
 *  mswsock.h   Windows Sockets extension functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _MSWSOCK_
#define _MSWSOCK_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Socket options */
#define SO_CONNDATA                     0x7000
#define SO_CONNOPT                      0x7001
#define SO_DISCDATA                     0x7002
#define SO_DISCOPT                      0x7003
#define SO_CONNDATALEN                  0x7004
#define SO_CONNOPTLEN                   0x7005
#define SO_DISCDATALEN                  0x7006
#define SO_DISCOPTLEN                   0x7007
#define SO_OPENTYPE                     0x7008
#define SO_MAXDG                        0x7009
#define SO_MAXPATHDG                    0x700A
#define SO_UPDATE_ACCEPT_CONTEXT        0x700B
#define SO_CONNECT_TIME                 0x700C
#if (_WIN32_WINNT >= 0x0501)
    #define SO_UPDATE_CONNECT_CONTEXT   0x7010
#endif

/* Socket open types */
#define SO_SYNCHRONOUS_ALERT    0x10
#define SO_SYNCHRONOUS_NONALERT 0x20

/* TCP options */
#define TCP_BSDURGENT   0x7000

/* Socket I/O control codes */
#define SIO_UPD_CONNRESET           _WSAIOW( IOC_VENDOR, 12 )
#if (_WIN32_WINNT < 0x0600) && (_WIN32_WINNT >= 0x0501)
    #define SIO_SOCKET_CLOSE_NOTIFY _WSAIOW( IOC_VENDOR, 13 )
#endif
#define SIO_UPD_NETRESET            _WSAIOW( IOC_VENDOR, 15 )
#if (_WIN32_WINNT >= 0x0600)
    #define SIO_BSP_HANDLE          _WSAIOR( IOC_WS2, 27 )
    #define SIO_BSP_HANDLE_SELECT   _WSAIOR( IOC_WS2, 28 )
    #define SIO_BSP_HANDLE_POLL     _WSAIOR( IOC_WS2, 29 )
    #define SIO_EXT_SELECT          _WSAIORW( IOC_WS2, 30 )
    #define SIO_EXT_POLL            _WSAIORW( IOC_WS2, 31 )
    #define SIO_EXT_SENDMSG         _WSAIORW( IOC_WS2, 32 )
    #define SIO_BASE_HANDLE         _WSAIOR( IOC_WS2, 34 )
#endif

/* TransmitFile() flags */
#if (_WIN32_WINNT >= 0x0501)
    #define TF_DISCONNECT           0x00000001L
    #define TF_REUSE_SOCKET         0x00000002L
    #define TF_WRITE_BEHIND         0x00000004L
    #define TF_USE_DEFAULT_WORKER   0x00000000L
    #define TF_USE_SYSTEM_THREAD    0x00000010L
    #define TF_USE_KERNEL_APC       0x00000020L
#endif

/* WSAID_TRANSMITPACKETS element flags */
#if (_WIN32_WINNT >= 0x0501)
    #define TP_ELEMENT_MEMORY   1L
    #define TP_ELEMENT_FILE     2L
    #define TP_ELEMENT_EOP      4L
#endif

/* WSAID_TRANSMITPACKETS flags */
#if (_WIN32_WINNT >= 0x0501)
    #define TP_DISCONNECT           TF_DISCONNECT
    #define TP_REUSE_SOCKET         TF_REUSE_SOCKET
    #define TP_USE_DEFAULT_WORKER   TF_USE_DEFAULT_WORKER
    #define TP_USE_SYSTEM_THREAD    TF_USE_SYSTEM_THREAD
    #define TP_USE_KERNEL_APC       TF_USE_KERNEL_APC
#endif

/* WSAID_DISCONNECTEX flags */
#if (_WIN32_WINNT >= 0x0501)
    #define DE_REUSE_SOCKET TF_REUSE_SOCKET
#endif

/* Function identifiers */
#define WSAID_TRANSMITFILE \
    { 0xB5367DF0, 0xCBAC, 0x11CF, { 0x95, 0xCA, 0x00, 0x80, 0x5F, 0x48, 0xA1, 0x92 } }
#define WSAID_ACCEPTEX \
    { 0xB5367DF1, 0xCBAC, 0x11CF, { 0x95, 0xCA, 0x00, 0x80, 0x5F, 0x48, 0xA1, 0x92 } }
#define WSAID_GETACCEPTEXSOCKADDRS \
    { 0xB5367DF2, 0xCBAC, 0x11CF, { 0x95, 0xCA, 0x00, 0x80, 0x5F, 0x48, 0xA1, 0x92 } }
#if (_WIN32_WINNT >= 0x0501)
    #define WSAID_TRANSMITPACKETS \
        { 0xD9689DA0, 0x1F90, 0x11D3, { 0x99, 0x71, 0x00, 0xC0, 0x4F, 0x68, 0xC8, 0x76 } }
    #define WSAID_CONNECTEX \
        { 0x25A207B9, 0xDDF3, 0x4660, { 0x8E, 0xE9, 0x76, 0xE5, 0x8C, 0x74, 0x06, 0x3E } }
    #define WSAID_DISCONNECTEX \
        { 0x7FDA2E11, 0x8630, 0x436F, { 0xA0, 0x31, 0xF5, 0x36, 0xA6, 0xEE, 0xC1, 0x57 } }
    #define WSAID_WSARECVMSG \
        { 0xF689D7C8, 0x6F1F, 0x436B, { 0x8A, 0x53, 0xE5, 0x4F, 0xE3, 0x51, 0xC3, 0x22 } }
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define WSAID_WSASENGMSG \
        { 0xA441E712, 0x754F, 0x43CA, { 0x84, 0xA7, 0x0D, 0xEE, 0x44, 0xCF, 0x60, 0x6D } }
    #define WSAID_WSAPOLL \
        { 0x18C76F85, 0xDC66, 0x4964, { 0x97, 0x2E, 0x23, 0xC2, 0x72, 0x38, 0x31, 0x2B } }
#endif

/* Network location awareness identifiers */
#if (_WIN32_WINNT >= 0x0501)
    #define NLA_NAMESPACE_GUID \
        { 0x6642243A, 0x3BA8, 0x4AA6, { 0xBA, 0xA5, 0x2E, 0x0B, 0xD7, 0x1F, 0xDD, 0x83 } }
    #define NLA_SERVICE_CLASS_GUID \
        { 0x0037E515, 0xB5C9, 0x4A43, { 0xBA, 0xDA, 0x8B, 0x48, 0xA8, 0x7A, 0xD2, 0x39 } }
#endif

/* Network location awareness flags */
#if (_WIN32_WINNT >= 0x0501)
    #define NLA_ALLUSERS_NETWORK    0x00000001L
    #define NLA_FRIENDLY_NAME       0x00000002L
#endif

/* TransmitFile() buffers */
typedef struct _TRANSMIT_FILE_BUFFERS {
    LPVOID  Head;
    DWORD   HeadLength;
    LPVOID  Tail;
    DWORD   TailLength;
} TRANSMIT_FILE_BUFFERS;
typedef TRANSMIT_FILE_BUFFERS   *PTRANSMIT_FILE_BUFFERS;
typedef TRANSMIT_FILE_BUFFERS   *LPTRANSMIT_FILE_BUFFERS;

/* WSAID_TRANSMITPACKETS element */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _TRANSMIT_PACKETS_ELEMENT {
    ULONG   dwElFlags;
    ULONG   cLength;
    union {
        struct {
            LARGE_INTEGER   nFileOffset;
            HANDLE          hFile;
        };
        PVOID   pBuffer;
    };
} TRANSMIT_PACKETS_ELEMENT;
typedef TRANSMIT_PACKETS_ELEMENT    *PTRANSMIT_PACKETS_ELEMENT;
typedef TRANSMIT_PACKETS_ELEMENT    *LPTRANSMIT_PACKETS_ELEMENT;
#endif

/* WSAPoll() data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct {
    int         result;
    ULONG       fds;
    INT         timeout;
    WSAPOLLFD   fdArray[1];
} WSAPOLLDATA;
typedef WSAPOLLDATA *LPWSAPOLLDATA;
#endif

/* WSASendMsg() data */
#if (_WIN32_WINNT >= 0x0600)
typedef struct {
    LPWSAMSG                            lpMsg;
    DWORD                               dwFlags;
    LPDWORD                             lpNumberOfBytesSent;
    LPWSAOVERLAPPED                     lpOverlapped;
    LPWSAOVERLAPPED_COMPLETION_ROUTINE  lpCompletionRoutine;
} WSASENDMSG;
typedef WSASENDMSG  *LPWSASENDMSG;
#endif

/* Function pointers */
typedef BOOL (PASCAL *LPFN_TRANSMITFILE)( SOCKET, HANDLE, DWORD, DWORD, LPOVERLAPPED, LPTRANSMIT_FILE_BUFFERS, DWORD );
typedef BOOL (PASCAL *LPFN_ACCEPTEX)( SOCKET, SOCKET, PVOID, DWORD, DWORD, DWORD, LPDWORD, LPOVERLAPPED );
typedef VOID (PASCAL *LPFN_GETACCEPTEXSOCKADDRS)( PVOID, DWORD, DWORD, DWORD, struct sockaddr **, LPINT, struct sockaddr **, LPINT );
#if (_WIN32_WINNT >= 0x0501)
typedef BOOL (PASCAL *LPFN_TRANSMITPACKETS)( SOCKET, LPTRANSMIT_PACKETS_ELEMENT, DWORD, DWORD, LPOVERLAPPED, DWORD );
typedef BOOL (PASCAL *LPFN_CONNECTEX)( SOCKET, const struct sockaddr *, int, PVOID, DWORD, LPDWORD, LPOVERLAPPED );
typedef BOOL (PASCAL *LPFN_DISCONNECTEX)( SOCKET, LPOVERLAPPED, DWORD, DWORD );
typedef INT (PASCAL *LPFN_WSARECVMSG)( SOCKET, LPWSAMSG, LPDWORD, LPWSAOVERLAPPED, LPWSAOVERLAPPED_COMPLETION_ROUTINE );
#endif
#if (_WIN32_WINNT >= 0x0600)
typedef INT (PASCAL *LPFN_WSASENDMSG)( SOCKET, LPWSAMSG, DWORD, LPDWORD, LPWSAOVERLAPPED, LPWSAOVERLAPPED_COMPLETION_ROUTINE );
typedef INT (PASCAL *LPFN_WSAPOLL)( LPWSAPOLLFD, ULONG, INT );
#endif

/* Network location awareness blob data types */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _NLA_BLOB_DATA_TYPE {
    NLA_RAW_DATA        = 0,
    NLA_INTERFACE       = 1,
    NLA_802_1X_LOCATION = 2,
    NLA_CONNECTIVITY    = 3,
    NLA_ICS             = 4,
} NLA_BLOB_DATA_TYPE;
typedef NLA_BLOB_DATA_TYPE  *PNLA_BLOB_DATA_TYPE;
#endif

/* Network location awareness connectivity types */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _NLA_CONNECTIVITY_TYPE {
    NLA_NETWORK_AD_HOC      = 0,
    NLA_NETWORK_MANAGED     = 1,
    NLA_NETWORK_UNMANAGED   = 2,
    NLA_NETWORK_UNKNOWN     = 3,
} NLA_CONNECTIVITY_TYPE;
typedef NLA_CONNECTIVITY_TYPE   *PNLA_CONNECTIVITY_TYPE;
#endif

/* Network location awareness Internet values */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _NLA_INTERNET {
    NLA_INTERNET_UNKNOWN    = 0,
    NLA_INTERNET_NO         = 1,
    NLA_INTERNET_YES        = 2
} NLA_INTERNET;
typedef NLA_INTERNET    *PNLA_INTERNET;
#endif

/* Network location awareness blob */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _NLA_BLOB {
    struct {
        NLA_BLOB_DATA_TYPE  type;
        DWORD               dwSize;
        DWORD               nextOffset;
    } header;
    union {
        CHAR    rawData[1];
        struct {
            DWORD   dwType;
            DWORD   dwSpeed;
            CHAR    adapterName[1];
        } interfaceData;
        struct {
            CHAR    information[1];
        } locationData;
        struct {
            NLA_CONNECTIVITY_TYPE   type;
            NLA_INTERNET            internet;
        } connectivity;
        struct {
            struct {
                DWORD   speed;
                DWORD   type;
                DWORD   state;
                WCHAR   machineName[256];
                WCHAR   sharedAdapterName[256];
            } remote;
        } ICS;
    } data;
} NLA_BLOB;
typedef NLA_BLOB    *PNLA_BLOB;
typedef NLA_BLOB    *LPNLA_BLOB;
#endif

/* Functions in MSWSOCK.DLL */
BOOL PASCAL AcceptEx( SOCKET, SOCKET, PVOID, DWORD, DWORD, DWORD, LPDWORD, LPOVERLAPPED );
VOID PASCAL GetAcceptExSockaddrs( PVOID, DWORD, DWORD, DWORD, struct sockaddr **, LPINT, struct sockaddr **, LPINT );
BOOL PASCAL TransmitFile( SOCKET, HANDLE, DWORD, DWORD, LPOVERLAPPED, LPTRANSMIT_FILE_BUFFERS, DWORD );
#if (_WIN32_WINNT >= 0x0600)
int PASCAL  WSARecvEx( SOCKET, CHAR *, INT, INT * );
#else
int PASCAL  WSARecvEx( SOCKET, char *, int, int * );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _MSWSOCK_ */
