/*
 *  mpegtype.h  MPEG data types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __MPEGTYPE__
#define __MPEGTYPE__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ActiveMovie MPEG audio dual modes */
#define AM_MPEG_AUDIO_DUAL_MERGE    0L
#define AM_MPEG_AUDIO_DUAL_LEFT     1L
#define AM_MPEG_AUDIO_DUAL_RIGHT    2L

/* ActiveMovie MPEG stream type */
typedef struct tagAM_MPEGSTREAMTYPE {
    DWORD           dwStreamId;
    DWORD           dwReserved;
    AM_MEDIA_TYPE   mt;
    BYTE            bFormat[1];
} AM_MPEGSTREAMTYPE;

/* ActiveMovie MPEG system type */
typedef struct tagAM_MPEGSYSTEMTYPE {
    DWORD               dwBitRate;
    DWORD               cStreams;
    AM_MPEGSTREAMTYPE   Streams[1];
} AM_MPEGSYSTEMTYPE;

/* IMpegAudioDecoder interface */
#undef INTERFACE
#define INTERFACE   IMpegAudioDecoder
DECLARE_INTERFACE_( IMpegAudioDecoder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMpegAudioDecoder methods */
    STDMETHOD( get_FrequencyDivider )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_FrequencyDivider )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_DecoderAccuracy )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_DecoderAccuracy )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_Stereo )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_Stereo )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_DecoderWordSize )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_DecoderWordSize )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_IntegerDecode )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_IntegerDecode )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_DualMode )( THIS_ unsigned long * ) PURE;
    STDMETHOD( put_DualMode )( THIS_ unsigned long ) PURE;
    STDMETHOD( get_AudioFormat )( THIS_ MPEG1WAVEFORMAT * ) PURE;
};

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __MPEGTYPE__ */
