/*
 *  lmjoin.h    LAN Manager join functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __LMJOIN_H__
#define __LMJOIN_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Network setup join flags */
#define NETSETUP_JOIN_DOMAIN                0x00000001L
#define NETSETUP_ACCT_CREATE                0x00000002L
#define NETSETUP_ACCT_DELETE                0x00000004L
#define NETSETUP_WIN9X_UPGRADE              0x00000010L
#define NETSETUP_DOMAIN_JOIN_IF_JOINED      0x00000020L
#define NETSETUP_JOIN_UNSECURE              0x00000040L
#define NETSETUP_MACHINE_PWD_PASSED         0x00000080L
#define NETSETUP_DEFER_SPN_SET              0x00000100L
#define NETSETUP_JOIN_DC_ACCOUNT            0x00000200L
#define NETSETUP_JOIN_WITH_NEW_NAME         0x00000400L
#define NETSETUP_JOIN_READONLY              0x00000800L
#define NETSETUP_DNS_NAME_CHANGES_ONLY      0x00001000L
#define NETSETUP_AMBIGUOUS_DC               0x00001000L
#define NETSETUP_NO_NETLOGON_CACHE          0x00002000L
#define NETSETUP_DONT_CONTROL_SERVICES      0x00004000L
#define NETSETUP_SET_MACHINE_NAME           0x00008000L
#define NETSETUP_FORCE_SPN_SET              0x00010000L
#define NETSETUP_NO_ACCT_REUSE              0x00020000L
#define NETSETUP_INSTALL_INVOCATION         0x00040000L
#define NETSETUP_IGNORE_UNSUPPORTED_FLAGS   0x10000000L
#define NETSETUP_VALID_UNJOIN_FLAGS \
    (NETSETUP_ACCT_DELETE | NETSETUP_INGORE_UNSUPPORTED_FLAGS | NETSETUP_JOIN_DC_ACCOUNT)
#define NETSETUP_PROCESS_OFFLINE_FLAGS \
    (NETSETUP_JOIN_DOMAIN | NETSETUP_DOMAIN_JOIN_IF_JOINED | \
    NETSETUP_JOIN_WITH_NEW_NAME | NETSETUP_DONT_CONTROL_SERVICES | \
    NETSETUP_MACHINE_PWD_PASSED)

/* NetProvisionComputerAccount() flags */
#if (_WIN32_WINNT >= 0x0601)
    #define NETSETUP_PROVISION_DOWNLEVEL_PRIV_SUPPORT   0x00000001L
    #define NETSETUP_PROVISION_REUSE_ACCOUNT            0x00000002L
    #define NETSETUP_PROVISION_USE_DEFAULT_PASSWORD     0x00000004L
    #define NETSETUP_PROVISION_SKIP_ACCOUNT_SEARCH      0x00000008L
    #define NETSETUP_PROVISION_ONLINE_CALLER            0x40000000L
    #define NETSETUP_PROVISION_CHECK_PWD_ONLY           0x80000000L
#endif

/* NetAddAlternateComputerName() flags */
#if (_WIN32_WINNT >= 0x0501)
    #define NET_IGNORE_UNSUPPORTED_FLAGS    0x00000001L
#endif

/* Network setup name types */
typedef enum _NETSETUP_NAME_TYPE {
    NetSetupUnknown             = 0,
    NetSetupMachine             = 1,
    NetSetupWorkgroup           = 2,
    NetSetupDomain              = 3,
#if (_WIN32_WINNT >= 0x0500)
    NetSetupNonExistentDomain   = 4,
    NetSetupDnsMachine          = 5
#else
    NetSetupNonExistentDomain   = 4
#endif
} NETSETUP_NAME_TYPE;
typedef NETSETUP_NAME_TYPE  *PNETSETUP_NAME_TYPE;

/* Network setup join status values */
typedef enum _NETSETUP_JOIN_STATUS {
    NetSetupUnknownStatus   = 0,
    NetSetupUnjoined        = 1,
    NetSetupWorkgroupName   = 2,
    NetSetupDomainName      = 3
} NETSETUP_JOIN_STATUS;
typedef NETSETUP_JOIN_STATUS    *PNETSETUP_JOIN_STATUS;

/* Network computer name types */
#if (_WIN32_WINNT >= 0x0501)
typedef enum _NET_COMPUTER_NAME_TYPE {
    NetPrimaryComputerName      = 0,
    NetAlternateComputerNames   = 1,
    NetAllComputerNames         = 2,
    NetComputerNameTypeMax      = 3
} NET_COMPUTER_NAME_TYPE;
typedef NET_COMPUTER_NAME_TYPE  *PNET_COMPUTER_NAME_TYPE;
#endif

/* Functions in NETAPI32.DLL */
NET_API_STATUS NET_API_FUNCTION NetGetJoinInformation( LPCWSTR, LPWSTR *, PNETSETUP_JOIN_STATUS );
NET_API_STATUS NET_API_FUNCTION NetGetJoinableOUs( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, DWORD *, LPWSTR ** );
NET_API_STATUS NET_API_FUNCTION NetJoinDomain( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, DWORD );
NET_API_STATUS NET_API_FUNCTION NetRenameMachineInDomain( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, DWORD );
NET_API_STATUS NET_API_FUNCTION NetUnjoinDomain( LPCWSTR, LPCWSTR, LPCWSTR, DWORD );
NET_API_STATUS NET_API_FUNCTION NetValidateName( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, NETSETUP_NAME_TYPE );
#if (_WIN32_WINNT >= 0x0501)
NET_API_STATUS NET_API_FUNCTION NetAddAlternateComputerName( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, ULONG );
NET_API_STATUS NET_API_FUNCTION NetEnumerateComputerNames( LPCWSTR, NET_COMPUTER_NAME_TYPE, ULONG, PDWORD, LPWSTR ** );
NET_API_STATUS NET_API_FUNCTION NetRemoveAlternateComputerName( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, ULONG );
NET_API_STATUS NET_API_FUNCTION NetSetPrimaryComputerName( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, ULONG );
#endif
#if (_WIN32_WINNT >= 0x0601)
NET_API_STATUS NET_API_FUNCTION NetProvisionComputerAccount( LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, DWORD, PBYTE *, DWORD *, LPWSTR * );
NET_API_STATUS NET_API_FUNCTION NetRequestOfflineDomainJoin( BYTE *, DWORD, DWORD, LPCWSTR );
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __LMJOIN_H__ */
