/*
 *  ktmtypes.h  Kernel transaction manager data types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _KTMTYPES_
#define _KTMTYPES_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Primitive data types */
typedef GUID    UOW;
typedef GUID    *PUOW;
typedef GUID    CRM_PROTOCOL_ID;
typedef GUID    *PCRM_PROTOCOL_ID;
typedef ULONG   NOTIFICATION_MASK;
typedef ULONG   SAVEPOINT_ID;
typedef ULONG   *PSAVEPOINT_ID;

/* Transaction manager options */
#define TRANSACTION_MANAGER_VOLATILE                0x00000001L
#define TRANSACTION_MANAGER_COMMIT_DEFAULT          0x00000000L
#define TRANSACTION_MANAGER_COMMIT_SYSTEM_VOLUME    0x00000002L
#define TRANSACTION_MANAGER_COMMIT_SYSTEM_HIVES     0x00000004L
#define TRANSACTION_MANAGER_COMMIT_LOWEST           0x00000008L
#define TRANSACTION_MANAGER_CORRUPT_FOR_RECOVERY    0x00000010L
#define TRANSACTION_MANAGER_CORRUPT_FOR_PROGRESS    0x00000020L
#define TRANSACTION_MANAGER_MAXIMUM_OPTION          0x0000003FL

/* Transaction options */
#define TRANSACTION_DO_NOT_PROMOTE  0x00000001L
#define TRANSACTION_MAXIMUM_OPTION  0x00000001L

/* Resource manager options */
#define RESOURCE_MANAGER_VOLATILE       0x00000001L
#define RESOURCE_MANAGER_COMMUNICATION  0x00000002L
#define RESOURCE_MANAGER_MAXIMUM_OPTION 0x00000003L

/* Protocol registration options */
#define CRM_PROTOCOL_EXPLICIT_MARSHAL_ONLY  0x00000001L
#define CRM_PROTOCOL_DYNAMIC_MARSHAL_INFO   0x00000002L
#define CRM_PROTOCOL_MAXIMUM_OPTION         0x00000003L

/* Enlistment options */
#define ENLISTMENT_SUPERIOR         0x00000001L
#define ENLISTMENT_MAXIMUM_OPTION   0x00000001L

/* Transaction notification masks */
#define TRANSACTION_NOTIFY_MASK                 0x3FFFFFFFL
#define TRANSACTION_NOTIFY_PREPREPARE           0x00000001L
#define TRANSACTION_NOTIFY_PREPARE              0x00000002L
#define TRANSACTION_NOTIFY_COMMIT               0x00000004L
#define TRANSACTION_NOTIFY_ROLLBACK             0x00000008L
#define TRANSACTION_NOTIFY_PREPREPARE_COMPLETE  0x00000010L
#define TRANSACTION_NOTIFY_PREPARE_COMPLETE     0x00000020L
#define TRANSACTION_NOTIFY_COMMIT_COMPLETE      0x00000040L
#define TRANSACTION_NOTIFY_ROLLBACK_COMPLETE    0x00000080L
#define TRANSACTION_NOTIFY_RECOVER              0x00000100L
#define TRANSACTION_NOTIFY_SINGLE_PHASE_COMMIT  0x00000200L
#define TRANSACTION_NOTIFY_DELEGATE_COMMIT      0x00000400L
#define TRANSACTION_NOTIFY_RECOVER_QUERY        0x00000800L
#define TRANSACTION_NOTIFY_ENLIST_PREPREPARE    0x00001000L
#define TRANSACTION_NOTIFY_LAST_RECOVER         0x00002000L
#define TRANSACTION_NOTIFY_INDOUBT              0x00004000L
#define TRANSACTION_NOTIFY_PROPAGATE_PULL       0x00008000L
#define TRANSACTION_NOTIFY_PROPAGATE_PUSH       0x00010000L
#define TRANSACTION_NOTIFY_MARSHAL              0x00020000L
#define TRANSACTION_NOTIFY_ENLIST_MASK          0x00040000L
#define TRANSACTION_NOTIFY_SAVEPOINT            0x00080000L
#define TRANSACTION_NOTIFY_SAVEPOINT_COMPLETE   0x00100000L
#define TRANSACTION_NOTIFY_CLEAR_SAVEPOINT      0x00200000L
#define TRANSACTION_NOTIFY_CLEAR_ALL_SAVEPOINTS 0x00400000L
#define TRANSACTION_NOTIFY_ROLLBACK_SAVEPOINT   0x00800000L
#define TRANSACTION_NOTIFY_RM_DISCONNECTED      0x01000000L
#define TRANSACTION_NOTIFY_TM_ONLINE            0x02000000L
#define TRANSACTION_NOTIFY_COMMIT_REQUEST       0x04000000L
#define TRANSACTION_NOTIFY_PROMOTE              0x08000000L
#define TRANSACTION_NOTIFY_PROMOTE_NEW          0x10000000L
#define TRANSACTION_NOTIFY_REQUEST_OUTCOME      0x20000000L
#define TRANSACTION_NOTIFY_COMMIT_FINALIZE      0x40000000L

/* Transaction manager object paths */
#define TRANSACTIONMANAGER_OBJECT_PATH  L"\\TransactionManager\\"
#define TRANSACTION_OBJECT_PATH         L"\\Transaction\\"
#define ENLISTMENT_OBJECT_PATH          L"\\Enlistment\\"
#define RESOURCE_MANAGER_OBJECT_PATH    L"\\ResourceManager\\"

/* Transation notification TM online flags */
#define TRANSACTION_NOTIFICATION_TM_ONLINE_FLAG_IS_CLUSTERED    0x00000001L

/* Transaction manager object name lengths */
#define TRANSACTIONMANAGER_OBJECT_NAME_LENGTH_IN_BYTES \
    (sizeof( TRANSACTIONMANAGER_OBJECT_PATH ) + (38 * sizeof( WCHAR )))
#define TRANSACTION_OBJECT_NAME_LENGTH_IN_BYTES \
    (sizeof( TRANSACTION_OBJECT_PATH ) + (38 * sizeof( WCHAR )))
#define ENLISTMENT_OBJECT_NAME_LENGTH_IN_BYTES \
    (sizeof( ENLISTMENT_OBJECT_PATH ) + (38 * sizeof( WCHAR )))
#define RESOURCE_MANAGER_OBJECT_NAME_LENGTH_IN_BYTES \
    (sizeof( RESOURCE_MANAGER_OBJECT_PATH ) + (38 * sizeof( WCHAR )))

/* Kernel transaction manager marshal blob version */
#define KTM_MARSHAL_BLOB_VERSION_MAJOR  1
#define KTM_MARSHAL_BLOB_VERSION_MINOR  1

/* Maximum lengths */
#define MAX_TRANSACTION_DESCRIPTION_LENGTH      64
#define MAX_RESOURCEMANAGER_DESCRIPTION_LENGTH  64

/* Transaction notification */
typedef struct _TRANSACTION_NOTIFICATION {
    PVOID           TransactionKey;
    ULONG           TransactionNotification;
    LARGE_INTEGER   TmVirtualClock;
    ULONG           ArgumentLength;
} TRANSACTION_NOTIFICATION;
typedef TRANSACTION_NOTIFICATION    *PTRANSACTION_NOTIFICATION;

/* Transaction notification recovery argument */
typedef struct _TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT {
    GUID    EnlistmentId;
    UOW     UOW;
} TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT  *PTRANSACTION_NOTIFICATION_RECOVERY_ARGUMENT;

/* Transaction notification TM online argument */
typedef struct _TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT {
    GUID    TmIdentity;
    ULONG   Flags;
} TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT *PTRANSACTION_NOTIFICATION_TM_ONLINE_ARGUMENT;

/* Transaction notification save point argument */
typedef struct _TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT {
    SAVEPOINT_ID    SavepointId;
} TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT *PTRANSACTION_NOTIFICATION_SAVEPOINT_ARGUMENT;

/* Transaction notification propagate argument */
typedef struct _TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT {
    ULONG   PropagationCookie;
    GUID    UOW;
    GUID    TmIdentity;
    ULONG   BufferLength;
} TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT *PTRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT TRANSACTION_NOTIFICATION_PROMOTE_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_PROPAGATE_ARGUMENT *PTRANSACTION_NOTIFICATION_PROMOTE_ARGUMENT;

/* Transaction notification marshal argument */
typedef struct _TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT {
    ULONG   MarshalCookie;
    GUID    UOW;
} TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT;
typedef TRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT   *PTRANSACTION_NOTIFICATION_MARSHAL_ARGUMENT;

/* Marshal header */
typedef struct _KCRM_MARSHAL_HEADER {
    ULONG   VersionMajor;
    ULONG   VersionMinor;
    ULONG   NumProtocols;
    ULONG   Unused;
} KCRM_MARSHAL_HEADER;
typedef KCRM_MARSHAL_HEADER *PKCRM_MARSHAL_HEADER;
typedef KCRM_MARSHAL_HEADER *PRKCRM_MARSHAL_HEADER;

/* Transaction blob */
typedef struct _KCRM_TRANSACTION_BLOB {
    UOW     UOW;
    GUID    TmIdentity;
    ULONG   IsolationLevel;
    ULONG   IsolationFlags;
    ULONG   Timeout;
    WCHAR   Description[MAX_TRANSACTION_DESCRIPTION_LENGTH];
} KCRM_TRANSACTION_BLOB;
typedef KCRM_TRANSACTION_BLOB   *PKCRM_TRANSACTION_BLOB;
typedef KCRM_TRANSACTION_BLOB   *PRKCRM_TRANSACTION_BLOB;

/* Protocol blob */
typedef struct _KCRM_PROTOCOL_BLOB {
    CRM_PROTOCOL_ID ProtocolId;
    ULONG           StaticInfoLength;
    ULONG           TransactionIdInfoLength;
    ULONG           Unused1;
    ULONG           Unused2;
} KCRM_PROTOCOL_BLOB;
typedef KCRM_PROTOCOL_BLOB  *PKCRM_PROTOCOL_BLOB;
typedef KCRM_PROTOCOL_BLOB  *PRKCRM_PROTOCOL_BLOB;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _KTMTYPES_ */
