/*
 *  ipxtfflt.h  IPX traffic filter definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __ipxfltdf_h
#define __ipxfltdf_h

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* IPX traffic filter actions */
#define IPX_TRAFFIC_FILTER_ACTION_PERMIT    1L
#define IPX_TRAFFIC_FILTER_ACTION_DENY      2L

/* IPX traffic filter definition flags */
#define IPX_TRAFFIC_FILTER_ON_SRCNET    0x00000001L
#define IPX_TRAFFIC_FILTER_ON_SRCNODE   0x00000002L
#define IPX_TRAFFIC_FILTER_ON_SRCSOCKET 0x00000004L
#define IPX_TRAFFIC_FILTER_ON_DSTNET    0x00000010L
#define IPX_TRAFFIC_FILTER_ON_DSTNODE   0x00000020L
#define IPX_TRAFFIC_FILTER_ON_DSTSOCKET 0x00000040L
#define IPX_TRAFFIC_FILTER_ON_PKTTYPE   0x00000100L
#define IPX_TRAFFIC_FILTER_LOG_MATCHES  0x80000000L

/* IPX traffic filter global information */
typedef struct _IPX_TRAFFIC_FILTER_GLOBAL_INFO {
    ULONG   FilterAction;
} IPX_TRAFFIC_FILTER_GLOBAL_INFO;
typedef IPX_TRAFFIC_FILTER_GLOBAL_INFO  *PIPX_TRAFFIC_FILTER_GLOBAL_INFO;

/* IPX traffic filter information */
typedef struct _IPX_TRAFFIC_FILTER_INFO {
    ULONG   FilterDefinition;
    UCHAR   DestinationNetwork[4];
    UCHAR   DestinationNetworkMask[4];
    UCHAR   DestinationNode[6];
    UCHAR   DestinationSocket[2];
    UCHAR   SourceNetwork[4];
    UCHAR   SourceNetworkMask[4];
    UCHAR   SourceNode[6];
    UCHAR   SourceSocket[2];
    UCHAR   PacketType;
} IPX_TRAFFIC_FILTER_INFO;
typedef IPX_TRAFFIC_FILTER_INFO *PIPX_TRAFFIC_FILTER_INFO;

/* Filter interface parameters */
typedef struct _FLT_IF_SET_PARAMS {
    ULONG   InterfaceIndex;
    ULONG   FilterAction;
    ULONG   FilterSize;
} FLT_IF_SET_PARAMS;
typedef FLT_IF_SET_PARAMS   *PFLT_IF_SET_PARAMS;
typedef struct _FLT_IF_GET_PARAMS {
    ULONG   FilterAction;
    ULONG   FilterSize;
    ULONG   TotalSize;
} FLT_IF_GET_PARAMS;
typedef FLT_IF_GET_PARAMS   *PFLT_IF_GET_PARAMS;

/* Filter packet log */
typedef struct _FLT_PACKET_LOG {
    ULONG   SrcIfIdx;
    ULONG   DstIfIdx;
    USHORT  DataSize;
    USHORT  SeqNum;
    UCHAR   Header[30];
} FLT_PACKET_LOG;
typedef FLT_PACKET_LOG  *PFLT_PACKET_LOG;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __ipxfltdf_h */
