/*
 *  dinput.h    DirectInput interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __DINPUT_INCLUDED__
#define __DINPUT_INCLUDED__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#define COM_NO_WINDOWS_H
#include <objbase.h>

#ifdef __cplusplus
extern "C" {
#endif

/* DirectInput version number */
#define DIRECTINPUT_HEADER_VERSION  0x0800
#ifndef DIRECTINPUT_VERSION
    #define DIRECTINPUT_VERSION     DIRECTINPUT_HEADER_VERSION
#endif

/* Forward declarations */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef interface IDirectInputEffect    IDirectInputEffect;
#endif
#if (DIRECTINPUT_VERSION >= 0x0800)
typedef interface IDirectInputDevice8A  IDirectInputDevice8A;
typedef interface IDirectInputDevice8W  IDirectInputDevice8W;
#endif

/* Direct3D color data type */
#if (DIRECTINPUT_VERSION >= 0x0700)
#ifndef D3DCOLOR_DEFINED
#define D3DCOLOR_DEFINED
typedef DWORD   D3DCOLOR;
#endif
#endif

/* DirectInput effect types */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEFT_ALL                   0x00000000L
    #define DIEFT_CONSTANTFORCE         0x00000001L
    #define DIEFT_RAMPFORCE             0x00000002L
    #define DIEFT_PERIODIC              0x00000003L
    #define DIEFT_CONDITION             0x00000004L
    #define DIEFT_CUSTOMFORCE           0x00000005L
    #define DIEFT_HARDWARE              0x000000FFL
    #define DIEFT_FFATTACK              0x00000200L
    #define DIEFT_FFFADE                0x00000400L
    #define DIEFT_SATURATION            0x00000800L
    #define DIEFT_POSNEGCOEFFICIENTS    0x00001000L
    #define DIEFT_POSNEGSATURATION      0x00002000L
    #define DIEFT_DEADBAND              0x00004000L
    #define DIEFT_STARTDELAY            0x00008000L
    #define DIEFT_GETTYPE( x )          LOBYTE( x )
#endif

/* DirectInput units */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DI_DEGREES      100
    #define DI_FFNOMINALMAX 10000
    #define DI_SECONDS      1000000
#endif

/* DirectInput effect flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEFF_OBJECTIDS     0x00000001L
    #define DIEFF_OBJECTOFFSETS 0x00000002L
    #define DIEFF_CARTESIAN     0x00000010L
    #define DIEFF_POLAR         0x00000020L
    #define DIEFF_SPHERICAL     0x00000040L
#endif

/* DirectInput effect parameters */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEP_DURATION               0x00000001L
    #define DIEP_SAMPLEPERIOD           0x00000002L
    #define DIEP_GAIN                   0x00000004L
    #define DIEP_TRIGGERBUTTON          0x00000008L
    #define DIEP_TRIGGERREPEATINTERVAL  0x00000010L
    #define DIEP_AXES                   0x00000020L
    #define DIEP_DIRECTION              0x00000040L
    #define DIEP_ENVELOPE               0x00000080L
    #define DIEP_TYPESPECIFICPARAMS     0x00000100L
    #if (DIRECTINPUT_VERSION >= 0x0600)
        #define DIEP_STARTDELAY         0x00000200L
        #define DIEP_ALLPARAMS_DX5      0x000001FFL
        #define DIEP_ALLPARAMS          0x000003FFL
    #else
        #define DIEP_ALLPARAMS          0x000001FFL
    #endif
    #define DIEP_START                  0x20000000L
    #define DIEP_NORESTART              0x40000000L
    #define DIEP_NODOWNLOAD             0x80000000L
#endif

/* DirectInput effect trigger button special value */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEB_NOTRIGGER  0xFFFFFFFFL
#endif

/* DirectInput effect start modes */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIES_SOLO       0x00000001L
    #define DIES_NODOWNLOAD 0x80000000L
#endif

/* DirectInput effect status flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEGES_PLAYING  0x00000001L
    #define DIEGES_EMULATED 0x00000002L
#endif

/* DirectInput device types */
#if (DIRECTINPUT_VERSION <= 0x0700)
    #define DIDEVTYPE_DEVICE            1
    #define DIDEVTYPE_MOUSE             2
    #define DIDEVTYPE_KEYBOARD          3
    #define DIDEVTYPE_JOYSTICK          4
#else
    #define DI8DEVCLASS_ALL             0
    #define DI8DEVCLASS_DEVICE          1
    #define DI8DEVCLASS_POINTER         2
    #define DI8DEVCLASS_KEYBOARD        3
    #define DI8DEVCLASS_GAMECTRL        4
    #define DI8DEVTYPE_DEVICE           0x11
    #define DI8DEVTYPE_MOUSE            0x12
    #define DI8DEVTYPE_KEYBOARD         0x13
    #define DI8DEVTYPE_JOYSTICK         0x14
    #define DI8DEVTYPE_GAMEPAD          0x15
    #define DI8DEVTYPE_DRIVING          0x16
    #define DI8DEVTYPE_FLIGHT           0x17
    #define DI8DEVTYPE_1STPERSON        0x18
    #define DI8DEVTYPE_DEVICECTRL       0x19
    #define DI8DEVTYPE_SCREENPOINTER    0x1A
    #define DI8DEVTYPE_REMOTE           0x1B
    #define DI8DEVTYPE_SUPPLEMENTAL     0x1C
#endif
#define DIDEVTYPE_HID                   0x00010000L

/* DirectInput mouse device types */
#if (DIRECTINPUT_VERSION <= 0x0700)
    #define DIDEVTYPEMOUSE_UNKNOWN      1
    #define DIDEVTYPEMOUSE_TRADITIONAL  2
    #define DIDEVTYPEMOUSE_FINGERSTICK  3
    #define DIDEVTYPEMOUSE_TOUCHPAD     4
    #define DIDEVTYPEMOUSE_TRACKBALL    5
#else
    #define DI8DEVTYPEMOUSE_UNKNOWN     1
    #define DI8DEVTYPEMOUSE_TRADITIONAL 2
    #define DI8DEVTYPEMOUSE_FINGERSTICK 3
    #define DI8DEVTYPEMOUSE_TOUCHPAD    4
    #define DI8DEVTYPEMOUSE_TRACKBALL   5
    #define DI8DEVTYPEMOUSE_ABSOLUTE    6
#endif

/* DirectInput keyboard device types */
#if (DIRECTINPUT_VERSION <= 0x0700)
    #define DIDEVTYPEKEYBOARD_UNKNOWN       0
    #define DIDEVTYPEKEYBOARD_PCXT          1
    #define DIDEVTYPEKEYBOARD_OLIVETTI      2
    #define DIDEVTYPEKEYBOARD_PCAT          3
    #define DIDEVTYPEKEYBOARD_PCENH         4
    #define DIDEVTYPEKEYBOARD_NOKIA1050     5
    #define DIDEVTYPEKEYBOARD_NOKIA9140     6
    #define DIDEVTYPEKEYBOARD_NEC98         7
    #define DIDEVTYPEKEYBOARD_NEC98LAPTOP   8
    #define DIDEVTYPEKEYBOARD_NEC98106      9
    #define DIDEVTYPEKEYBOARD_JAPAN106      10
    #define DIDEVTYPEKEYBOARD_JAPANAX       11
    #define DIDEVTYPEKEYBOARD_J3100         12
#else
    #define DI8DEVTYPEKEYBOARD_UNKNOWN      0
    #define DI8DEVTYPEKEYBOARD_PCXT         1
    #define DI8DEVTYPEKEYBOARD_OLIVETTI     2
    #define DI8DEVTYPEKEYBOARD_PCAT         3
    #define DI8DEVTYPEKEYBOARD_PCENH        4
    #define DI8DEVTYPEKEYBOARD_NOKIA1050    5
    #define DI8DEVTYPEKEYBOARD_NOIKA9140    6
    #define DI8DEVTYPEKEYBOARD_NEC98        7
    #define DI8DEVTYPEKEYBOARD_NEC98LAPTOP  8
    #define DI8DEVTYPEKEYBOARD_NEC98106     9
    #define DI8DEVTYPEKEYBOARD_JAPAN106     10
    #define DI8DEVTYPEKEYBOARD_JAPANAX      11
    #define DI8DEVTYPEKEYBOARD_J3100        12
#endif

/* DirectInput joystick device types */
#if (DIRECTINPUT_VERSION <= 0x0700)
    #define DIDEVTYPEJOYSTICK_UNKNOWN               1
    #define DIDEVTYPEJOYSTICK_TRADITIONAL           2
    #define DIDEVTYPEJOYSTICK_FLIGHTSTICK           3
    #define DIDEVTYPEJOYSTICK_GAMEPAD               4
    #define DIDEVTYPEJOYSTICK_RUDDER                5
    #define DIDEVTYPEJOYSTICK_WHEEL                 6
    #define DIDEVTYPEJOYSTICK_HEADTRACKER           7
#else
    #define DI8DEVTYPE_LIMITEDGAMESUBTYPE           1
    #define DI8DEVTYPEJOYSTICK_LIMITED              DI8DEVTYPE_LIMITEDGAMESUBTYPE
    #define DI8DEVTYPEJOYSTICK_STANDARD             2
    #define DI8DEVTYPEGAMEPAD_LIMITED               DI8DEVTYPE_LIMITEDGAMESUBTYPE
    #define DI8DEVTYPEGAMEPAD_STANDARD              2
    #define DI8DEVTYPEGAMEPAD_TILT                  3
    #define DI8DEVTYPEDRIVING_LIMITED               DI8DEVTYPE_LIMITEDGAMESUBTYPE
    #define DI8DEVTYPEDRIVING_COMBINEDPEDALS        2
    #define DI8DEVTYPEDRIVING_DUALPEDALS            3
    #define DI8DEVTYPEDRIVING_THREEPEDALS           4
    #define DI8DEVTYPEDRIVING_HANDHELD              5
    #define DI8DEVTYPEFLIGHT_LIMITED                DI8DEVTYPE_LIMITEDGAMESUBTYPE
    #define DI8DEVTYPEFLIGHT_STICK                  2
    #define DI8DEVTYPEFLIGHT_YOKE                   3
    #define DI8DEVTYPEFLIGHT_RC                     4
    #define DI8DEVTYPE1STPERSON_LIMITED             DI8DEVTYPE_LIMITEDGAMESUBTYPE
    #define DI8DEVTYPE1STPERSON_UNKNOWN             2
    #define DI8DEVTYPE1STPERSON_SIXDOF              3
    #define DI8DEVTYPE1STPERSON_SHOOTER             4
    #define DI8DEVTYPESCREENPTR_UNKNOWN             2
    #define DI8DEVTYPESCREENPTR_LIGHTGUN            3
    #define DI8DEVTYPESCREENPTR_LIGHTPEN            4
    #define DI8DEVTYPESCREENPTR_TOUCH               5
    #define DI8DEVTYPEREMOTE_UNKNOWN                2
    #define DI8DEVTYPEDEVICECTRL_UNKNOWN            2
    #define DI8DEVTYPEDEVICECTRL_COMMSSELECTION     3
    #define DI8DEVTYPEDEVICECTRL_COMMSSELECTION_HARDWIRED   4
    #define DI8DEVTYPESUPPLEMENTAL_UNKNOWN          2
    #define DI8DEVTYPESUPPLEMENTAL_2NDHANDCONTROLLER    3
    #define DI8DEVTYPESUPPLEMENTAL_HEADTRACKER      4
    #define DI8DEVTYPESUPPLEMENTAL_HANDTRACKER      5
    #define DI8DEVTYPESUPPLEMENTAL_SHIFTSTICKGATE   6
    #define DI8DEVTYPESUPPLEMENTAL_SHIFTER          7
    #define DI8DEVTYPESUPPLEMENTAL_THROTTLE         8
    #define DI8DEVTYPESUPPLEMENTAL_SPLITTHROTTLE    9
    #define DI8DEVTYPESUPPLEMENTAL_COMBINEDPEDALS   10
    #define DI8DEVTYPESUPPLEMENTAL_DUALPEDALS       11
    #define DI8DEVTYPESUPPLEMENTAL_THREEPEDALS      12
    #define DI8DEVTYPESUPPLEMENTAL_RUDDERPEDALS     13
#endif

/* Macros to manipulate DirectInput device types */
#define GET_DIDEVICE_TYPE( x )      LOBYTE( x )
#define GET_DIDEVICE_SUBTYPE( x )   HIBYTE( x )

/* DirectInput device capability flags */
#define DIDC_ATTACHED               0x00000001L
#define DIDC_POLLEDDEVICE           0x00000002L
#define DIDC_EMULATED               0x00000004L
#define DIDC_POLLEDDATAFORMAT       0x00000008L
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIDC_FORCEFEEDBACK      0x00000100L
    #define DIDC_FFATTACK           0x00000200L
    #define DIDC_FFFADE             0x00000400L
    #define DIDC_SATURATION         0x00000800L
    #define DIDC_POSNEGCOEFFICIENTS 0x00001000L
    #define DIDC_POSNEGSATURATION   0x00002000L
    #define DIDC_DEADBAND           0x00004000L
#endif
#define DIDC_STARTDELAY             0x00008000L
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIDC_ALIAS              0x00010000L
    #define DIDC_PHANTOM            0x00020000L
#endif
#if (DIRECTINPUT_VERSION >= 0x0800)
    #define DIDC_HIDDEN             0x00040000L
#endif

/* DirectInput device object type flags */
#define DIDFT_ALL               0x00000000L
#define DIDFT_RELAXIS           0x00000001L
#define DIDFT_ABSAXIS           0x00000002L
#define DIDFT_AXIS              0x00000003L
#define DIDFT_PSHBUTTON         0x00000004L
#define DIDFT_TGLBUTTON         0x00000008L
#define DIDFT_BUTTON            0x0000000CL
#define DIDFT_POV               0x00000010L
#define DIDFT_COLLECTION        0x00000040L
#define DIDFT_NODATA            0x00000080L
#define DIDFT_ANYINSTANCE       0x00FFFF00L
#define DIDFT_INSTANCEMASK      DIDFT_ANYINSTANCE
#define DIDFT_FFACTUATOR        0x01000000L
#define DIDFT_FFEFFECTTRIGGER   0x02000000L
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIDFT_OUTPUT        0x10000000L
    #define DIDFT_VENDORDEFINED 0x04000000L
    #define DIDFT_ALIAS         0x08000000L
#endif
#ifndef DIDFT_OPTIONAL
    #define DIDFT_OPTIONAL      0x80000000L
#endif
#define DIDFT_NOCOLLECTION      0x00FFFF00L

/* Macros to manipulate DirectInput device object type flags */
#define DIDFT_MAKEINSTANCE( x )     ((WORD)(x) << 8)
#define DIDFT_GETTYPE( x )          LOBYTE( x )
#define DIDFT_GETINSTANCE( x )      LOWORD( (x) >> 8 )
#define DIDFT_ENUMCOLLECTION( x )   ((WORD)(x) << 8)

/* DirectInput data format flags */
#define DIDF_ABSAXIS    0x00000001L
#define DIDF_RELAXIS    0x00000002L

/* DirectInput action flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIA_FORCEFEEDBACK   0x00000001L
    #define DIA_APPMAPPED       0x00000002L
    #define DIA_APPNOMAP        0x00000004L
    #define DIA_NORANGE         0x00000008L
    #define DIA_APPFIXED        0x00000010L
#endif

/* DirectInput action how flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIAH_UNMAPPED       0x00000000L
    #define DIAH_USERCONFIG     0x00000001L
    #define DIAH_APPREQUESTED   0x00000002L
    #define DIAH_HWAPP          0x00000004L
    #define DIAH_HWDEFAULT      0x00000008L
    #define DIAH_DEFAULT        0x00000020L
    #define DIAH_ERROR          0x80000000L
#endif

/* DirectInput action format timestamp special values */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIAFTS_NEWDEVICELOW     0xFFFFFFFFL
    #define DIAFTS_NEWDEVICEHIGH    0xFFFFFFFFL
    #define DIAFTS_UNUSEDDEVICELOW  0x00000000L
    #define DIAFTS_UNUSEDDEVICEHIGH 0x00000000L
#endif

/* IDirectInputDevice8::BuildActionMap() flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIDBAM_DEFAULT      0x00000000L
    #define DIDBAM_PRESERVE     0x00000001L
    #define DIDBAM_INITIALIZE   0x00000002L
    #define DIDBAM_HWDEFAULTS   0x00000004L
#endif

/* IDirectInputDevice8::SetActionMap() flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIDSAM_DEFAULT      0x00000000L
    #define DIDSAM_NOUSER       0x00000001L
    #define DIDSAM_FORCESAVE    0x00000002L
#endif

/* IDirectInput8::ConfigureDevices() flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DICD_DEFAULT    0x00000000L
    #define DICD_EDIT       0x00000001L
#endif

/* DirectInput device image information flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIDIFT_CONFIGURATION    0x00000001L
    #define DIDIFT_OVERLAY          0x00000002L
#endif

/* DirectInput device image information alignment flags */
#if (DIRECTINPUT_VERSION > 0x0700)
    #define DIDAL_CENTERED      0x00000000L
    #define DIDAL_LEFTALIGNED   0x00000001L
    #define DIDAL_RIGHTALIGNED  0x00000002L
    #define DIDAL_MIDDLE        0x00000000L
    #define DIDAL_TOPALIGNED    0x00000004L
    #define DIDAL_BOTTOMALIGNED 0x00000008L
#endif

/* DirectInput device object instance flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIDOI_FFACTUATOR        0x00000001L
    #define DIDOI_FFEFFECTTRIGGER   0x00000002L
    #define DIDOI_POLLED            0x00008000L
    #define DIDOI_ASPECTPOSITION    0x00000100L
    #define DIDOI_ASPECTVELOCITY    0x00000200L
    #define DIDOI_ASPECTACCEL       0x00000300L
    #define DIDOI_ASPECTFORCE       0x00000400L
    #define DIDOI_ASPECTMASK        0x00000F00L
#endif
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIDOI_GUIDISUSAGE       0x00010000L
#endif

/* DirectInput property header how constants */
#define DIPH_DEVICE         0
#define DIPH_BYOFFSET       1
#define DIPH_BYID           2
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIPH_BYUSAGE    3
#endif

/* Macro to make a DirectInput usage DWORD */
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIMAKEUSAGEDWORD( p1, p2 )  (DWORD)MAKELONG( p1, p2 )
#endif

/* DirectInput property range special values */
#define DIPROPRANGE_NOMIN   0x80000000L
#define DIPROPRANGE_NOMAX   0x7FFFFFFFL

/* Maximum number of calibration points */
#if (DIRECTINPUT_VERSION >= 0x0800)
    #define MAXCPOINTSNUM   8
#endif

/* Macro to make DirectInput properties */
#ifdef __cplusplus
    #define MAKEDIPROP( x ) (*(const GUID *)(x))
#else
    #define MAKEDIPROP( x ) ((REFGUID)(x))
#endif

/* DirectInput properties */
#define DIPROP_BUFFERSIZE           MAKEDIPROP( 1 )
#define DIPROP_AXISMODE             MAKEDIPROP( 2 )
#define DIPROP_GRANULARITY          MAKEDIPROP( 3 )
#define DIPROP_RANGE                MAKEDIPROP( 4 )
#define DIPROP_DEADZONE             MAKEDIPROP( 5 )
#define DIPROP_SATURATION           MAKEDIPROP( 6 )
#define DIPROP_FFGAIN               MAKEDIPROP( 7 )
#define DIPROP_FFLOAD               MAKEDIPROP( 8 )
#define DIPROP_AUTOCENTER           MAKEDIPROP( 9 )
#define DIPROP_CALIBRATIONMODE      MAKEDIPROP( 10 )
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIPROP_CALIBRATION      MAKEDIPROP( 11 )
    #define DIPROP_GUIDANDPATH      MAKEDIPROP( 12 )
    #define DIPROP_INSTANCENAME     MAKEDIPROP( 13 )
    #define DIPROP_PRODUCTNAME      MAKEDIPROP( 14 )
#endif
#if (DIRECTINPUT_VERSION >= 0x05B2)
    #define DIPROP_JOYSTICKID       MAKEDIPROP( 15 )
    #define DIPROP_GETPORTDISPLAYNAME   MAKEDIPROP( 16 )
#endif
#if (DIRECTINPUT_VERSION >= 0x0700)
    #define DIPROP_PHYSICALRANGE    MAKEDIPROP( 18 )
    #define DIPROP_LOGICALRANGE     MAKEDIPROP( 19 )
#endif
#if (DIRECTINPUT_VERSION >= 0x0800)
    #define DIPROP_KEYNAME          MAKEDIPROP( 20 )
    #define DIPROP_CPOINTS          MAKEDIPROP( 21 )
    #define DIPROP_APPDATA          MAKEDIPROP( 22 )
    #define DIPROP_SCANCODE         MAKEDIPROP( 23 )
    #define DIPROP_VIDPID           MAKEDIPROP( 24 )
    #define DIPROP_USERNAME         MAKEDIPROP( 25 )
    #define DIPROP_TYPENAME         MAKEDIPROP( 26 )
#endif

/* DirectInput axis mode property values */
#define DIPROPAXISMODE_ABS  0
#define DIPROPAXISMODE_REL  1

/* DirectInput autocenter property values */
#define DIPROPAUTOCENTER_OFF    0
#define DIPROPAUTOCENTER_ON     1

/* DirectInput calibration mode property values */
#define DIPROPCALIBRATIONMODE_COOKED    0
#define DIPROPCALIBRATIONMODE_RAW       1

/* IDirectInputDevice8::GetDeviceData() flags */
#define DIGDD_PEEK  0x00000001L

/* Macro to compare DirectInput sequences */
#define DISEQUENCE_COMPARE( p1, p2, p3 )    ((int)((p1) - (p3)) p2 0)

/* IDirectInputDevice::SetCooperativeLevel() flags */
#define DISCL_EXCLUSIVE     0x00000001L
#define DISCL_NONEXCLUSIVE  0x00000002L
#define DISCL_FOREGROUND    0x00000004L
#define DISCL_BACKGROUND    0x00000008L
#define DISCL_NOWINKEY      0x00000010L

/* IDirectInputDevice2::SendForceFeedbackCommand() flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DISFFC_RESET            0x00000001L
    #define DISFFC_STOPALL          0x00000002L
    #define DISFFC_PAUSE            0x00000004L
    #define DISFFC_CONTINUE         0x00000008L
    #define DISFFC_SETACTUATORSON   0x00000010L
    #define DISFFC_SETACUTATORSOFF  0x00000020L
#endif

/* IDirectInputDevice2::GetForceFeedbackState() flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIGFFS_EMPTY            0x00000001L
    #define DIGFFS_STOPPED          0x00000002L
    #define DIGFFS_PAUSED           0x00000004L
    #define DIGFFS_ACTUATORSON      0x00000010L
    #define DIGFFS_ACTUATORSOFF     0x00000020L
    #define DIGFFS_POWERON          0x00000040L
    #define DIGFFS_POWEROFF         0x00000080L
    #define DIGFFS_SAFETYSWITCHON   0x00000100L
    #define DIGFFS_SAFETYSWITCHOFF  0x00000200L
    #define DIGFFS_USERFFSWITCHON   0x00000400L
    #define DIGFFS_USERFFSWITCHOFF  0x00000800L
    #define DIGFFS_DEVICELOST       0x80000000L
#endif

/* IDirectInputDevice2::SendDeviceData() flags */
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DISDD_CONTINUE  0x00000001L
#endif

/* DirectInput effect flags */
#if (DIRECTINPUT_VERSION >= 0x0700)
    #define DIFEF_DEFAULT               0x00000000L
    #define DIFEF_INCLUDENONSTANDARD    0x00000001L
    #define DIFEF_MODIFYIFNEEDED        0x00000010L
#endif

/* DirectInput keyboard scan codes */
#define DIK_ESCAPE          0x01
#define DIK_1               0x02
#define DIK_2               0x03
#define DIK_3               0x04
#define DIK_4               0x05
#define DIK_5               0x06
#define DIK_6               0x07
#define DIK_7               0x08
#define DIK_8               0x09
#define DIK_9               0x0A
#define DIK_0               0x0B
#define DIK_MINUS           0x0C
#define DIK_EQUALS          0x0D
#define DIK_BACK            0x0E
#define DIK_TAB             0x0F
#define DIK_Q               0x10
#define DIK_W               0x11
#define DIK_E               0x12
#define DIK_R               0x13
#define DIK_T               0x14
#define DIK_Y               0x15
#define DIK_U               0x16
#define DIK_I               0x17
#define DIK_O               0x18
#define DIK_P               0x19
#define DIK_LBRACKET        0x1A
#define DIK_RBRACKET        0x1B
#define DIK_RETURN          0x1C
#define DIK_LCONTROL        0x1D
#define DIK_A               0x1E
#define DIK_S               0x1F
#define DIK_D               0x20
#define DIK_F               0x21
#define DIK_G               0x22
#define DIK_H               0x23
#define DIK_J               0x24
#define DIK_K               0x25
#define DIK_L               0x26
#define DIK_SEMICOLON       0x27
#define DIK_APOSTROPHE      0x28
#define DIK_GRAVE           0x29
#define DIK_LSHIFT          0x2A
#define DIK_BACKSLASH       0x2B
#define DIK_Z               0x2C
#define DIK_X               0x2D
#define DIK_C               0x2E
#define DIK_V               0x2F
#define DIK_B               0x30
#define DIK_N               0x31
#define DIK_M               0x32
#define DIK_COMMA           0x33
#define DIK_PERIOD          0x34
#define DIK_SLASH           0x35
#define DIK_RSHIFT          0x36
#define DIK_MULTIPLY        0x37
#define DIK_LMENU           0x38
#define DIK_SPACE           0x39
#define DIK_CAPITAL         0x3A
#define DIK_F1              0x3B
#define DIK_F2              0x3C
#define DIK_F3              0x3D
#define DIK_F4              0x3E
#define DIK_F5              0x3F
#define DIK_F6              0x40
#define DIK_F7              0x41
#define DIK_F8              0x42
#define DIK_F9              0x43
#define DIK_F10             0x44
#define DIK_NUMLOCK         0x45
#define DIK_SCROLL          0x46
#define DIK_NUMPAD7         0x47
#define DIK_NUMPAD8         0x48
#define DIK_NUMPAD9         0x49
#define DIK_SUBTRACT        0x4A
#define DIK_NUMPAD4         0x4B
#define DIK_NUMPAD5         0x4C
#define DIK_NUMPAD6         0x4D
#define DIK_ADD             0x4E
#define DIK_NUMPAD1         0x4F
#define DIK_NUMPAD2         0x50
#define DIK_NUMPAD3         0x51
#define DIK_NUMPAD0         0x52
#define DIK_DECIMAL         0x53
#define DIK_OEM_102         0x56
#define DIK_F11             0x57
#define DIK_F12             0x58
#define DIK_F13             0x64
#define DIK_F14             0x65
#define DIK_F15             0x66
#define DIK_KANA            0x70
#define DIK_ABNT_C1         0x73
#define DIK_CONVERT         0x79
#define DIK_NOCONVERT       0x7B
#define DIK_YEN             0x7D
#define DIK_ABNT_C2         0x7E
#define DIK_NUMPADEQUALS    0x8D
#define DIK_PREVTRACK       0x90
#define DIK_AT              0x91
#define DIK_COLON           0x92
#define DIK_UNDERLINE       0x93
#define DIK_KANJI           0x94
#define DIK_STOP            0x95
#define DIK_AX              0x96
#define DIK_UNLABELED       0x97
#define DIK_NEXTTRACK       0x99
#define DIK_NUMPADENTER     0x9C
#define DIK_RCONTROL        0x9D
#define DIK_MUTE            0xA0
#define DIK_CALCULATOR      0xA1
#define DIK_PLAYPAUSE       0xA2
#define DIK_MEDIASTOP       0xA4
#define DIK_VOLUMEDOWN      0xAE
#define DIK_VOLUMEUP        0xB0
#define DIK_WEBHOME         0xB2
#define DIK_NUMPADCOMMA     0xB3
#define DIK_DIVIDE          0xB5
#define DIK_SYSRQ           0xB7
#define DIK_RMENU           0xB8
#define DIK_PAUSE           0xC5
#define DIK_HOME            0xC7
#define DIK_UP              0xC8
#define DIK_PRIOR           0xC9
#define DIK_LEFT            0xCB
#define DIK_RIGHT           0xCD
#define DIK_END             0xCF
#define DIK_DOWN            0xD0
#define DIK_NEXT            0xD1
#define DIK_INSERT          0xD2
#define DIK_DELETE          0xD3
#define DIK_LWIN            0xDB
#define DIK_RWIN            0xDC
#define DIK_APPS            0xDD
#define DIK_POWER           0xDE
#define DIK_SLEEP           0xDF
#define DIK_WAKE            0xE3
#define DIK_WEBSEARCH       0xE5
#define DIK_WEBFAVORITES    0xE6
#define DIK_WEBREFRESH      0xE7
#define DIK_WEBSTOP         0xE8
#define DIK_WEBFORWARD      0xE9
#define DIK_WEBBACK         0xEA
#define DIK_MYCOMPUTER      0xEB
#define DIK_MAIL            0xEC
#define DIK_MEDIASELECT     0xED
#define DIK_BACKSPACE       DIK_BACK
#define DIK_NUMPADSTAR      DIK_MULTIPLY
#define DIK_LALT            DIK_LMENU
#define DIK_CAPSLOCK        DIK_CAPITAL
#define DIK_NUMPADMINUS     DIK_SUBTRACT
#define DIK_NUMPADPLUS      DIK_ADD
#define DIK_NUMPADPERIOD    DIK_DECIMAL
#define DIK_NUMPADSLASH     DIK_DIVIDE
#define DIK_RALT            DIK_RMENU
#define DIK_UPARROW         DIK_UP
#define DIK_PGUP            DIK_PRIOR
#define DIK_LEFTARROW       DIK_LEFT
#define DIK_RIGHTARROW      DIK_RIGHT
#define DIK_DOWNARROW       DIK_DOWN
#define DIK_PGDN            DIK_NEXT
#define DIK_CIRCUMFLEX      DIK_PREVTRACK

/* DirectInput enumeration constants */
#define DIENUM_STOP     0
#define DIENUM_CONTINUE 1

/* DirectInput device enumeration flags */
#define DIEDFL_ALLDEVICES           0x00000000L
#define DIEDFL_ATTACHEDONLY         0x00000001L
#if (DIRECTINPUT_VERSION >= 0x0500)
    #define DIEDFL_FORCEFEEDBACK    0x00000100L
#endif
#if (DIRECTINPUT_VERSION >= 0x050A)
    #define DIEDFL_INCLUDEALIASES   0x00010000L
    #define DIEDFL_INCLUDEPHANTOMS  0x00020000L
#endif
#if (DIRECTINPUT_VERSION >= 0x0800)
    #define DIEDFL_INCLUDEHIDDEN    0x00040000L
#endif

/* DirectInput device enumeration by semantics flags */
#if (DIRECTINPUT_VERSION >= 0x0800)
    #define DIEDBS_MAPPEDPRI1           0x00000001L
    #define DIEDBS_MAPPEDPRI2           0x00000002L
    #define DIEDBS_RECENTDEVICE         0x00000010L
    #define DIEDBS_NEWDEVICE            0x00000020L
    #define DIEDBSFL_ATTACHEDONLY       0x00000000L
    #define DIEDBSFL_THISUSER           0x00000010L
    #define DIEDBSFL_FORCEFEEDBACK      DIEDFL_FORCEFEEDBACK
    #define DIEDBSFL_AVAILABLEDEVICES   0x00001000L
    #define DIEDBSFL_MULTIMICEKEYBOARDS 0x00002000L
    #define DIEDBSFL_NONGAMINGDEVICES   0x00004000L
    #define DIEDBSFL_VALID              0x00007110L
#endif

/* DirectInput return codes */
#define DI_OK                       S_OK
#define DI_NOTATTACHED              S_FALSE
#define DI_BUFFEROVERFLOW           S_FALSE
#define DI_PROPNOEFFECT             S_FALSE
#define DI_NOEFFECT                 S_FALSE
#define DI_POLLEDDEVICE             0x00000002L
#define DI_DOWNLOADSKIPPED          0x00000003L
#define DI_EFFECTRESTARTED          0x00000004L
#define DI_TRUNCATED                0x00000008L
#define DI_SETTINGSNOTSAVED         0x0000000BL
#define DI_TRUNCATEDANDRESTARTED    0x0000000CL
#define DI_WRITEPROTECT             0x00000013L
#define DIERR_OLDDIRECTINPUTVERSION \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_OLD_WIN_VERSION )
#define DIERR_BETADIRECTINPUTVERSION \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_RMODE_APP )
#define DIERR_BADDRIVERVER \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_BAD_DRIVER_LEVEL )
#define DIERR_DEVICENOTREG          REGDB_E_CLASSNOTREG
#define DIERR_NOTFOUND \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_FILE_NOT_FOUND )
#define DIERR_OBJECTNOTFOUND \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_FILE_NOT_FOUND )
#define DIERR_INVALIDPARAM          E_INVALIDARG
#define DIERR_NOINTERFACE           E_NOINTERFACE
#define DIERR_GENERIC               E_FAIL
#define DIERR_OUTOFMEMORY           E_OUTOFMEMORY
#define DIERR_UNSUPPORTED           E_NOTIMPL
#define DIERR_NOTINITIALIZED \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_NOT_READY )
#define DIERR_ALREADYINITIALIZED \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_ALREADY_INITIALIZED )
#define DIERR_NOAGGREGATION         CLASS_E_NOAGGREGATION
#define DIERR_OTHERAPPHASPRIO       E_ACCESSDENIED
#define DIERR_INPUTLOST \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_READ_FAULT )
#define DIERR_ACQUIRED \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_BUSY )
#define DIERR_NOTACQUIRED \
    MAKE_HRESULT( SEVERITY_ERROR, FACILITY_WIN32, ERROR_INVALID_ACCESS )
#define DIERR_READONLY              E_ACCESSDENIED
#define DIERR_HANDLEEXISTS          E_ACCESSDENIED
#define DIERR_INSUFFICIENTPRIVS     0x80040200L
#define DIERR_DEVICEFULL            0x80040201L
#define DIERR_MOREDATA              0x80040202L
#define DIERR_NOTDOWNLOADED         0x80040203L
#define DIERR_HASEFFECTS            0x80040204L
#define DIERR_NOTEXCLUSIVEACQUIRED  0x80040205L
#define DIERR_INCOMPLETEEFFECT      0x80040206L
#define DIERR_NOTBUFFERED           0x80040207L
#define DIERR_EFFECTPLAYING         0x80040208L
#define DIERR_UNPLUGGED             0x80040209L
#define DIERR_REPORTFULL            0x8004020AL
#define DIERR_MAPFILEFAIL           0x8004020BL

/* DirectInput keyboard mapping constants */
#define DIKEYBOARD_ESCAPE       0x81000401L
#define DIKEYBOARD_1            0x81000402L
#define DIKEYBOARD_2            0x81000403L
#define DIKEYBOARD_3            0x81000404L
#define DIKEYBOARD_4            0x81000405L
#define DIKEYBOARD_5            0x81000406L
#define DIKEYBOARD_6            0x81000407L
#define DIKEYBOARD_7            0x81000408L
#define DIKEYBOARD_8            0x81000409L
#define DIKEYBOARD_9            0x8100040AL
#define DIKEYBOARD_0            0x8100040BL
#define DIKEYBOARD_MINUS        0x8100040CL
#define DIKEYBOARD_EQUALS       0x8100040DL
#define DIKEYBOARD_BACK         0x8100040EL
#define DIKEYBOARD_TAB          0x8100040FL
#define DIKEYBOARD_Q            0x81000410L
#define DIKEYBOARD_W            0x81000411L
#define DIKEYBOARD_E            0x81000412L
#define DIKEYBOARD_R            0x81000413L
#define DIKEYBOARD_T            0x81000414L
#define DIKEYBOARD_Y            0x81000415L
#define DIKEYBOARD_U            0x81000416L
#define DIKEYBOARD_I            0x81000417L
#define DIKEYBOARD_O            0x81000418L
#define DIKEYBOARD_P            0x81000419L
#define DIKEYBOARD_LBRACKET     0x8100041AL
#define DIKEYBOARD_RBRACKET     0x8100041BL
#define DIKEYBOARD_RETURN       0x8100041CL
#define DIKEYBOARD_LCONTROL     0x8100041DL
#define DIKEYBOARD_A            0x8100041EL
#define DIKEYBOARD_S            0x8100041FL
#define DIKEYBOARD_D            0x81000420L
#define DIKEYBOARD_F            0x81000421L
#define DIKEYBOARD_G            0x81000422L
#define DIKEYBOARD_H            0x81000423L
#define DIKEYBOARD_J            0x81000424L
#define DIKEYBOARD_K            0x81000425L
#define DIKEYBOARD_L            0x81000426L
#define DIKEYBOARD_SEMICOLON    0x81000427L
#define DIKEYBOARD_APOSTROPHE   0x81000428L
#define DIKEYBOARD_GRAVE        0x81000429L
#define DIKEYBOARD_LSHIFT       0x8100042AL
#define DIKEYBOARD_BACKSLASH    0x8100042BL
#define DIKEYBOARD_Z            0x8100042CL
#define DIKEYBOARD_X            0x8100042DL
#define DIKEYBOARD_C            0x8100042EL
#define DIKEYBOARD_V            0x8100042FL
#define DIKEYBOARD_B            0x81000430L
#define DIKEYBOARD_N            0x81000431L
#define DIKEYBOARD_M            0x81000432L
#define DIKEYBOARD_COMMA        0x81000433L
#define DIKEYBOARD_PERIOD       0x81000434L
#define DIKEYBOARD_SLASH        0x81000435L
#define DIKEYBOARD_RSHIFT       0x81000436L
#define DIKEYBOARD_MULTIPLY     0x81000437L
#define DIKEYBOARD_LMENU        0x81000438L
#define DIKEYBOARD_SPACE        0x81000439L
#define DIKEYBOARD_CAPITAL      0x8100043AL
#define DIKEYBOARD_F1           0x8100043BL
#define DIKEYBOARD_F2           0x8100043CL
#define DIKEYBOARD_F3           0x8100043DL
#define DIKEYBOARD_F4           0x8100043EL
#define DIKEYBOARD_F5           0x8100043FL
#define DIKEYBOARD_F6           0x81000440L
#define DIKEYBOARD_F7           0x81000441L
#define DIKEYBOARD_F8           0x81000442L
#define DIKEYBOARD_F9           0x81000443L
#define DIKEYBOARD_F10          0x81000444L
#define DIKEYBOARD_NUMLOCK      0x81000445L
#define DIKEYBOARD_SCROLL       0x81000446L
#define DIKEYBOARD_NUMPAD7      0x81000447L
#define DIKEYBOARD_NUMPAD8      0x81000448L
#define DIKEYBOARD_NUMPAD9      0x81000449L
#define DIKEYBOARD_SUBTRACT     0x8100044AL
#define DIKEYBOARD_NUMPAD4      0x8100044BL
#define DIKEYBOARD_NUMPAD5      0x8100044CL
#define DIKEYBOARD_NUMPAD6      0x8100044DL
#define DIKEYBOARD_ADD          0x8100044EL
#define DIKEYBOARD_NUMPAD1      0x8100044FL
#define DIKEYBOARD_NUMPAD2      0x81000450L
#define DIKEYBOARD_NUMPAD3      0x81000451L
#define DIKEYBOARD_NUMPAD0      0x81000452L
#define DIKEYBOARD_DECIMAL      0x81000453L
#define DIKEYBOARD_OEM_102      0x81000456L
#define DIKEYBOARD_F11          0x81000457L
#define DIKEYBOARD_F12          0x81000458L
#define DIKEYBOARD_F13          0x81000464L
#define DIKEYBOARD_F14          0x81000465L
#define DIKEYBOARD_F15          0x81000466L
#define DIKEYBOARD_KANA         0x81000470L
#define DIKEYBOARD_ABNT_C1      0x81000473L
#define DIKEYBOARD_CONVERT      0x81000479L
#define DIKEYBOARD_NOCONVERT    0x8100047BL
#define DIKEYBOARD_YEN          0x8100047DL
#define DIKEYBOARD_ABNT_C2      0x8100047EL
#define DIKEYBOARD_NUMPADEQUALS 0x8100048DL
#define DIKEYBOARD_PREVTRACK    0x81000490L
#define DIKEYBOARD_AT           0x81000491L
#define DIKEYBOARD_COLON        0x81000492L
#define DIKEYBOARD_UNDERLINE    0x81000493L
#define DIKEYBOARD_KANJI        0x81000494L
#define DIKEYBOARD_STOP         0x81000495L
#define DIKEYBOARD_AX           0x81000496L
#define DIKEYBOARD_UNLABELED    0x81000497L
#define DIKEYBOARD_NEXTTRACK    0x81000499L
#define DIKEYBOARD_NUMPADENTER  0x8100049CL
#define DIKEYBOARD_RCONTROL     0x8100049DL
#define DIKEYBOARD_MUTE         0x810004A0L
#define DIKEYBOARD_CALCULATOR   0x810004A1L
#define DIKEYBOARD_PLAYPAUSE    0x810004A2L
#define DIKEYBOARD_MEDIASTOP    0x810004A4L
#define DIKEYBOARD_VOLUMEDOWN   0x810004AEL
#define DIKEYBOARD_VOLUMEUP     0x810004B0L
#define DIKEYBOARD_WEBHOME      0x810004B2L
#define DIKEYBOARD_NUMPADCOMMA  0x810004B3L
#define DIKEYBOARD_DIVIDE       0x810004B5L
#define DIKEYBOARD_SYSRQ        0x810004B7L
#define DIKEYBOARD_RMENU        0x810004B8L
#define DIKEYBOARD_PAUSE        0x810004C5L
#define DIKEYBOARD_HOME         0x810004C7L
#define DIKEYBOARD_UP           0x810004C8L
#define DIKEYBOARD_PRIOR        0x810004C9L
#define DIKEYBOARD_LEFT         0x810004CBL
#define DIKEYBOARD_RIGHT        0x810004CDL
#define DIKEYBOARD_END          0x810004CFL
#define DIKEYBOARD_DOWN         0x810004D0L
#define DIKEYBOARD_NEXT         0x810004D1L
#define DIKEYBOARD_INSERT       0x810004D2L
#define DIKEYBOARD_DELETE       0x810004D3L
#define DIKEYBOARD_LWIN         0x810004DBL
#define DIKEYBOARD_RWIN         0x810004DCL
#define DIKEYBOARD_APPS         0x810004DDL
#define DIKEYBOARD_POWER        0x810004DEL
#define DIKEYBOARD_SLEEP        0x810004DFL
#define DIKEYBOARD_WAKE         0x810004E3L
#define DIKEYBOARD_WEBSEARCH    0x810004E5L
#define DIKEYBOARD_WEBFAVORITES 0x810004E6L
#define DIKEYBOARD_WEBREFRESH   0x810004E7L
#define DIKEYBOARD_WEBSTOP      0x810004E8L
#define DIKEYBOARD_WEBFORWARD   0x810004E9L
#define DIKEYBOARD_WEBBACK      0x810004EAL
#define DIKEYBOARD_MYCOMPUTER   0x810004EBL
#define DIKEYBOARD_MAIL         0x810004ECL
#define DIKEYBOARD_MEDIASELECT  0x810004EDL

/* DirectInput mouse mapping constants */
#define DIMOUSE_XAXISAB (0x82000200L | DIMOFS_X)
#define DIMOUSE_YAXISAB (0x82000200L | DIMOFS_Y)
#define DIMOUSE_XAXIS   (0x82000300L | DIMOFS_X)
#define DIMOUSE_YAXIS   (0x82000300L | DIMOFS_Y)
#define DIMOUSE_WHEEL   (0x82000300L | DIMOFS_Z)
#define DIMOUSE_BUTTON0 (0x82000400L | DIMOFS_BUTTON0)
#define DIMOUSE_BUTTON1 (0x82000400L | DIMOFS_BUTTON1)
#define DIMOUSE_BUTTON2 (0x82000400L | DIMOFS_BUTTON2)
#define DIMOUSE_BUTTON3 (0x82000400L | DIMOFS_BUTTON3)
#define DIMOUSE_BUTTON4 (0x82000400L | DIMOFS_BUTTON4)
#define DIMOUSE_BUTTON5 (0x82000400L | DIMOFS_BUTTON5)
#define DIMOUSE_BUTTON6 (0x82000400L | DIMOFS_BUTTON6)
#define DIMOUSE_BUTTON7 (0x82000400L | DIMOFS_BUTTON7)

/* DirectInput voice mapping constants */
#define DIVOICE_CHANNEL1        0x83000401L
#define DIVOICE_CHANNEL2        0x83000402L
#define DIVOICE_CHANNEL3        0x83000403L
#define DIVOICE_CHANNEL4        0x83000404L
#define DIVOICE_CHANNEL5        0x83000405L
#define DIVOICE_CHANNEL6        0x83000406L
#define DIVOICE_CHANNEL7        0x83000407L
#define DIVOICE_CHANNEL8        0x83000408L
#define DIVOICE_TEAM            0x83000409L
#define DIVOICE_ALL             0x8300040AL
#define DIVOICE_RECORDMUTE      0x8300040BL
#define DIVOICE_PLAYBACKMUTE    0x8300040CL
#define DIVOICE_TRANSMIT        0x8300040DL
#define DIVOICE_VOICECOMMAND    0x83000410L

/* DirectInput genre and control constants */
#define DIVIRTUAL_DRIVING_RACE              0x01000000L
#define DIAXIS_DRIVINGR_STEER               0x01008A01L
#define DIAXIS_DRIVINGR_ACCELERATE          0x01039202L
#define DIAXIS_DRIVINGR_BRAKE               0x01041203L
#define DIBUTTON_DRIVINGR_SHIFTUP           0x01000C01L
#define DIBUTTON_DRIVINGR_SHIFTDOWN         0x01000C02L
#define DIBUTTON_DRIVINGR_VIEW              0x01001C03L
#define DIBUTTON_DRIVINGR_MENU              0x010004FDL
#define DIAXIS_DRIVINGR_ACCEL_AND_BRAKE     0x01014A04L
#define DIHATSWITCH_DRIVINGR_GLANCE         0x01004601L
#define DIBUTTON_DRIVINGR_BRAKE             0x01004C04L
#define DIBUTTON_DRIVINGR_DASHBOARD         0x01004405L
#define DIBUTTON_DRIVINGR_AIDS              0x01004406L
#define DIBUTTON_DRIVINGR_MAP               0x01004407L
#define DIBUTTON_DRIVINGR_BOOST             0x01004408L
#define DIBUTTON_DRIVINGR_PIT               0x01004409L
#define DIBUTTON_DRIVINGR_ACCELERATE_LINK   0x0103D4E0L
#define DIBUTTON_DRIVINGR_STEER_LEFT_LINK   0x0100CCE4L
#define DIBUTTON_DRIVINGR_STEER_RIGHT_LINK  0x0100CCECL
#define DIBUTTON_DRIVINGR_GLANCE_LEFT_LINK  0x0107C4E4L
#define DIBUTTON_DRIVINGR_GLANCE_RIGHT_LINK 0x0107C4ECL
#define DIBUTTON_DRIVINGR_DEVICE            0x010044FEL
#define DIBUTTON_DRIVINGR_PAUSE             0x010044FCL
#define DIVIRTUAL_DRIVING_COMBAT            0x02000000L
#define DIAXIS_DRIVINGC_STEER               0x02008A01L
#define DIAXIS_DRIVINGC_ACCELERATE          0x02039202L
#define DIAXIS_DRIVINGC_BRAKE               0x02041203L
#define DIBUTTON_DRIVINGC_FIRE              0x02000C01L
#define DIBUTTON_DRIVINGC_WEAPONS           0x02000C02L
#define DIBUTTON_DRIVINGC_TARGET            0x02000C03L
#define DIBUTTON_DRIVINGC_MENU              0x000002FDL
#define DIAXIS_DRIVINGC_ACCEL_AND_BRAKE     0x02014A04L
#define DIHATSWITCH_DRIVINGC_GLANCE         0x02004601L
#define DIBUTTON_DRIVINGC_SHIFTUP           0x02004C04L
#define DIBUTTON_DRIVINGC_SHIFTDOWN         0x02004C05L
#define DIBUTTON_DRIVINGC_DASHBOARD         0x02004406L
#define DIBUTTON_DRIVINGC_AIDS              0x02004407L
#define DIBUTTON_DRIVINGC_BRAKE             0x02004C08L
#define DIBUTTON_DRIVINGC_FIRESECONDARY     0x02004C09L
#define DIBUTTON_DRIVINGC_ACCELERATE_LINK   0x0203D4E0L
#define DIBUTTON_DRIVINGC_STEER_LEFT_LINK   0x0200CCE4L
#define DIBUTTON_DRIVINGC_STEER_RIGHT_LINK  0x0200CCECL
#define DIBUTTON_DRIVINGC_GLANCE_LEFT_LINK  0x0207C4E4L
#define DIBUTTON_DRIVINGC_GLANCE_RIGHT_LINK 0x0207C4ECL
#define DIBUTTON_DRIVINGC_DEVICE            0x020044FEL
#define DIBUTTON_DRIVINGC_PAUSE             0x020044FCL
#define DIVIRTUAL_DRIVING_TANK              0x03000000L
#define DIAXIS_DRIVINGT_STEER               0x03008A01L
#define DIAXIS_DRIVINGT_BARREL              0x03010202L
#define DIAXIS_DRIVINGT_ACCELERATE          0x03039203L
#define DIAXIS_DRIVINGT_ROTATE              0x03020204L
#define DIBUTTON_DRIVINGT_FIRE              0x03000C01L
#define DIBUTTON_DRIVINGT_WEAPONS           0x03000C02L
#define DIBUTTON_DRIVINGT_TARGET            0x03000C03L
#define DIBUTTON_DRIVINGT_MENU              0x030004FDL
#define DIHATSWITCH_DRIVINGT_GLANCE         0x03004601L
#define DIAXIS_DRIVINGT_BRAKE               0x03045205L
#define DIAXIS_DRIVINGT_ACCEL_AND_BRAKE     0x03014A06L
#define DIBUTTON_DRIVINGT_VIEW              0x03005C04L
#define DIBUTTON_DRIVINGT_DASHBOARD         0x03005C05L
#define DIBUTTON_DRIVINGT_BRAKE             0x03004C06L
#define DIBUTTON_DRIVINGT_FIRESECONDARY     0x03004C07L
#define DIBUTTON_DRIVINGT_ACCELERATE_LINK   0x0303D4E0L
#define DIBUTTON_DRIVINGT_STEER_LEFT_LINK   0x0300CCE4L
#define DIBUTTON_DRIVINGT_STEER_RIGHT_LINK  0x0300CCECL
#define DIBUTTON_DRIVINGT_BARREL_UP_LINK    0x030144E0L
#define DIBUTTON_DRIVINGT_BARREL_DOWN_LINK  0x030144E8L
#define DIBUTTON_DRIVINGT_ROTATE_LEFT_LINK  0x030244E4L
#define DIBUTTON_DRIVINGT_ROTATE_RIGHT_LINK 0x030244ECL
#define DIBUTTON_DRIVINGT_GLANCE_LEFT_LINK  0x0307C4E4L
#define DIBUTTON_DRIVINGT_GLANCE_RIGHT_LINK 0x0307C4ECL
#define DIBUTTON_DRIVINGT_DEVICE            0x030044FEL
#define DIBUTTON_DRIVINGT_PAUSE             0x030044FCL
#define DIVIRTUAL_FLYING_CIVILIAN           0x04000000L
#define DIAXIS_FLYINGC_BANK                 0x04008A01L
#define DIAXIS_FLYINGC_PITCH                0x04010A02L
#define DIAXIS_FLYINGC_THROTTLE             0x04039203L
#define DIBUTTON_FLYINGC_VIEW               0x04002401L
#define DIBUTTON_FLYINGC_DISPLAY            0x04002402L
#define DIBUTTON_FLYINGC_GEAR               0x04002C03L
#define DIBUTTON_FLYINGC_MENU               0x040004FDL
#define DIHATSWITCH_FLYINGC_GLANCE          0x04004601L
#define DIAXIS_FLYINGC_BRAKE                0x04046A04L
#define DIAXIS_FLYINGC_RUDDER               0x04025205L
#define DIAXIS_FLYINGC_FLAPS                0x04055A06L
#define DIBUTTON_FLYINGC_FLAPSUP            0x04006404L
#define DIBUTTON_FLYINGC_FLAPSDOWN          0x04006405L
#define DIBUTTON_FLYINGC_BRAKE_LINK         0x04046CE0L
#define DIBUTTON_FLYINGC_FASTER_LINK        0x0403D4E0L
#define DIBUTTON_FLYINGC_SLOWER_LINK        0x0403D4E8L
#define DIBUTTON_FLYINGC_GLANCE_LEFT_LINK   0x0407C4E4L
#define DIBUTTON_FLYINGC_GLANCE_RIGHT_LINK  0x0407C4ECL
#define DIBUTTON_FLYINGC_GLANCE_UP_LINK     0x0407C4E0L
#define DIBUTTON_FLYINGC_GLANCE_DOWN_LINK   0x0407C4E8L
#define DIBUTTON_FLYINGC_DEVICE             0x040044FEL
#define DIBUTTON_FLYINGC_PAUSE              0x040044FCL
#define DIVIRTUAL_FLYING_MILITARY           0x05000000L
#define DIAXIS_FLYINGM_BANK                 0x05008A01L
#define DIAXIS_FLYINGM_PITCH                0x05010A02L
#define DIAXIS_FLYINGM_THROTTLE             0x05039203L
#define DIBUTTON_FLYINGM_FIRE               0x05000C01L
#define DIBUTTON_FLYINGM_WEAPONS            0x05000C02L
#define DIBUTTON_FLYINGM_TARGET             0x05000C03L
#define DIBUTTON_FLYINGM_MENU               0x050004FDL
#define DIHATSWITCH_FLYINGM_GLANCE          0x05004601L
#define DIBUTTON_FLYINGM_COUNTER            0x05005C04L
#define DIAXIS_FLYINGM_RUDDER               0x05024A04L
#define DIAXIS_FLYINGM_BRAKE                0x05046205L
#define DIBUTTON_FLYINGM_VIEW               0x05006405L
#define DIBUTTON_FLYINGM_DISPLAY            0x05006406L
#define DIAXIS_FLYINGM_FLAPS                0x05055206L
#define DIBUTTON_FLYINGM_FLAPSUP            0x05005407L
#define DIBUTTON_FLYINGM_FLAPSDOWN          0x05005408L
#define DIBUTTON_FLYINGM_FIRESECONDARY      0x05004C09L
#define DIBUTTON_FLYINGM_GEAR               0x0500640AL
#define DIBUTTON_FLYINGM_BRAKE_LINK         0x050464E0L
#define DIBUTTON_FLYINGM_FASTER_LINK        0x0503D4E0L
#define DIBUTTON_FLYINGM_SLOWER_LINK        0x0503D4E8L
#define DIBUTTON_FLYINGM_GLANCE_LEFT_LINK   0x0507C4E4L
#define DIBUTTON_FLYINGM_GLANCE_RIGHT_LINK  0x0507C4ECL
#define DIBUTTON_FLYINGM_GLANCE_UP_LINK     0x0507C4E0L
#define DIBUTTON_FLYINGM_GLANCE_DOWN_LINK   0x0507C4E8L
#define DIBUTTON_FLYINGM_DEVICE             0x050044FEL
#define DIBUTTON_FLYINGM_PAUSE              0x050044FCL
#define DIVIRTUAL_FLYING_HELICOPTER         0x06000000L
#define DIAXIS_FLYINGH_BANK                 0x06008A01L
#define DIAXIS_FLYINGH_PITCH                0x06010A02L
#define DIAXIS_FLYINGH_COLLECTIVE           0x06018A03L
#define DIBUTTON_FLYINGH_FIRE               0x06001401L
#define DIBUTTON_FLYINGH_WEAPONS            0x06001402L
#define DIBUTTON_FLYINGH_TARGET             0x06001403L
#define DIBUTTON_FLYINGH_MENU               0x060004FDL
#define DIHATSWITCH_FLYINGH_GLANCE          0x06004601L
#define DIAXIS_FLYINGH_TORQUE               0x06025A04L
#define DIAXIS_FLYINGH_THROTTLE             0x0603DA05L
#define DIBUTTON_FLYINGH_COUNTER            0x06005404L
#define DIBUTTON_FLYINGH_VIEW               0x06006405L
#define DIBUTTON_FLYINGH_GEAR               0x06006406L
#define DIBUTTON_FLYINGH_FIRESECONDARY      0x06004C07L
#define DIBUTTON_FLYINGH_FASTER_LINK        0x0603DCE0L
#define DIBUTTON_FLYINGH_SLOWER_LINK        0x0603DCE8L
#define DIBUTTON_FLYINGH_GLANCE_LEFT_LINK   0x0607C4E4L
#define DIBUTTON_FLYINGH_GLANCE_RIGHT_LINK  0x0607C4ECL
#define DIBUTTON_FLYINGH_GLANCE_UP_LINK     0x0607C4E0L
#define DIBUTTON_FLYINGH_GLANCE_DOWN_LINK   0x0607C4E8L
#define DIBUTTON_FLYINGH_DEVICE             0x060044FEL
#define DIBUTTON_FLYINGH_PAUSE              0x060044FCL
#define DIVIRTUAL_SPACESIM                  0x07000000L
#define DIAXIS_SPACESIM_LATERAL             0x07008201L
#define DIAXIS_SPACESIM_MOVE                0x07010202L
#define DIAXIS_SPACESIM_THROTTLE            0x07038203L
#define DIBUTTON_SPACESIM_FIRE              0x07000401L
#define DIBUTTON_SPACESIM_WEAPONS           0x07000402L
#define DIBUTTON_SPACESIM_TARGET            0x07000403L
#define DIBUTTON_SPACESIM_MENU              0x070004FDL
#define DIHATSWITCH_SPACESIM_GLANCE         0x07004601L
#define DIAXIS_SPACESIM_CLIMB               0x0701C204L
#define DIAXIS_SPACESIM_ROTATE              0x07024205L
#define DIBUTTON_SPACESIM_VIEW              0x07004404L
#define DIBUTTON_SPACESIM_DISPLAY           0x07004405L
#define DIBUTTON_SPACESIM_RAISE             0x07004406L
#define DIBUTTON_SPACESIM_LOWER             0x07004407L
#define DIBUTTON_SPACESIM_GEAR              0x07004408L
#define DIBUTTON_SPACESIM_FIRESECONDARY     0x07004409L
#define DIBUTTON_SPACESIM_LEFT_LINK         0x0700C4E4L
#define DIBUTTON_SPACESIM_RIGHT_LINK        0x0700C4ECL
#define DIBUTTON_SPACESIM_FORWARD_LINK      0x070144E0L
#define DIBUTTON_SPACESIM_BACKWARD_LINK     0x070144E8L
#define DIBUTTON_SPACESIM_FASTER_LINK       0x0703C4E0L
#define DIBUTTON_SPACESIM_SLOWER_LINK       0x0703C4E8L
#define DIBUTTON_SPACESIM_TURN_LEFT_LINK    0x070244E4L
#define DIBUTTON_SPACESIM_TURN_RIGHT_LINK   0x070244ECL
#define DIBUTTON_SPACESIM_GLANCE_LEFT_LINK  0x0707C4E4L
#define DIBUTTON_SPACESIM_GLANCE_RIGHT_LINK 0x0707C4ECL
#define DIBUTTON_SPACESIM_GLANCE_UP_LINK    0x0707C4E0L
#define DIBUTTON_SPACESIM_GLANCE_DOWN_LINK  0x0707C4E8L
#define DIBUTTON_SPACESIM_DEVICE            0x070044FEL
#define DIBUTTON_SPACESIM_PAUSE             0x070044FCL
#define DIVIRTUAL_FIGHTING_HAND2HAND        0x08000000L
#define DIAXIS_FIGHTINGH_LATERAL            0x08008201L
#define DIAXIS_FIGHTINGH_MOVE               0x08010202L
#define DIBUTTON_FIGHTINGH_PUNCH            0x08000401L
#define DIBUTTON_FIGHTINGH_KICK             0x08000402L
#define DIBUTTON_FIGHTINGH_BLOCK            0x08000403L
#define DIBUTTON_FIGHTINGH_CROUCH           0x08000404L
#define DIBUTTON_FIGHTINGH_JUMP             0x08000405L
#define DIBUTTON_FIGHTINGH_SPECIAL1         0x08000406L
#define DIBUTTON_FIGHTINGH_SPECIAL2         0x08000407L
#define DIBUTTON_FIGHTINGH_MENU             0x080004FDL
#define DIBUTTON_FIGHTINGH_SELECT           0x08004408L
#define DIHATSWITCH_FIGHTINGH_SLIDE         0x08004601L
#define DIBUTTON_FIGHTINGH_DISPLAY          0x08004409L
#define DIAXIS_FIGHTINGH_ROTATE             0x08024203L
#define DIBUTTON_FIGHTINGH_DODGE            0x0800440AL
#define DIBUTTON_FIGHTINGH_LEFT_LINK        0x0800C4E4L
#define DIBUTTON_FIGHTINGH_RIGHT_LINK       0x0800C4ECL
#define DIBUTTON_FIGHTINGH_FORWARD_LINK     0x080144E0L
#define DIBUTTON_FIGHTINGH_BACKWARD_LINK    0x080114E8L
#define DIBUTTON_FIGHTINGH_DEVICE           0x080044FEL
#define DIBUTTON_FIGHTINGH_PAUSE            0x080044FCL
#define DIVIRTUAL_FIGHTING_FPS              0x09000000L
#define DIAXIS_FPS_ROTATE                   0x09008201L
#define DIAXIS_FPS_MOVE                     0x09010202L
#define DIBUTTON_FPS_FIRE                   0x09000401L
#define DIBUTTON_FPS_WEAPONS                0x09000402L
#define DIBUTTON_FPS_APPLY                  0x09000403L
#define DIBUTTON_FPS_SELECT                 0x09000404L
#define DIBUTTON_FPS_CROUCH                 0x09000405L
#define DIBUTTON_FPS_JUMP                   0x09000406L
#define DIAXIS_FPS_LOOKUPDOWN               0x09018203L
#define DIBUTTON_FPS_STRAFE                 0x09000407L
#define DIBUTTON_FPS_MENU                   0x900004FDL
#define DIHATSWITCH_FPS_GLANCE              0x09004601L
#define DIBUTTON_FPS_DISPLAY                0x09004408L
#define DIAXIS_FPS_SIDESTEP                 0x09024204L
#define DIBUTTON_FPS_DODGE                  0x09004409L
#define DIBUTTON_FPS_GLANCEL                0x0900440AL
#define DIBUTTON_FPS_GLANCER                0x0900440BL
#define DIBUTTON_FPS_FIRESECONDARY          0x0900440CL
#define DIBUTTON_FPS_ROTATE_LEFT_LINK       0x0900C4E4L
#define DIBUTTON_FPS_ROTATE_RIGHT_LINK      0x0900C4ECL
#define DIBUTTON_FPS_FORWARD_LINK           0x090144E0L
#define DIBUTTON_FPS_BACKWARD_LINK          0x090144E8L
#define DIBUTTON_FPS_GLANCE_UP_LINK         0x0901C4E0L
#define DIBUTTON_FPS_GLANCE_DOWN_LINK       0x0901C4E8L
#define DIBUTTON_FPS_STEP_LEFT_LINK         0x090244E4L
#define DIBUTTON_FPS_STEP_RIGHT_LINK        0x090244ECL
#define DIBUTTON_FPS_DEVICE                 0x090044FEL
#define DIBUTTON_FPS_PAUSE                  0x090044FCL
#define DIVIRTUAL_FIGHTING_THIRDPERSON      0x0A000000L
#define DIAXIS_TPS_TURN                     0x0A020201L
#define DIAXIS_TPS_MOVE                     0x0A010202L
#define DIBUTTON_TPS_RUN                    0x0A000401L
#define DIBUTTON_TPS_ACTION                 0x0A000402L
#define DIBUTTON_TPS_SELECT                 0x0A000403L
#define DIBUTTON_TPS_USE                    0x0A000404L
#define DIBUTTON_TPS_JUMP                   0x0A000405L
#define DIBUTTON_TPS_MENU                   0x0A0004FDL
#define DIHATSWITCH_TPS_GLANCE              0x0A004601L
#define DIBUTTON_TPS_VIEW                   0x0A004406L
#define DIBUTTON_TPS_STEPLEFT               0x0A004407L
#define DIBUTTON_TPS_STEPRIGHT              0x0A004408L
#define DIAXIS_TPS_STEP                     0x0A00C203L
#define DIBUTTON_TPS_DODGE                  0x0A004409L
#define DIBUTTON_TPS_INVENTORY              0x0A00440AL
#define DIBUTTON_TPS_TURN_LEFT_LINK         0x0A0244E4L
#define DIBUTTON_TPS_TURN_RIGHT_LINK        0x0A0244ECL
#define DIBUTTON_TPS_FORWARD_LINK           0x0A0144E0L
#define DIBUTTON_TPS_BACKWARD_LINK          0x0A0144E8L
#define DIBUTTON_TPS_GLANCE_UP_LINK         0x0A07C4E0L
#define DIBUTTON_TPS_GLANCE_DOWN_LINK       0x0A07C4E8L
#define DIBUTTON_TPS_GLANCE_LEFT_LINK       0x0A07C4E4L
#define DIBUTTON_TPS_GLANCE_RIGHT_LINK      0x0A07C4ECL
#define DIBUTTON_TPS_DEVICE                 0x0A0044FEL
#define DIBUTTON_TPS_PAUSE                  0x0A0044FCL
#define DIVIRTUAL_STRATEGY_ROLEPLAYING      0x0B000000L
#define DIAXIS_STRATEGYR_LATERAL            0x0B008201L
#define DIAXIS_STRATEGYR_MOVE               0x0B010202L
#define DIBUTTON_STRATEGYR_GET              0x0B000401L
#define DIBUTTON_STRATEGYR_APPLY            0x0B000402L
#define DIBUTTON_STRATEGYR_SELECT           0x0B000403L
#define DIBUTTON_STRATEGYR_ATTACK           0x0B000404L
#define DIBUTTON_STRATEGYR_CAST             0x0B000405L
#define DIBUTTON_STRATEGYR_CROUCH           0x0B000406L
#define DIBUTTON_STRATEGYR_JUMP             0x0B000407L
#define DIBUTTON_STRATEGYR_MENU             0x0B0004FDL
#define DIHATSWITCH_STRATEGYR_GLANCE        0x0B004601L
#define DIBUTTON_STRATEGYR_MAP              0x0B004408L
#define DIBUTTON_STRATEGYR_DISPLAY          0x0B004409L
#define DIAXIS_STRATEGYR_ROTATE             0x0B024203L
#define DIBUTTON_STRATEGYR_LEFT_LINK        0x0B00C4E4L
#define DIBUTTON_STRATEGYR_RIGHT_LINK       0x0B00C4ECL
#define DIBUTTON_STRATEGYR_FORWARD_LINK     0x0B0144E0L
#define DIBUTTON_STRATEGYR_BACK_LINK        0x0B0144E8L
#define DIBUTTON_STRATEGYR_ROTATE_LEFT_LINK 0x0B0244E4L
#define DIBUTTON_STRATEGYR_ROTATE_RIGHT_LINK    0x0B0244ECL
#define DIBUTTON_STRATEGYR_DEVICE           0x0B0044FEL
#define DIBUTTON_STRATEGYR_PAUSE            0x0B0044FCL
#define DIVIRTUAL_STRATEGY_TURN             0x0C000000L
#define DIAXIS_STRATEGYT_LATERAL            0x0C008201L
#define DIAXIS_STRATEGYT_MOVE               0x0C010202L
#define DIBUTTON_STRATEGYT_SELECT           0x0C000401L
#define DIBUTTON_STRATEGYT_INSTRUCT         0x0C000402L
#define DIBUTTON_STRATEGYT_APPLY            0x0C000403L
#define DIBUTTON_STRATEGYT_TEAM             0x0C000404L
#define DIBUTTON_STRATEGYT_TURN             0x0C000405L
#define DIBUTTON_STRATEGYT_MENU             0x0C0004FDL
#define DIBUTTON_STRATEGYT_ZOOM             0x0C004406L
#define DIBUTTON_STRATEGYT_MAP              0x0C004407L
#define DIBUTTON_STRATEGYT_DISPLAY          0x0C004408L
#define DIBUTTON_STRATEGYT_LEFT_LINK        0x0C00C4E4L
#define DIBUTTON_STRATEGYT_RIGHT_LINK       0x0C00C4ECL
#define DIBUTTON_STRATEGYT_FORWARD_LINK     0x0C0144E0L
#define DIBUTTON_STRATEGYT_BACK_LINK        0x0C0144E8L
#define DIBUTTON_STRATEGYT_DEVICE           0x0C0044FEL
#define DIBUTTON_STRATEGYT_PAUSE            0x0C0044FCL
#define DIVIRTUAL_SPORTS_HUNTING            0x0D000000L
#define DIAXIS_HUNTING_LATERAL              0x0D008201L
#define DIAXIS_HUNTING_MOVE                 0x0D010202L
#define DIBUTTON_HUNTING_FIRE               0x0D000401L
#define DIBUTTON_HUNTING_AIM                0x0D000402L
#define DIBUTTON_HUNTING_WEAPON             0x0D000403L
#define DIBUTTON_HUNTING_BINOCULAR          0x0D000404L
#define DIBUTTON_HUNTING_CALL               0x0D000405L
#define DIBUTTON_HUNTING_MAP                0x0D000406L
#define DIBUTTON_HUNTING_SPECIAL            0x0D000407L
#define DIBUTTON_HUNTING_MENU               0x0D0004FDL
#define DIHATSWITCH_HUNTING_GLANCE          0x0D004601L
#define DIBUTTON_HUNTING_DISPLAY            0x0D004408L
#define DIAXIS_HUNTING_ROTATE               0x0D024203L
#define DIBUTTON_HUNTING_CROUCH             0x0D004409L
#define DIBUTTON_HUNTING_JUMP               0x0D00440AL
#define DIBUTTON_HUNTING_FIRESECONDARY      0x0D00440BL
#define DIBUTTON_HUNTING_LEFT_LINK          0x0D00C4E4L
#define DIBUTTON_HUNTING_RIGHT_LINK         0x0D00C4ECL
#define DIBUTTON_HUNTING_FORWARD_LINK       0x0D0144E0L
#define DIBUTTON_HUNTING_BACK_LINK          0x0D0144E8L
#define DIBUTTON_HUNTING_ROTATE_LEFT_LINK   0x0D0244E4L
#define DIBUTTON_HUNTING_ROTATE_RIGHT_LINK  0x0D0244ECL
#define DIBUTTON_HUNTING_DEVICE             0x0D0044FEL
#define DIBUTTON_HUNTING_PAUSE              0x0D0044FCL
#define DIVIRTUAL_SPORTS_FISHING            0x0E000000L
#define DIAXIS_FISHING_LATERAL              0x0E008201L
#define DIAXIS_FISHING_MOVE                 0x0E010202L
#define DIBUTTON_FISHING_CAST               0x0E000401L
#define DIBUTTON_FISHING_TYPE               0x0E000402L
#define DIBUTTON_FISHING_BINOCULAR          0x0E000403L
#define DIBUTTON_FISHING_BAIT               0x0E000404L
#define DIBUTTON_FISHING_MAP                0x0E000405L
#define DIBUTTON_FISHING_MENU               0x0E0004FDL
#define DIHATSWITCH_FISHING_GLANCE          0x0E004601L
#define DIBUTTON_FISHING_DISPLAY            0x0E004406L
#define DIAXIS_FISHING_ROTATE               0x0E024203L
#define DIBUTTON_FISHING_CROUCH             0x0E004407L
#define DIBUTTON_FISHING_JUMP               0x0E004408L
#define DIBUTTON_FISHING_LEFT_LINK          0x0E00C4E4L
#define DIBUTTON_FISHING_RIGHT_LINK         0x0E00C4ECL
#define DIBUTTON_FISHING_FORWARD_LINK       0x0E0144E0L
#define DIBUTTON_FISHING_BACK_LINK          0x0E0144E8L
#define DIBUTTON_FISHING_ROTATE_LEFT_LINK   0x0E0244E4L
#define DIBUTTON_FISHING_ROTATE_RIGHT_LINK  0x0E0244ECL
#define DIBUTTON_FISHING_DEVICE             0x0E0044FEL
#define DIBUTTON_FISHING_PAUSE              0x0E0044FCL
#define DIVIRTUAL_SPORTS_BASEBALL_BAT       0x0F000000L
#define DIAXIS_BASEBALLB_LATERAL            0x0F008201L
#define DIAXIS_BASEBALLB_MOVE               0x0F010202L
#define DIBUTTON_BASEBALLB_SELECT           0x0F000401L
#define DIBUTTON_BASEBALLB_NORMAL           0x0F000402L
#define DIBUTTON_BASEBALLB_POWER            0x0F000403L
#define DIBUTTON_BASEBALLB_BUNT             0x0F000404L
#define DIBUTTON_BASEBALLB_STEAL            0x0F000405L
#define DIBUTTON_BASEBALLB_BURST            0x0F000406L
#define DIBUTTON_BASEBALLB_SLIDE            0x0F000407L
#define DIBUTTON_BASEBALLB_CONTACT          0x0F000408L
#define DIBUTTON_BASEBALLB_MENU             0x0F0004FDL
#define DIBUTTON_BASEBALLB_NOSTEAL          0x0F004409L
#define DIBUTTON_BASEBALLB_BOX              0x0F00440AL
#define DIBUTTON_BASEBALLB_LEFT_LINK        0x0F00C4E4L
#define DIBUTTON_BASEBALLB_RIGHT_LINK       0x0F00C4ECL
#define DIBUTTON_BASEBALLB_FORWARD_LINK     0x0F0144E0L
#define DIBUTTON_BASEBALLB_BACK_LINK        0x0F0144E8L
#define DIBUTTON_BASEBALLB_DEVICE           0x0F0044FEL
#define DIBUTTON_BASEBALLB_PAUSE            0x0F0044FCL
#define DIVIRTUAL_SPORTS_BASEBALL_PITCH     0x10000000L
#define DIAXIS_BASEBALLP_LATERAL            0x10008201L
#define DIAXIS_BASEBALLP_MOVE               0x10010202L
#define DIBUTTON_BASEBALLP_SELECT           0x10000401L
#define DIBUTTON_BASEBALLP_PITCH            0x10000402L
#define DIBUTTON_BASEBALLP_BASE             0x10000403L
#define DIBUTTON_BASEBALLP_THROW            0x10000404L
#define DIBUTTON_BASEBALLP_FAKE             0x10000405L
#define DIBUTTON_BASEBALLP_MENU             0x100004FDL
#define DIBUTTON_BASEBALLP_WALK             0x10004406L
#define DIBUTTON_BASEBALLP_LOOK             0x10004407L
#define DIBUTTON_BASEBALLP_LEFT_LINK        0x1000C4E4L
#define DIBUTTON_BASEBALLP_RIGHT_LINK       0x1000C4ECL
#define DIBUTTON_BASEBALLP_FORWARD_LINK     0x100144E0L
#define DIBUTTON_BASEBALLP_BACK_LINK        0x100144E8L
#define DIBUTTON_BASEBALLP_DEVICE           0x100044FEL
#define DIBUTTON_BASEBALLP_PAUSE            0x100044FCL
#define DIVIRTUAL_SPORTS_BASEBALL_FIELD     0x11000000L
#define DIAXIS_BASEBALLF_LATERAL            0x11008201L
#define DIAXIS_BASEBALLF_MOVE               0x11010202L
#define DIBUTTON_BASEBALLF_NEAREST          0x11000401L
#define DIBUTTON_BASEBALLF_THROW1           0x11000402L
#define DIBUTTON_BASEBALLF_THROW2           0x11000403L
#define DIBUTTON_BASEBALLF_BURST            0x11000404L
#define DIBUTTON_BASEBALLF_JUMP             0x11000405L
#define DIBUTTON_BASEBALLF_DIVE             0x11000406L
#define DIBUTTON_BASEBALLF_MENU             0x110004FDL
#define DIBUTTON_BASEBALLF_SHIFTIN          0x11004407L
#define DIBUTTON_BASEBALLF_SHIFTOUT         0x11004408L
#define DIBUTTON_BASEBALLF_AIM_LEFT_LINK    0x1100C4E4L
#define DIBUTTON_BASEBALLF_AIM_RIGHT_LINK   0x1100C4ECL
#define DIBUTTON_BASEBALLF_FORWARD_LINK     0x110144E0L
#define DIBUTTON_BASEBALLF_BACK_LINK        0x110144E8L
#define DIBUTTON_BASEBALLF_DEVICE           0x110044FEL
#define DIBUTTON_BASEBALLF_PAUSE            0x110044FCL
#define DIVIRTUAL_SPORTS_BASKETBALL_OFFENSE 0x12000000L
#define DIAXIS_BBALLO_LATERAL               0x12008201L
#define DIAXIS_BBALLO_MOVE                  0x12010202L
#define DIBUTTON_BBALLO_SHOOT               0x12000401L
#define DIBUTTON_BBALLO_DUNK                0x12000402L
#define DIBUTTON_BBALLO_PASS                0x12000403L
#define DIBUTTON_BBALLO_FAKE                0x12000404L
#define DIBUTTON_BBALLO_SPECIAL             0x12000405L
#define DIBUTTON_BBALLO_PLAYER              0x12000406L
#define DIBUTTON_BBALLO_BURST               0x12000407L
#define DIBUTTON_BBALLO_CALL                0x12000408L
#define DIBUTTON_BBALLO_MENU                0x120004FDL
#define DIHATSWITCH_BBALLO_GLANCE           0x12004601L
#define DIBUTTON_BBALLO_SCREEN              0x12004409L
#define DIBUTTON_BBALLO_PLAY                0x1200440AL
#define DIBUTTON_BBALLO_JAB                 0x1200440BL
#define DIBUTTON_BBALLO_POST                0x1200440CL
#define DIBUTTON_BBALLO_TIMEOUT             0x1200440DL
#define DIBUTTON_BBALLO_SUBSTITUTE          0x1200440EL
#define DIBUTTON_BBALLO_LEFT_LINK           0x1200C4E4L
#define DIBUTTON_BBALLO_RIGHT_LINK          0x1200C4ECL
#define DIBUTTON_BBALLO_FORWARD_LINK        0x120144E0L
#define DIBUTTON_BBALLO_BACK_LINK           0x120144E8L
#define DIBUTTON_BBALLO_DEVICE              0x120044FEL
#define DIBUTTON_BBALLO_PAUSE               0x120044FCL
#define DIVIRTUAL_SPORTS_BASKETBALL_DEFENSE 0x13000000L
#define DIAXIS_BBALLD_LATERAL               0x13008201L
#define DIAXIS_BBALLD_MOVE                  0x13010202L
#define DIBUTTON_BBALLD_JUMP                0x13000401L
#define DIBUTTON_BBALLD_STEAL               0x13000402L
#define DIBUTTON_BBALLD_FAKE                0x13000403L
#define DIBUTTON_BBALLD_SPECIAL             0x13000404L
#define DIBUTTON_BBALLD_PLAYER              0x13000405L
#define DIBUTTON_BBALLD_BURST               0x13000406L
#define DIBUTTON_BBALLD_PLAY                0x13000407L
#define DIBUTTON_BBALLD_MENU                0x130004FDL
#define DIHATSWITCH_BBALLD_GLANCE           0x13004601L
#define DIBUTTON_BBALLD_TIMEOUT             0x13004408L
#define DIBUTTON_BBALLD_SUBSTITUTE          0x13004409L
#define DIBUTTON_BBALLD_LEFT_LINK           0x1300C4E4L
#define DIBUTTON_BBALLD_RIGHT_LINK          0x1300C4ECL
#define DIBUTTON_BBALLD_FORWARD_LINK        0x130144E0L
#define DIBUTTON_BBALLD_BACK_LINK           0x130144E8L
#define DIBUTTON_BBALLD_DEVICE              0x130044FEL
#define DIBUTTON_BBALLD_PAUSE               0x130044FCL
#define DIVIRTUAL_SPORTS_FOOTBALL_FIELD     0x14000000L
#define DIBUTTON_FOOTBALLP_PLAY             0x14000401L
#define DIBUTTON_FOOTBALLP_SELECT           0x14000402L
#define DIBUTTON_FOOTBALLP_HELP             0x14000403L
#define DIBUTTON_FOOTBALLP_MENU             0x140004FDL
#define DIBUTTON_FOOTBALLP_DEVICE           0x140044FEL
#define DIBUTTON_FOOTBALLP_PAUSE            0x140044FCL
#define DIVIRTUAL_SPORTS_FOOTBALL_QBCK      0x15000000L
#define DIAXIS_FOOTBALLQ_LATERAL            0x15008201L
#define DIAXIS_FOOTBALLQ_MOVE               0x15010202L
#define DIBUTTON_FOOTBALLQ_SELECT           0x15000401L
#define DIBUTTON_FOOTBALLQ_SNAP             0x15000402L
#define DIBUTTON_FOOTBALLQ_JUMP             0x15000403L
#define DIBUTTON_FOOTBALLQ_SLIDE            0x15000404L
#define DIBUTTON_FOOTBALLQ_PASS             0x15000405L
#define DIBUTTON_FOOTBALLQ_FAKE             0x15000406L
#define DIBUTTON_FOOTBALLQ_MENU             0x150004FDL
#define DIBUTTON_FOOTBALLQ_FAKESNAP         0x15004407L
#define DIBUTTON_FOOTBALLQ_MOTION           0x15004408L
#define DIBUTTON_FOOTBALLQ_AUDIBLE          0x15004409L
#define DIBUTTON_FOOTBALLQ_LEFT_LINK        0x1500C4E4L
#define DIBUTTON_FOOTBALLQ_RIGHT_LINK       0x1500C4ECL
#define DIBUTTON_FOOTBALLQ_FORWARD_LINK     0x150144E0L
#define DIBUTTON_FOOTBALLQ_BACK_LINK        0x150144E8L
#define DIBUTTON_FOOTBALLQ_DEVICE           0x150044FEL
#define DIBUTTON_FOOTBALLQ_PAUSE            0x150044FCL
#define DIVIRTUAL_SPORTS_FOOTBALL_OFFENSE   0x16000000L
#define DIAXIS_FOOTBALLO_LATERAL            0x16008201L
#define DIAXIS_FOOTBALLO_MOVE               0x16010202L
#define DIBUTTON_FOOTBALLO_JUMP             0x16000401L
#define DIBUTTON_FOOTBALLO_LEFTARM          0x16000402L
#define DIBUTTON_FOOTBALLO_RIGHTARM         0x16000403L
#define DIBUTTON_FOOTBALLO_THROW            0x16000404L
#define DIBUTTON_FOOTBALLO_SPIN             0x16000405L
#define DIBUTTON_FOOTBALLO_MENU             0x160004FDL
#define DIBUTTON_FOOTBALLO_JUKE             0x16004406L
#define DIBUTTON_FOOTBALLO_SHOULDER         0x16004407L
#define DIBUTTON_FOOTBALLO_TURBO            0x16004408L
#define DIBUTTON_FOOTBALLO_DIVE             0x16004409L
#define DIBUTTON_FOOTBALLO_ZOOM             0x1600440AL
#define DIBUTTON_FOOTBALLO_SUBSTITUTE       0x1600440BL
#define DIBUTTON_FOOTBALLO_LEFT_LINK        0x1600C4E4L
#define DIBUTTON_FOOTBALLO_RIGHT_LINK       0x1600C4ECL
#define DIBUTTON_FOOTBALLO_FORWARD_LINK     0x160144E0L
#define DIBUTTON_FOOTBALLO_BACK_LINK        0x160144E8L
#define DIBUTTON_FOOTBALLO_DEVICE           0x160044FEL
#define DIBUTTON_FOOTBALLO_PAUSE            0x160044FCL
#define DIVIRTUAL_SPORTS_FOOTBALL_DEFENSE   0x17000000L
#define DIAXIS_FOOTBALLD_LATERAL            0x17008201L
#define DIAXIS_FOOTBALLD_MOVE               0x17010202L
#define DIBUTTON_FOOTBALLD_PLAY             0x17000401L
#define DIBUTTON_FOOTBALLD_SELECT           0x17000402L
#define DIBUTTON_FOOTBALLD_JUMP             0x17000403L
#define DIBUTTON_FOOTBALLD_TACKLE           0x17000404L
#define DIBUTTON_FOOTBALLD_FAKE             0x17000405L
#define DIBUTTON_FOOTBALLD_SUPERTACKLE      0x17000406L
#define DIBUTTON_FOOTBALLD_MENU             0x170004FDL
#define DIBUTTON_FOOTBALLD_SPIN             0x17004407L
#define DIBUTTON_FOOTBALLD_SWIM             0x17004408L
#define DIBUTTON_FOOTBALLD_BULLRUSH         0x17004409L
#define DIBUTTON_FOOTBALLD_RIP              0x1700440AL
#define DIBUTTON_FOOTBALLD_AUDIBLE          0x1700440BL
#define DIBUTTON_FOOTBALLD_ZOOM             0x1700440CL
#define DIBUTTON_FOOTBALLD_SUBSTITUTE       0x1700440DL
#define DIBUTTON_FOOTBALLD_LEFT_LINK        0x1700C4E4L
#define DIBUTTON_FOOTBALLD_RIGHT_LINK       0x1700C4ECL
#define DIBUTTON_FOOTBALLD_FORWARD_LINK     0x170144E0L
#define DIBUTTON_FOOTBALLD_BACK_LINK        0x170144F8L
#define DIBUTTON_FOOTBALLD_DEVICE           0x170044FEL
#define DIBUTTON_FOOTBALLD_PAUSE            0x170044FCL
#define DIVIRTUAL_SPORTS_GOLF               0x18000000L
#define DIAXIS_GOLF_LATERAL                 0x18008201L
#define DIAXIS_GOLF_MOVE                    0x18010202L
#define DIBUTTON_GOLF_SWING                 0x18000401L
#define DIBUTTON_GOLF_SELECT                0x18000402L
#define DIBUTTON_GOLF_UP                    0x18000403L
#define DIBUTTON_GOLF_DOWN                  0x18000404L
#define DIBUTTON_GOLF_TERRAIN               0x18000405L
#define DIBUTTON_GOLF_FLYBY                 0x18000406L
#define DIBUTTON_GOLF_MENU                  0x180004FDL
#define DIHATSWITCH_GOLF_SCROLL             0x18004601L
#define DIBUTTON_GOLF_ZOOM                  0x18004407L
#define DIBUTTON_GOLF_TIMEOUT               0x18004408L
#define DIBUTTON_GOLF_SUBSTITUTE            0x18004409L
#define DIBUTTON_GOLF_LEFT_LINK             0x1800C4E4L
#define DIBUTTON_GOLF_RIGHT_LINK            0x1800C4ECL
#define DIBUTTON_GOLF_FORWARD_LINK          0x180144E0L
#define DIBUTTON_GOLF_BACK_LINK             0x180144E8L
#define DIBUTTON_GOLF_DEVICE                0x180044FEL
#define DIBUTTON_GOLF_PAUSE                 0x180044FCL
#define DIVIRTUAL_SPORTS_HOCKEY_OFFENSE     0x19000000L
#define DIAXIS_HOCKEYO_LATERAL              0x19008201L
#define DIAXIS_HOCKEYO_MOVE                 0x19010202L
#define DIBUTTON_HOCKEYO_SHOOT              0x19000401L
#define DIBUTTON_HOCKEYO_PASS               0x19000402L
#define DIBUTTON_HOCKEYO_BURST              0x19000403L
#define DIBUTTON_HOCKEYO_SPECIAL            0x19000404L
#define DIBUTTON_HOCKEYO_FAKE               0x19000405L
#define DIBUTTON_HOCKEYO_MENU               0x190004FDL
#define DIHATSWITCH_HOCKEYO_SCROLL          0x19004601L
#define DIBUTTON_HOCKEYO_ZOOM               0x19004406L
#define DIBUTTON_HOCKEYO_STRATEGY           0x19004407L
#define DIBUTTON_HOCKEYO_TIMEOUT            0x19004408L
#define DIBUTTON_HOCKEYO_SUBSTITUTE         0x19004409L
#define DIBUTTON_HOCKEYO_LEFT_LINK          0x1900C4E4L
#define DIBUTTON_HOCKEYO_RIGHT_LINK         0x1900C4ECL
#define DIBUTTON_HOCKEYO_FORWARD_LINK       0x190144E0L
#define DIBUTTON_HOCKEYO_BACK_LINK          0x190144E8L
#define DIBUTTON_HOCKEYO_DEVICE             0x190044FEL
#define DIBUTTON_HOCKEYO_PAUSE              0x190044FCL
#define DIVIRTUAL_SPORTS_HOCKEY_DEFENSE     0x1A000000L
#define DIAXIS_HOCKEYD_LATERAL              0x1A008201L
#define DIAXIS_HOCKEYD_MOVE                 0x1A010202L
#define DIBUTTON_HOCKEYD_PLAYER             0x1A000401L
#define DIBUTTON_HOCKEYD_STEAL              0x1A000402L
#define DIBUTTON_HOCKEYD_BURST              0x1A000403L
#define DIBUTTON_HOCKEYD_BLOCK              0x1A000404L
#define DIBUTTON_HOCKEYD_FAKE               0x1A000405L
#define DIBUTTON_HOCKEYD_MENU               0x1A0004FDL
#define DIHATSWITCH_HOCKEYD_SCROLL          0x1A004601L
#define DIBUTTON_HOCKEYD_ZOOM               0x1A004406L
#define DIBUTTON_HOCKEYD_STRATEGY           0x1A004407L
#define DIBUTTON_HOCKEYD_TIMEOUT            0x1A004408L
#define DIBUTTON_HOCKEYD_SUBSTITUTE         0x1A004409L
#define DIBUTTON_HOCKEYD_LEFT_LINK          0x1A00C4E4L
#define DIBUTTON_HOCKEYD_RIGHT_LINK         0x1A00C4ECL
#define DIBUTTON_HOCKEYD_FORWARD_LINK       0x1A0144E0L
#define DIBUTTON_HOCKEYD_BACK_LINK          0x1A0144E8L
#define DIBUTTON_HOCKEYD_DEVICE             0x1A0044FEL
#define DIBUTTON_HOCKEYD_PAUSE              0x1A0044FCL
#define DIVIRTUAL_SPORTS_HOCKEY_GOALIE      0x1B000000L
#define DIAXIS_HOCKEYG_LATERAL              0x1B008201L
#define DIAXIS_HOCKEYG_MOVE                 0x1B010202L
#define DIBUTTON_HOCKEYG_PASS               0x1B000401L
#define DIBUTTON_HOCKEYG_POKE               0x1B000402L
#define DIBUTTON_HOCKEYG_STEAL              0x1B000403L
#define DIBUTTON_HOCKEYG_BLOCK              0x1B000404L
#define DIBUTTON_HOCKEYG_MENU               0x1B0004FDL
#define DIHATSWITCH_HOCKEYG_SCROLL          0x1B004601L
#define DIBUTTON_HOCKEYG_ZOOM               0x1B004405L
#define DIBUTTON_HOCKEYG_STRATEGY           0x1B004406L
#define DIBUTTON_HOCKEYG_TIMEOUT            0x1B004407L
#define DIBUTTON_HOCKEYG_SUBSTITUTE         0x1B004408L
#define DIBUTTON_HOCKEYG_LEFT_LINK          0x1B00C4E4L
#define DIBUTTON_HOCKEYG_RIGHT_LINK         0x1B00C4ECL
#define DIBUTTON_HOCKEYG_FORWARD_LINK       0x1B0144E0L
#define DIBUTTON_HOCKEYG_BACK_LINK          0x1B0144E8L
#define DIBUTTON_HOCKEYG_DEVICE             0x1B0044FEL
#define DIBUTTON_HOCKEYG_PAUSE              0x1B0044FCL
#define DIVIRTUAL_SPORTS_BIKING_MOUNTAIN    0x1C000000L
#define DIAXIS_BIKINGM_TURN                 0x1C008201L
#define DIAXIS_BIKINGM_PEDAL                0x1C010202L
#define DIBUTTON_BIKINGM_JUMP               0x1C000401L
#define DIBUTTON_BIKINGM_CAMERA             0x1C000402L
#define DIBUTTON_BIKINGM_SPECIAL1           0x1C000403L
#define DIBUTTON_BIKINGM_SELECT             0x1C000404L
#define DIBUTTON_BIKINGM_SPECIAL2           0x1C000405L
#define DIBUTTON_BIKINGM_MENU               0x1C0004FDL
#define DIHATSWITCH_BIKINGM_SCROLL          0x1C004601L
#define DIBUTTON_BIKINGM_ZOOM               0x1C004406L
#define DIAXIS_BIKINGM_BRAKE                0x1C044203L
#define DIBUTTON_BIKINGM_LEFT_LINK          0x1C00C4E4L
#define DIBUTTON_BIKINGM_RIGHT_LINK         0x1C00C4ECL
#define DIBUTTON_BIKINGM_FASTER_LINK        0x1C0144E0L
#define DIBUTTON_BIKINGM_SLOWER_LINK        0x1C0144E8L
#define DIBUTTON_BIKINGM_BRAKE_BUTTON_LINK  0x1C0444E8L
#define DIBUTTON_BIKINGM_DEVICE             0x1C0044FEL
#define DIBUTTON_BIKINGM_PAUSE              0x1C0044FCL
#define DIVIRTUAL_SPORTS_SKIING             0x1D000000L
#define DIAXIS_SKIING_TURN                  0x1D008201L
#define DIAXIS_SKIING_SPEED                 0x1D010202L
#define DIBUTTON_SKIING_JUMP                0x1D000401L
#define DIBUTTON_SKIING_CROUCH              0x1D000402L
#define DIBUTTON_SKIING_CAMERA              0x1D000403L
#define DIBUTTON_SKIING_SPECIAL1            0x1D000404L
#define DIBUTTON_SKIING_SELECT              0x1D000405L
#define DIBUTTON_SKIING_SPECIAL2            0x1D000406L
#define DIBUTTON_SKIING_MENU                0x1D0004FDL
#define DIHATSWITCH_SKIING_GLANCE           0x1D004601L
#define DIBUTTON_SKIING_ZOOM                0x1D004407L
#define DIBUTTON_SKIING_LEFT_LINK           0x1D00C4E4L
#define DIBUTTON_SKIING_RIGHT_LINK          0x1D00C4ECL
#define DIBUTTON_SKIING_FASTER_LINK         0x1D0144E0L
#define DIBUTTON_SKIING_SLOWER_LINK         0x1D0144E8L
#define DIBUTTON_SKIING_DEVICE              0x1D0044FEL
#define DIBUTTON_SKIING_PAUSE               0x1D0044FCL
#define DIVIRTUAL_SPORTS_SOCCER_OFFENSE     0x1E000000L
#define DIAXIS_SOCCERO_LATERAL              0x1E008201L
#define DIAXIS_SOCCERO_MOVE                 0x1E010202L
#define DIAXIS_SOCCERO_BEND                 0x1E010203L
#define DIBUTTON_SOCCERO_SHOOT              0x1E000401L
#define DIBUTTON_SOCCERO_PASS               0x1E000402L
#define DIBUTTON_SOCCERO_FAKE               0x1E000403L
#define DIBUTTON_SOCCERO_PLAYER             0x1E000404L
#define DIBUTTON_SOCCERO_SPECIAL1           0x1E000405L
#define DIBUTTON_SOCCERO_SELECT             0x1E000406L
#define DIBUTTON_SOCCERO_MENU               0x1E0004FDL
#define DIHATSWITCH_SOCCERO_GLANCE          0x1E004601L
#define DIBUTTON_SOCCERO_SUBSTITUTE         0x1E004407L
#define DIBUTTON_SOCCERO_SHOOTLOW           0x1E004408L
#define DIBUTTON_SOCCERO_SHOOTHIGH          0x1E004409L
#define DIBUTTON_SOCCERO_PASSTHRU           0x1E00440AL
#define DIBUTTON_SOCCERO_SPRINT             0x1E00440BL
#define DIBUTTON_SOCCERO_CONTROL            0x1E00440CL
#define DIBUTTON_SOCCERO_HEAD               0x1E00440DL
#define DIBUTTON_SOCCERO_LEFT_LINK          0x1E00C4E4L
#define DIBUTTON_SOCCERO_RIGHT_LINK         0x1E00C4ECL
#define DIBUTTON_SOCCERO_FORWARD_LINK       0x1E0144E0L
#define DIBUTTON_SOCCERO_BACK_LINK          0x1E0144E8L
#define DIBUTTON_SOCCERO_DEVICE             0x1E0044FEL
#define DIBUTTON_SOCCERO_PAUSE              0x1E0044FCL
#define DIVIRTUAL_SPORTS_SOCCER_DEFENSE     0x1F000000L
#define DIAXIS_SOCCERD_LATERAL              0x1F008201L
#define DIAXIS_SOCCERD_MOVE                 0x1F010202L
#define DIBUTTON_SOCCERD_BLOCK              0x1F000401L
#define DIBUTTON_SOCCERD_STEAL              0x1F000402L
#define DIBUTTON_SOCCERD_FAKE               0x1F000403L
#define DIBUTTON_SOCCERD_PLAYER             0x1F000404L
#define DIBUTTON_SOCCERD_SPECIAL            0x1F000405L
#define DIBUTTON_SOCCERD_SELECT             0x1F000406L
#define DIBUTTON_SOCCERD_SLIDE              0x1F000407L
#define DIBUTTON_SOCCERD_MENU               0x1F0004FDL
#define DIHATSWITCH_SOCCERD_GLANCE          0x1F004601L
#define DIBUTTON_SOCCERD_FOUL               0x1F004408L
#define DIBUTTON_SOCCERD_HEAD               0x1F004409L
#define DIBUTTON_SOCCERD_CLEAR              0x1F00440AL
#define DIBUTTON_SOCCERD_GOALIECHARGE       0x1F00440BL
#define DIBUTTON_SOCCERD_SUBSTITUTE         0x1F00440CL
#define DIBUTTON_SOCCERD_LEFT_LINK          0x1F00C4E4L
#define DIBUTTON_SOCCERD_RIGHT_LINK         0x1F00C4ECL
#define DIBUTTON_SOCCERD_FORWARD_LINK       0x1F0144E0L
#define DIBUTTON_SOCCERD_BACK_LINK          0x1F0144E8L
#define DIBUTTON_SOCCERD_DEVICE             0x1F0044FEL
#define DIBUTTON_SOCCERD_PAUSE              0x1F0044FCL
#define DIVIRTUAL_SPORTS_RACQUET            0x20000000L
#define DIAXIS_RACQUET_LATERAL              0x20008201L
#define DIAXIS_RACQUET_MOVE                 0x20010202L
#define DIBUTTON_RACQUET_SWING              0x20000401L
#define DIBUTTON_RACQUET_BACKSWING          0x20000402L
#define DIBUTTON_RACQUET_SMASH              0x20000403L
#define DIBUTTON_RACQUET_SPECIAL            0x20000404L
#define DIBUTTON_RACQUET_SELECT             0x20000405L
#define DIBUTTON_RACQUET_MENU               0x200004FDL
#define DIHATSWITCH_RACQUET_GLANCE          0x20004601L
#define DIBUTTON_RACQUET_TIMEOUT            0x20004406L
#define DIBUTTON_RACQUET_SUBSTITUTE         0x20004407L
#define DIBUTTON_RACQUET_LEFT_LINK          0x2000C4E4L
#define DIBUTTON_RACQUET_RIGHT_LINK         0x2000C4ECL
#define DIBUTTON_RACQUET_FORWARD_LINK       0x200144E0L
#define DIBUTTON_RACQUET_BACK_LINK          0x200144E8L
#define DIBUTTON_RACQUET_DEVICE             0x200044FEL
#define DIBUTTON_RACQUET_PAUSE              0x200044FCL
#define DIVIRTUAL_ARCADE_SIDE2SIDE          0x21000000L
#define DIAXIS_ARCADES_LATERAL              0x21008201L
#define DIAXIS_ARCADES_MOVE                 0x21010202L
#define DIBUTTON_ARCADES_THROW              0x21000401L
#define DIBUTTON_ARCADES_CARRY              0x21000402L
#define DIBUTTON_ARCADES_ATTACK             0x21000403L
#define DIBUTTON_ARCADES_SPECIAL            0x21000404L
#define DIBUTTON_ARCADES_SELECT             0x21000405L
#define DIBUTTON_ARCADES_MENU               0x210004FDL
#define DIHATSWITCH_ARCADES_VIEW            0x21004601L
#define DIBUTTON_ARCADES_LEFT_LINK          0x2100C4E4L
#define DIBUTTON_ARCADES_RIGHT_LINK         0x2100C4ECL
#define DIBUTTON_ARCADES_FORWARD_LINK       0x210144E0L
#define DIBUTTON_ARCADES_BACK_LINK          0x210144E8L
#define DIBUTTON_ARCADES_VIEW_UP_LINK       0x2107C4E0L
#define DIBUTTON_ARCADES_VIEW_DOWN_LINK     0x2107C4E8L
#define DIBUTTON_ARCADES_VIEW_LEFT_LINK     0x2107C4E4L
#define DIBUTTON_ARCADES_VIEW_RIGHT_LINK    0x2107C4ECL
#define DIBUTTON_ARCADES_DEVICE             0x210044FEL
#define DIBUTTON_ARCADES_PAUSE              0x210044FCL
#define DIVIRTUAL_ARCADE_PLATFORM           0x22000000L
#define DIAXIS_ARCADEP_LATERAL              0x22008201L
#define DIAXIS_ARCADEP_MOVE                 0x22010202L
#define DIBUTTON_ARCADEP_JUMP               0x22000401L
#define DIBUTTON_ARCADEP_FIRE               0x22000402L
#define DIBUTTON_ARCADEP_CROUCH             0x22000403L
#define DIBUTTON_ARCADEP_SPECIAL            0x22000404L
#define DIBUTTON_ARCADEP_SELECT             0x22000405L
#define DIBUTTON_ARCADEP_MENU               0x220004FDL
#define DIHATSWITCH_ARCADEP_VIEW            0x22004601L
#define DIBUTTON_ARCADEP_FIRESECONDARY      0x22004406L
#define DIBUTTON_ARCADEP_LEFT_LINK          0x2200C4E4L
#define DIBUTTON_ARCADEP_RIGHT_LINK         0x2200C4ECL
#define DIBUTTON_ARCADEP_FORWARD_LINK       0x220144E0L
#define DIBUTTON_ARCADEP_BACK_LINK          0x220144E8L
#define DIBUTTON_ARCADEP_VIEW_UP_LINK       0x2207C4E0L
#define DIBUTTON_ARCADEP_VIEW_DOWN_LINK     0x2207C4E8L
#define DIBUTTON_ARCADEP_VIEW_LEFT_LINK     0x2207C4E4L
#define DIBUTTON_ARCADEP_VIEW_RIGHT_LINK    0x2207C4ECL
#define DIBUTTON_ARCADEP_DEVICE             0x220044FEL
#define DIBUTTON_ARCADEP_PAUSE              0x220044FCL
#define DIVIRTUAL_CAD_2DCONTROL             0x23000000L
#define DIAXIS_2DCONTROL_LATERAL            0x23008201L
#define DIAXIS_2DCONTROL_MOVE               0x23010202L
#define DIAXIS_2DCONTROL_INOUT              0x23010203L
#define DIBUTTON_2DCONTROL_SELECT           0x23000401L
#define DIBUTTON_2DCONTROL_SPECIAL1         0x23000402L
#define DIBUTTON_2DCONTROL_SPECIAL          0x23000403L
#define DIBUTTON_2DCONTROL_SPECIAL2         0x23000404L
#define DIBUTTON_2DCONTROL_MENU             0x230004FDL
#define DIHATSWITCH_2DCONTROL_HATSWITCH     0x23004601L
#define DIAXIS_2DCONTROL_ROTATEZ            0x23024204L
#define DIBUTTON_2DCONTROL_DISPLAY          0x23004405L
#define DIBUTTON_2DCONTROL_DEVICE           0x230044FEL
#define DIBUTTON_2DCONTROL_PAUSE            0x230044FCL
#define DIVIRTUAL_CAD_3DCONTROL             0x24000000L
#define DIAXIS_3DCONTROL_LATERAL            0x24008201L
#define DIAXIS_3DCONTROL_MOVE               0x24010202L
#define DIAXIS_3DCONTROL_INOUT              0x24018203L
#define DIBUTTON_3DCONTROL_SELECT           0x24000401L
#define DIBUTTON_3DCONTROL_SPECIAL1         0x24000402L
#define DIBUTTON_3DCONTROL_SPECIAL          0x24000403L
#define DIBUTTON_3DCONTROL_SPECIAL2         0x24000404L
#define DIBUTTON_3DCONTROL_MENU             0x240004FDL
#define DIHATSWITCH_3DCONTROL_HATSWITCH     0x24004601L
#define DIAXIS_3DCONTROL_ROTATEX            0x24034204L
#define DIAXIS_3DCONTROL_ROTATEY            0x2402C205L
#define DIAXIS_3DCONTROL_ROTATEZ            0x24024206L
#define DIBUTTON_3DCONTROL_DISPLAY          0x24004405L
#define DIBUTTON_3DCONTROL_DEVICE           0x240044FEL
#define DIBUTTON_3DCONTROL_PAUSE            0x240044FCL
#define DIVIRTUAL_CAD_FLYBY                 0x25000000L
#define DIAXIS_CADF_LATERAL                 0x25008201L
#define DIAXIS_CADF_MOVE                    0x25010202L
#define DIAXIS_CADF_INOUT                   0x25018203L
#define DIBUTTON_CADF_SELECT                0x25000401L
#define DIBUTTON_CADF_SPECIAL1              0x25000402L
#define DIBUTTON_CADF_SPECIAL               0x25000403L
#define DIBUTTON_CADF_SPECIAL2              0x25000404L
#define DIBUTTON_CADF_MENU                  0x250004FDL
#define DIHATSWITCH_CADF_HATSWITCH          0x25004601L
#define DIAXIS_CADF_ROTATEX                 0x25034204L
#define DIAXIS_CADF_ROTATEY                 0x2502C205L
#define DIAXIS_CADF_ROTATEZ                 0x25024206L
#define DIBUTTON_CADF_DISPLAY               0x25004405L
#define DIBUTTON_CADF_DEVICE                0x250044FEL
#define DIBUTTON_CADF_PAUSE                 0x250044FCL
#define DIVIRTUAL_CAD_MODEL                 0x26000000L
#define DIAXIS_CADM_LATERAL                 0x26008201L
#define DIAXIS_CADM_MOVE                    0x26010202L
#define DIAXIS_CADM_INOUT                   0x26010203L
#define DIBUTTON_CADM_SELECT                0x26000401L
#define DIBUTTON_CADM_SPECIAL1              0x26000402L
#define DIBUTTON_CADM_SPECIAL               0x26000403L
#define DIBUTTON_CADM_SPECIAL2              0x26000404L
#define DIBUTTON_CADM_MENU                  0x260004FDL
#define DIHATSWITCH_CADM_HATSWITCH          0x26004601L
#define DIAXIS_CADM_ROTATEX                 0x26034204L
#define DIAXIS_CADM_ROTATEY                 0x2602C205L
#define DIAXIS_CADM_ROTATEZ                 0x26024206L
#define DIBUTTON_CADM_DISPLAY               0x26004405L
#define DIBUTTON_CADM_DEVICE                0x260044FEL
#define DIBUTTON_CADM_PAUSE                 0x260044FCL
#define DIVIRTUAL_REMOTE_CONTROL            0x27000000L
#define DIAXIS_REMOTE_SLIDER                0x27050201L
#define DIBUTTON_REMOTE_MUTE                0x27000401L
#define DIBUTTON_REMOTE_SELECT              0x27000402L
#define DIBUTTON_REMOTE_PLAY                0x27002403L
#define DIBUTTON_REMOTE_CUE                 0x27002404L
#define DIBUTTON_REMOTE_REVIEW              0x27002405L
#define DIBUTTON_REMOTE_CHANGE              0x27002406L
#define DIBUTTON_REMOTE_RECORD              0x27002407L
#define DIBUTTON_REMOTE_MENU                0x270004FDL
#define DIAXIS_REMOTE_SLIDER2               0x27054202L
#define DIBUTTON_REMOTE_TV                  0x27005C08L
#define DIBUTTON_REMOTE_CABLE               0x27005C09L
#define DIBUTTON_REMOTE_CD                  0x27005C0AL
#define DIBUTTON_REMOTE_VCR                 0x27005C0BL
#define DIBUTTON_REMOTE_TUNER               0x27005C0CL
#define DIBUTTON_REMOTE_DVD                 0x27005C0DL
#define DIBUTTON_REMOTE_ADJUST              0x27005C0EL
#define DIBUTTON_REMOTE_DIGIT0              0x2700540FL
#define DIBUTTON_REMOTE_DIGIT1              0x27005410L
#define DIBUTTON_REMOTE_DIGIT2              0x27005411L
#define DIBUTTON_REMOTE_DIGIT3              0x27005412L
#define DIBUTTON_REMOTE_DIGIT4              0x27005413L
#define DIBUTTON_REMOTE_DIGIT5              0x27005414L
#define DIBUTTON_REMOTE_DIGIT6              0x27005415L
#define DIBUTTON_REMOTE_DIGIT7              0x27005416L
#define DIBUTTON_REMOTE_DIGIT8              0x27005417L
#define DIBUTTON_REMOTE_DIGIT9              0x27005418L
#define DIBUTTON_REMOTE_DEVICE              0x270044FEL
#define DIBUTTON_REMOTE_PAUSE               0x270044FCL
#define DIVIRTUAL_BROWSER_CONTROL           0x28000000L
#define DIAXIS_BROWSER_LATERAL              0x28008201L
#define DIAXIS_BROWSER_MOVE                 0x28010202L
#define DIBUTTON_BROWSER_SELECT             0x28000401L
#define DIAXIS_BROWSER_VIEW                 0x28018203L
#define DIBUTTON_BROWSER_REFRESH            0x28000402L
#define DIBUTTON_BROWSER_MENU               0x280004FDL
#define DIBUTTON_BROWSER_SEARCH             0x28004403L
#define DIBUTTON_BROWSER_STOP               0x28004404L
#define DIBUTTON_BROWSER_HOME               0x28004405L
#define DIBUTTON_BROWSER_FAVORITES          0x28004406L
#define DIBUTTON_BROWSER_NEXT               0x28004407L
#define DIBUTTON_BROWSER_PREVIOUS           0x28004408L
#define DIBUTTON_BROWSER_HISTORY            0x28004409L
#define DIBUTTON_BROWSER_PRINT              0x2800440AL
#define DIBUTTON_BROWSER_DEVICE             0x280044FEL
#define DIBUTTON_BROWSER_PAUSE              0x280044FCL
#define DIVIRTUAL_DRIVING_MECHA             0x29000000L
#define DIAXIS_MECHA_STEER                  0x29008201L
#define DIAXIS_MECHA_TORSO                  0x29010202L
#define DIAXIS_MECHA_ROTATE                 0x29020203L
#define DIAXIS_MECHA_THROTTLE               0x29038204L
#define DIBUTTON_MECHA_FIRE                 0x29000401L
#define DIBUTTON_MECHA_WEAPONS              0x29000402L
#define DIBUTTON_MECHA_TARGET               0x29000403L
#define DIBUTTON_MECHA_REVERSE              0x29000404L
#define DIBUTTON_MECHA_ZOOM                 0x29000405L
#define DIBUTTON_MECHA_JUMP                 0x29000406L
#define DIBUTTON_MECHA_MENU                 0x290004FDL
#define DIBUTTON_MECHA_CENTER               0x29004407L
#define DIHATSWITCH_MECHA_GLANCE            0x29004601L
#define DIBUTTON_MECHA_VIEW                 0x29004408L
#define DIBUTTON_MECHA_FIRESECONDARY        0x29004409L
#define DIBUTTON_MECHA_LEFT_LINK            0x2900C4E4L
#define DIBUTTON_MECHA_RIGHT_LINK           0x2900C4ECL
#define DIBUTTON_MECHA_FORWARD_LINK         0x290144E0L
#define DIBUTTON_MECHA_BACK_LINK            0x290144E8L
#define DIBUTTON_MECHA_ROTATE_LEFT_LINK     0x290244E4L
#define DIBUTTON_MECHA_ROTATE_RIGHT_LINK    0x290244ECL
#define DIBUTTON_MECHA_FASTER_LINK          0x2903C4E0L
#define DIBUTTON_MECHA_SLOWER_LINK          0x2903C4E8L
#define DIBUTTON_MECHA_DEVICE               0x290044FEL
#define DIBUTTON_MECHA_PAUSE                0x290044FCL
#define DIAXIS_ANY_X_1                      0xFF00C201L
#define DIAXIS_ANY_X_2                      0xFF00C202L
#define DIAXIS_ANY_Y_1                      0xFF014201L
#define DIAXIS_ANY_Y_2                      0xFF014202L
#define DIAXIS_ANY_Z_1                      0xFF01C201L
#define DIAXIS_ANY_Z_2                      0xFF01C202L
#define DIAXIS_ANY_R_1                      0xFF024201L
#define DIAXIS_ANY_R_2                      0xFF024202L
#define DIAXIS_ANY_U_1                      0xFF02C201L
#define DIAXIS_ANY_U_2                      0xFF02C202L
#define DIAXIS_ANY_V_1                      0xFF034201L
#define DIAXIS_ANY_V_2                      0xFF034202L
#define DIAXIS_ANY_A_1                      0xFF03C201L
#define DIAXIS_ANY_A_2                      0xFF03C202L
#define DIAXIS_ANY_B_1                      0xFF044201L
#define DIAXIS_ANY_B_2                      0xFF044202L
#define DIAXIS_ANY_C_1                      0xFF04C201L
#define DIAXIS_ANY_C_2                      0xFF04C202L
#define DIAXIS_ANY_S_1                      0xFF054201L
#define DIAXIS_ANY_S_2                      0xFF054202L
#define DIAXIS_ANY_1                        0xFF004201L
#define DIAXIS_ANY_2                        0xFF004202L
#define DIAXIS_ANY_3                        0xFF004203L
#define DIAXIS_ANY_4                        0xFF004204L
#define DIPOV_ANY_1                         0xFF004601L
#define DIPOV_ANY_2                         0xFF004602L
#define DIPOV_ANY_3                         0xFF004603L
#define DIPOV_ANY_4                         0xFF004604L
#define DIBUTTON_ANY( x )                   (0xFF004400L | (x))

/* DirectInput constant force effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DICONSTANTFORCE {
    LONG    lMagnitude;
} DICONSTANTFORCE;
typedef DICONSTANTFORCE         *LPDICONSTANTFORCE;
typedef const DICONSTANTFORCE   *LPCDICONSTANTFORCE;
#endif

/* DirectInput ramp force effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIRAMPFORCE {
    LONG    lStart;
    LONG    lEnd;
} DIRAMPFORCE;
typedef DIRAMPFORCE         *LPDIRAMPFORCE;
typedef const DIRAMPFORCE   *LPCDIRAMPFORCE;
#endif

/* DirectInput periodic effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIPERIODIC {
    DWORD   dwMagnitude;
    LONG    lOffset;
    DWORD   dwPhase;
    DWORD   dwPeriod;
} DIPERIODIC;
typedef DIPERIODIC          *LPDIPERIODIC;
typedef const DIPERIODIC    *LPCDIPERIODIC;
#endif

/* DirectInput condition effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DICONDITION {
    LONG    lOffset;
    LONG    lPositiveCoefficient;
    LONG    lNegativeCoefficient;
    DWORD   dwPositiveSaturation;
    DWORD   dwNegativeSaturation;
    LONG    lDeadBand;
} DICONDITION;
typedef DICONDITION         *LPDICONDITION;
typedef const DICONDITION   *LPCDICONDITION;
#endif

/* DirectInput custom force effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DICUSTOMFORCE {
    DWORD   cChannels;
    DWORD   dwSamplePeriod;
    DWORD   cSamples;
    LPLONG  rglForceData;
} DICUSTOMFORCE;
typedef DICUSTOMFORCE       *LPDICUSTOMFORCE;
typedef const DICUSTOMFORCE *LPCDICUSTOMFORCE;
#endif

/* DirectInput envelope */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIENVELOPE {
    DWORD   dwSize;
    DWORD   dwAttackLevel;
    DWORD   dwAttackTime;
    DWORD   dwFadeLevel;
    DWORD   dwFadeTime;
} DIENVELOPE;
typedef DIENVELOPE          *LPDIENVELOPE;
typedef const DIENVELOPE    *LPCDIENVELOPE;
#endif

/* DirectInput effect for DirectX 5 compatibility */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIEFFECT_DX5 {
    DWORD           dwSize;
    DWORD           dwFlags;
    DWORD           dwDuration;
    DWORD           dwSamplePeriod;
    DWORD           dwGain;
    DWORD           dwTriggerButton;
    DWORD           dwTriggerRepeatInterval;
    DWORD           cAxes;
    LPDWORD         rgdwAxes;
    LPLONG          rglDirection;
    LPDIENVELOPE    lpEnvelope;
    DWORD           cbTypeSpecificParams;
    LPVOID          lpvTypeSpecificParams;
} DIEFFECT_DX5;
typedef DIEFFECT_DX5        *LPDIEFFECT_DX5;
typedef const DIEFFECT_DX5  *LPCDIEFFECT_DX5;
#endif

/* DirectInput effect */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIEFFECT {
    DWORD           dwSize;
    DWORD           dwFlags;
    DWORD           dwDuration;
    DWORD           dwSamplePeriod;
    DWORD           dwGain;
    DWORD           dwTriggerButton;
    DWORD           dwTriggerRepeatInterval;
    DWORD           cAxes;
    LPDWORD         rgdwAxes;
    LPLONG          rglDirection;
    LPDIENVELOPE    lpEnvelope;
    DWORD           cbTypeSpecificParams;
    LPVOID          lpvTypeSpecificParams;
#if (DIRECTINPUT_VERSION >= 0x0600)
    DWORD           dwStartDelay;
#endif
} DIEFFECT;
typedef DIEFFECT        *LPDIEFFECT;
typedef DIEFFECT        DIEFFECT_DX6;
typedef LPDIEFFECT      LPDIEFFECT_DX6;
typedef const DIEFFECT  *LPCDIEFFECT;
#endif

/* DirectInput file effect */
#if (DIRECTINPUT_VERSION >= 0x0700)
typedef struct DIFILEEFFECT {
    DWORD       dwSize;
    GUID        GuidEffect;
    LPCDIEFFECT lpDiEffect;
    CHAR        szFriendlyName[MAX_PATH];
} DIFILEEFFECT;
typedef DIFILEEFFECT        *LPDIFILEEFFECT;
typedef const DIFILEEFFECT  *LPCDIFILEEFFECT;
#endif

/* DirectInput effect enumeration callback */
#if (DIRECTINPUT_VERSION >= 0x0700)
typedef BOOL (PASCAL *LPDIENUMEFFECTSINFILECALLBACK)( LPCDIFILEEFFECT, LPVOID );
#endif

/* DirectInput effect escape */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIEFFESCAPE {
    DWORD   dwSize;
    DWORD   dwCommand;
    LPVOID  lpvInBuffer;
    DWORD   cbInBuffer;
    LPVOID  lpvOutBuffer;
    DWORD   cbOutBuffer;
} DIEFFESCAPE;
typedef DIEFFESCAPE *LPDIEFFESCAPE;
#endif

/* DirectInput device capabilities for DirectX 3 compatibility */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIDEVCAPS_DX3 {
    DWORD   dwSize;
    DWORD   dwFlags;
    DWORD   dwDevType;
    DWORD   dwAxes;
    DWORD   dwButtons;
    DWORD   dwPOVs;
} DIDEVCAPS_DX3;
typedef DIDEVCAPS_DX3   *LPDIDEVCAPS_DX3;
#endif

/* DirectInput device capabilities */
typedef struct DIDEVCAPS {
    DWORD   dwSize;
    DWORD   dwFlags;
    DWORD   dwDevType;
    DWORD   dwAxes;
    DWORD   dwButtons;
    DWORD   dwPOVs;
#if (DIRECTINPUT_VERSION >= 0x0500)
    DWORD   dwFFSamplePeriod;
    DWORD   dwFFMinTimeResolution;
    DWORD   dwFirmwareRevision;
    DWORD   dwHardwareRevision;
    DWORD   dwFFDriverRevision;
#endif
} DIDEVCAPS;
typedef DIDEVCAPS   *LPDIDEVCAPS;

/* DirectInput object data format */
typedef struct _DIOBJECTDATAFORMAT {
    const GUID  *pguid;
    DWORD       dwOfs;
    DWORD       dwType;
    DWORD       dwFlags;
} DIOBJECTDATAFORMAT;
typedef DIOBJECTDATAFORMAT          *LPDIOBJECTDATAFORMAT;
typedef const DIOBJECTDATAFORMAT    *LPCDIOBJECTDATAFORMAT;

/* DirectInput data format */
typedef struct _DIDATAFORMAT {
    DWORD                   dwSize;
    DWORD                   dwObjSize;
    DWORD                   dwFlags;
    DWORD                   dwDataSize;
    DWORD                   dwNumObjs;
    LPDIOBJECTDATAFORMAT    rgodf;
} DIDATAFORMAT;
typedef DIDATAFORMAT        *LPDIDATAFORMAT;
typedef const DIDATAFORMAT  *LPCDIDATAFORMAT;

/* DirectInput action */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DIACTIONA {
    UINT_PTR    uAppData;
    DWORD       dwSemantic;
    DWORD       dwFlags;
    union {
        LPCSTR  lptszActionName;
        UINT    uResIdString;
    };
    GUID        guidInstance;
    DWORD       dwObjID;
    DWORD       dwHow;
} DIACTIONA;
typedef DIACTIONA       *LPDIACTIONA;
typedef const DIACTIONA *LPCDIACTIONA;
typedef struct _DIACTIONW {
    UINT_PTR    uAppData;
    DWORD       dwSemantic;
    DWORD       dwFlags;
    union {
        LPCWSTR lptszActionName;
        UINT    uResIdString;
    };
    GUID        guidInstance;
    DWORD       dwObjID;
    DWORD       dwHow;
} DIACTIONW;
typedef DIACTIONW       *LPDIACTIONW;
typedef const DIACTIONW *LPCDIACTIONW;
#ifdef UNICODE
typedef DIACTIONW       DIACTION;
typedef LPDIACTIONW     LPDIACTION;
typedef LPCDIACTIONW    LPCDIACTION;
#else
typedef DIACTIONA       DIACTION;
typedef LPDIACTIONA     LPDIACTION;
typedef LPCDIACTIONA    LPCDIACTION;
#endif
#endif

/* DirectInput action format */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DIACTIONFORMATA {
    DWORD       dwSize;
    DWORD       dwActionSize;
    DWORD       dwDataSize;
    DWORD       dwNumActions;
    LPDIACTIONA rgoAction;
    GUID        guidActionMap;
    DWORD       dwGenre;
    DWORD       dwBufferSize;
    LONG        lAxisMin;
    LONG        lAxisMax;
    HINSTANCE   hInstString;
    FILETIME    ftTimeStamp;
    DWORD       dwCRC;
    CHAR        tszActionMap[MAX_PATH];
} DIACTIONFORMATA;
typedef DIACTIONFORMATA         *LPDIACTIONFORMATA;
typedef const DIACTIONFORMATA   *LPCDIACTIONFORMATA;
typedef struct _DIACTIONFORMATW {
    DWORD       dwSize;
    DWORD       dwActionSize;
    DWORD       dwDataSize;
    DWORD       dwNumActions;
    LPDIACTIONW rgoAction;
    GUID        guidActionMap;
    DWORD       dwGenre;
    DWORD       dwBufferSize;
    LONG        lAxisMin;
    LONG        lAxisMax;
    HINSTANCE   hInstString;
    FILETIME    ftTimeStamp;
    DWORD       dwCRC;
    WCHAR       tszActionMap[MAX_PATH];
} DIACTIONFORMATW;
typedef DIACTIONFORMATW         *LPDIACTIONFORMATW;
typedef const DIACTIONFORMATW   *LPCDIACTIONFORMATW;
#ifdef UNICODE
typedef DIACTIONFORMATW         DIACTIONFORMAT;
typedef LPDIACTIONFORMATW       LPDIACTIONFORMAT;
typedef LPCDIACTIONFORMATW      LPCDIACTIONFORMAT;
#else
typedef DIACTIONFORMATA         DIACTIONFORMAT;
typedef LPDIACTIONFORMATA       LPDIACTIONFORMAT;
typedef LPCDIACTIONFORMATA      LPCDIACTIONFORMAT;
#endif
#endif

/* DirectInput color set */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DICOLORSET {
    DWORD       dwSize;
    D3DCOLOR    cTextFore;
    D3DCOLOR    cTextHighlight;
    D3DCOLOR    cCalloutLine;
    D3DCOLOR    cCalloutHighlight;
    D3DCOLOR    cBorder;
    D3DCOLOR    cControlFill;
    D3DCOLOR    cHighlightFill;
    D3DCOLOR    cAreaFill;
} DICOLORSET;
typedef DICOLORSET          *LPDICOLORSET;
typedef const DICOLORSET    *LPCDICOLORSET;
#endif

/* DirectInput configure devices parameters */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DICONFIGUREDEVICESPARAMSA {
    DWORD               dwSize;
    DWORD               dwcUsers;
    LPSTR               lptszUserNames;
    DWORD               dwcFormats;
    LPDIACTIONFORMATA   lprgFormats;
    HWND                hwnd;
    DICOLORSET          dics;
    IUnknown            *lpUnkDDSTarget;
} DICONFIGUREDEVICESPARAMSA;
typedef DICONFIGUREDEVICESPARAMSA       *LPDICONFIGUREDEVICESPARAMSA;
typedef const DICONFIGUREDEVICESPARAMSA *LPCDICONFIGUREDEVICESPARAMSA;
typedef struct _DICONFIGUREDEVICESPARAMW {
    DWORD               dwSize;
    DWORD               dwcUsers;
    LPWSTR              lptszUserNames;
    DWORD               dwcFormats;
    LPDIACTIONFORMATW   lprgFormats;
    HWND                hwnd;
    DICOLORSET          dics;
    IUnknown            *lpUnkDDSTarget;
} DICONFIGUREDEVICESPARAMSW;
typedef DICONFIGUREDEVICESPARAMSW       *LPDICONFIGUREDEVICESPARAMSW;
typedef const DICONFIGUREDEVICESPARAMSW *LPCDICONFIGUREDEVICESPARAMSW;
#ifdef UNICODE
typedef DICONFIGUREDEVICESPARAMSW       DICONFIGUREDEVICESPARAMS;
typedef LPDICONFIGUREDEVICESPARAMSW     LPDICONFIGUREDEVICESPARAMS;
typedef LPCDICONFIGUREDEVICESPARAMSW    LPCDICONFIGUREDEVICESPARAMS;
#else
typedef DICONFIGUREDEVICESPARAMSA       DICONFIGUREDEVICESPARAMS;
typedef LPDICONFIGUREDEVICESPARAMSA     LPDICONFIGUREDEVICESPARAMS;
typedef LPCDICONFIGUREDEVICESPARAMSA    LPCDICONFIGUREDEVICESPARAMS;
#endif
#endif

/* DirectInput device image information */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DIDEVICEIMAGEINFOA {
    CHAR    tszImagePath[MAX_PATH];
    DWORD   dwFlags;
    DWORD   dwViewID;
    RECT    rcOverlay;
    DWORD   dwObjID;
    DWORD   dwcValidPts;
    POINT   rgptCalloutLine[5];
    RECT    rcCalloutRect;
    DWORD   dwTextAlign;
} DIDEVICEIMAGEINFOA;
typedef DIDEVICEIMAGEINFOA          *LPDIDEVICEIMAGEINFOA;
typedef const DIDEVICEIMAGEINFOA    *LPCDIDEVICEIMAGEINFOA;
typedef struct _DIDEVICEIMAGEINFOW {
    WCHAR   tszImagePath[MAX_PATH];
    DWORD   dwFlags;
    DWORD   dwViewID;
    RECT    rcOverlay;
    DWORD   dwObjID;
    DWORD   dwcValidPts;
    POINT   rgptCalloutLine[5];
    RECT    rcCalloutRect;
    DWORD   dwTextAlign;
} DIDEVICEIMAGEINFOW;
typedef DIDEVICEIMAGEINFOW          *LPDIDEVICEIMAGEINFOW;
typedef const DIDEVICEIMAGEINFOW    *LPCDIDEVICEIMAGEINFOW;
#ifdef UNICODE
typedef DIDEVICEIMAGEINFOW          DIDEVICEIMAGEINFO;
typedef LPDIDEVICEIMAGEINFOW        LPDIDEVICEIMAGEINFO;
typedef LPCDIDEVICEIMAGEINFOW       LPCDIDEVICEIMAGEINFO;
#else
typedef DIDEVICEIMAGEINFOA          DIDEVICEIMAGEINFO;
typedef LPDIDEVICEIMAGEINFOA        LPDIDEVICEIMAGEINFO;
typedef LPCDIDEVICEIMAGEINFOA       LPCDIDEVICEIMAGEINFO;
#endif
#endif

/* DirectInput device image information header */
#if (DIRECTINPUT_VERSION > 0x0700)
typedef struct _DIDEVICEIMAGEINFOHEADERA {
    DWORD                   dwSize;
    DWORD                   dwSizeImageInfo;
    DWORD                   dwcViews;
    DWORD                   dwcButtons;
    DWORD                   dwcAxes;
    DWORD                   dwcPOVs;
    DWORD                   dwBufferSize;
    DWORD                   dwBufferUsed;
    LPDIDEVICEIMAGEINFOA    lprgImageInfoArray;
} DIDEVICEIMAGEINFOHEADERA;
typedef DIDEVICEIMAGEINFOHEADERA        *LPDIDEVICEIMAGEINFOHEADERA;
typedef const DIDEVICEIMAGEINFOHEADERA  *LPCDIDEVICEIMAGEINFOHEADERA;
typedef struct _DIDEVICEIMAGEINFOHEADERW {
    DWORD                   dwSize;
    DWORD                   dwSizeImageInfo;
    DWORD                   dwcViews;
    DWORD                   dwcButtons;
    DWORD                   dwcAxes;
    DWORD                   dwcPOVs;
    DWORD                   dwBufferSize;
    DWORD                   dwBufferUsed;
    LPDIDEVICEIMAGEINFOW    lprgImageInfoArray;
} DIDEVICEIMAGEINFOHEADERW;
typedef DIDEVICEIMAGEINFOHEADERW        *LPDIDEVICEIMAGEINFOHEADERW;
typedef const DIDEVICEIMAGEINFOHEADERW  *LPCDIDEVICEIMAGEINFOHEADERW;
#ifdef UNICODE
typedef DIDEVICEIMAGEINFOHEADERW        DIDEVICEIMAGEINFOHEADER;
typedef LPDIDEVICEIMAGEINFOHEADERW      LPDIDEVICEIMAGEINFOHEADER;
typedef LPCDIDEVICEIMAGEINFOHEADERW     LPCDIDEVICEIMAGEINFOHEADER;
#else
typedef DIDEVICEIMAGEINFOHEADERA        DIDEVICEIMAGEINFOHEADER;
typedef LPDIDEVICEIMAGEINFOHEADERA      LPDIDEVICEIMAGEINFOHEADER;
typedef LPCDIDEVICEIMAGEINFOHEADERA     LPCDIDEVICEIMAGEINFOHEADER;
#endif
#endif

/* DirectInput device object instance for DirectX 3 compatibility */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIDEVICEOBJECTINSTANCE_DX3A {
    DWORD   dwSize;
    GUID    guidType;
    DWORD   dwOfs;
    DWORD   dwType;
    DWORD   dwFlags;
    CHAR    tszName[MAX_PATH];
} DIDEVICEOBJECTINSTANCE_DX3A;
typedef DIDEVICEOBJECTINSTANCE_DX3A         *LPDIDEVICEOBJECTINSTANCE_DX3A;
typedef const DIDEVICEOBJECTINSTANCE_DX3A   *LPCDIDEVICEOBJECTINSTANCE_DX3A;
typedef struct DIDEVICEOBJECTINSTANCE_DX3W {
    DWORD   dwSize;
    GUID    guidType;
    DWORD   dwOfs;
    DWORD   dwType;
    DWORD   dwFlags;
    WCHAR   tszName[MAX_PATH];
} DIDEVICEOBJECTINSTANCE_DX3W;
typedef DIDEVICEOBJECTINSTANCE_DX3W         *LPDIDEVICEOBJECTINSTANCE_DX3W;
typedef const DIDEVICEOBJECTINSTANCE_DX3W   *LPCDIDEVICEOBJECTINSTANCE_DX3W;
#ifdef UNICODE
typedef DIDEVICEOBJECTINSTANCE_DX3W         DIDEVICEOBJECTINSTANCE_DX3;
typedef LPDIDEVICEOBJECTINSTACE_DX3W        LPDIDEVICEOBJECTINSTANCE_DX3;
typedef LPCDIDEVICEOBJECTINSTANCE_DX3W      LPCDIDEVICEOBJECTINSTANCE_DX3;
#else
typedef DIDEVICEOBJECTINSTANCE_DX3A         DIDEVICEOBJECTINSTANCE_DX3;
typedef LPDIDEVICEOBJECTINSTANCE_DX3A       LPDIDEVICEOBJECTINSTANCE_DX3;
typedef LPCDIDEVICEOBJECTINSTANCE_DX3A      LPCDIDEVICEOBJECTINSTANCE_DX3;
#endif
#endif

/* DirectInput device object instance */
typedef struct DIDEVICEOBJECTINSTANCEA {
    DWORD   dwSize;
    GUID    guidType;
    DWORD   dwOfs;
    DWORD   dwType;
    DWORD   dwFlags;
    CHAR    tszName[MAX_PATH];
#if (DIRECTINPUT_VERSION >= 0x0500)
    DWORD   dwFFMaxForce;
    DWORD   dwFFForceResolution;
    WORD    wCollectionNumber;
    WORD    wDesignatorIndex;
    WORD    wUsagePage;
    WORD    wUsage;
    DWORD   dwDimension;
    WORD    wExponent;
    WORD    wReportId;
#endif
} DIDEVICEOBJECTINSTANCEA;
typedef DIDEVICEOBJECTINSTANCEA         *LPDIDEVICEOBJECTINSTANCEA;
typedef const DIDEVICEOBJECTINSTANCEA   *LPCDIDEVICEOBJECTINSTANCEA;
typedef struct DIDEVICEOBJECTINSTANCEW {
    DWORD   dwSize;
    GUID    guidType;
    DWORD   dwOfs;
    DWORD   dwType;
    DWORD   dwFlags;
    WCHAR   tszName[MAX_PATH];
#if (DIRECTINPUT_VERSION >= 0x0500)
    DWORD   dwFFMaxForce;
    DWORD   dwFFForceResolution;
    WORD    wCollectionNumber;
    WORD    wDesignatorIndex;
    WORD    wUsagePage;
    WORD    wUsage;
    DWORD   dwDimension;
    WORD    wExponent;
    WORD    wReportId;
#endif
} DIDEVICEOBJECTINSTANCEW;
typedef DIDEVICEOBJECTINSTANCEW         *LPDIDEVICEOBJECTINSTANCEW;
typedef const DIDEVICEOBJECTINSTANCEW   *LPCDIDEVICEOBJECTINSTANCEW;
#ifdef UNICODE
typedef DIDEVICEOBJECTINSTANCEW         DIDEVICEOBJECTINSTANCE;
typedef LPDIDEVICEOBJECTINSTANCEW       LPDIDEVICEOBJECTINSTANCE;
typedef LPCDIDEVICEOBJECTINSTANCEW      LPCDIDEVICEOBJECTINSTANCE;
#else
typedef DIDEVICEOBJECTINSTANCEA         DIDEVICEOBJECTINSTANCE;
typedef LPDIDEVICEOBJECTINSTANCEA       LPDIDEVICEOBJECTINSTANCE;
typedef LPCDIDEVICEOBJECTINSTANCEA      LPCDIDEVICEOBJECTINSTANCE;
#endif

/* DirectInput device object enumeration callback */
typedef BOOL (PASCAL *LPDIENUMDEVICEOBJECTSCALLBACKA)( LPCDIDEVICEOBJECTINSTANCEA, LPVOID );
typedef BOOL (PASCAL *LPDIENUMDEVICEOBJECTSCALLBACKW)( LPCDIDEVICEOBJECTINSTANCEW, LPVOID );
#ifdef UNICODE
    #define LPDIENUMDEVICEOBJECTSCALLBACK   LPDIENUMDEVICEOBJECTSCALLBACKW
#else
    #define LPDIENUMDEVICEOBJECTSCALLBACK   LPDIENUMDEVICEOBJECTSCALLBACKA
#endif

/* DirectInput property header */
typedef struct DIPROPHEADER {
    DWORD   dwSize;
    DWORD   dwHeaderSize;
    DWORD   dwObj;
    DWORD   dwHow;
} DIPROPHEADER;
typedef DIPROPHEADER        *LPDIPROPHEADER;
typedef const DIPROPHEADER  *LPCDIPROPHEADER;

/* DirectInput property DWORD */
typedef struct DIPROPDWORD {
    DIPROPHEADER    diph;
    DWORD           dwData;
} DIPROPDWORD;
typedef DIPROPDWORD         *LPDIPROPDWORD;
typedef const DIPROPDWORD   *LPCDIPROPDWORD;

/* DirectInput property pointer */
#if (DIRECTINPUT_VERSION >= 0x0800)
typedef struct DIPROPPOINTER {
    DIPROPHEADER    diph;
    UINT_PTR        uData;
} DIPROPPOINTER;
typedef DIPROPPOINTER       *LPDIPROPPOINTER;
typedef const DIPROPPOINTER *LPCDIPROPPOINTER;
#endif

/* DirectInput property range */
typedef struct DIPROPRANGE {
    DIPROPHEADER    diph;
    LONG            lMin;
    LONG            lMax;
} DIPROPRANGE;
typedef DIPROPRANGE         *LPDIPROPRANGE;
typedef const DIPROPRANGE   *LPCDIPROPRANGE;

/* DirectInput property calibration */
#if (DIRECTINPUT_VERSION >= 0x050A)
typedef struct DIPROPCAL {
    DIPROPHEADER    diph;
    LONG            lMin;
    LONG            lCenter;
    LONG            lMax;
} DIPROPCAL;
typedef DIPROPCAL       *LPDIPROPCAL;
typedef const DIPROPCAL *LPCDIPROPCAL;
#endif

/* DirectInput property calibration point-of-view */
#if (DIRECTINPUT_VERSION >= 0x050A)
typedef struct DIPROPCALPOV {
    DIPROPHEADER    diph;
    LONG            lMin[5];
    LONG            lMax[5];
} DIPROPCALPOV;
typedef DIPROPCALPOV        *LPDIPROPCALPOV;
typedef const DIPROPCALPOV  *LPCDIPROPCALPOV;
#endif

/* DirectInput property GUID and path */
#if (DIRECTINPUT_VERSION >= 0x050A)
typedef struct DIPROPGUIDANDPATH {
    DIPROPHEADER    diph;
    GUID            guidClass;
    WCHAR           wszPath[MAX_PATH];
} DIPROPGUIDANDPATH;
typedef DIPROPGUIDANDPATH       *LPDIPROPGUIDANDPATH;
typedef const DIPROPGUIDANDPATH *LPCDIPROPGUIDANDPATH;
#endif

/* DirectInput property string */
#if (DIRECTINPUT_VERSION >= 0x050A)
typedef struct DIPROPSTRING {
    DIPROPHEADER    diph;
    WCHAR           wsz[MAX_PATH];
} DIPROPSTRING;
typedef DIPROPSTRING        *LPDIPROPSTRING;
typedef const DIPROPSTRING  *LPCDIPROPSTRING;
#endif

/* Calibration point */
#if (DIRECTINPUT_VERSION >= 0x0800)
typedef struct _CPOINT {
    LONG    lP;
    DWORD   dwLog;
} CPOINT;
typedef CPOINT  *PCPOINT;
#endif

/* DirectInput property calibration points */
#if (DIRECTINPUT_VERSION >= 0x0800)
typedef struct DIPROPCPOINTS {
    DIPROPHEADER    diph;
    DWORD           dwCPointsNum;
    CPOINT          cp[MAXCPOINTSNUM];
} DIPROPCPOINTS;
typedef DIPROPCPOINTS       *LPDIPROPCPOINTS;
typedef const DIPROPCPOINTS *LPCDIPROPCPOINTS;
#endif

/* DirectInput device object data for DirectX 3 compatibility */
typedef struct DIDEVICEOBJECTDATA_DX3 {
    DWORD   dwOfs;
    DWORD   dwData;
    DWORD   dwTimeStamp;
    DWORD   dwSequence;
} DIDEVICEOBJECTDATA_DX3;
typedef DIDEVICEOBJECTDATA_DX3          *LPDIDEVICEOBJECTDATA_DX3;
typedef const DIDEVICEOBJECTDATA_DX3    *LPCDIDEVICEOBJECTDATA_DX3;

/* DirectInput device object data */
typedef struct DIDEVICEOBJECTDATA {
    DWORD       dwOfs;
    DWORD       dwData;
    DWORD       dwTimeStamp;
    DWORD       dwSequence;
#if (DIRECTINPUT_VERSION >= 0x0800)
    UINT_PTR    uAppData;
#endif
} DIDEVICEOBJECTDATA;
typedef DIDEVICEOBJECTDATA          *LPDIDEVICEOBJECTDATA;
typedef const DIDEVICEOBJECTDATA    *LPCDIDEVICEOBJECTDATA;

/* DirectInput device instance for DirectX 3 compatibility */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIDEVICEINSTANCE_DX3A {
    DWORD   dwSize;
    GUID    guidInstance;
    GUID    guidProduct;
    DWORD   dwDevType;
    CHAR    tszInstanceName[MAX_PATH];
    CHAR    tszProductName[MAX_PATH];
} DIDEVICEINSTANCE_DX3A;
typedef DIDEVICEINSTANCE_DX3A       *LPDIDEVICEINSTANCE_DX3A;
typedef const DIDEVICEINSTANCE_DX3A *LPCDIDEVICEINSTANCE_DX3A;
typedef struct DIDEVICEINSTANCE_DX3W {
    DWORD   dwSize;
    GUID    guidInstance;
    GUID    guidProduct;
    DWORD   dwDevType;
    WCHAR   tszInstanceName[MAX_PATH];
    WCHAR   tszProductName[MAX_PATH];
} DIDEVICEINSTANCE_DX3W;
typedef DIDEVICEINSTANCE_DX3W       *LPDIDEVICEINSTANCE_DX3W;
typedef const DIDEVICEINSTANCE_DX3W *LPCDIDEVICEINSTANCE_DX3W;
#ifdef UNICODE
typedef DIDEVICEINSTANCE_DX3W       DIDEVICEINSTANCE_DX3;
typedef LPDIDEVICEINSTANCE_DX3W     LPDIDEVICEINSTANCE_DX3;
typedef LPCDIDEVICEINSTANCE_DX3W    LPCDIDEVICEINSTANCE_DX3;
#else
typedef DIDEVICEINSTANCE_DX3A       DIDEVICEINSTANCE_DX3;
typedef LPDIDEVICEINSTANCE_DX3A     LPDIDEVICEINSTANCE_DX3;
typedef LPCDIDEVICEINSTANCE_DX3A    LPCDIDEVICEINSTANCE_DX3;
#endif
#endif

/* DirectInput device instance */
typedef struct DIDEVICEINSTANCEA {
    DWORD   dwSize;
    GUID    guidInstance;
    GUID    guidProduct;
    DWORD   dwDevType;
    CHAR    tszInstanceName[MAX_PATH];
    CHAR    tszProductName[MAX_PATH];
#if (DIRECTINPUT_VERSION >= 0x0500)
    GUID    guidFFDriver;
    WORD    wUsagePage;
    WORD    wUsage;
#endif
} DIDEVICEINSTANCEA;
typedef DIDEVICEINSTANCEA       *LPDIDEVICEINSTANCEA;
typedef const DIDEVICEINSTANCEA *LPCDIDEVICEINSTANCEA;
typedef struct DIDEVICEINSTANCEW {
    DWORD   dwSize;
    GUID    guidInstance;
    GUID    guidProduct;
    DWORD   dwDevType;
    WCHAR   tszInstanceName[MAX_PATH];
    WCHAR   tszProductName[MAX_PATH];
#if (DIRECTINPUT_VERSION >= 0x0500)
    GUID    guidFFDriver;
    WORD    wUsagePage;
    WORD    wUsage;
#endif
} DIDEVICEINSTANCEW;
typedef DIDEVICEINSTANCEW       *LPDIDEVICEINSTANCEW;
typedef const DIDEVICEINSTANCEW *LPCDIDEVICEINSTANCEW;
#ifdef UNICODE
typedef DIDEVICEINSTANCEW       DIDEVICEINSTANCE;
typedef LPDIDEVICEINSTANCEW     LPDIDEVICEINSTANCE;
typedef LPCDIDEVICEINSTANCEW    LPCDIDEVICEINSTANCE;
#else
typedef DIDEVICEINSTANCEA       DIDEVICEINSTANCE;
typedef LPDIDEVICEINSTANCEA     LPDIDEVICEINSTANCE;
typedef LPCDIDEVICEINSTANCEA    LPCDIDEVICEINSTANCE;
#endif

/* DirectInput effect information */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef struct DIEFFECTINFOA {
    DWORD   dwSize;
    GUID    guid;
    DWORD   dwEffType;
    DWORD   dwStaticParams;
    DWORD   dwDynamicParams;
    CHAR    tszName[MAX_PATH];
} DIEFFECTINFOA;
typedef DIEFFECTINFOA       *LPDIEFFECTINFOA;
typedef const DIEFFECTINFOA *LPCDIEFFECTINFOA;
typedef struct DIEFFECTINFOW {
    DWORD   dwSize;
    GUID    guid;
    DWORD   dwEffType;
    DWORD   dwStaticParams;
    DWORD   dwDynamicParams;
    WCHAR   tszName[MAX_PATH];
} DIEFFECTINFOW;
typedef DIEFFECTINFOW       *LPDIEFFECTINFOW;
typedef const DIEFFECTINFOW *LPCDIEFFECTINFOW;
#ifdef UNICODE
typedef DIEFFECTINFOW       DIEFFECTINFO;
typedef LPDIEFFECTINFOW     LPDIEFFECTINFO;
typedef LPCDIEFFECTINFOW    LPCDIEFFECTINFO;
#else
typedef DIEFFECTINFOA       DIEFFECTINFO;
typedef LPDIEFFECTINFOA     LPDIEFFECTINFO;
typedef LPCDIEFFECTINFOA    LPCDIEFFECTINFO;
#endif
#endif

/* DirectInput effect enumeration callbacks */
#if (DIRECTINPUT_VERSION >= 0x0500)
typedef BOOL (PASCAL *LPDIENUMEFFECTSCALLBACKA)( LPCDIEFFECTINFOA, LPVOID );
typedef BOOL (PASCAL *LPDIENUMEFFECTSCALLBACKW)( LPCDIEFFECTINFOW, LPVOID );
typedef BOOL (PASCAL *LPDIENUMCREATEDEFFECTOBJECTSCALLBACK)( IDirectInputEffect *, LPVOID );
#ifdef UNICODE
    #define LPDIENUMEFFECTSCALLBACK LPDIENUMEFFECTSCALLBACKW
#else
    #define LPDIENUMEFFECTSCALLBACK LPDIENUMEFFECTSCALLBACKA
#endif
#endif

/* DirectInput mouse state */
typedef struct _DIMOUSESTATE {
    LONG    lX;
    LONG    lY;
    LONG    lZ;
    BYTE    rgbButtons[4];
} DIMOUSESTATE;
typedef DIMOUSESTATE    *LPDIMOUSESTATE;

/* DirectInput mouse state (version 2) */
#if (DIRECTINPUT_VERSION >= 0x0700)
typedef struct _DIMOUSESTATE2 {
    LONG    lX;
    LONG    lY;
    LONG    lZ;
    BYTE    rgbButtons[8];
} DIMOUSESTATE2;
typedef DIMOUSESTATE2   *LPDIMOUSESTATE2;
#endif

/* DirectInput mouse state field offsets */
#define DIMOFS_X            FIELD_OFFSET( DIMOUSESTATE, lX )
#define DIMOFS_Y            FIELD_OFFSET( DIMOUSESTATE, lY )
#define DIMOFS_Z            FIELD_OFFSET( DIMOUSESTATE, lZ )
#define DIMOFS_BUTTON0      (FIELD_OFFSET( DIMOUSESTATE, rgbButtons ) + 0)
#define DIMOFS_BUTTON1      (FIELD_OFFSET( DIMOUSESTATE, rgbButtons ) + 1)
#define DIMOFS_BUTTON2      (FIELD_OFFSET( DIMOUSESTATE, rgbButtons ) + 2)
#define DIMOFS_BUTTON3      (FIELD_OFFSET( DIMOUSESTATE, rgbButtons ) + 3)
#if (DIRECTINPUT_VERSION >= 0x0700)
    #define DIMOFS_BUTTON4  (FIELD_OFFSET( DIMOUSESTATE2, rgbButtons ) + 4)
    #define DIMOFS_BUTTON5  (FIELD_OFFSET( DIMOUSESTATE2, rgbButtons ) + 5)
    #define DIMOFS_BUTTON6  (FIELD_OFFSET( DIMOUSESTATE2, rgbButtons ) + 6)
    #define DIMOFS_BUTTON7  (FIELD_OFFSET( DIMOUSESTATE2, rgbButtons ) + 7)
#endif

/* DirectInput joystick state */
typedef struct DIJOYSTATE {
    LONG    lX;
    LONG    lY;
    LONG    lZ;
    LONG    lRx;
    LONG    lRy;
    LONG    lRz;
    LONG    rglSlider[2];
    DWORD   rgdwPOV[4];
    BYTE    rgbButtons[32];
} DIJOYSTATE;
typedef DIJOYSTATE  *LPDIJOYSTATE;

/* DirectInput joystick state (version 2) */
typedef struct DIJOYSTATE2 {
    LONG    lX;
    LONG    lY;
    LONG    lZ;
    LONG    lRx;
    LONG    lRy;
    LONG    lRz;
    LONG    rglSlider[2];
    DWORD   rgdwPOV[4];
    BYTE    rgbButtons[128];
    LONG    lVX;
    LONG    lVY;
    LONG    lVZ;
    LONG    lVRx;
    LONG    lVRy;
    LONG    lVRz;
    LONG    rglVSlider[2];
    LONG    lAX;
    LONG    lAY;
    LONG    lAZ;
    LONG    lARx;
    LONG    lARy;
    LONG    lARz;
    LONG    rglASlider[2];
    LONG    lFX;
    LONG    lFY;
    LONG    lFZ;
    LONG    lFRx;
    LONG    lFRy;
    LONG    lFRz;
    LONG    rglFSlider[2];
} DIJOYSTATE2;
typedef DIJOYSTATE2 *LPDIJOYSTATE2;

/* DirectInput joystick state field offsets */
#define DIJOFS_X            FIELD_OFFSET( DIJOYSTATE, lX )
#define DIJOFS_Y            FIELD_OFFSET( DIJOYSTATE, lY )
#define DIJOFS_Z            FIELD_OFFSET( DIJOYSTATE, lZ )
#define DIJOFS_RX           FIELD_OFFSET( DIJOYSTATE, lRx )
#define DIJOFS_RY           FIELD_OFFSET( DIJOYSTATE, lRy )
#define DIJOFS_RZ           FIELD_OFFSET( DIJOYSTATE, lRz )
#define DIJOFS_SLIDER( x )  (FIELD_OFFSET( DIJOYSTATE, rglSlider ) + (x) * sizeof( LONG ))
#define DIJOFS_POV( x )     (FIELD_OFFSET( DIJOYSTATE, rgdwPOV ) + (x) * sizeof( DWORD ))
#define DIJOFS_BUTTON( x )  (FIELD_OFFSET( DIJOYSTATE, rgbButtons ) + (x))
#define DIJOFS_BUTTON0      DIJOFS_BUTTON( 0 )
#define DIJOFS_BUTTON1      DIJOFS_BUTTON( 1 )
#define DIJOFS_BUTTON2      DIJOFS_BUTTON( 2 )
#define DIJOFS_BUTTON3      DIJOFS_BUTTON( 3 )
#define DIJOFS_BUTTON4      DIJOFS_BUTTON( 4 )
#define DIJOFS_BUTTON5      DIJOFS_BUTTON( 5 )
#define DIJOFS_BUTTON6      DIJOFS_BUTTON( 6 )
#define DIJOFS_BUTTON7      DIJOFS_BUTTON( 7 )
#define DIJOFS_BUTTON8      DIJOFS_BUTTON( 8 )
#define DIJOFS_BUTTON9      DIJOFS_BUTTON( 9 )
#define DIJOFS_BUTTON10     DIJOFS_BUTTON( 10 )
#define DIJOFS_BUTTON11     DIJOFS_BUTTON( 11 )
#define DIJOFS_BUTTON12     DIJOFS_BUTTON( 12 )
#define DIJOFS_BUTTON13     DIJOFS_BUTTON( 13 )
#define DIJOFS_BUTTON14     DIJOFS_BUTTON( 14 )
#define DIJOFS_BUTTON15     DIJOFS_BUTTON( 15 )
#define DIJOFS_BUTTON16     DIJOFS_BUTTON( 16 )
#define DIJOFS_BUTTON17     DIJOFS_BUTTON( 17 )
#define DIJOFS_BUTTON18     DIJOFS_BUTTON( 18 )
#define DIJOFS_BUTTON19     DIJOFS_BUTTON( 19 )
#define DIJOFS_BUTTON20     DIJOFS_BUTTON( 20 )
#define DIJOFS_BUTTON21     DIJOFS_BUTTON( 21 )
#define DIJOFS_BUTTON22     DIJOFS_BUTTON( 22 )
#define DIJOFS_BUTTON23     DIJOFS_BUTTON( 23 )
#define DIJOFS_BUTTON24     DIJOFS_BUTTON( 24 )
#define DIJOFS_BUTTON25     DIJOFS_BUTTON( 25 )
#define DIJOFS_BUTTON26     DIJOFS_BUTTON( 26 )
#define DIJOFS_BUTTON27     DIJOFS_BUTTON( 27 )
#define DIJOFS_BUTTON28     DIJOFS_BUTTON( 28 )
#define DIJOFS_BUTTON29     DIJOFS_BUTTON( 29 )
#define DIJOFS_BUTTON30     DIJOFS_BUTTON( 30 )
#define DIJOFS_BUTTON31     DIJOFS_BUTTON( 31 )

/* DirectInput device callbacks */
typedef BOOL (PASCAL *LPDIENUMDEVICESCALLBACKA)( LPCDIDEVICEINSTANCEA, LPVOID );
typedef BOOL (PASCAL *LPDIENUMDEVICESCALLBACKW)( LPCDIDEVICEINSTANCEW, LPVOID );
typedef BOOL (PASCAL *LPDICONFIGUREDEVICESCALLBACK)( IUnknown *, LPVOID );
typedef BOOL (PASCAL *LPDIENUMDEVICESBYSEMANTICSCBA)( LPCDIDEVICEINSTANCEA, IDirectInputDevice8A *, DWORD, DWORD, LPVOID );
typedef BOOL (PASCAL *LPDIENUMDEVICESBYSEMANTICSCBW)( LPCDIDEVICEINSTANCEW, IDirectInputDevice8W *, DWORD, DWORD, LPVOID );
#ifdef UNICODE
    #define LPDIENUMDEVICESCALLBACK         LPDIENUMDEVICESCALLBACKW
    #define LPDIENUMDEVICESBYSEMANTICSCB    LPDIENUMDEVICESBYSEMANTICSCBW
#else
    #define LPDIENUMDEVICESCALLBACK         LPDIENUMDEVICESCALLBACKA
    #define LPDIENUMDEVICESBYSEMANTICSCB    LPDIENUMDEVICESBYSEMANTICSCBA
#endif

/* IDirectInputEffect interface */
#if (DIRECTINPUT_VERSION >= 0x0500)
#undef INTERFACE
#define INTERFACE   IDirectInputEffect
DECLARE_INTERFACE_( IDirectInputEffect, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputEffect methods */
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;
    STDMETHOD( GetEffectGuid )( THIS_ LPGUID ) PURE;
    STDMETHOD( GetParameters )( THIS_ LPDIEFFECT, DWORD ) PURE;
    STDMETHOD( SetParameters )( THIS_ LPCDIEFFECT, DWORD ) PURE;
    STDMETHOD( Start )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( GetEffectStatus )( THIS_ LPDWORD ) PURE;
    STDMETHOD( Download )( THIS ) PURE;
    STDMETHOD( Unload )( THIS ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
};
typedef IDirectInputEffect  *LPDIRECTINPUTEFFECT;
#endif

/* IDirectInputDevice interface */
#undef INTERFACE
#define INTERFACE   IDirectInputDeviceA
DECLARE_INTERFACE_( IDirectInputDeviceA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceA methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEA, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEA ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;
};
typedef IDirectInputDeviceA         *LPDIRECTINPUTDEVICEA;
#undef INTERFACE
#define INTERFACE   IDirectInputDeviceW
DECLARE_INTERFACE_( IDirectInputDeviceW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceW methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEW, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEW ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;
};
typedef IDirectInputDeviceW         *LPDIRECTINPUTDEVICEW;
#ifdef UNICODE
    #define IDirectInputDevice      IDirectInputDeviceW
    #define IDirectInputDeviceVtbl  IDirectInputDeviceWVtbl
#else
    #define IDirectInputDevice      IDirectInputDeviceA
    #define IDirectInputDeviceVtbl  IDirectInputDeviceAVtbl
#endif
typedef IDirectInputDevice          *LPDIRECTINPUTDEVICE;

/* IDirectInputDevice2 interface */
#if (DIRECTINPUT_VERSION >= 0x0500)
#undef INTERFACE
#define INTERFACE   IDirectInputDevice2A
DECLARE_INTERFACE_( IDirectInputDevice2A, IDirectInputDeviceA ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceA methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEA, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEA ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;

    /* IDirectInputDevice2A methods */
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOA, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
};
typedef IDirectInputDevice2A        *LPDIRECTINPUTDEVICE2A;
#undef INTERFACE
#define INTERFACE   IDirectInputDevice2W
DECLARE_INTERFACE_( IDirectInputDevice2W, IDirectInputDeviceW ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceW methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEW, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEW ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;

    /* IDirectInputDevice2W methods */
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOW, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
};
typedef IDirectInputDevice2W        *LPDIRECTINPUTDEVICE2W;
#ifdef UNICODE
    #define IDirectInputDevice2     IDirectInputDevice2W
    #define IDirectInputDevice2Vtbl IDirectInputDevice2WVtbl
#else
    #define IDirectInputDevice2     IDirectInputDevice2A
    #define IDirectInputDevice2Vtbl IDirectInputDevice2AVtbl
#endif
typedef IDirectInputDevice2         *LPDIRECTINPUTDEVICE2;
#endif

/* IDirectInputDevice7 interface */
#if (DIRECTINPUT_VERSION >= 0x0700)
#undef INTERFACE
#define INTERFACE   IDirectInputDevice7A
DECLARE_INTERFACE_( IDirectInputDevice7A, IDirectInputDevice2A ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceA methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEA, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEA ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;

    /* IDirectInputDevice2A methods */
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOA, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;

    /* IDirectInputDevice7A methods */
    STDMETHOD( EnumEffectsInFile )( THIS_ LPCSTR, LPDIENUMEFFECTSINFILECALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( WriteEffectToFile )( THIS_ LPCSTR, DWORD, LPDIFILEEFFECT, DWORD ) PURE;
};
typedef IDirectInputDevice7A        *LPDIRECTINPUTDEVICE7A;
#undef INTERFACE
#define INTERFACE   IDirectInputDevice7W
DECLARE_INTERFACE_( IDirectInputDevice7W, IDirectInputDevice2W ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDeviceW methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEW, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEW ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;

    /* IDirectInputDevice2W methods */
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOW, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;

    /* IDirectInputDevice7W methods */
    STDMETHOD( EnumEffectsInFile )( THIS_ LPCWSTR, LPDIENUMEFFECTSINFILECALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( WriteEffectToFile )( THIS_ LPCWSTR, DWORD, LPDIFILEEFFECT, DWORD ) PURE;
};
typedef IDirectInputDevice7W        *LPDIRECTINPUTDEVICE7W;
#ifdef UNICODE
    #define IDirectInputDevice7     IDirectInputDevice7W
    #define IDirectInputDevice7Vtbl IDirectInputDevice7WVtbl
#else
    #define IDirectInputDevice7     IDirectInputDevice7A
    #define IDirectInputDevice7Vtbl IDirectInputDevice7AVtbl
#endif
typedef IDirectInputDevice7         *LPDIRECTINPUTDEVICE7;
#endif

/* IDirectInputDevice8 interface */
#if (DIRECTINPUT_VERSION >= 0x0800)
#undef INTERFACE
#define INTERFACE   IDirectInputDevice8A
DECLARE_INTERFACE_( IDirectInputDevice8A, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDevice8A methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEA, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEA ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOA, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( EnumEffectsInFile )( THIS_ LPCSTR, LPDIENUMEFFECTSINFILECALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( WriteEffectToFile )( THIS_ LPCSTR, DWORD, LPDIFILEEFFECT, DWORD ) PURE;
    STDMETHOD( BuildActionMap )( THIS_ LPDIACTIONFORMATA, LPCSTR, DWORD ) PURE;
    STDMETHOD( SetActionMap )( THIS_ LPDIACTIONFORMATA, LPCSTR, DWORD ) PURE;
    STDMETHOD( GetImageInfo )( THIS_ LPDIDEVICEIMAGEINFOHEADERA ) PURE;
};
typedef IDirectInputDevice8A        *LPDIRECTINPUTDEVICE8A;
#undef INTERFACE
#define INTERFACE   IDirectInputDevice8W
DECLARE_INTERFACE_( IDirectInputDevice8W, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputDevice8W methods */
    STDMETHOD( GetCapabilities )( THIS_ LPDIDEVCAPS ) PURE;
    STDMETHOD( EnumObjects )( THIS_ LPDIENUMDEVICEOBJECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetProperty )( THIS_ REFGUID, LPDIPROPHEADER ) PURE;
    STDMETHOD( SetProperty )( THIS_ REFGUID, LPCDIPROPHEADER ) PURE;
    STDMETHOD( Acquire )( THIS ) PURE;
    STDMETHOD( Unacquire )( THIS ) PURE;
    STDMETHOD( GetDeviceState )( THIS_ DWORD, LPVOID ) PURE;
    STDMETHOD( GetDeviceData )( THIS_ DWORD, LPDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( SetDataFormat )( THIS_ LPCDIDATAFORMAT ) PURE;
    STDMETHOD( SetEventNotification )( THIS_ HANDLE ) PURE;
    STDMETHOD( SetCooperativeLevel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( GetObjectInfo )( THIS_ LPDIDEVICEOBJECTINSTANCEW, DWORD, DWORD ) PURE;
    STDMETHOD( GetDeviceInfo )( THIS_ LPDIDEVICEINSTANCEW ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD, REFGUID ) PURE;
    STDMETHOD( CreateEffect )( THIS_ REFGUID, LPCDIEFFECT, LPDIRECTINPUTEFFECT *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumEffects )( THIS_ LPDIENUMEFFECTSCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetEffectInfo )( THIS_ LPDIEFFECTINFOW, REFGUID ) PURE;
    STDMETHOD( GetForceFeedbackState )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SendForceFeedbackCommand )( THIS_ DWORD ) PURE;
    STDMETHOD( EnumCreatedEffectObjects )( THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( Escape )( THIS_ LPDIEFFESCAPE ) PURE;
    STDMETHOD( Poll )( THIS ) PURE;
    STDMETHOD( SendDeviceData )( THIS_ DWORD, LPCDIDEVICEOBJECTDATA, LPDWORD, DWORD ) PURE;
    STDMETHOD( EnumEffectsInFile )( THIS_ LPCWSTR, LPDIENUMEFFECTSINFILECALLBACK, LPVOID, DWORD ) PURE;
    STDMETHOD( WriteEffectToFile )( THIS_ LPCWSTR, DWORD, LPDIFILEEFFECT, DWORD ) PURE;
    STDMETHOD( BuildActionMap )( THIS_ LPDIACTIONFORMATW, LPCWSTR, DWORD ) PURE;
    STDMETHOD( SetActionMap )( THIS_ LPDIACTIONFORMATW, LPCWSTR, DWORD ) PURE;
    STDMETHOD( GetImageInfo )( THIS_ LPDIDEVICEIMAGEINFOHEADERW ) PURE;
};
typedef IDirectInputDevice8W        *LPDIRECTINPUTDEVICE8W;
#ifdef UNICODE
    #define IDirectInputDevice8     IDirectInputDevice8W
    #define IDirectInputDevice8Vtbl IDirectInputDevice8WVtbl
#else
    #define IDirectInputDevice8     IDirectInputDevice8A
    #define IDirectInputDevice8Vtbl IDirectInputDevice8AVtbl
#endif
typedef IDirectInputDevice8         *LPDIRECTINPUTDEVICE8;
#endif

/* IDirectInput interface */
#undef INTERFACE
#define INTERFACE   IDirectInputA
DECLARE_INTERFACE_( IDirectInputA, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputW methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEA *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;
};
typedef IDirectInputA           *LPDIRECTINPUTA;
#undef INTERFACE
#define INTERFACE   IDirectInputW
DECLARE_INTERFACE_( IDirectInputW, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputW methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEW *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;
};
typedef IDirectInputW           *LPDIRECTINPUTW;
#ifdef UNICODE
    #define IDirectInput        IDirectInputW
    #define IDirectInputVtbl    IDirectInputWVtbl
#else
    #define IDirectInput        IDirectInputA
    #define IDirectInputVtbl    IDirectInputAVtbl
#endif

/* IDirectInput2 interface */
#undef INTERFACE
#define INTERFACE   IDirectInput2A
DECLARE_INTERFACE_( IDirectInput2A, IDirectInputA ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputA methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEA *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;

    /* IDirectInput2A methods */
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCSTR, LPGUID ) PURE;
};
typedef IDirectInput2A          *LPDIRECTINPUT2A;
#undef INTERFACE
#define INTERFACE   IDirectInput2W
DECLARE_INTERFACE_( IDirectInput2W, IDirectInputW ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputW methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEW *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;

    /* IDirectInput2W methods */
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCWSTR, LPGUID ) PURE;
};
typedef IDirectInput2W          *LPDIRECTINPUT2W;
#ifdef UNICODE
    #define IDirectInput2       IDirectInput2W
    #define IDirectInput2Vtbl   IDirectInput2WVtbl
#else
    #define IDirectInput2       IDirectInput2A
    #define IDirectInput2Vtbl   IDirectInput2AVtbl
#endif
typedef IDirectInput2           *LPDIRECTINPUT2;

/* IDirectInput7 interface */
#undef INTERFACE
#define INTERFACE   IDirectInput7A
DECLARE_INTERFACE_( IDirectInput7A, IDirectInput2A ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputA methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEA *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;

    /* IDirectInput2A methods */
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCSTR, LPGUID ) PURE;

    /* IDirectInput7A methods */
    STDMETHOD( CreateDeviceEx )( THIS_ REFGUID, REFIID, LPVOID *, LPUNKNOWN ) PURE;
};
typedef IDirectInput7A          *LPDIRECTINPUT7A;
#undef INTERFACE
#define INTERFACE   IDirectInput7W
DECLARE_INTERFACE_( IDirectInput7W, IDirectInput2W ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInputW methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICEW *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;

    /* IDirectInput2W methods */
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCWSTR, LPGUID ) PURE;

    /* IDirectInput7W methods */
    STDMETHOD( CreateDeviceEx )( THIS_ REFGUID, REFIID, LPVOID *, LPUNKNOWN ) PURE;
};
typedef IDirectInput7W          *LPDIRECTINPUT7W;
#ifdef UNICODE
    #define IDirectInput7       IDirectInput7W
    #define IDirectInput7Vtbl   IDirectInput7WVtbl
#else
    #define IDirectInput7       IDirectInput7A
    #define IDirectInput7Vtbl   IDirectInput7AVtbl
#endif
typedef IDirectInput7           *LPDIRECTINPUT7;

/* IDirectInput8 interface */
#if (DIRECTINPUT_VERSION >= 0x0800)
#undef INTERFACE
#define INTERFACE   IDirectInput8A
DECLARE_INTERFACE_( IDirectInput8A, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInput8A methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICE8A *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKA, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCSTR, LPGUID ) PURE;
    STDMETHOD( EnumDevicesBySemantics )( THIS_ LPCSTR, LPDIACTIONFORMATA, LPDIENUMDEVICESBYSEMANTICSCBA, LPVOID, DWORD ) PURE;
    STDMETHOD( ConfigureDevices )( THIS_ LPDICONFIGUREDEVICESCALLBACK, LPDICONFIGUREDEVICESPARAMSA, DWORD, LPVOID ) PURE;
};
typedef IDirectInput8A          *LPDIRECTINPUT8A;
#undef INTERFACE
#define INTERFACE   IDirectInput8W
DECLARE_INTERFACE_( IDirectInput8W, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDirectInput8W methods */
    STDMETHOD( CreateDevice )( THIS_ REFGUID, LPDIRECTINPUTDEVICE8W *, LPUNKNOWN ) PURE;
    STDMETHOD( EnumDevices )( THIS_ DWORD, LPDIENUMDEVICESCALLBACKW, LPVOID, DWORD ) PURE;
    STDMETHOD( GetDeviceStatus )( THIS_ REFGUID ) PURE;
    STDMETHOD( RunControlPanel )( THIS_ HWND, DWORD ) PURE;
    STDMETHOD( Initialize )( THIS_ HINSTANCE, DWORD ) PURE;
    STDMETHOD( FindDevice )( THIS_ REFGUID, LPCWSTR, LPGUID ) PURE;
    STDMETHOD( EnumDevicesBySemantics )( THIS_ LPCWSTR, LPDIACTIONFORMATW, LPDIENUMDEVICESBYSEMANTICSCBW, LPVOID, DWORD ) PURE;
    STDMETHOD( ConfigureDevices )( THIS_ LPDICONFIGUREDEVICESCALLBACK, LPDICONFIGUREDEVICESPARAMSW, DWORD, LPVOID ) PURE;
};
typedef IDirectInput8W          *LPDIRECTINPUT8W;
#ifdef UNICODE
    #define IDirectInput8       IDirectInput8W
    #define IDirectInput8Vtbl   IDirectInput8WVtbl
#else
    #define IDirectInput8       IDirectInput8A
    #define IDirectInput8Vtbl   IDirectInput8AVtbl
#endif
typedef IDirectInput8           *LPDIRECTINPUT8;
#endif

/* C/C++ object macros */
#if !defined( __cplusplus ) || defined( CINTERFACE )
    #if (DIRECTINPUT_VERSION >= 0x0500)
        #define IDirectInputEffect_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IDirectInputEffect_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IDirectInputEffect_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IDirectInputEffect_Initialize( x, p1, p2, p3 ) \
            (x)->lpVtbl->Initialize( x, p1, p2, p3 )
        #define IDirectInputEffect_GetEffectGuid( x, p ) \
            (x)->lpVtbl->GetEffectGuid( x, p )
        #define IDirectInputEffect_GetParameters( x, p1, p2 ) \
            (x)->lpVtbl->GetParameters( x, p1, p2 )
        #define IDirectInputEffect_SetParameters( x, p1, p2 ) \
            (x)->lpVtbl->SetParameters( x, p1, p2 )
        #define IDirectInputEffect_Start( x, p1, p2 ) \
            (x)->lpVtbl->Start( x, p1, p2 )
        #define IDirectInputEffect_Stop( x ) \
            (x)->lpVtbl->Stop( x )
        #define IDirectInputEffect_GetEffectStatus( x, p ) \
            (x)->lpVtbl->GetEffectStatus( x, p )
        #define IDirectInputEffect_Download( x ) \
            (x)->lpVtbl->Download( x )
        #define IDirectInputEffect_Unload( x ) \
            (x)->lpVtbl->Unload( x )
        #define IDirectInputEffect_Escape( x, p ) \
            (x)->lpVtbl->Escape( x, p )
    #endif
    #define IDirectInputDevice_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectInputDevice_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectInputDevice_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectInputDevice_GetCapabilities( x, p ) \
        (x)->lpVtbl->GetCapabilities( x, p )
    #define IDirectInputDevice_EnumObjects( x, p1, p2, p3 ) \
        (x)->lpVtbl->EnumObjects( x, p1, p2, p3 )
    #define IDirectInputDevice_GetProperty( x, p1, p2 ) \
        (x)->lpVtbl->GetProperty( x, p1, p2 )
    #define IDirectInputDevice_SetProperty( x, p1, p2 ) \
        (x)->lpVtbl->SetProperty( x, p1, p2 )
    #define IDirectInputDevice_Acquire( x ) \
        (x)->lpVtbl->Acquire( x )
    #define IDirectInputDevice_Unacquire( x ) \
        (x)->lpVtbl->Unacquire( x )
    #define IDirectInputDevice_GetDeviceState( x, p1, p2 ) \
        (x)->lpVtbl->GetDeviceState( x, p1, p2 )
    #define IDirectInputDevice_GetDeviceData( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDeviceData( x, p1, p2, p3, p4 )
    #define IDirectInputDevice_SetDataFormat( x, p ) \
        (x)->lpVtbl->SetDataFormat( x, p )
    #define IDirectInputDevice_SetEventNotification( x, p ) \
        (x)->lpVtbl->SetEventNotification( x, p )
    #define IDirectInputDevice_SetCooperativeLevel( x, p1, p2 ) \
        (x)->lpVtbl->SetCooperativeLevel( x, p1, p2 )
    #define IDirectInputDevice_GetObjectInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetObjectInfo( x, p1, p2, p3 )
    #define IDirectInputDevice_GetDeviceInfo( x, p ) \
        (x)->lpVtbl->GetDeviceInfo( x, p )
    #define IDirectInputDevice_RunControlPanel( x, p1, p2 ) \
        (x)->lpVtbl->RunControlPanel( x, p1, p2 )
    #define IDirectInputDevice_Initialize( x, p1, p2, p3 ) \
        (x)->lpVtbl->Initialize( x, p1, p2, p3 )
    #if (DIRECTINPUT_VERSION >= 0x0500)
        #define IDirectInputDevice2_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IDirectInputDevice2_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IDirectInputDevice2_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IDirectInputDevice2_GetCapabilities( x, p ) \
            (x)->lpVtbl->GetCapabilities( x, p )
        #define IDirectInputDevice2_EnumObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumObjects( x, p1, p2, p3 )
        #define IDirectInputDevice2_GetProperty( x, p1, p2 ) \
            (x)->lpVtbl->GetProperty( x, p1, p2 )
        #define IDirectInputDevice2_SetProperty( x, p1, p2 ) \
            (x)->lpVtbl->SetProperty( x, p1, p2 )
        #define IDirectInputDevice2_Acquire( x ) \
            (x)->lpVtbl->Acquire( x )
        #define IDirectInputDevice2_Unacquire( x ) \
            (x)->lpVtbl->Unacquire( x )
        #define IDirectInputDevice2_GetDeviceState( x, p1, p2 ) \
            (x)->lpVtbl->GetDeviceState( x, p1, p2 )
        #define IDirectInputDevice2_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetDeviceData( x, p1, p2, p3, p4 )
        #define IDirectInputDevice2_SetDataFormat( x, p ) \
            (x)->lpVtbl->SetDataFormat( x, p )
        #define IDirectInputDevice2_SetEventNotification( x, p ) \
            (x)->lpVtbl->SetEventNotification( x, p )
        #define IDirectInputDevice2_SetCooperativeLevel( x, p1, p2 ) \
            (x)->lpVtbl->SetCooperativeLevel( x, p1, p2 )
        #define IDirectInputDevice2_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetObjectInfo( x, p1, p2, p3 )
        #define IDirectInputDevice2_GetDeviceInfo( x, p ) \
            (x)->lpVtbl->GetDeviceInfo( x, p )
        #define IDirectInputDevice2_RunControlPanel( x, p1, p2 ) \
            (x)->lpVtbl->RunControlPanel( x, p1, p2 )
        #define IDirectInputDevice2_Initialize( x, p1, p2, p3 ) \
            (x)->lpVtbl->Initialize( x, p1, p2, p3 )
        #define IDirectInputDevice2_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->CreateEffect( x, p1, p2, p3, p4 )
        #define IDirectInputDevice2_EnumEffects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumEffects( x, p1, p2, p3 )
        #define IDirectInputDevice2_GetEffectInfo( x, p1, p2 ) \
            (x)->lpVtbl->GetEffectInfo( x, p1, p2 )
        #define IDirectInputDevice2_GetForceFeedbackState( x, p ) \
            (x)->lpVtbl->GetForceFeedbackState( x, p )
        #define IDirectInputDevice2_SendForceFeedbackCommand( x, p ) \
            (x)->lpVtbl->SendForceFeedbackCommand( x, p )
        #define IDirectInputDevice2_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumCreatedEffectObjects( x, p1, p2, p3 )
        #define IDirectInputDevice2_Escape( x, p ) \
            (x)->lpVtbl->Escape( x, p )
        #define IDirectInputDevice2_Poll( x ) \
            (x)->lpVtbl->Poll( x )
        #define IDirectInputDevice2_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->SendDeviceData( x, p1, p2, p3, p4 )
    #endif
    #if (DIRECTINPUT_VERSION >= 0x0700)
        #define IDirectInputDevice7_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IDirectInputDevice7_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IDirectInputDevice7_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IDirectInputDevice7_GetCapabilities( x, p ) \
            (x)->lpVtbl->GetCapabilities( x, p )
        #define IDirectInputDevice7_EnumObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumObjects( x, p1, p2, p3 )
        #define IDirectInputDevice7_GetProperty( x, p1, p2 ) \
            (x)->lpVtbl->GetProperty( x, p1, p2 )
        #define IDirectInputDevice7_SetProperty( x, p1, p2 ) \
            (x)->lpVtbl->SetProperty( x, p1, p2 )
        #define IDirectInputDevice7_Acquire( x ) \
            (x)->lpVtbl->Acquire( x )
        #define IDirectInputDevice7_Unacquire( x ) \
            (x)->lpVtbl->Unacquire( x )
        #define IDirectInputDevice7_GetDeviceState( x, p1, p2 ) \
            (x)->lpVtbl->GetDeviceState( x, p1, p2 )
        #define IDirectInputDevice7_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetDeviceData( x, p1, p2, p3, p4 )
        #define IDirectInputDevice7_SetDataFormat( x, p ) \
            (x)->lpVtbl->SetDataFormat( x, p )
        #define IDirectInputDevice7_SetEventNotification( x, p ) \
            (x)->lpVtbl->SetEventNotification( x, p )
        #define IDirectInputDevice7_SetCooperativeLevel( x, p1, p2 ) \
            (x)->lpVtbl->SetCooperativeLevel( x, p1, p2 )
        #define IDirectInputDevice7_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetObjectInfo( x, p1, p2, p3 )
        #define IDirectInputDevice7_GetDeviceInfo( x, p ) \
            (x)->lpVtbl->GetDeviceInfo( x, p )
        #define IDirectInputDevice7_RunControlPanel( x, p1, p2 ) \
            (x)->lpVtbl->RunControlPanel( x, p1, p2 )
        #define IDirectInputDevice7_Initialize( x, p1, p2, p3 ) \
            (x)->lpVtbl->Initialize( x, p1, p2, p3 )
        #define IDirectInputDevice7_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->CreateEffect( x, p1, p2, p3, p4 )
        #define IDirectInputDevice7_EnumEffects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumEffects( x, p1, p2, p3 )
        #define IDirectInputDevice7_GetEffectInfo( x, p1, p2 ) \
            (x)->lpVtbl->GetEffectInfo( x, p1, p2 )
        #define IDirectInputDevice7_GetForceFeedbackState( x, p ) \
            (x)->lpVtbl->GetForceFeedbackState( x, p )
        #define IDirectInputDevice7_SendForceFeedbackCommand( x, p ) \
            (x)->lpVtbl->SendForceFeedbackCommand( x, p )
        #define IDirectInputDevice7_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumCreatedEffectObjects( x, p1, p2, p3 )
        #define IDirectInputDevice7_Escape( x, p ) \
            (x)->lpVtbl->Escape( x, p )
        #define IDirectInputDevice7_Poll( x ) \
            (x)->lpVtbl->Poll( x )
        #define IDirectInputDevice7_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->SendDeviceData( x, p1, p2, p3, p4 )
        #define IDirectInputDevice7_EnumEffectsInFile( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->EnumEffectsInFile( x, p1, p2, p3, p4 )
        #define IDirectInputDevice7_WriteEffectToFile( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->WriteEffectToFile( x, p1, p2, p3, p4 )
    #endif
    #if (DIRECTINPUT_VERSION >= 0x0800)
        #define IDirectInputDevice8_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IDirectInputDevice8_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IDirectInputDevice8_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IDirectInputDevice8_GetCapabilities( x, p ) \
            (x)->lpVtbl->GetCapabilities( x, p )
        #define IDirectInputDevice8_EnumObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumObjects( x, p1, p2, p3 )
        #define IDirectInputDevice8_GetProperty( x, p1, p2 ) \
            (x)->lpVtbl->GetProperty( x, p1, p2 )
        #define IDirectInputDevice8_SetProperty( x, p1, p2 ) \
            (x)->lpVtbl->SetProperty( x, p1, p2 )
        #define IDirectInputDevice8_Acquire( x ) \
            (x)->lpVtbl->Acquire( x )
        #define IDirectInputDevice8_Unacquire( x ) \
            (x)->lpVtbl->Unacquire( x )
        #define IDirectInputDevice8_GetDeviceState( x, p1, p2 ) \
            (x)->lpVtbl->GetDeviceState( x, p1, p2 )
        #define IDirectInputDevice8_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->GetDeviceData( x, p1, p2, p3, p4 )
        #define IDirectInputDevice8_SetDataFormat( x, p ) \
            (x)->lpVtbl->SetDataFormat( x, p )
        #define IDirectInputDevice8_SetEventNotification( x, p ) \
            (x)->lpVtbl->SetEventNotification( x, p )
        #define IDirectInputDevice8_SetCooperativeLevel( x, p1, p2 ) \
            (x)->lpVtbl->SetCooperativeLevel( x, p1, p2 )
        #define IDirectInputDevice8_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->lpVtbl->GetObjectInfo( x, p1, p2, p3 )
        #define IDirectInputDevice8_GetDeviceInfo( x, p ) \
            (x)->lpVtbl->GetDeviceInfo( x, p )
        #define IDirectInputDevice8_RunControlPanel( x, p1, p2 ) \
            (x)->lpVtbl->RunControlPanel( x, p1, p2 )
        #define IDirectInputDevice8_Initialize( x, p1, p2, p3 ) \
            (x)->lpVtbl->Initialize( x, p1, p2, p3 )
        #define IDirectInputDevice8_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->CreateEffect( x, p1, p2, p3, p4 )
        #define IDirectInputDevice8_EnumEffects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumEffects( x, p1, p2, p3 )
        #define IDirectInputDevice8_GetEffectInfo( x, p1, p2 ) \
            (x)->lpVtbl->GetEffectInfo( x, p1, p2 )
        #define IDirectInputDevice8_GetForceFeedbackState( x, p ) \
            (x)->lpVtbl->GetForceFeedbackState( x, p )
        #define IDirectInputDevice8_SendForceFeedbackCommand( x, p ) \
            (x)->lpVtbl->SendForceFeedbackCommand( x, p )
        #define IDirectInputDevice8_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->lpVtbl->EnumCreatedEffectObjects( x, p1, p2, p3 )
        #define IDirectInputDevice8_Escape( x, p ) \
            (x)->lpVtbl->Escape( x, p )
        #define IDirectInputDevice8_Poll( x ) \
            (x)->lpVtbl->Poll( x )
        #define IDirectInputDevice8_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->SendDeviceData( x, p1, p2, p3, p4 )
        #define IDirectInputDevice8_EnumEffectsInFile( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->EnumEffectsInFile( x, p1, p2, p3, p4 )
        #define IDirectInputDevice8_WriteEffectToFile( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->WriteEffectToFile( x, p1, p2, p3, p4 )
        #define IDirectInputDevice8_BuildActionMap( x, p1, p2, p3 ) \
            (x)->lpVtbl->BuildActionMap( x, p1, p2, p3 )
        #define IDirectInputDevice8_SetActionMap( x, p1, p2, p3 ) \
            (x)->lpVtbl->SetActionMap( x, p1, p2, p3 )
        #define IDirectInputDevice8_GetImageInfo( x, p ) \
            (x)->lpVtbl->GetImageInfo( x, p )
    #endif
    #define IDirectInput_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectInput_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectInput_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectInput_CreateDevice( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateDevice( x, p1, p2, p3 )
    #define IDirectInput_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumDevices( x, p1, p2, p3, p4 )
    #define IDirectInput_GetDeviceStatus( x, p ) \
        (x)->lpVtbl->GetDeviceStatus( x, p )
    #define IDirectInput_RunControlPanel( x, p1, p2 ) \
        (x)->lpVtbl->RunControlPanel( x, p1, p2 )
    #define IDirectInput_Initialize( x, p1, p2 ) \
        (x)->lpVtbl->Initialize( x, p1, p2 )
    #define IDirectInput2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectInput2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectInput2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectInput2_CreateDevice( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateDevice( x, p1, p2, p3 )
    #define IDirectInput2_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumDevices( x, p1, p2, p3, p4 )
    #define IDirectInput2_GetDeviceStatus( x, p ) \
        (x)->lpVtbl->GetDeviceStatus( x, p )
    #define IDirectInput2_RunControlPanel( x, p1, p2 ) \
        (x)->lpVtbl->RunControlPanel( x, p1, p2 )
    #define IDirectInput2_Initialize( x, p1, p2 ) \
        (x)->lpVtbl->Initialize( x, p1, p2 )
    #define IDirectInput2_FindDevice( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindDevice( x, p1, p2, p3 )
    #define IDirectInput7_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDirectInput7_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDirectInput7_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDirectInput7_CreateDevice( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateDevice( x, p1, p2, p3 )
    #define IDirectInput7_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->EnumDevices( x, p1, p2, p3, p4 )
    #define IDirectInput7_GetDeviceStatus( x, p ) \
        (x)->lpVtbl->GetDeviceStatus( x, p )
    #define IDirectInput7_RunControlPanel( x, p1, p2 ) \
        (x)->lpVtbl->RunControlPanel( x, p1, p2 )
    #define IDirectInput7_Initialize( x, p1, p2 ) \
        (x)->lpVtbl->Initialize( x, p1, p2 )
    #define IDirectInput7_FindDevice( x, p1, p2, p3 ) \
        (x)->lpVtbl->FindDevice( x, p1, p2, p3 )
    #define IDirectInput7_CreateDeviceEx( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CreateDeviceEx( x, p1, p2, p3, p4 )
    #if (DIRECTINPUT_VERSION >= 0x0800)
        #define IDirectInput8_QueryInterface( x, p1, p2 ) \
            (x)->lpVtbl->QueryInterface( x, p1, p2 )
        #define IDirectInput8_AddRef( x ) \
            (x)->lpVtbl->AddRef( x )
        #define IDirectInput8_Release( x ) \
            (x)->lpVtbl->Release( x )
        #define IDirectInput8_CreateDevice( x, p1, p2, p3 ) \
            (x)->lpVtbl->CreateDevice( x, p1, p2, p3 )
        #define IDirectInput8_EnumDevices( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->EnumDevices( x, p1, p2, p3, p4 )
        #define IDirectInput8_GetDeviceStatus( x, p ) \
            (x)->lpVtbl->GetDeviceStatus( x, p )
        #define IDirectInput8_RunControlPanel( x, p1, p2 ) \
            (x)->lpVtbl->RunControlPanel( x, p1, p2 )
        #define IDirectInput8_Initialize( x, p1, p2 ) \
            (x)->lpVtbl->Initialize( x, p1, p2 )
        #define IDirectInput8_FindDevice( x, p1, p2, p3 ) \
            (x)->lpVtbl->FindDevice( x, p1, p2, p3 )
        #define IDirectInput8_EnumDevicesBySemantics( x, p1, p2, p3, p4, p5 ) \
            (x)->lpVtbl->EnumDevicesBySemantics( x, p1, p2, p3, p4, p5 )
        #define IDirectInput8_ConfigureDevices( x, p1, p2, p3, p4 ) \
            (x)->lpVtbl->ConfigureDevices( x, p1, p2, p3, p4 )
    #endif
#else
    #if (DIRECTINPUT_VERSION >= 0x0500)
        #define IDirectInputEffect_QueryInterface( x, p1, p2 ) \
            (x)->QueryInterface( p1, p2 )
        #define IDirectInputEffect_AddRef( x ) \
            (x)->AddRef()
        #define IDirectInputEffect_Release( x ) \
            (x)->Release()
        #define IDirectInputEffect_Initialize( x, p1, p2, p3 ) \
            (x)->Initialize( p1, p2, p3 )
        #define IDirectInputEffect_GetEffectGuid( x, p ) \
            (x)->GetEffectGuid( p )
        #define IDirectInputEffect_GetParameters( x, p1, p2 ) \
            (x)->GetParameters( p1, p2 )
        #define IDirectInputEffect_SetParameters( x, p1, p2 ) \
            (x)->SetParameters( p1, p2 )
        #define IDirectInputEffect_Start( x, p1, p2 ) \
            (x)->Start( p1, p2 )
        #define IDirectInputEffect_Stop( x ) \
            (x)->Stop()
        #define IDirectInputEffect_GetEffectStatus( x, p ) \
            (x)->GetEffectStatus( p )
        #define IDirectInputEffect_Download( x ) \
            (x)->Download()
        #define IDirectInputEffect_Unload( x ) \
            (x)->Unload()
        #define IDirectInputEffect_Escape( x, p ) \
            (x)->Escape( p )
    #endif
    #define IDirectInputDevice_QueryInterface( x, p1, p2 ) \
        (x)->QueryInterface( p1, p2 )
    #define IDirectInputDevice_AddRef( x ) \
        (x)->AddRef()
    #define IDirectInputDevice_Release( x ) \
        (x)->Release()
    #define IDirectInputDevice_GetCapabilities( x, p ) \
        (x)->GetCapabilities( p )
    #define IDirectInputDevice_EnumObjects( x, p1, p2, p3 ) \
        (x)->EnumObjects( p1, p2, p3 )
    #define IDirectInputDevice_GetProperty( x, p1, p2 ) \
        (x)->GetProperty( p1, p2 )
    #define IDirectInputDevice_SetProperty( x, p1, p2 ) \
        (x)->SetProperty( p1, p2 )
    #define IDirectInputDevice_Acquire( x ) \
        (x)->Acquire()
    #define IDirectInputDevice_Unacquire( x ) \
        (x)->Unacquire()
    #define IDirectInputDevice_GetDeviceState( x, p1, p2 ) \
        (x)->GetDeviceState( p1, p2 )
    #define IDirectInputDevice_GetDeviceData( x, p1, p2, p3, p4 ) \
        (x)->GetDeviceData( p1, p2, p3, p4 )
    #define IDirectInputDevice_SetDataFormat( x, p ) \
        (x)->SetDataFormat( p )
    #define IDirectInputDevice_SetEventNotification( x, p ) \
        (x)->SetEventNotification( p )
    #define IDirectInputDevice_SetCooperativeLevel( x, p1, p2 ) \
        (x)->SetCooperativeLevel( p1, p2 )
    #define IDirectInputDevice_GetObjectInfo( x, p1, p2, p3 ) \
        (x)->GetObjectInfo( p1, p2, p3 )
    #define IDirectInputDevice_GetDeviceInfo( x, p ) \
        (x)->GetDeviceInfo( p )
    #define IDirectInputDevice_RunControlPanel( x, p1, p2 ) \
        (x)->RunControlPanel( p1, p2 )
    #define IDirectInputDevice_Initialize( x, p1, p2, p3 ) \
        (x)->Initialize( p1, p2, p3 )
    #if (DIRECTINPUT_VERSION >= 0x0500)
        #define IDirectInputDevice2_QueryInterface( x, p1, p2 ) \
            (x)->QueryInterface( p1, p2 )
        #define IDirectInputDevice2_AddRef( x ) \
            (x)->AddRef()
        #define IDirectInputDevice2_Release( x ) \
            (x)->Release()
        #define IDirectInputDevice2_GetCapabilities( x, p ) \
            (x)->GetCapabilities( p )
        #define IDirectInputDevice2_EnumObjects( x, p1, p2, p3 ) \
            (x)->EnumObjects( p1, p2, p3 )
        #define IDirectInputDevice2_GetProperty( x, p1, p2 ) \
            (x)->GetProperty( p1, p2 )
        #define IDirectInputDevice2_SetProperty( x, p1, p2 ) \
            (x)->SetProperty( p1, p2 )
        #define IDirectInputDevice2_Acquire( x ) \
            (x)->Acquire()
        #define IDirectInputDevice2_Unacquire( x ) \
            (x)->Unacquire()
        #define IDirectInputDevice2_GetDeviceState( x, p1, p2 ) \
            (x)->GetDeviceState( p1, p2 )
        #define IDirectInputDevice2_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->GetDeviceData( p1, p2, p3, p4 )
        #define IDirectInputDevice2_SetDataFormat( x, p ) \
            (x)->SetDataFormat( p )
        #define IDirectInputDevice2_SetEventNotification( x, p ) \
            (x)->SetEventNotification( p )
        #define IDirectInputDevice2_SetCooperativeLevel( x, p1, p2 ) \
            (x)->SetCooperativeLevel( p1, p2 )
        #define IDirectInputDevice2_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->GetObjectInfo( p1, p2, p3 )
        #define IDirectInputDevice2_GetDeviceInfo( x, p ) \
            (x)->GetDeviceInfo( p )
        #define IDirectInputDevice2_RunControlPanel( x, p1, p2 ) \
            (x)->RunControlPanel( p1, p2 )
        #define IDirectInputDevice2_Initialize( x, p1, p2, p3 ) \
            (x)->Initialize( p1, p2, p3 )
        #define IDirectInputDevice2_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->CreateEffect( p1, p2, p3, p4 )
        #define IDirectInputDevice2_EnumEffects( x, p1, p2, p3 ) \
            (x)->EnumEffects( p1, p2, p3 )
        #define IDirectInputDevice2_GetEffectInfo( x, p1, p2 ) \
            (x)->GetEffectInfo( p1, p2 )
        #define IDirectInputDevice2_GetForceFeedbackState( x, p ) \
            (x)->GetForceFeedbackState( p )
        #define IDirectInputDevice2_SendForceFeedbackCommand( x, p ) \
            (x)->SendForceFeedbackCommand( p )
        #define IDirectInputDevice2_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->EnumCreatedEffectObjects( p1, p2, p3 )
        #define IDirectInputDevice2_Escape( x, p ) \
            (x)->Escape( p )
        #define IDirectInputDevice2_Poll( x ) \
            (x)->Poll()
        #define IDirectInputDevice2_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->SendDeviceData( p1, p2, p3, p4 )
    #endif
    #if (DIRECTINPUT_VERSION >= 0x0500)
        #define IDirectInputDevice7_QueryInterface( x, p1, p2 ) \
            (x)->QueryInterface( p1, p2 )
        #define IDirectInputDevice7_AddRef( x ) \
            (x)->AddRef()
        #define IDirectInputDevice7_Release( x ) \
            (x)->Release()
        #define IDirectInputDevice7_GetCapabilities( x, p ) \
            (x)->GetCapabilities( p )
        #define IDirectInputDevice7_EnumObjects( x, p1, p2, p3 ) \
            (x)->EnumObjects( p1, p2, p3 )
        #define IDirectInputDevice7_GetProperty( x, p1, p2 ) \
            (x)->GetProperty( p1, p2 )
        #define IDirectInputDevice7_SetProperty( x, p1, p2 ) \
            (x)->SetProperty( p1, p2 )
        #define IDirectInputDevice7_Acquire( x ) \
            (x)->Acquire()
        #define IDirectInputDevice7_Unacquire( x ) \
            (x)->Unacquire()
        #define IDirectInputDevice7_GetDeviceState( x, p1, p2 ) \
            (x)->GetDeviceState( p1, p2 )
        #define IDirectInputDevice7_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->GetDeviceData( p1, p2, p3, p4 )
        #define IDirectInputDevice7_SetDataFormat( x, p ) \
            (x)->SetDataFormat( p )
        #define IDirectInputDevice7_SetEventNotification( x, p ) \
            (x)->SetEventNotification( p )
        #define IDirectInputDevice7_SetCooperativeLevel( x, p1, p2 ) \
            (x)->SetCooperativeLevel( p1, p2 )
        #define IDirectInputDevice7_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->GetObjectInfo( p1, p2, p3 )
        #define IDirectInputDevice7_GetDeviceInfo( x, p ) \
            (x)->GetDeviceInfo( p )
        #define IDirectInputDevice7_RunControlPanel( x, p1, p2 ) \
            (x)->RunControlPanel( p1, p2 )
        #define IDirectInputDevice7_Initialize( x, p1, p2, p3 ) \
            (x)->Initialize( p1, p2, p3 )
        #define IDirectInputDevice7_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->CreateEffect( p1, p2, p3, p4 )
        #define IDirectInputDevice7_EnumEffects( x, p1, p2, p3 ) \
            (x)->EnumEffects( p1, p2, p3 )
        #define IDirectInputDevice7_GetEffectInfo( x, p1, p2 ) \
            (x)->GetEffectInfo( p1, p2 )
        #define IDirectInputDevice7_GetForceFeedbackState( x, p ) \
            (x)->GetForceFeedbackState( p )
        #define IDirectInputDevice7_SendForceFeedbackCommand( x, p ) \
            (x)->SendForceFeedbackCommand( p )
        #define IDirectInputDevice7_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->EnumCreatedEffectObjects( p1, p2, p3 )
        #define IDirectInputDevice7_Escape( x, p ) \
            (x)->Escape( p )
        #define IDirectInputDevice7_Poll( x ) \
            (x)->Poll()
        #define IDirectInputDevice7_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->SendDeviceData( p1, p2, p3, p4 )
        #define IDirectInputDevice7_EnumEffectsInFile( x, p1, p2, p3, p4 ) \
            (x)->EnumEffectsInFile( p1, p2, p3, p4 )
        #define IDirectInputDevice7_WriteEffectToFile( x, p1, p2, p3, p4 ) \
            (x)->WriteEffectToFile( p1, p2, p3, p4 )
    #endif
    #if (DIRECTINPUT_VERSION >= 0x0800)
        #define IDirectInputDevice8_QueryInterface( x, p1, p2 ) \
            (x)->QueryInterface( p1, p2 )
        #define IDirectInputDevice8_AddRef( x ) \
            (x)->AddRef()
        #define IDirectInputDevice8_Release( x ) \
            (x)->Release()
        #define IDirectInputDevice8_GetCapabilities( x, p ) \
            (x)->GetCapabilities( p )
        #define IDirectInputDevice8_EnumObjects( x, p1, p2, p3 ) \
            (x)->EnumObjects( p1, p2, p3 )
        #define IDirectInputDevice8_GetProperty( x, p1, p2 ) \
            (x)->GetProperty( p1, p2 )
        #define IDirectInputDevice8_SetProperty( x, p1, p2 ) \
            (x)->SetProperty( p1, p2 )
        #define IDirectInputDevice8_Acquire( x ) \
            (x)->Acquire()
        #define IDirectInputDevice8_Unacquire( x ) \
            (x)->Unacquire()
        #define IDirectInputDevice8_GetDeviceState( x, p1, p2 ) \
            (x)->GetDeviceState( p1, p2 )
        #define IDirectInputDevice8_GetDeviceData( x, p1, p2, p3, p4 ) \
            (x)->GetDeviceData( p1, p2, p3, p4 )
        #define IDirectInputDevice8_SetDataFormat( x, p ) \
            (x)->SetDataFormat( p )
        #define IDirectInputDevice8_SetEventNotification( x, p ) \
            (x)->SetEventNotification( p )
        #define IDirectInputDevice8_SetCooperativeLevel( x, p1, p2 ) \
            (x)->SetCooperativeLevel( p1, p2 )
        #define IDirectInputDevice8_GetObjectInfo( x, p1, p2, p3 ) \
            (x)->GetObjectInfo( p1, p2, p3 )
        #define IDirectInputDevice8_GetDeviceInfo( x, p ) \
            (x)->GetDeviceInfo( p )
        #define IDirectInputDevice8_RunControlPanel( x, p1, p2 ) \
            (x)->RunControlPanel( p1, p2 )
        #define IDirectInputDevice8_Initialize( x, p1, p2, p3 ) \
            (x)->Initialize( p1, p2, p3 )
        #define IDirectInputDevice8_CreateEffect( x, p1, p2, p3, p4 ) \
            (x)->CreateEffect( p1, p2, p3, p4 )
        #define IDirectInputDevice8_EnumEffects( x, p1, p2, p3 ) \
            (x)->EnumEffects( p1, p2, p3 )
        #define IDirectInputDevice8_GetEffectInfo( x, p1, p2 ) \
            (x)->GetEffectInfo( p1, p2 )
        #define IDirectInputDevice8_GetForceFeedbackState( x, p ) \
            (x)->GetForceFeedbackState( p )
        #define IDirectInputDevice8_SendForceFeedbackCommand( x, p ) \
            (x)->SendForceFeedbackCommand( p )
        #define IDirectInputDevice8_EnumCreatedEffectObjects( x, p1, p2, p3 ) \
            (x)->EnumCreatedEffectObjects( p1, p2, p3 )
        #define IDirectInputDevice8_Escape( x, p ) \
            (x)->Escape( p )
        #define IDirectInputDevice8_Poll( x ) \
            (x)->Poll()
        #define IDirectInputDevice8_SendDeviceData( x, p1, p2, p3, p4 ) \
            (x)->SendDeviceData( p1, p2, p3, p4 )
        #define IDirectInputDevice8_EnumEffectsInFile( x, p1, p2, p3, p4 ) \
            (x)->EnumEffectsInFile( p1, p2, p3, p4 )
        #define IDirectInputDevice8_WriteEffectToFile( x, p1, p2, p3, p4 ) \
            (x)->WriteEffectToFile( p1, p2, p3, p4 )
        #define IDirectInputDevice8_BuildActionMap( x, p1, p2, p3 ) \
            (x)->BuildActionMap( p1, p2, p3 )
        #define IDirectInputDevice8_SetActionMap( x, p1, p2, p3 ) \
            (x)->SetActionMap( p1, p2, p3 )
        #define IDirectInputDevice8_GetImageInfo( x, p ) \
            (x)->GetImageInfo( p )
    #endif
    #define IDirectInput_QueryInterface( x, p1, p2 ) \
        (x)->QueryInterface( p1, p2 )
    #define IDirectInput_AddRef( x ) \
        (x)->AddRef()
    #define IDirectInput_Release( x ) \
        (x)->Release()
    #define IDirectInput_CreateDevice( x, p1, p2, p3 ) \
        (x)->CreateDevice( p1, p2, p3 )
    #define IDirectInput_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->EnumDevices( p1, p2, p3, p4 )
    #define IDirectInput_GetDeviceStatus( x, p ) \
        (x)->GetDeviceStatus( p )
    #define IDirectInput_RunControlPanel( x, p1, p2 ) \
        (x)->RunControlPanel( p1, p2 )
    #define IDirectInput_Initialize( x, p1, p2 ) \
        (x)->Initialize( p1, p2 )
    #define IDirectInput2_QueryInterface( x, p1, p2 ) \
        (x)->QueryInterface( p1, p2 )
    #define IDirectInput2_AddRef( x ) \
        (x)->AddRef()
    #define IDirectInput2_Release( x ) \
        (x)->Release()
    #define IDirectInput2_CreateDevice( x, p1, p2, p3 ) \
        (x)->CreateDevice( p1, p2, p3 )
    #define IDirectInput2_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->EnumDevices( p1, p2, p3, p4 )
    #define IDirectInput2_GetDeviceStatus( x, p ) \
        (x)->GetDeviceStatus( p )
    #define IDirectInput2_RunControlPanel( x, p1, p2 ) \
        (x)->RunControlPanel( p1, p2 )
    #define IDirectInput2_Initialize( x, p1, p2 ) \
        (x)->Initialize( p1, p2 )
    #define IDirectInput2_FindDevice( x, p1, p2, p3 ) \
        (x)->FindDevice( p1, p2, p3 )
    #define IDirectInput7_QueryInterface( x, p1, p2 ) \
        (x)->QueryInterface( p1, p2 )
    #define IDirectInput7_AddRef( x ) \
        (x)->AddRef()
    #define IDirectInput7_Release( x ) \
        (x)->Release()
    #define IDirectInput7_CreateDevice( x, p1, p2, p3 ) \
        (x)->CreateDevice( p1, p2, p3 )
    #define IDirectInput7_EnumDevices( x, p1, p2, p3, p4 ) \
        (x)->EnumDevices( p1, p2, p3, p4 )
    #define IDirectInput7_GetDeviceStatus( x, p ) \
        (x)->GetDeviceStatus( p )
    #define IDirectInput7_RunControlPanel( x, p1, p2 ) \
        (x)->RunControlPanel( p1, p2 )
    #define IDirectInput7_Initialize( x, p1, p2 ) \
        (x)->Initialize( p1, p2 )
    #define IDirectInput7_FindDevice( x, p1, p2, p3 ) \
        (x)->FindDevice( p1, p2, p3 )
    #define IDirectInput7_CreateDeviceEx( x, p1, p2, p3, p4 ) \
        (x)->CreateDeviceEx( p1, p2, p3, p4 )
    #if (DIRECTINPUT_VERSION >= 0x0800)
        #define IDirectInput8_QueryInterface( x, p1, p2 ) \
            (x)->QueryInterface( p1, p2 )
        #define IDirectInput8_AddRef( x ) \
            (x)->AddRef()
        #define IDirectInput8_Release( x ) \
            (x)->Release()
        #define IDirectInput8_CreateDevice( x, p1, p2, p3 ) \
            (x)->CreateDevice( p1, p2, p3 )
        #define IDirectInput8_EnumDevices( x, p1, p2, p3, p4 ) \
            (x)->EnumDevices( p1, p2, p3, p4 )
        #define IDirectInput8_GetDeviceStatus( x, p ) \
            (x)->GetDeviceStatus( p )
        #define IDirectInput8_RunControlPanel( x, p1, p2 ) \
            (x)->RunControlPanel( p1, p2 )
        #define IDirectInput8_Initialize( x, p1, p2 ) \
            (x)->Initialize( p1, p2 )
        #define IDirectInput8_FindDevice( x, p1, p2, p3 ) \
            (x)->FindDevice( p1, p2, p3 )
        #define IDirectInput8_EnumDevicesBySemantics( x, p1, p2, p3, p4, p5 ) \
            (x)->EnumDevicesBySemantics( p1, p2, p3, p4, p5 )
        #define IDirectInput8_ConfigureDevices( x, p1, p2, p3, p4 ) \
            (x)->ConfigureDevices( p1, p2, p3, p4 )
    #endif
#endif

/* Global variables in DINPUT.LIB and DINPUT8.LIB */
extern const DIDATAFORMAT   __cdecl c_dfDIMouse;
extern const DIDATAFORMAT   __cdecl c_dfDIKeyboard;
#if (DIRECTINPUT_VERSION >= 0x0500)
extern const DIDATAFORMAT   __cdecl c_dfDIJoystick;
extern const DIDATAFORMAT   __cdecl c_dfDIJoystick2;
#endif
#if (DIRECTINPUT_VERSION >= 0x0700)
extern const DIDATAFORMAT   __cdecl c_dfDIMouse2;
#endif

/* Functions in DINPUT.DLL */
extern HRESULT WINAPI   DirectInputCreateA( HINSTANCE, DWORD, LPDIRECTINPUTA *, LPUNKNOWN );
extern HRESULT WINAPI   DirectInputCreateEx( HINSTANCE, DWORD, REFIID, LPVOID *, LPUNKNOWN );
extern HRESULT WINAPI   DirectInputCreateW( HINSTANCE, DWORD, LPDIRECTINPUTW *, LPUNKNOWN );

/* Functions in DINPUT8.DLL */
#if (DIRECTINPUT_VERSION > 0x0700)
extern HRESULT WINAPI   DirectInput8Create( HINSTANCE, DWORD, REFIID, LPVOID *, LPUNKNOWN );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define DirectInputCreate   DirectInputCreateW
#else
    #define DirectInputCreate   DirectInputCreateA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const CLSID    __cdecl CLSID_DirectInput;
EXTERN_C const CLSID    __cdecl CLSID_DirectInputDevice;
EXTERN_C const CLSID    __cdecl CLSID_DirectInput8;
EXTERN_C const CLSID    __cdecl CLSID_DirectInputDevice8;
EXTERN_C const IID      __cdecl IID_IDirectInputA;
EXTERN_C const IID      __cdecl IID_IDirectInputW;
EXTERN_C const IID      __cdecl IID_IDirectInput2A;
EXTERN_C const IID      __cdecl IID_IDirectInput2W;
EXTERN_C const IID      __cdecl IID_IDirectInput7A;
EXTERN_C const IID      __cdecl IID_IDirectInput7W;
EXTERN_C const IID      __cdecl IID_IDirectInput8A;
EXTERN_C const IID      __cdecl IID_IDirectInput8W;
EXTERN_C const IID      __cdecl IID_IDirectInputDeviceA;
EXTERN_C const IID      __cdecl IID_IDirectInputDeviceW;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice2A;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice2W;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice7A;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice7W;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice8A;
EXTERN_C const IID      __cdecl IID_IDirectInputDevice8W;
EXTERN_C const IID      __cdecl IID_IDirectInputEffect;
EXTERN_C const GUID     __cdecl GUID_XAxis;
EXTERN_C const GUID     __cdecl GUID_YAxis;
EXTERN_C const GUID     __cdecl GUID_ZAxis;
EXTERN_C const GUID     __cdecl GUID_RxAxis;
EXTERN_C const GUID     __cdecl GUID_RyAxis;
EXTERN_C const GUID     __cdecl GUID_RzAxis;
EXTERN_C const GUID     __cdecl GUID_Slider;
EXTERN_C const GUID     __cdecl GUID_Button;
EXTERN_C const GUID     __cdecl GUID_Key;
EXTERN_C const GUID     __cdecl GUID_POV;
EXTERN_C const GUID     __cdecl GUID_Unknown;
EXTERN_C const GUID     __cdecl GUID_SysMouse;
EXTERN_C const GUID     __cdecl GUID_SysKeyboard;
EXTERN_C const GUID     __cdecl GUID_Joystick;
EXTERN_C const GUID     __cdecl GUID_SysMouseEm;
EXTERN_C const GUID     __cdecl GUID_SysMouseEm2;
EXTERN_C const GUID     __cdecl GUID_SysKeyboardEm;
EXTERN_C const GUID     __cdecl GUID_SysKeyboardEm2;
EXTERN_C const GUID     __cdecl GUID_ConstantForce;
EXTERN_C const GUID     __cdecl GUID_RampForce;
EXTERN_C const GUID     __cdecl GUID_Square;
EXTERN_C const GUID     __cdecl GUID_Sine;
EXTERN_C const GUID     __cdecl GUID_Triangle;
EXTERN_C const GUID     __cdecl GUID_SawtoothUp;
EXTERN_C const GUID     __cdecl GUID_SawtoothDown;
EXTERN_C const GUID     __cdecl GUID_Spring;
EXTERN_C const GUID     __cdecl GUID_Damper;
EXTERN_C const GUID     __cdecl GUID_Inertia;
EXTERN_C const GUID     __cdecl GUID_Friction;
EXTERN_C const GUID     __cdecl GUID_CustomForce;
#ifdef UNICODE
    #define IID_IDirectInputDevice  IID_IDirectInputDeviceW
    #define IID_IDirectInputDevice2 IID_IDirectInputDevice2W
    #define IID_IDirectInputDevice7 IID_IDirectInputDevice7W
    #define IID_IDirectInputDevice8 IID_IDirectInputDevice8W
    #define IID_IDirectInput        IID_IDirectInputW
    #define IID_IDirectInput2       IID_IDirectInput2W
    #define IID_IDirectInput7       IID_IDirectInput7W
    #define IID_IDirectInput8       IID_IDirectInput8W
#else
    #define IID_IDirectInputDevice  IID_IDirectInputDeviceA
    #define IID_IDirectInputDevice2 IID_IDirectInputDevice2A
    #define IID_IDirectInputDevice7 IID_IDirectInputDevice7A
    #define IID_IDirectInputDevice8 IID_IDirectInputDevice8A
    #define IID_IDirectInput        IID_IDirectInputA
    #define IID_IDirectInput2       IID_IDirectInput2A
    #define IID_IDirectInput7       IID_IDirectInput7A
    #define IID_IDirectInput8       IID_IDirectInput8A
#endif

#endif /* __DINPUT_INCLUDED__ */
