/*
 *  ntdef.h     NT definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDEF_
#define _NTDEF_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <_w32ials.h>
#include <ctype.h>
#include <basetsd.h>
#include <guiddef.h>
#include <sdkddkver.h>
#include <specstrings.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define the appropriate macro for the current processor. */
#if defined(_M_I386) && !defined(_X86_)
    #define _X86_
#elif defined(_M_ALPHA) && !defined(_ALPHA_)
    #define _ALPHA_
#endif

/* Calling conventions */
#ifdef _M_I386
    #define FASTCALL    __fastcall
#else
    #define FASTCALL
#endif
#define NTAPI           __stdcall

/* Variable attributes */
#define CONST const

/* Parameter attributes */
#define IN
#define OUT
#define OPTIONAL
#define NOTHING
#define CRITICAL

/* Pointer attributes */
#define UNALIGNED
#define UNALIGNED64
#define RESTRICTED_POINTER

/* Macro to perform compile-time assertions */
#define C_ASSERT( x )   typedef char __C_ASSERT__[(x) ? 1 : -1]

/* Declaration specifiers */
#define DECLSPEC_IMPORT             __declspec(dllimport)
#define DECLSPEC_NORETURN
#define DECLSPEC_NOTHROW
#define DECLSPEC_ALIGN( x )
#define DECLSPEC_UUID( x )
#define DECLSPEC_NOVTABLE
#define DECLSPEC_SELECTANY
#define DECLSPEC_ADDRSAFE
#define DECLSPEC_NOINLINE
#define DECLSPEC_DEPRECATED
#ifdef DEPRECATE_DDK_FUNCTIONS
    #define DECLSPEC_DEPRECATED_DDK DECLSPEC_DEPRECATED
#else
    #define DECLSPEC_DEPRECATED_DDK
#endif

/* Macros to specify NT functions */
#define NTSYSAPI        DECLSPEC_IMPORT
#define NTSYSCALLAPI    DECLSPEC_IMPORT

/* Standard method and API calling conventions */
#define STDMETHODCALLTYPE   __stdcall
#define STDMETHODVCALLTYPE  __cdecl
#define STDAPICALLTYPE      __stdcall
#define STDAPIVCALLTYPE     __cdecl

/* Macro used to specify extern "C" */
#ifdef __cplusplus
    #define EXTERN_C    extern "C"
#else
    #define EXTERN_C    extern
#endif

/* Standard method implementation and API declaration macros */
#define STDAPI                      EXTERN_C HRESULT STDAPICALLTYPE
#define STDAPI_( x )                EXTERN_C x STDAPICALLTYPE
#define STDAPIV                     EXTERN_C HRESULT STDAPIVCALLTYPE
#define STDAPIV_( x )               EXTERN_C x STDAPIVCALLTYPE
#define STDMETHODIMP                HRESULT STDMETHODCALLTYPE
#define STDMETHODIMP_( x )          x STDMETHODCALLTYPE
#define STDMETHODIMPV               HRESULT STDMETHODVCALLTYPE
#define STDMETHODIMPV_( x )         x STDMETHODVCALLTYPE
#define STDOVERRIDEMETHODIMP        STDMETHODIMP
#define STDOVERRIDEMETHODIMP_( x )  STDMETHODIMP_( x )
#define STDOVERRIDEMETHODIMPV       STDMETHODIMPV
#define STDOVERRIDEMETHODIMPV_( x ) STDMETHODIMPV_( x )
#define IFACEMETHODIMP              STDMETHODIMP
#define IFACEMETHODIMP_( x )        STDMETHODIMP_( x )
#define IFACEMETHODIMPV             STDMETHODIMPV
#define IFACEMETHODIMPV_( x )       STDMETHODIMPV_( x )

/* Macro to declare handle data types */
#define DECLARE_HANDLE( x ) typedef struct x##__ { int dummy; } *x

/* Macro used to specify an unspecified data type or an empty parameter list */
#define VOID    void

/* Macro to specify neutral strings */
#ifdef UNICODE
    #define __TEXT( x ) L##x
#else
    #define __TEXT( x ) x
#endif
#define TEXT( x )       __TEXT( x )

/* Primitive data types */
typedef void                *PVOID;
typedef void                *PVOID64;
typedef char                CHAR;
typedef short               SHORT;
typedef long                LONG;
typedef int                 INT;
typedef SHORT               *PSHORT;
typedef LONG                *PLONG;
typedef double              DOUBLE;
typedef unsigned char       UCHAR;
typedef unsigned short      USHORT;
typedef unsigned long       ULONG;
typedef UCHAR               *PUCHAR;
typedef USHORT              *PUSHORT;
typedef ULONG               *PULONG;
typedef signed char         SCHAR;
typedef SCHAR               *PSCHAR;
#if (_WIN32_WINNT >= 0x0600)
typedef CONST UCHAR         *PCUCHAR;
typedef CONST USHORT        *PCUSHORT;
typedef CONST ULONG         *PCULONG;
typedef CONST SCHAR         *PCSCHAR;
#endif
typedef void                *HANDLE;
typedef HANDLE              *PHANDLE;
typedef UCHAR               FCHAR;
typedef USHORT              FSHORT;
typedef ULONG               FLONG;
typedef LONG                HRESULT;
typedef char                CCHAR;
typedef short               CSHORT;
typedef ULONG               CLONG;
typedef CCHAR               *PCCHAR;
typedef CSHORT              *PCSHORT;
typedef CLONG               *PCLONG;
typedef ULONG               LCID;
typedef PULONG              PLCID;
typedef USHORT              LANGID;
typedef ULONG               LOGICAL;
typedef ULONG               *PLOGICAL;
typedef LONG                NTSTATUS;
typedef NTSTATUS            *PNTSTATUS;
#if (_WIN32_WINNT >= 0x0600)
typedef CONST NTSTATUS      *PCNTSTATUS;
#endif
typedef __int64             LONGLONG;
typedef unsigned __int64    ULONGLONG;
typedef LONGLONG            *PLONGLONG;
typedef ULONGLONG           *PULONGLONG;
typedef LONGLONG            USN;
typedef CHAR                *PSZ;
typedef CONST char          *PCSZ;
typedef USHORT              RTL_STRING_LENGTH_TYPE;
typedef UCHAR               BOOLEAN;
typedef BOOLEAN             *PBOOLEAN;
typedef UCHAR               KIRQL;
typedef KIRQL               *PKIRQL;

/* ANSI string data types */
typedef CHAR        *PCHAR;
typedef CHAR        *LPCH;
typedef CHAR        *PCH;
typedef CONST CHAR  *LPCCH;
typedef CHAR        *PCCH;
typedef CHAR        *NPSTR;
typedef CHAR        *LPSTR;
typedef CHAR        *PSTR;
typedef PSTR        *PZPSTR;
typedef CONST PSTR  *PCZPSTR;
typedef CONST CHAR  *LPCSTR;
typedef CONST CHAR  *PCSTR;
typedef PCSTR       *PZPCSTR;
typedef CHAR        *PZZSTR;
typedef CONST CHAR  *PCZZSTR;
typedef CHAR        *PNZCH;
typedef CONST CHAR  *PCNZCH;

/* Unicode string data types */
typedef wchar_t                 WCHAR;
typedef WCHAR                   *PWCHAR;
typedef WCHAR                   *LPWCH;
typedef WCHAR                   *PWCH;
typedef CONST WCHAR             *LPCWCH;
typedef CONST WCHAR             *PCWCH;
typedef WCHAR                   *NWPSTR;
typedef WCHAR                   *LPWSTR;
typedef WCHAR                   *PWSTR;
typedef PWSTR                   *PZPWSTR;
typedef CONST PWSTR             *PCZPWSTR;
typedef WCHAR UNALIGNED         *LPUWSTR;
typedef WCHAR UNALIGNED         *PUWSTR;
typedef CONST WCHAR             *LPCWSTR;
typedef CONST WCHAR             *PCWSTR;
typedef PCWSTR                  *PZPCWSTR;
typedef CONST WCHAR UNALIGNED   *LPCUWSTR;
typedef CONST WCHAR UNALIGNED   *PCUWSTR;
typedef WCHAR                   *PZZWSTR;
typedef CONST WCHAR             *PCZZWSTR;
typedef WCHAR UNALIGNED         *PUZZWSTR;
typedef CONST WCHAR UNALIGNED   *PCUZZWSTR;
typedef WCHAR                   *PNZWCH;
typedef CONST WCHAR             *PCNZWCH;
typedef WCHAR UNALIGNED         *PUNZWCH;
typedef CONST WCHAR UNALIGNED   *PCUNZWCH;

/* Neutral string data types */
#ifdef UNICODE
typedef WCHAR           TCHAR;
typedef WCHAR           *PTCHAR;
typedef WCHAR           TUCHAR;
typedef WCHAR           *PTUCHAR;
typedef LPWCH           LPTCH;
typedef LPWCH           PTCH;
typedef LPCWCH          LPCTCH;
typedef LPCWCH          PCTCH;
typedef LPWSTR          LPTSTR;
typedef LPWSTR          PTSTR;
typedef LPCWSTR         LPCTSTR;
typedef LPCWSTR         PCTSTR;
typedef LPUWSTR         LPUTSTR;
typedef LPUWSTR         PUTSTR;
typedef LPCUWSTR        LPCUTSTR;
typedef LPCUWSTR        PCUTSTR;
typedef PZZWSTR         PZZTSTR;
typedef PCZZWSTR        PCZZTSTR;
typedef PUZZWSTR        PUZZTSTR;
typedef PCUZZWSTR       PCUZZTSTR;
typedef PNZWCH          PNZTCH;
typedef PCNZWCH         PCNZTCH;
typedef PUNZWCH         PUNZTCH;
typedef PCUNZWCH        PCUNZTCH;
#else
typedef char            TCHAR;
typedef char            *PTCHAR;
typedef unsigned char   TUCHAR;
typedef unsigned char   *PTUCHAR;
typedef LPCH            LPTCH;
typedef LPCH            PTCH;
typedef LPCCH           LPCTCH;
typedef LPCCH           PCTCH;
typedef LPSTR           LPTSTR;
typedef LPSTR           PTSTR;
typedef LPCSTR          LPCTSTR;
typedef LPCSTR          PCTSTR;
typedef LPSTR           LPUTSTR;
typedef LPSTR           PUTSTR;
typedef LPCSTR          LPCUTSTR;
typedef LPCSTR          PCUTSTR;
typedef PZZSTR          PZZTSTR;
typedef PCZZSTR         PCZZTSTR;
typedef PZZSTR          PUZZTSTR;
typedef PCZZSTR         PCUZZTSTR;
typedef PNZCH           PNZTCH;
typedef PCNZCH          PCNZTCH;
typedef PNZCH           PUNZTCH;
typedef PCNZCH          PCUNZTCH;
#endif

/* Universal Character Set (UCS) data types */
#if (_WIN32_WINNT >= 0x0600)
typedef CONST WCHAR             *LPCWCHAR;
typedef CONST WCHAR             *PCWCHAR;
typedef CONST WCHAR UNALIGNED   *LPCUWCHAR;
typedef CONST WCHAR UNALIGNED   *PCUWCHAR;
typedef unsigned long           UCSCHAR;
typedef UCSCHAR                 *PUCSCHAR;
typedef const UCSCHAR           *PCUCSCHAR;
typedef UCSCHAR                 *PUCSSTR;
typedef UCSCHAR UNALIGNED       *PUUCSSTR;
typedef const UCSCHAR           *PCUCSSTR;
typedef const UCSCHAR UNALIGNED *PCUUCSSTR;
typedef UCSCHAR UNALIGNED       *PUUCSCHAR;
typedef const UCSCHAR UNALIGNED *PCUUCSCHAR;
#endif

/* Security status data type */
#ifndef __SECSTATUS_DEFINED__
#define __SECSTATUS_DEFINED__
typedef LONG    SECURITY_STATUS;
#endif

/* Value used to declare an array of an unknown size */
#define ANYSIZE_ARRAY   1

/* Universal Character Set (UCS) constants */
#if (_WIN32_WINNT >= 0x0600)
    #define UCSCHAR_INVALID_CHARACTER   0xFFFFFFFFL
    #define MIN_UCSCHAR                 0x00000000L
    #define MAX_UCSCHAR                 0x0010FFFFL
#endif

/* Processor group special value */
#define ALL_PROCESSOR_GROUPS    0xFFFF

/* Object handle tag bits */
#define OBJ_HANDLE_TAGBITS  0x00000003L

/* Macros to test NT status values */
#define NT_SUCCESS( x )     (((NTSTATUS)(x)) >= 0)
#define NT_INFORMATION( x ) ((((ULONG)(x)) >> 30) == 1)
#define NT_WARNING( x )     ((((ULONG)(x)) >> 30) == 2)
#define NT_ERROR( x )       ((((ULONG)(x)) >> 30) == 3)

/* Error severities */
#define APPLICATION_ERROR_MASK          0x20000000
#define ERROR_SEVERITY_SUCCES           0x00000000
#define ERROR_SEVERITY_INFORMATIONAL    0x40000000
#define ERROR_SEVERITY_WARNING          0x80000000
#define ERROR_SEVERITY_ERROR            0xC0000000

/* Null character values */
#define ANSI_NULL       ((CHAR)0)
#define UNICODE_NULL    ((WCHAR)0)

/* Object attribute flags */
#define OBJ_INHERIT             0x00000002L
#define OBJ_PERMANENT           0x00000010L
#define OBJ_EXCLUSIVE           0x00000020L
#define OBJ_CASE_INSENSITIVE    0x00000040L
#define OBJ_OPENIF              0x00000080L
#define OBJ_OPENLINK            0x00000100L
#define OBJ_KERNEL_HANDLE       0x00000200L
#define OBJ_FORCE_ACCESS_CHECK  0x00000400L
#define OBJ_VALID_ATTRIBUTES    0x000007F2L

/* Basic constants */
#ifndef NULL
    #ifdef __cplusplus
        #define NULL    0
    #else
        #define NULL    ((void *)0)
    #endif
#endif
#ifndef FALSE
    #define FALSE       0
#endif
#ifndef TRUE
    #define TRUE        1
#endif

/* Limits of primitive data types */
#define MINCHAR     0x80
#define MAXCHAR     0x7F
#define MINSHORT    0x8000
#define MAXSHORT    0x7FFF
#define MINLONG     0x80000000
#define MAXLONG     0x7FFFFFFF
#define MAXUCHAR    0xFF
#define MAXUSHORT   0xFFFF
#define MAXULONG    0xFFFFFFFF

/* Macro to test if an argument is present */
#define ARGUMENT_PRESENT( x )   ((CHAR *)(ULONG_PTR)(x) != (CHAR *)NULL)

/* Macro to find field offsets */
#define FIELD_OFFSET( x, p )    ((LONG)(LONG_PTR)&(((x *)0)->p))

/* Macro to find the containing record */
#define CONTAINING_RECORD( p1, p2, p3 ) \
    ((p2 *)((PCHAR)(p1) - (ULONG_PTR)(&((p2 *)0)->p3)))

/* Suite types */
#define VER_SUITE_SMALLBUSINESS             0x00000001
#define VER_SUITE_ENTERPRISE                0x00000002
#define VER_SUITE_BACKOFFICE                0x00000004
#define VER_SUITE_COMMUNICATIONS            0x00000008
#define VER_SUITE_TERMINAL                  0x00000010
#define VER_SUITE_SMALLBUSINESS_RESTRICTED  0x00000020
#define VER_SUITE_EMBEDDEDNT                0x00000040
#define VER_SUITE_DATACENTER                0x00000080
#define VER_SUITE_SINGLEUSERTS              0x00000100
#define VER_SUITE_PERSONAL                  0x00000200
#define VER_SUITE_BLADE                     0x00000400
#define VER_SUITE_EMBEDDED_RESTRICTED       0x00000800
#define VER_SUITE_SECURITY_APPLIANCE        0x00001000
#define VER_SUITE_STORAGE_SERVER            0x00002000
#define VER_SUITE_COMPUTE_SERVER            0x00004000
#define VER_SUITE_WH_SERVER                 0x00008000

/* Product types */
#define PRODUCT_UNDEFINED                           0x00000000
#define PRODUCT_ULTIMATE                            0x00000001
#define PRODUCT_HOME_BASIC                          0x00000002
#define PRODUCT_HOME_PREMIUM                        0x00000003
#define PRODUCT_ENTERPRISE                          0x00000004
#define PRODUCT_HOME_BASIC_N                        0x00000005
#define PRODUCT_BUSINESS                            0x00000006
#define PRODUCT_STANDARD_SERVER                     0x00000007
#define PRODUCT_DATACENTER_SERVER                   0x00000008
#define PRODUCT_SMALLBUSINESS_SERVER                0x00000009
#define PRODUCT_ENTERPRISE_SERVER                   0x0000000A
#define PRODUCT_STARTER                             0x0000000B
#define PRODUCT_DATACENTER_SERVER_CORE              0x0000000C
#define PRODUCT_STANDARD_SERVER_CORE                0x0000000D
#define PRODUCT_ENTERPRISE_SERVER_CORE              0x0000000E
#define PRODUCT_ENTERPRISE_SERVER_IA64              0x0000000F
#define PRODUCT_BUSINESS_N                          0x00000010
#define PRODUCT_WEB_SERVER                          0x00000011
#define PRODUCT_CLUSTER_SERVER                      0x00000012
#define PRODUCT_HOME_SERVER                         0x00000013
#define PRODUCT_STORAGE_EXPRESS_SERVER              0x00000014
#define PRODUCT_STORAGE_STANDARD_SERVER             0x00000015
#define PRODUCT_STORAGE_WORKGROUP_SERVER            0x00000016
#define PRODUCT_STORAGE_ENTERPRISE_SERVER           0x00000017
#define PRODUCT_SERVER_FOR_SMALLBUSINESS            0x00000018
#define PRODUCT_SMALLBUSINESS_SERVER_PREMIUM        0x00000019
#define PRODUCT_HOME_PREMIUM_N                      0x0000001A
#define PRODUCT_ENTERPRISE_N                        0x0000001B
#define PRODUCT_ULTIMATE_N                          0x0000001C
#define PRODUCT_WEB_SERVER_CORE                     0x0000001D
#define PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT    0x0000001E
#define PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY      0x0000001F
#define PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING     0x00000020
#define PRODUCT_SERVER_FOUNDATION                   0x00000021
#define PRODUCT_HOME_PREMIUM_SERVER                 0x00000022
#define PRODUCT_SERVER_FOR_SMALLBUSINESS_V          0x00000023
#define PRODUCT_STANDARD_SERVER_V                   0x00000024
#define PRODUCT_DATACENTER_SERVER_V                 0x00000025
#define PRODUCT_ENTERPRISE_SERVER_V                 0x00000026
#define PRODUCT_DATACENTER_SERVER_CORE_V            0x00000027
#define PRODUCT_STANDARD_SERVER_CORE_V              0x00000028
#define PRODUCT_ENTERPRISE_SERVER_CORE_V            0x00000029
#define PRODUCT_HYPERV                              0x0000002A
#define PRODUCT_STORAGE_EXPRESS_SERVER_CORE         0x0000002B
#define PRODUCT_STORAGE_STANDARD_SERVER_CORE        0x0000002C
#define PRODUCT_STORAGE_WORKGROUP_SERVER_CORE       0x0000002D
#define PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE      0x0000002E
#define PRODUCT_STARTER_N                           0x0000002F
#define PRODUCT_PROFESSIONAL                        0x00000030
#define PRODUCT_PROFESSIONAL_N                      0x00000031
#define PRODUCT_SB_SOLUTION_SERVER                  0x00000032
#define PRODUCT_SERVER_FOR_SB_SOLUTIONS             0x00000033
#define PRODUCT_STANDARD_SERVER_SOLUTIONS           0x00000034
#define PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE      0x00000035
#define PRODUCT_SB_SOLUTION_SERVER_EM               0x00000036
#define PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM          0x00000037
#define PRODUCT_SOLUTION_EMBEDDEDSERVER             0x00000038
#define PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE        0x00000039
#define PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT       0x0000003B
#define PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL       0x0000003C
#define PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC    0x0000003D
#define PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC    0x0000003E
#define PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE   0x0000003F
#define PRODUCT_CLUSTER_SERVER_V                    0x00000040
#define PRODUCT_EMBEDDED                            0x00000041
#define PRODUCT_STARTER_E                           0x00000042
#define PRODUCT_HOME_BASIC_E                        0x00000043
#define PRODUCT_HOME_PREMIUM_E                      0x00000044
#define PRODUCT_PROFESSIONAL_E                      0x00000045
#define PRODUCT_ENTERPRISE_E                        0x00000046
#define PRODUCT_ULTIMATE_E                          0x00000047
#define PRODUCT_UNLICENSED                          0xABCDABCD

/* Language identifiers */
#define LANG_NEUTRAL            0x00
#define LANG_INVARIANT          0x7F
#define LANG_AFRIKAANS          0x36
#define LANG_ALBANIAN           0x1C
#define LANG_ALSATIAN           0x84
#define LANG_AMHARIC            0x5E
#define LANG_ARABIC             0x01
#define LANG_ARMENIAN           0x2B
#define LANG_ASSAMESE           0x4D
#define LANG_AZERI              0x2C
#define LANG_BASHKIR            0x6D
#define LANG_BASQUE             0x2D
#define LANG_BELARUSIAN         0x23
#define LANG_BENGALI            0x45
#define LANG_BRETON             0x7E
#define LANG_BULGARIAN          0x02
#define LANG_CATALAN            0x03
#define LANG_CHINESE            0x04
#define LANG_CORSICAN           0x83
#define LANG_CROATIAN           0x1A
#define LANG_CZECH              0x05
#define LANG_DANISH             0x06
#define LANG_DARI               0x8C
#define LANG_DIVEHI             0x65
#define LANG_DUTCH              0x13
#define LANG_ENGLISH            0x09
#define LANG_ESTONIAN           0x25
#define LANG_FAEROESE           0x38
#define LANG_FARSI              0x29
#define LANG_FILIPINO           0x64
#define LANG_FINNISH            0x0B
#define LANG_FRENCH             0x0C
#define LANG_FRISIAN            0x62
#define LANG_GALICIAN           0x56
#define LANG_GEORGIAN           0x37
#define LANG_GERMAN             0x07
#define LANG_GREEK              0x08
#define LANG_GREENLANDIC        0x6F
#define LANG_GUJARATI           0x47
#define LANG_HAUSA              0x68
#define LANG_HEBREW             0x0D
#define LANG_HINDI              0x39
#define LANG_HUNGARIAN          0x0E
#define LANG_ICELANDIC          0x0F
#define LANG_IGBO               0x70
#define LANG_INDONESIAN         0x21
#define LANG_INUKTITUT          0x5D
#define LANG_IRISH              0x3C
#define LANG_ITALIAN            0x10
#define LANG_JAPANESE           0x11
#define LANG_KANNADA            0x4B
#define LANG_KASHMIRI           0x60
#define LANG_KAZAK              0x3F
#define LANG_KHMER              0x53
#define LANG_KICHE              0x86
#define LANG_KINYARWANDA        0x87
#define LANG_KONKANI            0x57
#define LANG_KOREAN             0x12
#define LANG_KYRGYZ             0x40
#define LANG_LAO                0x54
#define LANG_LATVIAN            0x26
#define LANG_LITHUANIAN         0x27
#define LANG_LOWER_SORBIAN      0x2E
#define LANG_LUXEMBOURGISH      0x6E
#define LANG_MACEDONIAN         0x2F
#define LANG_MALAY              0x3E
#define LANG_MALAYALAM          0x4C
#define LANG_MALTESE            0x3A
#define LANG_MANIPURI           0x58
#define LANG_MAORI              0x81
#define LANG_MAPUDUNGUN         0x7A
#define LANG_MARATHI            0x4E
#define LANG_MOHAWK             0x7C
#define LANG_MONGOLIAN          0x50
#define LANG_NEPALI             0x61
#define LANG_NORWEGIAN          0x14
#define LANG_OCCITAN            0x82
#define LANG_ORIYA              0x48
#define LANG_PASHTO             0x63
#define LANG_PERSIAN            0x29
#define LANG_POLISH             0x15
#define LANG_PORTUGUESE         0x16
#define LANG_PUNJABI            0x46
#define LANG_QUECHUA            0x6B
#define LANG_ROMANIAN           0x18
#define LANG_ROMANSH            0x17
#define LANG_RUSSIAN            0x19
#define LANG_SAMI               0x3B
#define LANG_SANSKRIT           0x4F
#define LANG_SCOTTISH_GAELIC    0x91
#define LANG_SERBIAN            0x1A
#define LANG_SINDHI             0x59
#define LANG_SINHALESE          0x5B
#define LANG_SLOVAK             0x1B
#define LANG_SLOVENIAN          0x24
#define LANG_SOTHO              0x6C
#define LANG_SPANISH            0x0A
#define LANG_SWAHILI            0x41
#define LANG_SWEDISH            0x1D
#define LANG_SYRIAC             0x5A
#define LANG_TAJIK              0x28
#define LANG_TAMAZIGHT          0x5F
#define LANG_TAMIL              0x49
#define LANG_TATAR              0x44
#define LANG_TELUGU             0x4A
#define LANG_THAI               0x1E
#define LANG_TIBETAN            0x51
#define LANG_TIGRIGNA           0x73
#define LANG_TSWANA             0x32
#define LANG_TURKISH            0x1F
#define LANG_TURKMEN            0x42
#define LANG_UIGHUR             0x80
#define LANG_UKRAINIAN          0x22
#define LANG_UPPER_SORBIAN      0x2E
#define LANG_URDU               0x20
#define LANG_UZBEK              0x43
#define LANG_VIETNAMESE         0x2A
#define LANG_WELSH              0x52
#define LANG_WOLOF              0x88
#define LANG_XHOSA              0x34
#define LANG_YAKUT              0x85
#define LANG_YI                 0x78
#define LANG_YORUBA             0x6A
#define LANG_ZULU               0x35

/* Sublanguage identifiers */
#define SUBLANG_NEUTRAL                             0x00
#define SUBLANG_DEFAULT                             0x01
#define SUBLANG_SYS_DEFAULT                         0x02
#define SUBLANG_CUSTOM_DEFAULT                      0x03
#define SUBLANG_CUSTOM_UNSPECIFIED                  0x04
#define SUBLANG_UI_CUSTOM_DEFAULT                   0x05
#define SUBLANG_AFRIKAANS_SOUTH_AFRICA              0x01
#define SUBLANG_ALBANIAN_ALBANIA                    0x01
#define SUBLANG_ALSATIAN_FRANCE                     0x01
#define SUBLANG_AMHARIC_ETHIOPIA                    0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA                 0x01
#define SUBLANG_ARABIC_IRAQ                         0x02
#define SUBLANG_ARABIC_EGYPT                        0x03
#define SUBLANG_ARABIC_LIBYA                        0x04
#define SUBLANG_ARABIC_ALGERIA                      0x05
#define SUBLANG_ARABIC_MOROCCO                      0x06
#define SUBLANG_ARABIC_TUNISIA                      0x07
#define SUBLANG_ARABIC_OMAN                         0x08
#define SUBLANG_ARABIC_YEMEN                        0x09
#define SUBLANG_ARABIC_SYRIA                        0x0A
#define SUBLANG_ARABIC_JORDAN                       0x0B
#define SUBLANG_ARABIC_LEBANON                      0x0C
#define SUBLANG_ARABIC_KUWAIT                       0x0D
#define SUBLANG_ARABIC_UAE                          0x0E
#define SUBLANG_ARABIC_BAHRAIN                      0x0F
#define SUBLANG_ARABIC_QATAR                        0x10
#define SUBLANG_ARMENIAN_ARMENIA                    0x01
#define SUBLANG_ASSAMESE_INDIA                      0x01
#define SUBLANG_AZERI_LATIN                         0x01
#define SUBLANG_AZERI_CYRILLIC                      0x02
#define SUBLANG_BASHKIR_RUSSIA                      0x01
#define SUBLANG_BASQUE_BASQUE                       0x01
#define SUBLANG_BELARUSIAN_BELARUS                  0x01
#define SUBLANG_BENGALI                             0x01
#define SUBLANG_BENGALI_BANGLADESH                  0x02
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN    0x05
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC 0x08
#define SUBLANG_BRETON_FRANCE                       0x01
#define SUBLANG_BULGARIAN_BULGARIA                  0x01
#define SUBLANG_CATALAN_CATALAN                     0x01
#define SUBLANG_CHINESE_TRADITIONAL                 0x01
#define SUBLANG_CHINESE_SIMPLIFIED                  0x02
#define SUBLANG_CHINESE_HONGKONG                    0x03
#define SUBLANG_CHINESE_SINGAPORE                   0x04
#define SUBLANG_CHINESE_MACAU                       0x05
#define SUBLANG_CORSICAN_FRANCE                     0x01
#define SUBLANG_CZECH_CZECH_REPUBLIC                0x01
#define SUBLANG_CROATIAN_CROATIA                    0x01
#define SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN   0x04
#define SUBLANG_DANISH_DENMARK                      0x01
#define SUBLANG_DARI_AFGHANISTAN                    0x01
#define SUBLANG_DIVEHI_MALDIVES                     0x01
#define SUBLANG_DUTCH                               0x01
#define SUBLANG_DUTCH_BELGIAN                       0x02
#define SUBLANG_ENGLISH_US                          0x01
#define SUBLANG_ENGLISH_UK                          0x02
#define SUBLANG_ENGLISH_AUS                         0x03
#define SUBLANG_ENGLISH_CAN                         0x04
#define SUBLANG_ENGLISH_NZ                          0x05
#define SUBLANG_ENGLISH_EIRE                        0x06
#define SUBLANG_ENGLISH_SOUTH_AFRICA                0x07
#define SUBLANG_ENGLISH_JAMAICA                     0x08
#define SUBLANG_ENGLISH_CARIBBEAN                   0x09
#define SUBLANG_ENGLISH_BELIZE                      0x0A
#define SUBLANG_ENGLISH_TRINIDAD                    0x0B
#define SUBLANG_ENGLISH_ZIMBABWE                    0x0C
#define SUBLANG_ENGLISH_PHILIPPINES                 0x0D
#define SUBLANG_ENGLISH_INDIA                       0x10
#define SUBLANG_ENGLISH_MALAYSIA                    0x11
#define SUBLANG_ENGLISH_SINGAPORE                   0x12
#define SUBLANG_ESTONIAN_ESTONIA                    0x01
#define SUBLANG_FAEROESE_FAROE_ISLANDS              0x01
#define SUBLANG_FILIPINO_PHILIPPINES                0x01
#define SUBLANG_FINNISH_FINLAND                     0x01
#define SUBLANG_FRENCH                              0x01
#define SUBLANG_FRENCH_BELGIAN                      0x02
#define SUBLANG_FRENCH_CANADIAN                     0x03
#define SUBLANG_FRENCH_SWISS                        0x04
#define SUBLANG_FRENCH_LUXEMBOURG                   0x05
#define SUBLANG_FRENCH_MONACO                       0x06
#define SUBLANG_FRISIAN_NETHERLANDS                 0x01
#define SUBLANG_GALICIAN_GALICIAN                   0x01
#define SUBLANG_GEORGIAN_GEORGIA                    0x01
#define SUBLANG_GERMAN                              0x01
#define SUBLANG_GERMAN_SWISS                        0x02
#define SUBLANG_GERMAN_AUSTRIAN                     0x03
#define SUBLANG_GERMAN_LUXEMBOURG                   0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN                0x05
#define SUBLANG_GREEK_GREECE                        0x01
#define SUBLANG_GREENLANDIC_GREENLAND               0x01
#define SUBLANG_GUJARATI_INDIA                      0x01
#define SUBLANG_HAUSA_NIGERIA_LATIN                 0x01
#define SUBLANG_HEBREW_ISRAEL                       0x01
#define SUBLANG_HINDI_INDIA                         0x01
#define SUBLANG_HUNGARIAN_HUNGARY                   0x01
#define SUBLANG_ICELANDIC_ICELAND                   0x01
#define SUBLANG_IGBO_NIGERIA                        0x01
#define SUBLANG_INDONESIAN_INDONESIA                0x01
#define SUBLANG_INUKTITUT_CANADA                    0x01
#define SUBLANG_INUKTITUT_CANADA_LATIN              0x02
#define SUBLANG_IRISH_IRELAND                       0x01
#define SUBLANG_ITALIAN                             0x01
#define SUBLANG_ITALIAN_SWISS                       0x02
#define SUBLANG_JAPANESE_JAPAN                      0x01
#define SUBLANG_KANNADA_INDIA                       0x01
#define SUBLANG_KASHMIRI_SASIA                      0x02
#define SUBLANG_KASHMIRI_INDIA                      0x02
#define SUBLANG_KAZAK_KAZAKHSTAN                    0x01
#define SUBLANG_KHMER_CAMBODIA                      0x01
#define SUBLANG_KICHE_GUATEMALA                     0x01
#define SUBLANG_KINYARWANDA_RWANDA                  0x01
#define SUBLANG_KONKANI_INDIA                       0x01
#define SUBLANG_KOREAN                              0x01
#define SUBLANG_KYRGYZ_KYRGYZSTAN                   0x01
#define SUBLANG_LAO_LAO                             0x01
#define SUBLANG_LATVIAN_LATVIA                      0x01
#define SUBLANG_LITHUANIAN                          0x01
#define SUBLANG_LOWER_SORBIAN_GERMANY               0x02
#define SUBLANG_LUXEMBOURGISH_LUXEMBOURG            0x01
#define SUBLANG_MACEDONIAN_MACEDONIA                0x01
#define SUBLANG_MALAY_MALAYSIA                      0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM             0x02
#define SUBLANG_MALAYALAM_INDIA                     0x01
#define SUBLANG_MALTESE_MALTA                       0x01
#define SUBLANG_MAORI_NEW_ZEALAND                   0x01
#define SUBLANG_MAPUDUNGUN_CHILE                    0x01
#define SUBLANG_MARATHI_INDIA                       0x01
#define SUBLANG_MOHAWK_MOHAWK                       0x01
#define SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA         0x01
#define SUBLANG_MONGOLIAN_PRC                       0x02
#define SUBLANG_NEPALI_INDIA                        0x02
#define SUBLANG_NEPALI_NEPAL                        0x01
#define SUBLANG_NORWEGIAN_BOKMAL                    0x01
#define SUBLANG_NORWEGIAN_NYNORSK                   0x02
#define SUBLANG_OCCITAN_FRANCE                      0x01
#define SUBLANG_ORIYA_INDIA                         0x01
#define SUBLANG_PASHTO_AFGHANISTAN                  0x01
#define SUBLANG_PERSIAN_IRAN                        0x01
#define SUBLANG_POLISH_POLAND                       0x01
#define SUBLANG_PORTUGUESE                          0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN                0x01
#define SUBLANG_PUNJABI_INDIA                       0x01
#define SUBLANG_QUECHUA_BOLIVIA                     0x01
#define SUBLANG_QUECHUA_ECUADOR                     0x02
#define SUBLANG_QUECHUA_PERU                        0x03
#define SUBLANG_ROMANIAN_ROMANIA                    0x01
#define SUBLANG_ROMANSH_SWITZERLAND                 0x01
#define SUBLANG_RUSSIAN_RUSSIA                      0x01
#define SUBLANG_SAMI_NORTHERN_NORWAY                0x01
#define SUBLANG_SAMI_NORTHERN_SWEDEN                0x02
#define SUBLANG_SAMI_NORTHERN_FINLAND               0x03
#define SUBLANG_SAMI_LULE_NORWAY                    0x04
#define SUBLANG_SAMI_LULE_SWEDEN                    0x05
#define SUBLANG_SAMI_SOUTHERN_NORWAY                0x06
#define SUBLANG_SAMI_SOUTHERN_SWEDEN                0x07
#define SUBLANG_SAMI_SKOLT_FINLAND                  0x08
#define SUBLANG_SAMI_INARI_FINLAND                  0x09
#define SUBLANG_SANSKRIT_INDIA                      0x01
#define SUBLANG_SCOTTISH_GAELIC                     0x01
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN    0x06
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC 0x07
#define SUBLANG_SERBIAN_MONTENEGRO_LATIN            0x0B
#define SUBLANG_SERBIAN_MONTENEGRO_CYRILLIC         0x0C
#define SUBLANG_SERBIAN_SERBIA_LATIN                0x09
#define SUBLANG_SERBIAN_SERBIA_CYRILLIC             0x0A
#define SUBLANG_SERBIAN_CROATIA                     0x01
#define SUBLANG_SERBIAN_LATIN                       0x02
#define SUBLANG_SERBIAN_CYRILLIC                    0x03
#define SUBLANG_SINDHI_INDIA                        0x01
#define SUBLANG_SINDHI_PAKISTAN                     0x02
#define SUBLANG_SINDHI_AFGHANISTAN                  0x02
#define SUBLANG_SINHALESE_SRI_LANKA                 0x01
#define SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA         0x01
#define SUBLANG_SLOVAK_SLOVAKIA                     0x01
#define SUBLANG_SLOVENIAN_SLOVENIA                  0x01
#define SUBLANG_SPANISH                             0x01
#define SUBLANG_SPANISH_MEXICAN                     0x02
#define SUBLANG_SPANISH_MODERN                      0x03
#define SUBLANG_SPANISH_GUATEMALA                   0x04
#define SUBLANG_SPANISH_COSTA_RICA                  0x05
#define SUBLANG_SPANISH_PANAMA                      0x06
#define SUBLANG_SPANISH_DOMINICAN_REPUBLIC          0x07
#define SUBLANG_SPANISH_VENEZUELA                   0x08
#define SUBLANG_SPANISH_COLOMBIA                    0x09
#define SUBLANG_SPANISH_PERU                        0x0A
#define SUBLANG_SPANISH_ARGENTINA                   0x0B
#define SUBLANG_SPANISH_ECUADOR                     0x0C
#define SUBLANG_SPANISH_CHILE                       0x0D
#define SUBLANG_SPANISH_URUGUAY                     0x0E
#define SUBLANG_SPANISH_PARAGUAY                    0x0F
#define SUBLANG_SPANISH_BOLIVIA                     0x10
#define SUBLANG_SPANISH_EL_SALVADOR                 0x11
#define SUBLANG_SPANISH_HONDURAS                    0x12
#define SUBLANG_SPANISH_NICARAGUA                   0x13
#define SUBLANG_SPANISH_PEUTRO_RICO                 0x14
#define SUBLANG_SPANISH_US                          0x15
#define SUBLANG_SWAHILI_KENYA                       0x01
#define SUBLANG_SWEDISH                             0x01
#define SUBLANG_SWEDISH_FINLAND                     0x02
#define SUBLANG_SYRIAC_SYRIA                        0x01
#define SUBLANG_TAJIK_TAJIKISTAN                    0x01
#define SUBLANG_TAMAZIGHT_ALGERIA_LATIN             0x02
#define SUBLANG_TAMIL_INDIA                         0x01
#define SUBLANG_TATAR_RUSSIA                        0x01
#define SUBLANG_TELUGU_INDIA                        0x01
#define SUBLANG_THAI_THAILAND                       0x01
#define SUBLANG_TIBETAN_PRC                         0x01
#define SUBLANG_TIRGIGNA_ERITREA                    0x02
#define SUBLANG_TSWANA_SOUTH_AFRICA                 0x01
#define SUBLANG_TURKISH_TURKEY                      0x01
#define SUBLANG_TURKMEN_TURKMENISTAN                0x01
#define SUBLANG_UIGHUR_PRC                          0x01
#define SUBLANG_UKRAINIAN_UKRAINE                   0x01
#define SUBLANG_UPPER_SORBIAN_GERMANY               0x01
#define SUBLANG_URDU_PAKISTAN                       0x01
#define SUBLANG_URDU_INDIA                          0x02
#define SUBLANG_UZBEK_LATIN                         0x01
#define SUBLANG_UZBEK_CYRILLIC                      0x02
#define SUBLANG_VIETNAMESE_VIETNAM                  0x01
#define SUBLANG_WELSH_UNITED_KINGDOM                0x01
#define SUBLANG_WOLOF_SENEGAL                       0x01
#define SUBLANG_XHOSA_SOUTH_AFRICA                  0x01
#define SUBLANG_YAKUT_RUSSIA                        0x01
#define SUBLANG_YI_PRC                              0x01
#define SUBLANG_YURUBA_NIGERIA                      0x01
#define SUBLANG_ZULU_SOUTH_AFRICA                   0x01

/* Sort identifiers */
#define SORT_DEFAULT                0x0
#define SORT_INVARIANT_MATH         0x1
#define SORT_JAPANESE_XJIS          0x0
#define SORT_JAPANESE_UNICODE       0x1
#define SORT_JAPANESE_RADICALSTROKE 0x4
#define SORT_CHINESE_BIG5           0x0
#define SORT_CHINESE_PRCP           0x0
#define SORT_CHINESE_UNICODE        0x1
#define SORT_CHINESE_PRC            0x2
#define SORT_CHINESE_BOPOMOFO       0x3
#define SORT_CHINESE_RADICALSTROKE  0x4
#define SORT_KOREAN_KSC             0x0
#define SORT_KOREAN_UNICODE         0x1
#define SORT_GERMAN_PHONE_BOOK      0x1
#define SORT_HUNGARIAN_DEFAULT      0x0
#define SORT_HUNGARIAN_TECHNICAL    0x1
#define SORT_GEORGIAN_TRADITIONAL   0x0
#define SORT_GEORGIAN_MODERN        0x1

/* Macros to manipulate language identifiers */
#define MAKELANGID( p1, p2 )    (((USHORT)(p2) << 10) | (USHORT)(p1))
#define PRIMARYLANGID( x )      ((USHORT)(x) & 0x03FF)
#define SUBLANGID( x )          ((USHORT)(x) >> 10)

/* Macros to manipulate locale identifiers */
#define MAKELCID( p1, p2)           (((ULONG)(USHORT)(p2) << 16) | (ULONG)(USHORT)(p1))
#define MAKESORTLCID( p1, p2, p3 )  (MAKELCID( p1, p2 ) | ((ULONG)(USHORT)(p3) << 20))
#define LANGIDFROMLCID( x )         ((USHORT)(x))
#define SORTIDFROMLCID( x )         ((USHORT)(((ULONG)(x) >> 16) & 0x0000000FL))
#define SORTVERSIONFROMLCID( x )    ((USHORT)(((ULONG)(x) >> 20) & 0x0000000FL))

/* Default languages identifiers */
#define LANG_SYSTEM_DEFAULT MAKELANGID( LANG_NEUTRAL, SUBLANG_SYS_DEFAULT )
#define LANG_USER_DEFAULT   MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT )

/* Default locale identifiers */
#define LOCALE_SYSTEM_DEFAULT   MAKELCID( LANG_SYSTEM_DEFAULT, SORT_DEFAULT )
#define LOCALE_USER_DEFAULT     MAKELCID( LANG_USER_DEFAULT, SORT_DEFAULT )
#define LOCALE_CUSTOM_DEFAULT \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_CUSTOM_DEFAULT ), SORT_DEFAULT )
#define LOCALE_CUSTOM_UNSPECIFIED \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_CUSTOM_UNSPECIFIED ), SORT_DEFAULT )
#define LOCALE_CUSTOM_UI_DEFAULT \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_UI_CUSTOM_DEFAULT ), SORT_DEFAULT )
#define LOCALE_NEUTRAL \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_NEUTRAL ), SORT_DEFAULT )
#define LOCALE_INVARIANT \
    MAKELCID( MAKELANGID( LANG_INVARIANT, SUBLANG_NEUTRAL ), SORT_DEFAULT )

/* Maximum locale name length */
#define LOCALE_NAME_MAX_LENGTH  85

/* Language identifiers for use with ConvertDefaultLocale() */
#define LANG_BOSNIAN_NEUTRAL        0x781A
#define LANG_CHINESE_SIMPLIFIED     0x0004
#define LANG_CHINESE_TRADITIONAL    0x7C04
#define LANG_SERBIAN_NEUTRAL        0x7C1A

/* Unreferenced parameter macros */
#define UNREFERENCED_PARAMETER( x )             (x)
#define DBG_UNREFERENCED_PARAMETER( x )         (x)
#define DBG_UNREFERENCED_LOCAL_VARIABLE( x )    (x)

/* Minimum and maximum macros */
#ifndef min
    #define min( p1, p2 )   (((p1) < (p2)) ? (p1) : (p2))
#endif
#ifndef max
    #define max( p1, p2 )   (((p1) > (p2)) ? (p1) : (p2))
#endif

/* Quad */
typedef struct _QUAD {
    union {
        __int64 UseThisFieldToCopy;
        double  DoNotUseThisField;
    };
} QUAD;
typedef QUAD        *PQUAD;
typedef QUAD        UQUAD;
typedef UQUAD       *PUQUAD;
#if (_WIN32_WINNT >= 0x0600)
typedef CONST UQUAD *PCUQUAD;
#endif

/* Compartment identifiers */
typedef enum {
    UNSPECIFIED_COMPARTMENT_ID  = 0,
    DEFAULT_COMPARTMENT_ID      = 1
} COMPARTMENT_ID;
typedef COMPARTMENT_ID  *PCOMPARTMENT_ID;

/* Processor number */
typedef struct _PROCESSOR_NUMBER {
    USHORT  Group;
    UCHAR   Number;
    UCHAR   Reserved;
} PROCESSOR_NUMBER;
typedef PROCESSOR_NUMBER    *PPROCESSOR_NUMBER;

/* Group affinity */
typedef struct _GROUP_AFFINITY {
    KAFFINITY   Mask;
    USHORT      Group;
    USHORT      Reserved[3];
} GROUP_AFFINITY;
typedef GROUP_AFFINITY  *PGROUP_AFFINITY;

/* Large integer */
typedef union _LARGE_INTEGER {
    struct {
        ULONG   LowPart;
        LONG    HighPart;
    };
    struct {
        ULONG   LowPart;
        LONG    HighPart;
    } u;
    LONGLONG    QuadPart;
} LARGE_INTEGER;
typedef LARGE_INTEGER   *PLARGE_INTEGER;
typedef LARGE_INTEGER   PHYSICAL_ADDRESS;
typedef LARGE_INTEGER   *PPHYSICAL_ADDRESS;
#define TIME            LARGE_INTEGER
#define _TIME           _LARGE_INTEGER
#define PTIME           PLARGE_INTEGER
#define LowTime         LowPart
#define HighPart        HighPart

/* Unsigned large integer */
typedef union _ULARGE_INTEGER {
    struct {
        ULONG   LowPart;
        ULONG   HighPart;
    };
    struct {
        ULONG   LowPart;
        ULONG   HighPart;
    } u;
    ULONGLONG   QuadPart;
} ULARGE_INTEGER;
typedef ULARGE_INTEGER  *PULARGE_INTEGER;

/* Locally unique identifier */
typedef struct _LUID {
    ULONG   LowPart;
    LONG    HighPart;
} LUID;
typedef LUID    *PLUID;

/* Event types */
typedef enum _EVENT_TYPE {
    NotificationEvent       = 0,
    SynchronizationEvent    = 1
} EVENT_TYPE;

/* Timer types */
typedef enum _TIMER_TYPE {
    NotificationTimer       = 0,
    SynchronizationTimer    = 1
} TIMER_TYPE;

/* Wait types */
typedef enum _WAIT_TYPE {
    WaitAll = 0,
    WaitAny = 1
} WAIT_TYPE;

/* String */
typedef struct _STRING {
    USHORT  Length;
    USHORT  MaximumLength;
    PCHAR   Buffer;
} STRING;
typedef STRING          *PSTRING;
typedef STRING          ANSI_STRING;
typedef PSTRING         PANSI_STRING;
typedef STRING          OEM_STRING;
typedef PSTRING         POEM_STRING;
typedef CONST STRING    *PCOEM_STRING;
typedef STRING          CANSI_STRING;
typedef PSTRING         PCANSI_STRING;

/* Constant string */
typedef struct _CSTRING {
    USHORT      Length;
    USHORT      MaximumLength;
    CONST char  *Buffer;
} CSTRING;
typedef CSTRING *PCSTRING;

/* Unicode string */
typedef struct _UNICODE_STRING {
    USHORT  Length;
    USHORT  MaximumLength;
    PWCH    Buffer;
} UNICODE_STRING;
typedef UNICODE_STRING          *PUNICODE_STRING;
typedef const UNICODE_STRING    *PCUNICODE_STRING;

/* Doubly linked list entry */
typedef struct _LIST_ENTRY {
    struct _LIST_ENTRY  *Flink;
    struct _LIST_ENTRY  *Blink;
} LIST_ENTRY;
typedef LIST_ENTRY  *PLIST_ENTRY;
typedef LIST_ENTRY  *RESTRICTED_POINTER PRLIST_ENTRY;

/* Singly linked list entry */
typedef struct _SINGLE_LIST_ENTRY {
    struct _SINGLE_LIST_ENTRY   *Next;
} SINGLE_LIST_ENTRY;
typedef SINGLE_LIST_ENTRY   *PSINGLE_LIST_ENTRY;

/* Doubly linked list entry (32-bit version) */
typedef struct LIST_ENTRY32 {
    ULONG   Flink;
    ULONG   Blink;
} LIST_ENTRY32;
typedef LIST_ENTRY32    *PLIST_ENTRY32;

/* Doubly linked list entry (64-bit version) */
typedef struct LIST_ENTRY64 {
    ULONGLONG   Flink;
    ULONGLONG   Blink;
} LIST_ENTRY64;
typedef LIST_ENTRY64    *PLIST_ENTRY64;

/* Singly linked list entry (32-bit version) */
typedef struct _SINGLE_LIST_ENTRY32 {
    ULONG   Next;
} SINGLE_LIST_ENTRY32;
typedef SINGLE_LIST_ENTRY32 *PSINGLE_LIST_ENTRY32;

/* String (32-bit version) */
typedef struct _STRING32 {
    USHORT  Length;
    USHORT  MaximumLength;
    ULONG   Buffer;
} STRING32;
typedef STRING32            *PSTRING32;
typedef STRING32            UNICODE_STRING32;
typedef UNICODE_STRING32    *PUNICODE_STRING32;
typedef STRING32            ANSI_STRING32;
typedef ANSI_STRING32       *PANSI_STRING32;

/* String (64-bit version) */
typedef struct _STRING64 {
    USHORT      Length;
    USHORT      MaximumLength;
    ULONGLONG   Buffer;
} STRING64;
typedef STRING64            *PSTRING64;
typedef STRING64            UNICODE_STRING64;
typedef UNICODE_STRING64    *PUNICODE_STRING64;
typedef STRING64            ANSI_STRING64;
typedef ANSI_STRING64       *PANSI_STRING64;

/* Object attributes (64-bit version) */
typedef struct _OBJECT_ATTRIBUTES64 {
    ULONG   Length;
    ULONG64 RootDirectory;
    ULONG64 ObjectName;
    ULONG   Attributes;
    ULONG64 SecurityDescriptor;
    ULONG64 SecurityQualityOfService;
} OBJECT_ATTRIBUTES64;
typedef OBJECT_ATTRIBUTES64         *POBJECT_ATTRIBUTES64;
typedef CONST OBJECT_ATTRIBUTES64   *PCOBJECT_ATTRIBUTES64;

/* Object attributes (32-bit version) */
typedef struct _OBJECT_ATTRIBUTES32 {
    ULONG   Length;
    ULONG   RootDirectory;
    ULONG   ObjectName;
    ULONG   Attributes;
    ULONG   SecurityDescriptor;
    ULONG   SecurityQualityOfService;
} OBJECT_ATTRIBUTES32;
typedef OBJECT_ATTRIBUTES32         *POBJECT_ATTRIBUTES32;
typedef CONST OBJECT_ATTRIBUTES32   *PCOBJECT_ATTRIBUTES32;

/* Object attributes */
typedef struct _OBJECT_ATTRIBUTES {
    ULONG           Length;
    HANDLE          RootDirectory;
    PUNICODE_STRING ObjectName;
    ULONG           Attributes;
    PVOID           SecurityDescriptor;
    PVOID           SecurityQualityOfService;
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES       *POBJECT_ATTRIBUTES;
typedef CONST OBJECT_ATTRIBUTES *PCOBJECT_ATTRIBUTES;

/* NT product types */
typedef enum _NT_PRODUCT_TYPE {
    NtProductWinNt      = 1,
    NtProductLanManNt   = 2,
    NtProductServer     = 3
} NT_PRODUCT_TYPE;
typedef NT_PRODUCT_TYPE *PNT_PRODUCT_TYPE;

/* Suite types */
typedef enum _SUITE_TYPE {
    SmallBusiness           = 0,
    Enterprise              = 1,
    BackOffice              = 2,
    CommunicationServer     = 3,
    TerminalServer          = 4,
    SmallBusinessRestricted = 5,
    EmbeddedNT              = 6,
    DataCenter              = 7,
    SingleUserTS            = 8,
    Personal                = 9,
    Blade                   = 10,
    EmbeddedRestricted      = 11,
    SecurityAppliance       = 12,
    StorageServer           = 13,
    ComputeServer           = 14,
    WHServer                = 15,
    MaxSuiteType            = 16
} SUITE_TYPE;

/* Functions implemented as macros */
#define Int32x32To64( p1, p2 )          ((LONGLONG)(LONG)(p1) * (LONGLONG)(LONG)(p2))
#define UInt32x32To64( p1, p2 )         ((ULONGLONG)(ULONG)(p1) * (ULONGLONG)(ULONG)(p2))
#define Int64ShllMod32( p1, p2 )        ((ULONGLONG)(p1) << (p2))
#define Int64ShraMod32( p1, p2 )        ((LONGLONG)(p1) >> (p2))
#define Int64ShrlMod32( p1, p2 )        ((ULONGLONG)(p1) >> (p2))
#define InitializeObjectAttributes( x, p1, p2, p3, p4 ) \
    { \
        (x)->Length = sizeof( OBJECT_ATTRIBUTES ); \
        (x)->RootDirectory = p3; \
        (x)->Attributes = p2; \
        (x)->ObjectName = p1; \
        (x)->SecurityDescriptor = p4; \
        (x)->SecurityQualityOfService = NULL; \
    }

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDEF_ */
