/*
 *  ntddpar.h   Parallel port device I/O control codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDDPAR_
#define _NTDDPAR_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Paralle port device I/O control codes */
#define IOCTL_PAR_BASE  FILE_DEVICE_PARALLEL_PORT
#define IOCTL_PAR_QUERY_INFORMATION \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 1, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_SET_INFORMATION \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 2, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_QUERY_DEVICE_ID \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 3, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_QUERY_DEVICE_ID_SIZE \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 4, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_IEEE1284_GET_MODE \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 5, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_IEEE1284_NEGOTIATE \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 6, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_SET_WRITE_ADDRESS \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 7, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_SET_READ_ADDRESS \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 8, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_GET_DEVICE_CAPS \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 9, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_GET_DEFAULT_MODES \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 10, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_PING \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 11, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_QUERY_RAW_DEVICE_ID \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 12, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_ECP_HOST_RECOVERY \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 13, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_GET_READ_ADDRESS \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 14, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_GET_WRITE_ADDRESS \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 15, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_TEST \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 20, METHOD_BUFFERED, FILE_ANY_ACCESS )
#define IOCTL_PAR_IS_PORT_FREE \
    CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 21, METHOD_BUFFERED, FILE_ANY_ACCESS )
#if (NTDDI_VERSION >= 0x05010000)
    #define IOCTL_PAR_QUERY_LOCATION \
        CTL_CODE( FILE_DEVICE_PARALLEL_PORT, 22, METHOD_BUFFERED, FILE_ANY_ACCESS )
#endif

/* Parallel flags */
#define PARALLEL_INIT           0x01
#define PARALLEL_AUTOFEED       0x02
#define PARALLEL_PAPER_EMPTY    0x04
#define PARALLEL_OFF_LINE       0x08
#define PARALLEL_POWER_OFF      0x10
#define PARALLEL_NOT_CONNECTED  0x20
#define PARALLEL_BUSY           0x40
#define PARALLEL_SELECTED       0x80

/* Read/write mask flags */
#define NONE                0x0000
#define CENTRONICS          0x0001
#define IEEE_COMPATIBILITY  0x0002
#define NIBBLE              0x0004
#define CHANNEL_NIBBLE      0x0008
#define BYTE_BIDIR          0x0010
#define EPP_HW              0x0020
#define EPP_SW              0x0040
#define EPP_ANY             0x0060
#define BOUNDED_ECP         0x0080
#define ECP_HW_NOIRQ        0x0100
#define ECP_HW_IRQ          0x0200
#define ECP_SW              0x0400
#define ECP_ANY             0x0780

/* Parallel query information */
typedef struct _PAR_QUERY_INFORMATION {
    UCHAR   Status;
} PAR_QUERY_INFORMATION;
typedef PAR_QUERY_INFORMATION   *PPAR_QUERY_INFORMATION;

/* Parallel set information */
typedef struct _PAR_SET_INFORMATION {
    UCHAR   Init;
} PAR_SET_INFORMATION;
typedef PAR_SET_INFORMATION *PPAR_SET_INFORMATION;

/* Parallel device identifier size information */
typedef struct _PAR_DEVICE_ID_SIZE_INFORMATION {
    ULONG   DeviceIdSize;
} PAR_DEVICE_ID_SIZE_INFORMATION;
typedef PAR_DEVICE_ID_SIZE_INFORMATION  *PPAR_DEVICE_ID_SIZE_INFORMATION;

/* Parallel class negotiation mask */
typedef struct _PARCLASS_NEGOTIATION_MASK {
    USHORT  usReadMask;
    USHORT  usWriteMask;
} PARCLASS_NEGOTIATION_MASK;
typedef PARCLASS_NEGOTIATION_MASK   *PPARCLASS_NEGOTIATION_MASK;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDDPAR_ */
