/*
 *  netevent.h  Network event codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NETEVENT_
#define _NETEVENT_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Network event codes */
#define EVENT_SRV_SERVICE_FAILED                            0xC00007D0L
#define EVENT_SRV_RESOURCE_SHORTAGE                         0xC00007D1L
#define EVENT_SRV_CANT_CREATE_DEVICE                        0xC00007D2L
#define EVENT_SRV_CANT_CREATE_PROCESS                       0xC00007D3L
#define EVENT_SRV_CANT_CREATE_THREAD                        0xC00007D4L
#define EVENT_SRV_UNEXPECTED_DISC                           0xC00007D5L
#define EVENT_SRV_INVALID_REQUEST                           0xC00007D6L
#define EVENT_SRV_CANT_OPEN_NPFS                            0xC00007D7L
#define EVENT_SRV_CANT_GROW_TABLE                           0x800007D9L
#define EVENT_SRV_CANT_START_SCAVENGER                      0xC00007DAL
#define EVENT_SRV_IRP_STACK_SIZE                            0xC00007DBL
#define EVENT_SRV_NETWORK_ERROR                             0x800007DCL
#define EVENT_SRV_DISK_FULL                                 0x800007DDL
#define EVENT_SRV_NO_VIRTUAL_MEMORY                         0xC00007E0L
#define EVENT_SRV_NONPAGED_POOL_LIMIT                       0xC00007E1L
#define EVENT_SRV_PAGED_POOL_LIMIT                          0xC00007E2L
#define EVENT_SRV_NO_NONPAGED_POOL                          0xC00007E3L
#define EVENT_SRV_NO_PAGED_POOL                             0xC00007E4L
#define EVENT_SRV_NO_WORK_ITEM                              0x800007E5L
#define EVENT_SRV_NO_FREE_CONNECTIONS                       0x800007E6L
#define EVENT_SRV_NO_FREE_RAW_WORK_ITEM                     0x800007E7L
#define EVENT_SRV_NO_BLOCKING_IO                            0x800007E8L
#define EVENT_SRV_DOS_ATTACK_DETECTED                       0x800007E9L
#define EVENT_SRV_TOO_MANY_DOS                              0x800007EAL
#define EVENT_SRV_OUT_OF_WORK_ITEM_DOS                      0x800007EBL
#define EVENT_SRV_KEY_NOT_FOUND                             0xC00009C5L
#define EVENT_SRV_KEY_NOT_CREATED                           0xC00009C6L
#define EVENT_SRV_NO_TRANSPORTS_BOUND                       0xC00009C7L
#define EVENT_SRV_CANT_BIND_TO_TRANSPORT                    0x800009C8L
#define EVENT_SRV_CANT_BIND_DUP_NAME                        0xC00009C9L
#define EVENT_SRV_INVALID_REGISTRY_VALUE                    0x800009CAL
#define EVENT_SRV_INVALID_SD                                0x800009CBL
#define EVENT_SRV_CANT_LOAD_DRIVER                          0x800009CCL
#define EVENT_SRV_CANT_UNLOAD_DRIVER                        0x800009CDL
#define EVENT_SRV_CANT_MAP_ERROR                            0x800009CEL
#define EVENT_SRV_CANT_RECREATE_SHARE                       0x800009CFL
#define EVENT_SRV_CANT_CHANGE_DOMAIN_NAME                   0x800009D0L
#define EVENT_SRV_TXF_INIT_FAILED                           0x800009D1L
#define EVENT_RDR_RESOURCE_SHORTAGE                         0x80000BB9L
#define EVENT_RDR_CANT_CREATE_DEVICE                        0x80000BBAL
#define EVENT_RDR_CANT_CREATE_THREAD                        0x80000BBBL
#define EVENT_RDR_CANT_SET_THREAD                           0x80000BBCL
#define EVENT_RDR_INVALID_REPLY                             0x80000BBDL
#define EVENT_RDR_INVALID_SMB                               0x80000BBEL
#define EVENT_RDR_INVALID_LOCK_REPLY                        0x80000BBFL
#define EVENT_RDR_FAILED_UNLOCK                             0x80000BC1L
#define EVENT_RDR_CLOSE_BEHIND                              0x80000BC3L
#define EVENT_RDR_UNEXPECTED_ERROR                          0x80000BC4L
#define EVENT_RDR_TIMEOUT                                   0x80000BC5L
#define EVENT_RDR_INVALID_OPLOCK                            0x80000BC6L
#define EVENT_RDR_CONNECTION_REFERENCE                      0x80000BC7L
#define EVENT_RDR_SERVER_REFERENCE                          0x80000BC8L
#define EVENT_RDR_SMB_REFERENCE                             0x80000BC9L
#define EVENT_RDR_ENCRYPT                                   0x80000BCAL
#define EVENT_RDR_CONNECTION                                0x80000BCBL
#define EVENT_RDR_MAXCMDS                                   0x80000BCDL
#define EVENT_RDR_OPLOCK_SMB                                0x80000BCEL
#define EVENT_RDR_DISPOSITION                               0x80000BCFL
#define EVENT_RDR_CONTEXTS                                  0x80000BD0L
#define EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED                 0x80000BD1L
#define EVENT_RDR_AT_THREAD_MAX                             0x80000BD2L
#define EVENT_RDR_CANT_READ_REGISTRY                        0x80000BD3L
#define EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE                   0x80000BD4L
#define EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED          0x80000BD5L
#define EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED             0x80000BD6L
#define EVENT_RDR_DELETEONCLOSE_FAILED                      0x80000BD7L
#define EVENT_RDR_CANT_BIND_TRANSPORT                       0x80000BD8L
#define EVENT_RDR_CANT_REGISTER_ADDRESS                     0x80000BD9L
#define EVENT_RDR_CANT_GET_SECURITY_CONTEXT                 0x80000BDAL
#define EVENT_RDR_CANT_BUILD_SMB_HEADER                     0x80000BDBL
#define EVENT_RDR_SECURITY_SIGNATURE_MISMATCH               0x80000BDCL
#define EVENT_TCPIP6_STARTED                                0x40000C1CL
#define EVENT_STREAMS_STRLOG                                0xC0000FA0L
#define EVENT_STREAMS_ALLOCB_FAILURE                        0x80000FA1L
#define EVENT_STREAMS_ALLOCB_FAILURE_CNT                    0x80000FA2L
#define EVENT_STREAMS_ESBALLOC_FAILURE                      0x80000FA3L
#define EVENT_STREAMS_ESBALLOC_FAILURE_CNT                  0x80000FA4L
#define EVENT_TCPIP_CREATE_DEVICE_FAILED                    0xC0001004L
#define EVENT_TCPIP_NO_RESOURCES_FOR_INIT                   0xC0001005L
#define EVENT_TCPIP_TOO_MANY_NETS                           0xC0001059L
#define EVENT_TCPIP_NO_MASK                                 0xC000105AL
#define EVENT_TCPIP_INVALID_ADDRESS                         0xC000105BL
#define EVENT_TCPIP_INVALID_MASK                            0xC000105CL
#define EVENT_TCPIP_NO_ADAPTER_RESOURCES                    0xC000105DL
#define EVENT_TCPIP_DHCP_INIT_FAILED                        0xC000105EL
#define EVENT_TCPIP_ADAPTER_REG_FAILURE                     0xC000105FL
#define EVENT_TCPIP_INVALID_DEFAULT_GATEWAY                 0x80001060L
#define EVENT_TCPIP_NO_ADDRESS_LIST                         0xC0001061L
#define EVENT_TCPIP_NO_MASK_LIST                            0xC0001062L
#define EVENT_TCPIP_NO_BINDINGS                             0xC0001063L
#define EVENT_TCPIP_IP_INIT_FAILED                          0xC0001064L
#define EVENT_TCPIP_TOO_MANY_GATEWAYS                       0x80001065L
#define EVENT_TCPIP_ADDRESS_CONFLICT1                       0xC0001066L
#define EVENT_TCPIP_ADDRESS_CONFLICT2                       0xC0001067L
#define EVENT_TCPIP_NTE_CONTEXT_LIST_FAILURE                0xC0001068L
#define EVENT_TCPIP_MEDIA_CONNECT                           0x40001069L
#define EVENT_TCPIP_MEDIA_DISCONNECT                        0x4000106AL
#define EVENT_TCPIP_IPV4_UNINSTALLED                        0x4000106BL
#define EVENT_TCPIP_TCP_INIT_FAILED                         0xC0001081L
#define EVENT_TCPIP_TCP_CONNECT_LIMIT_REACHED               0x80001082L
#define EVENT_TCPIP_TCP_TIME_WAIT_COLLISION                 0x80001083L
#define EVENT_TCPIP_TCP_WSD_WS_RESTRICTED                   0x80001084L
#define EVENT_TCPIP_TCP_TCP_MPP_ATTACKS_DETECTED            0x80001085L
#define EVENT_TCPIP_UDP_LIMIT_REACHED                       0x800010A9L
#define EVENT_NBT_CREATE_DRIVER                             0xC00010CCL
#define EVENT_NBT_OPEN_REG_PARAMS                           0xC00010CDL
#define EVENT_NBT_NO_BACKUP_WINS                            0x800010CEL
#define EVENT_NBT_NO_WINS                                   0x800010CFL
#define EVENT_NBT_BAD_BACKUP_WINS_ADDR                      0x800010D0L
#define EVENT_NBT_BAD_PRIMARY_WINS_ADDR                     0x800010D1L
#define EVENT_NBT_NAME_SERVER_ADDRS                         0xC00010D2L
#define EVENT_NBT_CREATE_ADDRESS                            0xC00010D3L
#define EVENT_NBT_CREATE_CONNECTION                         0xC00010D4L
#define EVENT_NBT_NON_OS_INIT                               0xC00010D5L
#define EVENT_NBT_TIMERS                                    0xC00010D6L
#define EVENT_NBT_CREATE_DEVICE                             0xC00010D7L
#define EVENT_NBT_NO_DEVICES                                0xC00010D8L
#define EVENT_NBT_OPEN_REG_LINKAGE                          0xC00010D9L
#define EVENT_NBT_READ_BIND                                 0xC00010DAL
#define EVENT_NBT_READ_EXPORT                               0xC00010DBL
#define EVENT_NBT_OPEN_REG_NAMESERVER                       0x800010DCL
#define EVENT_SCOPE_LABEL_TOO_LONG                          0x800010DDL
#define EVENT_SCOPE_TOO_LONG                                0x800010DEL
#define EVENT_NBT_DUPLICATE_NAME                            0xC00010DFL
#define EVENT_NBT_NAME_RELEASE                              0xC00010E0L
#define EVENT_NBT_DUPLICATE_NAME_ERROR                      0xC00010E1L
#define EVENT_NBT_NO_RESOURCES                              0xC00010E2L
#define EVENT_NDIS_RESOURCE_CONFLICT                        0xC0001388L
#define EVENT_NDIS_OUT_OF_RESOURCE                          0xC0001389L
#define EVENT_NDIS_HARDWARE_FAILURE                         0xC000138AL
#define EVENT_NDIS_ADAPTER_NOT_FOUND                        0xC000138BL
#define EVENT_NDIS_INTERRUPT_CONNECT                        0xC000138CL
#define EVENT_NDIS_DRIVER_FAILURE                           0xC000138DL
#define EVENT_NDIS_BAD_VERSION                              0xC000138EL
#define EVENT_NDIS_TIMEOUT                                  0x8000138FL
#define EVENT_NDIS_NETWORK_ADDRESS                          0xC0001390L
#define EVENT_NDIS_UNSUPPORTED_CONFIGURATION                0xC0001391L
#define EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER               0xC0001392L
#define EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER          0xC0001393L
#define EVENT_NDIS_BAD_IO_BASE_ADDRESS                      0xC0001394L
#define EVENT_NDIS_RECEIVE_SPACE_SMALL                      0x40001395L
#define EVENT_NDIS_ADAPTER_DISABLED                         0x80001396L
#define EVENT_NDIS_IO_PORT_CONFLICT                         0x80001397L
#define EVENT_NDIS_PORT_OR_DMA_CONFLICT                     0x80001398L
#define EVENT_NDIS_MEMORY_CONFLICT                          0x80001399L
#define EVENT_NDIS_INTERRUPT_CONFLICT                       0x8000139AL
#define EVENT_NDIS_DMA_CONFLICT                             0x8000139BL
#define EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR              0xC000139CL
#define EVENT_NDIS_MAXRECEIVES_ERROR                        0x8000139DL
#define EVENT_NDIS_MAXTRANSMITS_ERROR                       0x8000139EL
#define EVENT_NDIS_MAXFRAMESIZE_ERROR                       0x8000139FL
#define EVENT_NDIS_MAXINTERNALBUFS_ERROR                    0x800013A0L
#define EVENT_NDIS_MAXMULTICAST_ERROR                       0x800013A1L
#define EVENT_NDIS_PRODUCTID_ERROR                          0x800013A2L
#define EVENT_NDIS_LOBE_FAILUE_ERROR                        0x800013A3L
#define EVENT_NDIS_SIGNAL_LOSS_ERROR                        0x800013A4L
#define EVENT_NDIS_REMOVE_RECEIVED_ERROR                    0x800013A5L
#define EVENT_NDIS_TOKEN_RING_CORRECTION                    0x400013A6L
#define EVENT_NDIS_ADAPTER_CHECK_ERROR                      0xC00013A7L
#define EVENT_NDIS_RESET_FAILURE_ERROR                      0x800013A8L
#define EVENT_NDIS_CABLE_DISCONNECTED_ERROR                 0x800013A9L
#define EVENT_NDIS_RESET_FAILURE_CORRECTION                 0x800013AAL
#define EVENT_EventlogStarted                               0x80001775L
#define EVENT_EventlogStopped                               0x80001776L
#define EVENT_EventlogAbnormalShutdown                      0x80001778L
#define EVENT_EventLogProductInfo                           0x80001779L
#define EVENT_ComputerNameChange                            0x8000177BL
#define EVENT_DNSDomainNameChange                           0x8000177CL
#define EVENT_EventlogUptime                                0x8000177DL
#define EVENT_UP_DRIVER_ON_MP                               0xC00017D4L
#define EVENT_SERVICE_START_FAILED                          0xC0001B58L
#define EVENT_SERVICE_START_FAILED_II                       0xC0001B59L
#define EVENT_SERVICE_START_FAILED_GROUP                    0xC0001B5AL
#define EVENT_SERVICE_START_FAILED_NONE                     0xC0001B5BL
#define EVENT_CALL_TO_FUNCTION_FAILED                       0xC0001B5DL
#define EVENT_CALL_TO_FUNCTION_FAILED_II                    0xC0001B5EL
#define EVENT_REVERTED_TO_LASTKNOWNGOOD                     0xC0001B5FL
#define EVENT_BAD_ACCOUNT_NAME                              0xC0001B60L
#define EVENT_CONNECTION_TIMEOUT                            0xC0001B61L
#define EVENT_READFILE_TIMEOUT                              0xC0001B62L
#define EVENT_TRANSACT_TIMEOUT                              0xC0001B63L
#define EVENT_TRANSACT_INVALID                              0xC0001B64L
#define EVENT_FIRST_LOGON_FAILED                            0xC0001B65L
#define EVENT_SECOND_LOGON_FAILED                           0xC0001B66L
#define EVENT_INVALID_DRIVER_DEPENDENCY                     0xC0001B67L
#define EVENT_BAD_SERVICE_STATE                             0xC0001B68L
#define EVENT_CIRCULAR_DEPENDENCY_DEMAND                    0xC0001B69L
#define EVENT_CIRCULAR_DEPENDENCY_AUTO                      0xC0001B6AL
#define EVENT_DEPEND_ON_LATER_SERVICE                       0xC0001B6BL
#define EVENT_DEPEND_ON_LATER_GROUP                         0xC0001B6CL
#define EVENT_SEVERE_SERVICE_FAILED                         0xC0001B6DL
#define EVENT_SERVICE_START_HUNG                            0xC0001B6EL
#define EVENT_SERVICE_EXIT_FAILED                           0xC0001B6FL
#define EVENT_SERVICE_EXIT_FAILED_SPECIFIC                  0xC0001B70L
#define EVENT_SERVICE_START_AT_BOOT_FAILED                  0xC0001B71L
#define EVENT_SERVICE_SYSTEM_DRIVERS_FAILED                 0xC0001B72L
#define EVENT_RUNNING_LASTKNOWNGOOD                         0xC0001B73L
#define EVENT_TAKE_OWNERSHIP                                0xC0001B74L
#define EVENT_SC_MESSAGE_BOX                                0xC0001B75L
#define EVENT_SERVICE_NOT_INTERACTIVE                       0xC0001B76L
#define EVENT_SERVICE_CRASH                                 0xC0001B77L
#define EVENT_SERVICE_RECOVERY_FAILED                       0xC0001B78L
#define EVENT_SERVICE_SCESRV_FAILED                         0xC0001B79L
#define EVENT_SERVICE_CRASH_NO_ACTION                       0xC0001B7AL
#define EVENT_SERVICE_CONTROL_SUCCESS                       0x40001B7BL
#define EVENT_SERVICE_STATUS_SUCCESS                        0x40001B7CL
#define EVENT_SERVICE_CONFIG_BACKOUT_FAILED                 0xC0001B7DL
#define EVENT_FIRST_LOGON_FAILED_II                         0xC0001B7EL
#define EVENT_SERVICE_DIFFERENT_PID_CONNECTED               0x80001B7FL
#define EVENT_SERVICE_START_TYPE_CHANGED                    0x40001B80L
#define EVENT_SERVICE_LOGON_TYPE_NOT_GRANTED                0xC0001B81L
#define EVENT_SERVICE_STOP_SUCCESS_WITH_REASON              0x40001B82L
#define EVENT_SERVICE_SHUTDOWN_FAILED                       0xC0001B83L
#define EVENT_COMMAND_NOT_INTERACTIVE                       0xC0001EDCL
#define EVENT_COMMAND_START_FAILED                          0xC0001EDDL
#define EVENT_BOWSER_OTHER_MASTER_ON_NET                    0xC0001F43L
#define EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER          0x80001F44L
#define EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE             0x80001F45L
#define EVENT_BOWSER_ILLEGAL_DATAGRAM                       0x80001F46L
#define EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED             0xC0001F47L
#define EVENT_BROWSER_ROLE_CHANGE_FAILED                    0xC0001F48L
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED               0xC0001F49L
#define EVENT_BOWSER_NAME_CONVERSION_FAILED                 0xC0001F4AL
#define EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED                0xC0001F4BL
#define EVENT_BOWSER_ELECTION_RECEIVED                      0xC0001F4CL
#define EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED          0x40001F4DL
#define EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED       0x40001F4EL
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED       0x40001F4FL
#define EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD             0xC0001F50L
#define EVENT_BROWSER_DEPENDENT_SERVICE_FAILED              0xC0001F51L
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING      0xC0001F53L
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER     0xC0001F54L
#define EVENT_BROWSER_SERVER_LIST_FAILED                    0x80001F55L
#define EVENT_BROWSER_DOMAIN_LIST_FAILED                    0x80001F56L
#define EVENT_BROWSER_ILLEGAL_CONFIG                        0x80001F57L
#define EVENT_BOWSER_OLD_BACKUP_FOUND                       0x40001F58L
#define EVENT_BROWSER_SERVER_LIST_RETRIEVED                 0x00001F59L
#define EVENT_BROWSER_DOMAIN_LIST_RETRIEVED                 0x00001F5AL
#define EVENT_BOWSER_PDC_LOST_ELECTION                      0x40001F5BL
#define EVENT_BOWSER_NON_PDC_WON_ELECTION                   0x40001F5CL
#define EVENT_BOWSER_CANT_READ_REGISTRY                     0x40001F5DL
#define EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED   0x40001F5EL
#define EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED      0x40001F5FL
#define EVENT_BROWSER_BACKUP_STOPPED                        0xC0001F60L
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED       0x40001F61L
#define EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER          0xC0001F62L
#define EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED            0x40001F63L
#define EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH       0xC0001F64L
#define NWSAP_EVENT_KEY_NOT_FOUND                           0xC0002134L
#define NWSAP_EVENT_WSASTARTUP_FAILED                       0xC0002135L
#define NWSAP_EVENT_SOCKET_FAILED                           0xC0002136L
#define NWSAP_EVENT_SETOPTBCAST_FAILED                      0xC0002137L
#define NWSAP_EVENT_BIND_FAILED                             0xC0002138L
#define NWSAP_EVENT_GETSOCKNAME_FAILED                      0xC0002139L
#define NWSAP_EVENT_OPTEXTENDEDADDR_FAILED                  0xC000213AL
#define NWSAP_EVENT_OPTBCASTINADDR_FAILED                   0xC000213BL
#define NWSAP_EVENT_CARDMALLOC_FAILED                       0xC000213CL
#define NWSAP_EVENT_NOCARDS                                 0xC000213DL
#define NWSAP_EVENT_THREADEVENT_FAIL                        0xC000213EL
#define NWSAP_EVENT_RECVSAM_FAIL                            0xC000213FL
#define NWSAP_EVENT_SENDEVENT_FAIL                          0xC0002140L
#define NWSAP_EVENT_STARTRECEIVE_ERROR                      0xC0002141L
#define NWSAP_EVENT_STARTWORKER_ERROR                       0xC0002142L
#define NWSAP_EVENT_TABLE_MALLOC_FAILED                     0xC0002143L
#define NWSAP_EVENT_HASHTABLE_MALLOC_FAILED                 0xC0002144L
#define NWSAP_EVENT_STARTLPCWORKER_ERROR                    0xC0002145L
#define NWSAP_EVENT_CREATELPCPORT_ERROR                     0xC0002146L
#define NWSAP_EVENT_CREATELPCEVENT_ERROR                    0xC0002147L
#define NWSAP_EVENT_LPCLISTENMEMORY_ERROR                   0xC0002148L
#define NWSAP_EVENT_LPCHANDLEMEMORY_ERROR                   0xC0002149L
#define NWSAP_EVENT_BADWANFILTER_VALUE                      0xC000214AL
#define NWSAP_EVENT_CARDLISTEVENT_FAIL                      0xC000214BL
#define NWSAP_EVENT_SDMDEVENT_FAIL                          0xC000214CL
#define NWSAP_EVENT_INVALID_FILTERNAME                      0xC000214DL
#define NWSAP_EVENT_WANSEM_FAIL                             0xC000214EL
#define NWSAP_EVENT_WANSOCKET_FAILED                        0xC000214FL
#define NWSAP_EVENT_WANBIND_FAILED                          0xC0002150L
#define NWSAP_EVENT_STARTWANWORKER_ERROR                    0xC0002151L
#define NWSAP_EVENT_STARTWANCHECK_ERROR                     0xC0002152L
#define NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR                  0xC0002153L
#define NWSAP_EVENT_WANHANDLEMEMORY_ERROR                   0xC0002154L
#define NWSAP_EVENT_WANEVENT_ERROR                          0xC0002155L
#define EVENT_TRANSPORT_RESOURCE_POOL                       0x80002329L
#define EVENT_TRANSPORT_RESOURCE_LIMIT                      0x8000232AL
#define EVENT_TRANSPORT_RESOURCE_SPECIFIC                   0x8000232BL
#define EVENT_TRANSPORT_REGISTER_FAILED                     0xC000232CL
#define EVENT_TRANSPORT_BINDING_FAILED                      0xC000232DL
#define EVENT_TRANSPORT_ADAPTER_NOT_FOUND                   0xC000232EL
#define EVENT_TRANSPORT_SET_OID_FAILED                      0xC000232FL
#define EVENT_TRANSPORT_QUERY_OID_FAILED                    0xC0002330L
#define EVENT_TRANSPORT_TRANSFER_DATA                       0x40002331L
#define EVENT_TRANSPORT_TOO_MANY_LINKS                      0x40002332L
#define EVENT_TRANSPORT_BAD_PROTOCOL                        0x40002333L
#define EVENT_IPX_NEW_DEFAULT_TYPE                          0x4000251DL
#define EVENT_IPX_SAP_ANNOUNCE                              0x8000251EL
#define EVENT_IPX_ILLEGAL_CONFIG                            0x8000251FL
#define EVENT_IPX_INTERNAL_NET_INVALID                      0xC0002520L
#define EVENT_IPX_NO_FRAME_TYPES                            0xC0002521L
#define EVENT_IPX_CREATE_DEVICE                             0xC0002522L
#define EVENT_IPX_NO_ADAPTERS                               0xC0002523L
#define EVENT_RPCSS_CREATEPROCESS_FAILURE                   0xC0002710L
#define EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE             0xC0002711L
#define EVENT_RPCSS_LAUNCH_ACCESS_DENIED                    0xC0002712L
#define EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED            0xC0002713L
#define EVENT_RPCSS_RUNAS_CANT_LOGIN                        0xC0002714L
#define EVENT_RPCSS_START_SERVICE_FAILURE                   0xC0002715L
#define EVENT_RPCSS_REMOTE_SIDE_ERROR                       0xC0002716L
#define EVENT_RPCSS_ACTIVATION_ERROR                        0xC0002717L
#define EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE             0xC0002718L
#define EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE                 0xC0002719L
#define EVENT_RPCSS_SERVER_START_TIMEOUT                    0xC000271AL
#define EVENT_RPCSS_SERVER_NOT_RESPONDING                   0xC000271BL
#define EVENT_DCOM_ASSERTION_FAILURE                        0xC000271CL
#define EVENT_DCOM_INVALID_ENDPOINT_DATA                    0xC000271DL
#define EVENT_DCOM_COMPLUS_DISABLED                         0xC000271EL
#define EVENT_DNS_CACHE_START_FAILURE_NO_DLL                0xC0002AF8L
#define EVENT_DNS_CACHE_START_FAILURE_NO_ENTRY              0xC0002AF9L
#define EVENT_DNS_CACHE_START_FAILURE_NO_CONTROL            0xC0002AFAL
#define EVENT_DNS_CACHE_START_FAILURE_NO_DONE_EVENT         0xC0002AFBL
#define EVENT_DNS_CACHE_START_FAILURE_NO_RPC                0xC0002AFCL
#define EVENT_DNS_CACHE_START_FAILURE_NO_SHUTDOWN_NOTIFY    0xC0002AFDL
#define EVENT_DNS_CACHE_START_FAILURE_NO_UPDATE             0xC0002AFEL
#define EVENT_DNS_CACHE_START_FAILURE_LOW_MEMORY            0xC0002AFFL
#define EVENT_DNS_CACHE_NETWORK_PERF_WARNING                0x80002B2AL
#define EVENT_DNS_CACHE_UNABLE_TO_REACH_SERVER_WARNING      0x80002B2BL
#define EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT            0x80002B8EL
#define EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL         0x80002B8FL
#define EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP            0x80002B90L
#define EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED            0x80002B91L
#define EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY           0x80002B92L
#define EVENT_DNSAPI_REGISTRATION_FAILED_OTHER              0x80002B93L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_TIMEOUT        0x80002B94L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SERVERFAIL     0x80002B95L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_NOTSUPP        0x80002B96L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_REFUSED        0x80002B97L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_SECURITY       0x80002B98L
#define EVENT_DNSAPI_PTR_REGISTRATION_FAILED_OTHER          0x80002B99L
#define EVENT_DNSAPI_REGISTRATION_FAILED_TIMEOUT_PRIMARY_DN 0x80002B9AL
#define EVENT_DNSAPI_REGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN  0x80002B9BL
#define EVENT_DNSAPI_REGISTRATION_FAILED_NOTSUPP_PRIMARY_DN 0x80002B9CL
#define EVENT_DNSAPI_REGISTRATION_FAILED_REFUSED_PRIMARY_DN 0x80002B9DL
#define EVENT_DNSAPI_REGISTRATION_FAILED_SECURITY_PRIMARY_DN    0x80002B9EL
#define EVENT_DNSAPI_REGISTRATION_FAILED_OTHER_PRIMARY_DN   0x80002B9FL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT          0x80002BACL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL       0x80002BADL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP          0x80002BAEL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED          0x80002BAFL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY         0x80002BB0L
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER            0x80002BB1L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_TIMEOUT      0x80002BB2L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SERVERFAIL   0x80002BB3L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_NOTSUPP      0x80002BB4L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_REFUSED      0x80002BB5L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_SECURITY     0x80002BB6L
#define EVENT_DNSAPI_PTR_DEREGISTRATION_FAILED_OTHER        0x80002BB7L
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_TIMEOUT_PRIMARY_DN   0x80002BB8L
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SERVERFAIL_PRIMARY_DN    0x80002BB9L
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_NOTSUPP_PRIMARY_DN   0x80002BBAL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_REFUSED_PRIMARY_DN   0x80002BBBL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_SECURITY_PRIMARY_DN  0x80002BBCL
#define EVENT_DNSAPI_DEREGISTRATION_FAILED_OTHER_PRIMARY_DN 0x80002BBDL
#define EVENT_DNSAPI_REGISTERED_ADAPTER                     0x40002BC0L
#define EVENT_DNSAPI_REGISTERED_PTR                         0x40002BC1L
#define EVENT_DNSAPI_REGISTERED_ADAPTER_PRIMARY_DN          0x40002BC2L
#define EVENT_WMI_CANT_OPEN_DEVICE                          0xC0002EE0L
#define EVENT_WMI_INVALID_MOF                               0x80002F44L
#define EVENT_WMI_MOF_LOAD_FAILURE                          0x80002F45L
#define EVENT_WMI_INVALID_REGINFO                           0x80002F46L
#define EVENT_WMI_INVALID_REGPATH                           0x80002F47L
#define EVENT_WMI_CANT_RESOLVE_INSTANCE                     0x80002F48L
#define EVENT_WMI_CANT_GET_EVENT_DATA                       0x80002F49L
#define EVENT_TRK_INTERNAL_ERROR                            0xC00030D4L
#define EVENT_TRK_SERVICE_START_SUCCESS                     0x400030D5L
#define EVENT_TRK_SERVICE_START_FAILURE                     0xC00030D6L
#define EVENT_TRK_SERVICE_CORRUPT_LOG                       0xC00030D7L
#define EVENT_TRK_SERVICE_VOL_QUOTA_EXCEEDED                0x800030D8L
#define EVENT_TRK_SERVICE_VOLUME_CREATE                     0x400030D9L
#define EVENT_TRK_SERVICE_VOLUME_CLAIM                      0x400030DAL
#define EVENT_TRK_SERVICE_DUPLICATE_VOLIDS                  0x400030DBL
#define EVENT_TRK_SERVICE_MOVE_QUOTA_EXCEEDED               0x800030DCL
#define EVENT_FRS_ERROR                                     0xC00034BCL
#define EVENT_FRS_STARTING                                  0x400034BDL
#define EVENT_FRS_STOPPING                                  0x400034BEL
#define EVENT_FRS_STOPPED                                   0x400034BFL
#define EVENT_FRS_STOPPED_FORCE                             0xC00034C0L
#define EVENT_FRS_STOPPED_ASSERT                            0xC00034C1L
#define EVENT_FRS_ASSERT                                    0xC00034C2L
#define EVENT_FRS_VOLUME_NOT_SUPPORTED                      0xC00034C3L
#define EVENT_FRS_LONG_JOIN                                 0x800034C4L
#define EVENT_FRS_LONG_JOIN_DONE                            0x800034C5L
#define EVENT_FRS_CANNOT_COMMUNICATE                        0xC00034C6L
#define EVENT_FRS_DATABASE_SPACE                            0xC00034C7L
#define EVENT_FRS_DISK_WRITE_CACHE_ENABLED                  0x800034C8L
#define EVENT_FRS_JET_1414                                  0xC00034C9L
#define EVENT_FRS_SYSVOL_NOT_READY                          0x800034CAL
#define EVENT_FRS_SYSVOL_NOT_READY_PRIMARY                  0x800034CBL
#define EVENT_FRS_SYSVOL_READY                              0x400034CCL
#define EVENT_FRS_ACCESS_CHECKS_DISABLED                    0x800034CDL
#define EVENT_FRS_ACCESS_CHECKS_FAILED_USER                 0x800034CEL
#define EVENT_FRS_ACCESS_CHECKS_FAILED_UNKNOWN              0xC00034CFL
#define EVENT_FRS_MOVED_PREEXISTING                         0x800034D0L
#define EVENT_FRS_CANNOT_START_BACKUP_RESTORE_IN_PROGRESS   0xC00034D1L
#define EVENT_FRS_STAGING_AREA_FULL                         0x800034D2L
#define EVENT_FRS_HUGE_FILE                                 0x800034D3L
#define EVENT_FRS_CANNOT_CREATE_UUID                        0xC00034D4L
#define EVENT_FRS_NO_DNS_ATTRIBUTE                          0x800034D5L
#define EVENT_FRS_NO_SID                                    0xC00034D6L
#define NTFRSPRF_OPEN_RPC_BINDING_ERROR_SET                 0xC00034D7L
#define NTFRSPRF_OPEN_RPC_BINDING_ERROR_CONN                0xC00034D8L
#define NTFRSPRF_OPEN_RPC_CALL_ERROR_SET                    0xC00034D9L
#define NTFRSPRF_OPEN_RPC_CALL_ERROR_CONN                   0xC00034DAL
#define NTFRSPRF_COLLECT_RPC_BINDING_ERROR_SET              0xC00034DBL
#define NTFRSPRF_COLLECT_RPC_BINDING_ERROR_CONN             0xC00034DCL
#define NTFRSPRF_COLLECT_RPC_CALL_ERROR_SET                 0xC00034DDL
#define NTFRSPRF_COLLECT_RPC_CALL_ERROR_CONN                0xC00034DEL
#define NTFRSPRF_VIRTUALALLOC_ERROR_SET                     0xC00034DFL
#define NTFRSPRF_VIRTUALALLOC_ERROR_CONN                    0xC00034E0L
#define NTFRSPRF_REGISTRY_ERROR_SET                         0xC00034E1L
#define NTFRSPRF_REGISTRY_ERROR_CONN                        0xC00034E2L
#define EVENT_FRS_ROOT_NOT_VALID                            0xC00034E3L
#define EVENT_FRS_STAGE_NOT_VALID                           0xC00034E4L
#define EVENT_FRS_OVERLAPS_LOGGING                          0xC00034E5L
#define EVENT_FRS_OVERLAPS_WORKING                          0xC00034E6L
#define EVENT_FRS_OVERLAPS_STAGE                            0xC00034E7L
#define EVENT_FRS_OVERLAPS_ROOT                             0xC00034E8L
#define EVENT_FRS_OVERLAPS_OTHER_STAGE                      0xC00034E9L
#define EVENT_FRS_PREPARE_ROOT_FAILED                       0xC00034EAL
#define EVENT_FRS_BAD_REG_DATA                              0x800034EBL
#define EVENT_FRS_JOIN_FAIL_TIME_SKEW                       0xC00034ECL
#define EVENT_FRS_RMTCO_TIME_SKEW                           0xC00034EDL
#define EVENT_FRS_CANT_OPEN_STAGE                           0xC00034EEL
#define EVENT_FRS_CANT_OPEN_PREINSTALL                      0xC00034EFL
#define EVENT_FRS_REPLICA_SET_CREATE_FAIL                   0xC00034F0L
#define EVENT_FRS_REPLICA_SET_CREATE_OK                     0x400034F1L
#define EVENT_FRS_REPLICA_SET_SET_CXTIONS                   0x400034F2L
#define EVENT_FRS_IN_ERROR_STATE                            0xC00034F3L
#define EVENT_FRS_REPLICA_NO_ROOT_CHANGE                    0xC00034F4L
#define EVENT_FRS_DUPLICATE_IN_CXTION_SYSVOL                0xC00034F5L
#define EVENT_FRS_DUPLICATE_IN_CXTION                       0xC00034F6L
#define EVENT_FRS_ROOT_HAS_MOVED                            0xC00034F7L
#define EVENT_FRS_ERROR_REPLICA_SET_DELETED                 0x800034F8L
#define EVENT_FRS_REPLICA_IN_JRNL_WRAP_ERROR                0xC00034F9L
#define EVENT_FRS_DS_POLL_ERROR_SUMMARY                     0x800034FAL
#define EVENT_PS_GPC_REGISTER_FAILED                        0xC00036B0L
#define EVENT_PS_NO_RESOURCES_FOR_INIT                      0xC00036B1L
#define EVENT_PS_REGISTER_PROTOCOL_FAILED                   0xC00036B2L
#define EVENT_PS_REGISTER_MINIPORT_FAILED                   0xC00036B3L
#define EVENT_PS_BAD_BESTEFFORT_LIMIT                       0x80003714L
#define EVENT_PS_QUERY_OID_GEN_MAXIMUM_FRAME_SIZE           0xC0003715L
#define EVENT_PS_QUERY_OID_GEN_MAXIMUM_TOTAL_SIZE           0xC0003716L
#define EVENT_PS_QUERY_OID_GEN_LINK_SPEED                   0xC0003717L
#define EVENT_PS_BINDING_FAILED                             0xC0003718L
#define EVENT_PS_MISSING_ADAPTER_REGISTRY_DATA              0xC0003719L
#define EVENT_PS_REGISTER_ADDRESS_FAMILY_FAILED             0xC000371AL
#define EVENT_PS_INIT_DEVICE_FAILED                         0xC000371BL
#define EVENT_PS_WMI_INSTANCE_NAME_FAILED                   0xC000371CL
#define EVENT_PS_WAN_LIMITED_BESTEFFORT                     0x8000371DL
#define EVENT_PS_RESOURCE_POOL                              0xC000371EL
#define EVENT_PS_ADMISSIONCONTROL_OVERFLOW                  0x8000371FL
#define EVENT_PS_NETWORK_ADDRESS_FAIL                       0xC0003720L
#define EXTRA_EXIT_POINT                                    0xC00037DCL
#define MISSING_EXIT_POINT                                  0xC00037DDL
#define MISSING_VOLUME                                      0xC00037DEL
#define EXTRA_VOLUME                                        0xC00037DFL
#define EXTRA_EXIT_POINT_DELETED                            0xC00037E0L
#define EXTRA_EXIT_POINT_NOT_DELETED                        0xC00037E1L
#define MISSING_EXIT_POINT_CREATED                          0xC00037E2L
#define MISSING_EXIT_POINT_NOT_CREATED                      0xC00037E3L
#define MISSING_VOLUME_CREATED                              0xC00037E4L
#define MISSING_VOLUME_NOT_CREATED                          0xC00037E5L
#define EXTRA_VOLUME_DELETED                                0xC00037E6L
#define EXTRA_VOLUME_NOT_DELETED                            0xC00037E7L
#define COULD_NOT_VERIFY_VOLUMES                            0xC00037E8L
#define KNOWLEDGE_INCONSISTENCY_DETECTED                    0xC00037E9L
#define PREFIX_MISMATCH                                     0xC00037EAL
#define PREFIX_MISMATCH_FIXED                               0xC00037EBL
#define PREFIX_MISMATCH_NOT_FIXED                           0xC00037ECL
#define MACHINE_UNJOINED                                    0xC00037EDL
#define DFS_REFERRAL_REQUEST                                0x400037EEL
#define NOT_A_DFS_PATH                                      0x40003840L
#define LM_REDIR_FAILURE                                    0x40003841L
#define DFS_CONNECTION_FAILURE                              0x40003842L
#define DFS_REFERRAL_FAILURE                                0x40003843L
#define DFS_REFERRAL_SUCCESS                                0x40003844L
#define DFS_MAX_DNR_ATTEMPTS                                0x40003845L
#define DFS_SPECIAL_REFERRAL_FAILURE                        0x40003846L
#define DFS_OPEN_FAILURE                                    0x40003847L
#define NET_DFS_ENUM                                        0x400038A4L
#define NET_DFS_ENUMEX                                      0x400038A5L
#define DFS_ERROR_CREATE_REPARSEPOINT_FAILURE               0xC00038A7L
#define DFS_ERROR_UNSUPPORTED_FILESYSTEM                    0xC00038A8L
#define DFS_ERROR_OVERLAPPING_DIRECTORIES                   0xC00038A9L
#define DFS_INFO_ACTIVEDIRECTORY_ONLINE                     0x400038ACL
#define DFS_ERROR_TOO_MANY_ERRORS                           0xC00038ADL
#define DFS_ERROR_WINSOCKINIT_FAILED                        0xC00038AEL
#define DFS_ERROR_SECURITYINIT_FAILED                       0xC00038AFL
#define DFS_ERROR_THREADINIT_FAILED                         0xC00038B0L
#define DFS_ERROR_SITECACHEINIT_FAILED                      0xC00038B1L
#define DFS_ERROR_ROOTSYNCINIT_FAILED                       0xC00038B2L
#define DFS_ERROR_CREATEEVENT_FAILED                        0xC00038B3L
#define DFS_ERROR_COMPUTERINFO_FAILED                       0xC00038B4L
#define DFS_ERROR_CLUSTERINFO_FAILED                        0xC00038B5L
#define DFS_ERROR_DCINFO_FAILED                             0xC00038B6L
#define DFS_ERROR_PREFIXTABLE_FAILED                        0xC00038B7L
#define DFS_ERROR_HANDLENAMESPACE_FAILED                    0xC00038B8L
#define DFS_ERROR_REGISTERSTORE_FAILED                      0xC00038B9L
#define DFS_ERROR_REFLECTIONENGINE_FAILED                   0xC00038BAL
#define DFS_ERROR_ACTIVEDIRECTORY_OFFLINE                   0xC00038BBL
#define DFS_ERROR_SITESUPPOR_FAILED                         0xC00038BCL
#define DFS_ERROR_DSCONNECT_FAILED                          0x800038BEL
#define DFS_INFO_DS_RECONNECTED                             0x400038C1L
#define DFS_ERROR_NO_DFS_DATA                               0xC00038C2L
#define DFS_INFO_FINISH_INIT                                0x400038C3L
#define DFS_INFO_RECONNECT_DATA                             0x400038C4L
#define DFS_INFO_FINISH_BUILDING_NAMESPACE                  0x400038C5L
#define DFS_ERROR_ON_ROOT                                   0x800038C6L
#define DFS_ERROR_MULTIPLE_ROOTS_NOT_SUPPORTED              0xC00038C7L
#define DFS_WARN_DOMAIN_REFERRAL_OVERFLOW                   0x800038C8L
#define DFS_INFO_DOMAIN_REFERRAL_MIN_OVERFLOW               0x400038C9L
#define DFS_WARN_INCOMPLETE_MOVE                            0x800038CAL
#define DFS_ERROR_RESYNCHRONIZE_FAILED                      0xC00038CBL
#define DFS_ERROR_REMOVE_LINK_FAILED                        0xC00038CCL
#define DFS_WARN_METADATA_LINK_TYPE_INCORRECT               0x800038CDL
#define DFS_WARN_METADATA_LINK_INFO_INVALID                 0x800038CEL
#define DFS_ERROR_TARGET_LIST_INCORRECT                     0xC00038CFL
#define DFS_ERROR_LINKS_OVERLAP                             0xC00038D0L
#define DFS_ERROR_LINK_OVERLAP                              0xC00038D1L
#define DFS_ERROR_CREATE_REPARSEPOINT_SUCCESS               0xC00038D2L
#define DFS_ERROR_DUPLICATE_LINK                            0xC00038D3L
#define DFS_ERROR_TRUSTED_DOMAIN_INFO_FAILED                0xC00038D4L
#define DFS_ERROR_TRUSTED_DOMAIN_INFO_SUCCESS               0xC00038D5L
#define DFS_ERROR_CROSS_FOREST_TRUST_INFO_FAILED            0xC00038D6L
#define DFS_ERROR_CROSS_FOREST_TRUST_INFO_SUCCESS           0xC00038D7L
#define EVENT_BRIDGE_PROTOCOL_REGISTER_FAILED               0xC0003908L
#define EVENT_BRIDGE_MINIPROT_DEVNAME_MISSING               0xC0003909L
#define EVENT_BRIDGE_MINIPORT_REGISTER_FAILED               0xC000390AL
#define EVENT_BRIDGE_DEVICE_CREATION_FAILED                 0xC000390BL
#define EVENT_BRIDGE_NO_BRIDGE_MAC_ADDR                     0xC000390CL
#define EVENT_BRIDGE_MINIPORT_INIT_FAILED                   0xC000390DL
#define EVENT_BRIDGE_ETHERNET_NOT_OFFERED                   0xC000390EL
#define EVENT_BRIDGE_THREAD_CREATION_FAILED                 0xC000390FL
#define EVENT_BRIDGE_THREAD_REF_FAILED                      0xC0003910L
#define EVENT_BRIDGE_PACKET_POOL_CREATION_FAILED            0xC0003911L
#define EVENT_BRIDGE_BUFFER_POOL_CREATION_FAILED            0xC0003912L
#define EVENT_BRIDGE_INIT_MALLOC_FAILED                     0xC0003913L
#define EVENT_BRIDGE_ADAPTER_LINK_SPEED_QUERY_FAILED        0xC000396CL
#define EVENT_BRIDGE_ADAPTER_MAC_ADDR_QUERY_FAILED          0xC000396DL
#define EVENT_BRIDGE_ADAPTER_FILTER_FAILED                  0xC000396EL
#define EVENT_BRIDGE_ADAPTER_NAME_QUERY_FAILED              0xC000396FL
#define EVENT_BRIDGE_ADAPTER_BIND_FAILED                    0xC0003970L
#define EVENT_DAV_REDIR_DELAYED_WRITE_FAILED                0x800039D0L
#define EVENT_WEBCLIENT_CLOSE_PUT_FAILED                    0x80003A35L
#define EVENT_WEBCLIENT_CLOSE_DELETE_FAILED                 0x80003A36L
#define EVENT_WEBCLIENT_CLOSE_PROPPATCH_FAILED              0x80003A37L
#define EVENT_WEBCLIENT_SETINFO_PROPPATCH_FAILED            0x80003A38L
#define EVENT_WSK_OWNINGTHREAD_PARAMETER_IGNORED            0xC0003E80L
#define EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_NO_CHANGE    0x40004074L
#define EVENT_EQOS_INFO_MACHINE_POLICY_REFRESH_WITH_CHANGE  0x40004075L
#define EVENT_EQOS_INFO_USER_POLICY_REFRESH_NO_CHANGE       0x40004076L
#define EVENT_EQOS_INFO_USER_POLICY_REFRESH_WITH_CHANGE     0x40004077L
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_NOT_CONFIGURED       0x40004078L
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_OFF                  0x40004079L
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_HIGHLY_RESTRICTED    0x4000407AL
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_RESTRICTED           0x4000407BL
#define EVENT_EQOS_INFO_TCP_AUTOTUNING_NORMAL               0x4000407CL
#define EVENT_EQOS_INFO_APP_MARKING_NOT_CONFIGURED          0x4000407DL
#define EVENT_EQOS_INFO_APP_MARKING_IGNORED                 0x4000407EL
#define EVENT_EQOS_INFO_APP_MARKING_ALLOWED                 0x4000407FL
#define EVENT_EQOS_INFO_LOCAL_SETTING_DONT_USE_NLA          0x40004080L
#define EVENT_EQOS_URL_QOS_APPLICATION_CONFLICT             0x40004081L
#define EVENT_EQOS_WARNING_TEST_1                           0x800040D8L
#define EVENT_EQOS_WARNING_TEST_2                           0x800040D9L
#define EVENT_EQOS_WARNING_MACHINE_POLICY_VERSION           0x800040DAL
#define EVENT_EQOS_WARNING_USER_POLICY_VERSION              0x800040DBL
#define EVENT_EQOS_WARNING_MACHINE_POLICY_PROFILE_NOT_SPECIFIED 0x800040DCL
#define EVENT_EQOS_WARNING_USER_POLICY_PROFILE_NOT_SPECIFIED    0x800040DDL
#define EVENT_EQOS_WARNING_MACHINE_POLICY_PROFILE_QUOTA_EXCEEDED    0x800040DEL
#define EVENT_EQOS_WARNING_USER_POLICY_PROFILE_QUOTA_EXCEEDED   0x800040DFL
#define EVENT_EQOS_WARNING_MACHINE_POLICY_CONFLICT          0x800040E0L
#define EVENT_EQOS_WARNING_USER_POLICY_CONFLICT             0x800040E1L
#define EVENT_EQOS_WARNING_MACHINE_POLICY_NO_FULLPATH_APPNAME   0x800040E2L
#define EVENT_EQOS_WARNING_USER_POLICY_NO_FULLPATH_APPNAME  0x800040E3L
#define EVENT_EQOS_ERROR_MACHINE_POLICY_REFRESH             0xC000413CL
#define EVENT_EQOS_ERROR_USER_POLICY_REFRESH                0xC000413DL
#define EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_ROOT_KEY    0xC000413EL
#define EVENT_EQOS_ERROR_OPENING_USER_POLICY_ROOT_KEY       0xC000413FL
#define EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_TOO_LONG    0xC0004140L
#define EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_TOO_LONG       0xC0004141L
#define EVENT_EQOS_ERROR_MACHINE_POLICY_KEYNAME_SIZE_ZERO   0xC0004142L
#define EVENT_EQOS_ERROR_USER_POLICY_KEYNAME_SIZE_ZERO      0xC0004143L
#define EVENT_EQOS_ERROR_OPENING_MACHINE_POLICY_SUBKEY      0xC0004144L
#define EVENT_EQOS_ERROR_OPENING_USER_POLICY_SUBKEY         0xC0004145L
#define EVENT_EQOS_ERROR_PROCESSING_MACHINE_POLICY_FIELD    0xC0004146L
#define EVENT_EQOS_ERROR_PROCESSING_USER_POLICY_FIELD       0xC0004147L
#define EVENT_EQOS_ERROR_SETTING_TCP_AUTOTUNING             0xC0004148L
#define EVENT_EQOS_ERROR_SETTING_APP_MARKING                0xC0004149L

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NETEVENT_ */
