/*
 *  kbdmou.h    Keyboard and mouse definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _KBDMOU_
#define _KBDMOU_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ntddkbd.h>
#include <ntddmou.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Keyboard and mouse device names */
#define DD_KEYBOARD_PORT_DEVICE_NAME                    "\\Device\\KeyboardPort"
#define DD_KEYBOARD_PORT_DEVICE_NAME_U                  L"\\Device\\KeyboardPort"
#define DD_KEYBOARD_PORT_BASE_NAME_U                    L"KeyboardPort"
#define DD_POINTER_PORT_DEVICE_NAME                     "\\Device\\PointerPort"
#define DD_POINTER_PORT_DEVICE_NAME_U                   L"\\Device\\PointerPort"
#define DD_POINTER_PORT_BASE_NAME_U                     L"PointerPort"
#define DD_KEYBOARD_CLASS_BASE_NAME_U                   L"KeyboardClass"
#define DD_POINTER_CLASS_BASE_NAME_U                    L"PointerClass"
#define DD_KEYBOARD_RESOURCE_CLASS_NAME_U               L"Keyboard"
#define DD_POINTER_RESOURCE_CLASS_NAME_U                L"Pointer"
#define DD_KEYBOARD_MOUSE_COMBO_RESOURCE_CLASS_NAME_U   L"Keyboard/Pointer"

/* Maximum number of ports */
#define POINTER_PORTS_MAXIMUM   8
#define KEYBOARD_PORTS_MAXIMUM  8

/* Keyboard internal device I/O control codes */
#define IOCTL_INTERNAL_KEYBOARD_CONNECT \
    CTL_CODE( FILE_DEVICE_KEYBOARD, 0x0080, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_KEYBOARD_DISCONNECT \
    CTL_CODE( FILE_DEVICE_KEYBOARD, 0x0100, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_KEYBOARD_ENABLE \
    CTL_CODE( FILE_DEVICE_KEYBOARD, 0x0200, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_KEYBOARD_DISABLE \
    CTL_CODE( FILE_DEVICE_KEYBOARD, 0x0400, METHOD_NEITHER, FILE_ANY_ACCESS )

/* Mouse internal device I/O control codes */
#define IOCTL_INTERNAL_MOUSE_CONNECT \
    CTL_CODE( FILE_DEVICE_MOUSE, 0x0080, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_MOUSE_DISCONNECT \
    CTL_CODE( FILE_DEVICE_MOUSE, 0x0100, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_MOUSE_ENABLE \
    CTL_CODE( FILE_DEVICE_MOUSE, 0x0200, METHOD_NEITHER, FILE_ANY_ACCESS )
#define IOCTL_INTERNAL_MOUSE_DISABLE \
    CTL_CODE( FILE_DEVICE_MOUSE, 0x0400, METHOD_NEITHER, FILE_ANY_ACCESS )

/* Keyboard and mouse errors */
#define KBDMOU_COULD_NOT_SEND_COMMAND   0x0000
#define KBDMOU_COULD_NOT_SEND_PARAM     0x0001
#define KBDMOU_NO_RESPONSE              0x0002
#define KBDMOU_INCORRECT_RESPONSE       0x0004

/* Keyboard and mouse error value bases */
#define I8042_ERROR_VALUE_BASE          1000
#define INPORT_ERROR_VALUE_BASE         2000
#define SERIAL_MOUSE_ERROR_VALUE_BASE   3000

/* Connect data */
typedef struct _CONNECT_DATA {
    PDEVICE_OBJECT  ClassDeviceObject;
    PVOID           ClassService;
} CONNECT_DATA;
typedef CONNECT_DATA    *PCONNECT_DATA;

/* Service callback routine */
typedef VOID (NTAPI *PSERVICE_CALLBACK_ROUTINE)( PVOID, PVOID, PVOID, PVOID );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _KBDMOU_ */
