/*
 *  cpl.h       Control panel definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_CPL
#define _INC_CPL

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Old control panel messages for compatibility */
#define WM_CPL_LAUNCH   (WM_USER + 1000)
#define WM_CPL_LAUNCHED (WM_USER + 1001)

/* Resource identifier special value */
#if (WINVER >= 0x0400)
    #define CPL_DYNAMIC_RES 0
#endif

/* Control panel messages */
#define CPL_INIT                1
#define CPL_GETCOUNT            2
#define CPL_INQUIRE             3
#define CPL_SELECT              4
#define CPL_DBLCLK              5
#define CPL_STOP                6
#define CPL_EXIT                7
#define CPL_NEWINQUIRE          8
#if (WINVER >= 0x0400)
    #define CPL_STARTWPARMSA    9
    #define CPL_STARTWPARMSW    10
#endif
#define CPL_SETUP               200
#ifdef UNICODE
    #if (WINVER >= 0x0400)
        #define CPL_STARTWPARMS CPL_STARTWPARMSW
    #endif
#else
    #if (WINVER >= 0x0400)
        #define CPL_STARTWPARMS CPL_STARTWPARMSA
    #endif
#endif

/* All structures in this file get one-byte packing. */
#include <pshpack1.h>

/* Control panel applet procedure */
typedef LONG (APIENTRY *APPLET_PROC)( HWND, UINT, LPARAM, LPARAM );

/* Control panel information */
typedef struct tagCPLINFO {
    int         idIcon;
    int         idName;
    int         idInfo;
    LONG_PTR    lData;
} CPLINFO;
typedef CPLINFO *LPCPLINFO;

/* New control panel information */
typedef struct tagNEWCPLINFOA {
    DWORD       dwSize;
    DWORD       dwFlags;
    DWORD       dwHelpContext;
    LONG_PTR    lData;
    HICON       hIcon;
    CHAR        szName[32];
    CHAR        szInfo[64];
    CHAR        szHelpFile[128];
} NEWCPLINFOA;
typedef NEWCPLINFOA     *LPNEWCPLINFOA;
typedef struct tagNEWCPLINFOW {
    DWORD       dwSize;
    DWORD       dwFlags;
    DWORD       dwHelpContext;
    LONG_PTR    lData;
    HICON       hIcon;
    WCHAR       szName[32];
    WCHAR       szInfo[64];
    WCHAR       szHelpFile[128];
} NEWCPLINFOW;
typedef NEWCPLINFOW     *LPNEWCPLINFOW;
#ifdef UNICODE
typedef NEWCPLINFOW     NEWCPLINFO;
typedef LPNEWCPLINFOW   LPNEWCPLINFO;
#else
typedef NEWCPLINFOA     NEWCPLINFO;
typedef LPNEWCPLINFOA   LPNEWCPLINFO;
#endif

/* Revert to default packing. */
#include <poppack.h>

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_CPL */
