/*
 *  commctrl.h  Common control functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_COMMCTRL
#define _INC_COMMCTRL

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <prsht.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify common control functions */
#ifndef WINCOMMCTRLAPI
    #define WINCOMMCTRLAPI  DECLSPEC_IMPORT
#endif

/* The following macros make it possible to disable nameless unions in certain structures
 * by defining NONAMELESSUNION.  They are shared with several other header files.
 */
#ifndef DUMMYUNIONNAME
    #ifdef NONAMELESSUNION
        #define DUMMYUNIONNAME  u
        #define DUMMYUNIONNAME2 u2
        #define DUMMYUNIONNAME3 u3
        #define DUMMYUNIONNAME4 u4
        #define DUMMYUNIONNAME5 u5
    #else
        #define DUMMYUNIONNAME
        #define DUMMYUNIONNAME2
        #define DUMMYUNIONNAME3
        #define DUMMYUNIONNAME4
        #define DUMMYUNIONNAME5
    #endif
#endif

/* These macro is used by other macros to invoke SendMessage().  It is shared with
 * several other header files.
 */
#ifndef SNDMSG
    #ifdef __cplusplus
        #define SNDMSG  ::SendMessage
    #else
        #define SNDMSG  SendMessage
    #endif
#endif

/* Handle data types */
typedef struct _IMAGELIST   *HIMAGELIST;
typedef struct _TREEITEM    *HTREEITEM;
#if (_WIN32_IE >= 0x0300)
typedef struct _DSA         *HDSA;
typedef struct _DPA         *HDPA;
#endif

/* Month calendar month/day state data type */
#if (_WIN32_IE >= 0x0300)
typedef DWORD   MONTHDAYSTATE;
typedef DWORD   *LPMONTHDAYSTATE;
#endif

/* InitCommonControlsEx() flags */
#if (_WIN32_IE >= 0x0300)
    #define ICC_LISTVIEW_CLASSES    0x00000001L
    #define ICC_TREEVIEW_CLASSES    0x00000002L
    #define ICC_BAR_CLASSES         0x00000004L
    #define ICC_TAB_CLASSES         0x00000008L
    #define ICC_UPDOWN_CLASS        0x00000010L
    #define ICC_PROGRESS_CLASS      0x00000020L
    #define ICC_HOTKEY_CLASS        0x00000040L
    #define ICC_ANIMATE_CLASS       0x00000080L
    #define ICC_WIN95_CLASSES       0x000000FFL
    #define ICC_DATE_CLASSES        0x00000100L
    #define ICC_USEREX_CLASSES      0x00000200L
    #define ICC_COOL_CLASSES        0x00000400L
#endif
#if (_WIN32_IE >= 0x0400)
    #define ICC_INTERNET_CLASSES    0x00000800L
    #define ICC_PAGESCROLLER_CLASS  0x00001000L
    #define ICC_NATIVEFNTCTL_CLASS  0x00002000L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define ICC_STANDARD_CLASSES    0x00004000L
    #define ICC_LINK_CLASS          0x00008000L
#endif

/* Owner draw types */
#define ODT_HEADER      100
#define ODT_TAB         101
#define ODT_LISTVIEW    102

/* Control message ranges */
#define LVM_FIRST           0x1000
#define TV_FIRST            0x1100
#define HDM_FIRST           0x1200
#define TCM_FIRST           0x1300
#if (_WIN32_IE >= 0x0400)
    #define PGM_FIRST       0x1400
    #if (_WIN32_WINNT >= 0x0501)
        #define ECM_FIRST   0x1500
        #define BCM_FIRST   0x1600
        #define CBM_FIRST   0x1700
    #endif
#endif

/* Common control messages */
#if (_WIN32_IE >= 0x0400)
    #define CCM_FIRST               0x2000
    #define CCM_LAST                0x2200
    #define CCM_SETBKCOLOR          (CCM_FIRST + 1)
    #define CCM_SETCOLORSCHEME      (CCM_FIRST + 2)
    #define CCM_GETCOLORSCHEME      (CCM_FIRST + 3)
    #define CCM_GETDROPTARGET       (CCM_FIRST + 4)
    #define CCM_SETUNICODEFORMAT    (CCM_FIRST + 5)
    #define CCM_GETUNICODEFORMAT    (CCM_FIRST + 6)
    #define CCM_SETVERSION          (CCM_FIRST + 7)
    #define CCM_GETVERSION          (CCM_FIRST + 8)
    #define CCM_SETNOTIFYWINDOW     (CCM_FIRST + 9)
    #if (_WIN32_WINNT >= 0x0501)
        #define CCM_SETWINDOWTHEME  (CCM_FIRST + 11)
        #define CCM_DPISCALE        (CCM_FIRST + 12)
    #endif
#endif

/* Common control version numbers */
#if (_WIN32_IE >= 0x0500)
    #if (_WIN32_WINNT >= 0x0501)
        #define COMCTL32_VERSION    6
    #else
        #define COMCTL32_VERSION    5
    #endif
#endif

/* InfoTip size */
#if (_WIN32_IE >= 0x0400)
    #define INFOTIPSIZE 1024
#endif

/* WM_NOTIFY helper macros */
#define HANDLE_WM_NOTIFY( p1, p2, p3, p4 ) \
    (p4)((p1), (int)(p2), (NMHDR *)(p3))
#define FORWARD_WM_NOTIFY( p1, p2, p3, p4 ) \
    (LRESULT)(p4)((p1), WM_NOTIFY, (WPARAM)(int)(p2), (LPARAM)(NMHDR *)(p4))

/* Notification ranges */
#define NM_FIRST        (0U - 0U)
#define NM_LAST         (0U - 99U)
#define LVN_FIRST       (0U - 100U)
#define LVN_LAST        (0U - 199U)
#define HDN_FIRST       (0U - 300U)
#define HDN_LAST        (0U - 399U)
#define TVN_FIRST       (0U - 400U)
#define TVN_LAST        (0U - 499U)
#define TTN_FIRST       (0U - 520U)
#define TTN_LAST        (0U - 549U)
#define TCN_FIRST       (0U - 550U)
#define TCN_LAST        (0U - 580U)
#ifndef CDN_FIRST
    #define CDN_FIRST   (0U - 601U)
    #define CDN_LAST    (0U - 699U)
#endif
#define TBN_FIRST       (0U - 700U)
#define TBN_LAST        (0U - 720U)
#define UDN_FIRST       (0U - 721U)
#define UDN_LAST        (0U - 729U)
#if (_WIN32_IE >= 0x0300)
    #define DTN_FIRST   (0U - 740U)
    #define DTN_LAST    (0U - 745U)
    #define MCN_FIRST   (0U - 746U)
    #define MCN_LAST    (0U - 752U)
    #define DTN_FIRST2  (0U - 753U)
    #define DTN_LAST2   (0U - 799U)
    #define CBEN_FIRST  (0U - 800U)
    #define CBEN_LAST   (0U - 830U)
    #define RBN_FIRST   (0U - 831U)
    #define RBN_LAST    (0U - 859U)
#endif
#if (_WIN32_IE >= 0x0400)
    #define IPN_FIRST   (0U - 860U)
    #define IPN_LAST    (0U - 879U)
    #define SBN_FIRST   (0U - 880U)
    #define SBN_LAST    (0U - 899U)
    #define PGN_FIRST   (0U - 900U)
    #define PGN_LAST    (0U - 950U)
#endif
#if (_WIN32_IE >= 0x0500)
    #define WMN_FIRST   (0U - 1000U)
    #define WMN_LAST    (0U - 1200U)
#endif
#if (_WIN32_IE >= 0x0501)
    #define BCN_FIRST   (0U - 1250U)
    #define BCN_LAST    (0U - 1350U)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TRBN_FIRST  (0U - 1501U)
    #define TRBN_LAST   (0U - 1519U)
#endif

/* Common control notifications */
#define NM_OUTOFMEMORY              (NM_FIRST - 1)
#define NM_CLICK                    (NM_FIRST - 2)
#define NM_DBLCLK                   (NM_FIRST - 3)
#define NM_RETURN                   (NM_FIRST - 4)
#define NM_RCLICK                   (NM_FIRST - 5)
#define NM_RDBLCLK                  (NM_FIRST - 6)
#define NM_SETFOCUS                 (NM_FIRST - 7)
#define NM_KILLFOCUS                (NM_FIRST - 8)
#if (_WIN32_IE >= 0x0300)
    #define NM_CUSTOMDRAW           (NM_FIRST - 12)
    #define NM_HOVER                (NM_FIRST - 13)
#endif
#if (_WIN32_IE >= 0x0400)
    #define NM_NCHITTEST            (NM_FIRST - 14)
    #define NM_KEYDOWN              (NM_FIRST - 15)
    #define NM_RELEASEDCAPTURE      (NM_FIRST - 16)
    #define NM_SETCURSOR            (NM_FIRST - 17)
    #define NM_CHAR                 (NM_FIRST - 18)
#endif
#if (_WIN32_IE >= 0x0401)
    #define NM_TOOLTIPSCREATED      (NM_FIRST - 19)
#endif
#if (_WIN32_IE >= 0x0500)
    #define NM_LDOWN                (NM_FIRST - 20)
    #define NM_RDOWN                (NM_FIRST - 21)
    #define NM_THEMECHANGED         (NM_FIRST - 22)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define NM_FONTCHANGED          (NM_FIRST - 23)
    #define NM_CUSTOMTEXT           (NM_FIRST - 24)
    #define NM_TVSTATEIMAGECHANGING (NM_FIRST - 24)
#endif

/* Message filter codes for common controls */
#define MSGF_COMMCTRL_BEGINDRAG     0x4200
#define MSGF_COMMCTRL_SIZEHEADER    0x4201
#define MSGF_COMMCTRL_DRAGSELECT    0x4202
#define MSGF_COMMCTRL_TOOLBARCUST   0x4203

/* Custom draw return flags */
#if (_WIN32_IE >= 0x0300)
    #define CDRF_DODEFAULT          0x00000000L
    #define CDRF_NEWFONT            0x00000002L
    #define CDRF_SKIPDEFAULT        0x00000004L
    #define CDRF_DOERASE            0x00000008L
    #define CDRF_NOTIFYPOSTPAINT    0x00000010L
    #define CDRF_NOTIFYITEMDRAW     0x00000020L
#endif
#if (_WIN32_IE >= 0x0400)
    #define CDRF_NOTIFYSUBITEMDRAW  0x00000020L
#endif
#if (_WIN32_IE >= 0x0300)
    #define CDRF_NOTIFYPOSTERASE    0x00000040L
    #define CDRF_SKIPPOSTPAINT      0x00000100L
#endif

/* Custom draw draw states */
#if (_WIN32_IE >= 0x0300)
    #define CDDS_PREPAINT       0x00000001L
    #define CDDS_POSTPAINT      0x00000002L
    #define CDDS_PREERASE       0x00000003L
    #define CDDS_POSTERASE      0x00000004L
    #define CDDS_ITEM           0x00010000L
    #define CDDS_ITEMPREPAINT   (CDDS_ITEM | CDDS_PREPAINT)
    #define CDDS_ITEMPOSTPAINT  (CDDS_ITEM | CDDS_POSTPAINT)
    #define CDDS_ITEMPREERASE   (CDDS_ITEM | CDDS_PREERASE)
    #define CDDS_ITEMPOSTERASE  (CDDS_ITEM | CDDS_POSTERASE)
#endif
#if (_WIN32_IE >= 0x0400)
    #define CDDS_SUBITEM        0x00020000L
#endif

/* Custom draw item states */
#if (_WIN32_IE >= 0x0300)
    #define CDIS_SELECTED               0x00000001
    #define CDIS_GRAYED                 0x00000002
    #define CDIS_DISABLED               0x00000004
    #define CDIS_CHECKED                0x00000008
    #define CDIS_FOCUS                  0x00000010
    #define CDIS_DEFAULT                0x00000020
    #define CDIS_HOT                    0x00000040
    #define CDIS_MARKED                 0x00000080
    #define CDIS_INDETERMINATE          0x00000100
    #if (_WIN32_WINNT >= 0x0501)
        #define CDIS_SHOWKEYBOARDCUES   0x00000200
    #endif
    #if (_WIN32_WINNT >= 0x0600)
        #define CDIS_NEARHOT            0x00000400
        #define CDIS_OTHERSIDEHOT       0x00000800
        #define CDIS_DROPHILITED        0x00001000
    #endif
#endif

/* Button control notifications */
#if (_WIN32_IE >= 0x0300)
    #define NM_GETCUSTOMSPLITRECT   (BCN_FIRST + 3)
#endif

/* Special color values */
#define CLR_NONE    0xFFFFFFFFL
#define CLR_DEFAULT 0xFF000000L
#define CLR_HILIGHT CLR_DEFAULT

/* ImageList_Create() flags */
#define ILC_MASK                    0x00000001L
#define ILC_COLOR                   0x00000000L
#define ILC_COLORDDB                0x000000FEL
#define ILC_COLOR4                  0x00000004L
#define ILC_COLOR8                  0x00000008L
#define ILC_COLOR16                 0x00000010L
#define ILC_COLOR24                 0x00000018L
#define ILC_COLOR32                 0x00000020L
#define ILC_PALETTE                 0x00000800L
#if (_WIN32_WINNT >= 0x0501)
    #define ILC_MIRROR              0x00002000L
    #define ILC_PERITEMMIRROR       0x00008000L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define ILC_ORIGINALSIZE        0x00010000L
    #define ILC_HIGHQUALITYSCALE    0x00020000L
#endif

/* ImageList_Draw() flags */
#define ILD_NORMAL          0x00000000L
#define ILD_TRANSPARENT     0x00000001L
#define ILD_MASK            0x00000010L
#define ILD_IMAGE           0x00000020L
#if (_WIN32_IE >= 0x0300)
    #define ILD_ROP         0x00000040L
#endif
#define ILD_BLEND25         0x00000002L
#define ILD_BLEND50         0x00000004L
#define ILD_OVERLAYMASK     0x00000F00L
#define ILD_PRESERVEALPHA   0x00001000L
#define ILD_SCALE           0x00002000L
#define ILD_DPISCALE        0x00004000L
#if (_WIN32_WINNT >= 0x0600)
    #define ILD_ASYNC       0x00008000L
#endif
#define ILD_SELECTED        ILD_BLEND50
#define ILD_FOCUS           ILD_BLEND25
#define ILD_BLEND           ILD_BLEND50

/* Image list states */
#define ILS_NORMAL      0x00000000L
#define ILS_GROW        0x00000001L
#define ILS_SHADOW      0x00000002L
#define ILS_SATURATE    0x00000004L
#define ILS_ALPHA       0x00000008L

#if (_WIN32_WINNT >= 0x0600)
    #define ILGT_NORMAL 0x00000000L
    #define ILGT_ASYNC  0x00000001L
#endif

/* Bitmap handle special value */
#if (_WIN32_WINNT >= 0x0600)
    #define HBITMAP_CALLBACK    ((HBITMAP)-1)
#endif

/* ImageList_Copy() flags */
#if (_WIN32_IE >= 0x0300)
    #define ILCF_MOVE   0x00000000L
    #define ILCF_SWAP   0x00000001L
#endif

/* ImageList_ReadEx()/ImageList_WriteEx() flags */
#if (_WIN32_WINNT >= 0x0501) && defined( __objidl_h__ )
    #define ILP_NORMAL      0L
    #define ILP_DOWNLEVEL   1L
#endif

/* Macro to convert an image list interface pointer to a handle */
#ifdef __cplusplus
    #define IImageListToHIMAGELIST( x ) reinterpret_cast< HIMAGELIST >( x )
#else
    #define IImageListToHIMAGELIST( x ) ((HIMAGELIST)(x))
#endif

/* Macro to convert image indices to overlay masks */
#define INDEXTOOVERLAYMASK( x ) ((x) << 8)

/* Common control window classes */
#define ANIMATE_CLASSA              "SysAnimate32"
#define ANIMATE_CLASSW              L"SysAnimate32"
#define HOTKEY_CLASSA               "msctls_hotkey32"
#define HOTKEY_CLASSW               L"msctls_hotkey32"
#define PROGRESS_CLASSA             "msctls_progress32"
#define PROGRESS_CLASSW             L"msctls_progress32"
#define STATUSCLASSNAMEA            "msctls_statusbar32"
#define STATUSCLASSNAMEW            L"msctls_statusbar32"
#define TOOLBARCLASSNAMEA           "ToolbarWindow32"
#define TOOLBARCLASSNAMEW           L"ToolbarWindow32"
#define TOOLTIPS_CLASSA             "tooltips_class32"
#define TOOLTIPS_CLASSW             L"tooltips_class32"
#define TRACKBAR_CLASSA             "msctls_trackbar32"
#define TRACKBAR_CLASSW             L"msctls_trackbar32"
#define UPDOWN_CLASSA               "msctls_updown32"
#define UPDOWN_CLASSW               L"msctls_updown32"
#define WC_HEADERA                  "SysHeader32"
#define WC_HEADERW                  L"SysHeader32"
#define WC_LISTVIEWA                "SysListView32"
#define WC_LISTVIEWW                L"SysListView32"
#define WC_TABCONTROLA              "SysTabControl32"
#define WC_TABCONTROLW              L"SysTabControl32"
#define WC_TREEVIEWA                "SysTreeView32"
#define WC_TREEVIEWW                L"SysTreeView32"
#if (_WIN32_IE >= 0x0300)
    #define DATETIMEPICK_CLASSA     "SysDateTimePick32"
    #define DATETIMEPICK_CLASSW     L"SysDateTimePick32"
    #define MONTHCAL_CLASSA         "SysMonthCal32"
    #define MONTHCAL_CLASSW         L"SysMonthCal32"
    #define REBARCLASSNAMEA         "ReBarWindow32"
    #define REBARCLASSNAMEW         L"ReBarWindow32"
    #define WC_COMBOBOXEXA          "ComboBoxEx32"
    #define WC_COMBOBOXEXW          L"ComboBoxEx32"
#endif
#if (_WIN32_IE >= 0x0400)
    #define WC_BUTTONA              "Button"
    #define WC_BUTTONW              L"Button"
    #define WC_COMBOBOXA            "ComboBox"
    #define WC_COMBOBOXW            L"ComboBox"
    #define WC_EDITA                "Edit"
    #define WC_EDITW                L"Edit"
    #define WC_IPADDRESSA           "SysIPAddress32"
    #define WC_IPADDRESSW           L"SysIPAddress32"
    #define WC_LISTBOXA             "ListBox"
    #define WC_LISTBOXW             L"ListBox"
    #define WC_NATIVEFONTCTLA       "NativeFontCtl"
    #define WC_NATIVEFONTCTLW       L"NativeFontCtl"
    #define WC_PAGESCROLLERA        "SysPager"
    #define WC_PAGESCROLLERW        L"SysPager"
    #define WC_SCROLLBARA           "ScrollBar"
    #define WC_SCROLLBARW           L"ScrollBar"
    #define WC_STATICA              "Static"
    #define WC_STATICW              L"Static"
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define WC_LINK                 L"SysLink"
#endif
#ifdef UNICODE
    #define ANIMATE_CLASS           ANIMATE_CLASSW
    #define HOTKEY_CLASS            HOTKEY_CLASSW
    #define PROGRESS_CLASS          PROGRESS_CLASSW
    #define STATUSCLASSNAME         STATUSCLASSNAMEW
    #define TOOLBARCLASSNAME        TOOLBARCLASSNAMEW
    #define TOOLTIPS_CLASS          TOOLTIPS_CLASSW
    #define TRACKBAR_CLASS          TRACKBAR_CLASSW
    #define UPDOWN_CLASS            UPDOWN_CLASSW
    #define WC_HEADER               WC_HEADERW
    #define WC_LISTVIEW             WC_LISTVIEWW
    #define WC_TABCONTROL           WC_TABCONTROLW
    #define WC_TREEVIEW             WC_TREEVIEWW
    #if (_WIN32_IE >= 0x0300)
        #define DATETIMEPICK_CLASS  DATETIMEPICK_CLASSW
        #define MONTHCAL_CLASS      MONTHCAL_CLASSW
        #define REBARCLASSNAME      REBARCLASSNAMEW
        #define WC_COMBOBOXEX       WC_COMBOBOXEXW
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define WC_BUTTON           WC_BUTTONW
        #define WC_COMBOBOX         WC_COMBOBOXW
        #define WC_EDIT             WC_EDITW
        #define WC_IPADDRESS        WC_IPADDRESSW
        #define WC_LISTBOX          WC_LISTBOXW
        #define WC_NATIVEFONTCTL    WC_NATIVEFONTCTLW
        #define WC_PAGESCROLLER     WC_PAGESCROLLERW
        #define WC_SCROLLBAR        WC_SCROLLBARW
        #define WC_STATIC           WC_STATICW
    #endif
#else
    #define ANIMATE_CLASS           ANIMATE_CLASSA
    #define HOTKEY_CLASS            HOTKEY_CLASSA
    #define PROGRESS_CLASS          PROGRESS_CLASSA
    #define STATUSCLASSNAME         STATUSCLASSNAMEA
    #define TOOLBARCLASSNAME        TOOLBARCLASSNAMEA
    #define TOOLTIPS_CLASS          TOOLTIPS_CLASSA
    #define TRACKBAR_CLASS          TRACKBAR_CLASSA
    #define UPDOWN_CLASS            UPDOWN_CLASSA
    #define WC_HEADER               WC_HEADERA
    #define WC_LISTVIEW             WC_LISTVIEWA
    #define WC_TABCONTROL           WC_TABCONTROLA
    #define WC_TREEVIEW             WC_TREEVIEWA
    #if (_WIN32_IE >= 0x0300)
        #define DATETIMEPICK_CLASS  DATETIMEPICK_CLASSA
        #define MONTHCAL_CLASS      MONTHCAL_CLASSA
        #define REBARCLASSNAME      REBARCLASSNAMEA
        #define WC_COMBOBOXEX       WC_COMBOBOXEXA
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define WC_BUTTON           WC_BUTTONA
        #define WC_COMBOBOX         WC_COMBOBOXA
        #define WC_EDIT             WC_EDITA
        #define WC_IPADDRESS        WC_IPADDRESSA
        #define WC_LISTBOX          WC_LISTBOXA
        #define WC_NATIVEFONTCTL    WC_NATIVEFONTCTLA
        #define WC_PAGESCROLLER     WC_PAGESCROLLERA
        #define WC_SCROLLBAR        WC_SCROLLBARA
        #define WC_STATIC           WC_STATICA
    #endif
#endif

/* Header styles */
#define HDS_HORZ            0x0000L
#define HDS_BUTTONS         0x0002L
#if (_WIN32_IE >= 0x0300)
    #define HDS_HOTTRACK    0x0004L
#endif
#define HDS_HIDDEN          0x0008L
#if (_WIN32_IE >= 0x0300)
    #define HDS_DRAGDROP    0x0040L
    #define HDS_FULLDRAG    0x0080L
#endif
#if (_WIN32_IE >= 0x0500)
    #define HDS_FILTERBAR   0x0100L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define HDS_FLAT        0x0200L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define HDS_CHECKBOXES  0x0400L
    #define HDS_NOSIZING    0x0800L
    #define HDS_OVERFLOW    0x1000L
#endif

/* Header filter types */
#if (_WIN32_IE >= 0x0500)
    #define HDFT_ISSTRING   0x0000
    #define HDFT_ISNUMBER   0x0001
    #define HDFT_ISDATE     0x0002
    #define HDFT_HASNOVALUE 0x8000
#endif

/* Header item masks */
#define HDI_WIDTH           0x0001
#define HDI_HEIGHT          HDI_WIDTH
#define HDI_TEXT            0x0002
#define HDI_FORMAT          0x0004
#define HDI_LPARAM          0x0008
#define HDI_BITMAP          0x0010
#if (_WIN32_IE >= 0x0300)
    #define HDI_IMAGE       0x0020
    #define HDI_DI_SETITEM  0x0040
    #define HDI_ORDER       0x0080
#endif
#if (_WIN32_IE >= 0x0500)
    #define HDI_FILTER      0x0100
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define HDI_STATE       0x0200
#endif

/* Header flags */
#define HDF_LEFT                0x00000000
#define HDF_RIGHT               0x00000001
#define HDF_CENTER              0x00000002
#define HDF_JUSTIFYMASK         0x00000003
#define HDF_RTLREADING          0x00000004
#if (_WIN32_WINNT >= 0x0600)
    #define HDF_CHECKBOX        0x00000040
    #define HDF_CHECKED         0x00000080
    #define HDF_FIXEDWIDTH      0x00000100
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define HDF_SORTDOWN        0x00000200
    #define HDF_SORTUP          0x00000400
#endif
#if (_WIN32_IE >= 0x0300)
    #define HDF_IMAGE           0x00000800
    #define HDF_BITMAP_ON_RIGHT 0x00001000
#endif
#define HDF_BITMAP              0x00002000
#define HDF_STRING              0x00004000
#define HDF_OWNERDRAW           0x00008000
#if (_WIN32_WINNT >= 0x0600)
    #define HDF_SPLITBUTTON     0x01000000
#endif

/* Header item states */
#if (_WIN32_WINNT >= 0x0600)
    #define HDIS_FOCUSED    0x00000001
#endif

/* Header messages */
#define HDM_GETITEMCOUNT                (HDM_FIRST + 0)
#define HDM_INSERTITEMA                 (HDM_FIRST + 1)
#define HDM_DELETEITEM                  (HDM_FIRST + 2)
#define HDM_GETITEMA                    (HDM_FIRST + 3)
#define HDM_SETITEMA                    (HDM_FIRST + 4)
#define HDM_LAYOUT                      (HDM_FIRST + 5)
#define HDM_HITTEST                     (HDM_FIRST + 6)
#if (_WIN32_IE >= 0x0300)
    #define HDM_GETITEMRECT             (HDM_FIRST + 7)
    #define HDM_SETIMAGELIST            (HDM_FIRST + 8)
    #define HDM_GETIMAGELIST            (HDM_FIRST + 9)
#endif
#define HDM_INSERTITEMW                 (HDM_FIRST + 10)
#define HDM_GETITEMW                    (HDM_FIRST + 11)
#define HDM_SETITEMW                    (HDM_FIRST + 12)
#if (_WIN32_IE >= 0x0300)
    #define HDM_ORDERTOINDEX            (HDM_FIRST + 15)
    #define HDM_CREATEDRAGIMAGE         (HDM_FIRST + 16)
    #define HDM_GETORDERARRAY           (HDM_FIRST + 17)
    #define HDM_SETORDERARRAY           (HDM_FIRST + 18)
    #define HDM_SETHOTDIVIDER           (HDM_FIRST + 19)
#endif
#if (_WIN32_IE >= 0x0500)
    #define HDM_SETBITMAPMARGIN         (HDM_FIRST + 20)
    #define HDM_GETBITMAPMARGIN         (HDM_FIRST + 21)
    #define HDM_SETFILTERCHANGETIMEOUT  (HDM_FIRST + 22)
    #define HDM_EDITFILTER              (HDM_FIRST + 23)
    #define HDM_CLEARFILTER             (HDM_FIRST + 24)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define HDM_GETITEMDROPDOWNRECT     (HDM_FIRST + 25)
    #define HDM_GETOVERFLOWRECT         (HDM_FIRST + 26)
    #define HDM_GETFOCUSEDITEM          (HDM_FIRST + 27)
    #define HDM_SETFOCUSEDITEM          (HDM_FIRST + 28)
#endif
#if (_WIN32_IE >= 0x0400)
    #define HDM_SETUNICODEFORMAT        CCM_SETUNICODEFORMAT
    #define HDM_GETUNICODEFORMAT        CCM_GETUNICODEFORMAT
#endif
#if (_WIN32_IE >= 0x0600)
    #define HDM_TRANSLATEACCELERATOR    CCM_TRANSLATEACCELERATOR
#endif
#ifdef UNICODE
    #define HDM_INSERTITEM              HDM_INSERTITEMW
    #define HDM_GETITEM                 HDM_GETITEMW
    #define HDM_SETITEM                 HDM_SETITEMW
#else
    #define HDM_INSERTITEM              HDM_INSERTITEMA
    #define HDM_GETITEM                 HDM_GETITEMA
    #define HDM_SETITEM                 HDM_SETITEMA
#endif

/* Header hit test flags */
#define HHT_NOWHERE             0x0001
#define HHT_ONHEADER            0x0002
#define HHT_ONDIVIDER           0x0004
#define HHT_ONDIVOPEN           0x0008
#if (_WIN32_IE >= 0x0500)
    #define HHT_ONFILTER        0x0010
    #define HHT_ONFILTERBUTTON  0x0020
#endif
#define HHT_ABOVE               0x0100
#define HHT_BELOW               0x0200
#define HHT_TORIGHT             0x0400
#define HHT_TOLEFT              0x0800
#if (_WIN32_WINNT >= 0x0600)
    #define HHT_ONITEMSTATEICON 0x1000
    #define HHT_ONDROPDOWN      0x2000
    #define HHT_ONOVERFLOW      0x4000
#endif

/* HDM_SETIMAGELIST options */
#define HDSIL_NORMAL    0
#define HDSIL_STATE     1

/* Header notifications */
#define HDN_ITEMCHANGINGA           (HDN_FIRST - 0)
#define HDN_ITEMCHANGEDA            (HDN_FIRST - 1)
#define HDN_ITEMCLICKA              (HDN_FIRST - 2)
#define HDN_ITEMDBLCLICKA           (HDN_FIRST - 3)
#define HDN_DIVIDERDBLCLICKA        (HDN_FIRST - 5)
#define HDN_BEGINTRACKA             (HDN_FIRST - 6)
#define HDN_ENDTRACKA               (HDN_FIRST - 7)
#define HDN_TRACKA                  (HDN_FIRST - 8)
#if (_WIN32_IE >= 0x0300)
    #define HDN_GETDISPINFOA        (HDN_FIRST - 9)
    #define HDN_BEGINDRAG           (HDN_FIRST - 10)
    #define HDN_ENDDRAG             (HDN_FIRST - 11)
#endif
#if (_WIN32_IE >= 0x0500)
    #define HDN_FILTERCHANGE        (HDN_FIRST - 12)
    #define HDN_FILTERBTNCLICK      (HDN_FIRST - 13)
#endif
#if (_WIN32_IE >= 0x0600)
    #define HDN_BEGINFILTEREDIT     (HDN_FIRST - 14)
    #define HDN_ENDFILTEREDIT       (HDN_FIRST - 15)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define HDN_ITEMSTATEICONCLICK  (HDN_FIRST - 16)
    #define HDN_ITEMKEYDOWN         (HDN_FIRST - 17)
    #define HDN_DROPDOWN            (HDN_FIRST - 18)
    #define HDN_OVERFLOWCLICK       (HDN_FIRST - 19)
#endif
#define HDN_ITEMCHANGINGW           (HDN_FIRST - 20)
#define HDN_ITEMCHANGEDW            (HDN_FIRST - 21)
#define HDN_ITEMCLICKW              (HDN_FIRST - 22)
#define HDN_ITEMDBLCLICKW           (HDN_FIRST - 23)
#define HDN_DIVIDERDBLCLICKW        (HDN_FIRST - 25)
#define HDN_BEGINTRACKW             (HDN_FIRST - 26)
#define HDN_ENDTRACKW               (HDN_FIRST - 27)
#define HDN_TRACKW                  (HDN_FIRST - 28)
#if (_WIN32_IE >= 0x0300)
    #define HDN_GETDISPINFOW        (HDN_FIRST - 29)
#endif
#ifdef UNICODE
    #define HDN_ITEMCHANGING        HDN_ITEMCHANGINGW
    #define HDN_ITEMCHANGED         HDN_ITEMCHANGEDW
    #define HDN_ITEMCLICK           HDN_ITEMCLICKW
    #define HDN_ITEMDBLCLICK        HDN_ITEMDBLCLICKW
    #define HDN_DIVIDERDBLCLICK     HDN_DIVIDERDBLCLICKW
    #define HDN_BEGINTRACK          HDN_BEGINTRACKW
    #define HDN_ENDTRACK            HDN_ENDTRACKW
    #if (_WIN32_IE >= 0x0300)
        #define HDN_GETDISPINFO     HDN_GETDISPINFOW
    #endif
#else
    #define HDN_ITEMCHANGING        HDN_ITEMCHANGINGA
    #define HDN_ITEMCHANGED         HDN_ITEMCHANGEDA
    #define HDN_ITEMCLICK           HDN_ITEMCLICKA
    #define HDN_ITEMDBLCLICK        HDN_ITEMDBLCLICKA
    #define HDN_DIVIDERDBLCLICK     HDN_DIVIDERDBLCLICKA
    #define HDN_BEGINTRACK          HDN_BEGINTRACKA
    #define HDN_ENDTRACK            HDN_ENDTRACKA
    #if (_WIN32_IE >= 0x0300)
        #define HDN_GETDISPINFO     HDN_GETDISPINFOA
    #endif
#endif

/* CreateMappedBitmap() flags */
#define CMB_MASKED  0x00000002

/* Toolbar button states */
#define TBSTATE_CHECKED         0x01
#define TBSTATE_PRESSED         0x02
#define TBSTATE_ENABLED         0x04
#define TBSTATE_HIDDEN          0x08
#define TBSTATE_INDETERMINATE   0x10
#define TBSTATE_WRAP            0x20
#if (_WIN32_IE >= 0x0300)
    #define TBSTATE_ELLIPSES    0x40
#endif
#if (_WIN32_IE >= 0x0400)
    #define TBSTATE_MARKED      0x80
#endif

/* Toolbar button styles */
#define TBSTYLE_BUTTON          0x00
#define TBSTYLE_SEP             0x01
#define TBSTYLE_CHECK           0x02
#define TBSTYLE_GROUP           0x04
#define TBSTYLE_CHECKGROUP      (TBSTYLE_GROUP | TBSTYLE_CHECK)
#if (_WIN32_IE >= 0x0300)
    #define TBSTYLE_DROPDOWN    0x08
#endif
#if (_WIN32_IE >= 0x0400)
    #define TBSTYLE_AUTOSIZE    0x10
    #define TBSTYLE_NOPREFIX    0x20
#endif
#if (_WIN32_IE >= 0x0500)
    #define BTNS_BUTTON         TBSTYLE_BUTTON
    #define BTNS_SEP            TBSTYLE_SEP
    #define BTNS_CHECK          TBSTYLE_CHECK
    #define BTNS_GROUP          TBSTYLE_GROUP
    #define BTNS_CHECKGROUP     TBSTYLE_CHECKGROUP
    #define BTNS_DROPDOWN       TBSTYLE_DROPDOWN
    #define BTNS_AUTOSIZE       TBSTYLE_AUTOSIZE
    #define BTNS_NOPREFIX       TBSTYLE_NOPREFIX
#endif
#if (_WIN32_IE >= 0x0501)
    #define BTNS_SHOWTEXT       0x40
#endif
#if (_WIN32_IE >= 0x0500)
    #define BTNS_WHOLEDROPDOWN  0x80
#endif

/* Toolbar styles */
#define TBSTYLE_TOOLTIPS            0x0100L
#define TBSTYLE_WRAPABLE            0x0200L
#define TBSTYLE_ALTDRAG             0x0400L
#if (_WIN32_IE >= 0x0300)
    #define TBSTYLE_FLAT            0x0800L
    #define TBSTYLE_LIST            0x1000L
    #define TBSTYLE_CUSTOMERASE     0x2000L
#endif
#if (_WIN32_IE >= 0x0400)
    #define TBSTYLE_REGISTERDROP    0x4000L
    #define TBSTYLE_TRANSPARENT     0x8000L
#endif

/* Toolbar extended styles */
#define TBSTYLE_EX_DRAWDDARROWS             0x00000001L
#if (_WIN32_IE >= 0x0501)
    #define TBSTYLE_EX_MIXEDBUTTONS         0x00000008L
    #define TBSTYLE_EX_HIDECLIPPEDBUTTONS   0x00000010L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TBSTYLE_EX_DOUBLEBUFFER         0x00000080L
#endif

/* Toolbar custom draw return flags */
#if (_WIN32_IE >= 0x0400)
    #define TBCDRF_NOEDGES          0x00010000L
    #define TBCDRF_HILITEHOTTRACK   0x00020000L
    #define TBCDRF_NOOFFSET         0x00040000L
    #define TBCDRF_NOMARK           0x00080000L
    #define TBCDRF_NOETCHEDEFFECT   0x00100000L
#endif
#if (_WIN32_IE >= 0x0500)
    #define TBCDRF_BLENDICON        0x00200000L
    #define TBCDRF_NOBACKGROUND     0x00400000L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TBCDRF_USECDCOLORS      0x00800000L
#endif

/* Toolbar messages */
#define TB_ENABLEBUTTON             (WM_USER + 1)
#define TB_CHECKBUTTON              (WM_USER + 2)
#define TB_PRESSBUTTON              (WM_USER + 3)
#define TB_HIDEBUTTON               (WM_USER + 4)
#define TB_INDETERMINATE            (WM_USER + 5)
#if (_WIN32_IE >= 0x0400)
    #define TB_MARKBUTTON           (WM_USER + 6)
#endif
#define TB_ISBUTTONENABLED          (WM_USER + 9)
#define TB_ISBUTTONCHECKED          (WM_USER + 10)
#define TB_ISBUTTONPRESSED          (WM_USER + 11)
#define TB_ISBUTTONHIDDEN           (WM_USER + 12)
#define TB_ISBUTTONINDETERMINATE    (WM_USER + 13)
#if (_WIN32_IE >= 0x0400)
    #define TB_ISBUTTONHIGHLIGHTED  (WM_USER + 14)
#endif
#define TB_SETSTATE                 (WM_USER + 17)
#define TB_GETSTATE                 (WM_USER + 18)
#define TB_ADDBITMAP                (WM_USER + 19)
#if (_WIN32_IE >= 0x0400)
    #define TB_ADDBUTTONSA          (WM_USER + 20)
    #define TB_INSERTBUTTONA        (WM_USER + 21)
#else
    #define TB_ADDBUTTONS           (WM_USER + 20)
    #define TB_INSERTBUTTON         (WM_USER + 21)
#endif
#define TB_DELETEBUTTON             (WM_USER + 22)
#define TB_GETBUTTON                (WM_USER + 23)
#define TB_BUTTONCOUNT              (WM_USER + 24)
#define TB_COMMANDTOINDEX           (WM_USER + 25)
#define TB_SAVERESTOREA             (WM_USER + 26)
#define TB_CUSTOMIZE                (WM_USER + 27)
#define TB_ADDSTRINGA               (WM_USER + 28)
#define TB_GETITEMRECT              (WM_USER + 29)
#define TB_BUTTONSTRUCTSIZE         (WM_USER + 30)
#define TB_SETBUTTONSIZE            (WM_USER + 31)
#define TB_SETBITMAPSIZE            (WM_USER + 32)
#define TB_AUTOSIZE                 (WM_USER + 33)
#define TB_GETTOOLTIPS              (WM_USER + 35)
#define TB_SETTOOLTIPS              (WM_USER + 36)
#define TB_SETPARENT                (WM_USER + 37)
#define TB_SETROWS                  (WM_USER + 39)
#define TB_GETROWS                  (WM_USER + 40)
#define TB_GETBITMAPFLAGS           (WM_USER + 41)
#define TB_SETCMDID                 (WM_USER + 42)
#define TB_CHANGEBITMAP             (WM_USER + 43)
#define TB_GETBITMAP                (WM_USER + 44)
#define TB_GETBUTTONTEXTA           (WM_USER + 45)
#define TB_REPLACEBITMAP            (WM_USER + 46)
#if (_WIN32_IE >= 0x0300)
    #define TB_SETINDENT            (WM_USER + 47)
    #define TB_SETIMAGELIST         (WM_USER + 48)
    #define TB_GETIMAGELIST         (WM_USER + 49)
    #define TB_LOADIMAGES           (WM_USER + 50)
    #define TB_GETRECT              (WM_USER + 51)
    #define TB_SETHOTIMAGELIST      (WM_USER + 52)
    #define TB_GETHOTIMAGELIST      (WM_USER + 53)
    #define TB_SETDISABLEDIMAGELIST (WM_USER + 54)
    #define TB_GETDISABLEDIMAGELIST (WM_USER + 55)
    #define TB_SETSTYLE             (WM_USER + 56)
    #define TB_GETSTYLE             (WM_USER + 57)
    #define TB_GETBUTTONSIZE        (WM_USER + 58)
    #define TB_SETBUTTONWIDTH       (WM_USER + 59)
    #define TB_SETMAXTEXTROWS       (WM_USER + 60)
    #define TB_GETTEXTROWS          (WM_USER + 61)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TB_GETOBJECT            (WM_USER + 62)
    #define TB_GETBUTTONINFOW       (WM_USER + 63)
    #define TB_SETBUTTONINFOW       (WM_USER + 64)
    #define TB_GETBUTTONINFOA       (WM_USER + 65)
    #define TB_SETBUTTONINFOA       (WM_USER + 66)
    #define TB_INSERTBUTTONW        (WM_USER + 67)
    #define TB_ADDBUTTONSW          (WM_USER + 68)
    #define TB_HITTEST              (WM_USER + 69)
    #define TB_SETDRAWTEXTFLAGS     (WM_USER + 70)
    #define TB_GETHOTITEM           (WM_USER + 71)
    #define TB_SETHOTITEM           (WM_USER + 72)
    #define TB_SETANCHORHIGHLIGHT   (WM_USER + 73)
    #define TB_GETANCHORHIGHLIGHT   (WM_USER + 74)
#endif
#define TB_GETBUTTONTEXTW           (WM_USER + 75)
#define TB_SAVERESTOREW             (WM_USER + 76)
#define TB_ADDSTRINGW               (WM_USER + 77)
#if (_WIN32_IE >= 0x0400)
    #define TB_MAPACCELERATORA      (WM_USER + 78)
    #define TB_GETINSERTMARK        (WM_USER + 79)
    #define TB_SETINSERTMARK        (WM_USER + 80)
    #define TB_INSERTMARKHITTEST    (WM_USER + 81)
    #define TB_MOVEBUTTON           (WM_USER + 82)
    #define TB_GETMAXSIZE           (WM_USER + 83)
    #define TB_SETEXTENDEDSTYLE     (WM_USER + 84)
    #define TB_GETEXTENDEDSTYLE     (WM_USER + 85)
    #define TB_GETPADDING           (WM_USER + 86)
    #define TB_SETPADDING           (WM_USER + 87)
    #define TB_SETINSERTMARKCOLOR   (WM_USER + 88)
    #define TB_GETINSERTMARKCOLOR   (WM_USER + 89)
    #define TB_MAPACCELERATORW      (WM_USER + 90)
#endif
#if (_WIN32_IE >= 0x0500)
    #define TB_GETSTRINGW           (WM_USER + 91)
    #define TB_GETSTRINGA           (WM_USER + 92)
    #define TB_SETHOTITEM2          (WM_USER + 94)
    #define TB_SETLISTGAP           (WM_USER + 96)
    #define TB_GETIMAGELISTCOUNT    (WM_USER + 98)
    #define TB_GETIDEALSIZE         (WM_USER + 99)
    #define TB_TRANSLATEACCELERATOR CCM_TRANSLATEACCELERATOR
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TB_GETMETRICS           (WM_USER + 101)
    #define TB_SETMETRICS           (WM_USER + 102)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TB_GETITEMDROPDOWNRECT  (WM_USER + 103)
    #define TB_SETPRESSEDIMAGELIST  (WM_USER + 104)
    #define TB_GETPRESSEDIMAGELIST  (WM_USER + 105)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TB_SETCOLORSCHEME       CCM_SETCOLORSCHEME
    #define TB_GETCOLORSCHEME       CCM_GETCOLORSCHEME
    #define TB_SETUNICODEFORMAT     CCM_SETUNICODEFORMAT
    #define TB_GETUNICODEFORMAT     CCM_GETUNICODEFORMAT
#endif
#if (_WIN32_IE >= 0x0501)
    #define TB_SETWINDOWTHEME       CCM_SETWINDOWTHEME
#endif
#ifdef UNICODE
    #define TB_SAVERESTORE          TB_SAVERESTOREW
    #define TB_ADDSTRING            TB_ADDSTRINGW
    #define TB_GETBUTTONTEXT        TB_GETBUTTONTEXTW
    #if (_WIN32_IE >= 0x0400)
        #define TB_GETBUTTONINFO    TB_GETBUTTONINFOW
        #define TB_SETBUTTONINFO    TB_SETBUTTONINFOW
        #define TB_INSERTBUTTON     TB_INSERTBUTTONW
        #define TB_ADDBUTTONS       TB_ADDBUTTONSW
        #define TB_MAPACCELERATOR   TB_MAPACCELERATORW
    #endif
    #if (_WIN32_IE >= 0x0500)
        #define TB_GETSTRING        TB_GETSTRINGW
    #endif
#else
    #define TB_SAVERESTORE          TB_SAVERESTOREA
    #define TB_ADDSTRING            TB_ADDSTRINGA
    #define TB_GETBUTTONTEXT        TB_GETBUTTONTEXTA
    #if (_WIN32_IE >= 0x0400)
        #define TB_GETBUTTONINFO    TB_GETBUTTONINFOA
        #define TB_SETBUTTONINFO    TB_SETBUTTONINFOA
        #define TB_INSERTBUTTON     TB_INSERTBUTTONA
        #define TB_ADDBUTTONS       TB_ADDBUTTONSA
        #define TB_MAPACCELERATOR   TB_MAPACCELERATORA
    #endif
    #if (_WIN32_IE >= 0x0500)
        #define TB_GETSTRING        TB_GETSTRINGA
    #endif
#endif

/* Instance handle for COMCTL32.DLL */
#define HINST_COMMCTRL  ((HINSTANCE)-1)

/* Standard bitmap handles for toolbars */
#define IDB_STD_SMALL_COLOR         0
#define IDB_STD_LARGE_COLOR         1
#define IDB_VIEW_SMALL_COLOR        4
#define IDB_VIEW_LARGE_COLOR        5
#if (_WIN32_IE >= 0x0300)
    #define IDB_HIST_SMALL_COLOR    8
    #define IDB_HIST_LARGE_COLOR    9
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define IDB_HIST_NORMAL         12
    #define IDB_HIST_HOT            13
    #define IDB_HIST_DISABLED       14
    #define IDB_HIST_PRESSED        15
#endif

/* Icon indices for standard bitmaps */
#define STD_CUT                 0
#define STD_COPY                1
#define STD_PASTE               2
#define STD_UNDO                3
#define STD_REDOW               4
#define STD_DELETE              5
#define STD_FILENEW             6
#define STD_FILEOPEN            7
#define STD_FILESAVE            8
#define STD_PRINTPRE            9
#define STD_PROPERTIES          10
#define STD_HELP                11
#define STD_FIND                12
#define STD_REPLACE             13
#define STD_PRINT               14
#define VIEW_LARGEICONS         0
#define VIEW_SMALLICONS         1
#define VIEW_LIST               2
#define VIEW_DETAILS            3
#define VIEW_SORTNAME           4
#define VIEW_SORTSIZE           5
#define VIEW_SORTDATE           6
#define VIEW_SORTTYPE           7
#define VIEW_PARENTFOLDER       8
#define VIEW_NETCONNECT         9
#define VIEW_NETDISCONNECT      10
#define VIEW_NEWFOLDER          11
#if (_WIN32_IE >= 0x0400)
    #define VIEW_VIEWMENU       12
#endif
#if (_WIN32_IE >= 0x0300)
    #define HIST_BACK           0
    #define HIST_FORWARD        1
    #define HIST_FAVORITES      2
    #define HIST_ADDTOFAVORITES 3
    #define HIST_VIEWTREE       4
#endif

/* Toolbar insert mark flags */
#if (_WIN32_IE >= 0x0400)
    #define TBIMHT_AFTER        0x00000001L
    #define TBIMHT_BACKGROUND   0x00000002L
#endif

/* Toolbar bitmap flags */
#define TBBF_LARGE  0x0001

/* Toolbar button information masks */
#if (_WIN32_IE >= 0x0400)
    #define TBIF_IMAGE      0x00000001
    #define TBIF_TEXT       0x00000002
    #define TBIF_STATE      0x00000004
    #define TBIF_STYLE      0x00000008
    #define TBIF_LPARAM     0x00000010
    #define TBIF_COMMAND    0x00000020
    #define TBIF_SIZE       0x00000040
#endif
#if (_WIN32_IE >= 0x0500)
    #define TBIF_BYINDEX    0x80000000
#endif

/* Toolbar metric masks */
#if (_WIN32_WINNT >= 0x0501)
    #define TBMF_PAD            0x00000001
    #define TBMF_BARPAD         0x00000002
    #define TBMF_BUTTONSPACING  0x00000004
#endif

/* Toolbar notifications */
#define TBN_GETBUTTONINFOA      (TBN_FIRST - 0)
#define TBN_BEGINDRAG           (TBN_FIRST - 1)
#define TBN_ENDDRAG             (TBN_FIRST - 2)
#define TBN_BEGINADJUST         (TBN_FIRST - 3)
#define TBN_ENDADJUST           (TBN_FIRST - 4)
#define TBN_RESET               (TBN_FIRST - 5)
#define TBN_QUERYINSERT         (TBN_FIRST - 6)
#define TBN_QUERYDELETE         (TBN_FIRST - 7)
#define TBN_TOOLBARCHANGE       (TBN_FIRST - 8)
#define TBN_CUSTHELP            (TBN_FIRST - 9)
#if (_WIN32_IE >= 0x0300)
    #define TBN_DROPDOWN        (TBN_FIRST - 10)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TBN_GETOBJECT       (TBN_FIRST - 12)
    #define TBN_HOTITEMCHANGE   (TBN_FIRST - 13)
    #define TBN_DRAGOUT         (TBN_FIRST - 14)
    #define TBN_DELETINGBUTTON  (TBN_FIRST - 15)
    #define TBN_GETDISPINFOA    (TBN_FIRST - 16)
    #define TBN_GETDISPINFOW    (TBN_FIRST - 17)
    #define TBN_GETINFOTIPA     (TBN_FIRST - 18)
    #define TBN_GETINFOTIPW     (TBN_FIRST - 19)
    #define TBN_GETBUTTONINFOW  (TBN_FIRST - 20)
#endif
#if (_WIN32_IE >= 0x0500)
    #define TBN_RESTORE         (TBN_FIRST - 21)
    #define TBN_SAVE            (TBN_FIRST - 22)
    #define TBN_INITCUSTOMIZE   (TBN_FIRST - 23)
    #define TBN_WRAPHOTITEM     (TBN_FIRST - 24)
    #define TBN_DUPACCELERATOR  (TBN_FIRST - 25)
    #define TBN_WRAPACCELERATOR (TBN_FIRST - 26)
    #define TBN_DRAGOVER        (TBN_FIRST - 27)
    #define TBN_MAPACCELERATOR  (TBN_FIRST - 28)
#endif
#ifdef UNICODE
    #define TBN_GETBUTTONINFO   TBN_GETBUTTONINFOW
    #if (_WIN32_IE >= 0x0400)
        #define TBN_GETDISPINFO TBN_GETDISPINFOW
        #define TBN_GETINFOTIP  TBN_GETINFOTIPW
    #endif
#else
    #define TBN_GETBUTTONINFO   TBN_GETBUTTONINFOA
    #if (_WIN32_IE >= 0x0400)
        #define TBN_GETDISPINFO TBN_GETDISPINFOA
        #define TBN_GETINFOTIP  TBN_GETINFOTIPA
    #endif
#endif

/* Hot item change flags */
#if (_WIN32_IE >= 0x0400)
    #define HICF_OTHER          0x00000000L
    #define HICF_MOUSE          0x00000001L
    #define HICF_ARROWKEYS      0x00000002L
    #define HICF_ACCELERATOR    0x00000004L
    #define HICF_DUPACCEL       0x00000008L
    #define HICF_ENTERING       0x00000010L
    #define HICF_LEAVING        0x00000020L
    #define HICF_RESELECT       0x00000040L
    #define HICF_LMOUSE         0x00000080L
    #define HICF_TOGGLEDROPDOWN 0x00000100L
#endif

/* TBN_INITCUSTOMIZE return flags */
#if (_WIN32_IE >= 0x0500)
    #define TBNRF_HIDEHELP      0x00000001L
    #define TBNRF_ENDCUSTOMIZE  0x00000002L
#endif

/* Toolbar display information masks */
#if (_WIN32_IE >= 0x0400)
    #define TBNF_IMAGE      0x00000001L
    #define TBNF_TEXT       0x00000002L
    #define TBNF_DI_SETITEM 0x10000000L
#endif

/* TBN_DROPDOWN return codes */
#if (_WIN32_IE >= 0x0400)
    #define TBDDRET_DEFAULT         0L
    #define TBDDRET_NODEFAULT       1L
    #define TBDDRET_TREATPRESSED    2L
#endif

/* Rebar information masks */
#if (_WIN32_IE >= 0x0300)
    #define RBIM_IMAGELIST  0x00000001
#endif

/* Rebar styles */
#if (_WIN32_IE >= 0x0300)
    #define RBS_TOOLTIPS        0x0100L
    #define RBS_VARHEIGHT       0x0200L
    #define RBS_BANDBORDERS     0x0400L
    #define RBS_FIXEDORDER      0x0800L
#endif
#if (_WIN32_IE >= 0x0400)
    #define RBS_REGISTERDROP    0x1000L
    #define RBS_AUTOSIZE        0x2000L
    #define RBS_VERTICALGRIPPER 0x4000L
    #define RBS_DBLCLKTOGGLE    0x8000L
#endif

/* Rebar band styles */
#if (_WIN32_IE >= 0x0300)
    #define RBBS_BREAK          0x00000001
    #define RBBS_FIXEDSIZE      0x00000002
    #define RBBS_CHILDEDGE      0x00000004
    #define RBBS_HIDDEN         0x00000008
    #define RBBS_NOVERT         0x00000010
    #define RBBS_FIXEDBMP       0x00000020
#endif
#if (_WIN32_IE >= 0x0400)
    #define RBBS_VARIABLEHEIGHT 0x00000040
    #define RBBS_GRIPPERALWAYS  0x00000080
    #define RBBS_NOGRIPPER      0x00000100
#endif
#if (_WIN32_IE >= 0x0500)
    #define RBBS_USECHEVRON     0x00000200
#endif
#if (_WIN32_IE >= 0x0501)
    #define RBBS_HIDETITLE      0x00000400
    #define RBBS_TOPALIGN       0x00000800
#endif

/* Rebar band information masks */
#if (_WIN32_IE >= 0x0300)
    #define RBBIM_STYLE             0x00000001
    #define RBBIM_COLORS            0x00000002
    #define RBBIM_TEXT              0x00000004
    #define RBBIM_IMAGE             0x00000008
    #define RBBIM_CHILD             0x00000010
    #define RBBIM_CHILDSIZE         0x00000020
    #define RBBIM_SIZE              0x00000040
    #define RBBIM_BACKGROUND        0x00000080
    #define RBBIM_ID                0x00000100
#endif
#if (_WIN32_IE >= 0x0400)
    #define RBBIM_IDEALSIZE         0x00000200
    #define RBBIM_LPARAM            0x00000400
    #define RBBIM_HEADERSIZE        0x00000800
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define RBBIM_CHEVRONLOCATION   0x00001000
    #define RBBIM_CHEVRONSTATE      0x00002000
#endif

/* Rebar messages */
#if (_WIN32_IE >= 0x0300)
    #define RB_INSERTBANDA      (WM_USER + 1)
    #define RB_DELETEBAND       (WM_USER + 2)
    #define RB_GETBARINFO       (WM_USER + 3)
    #define RB_SETBARINFO       (WM_USER + 4)
    #if (_WIN32_IE < 0x0400)
        #define RB_GETBANDINFO  (WM_USER + 5)
    #endif
    #define RB_SETBANDINFOA     (WM_USER + 6)
    #define RB_SETPARENT        (WM_USER + 7)
#endif
#if (_WIN32_IE >= 0x0400)
    #define RB_HITTEST          (WM_USER + 8)
    #define RB_GETRECT          (WM_USER + 9)
#endif
#if (_WIN32_IE >= 0x0300)
    #define RB_INSERTBANDW      (WM_USER + 10)
    #define RB_SETBANDINFOW     (WM_USER + 11)
    #define RB_GETBANDCOUNT     (WM_USER + 12)
    #define RB_GETROWCOUNT      (WM_USER + 13)
    #define RB_GETROWHEIGHT     (WM_USER + 14)
#endif
#if (_WIN32_IE >= 0x0400)
    #define RB_IDTOINDEX        (WM_USER + 16)
    #define RB_GETTOOLTIPS      (WM_USER + 17)
    #define RB_SETTOOLTIPS      (WM_USER + 18)
    #define RB_SETBKCOLOR       (WM_USER + 19)
    #define RB_GETBKCOLOR       (WM_USER + 20)
    #define RB_SETTEXTCOLOR     (WM_USER + 21)
    #define RB_GETTEXTCOLOR     (WM_USER + 22)
    #define RB_SIZETORECT       (WM_USER + 23)
    #define RB_BEGINDRAG        (WM_USER + 24)
    #define RB_ENDDRAG          (WM_USER + 25)
    #define RB_DRAGMOVE         (WM_USER + 26)
    #define RB_GETBARHEIGHT     (WM_USER + 27)
    #define RB_GETBANDINFOW     (WM_USER + 28)
    #define RB_GETBANDINFOA     (WM_USER + 29)
    #define RB_MINIMIZEBAND     (WM_USER + 30)
    #define RB_MAXIMIZEBAND     (WM_USER + 31)
    #define RB_GETBANDBORDERS   (WM_USER + 34)
    #define RB_SHOWBAND         (WM_USER + 35)
    #define RB_SETPALETTE       (WM_USER + 37)
    #define RB_GETPALETTE       (WM_USER + 38)
    #define RB_MOVEBAND         (WM_USER + 39)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define RB_GETBANDMARGINS   (WM_USER + 40)
#endif
#if (_WIN32_IE >= 0x0600)
    #define RB_SETEXTENDEDSTYLE (WM_USER + 41)
    #define RB_GETEXTENDEDSTYLE (WM_USER + 42)
#endif
#if (_WIN32_IE >= 0x0500)
    #define RB_PUSHCHEVRON      (WM_USER + 43)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define RB_SETBANDWIDTH     (WM_USER + 44)
#endif
#if (_WIN32_IE >= 0x0300)
    #define RB_SETCOLORSCHEME   CCM_SETCOLORSCHEME
    #define RB_GETCOLORSCHEME   CCM_GETCOLORSCHEME
#endif
#if (_WIN32_IE >= 0x0400)
    #define RB_GETDROPTARGET    CCM_GETDROPTARGET
    #define RB_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
    #define RB_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define RB_SETWINDOWTHEME   CCM_SETWINDOWTHEME
#endif
#ifdef UNICODE
    #if (_WIN32_IE >= 0x0300)
        #define RB_INSERTBAND   RB_INSERTBANDW
        #define RB_SETBANDINFO  RB_SETBANDINFOW
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define RB_GETBANDINFO  RB_GETBANDINFOW
    #endif
#else
    #if (_WIN32_IE >= 0x0300)
        #define RB_INSERTBAND   RB_INSERTBANDA
        #define RB_SETBANDINFO  RB_SETBANDINFOA
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define RB_GETBANDINFO  RB_GETBANDINFOA
    #endif
#endif

/* RB_SIZETORECT flags */
#if (_WIN32_WINNT >= 0x0501)
    #define RBSTR_CHANGERECT    0x0001
#endif

/* Rebar notifications */
#if (_WIN32_IE >= 0x0300)
    #define RBN_HEIGHTCHANGE    (RBN_FIRST - 0)
#endif
#if (_WIN32_IE >= 0x0400)
    #define RBN_GETOBJECT       (RBN_FIRST - 1)
    #define RBN_LAYOUTCHANGED   (RBN_FIRST - 2)
    #define RBN_AUTOSIZE        (RBN_FIRST - 3)
    #define RBN_BEGINDRAG       (RBN_FIRST - 4)
    #define RBN_ENDDRAG         (RBN_FIRST - 5)
    #define RBN_DELETINGBAND    (RBN_FIRST - 6)
    #define RBN_DELETEDBAND     (RBN_FIRST - 7)
    #define RBN_CHILDSIZE       (RBN_FIRST - 8)
#endif
#if (_WIN32_IE >= 0x0500)
    #define RBN_CHEVRONPUSHED   (RBN_FIRST - 10)
#endif
#if (_WIN32_IE >= 0x0600)
    #define RBN_SPLITTERDRAG    (RBN_FIRST - 11)
#endif
#if (_WIN32_IE >= 0x0500)
    #define RBN_MINMAX          (RBN_FIRST - 21)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define RBN_AUTOBREAK       (RBN_FIRST - 22)
#endif

/* Rebar notification masks */
#if (_WIN32_IE >= 0x0400)
    #define RBNM_ID     0x00000001L
    #define RBNM_STYLE  0x00000002L
    #define RBNM_LPARAM 0x00000004L
#endif

/* RBN_AUTOBREAK messages */
#if (_WIN32_WINNT >= 0x0501)
    #define RBAB_AUTOSIZE   0x00000001
    #define RBAB_ADDBAND    0x00000002
#endif

/* RB_HITTEST flags */
#if (_WIN32_IE >= 0x0400)
    #define RBHT_NOWHERE    0x00000001
    #define RBHT_CAPTION    0x00000002
    #define RBHT_CLIENT     0x00000003
    #define RBHT_GRABBER    0x00000004
#endif
#if (_WIN32_IE >= 0x0500)
    #define RBHT_CHEVRON    0x00000008
#endif
#if (_WIN32_IE >= 0x0600)
    #define RBHT_SPLITTER   0x00000010
#endif

/* ToolTips styles */
#define TTS_ALWAYSTIP           0x0001L
#define TTS_NOPREFIX            0x0002L
#if (_WIN32_IE >= 0x0500)
    #define TTS_NOANIMATE       0x0010L
    #define TTS_NOFADE          0x0020L
    #define TTS_BALLOON         0x0040L
    #define TTS_CLOSE           0x0080L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TTS_USEVISUALSTYLE  0x0100L
#endif

/* ToolTips flags */
#define TTF_IDISHWND        0x00000001
#define TTF_CENTERTIP       0x00000002
#define TTF_RTLREADING      0x00000004
#define TTF_SUBCLASS        0x00000010
#if (_WIN32_IE >= 0x0300)
    #define TTF_TRACK       0x00000020
    #define TTF_ABSOLUTE    0x00000080
    #define TTF_TRANSPARENT 0x00000100
#endif
#if (_WIN32_IE >= 0x0501)
    #define TTF_PARSELINKS  0x00001000
#endif
#if (_WIN32_IE >= 0x0300)
    #define TTF_DI_SETITEM  0x00008000
#endif

/* ToolTips delay time flags */
#define TTDT_AUTOMATIC  0
#define TTDT_RESHOW     1
#define TTDT_AUTOPOP    2
#define TTDT_INITIAL    3

/* ToolTips icons */
#define TTI_NONE                0
#define TTI_INFO                1
#define TTI_WARNING             2
#define TTI_ERROR               3
#if (_WIN32_WINNT >= 0x0600)
    #define TTI_INFO_LARGE      4
    #define TTI_WARNING_LARGE   5
    #define TTI_ERROR_LARGE     6
#endif

/* ToolTips messages */
#define TTM_ACTIVATE            (WM_USER + 1)
#define TTM_SETDELAYTIME        (WM_USER + 3)
#define TTM_ADDTOOLA            (WM_USER + 4)
#define TTM_DELTOOLA            (WM_USER + 5)
#define TTM_NEWTOOLRECTA        (WM_USER + 6)
#define TTM_RELAYEVENT          (WM_USER + 7)
#define TTM_GETTOOLINFOA        (WM_USER + 8)
#define TTM_SETTOOLINFOA        (WM_USER + 9)
#define TTM_HITTESTA            (WM_USER + 10)
#define TTM_GETTEXTA            (WM_USER + 11)
#define TTM_UPDATETIPTEXTA      (WM_USER + 12)
#define TTM_GETTOOLCOUNT        (WM_USER + 13)
#define TTM_ENUMTOOLSA          (WM_USER + 14)
#define TTM_GETCURRENTTOOLA     (WM_USER + 15)
#define TTM_WINDOWFROMPOINT     (WM_USER + 16)
#if (_WIN32_IE >= 0x0300)
    #define TTM_TRACKACTIVATE   (WM_USER + 17)
    #define TTM_TRACKPOSITION   (WM_USER + 18)
    #define TTM_SETTIPBKCOLOR   (WM_USER + 19)
    #define TTM_SETTIPTEXTCOLOR (WM_USER + 20)
    #define TTM_GETDELAYTIME    (WM_USER + 21)
    #define TTM_GETTIPBKCOLOR   (WM_USER + 22)
    #define TTM_GETTIPTEXTCOLOR (WM_USER + 23)
    #define TTM_SETMAXTIPWIDTH  (WM_USER + 24)
    #define TTM_GETMAXTIPWIDTH  (WM_USER + 25)
    #define TTM_SETMARGIN       (WM_USER + 26)
    #define TTM_GETMARGIN       (WM_USER + 27)
    #define TTM_POP             (WM_USER + 28)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TTM_UPDATE          (WM_USER + 29)
#endif
#if (_WIN32_IE >= 0x0500)
    #define TTM_GETBUBBLESIZE   (WM_USER + 30)
    #define TTM_ADJUSTRECT      (WM_USER + 31)
    #define TTM_SETTITLEA       (WM_USER + 32)
    #define TTM_SETTITLEW       (WM_USER + 33)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TTM_POPUP           (WM_USER + 34)
    #define TTM_GETTITLE        (WM_USER + 35)
#endif
#define TTM_ADDTOOLW            (WM_USER + 50)
#define TTM_DELTOOLW            (WM_USER + 51)
#define TTM_NEWTOOLRECTW        (WM_USER + 52)
#define TTM_GETTOOLINFOW        (WM_USER + 53)
#define TTM_SETTOOLINFOW        (WM_USER + 54)
#define TTM_HITTESTW            (WM_USER + 55)
#define TTM_GETTEXTW            (WM_USER + 56)
#define TTM_UPDATETIPTEXTW      (WM_USER + 57)
#define TTM_ENUMTOOLSW          (WM_USER + 58)
#define TTM_GETCURRENTTOOLW     (WM_USER + 59)
#if (_WIN32_WINNT >= 0x0501)
    #define TTM_SETWINDOWTHEME  CCM_SETWINDOWTHEME
#endif
#ifdef UNICODE
    #define TTM_ADDTOOL         TTM_ADDTOOLW
    #define TTM_DELTOOL         TTM_DELTOOLW
    #define TTM_NEWTOOLRECT     TTM_NEWTOOLRECTW
    #define TTM_GETTOOLINFO     TTM_GETTOOLINFOW
    #define TTM_SETTOOLINFO     TTM_SETTOOLINFOW
    #define TTM_HITTEST         TTM_HITTESTW
    #define TTM_GETTEXT         TTM_GETTEXTW
    #define TTM_UPDATETIPTEXT   TTM_UPDATETIPTEXTW
    #define TTM_ENUMTOOLS       TTM_ENUMTOOLSW
    #define TTM_GETCURRENTTOOL  TTM_GETCURRENTTOOLW
    #if (_WIN32_IE >= 0x0500)
        #define TTM_SETTITLE    TTM_SETTITLEW
    #endif
#else
    #define TTM_ADDTOOL         TTM_ADDTOOLA
    #define TTM_DELTOOL         TTM_DELTOOLA
    #define TTM_NEWTOOLRECT     TTM_NEWTOOLRECTA
    #define TTM_GETTOOLINFO     TTM_GETTOOLINFOA
    #define TTM_SETTOOLINFO     TTM_SETTOOLINFOA
    #define TTM_HITTEST         TTM_HITTESTA
    #define TTM_GETTEXT         TTM_GETTEXTA
    #define TTM_UPDATETIPTEXT   TTM_UPDATETIPTEXTA
    #define TTM_ENUMTOOLS       TTM_ENUMTOOLSA
    #define TTM_GETCURRENTTOOL  TTM_GETCURRENTTOOLA
    #if (_WIN32_IE >= 0x0500)
        #define TTM_SETTITLE    TTM_SETTITLEA
    #endif
#endif

/* ToolTips notifications */
#define TTN_GETDISPINFOA    (TTN_FIRST - 0)
#define TTN_SHOW            (TTN_FIRST - 1)
#define TTN_POP             (TTN_FIRST - 2)
#define TTN_LINKCLICK       (TTN_FIRST - 3)
#define TTN_GETDISPINFOW    (TTN_FIRST - 10)
#ifdef UNICODE
    #define TTN_GETDISPINFO TTN_GETDISPINFOW
#else
    #define TTN_GETDISPINFO TTN_GETDISPINFOA
#endif
#define TTN_NEEDTEXTA       TTN_GETDISPINFOA
#define TTN_NEEDTEXTW       TTN_GETDISPINFOW
#define TTN_NEEDTEXT        TTN_GETDISPINFO

/* Status bar styles */
#define SBARS_SIZEGRIP      0x0100L
#if (_WIN32_IE >= 0x0500)
    #define SBARS_TOOLTIPS  0x0800L
#endif

/* Old status bar style name */
#if (_WIN32_IE >= 0x0400)
    #define SBT_TOOLTIPS    0x0800L
#endif

/* Status bar messages */
#define SB_SETTEXTA             (WM_USER + 1)
#define SB_GETTEXTA             (WM_USER + 2)
#define SB_GETTEXTLENGTHA       (WM_USER + 3)
#define SB_SETPARTS             (WM_USER + 4)
#define SB_GETPARTS             (WM_USER + 6)
#define SB_GETBORDERS           (WM_USER + 7)
#define SB_SETMINHEIGHT         (WM_USER + 8)
#define SB_SIMPLE               (WM_USER + 9)
#define SB_GETRECT              (WM_USER + 10)
#define SB_SETTEXTW             (WM_USER + 11)
#define SB_GETTEXTLENGTHW       (WM_USER + 12)
#define SB_GETTEXTW             (WM_USER + 13)
#if (_WIN32_IE >= 0x0300)
    #define SB_ISSIMPLE         (WM_USER + 14)
#endif
#if (_WIN32_IE >= 0x0400)
    #define SB_SETICON          (WM_USER + 15)
    #define SB_SETTIPTEXTA      (WM_USER + 16)
    #define SB_SETTIPTEXTW      (WM_USER + 17)
    #define SB_GETTIPTEXTA      (WM_USER + 18)
    #define SB_GETTIPTEXTW      (WM_USER + 19)
    #define SB_GETICON          (WM_USER + 20)
    #define SB_SETUNICODEFORMAT CCM_SETUNICODEFORMAT
    #define SB_GETUNICODEFORMAT CCM_GETUNICODEFORMAT
#endif
#define SB_SETBKCOLOR           CCM_SETBKCOLOR
#ifdef UNICODE
    #define SB_SETTEXT          SB_SETTEXTW
    #define SB_GETTEXT          SB_GETTEXTW
    #define SB_GETTEXTLENGTH    SB_GETTEXTLENGTHW
    #define SB_SETTIPTEXT       SB_SETTIPTEXTW
    #define SB_GETTIPTEXT       SB_GETTIPTEXTW
#else
    #define SB_SETTEXT          SB_SETTEXTA
    #define SB_GETTEXT          SB_GETTEXTA
    #define SB_GETTEXTLENGTH    SB_GETTEXTLENGTHA
    #define SB_SETTIPTEXT       SB_SETTIPTEXTA
    #define SB_GETTIPTEXT       SB_GETTIPTEXTA
#endif

/* Status bar types */
#define SBT_NOBORDERS           0x00000100
#define SBT_POPOUT              0x00000200
#define SBT_RTLREADING          0x00000400
#if (_WIN32_IE >= 0x0500)
    #define SBT_NOTABPARSING    0x00000800
#endif
#define SBT_OWNERDRAW           0x00001000

/* Status bar notifications */
#if (_WIN32_IE >= 0x0400)
    #define SBN_SIMPLEMODECHANGE    (SBN_FIRST - 0)
#endif

/* Status bar part special value */
#if (_WIN32_IE >= 0x0500)
    #define SB_SIMPLEID 0x00FF
#endif

/* Track bar styles */
#define TBS_AUTOTICKS               0x0001L
#define TBS_VERT                    0x0002L
#define TBS_HORZ                    0x0000L
#define TBS_TOP                     0x0004L
#define TBS_BOTTOM                  0x0000L
#define TBS_LEFT                    0x0004L
#define TBS_RIGHT                   0x0000L
#define TBS_BOTH                    0x0008L
#define TBS_NOTICKS                 0x0010L
#define TBS_ENABLESELRANGE          0x0020L
#define TBS_FIXEDLENGTH             0x0040L
#define TBS_NOTHUMB                 0x0080L
#if (_WIN32_IE >= 0x0300)
    #define TBS_TOOLTIPS            0x0100L
#endif
#if (_WIN32_IE >= 0x0500)
    #define TBS_REVERSED            0x0200L
#endif
#if (_WIN32_IE >= 0x0501)
    #define TBS_DOWNISLEFT          0x0400L
#endif
#if (_WIN32_IE >= 0x0600)
    #define TBS_NOTIFYBEFOREMOVE    0x0800L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define TBS_TRANSPARENTBKGND    0x1000L
#endif

/* Track bar messages */
#define TBM_GETPOS                  (WM_USER + 0)
#define TBM_GETRANGEMIN             (WM_USER + 1)
#define TBM_GETRANGEMAX             (WM_USER + 2)
#define TBM_GETTIC                  (WM_USER + 3)
#define TBM_SETTIC                  (WM_USER + 4)
#define TBM_SETPOS                  (WM_USER + 5)
#define TBM_SETRANGE                (WM_USER + 6)
#define TBM_SETRANGEMIN             (WM_USER + 7)
#define TBM_SETRANGEMAX             (WM_USER + 8)
#define TBM_CLEARTICS               (WM_USER + 9)
#define TBM_SETSEL                  (WM_USER + 10)
#define TBM_SETSELSTART             (WM_USER + 11)
#define TBM_SETSELEND               (WM_USER + 12)
#define TBM_GETPTICS                (WM_USER + 14)
#define TBM_GETTICPOS               (WM_USER + 15)
#define TBM_GETNUMTICS              (WM_USER + 16)
#define TBM_GETSELSTART             (WM_USER + 17)
#define TBM_GETSELEND               (WM_USER + 18)
#define TBM_CLEARSEL                (WM_USER + 19)
#define TBM_SETTICFREQ              (WM_USER + 20)
#define TBM_SETPAGESIZE             (WM_USER + 21)
#define TBM_GETPAGESIZE             (WM_USER + 22)
#define TBM_SETLINESIZE             (WM_USER + 23)
#define TBM_GETLINESIZE             (WM_USER + 24)
#define TBM_GETTHUMBRECT            (WM_USER + 25)
#define TBM_GETCHANNELRECT          (WM_USER + 26)
#define TBM_SETTHUMBLENGTH          (WM_USER + 27)
#define TBM_GETTHUMBLENGTH          (WM_USER + 28)
#if (_WIN32_IE >= 0x0300)
    #define TBM_SETTOOLTIPS         (WM_USER + 29)
    #define TBM_GETTOOLTIPS         (WM_USER + 30)
    #define TBM_SETTIPSIDE          (WM_USER + 31)
    #define TBM_SETBUDDY            (WM_USER + 32)
    #define TBM_GETBUDDY            (WM_USER + 33)
    #define TBM_SETPOSNOTIFY        (WM_USER + 34)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TBM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
    #define TBM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#endif

/* Track bar tip side flags */
#if (_WIN32_IE >= 0x0300)
    #define TBTS_TOP    0
    #define TBTS_LEFT   1
    #define TBTS_BOTTOM 2
    #define TBTS_RIGHT  3
#endif

/* Track bar commands */
#define TB_LINEUP           0
#define TB_LINEDOWN         1
#define TB_PAGEUP           2
#define TB_PAGEDOWN         3
#define TB_THUMBPOSITION    4
#define TB_THUMBTRACK       5
#define TB_TOP              6
#define TB_BOTTOM           7
#define TB_ENDTRACK         8

/* Track bar custom draw item specifiers */
#if (_WIN32_IE >= 0x0300)
    #define TBCD_TICS       0x00000001L
    #define TBCD_THUMB      0x00000002L
    #define TBCD_CHANNEL    0x00000003L
#endif

/* Track bar notifications */
#if (_WIN32_WINNT >= 0x0600)
    #define TRBN_THUMBPOSCHANGING   (TRBN_FIRST - 1)
#endif

/* Drag list messages */
#define DL_BEGINDRAG    (WM_USER + 133)
#define DL_DRAGGING     (WM_USER + 134)
#define DL_DROPPED      (WM_USER + 135)
#define DL_CANCELDRAG   (WM_USER + 136)

/* Drag list return values */
#define DL_CURSORSET    0L
#define DL_STOPCURSOR   1L
#define DL_COPYCURSOR   2L
#define DL_MOVECURSOR   3L

/* Drag list registered message */
#define DRAGLISTMSGSTRING   TEXT("commctrl_DragListMsg")

/* Up/down minimum and maximum */
#define UD_MAXVAL   0x7FFF
#define UD_MINVAL   (-UD_MAXVAL)

/* Up/down styles */
#define UDS_WRAP            0x0001L
#define UDS_SETBUDDYINT     0x0002L
#define UDS_ALIGNRIGHT      0x0004L
#define UDS_ALIGNLEFT       0x0008L
#define UDS_AUTOBUDDY       0x0010L
#define UDS_ARROWKEYS       0x0020L
#define UDS_HORZ            0x0040L
#define UDS_NOTHOUSANDS     0x0080L
#if (_WIN32_IE >= 0x0300)
    #define UDS_HOTTRACK    0x0100L
#endif

/* Up/down messages */
#define UDM_SETRANGE                (WM_USER + 101)
#define UDM_GETRANGE                (WM_USER + 102)
#define UDM_SETPOS                  (WM_USER + 103)
#define UDM_GETPOS                  (WM_USER + 104)
#define UDM_SETBUDDY                (WM_USER + 105)
#define UDM_GETBUDDY                (WM_USER + 106)
#define UDM_SETACCEL                (WM_USER + 107)
#define UDM_GETACCEL                (WM_USER + 108)
#define UDM_SETBASE                 (WM_USER + 109)
#define UDM_GETBASE                 (WM_USER + 110)
#if (_WIN32_IE >= 0x0400)
    #define UDM_SETRANGE32          (WM_USER + 111)
    #define UDM_GETRANGE32          (WM_USER + 112)
#endif
#if (_WIN32_IE >= 0x0500)
    #define UDM_SETPOS32            (WM_USER + 113)
    #define UDM_GETPOS32            (WM_USER + 114)
#endif
#if (_WIN32_IE >= 0x0400)
    #define UDM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
    #define UDM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#endif

/* Up/down notifications */
#define UDN_DELTAPOS    (UDN_FIRST - 1)

/* Progress bar styles */
#if (_WIN32_IE >= 0x0300)
    #define PBS_SMOOTH          0x0001L
    #define PBS_VERTICAL        0x0004L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define PBS_MARQUEE         0x0008L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define PBS_SMOOTHREVERSE   0x0010L
#endif

/* Progress bar messages */
#define PBM_SETRANGE        (WM_USER + 1)
#define PBM_SETPOS          (WM_USER + 2)
#define PBM_DELTAPOS        (WM_USER + 3)
#define PBM_SETSTEP         (WM_USER + 4)
#define PBM_STEPIT          (WM_USER + 5)
#if (_WIN32_IE >= 0x0300)
    #define PBM_SETRANGE32  (WM_USER + 6)
    #define PBM_GETRANGE    (WM_USER + 7)
    #define PBM_GETPOS      (WM_USER + 8)
#endif
#if (_WIN32_IE >= 0x0400)
    #define PBM_SETBARCOLOR (WM_USER + 9)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define PBM_SETMARQUEE  (WM_USER + 10)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define PBM_GETSTEP     (WM_USER + 13)
    #define PBM_GETBKCOLOR  (WM_USER + 14)
    #define PBM_GETBARCOLOR (WM_USER + 15)
    #define PBM_SETSTATE    (WM_USER + 16)
    #define PBM_GETSTATE    (WM_USER + 17)
#endif
#if (_WIN32_IE >= 0x0300)
    #define PBM_SETBKCOLOR  CCM_SETBKCOLOR
#endif

/* Progress bar states */
#if (_WIN32_WINNT >= 0x0600)
    #define PBST_NORMAL 0x00000001
    #define PBST_ERROR  0x00000002
    #define PBST_PAUSED 0x00000003
#endif

/* Hot key flags */
#define HOTKEYF_SHIFT   0x00000001
#define HOTKEYF_CONTROL 0x00000002
#define HOTKEYF_ALT     0x00000004
#define HOTKEYF_EXT     0x00000008

/* Hot key combination flags */
#define HKCOMB_NONE 0x00000001
#define HKCOMB_S    0x00000002
#define HKCOMB_C    0x00000004
#define HKCOMB_A    0x00000008
#define HKCOMB_SC   0x00000010
#define HKCOMB_SA   0x00000020
#define HKCOMB_CA   0x00000040
#define HKCOMB_SCA  0x00000080

/* Hot key messages */
#define HKM_SETHOTKEY   (WM_USER + 1)
#define HKM_GETHOTKEY   (WM_USER + 2)
#define HKM_SETRULES    (WM_USER + 3)

/* Common control styles */
#define CCS_TOP             0x0001L
#define CCS_NOMOVEY         0x0002L
#define CCS_BOTTOM          0x0003L
#define CCS_NORESIZE        0x0004L
#define CCS_NOPARENTALIGN   0x0008L
#define CCS_ADJUSTABLE      0x0020L
#define CCS_NODIVIDER       0x0040L
#if (_WIN32_IE >= 0x0300)
    #define CCS_VERT        0x0080L
    #define CCS_LEFT        (CCS_VERT | CCS_TOP)
    #define CCS_RIGHT       (CCS_VERT | CCS_BOTTOM)
    #define CCS_NOMOVEX     (CCS_VERT | CCS_NOMOVEY)
#endif

/* Miscellaneous link constants */
#if (_WIN32_WINNT >= 0x0501)
    #define INVALID_LINK_INDEX  (-1)
    #define MAX_LINKID_TEXT     48
    #define L_MAX_URL_LENGTH    2083
#endif

/* Link styles */
#if (_WIN32_WINNT >= 0x0501)
    #define LWS_TRANSPARENT     0x0001L
    #define LWS_IGNORERETURN    0x0002L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LWS_NOPREFIX        0x0004L
    #define LWS_USEVISUALSTYLE  0x0008L
    #define LWS_USECUSTOMTEXT   0x0010L
    #define LWS_RIGHT           0x0020L
#endif

/* Link item masks */
#if (_WIN32_WINNT >= 0x0501)
    #define LIF_ITEMINDEX   0x00000001
    #define LIF_STATE       0x00000002
    #define LIF_ITEMID      0x00000004
    #define LIF_URL         0x00000008
#endif

/* Link item states */
#if (_WIN32_WINNT >= 0x0501)
    #define LIS_FOCUSED         0x00000001
    #define LIS_ENABLED         0x00000002
    #define LIS_VISITED         0x00000004
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LIS_HOTTRACK        0x00000008
    #define LIS_DEFAULTCOLORS   0x00000010
#endif

/* Link messages */
#if (_WIN32_WINNT >= 0x0501)
    #define LM_HITTEST          (WM_USER + 0x0300)
    #define LM_GETIDEALHEIGHT   (WM_USER + 0x0301)
    #define LM_SETITEM          (WM_USER + 0x0302)
    #define LM_GETITEM          (WM_USER + 0x0303)
    #define LM_GETIDEALSIZE     LM_GETIDEALHEIGHT
#endif

/* List view styles */
#define LVS_ICON            0x0000L
#define LVS_REPORT          0x0001L
#define LVS_SMALLICON       0x0002L
#define LVS_LIST            0x0003L
#define LVS_TYPEMASK        0x0003L
#define LVS_SINGLESEL       0x0004L
#define LVS_SHOWSELALWAYS   0x0008L
#define LVS_SORTASCENDING   0x0010L
#define LVS_SORTDESCENDING  0x0020L
#define LVS_SHAREIMAGELISTS 0x0040L
#define LVS_NOLABELWRAP     0x0080L
#define LVS_AUTOARRANGE     0x0100L
#define LVS_EDITLABELS      0x0200L
#define LVS_OWNERDRAWFIXED  0x0400L
#define LVS_ALIGNTOP        0x0000L
#define LVS_ALIGNLEFT       0x0800L
#define LVS_ALIGNMASK       0x0C00L
#if (_WIN32_IE >= 0x0300)
    #define LVS_OWNERDATA   0x1000L
#endif
#define LVS_NOSCROLL        0x2000L
#define LVS_NOCOLUMNHEADER  0x4000L
#define LVS_NOSORTHEADER    0x8000L
#define LVS_TYPESTYLEMASK   0xFC00L

/* List view messages */
#define LVM_GETBKCOLOR                      (LVM_FIRST + 0)
#define LVM_SETBKCOLOR                      (LVM_FIRST + 1)
#define LVM_GETIMAGELIST                    (LVM_FIRST + 2)
#define LVM_SETIMAGELIST                    (LVM_FIRST + 3)
#define LVM_GETITEMCOUNT                    (LVM_FIRST + 4)
#define LVM_GETITEMA                        (LVM_FIRST + 5)
#define LVM_SETITEMA                        (LVM_FIRST + 6)
#define LVM_INSERTITEMA                     (LVM_FIRST + 7)
#define LVM_DELETEITEM                      (LVM_FIRST + 8)
#define LVM_DELETEALLITEMS                  (LVM_FIRST + 9)
#define LVM_GETCALLBACKMASK                 (LVM_FIRST + 10)
#define LVM_SETCALLBACKMASK                 (LVM_FIRST + 11)
#define LVM_GETNEXTITEM                     (LVM_FIRST + 12)
#define LVM_FINDITEMA                       (LVM_FIRST + 13)
#define LVM_GETITEMRECT                     (LVM_FIRST + 14)
#define LVM_SETITEMPOSITION                 (LVM_FIRST + 15)
#define LVM_GETITEMPOSITION                 (LVM_FIRST + 16)
#define LVM_GETSTRINGWIDTHA                 (LVM_FIRST + 17)
#define LVM_HITTEST                         (LVM_FIRST + 18)
#define LVM_ENSUREVISIBLE                   (LVM_FIRST + 19)
#define LVM_SCROLL                          (LVM_FIRST + 20)
#define LVM_REDRAWITEMS                     (LVM_FIRST + 21)
#define LVM_ARRANGE                         (LVM_FIRST + 22)
#define LVM_EDITLABELA                      (LVM_FIRST + 23)
#define LVM_GETEDITCONTROL                  (LVM_FIRST + 24)
#define LVM_GETCOLUMNA                      (LVM_FIRST + 25)
#define LVM_SETCOLUMNA                      (LVM_FIRST + 26)
#define LVM_INSERTCOLUMNA                   (LVM_FIRST + 27)
#define LVM_DELETECOLUMN                    (LVM_FIRST + 28)
#define LVM_GETCOLUMNWIDTH                  (LVM_FIRST + 29)
#define LVM_SETCOLUMNWIDTH                  (LVM_FIRST + 30)
#if (_WIN32_IE >= 0x0300)
    #define LVM_GETHEADER                   (LVM_FIRST + 31)
#endif
#define LVM_CREATEDRAGIMAGE                 (LVM_FIRST + 33)
#define LVM_GETVIEWRECT                     (LVM_FIRST + 34)
#define LVM_GETTEXTCOLOR                    (LVM_FIRST + 35)
#define LVM_SETTEXTCOLOR                    (LVM_FIRST + 36)
#define LVM_GETTEXTBKCOLOR                  (LVM_FIRST + 37)
#define LVM_SETTEXTBKCOLOR                  (LVM_FIRST + 38)
#define LVM_GETTOPINDEX                     (LVM_FIRST + 39)
#define LVM_GETCOUNTPERPAGE                 (LVM_FIRST + 40)
#define LVM_GETORIGIN                       (LVM_FIRST + 41)
#define LVM_UPDATE                          (LVM_FIRST + 42)
#define LVM_SETITEMSTATE                    (LVM_FIRST + 43)
#define LVM_GETITEMSTATE                    (LVM_FIRST + 44)
#define LVM_GETITEMTEXTA                    (LVM_FIRST + 45)
#define LVM_SETITEMTEXTA                    (LVM_FIRST + 46)
#define LVM_SETITEMCOUNT                    (LVM_FIRST + 47)
#define LVM_SORTITEMS                       (LVM_FIRST + 48)
#define LVM_SETITEMPOSITION32               (LVM_FIRST + 49)
#define LVM_GETSELECTEDCOUNT                (LVM_FIRST + 50)
#define LVM_GETITEMSPACING                  (LVM_FIRST + 51)
#define LVM_GETISEARCHSTRINGA               (LVM_FIRST + 52)
#if (_WIN32_IE >= 0x0300)
    #define LVM_SETICONSPACING              (LVM_FIRST + 53)
    #define LVM_SETEXTENDEDLISTVIEWSTYLE    (LVM_FIRST + 54)
    #define LVM_GETEXTENDEDLISTVIEWSTYLE    (LVM_FIRST + 55)
    #define LVM_GETSUBITEMRECT              (LVM_FIRST + 56)
    #define LVM_SUBITEMHITTEST              (LVM_FIRST + 57)
    #define LVM_SETCOLUMNORDERARRAY         (LVM_FIRST + 58)
    #define LVM_GETCOLUMNORDERARRAY         (LVM_FIRST + 59)
    #define LVM_SETHOTITEM                  (LVM_FIRST + 60)
    #define LVM_GETHOTITEM                  (LVM_FIRST + 61)
    #define LVM_SETHOTCURSOR                (LVM_FIRST + 62)
    #define LVM_GETHOTCURSOR                (LVM_FIRST + 63)
    #define LVM_APPROXIMATEVIEWRECT         (LVM_FIRST + 64)
#endif
#if (_WIN32_IE >= 0x0400)
    #define LVM_SETWORKAREAS                (LVM_FIRST + 65)
    #define LVM_GETSELECTIONMARK            (LVM_FIRST + 66)
    #define LVM_SETSELECTIONMARK            (LVM_FIRST + 67)
    #define LVM_SETBKIMAGEA                 (LVM_FIRST + 68)
    #define LVM_GETBKIMAGEA                 (LVM_FIRST + 69)
    #define LVM_GETWORKAREAS                (LVM_FIRST + 70)
    #define LVM_SETHOVERTIME                (LVM_FIRST + 71)
    #define LVM_GETHOVERTIME                (LVM_FIRST + 72)
    #define LVM_GETNUMBEROFWORKAREAS        (LVM_FIRST + 73)
    #define LVM_SETTOOLTIPS                 (LVM_FIRST + 74)
#endif
#define LVM_GETITEMW                        (LVM_FIRST + 75)
#define LVM_SETITEMW                        (LVM_FIRST + 76)
#define LVM_INSERTITEMW                     (LVM_FIRST + 77)
#if (_WIN32_IE >= 0x0400)
    #define LVM_GETTOOLTIPS                 (LVM_FIRST + 78)
    #define LVM_SORTITEMSEX                 (LVM_FIRST + 81)
#endif
#define LVM_FINDITEMW                       (LVM_FIRST + 83)
#define LVM_GETSTRINGWIDTHW                 (LVM_FIRST + 87)
#if (_WIN32_WINNT >= 0x0501)
    #define LVM_GETGROUPSTATE               (LVM_FIRST + 92)
    #define LVM_GETFOCUSEDGROUP             (LVM_FIRST + 93)
#endif
#define LVM_GETCOLUMNW                      (LVM_FIRST + 95)
#define LVM_SETCOLUMNW                      (LVM_FIRST + 96)
#define LVM_INSERTCOLUMNW                   (LVM_FIRST + 97)
#if (_WIN32_WINNT >= 0x0501)
    #define LVM_GETGROUPRECT                (LVM_FIRST + 98)
#endif
#define LVM_GETITEMTEXTW                    (LVM_FIRST + 115)
#define LVM_SETITEMTEXTW                    (LVM_FIRST + 116)
#define LVM_GETISEARCHSTRINGW               (LVM_FIRST + 117)
#define LVM_EDITLABELW                      (LVM_FIRST + 118)
#if (_WIN32_IE >= 0x0400)
    #define LVM_SETBKIMAGEW                 (LVM_FIRST + 138)
    #define LVM_GETBKIMAGEW                 (LVM_FIRST + 139)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define LVM_SETSELECTEDCOLUMN           (LVM_FIRST + 140)
    #define LVM_SETVIEW                     (LVM_FIRST + 142)
    #define LVM_GETVIEW                     (LVM_FIRST + 143)
    #define LVM_INSERTGROUP                 (LVM_FIRST + 145)
    #define LVM_SETGROUPINFO                (LVM_FIRST + 147)
    #define LVM_GETGROUPINFO                (LVM_FIRST + 149)
    #define LVM_REMOVEGROUP                 (LVM_FIRST + 150)
    #define LVM_MOVEGROUP                   (LVM_FIRST + 151)
    #define LVM_GETGROUPCOUNT               (LVM_FIRST + 152)
    #define LVM_GETGROUPINFOBYINDEX         (LVM_FIRST + 153)
    #define LVM_MOVEITEMTOGROUP             (LVM_FIRST + 154)
    #define LVM_SETGROUPMETRICS             (LVM_FIRST + 155)
    #define LVM_GETGROUPMETRICS             (LVM_FIRST + 156)
    #define LVM_ENABLEGROUPVIEW             (LVM_FIRST + 157)
    #define LVM_SORTGROUPS                  (LVM_FIRST + 158)
    #define LVM_INSERTGROUPSORTED           (LVM_FIRST + 159)
    #define LVM_REMOVEALLGROUPS             (LVM_FIRST + 160)
    #define LVM_HASGROUP                    (LVM_FIRST + 161)
    #define LVM_SETTILEVIEWINFO             (LVM_FIRST + 162)
    #define LVM_GETTILEVIEWINFO             (LVM_FIRST + 163)
    #define LVM_SETTILEINFO                 (LVM_FIRST + 164)
    #define LVM_GETTILEINFO                 (LVM_FIRST + 165)
    #define LVM_SETINSERTMARK               (LVM_FIRST + 166)
    #define LVM_GETINSERTMARK               (LVM_FIRST + 167)
    #define LVM_INSERTMARKHITTEST           (LVM_FIRST + 168)
    #define LVM_GETINSERTMARKRECT           (LVM_FIRST + 169)
    #define LVM_SETINSERTMARKCOLOR          (LVM_FIRST + 170)
    #define LVM_GETINSERTMARKCOLOR          (LVM_FIRST + 171)
    #define LVM_SETINFOTIP                  (LVM_FIRST + 173)
    #define LVM_GETSELECTEDCOLUMN           (LVM_FIRST + 174)
    #define LVM_ISGROUPVIEWENABLED          (LVM_FIRST + 175)
    #define LVM_GETOUTLINECOLOR             (LVM_FIRST + 176)
    #define LVM_SETOUTLINECOLOR             (LVM_FIRST + 177)
    #define LVM_CANCELEDITLABEL             (LVM_FIRST + 179)
    #define LVM_MAPINDEXTOID                (LVM_FIRST + 180)
    #define LVM_MAPIDTOINDEX                (LVM_FIRST + 181)
    #define LVM_ISITEMVISIBLE               (LVM_FIRST + 182)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVM_GETEMPTYTEXT                (LVM_FIRST + 204)
    #define LVM_GETFOOTERRECT               (LVM_FIRST + 205)
    #define LVM_GETFOOTERINFO               (LVM_FIRST + 206)
    #define LVM_GETFOOTERITEMRECT           (LVM_FIRST + 207)
    #define LVM_GETFOOTERITEM               (LVM_FIRST + 208)
    #define LVM_GETITEMINDEXRECT            (LVM_FIRST + 209)
    #define LVM_SETITEMINDEXSTATE           (LVM_FIRST + 210)
    #define LVM_GETNEXTITEMINDEX            (LVM_FIRST + 211)
#endif
#if (_WIN32_IE >= 0x0400)
    #define LVM_SETUNICODEFORMAT            CCM_SETUNICODEFORMAT
    #define LVM_GETUNICODEFORMAT            CCM_GETUNICODEFORMAT
#endif
#ifdef UNICODE
    #define LVM_GETITEM                     LVM_GETITEMW
    #define LVM_SETITEM                     LVM_SETITEMW
    #define LVM_INSERTITEM                  LVM_INSERTITEMW
    #define LVM_FINDITEM                    LVM_FINDITEMW
    #define LVM_GETSTRINGWIDTH              LVM_GETSTRINGWIDTHW
    #define LVM_EDITLABEL                   LVM_EDITLABELW
    #define LVM_GETCOLUMN                   LVM_GETCOLUMNW
    #define LVM_SETCOLUMN                   LVM_SETCOLUMNW
    #define LVM_INSERTCOLUMN                LVM_INSERTCOLUMNW
    #define LVM_GETITEMTEXT                 LVM_GETITEMTEXTW
    #define LVM_SETITEMTEXT                 LVM_SETITEMTEXTW
    #define LVM_GETISEARCHSTRING            LVM_GETISEARCHSTRINGW
    #if (_WIN32_IE >= 0x0400)
        #define LVM_SETBKIMAGE              LVM_SETBKIMAGEW
        #define LVM_GETBKIMAGE              LVM_GETBKIMAGEW
    #endif
#else
    #define LVM_GETITEM                     LVM_GETITEMA
    #define LVM_SETITEM                     LVM_SETITEMA
    #define LVM_INSERTITEM                  LVM_INSERTITEMA
    #define LVM_FINDITEM                    LVM_FINDITEMA
    #define LVM_GETSTRINGWIDTH              LVM_GETSTRINGWIDTHA
    #define LVM_EDITLABEL                   LVM_EDITLABELA
    #define LVM_GETCOLUMN                   LVM_GETCOLUMNA
    #define LVM_SETCOLUMN                   LVM_SETCOLUMNA
    #define LVM_INSERTCOLUMN                LVM_INSERTCOLUMNA
    #define LVM_GETITEMTEXT                 LVM_GETITEMTEXTA
    #define LVM_SETITEMTEXT                 LVM_SETITEMTEXTA
    #define LVM_GETISEARCHSTRING            LVM_GETISEARCHSTRINGA
    #if (_WIN32_IE >= 0x0400)
        #define LVM_SETBKIMAGE              LVM_SETBKIMAGEA
        #define LVM_GETBKIMAGE              LVM_GETBKIMAGEA
    #endif
#endif

/* LVM_SETIMAGELIST image list choices */
#define LVSIL_NORMAL        0
#define LVSIL_SMALL         1
#define LVSIL_STATE         2
#define LVSIL_GROUPHEADER   3

/* List view item masks */
#define LVIF_TEXT               0x00000001
#define LVIF_IMAGE              0x00000002
#define LVIF_PARAM              0x00000004
#define LVIF_STATE              0x00000008
#if (_WIN32_IE >= 0x0300)
    #define LVIF_INDENT         0x00000010
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define LVIF_GROUPID        0x00000100
    #define LVIF_COLUMNS        0x00000200
#endif
#if (_WIN32_IE >= 0x0300)
    #define LVIF_NORECOMPUTE    0x00000800
#endif
#define LVIF_DI_SETITEM         0x00001000
#if (_WIN32_WINNT >= 0x0600)
    #define LVIF_COLFMT         0x00010000
#endif

/* List view item states */
#define LVIS_FOCUSED        0x00000001
#define LVIS_SELECTED       0x00000002
#define LVIS_CUT            0x00000004
#define LVIS_DROPHILITED    0x00000008
#define LVIS_GLOW           0x00000010
#define LVIS_ACTIVATING     0x00000020
#define LVIS_OVERLAYMASK    0x00000F00
#define LVIS_STATEIMAGEMASK 0x0000F000

/* Macro to convert image indices to state image masks */
#define INDEXTOSTATEIMAGEMASK( x )  ((x) << 12)

/* Special values for item fields */
#if (_WIN32_IE >= 0x0300)
    #define I_INDENTCALLBACK    (-1)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define I_GROUPIDCALLBACK   (-1)
    #define I_GROUPIDNONE       (-2)
#endif
#define I_IMAGECALLBACK         (-1)
#if (_WIN32_IE >= 0x0300)
    #define I_IMAGENONE         (-2)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define I_COLUMNSCALLBACK   ((UINT)-1)
#endif
#define I_CHILDRENCALLBACK      (-1)
#define LPSTR_TEXTCALLBACKA     ((LPSTR)-1)
#define LPSTR_TEXTCALLBACKW     ((LPWSTR)-1)
#ifdef UNICODE
    #define LPSTR_TEXTCALLBACK  LPSTR_TEXTCALLBACKW
#else
    #define LPSTR_TEXTCALLBACK  LPSTR_TEXTCALLBACKA
#endif

/* LVM_GETNEXTITEM flags */
#define LVNI_ALL            0x0000
#define LVNI_FOCUSED        0x0001
#define LVNI_SELECTED       0x0002
#define LVNI_CUT            0x0004
#define LVNI_DROPHILITED    0x0008
#define LVNI_STATEMASK      (LVNI_FOCUSED | LVNI_SELECTED | LVNI_CUT | LVNI_DROPHILITED)
#define LVNI_VISIBLEORDER   0x0010
#define LVNI_PREVIOUS       0x0020
#define LVNI_VISIBLEONLY    0x0040
#define LVNI_SAMEGROUPONLY  0x0080
#define LVNI_ABOVE          0x0100
#define LVNI_BELOW          0x0200
#define LVNI_TOLEFT         0x0400
#define LVNI_TORIGHT        0x0800
#define LVNI_DIRECTIONMASK  (LVNI_ABOVE | LVNI_BELOW | LVNI_TOLEFT | TVNI_TORIGHT)

/* LVM_FINDITEM flags */
#define LVFI_PARAM      0x00000001
#define LVFI_STRING     0x00000002
#define LVFI_SUBSTRING  0x00000004
#define LVFI_PARTIAL    0x00000008
#define LVFI_WRAP       0x00000020
#define LVFI_NEARESTXY  0x00000040

/* LVM_GETITEMRECT codes */
#define LVIR_BOUNDS         0
#define LVIR_ICON           1
#define LVIR_LABEL          2
#define LVIR_SELECTBOUNDS   3

/* LVM_HITTEST flags */
#define LVHT_NOWHERE                0x00000001
#define LVHT_ONITEMICON             0x00000002
#define LVHT_ONITEMLABEL            0x00000004
#define LVHT_ONITEMSTATEICON        0x00000008
#define LVHT_ONITEM \
    (LVHT_ONITEMICON | LVHT_ONITEMLABEL | LVHT_ONITEMSTATEICON)
#define LVHT_ABOVE                  0x00000008
#define LVHT_BELOW                  0x00000010
#define LVHT_TORIGHT                0x00000020
#define LVHT_TOLEFT                 0x00000040
#define LVHT_EX_GROUP_HEADER        0x10000000
#define LVHT_EX_GROUP_FOOTER        0x20000000
#define LVHT_EX_GROUP_COLLAPSE      0x40000000
#define LVHT_EX_GROUP_BACKGROUND    0x80000000
#define LVHT_EX_GROUP_STATEICON     0x01000000
#define LVHT_EX_GROUP_SUBSETLINK    0x02000000
#define LVHT_EX_GROUP \
    (LVHT_EX_GROUP_BACKGROUND | LVHT_EX_GROUP_COLLAPSE | LVHT_EX_GROUP_FOOTER | \
    LVHT_EX_GROUP_HEADER | LVHT_EX_GROUP_STATEICON | LVHT_EX_GROUP_SUBSETICON)
#define LVHT_EX_ONCONTENTS          0x04000000
#define LVHT_EX_FOOTER              0x08000000

/* LVM_ARRANGE codes */
#define LVA_DEFAULT     0x00000000
#define LVA_ALIGNLEFT   0x00000001
#define LVA_ALIGNTOP    0x00000002
#define LVA_SNAPTOGRID  0x00000005

/* List view column masks */
#define LVCF_FMT                0x00000001
#define LVCF_WIDTH              0x00000002
#define LVCF_TEXT               0x00000004
#define LVCF_SUBITEM            0x00000008
#if (_WIN32_IE >= 0x0300)
    #define LVCF_IMAGE          0x00000010
    #define LVCF_ORDER          0x00000020
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVCF_MINWIDTH       0x00000040
    #define LVCF_DEFAULTWIDTH   0x00000080
    #define LVCF_IDEALWIDTH     0x00000100
#endif

/* List view column formats */
#define LVCFMT_LEFT                     0x00000000
#define LVCFMT_RIGHT                    0x00000001
#define LVCFMT_CENTER                   0x00000002
#define LVCFMT_JUSTIFYMASK              0x00000003
#if (_WIN32_IE >= 0x0300)
    #define LVCFMT_IMAGE                0x00000800
    #define LVCFMT_BITMAP_ON_RIGHT      0x00001000
    #define LVCFMT_COL_HAS_IMAGES       0x00008000
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVCFMT_FIXED_WIDTH          0x00000100
    #define LVCFMT_NO_DPI_SCALE         0x00040000
    #define LVCFMT_FIXED_RATIO          0x00080000
    #define LVCFMT_LINE_BREAK           0x00100000
    #define LVCFMT_FILL                 0x00200000
    #define LVCFMT_WRAP                 0x00400000
    #define LVCFMT_NO_TITLE             0x00800000
    #define LVCFMT_TITLE_PLACEMENTMASK  (LVCFMT_LINE_BREAK | LVCFMT_FILL)
    #define LVCFMT_SPLITBUTTON          0x01000000
#endif

/* LVM_SETCOLUMNWIDTH special values */
#define LVSCW_AUTOSIZE              (-1)
#define LVSCW_AUTOSIZE_USEHEADER    (-2)

/* LVM_SETITEMCOUNT flags for owner draw */
#if (_WIN32_IE >= 0x0300)
    #define LVSICF_NOINVALIDATEALL  0x00000001L
    #define LVSICF_NOSCROLL         0x00000002L
#endif

/* List view extended styles */
#if (_WIN32_IE >= 0x0300)
    #define LVS_EX_GRIDLINES                0x00000001L
    #define LVS_EX_SUBITEMIMAGES            0x00000002L
    #define LVS_EX_CHECKBOXES               0x00000004L
    #define LVS_EX_TRACKSELECT              0x00000008L
    #define LVS_EX_HEADERDRAGDROP           0x00000010L
    #define LVS_EX_FULLROWSELECT            0x00000020L
    #define LVS_EX_ONECLICKACTIVATE         0x00000040L
    #define LVS_EX_TWOCLICKACTIVATE         0x00000080L
#endif
#if (_WIN32_IE >= 0x0400)
    #define LVS_EX_FLATSB                   0x00000100L
    #define LVS_EX_REGIONAL                 0x00000200L
    #define LVS_EX_INFOTIP                  0x00000400L
    #define LVS_EX_UNDERLINEHOT             0x00000800L
    #define LVS_EX_UNDERLINECOLD            0x00001000L
    #define LVS_EX_MULTIWORKAREAS           0x00002000L
#endif
#if (_WIN32_IE >= 0x0500)
    #define LVS_EX_LABELTIP                 0x00004000L
    #define LVS_EX_BORDERSELECT             0x00008000L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define LVS_EX_DOUBLEBUFFER             0x00010000L
    #define LVS_EX_HIDELABELS               0x00020000L
    #define LVS_EX_SINGLEROW                0x00040000L
    #define LVS_EX_SNAPTOGRID               0x00080000L
    #define LVS_EX_SIMPLESELECT             0x00100000L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVS_EX_JUSTIFYCOLUMNS           0x00200000L
    #define LVS_EX_TRANSPARENTBKGND         0x00400000L
    #define LVS_EX_TRANSPARENTSHADOWTEXT    0x00800000L
    #define LVS_EX_AUTOAUTOARRANGE          0x01000000L
    #define LVS_EX_HEADERINALLVIEWS         0x02000000L
    #define LVS_EX_AUTOCHECKSELECT          0x08000000L
    #define LVS_EX_AUTOSIZECOLUMNS          0x10000000L
    #define LVS_EX_COLUMNSNAPPOINTS         0x40000000L
    #define LVS_EX_COLUMNOVERFLOW           0x80000000L
#endif

/* Maximum number of list view work areas */
#if (_WIN32_IE >= 0x0400)
    #define LV_MAX_WORKAREAS    16
#endif

/* List view background image flags */
#if (_WIN32_IE >= 0x0400)
    #define LVBKIF_SOURCE_NONE      0x00000000L
    #define LVBKIF_SOURCE_HBITMAP   0x00000001L
    #define LVBKIF_SOURCE_URL       0x00000002L
    #define LVBKIF_SOURCE_MASK      0x00000003L
    #define LVBKIF_STYLE_NORMAL     0x00000000L
    #define LVBKIF_STYLE_TILE       0x00000010L
    #define LVBKIF_STYLE_MASK       0x00000010L
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define LVBKIF_FLAG_TILEOFFSET  0x00000100L
    #define LVBKIF_TYPE_WATERMARK   0x10000000L
    #define LVBKIF_FLAG_ALPHABLEND  0x20000000L
#endif

/* List view views */
#if (_WIN32_WINNT >= 0x0501)
    #define LV_VIEW_ICON        0x00000000
    #define LV_VIEW_DETAILS     0x00000001
    #define LV_VIEW_SMALLICON   0x00000002
    #define LV_VIEW_LIST        0x00000003
    #define LV_VIEW_TILE        0x00000004
    #define LV_VIEW_MAX         0x00000004
#endif

/* List view group masks */
#if (_WIN32_WINNT >= 0x0501)
    #define LVGF_NONE               0x00000000
    #define LVGF_HEADER             0x00000001
    #define LVGF_FOOTER             0x00000002
    #define LVGF_STATE              0x00000004
    #define LVGF_ALIGN              0x00000008
    #define LVGF_GROUPID            0x00000010
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVGF_SUBTITLE           0x00000100
    #define LVGF_TASK               0x00000200
    #define LVGF_DESCRIPTIONTOP     0x00000400
    #define LVGF_DESCRIPTIONBOTTOM  0x00000800
    #define LVGF_TITLEIMAGE         0x00001000
    #define LVGF_EXTENDEDIMAGE      0x00002000
    #define LVGF_ITEMS              0x00004000
    #define LVGF_SUBSET             0x00008000
    #define LVGF_SUBSETITEMS        0x00010000
#endif

/* List view group states */
#if (_WIN32_WINNT >= 0x0501)
    #define LVGS_NORMAL             0x00000000
    #define LVGS_COLLAPSED          0x00000001
    #define LVGS_HIDDEN             0x00000002
    #define LVGS_NOHEADER           0x00000004
    #define LVGS_COLLAPSIBLE        0x00000008
    #define LVGS_FOCUSED            0x00000010
    #define LVGS_SELECTED           0x00000020
    #define LVGS_SUBSETED           0x00000040
    #define LVGS_SUBSETLINKFOCUSED  0x00000080
#endif

/* List view group alignments */
#if (_WIN32_WINNT >= 0x0501)
    #define LVGA_HEADER_LEFT    0x00000001
    #define LVGA_HEADER_CENTER  0x00000002
    #define LVGA_HEADER_RIGHT   0x00000004
    #define LVGA_FOOTER_LEFT    0x00000008
    #define LVGA_FOOTER_CENTER  0x00000010
    #define LVGA_FOOTER_RIGHT   0x00000020
#endif

/* LVM_GETGROUPRECT types */
#if (_WIN32_WINNT >= 0x0501)
    #define LVGGR_GROUP         0
    #define LVGGR_HEADER        1
    #define LVGGR_LABEL         2
    #define LVGGR_SUBSETLINK    3
#endif

/* List view group metrics masks */
#if (_WIN32_WINNT >= 0x0501)
    #define LVGMF_NONE          0x00000000
    #define LVGMF_BORDERSIZE    0x00000001
    #define LVGMF_BORDERCOLOR   0x00000002
    #define LVGMF_TEXTCOLOR     0x00000004
#endif

/* List view tile view information flags */
#if (_WIN32_WINNT >= 0x0501)
    #define LVTVIF_AUTOSIZE     0x00000000L
    #define LVTVIF_FIXEDWIDTH   0x00000001L
    #define LVTVIF_FIXEDHEIGHT  0x00000002L
    #define LVTVIF_FIXEDSIZE    0x00000003L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVTVIF_EXTENDED     0x00000004L
#endif

/* List view tile view information masks */
#if (_WIN32_WINNT >= 0x0501)
    #define LVTVIM_TILESIZE     0x00000001L
    #define LVTVIM_COLUMNS      0x00000002L
    #define LVTVIM_LABELMARGIN  0x00000004L
#endif

/* List view insert mark flags */
#if (_WIN32_WINNT >= 0x0501)
    #define LVIM_AFTER  0x00000001L
#endif

/* List view footer information masks */
#if (_WIN32_WINNT >= 0x0600)
    #define LVFF_ITEMCOUNT  0x00000001
#endif

/* List view footer information flags */
#if (_WIN32_WINNT >= 0x0600)
    #define LVFIF_TEXT  0x00000001
    #define LVFIF_STATE 0x00000002
#endif

/* List view footer information states */
#if (_WIN32_WINNT >= 0x0600)
    #define LVFIS_FOCUSED   0x00000001
#endif

/* List view key flags */
#if (_WIN32_IE >= 0x0400)
    #define LVKF_ALT        0x00000001
    #define LVKF_CONTROL    0x00000002
    #define LVKF_SHIFT      0x00000004
#endif

/* List view custom draw item types */
#if (_WIN32_IE >= 0x0300)
    #define LVCDI_ITEM      0x00000000L
    #define LVCDI_GROUP     0x00000001L
    #define LVCDI_ITEMSLIST 0x00000002L
#endif

/* List view custom draw return flags */
#if (_WIN32_IE >= 0x0300)
    #define LVCDRF_NOSELECT     0x00010000L
    #define LVCDRF_NOGROUPFRAME 0x00020000L
#endif

/* List view notifications */
#define LVN_ITEMCHANGING                (LVN_FIRST - 0)
#define LVN_ITEMCHANGED                 (LVN_FIRST - 1)
#define LVN_INSERTITEM                  (LVN_FIRST - 2)
#define LVN_DELETEITEM                  (LVN_FIRST - 3)
#define LVN_DELETEALLITEMS              (LVN_FIRST - 4)
#define LVN_BEGINLABELEDITA             (LVN_FIRST - 5)
#define LVN_ENDLABELEDITA               (LVN_FIRST - 6)
#define LVN_COLUMNCLICK                 (LVN_FIRST - 8)
#define LVN_BEGINDRAG                   (LVN_FIRST - 9)
#define LVN_BEGINRDRAG                  (LVN_FIRST - 11)
#if (_WIN32_IE >= 0x0300)
    #define LVN_ODCACHEHINT             (LVN_FIRST - 13)
    #define LVN_ITEMACTIVATE            (LVN_FIRST - 14)
    #define LVN_ODSTATECHANGED          (LVN_FIRST - 15)
#endif
#if (_WIN32_IE >= 0x0400)
    #define LVN_HOTTRACK                (LVN_FIRST - 21)
#endif
#define LVN_GETDISPINFOA                (LVN_FIRST - 50)
#define LVN_SETDISPINFOA                (LVN_FIRST - 51)
#if (_WIN32_IE >= 0x0300)
    #define LVN_ODFINDITEMA             (LVN_FIRST - 52)
#endif
#define LVN_KEYDOWN                     (LVN_FIRST - 55)
#if (_WIN32_IE >= 0x0300)
    #define LVN_MARQUEEBEGIN            (LVN_FIRST - 56)
#endif
#if (_WIN32_IE >= 0x0400)
    #define LVN_GETINFOTIPA             (LVN_FIRST - 57)
    #define LVN_GETINFOTIPW             (LVN_FIRST - 58)
#endif
#if (_WIN32_IE >= 0x0500)
    #define LVN_INCREMENTALSEARCHA      (LVN_FIRST - 62)
    #define LVN_INCREMENTALSEARCHW      (LVN_FIRST - 63)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVN_COLUMNDROPDOWN          (LVN_FIRST - 64)
    #define LVN_COLUMNOVERFLOWCLICK     (LVN_FIRST - 66)
#endif
#define LVN_BEGINLABELEDITW             (LVN_FIRST - 75)
#define LVN_ENDLABELEDITW               (LVN_FIRST - 76)
#define LVN_GETDISPINFOW                (LVN_FIRST - 77)
#define LVN_SETDISPINFOW                (LVN_FIRST - 78)
#if (_WIN32_IE >= 0x0300)
    #define LVN_ODFINDITEMW             (LVN_FIRST - 79)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define LVN_BEGINSCROLL             (LVN_FIRST - 80)
    #define LVN_ENDSCROLL               (LVN_FIRST - 81)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define LVN_LINKCLICK               (LVN_FIRST - 84)
    #define LVN_GETEMPTYMARKUP          (LVN_FIRST - 87)
#endif
#ifdef UNICODE
    #define LVN_BEGINLABELEDIT          LVN_BEGINLABELEDITW
    #define LVN_ENDLABELEDIT            LVN_ENDLABELEDITW
    #define LVN_GETDISPINFO             LVN_GETDISPINFOW
    #define LVN_SETDISPINFO             LVN_SETDISPINFOW
    #if (_WIN32_IE >= 0x0300)
        #define LVN_ODFINDITEM          LVN_ODFINDITEMW
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define LVN_GETINFOTIP          LVN_GETINFOTIPW
    #endif
    #if (_WIN32_IE >= 0x0500)
        #define LVN_INCREMENTALSEARCH   LVN_INCREMENTALSEARCHW
    #endif
#else
    #define LVN_BEGINLABELEDIT          LVN_BEGINLABELEDITA
    #define LVN_ENDLABELEDIT            LVN_ENDLABELEDITA
    #define LVN_GETDISPINFO             LVN_GETDISPINFOA
    #define LVN_SETDISPINFO             LVN_SETDISPINFOA
    #if (_WIN32_IE >= 0x0300)
        #define LVN_ODFINDITEM          LVN_ODFINDITEMA
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define LVN_GETINFOTIP          LVN_GETINFOTIPA
    #endif
    #if (_WIN32_IE >= 0x0500)
        #define LVN_INCREMENTALSEARCH   LVN_INCREMENTALSEARCHA
    #endif
#endif

/* LVN_GETEMPTYMARKUP flags */
#if (_WIN32_WINNT >= 0x0600)
    #define EMF_CENTERED    0x00000001L
#endif

/* LVN_GETINFOTIP flags */
#if (_WIN32_IE >= 0x0400)
    #define LVGIT_UNFOLDED  0x00000001L
#endif

/* LVN_INCREMENTALSEARCH return values */
#if (_WIN32_IE >= 0x0500)
    #define LVNSCH_DEFAULT  (-1L)
    #define LVNSCH_ERROR    (-2L)
    #define LVNSCH_IGNORE   (-3L)
#endif

/* Tree view styles */
#define TVS_HASBUTTONS          0x0001L
#define TVS_HASLINES            0x0002L
#define TVS_LINESATROOT         0x0004L
#define TVS_EDITLABELS          0x0008L
#define TVS_DISABLEDRAGDROP     0x0010L
#define TVS_SHOWSELALWAYS       0x0020L
#if (_WIN32_IE >= 0x0300)
    #define TVS_RTLREADING      0x0040L
    #define TVS_NOTOOLTIPS      0x0080L
    #define TVS_CHECKBOXES      0x0100L
    #define TVS_TRACKSELECT     0x0200L
#endif
#if (_WIN32_IE >= 0x0400)
    #define TVS_SINGLEEXPAND    0x0400L
    #define TVS_INFOTIP         0x0800L
    #define TVS_FULLROWSELECT   0x1000L
    #define TVS_NOSCROLL        0x2000L
    #define TVS_NONEVENHEIGHT   0x4000L
#endif
#if (_WIN32_IE >= 0x0500)
    #define TVS_NOHSCROLL       0x8000L
#endif

/* Tree view extended styles */
#if (_WIN32_WINNT >= 0x0600)
    #define TVS_EX_MULTISELECT          0x00000002L
    #define TVS_EX_DOUBLEBUFFER         0x00000004L
    #define TVS_EX_NOINDENTSTATE        0x00000008L
    #define TVS_EX_RICHTOOLTIP          0x00000010L
    #define TVS_EX_AUTOHSCROLL          0x00000020L
    #define TVS_EX_FADEINOUTEXPANDOS    0x00000040L
    #define TVS_EX_PARTIALCHECKBOXES    0x00000080L
    #define TVS_EX_EXCLUSIONCHECKBOXES  0x00000100L
    #define TVS_EX_DIMMEDCHECKBOXES     0x00000200L
    #define TVS_EX_DRAWIMAGEASYNC       0x00000400L
#endif

/* Tree view item masks */
#define TVIF_TEXT               0x00000001
#define TVIF_IMAGE              0x00000002
#define TVIF_PARAM              0x00000004
#define TVIF_STATE              0x00000008
#define TVIF_HANDLE             0x00000010
#define TVIF_SELECTEDIMAGE      0x00000020
#define TVIF_CHILDREN           0x00000040
#if (_WIN32_IE >= 0x0400)
    #define TVIF_INTEGRAL       0x00000080
#endif
#if (_WIN32_IE >= 0x0600)
    #define TVIF_STATEEX        0x00000100
    #define TVIF_EXPANDEDIMAGE  0x00000200
#endif
#define TVIF_DI_SETITEM         0x00001000

/* Tree view item states */
#define TVIS_SELECTED           0x00000002
#define TVIS_CUT                0x00000004
#define TVIS_DROPHILITED        0x00000008
#define TVIS_BOLD               0x00000010
#define TVIS_EXPANDED           0x00000020
#define TVIS_EXPANDEDONCE       0x00000040
#if (_WIN32_IE >= 0x0300)
    #define TVIS_EXPANDPARTIAL  0x00000080
#endif
#define TVIS_OVERLAYMASK        0x00000F00
#define TVIS_STATEIMAGEMASK     0x0000F000
#define TVIS_USERMASK           0x0000F000

/* Tree view item extended states */
#if (_WIN32_IE >= 0x0600)
    #define TVIS_EX_FLAT        0x00000001
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TVIS_EX_DISABLED    0x00000002
#endif
#if (_WIN32_IE >= 0x0600)
    #define TVIS_EX_ALL         0x00000002
#endif

/* Tree view item handle special values */
#define TVI_ROOT    ((HTREEITEM)(ULONG_PTR)-0x10000)
#define TVI_FIRST   ((HTREEITEM)(ULONG_PTR)-0x0FFFF)
#define TVI_LAST    ((HTREEITEM)(ULONG_PTR)-0x0FFFE)
#define TVI_SORT    ((HTREEITEM)(ULONG_PTR)-0x0FFFD)

/* Tree view messages */
#define TVM_INSERTITEMA             (TV_FIRST + 0)
#define TVM_DELETEITEM              (TV_FIRST + 1)
#define TVM_EXPAND                  (TV_FIRST + 2)
#define TVM_GETITEMRECT             (TV_FIRST + 4)
#define TVM_GETCOUNT                (TV_FIRST + 5)
#define TVM_GETINDENT               (TV_FIRST + 6)
#define TVM_SETINDENT               (TV_FIRST + 7)
#define TVM_GETIMAGELIST            (TV_FIRST + 8)
#define TVM_SETIMAGELIST            (TV_FIRST + 9)
#define TVM_GETNEXTITEM             (TV_FIRST + 10)
#define TVM_SELECTITEM              (TV_FIRST + 11)
#define TVM_GETITEMA                (TV_FIRST + 12)
#define TVM_SETITEMA                (TV_FIRST + 13)
#define TVM_EDITLABELA              (TV_FIRST + 14)
#define TVM_GETEDITCONTROL          (TV_FIRST + 15)
#define TVM_GETVISIBLECOUNT         (TV_FIRST + 16)
#define TVM_HITTEST                 (TV_FIRST + 17)
#define TVM_CREATEDRAGIMAGE         (TV_FIRST + 18)
#define TVM_SORTCHILDREN            (TV_FIRST + 19)
#define TVM_ENSUREVISIBLE           (TV_FIRST + 20)
#define TVM_SORTCHILDRENCB          (TV_FIRST + 21)
#define TVM_ENDEDITLABELNOW         (TV_FIRST + 22)
#define TVM_GETISEARCHSTRINGA       (TV_FIRST + 23)
#if (_WIN32_IE >= 0x0300)
    #define TVM_SETTOOLTIPS         (TV_FIRST + 24)
    #define TVM_GETTOOLTIPS         (TV_FIRST + 25)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TVM_SETINSERTMARK       (TV_FIRST + 26)
    #define TVM_SETITEMHEIGHT       (TV_FIRST + 27)
    #define TVM_GETITEMHEIGHT       (TV_FIRST + 28)
    #define TVM_SETBKCOLOR          (TV_FIRST + 29)
    #define TVM_SETTEXTCOLOR        (TV_FIRST + 30)
    #define TVM_GETBKCOLOR          (TV_FIRST + 31)
    #define TVM_GETTEXTCOLOR        (TV_FIRST + 32)
    #define TVM_SETSCROLLTIME       (TV_FIRST + 33)
    #define TVM_GETSCROLLTIME       (TV_FIRST + 34)
    #define TVM_SETINSERTMARKCOLOR  (TV_FIRST + 37)
    #define TVM_GETINSERTMARKCOLOR  (TV_FIRST + 38)
#endif
#if (_WIN32_IE >= 0x0500)
    #define TVM_GETITEMSTATE        (TV_FIRST + 39)
    #define TVM_SETLINECOLOR        (TV_FIRST + 40)
    #define TVM_GETLINECOLOR        (TV_FIRST + 41)
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TVM_MAPACCIDTOHTREEITEM (TV_FIRST + 42)
    #define TVM_MAPHTREEITEMTOACCID (TV_FIRST + 43)
    #define TVM_SETEXTENDEDSTYLE    (TV_FIRST + 44)
    #define TVM_GETEXTENDEDSTYLE    (TV_FIRST + 45)
#endif
#define TVM_INSERTITEMW             (TV_FIRST + 50)
#if (_WIN32_WINNT >= 0x0501)
    #define TVM_SETAUTOSCROLLINFO   (TV_FIRST + 59)
#endif
#define TVM_GETITEMW                (TV_FIRST + 62)
#define TVM_SETITEMW                (TV_FIRST + 63)
#define TVM_GETISEARCHSTRINGW       (TV_FIRST + 64)
#define TVM_EDITLABELW              (TV_FIRST + 65)
#if (_WIN32_WINNT >= 0x0600)
    #define TVM_GETSELECTEDCOUNT    (TV_FIRST + 70)
    #define TVM_SHOWINFOTIP         (TV_FIRST + 71)
    #define TVM_GETITEMPARTRECT     (TV_FIRST + 72)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TVM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
    #define TVM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#endif
#ifdef UNICODE
    #define TVM_INSERTITEM          TVM_INSERTITEMW
    #define TVM_GETITEM             TVM_GETITEMW
    #define TVM_SETITEM             TVM_SETITEMW
    #define TVM_EDITLABEL           TVM_EDITLABELW
    #define TVM_GETISEARCHSTRING    TVM_GETISEARCHSTRINGW
#else
    #define TVM_INSERTITEM          TVM_INSERTITEMA
    #define TVM_GETITEM             TVM_GETITEMA
    #define TVM_SETITEM             TVM_SETITEMA
    #define TVM_EDITLABEL           TVM_EDITLABELA
    #define TVM_GETISEARCHSTRING    TVM_GETISEARCHSTRINGA
#endif

/* TVM_EXPAND codes */
#define TVE_COLLAPSE            0x00000001
#define TVE_EXPAND              0x00000002
#define TVE_TOGGLE              0x00000003
#if (_WIN32_IE >= 0x0300)
    #define TVE_EXPANDPARTIAL   0x00004000
#endif
#define TVE_COLLAPSERESET       0x00008000

/* TVM_SETIMAGELIST image list choices */
#define TVSIL_NORMAL    0
#define TVSIL_STATE     1

/* TVM_GETNEXTITEM codes */
#define TVGN_ROOT               0x00000000
#define TVGN_NEXT               0x00000001
#define TVGN_PREVIOUS           0x00000002
#define TVGN_PARENT             0x00000003
#define TVGN_CHILD              0x00000004
#define TVGN_FIRSTVISIBLE       0x00000005
#define TVGN_NEXTVISIBLE        0x00000006
#define TVGN_PREVIOUSVISIBLE    0x00000007
#define TVGN_DROPHILITE         0x00000008
#define TVGN_CARET              0x00000009
#if (_WIN32_IE >= 0x0400)
    #define TVGN_LASTVISIBLE    0x0000000A
#endif
#if (_WIN32_IE >= 0x0600)
    #define TVGN_NEXTSELECTED   0x0000000B
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TVGN_NOSINGLEEXPAND 0x00008000
#endif

/* TVM_HITTEST flags */
#define TVHT_NOWHERE            0x00000001
#define TVHT_ONITEMICON         0x00000002
#define TVHT_ONITEMLABEL        0x00000004
#define TVHT_ONITEMINDENT       0x00000008
#define TVHT_ONITEMBUTTON       0x00000010
#define TVHT_ONITEMRIGHT        0x00000020
#define TVHT_ONITEMSTATEICON    0x00000040
#define TVHT_ABOVE              0x00000100
#define TVHT_BELOW              0x00000200
#define TVHT_TORIGHT            0x00000400
#define TVHT_TOLEFT             0x00000800
#define TVHT_ONITEM \
    (TVHT_ONITEMICON | TVHT_ONITEMLABEL | TVHT_ONITEMSTATEICON)

/* Tree view notifications */
#define TVN_SELCHANGINGA            (TVN_FIRST - 1)
#define TVN_SELCHANGEDA             (TVN_FIRST - 2)
#define TVN_GETDISPINFOA            (TVN_FIRST - 3)
#define TVN_SETDISPINFOA            (TVN_FIRST - 4)
#define TVN_ITEMEXPANDINGA          (TVN_FIRST - 5)
#define TVN_ITEMEXPANDEDA           (TVN_FIRST - 6)
#define TVN_BEGINDRAGA              (TVN_FIRST - 7)
#define TVN_BEGINRDRAGA             (TVN_FIRST - 8)
#define TVN_DELETEITEMA             (TVN_FIRST - 9)
#define TVN_BEGINLABELEDITA         (TVN_FIRST - 10)
#define TVN_ENDLABELEDITA           (TVN_FIRST - 11)
#define TVN_KEYDOWN                 (TVN_FIRST - 12)
#if (_WIN32_IE >= 0x0400)
    #define TVN_GETINFOTIPA         (TVN_FIRST - 13)
    #define TVN_GETINFOTIPW         (TVN_FIRST - 14)
    #define TVN_SINGLEEXPAND        (TVN_FIRST - 15)
#endif
#if (_WIN32_IE >= 0x0600)
    #define TVN_ITEMCHANGINGA       (TVN_FIRST - 16)
    #define TVN_ITEMCHANGINGW       (TVN_FIRST - 17)
    #define TVN_ITEMCHANGEDA        (TVN_FIRST - 18)
    #define TVN_ITEMCHANGEDW        (TVN_FIRST - 19)
    #define TVN_ASYNCDRAW           (TVN_FIRST - 20)
#endif
#define TVN_SELCHANGINGW            (TVN_FIRST - 50)
#define TVN_SELCHANGEDW             (TVN_FIRST - 51)
#define TVN_GETDISPINFOW            (TVN_FIRST - 52)
#define TVN_SETDISPINFOW            (TVN_FIRST - 53)
#define TVN_ITEMEXPANDINGW          (TVN_FIRST - 54)
#define TVN_ITEMEXPANDEDW           (TVN_FIRST - 55)
#define TVN_BEGINDRAGW              (TVN_FIRST - 56)
#define TVN_BEGINRDRAGW             (TVN_FIRST - 57)
#define TVN_DELETEITEMW             (TVN_FIRST - 58)
#define TVN_BEGINLABELEDITW         (TVN_FIRST - 59)
#define TVN_ENDLABELEDITW           (TVN_FIRST - 60)
#ifdef UNICODE
    #define TVN_SELCHANGING         TVN_SELCHANGINGW
    #define TVN_SELCHANGED          TVN_SELCHANGEDW
    #define TVN_GETDISPINFO         TVN_GETDISPINFOW
    #define TVN_SETDISPINFO         TVN_SETDISPINFOW
    #define TVN_ITEMEXPANDING       TVN_ITEMEXPANDINGW
    #define TVN_ITEMEXPANDED        TVN_ITEMEXPANDEDW
    #define TVN_BEGINDRAG           TVN_BEGINDRAGW
    #define TVN_BEGINRDRAG          TVN_BEGINRDRAGW
    #define TVN_DELETEITEM          TVN_DELETEITEMW
    #define TVN_BEGINLABELEDIT      TVN_BEGINLABELEDITW
    #define TVN_ENDLABELEDIT        TVN_ENDLABELEDITW
    #if (_WIN32_IE >= 0x0400)
        #define TVN_GETINFOTIP      TVN_GETINFOTIPW
    #endif
    #if (_WIN32_IE >= 0x0600)
        #define TVN_ITEMCHANGING    TVN_ITEMCHANGINGW
        #define TVN_ITEMCHANGED     TVN_ITEMCHANGEDW
    #endif
#else
    #define TVN_SELCHANGING         TVN_SELCHANGINGA
    #define TVN_SELCHANGED          TVN_SELCHANGEDA
    #define TVN_GETDISPINFO         TVN_GETDISPINFOA
    #define TVN_SETDISPINFO         TVN_SETDISPINFOA
    #define TVN_ITEMEXPANDING       TVN_ITEMEXPANDINGA
    #define TVN_ITEMEXPANDED        TVN_ITEMEXPANDEDA
    #define TVN_BEGINDRAG           TVN_BEGINDRAGA
    #define TVN_BEGINRDRAG          TVN_BEGINRDRAGA
    #define TVN_DELETEITEM          TVN_DELETEITEMA
    #define TVN_BEGINLABELEDIT      TVN_BEGINLABELEDITA
    #define TVN_ENDLABELEDIT        TVN_ENDLABELEDITA
    #if (_WIN32_IE >= 0x0400)
        #define TVN_GETINFOTIP      TVN_GETINFOTIPA
    #endif
    #if (_WIN32_IE >= 0x0600)
        #define TVN_ITEMCHANGING    TVN_ITEMCHANGINGA
        #define TVN_ITEMCHANGED     TVN_ITEMCHANGEDA
    #endif
#endif

/* Tree view notification actions */
#define TVC_UNKNOWN     0x00000000
#define TVC_BYMOUSE     0x00000001
#define TVC_BYKEYBOARD  0x00000002

/* TVN_SINGLEEXPAND return values */
#if (_WIN32_IE >= 0x0400)
    #define TVNRET_DEFAULT  0
    #define TVNRET_SKIPOLD  1
    #define TVNRET_SKIPNEW  2
#endif

/* Tree view custom draw return flags */
#if (_WIN32_IE >= 0x0400)
    #define TVCDRF_NOIMAGES 0x00010000L
#endif

/* Extended combo box item masks */
#if (_WIN32_IE >= 0x0300)
    #define CBEIF_TEXT          0x00000001
    #define CBEIF_IMAGE         0x00000002
    #define CBEIF_SELECTEDIMAGE 0x00000004
    #define CBEIF_OVERLAY       0x00000008
    #define CBEIF_INDENT        0x00000010
    #define CBEIF_LPARAM        0x00000020
    #define CBEIF_DI_SETITEM    0x10000000
#endif

/* Extended combo box messages */
#if (_WIN32_IE >= 0x0300)
    #define CBEM_INSERTITEMA        (WM_USER + 1)
    #define CBEM_SETIMAGELIST       (WM_USER + 2)
    #define CBEM_GETIMAGELIST       (WM_USER + 3)
    #define CBEM_GETITEMA           (WM_USER + 4)
    #define CBEM_SETITEMA           (WM_USER + 5)
    #define CBEM_DELETEITEM         CB_DELETESTRING
    #define CBEM_GETCOMBOCONTROL    (WM_USER + 6)
    #define CBEM_GETEDITCONTROL     (WM_USER + 7)
    #define CBEM_SETEXSTYLE         (WM_USER + 8)
    #define CBEM_GETEXSTYLE         (WM_USER + 9)
    #define CBEM_HASEDITCHANGED     (WM_USER + 10)
    #define CBEM_INSERTITEMW        (WM_USER + 11)
    #define CBEM_SETITEMW           (WM_USER + 12)
    #define CBEM_GETITEMW           (WM_USER + 13)
#endif
#if (_WIN32_IE >= 0x0400)
    #define CBEM_SETEXTENDEDSTYLE   (WM_USER + 14)
    #define CBEM_GETEXTENDEDSTYLE   CBEM_GETEXSTYLE
    #define CBEM_SETUNICODEFORMAT   CCM_SETUNICODEFORMAT
    #define CBEM_GETUNICODEFORMAT   CCM_GETUNICODEFORMAT
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define CBEM_SETWINDOWTHEME     CCM_SETWINDOWTHEME
#endif
#ifdef UNICODE
    #if (_WIN32_IE >= 0x0300)
        #define CBEM_INSERTITEM     CBEM_INSERTITEMW
        #define CBEM_GETITEM        CBEM_GETITEMW
        #define CBEM_SETITEM        CBEM_SETITEMW
    #endif
#else
    #if (_WIN32_IE >= 0x0300)
        #define CBEM_INSERTITEM     CBEM_INSERTITEMA
        #define CBEM_GETITEM        CBEM_GETITEMA
        #define CBEM_SETITEM        CBEM_SETITEMA
    #endif
#endif

/* Extended combo box extended styles */
#if (_WIN32_IE >= 0x0300)
    #define CBES_EX_NOEDITIMAGE         0x00000001L
    #define CBES_EX_NOEDITIMAGEINDENT   0x00000002L
    #define CBES_EX_PATHWORDBREAKPROC   0x00000004L
#endif
#if (_WIN32_IE >= 0x0400)
    #define CBES_EX_NOSIZELIMIT         0x00000008L
    #define CBES_EX_CASESENSITIVE       0x00000010L
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define CBES_EX_TEXTENDELLIPSIS     0x00000020L
#endif

/* Extended combo box notifications */
#if (_WIN32_IE >= 0x0400)
    #define CBEN_GETDISPINFOA   (CBEN_FIRST - 0)
#elif (_WIN32_IE >= 0x0300)
    #define CBEN_GETDISPINFO    (CBEN_FIRST - 0)
#endif
#if (_WIN32_IE >= 0x0300)
    #define CBEN_INSERTITEM     (CBEN_FIRST - 1)
    #define CBEN_DELETEITEM     (CBEN_FIRST - 2)
    #define CBEN_BEGINEDIT      (CBEN_FIRST - 4)
    #define CBEN_ENDEDITA       (CBEN_FIRST - 5)
    #define CBEN_ENDEDITW       (CBEN_FIRST - 6)
#endif
#if (_WIN32_IE >= 0x0400)
    #define CBEN_GETDISPINFOW   (CBEN_FIRST - 7)
    #define CBEN_DRAGBEGINA     (CBEN_FIRST - 8)
    #define CBEN_DRAGBEGINW     (CBEN_FIRST - 9)
#endif
#ifdef UNICODE
    #if (_WIN32_IE >= 0x0400)
        #define CBEN_GETDISPINFO    CBEN_GETDISPINFOW
    #endif
    #if (_WIN32_IE >= 0x0300)
        #define CBEN_ENDEDIT        CBEN_ENDEDITW
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define CBEN_DRAGBEGIN      CBEN_DRAGBEGINW
    #endif
#else
    #if (_WIN32_IE >= 0x0400)
        #define CBEN_GETDISPINFO    CBEN_GETDISPINFOA
    #endif
    #if (_WIN32_IE >= 0x0300)
        #define CBEN_ENDEDIT        CBEN_ENDEDITA
    #endif
    #if (_WIN32_IE >= 0x0400)
        #define CBEN_DRAGBEGIN      CBEN_DRAGBEGINA
    #endif
#endif

/* CBEN_ENDEDIT reasons */
#if (_WIN32_IE >= 0x0300)
    #define CBENF_KILLFOCUS 1
    #define CBENF_RETURN    2
    #define CBENF_ESCAPE    3
    #define CBENF_DROPDOWN  4
#endif

/* Maximum extended combo box string length */
#if (_WIN32_IE >= 0x0300)
    #define CBEMAXSTRLEN    260
#endif

/* Tab control styles */
#if (_WIN32_IE >= 0x0300)
    #define TCS_SCROLLOPPOSITE  0x0001L
    #define TCS_BOTTOM          0x0002L
    #define TCS_RIGHT           0x0002L
    #define TCS_MULTISELECT     0x0004L
#endif
#if (_WIN32_IE >= 0x0400)
    #define TCS_FLATBUTTONS     0x0008L
#endif
#define TCS_FORCEICONLEFT       0x0010L
#define TCS_FORCELABELLEFT      0x0020L
#if (_WIN32_IE >= 0x0300)
    #define TCS_HOTTRACK        0x0040L
    #define TCS_VERTICAL        0x0080L
#endif
#define TCS_TABS                0x0000L
#define TCS_BUTTONS             0x0100L
#define TCS_SINGLELINE          0x0000L
#define TCS_MULTILINE           0x0200L
#define TCS_RIGHTJUSTIFY        0x0000L
#define TCS_FIXEDWIDTH          0x0400L
#define TCS_RAGGEDRIGHT         0x0800L
#define TCS_FOCUSONBUTTONDOWN   0x1000L
#define TCS_OWNERDRAWFIXED      0x2000L
#define TCS_TOOLTIPS            0x4000L
#define TCS_FOCUSNEVER          0x8000L

/* Tab control extended styles */
#if (_WIN32_IE >= 0x0400)
    #define TCS_EX_FLATSEPARATORS   0x00000001L
    #define TCS_EX_REGISTERDROP     0x00000002L
#endif

/* Tab control messages */
#define TCM_GETIMAGELIST            (TCM_FIRST + 2)
#define TCM_SETIMAGELIST            (TCM_FIRST + 3)
#define TCM_GETITEMCOUNT            (TCM_FIRST + 4)
#define TCM_GETITEMA                (TCM_FIRST + 5)
#define TCM_SETITEMA                (TCM_FIRST + 6)
#define TCM_INSERTITEMA             (TCM_FIRST + 7)
#define TCM_DELETEITEM              (TCM_FIRST + 8)
#define TCM_DELETEALLITEMS          (TCM_FIRST + 9)
#define TCM_GETITEMRECT             (TCM_FIRST + 10)
#define TCM_GETCURSEL               (TCM_FIRST + 11)
#define TCM_SETCURSEL               (TCM_FIRST + 12)
#define TCM_HITTEST                 (TCM_FIRST + 13)
#define TCM_SETITEMEXTRA            (TCM_FIRST + 14)
#define TCM_ADJUSTRECT              (TCM_FIRST + 40)
#define TCM_SETITEMSIZE             (TCM_FIRST + 41)
#define TCM_REMOVEIMAGE             (TCM_FIRST + 42)
#define TCM_SETPADDING              (TCM_FIRST + 43)
#define TCM_GETROWCOUNT             (TCM_FIRST + 44)
#define TCM_GETTOOLTIPS             (TCM_FIRST + 45)
#define TCM_SETTOOLTIPS             (TCM_FIRST + 46)
#define TCM_GETCURFOCUS             (TCM_FIRST + 47)
#define TCM_SETCURFOCUS             (TCM_FIRST + 48)
#if (_WIN32_IE >= 0x0300)
    #define TCM_SETMINTABWIDTH      (TCM_FIRST + 49)
    #define TCM_DESELECTALL         (TCM_FIRST + 50)
#endif
#if (_WIN32_IE >= 0x0400)
    #define TCM_HIGHLIGHTITEM       (TCM_FIRST + 51)
    #define TCM_SETEXTENDEDSTYLE    (TCM_FIRST + 52)
    #define TCM_GETEXTENDEDSTYLE    (TCM_FIRST + 53)
#endif
#define TCM_GETITEMW                (TCM_FIRST + 60)
#define TCM_SETITEMW                (TCM_FIRST + 61)
#define TCM_INSERTITEMW             (TCM_FIRST + 62)
#if (_WIN32_IE >= 0x0400)
    #define TCM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
    #define TCM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#endif
#ifdef UNICODE
    #define TCM_GETITEM             TCM_GETITEMW
    #define TCM_SETITEM             TCM_SETITEMW
    #define TCM_INSERTITEM          TCM_INSERTITEMW
#else
    #define TCM_GETITEM             TCM_GETITEMA
    #define TCM_SETITEM             TCM_SETITEMA
    #define TCM_INSERTITEM          TCM_INSERTITEMA
#endif

/* Tab control item masks */
#define TCIF_TEXT           0x00000001
#define TCIF_IMAGE          0x00000002
#define TCIF_RTLREADING     0x00000004
#define TCIF_PARAM          0x00000008
#if (_WIN32_IE >= 0x0300)
    #define TCIF_STATE      0x00000010
#endif

/* Tab control item states */
#if (_WIN32_IE >= 0x0300)
    #define TCIF_BUTTONPRESSED  0x00000001
#endif
#if (_WIN32_IE >= 0x0400)
    #define TCIF_HIGHLIGHTED    0x00000002
#endif

/* TCM_HITTEST flags */
#define TCHT_NOWHERE        0x00000001
#define TCHT_ONITEMICON     0x00000002
#define TCHT_ONITEMLABEL    0x00000004
#define TCHT_ONITEM         (TCHT_ONITEMICON | TCHT_ONITEMLABEL)

/* Tab control notifications */
#define TCN_KEYDOWN         (TCN_FIRST - 0)
#define TCN_SELCHANGE       (TCN_FIRST - 1)
#define TCN_SELCHANGING     (TCN_FIRST - 2)
#if (_WIN32_IE >= 0x0400)
    #define TCN_GETOBJECT   (TCN_FIRST - 3)
#endif
#if (_WIN32_IE >= 0x0500)
    #define TCN_FOCUSCHANGE (TCN_FIRST - 4)
#endif

/* Animation control styles */
#define ACS_CENTER      0x0001L
#define ACS_TRANSPARENT 0x0002L
#define ACS_AUTOPLAY    0x0004L
#if (_WIN32_IE >= 0x0300)
    #define ACS_TIMER   0x0008L
#endif

/* Animation control messages */
#define ACM_OPENA       (WM_USER + 100)
#define ACM_PLAY        (WM_USER + 101)
#define ACM_STOP        (WM_USER + 102)
#define ACM_OPENW       (WM_USER + 103)
#define ACM_ISPLAYING   (WM_USER + 104)
#ifdef UNICODE
    #define ACM_OPEN    ACM_OPENW
#else
    #define ACM_OPEN    ACM_OPENA
#endif

/* Animation control notifications */
#define ACN_START   1
#define ACN_STOP    2

/* Month calendar messages */
#if (_WIN32_IE >= 0x0300)
    #define MCM_FIRST               0x1000
    #define MCM_GETCURSEL           (MCM_FIRST + 1)
    #define MCM_SETCURSEL           (MCM_FIRST + 2)
    #define MCM_GETMAXSELCOUNT      (MCM_FIRST + 3)
    #define MCM_SETMAXSELCOUNT      (MCM_FIRST + 4)
    #define MCM_GETSELRANGE         (MCM_FIRST + 5)
    #define MCM_SETSELRANGE         (MCM_FIRST + 6)
    #define MCM_GETMONTHRANGE       (MCM_FIRST + 7)
    #define MCM_SETDAYSTATE         (MCM_FIRST + 8)
    #define MCM_GETMINREQRECT       (MCM_FIRST + 9)
    #define MCM_SETCOLOR            (MCM_FIRST + 10)
    #define MCM_GETCOLOR            (MCM_FIRST + 11)
    #define MCM_SETTODAY            (MCM_FIRST + 12)
    #define MCM_GETTODAY            (MCM_FIRST + 13)
    #define MCM_HITTEST             (MCM_FIRST + 14)
    #define MCM_SETFIRSTDAYOFWEEK   (MCM_FIRST + 15)
    #define MCM_GETFIRSTDAYOFWEEK   (MCM_FIRST + 16)
    #define MCM_GETRANGE            (MCM_FIRST + 17)
    #define MCM_SETRANGE            (MCM_FIRST + 18)
    #define MCM_GETMONTHDELTA       (MCM_FIRST + 19)
    #define MCM_SETMONTHDELTA       (MCM_FIRST + 20)
    #define MCM_GETMAXTODAYWIDTH    (MCM_FIRST + 21)
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define MCM_GETCURRENTVIEW      (MCM_FIRST + 22)
    #define MCM_GETCALENDARCOUNT    (MCM_FIRST + 23)
    #define MCM_GETCALENDARGRIDINFO (MCM_FIRST + 24)
    #define MCM_GETCALID            (MCM_FIRST + 27)
    #define MCM_SETCALID            (MCM_FIRST + 28)
    #define MCM_SIZERECTTOMIN       (MCM_FIRST + 29)
    #define MCM_SETCALENDARBORDER   (MCM_FIRST + 30)
    #define MCM_GETCALENDARBORDER   (MCM_FIRST + 31)
    #define MCM_SETCURRENTVIEW      (MCM_FIRST + 32)
#endif
#if (_WIN32_IE >= 0x0400)
    #define MCM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
    #define MCM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#endif

/* MCM_SETCOLOR and MCM_GETCOLOR indices */
#if (_WIN32_IE >= 0x0300)
    #define MCSC_BACKGROUND     0
    #define MCSC_TEXT           1
    #define MCSC_TITLEBK        2
    #define MCSC_TITLETEXT      3
    #define MCSC_MONTHBK        4
    #define MCSC_TRAILINGTEXT   5
#endif

/* MCM_HITTEST flags */
#if (_WIN32_IE >= 0x0300)
    #define MCHT_TITLE              0x00010000
    #define MCHT_CALENDAR           0x00020000
    #define MCHT_TODAYLINK          0x00030000
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define MCHT_CALENDARCONTROL    0x00100000
#endif
#if (_WIN32_IE >= 0x0300)
    #define MCHT_NEXT               0x01000000
    #define MCHT_PREV               0x02000000
    #define MCHT_NOWHERE            0x00000000
    #define MCHT_TITLEBK            (MCHT_TITLE | 0x00000000)
    #define MCHT_TITLEMONTH         (MCHT_TITLE | 0x00000001)
    #define MCHT_TITLEYEAR          (MCHT_TITLE | 0x00000002)
    #define MCHT_TITLEBTNNEXT       (MCHT_TITLE | MCHT_NEXT | 0x00000003)
    #define MCHT_TITLEBTNPREV       (MCHT_TITLE | MCHT_PREV | 0x00000003)
    #define MCHT_CALENDARBK         (MCHT_CALENDAR | 0x00000000)
    #define MCHT_CALENDARDATE       (MCHT_CALENDAR | 0x00000001)
    #define MCHT_CALENDARDATENEXT   (MCHT_CALENDARDATE | MCHT_NEXT)
    #define MCHT_CALENDARDATEPREV   (MCHT_CALENDARDATE | MCHT_PREV)
    #define MCHT_CALENDARDAY        (MCHT_CALENDAR | 0x00000002)
    #define MCHT_CALENDARWEEKNUM    (MCHT_CALENDAR | 0x00000003)
    #define MCHT_CALENDARDATEMIN    (MCHT_CALENDAR | 0x00000004)
    #define MCHT_CALENDARDATEMAX    (MCHT_CALENDAR | 0x00000005)
#endif

/* Month calendar views */
#if (NTDDI_VERSION >= 0x06000000)
    #define MCMV_MONTH      0L
    #define MCMV_YEAR       1L
    #define MCMV_DECADE     2L
    #define MCMV_CENTURY    3L
    #define MCMV_MAX        MCMV_CENTURY
#endif

/* Month calendar grid information parts */
#if (NTDDI_VERSION >= 0x06000000)
    #define MCGIP_CALENDARCONTROL   0L
    #define MCGIP_NEXT              1L
    #define MCGIP_PREV              2L
    #define MCGIP_FOOTER            3L
    #define MCGIP_CALENDAR          4L
    #define MCGIP_CALENDARHEADER    5L
    #define MCGIP_CALENDARBODY      6L
    #define MCGIP_CALENDARROW       7L
    #define MCGIP_CALENDARCELL      8L
#endif

/* Month calendar grid information flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define MCGIF_DATE  0x00000001L
    #define MCGIF_RECT  0x00000002L
    #define MCGIF_NAME  0x00000004L
#endif

/* Month calendar notifications */
#if (_WIN32_IE >= 0x0300)
    #define MCN_SELECT      (MCN_FIRST - 0)
    #define MCN_GETDAYSTATE (MCN_FIRST - 1)
    #define MCN_SELCHANGE   (MCN_FIRST - 3)
    #define MCN_VIEWCHANGE  (MCN_FIRST - 4)
#endif

/* Month calendar styles */
#if (_WIN32_IE >= 0x0300)
    #define MCS_DAYSTATE            0x0001L
    #define MCS_MULTISELECT         0x0002L
    #define MCS_WEEKNUMBERS         0x0004L
#endif
#if (_WIN32_IE >= 0x0400)
    #define MCS_NOTODAYCIRCLE       0x0008L
    #define MCS_NOTODAY             0x0010L
#elif (_WIN32_IE >= 0x0300)
    #define MCS_NOTODAY             0x0008L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define MCS_NOTRAILINGDATES     0x0040L
    #define MCS_SHORTDAYSOFWEEK     0x0080L
    #define MCS_NOSELCHANGEONNAV    0x0100L
#endif

/* MCM_GETMONTHRECT flags */
#if (_WIN32_IE >= 0x0300)
    #define GMR_VISIBLE     0
    #define GMR_DAYSTATE    1
#endif

/* Date/time picker messages */
#if (_WIN32_IE >= 0x0300)
    #define DTM_FIRST                   0x1000
    #define DTM_GETSYSTEMTIME           (DTM_FIRST + 1)
    #define DTM_SETSYSTEMTIME           (DTM_FIRST + 2)
    #define DTM_GETRANGE                (DTM_FIRST + 3)
    #define DTM_SETRANGE                (DTM_FIRST + 4)
    #define DTM_SETFORMATA              (DTM_FIRST + 5)
    #define DTM_SETMCCOLOR              (DTM_FIRST + 6)
    #define DTM_GETMCCOLOR              (DTM_FIRST + 7)
    #define DTM_GETMONTHCAL             (DTM_FIRST + 8)
#endif
#if (_WIN32_IE >= 0x0400)
    #define DTM_SETMCFONT               (DTM_FIRST + 9)
    #define DTM_GETMCFONT               (DTM_FIRST + 10)
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define DTM_SETMCSTYLE              (DTM_FIRST + 11)
    #define DTM_GETMCSTYLE              (DTM_FIRST + 12)
    #define DTM_CLOSEMONTHCAL           (DTM_FIRST + 13)
    #define DTM_GETDATETIMEPICKERINFO   (DTM_FIRST + 14)
    #define DTM_GETIDEALSIZE            (DTM_FIRST + 15)
#endif
#if (_WIN32_IE >= 0x0300)
    #define DTM_SETFORMATW              (DTM_FIRST + 50)
#endif
#ifdef UNICODE
    #if (_WIN32_IE >= 0x0300)
        #define DTM_SETFORMAT           DTM_SETFORMATW
    #endif
#else
    #if (_WIN32_IE >= 0x0300)
        #define DTM_SETFORMAT           DTM_SETFORMATA
    #endif
#endif

/* Date/time picker styles */
#if (_WIN32_IE >= 0x0300)
    #define DTS_UPDOWN                  0x0001L
    #define DTS_SHOWNONE                0x0002L
    #define DTS_SHORTDATEFORMAT         0x0000L
    #define DTS_LONGDATEFORMAT          0x0004L
    #define DTS_TIMEFORMAT              0x0009L
#endif
#if (_WIN32_IE >= 0x0500)
    #define DTS_SHORTDATECENTURYFORMAT  0x000CL
#endif
#if (_WIN32_IE >= 0x0300)
    #define DTS_APPCANPARSE             0x0010L
    #define DTS_RIGHTALIGN              0x0020L
#endif

/* Date/time picker notifications */
#if (_WIN32_IE >= 0x0300)
    #define DTN_CLOSEUP         (DTN_FIRST2 - 0)
    #define DTN_DROPDOWN        (DTN_FIRST2 - 1)
    #define DTN_FORMATQUERYA    (DTN_FIRST2 - 2)
    #define DTN_FORMATQUERYW    (DTN_FIRST - 2)
    #define DTN_FORMATA         (DTN_FIRST2 - 3)
    #define DTN_FORMATW         (DTN_FIRST - 3)
    #define DTN_WMKEYDOWNA      (DTN_FIRST2 - 4)
    #define DTN_WMKEYDOWNW      (DTN_FIRST - 4)
    #define DTN_USERSTRINGA     (DTN_FIRST2 - 5)
    #define DTN_USERSTRINGW     (DTN_FIRST - 5)
    #define DTN_DATETIMECHANGE  (DTN_FIRST2 - 6)
#endif
#ifdef UNICODE
    #if (_WIN32_IE >= 0x0300)
        #define DTN_FORMATQUERY DTN_FORMATQUERYW
        #define DTN_FORMAT      DTN_FORMATW
        #define DTN_WMKEYDOWN   DTN_WMKEYDOWNW
        #define DTN_USERSTRING  DTN_USERSTRINGW
    #endif
#else
    #if (_WIN32_IE >= 0x0300)
        #define DTN_FORMATQUERY DTN_FORMATQUERYA
        #define DTN_FORMAT      DTN_FORMATA
        #define DTN_WMKEYDOWN   DTN_WMKEYDOWNA
        #define DTN_USERSTRING  DTN_USERSTRINGA
    #endif
#endif

/* DTM_GETRANGE flags */
#if (_WIN32_IE >= 0x0300)
    #define GDTR_MIN    0x00000001
    #define GDTR_MAX    0x00000002
#endif

/* DTM_GETSYSTEMTIME return values */
#if (_WIN32_IE >= 0x0300)
    #define GDT_ERROR   (-1)
    #define GDT_VALID   0
    #define GDT_NONE    1
#endif

/* IP address control messages */
#if (_WIN32_IE >= 0x0400)
    #define IPM_CLEARADDRESS    (WM_USER + 100)
    #define IPM_SETADDRESS      (WM_USER + 101)
    #define IPM_GETADDRESS      (WM_USER + 102)
    #define IPM_SETRANGE        (WM_USER + 103)
    #define IPM_SETFOCUS        (WM_USER + 104)
    #define IPM_ISBLANK         (WM_USER + 105)
#endif

/* IP address control notifications */
#if (_WIN32_IE >= 0x0400)
    #define IPN_FIELDCHANGED    (IPN_FIRST - 0)
#endif

/* Macros to manipulate IP addresses */
#if (_WIN32_IE >= 0x0400)
    #define MAKEIPRANGE( p1, p2 ) \
        ((LPARAM)(WORD)(((BYTE)(p2) << 8) + (BYTE)(p1)))
    #define MAKEIPADDRESS( p1, p2, p3, p4 ) \
        ((LPARAM)(((DWORD)(p1) << 24) + ((DWORD)(p2) << 16) + ((DWORD)(p3) << 8) + \
        ((DWORD)(p4))))
    #define FIRST_IPADDRESS( x ) \
        (((x) >> 24) & 0x000000FF)
    #define SECOND_IPADDRESS( x ) \
        (((x) >> 16) & 0x000000FF)
    #define THIRD_IPADDRESS( x ) \
        (((x) >> 8) & 0x000000FF)
    #define FOURTH_IPADDRESS( x ) \
        ((x) & 0x000000FF)
#endif

/* Page scroller styles */
#if (_WIN32_IE >= 0x0400)
    #define PGS_VERT        0x0000L
    #define PGS_HORZ        0x0001L
    #define PGS_AUTOSCROLL  0x0002L
    #define PGS_DRAGNDROP   0x0004L
#endif

/* Page scroller button states */
#if (_WIN32_IE >= 0x0400)
    #define PGF_INVISIBLE   0L
    #define PGF_NORMAL      1L
    #define PGF_GRAYED      2L
    #define PGF_DEPRESSED   4L
    #define PGF_HOT         8L
#endif

/* Page scroller buttons */
#if (_WIN32_IE >= 0x0400)
    #define PGB_TOPORLEFT       0
    #define PGB_BOTTOMORRIGHT   1
#endif

/* Page scroller messages */
#if (_WIN32_IE >= 0x0400)
    #define PGM_SETCHILD        (PGM_FIRST + 1)
    #define PGM_RECALCSIZE      (PGM_FIRST + 2)
    #define PGM_FORWARDMOUSE    (PGM_FIRST + 3)
    #define PGM_SETBKCOLOR      (PGM_FIRST + 4)
    #define PGM_GETBKCOLOR      (PGM_FIRST + 5)
    #define PGM_SETBORDER       (PGM_FIRST + 6)
    #define PGM_GETBORDER       (PGM_FIRST + 7)
    #define PGM_SETPOS          (PGM_FIRST + 8)
    #define PGM_GETPOS          (PGM_FIRST + 9)
    #define PGM_SETBUTTONSIZE   (PGM_FIRST + 10)
    #define PGM_GETBUTTONSIZE   (PGM_FIRST + 11)
    #define PGM_GETBUTTONSTATE  (PGM_FIRST + 12)
    #define PGM_GETDROPTARGET   CCM_GETDROPTARGET
#endif

/* Page scroller notifications */
#if (_WIN32_IE >= 0x0400)
    #define PGN_SCROLL          (PGN_FIRST - 1)
    #define PGN_CALCSIZE        (PGN_FIRST - 2)
    #define PGN_HOTITEMCHANGE   (PGN_FIRST - 3)
#endif

/* Page scroller directions */
#if (_WIN32_IE >= 0x0400)
    #define PGF_SCROLLUP    1
    #define PGF_SCROLLDOWN  2
    #define PGF_SCROLLLEFT  4
    #define PGF_SCROLLRIGHT 8
#endif

/* Page scroller keys */
#if (_WIN32_IE >= 0x0400)
    #define PGK_SHIFT   1
    #define PGK_CONTROL 2
    #define PGK_MENU    4
#endif

/* Native font control styles */
#if (_WIN32_IE >= 0x0400)
    #define NFS_EDIT            0x0001L
    #define NFS_STATIC          0x0002L
    #define NFS_LISTCOMBO       0x0004L
    #define NFS_BUTTON          0x0008L
    #define NFS_ALL             0x0010L
    #define NFS_USEFONTASSOC    0x0020L
#endif

/* Button image list alignments */
#if (_WIN32_WINNT >= 0x0501)
    #define BUTTON_IMAGELIST_ALIGN_LEFT     0
    #define BUTTON_IMAGELIST_ALIGN_RIGHT    1
    #define BUTTON_IMAGELIST_ALIGN_TOP      2
    #define BUTTON_IMAGELIST_ALIGN_BOTTOM   3
    #define BUTTON_IMAGELIST_ALIGN_CENTER   4
#endif

/* Button control messages */
#if (_WIN32_WINNT >= 0x0501)
    #define BCM_GETIDEALSIZE        (BCM_FIRST + 1)
    #define BCM_SETIMAGELIST        (BCM_FIRST + 2)
    #define BCM_GETIMAGELIST        (BCM_FIRST + 3)
    #define BCM_SETTEXTMARGIN       (BCM_FIRST + 4)
    #define BCM_GETTEXTMARGIN       (BCM_FIRST + 5)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define BCM_SETDROPDOWNSTATE    (BCM_FIRST + 6)
    #define BCM_SETSPLITINFO        (BCM_FIRST + 7)
    #define BCM_GETSPLITINFO        (BCM_FIRST + 8)
    #define BCM_SETNOTE             (BCM_FIRST + 9)
    #define BCM_GETNOTE             (BCM_FIRST + 10)
    #define BCM_GETNOTELENGTH       (BCM_FIRST + 11)
    #define BCM_SETSHIELD           (BCM_FIRST + 12)
#endif

/* Button control notifications */
#if (_WIN32_WINNT >= 0x0501)
    #define BCN_HOTITEMCHANGE   (BCN_FIRST + 1)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define BCN_DROPDOWN        (BCN_FIRST + 2)
#endif

/* Button control states */
#if (_WIN32_WINNT >= 0x0501)
    #define BST_HOT             0x0200
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define BST_DROPDOWNPUSHED  0x0400
#endif

/* Button styles */
#if (_WIN32_WINNT >= 0x0600)
    #define BS_SPLITBUTTON      0x000CL
    #define BS_DEFSPLITBUTTON   0x000DL
    #define BS_COMMANDLINK      0x000EL
    #define BS_DEFCOMMANDLINK   0x000FL
#endif

/* Button control split information masks */
#if (_WIN32_WINNT >= 0x0600)
    #define BCSIF_GLYPH 0x00000001
    #define BCSIF_IMAGE 0x00000002
    #define BCSIF_STYLE 0x00000004
    #define BCSIF_SIZE  0x00000008
#endif

/* Button control split styles */
#if (_WIN32_WINNT >= 0x0600)
    #define BCSS_NOSPLIT    0x00000001
    #define BCSS_STRETCH    0x00000002
    #define BCSS_ALIGNLEFT  0x00000004
    #define BCSS_IMAGE      0x00000008
#endif

/* BCM_SETIMAGELIST special value */
#if (_WIN32_WINNT >= 0x0600)
    #define BCCL_NOGLYPH    ((HIMAGELIST)-1)
#endif

/* Edit control messages */
#if (_WIN32_WINNT >= 0x0501)
    #define EM_SETCUEBANNER     (ECM_FIRST + 1)
    #define EM_GETCUEBANNER     (ECM_FIRST + 2)
    #define EM_SHOWBALLOONTIP   (ECM_FIRST + 3)
    #define EM_HIDEBALLOONTIP   (ECM_FIRST + 4)
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define EM_SETHILITE        (ECM_FIRST + 5)
    #define EM_GETHILITE        (ECM_FIRST + 6)
#endif

/* Combo box messages */
#if (_WIN32_WINNT >= 0x0501)
    #define CB_SETMINVISIBLE    (CBM_FIRST + 1)
    #define CB_GETMINVISIBLE    (CBM_FIRST + 2)
    #define CB_SETCUEBANNER     (CBM_FIRST + 3)
    #define CB_GETCUEBANNER     (CBM_FIRST + 4)
#endif

/* Task dialog icon identifiers */
#if (_WIN32_IE >= 0x0400)
    #define TD_WARNING_ICON     MAKEINTRESOURCEW( -1 )
    #define TD_ERROR_ICON       MAKEINTRESOURCEW( -2 )
    #define TD_INFORMATION_ICON MAKEINTRESOURCEW( -3 )
    #define TD_SHIELD_ICON      MAKEINTRESOURCEW( -4 )
#endif

/* Dynamic array special values */
#if (_WIN32_IE >= 0x0300)
    #define DA_LAST     0x7FFFFFFF
    #define DA_ERR      (-1)
    #define DSA_APPEND  DA_LAST
    #define DSA_ERR     DA_ERR
    #define DPA_APPEND  DA_LAST
    #define DPA_ERR     DA_ERR
#endif

/* DPA_Merge() flags */
#if (_WIN32_IE >= 0x0300)
    #define DPAM_SORTED     0x00000001L
    #define DPAM_NORMAL     0x00000002L
    #define DPAM_UNION      0x00000004L
    #define DPAM_INTERSECT  0x00000008L
#endif

/* Dynamic pointer array merge callback messages */
#if (_WIN32_IE >= 0x0300)
    #define DPAMM_MERGE     1
    #define DPAMM_DELETE    2
    #define DPAMM_INSERT    3
#endif

/* DPA_Search() flags */
#if (_WIN32_IE >= 0x0300)
    #define DPAS_SORTED         0x00000001
    #define DPAS_INSERTBEFORE   0x00000002
    #define DPAS_INSERTAFTER    0x00000004
#endif

/* Messages used with _TrackMouseEvent() */
#if (_WIN32_IE >= 0x0300) && !defined( WM_MOUSEHOVER )
    #define WM_MOUSEHOVER   0x02A1
    #define WM_MOUSELEAVE   0x02A3
#endif

/* Definitions for _TrackMouseEvent() */
#if (_WIN32_IE >= 0x0300) && !defined( TME_HOVER )

/* _TrackMouseEvent() flags */
#define TME_HOVER           0x00000001L
#define TME_LEAVE           0x00000002L
#if (WINVER >= 0x0500)
    #define TME_NONCLIENT   0x00000010L
#endif
#define TME_QUERY           0x40000000L
#define TME_CANCEL          0x80000000L

/* Hover time special value */
#define HOVER_DEFAULT   0xFFFFFFFFL

/* _TrackMouseEvent() parameters */
typedef struct tagTRACKMOUSEEVENT {
    DWORD   cbSize;
    DWORD   dwFlags;
    HWND    hwndTrack;
    DWORD   dwHoverTime;
} TRACKMOUSEEVENT;
typedef TRACKMOUSEEVENT *LPTRACKMOUSEEVENT;

#endif /* (_WIN32_IE >= 0x0300) && !defined( TME_HOVER ) */

/* Flat scroll bar properties */
#if (_WIN32_IE >= 0x0400)
    #define WSB_PROP_CYVSCROLL  0x00000001
    #define WSB_PROP_CXHSCROLL  0x00000002
    #define WSB_PROP_CYHSCROLL  0x00000004
    #define WSB_PROP_CXVSCROLL  0x00000008
    #define WSB_PROP_CXHTHUMB   0x00000010
    #define WSB_PROP_CYVTHUMB   0x00000020
    #define WSB_PROP_VBKGCOLOR  0x00000040
    #define WSB_PROP_HBKGCOLOR  0x00000080
    #define WSB_PROP_VSTYLE     0x00000100
    #define WSB_PROP_HSTYLE     0x00000200
    #define WSB_PROP_WINSTYLE   0x00000400
    #define WSB_PROP_PALETTE    0x00000800
    #define WSB_PROP_MASK       0x00000FFF
#endif

/* Flat scroll bar modes */
#if (_WIN32_IE >= 0x0400)
    #define FSB_FLAT_MODE       2
    #define FSB_ENCARTA_MODE    1
    #define FSB_REGULAR_MODE    0
#endif

/* InitCommonControlsEx() parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagINITCOMMONCONTROLSEX {
    DWORD   dwSize;
    DWORD   dwICC;
} INITCOMMONCONTROLSEX;
typedef INITCOMMONCONTROLSEX    *LPINITCOMMONCONTROLSEX;
#endif

/* Color scheme */
#if (_WIN32_IE >= 0x0400)
typedef struct tagCOLORSCHEME {
    DWORD       dwSize;
    COLORREF    clrBtnHighlight;
    COLORREF    clrBtnShadow;
} COLORSCHEME;
typedef COLORSCHEME *LPCOLORSCHEME;
#endif

/* NM_TOOLTIPSCREATED parameters */
#if (_WIN32_IE >= 0x0401)
typedef struct tagNMTOOLTIPSCREATED {
    NMHDR   hdr;
    HWND    hwndToolTips;
} NMTOOLTIPSCREATED;
typedef NMTOOLTIPSCREATED   *LPNMTOOLTIPSCREATED;
#endif

/* Mouse notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMMOUSE {
    NMHDR       hdr;
    DWORD_PTR   dwItemSpec;
    DWORD_PTR   dwItemData;
    POINT       pt;
    LPARAM      dwHitInfo;
} NMMOUSE;
typedef NMMOUSE     *LPNMMOUSE;
typedef NMMOUSE     NMCLICK;
typedef LPNMMOUSE   LPNMCLICK;
#endif

/* Object notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMOBJECTNOTIFY {
    NMHDR       hdr;
    int         iItem;
    const IID   *piid;
    void        *pObject;
    HRESULT     hResult;
    DWORD       dwFlags;
} NMOBJECTNOTIFY;
typedef NMOBJECTNOTIFY  *LPNMOBJECTNOTIFY;
#endif

/* Key notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMKEY {
    NMHDR   hdr;
    UINT    nVKey;
    UINT    uFlags;
} NMKEY;
typedef NMKEY   *LPNMKEY;
#endif

/* Character notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMCHAR {
    NMHDR   hdr;
    UINT    ch;
    DWORD   dwItemPrev;
    DWORD   dwItemNext;
} NMCHAR;
typedef NMCHAR  *LPNMCHAR;
#endif

/* NM_CUSTOMTEXT parameters */
#if (_WIN32_IE >= 0x0600)
typedef struct tagNMCUSTOMTEXT {
    NMHDR   hdr;
    HDC     hDC;
    LPCWSTR lpString;
    int     nCount;
    LPRECT  lpRect;
    UINT    uFormat;
    BOOL    fLink;
} NMCUSTOMTEXT;
typedef NMCUSTOMTEXT    *LPNMCUSTOMTEXT;
#endif

/* NM_CUSTOMDRAW parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMCUSTOMDRAWINFO {
    NMHDR       hdr;
    DWORD       dwDrawStage;
    HDC         hdc;
    RECT        rc;
    DWORD_PTR   dwItemSpec;
    UINT        uItemState;
    LPARAM      lItemlParam;
} NMCUSTOMDRAW;
typedef NMCUSTOMDRAW    *LPNMCUSTOMDRAW;
#endif

/* NM_CUSTOMDRAW parameters for ToolTip controls */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMTTCUSTOMDRAW {
    NMCUSTOMDRAW    nmcd;
    UINT            uDrawFlags;
} NMTTCUSTOMDRAW;
typedef NMTTCUSTOMDRAW  *LPNMTTCUSTOMDRAW;
#endif

/* Custom split rectangle notification parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMCUSTOMSPLITRECTINFO {
    NMHDR   hdr;
    RECT    rcClient;
    RECT    rcButton;
    RECT    rcSplit;
} NMCUSTOMSPLITRECTINFO;
typedef NMCUSTOMSPLITRECTINFO   *LPNMCUSTOMSPLITRECTINFO;
#endif

/* ImageList_DrawIndirect() parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct _IMAGELISTDRAWPARAMS {
    DWORD       cbSize;
    HIMAGELIST  himl;
    int         i;
    HDC         hdcDst;
    int         x;
    int         y;
    int         cx;
    int         cy;
    int         xBitmap;
    int         yBitmap;
    COLORREF    rgbBk;
    COLORREF    rgbFg;
    UINT        fStyle;
    DWORD       dwRop;
#if (_WIN32_IE >= 0x0501)
    DWORD       fState;
    DWORD       Frame;
    COLORREF    crEffect;
#endif
} IMAGELISTDRAWPARAMS;
typedef IMAGELISTDRAWPARAMS *LPIMAGELISTDRAWPARAMS;
#endif

/* Image information */
typedef struct _IMAGEINFO {
    HBITMAP hbmImage;
    HBITMAP hbmMask;
    int     Unused1;
    int     Unused2;
    RECT    rcImage;
} IMAGEINFO;
typedef IMAGEINFO   *LPIMAGEINFO;

/* Header text filter */
typedef struct _HD_TEXTFILTERA {
    LPSTR   pszText;
    INT     cchTextMax;
} HD_TEXTFILTERA;
typedef HD_TEXTFILTERA      *LPHD_TEXTFILTERA;
typedef struct _HD_TEXTFILTERW {
    LPWSTR  pszText;
    INT     cchTextMax;
} HD_TEXTFILTERW;
typedef HD_TEXTFILTERW      *LPHD_TEXTFILTERW;
#ifdef UNICODE
typedef HD_TEXTFILTERW      HD_TEXTFILTER;
typedef LPHD_TEXTFILTERW    LPHD_TEXTFILTER;
#else
typedef HD_TEXTFILTERA      HD_TEXTFILTER;
typedef LPHD_TEXTFILTERA    LPHD_TEXTFILTER;
#endif
typedef HD_TEXTFILTER       HDTEXTFILTER;
typedef LPHD_TEXTFILTER     LPHD_TEXTFILTER;

/* Header item */
typedef struct _HD_ITEMA {
    UINT    mask;
    int     cxy;
    LPSTR   pszText;
    HBITMAP hbm;
    int     cchTextMax;
    int     fmt;
    LPARAM  lParam;
#if (_WIN32_IE >= 0x0300)
    int     iImage;
    int     iOrder;
#endif
#if (_WIN32_IE >= 0x0500)
    UINT    type;
    void    *pvFilter;
#endif
#if (_WIN32_WINNT >= 0x0600)
    UINT    state;
#endif
} HDITEMA;
typedef HDITEMA     *LPHDITEMA;
typedef struct _HD_ITEMW {
    UINT    mask;
    int     cxy;
    LPWSTR  pszText;
    HBITMAP hbm;
    int     cchTextMax;
    int     fmt;
    LPARAM  lParam;
#if (_WIN32_IE >= 0x0300)
    int     iImage;
    int     iOrder;
#endif
#if (_WIN32_IE >= 0x0500)
    UINT    type;
    void    *pvFilter;
#endif
#if (_WIN32_WINNT >= 0x0600)
    UINT    state;
#endif
} HDITEMW;
typedef HDITEMW     *LPHDITEMW;
#ifdef UNICODE
typedef HDITEMW     HDITEM;
typedef LPHDITEMW   LPHDITEM;
#else
typedef HDITEMA     HDITEM;
typedef LPHDITEMA   LPHDITEM;
#endif
typedef HDITEM      HD_ITEM;

/* Header layout */
typedef struct _HD_LAYOUT {
    RECT        *prc;
    WINDOWPOS   *pwpos;
} HDLAYOUT;
typedef HDLAYOUT    *LPHDLAYOUT;
typedef HDLAYOUT    HD_LAYOUT;

/* Header hit test information */
typedef struct _HD_HITTESTINFO {
    POINT   pt;
    UINT    flags;
    int     iItem;
} HDHITTESTINFO;
typedef HDHITTESTINFO   *LPHDHITTESTINFO;
typedef HDHITTESTINFO   HD_HITTESTINFO;

/* Header notification parameters */
typedef struct tagNMHEADERA {
    NMHDR   hdr;
    int     iItem;
    int     iButton;
    HDITEMA *pitem;
} NMHEADERA;
typedef NMHEADERA   *LPNMHEADERA;
typedef struct tagNMHEADERW {
    NMHDR   hdr;
    int     iItem;
    int     iButton;
    HDITEMW *pitem;
} NMHEADERW;
typedef NMHEADERW   *LPNMHEADERW;
#ifdef UNICODE
typedef NMHEADERW   NMHEADER;
typedef LPNMHEADERW LPNMHEADER;
#else
typedef NMHEADERA   NMHEADER;
typedef LPNMHEADERA LPNMHEADER;
#endif
typedef NMHEADERA   HD_NOTIFYA;
typedef NMHEADERW   HD_NOTIFYW;
typedef NMHEADER    HD_NOTIFY;

/* HDN_GETDISPINFO parameters */
typedef struct tagNMHDDISPINFOA {
    NMHDR   hdr;
    int     iItem;
    UINT    mask;
    LPSTR   pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
} NMHDDISPINFOA;
typedef NMHDDISPINFOA   *LPNMHDDISPINFOA;
typedef struct tagNMHDDISPINFOW {
    NMHDR   hdr;
    int     iItem;
    UINT    mask;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
} NMHDDISPINFOW;
typedef NMHDDISPINFOW   *LPNMHDDISPINFOW;
#ifdef UNICODE
typedef NMHDDISPINFOW   NMHDDISPINFO;
typedef LPNMHDDISPINFOW LPNMHDDISPINFO;
#else
typedef NMHDDISPINFOA   NMHDDISPINFO;
typedef LPNMHDDISPINFOA LPNMHDDISPINFO;
#endif

/* HDN_FILTERBTNCLICK parameters */
#if (_WIN32_IE >= 0x0500)
typedef struct tagNMHDFILTERBTNCLICK {
    NMHDR   hdr;
    INT     iItem;
    RECT    rc;
} NMHDFILTERBTNCLICK;
typedef NMHDFILTERBTNCLICK  *LPNMHDFILTERBTNCLICK;
#endif

/* Toolbar button */
typedef struct _TBBUTTON {
    int         iBitmap;
    int         idCommand;
    BYTE        fsState;
    BYTE        fsStyle;
    BYTE        bReserved[2];
    DWORD_PTR   dwData;
    INT_PTR     iString;
} TBBUTTON;
typedef TBBUTTON        *PTBBUTTON;
typedef TBBUTTON        *LPTBBUTTON;
typedef const TBBUTTON  *LPCTBBUTTON;

/* Color map */
typedef struct _COLORMAP {
    COLORREF    from;
    COLORREF    to;
} COLORMAP;
typedef COLORMAP    *LPCOLORMAP;

/* NM_CUSTOMDRAW parameters for toolbars */
#if (_WIN32_IE >= 0x0400)
typedef struct _NMTBCUSTOMDRAW {
    NMCUSTOMDRAW    nmcd;
    HBRUSH          hbrMonoDither;
    HBRUSH          hbrLines;
    HPEN            hpenLines;
    COLORREF        clrText;
    COLORREF        clrMark;
    COLORREF        clrTextHighlight;
    COLORREF        clrBtnFace;
    COLORREF        clrBtnHighlight;
    COLORREF        clrHighlightHotTrack;
    RECT            rcText;
    int             nStringBkMode;
    int             nHLStringBkMode;
#if (_WIN32_WINNT >= 0x0501)
    int             iListGap;
#endif
} NMTBCUSTOMDRAW;
typedef NMTBCUSTOMDRAW  *LPNMTBCUSTOMDRAW;
#endif

/* TB_ADDBITMAP parameters */
typedef struct tagTBADDBITMAP {
    HINSTANCE   hInst;
    UINT_PTR    nID;
} TBADDBITMAP;
typedef TBADDBITMAP *LPTBADDBITMAP;

/* TB_SAVERESTORE parameters */
typedef struct tagTBSAVEPARAMSA {
    HKEY    hkr;
    LPCSTR  pszSubKey;
    LPCSTR  pszValueName;
} TBSAVEPARAMSA;
typedef TBSAVEPARAMSA   *LPTBSAVEPARAMSA;
typedef struct tagTBSAVEPARAMSW {
    HKEY    hkr;
    LPCWSTR pszSubKey;
    LPCWSTR pszValueName;
} TBSAVEPARAMSW;
typedef TBSAVEPARAMSW   *LPTBSAVEPARAMSW;
#ifdef UNICODE
typedef TBSAVEPARAMSW   TBSAVEPARAMS;
typedef LPTBSAVEPARAMSW LPTBSAVEPARAMS;
#else
typedef TBSAVEPARAMSA   TBSAVEPARAMS;
typedef LPTBSAVEPARAMSA LPTBSAVEPARAMS;
#endif

/* Toolbar insert mark */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    int     iButton;
    DWORD   dwFlags;
} TBINSERTMARK;
typedef TBINSERTMARK    *LPTBINSERTMARK;
#endif

/* TB_REPLACEBITMAP parameters */
typedef struct {
    HINSTANCE   hInstOld;
    UINT_PTR    nIDOld;
    HINSTANCE   hInstNew;
    UINT_PTR    nIDNew;
    int         nButtons;
} TBREPLACEBITMAP;
typedef TBREPLACEBITMAP *LPTBREPLACEBITMAP;

/* Toolbar button information */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    UINT        cbSize;
    DWORD       dwMask;
    int         idCommand;
    int         iImage;
    BYTE        fsState;
    BYTE        fsStyle;
    WORD        cx;
    DWORD_PTR   lParam;
    LPSTR       pszText;
    int         cchText;
} TBBUTTONINFOA;
typedef TBBUTTONINFOA   *LPTBBUTTONINFOA;
typedef struct {
    UINT        cbSize;
    DWORD       dwMask;
    int         idCommand;
    int         iImage;
    BYTE        fsState;
    BYTE        fsStyle;
    WORD        cx;
    DWORD_PTR   lParam;
    LPWSTR      pszText;
    int         cchText;
} TBBUTTONINFOW;
typedef TBBUTTONINFOW   *LPTBBUTTONINFOW;
#ifdef UNICODE
typedef TBBUTTONINFOW   TBBUTTONINFO;
typedef LPTBBUTTONINFOW LPTBBUTTONINFO;
#else
typedef TBBUTTONINFOA   TBBUTTONINFO;
typedef LPTBBUTTONINFOA LPTBBUTTONINFO;
#endif
#endif

/* Toolbar metrics */
#if (_WIN32_WINNT >= 0x0501)
typedef struct {
    UINT    cbSize;
    DWORD   dwMask;
    int     cxPad;
    int     cyPad;
    int     cxBarPad;
    int     cyBarPad;
    int     cxButtonSpacing;
    int     cyButtonSpacing;
} TBMETRICS;
typedef TBMETRICS   *LPTBMETRICS;
#endif

/* TBN_HOTITEMCHANGE parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMTBHOTITEM {
    NMHDR   hdr;
    int     idOld;
    int     idNew;
    DWORD   dwFlags;
} NMTBHOTITEM;
typedef NMTBHOTITEM *LPNMTBHOTITEM;
#endif

/* TBN_SAVE parameters */
#if (_WIN32_IE >= 0x0500)
typedef struct tagNMTBSAVE {
    NMHDR       hdr;
    DWORD       *pData;
    DWORD       *pCurrent;
    UINT        cbData;
    int         iItem;
    int         cButtons;
    TBBUTTON    tbButton;
} NMTBSAVE;
typedef NMTBSAVE    *LPNMTBSAVE;
#endif

/* TBN_RESTORE parameters */
#if (_WIN32_IE >= 0x0500)
typedef struct tagNMTBRESTORE {
    NMHDR       hdr;
    DWORD       *pData;
    DWORD       *pCurrent;
    UINT        cbData;
    int         iItem;
    int         cButtons;
    int         cbBytesPerRecord;
    TBBUTTON    tbButton;
} NMTBRESTORE;
typedef NMTBRESTORE *LPNMTBRESTORE;
#endif

/* TBN_GETINFOTIP parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMTBGETINFOTIPA {
    NMHDR   hdr;
    LPSTR   pszText;
    int     cchTextMax;
    int     iItem;
    LPARAM  lParam;
} NMTBGETINFOTIPA;
typedef NMTBGETINFOTIPA     *LPNMTBGETINFOTIPA;
typedef struct tagNMTBGETINFOTIPW {
    NMHDR   hdr;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iItem;
    LPARAM  lParam;
} NMTBGETINFOTIPW;
typedef NMTBGETINFOTIPW     *LPNMTBGETINFOTIPW;
#ifdef UNICODE
typedef NMTBGETINFOTIPW     NMTBGETINFOTIP;
typedef LPNMTBGETINFOTIPW   LPNMTBGETINFOTIP;
#else
typedef NMTBGETINFOTIPA     NMTBGETINFOTIP;
typedef LPNMTBGETINFOTIPA   LPNMTBGETINFOTIP;
#endif
#endif

/* TBN_GETDISPINFO parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    NMHDR       hdr;
    DWORD       dwMask;
    int         idCommand;
    DWORD_PTR   lParam;
    int         iImage;
    LPSTR       pszText;
    int         cchText;
} NMTBDISPINFOA;
typedef NMTBDISPINFOA   *LPNMTBDISPINFOA;
typedef struct {
    NMHDR       hdr;
    DWORD       dwMask;
    int         idCommand;
    DWORD_PTR   lParam;
    int         iImage;
    LPWSTR      pszText;
    int         cchText;
} NMTBDISPINFOW;
typedef NMTBDISPINFOW   *LPNMTBDISPINFOW;
#ifdef UNICODE
typedef NMTBDISPINFOW   NMTBDISPINFO;
typedef LPNMTBDISPINFOW LPNMTBDISPINFO;
#else
typedef NMTBDISPINFOA   NMTBDISPINFO;
typedef LPNMTBDISPINFOA LPNMTBDISPINFO;
#endif
#endif

/* Toolbar notification parameters */
typedef struct tagNMTOOLBARA {
    NMHDR       hdr;
    int         iItem;
    TBBUTTON    tbButton;
    int         cchText;
    LPSTR       pszText;
#if (_WIN32_IE >= 0x0500)
    RECT        rcButton;
#endif
} NMTOOLBARA;
typedef NMTOOLBARA      *LPNMTOOLBARA;
typedef struct tagNMTOOLBARW {
    NMHDR       hdr;
    int         iItem;
    TBBUTTON    tbButton;
    int         cchText;
    LPWSTR      pszText;
#if (_WIN32_IE >= 0x0500)
    RECT        rcButton;
#endif
} NMTOOLBARW;
typedef NMTOOLBARW      *LPNMTOOLBARW;
#ifdef UNICODE
typedef NMTOOLBARW      NMTOOLBAR;
typedef LPNMTOOLBARW    LPNMTOOLBAR;
#else
typedef NMTOOLBARA      NMTOOLBAR;
typedef LPNMTOOLBARA    LPNMTOOLBAR;
#endif
typedef NMTOOLBARA      TBNOTIFYA;
typedef NMTOOLBARW      TBNOTIFYW;
typedef LPNMTOOLBARA    LPTBNOTIFYA;
typedef LPNMTOOLBARW    LPTBNOTIFYW;
typedef NMTOOLBAR       TBNOTIFY;
typedef LPNMTOOLBAR     LPTBNOTIFY;

/* Rebar information */
#if (_WIN32_IE >= 0x0300)
typedef struct tagREBARINFO {
    UINT        cbSize;
    UINT        fMask;
    HIMAGELIST  himl;
} REBARINFO;
typedef REBARINFO   *LPREBARINFO;
#endif

/* Rebar band information */
#if (_WIN32_IE >= 0x0300)
typedef struct tagREBARBANDINFOA {
    UINT        cbSize;
    UINT        fMask;
    UINT        fStyle;
    COLORREF    clrFore;
    COLORREF    clrBack;
    LPSTR       lpText;
    UINT        cch;
    int         iImage;
    HWND        hwndChild;
    UINT        cxMinChild;
    UINT        cyMinChild;
    UINT        cx;
    HBITMAP     hbmBack;
    UINT        wID;
#if (_WIN32_IE >= 0x0400)
    UINT        cyChild;
    UINT        cyMaxChild;
    UINT        cyIntegral;
    UINT        cxIdeal;
    LPARAM      lParam;
    UINT        cxHeader;
#endif
#if (_WIN32_WINNT >= 0x0600)
    RECT        rcChevronLocation;
    UINT        uChevronState;
#endif
} REBARBANDINFOA;
typedef REBARBANDINFOA          *LPREBARBANDINFOA;
typedef CONST REBARBANDINFOA    *LPCREBARBANDINFOA;
typedef struct tagREBARBANDINFOW {
    UINT        cbSize;
    UINT        fMask;
    UINT        fStyle;
    COLORREF    clrFore;
    COLORREF    clrBack;
    LPWSTR      lpText;
    UINT        cch;
    int         iImage;
    HWND        hwndChild;
    UINT        cxMinChild;
    UINT        cyMinChild;
    UINT        cx;
    HBITMAP     hbmBack;
    UINT        wID;
#if (_WIN32_IE >= 0x0400)
    UINT        cyChild;
    UINT        cyMaxChild;
    UINT        cyIntegral;
    UINT        cxIdeal;
    LPARAM      lParam;
    UINT        cxHeader;
#endif
#if (_WIN32_WINNT >= 0x0600)
    RECT        rcChevronLocation;
    UINT        uChevronState;
#endif
} REBARBANDINFOW;
typedef REBARBANDINFOW          *LPREBARBANDINFOW;
typedef CONST REBARBANDINFOW    *LPCREBARBANDINFOW;
#ifdef UNICODE
typedef REBARBANDINFOW          REBARBANDINFO;
typedef LPREBARBANDINFOW        LPREBARBANDINFO;
typedef LPCREBARBANDINFOW       LPCREBARBANDINFO;
#else
typedef REBARBANDINFOA          REBARBANDINFO;
typedef LPREBARBANDINFOA        LPREBARBANDINFO;
typedef LPCREBARBANDINFOA       LPCREBARBANDINFO;
#endif
#endif

/* RBN_CHILDSIZE parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMREBARCHILDSIZE {
    NMHDR   hdr;
    UINT    uBand;
    UINT    wID;
    RECT    rcChild;
    RECT    rcBand;
} NMREBARCHILDSIZE;
typedef NMREBARCHILDSIZE    *LPNMREBARCHILDSIZE;
#endif

/* Rebar notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMREBAR {
    NMHDR   hdr;
    DWORD   dwMask;
    UINT    uBand;
    UINT    fStyle;
    UINT    wID;
    LPARAM  lParam;
} NMREBAR;
typedef NMREBAR *LPNMREBAR;
#endif

/* RBN_AUTOSIZE parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMRBAUTOSIZE {
    NMHDR   hdr;
    BOOL    fChanged;
    RECT    rcTarget;
    RECT    rcActual;
} NMRBAUTOSIZE;
typedef NMRBAUTOSIZE    *LPNMRBAUTOSIZE;
#endif

/* Rebar chevron notification parameters */
#if (_WIN32_IE >= 0x0500)
typedef struct tagNMREBARCHEVRON {
    NMHDR   hdr;
    UINT    uBand;
    UINT    wID;
    LPARAM  lParam;
    RECT    rc;
    LPARAM  lParamNM;
} NMREBARCHEVRON;
typedef NMREBARCHEVRON  *LPNMREBARCHEVRON;
#endif

/* RBN_SPLITTERDRAG parameters */
#if (_WIN32_IE >= 0x0600)
typedef struct tagNMREBARSPLITTER {
    NMHDR   hdr;
    RECT    rcSizing;
} NMREBARSPLITTER;
typedef NMREBARSPLITTER *LPNMREBARSPLITTER;
#endif

/* RBN_AUTOBREAK parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagNMREBARAUTOBREAK {
    NMHDR   hdr;
    UINT    uBand;
    UINT    wID;
    LPARAM  lParam;
    UINT    uMsg;
    UINT    fStyleCurrent;
    BOOL    fAutoBreak;
} NMREBARAUTOBREAK;
typedef NMREBARAUTOBREAK    *LPNMREBARAUTOBREAK;
#endif

/* RB_HITTEST parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct _RB_HITTESTINFO {
    POINT   pt;
    UINT    flags;
    int     iBand;
} RBHITTESTINFO;
typedef RBHITTESTINFO   *LPRBHITTESTINFO;
#endif

/* Tool information */
typedef struct tagTOOLINFOA {
    UINT        cbSize;
    UINT        uFlags;
    HWND        hwnd;
    UINT_PTR    uId;
    RECT        rect;
    HINSTANCE   hinst;
    LPSTR       lpszText;
#if (_WIN32_IE >= 0x0300)
    LPARAM      lParam;
#endif
#if (_WIN32_WINNT >= 0x0501)
    void        *lpReserved;
#endif
} TOOLINFOA;
typedef TOOLINFOA   *PTOOLINFOA;
typedef TOOLINFOA   *LPTOOLINFOA;
typedef struct tagTOOLINFOW {
    UINT        cbSize;
    UINT        uFlags;
    HWND        hwnd;
    UINT_PTR    uId;
    RECT        rect;
    HINSTANCE   hinst;
    LPWSTR      lpszText;
#if (_WIN32_IE >= 0x0300)
    LPARAM      lParam;
#endif
#if (_WIN32_WINNT >= 0x0501)
    void        *lpReserved;
#endif
} TOOLINFOW;
typedef TOOLINFOW   *PTOOLINFOW;
typedef TOOLINFOW   *LPTOOLINFOW;
#ifdef UNICODE
typedef TOOLINFOW   TOOLINFO;
typedef PTOOLINFOW  PTOOLINFO;
typedef LPTOOLINFOW LPTOOLINFO;
#else
typedef TOOLINFOA   TOOLINFO;
typedef PTOOLINFOA  PTOOLINFO;
typedef LPTOOLINFOA LPTOOLINFO;
#endif
typedef TOOLINFOA   TTTOOLINFOA;
typedef LPTOOLINFOA LPTTTOOLINFOA;
typedef TOOLINFOW   TTTOOLINFOW;
typedef LPTOOLINFOW LPTTTOOLINFOW;
typedef TOOLINFO    TTTOOLINFO;
typedef LPTOOLINFO  LPTTTOOLINFO;

/* TTM_GETTITLE parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _TTGETTITLE {
    DWORD   dwSize;
    UINT    uTitleBitmap;
    UINT    cch;
    WCHAR   *pszTitle;
} TTGETTITLE;
typedef TTGETTITLE  *PTTGETTITLE;
#endif

/* TTM_HITTEST parameters */
typedef struct _TT_HITTESTINFOA {
    HWND        hwnd;
    POINT       pt;
    TTTOOLINFOA ti;
} TTHITTESTINFOA;
typedef TTHITTESTINFOA      *LPTTHITTESTINFOA;
typedef struct _TT_HITTESTINFOW {
    HWND        hwnd;
    POINT       pt;
    TTTOOLINFOW ti;
} TTHITTESTINFOW;
typedef TTHITTESTINFOW      *LPTTHITTESTINFOW;
#ifdef UNICODE
typedef TTHITTESTINFOW      TTHITTESTINFO;
typedef LPTTHITTESTINFOW    LPTTHITTESTINFO;
#else
typedef TTHITTESTINFOA      TTHITTESTINFO;
typedef LPTTHITTESTINFOA    LPTTHITTESTINFO;
#endif
typedef LPTTHITTESTINFOA    LPHITTESTINFOA;
typedef LPTTHITTESTINFOW    LPHITTESTINFOW;
typedef LPTTHITTESTINFO     LPHITTESTINFO;

/* TTN_GETDISPINFO parameters */
typedef struct tagNMTTDISPINFOA {
    NMHDR       hdr;
    LPSTR       lpszText;
    char        szText[80];
    HINSTANCE   hinst;
    UINT        uFlags;
#if (_WIN32_IE >= 0x0300)
    LPARAM      lParam;
#endif
} NMTTDISPINFOA;
typedef NMTTDISPINFOA   *LPNMTTDISPINFOA;
typedef struct tagNMTTDISPINFOW {
    NMHDR       hdr;
    LPWSTR      lpszText;
    WCHAR       szText[80];
    HINSTANCE   hinst;
    UINT        uFlags;
#if (_WIN32_IE >= 0x0300)
    LPARAM      lParam;
#endif
} NMTTDISPINFOW;
typedef NMTTDISPINFOW   *LPNMTTDISPINFOW;
#ifdef UNICODE
typedef NMTTDISPINFOW   NMTTDISPINFO;
typedef LPNMTTDISPINFOW LPNMTTDISPINFO;
#else
typedef NMTTDISPINFOA   NMTTDISPINFO;
typedef LPNMTTDISPINFOA LPNMTTDISPINFO;
#endif
typedef NMTTDISPINFOA   TOOLTIPTEXTA;
typedef LPNMTTDISPINFOA LPTOOLTIPTEXTA;
typedef NMTTDISPINFOW   TOOLTIPTEXTW;
typedef LPNMTTDISPINFOW LPTOOLTIPTEXTW;
typedef NMTTDISPINFO    TOOLTIPTEXT;
typedef LPNMTTDISPINFO  LPTOOLTIPTEXT;

/* TRBN_THUMBPOSCHANGING parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagTRBTHUMBPOSCHANGING {
    NMHDR   hdr;
    DWORD   dwPos;
    int     nReason;
} NMTRBTHUMBPOSCHANGING;
#endif

/* Drag list information */
typedef struct tagDRAGLISTINFO {
    UINT    uNotification;
    HWND    hWnd;
    POINT   ptCursor;
} DRAGLISTINFO;
typedef DRAGLISTINFO    *LPDRAGLISTINFO;

/* Up/down accelerator */
typedef struct _UDACCEL {
    UINT    nSec;
    UINT    nInc;
} UDACCEL;
typedef UDACCEL *LPUDACCEL;

/* Up/down notification parameters */
typedef struct _NM_UPDOWN {
    NMHDR   hdr;
    int     iPos;
    int     iDelta;
} NMUPDOWN;
typedef NMUPDOWN    *LPNMUPDOWN;
typedef NMUPDOWN    NM_UPDOWN;
typedef LPNMUPDOWN  LPNM_UPDOWN;

/* Progress bar range */
#if (_WIN32_IE >= 0x0300)
typedef struct {
    int iLow;
    int iHigh;
} PBRANGE;
typedef PBRANGE *PPBRANGE;
#endif

/* Link item */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLITEM {
    UINT    mask;
    int     iLink;
    UINT    state;
    UINT    stateMask;
    WCHAR   szID[MAX_LINKID_TEXT];
    WCHAR   szUrl[L_MAX_URL_LENGTH];
} LITEM;
typedef LITEM   *PLITEM;
#endif

/* LM_HITTEST parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLHITTESTINFO {
    POINT   pt;
    LITEM   item;
} LHITTESTINFO;
typedef LHITTESTINFO    *PLHITTESTINFO;
#endif

/* Link notification parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagNMLINK {
    NMHDR   hdr;
    LITEM   item;
} NMLINK;
typedef NMLINK  *PNMLINK;
#endif

/* List view item */
typedef struct tagLVITEMA {
    UINT    mask;
    int     iItem;
    int     iSubItem;
    UINT    state;
    UINT    stateMask;
    LPSTR   pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
#if (_WIN32_IE >= 0x0300)
    int     iIndent;
#endif
#if (_WIN32_WINNT >= 0x0501)
    int     iGroupId;
    UINT    cColumns;
    PUINT   puColumns;
#endif
#if (_WIN32_WINNT >= 0x0600)
    int     *piColFmt;
    int     iGroup;
#endif
} LVITEMA;
typedef LVITEMA     *LPLVITEMA;
typedef struct tagLVITEMW {
    UINT    mask;
    int     iItem;
    int     iSubItem;
    UINT    state;
    UINT    stateMask;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
#if (_WIN32_IE >= 0x0300)
    int     iIndent;
#endif
#if (_WIN32_WINNT >= 0x0501)
    int     iGroupId;
    UINT    cColumns;
    PUINT   puColumns;
#endif
#if (_WIN32_WINNT >= 0x0600)
    int     *piColFmt;
    int     iGroup;
#endif
} LVITEMW;
typedef LVITEMW     *LPLVITEMW;
#ifdef UNICODE
typedef LVITEMW     LVITEM;
typedef LPLVITEMW   LPLVITEM;
#else
typedef LVITEMA     LVITEM;
typedef LPLVITEMA   LPLVITEM;
#endif
typedef LVITEM      LV_ITEM;
typedef LVITEMA     LV_ITEMA;
typedef LVITEMW     LV_ITEMW;

/* LVM_FINDITEM parameters */
typedef struct tagLVFINDINFOA {
    UINT    flags;
    LPCSTR  psz;
    LPARAM  lParam;
    POINT   pt;
    UINT    vkDirection;
} LVFINDINFOA;
typedef LVFINDINFOA     *LPLVFINDINFOA;
typedef struct tagLVFINDINFOW {
    UINT    flags;
    LPCWSTR psz;
    LPARAM  lParam;
    POINT   pt;
    UINT    vkDirection;
} LVFINDINFOW;
typedef LVFINDINFOW     *LPLVFINDINFOW;
#ifdef UNICODE
typedef LVFINDINFOW     LVFINDINFO;
typedef LPLVFINDINFOW   LPLVFINDINFO;
#else
typedef LVFINDINFOA     LVFINDINFO;
typedef LPLVFINDINFOA   LPLVFINDINFO;
#endif
typedef LVFINDINFOA     LV_FINDINFOA;
typedef LVFINDINFOW     LV_FINDINFOW;
typedef LVFINDINFO      LV_FINDINFO;

/* LVM_HITTEST parameters */
typedef struct tagLVHITTESTINFO {
    POINT   pt;
    UINT    flags;
    int     iItem;
#if (_WIN32_IE >= 0x0300)
    int     iSubItem;
#endif
#if (_WIN32_WINNT >= 0x0600)
    int     iGroup;
#endif
} LVHITTESTINFO;
typedef LVHITTESTINFO   *LPLVHITTESTINFO;
typedef LVHITTESTINFO   LV_HITTESTINFO;

/* List view column */
typedef struct tagLVCOLUMNA {
    UINT    mask;
    int     fmt;
    int     cx;
    LPSTR   pszText;
    int     cchTextMax;
    int     iSubItem;
#if (_WIN32_IE >= 0x0300)
    int     iImage;
    int     iOrder;
#endif
#if (_WIN32_WINNT >= 0x0600)
    int     cxMin;
    int     cxDefault;
    int     cxIdeal;
#endif
} LVCOLUMNA;
typedef LVCOLUMNA   *LPLVCOLUMNA;
typedef struct tagLVCOLUMNW {
    UINT    mask;
    int     fmt;
    int     cx;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iSubItem;
#if (_WIN32_IE >= 0x0300)
    int     iImage;
    int     iOrder;
#endif
#if (_WIN32_WINNT >= 0x0600)
    int     cxMin;
    int     cxDefault;
    int     cxIdeal;
#endif
} LVCOLUMNW;
typedef LVCOLUMNW   *LPLVCOLUMNW;
#ifdef UNICODE
typedef LVCOLUMNW   LVCOLUMN;
typedef LPLVCOLUMNW LPLVCOLUMN;
#else
typedef LVCOLUMNA   LVCOLUMN;
typedef LPLVCOLUMNA LPLVCOLUMN;
#endif
typedef LVCOLUMNA   LV_COLUMNA;
typedef LVCOLUMNW   LV_COLUMNW;
typedef LVCOLUMN    LV_COLUMN;

/* List view compare callback */
typedef int (CALLBACK *PFNLVCOMPARE)( LPARAM, LPARAM, LPARAM );

/* List view background image */
#if (_WIN32_IE >= 0x0400)
typedef struct tagLVBKIMAGEA {
    ULONG   ulFlags;
    HBITMAP hbm;
    LPSTR   pszImage;
    UINT    cchImageMax;
    int     xOffsetPercent;
    int     yOffsetPercent;
} LVBKIMAGEA;
typedef LVBKIMAGEA      *LPLVBKIMAGEA;
typedef struct tagLVBKIMAGEW {
    ULONG   ulFlags;
    HBITMAP hbm;
    LPWSTR  pszImage;
    UINT    cchImageMax;
    int     xOffsetPercent;
    int     yOffsetPercent;
} LVBKIMAGEW;
typedef LVBKIMAGEW      *LPLVBKIMAGEW;
#ifdef UNICODE
typedef LVBKIMAGEW      LVBKIMAGE;
typedef LPLVBKIMAGEW    LPLVBKIMAGE;
#else
typedef LVBKIMAGEA      LVBKIMAGE;
typedef LPLVBKIMAGEA    LPLVBKIMAGE;
#endif
#endif

/* List view group */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVGROUP {
    UINT    cbSize;
    UINT    mask;
    LPWSTR  pszHeader;
    int     cchHeader;
    LPWSTR  pszFooter;
    int     cchFooter;
    int     iGroupId;
    UINT    stateMask;
    UINT    state;
    UINT    uAlign;
#if (_WIN32_WINNT >= 0x0600)
    LPWSTR  pszSubtitle;
    UINT    cchSubtitle;
    LPWSTR  pszTask;
    UINT    cchTask;
    LPWSTR  pszDescriptionTop;
    UINT    cchDescriptionTop;
    LPWSTR  pszDescriptionBottom;
    UINT    cchDescriptionBottom;
    int     iTitleImage;
    int     iExtendedImage;
    int     iFirstItem;
    UINT    cItems;
    LPWSTR  pszSubsetTitle;
    UINT    cchSubsetTitle;
#endif
} LVGROUP;
typedef LVGROUP *PLVGROUP;
#endif

/* List view group metrics */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVGROUPMETRICS {
    UINT        cbSize;
    UINT        mask;
    UINT        Left;
    UINT        Top;
    UINT        Right;
    UINT        Bottom;
    COLORREF    crLeft;
    COLORREF    crTop;
    COLORREF    crRight;
    COLORREF    crBottom;
    COLORREF    crHeader;
    COLORREF    crFooter;
} LVGROUPMETRICS;
typedef LVGROUPMETRICS  *PLVGROUPMETRICS;
#endif

/* List view group compare callback */
#if (_WIN32_WINNT >= 0x0501)
typedef int (CALLBACK *PFNLVGROUPCOMPARE)( int, int, void * );
#endif

/* LVM_INSERTGROUPSORTED parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVINSERTGROUPSORTED {
    PFNLVGROUPCOMPARE   pfnGroupCompare;
    void                *pvData;
    LVGROUP             lvGroup;
} LVINSERTGROUPSORTED;
typedef LVINSERTGROUPSORTED *PLVINSERTGROUPSORTED;
#endif

/* List view tile view information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVTILEVIEWINFO {
    UINT    cbSize;
    DWORD   dwMask;
    DWORD   dwFlags;
    SIZE    sizeTile;
    int     cLines;
    RECT    rcLabelMargin;
} LVTILEVIEWINFO;
typedef LVTILEVIEWINFO  *PLVTILEVIEWINFO;
#endif

/* List view tile information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVTILEINFO {
    UINT    cbSize;
    int     iItem;
    UINT    cColumns;
    PUINT   puColumns;
#if (_WIN32_WINNT >= 0x0600)
    int     *piColFmt;
#endif
} LVTILEINFO;
typedef LVTILEINFO  *PLVTILEINFO;
#endif

/* List view insert mark */
#if (_WIN32_WINNT >= 0x0501)
typedef struct {
    UINT    cbSize;
    DWORD   dwFlags;
    int     iItem;
    DWORD   dwReserved;
} LVINSERTMARK;
typedef LVINSERTMARK    *LPLVINSERTMARK;
#endif

/* LVM_SETINFOTIP parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagLVSETINFOTIP {
    UINT    cbSize;
    DWORD   dwFlags;
    LPWSTR  pszText;
    int     iItem;
    int     iSubItem;
} LVSETINFOTIP;
typedef LVSETINFOTIP    *PLVSETINFOTIP;
#endif

/* List view footer information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagLVFOOTERINFO {
    UINT    mask;
    LPWSTR  pszText;
    int     cchTextMax;
    UINT    cItems;
} LVFOOTERINFO;
typedef LVFOOTERINFO    *LPLVFOOTERINFO;
#endif

/* List view footer item */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagLVFOOTERITEM {
    UINT    mask;
    int     iItem;
    LPWSTR  pszText;
    int     cchTextMax;
    UINT    state;
    UINT    stateMask;
} LVFOOTERITEM;
typedef LVFOOTERITEM    *LPLVFOOTERITEM;
#endif

/* List view item index */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagLVITEMINDEX {
    int iItem;
    int iGroup;
} LVITEMINDEX;
typedef LVITEMINDEX *PLVITEMINDEX;
#endif

/* List view notification parameters */
typedef struct tagNMLISTVIEW {
    NMHDR   hdr;
    int     iItem;
    int     iSubItem;
    UINT    uNewState;
    UINT    uOldState;
    UINT    uChanged;
    POINT   ptAction;
    LPARAM  lParam;
} NMLISTVIEW;
typedef NMLISTVIEW      *LPNMLISTVIEW;
typedef NMLISTVIEW      NM_LISTVIEW;
typedef LPNMLISTVIEW    LPNM_LISTVIEW;

/* New list view notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMITEMACTIVATE {
    NMHDR   hdr;
    int     iItem;
    int     iSubItem;
    UINT    uNewState;
    UINT    uOldState;
    UINT    uChanged;
    POINT   ptAction;
    LPARAM  lParam;
    UINT    uKeyFlags;
} NMITEMACTIVATE;
typedef NMITEMACTIVATE  *LPNMITEMACTIVATE;
#endif

/* NM_CUSTOMDRAW parameters for list view controls */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMLVCUSTOMDRAW {
    NMCUSTOMDRAW    nmcd;
    COLORREF        clrText;
    COLORREF        clrTextBk;
#if (_WIN32_IE >= 0x0400)
    int             iSubItem;
#endif
#if (_WIN32_WINNT >= 0x0501)
    DWORD           dwItemType;
    COLORREF        clrFace;
    int             iIconEffect;
    int             iIconPhase;
    int             iPartId;
    int             iStateId;
    RECT            rcText;
    UINT            uAlign;
#endif
} NMLVCUSTOMDRAW;
typedef NMLVCUSTOMDRAW  *LPNMLVCUSTOMDRAW;
#endif

/* LVN_ODCACHEHINT parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMLVCACHEHINT {
    NMHDR   hdr;
    int     iFrom;
    int     iTo;
} NMLVCACHEHINT;
typedef NMLVCACHEHINT   *LPNMLVCACHEHINT;
typedef NMLVCACHEHINT   NM_CACHEHINT;
typedef LPNMLVCACHEHINT PNM_CACHEHINT;
typedef LPNMLVCACHEHINT LPNM_CACHEHINT;
#endif

/* LVN_ODFINDITEM parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMLVFINDITEMA {
    NMHDR       hdr;
    int         iStart;
    LVFINDINFOA lvfi;
} NMLVFINDITEMA;
typedef NMLVFINDITEMA   *LPNMLVFINDITEMA;
typedef struct tagNMLVFINDITEMW {
    NMHDR       hdr;
    int         iStart;
    LVFINDINFOW lvfi;
} NMLVFINDITEMW;
typedef NMLVFINDITEMW   *LPNMLVFINDITEMW;
#ifdef UNICODE
typedef NMLVFINDITEMW   NMLVFINDITEM;
typedef LPNMLVFINDITEMW LPNMLVFINDITEM;
#else
typedef NMLVFINDITEMA   NMLVFINDITEM;
typedef LPNMLVFINDITEMA LPNMLVFINDITEM;
#endif
typedef NMLVFINDITEMA   NM_FINDITEMA;
typedef NMLVFINDITEMW   NM_FINDITEMW;
typedef LPNMLVFINDITEMA PNM_FINDITEMA;
typedef LPNMLVFINDITEMW PNM_FINDITEMW;
typedef LPNMLVFINDITEMA LPNM_FINDITEMA;
typedef LPNMLVFINDITEMW LPNM_FINDITEMW;
typedef NMLVFINDITEM    NM_FINDITEM;
typedef LPNMLVFINDITEM  PNM_FINDITEM;
typedef LPNMLVFINDITEM  LPNM_FINDITEM;
#endif

/* LVN_ODSTATECHANGE parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMLVODSTATECHANGE {
    NMHDR   hdr;
    int     iFrom;
    int     iTo;
    UINT    uNewState;
    UINT    uOldState;
} NMLVODSTATECHANGE;
typedef NMLVODSTATECHANGE   *LPNMLVODSTATECHANGE;
typedef NMLVODSTATECHANGE   NM_ODSTATECHANGE;
typedef LPNMLVODSTATECHANGE PNM_ODSTATECHANGE;
typedef LPNMLVODSTATECHANGE LPNM_ODSTATECHANGE;
#endif

/* LVN_GETDISPINFO and LVN_SETDISPINFO parameters */
typedef struct tagLVDISPINFOA {
    NMHDR   hdr;
    LVITEMA item;
} NMLVDISPINFOA;
typedef NMLVDISPINFOA   *LPNMLVDISPINFOA;
typedef struct tagLVDISPINFOW {
    NMHDR   hdr;
    LVITEMW item;
} NMLVDISPINFOW;
typedef NMLVDISPINFOW   *LPNMLVDISPINFOW;
#ifdef UNICODE
typedef NMLVDISPINFOW   NMLVDISPINFO;
typedef LPNMLVDISPINFOW LPNMLVDISPINFO;
#else
typedef NMLVDISPINFOA   NMLVDISPINFO;
typedef LPNMLVDISPINFOA LPNMLVDISPINFO;
#endif
typedef NMLVDISPINFOA   LV_DISPINFOA;
typedef NMLVDISPINFOW   LV_DISPINFOW;
typedef NMLVDISPINFO    LV_DISPINFO;

/* LVN_KEYDOWN parameters */
#include <pshpack1.h>
typedef struct tagLVKEYDOWN {
    NMHDR   hdr;
    WORD    wVKey;
    UINT    flags;
} NMLVKEYDOWN;
typedef NMLVKEYDOWN *LPNMLVKEYDOWN;
typedef NMLVKEYDOWN LV_KEYDOWN;
#include <poppack.h>

/* LVN_LINKCLICK parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagNMLVLINK {
    NMHDR   hdr;
    LITEM   link;
    int     iItem;
    int     iSubItem;
} NMLVLINK;
typedef NMLVLINK    *PNMLVLINK;
#endif

/* LVN_GETINFOTIP parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMLVGETINFOTIPA {
    NMHDR   hdr;
    DWORD   dwFlags;
    LPSTR   pszText;
    int     cchTextMax;
    int     iItem;
    int     iSubItem;
    LPARAM  lParam;
} NMLVGETINFOTIPA;
typedef NMLVGETINFOTIPA     *LPNMLVGETINFOTIPA;
typedef struct tagNMLVGETINFOTIPW {
    NMHDR   hdr;
    DWORD   dwFlags;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iItem;
    int     iSubItem;
    LPARAM  lParam;
} NMLVGETINFOTIPW;
typedef NMLVGETINFOTIPW     *LPNMLVGETINFOTIPW;
#ifdef UNICODE
typedef NMLVGETINFOTIPW     NMLVGETINFOTIP;
typedef LPNMLVGETINFOTIPW   LPNMLVGETINFOTIP;
#else
typedef NMLVGETINFOTIPA     NMLVGETINFOTIP;
typedef LPNMLVGETINFOTIPA   LPNMLVGETINFOTIP;
#endif
#endif

/* List view scroll notification parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagNMLVSCROLL {
    NMHDR   hdr;
    int     dx;
    int     dy;
} NMLVSCROLL;
typedef NMLVSCROLL  *LPNMLVSCROLL;
#endif

/* LVN_GETEMPTYMARKUP parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagNMLVEMPTYMARKUP {
    NMHDR   hdr;
    DWORD   dwFlags;
    WCHAR   szMarkup[L_MAX_URL_LENGTH];
} NMLVEMPTYMARKUP;
#endif

/* TVN_STATEIMAGECHANGING parameters */
#if (_WIN32_IE >= 0x0600)
typedef struct tagNMTVSTATEIMAGECHANGING {
    NMHDR       hdr;
    HTREEITEM   hti;
    int         iOldStateImageIndex;
    int         iNewStateImageIndex;
} NMTVSTATEIMAGECHANGING;
typedef NMTVSTATEIMAGECHANGING  *LPNMTVSTATEIMAGECHANGING;
#endif

/* Tree view item */
typedef struct tagTVITEMA {
    UINT        mask;
    HTREEITEM   hItem;
    UINT        state;
    UINT        stateMask;
    LPSTR       pszText;
    int         cchTextMax;
    int         iImage;
    int         iSelectedImage;
    int         cChildren;
    LPARAM      lParam;
} TVITEMA;
typedef TVITEMA     *LPTVITEMA;
typedef struct tagTVITEMW {
    UINT        mask;
    HTREEITEM   hItem;
    UINT        state;
    UINT        stateMask;
    LPWSTR      pszText;
    int         cchTextMax;
    int         iImage;
    int         iSelectedImage;
    int         cChildren;
    LPARAM      lParam;
} TVITEMW;
typedef TVITEMW     *LPTVITEMW;
#ifdef UNICODE
typedef TVITEMW     TVITEM;
typedef LPTVITEMW   LPTVITEM;
#else
typedef TVITEMA     TVITEM;
typedef LPTVITEMA   LPTVITEM;
#endif
typedef TVITEMA     TV_ITEMA;
typedef TVITEMW     TV_ITEMW;
typedef LPTVITEMA   LPTV_ITEMA;
typedef LPTVITEMW   LPTV_ITEMW;
typedef TVITEM      TV_ITEM;
typedef LPTVITEM    LPTV_ITEM;

/* Tree view extended item */
#if (_WIN32_IE >= 0x0400)
typedef struct tagTVITEMEXA {
    UINT        mask;
    HTREEITEM   hItem;
    UINT        state;
    UINT        stateMask;
    LPSTR       pszText;
    int         cchTextMax;
    int         iImage;
    int         iSelectedImage;
    int         cChildren;
    LPARAM      lParam;
    int         iIntegral;
#if (_WIN32_IE >= 0x0600)
    UINT        uStateEx;
    HWND        hwnd;
    int         iExpandedImage;
#endif
#if (NTDDI_VERSION >= 0x06010000)
    int         iReserved;
#endif
} TVITEMEXA;
typedef TVITEMEXA   *LPTVITEMEXA;
typedef struct tagTVITEMEXW {
    UINT        mask;
    HTREEITEM   hItem;
    UINT        state;
    UINT        stateMask;
    LPWSTR      pszText;
    int         cchTextMax;
    int         iImage;
    int         iSelectedImage;
    int         cChildren;
    LPARAM      lParam;
    int         iIntegral;
#if (_WIN32_IE >= 0x0600)
    UINT        uStateEx;
    HWND        hwnd;
    int         iExpandedImage;
#endif
#if (NTDDI_VERSION >= 0x06010000)
    int         iReserved;
#endif
} TVITEMEXW;
typedef TVITEMEXW   *LPTVITEMEXW;
#ifdef UNICODE
typedef TVITEMEXW   TVITEMEX;
typedef LPTVITEMEXW LPTVITEMEX;
#else
typedef TVITEMEXA   TVITEMEX;
typedef LPTVITEMEXA LPTVITEMEX;
#endif
#endif

/* TVM_INSERTITEM parameters */
typedef struct tagTVINSERTSTRUCTA {
    HTREEITEM   hParent;
    HTREEITEM   hInsertAfter;
#if (_WIN32_IE >= 0x0400)
    union {
        TVITEMEXA   itemex;
        TV_ITEMA    item;
    } DUMMYUNIONNAME;
#else
    TV_ITEMA    item;
#endif
} TVINSERTSTRUCTA;
typedef TVINSERTSTRUCTA     *LPTVINSERTSTRUCTA;
typedef struct tagTVINSERTSTRUCTW {
    HTREEITEM   hParent;
    HTREEITEM   hInsertAfter;
#if (_WIN32_IE >= 0x0400)
    union {
        TVITEMEXW   itemex;
        TV_ITEMW    item;
    } DUMMYUNIONNAME;
#else
    TV_ITEMW    item;
#endif
} TVINSERTSTRUCTW;
typedef TVINSERTSTRUCTW     *LPTVINSERTSTRUCTW;
#ifdef UNICODE
typedef TVINSERTSTRUCTW     TVINSERTSTRUCT;
typedef LPTVINSERTSTRUCTW   LPTVINSERTSTRUCT;
#else
typedef TVINSERTSTRUCTA     TVINSERTSTRUCT;
typedef LPTVINSERTSTRUCTA   LPTVINSERTSTRUCT;
#endif
typedef TVINSERTSTRUCTA     TV_INSERTSTRUCTA;
typedef TVINSERTSTRUCTW     TV_INSERTSTRUCTW;
typedef LPTVINSERTSTRUCTA   LPTV_INSERTSTRUCTA;
typedef LPTVINSERTSTRUCTW   LPTV_INSERTSTRUCTW;
typedef TVINSERTSTRUCT      TV_INSERTSTRUCT;
typedef LPTVINSERTSTRUCT    LPTV_INSERTSTRUCT;

/* TVM_HITTEST parameters */
typedef struct tagTVHITTESTINFO {
    POINT       pt;
    UINT        flags;
    HTREEITEM   hItem;
} TVHITTESTINFO;
typedef TVHITTESTINFO   *LPTVHITTESTINFO;
typedef TVHITTESTINFO   TV_HITTESTINFO;
typedef LPTVHITTESTINFO LPTV_HITTESTINFO;

/* Tree view item parts */
#if (_WIN32_WINNT >= 0x0600)
typedef enum _TVITEMPART {
    TVGIPR_BUTTON   = 1
} TVITEMPART;
#endif

/* TVM_GETITEMPARTRECT parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagTVGETITEMPARTRECTINFO {
    HTREEITEM   hti;
    RECT        *prc;
    TVITEMPART  partID;
} TVGETITEMPARTRECTINFO;
#endif

/* Tree view compare callback */
typedef int (CALLBACK *PFNTVCOMPARE)( LPARAM, LPARAM, LPARAM );

/* TVM_SORTCHILDRENCB parameters */
typedef struct tagTVSORTCB {
    HTREEITEM       hParent;
    PFNTVCOMPARE    lpfnCompare;
    LPARAM          lParam;
} TVSORTCB;
typedef TVSORTCB    *LPTVSORTCB;
typedef TVSORTCB    TV_SORTCB;
typedef LPTVSORTCB  LPTV_SORTCB;

/* Tree view notification parameters */
typedef struct tagNMTREEVIEWA {
    NMHDR   hdr;
    UINT    action;
    TVITEMA itemOld;
    TVITEMA itemNew;
    POINT   ptDrag;
} NMTREEVIEWA;
typedef NMTREEVIEWA     *LPNMTREEVIEWA;
typedef struct tagNMTREEVIEWW {
    NMHDR   hdr;
    UINT    action;
    TVITEMW itemOld;
    TVITEMA itemNew;
    POINT   ptDrag;
} NMTREEVIEWW;
typedef NMTREEVIEWW     *LPNMTREEVIEWW;
#ifdef UNICODE
typedef NMTREEVIEWW     NMTREEVIEW;
typedef LPNMTREEVIEWW   LPNMTREEVIEW;
#else
typedef NMTREEVIEWA     NMTREEVIEW;
typedef LPNMTREEVIEWA   LPNMTREEVIEW;
#endif
typedef NMTREEVIEWA     NM_TREEVIEWA;
typedef NMTREEVIEWW     NM_TREEVIEWW;
typedef LPNMTREEVIEWA   LPNM_TREEVIEWA;
typedef LPNMTREEVIEWW   LPNM_TREEVIEWW;
typedef NMTREEVIEW      NM_TREEVIEW;
typedef LPNMTREEVIEW    LPNM_TREEVIEW;

/* TVN_GETDISPINFO and TVN_SETDISPINFO parameters */
typedef struct tagTVDISPINFOA {
    NMHDR   hdr;
    TVITEMA item;
} NMTVDISPINFOA;
typedef NMTVDISPINFOA   *LPNMTVDISPINFOA;
typedef struct tagTVDISPINFOW {
    NMHDR   hdr;
    TVITEMW item;
} NMTVDISPINFOW;
typedef NMTVDISPINFOW   *LPNMTVDISPINFOW;
#ifdef UNICODE
typedef NMTVDISPINFOW   NMTVDISPINFO;
typedef LPNMTVDISPINFOW LPNMTVDISPINFO;
#else
typedef NMTVDISPINFOA   NMTVDISPINFO;
typedef LPNMTVDISPINFOA LPNMTVDISPINFO;
#endif
typedef NMTVDISPINFOA   TV_DISPINFOA;
typedef NMTVDISPINFOW   TV_DISPINFOW;
typedef NMTVDISPINFO    TV_DISPINFO;

/* TVN_GETDISPINFO and TVN_SETDISPINFO parameters (extended version) */
#if (_WIN32_IE >= 0x0600)
typedef struct tagTVDISPINFOEXA {
    NMHDR       hdr;
    TVITEMEXA   item;
} NMTVDISPINFOEXA;
typedef NMTVDISPINFOEXA     *LPNMTVDISPINFOEXA;
typedef struct tagTVDISPINFOEXW {
    NMHDR       hdr;
    TVITEMEXW   item;
} NMTVDISPINFOEXW;
typedef NMTVDISPINFOEXW     *LPNMTVDISPINFOEXW;
#ifdef UNICODE
typedef NMTVDISPINFOEXW     NMTVDISPINFOEX;
typedef LPNMTVDISPINFOEXW   LPNMTVDISPINFOEX;
#else
typedef NMTVDISPINFOEXA     NMTVDISPINFOEX;
typedef LPNMTVDISPINFOEXA   LPNMTVDISPINFOEX;
#endif
typedef NMTVDISPINFOEXA     TV_DISPINFOEXA;
typedef NMTVDISPINFOEXW     TV_DISPINFOEXW;
typedef NMTVDISPINFOEX      TV_DISPINFOEX;
#endif

/* TVN_KEYDOWN parameters */
#include <pshpack1.h>
typedef struct tagTVKEYDOWN {
    NMHDR   hdr;
    WORD    wVKey;
    UINT    flags;
} NMTVKEYDOWN;
typedef NMTVKEYDOWN     *LPNMTVKEYDOWN;
typedef NMTVKEYDOWN     TV_KEYDOWN;
#include <poppack.h>

/* NM_CUSTOMDRAW parameters for tree view controls */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMTVCUSTOMDRAW {
    NMCUSTOMDRAW    nmcd;
    COLORREF        clrText;
    COLORREF        clrTextBk;
#if (_WIN32_IE >= 0x0400)
    int             iLevel;
#endif
} NMTVCUSTOMDRAW;
typedef NMTVCUSTOMDRAW  *LPNMTVCUSTOMDRAW;
#endif

/* TVN_GETINFOTIP parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMTVGETINFOTIPA {
    NMHDR       hdr;
    LPSTR       pszText;
    int         cchTextMax;
    HTREEITEM   hItem;
    LPARAM      lParam;
} NMTVGETINFOTIPA;
typedef NMTVGETINFOTIPA     *LPNMTVGETINFOTIPA;
typedef struct tagNMTVGETINFOTIPW {
    NMHDR       hdr;
    LPWSTR      pszText;
    int         cchTextMax;
    HTREEITEM   hItem;
    LPARAM      lParam;
} NMTVGETINFOTIPW;
typedef NMTVGETINFOTIPW     *LPNMTVGETINFOTIPW;
#ifdef UNICODE
typedef NMTVGETINFOTIPW     NMTVGETINFOTIP;
typedef LPNMTVGETINFOTIPW   LPNMTVGETINFOTIP;
#else
typedef NMTVGETINFOTIPA     NMTVGETINFOTIP;
typedef LPNMTVGETINFOTIPA   LPNMTVGETINFOTIP;
#endif
#endif

/* TVN_ITEMCHANGING and TVN_ITEMCHANGED parameters */
#if (_WIN32_IE > 0x0600)
typedef struct tagTVITEMCHANGE {
    NMHDR       hdr;
    UINT        uChanged;
    HTREEITEM   hItem;
    UINT        uStateNew;
    UINT        uStateOld;
    LPARAM      lParam;
} NMTVITEMCHANGE;
#endif

/* TVN_ASYNCDRAW parameters */
#if (_WIN32_IE > 0x0600)
typedef struct tagNMTVASYNCDRAW {
    NMHDR               hdr;
    IMAGELISTDRAWPARAMS *pimldp;
    HRESULT             hr;
    HTREEITEM           hItem;
    LPARAM              lParam;
    DWORD               dwRetFlags;
    int                 iRetImageIndex;
} NMTVASYNCDRAW;
#endif

/* Extended combo box item */
#if (_WIN32_IE >= 0x0300)
typedef struct tagCOMBOBOXEXITEMA {
    UINT    mask;
    INT_PTR iItem;
    LPSTR   pszText;
    int     cchTextMax;
    int     iImage;
    int     iSelectedImage;
    int     iOverlay;
    int     iIndent;
    LPARAM  lParam;
} COMBOBOXEXITEMA;
typedef COMBOBOXEXITEMA         *PCOMBOBOXEXITEMA;
typedef COMBOBOXEXITEMA CONST   *PCCOMBOBOXEXITEMA;
typedef struct tagCOMBOBOXEXITEMW {
    UINT    mask;
    INT_PTR iItem;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iImage;
    int     iSelectedImage;
    int     iOverlay;
    int     iIndent;
    LPARAM  lParam;
} COMBOBOXEXITEMW;
typedef COMBOBOXEXITEMW         *PCOMBOBOXEXITEMW;
typedef COMBOBOXEXITEMW CONST   *PCCOMBOBOXEXITEMW;
#ifdef UNICODE
typedef COMBOBOXEXITEMW         COMBOBOXEXITEM;
typedef PCOMBOBOXEXITEMW        PCOMBOBOXEXITEM;
typedef PCCOMBOBOXEXITEMW       PCCOMBOBOXEXITEM;
#else
typedef COMBOBOXEXITEMA         COMBOBOXEXITEM;
typedef PCOMBOBOXEXITEMA        PCOMBOBOXEXITEM;
typedef PCCOMBOBOXEXITEMA       PCCOMBOBOXEXITEM;
#endif
#endif

/* Extended combo box notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    NMHDR           hdr;
    COMBOBOXEXITEMA ceItem;
} NMCOMBOBOXEXA;
typedef NMCOMBOBOXEXA   *PNMCOMBOBOXEXA;
typedef struct {
    NMHDR           hdr;
    COMBOBOXEXITEMW ceItem;
} NMCOMBOBOXEXW;
typedef NMCOMBOBOXEXW   *PNMCOMBOBOXEXW;
#ifdef UNICODE
typedef NMCOMBOBOXEXW   NMCOMBOBOXEX;
typedef PNMCOMBOBOXEXW  PNMCOMBOBOXEX;
#else
typedef NMCOMBOBOXEXA   NMCOMBOBOXEX;
typedef PNMCOMBOBOXEXA  PNMCOMBOBOXEX;
#endif
#elif (_WIN32_IE >= 0x0300)
typedef struct {
    NMHDR           hdr;
    COMBOBOXEXITEMA ceItem;
} NMCOMBOBOXEX;
typedef NMCOMBOBOXEX    *PNMCOMBOBOXEX;
#endif

/* CBEN_DRAGBEGIN parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    NMHDR   hdr;
    int     iItemid;
    char    szText[CBEMAXSTRLEN];
} NMCBEDRAGBEGINA;
typedef NMCBEDRAGBEGINA     *PNMCBEDRAGBEGINA;
typedef NMCBEDRAGBEGINA     *LPNMCBEDRAGBEGINA;
typedef struct {
    NMHDR   hdr;
    int     iItemid;
    WCHAR   szText[CBEMAXSTRLEN];
} NMCBEDRAGBEGINW;
typedef NMCBEDRAGBEGINW     *PNMCBEDRAGBEGINW;
typedef NMCBEDRAGBEGINW     *LPNMCBEDRAGBEGINW;
#ifdef UNICODE
typedef NMCBEDRAGBEGINW     NMCBEDRAGBEGIN;
typedef PNMCBEDRAGBEGINW    PNMCBEDRAGBEGIN;
typedef LPNMCBEDRAGBEGINW   LPNMCBEDRAGBEGIN;
#else
typedef NMCBEDRAGBEGINA     NMCBEDRAGBEGIN;
typedef PNMCBEDRAGBEGINA    PNMCBEDRAGBEGIN;
typedef LPNMCBEDRAGBEGINA   LPNMCBEDRAGBEGIN;
#endif
#endif

/* CBEN_ENDEDIT parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct {
    NMHDR   hdr;
    BOOL    fChanged;
    int     iNewSelection;
    char    szText[CBEMAXSTRLEN];
    int     iWhy;
} NMCBEENDEDITA;
typedef NMCBEENDEDITA   *PNMCBEENDEDITA;
typedef NMCBEENDEDITA   *LPNMCBEENDEDITA;
typedef struct {
    NMHDR   hdr;
    BOOL    fChanged;
    int     iNewSelection;
    WCHAR   szText[CBEMAXSTRLEN];
    int     iWhy;
} NMCBEENDEDITW;
typedef NMCBEENDEDITW   *PNMCBEENDEDITW;
typedef NMCBEENDEDITW   *LPNMCBEENDEDITW;
#ifdef UNICODE
typedef NMCBEENDEDITW   NMCBEENDEDIT;
typedef PNMCBEENDEDITW  PNMCBEENDEDIT;
typedef LPNMCBEENDEDITW LPNMCBEENDEDIT;
#else
typedef NMCBEENDEDITA   NMCBEENDEDIT;
typedef PNMCBEENDEDITA  PNMCBEENDEDIT;
typedef LPNMCBEENDEDITA LPNMCBEENDEDIT;
#endif
#endif

/* Tab control item header */
typedef struct tagTCITEMHEADERA {
    UINT    mask;
    UINT    lpReserved1;
    UINT    lpReserved2;
    LPSTR   pszText;
    int     cchTextMax;
    int     iImage;
} TCITEMHEADERA;
typedef TCITEMHEADERA   *LPTCITEMHEADERA;
typedef struct tagTCITEMHEADERW {
    UINT    mask;
    UINT    lpReserved1;
    UINT    lpReserved2;
    LPWSTR  pszText;
    int     cchTextMax;
    int     iImage;
} TCITEMHEADERW;
typedef TCITEMHEADERW   *LPTCITEMHEADERW;
#ifdef UNICODE
typedef TCITEMHEADERW   TCITEMHEADER;
typedef LPTCITEMHEADERW LPTCITEMHEADER;
#else
typedef TCITEMHEADERA   TCITEMHEADER;
typedef LPTCITEMHEADERA LPTCITEMHEADER;
#endif
typedef TCITEMHEADERA   TC_ITEMHEADERA;
typedef TCITEMHEADERW   TC_ITEMHEADERW;
typedef TCITEMHEADER    TC_ITEMHEADER;

/* Tab control item */
typedef struct tagTCITEMA {
    UINT    mask;
#if (_WIN32_IE >= 0x0300)
    DWORD   dwState;
    DWORD   dwStateMask;
#else
    UINT    lpReserved1;
    UINT    lpReserved2;
#endif
    LPSTR   pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
} TCITEMA;
typedef TCITEMA     *LPTCITEMA;
typedef struct tagTCITEMW {
    UINT    mask;
#if (_WIN32_IE >= 0x0300)
    DWORD   dwState;
    DWORD   dwStateMask;
#else
    UINT    lpReserved1;
    UINT    lpReserved2;
#endif
    LPWSTR  pszText;
    int     cchTextMax;
    int     iImage;
    LPARAM  lParam;
} TCITEMW;
typedef TCITEMW     *LPTCITEMW;
#ifdef UNICODE
typedef TCITEMW     TCITEM;
typedef LPTCITEMW   LPTCITEM;
#else
typedef TCITEMA     TCITEM;
typedef LPTCITEMA   LPTCITEM;
#endif
typedef TCITEMA     TC_ITEMA;
typedef TCITEMW     TC_ITEMW;
typedef TCITEM      TC_ITEM;

/* TCM_HITTEST parameters */
typedef struct tagTCHITTESTINFO {
    POINT   pt;
    UINT    flags;
} TCHITTESTINFO;
typedef TCHITTESTINFO   *LPTCHITTESTINFO;
typedef TCHITTESTINFO   TC_HITTESTINFO;
typedef LPTCHITTESTINFO LPTC_HITTESTINFO;

/* TCN_KEYDOWN parameters */
#include <pshpack1.h>
typedef struct tagTCKEYDOWN {
    NMHDR   hdr;
    WORD    wVKey;
    UINT    flags;
} NMTCKEYDOWN;
typedef NMTCKEYDOWN TC_KEYDOWN;
#include <poppack.h>

/* MCM_HITTEST parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct {
    UINT        cbSize;
    POINT       pt;
    UINT        uHit;
    SYSTEMTIME  st;
#if (NTDDI_VERSION >= 0x06000000)
    RECT        rc;
    int         iOffset;
    int         iRow;
    int         iCol;
#endif
} MCHITTESTINFO;
typedef MCHITTESTINFO   *PMCHITTESTINFO;
#endif

/* Month calendar grid information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct tagMCGRIDINFO {
    UINT        cbSize;
    DWORD       dwPart;
    DWORD       dwFlags;
    int         iCalendar;
    int         iRow;
    int         iCol;
    BOOL        bSelected;
    SYSTEMTIME  stStart;
    SYSTEMTIME  stEnd;
    RECT        rc;
    PWSTR       pszName;
    size_t      cchName;
} MCGRIDINFO;
typedef MCGRIDINFO  *PMCGRIDINFO;
#endif

/* MCN_SELCHANGE and MCN_SELECT parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMSELCHANGE {
    NMHDR       nmhdr;
    SYSTEMTIME  stSelStart;
    SYSTEMTIME  stSelEnd;
} NMSELCHANGE;
typedef NMSELCHANGE *LPNMSELCHANGE;
typedef NMSELCHANGE NMSELECT;
typedef NMSELCHANGE *LPNMSELECT;
#endif

/* MCN_GETDAYSTATE parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDAYSTATE {
    NMHDR           nmhdr;
    SYSTEMTIME      stStart;
    int             cDayState;
    LPMONTHDAYSTATE prgDayState;
} NMDAYSTATE;
typedef NMDAYSTATE  *LPNMDAYSTATE;
#endif

/* MCN_VIEWCHANGE parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMVIEWCHANGE {
    NMHDR   nmhdr;
    DWORD   dwOldView;
    DWORD   dwNewView;
} NMVIEWCHANGE;
typedef NMVIEWCHANGE    *LPNMVIEWCHANGE;
#endif

/* Date/time picker information */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct tagDATETIMEPICKERINFO {
    DWORD   cbSize;
    RECT    rcCheck;
    DWORD   stateCheck;
    RECT    rcButton;
    DWORD   stateButton;
    HWND    hwndEdit;
    HWND    hwndUD;
    HWND    hwndDropDown;
} DATETIMEPICKERINFO;
typedef DATETIMEPICKERINFO  *LPDATETIMEPICKERINFO;
#endif

/* DTN_DATETIMECHANGE parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDATETIMECHANGE {
    NMHDR       nmhdr;
    DWORD       dwFlags;
    SYSTEMTIME  st;
} NMDATETIMECHANGE;
typedef NMDATETIMECHANGE    *LPNMDATETIMECHANGE;
#endif

/* DTN_USERSTRING parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDATETIMESTRINGA {
    NMHDR       nmhdr;
    LPCSTR      pszUserString;
    SYSTEMTIME  st;
    DWORD       dwFlags;
} NMDATETIMESTRINGA;
typedef NMDATETIMESTRINGA   *LPNMDATETIMESTRINGA;
typedef struct tagNMDATETIMESTRINGW {
    NMHDR       nmhdr;
    LPCWSTR     pszUserString;
    SYSTEMTIME  st;
    DWORD       dwFlags;
} NMDATETIMESTRINGW;
typedef NMDATETIMESTRINGW   *LPNMDATETIMESTRINGW;
#ifdef UNICODE
typedef NMDATETIMESTRINGW   NMDATETIMESTRING;
typedef LPNMDATETIMESTRINGW LPNMDATETIMESTRING;
#else
typedef NMDATETIMESTRINGA   NMDATETIMESTRING;
typedef LPNMDATETIMESTRINGA LPNMDATETIMESTRING;
#endif
#endif

/* DTN_WMKEYDOWN parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDATETIMEWMKEYDOWNA {
    NMHDR       nmhdr;
    int         nVirtKey;
    LPCSTR      pszFormat;
    SYSTEMTIME  st;
} NMDATETIMEWMKEYDOWNA;
typedef NMDATETIMEWMKEYDOWNA    *LPNMDATETIMEWMKEYDOWNA;
typedef struct tagNMDATETIMEWMKEYDOWNW {
    NMHDR       nmhdr;
    int         nVirtKey;
    LPCWSTR     pszFormat;
    SYSTEMTIME  st;
} NMDATETIMEWMKEYDOWNW;
typedef NMDATETIMEWMKEYDOWNW    *LPNMDATETIMEWMKEYDOWNW;
#ifdef UNICODE
typedef NMDATETIMEWMKEYDOWNW    NMDATETIMEWMKEYDOWN;
typedef LPNMDATETIMEWMKEYDOWNW  LPNMDATETIMEWMKEYDOWN;
#else
typedef NMDATETIMEWMKEYDOWNA    NMDATETIMEWMKEYDOWN;
typedef LPNMDATETIMEWMKEYDOWNA  LPNMDATETIMEWMKEYDOWN;
#endif
#endif

/* DTN_FORMAT parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDATETIMEFORMATA {
    NMHDR       nmhdr;
    LPCSTR      pszFormat;
    SYSTEMTIME  st;
    LPCSTR      pszDisplay;
    CHAR        szDisplay[64];
} NMDATETIMEFORMATA;
typedef NMDATETIMEFORMATA   *LPNMDATETIMEFORMATA;
typedef struct tagNMDATETIMEFORMATW {
    NMHDR       nmhdr;
    LPCWSTR     pszFormat;
    SYSTEMTIME  st;
    LPCWSTR     pszDisplay;
    WCHAR       szDisplay[64];
} NMDATETIMEFORMATW;
typedef NMDATETIMEFORMATW   *LPNMDATETIMEFORMATW;
#ifdef UNICODE
typedef NMDATETIMEFORMATW   NMDATETIMEFORMAT;
typedef LPNMDATETIMEFORMATW LPNMDATETIMEFORMAT;
#else
typedef NMDATETIMEFORMATA   NMDATETIMEFORMAT;
typedef LPNMDATETIMEFORMATA LPNMDATETIMEFORMAT;
#endif
#endif

/* DTN_FORMATQUERY parameters */
#if (_WIN32_IE >= 0x0300)
typedef struct tagNMDATETIMEFORMATQUERYA {
    NMHDR   nmhdr;
    LPCSTR  pszFormat;
    SIZE    szMax;
} NMDATETIMEFORMATQUERYA;
typedef NMDATETIMEFORMATQUERYA      *LPNMDATETIMEFORMATQUERYA;
typedef struct tagNMDATETIMEFORMATQUERYW {
    NMHDR   nmhdr;
    LPCWSTR pszFormat;
    SIZE    szMax;
} NMDATETIMEFORMATQUERYW;
typedef NMDATETIMEFORMATQUERYW      *LPNMDATETIMEFORMATQUERYW;
#ifdef UNICODE
typedef NMDATETIMEFORMATQUERYW      NMDATETIMEFORMATQUERY;
typedef LPNMDATETIMEFORMATQUERYW    LPNMDATETIMEFORMATQUERY;
#else
typedef NMDATETIMEFORMATQUERYA      NMDATETIMEFORMATQUERY;
typedef LPNMDATETIMEFORMATQUERYA    LPNMDATETIMEFORMATQUERY;
#endif
#endif

/* IP address control notification parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMIPADDRESS {
    NMHDR   hdr;
    int     iField;
    int     iValue;
} NMIPADDRESS;
typedef NMIPADDRESS *LPNMIPADDRESS;
#endif

/* PGN_SCROLL parameters */
#if (_WIN32_IE >= 0x0400)
#include <pshpack1.h>
typedef struct {
    NMHDR   hdr;
    WORD    fwKeys;
    RECT    rcParent;
    int     iDir;
    int     iXpos;
    int     iYpos;
    int     iScroll;
} NMPGSCROLL;
typedef NMPGSCROLL  *LPNMPGSCROLL;
#include <poppack.h>
#endif

/* PGN_CALCSIZE parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct {
    NMHDR   hdr;
    DWORD   dwFlag;
    int     iWidth;
    int     iHeight;
} NMPGCALCSIZE;
typedef NMPGCALCSIZE    *LPNMPGCALCSIZE;
#endif

/* PGN_HOTITEMCHANGE parameters */
#if (_WIN32_IE >= 0x0400)
typedef struct tagNMPGHOTITEM {
    NMHDR   hdr;
    int     idOld;
    int     idNew;
    DWORD   dwFlags;
} NMPGHOTITEM;
typedef NMPGHOTITEM *LPNMPGHOTITEM;
#endif

/* Button image list */
#if (_WIN32_WINNT >= 0x0501)
typedef struct {
    HIMAGELIST  himl;
    RECT        margin;
    UINT        uAlign;
} BUTTON_IMAGELIST;
typedef BUTTON_IMAGELIST    *PBUTTON_IMAGELIST;
#endif

/* BCN_HOTITEMCHANGE parameters */
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagNMBCHOTITEM {
    NMHDR   hdr;
    DWORD   dwFlags;
} NMBCHOTITEM;
typedef NMBCHOTITEM *LPNMBCHOTITEM;
#endif

/* Button split information */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagBUTTON_SPLITINFO {
    UINT        mask;
    HIMAGELIST  himlGlyph;
    UINT        uSplitStyle;
    SIZE        size;
} BUTTON_SPLITINFO;
typedef BUTTON_SPLITINFO    *PBUTTON_SPLITINFO;
#endif

/* BCN_DROPDOWN parameters */
#if (_WIN32_WINNT >= 0x0600)
typedef struct tagNMBCDROPDOWN {
    NMHDR   hdr;
    RECT    rcButton;
} NMBCDROPDOWN;
typedef NMBCDROPDOWN    *LPNMBCDROPDOWN;
#endif

/* Edit control balloon tip information */
#if (_WIN32_WINNT >= 0x0501)
typedef struct _tagEDITBALLOONTIP {
    DWORD   cbStruct;
    LPCWSTR pszTitle;
    LPCWSTR pszText;
    INT     ttiIcon;
} EDITBALLOONTIP;
typedef EDITBALLOONTIP  *PEDITBALLOONTIP;
#endif

/* All task dialog structures get one-byte packing. */
#include <pshpack1.h>

/* Task dialog callback */
#if (_WIN32_IE >= 0x0400)
typedef HRESULT (CALLBACK *PFTASKDIALOGCALLBACK)( HWND, UINT, WPARAM, LPARAM, LONG_PTR );
#endif

/* Task dialog flags */
#if (_WIN32_IE >= 0x0400)
enum _TASKDIALOG_FLAGS {
    TDF_ENABLE_HYPERLINKS           = 0x00000001,
    TDF_USE_HICON_MAIN              = 0x00000002,
    TDF_USE_HICON_FOOTER            = 0x00000004,
    TDF_ALLOW_DIALOG_CANCELLATION   = 0x00000008,
    TDF_USE_COMMAND_LINKS           = 0x00000010,
    TDF_USE_COMMAND_LINKS_NO_ICON   = 0x00000020,
    TDF_EXPAND_FOOTER_AREA          = 0x00000040,
    TDF_EXPANDED_BY_DEFAULT         = 0x00000080,
    TDF_VERIFICATION_FLAG_CHECKED   = 0x00000100,
    TDF_SHOW_PROGRESS_BAR           = 0x00000200,
    TDF_SHOW_MARQUEE_PROGRESS_BAR   = 0x00000400,
    TDF_CALLBACK_TIMER              = 0x00000800,
    TDF_POSITION_RELATIVE_TO_WINDOW = 0x00001000,
    TDF_RTL_LAYOUT                  = 0x00002000,
    TDF_NO_DEFAULT_RADIO_BUTTON     = 0x00004000,
    TDF_CAN_BE_MINIMIZED            = 0x00008000
};
typedef int TASKDIALOG_FLAGS;
#endif

/* Task dialog messages */
#if (_WIN32_IE >= 0x0400)
typedef enum _TASKDIALOG_MESSAGES {
    TDM_NAVIGATE_PANE                       = WM_USER + 101,
    TDM_CLICK_BUTTON                        = WM_USER + 102,
    TDM_SET_MARQUEE_PROGRESS_BAR            = WM_USER + 103,
    TDM_SET_PROGRESS_BAR_STATE              = WM_USER + 104,
    TDM_SET_PROGRESS_BAR_RANGE              = WM_USER + 105,
    TDM_SET_PROGRESS_BAR_POS                = WM_USER + 106,
    TDM_SET_PROGRESS_BAR_MARQUEE            = WM_USER + 107,
    TDM_SET_ELEMENT_TEXT                    = WM_USER + 108,
    TDM_CLICK_RADIO_BUTTON                  = WM_USER + 110,
    TDM_ENABLE_BUTTON                       = WM_USER + 111,
    TDM_ENABLE_RADIO_BUTTON                 = WM_USER + 112,
    TDM_CLICK_VERIFICATION                  = WM_USER + 113,
    TDM_UPDATE_ELEMENT_TEXT                 = WM_USER + 114,
    TDM_SET_BUTTON_ELEVATION_REQUIRED_STATE = WM_USER + 115,
    TDM_UPDATE_ICON                         = WM_USER + 116
} TASKDIALOG_MESSAGES;
#endif

/* Task dialog notifications */
#if (_WIN32_IE >= 0x0400)
typedef enum _TASKDIALOG_NOTIFICATIONS {
    TDN_CREATED                 = 0,
    TDN_NAVIGATED               = 1,
    TDN_BUTTON_CLICKED          = 2,
    TDN_HYPERLINK_CLICKED       = 3,
    TDN_TIMER                   = 4,
    TDN_DESTROYED               = 5,
    TDN_RADIO_BUTTON_CLICKED    = 6,
    TDN_DIALOG_CONSTRUCTED      = 7,
    TDN_VERIFICATION_CLICKED    = 8,
    TDN_HELP                    = 9,
    TDN_EXPANDO_BUTTON_CLICKED  = 10
} TASKDIALOG_NOTIFICATIONS;
#endif

/* Task dialog button */
#if (_WIN32_IE >= 0x0400)
typedef struct _TASKDIALOG_BUTTON {
    int     nButtonID;
    PCWSTR  pszButtonText;
} TASKDIALOG_BUTTON;
#endif

/* Task dialog elements */
#if (_WIN32_IE >= 0x0400)
typedef enum _TASKDIALOG_ELEMENTS {
    TDE_CONTENT                 = 0,
    TDE_EXPANDED_INFORMATION    = 1,
    TDE_FOOTER                  = 2,
    TDE_MAIN_INSTRUCTION        = 3
} TASKDIALOG_ELEMENTS;
#endif

/* Task dialog icon elements */
#if (_WIN32_IE >= 0x0400)
typedef enum _TASKDIALOG_ICON_ELEMENTS {
    TDIE_ICON_MAIN      = 0,
    TDIE_ICON_FOOTER    = 1
} TASKDIALOG_ICON_ELEMENTS;
#endif

/* Task dialog command button flags */
#if (_WIN32_IE >= 0x0400)
enum _TASKDIALOG_COMMON_BUTTON_FLAGS {
    TDCBF_OK_BUTTON     = 0x00000001,
    TDCBF_YES_BUTTON    = 0x00000002,
    TDCBF_NO_BUTTON     = 0x00000004,
    TDCBF_CANCEL_BUTTON = 0x00000008,
    TDCBF_RETRY_BUTTON  = 0x00000010,
    TDCBF_CLOSE_BUTTON  = 0x00000020
};
typedef int TASKDIALOG_COMMON_BUTTON_FLAGS;
#endif

/* Task dialog configuration */
#if (_WIN32_IE >= 0x0400)
typedef struct _TASKDIALOGCONFIG {
    UINT                            cbSize;
    HWND                            hwndParent;
    HINSTANCE                       hInstance;
    TASKDIALOG_FLAGS                dwFlags;
    TASKDIALOG_COMMON_BUTTON_FLAGS  dwCommonButtons;
    PCWSTR                          pszWindowTitle;
    union {
        HICON   hMainIcon;
        PCWSTR  pszMainIcon;
    };
    PCWSTR                          pszMainInstruction;
    PCWSTR                          pszContent;
    UINT                            cButtons;
    const TASKDIALOG_BUTTON         *pButtons;
    int                             nDefaultButton;
    UINT                            cRadioButtons;
    const TASKDIALOG_BUTTON         *pRadioButtons;
    int                             nDefaultRadioButton;
    PCWSTR                          pszVerificationText;
    PCWSTR                          pszExpandedInformation;
    PCWSTR                          pszExpandedControlText;
    PCWSTR                          pszCollapsedControlText;
    union {
        HICON   hFooterIcon;
        PCWSTR  pszFooterIcon;
    };
    PCWSTR                          pszFooter;
    PFTASKDIALOGCALLBACK            pfCallback;
    LONG_PTR                        lpCallbackData;
    UINT                            cxWidth;
} TASKDIALOGCONFIG;
#endif

/* Revert to default packing. */
#include <poppack.h>

/* Dynamic array callbacks */
#if (_WIN32_IE >= 0x0300)
typedef int (CALLBACK *PFNDAENUMCALLBACK)( void *, void * );
typedef int (CALLBACK *PFNDAENUMCALLBACKCONST)( const void *, void * );
typedef int (CALLBACK *PFNDACOMPARE)( void *, void *, LPARAM );
typedef int (CALLBACK *PFNDACOMPARECONST)( const void *, const void *, LPARAM );
typedef PFNDAENUMCALLBACK       PFNDSAENUMCALLBACK;
typedef PFNDAENUMCALLBACKCONST  PFNDSAENUMCALLBACKCONST;
typedef PFNDACOMPARE            PFNDSACOMPARE;
typedef PFNDACOMPARECONST       PFNDSACOMPARECONST;
typedef PFNDAENUMCALLBACK       PFNDPAENUMCALLBACK;
typedef PFNDAENUMCALLBACKCONST  PFNDPAENUMCALLBACKCONST;
typedef PFNDACOMPARE            PFNDPACOMPARE;
typedef PFNDACOMPARECONST       PFNDPACOMPARECONST;
#endif

/* Dynamic pointer array stream information */
#if (_WIN32_IE >= 0x0300)
typedef struct _DPASTREAMINFO {
    int     iPos;
    void    *pvItem;
} DPASTREAMINFO;
#endif

/* Dynamic pointer array callbacks */
#if (_WIN32_IE >= 0x0300)
typedef HRESULT (CALLBACK *PFNDPASTREAM)( DPASTREAMINFO *, struct IStream *, void * );
typedef void * (CALLBACK *PFNDPAMERGE)( UINT, void *, void *, LPARAM );
typedef const void * (CALLBACK *PFNDPAMERGECONST)( UINT, const void *, const void *, LPARAM );
#endif

/* Subclassing procedure */
#if (_WIN32_WINNT >= 0x0501)
typedef LRESULT (CALLBACK *SUBCLASSPROC)( HWND, UINT, WPARAM, LPARAM, UINT_PTR, DWORD_PTR );
#endif

/* LoadIconMetric() options */
#if (NTDDI_VERSION >= 0x06000000)
enum _LI_METRIC {
    LIM_SMALL   = 0,
    LIM_LARGE   = 1
};
#endif

/* Functions in COMCTL32.DLL */
WINCOMMCTRLAPI HBITMAP WINAPI       CreateMappedBitmap( HINSTANCE, INT_PTR, UINT, LPCOLORMAP, int );
WINCOMMCTRLAPI HWND WINAPI          CreateStatusWindowA( LONG, LPCSTR, HWND, UINT );
WINCOMMCTRLAPI HWND WINAPI          CreateStatusWindowW( LONG, LPCWSTR, HWND, UINT );
WINCOMMCTRLAPI HWND WINAPI          CreateToolbarEx( HWND, DWORD, UINT, int, HINSTANCE, UINT_PTR, LPCTBBUTTON, int, int, int, int, int, UINT );
WINCOMMCTRLAPI HWND WINAPI          CreateUpDownControl( DWORD, int, int, int, int, HWND, int, HINSTANCE, HWND, int, int, int );
WINCOMMCTRLAPI void WINAPI          DrawInsert( HWND, HWND, int );
WINCOMMCTRLAPI void WINAPI          DrawStatusTextA( HDC, LPCRECT, LPCSTR, UINT );
WINCOMMCTRLAPI void WINAPI          DrawStatusTextW( HDC, LPCRECT, LPCWSTR, UINT );
WINCOMMCTRLAPI void WINAPI          GetEffectiveClientRect( HWND, LPRECT, const INT * );
WINCOMMCTRLAPI int WINAPI           ImageList_Add( HIMAGELIST, HBITMAP, HBITMAP );
WINCOMMCTRLAPI int WINAPI           ImageList_AddMasked( HIMAGELIST, HBITMAP, COLORREF );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_BeginDrag( HIMAGELIST, int, int, int );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_Create( int, int, UINT, int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Destroy( HIMAGELIST );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DragEnter( HWND, int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DragLeave( HWND );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DragMove( int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DragShowNolock( BOOL );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Draw( HIMAGELIST, int, HDC, int, int, UINT );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DrawEx( HIMAGELIST, int, HDC, int, int, int, int, COLORREF, COLORREF, UINT );
WINCOMMCTRLAPI void WINAPI          ImageList_EndDrag( void );
WINCOMMCTRLAPI COLORREF WINAPI      ImageList_GetBkColor( HIMAGELIST );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_GetDragImage( POINT *, POINT * );
WINCOMMCTRLAPI HICON WINAPI         ImageList_GetIcon( HIMAGELIST, int, UINT );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_GetIconSize( HIMAGELIST, int *, int * );
WINCOMMCTRLAPI int WINAPI           ImageList_GetImageCount( HIMAGELIST );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_GetImageInfo( HIMAGELIST, int, IMAGEINFO * );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_LoadImageA( HINSTANCE, LPCSTR, int, int, COLORREF, UINT, UINT );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_LoadImageW( HINSTANCE, LPCWSTR, int, int, COLORREF, UINT, UINT );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_Merge( HIMAGELIST, int, HIMAGELIST, int, int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Remove( HIMAGELIST, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Replace( HIMAGELIST, int, HBITMAP, HBITMAP );
WINCOMMCTRLAPI int WINAPI           ImageList_ReplaceIcon( HIMAGELIST, int, HICON );
WINCOMMCTRLAPI COLORREF WINAPI      ImageList_SetBkColor( HIMAGELIST, COLORREF );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_SetDragCursorImage( HIMAGELIST, int, int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_SetIconSize( HIMAGELIST, int, int );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_SetOverlayImage( HIMAGELIST, int, int );
WINCOMMCTRLAPI void WINAPI          InitCommonControls( void );
WINCOMMCTRLAPI int WINAPI           LBItemFromPt( HWND, POINT, BOOL );
WINCOMMCTRLAPI BOOL WINAPI          MakeDragList( HWND );
WINCOMMCTRLAPI void WINAPI          MenuHelp( UINT, WPARAM, LPARAM, HMENU, HINSTANCE, HWND, UINT * );
WINCOMMCTRLAPI BOOL WINAPI          ShowHideMenuCtl( HWND, UINT_PTR, LPINT );
#ifdef __objidl_h__
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_Read( LPSTREAM );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Write( HIMAGELIST, LPSTREAM );
#endif
#if (_WIN32_IE >= 0x0300)
WINCOMMCTRLAPI HDPA WINAPI          DPA_Clone( const HDPA, HDPA );
WINCOMMCTRLAPI HDPA WINAPI          DPA_Create( int );
WINCOMMCTRLAPI HDPA WINAPI          DPA_CreateEx( int, HANDLE );
WINCOMMCTRLAPI BOOL WINAPI          DPA_DeleteAllPtrs( HDPA );
WINCOMMCTRLAPI PVOID WINAPI         DPA_DeletePtr( HDPA, int );
WINCOMMCTRLAPI BOOL WINAPI          DPA_Destroy( HDPA );
WINCOMMCTRLAPI void WINAPI          DPA_DestroyCallback( HDPA, PFNDAENUMCALLBACK, void * );
WINCOMMCTRLAPI void WINAPI          DPA_EnumCallback( HDPA, PFNDAENUMCALLBACK, void * );
WINCOMMCTRLAPI PVOID WINAPI         DPA_GetPtr( HDPA, INT_PTR );
WINCOMMCTRLAPI int WINAPI           DPA_GetPtrIndex( HDPA, const void * );
WINCOMMCTRLAPI BOOL WINAPI          DPA_Grow( HDPA, int );
WINCOMMCTRLAPI int WINAPI           DPA_InsertPtr( HDPA, int, void * );
WINCOMMCTRLAPI HRESULT WINAPI       DPA_LoadStream( HDPA *, PFNDPASTREAM, struct IStream *, void * );
WINCOMMCTRLAPI BOOL WINAPI          DPA_Merge( HDPA, HDPA, DWORD, PFNDACOMPARE, PFNDPAMERGE, LPARAM );
WINCOMMCTRLAPI HRESULT WINAPI       DPA_SaveStream( HDPA, PFNDPASTREAM, struct IStream *, void * );
WINCOMMCTRLAPI int WINAPI           DPA_Search( HDPA, void *, int, PFNDACOMPARE, LPARAM, UINT );
WINCOMMCTRLAPI BOOL WINAPI          DPA_SetPtr( HDPA, int, void * );
WINCOMMCTRLAPI BOOL WINAPI          DPA_Sort( HDPA, PFNDACOMPARE, LPARAM );
WINCOMMCTRLAPI HDSA WINAPI          DSA_Create( int, int );
WINCOMMCTRLAPI BOOL WINAPI          DSA_DeleteAllItems( HDSA );
WINCOMMCTRLAPI BOOL WINAPI          DSA_DeleteItem( HDSA, int );
WINCOMMCTRLAPI BOOL WINAPI          DSA_Destroy( HDSA );
WINCOMMCTRLAPI void WINAPI          DSA_DestroyCallback( HDSA, PFNDAENUMCALLBACK, void * );
WINCOMMCTRLAPI void WINAPI          DSA_EnumCallback( HDSA, PFNDAENUMCALLBACK, void * );
WINCOMMCTRLAPI BOOL WINAPI          DSA_GetItem( HDSA, int, void * );
WINCOMMCTRLAPI PVOID WINAPI         DSA_GetItemPtr( HDSA, int );
WINCOMMCTRLAPI int WINAPI           DSA_InsertItem( HDSA, int, const void * );
WINCOMMCTRLAPI BOOL WINAPI          DSA_SetItem( HDSA, int, const void * );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_Copy( HIMAGELIST, int, HIMAGELIST, int, UINT );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_DrawIndirect( IMAGELISTDRAWPARAMS * );
WINCOMMCTRLAPI BOOL WINAPI          ImageList_SetImageCount( HIMAGELIST, UINT );
WINCOMMCTRLAPI BOOL WINAPI          InitCommonControlsEx( const INITCOMMONCONTROLSEX * );
WINCOMMCTRLAPI BOOL WINAPI          Str_SetPtrW( LPWSTR *, LPCWSTR );
WINCOMMCTRLAPI BOOL WINAPI          _TrackMouseEvent( LPTRACKMOUSEEVENT );
#endif
#if (_WIN32_IE >= 0x0400)
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_EnableScrollBar( HWND, int, UINT );
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_GetScrollInfo( HWND, int, LPSCROLLINFO );
WINCOMMCTRLAPI int WINAPI           FlatSB_GetScrollPos( HWND, int );
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_GetScrollProp( HWND, int, LPINT );
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_GetScrollRange( HWND, int, LPINT, LPINT );
WINCOMMCTRLAPI int WINAPI           FlatSB_SetScrollInfo( HWND, int, LPSCROLLINFO, BOOL );
WINCOMMCTRLAPI int WINAPI           FlatSB_SetScrollPos( HWND, int, int, BOOL );
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_SetScrollProp( HWND, UINT, INT_PTR, BOOL );
WINCOMMCTRLAPI int WINAPI           FlatSB_SetScrollRange( HWND, int, int, int, BOOL );
WINCOMMCTRLAPI BOOL WINAPI          FlatSB_ShowScrollBar( HWND, int, BOOL );
WINCOMMCTRLAPI LANGID WINAPI        GetMUILanguage( void );
WINCOMMCTRLAPI HIMAGELIST WINAPI    ImageList_Duplicate( HIMAGELIST );
WINCOMMCTRLAPI void WINAPI          InitMUILanguage( LANGID );
WINCOMMCTRLAPI BOOL WINAPI          InitializeFlatSB( HWND );
WINCOMMCTRLAPI HRESULT WINAPI       TaskDialog( HWND, HINSTANCE, PCWSTR, PCWSTR, PCWSTR, TASKDIALOG_COMMON_BUTTON_FLAGS, PCWSTR, int * );
WINCOMMCTRLAPI HRESULT WINAPI       TaskDialogIndirect( const TASKDIALOGCONFIG *, int *, int *, BOOL * );
WINCOMMCTRLAPI HRESULT WINAPI       UninitializeFlatSB( HWND );
#endif
#if (_WIN32_WINNT >= 0x0501)
WINCOMMCTRLAPI LRESULT WINAPI       DefSubclassProc( HWND, UINT, WPARAM, LPARAM );
WINCOMMCTRLAPI int WINAPI           DrawShadowText( HDC, LPCWSTR, UINT, RECT *, DWORD, COLORREF, COLORREF, int, int );
WINCOMMCTRLAPI BOOL WINAPI          GetWindowSubclass( HWND, SUBCLASSPROC, UINT_PTR, DWORD_PTR * );
WINCOMMCTRLAPI HRESULT WINAPI       HIMAGELIST_QueryInterface( HIMAGELIST, REFIID, void ** );
WINCOMMCTRLAPI BOOL WINAPI          RemoveWindowSubclass( HWND, SUBCLASSPROC, UINT_PTR );
WINCOMMCTRLAPI BOOL WINAPI          SetWindowSubclass( HWND, SUBCLASSPROC, UINT_PTR, DWORD_PTR );
#ifdef __objidl_h__
WINCOMMCTRLAPI HRESULT WINAPI       ImageList_ReadEx( DWORD, LPSTREAM, REFIID, PVOID * );
WINCOMMCTRLAPI HRESULT WINAPI       ImageList_WriteEx( HIMAGELIST, DWORD, LPSTREAM );
#endif
#endif
#if (NTDDI_VERSION >= 0x06000000)
WINCOMMCTRLAPI ULONGLONG WINAPI     DPA_GetSize( HDPA );
WINCOMMCTRLAPI HDSA WINAPI          DSA_Clone( HDSA );
WINCOMMCTRLAPI ULONGLONG WINAPI     DSA_GetSize( HDSA );
WINCOMMCTRLAPI BOOL WINAPI          DSA_Sort( HDSA, PFNDACOMPARE, LPARAM );
WINCOMMCTRLAPI HRESULT WINAPI       LoadIconMetric( HINSTANCE, PCWSTR, int, HICON * );
WINCOMMCTRLAPI HRESULT WINAPI       LoadIconWithScaleDown( HINSTANCE, PCWSTR, int, int, HICON * );
#endif

/* Functions implemented as macros */
#define ImageList_AddIcon( p1, p2 ) \
    ImageList_ReplaceIcon( p1, -1, p2 )
#define ImageList_RemoveAll( x ) \
    ImageList_Remove( x, -1 )
#define ImageList_ExtractIcon( p1, p2, p3 ) \
    ImageList_GetIcon( p2, p3, 0 )
#define ImageList_LoadBitmap( p1, p2, p3, p4, p5 ) \
    ImageList_LoadImage( p1, p2, p3, p4, p5, IMAGE_BITMAP, 0 )
#define Header_GetItemCount( x ) \
    (int)SNDMSG( x, HDM_GETITEMCOUNT, 0, 0L )
#define Header_InsertItem( x, p1, p2 ) \
    (int)SNDMSG( x, HDM_INSERTITEM, (WPARAM)(int)(p1), (LPARAM)(const HD_ITEM *)(p2) )
#define Header_DeleteItem( x, p ) \
    (BOOL)SNDMSG( x, HDM_DELETEITEM, (WPARAM)(int)(p), 0L )
#define Header_GetItem( x, p1, p2 ) \
    (BOOL)SNDMSG( x, HDM_GETITEM, (WPARAM)(int)(p1), (LPARAM)(HD_ITEM *)(p2) )
#define Header_SetItem( x, p1, p2 ) \
    (BOOL)SNDMSG( x, HDM_SETITEM, (WPARAM)(int)(p1), (LPARAM)(const HD_ITEM *)(p2) )
#define Header_Layout( x, p ) \
    (BOOL)SNDMSG( x, HDM_LAYOUT, 0, (LPARAM)(HD_LAYOUT *)(p) )
#if (_WIN32_IE >= 0x0300)
    #define Header_GetItemRect( x, p1, p2 ) \
        (BOOL)SNDMSG( x, HDM_GETITEMRECT, (WPARAM)(p1), (LPARAM)(p2) )
    #define Header_SetImageList( x, p ) \
        (HIMAGELIST)SNDMSG( x, HDM_SETIMAGELIST, HDSIL_NORMAL, (LPARAM)(p) )
    #define Header_SetStateImageList( x, p ) \
        (HIMAGELIST)SNDMSG( x, HDM_SETIMAGELIST, HDSIL_STATE, (LPARAM)(p) )
    #define Header_GetImageList( x ) \
        (HIMAGELIST)SNDMSG( x, HDM_GETIMAGELIST, HDSIL_NORMAL, 0L )
    #define Header_GetStateImageList( x ) \
        (HIMAGELIST)SNDMSG( x, HDM_SETIMAGELIST, HDSIL_STATE, 0L )
    #define Header_OrderToIndex( x, p ) \
        (int)SNDMSG( x, HDM_ORDERTOINDEX, (WPARAM)(p), 0L )
    #define Header_CreateDragImage( x, p ) \
        (HIMAGELIST)SNDMSG( x, HDM_CREATEDRAGIMAGE, (WPARAM)(p), 0L )
    #define Header_GetOrderArray( x, p1, p2 ) \
        (BOOL)SNDMSG( x, HDM_GETORDERARRAY, (WPARAM)(p1), (LPARAM)(p2) )
    #define Header_SetOrderArray( x, p1, p2 ) \
        (BOOL)SNDMSG( x, HDM_SETORDERARRAY, (WPARAM)(p1), (LPARAM)(p2) )
    #define Header_SetHotDivider( x, p1, p2 ) \
        (int)SNDMSG( x, HDM_SETHOTDIVIDER, (WPARAM)(p1), (LPARAM)(p2) )
#endif
#if (_WIN32_IE >= 0x0500)
    #define Header_SetBitmapMargin( x, p ) \
        (int)SNDMSG( x, HDM_SETBITMAPMARGIN, (WPARAM)(p), 0L )
    #define Header_GetBitmapMargin( x, p ) \
        (int)SNDMSG( x, HDM_GETBITMAPMARGIN, 0, 0L )
    #define Header_SetFilterChangeTimeout( x, p ) \
        (int)SNDMSG( x, HDM_SETFILTERCHANGETIMEOUT, 0, (LPARAM)(p) )
    #define Header_EditFilter( x, p1, p2 ) \
        (int)SNDMSG( x, HDM_EDITFILTER, (WPARAM)(p1), MAKELPARAM( p2, 0 ) )
    #define Header_ClearFilter( x, p ) \
        (int)SNDMSG( x, HDM_CLEARFILTER, (WPARAM)(p), 0L )
    #define Header_ClearAllFilters( x ) \
        (int)SNDMSG( x, HDM_CLEARFILTER, (WPARAM)(-1), 0L )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define Header_GetItemDropDownRect( x, p1, p2 ) \
        (BOOL)SNDMSG( x, HDM_GETITEMDROPDOWNRECT, (WPARAM)(p1), (LPARAM)(p2) )
    #define Header_GetOverflowRect( x, p ) \
        (BOOL)SNDMSG( x, HDM_GETOVERFLOWRECT, 0, (LPARAM)(p) )
    #define Header_GetFocusedItem( x ) \
        (int)SNDMSG( x, HDM_GETFOCUSEDITEM, 0, 0L )
    #define Header_SetFocusedItem( x, p ) \
        (BOOL)SNDMSG( x, HDM_SETFOCUSEDITEM, 0, (LPARAM)(p) )
#endif
#if (_WIN32_IE >= 0x0400)
    #define Header_SetUnicodeFormat( x, p ) \
        (BOOL)SNDMSG( x, HDM_SETUNICODEFORMAT, (WPARAM)(p), 0L )
    #define Header_GetUnicodeFormat( x ) \
        (BOOL)SNDMSG( x, HDM_GETUNICODEFORMAT, 0, 0L )
#endif
#define ListView_GetBkColor( x ) \
    (COLORREF)SNDMSG( x, LVM_GETBKCOLOR, 0, 0L )
#define ListView_SetBkColor( x, p ) \
    (BOOL)SNDMSG( x, LVM_SETBKCOLOR, 0, (LPARAM)(COLORREF)(p) )
#define ListView_GetImageList( x, p ) \
    (HIMAGELIST)SNDMSG( x, LVM_GETIMAGELIST, (WPARAM)(INT)(p), 0L )
#define ListView_SetImageList( x, p1, p2 ) \
    (HIMAGELIST)SNDMSG( x, LVM_SETIMAGELIST, (WPARAM)(p2), (LPARAM)(HIMAGELIST)(p1) )
#define ListView_GetItemCount( x ) \
    (int)SNDMSG( x, LVM_GETITEMCOUNT, 0, 0L )
#define ListView_GetItem( x, p ) \
    (BOOL)SNDMSG( x, LVM_GETITEM, 0, (LPARAM)(LV_ITEM *)(p) )
#define ListView_SetItem( x, p ) \
    (BOOL)SNDMSG( x, LVM_SETITEM, 0, (LPARAM)(const LV_ITEM *)(p) )
#define ListView_InsertItem( x, p ) \
    (int)SNDMSG( x, LVM_INSERTITEM, 0, (LPARAM)(const LV_ITEM *)(p) )
#define ListView_DeleteItem( x, p ) \
    (BOOL)SNDMSG( x, LVM_DELETEITEM, (WPARAM)(int)(p), 0L )
#define ListView_DeleteAllItems( x ) \
    (BOOL)SNDMSG( x, LVM_DELETEALLITEMS, 0, 0L )
#define ListView_GetCallbackMask( x ) \
    (BOOL)SNDMSG( x, LVM_GETCALLBACKMASK, 0, 0L )
#define ListView_SetCallbackMask( x, p ) \
    (BOOL)SNDMSG( x, LVM_SETCALLBACKMASK, (WPARAM)(UINT)(p), 0L )
#define ListView_GetNextItem( x, p1, p2 ) \
    (int)SNDMSG( x, LVM_GETNEXTITEM, (WPARAM)(int)(p1), MAKELPARAM( p2, 0 ) )
#define ListView_FindItem( x, p1, p2 ) \
    (int)SNDMSG( x, LVM_FINDITEM, (WPARAM)(int)(p1), (LPARAM)(const LV_FINDINFO *)(p2) )
#define ListView_GetItemRect( x, p1, p2, p3 ) \
    (BOOL)SNDMSG( x, LVM_GETITEMRECT, (WPARAM)(int)(p1), (LPARAM)(RECT *)((p2) ? \
    (((RECT *)(p2))->left = (p3), (p2)) : NULL))
#define ListView_SetItemPosition( x, p1, p2, p3 ) \
    (BOOL)SNDMSG( x, LVM_SETITEMPOSITION, (WPARAM)(int)(p1), MAKELPARAM( p1, p2 ) )
#define ListView_GetItemPosition( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_GETITEMPOSITION, (WPARAM)(int)(p1), (LPARAM)(POINT *)(p2) )
#define ListView_GetStringWidth( x, p ) \
    (int)SNDMSG( x, LVM_GETSTRINGWIDTH, 0, (LPARAM)(LPCTSTR)(p) )
#define ListView_HitTest( x, p ) \
    (int)SNDMSG( x, LVM_HITTEST, 0, (LPARAM)(LV_HITTESTINFO *)(p) )
#define ListView_HitTestEx( x, p ) \
    (int)SNDMSG( x, LVM_HITTEST, ((WPARAM)-1), (LPARAM)(LV_HITTESTINFO *)(p) )
#define ListView_EnsureVisible( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_ENSUREVISIBLE, (WPARAM)(int)(p1), MAKELPARAM( p2, 0 ) )
#define ListView_Scroll( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_SCROLL, (WPARAM)(int)(p1), (LPARAM)(int)(p2) )
#define ListView_RedrawItems( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_REDRAWITEMS, (WPARAM)(int)(p1), (LPARAM)(int)(p2) )
#define ListView_Arrange( x, p ) \
    (BOOL)SNDMSG( x, LVM_ARRANGE, (WPARAM)(UINT)(p), 0L )
#define ListView_EditLabel( x, p ) \
    (HWND)SNDMSG( x, LVM_EDITLABEL, (WPARAM)(int)(p), 0L )
#define ListView_GetEditControl( x ) \
    (HWND)SNDMSG( x, LVM_GETEDITCONTROL, 0, 0L )
#define ListView_GetColumn( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_GETCOLUMN, (WPARAM)(int)(p1), (LPARAM)(LV_COLUMN *)(p2) )
#define ListView_SetColumn( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_SETCOLUMN, (WPARAM)(int)(p1), (LPARAM)(const LV_COLUMN *)(p2) )
#define ListView_InsertColumn( x, p1, p2 ) \
    (int)SNDMSG( x, LVM_INSERTCOLUMN, (WPARAM)(int)(p1), (LPARAM)(const LV_COLUMN *)(p2) )
#define ListView_DeleteColumn( x, p ) \
    (BOOL)SNDMSG( x, LVM_DELETECOLUMN, (WPARAM)(int)(p), 0L )
#define ListView_GetColumnWidth( x, p ) \
    (int)SNDMSG( x, LVM_GETCOLUMNWIDTH, (WPARAM)(int)(p), 0L )
#define ListView_SetColumnWidth( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_SETCOLUMNWIDTH, (WPARAM)(int)(p1), MAKELPARAM( p2, 0 ) )
#if (_WIN32_IE >= 0x0300)
    #define ListView_GetHeader( x ) \
        (HWND)SNDMSG( x, LVM_GETHEADER, 0, 0L )
#endif
#define ListView_CreateDragImage( x, p1, p2 ) \
    (HIMAGELIST)SNDMSG( x, LVM_CREATEDRAGIMAGE, (WPARAM)(int)(p1), (LPARAM)(LPPOINT)(p2) )
#define ListView_GetViewRect( x, p ) \
    (BOOL)SNDMSG( x, LVM_GETVIEWRECT, 0, (LPARAM)(RECT *)(p) )
#define ListView_GetTextColor( x ) \
    (COLORREF)SNDMSG( x, LVM_GETTEXTCOLOR, 0, 0L )
#define ListView_SetTextColor( x, p ) \
    (BOOL)SNDMSG( x, LVM_SETTEXTCOLOR, 0, (LPARAM)(COLORREF)(p) )
#define ListView_GetTextBkColor( x ) \
    (COLORREF)SNDMSG( x, LVM_GETTEXTBKCOLOR, 0, 0L )
#define ListView_SetTextBkColor( x, p ) \
    (BOOL)SNDMSG( x, LVM_SETTEXTBKCOLOR, 0, (LPARAM)(COLORREF)(p) )
#define ListView_GetTopIndex( x ) \
    (int)SNDMSG( x, LVM_GETTOPINDEX, 0, 0L )
#define ListView_GetCountPerPage( x ) \
    (int)SNDMSG( x, LVM_GETCOUNTPERPAGE, 0, 0L )
#define ListView_GetOrigin( x, p ) \
    (BOOL)SNDMSG( x, LVM_GETORIGIN, 0, (LPARAM)(POINT *)(p) )
#define ListView_Update( x, p ) \
    (BOOL)SNDMSG( x, LVM_UPDATE, (WPARAM)(p), 0L )
#define ListView_SetItemState( x, p1, p2, p3 ) \
    { \
        LV_ITEM __item; \
        __item.stateMask = p3; \
        __item.state = p2; \
        SNDMSG( x, LVM_SETITEMSTATE, (WPARAM)(p1), (LPARAM)(LV_ITEM *)&__item ); \
    }
#if (_WIN32_IE >= 0x0300)
    #define ListView_SetCheckState( x, p1, p2 ) \
        ListView_SetItemState( x, p1, INDEXTOSTATEIMAGEMASK( (p2) ? 2 : 1 ), LVIS_STATEIMAGEMASK )
#endif
#define ListView_GetItemState( x, p1, p2 ) \
    (UINT)SNDMSG( x, LVM_GETITEMSTATE, (WPARAM)(p1), (LPARAM)(p2) )
#if (_WIN32_IE >= 0x0300)
    #define ListView_GetCheckState( x, p ) \
        ((((UINT)SNDMSG( x, LVM_GETITEMSTATE, (WPARAM)(p), LVIS_STATEIMAGEMASK )) >> 12) - 1)
#endif
#define ListView_GetItemText( x, p1, p2, p3, p4 ) \
    { \
        LV_ITEM __item; \
        __item.iSubItem = p2; \
        __item.pszText = p3; \
        __item.cchTextMax = p4; \
        SNDMSG( x, LVM_GETITEMTEXT, (WPARAM)(p1), (LPARAM)(LV_ITEM *)&__item ); \
    }
#define ListView_SetItemText( x, p1, p2, p3 ) \
    { \
        LV_ITEM __item; \
        __item.iSubItem = p2; \
        __item.pszText = p3; \
        SNDMSG( x, LVM_SETITEMTEXT, (WPARAM)(p1), (LPARAM)(LV_ITEM *)&__item ); \
    }
#define ListView_SetItemCount( x, p ) \
    SNDMSG( x, LVM_SETITEMCOUNT, (WPARAM)(p), 0L )
#if (_WIN32_IE >= 0x0300)
    #define ListView_SetItemCountEx( x, p1, p2 ) \
        SNDMSG( x, LVM_SETITEMCOUNT, (WPARAM)(p1), (LPARAM)(p2) )
#endif
#define ListView_SortItems( x, p1, p2 ) \
    (BOOL)SNDMSG( x, LVM_SORTITEMS, (WPARAM)(LPARAM)(p2), (LPARAM)(PFNLVCOMPARE)(p1) )
#define ListView_GetSelectedCount( x ) \
    (UINT)SNDMSG( x, LVM_GETSELECTEDCOUNT, 0, 0L )
#define ListView_GetItemSpacing( x, p ) \
    (DWORD)SNDMSG( x, LVM_GETITEMSPACING, p, 0L )
#define ListView_GetISearchString( x, p ) \
    (BOOL)SNDMSG( x, LVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)(p) )
#if (_WIN32_IE >= 0x0300)
    #define ListView_SetIconSpacing( x, p1, p2 ) \
        (DWORD)SNDMSG( x, LVM_SETICONSPACING, 0, MAKELONG( p1, p2 )
    #define ListView_SetExtendedListViewStyle( x, p ) \
        (DWORD)SNDMSG( x, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, p )
#endif
#if (_WIN32_IE >= 0x0400)
    #define ListView_SetExtendedListViewStyleEx( x, p1, p2 ) \
        (DWORD)SNDMSG( x, LVM_SETEXTENDEDLISTVIEWSTYLE, p1, p2 )
#endif
#if (_WIN32_IE >= 0x0300)
    #define ListView_GetExtendedListViewStyle( x ) \
        (DWORD)SNDMSG( x, LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0L )
    #define ListView_GetSubItemRect( x, p1, p2, p3, p4 ) \
        (BOOL)SNDMSG( x, LVM_GETSUBITEMRECT, (WPARAM)(int)(p1), ((p4) ? \
        ((((LPRECT)(p4))->top = (p2)), (((LPRECT)(p4))->left = (p3)), (LPARAM)(p4)) : \
        (LPARAM)(LPRECT)NULL) )
    #define ListView_SubItemHitTest( x, p ) \
        (int)SNDMSG( x, LVM_SUBITEMHITTEST, 0, (LPARAM)(LPLVHITTESTINFO)(p) )
    #define ListView_SubItemHitTestEx( x, p ) \
        (int)SNDMSG( x, LVM_SUBITEMHITTESTEX, ((WPARAM)-1), (LPARAM)(LPLVHITTESTINFO)(p) )
    #define ListView_SetColumnOrderArray( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_SETCOLUMNORDERARRAY, (WPARAM)(p1), (LPARAM)(LPINT)(p2) )
    #define ListView_GetColumnOrderArray( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETCOLUMNORDERARRAY, (WPARAM)(p1), (LPARAM)(LPINT)(p2) )
    #define ListView_SetHotItem( x, p ) \
        (int)SNDMSG( x, LVM_SETHOTITEM, (WPARAM)(p), 0L )
    #define ListView_GetHotItem( x ) \
        (int)SNDMSG( x, LVM_GETHOTITEM, 0, 0L )
    #define ListView_SetHotCursor( x, p ) \
        (HCURSOR)SNDMSG( x, LVM_SETHOTCURSOR, 0, (LPARAM)(p) )
    #define ListView_GetHotCursor( x, p ) \
        (HCURSOR)SNDMSG( x, LVM_GETHOTCURSOR, 0, 0L )
    #define ListView_ApproximateViewRect( x, p1, p2, p3 ) \
        (DWORD)SNDMSG( x, LVM_APPROXIMATEVIEWRECT, (WPARAM)(p3), MAKELPARAM( p1, p2 ) )
#endif
#if (_WIN32_IE >= 0x0400)
    #define ListView_SetWorkAreas( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_SETWORKAREAS, (WPARAM)(int)(p1), (LPARAM)(RECT *)(p2) )
    #define ListView_GetSelectionMark( x ) \
        (int)SNDMSG( x, LVM_GETSELECTIONMARK, 0, 0L )
    #define ListView_SetSelectionMark( x, p ) \
        (int)SNDMSG( x, LVM_SETSELECTIONMARK, 0, (LPARAM)(p) )
    #define ListView_SetBkImage( x, p ) \
        (BOOL)SNDMSG( x, LVM_SETBKIMAGE, 0, (LPARAM)(p) )
    #define ListView_GetBkImage( x, p ) \
        (BOOL)SNDMSG( x, LVM_GETBKIMAGE, 0, (LPARAM)(p) )
    #define ListView_GetWorkAreas( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETWORKAREAS, (WPARAM)(int)(p1), (LPARAM)(RECT *)(p2) )
    #define ListView_SetHoverTime( x, p ) \
        (DWORD)SNDMSG( x, LVM_SETHOVERTIME, 0, (LPARAM)(p) )
    #define ListView_GetHoverTime( x ) \
        (DWORD)SNDMSG( x, LVM_GETHOVERTIME, 0, 0L )
    #define ListView_GetNumberOfWorkAreas( x, p ) \
        (BOOL)SNDMSG( x, LVM_GETNUMBEROFWORKAREAS, 0, (LPARAM)(UINT *)(p) )
    #define ListView_SetToolTips( x, p ) \
        (HWND)SNDMSG( x, LVM_SETTOOLTIPS, (WPARAM)(p), 0L )
    #define ListView_GetToolTips( x ) \
        (HWND)SNDMSG( x, LVM_GETTOOLTIPS, 0, 0L )
    #define ListView_SortItemsEx( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_SORTITEMSEX, (WPARAM)(LPARAM)(p2), (LPARAM)(PFNLVCOMPARE)(p1) )
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define ListView_GetGroupRect( x, p1, p2, p3 ) \
        SNDMSG( x, LVM_GETGROUPRECT, (WPARAM)(p1), (LPARAM)(RECT *)((p3) ? \
        (((RECT *)(p3))->top = p2), (p3) : NULL) )
    #define ListView_GetGroupState( x, p1, p2 ) \
        (UINT)SNDMSG( x, LVM_GETGROUPSTATE, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetFocusedGroup( x ) \
        SNDMSG( x, LVM_GETFOCUSEDGROUP, 0, 0L )
    #define ListView_SetSelectedColumn( x, p ) \
        SNDMSG( x, LVM_SETSELECTEDCOLUMN, (WPARAM)(p), 0L )
    #define ListView_SetView( x, p ) \
        (DWORD)SNDMSG( x, LVM_SETVIEW, (WPARAM)(DWORD)(p), 0L )
    #define ListView_GetView( x ) \
        (DWORD)SNDMSG( x, LVM_GETVIEW, 0, 0L )
    #define ListView_InsertGroup( x, p1, p2 ) \
        SNDMSG( x, LVM_INSERTGROUP, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_SetGroupInfo( x, p1, p2 ) \
        SNDMSG( x, LVM_SETGROUPINFO, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetGroupInfo( x, p1, p2 ) \
        SNDMSG( x, LVM_GETGROUPINFO, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_RemoveGroup( x, p ) \
        SNDMSG( x, LVM_REMOVEGROUP, (WPARAM)(p), 0L )
    #define ListView_MoveGroup( x, p1, p2 ) \
        SNDMSG( x, LVM_MOVEGROUP, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetGroupCount( x ) \
        SNDMSG( x, LVM_GETGROUPCOUNT, 0, 0L )
    #define ListView_GetGroupInfoByIndex( x, p1, p2 ) \
        SNDMSG( x, LVM_GETGROUPINFOBYINDEX, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_MoveItemToGroup( x, p1, p2 ) \
        SNDMSG( x, LVM_MOVEITEMTOGROUP, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_SetGroupMetrics( x, p ) \
        SNDMSG( x, LVM_SETGROUPMETRICS, 0, (LPARAM)(p) )
    #define ListView_GetGroupMetrics( x, p ) \
        SNDMSG( x, LVM_GETGROUPMETRICS, 0, (LPARAM)(p) )
    #define ListView_EnableGroupView( x, p ) \
        SNDMSG( x, LVM_ENABLEGROUPVIEW, (WPARAM)(p), 0L )
    #define ListView_SortGroups( x, p1, p2 ) \
        SNDMSG( x, LVM_SORTGROUPS, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_InsertGroupSorted( x, p ) \
        SNDMSG( x, LVM_INSERTGROUPSORTED, (WPARAM)(p), 0L )
    #define ListView_RemoveAllGroups( x ) \
        SNDMSG( x, LVM_REMOVEALLGROUPS, 0, 0L )
    #define ListView_HasGroup( x, p ) \
        SNDMSG( x, LVM_HASGROUP, p, 0L )
    #define ListView_SetGroupState( x, p1, p2, p3 ) \
        { \
            LVGROUP __group; \
            __group.cbSize = sizeof( __group ); \
            __group.mask = LVGF_STATE; \
            __group.stateMask = p2; \
            __group.state = p3; \
            SNDMSG( x, LVM_SETGROUPINFO, (WPARAM)(p1), (LPARAM)(LVGROUP *)&__group ); \
        }
    #define ListView_SetTileViewInfo( x, p ) \
        SNDMSG( x, LVM_SETTILEVIEWINFO, 0, (LPARAM)(p) )
    #define ListView_GetTileViewInfo( x, p ) \
        SNDMSG( x, LVM_GETTILEVIEWINFO, 0, (LPARAM)(p) )
    #define ListView_SetTileInfo( x, p ) \
        SNDMSG( x, LVM_SETTILEINFO, 0, (LPARAM)(p) )
    #define ListView_GetTileInfo( x, p ) \
        SNDMSG( x, LVM_GETTILEINFO, 0, (LPARAM)(p) )
    #define ListView_SetInsertMark( x, p ) \
        (BOOL)SNDMSG( x, LVM_SETINSERTMARK, 0, (LPARAM)(p) )
    #define ListView_GetInsertMark( x, p ) \
        (BOOL)SNDMSG( x, LVM_GETINSERTMARK, 0, (LPARAM)(p) )
    #define ListView_InsertMarkHitTest( x, p1, p2 ) \
        (int)SNDMSG( x, LVM_INSERTMARKHITTEST, (WPARAM)(LPPOINT)(p1), \
        (LPARAM)(LPLVINSERTMARK)(p2) )
    #define ListView_GetInsertMarkRect( x, p ) \
        (int)SNDMSG( x, LVM_GETINSERTMARKRECT, 0, (LPARAM)(LPRECT)(p) )
    #define ListView_SetInsertMarkColor( x, p ) \
        (COLORREF)SNDMSG( x, LVM_SETINSERTMARKCOLOR, 0, (LPARAM)(COLORREF)(p) )
    #define ListView_GetInsertMarkColor( x ) \
        (COLORREF)SNDMSG( x, LVM_GETINSERTMARKCOLOR, 0, 0L )
    #define ListView_SetInfoTip( x, p ) \
        (BOOL)SNDMSG( x, LVM_SETINFOTIP, 0, (LPARAM)(p) )
    #define ListView_GetSelectedColumn( x ) \
        (UINT)SNDMSG( x, LVM_GETSELECTEDCOLUMN, 0, 0L )
    #define ListView_IsGroupViewEnabled( x ) \
        (BOOL)SNDMSG( x, LVM_ISGROUPVIEWENABLED, 0, 0L )
    #define ListView_GetOutlineColor( x ) \
        (COLORREF)SNDMSG( x, LVM_GETOUTLINECOLOR, 0, 0L )
    #define ListView_SetOutlineColor( x, p ) \
        (COLORREF)SNDMSG( x, LVM_SETOUTLINECOLOR, 0, (LPARAM)(COLORREF)(p) )
    #define ListView_CancelEditLabel( x ) \
        (VOID)SNDMSG( x, LVM_CANCELEDITLABEL, 0, 0L )
    #define ListView_MapIndexToID( x, p ) \
        (UINT)SNDMSG( x, LVM_MAPINDEXTOID, (WPARAM)(p), 0L )
    #define ListView_MapIDToIndex( x, p ) \
        (UINT)SNDMSG( x, LVM_MAPIDTOINDEX, (WPARAM)(p), 0L )
    #define ListView_IsItemVisible( x, p ) \
        (UINT)SNDMSG( x, LVM_ISITEMVISIBLE, (WPARAM)(p), 0L )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define ListView_SetGroupHeaderImageList( x, p ) \
        (HIMAGELIST)SNDMSG( x, LVM_SETIMAGELIST, LVSIL_GROUPHEADER, \
        (LPARAM)(HIMAGELIST)(p) )
    #define ListView_GetGroupHeaderImageList( x ) \
        (HIMAGELIST)SNDMSG( x, LVM_GETIMAGELIST, LVSIL_GROUPHEADER, 0L )
    #define ListView_GetEmptyText( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETEMPTYTEXT, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetFooterRect( x, p ) \
        (BOOL)SNDMSG( x, LVM_GETFOOTERRECT, 0, (LPARAM)(p) )
    #define ListView_GetFooterInfo( x, p ) \
        (BOOL)SNDMSG( x, LVM_GETFOOTERINFO, 0, (LPARAM)(p) )
    #define ListView_GetFooterItemRect( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETFOOTERITEMRECT, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetFooterItem( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETFOOTERITEM, (WPARAM)(p1), (LPARAM)(p2) )
    #define ListView_GetItemIndexRect( x, p1, p2, p3, p4 ) \
        (BOOL)SNDMSG( x, LVM_GETITEMINDEXRECT, (WPARAM)(LVITEMINDEX *)(p1), \
        (LPARAM)((p4) ? ((((LPRECT)(p4))->top = p2), \
        (((LPRECT)(p4))->left = p3), (p4)) : (LPRECT)NULL) )
    #define ListView_SetItemIndexRect( x, p1, p2, p3 ) \
        { \
            LV_ITEM __item; \
            __item.stateMask = p3; \
            __item.state = p2; \
            SNDMSG( x, LVM_SETITEMINDEXRECT, (WPARAM)(LVITEMINDEX *)(p1), \
                (LPARAM)(LV_ITEM *)&__item ); \
        }
    #define ListView_GetNextItemIndex( x, p1, p2 ) \
        (BOOL)SNDMSG( x, LVM_GETNEXTITEMINDEX, (WPARAM)(LVITEMINDEX *)(p1), \
        MAKELPARAM( p2, 0 ) )
#endif
#if (_WIN32_IE >= 0x0400)
    #define ListView_SetUnicodeFormat( x, p ) \
        (BOOL)SNDMSG( x, LVM_SETUNICODEFORMAT, (WPARAM)(p), 0L )
    #define ListView_GetUnicodeFormat( x ) \
        (BOOL)SNDMSG( x, LVM_GETUNICODEFORMAT, 0, 0L )
#endif
#define TreeView_InsertItem( x, p ) \
    (HTREEITEM)SNDMSG( x, TVM_INSERTITEM, 0, (LPARAM)(LPTV_INSERTSTRUCT)(p) )
#define TreeView_DeleteItem( x, p ) \
    (BOOL)SNDMSG( x, TVM_DELETEITEM, 0, (LPARAM)(HTREEITEM)(p) )
#define TreeView_DeleteAllItems( x ) \
    (BOOL)SNDMSG( x, TVM_DELETEITEM, 0, (LPARAM)TVI_ROOT )
#define TreeView_Expand( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TVM_EXPAND, (WPARAM)(p2), (LPARAM)(HTREEITEM)(p1) )
#define TreeView_GetItemRect( x, p1, p2, p3 ) \
    ((*(HTREEITEM *)(p2) = p1), (BOOL)SNDMSG( x, TVM_GETITEMRECT, (WPARAM)(p3), \
    (LPARAM)(RECT *)(p2) ))
#define TreeView_GetCount( x ) \
    (UINT)SNDMSG( x, TVM_GETCOUNT, 0, 0L )
#define TreeView_GetIndent( x ) \
    (UINT)SNDMSG( x, TVM_GETINDENT, 0, 0L )
#define TreeView_SetIndent( x, p ) \
    (BOOL)SNDMSG( x, TVM_SETINDENT, (WPARAM)(p), 0L )
#define TreeView_GetImageList( x, p ) \
    (HIMAGELIST)SNDMSG( x, TVM_GETIMAGELIST, p, 0L )
#define TreeView_SetImageList( x, p1, p2 ) \
    (HIMAGELIST)SNDMSG( x, TVM_SETIMAGELIST, p2, (LPARAM)(HIMAGELIST)(p1) )
#define TreeView_GetNextItem( x, p1, p2 ) \
    (HTREEITEM)SNDMSG( x, TVM_GETNEXTITEM, (WPARAM)(p2), (LPARAM)(HTREEITEM)(p1) )
#define TreeView_GetChild( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_CHILD )
#define TreeView_GetNextSibling( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_NEXT )
#define TreeView_GetPrevSibling( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_PREVIOUS )
#define TreeView_GetParent( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_PARENT )
#define TreeView_GetFirstVisible( x ) \
    TreeView_GetNextItem( x, NULL, TVGN_FIRSTVISIBLE )
#define TreeView_GetNextVisible( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_NEXTVISIBLE )
#define TreeView_GetPrevVisible( x, p ) \
    TreeView_GetNextItem( x, p, TVGN_PREVIOUSVISIBLE )
#define TreeView_GetSelection( x ) \
    TreeView_GetNextItem( x, NULL, TVGN_CARET )
#define TreeView_GetDropHilight( x ) \
    TreeView_GetNextItem( x, NULL, TVGN_DROPHILITE )
#define TreeView_GetRoot( x ) \
    TreeView_GetNextItem( x, NULL, TVGN_ROOT )
#if (_WIN32_IE >= 0x0400)
    #define TreeView_GetLastVisible( x ) \
        TreeView_GetNextItem( x, NULL, TVGN_LASTVISIBLE )
#endif
#if (_WIN32_IE >= 0x0600)
    #define TreeView_GetNextSelected( x, p ) \
        TreeView_GetNextItem( x, p, TVGN_NEXTSELECTED )
#endif
#define TreeView_Select( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TVM_SELECTITEM, (WPARAM)(p2), (LPARAM)(HTREEITEM)(p1) )
#define TreeView_SelectItem( x, p ) \
    TreeView_Select( x, p, TVGN_CARET )
#define TreeView_SelectDropTarget( x, p ) \
    TreeView_Select( x, p, TVGN_DROPHILITE )
#define TreeView_SelectSetFirstVisible( x, p ) \
    TreeView_Select( x, p, TVGN_FIRSTVISIBLE )
#define TreeView_GetItem( x, p ) \
    (BOOL)SNDMSG( x, TVM_GETITEM, 0, (LPARAM)(TV_ITEM *)(p) )
#define TreeView_SetItem( x, p ) \
    (BOOL)SNDMSG( x, TVM_SETITEM, 0, (LPARAM)(const TV_ITEM *)(p) )
#define TreeView_EditLabel( x, p ) \
    (HWND)SNDMSG( x, TVM_EDITLABEL, 0, (LPARAM)(HTREEITEM)(p) )
#define TreeView_GetEditControl( x ) \
    (HWND)SNDMSG( x, TVM_GETEDITCONTROL, 0, 0L )
#define TreeView_GetVisibleCount( x ) \
    (UINT)SNDMSG( x, TVM_GETVISIBLECOUNT, 0, 0L )
#define TreeView_HitTest( x, p ) \
    (HTREEITEM)SNDMSG( x, TVM_HITTEST, 0, (LPARAM)(LPTV_HITTESTINFO)(p) )
#define TreeView_CreateDragImage( x, p ) \
    (HIMAGELIST)SNDMSG( x, TVM_CREATEDRAGIMAGE, 0, (LPARAM)(HIMAGELIST)(p) )
#define TreeView_SortChildren( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TVM_SORTCHILDREN, (WPARAM)(p2), (LPARAM)(HTREEITEM)(p1) )
#define TreeView_EnsureVisible( x, p ) \
    (BOOL)SNDMSG( x, TVM_ENSUREVISIBLE, 0, (LPARAM)(HTREEITEM)(p) )
#define TreeView_SortChildrenCB( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TVM_SORTCHILDRENCB, (WPARAM)(p2), (LPARAM)(LPTV_SORTCB)(p2) )
#define TreeView_EndEditLabelNow( x, p ) \
    (BOOL)SNDMSG( x, TVM_ENDEDITLABELNOW, (WPARAM)(p), 0L )
#define TreeView_GetISearchString( x, p ) \
    (BOOL)SNDMSG( x, TVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)(p) )
#if (_WIN32_IE >= 0x0300)
    #define TreeView_SetToolTips( x, p ) \
        (HWND)SNDMSG( x, TVM_SETTOOLTIPS, (WPARAM)(p), 0L )
    #define TreeView_GetToolTips( x ) \
        (HWND)SNDMSG( x, TVM_GETTOOLTIPS, 0, 0L )
#endif
#if (_WIN32_IE >= 0x0400)
    #define TreeView_SetInsertMark( x, p1, p2 ) \
        (BOOL)SNDMSG( x, TVM_SETINSERTMARK, (WPARAM)(p2), (LPARAM)(p1) )
    #define TreeView_SetItemHeight( x, p ) \
        (int)SNDMSG( x, TVM_SETITEMHEIGHT, (WPARAM)(p), 0L )
    #define TreeView_GetItemHeight( x ) \
        (int)SNDMSG( x, TVM_GETITEMHEIGHT, 0, 0L )
    #define TreeView_SetBkColor( x, p ) \
        (COLORREF)SNDMSG( x, TVM_SETBKCOLOR, 0, (LPARAM)(p) )
    #define TreeView_SetTextColor( x, p ) \
        (COLORREF)SNDMSG( x, TVM_SETTEXTCOLOR, 0, (LPARAM)(p) )
    #define TreeView_GetBkColor( x ) \
        (COLORREF)SNDMSG( x, TVM_GETBKCOLOR, 0, 0L )
    #define TreeView_GetTextColor( x ) \
        (COLORREF)SNDMSG( x, TVM_GETTEXTCOLOR, 0, 0L )
    #define TreeView_SetScrollTime( x, p ) \
        (UINT)SNDMSG( x, TVM_SETSCROLLTIME, p, 0L )
    #define TreeView_GetScrollTime( x ) \
        (UINT)SNDMSG( x, TVM_GETSCROLLTIME, 0, 0L )
    #define TreeView_SetInsertMarkColor( x, p ) \
        (COLORREF)SNDMSG( x, TVM_SETINSERTMARKCOLOR, 0, (LPARAM)(p) )
    #define TreeView_GetInsertMarkColor( x ) \
        (COLORREF)SNDMSG( x, TVM_GETINSERTMARKCOLOR, 0, 0L )
#endif
#if (_WIN32_IE >= 0x0500)
    #define TreeView_SetItemState( x, p1, p2, p3 ) \
        { \
            TV_ITEM __item; \
            __item.mask = TVIF_STATE; \
            __item.hItem = p1; \
            __item.state = p2; \
            __item.stateMask = p3; \
            SNDMSG( x, TVM_SETITEM, 0, (LPARAM)(TV_ITEM *)&__item ); \
        }
    #define TreeView_SetCheckState( x, p1, p2 ) \
        TreeView_SetItemState( x, p1, INDEXTOSTATEIMAGEMASK( (p2) ? 2 : 1 ), \
        TVIS_STATEIMAGEMASK )
    #define TreeView_GetItemState( x, p1, p2 ) \
        (UINT)SNDMSG( x, TVM_GETITEMSTATE, (WPARAM)(p1), (LPARAM)(p2) )
    #define TreeView_GetCheckState( x, p ) \
        ((((UINT)(TreeView_GetItemState( x, p, TVIS_STATEIMAGEMASK ))) >> 12) - 1)
    #define TreeView_SetLineColor( x, p ) \
        (COLORREF)SNDMSG( x, TVM_SETLINECOLOR, 0, (LPARAM)(p) )
    #define TreeView_GetLineColor( x ) \
        (COLORREF)SNDMSG( x, TVM_GETLINECOLOR, 0, 0L )
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define TreeView_MapAccIDToHTREEITEM( x, p ) \
        (HTREEITEM)SNDMSG( x, TVM_MAPACCIDTOHTREEITEM, p, 0L )
    #define TreeView_MapHTREEITEMToAccID( x, p ) \
        (UINT)SNDMSG( x, TVM_MAPHTREEITEMTOACCID, (WPARAM)(p), 0L )
    #define TreeView_SetExtendedStyle( x, p1, p2 ) \
        (DWORD)SNDMSG( x, TVM_SETEXTENDEDSTYLE, p2, p1 )
    #define TreeView_GetExtendedStyle( x ) \
        (DWORD)SNDMSG( x, TVM_GETEXTENDEDSTYLE, 0, 0L )
    #define TreeView_SetAutoScrollInfo( x, p1, p2 ) \
        SNDMSG( x, TVM_SETAUTOSCROLLINFO, (WPARAM)(p1), (LPARAM)(p2) )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define TreeView_GetSelectedCount( x ) \
        (DWORD)SNDMSG( x, TVM_GETSELECTEDCOUNT, 0, 0L )
    #define TreeView_ShowInfoTip( x, p ) \
        (DWORD)SNDMSG( x, TVM_SHOWINFOTIP, 0, (LPARAM)(p) )
    #define TreeView_GetItemPartRect( x, p1, p2, p3 ) \
        { \
            TVGETITEMPARTRECTINFO __info; \
            __info.hti = p1; \
            __info.prc = p2; \
            __info.partID = p3; \
            SNDMSG( x, TVM_GETITEMPARTRECT, 0, (LPARAM)&__info ); \
        }
#endif
#if (_WIN32_IE >= 0x0400)
    #define TreeView_SetUnicodeFormat( x, p ) \
        (BOOL)SNDMSG( x, TVM_SETUNICODEFORMAT, (WPARAM)(p), 0L )
    #define TreeView_GetUnicodeFormat( x ) \
        (BOOL)SNDMSG( x, TVM_GETUNICODEFORMAT, 0, 0L )
#endif
#define TabCtrl_GetImageList( x ) \
    (HIMAGELIST)SNDMSG( x, TCM_GETIMAGELIST, 0, 0L )
#define TabCtrl_SetImageList( x, p ) \
    (HIMAGELIST)SNDMSG( x, TCM_SETIMAGELIST, 0, (LPARAM)(HIMAGELIST)(p) )
#define TabCtrl_GetItemCount( x ) \
    (int)SNDMSG( x, TCM_GETITEMCOUNT, 0, 0L )
#define TabCtrl_GetItem( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TCM_GETITEM, (WPARAM)(int)(p1), (LPARAM)(TC_ITEM *)(p2) )
#define TabCtrl_SetItem( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TCM_SETITEM, (WPARAM)(int)(p1), (LPARAM)(TC_ITEM *)(p2) )
#define TabCtrl_InsertItem( x, p1, p2 ) \
    (int)SNDMSG( x, TCM_INSERTITEM, (WPARAM)(p1), (LPARAM)(const TC_ITEM *)(p2) )
#define TabCtrl_DeleteItem( x, p ) \
    (BOOL)SNDMSG( x, TCM_DELETEITEM, (WPARAM)(int)(p), 0L )
#define TabCtrl_DeleteAllItems( x ) \
    (BOOL)SNDMSG( x, TCM_DELETEALLITEMS, 0, 0L )
#define TabCtrl_GetItemRect( x, p1, p2 ) \
    (BOOL)SNDMSG( x, TCM_GETITEMRECT, (WPARAM)(int)(p1), (LPARAM)(RECT *)(p2) )
#define TabCtrl_GetCurSel( x ) \
    (int)SNDMSG( x, TCM_GETCURSEL, 0, 0L )
#define TabCtrl_SetCurSel( x, p ) \
    (int)SNDMSG( x, TCM_SETCURSEL, (WPARAM)(p), 0L )
#define TabCtrl_HitTest( x, p ) \
    (int)SNDMSG( x, TCM_HITTEST, 0, (LPARAM)(TC_HITTESTINFO *)(p) )
#define TabCtrl_SetItemExtra( x, p ) \
    (BOOL)SNDMSG( x, TCM_SETITEMEXTRA, (WPARAM)(p), 0L )
#define TabCtrl_AdjustRect( x, p1, p2 ) \
    (int)SNDMSG( x, TCM_ADJUSTRECT, (WPARAM)(BOOL)(p1), (LPARAM)(RECT *)(p2) )
#define TabCtrl_SetItemSize( x, p1, p2 ) \
    (DWORD)SNDMSG( x, TCM_SETITEMSIZE, 0, MAKELPARAM( p1, p2 ) )
#define TabCtrl_RemoveImage( x, p ) \
    (void)SNDMSG( x, TCM_REMOVEIMAGE, p, 0L )
#define TabCtrl_SetPadding( x, p1, p2 ) \
    (void)SNDMSG( x, TCM_SETPADDING, 0, MAKELPARAM( p1, p2 ) )
#define TabCtrl_GetRowCount( x ) \
    (int)SNDMSG( x, TCM_GETROWCOUNT, 0, 0L )
#define TabCtrl_GetToolTips( x ) \
    (HWND)SNDMSG( x, TCM_GETTOOLTIPS, 0, 0L )
#define TabCtrl_SetToolTips( x, p ) \
    (void)SNDMSG( x, TCM_SETTOOLTIPS, (WPARAM)(p), 0L )
#define TabCtrl_GetCurFocus( x ) \
    (int)SNDMSG( x, TCM_GETCURFOCUS, 0, 0L )
#define TabCtrl_SetCurFocus( x, p ) \
    SNDMSG( x, TCM_SETCURFOCUS, p, 0L )
#if (_WIN32_IE >= 0x0300)
    #define TabCtrl_SetMinTabWidth( x, p ) \
        (int)SNDMSG( x, TCM_SETMINTABWIDTH, 0, p )
    #define TabCtrl_DeselectAll( x, p ) \
        (void)SNDMSG( x, TCM_DESELECTALL, p, 0L )
#endif
#if (_WIN32_IE >= 0x0400)
    #define TabCtrl_HighlightItem( x, p1, p2 ) \
        (BOOL)SNDMSG( x, TCM_HIGHLIGHTITEM, (WPARAM)(p1), (LPARAM)MAKELONG( p2, 0 ) )
    #define TabCtrl_SetExtendedStyle( x, p ) \
        (DWORD)SNDMSG( x, TCM_SETEXTENDEDSTYLE, 0, p )
    #define TabCtrl_GetExtendedStyle( x ) \
        (DWORD)SNDMSG( x, TCM_GETEXTENDEDSTYLE, 0, 0L )
    #define TabCtrl_SetUnicodeFormat( x, p ) \
        (BOOL)SNDMSG( x, TCM_SETUNICODEFORMAT, (WPARAM)(p), 0L )
    #define TabCtrl_GetUnicodeFormat( x ) \
        (BOOL)SNDMSG( x, TCM_GETUNICODEFORMAT, 0, 0L )
#endif
#define Animate_Create( p1, p2, p3, p4 ) \
    CreateWindow( ANIMATE_CLASS, NULL, p3, 0L, 0L, 0L, 0L, p1, (HMENU)(p2), p4, NULL )
#define Animate_Open( x, p ) \
    (BOOL)SNDMSG( x, ACM_OPEN, 0, (LPARAM)(LPTSTR)(p) )
#define Animate_OpenEx( x, p1, p2 ) \
    (BOOL)SNDMSG( x, ACM_OPEN, (WPARAM)(p1), (LPARAM)(LPTSTR)(p) )
#define Animate_Play( x, p1, p2, p3 ) \
    (BOOL)SNDMSG( x, ACM_PLAY, (WPARAM)(p3), (LPARAM)MAKELONG( p1, p2 ) )
#define Animate_Stop( x ) \
    (BOOL)SNDMSG( x, ACM_STOP, 0, 0L )
#define Animate_IsPlaying( x ) \
    (BOOL)SNDMSG( x, ACM_ISPLAYING, 0, 0L )
#define Animate_Close( x )      Animate_Open( x, NULL )
#define Animate_Seek( x, p )    Animate_Play( x, p, p, 1 )
#if (_WIN32_IE >= 0x0300)
    #define MonthCal_GetCurSel( x, p ) \
        (BOOL)SNDMSG( x, MCM_GETCURSEL, 0, (LPARAM)(p) )
    #define MonthCal_SetCurSel( x, p ) \
        (BOOL)SNDMSG( x, MCM_SETCURSEL, 0, (LPARAM)(p) )
    #define MonthCal_GetMaxSelCount( x ) \
        (DWORD)SNDMSG( x, MCM_GETMAXSELCOUNT, 0, 0L )
    #define MonthCal_SetMaxSelCount( x, p ) \
        (BOOL)SNDMSG( x, MCM_SETMAXSELCOUNT, (WPARAM)(p), 0L )
    #define MonthCal_GetSelRange( x, p ) \
        SNDMSG( x, MCM_GETSELRANGE, 0, (LPARAM)(p) )
    #define MonthCal_SetSelRange( x, p ) \
        SNDMSG( x, MCM_SETSELRANGE, 0, (LPARAM)(p) )
    #define MonthCal_GetMonthRange( x, p1, p2 ) \
        (DWORD)SNDMSG( x, MCM_GETMONTHRANGE, (WPARAM)(p1), (LPARAM)(p2) )
    #define MonthCal_SetDayState( x, p1, p2 ) \
        SNDMSG( x, MCM_SETDAYSTATE, (WPARAM)(p1), (LPARAM)(p2) )
    #define MonthCal_GetMinReqRect( x, p ) \
        SNDMSG( x, MCM_GETMINREQRECT, 0, (LPARAM)(p) )
    #define MonthCal_SetColor( x, p1, p2 ) \
        SNDMSG( x, MCM_SETCOLOR, p1, p2 )
    #define MonthCal_GetColor( x, p ) \
        SNDMSG( x, MCM_GETCOLOR, p, 0L )
    #define MonthCal_SetToday( x, p ) \
        SNDMSG( x, MCM_SETTODAY, 0, (LPARAM)(p) )
    #define MonthCal_GetToday( x, p ) \
        (BOOL)SNDMSG( x, MCM_GETTODAY, 0, (LPARAM)(p) )
    #define MonthCal_HitTest( x, p ) \
        SNDMSG( x, MCM_HITTEST, 0, (LPARAM)(PMCHITTESTINFO)(p) )
    #define MonthCal_SetFirstDayOfWeek( x, p ) \
        SNDMSG( x, MCM_SETFIRSTDAYOFWEEK, 0, p )
    #define MonthCal_GetFirstDayOfWeek( x ) \
        (DWORD)SNDMSG( x, MCM_GETFIRSTDAYOFWEEK, 0, 0L )
    #define MonthCal_GetRange( x, p ) \
        (DWORD)SNDMSG( x, MCM_GETRANGE, 0, (LPARAM)(p) )
    #define MonthCal_SetRange( x, p1, p2 ) \
        (BOOL)SNDMSG( x, MCM_SETRANGE, (WPARAM)(p1), (LPARAM)(p2) )
    #define MonthCal_GetMonthDelta( x ) \
        (int)SNDMSG( x, MCM_GETMONTHDELTA, 0, 0L )
    #define MonthCal_SetMonthDelta( x, p ) \
        (int)SNDMSG( x, MCM_SETMONTHDELTA, p, 0L )
    #define MonthCal_GetMaxTodayWidth( x ) \
        (DWORD)SNDMSG( x, MCM_GETMAXTODAYWIDTH, 0, 0L )
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define MonthCal_GetCurrentView( x ) \
        (DWORD)SNDMSG( x, MCM_GETCURRENTVIEW, 0, 0L )
    #define MonthCal_GetCalendarCount( x ) \
        (DWORD)SNDMSG( x, MCM_GETCALENDARCOUNT, 0, 0L )
    #define MonthCal_GetCalendarGridInfo( x, p ) \
        (BOOL)SNDMSG( x, MCM_GETCALENDARGRIDINFO, 0, (LPARAM)(PMCGRIDINFO)(p) )
    #define MonthCal_GetCALID( x ) \
        (CALID)SNDMSG( x, MCM_GETCALID, 0, 0L )
    #define MonthCal_SetCALID( x, p ) \
        SNDMSG( x, MCM_SETCALID, (WPARAM)(p), 0L )
    #define MonthCal_SizeRectToMin( x, p ) \
        SNDMSG( x, MCM_SIZERECTTOMIN, 0, (LPARAM)(p) )
    #define MonthCal_SetCalendarBorder( x, p1, p2 ) \
        SNDMSG( x, MCM_SETCALENDARBORDER, (WPARAM)(p1), (LPARAM)(p2) )
    #define MonthCal_GetCalendarBorder( x ) \
        (int)SNDMSG( x, MCM_GETCALENDARBORDER, 0, 0L )
    #define MonthCal_SetCurrentView( x, p ) \
        (BOOL)SNDMSG( x, MCM_SETCURRENTVIEW, 0, (LPARAM)(p) )
#endif
#if (_WIN32_IE >= 0x0400)
    #define MonthCal_SetUnicodeFormat( x, p ) \
        (BOOL)SNDMSG( x, MCM_SETUNICODEFORMAT, (WPARAM)(p), 0L )
    #define MonthCal_GetUnicodeFormat( x ) \
        (BOOL)SNDMSG( x, MCM_GETUNICODEFORMAT, 0, 0L )
#endif
#if (_WIN32_IE >= 0x0300)
    #define DateTime_GetSystemTime( x, p ) \
        (DWORD)SNDMSG( x, DTM_GETSYSTEMTIME, 0, (LPARAM)(p) )
    #define DateTime_SetSystemTime( x, p1, p2 ) \
        (BOOL)SNDMSG( x, DTM_SETSYSTEMTIME, (WPARAM)(p1), (LPARAM)(p2) )
    #define DateTime_GetRange( x, p ) \
        (DWORD)SNDMSG( x, DTM_GETRANGE, 0, (LPARAM)(p) )
    #define DateTime_SetRange( x, p1, p2 ) \
        (BOOL)SNDMSG( x, DTM_SETRANGE, (WPARAM)(p1), (LPARAM)(p2) )
    #define DateTime_SetFormat( x, p ) \
        (BOOL)SNDMSG( x, DTM_SETFORMAT, 0, (LPARAM)(p) )
    #define DateTime_SetMonthCalColor( x, p1, p2 ) \
        SNDMSG( x, DTM_SETMCCOLOR, p1, p2 )
    #define DateTime_GetMonthCalColor( x, p ) \
        SNDMSG( x, DTM_GETMCCOLOR, p, 0L )
    #define DateTime_GetMonthCal( x ) \
        (HWND)SNDMSG( x, DTM_GETMONTHCAL, 0, 0L )
#endif
#if (_WIN32_IE >= 0x0400)
    #define DateTime_SetMonthCalFont( x, p1, p2 ) \
        SNDMSG( x, DTM_SETMCFONT, (WPARAM)(p1), (LPARAM)(p2) )
    #define DateTime_GetMonthCalFont( x ) \
        SNDMSG( x, DTM_GETMCFONT, 0, 0L )
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define DateTime_SetMonthCalStyle( x, p ) \
        SNDMSG( x, DTM_SETMCSTYLE, 0, (LPARAM)(p) )
    #define DateTime_GetMonthCalStyle( x ) \
        SNDMSG( x, DTM_GETMCSTYLE, 0, 0L )
    #define DateTime_CloseMonthCal( x ) \
        SNDMSG( x, DTM_CLOSEMONTHCAL, 0, 0L )
    #define DateTime_GetDateTimePickerInfo( x, p ) \
        SNDMSG( x, DTM_GETDATETIMEPICKERINFO, 0, (LPARAM)(p) )
    #define DateTime_GetIdealSize( x, p ) \
        (BOOL)SNDMSG( x, DTM_GETIDEALSIZE, 0, (LPARAM)(p) )
#endif
#if (_WIN32_IE >= 0x0400)
    #define Pager_SetChild( x, p ) \
        (void)SNDMSG( x, PGM_SETCHILD, 0, (LPARAM)(p) )
    #define Pager_RecalcSize( x ) \
        (void)SNDMSG( x, PGM_RECALCSIZE, 0, 0L )
    #define Pager_ForwardMouse( x, p ) \
        (void)SNDMSG( x, PGM_FORWARDMOUSE, (WPARAM)(p), 0L )
    #define Pager_SetBkColor( x, p ) \
        (COLORREF)SNDMSG( x, PGM_SETBKCOLOR, 0, (LPARAM)(p) )
    #define Pager_GetBkColor( x ) \
        (COLORREF)SNDMSG( x, PGM_GETBKCOLOR, 0, 0L )
    #define Pager_SetBorder( x, p ) \
        (int)SNDMSG( x, PGM_SETBORDER, 0, (LPARAM)(p) )
    #define Pager_GetBorder( x ) \
        (int)SNDMSG( x, PGM_GETBORDER, 0, 0L )
    #define Pager_SetPos( x, p ) \
        (int)SNDMSG( x, PGM_SETPOS, 0, (LPARAM)(p) )
    #define Pager_GetPos( x ) \
        (int)SNDMSG( x, PGM_GETPOS, 0, 0L )
    #define Pager_SetButtonSize( x, p ) \
        (int)SNDMSG( x, PGM_SETBUTTONSIZE, 0, (LPARAM)(p) )
    #define Pager_GetButtonSize( x ) \
        (int)SNDMSG( x, PGM_GETBUTTONSIZE, 0, 0L )
    #define Pager_GetButtonState( x, p ) \
        (DWORD)SNDMSG( x, PGM_GETBUTTONSTATE, 0, (LPARAM)(p) )
    #define Pager_GetDropTarget( x, p ) \
        (void)SNDMSG( x, PGM_GETDROPTARGET, 0, (LPARAM)(p) )
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define Button_GetIdealSize( x, p ) \
        (BOOL)SNDMSG( x, BCM_GETIDEALSIZE, 0, (LPARAM)(p) )
    #define Button_SetImageList( x, p ) \
        (BOOL)SNDMSG( x, BCM_SETIMAGELIST, 0, (LPARAM)(p) )
    #define Button_GetImageList( x, p ) \
        (BOOL)SNDMSG( x, BCM_GETIMAGELIST, 0, (LPARAM)(p) )
    #define Button_SetTextMargin( x, p ) \
        (BOOL)SNDMSG( x, BCM_SETTEXTMARGIN, 0, (LPARAM)(p) )
    #define Button_GetTextMargin( x, p ) \
        (BOOL)SNDMSG( x, BCM_GETTEXTMARGIN, 0, (LPARAM)(p) )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define Button_SetDropDownState( x, p ) \
        (BOOL)SNDMSG( x, BCM_SETDROPDOWNSTATE, (WPARAM)(p), 0L )
    #define Button_SetSplitInfo( x, p ) \
        (BOOL)SNDMSG( x, BCM_SETSPLITINFO, 0, (LPARAM)(p) )
    #define Button_GetSplitInfo( x, p ) \
        (BOOL)SNDMSG( x, BCM_GETSPLITINFO, 0, (LPARAM)(p) )
    #define Button_SetNote( x, p ) \
        (BOOL)SNDMSG( x, BCM_SETNOTE, 0, (LPARAM)(p) )
    #define Button_GetNote( x, p1, p2 ) \
        (BOOL)SNDMSG( x, BCM_GETNOTE, (WPARAM)(p2), (LPARAM)(p1) )
    #define Button_GetNoteLength( x ) \
        (LRESULT)SNDMSG( x, BCM_GETNOTELENGTH, 0, 0L )
    #define Button_SetElevationRequiredState( x, p ) \
        (LRESULT)SNDMSG( x, BCM_SETSHIELD, 0, (LPARAM)(p) )
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define Edit_SetCueBannerText( x, p ) \
        (BOOL)SNDMSG( x, EM_SETCUEBANNER, 0, (LPARAM)(p) )
    #define Edit_SetCueBannerTextFocused( x, p1, p2 ) \
        (BOOL)SNDMSG( x, EM_SETCUEBANNER, (WPARAM)(p2), (LPARAM)(p1) )
    #define Edit_GetCueBannerText( x, p1, p2 ) \
        (BOOL)SNDMSG( x, EM_GETCUEBANNER, (WPARAM)(p1), (LPARAM)(p2) )
    #define Edit_ShowBalloonTip( x, p ) \
        (BOOL)SNDMSG( x, EM_SHOWBALLOONTIP, 0, (LPARAM)(p) )
    #define Edit_HideBalloonTip( x ) \
        (BOOL)SNDMSG( x, EM_HIDEBALLOONTIP, 0, 0L )
#endif
#if (_WIN32_WINNT >= 0x0600)
    #define Edit_SetHilite( x, p1, p2 ) \
        (void)SNDMSG( x, EM_SETHILITE, p1, p2 )
    #define Edit_GetHilite( x ) \
        (DWORD)SNDMSG( x, EM_GETHILITE, 0, 0L )
#endif
#if (_WIN32_WINNT >= 0x0501)
    #define ComboBox_SetMinVisible( x, p ) \
        (BOOL)SNDMSG( x, CB_SETMINVISIBLE, (WPARAM)(p), 0L )
    #define ComboBox_GetMinVisible( x ) \
        (int)SNDMSG( x, CB_GETMINVISIBLE, 0, 0L )
    #define ComboBox_SetCueBannerText( x, p ) \
        (BOOL)SNDMSG( x, CB_SETCUEBANNER, 0, (LPARAM)(p) )
    #define ComboBox_GetCueBannerText( x, p1, p2 ) \
        (BOOL)SNDMSG( x, CB_GETCUEBANNER, (WPARAM)(p1), (LPARAM)(p2) )
#endif
#if (_WIN32_IE >= 0x0300)
    #define DSA_AppendItem( x, p )      DSA_InsertItem( x, DA_LAST, p )
    #define DSA_GetItemCount( x )       (*(int *)(x))
    #define DPA_GetPtrCount( x )        (*(int *)(x))
    #define DPA_SetPtrCount( x, p )     (*(int *)(x) = (p))
    #define DPA_FastDeleteLastPtr( x )  (--*(int *)(x))
    #define DPA_GetPtrPtr( x )          (*((void ***)((BYTE *)(x) + sizeof( void * ))))
    #define DPA_FastGetPtr( x, p )      (DPA_GetPtrPtr( x )[p])
    #define DPA_AppendPtr( x, p )       DPA_InsertPtr( x, DA_LAST, p )
    #define DPA_SortedInsertPtr( x, p1, p2, p3, p4, p5, p6 ) \
        DPA_InsertPtr( x, DPA_Search( x, p1, p2, p3, p4, (DPAS_SORTED | (p5)) ), p6 )
#endif

/* Aliases */
#if (_WIN32_IE >= 0x0400)
    #define FlatSB_GetScrollPropPtr FlatSB_GetScrollProp
    #define FlatSB_SetScrollPropPtr FlatSB_SetScrollProp
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define CreateStatusWindow  CreateStatusWindowW
    #define DrawStatusText      DrawStatusTextW
    #define ImageList_LoadImage ImageList_LoadImageW
#else
    #define CreateStatusWindow  CreateStatusWindowA
    #define DrawStatusText      DrawStatusTextA
    #define ImageList_LoadImage ImageList_LoadImageA
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_COMMCTRL */
