/*
 *  unistd.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2002-2014 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _UNISTD_H_INCLUDED
#define _UNISTD_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SYS_TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NULL
 #ifdef __cplusplus
   #define NULL 0
 #else
  #define NULL ((void *)0)
 #endif
#endif

/* Symbolic constants for the access() function */

#define R_OK    4       /*  Test for read permission    */
#define W_OK    2       /*  Test for write permission   */
#define X_OK    1       /*  Test for execute permission */
#define F_OK    0       /*  Test for existence of file  */

/* Symbolic constants for the lseek() function */

#ifndef _SEEKPOS_DEFINED_       /* If not already defined, define them  */
#define SEEK_SET    0           /* Seek relative to the start of file   */
#define SEEK_CUR    1           /* Seek relative to current position    */
#define SEEK_END    2           /* Seek relative to the end of the file */
#define _SEEKPOS_DEFINED_
#endif

/* Symbolic constants for stream I/O */

#define STDIN_FILENO    0
#define STDOUT_FILENO   1
#define STDERR_FILENO   2

/* Compile-time Symbolic Constants for Portability Specifications */

#undef  _POSIX_JOB_CONTROL              /* no job control                   */
#define _POSIX_SAVED_IDS    1           /* no saved-set user-ID & group-ID  */
#define _POSIX_VERSION      198808L     /* YYYYmm of POSIX std approval     */
#define _POSIX_PROCESS_SCHEDULING   1
#define _POSIX_TIMERS   1

/* Symbolic constants for sysconf */
/* caution: the module sysconf.c bound checks _SC_ARG_MAX ... _SC_PAGESIZE */
#define _SC_ARG_MAX          1
#define _SC_CHILD_MAX        2
#define _SC_CLK_TCK          3
#define _SC_NGROUPS_MAX      4
#define _SC_OPEN_MAX         5
#define _SC_JOB_CONTROL      6
#define _SC_SAVED_IDS        7
#define _SC_VERSION          8
#define _SC_STREAM_MAX       9
#define _SC_TZNAME_MAX       10
#define _SC_PAGESIZE         11
#define _SC_NPROCESSORS_CONF 12
#define _SC_NPROCESSORS_ONLN 13
#define _SC_PHYS_PAGES       14
#define _SC_AVPHYS_PAGES     15
#define _SC_REALTIME_SIGNALS 16
/* Execution-time Symbolic Constants for Portability Specifications */

#define _POSIX_CHOWN_RESTRICTED 0       /* restricted use of chown() */
#define _POSIX_NO_TRUNC         0       /* pathname components > NAME_MAX */
#define _POSIX_VDISABLE         0x00    /* terminal special chars can be disabled */

/* Symbolic constants for pathconf, fpathconf */

#define _PC_LINK_MAX            1
#define _PC_MAX_CANON           2
#define _PC_MAX_INPUT           3
#define _PC_NAME_MAX            4
#define _PC_PATH_MAX            5
#define _PC_PIPE_BUF            6
#define _PC_CHOWN_RESTRICTED    7
#define _PC_NO_TRUNC            8
#define _PC_VDISABLE            9
#define _PC_DOS_SHARE           10  /* test for dos share support   */
#define _PC_DOS_LOCKS           11  /* test for dos locking support */

/* Symbolic constants for confstr */

#define _CS_PATH            1

/*
 *  POSIX 1003.1 Prototypes
 */

#if defined(_POSIX_SOURCE) || defined(_LINUX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern void   _exit( int __status );
#endif /* extensions enabled */

_WCRTLINK extern int    access( const char *__path, int __mode );
_WCRTLINK extern int    brk(void *endds);
_WCRTLINK extern void   _WCNEAR *sbrk(int incr);
_WCRTLINK extern pid_t  clone( int __flags, void *__child_stack );
_WCRTLINK extern int    close( int __fildes );
_WCRTLINK extern int    dup( int __fildes );
#if defined(_LINUX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern long   _get_osfhandle( int __posixhandle );
_WCRTLINK extern int    _hdopen(int __handle,int __mode);
_WCRTLINK extern int    _open_osfhandle( long __osfhandle, int __flags );
_WCRTLINK extern int    _os_handle(int __handle);
#endif /* extensions enabled */
_WCRTLINK extern int    isatty( int __fildes );
_WCRTLINK extern off_t  lseek( int __fildes, off_t __offset, int __whence );
_WCRTLINK extern ssize_t read( int __fildes, void *__buffer, size_t __len );
#if !(defined(SYSV) || defined(BSD) || defined(XENIX) || defined(_UNIX_H_INCLUDED))
_WCRTLINK extern int    setmode( int __handle, int __mode );
#endif
_WCRTLINK extern int    unlink( const char *__path );
_WCRTLINK extern ssize_t write( int __fildes, const void *__buf, size_t __len );
_WCRTLINK extern unsigned alarm( unsigned int __seconds );
_WCRTLINK extern int    chown( const char *__path, uid_t __owner, gid_t __group );
_WCRTLINK extern int    lchown( const char *__path, uid_t __owner, gid_t __group );
_WCRTLINK extern int    chroot(const char *__path);
_WCRTLINK extern int    dup2( int __fildes, int __fildes2 );
_WCRTLINK extern int    fchown( int __fildes, uid_t __owner, gid_t __group );
_WCRTLINK extern int    fdatasync( int __fildes );
_WCRTLINK extern pid_t  fork( void );
#if defined( __386__ )
_WCRTLINK extern pid_t  vfork( void );
#pragma aux vfork modify [edx];
#endif
_WCRTLINK extern long   fpathconf( int __fildes, int __name );
_WCRTLINK extern int    fsync( int __filedes );
_WCRTLINK extern gid_t  getegid( void );
_WCRTLINK extern uid_t  geteuid( void );
_WCRTLINK extern gid_t  getgid( void );
_WCRTLINK extern int    getgroups( int __gidsetsize, gid_t __grouplist[] );
_WCRTLINK extern int    gethostname( char *__name, size_t __len );
_WCRTLINK extern char   *getlogin( void );
_WCRTLINK extern pid_t  getpgrp( void );
_WCRTLINK extern pid_t  getppid( void );
_WCRTLINK extern pid_t  getsid(pid_t __pid);
_WCRTLINK extern uid_t  getuid( void );
_WCRTLINK extern int    link( const char *__path1, const char *__path2 );
_WCRTLINK extern long   pathconf( const char *__path, int __name );
_WCRTLINK extern int    pause( void );
_WCRTLINK extern int    pipe( int __fildes[2] );
_WCRTLINK extern int    readlink( const char *__path, char *__buf, size_t __bufsiz );
_WCRTLINK extern int    setegid( gid_t __newegroup );
_WCRTLINK extern int    seteuid( uid_t __newuserid );
_WCRTLINK extern int    setgid( gid_t __newgroup );
_WCRTLINK extern int    setpgid( pid_t __pid, pid_t __pgroupid );
_WCRTLINK extern int    setregid(gid_t real, uid_t effective);
_WCRTLINK extern int    setreuid(uid_t real, uid_t effective);
_WCRTLINK extern pid_t  setsid( void );
_WCRTLINK extern int    setuid( uid_t __newuserid );
_WCRTLINK extern int    symlink( const char *__pname, const char *__slink );
_WCRTLINK extern void   sync( void );
_WCRTLINK extern long   sysconf( int __name );
_WCRTLINK extern pid_t  tcgetpgrp( int __fildes );
_WCRTLINK extern int    tcsetpgrp( int __fildes, pid_t __pgrp_id );
_WCRTLINK extern char   *ttyname( int __fildes );
_WCRTLINK extern int    ttyname_r( int __fildes, char *__buf, size_t __buflen );
_WCRTLINK extern int    truncate( const char *__path, off_t __length );
_WCRTLINK extern int    ftruncate( int __fd, off_t __length );


#if defined(_LINUX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern long long _filelengthi64( int __fildes );
_WCRTLINK extern long long _lseeki64( int __fildes, long long __offset, int __whence );
_WCRTLINK extern long long _telli64( int __fildes );

_WCRTLINK extern int    chsize( int __fildes, long __size );
_WCRTLINK extern int    eof( int __fildes );
_WCRTLINK extern long   filelength( int __fildes );
_WCRTLINK extern off_t  tell( int __fildes );
#endif /* extensions enabled */

_WCRTLINK extern size_t confstr( int, char*, size_t );
#if defined(_POSIX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern char   *basename( char *__fname );
_WCRTLINK extern off_t  ltrunc( int __fildes, off_t __offset, int __origin );
#endif /* extensions enabled */

/* These are Linux specific */

_WCRTLINK extern int    ioperm( unsigned long __from, unsigned long __num, int __turn_on );
_WCRTLINK extern int    iopl( int __level );
_WCRTLINK extern int    nice( int __val );
_WCRTLINK extern int    _llseek( unsigned int __fildes, unsigned long __hi, unsigned long __lo, loff_t *__res, unsigned int __whence);

_WCRTLINK extern int    chdir( const char *__path );
/* the following are also in process.h, but they are expected to be here */
_WCRTLINK extern int    execl( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    execle( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    execlp( const char *__file, const char *__arg0, ... );
_WCRTLINK extern int    execv( const char *__path, const char *const __argv[] );
_WCRTLINK extern int    execve( const char *__path, const char *const __argv[], const char *const __envp[] );
_WCRTLINK extern int    execvp( const char *__file, const char *const __argv[] );

_WCRTLINK extern char   *getcwd( char *__buf, size_t __size );
_WCRTLINK extern char   *_getcwd( char *__buf, size_t __size );
_WCRTLINK extern int    getopt( int __argc, char * const __argv[], const char *__optstring );
_WCRTLINK extern pid_t  getpid( void );
_WCRTLINK extern int    rmdir( const char *__path );
_WCRTLINK extern unsigned int sleep( unsigned int __seconds );
_WCRTLINK extern int    usleep( unsigned long __usec );

/* Globals used and set by getopt() */
_WCRTDATA extern char   *optarg;
_WCRTDATA extern int    optind;
_WCRTDATA extern int    opterr;
_WCRTDATA extern int    optopt;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
