/*
 *  sched.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SCHED_H_INCLUDED
#define _SCHED_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <time.h>
#include <sys/types.h>

struct sched_param {
    int sched_priority;
};

/* Scheduling policies per the Linux kernel */
#define SCHED_NORMAL            0
#define SCHED_FIFO              1
#define SCHED_RR                2
#define SCHED_BATCH             3
#define SCHED_IDLE              5
#define SCHED_DEADLINE	        6

/* For GNU compatibility, define SCHED_OTHER to be
 * simply SCHED_NORMAL
 */
#define SCHED_OTHER     SCHED_NORMAL

_WCRTLINK extern int    sched_yield( void );

_WCRTLINK extern int    sched_get_priority_max( int __policy );
_WCRTLINK extern int    sched_get_priority_min( int __policy );

_WCRTLINK extern int    sched_getscheduler( pid_t __pid );
_WCRTLINK extern int    sched_setscheduler( pid_t __pid, int __policy, 
                                            const struct sched_param *__sp );

_WCRTLINK extern int    sched_getparam( pid_t __pid, 
                                        struct sched_param *__sp );
_WCRTLINK extern int    sched_setparam( pid_t __pid, 
                                        const struct sched_param *__sp );

_WCRTLINK extern int    sched_rr_get_interval( pid_t __pid, 
                                               struct timespec *__ts);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
