/*
 *  process.h   Process spawning and related routines
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2002-2014 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _PROCESS_H_INCLUDED
#define _PROCESS_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _SYS_TYPES_H_INCLUDED
 #include <sys/types.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __cplusplus
 #ifndef _WCHAR_T_DEFINED
 #define _WCHAR_T_DEFINED
  #define _WCHAR_T_DEFINED_
  typedef unsigned short wchar_t;
 #endif
#endif

/*
 *  POSIX 1003.1 Prototypes
 */
_WCRTLINK extern int    execl( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    execle( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    execlp( const char *__file, const char *__arg0, ... );
_WCRTLINK extern int    execv( const char *__path, const char *const __argv[] );
_WCRTLINK extern int    execve( const char *__path, const char *const __argv[], const char *const __envp[] );
_WCRTLINK extern int    execvp( const char *__file, const char *const __argv[] );

#if defined(_LINUX_SOURCE) || !defined(NO_EXT_KEYS) /* extensions enabled */
_WCRTLINK extern int    _execl( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _execle( const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _execlp( const char *__file, const char *__arg0, ... );
_WCRTLINK extern int    _execv( const char *__path, const char *const __argv[] );
_WCRTLINK extern int    _execve( const char *__path, const char *const __argv[], const char *const __envp[] );
_WCRTLINK extern int    _execvp( const char *__file, const char *const __argv[] );

/* mode flags for spawnxxx routines */
_WCRTDATA extern int __p_overlay;

#define P_WAIT      0
#define _P_WAIT     0
#define P_NOWAIT    1
#define _P_NOWAIT   1
#define P_OVERLAY   __p_overlay
#define _P_OVERLAY  __p_overlay
#define P_NOWAITO   3
#define _P_NOWAITO  3

#if defined(__NT__)
#define P_DETACH    4
#define _P_DETACH   4
#endif

#define _OLD_P_OVERLAY  _P_OVERLAY

/*
 *  Prototypes for non-POSIX functions
 */

_WCRTLINK extern int    execlpe( const char *__file, const char *__arg0, ... );
_WCRTLINK extern int    execvpe( const char *__file, const char *const __argv[], const char *const __envp[] );

_WCRTLINK extern int    _execlpe( const char *__file, const char *__arg0, ... );
_WCRTLINK extern int    _execvpe( const char *__file, const char *const __argv[], const char *const __envp[] );

#if defined(__386__)
 _WCRTLINK extern int   _beginthread( void (*__start_address)(void *),
     void *__stack_bottom, unsigned __stack_size, void *__arglist );
 #pragma intrinsic(_beginthread);
 _WCRTLINK extern void  _endthread( void );
#endif

#ifdef __cplusplus
namespace std {
#endif
_WCRTLINK extern void   abort( void );
_WCRTLINK extern void   exit( int __status );
_WCRTLINK extern char   *getenv( const char *__name );
_WCRTLINK extern int    system( const char *__cmd );
#ifdef __cplusplus
}
using std::abort;
using std::exit;
using std::getenv;
using std::system;
#endif

_WCRTLINK extern void   _exit( int __status );

#if !(defined(SYSV) || defined(BSD) || defined(XENIX) || defined(_UNIX_H_INCLUDED))
_WCRTLINK extern char   *getcmd( char *__buffer );
_WCRTLINK extern int    _bgetcmd( char *__buffer, int __len );
_WCRTLINK extern char   *_cmdname( char *__name );
#endif
_WCRTLINK extern int    putenv( const char *__string );
_WCRTLINK extern int    spawnl( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    spawnle( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    spawnlp( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    spawnlpe( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    spawnv( int __mode, const char *__path, const char * const *__argv );
_WCRTLINK extern int    spawnve( int __mode, const char *__path, const char * const *__argv, const char * const *__envp );
_WCRTLINK extern int    spawnvp( int __mode, const char *__path, const char * const *__argv );
_WCRTLINK extern int    spawnvpe( int __mode, const char *__path, const char * const *__argv, const char * const *__envp );

_WCRTLINK extern int    _spawnl( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _spawnle( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _spawnlp( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _spawnlpe( int __mode, const char *__path, const char *__arg0, ... );
_WCRTLINK extern int    _spawnv( int __mode, const char *__path, const char * const *__argv );
_WCRTLINK extern int    _spawnve( int __mode, const char *__path, const char * const *__argv, const char * const *__envp );
_WCRTLINK extern int    _spawnvp( int __mode, const char *__path, const char * const *__argv );
_WCRTLINK extern int    _spawnvpe( int __mode, const char *__path, const char * const *__argv, const char * const *__envp );

_WCRTLINK extern wchar_t *_wgetenv( const wchar_t *__name );
_WCRTLINK extern int    _wsetenv( const wchar_t *__name, const wchar_t *__newvalue, int __overwrite );
_WCRTLINK extern int    _wputenv( const wchar_t *__env_string );

_WCRTLINK extern int    _wexecl( const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wexecle( const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wexeclp( const wchar_t *__file, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wexecv( const wchar_t *__path, const wchar_t *const __argv[] );
_WCRTLINK extern int    _wexecve( const wchar_t *__path, const wchar_t *const __argv[], const wchar_t *const __envp[] );
_WCRTLINK extern int    _wexecvp( const wchar_t *__file, const wchar_t *const __argv[] );
_WCRTLINK extern int    _wexeclpe( const wchar_t *__file, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wexecvpe( const wchar_t *__file, const wchar_t *const __argv[], const wchar_t *const __envp[] );
_WCRTLINK extern int    _wspawnl( int __mode, const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wspawnle( int __mode, const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wspawnlp( int __mode, const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wspawnlpe( int __mode, const wchar_t *__path, const wchar_t *__arg0, ... );
_WCRTLINK extern int    _wspawnv( int __mode, const wchar_t *__path, const wchar_t * const *__argv );
_WCRTLINK extern int    _wspawnve( int __mode, const wchar_t *__path, const wchar_t * const *__argv, const wchar_t * const *__envp );
_WCRTLINK extern int    _wspawnvp( int __mode, const wchar_t *__path, const wchar_t * const *__argv );
_WCRTLINK extern int    _wspawnvpe( int __mode, const wchar_t *__path, const wchar_t * const *__argv, const wchar_t * const *__envp );
_WCRTLINK extern int    _wsystem( const wchar_t *__cmd );

_WCRTLINK extern pid_t  getpid( void );
_WCRTLINK extern pid_t  _getpid( void );
_WCRTLINK extern pid_t  wait( int *__status );

#endif /* extensions enabled */

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
