/*
 *  winsmcrd.h  Win32 smart card device I/O control codes
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _NTDDSCRD_H2_
#define _NTDDSCRD_H2_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Smart card protocol flags */
#define SCARD_PROTOCOL_UNDEFINED    0x00000000L
#define SCARD_PROTOCOL_T0           0x00000001L
#define SCARD_PROTOCOL_T1           0x00000002L
#define SCARD_PROTOCOL_RAW          0x00010000L
#define SCARD_PROTOCOL_TX           (SCARD_PROTOCOL_T0 | SCARD_PROTOCOL_T1)
#define SCARD_PROTOCOL_DEFAULT      0x80000000L
#define SCARD_PROTOCOL_OPTIMAL      0x00000000L

/* IOCTL_SMARTCARD_POWER parameters */
#define SCARD_POWER_DOWN    0L
#define SCARD_COLD_RESET    1L
#define SCARD_WARM_RESET    2L

/* Macro to define smart card device I/O control codes */
#define SCARD_CTL_CODE( x ) \
    CTL_CODE( FILE_DEVICE_SMARTCARD, x, METHOD_BUFFERED, FILE_ANY_ACCESS )

/* SmartCard device I/O control codes */
#define IOCTL_SMARTCARD_POWER           SCARD_CTL_CODE( 1 )
#define IOCTL_SMARTCARD_GET_ATTRIBUTE   SCARD_CTL_CODE( 2 )
#define IOCTL_SMARTCARD_SET_ATTRIBUTE   SCARD_CTL_CODE( 3 )
#define IOCTL_SMARTCARD_CONFISCATE      SCARD_CTL_CODE( 4 )
#define IOCTL_SMARTCARD_TRANSMIT        SCARD_CTL_CODE( 5 )
#define IOCTL_SMARTCARD_EJECT           SCARD_CTL_CODE( 6 )
#define IOCTL_SMARTCARD_SWALLOW         SCARD_CTL_CODE( 7 )
#define IOCTL_SMARTCARD_IS_PRESENT      SCARD_CTL_CODE( 10 )
#define IOCTL_SMARTCARD_IS_ABSENT       SCARD_CTL_CODE( 11 )
#define IOCTL_SMARTCARD_SET_PROTOCOL    SCARD_CTL_CODE( 12 )
#define IOCTL_SMARTCARD_GET_STATE       SCARD_CTL_CODE( 14 )
#define IOCTL_SMARTCARD_GET_LAST_ERROR  SCARD_CTL_CODE( 15 )
#define IOCTL_SMARTCARD_GET_PERF_CNTR   SCARD_CTL_CODE( 16 )

/* Maximums */
#define MAXIMUM_ATTR_STRING_LENGTH  32
#define MAXIMUM_SMARTCARD_READERS   10

/* Macro to create a smart card attribute value */
#define SCARD_ATTR_VALUE( p1, p2 )  ((((ULONG)(p1)) << 16) | (((ULONG)(p2)))

/* Smart card attribute classes */
#define SCARD_CLASS_VENDOR_INFO     1
#define SCARD_CLASS_COMMUNICATIONS  2
#define SCARD_CLASS_PROTOCOL        3
#define SCARD_CLASS_POWER_MGMT      4
#define SCARD_CLASS_SECURITY        5
#define SCARD_CLASS_MECHANICAL      6
#define SCARD_CLASS_VENDOR_DEFINED  7
#define SCARD_CLASS_IFD_PROTOCOL    8
#define SCARD_CLASS_ICC_STATE       9
#define SCARD_CLASS_PERF            0x7FFE
#define SCARD_CLASS_SYSTEM          0x7FFF

/* Smart card attributes */
#define SCARD_ATTR_VENDOR_NAME \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_INFO, 0x0100 )
#define SCARD_ATTR_VENDOR_IFD_TYPE \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_INFO, 0x0101 )
#define SCARD_ATTR_VENDOR_IFD_VERSION \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_INFO, 0x0102 )
#define SCARD_ATTR_VENDOR_IFD_SERIAL_NO \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_INFO, 0x0103 )
#define SCARD_ATTR_CHANNEL_ID \
    SCARD_ATTR_VALUE( SCARD_CLASS_COMMUNICATIONS, 0x0110 )
#define SCARD_ATTR_PROTOCOL_TYPES \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0120 )
#define SCARD_ATTR_DEFAULT_CLK \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0121 )
#define SCARD_ATTR_MAX_CLK \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0122 )
#define SCARD_ATTR_DEFAULT_DATA_RATE \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0123 )
#define SCARD_ATTR_MAX_DATA_RATE \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0124 )
#define SCARD_ATTR_MAX_IFSD \
    SCARD_ATTR_VALUE( SCARD_CLASS_PROTOCOL, 0x0125 )
#define SCARD_ATTR_POWER_MGMT_SUPPORT \
    SCARD_ATTR_VALUE( SCARD_CLASS_POWER_MGMT, 0x0131 )
#define SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE \
    SCARD_ATTR_VALUE( SCARD_CLASS_SECURITY, 0x0140 )
#define SCARD_ATTR_USER_AUTH_INPUT_DEVICE \
    SCARD_ATTR_VALUE( SCARD_CLASS_SECURITY, 0x0142 )
#define SCARD_ATTR_CHARACTERISTICS \
    SCARD_ATTR_VALUE( SCARD_CLASS_MECHANICAL, 0x0150 )
#define SCARD_ATTR_CURRENT_PROTOCOL_TYPE \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0201 )
#define SCARD_ATTR_CURRENT_CLK \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0202 )
#define SCARD_ATTR_CURRENT_F \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0203 )
#define SCARD_ATTR_CURRENT_D \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0204 )
#define SCARD_ATTR_CURRENT_N \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0205 )
#define SCARD_ATTR_CURRENT_W \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0206 )
#define SCARD_ATTR_CURRENT_IFSC \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0207 )
#define SCARD_ATTR_CURRENT_IFSD \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0208 )
#define SCARD_ATTR_CURRENT_BWT \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x0209 )
#define SCARD_ATTR_CURRENT_CWT \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x020A )
#define SCARD_ATTR_CURRENT_EBC_ENCODING \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x020B )
#define SCARD_ATTR_EXTENDED_BWT \
    SCARD_ATTR_VALUE( SCARD_CLASS_IFD_PROTOCOL, 0x020C )
#define SCARD_ATTR_ICC_PRESENCE \
    SCARD_ATTR_VALUE( SCARD_CLASS_ICC_STATE, 0x0300 )
#define SCARD_ATTR_ICC_INTERFACE_STATUS \
    SCARD_ATTR_VALUE( SCARD_CLASS_ICC_STATE, 0x0301 )
#define SCARD_ATTR_CURRENT_IO_STATE \
    SCARD_ATTR_VALUE( SCARD_CLASS_ICC_STATE, 0x0302 )
#define SCARD_ATTR_ATR_STRING \
    SCARD_ATTR_VALUE( SCARD_CLASS_ICC_STATE, 0x0303 )
#define SCARD_ATTR_ICC_TYPE_PER_ATR \
    SCARD_ATTR_VALUE( SCARD_CLASS_ICC_STATE, 0x0304 )
#define SCARD_ATTR_ESC_RESET \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_DEFINED, 0xA000 )
#define SCARD_ATTR_ESC_CANCEL \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_DEFINED, 0xA003 )
#define SCARD_ATTR_ESC_AUTHREQUEST \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_DEFINED, 0xA005 )
#define SCARD_ATTR_MAXINPUT \
    SCARD_ATTR_VALUE( SCARD_CLASS_VENDOR_DEFINED, 0xA007 )
#define SCARD_ATTR_DEVICE_UNIT \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0001 )
#define SCARD_ATTR_DEVICE_IN_USE \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0002 )
#define SCARD_ATTR_DEVICE_FRIENDLY_NAME_A \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0003 )
#define SCARD_ATTR_DEVICE_SYSTEM_NAME_A \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0004 )
#define SCARD_ATTR_DEVICE_FRIENDLY_NAME_W \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0005 )
#define SCARD_ATTR_DEVICE_SYSTEM_NAME_W \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0006 )
#define SCARD_ATTR_SUPRESS_T1_IFS_REQUEST \
    SCARD_ATTR_VALUE( SCARD_CLASS_SYSTEM, 0x0007 )
#define SCARD_PERF_NUM_TRANSMISSIONS \
    SCARD_ATTR_VALUE( SCARD_CLASS_PERF, 0x0001 )
#define SCARD_PERF_BYTES_TRANSMITTED \
    SCARD_ATTR_VALUE( SCARD_CLASS_PERF, 0x0002 )
#define SCARD_PERF_TRANSMISSION_TIME \
    SCARD_ATTR_VALUE( SCARD_CLASS_PERF, 0x0003 )
#ifdef UNICODE
    #define SCARD_ATTR_DEVICE_FRIENDLY_NAME SCARD_ATTR_DEVICE_FRIENDLY_NAME_W
    #define SCARD_ATTR_DEVICE_SYSTEM_NAME   SCARD_ATTR_DEVICE_SYSTEM_NAME_W
#else
    #define SCARD_ATTR_DEVICE_FRIENDLY_NAME SCARD_ATTR_DEVICE_FRIENDLY_NAME_A
    #define SCARD_ATTR_DEVICE_SYSTEM_NAME   SCARD_ATTR_DEVICE_SYSTEM_NAME_A
#endif

/* T0 protocol constants */
#define SCARD_T0_HEADER_LENGTH  7
#define SCARD_T0_CMD_LENGTH     5

/* T1 protocol constants */
#define SCARD_T1_PROLOGUE_LENGTH    3
#define SCARD_T1_EPILOGUE_LENGTH    2
#define SCARD_T1_MAX_IFS            254

/* Smart card reader states */
#define SCARD_UNKNOWN       0L
#define SCARD_ABSENT        1L
#define SCARD_PRESENT       2L
#define SCARD_SWALLOWED     3L
#define SCARD_POWERED       4L
#define SCARD_NEGOTIABLE    5L
#define SCARD_SPECIFIC      6L

/* Smart card reader flags */
#define SCARD_READER_SWALLOWS       0x00000001L
#define SCARD_READER_EJECTS         0x00000002L
#define SCARD_READER_CONFISCATES    0x00000004L

/* Smart card reader types */
#define SCARD_READER_TYPE_SERIAL    0x00000001L
#define SCARD_READER_TYPE_PARALLEL  0x00000002L
#define SCARD_READER_TYPE_KEYBOARD  0x00000004L
#define SCARD_READER_TYPE_SCSI      0x00000008L
#define SCARD_READER_TYPE_IDE       0x00000010L
#define SCARD_READER_TYPE_USB       0x00000020L
#define SCARD_READER_TYPE_PCMCIA    0x00000040L
#define SCARD_READER_TYPE_VENDOR    0x000000F0L

/* Smart card I/O request */
typedef struct _SCARD_IO_REQUEST {
    DWORD   dwProtocol;
    DWORD   cbPciLength;
} SCARD_IO_REQUEST;
typedef SCARD_IO_REQUEST        *PSCARD_IO_REQUEST;
typedef SCARD_IO_REQUEST        *LPSCARD_IO_REQUEST;
typedef const SCARD_IO_REQUEST  *LPCSCARD_IO_REQUEST;

/* T0 command */
typedef struct {
    BYTE    bCla;
    BYTE    bIns;
    BYTE    bP1;
    BYTE    bP2;
    BYTE    bP3;
} SCARD_T0_COMMAND;
typedef SCARD_T0_COMMAND    *PSCARD_T0_COMMAND;

/* T0 request */
typedef struct {
    SCARD_IO_REQUEST    ioRequest;
    BYTE                bSw1;
    BYTE                bSw2;
    union {
        SCARD_T0_COMMAND    CmdBytes;
        BYTE                rgbHeader[5];
    };
} SCARD_T0_REQUEST;
typedef SCARD_T0_REQUEST    *PSCARD_T0_REQUEST;
typedef SCARD_T0_REQUEST    *LPSCARD_T0_REQUEST;

/* T1 request */
typedef struct {
    SCARD_IO_REQUEST    ioRequest;
} SCARD_T1_REQUEST;
typedef SCARD_T1_REQUEST    *PSCARD_T1_REQUEST;
typedef SCARD_T1_REQUEST    *LPSCARD_T1_REQUEST;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _NTDDSCRD_H2_ */
