/*
 *  winreg.h    Win32 registry functions.
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINREG_
#define _WINREG_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <reason.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Registry access mask data type */
typedef ACCESS_MASK REGSAM;

/* Registry API return value data type */
typedef LONG    LSTATUS;

/* RegGetValue() flags */
#define RRF_RT_REG_NONE         0x00000001L
#define RRF_RT_REG_SZ           0x00000002L
#define RRF_RT_REG_EXPAND_SZ    0x00000004L
#define RRF_RT_REG_BINARY       0x00000008L
#define RRF_RT_REG_DWORD        0x00000010L
#define RRF_RT_REG_MULTI_SZ     0x00000020L
#define RRF_RT_REG_QWORD        0x00000040L
#define RRF_RT_DWORD            (RRF_RT_REG_BINARY | RRF_RT_REF_DWORD)
#define RRF_RT_QWORD            (RRF_RT_REG_BINARY | RRF_RT_REF_QWORD)
#define RRF_RT_ANY              0x0000FFFFL
#define RRF_NOEXPAND            0x10000000L
#define RRF_ZEROONFAILURE       0x20000000L

/* RegLoadAppKey() flags */
#define REG_PROCESS_APPKEY  0x00000001L

/* RegLoadMUIString() flags */
#define REG_MUI_STRING_TRUNCATE 0x00000001L

/* Special key handles */
#define HKEY_CLASSES_ROOT                       ((HKEY)0x80000000L)
#define HKEY_CURRENT_USER                       ((HKEY)0x80000001L)
#define HKEY_LOCAL_MACHINE                      ((HKEY)0x80000002L)
#define HKEY_USERS                              ((HKEY)0x80000003L)
#define HKEY_PERFORMANCE_DATA                   ((HKEY)0x80000004L)
#define HKEY_PERFORMANCE_TEXT                   ((HKEY)0x80000050L)
#define HKEY_PERFORMANCE_NLSTEXT                ((HKEY)0x80000060L)
#if (WINVER >= 0x0400)
    #define HKEY_CURRENT_CONFIG                 ((HKEY)0x80000005L)
    #define HKEY_DYN_DATA                       ((HKEY)0x80000006L)
    #define HKEY_CURRENT_USER_LOCAL_SETTINGS    ((HKEY)0x80000007L)
#endif

/* RegConnectRegistryEx() flags */
#if (WINVER >= 0x0400)
    #define REG_SECURE_CONNECTION   1L
#endif

/* Default value for parameters that didn't exist in Win16 */
#define WIN31_CLASS NULL

/* Old names for shutdown reason codes */
#define REASON_SWINSTALL \
    (SHTDN_REASON_MAJOR_SOFTWARE | SHTDN_REASON_MINOR_INSTALLATION)
#define REASON_HWINSTALL \
    (SHTDN_REASON_MAJOR_HARDWARE | SHTDN_REASON_MINOR_INSTALLATION)
#define REASON_SERVICEHANG  (SHTDN_REASON_MAJOR_SOFTWARE | SHTDN_REASON_MINOR_HUNG)
#define REASON_UNSTABLE     (SHTDN_REASON_MAJOR_SYSTEM | SHTDN_REASON_MINOR_UNSTABLE)
#define REASON_SWHWRECONF   (SHTDN_REASON_MAJOR_SOFTWARE | SHTDN_REASON_MINOR_RECONFIG)
#define REASON_OTHER        (SHTDN_REASON_MAJOR_OTHER | SHTDN_REASON_MINOR_OTHER)
#define REASON_UNKNOWN      SHTDN_REASON_UNKNOWN
#define REASON_LEGACY_API   SHTDN_REASON_LEGACY_API
#define REASON_PLANNED_FLAG SHTDN_REASON_FLAG_PLANNED

/* Maximum shutdown timeout */
#define MAX_SHUTDOWN_TIMEOUT    315360000L

/* Shutdown flags */
#define SHUTDOWN_FORCE_OTHERS           0x00000001L
#define SHUTDOWN_FORCE_SELF             0x00000002L
#define SHUTDOWN_RESTART                0x00000004L
#define SHUTDOWN_POWEROFF               0x00000008L
#define SHUTDOWN_NOREBOOT               0x00000010L
#define SHUTDOWN_GRACE_OVERRIDE         0x00000020L
#define SHUTDOWN_INSTALL_UPDATES        0x00000040L
#define SHUTDOWN_RESTARTAPPS            0x00000080L
#define SHUTDOWN_SKIP_SVC_PRESHUTDOWN   0x00000100L

/* Value context */
#if (WINVER >= 0x0400)
struct val_context {
    int     valuelen;
    LPVOID  value_context;
    LPVOID  val_buff_ptr;
};
typedef struct val_context * PVALCONTEXT;
#endif

/* Provider value context */
#if (WINVER >= 0x0400)
typedef struct pvalueA {
    LPSTR   pv_valuename;
    int     pv_valuelen;
    LPVOID  pv_value_context;
    DWORD   pv_type;
} PVALUEA;
typedef PVALUEA     *PPVALUEA;
typedef struct pvalueW {
    LPWSTR  pv_valuename;
    int     pv_valuelen;
    LPVOID  pv_value_context;
    DWORD   pv_type;
} PVALUEW;
typedef PVALUEW     *PPVALUEW;
#ifdef UNICODE
typedef PVALUEW     PVALUE;
typedef PPVALUEW    PPVALUE;
#else
typedef PVALUEA     PVALUE;
typedef PPVALUEA    PPVALUE;
#endif
#endif

/* Query handler callback function */
#if (WINVER >= 0x0400)
typedef DWORD (__cdecl QUERYHANDLER)( LPVOID, PVALCONTEXT, DWORD, LPVOID, DWORD *,
                                      DWORD );
typedef QUERYHANDLER    *PQUERYHANDLER;
#endif

/* Provider information */
#if (WINVER >= 0x0400)
typedef struct provider_info {
    PQUERYHANDLER   pi_R0_1val;
    PQUERYHANDLER   pi_R0_allvals;
    PQUERYHANDLER   pi_R3_1val;
    PQUERYHANDLER   pi_R3_allvals;
    DWORD           pi_flags;
    LPVOID          pi_key_context;
} REG_PROVIDER;
typedef struct provider_info    *PPROVIDER;
#endif

/* Value entry */
#if (WINVER >= 0x0400)
typedef struct value_entA {
    LPSTR       ve_valuename;
    DWORD       ve_valuelen;
    DWORD_PTR   ve_valueptr;
    DWORD       ve_type;
} VALENTA;
typedef VALENTA     *PVALENTA;
typedef struct value_entW {
    LPWSTR      ve_valuename;
    DWORD       ve_valuelen;
    DWORD_PTR   ve_valueptr;
    DWORD       ve_type;
} VALENTW;
typedef VALENTW     *PVALENTW;
#ifdef UNICODE
typedef VALENTW     VALENT;
typedef PVALENTW    PVALENT;
#else
typedef VALENTA     VALENT;
typedef PVALENTA    PVALENT;
#endif
#endif

/* Functions in ADVAPI32.DLL */
WINADVAPI BOOL APIENTRY     AbortSystemShutdownA( LPSTR );
WINADVAPI BOOL APIENTRY     AbortSystemShutdownW( LPWSTR );
WINADVAPI DWORD APIENTRY    InitiateShutdownA( LPSTR, LPSTR, DWORD, DWORD, DWORD );
WINADVAPI DWORD APIENTRY    InitiateShutdownW( LPWSTR, LPWSTR, DWORD, DWORD, DWORD );
WINADVAPI BOOL APIENTRY     InitiateSystemShutdownA( LPSTR, LPSTR, DWORD, BOOL, BOOL );
WINADVAPI BOOL APIENTRY     InitiateSystemShutdownExA( LPSTR, LPSTR, DWORD, BOOL, BOOL, DWORD );
WINADVAPI BOOL APIENTRY     InitiateSystemShutdownExW( LPWSTR, LPWSTR, DWORD, BOOL, BOOL, DWORD );
WINADVAPI BOOL APIENTRY     InitiateSystemShutdownW( LPWSTR, LPWSTR, DWORD, BOOL, BOOL );
WINADVAPI LSTATUS APIENTRY  RegCloseKey( HKEY );
WINADVAPI LSTATUS APIENTRY  RegConnectRegistryA( LPCSTR, HKEY, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegConnectRegistryExA( LPCSTR, HKEY, ULONG, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegConnectRegistryExW( LPCWSTR, HKEY, ULONG, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegConnectRegistryW( LPCWSTR, HKEY, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyA( HKEY, LPCSTR, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyExA( HKEY, LPCSTR, DWORD, LPSTR, DWORD, REGSAM, CONST LPSECURITY_ATTRIBUTES, PHKEY, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyExW( HKEY, LPCWSTR, DWORD, LPWSTR, DWORD, REGSAM, CONST LPSECURITY_ATTRIBUTES, PHKEY, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyTransactedA( HKEY, LPCSTR, DWORD, LPSTR, DWORD, REGSAM, CONST LPSECURITY_ATTRIBUTES, PHKEY, LPDWORD, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyTransactedW( HKEY, LPCWSTR, DWORD, LPWSTR, DWORD, REGSAM, CONST LPSECURITY_ATTRIBUTES, PHKEY, LPDWORD, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegCreateKeyW( HKEY, LPCWSTR, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyA( HKEY, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyExA( HKEY, LPCSTR, REGSAM, DWORD );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyExW( HKEY, LPCWSTR, REGSAM, DWORD );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyTransactedA( HKEY, LPCSTR, REGSAM, DWORD, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyTransactedW( HKEY, LPCWSTR, REGSAM, DWORD, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyW( HKEY, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteValueA( HKEY, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteValueW( HKEY, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegDisablePredefinedCache( VOID );
WINADVAPI LSTATUS APIENTRY  RegDisablePredefinedCacheEx( VOID );
WINADVAPI LONG APIENTRY     RegDisableReflectionKey( HKEY );
WINADVAPI LONG APIENTRY     RegEnableReflectionKey( HKEY );
WINADVAPI LSTATUS APIENTRY  RegEnumKeyA( HKEY, DWORD, LPSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegEnumKeyExA( HKEY, DWORD, LPSTR, LPDWORD, LPDWORD, LPSTR, LPDWORD, PFILETIME );
WINADVAPI LSTATUS APIENTRY  RegEnumKeyExW( HKEY, DWORD, LPWSTR, LPDWORD, LPDWORD, LPWSTR, LPDWORD, PFILETIME );
WINADVAPI LSTATUS APIENTRY  RegEnumKeyW( HKEY, DWORD, LPWSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegEnumValueA( HKEY, DWORD, LPSTR, LPDWORD, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegEnumValueW( HKEY, DWORD, LPWSTR, LPDWORD, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegFlushKey( HKEY );
WINADVAPI LSTATUS APIENTRY  RegGetKeySecurity( HKEY, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegGetValueA( HKEY, LPCSTR, LPCSTR, DWORD, LPDWORD, PVOID, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegGetValueW( HKEY, LPCWSTR, LPCWSTR, DWORD, LPDWORD, PVOID, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegLoadAppKeyA( LPCSTR, PHKEY, REGSAM, DWORD, DWORD );
WINADVAPI LSTATUS APIENTRY  RegLoadAppKeyW( LPCWSTR, PHKEY, REGSAM, DWORD, DWORD );
WINADVAPI LSTATUS APIENTRY  RegLoadKeyA( HKEY, LPCSTR, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegLoadKeyW( HKEY, LPCWSTR, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegLoadMUIStringA( HKEY, LPCSTR, LPSTR, DWORD, LPDWORD, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegLoadMUIStringW( HKEY, LPCWSTR, LPWSTR, DWORD, LPDWORD, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegNotifyChangeKeyValue( HKEY, BOOL, DWORD, HANDLE, BOOL );
WINADVAPI LSTATUS APIENTRY  RegOpenCurrentUser( REGSAM, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyA( HKEY, LPCSTR, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyExA( HKEY, LPCSTR, DWORD, REGSAM, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyExW( HKEY, LPCWSTR, DWORD, REGSAM, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyTransactedA( HKEY, LPCSTR, DWORD, REGSAM, PHKEY, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyTransactedW( HKEY, LPCWSTR, DWORD, REGSAM, PHKEY, HANDLE, PVOID );
WINADVAPI LSTATUS APIENTRY  RegOpenKeyW( HKEY, LPCWSTR, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOpenUserClassesRoot( HANDLE, DWORD, REGSAM, PHKEY );
WINADVAPI LSTATUS APIENTRY  RegOverridePredefKey( HKEY, HKEY );
WINADVAPI LSTATUS APIENTRY  RegQueryInfoKeyA( HKEY, LPSTR, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, PFILETIME );
WINADVAPI LSTATUS APIENTRY  RegQueryInfoKeyW( HKEY, LPWSTR, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, LPDWORD, PFILETIME );
WINADVAPI LONG APIENTRY     RegQueryReflectionKey( HKEY, BOOL * );
WINADVAPI LSTATUS APIENTRY  RegQueryValueA( HKEY, LPCSTR, LPSTR, PLONG );
WINADVAPI LSTATUS APIENTRY  RegQueryValueExA( HKEY, LPCSTR, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegQueryValueExW( HKEY, LPCWSTR, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegQueryValueW( HKEY, LPCWSTR, LPWSTR, PLONG );
WINADVAPI LSTATUS APIENTRY  RegReplaceKeyA( HKEY, LPCSTR, LPCSTR, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegReplaceKeyW( HKEY, LPCWSTR, LPCWSTR, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegRestoreKeyA( HKEY, LPCSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegRestoreKeyW( HKEY, LPCWSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSaveKeyA( HKEY, LPCSTR, LPSECURITY_ATTRIBUTES );
WINADVAPI LSTATUS APIENTRY  RegSaveKeyExA( HKEY, LPCSTR, LPSECURITY_ATTRIBUTES, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSaveKeyExW( HKEY, LPCWSTR, LPSECURITY_ATTRIBUTES, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSaveKeyW( HKEY, LPCWSTR, LPSECURITY_ATTRIBUTES );
WINADVAPI LSTATUS APIENTRY  RegSetKeySecurity( HKEY, SECURITY_INFORMATION, PSECURITY_DESCRIPTOR );
WINADVAPI LSTATUS APIENTRY  RegSetValueA( HKEY, LPCSTR, DWORD, LPCSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSetValueExA( HKEY, LPCSTR, DWORD, DWORD, CONST BYTE *, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSetValueExW( HKEY, LPCWSTR, DWORD, DWORD, CONST BYTE *, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSetValueW( HKEY, LPCWSTR, DWORD, LPCWSTR, DWORD );
WINADVAPI LSTATUS APIENTRY  RegUnLoadKeyA( HKEY, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegUnLoadKeyW( HKEY, LPCWSTR );
#if (WINVER >= 0x0400)
WINADVAPI LSTATUS APIENTRY  RegQueryMultipleValuesA( HKEY, PVALENTA, DWORD, LPSTR, LPDWORD );
WINADVAPI LSTATUS APIENTRY  RegQueryMultipleValuesW( HKEY, PVALENTW, DWORD, LPWSTR, LPDWORD );
#endif
#if (WINVER >= 0x0600)
WINADVAPI LSTATUS APIENTRY  RegRenameKey( HKEY, LPCWSTR, LPCWSTR );
#endif
#if (_WIN32_WINNT >= 0x0600)
WINADVAPI LSTATUS APIENTRY  RegCopyTreeA( HKEY, LPCSTR, HKEY );
WINADVAPI LSTATUS APIENTRY  RegCopyTreeW( HKEY, LPCWSTR, HKEY );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyValueA( HKEY, LPCSTR, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteKeyValueW( HKEY, LPCWSTR, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteTreeA( HKEY, LPCSTR );
WINADVAPI LSTATUS APIENTRY  RegDeleteTreeW( HKEY, LPCWSTR );
WINADVAPI LSTATUS APIENTRY  RegSetKeyValueA( HKEY, LPCSTR, LPCSTR, DWORD, LPCVOID, DWORD );
WINADVAPI LSTATUS APIENTRY  RegSetKeyValueW( HKEY, LPCWSTR, LPCWSTR, DWORD, LPCVOID, DWORD );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define AbortSystemShutdown         AbortSystemShutdownW
    #define InitiateShutdown            InitiateShutdownW
    #define InitiateSystemShutdown      InitiateSystemShutdownW
    #define InitiateSystemShutdownEx    InitiateSystemShutdownExW
    #define RegConnectRegistry          RegConnectRegistryW
    #define RegConnectRegistryEx        RegConnectRegistryExW
    #define RegCreateKey                RegCreateKeyW
    #define RegCreateKeyEx              RegCreateKeyExW
    #define RegCreateKeyTransacted      RegCreateKeyTransactedW
    #define RegDeleteKey                RegDeleteKeyW
    #define RegDeleteKeyEx              RegDeleteKeyExW
    #define RegDeleteKeyTransacted      RegDeleteKeyTransactedW
    #define RegDeleteValue              RegDeleteValueW
    #define RegEnumKey                  RegEnumKeyW
    #define RegEnumKeyEx                RegEnumKeyExW
    #define RegEnumValue                RegEnumValueW
    #define RegGetValue                 RegGetValueW
    #define RegLoadAppKey               RegLoadAppKeyW
    #define RegLoadKey                  RegLoadKeyW
    #define RegLoadMUIString            RegLoadMUIStringW
    #define RegOpenKey                  RegOpenKeyW
    #define RegOpenKeyEx                RegOpenKeyExW
    #define RegOpenKeyTransacted        RegOpenKeyTransactedW
    #define RegQueryInfoKey             RegQueryInfoKeyW
    #define RegQueryValue               RegQueryValueW
    #define RegQueryValueEx             RegQueryValueExW
    #define RegReplaceKey               RegReplaceKeyW
    #define RegRestoreKey               RegRestoreKeyW
    #define RegSaveKey                  RegSaveKeyW
    #define RegSaveKeyEx                RegSaveKeyExW
    #define RegSetValue                 RegSetValueW
    #define RegSetValueEx               RegSetValueExW
    #define RegUnLoadKey                RegUnLoadKeyW
    #if (WINVER >= 0x0400)
        #define RegQueryMultipleValues  RegQueryMultipleValuesW
    #endif
    #if (_WIN32_WINNT >= 0x0600)
        #define RegCopyTree             RegCopyTreeW
        #define RegDeleteKeyValue       RegDeleteKeyValueW
        #define RegDeleteTree           RegDeleteTreeW
        #define RegSetKeyValue          RegSetKeyValueW
    #endif
#else
    #define AbortSystemShutdown         AbortSystemShutdownA
    #define InitiateShutdown            InitiateShutdownA
    #define InitiateSystemShutdown      InitiateSystemShutdownA
    #define InitiateSystemShutdownEx    InitiateSystemShutdownExA
    #define RegConnectRegistry          RegConnectRegistryA
    #define RegConnectRegistryEx        RegConnectRegistryExA
    #define RegCreateKey                RegCreateKeyA
    #define RegCreateKeyEx              RegCreateKeyExA
    #define RegCreateKeyTransacted      RegCreateKeyTransactedA
    #define RegDeleteKey                RegDeleteKeyA
    #define RegDeleteKeyEx              RegDeleteKeyExA
    #define RegDeleteKeyTransacted      RegDeleteKeyTransactedA
    #define RegDeleteValue              RegDeleteValueA
    #define RegEnumKey                  RegEnumKeyA
    #define RegEnumKeyEx                RegEnumKeyExA
    #define RegEnumValue                RegEnumValueA
    #define RegGetValue                 RegGetValueA
    #define RegLoadAppKey               RegLoadAppKeyA
    #define RegLoadKey                  RegLoadKeyA
    #define RegLoadMUIString            RegLoadMUIStringA
    #define RegOpenKey                  RegOpenKeyA
    #define RegOpenKeyEx                RegOpenKeyExA
    #define RegOpenKeyTransacted        RegOpenKeyTransactedA
    #define RegQueryInfoKey             RegQueryInfoKeyA
    #define RegQueryValue               RegQueryValueA
    #define RegQueryValueEx             RegQueryValueExA
    #define RegReplaceKey               RegReplaceKeyA
    #define RegRestoreKey               RegRestoreKeyA
    #define RegSaveKey                  RegSaveKeyA
    #define RegSaveKeyEx                RegSaveKeyExA
    #define RegSetValue                 RegSetValueA
    #define RegSetValueEx               RegSetValueExA
    #define RegUnLoadKey                RegUnLoadKeyA
    #if (WINVER >= 0x0400)
        #define RegQueryMultipleValues  RegQueryMultipleValuesA
    #endif
    #if (_WIN32_WINNT >= 0x0600)
        #define RegCopyTree             RegCopyTreeA
        #define RegDeleteKeyValue       RegDeleteKeyValueA
        #define RegDeleteTree           RegDeleteTreeA
        #define RegSetKeyValue          RegSetKeyValueA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINREG_ */
