/*
 *  winnt.h     NT definitions used by Win32
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINNT_
#define _WINNT_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ctype.h>
#include <string.h>
#include <basetsd.h>
#include <guiddef.h>
#include <specstrings.h>
#include <sdkddkver.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Define the appropriate macro for the current processor. */
#if defined(_M_I386) && !defined(_X86_)
    #define _X86_
#elif defined(_M_ALPHA) && !defined(_ALPHA_)
    #define _ALPHA_
#endif

/* Pointer attributes */
#define UNALIGNED
#define UNALIGNED64
#define RESTRICTED_POINTER

/* Macro to perform compile-time assertions */
#define C_ASSERT( x )   typedef char __C_ASSERT__[(x) ? 1 : -1]

/* Declaration specifiers */
#define DECLSPEC_IMPORT     __declspec(dllimport)
#define DECLSPEC_NORETURN
#define DECLSPEC_ALIGN( x )
#define DECLSPEC_UUID( x )
#define DECLSPEC_NOVTABLE
#define DECLSPEC_SELECTANY
#define DECLSPEC_ADDRSAFE
#define DECLSPEC_NOINLINE
#define DECLSPEC_DEPRECATED

/* Calling convention for NT functions */
#define NTAPI   __stdcall

/* Macros to specify NT functions */
#define NTSYSAPI        DECLSPEC_IMPORT
#define NTSYSCALLAPI    DECLSPEC_IMPORT

/* Standard method and API calling conventions */
#define STDMETHODCALLTYPE   __stdcall
#define STDMETHODVCALLTYPE  __cdecl
#define STDAPICALLTYPE      __stdcall
#define STDAPIVCALLTYPE     __cdecl

/* Macro used to specify extern "C" */
#ifdef __cplusplus
    #define EXTERN_C    extern "C"
#else
    #define EXTERN_C    extern
#endif

/* Standard method implementation and API declaration macros */
#define STDAPI                      EXTERN_C HRESULT STDAPICALLTYPE
#define STDAPI_( x )                EXTERN_C x STDAPICALLTYPE
#define STDAPIV                     EXTERN_C HRESULT STDAPIVCALLTYPE
#define STDAPIV_( x )               EXTERN_C x STDAPIVCALLTYPE
#define STDMETHODIMP                HRESULT STDMETHODCALLTYPE
#define STDMETHODIMP_( x )          x STDMETHODCALLTYPE
#define STDMETHODIMPV               HRESULT STDMETHODVCALLTYPE
#define STDMETHODIMPV_( x )         x STDMETHODVCALLTYPE
#define STDOVERRIDEMETHODIMP        STDMETHODIMP
#define STDOVERRIDEMETHODIMP_( x )  STDMETHODIMP_( x )
#define STDOVERRIDEMETHODIMPV       STDMETHODIMPV
#define STDOVERRIDEMETHODIMPV_( x ) STDMETHODIMPV_( x )
#define IFACEMETHODIMP              STDMETHODIMP
#define IFACEMETHODIMP_( x )        STDMETHODIMP_( x )
#define IFACEMETHODIMPV             STDMETHODIMPV
#define IFACEMETHODIMPV_( x )       STDMETHODIMPV_( x )

/* Macro to declare handle data types */
#define DECLARE_HANDLE( x ) typedef struct x##__ { int dummy; } *x

/* Macro used to specify an unspecified data type or an empty parameter list */
#define VOID    void

/* Macro to specify neutral strings */
#ifdef UNICODE
    #define __TEXT( x ) L##x
#else
    #define __TEXT( x ) x
#endif
#define TEXT( x )       __TEXT( x )

/* Macros to manipulate language identifiers */
#define MAKELANGID( p1, p2 )    (((WORD)(p2) << 10) | (WORD)(p1))
#define PRIMARYLANGID( x )      ((WORD)(x) & 0x03FF)
#define SUBLANGID( x )          ((WORD)(x) >> 10)

/* Macros to manipulate locale identifiers */
#define MAKELCID( p1, p2)           (((DWORD)(WORD)(p2) << 16) | (DWORD)(WORD)(p1))
#define MAKESORTLCID( p1, p2, p3 )  (MAKELCID( p1, p2 ) | ((DWORD)(WORD)(p3) << 20))
#define LANGIDFROMLCID( x )         ((WORD)(x))
#define SORTIDFROMLCID( x )         ((WORD)(((DWORD)(x) >> 16) & 0x0000000FL))
#define SORTVERSIONFROMLCID( x )    ((WORD)(((DWORD)(x) >> 20) & 0x0000000FL))

/* Primitive data types */
typedef void                *PVOID;
typedef void                *PVOID64;
typedef char                CHAR;
typedef short               SHORT;
typedef long                LONG;
typedef SHORT               *PSHORT;
typedef LONG                *PLONG;
typedef void                *HANDLE;
typedef HANDLE              *PHANDLE;
typedef BYTE                FCHAR;
typedef WORD                FSHORT;
typedef DWORD               FLONG;
typedef LONG                HRESULT;
typedef char                CCHAR;
typedef DWORD               LCID;
typedef PDWORD              PLCID;
typedef WORD                LANGID;
typedef __int64             LONGLONG;
typedef unsigned __int64    ULONGLONG;
typedef LONGLONG            *PLONGLONG;
typedef ULONGLONG           *PULONGLONG;
typedef LONGLONG            USN;
typedef ULONGLONG           DWORDLONG;
typedef DWORDLONG           *PDWORDLONG;
typedef BYTE                BOOLEAN;
typedef BOOLEAN*            PBOOLEAN;
typedef DWORD               ACCESS_MASK;
typedef ACCESS_MASK         *PACCESS_MASK;
typedef DWORD               ACCESS_REASON;
typedef ULONG_PTR           SID_HASH_ENTRY;
typedef ULONG_PTR           *PSID_HASH_ENTRY;
typedef WORD                SECURITY_DESCRIPTOR_CONTROL;
typedef WORD                *PSECURITY_DESCRIPTOR_CONTROL;
typedef BOOLEAN             SECURITY_CONTEXT_TRACKING_MODE;
typedef BOOLEAN             *PSECURITY_CONTEXT_TRACKING_MODE;
typedef DWORD               SECURITY_INFORMATION;
typedef DWORD               *PSECURITY_INFORMATION;
typedef DWORD               EXECUTION_STATE;
typedef DWORD               *PEXECUTION_STATE;
typedef DWORD               TP_VERSION;
typedef DWORD               *PTP_VERSION;
typedef DWORD               TP_WAIT_RESULT;

/* ANSI string data types */
typedef CHAR        *PCHAR;
typedef CHAR        *LPCH;
typedef CHAR        *PCH;
typedef CONST CHAR  *LPCCH;
typedef CHAR        *PCCH;
typedef CHAR        *NPSTR;
typedef CHAR        *LPSTR;
typedef CHAR        *PSTR;
typedef PSTR        *PZPSTR;
typedef CONST PSTR  *PCZPSTR;
typedef CONST CHAR  *LPCSTR;
typedef CONST CHAR  *PCSTR;
typedef PCSTR       *PZPCSTR;
typedef CHAR        *PZZSTR;
typedef CONST CHAR  *PCZZSTR;
typedef CHAR        *PNZCH;
typedef CONST CHAR  *PCNZCH;

/* Unicode string data types */
typedef wchar_t                 WCHAR;
typedef WCHAR                   *PWCHAR;
typedef WCHAR                   *LPWCH;
typedef WCHAR                   *PWCH;
typedef CONST WCHAR             *LPCWCH;
typedef CONST WCHAR             *PCWCH;
typedef WCHAR                   *NWPSTR;
typedef WCHAR                   *LPWSTR;
typedef WCHAR                   *PWSTR;
typedef PWSTR                   *PZPWSTR;
typedef CONST PWSTR             *PCZPWSTR;
typedef WCHAR UNALIGNED         *LPUWSTR;
typedef WCHAR UNALIGNED         *PUWSTR;
typedef CONST WCHAR             *LPCWSTR;
typedef CONST WCHAR             *PCWSTR;
typedef PCWSTR                  *PZPCWSTR;
typedef CONST WCHAR UNALIGNED   *LPCUWSTR;
typedef CONST WCHAR UNALIGNED   *PCUWSTR;
typedef WCHAR                   *PZZWSTR;
typedef CONST WCHAR             *PCZZWSTR;
typedef WCHAR UNALIGNED         *PUZZWSTR;
typedef CONST WCHAR UNALIGNED   *PCUZZWSTR;
typedef WCHAR                   *PNZWCH;
typedef CONST WCHAR             *PCNZWCH;
typedef WCHAR UNALIGNED         *PUNZWCH;
typedef CONST WCHAR UNALIGNED   *PCUNZWCH;

/* Neutral string data types */
#ifdef UNICODE
#ifndef _TCHAR_DEFINED
#define _TCHAR_DEFINED
typedef WCHAR           TCHAR;
typedef WCHAR           *PTCHAR;
typedef WCHAR           TBYTE;
typedef WCHAR           *PTBYTE;
#endif
typedef LPWCH           LPTCH;
typedef LPWCH           PTCH;
typedef LPWSTR          LPTSTR;
typedef LPWSTR          PTSTR;
typedef LPCWSTR         LPCTSTR;
typedef LPCWSTR         PCTSTR;
typedef LPUWSTR         LPUTSTR;
typedef LPUWSTR         PUTSTR;
typedef LPCUWSTR        LPCUTSTR;
typedef LPCUWSTR        PCUTSTR;
typedef PZZWSTR         PZZTSTR;
typedef PCZZWSTR        PCZZTSTR;
typedef PUZZWSTR        PUZZTSTR;
typedef PCUZZWSTR       PCUZZTSTR;
typedef PNZWCH          PNZTCH;
typedef PCNZWCH         PCNZTCH;
typedef PUNZWCH         PUNZTCH;
typedef PCUNZWCH        PCUNZTCH;
#else
#ifndef _TCHAR_DEFINED
#define _TCHAR_DEFINED
typedef char            TCHAR;
typedef char            *PTCHAR;
typedef unsigned char   TBYTE;
typedef unsigned char   *PTBYTE;
#endif
typedef LPCH            LPTCH;
typedef LPCH            PTCH;
typedef LPSTR           LPTSTR;
typedef LPSTR           PTSTR;
typedef LPCSTR          LPCTSTR;
typedef LPCSTR          PCTSTR;
typedef LPSTR           LPUTSTR;
typedef LPSTR           PUTSTR;
typedef LPCSTR          LPCUTSTR;
typedef LPCSTR          PCUTSTR;
typedef PZZSTR          PZZTSTR;
typedef PCZZSTR         PCZZTSTR;
typedef PZZSTR          PUZZTSTR;
typedef PCZZSTR         PCUZZTSTR;
typedef PNZCH           PNZTCH;
typedef PCNZCH          PCNZTCH;
typedef PNZCH           PUNZTCH;
typedef PCNZCH          PCUNZTCH;
#endif

/* Universal Character Set (UCS) data types */
#if (_WIN32_WINNT >= 0x0600)
typedef CONST WCHAR             *LPCWCHAR;
typedef CONST WCHAR             *PCWCHAR;
typedef CONST WCHAR UNALIGNED   *LPCUWCHAR;
typedef CONST WCHAR UNALIGNED   *PCUWCHAR;
typedef unsigned long           UCSCHAR;
typedef UCSCHAR                 *PUCSCHAR;
typedef const UCSCHAR           *PCUCSCHAR;
typedef UCSCHAR                 *PUCSSTR;
typedef UCSCHAR UNALIGNED       *PUUCSSTR;
typedef const UCSCHAR           *PCUCSSTR;
typedef const UCSCHAR UNALIGNED *PCUUCSSTR;
typedef UCSCHAR UNALIGNED       *PUUCSCHAR;
typedef const UCSCHAR UNALIGNED *PCUUCSCHAR;
#endif

/* Value used to declare an array of an unknown size */
#define ANYSIZE_ARRAY   1

/* Universal Character Set (UCS) constants */
#if (_WIN32_WINNT >= 0x0600)
    #define UCSCHAR_INVALID_CHARACTER   0xFFFFFFFFL
    #define MIN_UCSCHAR                 0x00000000L
    #define MAX_UCSCHAR                 0x0010FFFFL
#endif

/* Processor group special value */
#define ALL_PROCESSOR_GROUPS    0xFFFF

/* Error severities */
#define APPLICATION_ERROR_MASK          0x20000000
#define ERROR_SEVERITY_SUCCES           0x00000000
#define ERROR_SEVERITY_INFORMATIONAL    0x40000000
#define ERROR_SEVERITY_WARNING          0x80000000
#define ERROR_SEVERITY_ERROR            0xC0000000

/* Null values */
#define ANSI_NULL       ((CHAR)0)
#define UNICODE_NULL    ((WCHAR)0)

/* Limits of primitive data types */
#define MINCHAR     0x80
#define MAXCHAR     0x7F
#define MINSHORT    0x8000
#define MAXSHORT    0x7FFF
#define MINLONG     0x80000000
#define MAXLONG     0x7FFFFFFF
#define MAXBYTE     0xFF
#define MAXWORD     0xFFFF
#define MAXDWORD    0xFFFFFFFF

/* Macro to find field offsets */
#define FIELD_OFFSET( x, p )    ((LONG)(LONG_PTR)&(((x *)0)->p))

/* Macro to calculate the size of an array */
#define ARRAYSIZE( x )  (sizeof( x ) / sizeof( (x)[0] ))

/* Macro to find the containing record */
#define CONTAINING_RECORD( p1, p2, p3 ) \
    ((p2 *)((PCHAR)(p1) - (ULONG_PTR)(&((p2 *)0)->p3)))

/* Suite types */
#define VER_SUITE_SMALLBUSINESS             0x00000001
#define VER_SUITE_ENTERPRISE                0x00000002
#define VER_SUITE_BACKOFFICE                0x00000004
#define VER_SUITE_COMMUNICATIONS            0x00000008
#define VER_SUITE_TERMINAL                  0x00000010
#define VER_SUITE_SMALLBUSINESS_RESTRICTED  0x00000020
#define VER_SUITE_EMBEDDEDNT                0x00000040
#define VER_SUITE_DATACENTER                0x00000080
#define VER_SUITE_SINGLEUSERTS              0x00000100
#define VER_SUITE_PERSONAL                  0x00000200
#define VER_SUITE_BLADE                     0x00000400
#define VER_SUITE_EMBEDDED_RESTRICTED       0x00000800
#define VER_SUITE_SECURITY_APPLIANCE        0x00001000
#define VER_SUITE_STORAGE_SERVER            0x00002000
#define VER_SUITE_COMPUTE_SERVER            0x00004000
#define VER_SUITE_WH_SERVER                 0x00008000

/* Product types */
#define PRODUCT_UNDEFINED                           0x00000000
#define PRODUCT_ULTIMATE                            0x00000001
#define PRODUCT_HOME_BASIC                          0x00000002
#define PRODUCT_HOME_PREMIUM                        0x00000003
#define PRODUCT_ENTERPRISE                          0x00000004
#define PRODUCT_HOME_BASIC_N                        0x00000005
#define PRODUCT_BUSINESS                            0x00000006
#define PRODUCT_STANDARD_SERVER                     0x00000007
#define PRODUCT_DATACENTER_SERVER                   0x00000008
#define PRODUCT_SMALLBUSINESS_SERVER                0x00000009
#define PRODUCT_ENTERPRISE_SERVER                   0x0000000A
#define PRODUCT_STARTER                             0x0000000B
#define PRODUCT_DATACENTER_SERVER_CORE              0x0000000C
#define PRODUCT_STANDARD_SERVER_CORE                0x0000000D
#define PRODUCT_ENTERPRISE_SERVER_CORE              0x0000000E
#define PRODUCT_ENTERPRISE_SERVER_IA64              0x0000000F
#define PRODUCT_BUSINESS_N                          0x00000010
#define PRODUCT_WEB_SERVER                          0x00000011
#define PRODUCT_CLUSTER_SERVER                      0x00000012
#define PRODUCT_HOME_SERVER                         0x00000013
#define PRODUCT_STORAGE_EXPRESS_SERVER              0x00000014
#define PRODUCT_STORAGE_STANDARD_SERVER             0x00000015
#define PRODUCT_STORAGE_WORKGROUP_SERVER            0x00000016
#define PRODUCT_STORAGE_ENTERPRISE_SERVER           0x00000017
#define PRODUCT_SERVER_FOR_SMALLBUSINESS            0x00000018
#define PRODUCT_SMALLBUSINESS_SERVER_PREMIUM        0x00000019
#define PRODUCT_HOME_PREMIUM_N                      0x0000001A
#define PRODUCT_ENTERPRISE_N                        0x0000001B
#define PRODUCT_ULTIMATE_N                          0x0000001C
#define PRODUCT_WEB_SERVER_CORE                     0x0000001D
#define PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT    0x0000001E
#define PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY      0x0000001F
#define PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING     0x00000020
#define PRODUCT_SERVER_FOUNDATION                   0x00000021
#define PRODUCT_HOME_PREMIUM_SERVER                 0x00000022
#define PRODUCT_SERVER_FOR_SMALLBUSINESS_V          0x00000023
#define PRODUCT_STANDARD_SERVER_V                   0x00000024
#define PRODUCT_DATACENTER_SERVER_V                 0x00000025
#define PRODUCT_ENTERPRISE_SERVER_V                 0x00000026
#define PRODUCT_DATACENTER_SERVER_CORE_V            0x00000027
#define PRODUCT_STANDARD_SERVER_CORE_V              0x00000028
#define PRODUCT_ENTERPRISE_SERVER_CORE_V            0x00000029
#define PRODUCT_HYPERV                              0x0000002A
#define PRODUCT_STORAGE_EXPRESS_SERVER_CORE         0x0000002B
#define PRODUCT_STORAGE_STANDARD_SERVER_CORE        0x0000002C
#define PRODUCT_STORAGE_WORKGROUP_SERVER_CORE       0x0000002D
#define PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE      0x0000002E
#define PRODUCT_STARTER_N                           0x0000002F
#define PRODUCT_PROFESSIONAL                        0x00000030
#define PRODUCT_PROFESSIONAL_N                      0x00000031
#define PRODUCT_SB_SOLUTION_SERVER                  0x00000032
#define PRODUCT_SERVER_FOR_SB_SOLUTIONS             0x00000033
#define PRODUCT_STANDARD_SERVER_SOLUTIONS           0x00000034
#define PRODUCT_STANDARD_SERVER_SOLUTIONS_CORE      0x00000035
#define PRODUCT_SB_SOLUTION_SERVER_EM               0x00000036
#define PRODUCT_SERVER_FOR_SB_SOLUTIONS_EM          0x00000037
#define PRODUCT_SOLUTION_EMBEDDEDSERVER             0x00000038
#define PRODUCT_SOLUTION_EMBEDDEDSERVER_CORE        0x00000039
#define PRODUCT_ESSENTIALBUSINESS_SERVER_MGMT       0x0000003B
#define PRODUCT_ESSENTIALBUSINESS_SERVER_ADDL       0x0000003C
#define PRODUCT_ESSENTIALBUSINESS_SERVER_MGMTSVC    0x0000003D
#define PRODUCT_ESSENTIALBUSINESS_SERVER_ADDLSVC    0x0000003E
#define PRODUCT_SMALLBUSINESS_SERVER_PREMIUM_CORE   0x0000003F
#define PRODUCT_CLUSTER_SERVER_V                    0x00000040
#define PRODUCT_EMBEDDED                            0x00000041
#define PRODUCT_STARTER_E                           0x00000042
#define PRODUCT_HOME_BASIC_E                        0x00000043
#define PRODUCT_HOME_PREMIUM_E                      0x00000044
#define PRODUCT_PROFESSIONAL_E                      0x00000045
#define PRODUCT_ENTERPRISE_E                        0x00000046
#define PRODUCT_ULTIMATE_E                          0x00000047
#define PRODUCT_UNLICENSED                          0xABCDABCD

/* Language identifiers */
#define LANG_NEUTRAL            0x00
#define LANG_INVARIANT          0x7F
#define LANG_AFRIKAANS          0x36
#define LANG_ALBANIAN           0x1C
#define LANG_ALSATIAN           0x84
#define LANG_AMHARIC            0x5E
#define LANG_ARABIC             0x01
#define LANG_ARMENIAN           0x2B
#define LANG_ASSAMESE           0x4D
#define LANG_AZERI              0x2C
#define LANG_BASHKIR            0x6D
#define LANG_BASQUE             0x2D
#define LANG_BELARUSIAN         0x23
#define LANG_BENGALI            0x45
#define LANG_BRETON             0x7E
#define LANG_BULGARIAN          0x02
#define LANG_CATALAN            0x03
#define LANG_CHINESE            0x04
#define LANG_CORSICAN           0x83
#define LANG_CROATIAN           0x1A
#define LANG_CZECH              0x05
#define LANG_DANISH             0x06
#define LANG_DARI               0x8C
#define LANG_DIVEHI             0x65
#define LANG_DUTCH              0x13
#define LANG_ENGLISH            0x09
#define LANG_ESTONIAN           0x25
#define LANG_FAEROESE           0x38
#define LANG_FARSI              0x29
#define LANG_FILIPINO           0x64
#define LANG_FINNISH            0x0B
#define LANG_FRENCH             0x0C
#define LANG_FRISIAN            0x62
#define LANG_GALICIAN           0x56
#define LANG_GEORGIAN           0x37
#define LANG_GERMAN             0x07
#define LANG_GREEK              0x08
#define LANG_GREENLANDIC        0x6F
#define LANG_GUJARATI           0x47
#define LANG_HAUSA              0x68
#define LANG_HEBREW             0x0D
#define LANG_HINDI              0x39
#define LANG_HUNGARIAN          0x0E
#define LANG_ICELANDIC          0x0F
#define LANG_IGBO               0x70
#define LANG_INDONESIAN         0x21
#define LANG_INUKTITUT          0x5D
#define LANG_IRISH              0x3C
#define LANG_ITALIAN            0x10
#define LANG_JAPANESE           0x11
#define LANG_KANNADA            0x4B
#define LANG_KASHMIRI           0x60
#define LANG_KAZAK              0x3F
#define LANG_KHMER              0x53
#define LANG_KICHE              0x86
#define LANG_KINYARWANDA        0x87
#define LANG_KONKANI            0x57
#define LANG_KOREAN             0x12
#define LANG_KYRGYZ             0x40
#define LANG_LAO                0x54
#define LANG_LATVIAN            0x26
#define LANG_LITHUANIAN         0x27
#define LANG_LOWER_SORBIAN      0x2E
#define LANG_LUXEMBOURGISH      0x6E
#define LANG_MACEDONIAN         0x2F
#define LANG_MALAY              0x3E
#define LANG_MALAYALAM          0x4C
#define LANG_MALTESE            0x3A
#define LANG_MANIPURI           0x58
#define LANG_MAORI              0x81
#define LANG_MAPUDUNGUN         0x7A
#define LANG_MARATHI            0x4E
#define LANG_MOHAWK             0x7C
#define LANG_MONGOLIAN          0x50
#define LANG_NEPALI             0x61
#define LANG_NORWEGIAN          0x14
#define LANG_OCCITAN            0x82
#define LANG_ORIYA              0x48
#define LANG_PASHTO             0x63
#define LANG_PERSIAN            0x29
#define LANG_POLISH             0x15
#define LANG_PORTUGUESE         0x16
#define LANG_PUNJABI            0x46
#define LANG_QUECHUA            0x6B
#define LANG_ROMANIAN           0x18
#define LANG_ROMANSH            0x17
#define LANG_RUSSIAN            0x19
#define LANG_SAMI               0x3B
#define LANG_SANSKRIT           0x4F
#define LANG_SCOTTISH_GAELIC    0x91
#define LANG_SERBIAN            0x1A
#define LANG_SINDHI             0x59
#define LANG_SINHALESE          0x5B
#define LANG_SLOVAK             0x1B
#define LANG_SLOVENIAN          0x24
#define LANG_SOTHO              0x6C
#define LANG_SPANISH            0x0A
#define LANG_SWAHILI            0x41
#define LANG_SWEDISH            0x1D
#define LANG_SYRIAC             0x5A
#define LANG_TAJIK              0x28
#define LANG_TAMAZIGHT          0x5F
#define LANG_TAMIL              0x49
#define LANG_TATAR              0x44
#define LANG_TELUGU             0x4A
#define LANG_THAI               0x1E
#define LANG_TIBETAN            0x51
#define LANG_TIGRIGNA           0x73
#define LANG_TSWANA             0x32
#define LANG_TURKISH            0x1F
#define LANG_TURKMEN            0x42
#define LANG_UIGHUR             0x80
#define LANG_UKRAINIAN          0x22
#define LANG_UPPER_SORBIAN      0x2E
#define LANG_URDU               0x20
#define LANG_UZBEK              0x43
#define LANG_VIETNAMESE         0x2A
#define LANG_WELSH              0x52
#define LANG_WOLOF              0x88
#define LANG_XHOSA              0x34
#define LANG_YAKUT              0x85
#define LANG_YI                 0x78
#define LANG_YORUBA             0x6A
#define LANG_ZULU               0x35

/* Sublanguage identifiers */
#define SUBLANG_NEUTRAL                             0x00
#define SUBLANG_DEFAULT                             0x01
#define SUBLANG_SYS_DEFAULT                         0x02
#define SUBLANG_CUSTOM_DEFAULT                      0x03
#define SUBLANG_CUSTOM_UNSPECIFIED                  0x04
#define SUBLANG_UI_CUSTOM_DEFAULT                   0x05
#define SUBLANG_AFRIKAANS_SOUTH_AFRICA              0x01
#define SUBLANG_ALBANIAN_ALBANIA                    0x01
#define SUBLANG_ALSATIAN_FRANCE                     0x01
#define SUBLANG_AMHARIC_ETHIOPIA                    0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA                 0x01
#define SUBLANG_ARABIC_IRAQ                         0x02
#define SUBLANG_ARABIC_EGYPT                        0x03
#define SUBLANG_ARABIC_LIBYA                        0x04
#define SUBLANG_ARABIC_ALGERIA                      0x05
#define SUBLANG_ARABIC_MOROCCO                      0x06
#define SUBLANG_ARABIC_TUNISIA                      0x07
#define SUBLANG_ARABIC_OMAN                         0x08
#define SUBLANG_ARABIC_YEMEN                        0x09
#define SUBLANG_ARABIC_SYRIA                        0x0A
#define SUBLANG_ARABIC_JORDAN                       0x0B
#define SUBLANG_ARABIC_LEBANON                      0x0C
#define SUBLANG_ARABIC_KUWAIT                       0x0D
#define SUBLANG_ARABIC_UAE                          0x0E
#define SUBLANG_ARABIC_BAHRAIN                      0x0F
#define SUBLANG_ARABIC_QATAR                        0x10
#define SUBLANG_ARMENIAN_ARMENIA                    0x01
#define SUBLANG_ASSAMESE_INDIA                      0x01
#define SUBLANG_AZERI_LATIN                         0x01
#define SUBLANG_AZERI_CYRILLIC                      0x02
#define SUBLANG_BASHKIR_RUSSIA                      0x01
#define SUBLANG_BASQUE_BASQUE                       0x01
#define SUBLANG_BELARUSIAN_BELARUS                  0x01
#define SUBLANG_BENGALI                             0x01
#define SUBLANG_BENGALI_BANGLADESH                  0x02
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_LATIN    0x05
#define SUBLANG_BOSNIAN_BOSNIA_HERZEGOVINA_CYRILLIC 0x08
#define SUBLANG_BRETON_FRANCE                       0x01
#define SUBLANG_BULGARIAN_BULGARIA                  0x01
#define SUBLANG_CATALAN_CATALAN                     0x01
#define SUBLANG_CHINESE_TRADITIONAL                 0x01
#define SUBLANG_CHINESE_SIMPLIFIED                  0x02
#define SUBLANG_CHINESE_HONGKONG                    0x03
#define SUBLANG_CHINESE_SINGAPORE                   0x04
#define SUBLANG_CHINESE_MACAU                       0x05
#define SUBLANG_CORSICAN_FRANCE                     0x01
#define SUBLANG_CZECH_CZECH_REPUBLIC                0x01
#define SUBLANG_CROATIAN_CROATIA                    0x01
#define SUBLANG_CROATIAN_BOSNIA_HERZEGOVINA_LATIN   0x04
#define SUBLANG_DANISH_DENMARK                      0x01
#define SUBLANG_DARI_AFGHANISTAN                    0x01
#define SUBLANG_DIVEHI_MALDIVES                     0x01
#define SUBLANG_DUTCH                               0x01
#define SUBLANG_DUTCH_BELGIAN                       0x02
#define SUBLANG_ENGLISH_US                          0x01
#define SUBLANG_ENGLISH_UK                          0x02
#define SUBLANG_ENGLISH_AUS                         0x03
#define SUBLANG_ENGLISH_CAN                         0x04
#define SUBLANG_ENGLISH_NZ                          0x05
#define SUBLANG_ENGLISH_EIRE                        0x06
#define SUBLANG_ENGLISH_SOUTH_AFRICA                0x07
#define SUBLANG_ENGLISH_JAMAICA                     0x08
#define SUBLANG_ENGLISH_CARIBBEAN                   0x09
#define SUBLANG_ENGLISH_BELIZE                      0x0A
#define SUBLANG_ENGLISH_TRINIDAD                    0x0B
#define SUBLANG_ENGLISH_ZIMBABWE                    0x0C
#define SUBLANG_ENGLISH_PHILIPPINES                 0x0D
#define SUBLANG_ENGLISH_INDIA                       0x10
#define SUBLANG_ENGLISH_MALAYSIA                    0x11
#define SUBLANG_ENGLISH_SINGAPORE                   0x12
#define SUBLANG_ESTONIAN_ESTONIA                    0x01
#define SUBLANG_FAEROESE_FAROE_ISLANDS              0x01
#define SUBLANG_FILIPINO_PHILIPPINES                0x01
#define SUBLANG_FINNISH_FINLAND                     0x01
#define SUBLANG_FRENCH                              0x01
#define SUBLANG_FRENCH_BELGIAN                      0x02
#define SUBLANG_FRENCH_CANADIAN                     0x03
#define SUBLANG_FRENCH_SWISS                        0x04
#define SUBLANG_FRENCH_LUXEMBOURG                   0x05
#define SUBLANG_FRENCH_MONACO                       0x06
#define SUBLANG_FRISIAN_NETHERLANDS                 0x01
#define SUBLANG_GALICIAN_GALICIAN                   0x01
#define SUBLANG_GEORGIAN_GEORGIA                    0x01
#define SUBLANG_GERMAN                              0x01
#define SUBLANG_GERMAN_SWISS                        0x02
#define SUBLANG_GERMAN_AUSTRIAN                     0x03
#define SUBLANG_GERMAN_LUXEMBOURG                   0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN                0x05
#define SUBLANG_GREEK_GREECE                        0x01
#define SUBLANG_GREENLANDIC_GREENLAND               0x01
#define SUBLANG_GUJARATI_INDIA                      0x01
#define SUBLANG_HAUSA_NIGERIA_LATIN                 0x01
#define SUBLANG_HEBREW_ISRAEL                       0x01
#define SUBLANG_HINDI_INDIA                         0x01
#define SUBLANG_HUNGARIAN_HUNGARY                   0x01
#define SUBLANG_ICELANDIC_ICELAND                   0x01
#define SUBLANG_IGBO_NIGERIA                        0x01
#define SUBLANG_INDONESIAN_INDONESIA                0x01
#define SUBLANG_INUKTITUT_CANADA                    0x01
#define SUBLANG_INUKTITUT_CANADA_LATIN              0x02
#define SUBLANG_IRISH_IRELAND                       0x01
#define SUBLANG_ITALIAN                             0x01
#define SUBLANG_ITALIAN_SWISS                       0x02
#define SUBLANG_JAPANESE_JAPAN                      0x01
#define SUBLANG_KANNADA_INDIA                       0x01
#define SUBLANG_KASHMIRI_SASIA                      0x02
#define SUBLANG_KASHMIRI_INDIA                      0x02
#define SUBLANG_KAZAK_KAZAKHSTAN                    0x01
#define SUBLANG_KHMER_CAMBODIA                      0x01
#define SUBLANG_KICHE_GUATEMALA                     0x01
#define SUBLANG_KINYARWANDA_RWANDA                  0x01
#define SUBLANG_KONKANI_INDIA                       0x01
#define SUBLANG_KOREAN                              0x01
#define SUBLANG_KYRGYZ_KYRGYZSTAN                   0x01
#define SUBLANG_LAO_LAO                             0x01
#define SUBLANG_LATVIAN_LATVIA                      0x01
#define SUBLANG_LITHUANIAN                          0x01
#define SUBLANG_LOWER_SORBIAN_GERMANY               0x02
#define SUBLANG_LUXEMBOURGISH_LUXEMBOURG            0x01
#define SUBLANG_MACEDONIAN_MACEDONIA                0x01
#define SUBLANG_MALAY_MALAYSIA                      0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM             0x02
#define SUBLANG_MALAYALAM_INDIA                     0x01
#define SUBLANG_MALTESE_MALTA                       0x01
#define SUBLANG_MAORI_NEW_ZEALAND                   0x01
#define SUBLANG_MAPUDUNGUN_CHILE                    0x01
#define SUBLANG_MARATHI_INDIA                       0x01
#define SUBLANG_MOHAWK_MOHAWK                       0x01
#define SUBLANG_MONGOLIAN_CYRILLIC_MONGOLIA         0x01
#define SUBLANG_MONGOLIAN_PRC                       0x02
#define SUBLANG_NEPALI_INDIA                        0x02
#define SUBLANG_NEPALI_NEPAL                        0x01
#define SUBLANG_NORWEGIAN_BOKMAL                    0x01
#define SUBLANG_NORWEGIAN_NYNORSK                   0x02
#define SUBLANG_OCCITAN_FRANCE                      0x01
#define SUBLANG_ORIYA_INDIA                         0x01
#define SUBLANG_PASHTO_AFGHANISTAN                  0x01
#define SUBLANG_PERSIAN_IRAN                        0x01
#define SUBLANG_POLISH_POLAND                       0x01
#define SUBLANG_PORTUGUESE                          0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN                0x01
#define SUBLANG_PUNJABI_INDIA                       0x01
#define SUBLANG_QUECHUA_BOLIVIA                     0x01
#define SUBLANG_QUECHUA_ECUADOR                     0x02
#define SUBLANG_QUECHUA_PERU                        0x03
#define SUBLANG_ROMANIAN_ROMANIA                    0x01
#define SUBLANG_ROMANSH_SWITZERLAND                 0x01
#define SUBLANG_RUSSIAN_RUSSIA                      0x01
#define SUBLANG_SAMI_NORTHERN_NORWAY                0x01
#define SUBLANG_SAMI_NORTHERN_SWEDEN                0x02
#define SUBLANG_SAMI_NORTHERN_FINLAND               0x03
#define SUBLANG_SAMI_LULE_NORWAY                    0x04
#define SUBLANG_SAMI_LULE_SWEDEN                    0x05
#define SUBLANG_SAMI_SOUTHERN_NORWAY                0x06
#define SUBLANG_SAMI_SOUTHERN_SWEDEN                0x07
#define SUBLANG_SAMI_SKOLT_FINLAND                  0x08
#define SUBLANG_SAMI_INARI_FINLAND                  0x09
#define SUBLANG_SANSKRIT_INDIA                      0x01
#define SUBLANG_SCOTTISH_GAELIC                     0x01
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_LATIN    0x06
#define SUBLANG_SERBIAN_BOSNIA_HERZEGOVINA_CYRILLIC 0x07
#define SUBLANG_SERBIAN_MONTENEGRO_LATIN            0x0B
#define SUBLANG_SERBIAN_MONTENEGRO_CYRILLIC         0x0C
#define SUBLANG_SERBIAN_SERBIA_LATIN                0x09
#define SUBLANG_SERBIAN_SERBIA_CYRILLIC             0x0A
#define SUBLANG_SERBIAN_CROATIA                     0x01
#define SUBLANG_SERBIAN_LATIN                       0x02
#define SUBLANG_SERBIAN_CYRILLIC                    0x03
#define SUBLANG_SINDHI_INDIA                        0x01
#define SUBLANG_SINDHI_PAKISTAN                     0x02
#define SUBLANG_SINDHI_AFGHANISTAN                  0x02
#define SUBLANG_SINHALESE_SRI_LANKA                 0x01
#define SUBLANG_SOTHO_NORTHERN_SOUTH_AFRICA         0x01
#define SUBLANG_SLOVAK_SLOVAKIA                     0x01
#define SUBLANG_SLOVENIAN_SLOVENIA                  0x01
#define SUBLANG_SPANISH                             0x01
#define SUBLANG_SPANISH_MEXICAN                     0x02
#define SUBLANG_SPANISH_MODERN                      0x03
#define SUBLANG_SPANISH_GUATEMALA                   0x04
#define SUBLANG_SPANISH_COSTA_RICA                  0x05
#define SUBLANG_SPANISH_PANAMA                      0x06
#define SUBLANG_SPANISH_DOMINICAN_REPUBLIC          0x07
#define SUBLANG_SPANISH_VENEZUELA                   0x08
#define SUBLANG_SPANISH_COLOMBIA                    0x09
#define SUBLANG_SPANISH_PERU                        0x0A
#define SUBLANG_SPANISH_ARGENTINA                   0x0B
#define SUBLANG_SPANISH_ECUADOR                     0x0C
#define SUBLANG_SPANISH_CHILE                       0x0D
#define SUBLANG_SPANISH_URUGUAY                     0x0E
#define SUBLANG_SPANISH_PARAGUAY                    0x0F
#define SUBLANG_SPANISH_BOLIVIA                     0x10
#define SUBLANG_SPANISH_EL_SALVADOR                 0x11
#define SUBLANG_SPANISH_HONDURAS                    0x12
#define SUBLANG_SPANISH_NICARAGUA                   0x13
#define SUBLANG_SPANISH_PEUTRO_RICO                 0x14
#define SUBLANG_SPANISH_US                          0x15
#define SUBLANG_SWAHILI_KENYA                       0x01
#define SUBLANG_SWEDISH                             0x01
#define SUBLANG_SWEDISH_FINLAND                     0x02
#define SUBLANG_SYRIAC_SYRIA                        0x01
#define SUBLANG_TAJIK_TAJIKISTAN                    0x01
#define SUBLANG_TAMAZIGHT_ALGERIA_LATIN             0x02
#define SUBLANG_TAMIL_INDIA                         0x01
#define SUBLANG_TATAR_RUSSIA                        0x01
#define SUBLANG_TELUGU_INDIA                        0x01
#define SUBLANG_THAI_THAILAND                       0x01
#define SUBLANG_TIBETAN_PRC                         0x01
#define SUBLANG_TIRGIGNA_ERITREA                    0x02
#define SUBLANG_TSWANA_SOUTH_AFRICA                 0x01
#define SUBLANG_TURKISH_TURKEY                      0x01
#define SUBLANG_TURKMEN_TURKMENISTAN                0x01
#define SUBLANG_UIGHUR_PRC                          0x01
#define SUBLANG_UKRAINIAN_UKRAINE                   0x01
#define SUBLANG_UPPER_SORBIAN_GERMANY               0x01
#define SUBLANG_URDU_PAKISTAN                       0x01
#define SUBLANG_URDU_INDIA                          0x02
#define SUBLANG_UZBEK_LATIN                         0x01
#define SUBLANG_UZBEK_CYRILLIC                      0x02
#define SUBLANG_VIETNAMESE_VIETNAM                  0x01
#define SUBLANG_WELSH_UNITED_KINGDOM                0x01
#define SUBLANG_WOLOF_SENEGAL                       0x01
#define SUBLANG_XHOSA_SOUTH_AFRICA                  0x01
#define SUBLANG_YAKUT_RUSSIA                        0x01
#define SUBLANG_YI_PRC                              0x01
#define SUBLANG_YURUBA_NIGERIA                      0x01
#define SUBLANG_ZULU_SOUTH_AFRICA                   0x01

/* Sort identifiers */
#define SORT_DEFAULT                0x0
#define SORT_INVARIANT_MATH         0x1
#define SORT_JAPANESE_XJIS          0x0
#define SORT_JAPANESE_UNICODE       0x1
#define SORT_JAPANESE_RADICALSTROKE 0x4
#define SORT_CHINESE_BIG5           0x0
#define SORT_CHINESE_PRCP           0x0
#define SORT_CHINESE_UNICODE        0x1
#define SORT_CHINESE_PRC            0x2
#define SORT_CHINESE_BOPOMOFO       0x3
#define SORT_CHINESE_RADICALSTROKE  0x4
#define SORT_KOREAN_KSC             0x0
#define SORT_KOREAN_UNICODE         0x1
#define SORT_GERMAN_PHONE_BOOK      0x1
#define SORT_HUNGARIAN_DEFAULT      0x0
#define SORT_HUNGARIAN_TECHNICAL    0x1
#define SORT_GEORGIAN_TRADITIONAL   0x0
#define SORT_GEORGIAN_MODERN        0x1

/* Default languages identifiers */
#define LANG_SYSTEM_DEFAULT MAKELANGID( LANG_NEUTRAL, SUBLANG_SYS_DEFAULT )
#define LANG_USER_DEFAULT   MAKELANGID( LANG_NEUTRAL, SUBLANG_DEFAULT )

/* Default locale identifiers */
#define LOCALE_SYSTEM_DEFAULT   MAKELCID( LANG_SYSTEM_DEFAULT, SORT_DEFAULT )
#define LOCALE_USER_DEFAULT     MAKELCID( LANG_USER_DEFAULT, SORT_DEFAULT )
#define LOCALE_CUSTOM_DEFAULT \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_CUSTOM_DEFAULT ), SORT_DEFAULT )
#define LOCALE_CUSTOM_UNSPECIFIED \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_CUSTOM_UNSPECIFIED ), SORT_DEFAULT )
#define LOCALE_CUSTOM_UI_DEFAULT \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_UI_CUSTOM_DEFAULT ), SORT_DEFAULT )
#define LOCALE_NEUTRAL \
    MAKELCID( MAKELANGID( LANG_NEUTRAL, SUBLANG_NEUTRAL ), SORT_DEFAULT )
#define LOCALE_INVARIANT \
    MAKELCID( MAKELANGID( LANG_INVARIANT, SUBLANG_NEUTRAL ), SORT_DEFAULT )

/* Maximum locale name length */
#define LOCALE_NAME_MAX_LENGTH  85

/* Language identifiers for use with ConvertDefaultLocale() */
#define LANG_BOSNIAN_NEUTRAL        0x781A
#define LANG_CHINESE_SIMPLIFIED     0x0004
#define LANG_CHINESE_TRADITIONAL    0x7C04
#define LANG_SERBIAN_NEUTRAL        0x7C1A

/* Unreferenced parameter macros */
#define UNREFERENCED_PARAMETER( x )             ((void)(x))
#define DBG_UNREFERENCED_PARAMETER( x )         ((void)(x))
#define DBG_UNREFERENCED_LOCAL_VARIABLE( x )    ((void)(x))

/* Status codes */
#define STATUS_WAIT_0                       0x00000000L
#define STATUS_ABANDONED_WAIT_0             0x00000080L
#define STATUS_USER_APC                     0x000000C0L
#define STATUS_TIMEOUT                      0x00000102L
#define STATUS_PENDING                      0x00000103L
#define DBG_EXCEPTION_HANDLED               0x00010001L
#define DBG_CONTINUE                        0x00010002L
#define STATUS_SEGMENT_NOTIFICATION         0x40000005L
#define DBG_TERMINATE_THREAD                0x40010003L
#define DBG_TERMINATE_PROCESS               0x40010004L
#define DBG_CONTROL_C                       0x40010005L
#define DBG_PRINTEXCEPTION_C                0x40010006L
#define DBG_RIPEXCEPTION                    0x40010007L
#define DBG_CONTROL_BREAK                   0x40010008L
#define DBG_COMMAND_EXCEPTION               0x40010009L
#define STATUS_GUARD_PAGE_VIOLATION         0x80000001L
#define STATUS_DATATYPE_MISALIGNMENT        0x80000002L
#define STATUS_BREAKPOINT                   0x80000003L
#define STATUS_SINGLE_STEP                  0x80000004L
#define STATUS_LONGJMP                      0x80000026L
#define STATUS_UNWIND_CONSOLIDATE           0x80000029L
#define DBG_EXCEPTION_NOT_HANDLED           0x80010001L
#define STATUS_ACCESS_VIOLATION             0xC0000005L
#define STATUS_IN_PAGE_ERROR                0xC0000006L
#define STATUS_INVALID_HANDLE               0xC0000008L
#define STATUS_INVALID_PARAMETER            0xC000000DL
#define STATUS_NO_MEMORY                    0xC0000017L
#define STATUS_ILLEGAL_INSTRUCTION          0xC000001DL
#define STATUS_NONCONTINUABLE_EXCEPTION     0xC0000025L
#define STATUS_INVALID_DISPOSITION          0xC0000026L
#define STATUS_ARRAY_BOUNDS_EXCEEDED        0xC000008CL
#define STATUS_FLOAT_DENORMAL_OPERAND       0xC000008DL
#define STATUS_FLOAT_DIVIDE_BY_ZERO         0xC000008EL
#define STATUS_FLOAT_INEXACT_RESULT         0xC000008FL
#define STATUS_FLOAT_INVALID_OPERATION      0xC0000090L
#define STATUS_FLOAT_OVERFLOW               0xC0000091L
#define STATUS_FLOAT_STACK_CHECK            0xC0000092L
#define STATUS_FLOAT_UNDERFLOW              0xC0000093L
#define STATUS_INTEGER_DIVIDE_BY_ZERO       0xC0000094L
#define STATUS_INTEGER_OVERFLOW             0xC0000095L
#define STATUS_PRIVILEGED_INSTRUCTION       0xC0000096L
#define STATUS_STACK_OVERFLOW               0xC00000FDL
#define STATUS_DLL_NOT_FOUND                0xC0000135L
#define STATUS_ORDINAL_NOT_FOUND            0xC0000138L
#define STATUS_ENTRYPOINT_NOT_FOUND         0xC0000139L
#define STATUS_CONTROL_C_EXIT               0xC000013AL
#define STATUS_DLL_INIT_FAILED              0xC0000142L
#define STATUS_FLOAT_MULTIPLE_FAULTS        0xC00002B4L
#define STATUS_FLOAT_MULTIPLE_TRAPS         0xC00002B5L
#define STATUS_REG_NAT_CONSUMPTION          0xC00002C9L
#define STATUS_STACK_BUFFER_OVERRUN         0xC0000409L
#define STATUS_INVALID_CRUNTIME_PARAMETER   0xC0000417L
#define STATUS_ASSERTION_FAILURE            0xC0000420L
#define STATUS_SXS_EARLY_DEACTIVATION       0xC015000FL
#define STATUS_SXS_INVALID_DEACTIVATION     0xC0150010L

/* Maximum values */
#define MAXIMUM_WAIT_OBJECTS    64
#define MAXIMUM_SUSPEND_COUNT   MAXCHAR

/* Size of the 80387 registers in the x86 context record */
#ifdef _X86_
    #define SIZE_OF_80387_REGISTERS 80
#endif

/* Context flags for the x86 processor */
#ifdef _X86_
    #define CONTEXT_i386                0x00010000L
    #define CONTEXT_i486                0x00010000L
    #define CONTEXT_CONTROL             (CONTEXT_i386 | 0x00000001L)
    #define CONTEXT_INTEGER             (CONTEXT_i386 | 0x00000002L)
    #define CONTEXT_SEGMENTS            (CONTEXT_i386 | 0x00000004L)
    #define CONTEXT_FLOATING_POINT      (CONTEXT_i386 | 0x00000008L)
    #define CONTEXT_DEBUG_REGISTERS     (CONTEXT_i386 | 0x00000010L)
    #define CONTEXT_EXTENDED_REGISTERS  (CONTEXT_i386 | 0x00000020L)
    #define CONTEXT_XSTATE              (CONTEXT_i386 | 0x00000040L)
    #define CONTEXT_FULL \
        (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS)
    #define CONTEXT_ALL  \
        (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS | \
        CONTEXT_FLOATING_POINT | CONTEXT_DEBUG_REGISTERS | \
        CONTEXT_EXTENDED_REGISTERS)
#endif

/* Size of the extended registers in the x86 context record */
#ifdef _X86_
    #define MAXIMUM_SUPPORTED_EXTENSION 512
#endif

/* Context flags for the Alpha processor */
#ifdef _ALPHA_
    #define CONTEXT_ALPHA           0x00020000L
    #define CONTEXT_PORTABLE_32BIT  0x00100000L
    #define CONTEXT_CONTROL         (CONTEXT_ALPHA | 0x00000001L)
    #define CONTEXT_FLOATING_POINT  (CONTEXT_ALPHA | 0x00000002L)
    #define CONTEXT_INTEGER         (CONTEXT_ALPHA | 0x00000004L)
    #define CONTEXT_FULL \
        (CONTEXT_CONTROL | CONTEXT_FLOATING_POINT | CONTEXT_INTEGER)
#endif

/* WOW64 context flags */
#define WOW64_CONTEXT_i386                  0x00010000L
#define WOW64_CONTEXT_i486                  0x00010000L
#define WOW64_CONTEXT_CONTROL               (WOW64_CONTEXT_i386 | 0x00000001L)
#define WOW64_CONTEXT_INTEGER               (WOW64_CONTEXT_i386 | 0x00000002L)
#define WOW64_CONTEXT_SEGMENTS              (WOW64_CONTEXT_i386 | 0x00000004L)
#define WOW64_CONTEXT_FLOATING_POINT        (WOW64_CONTEXT_i386 | 0x00000008L)
#define WOW64_CONTEXT_DEBUG_REGISTERS       (WOW64_CONTEXT_i386 | 0x00000010L)
#define WOW64_CONTEXT_EXTENDED_REGISTERS    (WOW64_CONTEXT_i386 | 0x00000020L)
#define WOW64_CONTEXT_XSTATE                (WOW64_CONTEXT_i386 | 0x00000040L)
#define WOW64_CONTEXT_FULL \
    (WOW64_CONTEXT_CONTROL | WOW64_CONTEXT_INTEGER | WOW64_CONTEXT_SEGMENTS)
#define WOW64_CONTEXT_ALL \
    (WOW64_CONTEXT_CONTROL | WOW64_CONTEXT_INTEGER | WOW64_CONTEXT_SEGMENTS \
    WOW64_CONTEXT_FLOATING_POINT | WOW64_CONTEXT_DEBUG_REGISTERS | \
    WOW64_CONTEXT_EXTENDED_REGISTERS)

/* Size of the 80387 registers in the WOW64 context record */
#define WOW64_SIZE_OF_80387_REGISTERS   80

/* Size of the extended registers in the WOW64 context record */
#define WOW64_MAXIMUM_SUPPORTED_EXTENSION   512

/* Exception flags */
#define EXCEPTION_NONCONTINUABLE    0x00000001L

/* Maximum number of exception parameters */
#define EXCEPTION_MAXIMUM_PARAMETERS    15

/* Standard access rights */
#define DELETE                      0x00010000L
#define READ_CONTROL                0x00020000L
#define WRITE_DAC                   0x00040000L
#define WRITE_OWNER                 0x00080000L
#define SYNCHRONIZE                 0x00100000L
#define STANDARD_RIGHTS_REQUIRED    0x000F0000L
#define STANDARD_RIGHTS_READ        READ_CONTROL
#define STANDARD_RIGHTS_WRITE       READ_CONTROL
#define STANDARD_RIGHTS_EXECUTE     READ_CONTROL
#define STANDARD_RIGHTS_ALL         0x001F0000L
#define SPECIFIC_RIGHTS_ALL         0x0000FFFFL
#define ACCESS_SYSTEM_SECURITY      0x01000000L
#define MAXIMUM_ALLOWED             0x02000000L
#define GENERIC_READ                0x80000000L
#define GENERIC_WRITE               0x40000000L
#define GENERIC_EXECUTE             0x20000000L
#define GENERIC_ALL                 0x10000000L

/* Current SID revision */
#define SID_REVISION    1

/* Maximum and recommended numbers of subauthorities */
#define SID_MAX_SUB_AUTHORITIES         15
#define SID_RECOMMENDED_SUB_AUTHORITIES 1

/* SID hash size */
#define SID_HASH_SIZE   32

/* SID identifier authority values */
#define SECURITY_NULL_SID_AUTHORITY         { 0, 0, 0, 0, 0, 0 }
#define SECURITY_WORLD_SID_AUTHORITY        { 0, 0, 0, 0, 0, 1 }
#define SECURITY_LOCAL_SID_AUTHORITY        { 0, 0, 0, 0, 0, 2 }
#define SECURITY_CREATOR_SID_AUTHORITY      { 0, 0, 0, 0, 0, 3 }
#define SECURITY_NON_UNIQUE_AUTHORITY       { 0, 0, 0, 0, 0, 4 }
#define SECURITY_NT_AUTHORITY               { 0, 0, 0, 0, 0, 5 }
#define SECURITY_RESOURCE_MANAGER_AUTHORITY { 0, 0, 0, 0, 0, 9 }
#define SECURITY_MANDATORY_LABEL_AUTHORITY  { 0, 0, 0, 0, 0, 16 }

/* Relative identifiers */
#define SECURITY_NULL_RID                               0x00000000L
#define SECURITY_WORLD_RID                              0x00000000L
#define SECURITY_LOCAL_RID                              0x00000000L
#define SECURITY_LOCAL_LOGON_RID                        0x00000001L
#define SECURITY_CREATOR_OWNER_RID                      0x00000000L
#define SECURITY_CREATOR_GROUP_RID                      0x00000001L
#define SECURITY_CREATOR_OWNER_SERVER_RID               0x00000002L
#define SECURITY_CREATOR_GROUP_SERVER_RID               0x00000003L
#define SECURITY_CREATOR_OWNER_RIGHTS_RID               0x00000004L
#define SECURITY_DIALUP_RID                             0x00000001L
#define SECURITY_NETWORK_RID                            0x00000002L
#define SECURITY_BATCH_RID                              0x00000003L
#define SECURITY_INTERACTIVE_RID                        0x00000004L
#define SECURITY_LOGON_IDS_RID                          0x00000005L
#define SECURITY_SERVICE_RID                            0x00000006L
#define SECURITY_ANONYMOUS_LOGON_RID                    0x00000007L
#define SECURITY_PROXY_RID                              0x00000008L
#define SECURITY_ENTERPRISE_CONTROLLERS_RID             0x00000009L
#define SECURITY_SERVER_LOGON_RID \
    SECURITY_ENTERPRISE_CONTROLLERS_RID
#define SECURITY_PRINCIPAL_SELF_RID                     0x0000000AL
#define SECURITY_AUTHENTICATED_USER_RID                 0x0000000BL
#define SECURITY_RESTRICTED_CODE_RID                    0x0000000CL
#define SECURITY_TERMINAL_SERVER_RID                    0x0000000DL
#define SECURITY_REMOTE_LOGON_RID                       0x0000000EL
#define SECURITY_THIS_ORGANIZATION_RID                  0x0000000FL
#define SECURITY_IUSER_RID                              0x00000011L
#define SECURITY_LOCAL_SYSTEM_RID                       0x00000012L
#define SECURITY_LOCAL_SERVICE_RID                      0x00000013L
#define SECURITY_NETWORK_SERVICE_RID                    0x00000014L
#define SECURITY_NT_NON_UNIQUE                          0x00000015L
#define SECURITY_ENTERPRISE_READONLY_CONTROLLERS_RID    0x00000016L
#define SECURITY_BUILTIN_DOMAIN_RID                     0x00000020L
#define SECURITY_WRITE_RESTRICTED_CODE_RID              0x00000021L
#define SECURITY_PACKAGE_BASE_RID                       0x00000040L
#define SECURITY_PACKAGE_NTLM_RID                       0x0000000AL
#define SECURITY_PACKAGE_SCHANNEL_RID                   0x0000000EL
#define SECURITY_PACKAGE_DIGEST_RID                     0x00000015L
#define SECURITY_CRED_TYPE_BASE_RID                     0x00000041L
#define SECURITY_CRED_TYPE_THIS_ORG_CERT_RID            0x00000001L
#define SECURITY_MIN_BASE_RID                           0x00000050L
#define SECURITY_SERVICE_ID_BASE_RID                    0x00000050L
#define SECURITY_RESERVED_ID_BASE_RID                   0x00000051L
#define SECURITY_APPPOOL_ID_BASE_RID                    0x00000052L
#define SECURITY_VIRTUALSERVER_ID_BASE_RID              0x00000053L
#define SECURITY_USERMODEDRIVERHOST_ID_BASE_RID         0x00000054L
#define SECURITY_CLOUD_INFRASTRUCTURE_SERVICES_ID_BASE_RID  0x00000055L
#define SECURITY_WMIHOST_ID_BASE_RID                    0x00000056L
#define SECURITY_TASK_ID_BASE_RID                       0x00000057L
#define SECURITY_NFS_ID_BASE_RID                        0x00000058L
#define SECURITY_COM_ID_BASE_RID                        0x00000059L
#define SECURITY_MAX_BASE_RID                           0x0000006FL
#define SECURITY_MAX_ALWAYS_FITLERED                    0x000003E7L
#define SECURITY_MIN_NEVER_FILTERED                     0x000003E8L
#define SECURITY_OTHER_ORGANIZATION_RID                 0x000003E8L
#define SECURITY_WINDOWSMOBILE_ID_BASE_RID              0x00000070L
#define SECURITY_MANDATORY_UNTRUSTED_RID                0x00000000L
#define SECURITY_MANDATORY_LOW_RID                      0x00001000L
#define SECURITY_MANDATORY_MEDIUM_RID                   0x00002000L
#define SECURITY_MANDATORY_MEDIUM_PLUS_RID \
    (SECURITY_MANDATORY_MEDIUM_RID + 0x00000100L)
#define SECURITY_MANDATORY_HIGH_RID                     0x00003000L
#define SECURITY_MANDATORY_SYSTEM_RID                   0x00004000L
#define SECURITY_MANDATORY_PROTECTED_PROCESS_RID        0x00005000L
#define SECURITY_MANDATORY_MAXIMUM_USER_RID \
    SECURITY_MANDATORY_SYSTEM_RID

/* Relative identifier counts */
#define SECURITY_LOGON_IDS_RID_COUNT                        3L
#define SECURITY_NT_NON_UNIQUE_SUB_AUTH_COUNT               3L
#define SECURITY_PACKAGE_RID_COUNT                          2L
#define SECURITY_CRED_TYPE_RID_COUNT                        2L
#define SECURITY_SERVICE_ID_RID_COUNT                       6L
#define SECURITY_APPPOOL_ID_RID_COUNT                       6L
#define SECURITY_VIRTUALSERVER_ID_RID_COUNT                 6L
#define SECURITY_USERMODEDRIVERHOST_ID_RID_COUNT            6L
#define SECURITY_CLOUD_INFRASTRUCTURE_SERVICES_ID_RID_COUNT 6L
#define SECURITY_WMIHOST_ID_RID_COUNT                       6L
#define SECURITY_VIRTUALACCOUNT_ID_RID_COUNT                6L

/* Well-known users */
#define FOREST_USER_RID_MAX     0x000001F3L
#define DOMAIN_USER_RID_ADMIN   0x000001F4L
#define DOMAIN_USER_RID_GUEST   0x000001F5L
#define DOMAIN_USER_RID_KRBTGT  0x000001F6L
#define DOMAIN_USER_RID_MAX     0x000003E7L

/* Well-known groups */
#define DOMAIN_GROUP_RID_ADMINS                 0x00000200L
#define DOMAIN_GROUP_RID_USERS                  0x00000201L
#define DOMAIN_GROUP_RID_GUESTS                 0x00000202L
#define DOMAIN_GROUP_RID_COMPUTERS              0x00000203L
#define DOMAIN_GROUP_RID_CONTROLLERS            0x00000204L
#define DOMAIN_GROUP_RID_CERT_ADMINS            0x00000205L
#define DOMAIN_GROUP_RID_SCHEMA_ADMINS          0x00000206L
#define DOMAIN_GROUP_RID_ENTERPRISE_ADMINS      0x00000207L
#define DOMAIN_GROUP_RID_POLICY_ADMINS          0x00000208L
#define DOMAIN_GROUP_RID_READONLY_CONTROLLERS   0x00000209L
#define DOMAIN_GROUP_RID_ENTERPRISE_READONLY_DOMAIN_CONTROLLERS 0x000001F2L

/* Well-known aliases */
#define DOMAIN_ALIAS_RID_ADMINS                         0x00000220L
#define DOMAIN_ALIAS_RID_USERS                          0x00000221L
#define DOMAIN_ALIAS_RID_GUESTS                         0x00000222L
#define DOMAIN_ALIAS_RID_POWER_USERS                    0x00000223L
#define DOMAIN_ALIAS_RID_ACCOUNT_OPS                    0x00000224L
#define DOMAIN_ALIAS_RID_SYSTEM_OPS                     0x00000225L
#define DOMAIN_ALIAS_RID_PRINT_OPS                      0x00000226L
#define DOMAIN_ALIAS_RID_BACKUP_OPS                     0x00000227L
#define DOMAIN_ALIAS_RID_REPLICATOR                     0x00000228L
#define DOMAIN_ALIAS_RID_RAS_SERVERS                    0x00000229L
#define DOMAIN_ALIAS_RID_PREW2KCOMPACCESS               0x0000022AL
#define DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS           0x0000022BL
#define DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS      0x0000022CL
#define DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS 0x0000022DL
#define DOMAIN_ALIAS_RID_MONITORING_USERS               0x0000022EL
#define DOMAIN_ALIAS_RID_LOGGING_USERS                  0x0000022FL
#define DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS            0x00000230L
#define DOMAIN_ALIAS_RID_TS_LICENSE_SERVERS             0x00000231L
#define DOMAIN_ALIAS_RID_DCOM_USERS                     0x00000232L
#define DOMAIN_ALIAS_RID_IUSERS                         0x00000238L
#define DOMAIN_ALIAS_RID_CRYPTO_OPERATORS               0x00000239L
#define DOMAIN_ALIAS_RID_CACHEABLE_PRINCIPALS_GROUP     0x0000023BL
#define DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP 0x0000023CL
#define DOMAIN_ALIAS_RID_EVENT_LOG_READERS_GROUP        0x0000023DL
#define DOMAIN_ALIAS_RID_CERTSVC_DCOM_ACCESS_GROUP      0x0000023EL

/* Predefined system LUID values */
#define SYSTEM_LUID             { 0x000003E7, 0x00000000 }
#define ANONYMOUS_LOGON_LUID    { 0x000003E6, 0x00000000 }
#define LOCALSERVICE_LUID       { 0x000003E5, 0x00000000 }
#define NETWORKSERVICE_LUID     { 0x000003E4, 0x00000000 }

/* Group attributes */
#define SE_GROUP_MANDATORY          0x00000001L
#define SE_GROUP_ENABLED_BY_DEFAULT 0x00000002L
#define SE_GROUP_ENABLED            0x00000004L
#define SE_GROUP_OWNER              0x00000008L
#define SE_GROUP_USE_FOR_DENY_ONLY  0x00000010L
#define SE_GROUP_INTEGRITY          0x00000020L
#define SE_GROUP_INTEGRITY_ENABLED  0x00000040L
#define SE_GROUP_LOGON_ID           0xC0000000L
#define SE_GROUP_RESOURCE           0x20000000L
#define SE_GROUP_VALID_ATTRIBUTES \
    (SE_GROUP_MANDATORY | SE_GROUP_ENABLED_BY_DEFAULT | SE_GROUP_ENABLED | \
    SE_GROUP_OWNER | SE_GROUP_USE_FOR_DENY_ONLY | SE_GROUP_LOGON_ID | \
    SE_TGROUP_RESOURCE | SE_GROUP_INTEGRITY | SE_GROUP_INTEGRITY_ENABLED)

/* Current ACL revisions */
#define ACL_REVISION    2
#define ACL_REVISION_DS 4

/* All ACL revisions */
#define ACL_REVISION1       1
#define ACL_REVISION2       2
#define ACL_REVISION3       3
#define ACL_REVISION4       4
#define MIN_ACL_REVISION    ACL_REVISION2
#define MAX_ACL_REVISION    ACL_REVISION4

/* ACE types */
#define ACCESS_ALLOWED_ACE_TYPE                 0x00
#define ACCESS_DENIED_ACE_TYPE                  0x01
#define SYSTEM_AUDIT_ACE_TYPE                   0x02
#define SYSTEM_ALARM_ACE_TYPE                   0x03
#define ACCESS_ALLOWED_COMPOUND_ACE_TYPE        0x04
#define ACCESS_ALLOWED_OBJECT_ACE_TYPE          0x05
#define ACCESS_DENIED_OBJECT_ACE_TYPE           0x06
#define SYSTEM_AUDIT_OBJECT_ACE_TYPE            0x07
#define SYSTEM_ALARM_OBJECT_ACE_TYPE            0x08
#define ACCESS_ALLOWED_CALLBACK_ACE_TYPE        0x09
#define ACCESS_DENIED_CALLBACK_ACE_TYPE         0x0A
#define ACCESS_ALLOWED_CALLBACK_OBJECT_ACE_TYPE 0x0B
#define ACCESS_DENIED_CALLBACK_OBJECT_ACE_TYPE  0x0C
#define SYSTEM_AUDIT_CALLBACK_ACE_TYPE          0x0D
#define SYSTEM_ALARM_CALLBACK_ACE_TYPE          0x0E
#define SYSTEM_AUDIT_CALLBACK_OBJECT_ACE_TYPE   0x0F
#define SYSTEM_ALARM_CALLBACK_OBJECT_ACE_TYPE   0x10
#define SYSTEM_MANDATORY_LABEL_ACE_TYPE         0x11
#define ACCESS_MIN_MS_ACE_TYPE                  ACCESS_ALLOWED_ACE_TYPE
#define ACCESS_MAX_MS_ACE_TYPE                  SYSTEM_ALARM_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_V2_ACE_TYPE               SYSTEM_ALARM_ACE_TYPE
#define ACCESS_MAX_MS_V3_ACE_TYPE               ACCESS_ALLOWED_COMPOUND_ACE_TYPE
#define ACCESS_MAX_MS_V4_ACE_TYPE               SYSTEM_ALARM_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_V5_ACE_TYPE               SYSTEM_MANDATORY_LABEL_ACE_TYPE
#define ACCESS_MIN_MS_OBJECT_ACE_TYPE           ACCESS_ALLOWED_OBJECT_ACE_TYPE
#define ACCESS_MAX_MS_OBJECT_ACE_TYPE           SYSTEM_ALARM_OBJECT_ACE_TYPE

/* ACE inherit flags */
#define OBJECT_INHERIT_ACE          0x01
#define CONTAINER_INHERIT_ACE       0x02
#define NO_PROPAGATE_INHERIT_ACE    0x04
#define INHERIT_ONLY_ACE            0x08
#define INHERITED_ACE               0x10
#define VALID_INHERIT_FLAGS         0x1F

/* ACE flags */
#define SUCCESSFUL_ACCESS_ACE_FLAG  0x40
#define FAILED_ACCESS_ACE_FLAG      0x80

/* System mandatory label ACE access mask flags */
#define SYSTEM_MANDATORY_LABEL_NO_WRITE_UP      0x00000001L
#define SYSTEM_MANDATORY_LABEL_NO_READ_UP       0x00000002L
#define SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP    0x00000004L
#define SYSTEM_MANDATORY_LABEL_VALID_MASK \
    (SYSTEM_MANDATORY_LABEL_NO_WRITE_UP | SYSTEM_MANDATORY_LABEL_NO_READ_UP | \
    SYSTEM_MANDATORY_LABEL_NO_EXECUTE_UP)

/* Object ACE flags */
#define ACE_OBJECT_TYPE_PRESENT             0x00000001L
#define ACE_INHERITED_OBJECT_TYPE_PRESENT   0x00000002L

/* Current security descriptor revision */
#define SECURITY_DESCRIPTOR_REVISION    1

/* All security descriptor revisions */
#define SECURITY_DESCRIPTOR_REVISION1   1

/* Security descriptor control flags */
#define SE_OWNER_DEFAULTED          0x0001
#define SE_GROUP_DEFAULTED          0x0002
#define SE_DACL_PRESENT             0x0004
#define SE_DACL_DEFAULTED           0x0008
#define SE_SACL_PRESENT             0x0010
#define SE_SACL_DEFAULTED           0x0020
#define SE_DACL_AUTO_INHERIT_REQ    0x0100
#define SE_SACL_AUTO_INHERIT_REQ    0x0200
#define SE_DACL_AUTO_INHERITED      0x0400
#define SE_SACL_AUTO_INHERITED      0x0800
#define SE_DACL_PROTECTED           0x1000
#define SE_SACL_PROTECTED           0x2000
#define SE_RM_CONTROL_VALID         0x4000
#define SE_SELF_RELATIVE            0x8000

/* Object type list level values */
#define ACCESS_OBJECT_GUID          0
#define ACCESS_PROPERTY_SET_GUID    1
#define ACCESS_PROPERTY_GUID        2
#define ACCESS_MAX_LEVEL            4

/* Audit alarm flags */
#define AUDIT_ALLOW_NO_PRIVILEGE    0x00000001L

/* Privilege attributes */
#define SE_PRIVILEGE_ENABLED_BY_DEFAULT 0x00000001L
#define SE_PRIVILEGE_ENABLED            0x00000002L
#define SE_PRIVILEGE_REMOVED            0x00000004L
#define SE_PRIVILEGE_USED_FOR_ACCESS    0x00000008L
#define SE_PRIVILEGE_VALID_ATTRIBUTES \
    (SE_PRIVILEGE_ENABLED_BY_DEFAULT | SE_PRIVILEGE_ENABLED | \
    SE_PRIVILEGE_REMOVED | SE_PRIVLEGE_USED_FOR_ACCESS)

/* Privilege set control flags */
#define PRIVILEGE_SET_ALL_NECESSARY 1

/* Access reason masks */
#define ACCESS_REASON_TYPE_MASK 0xFFFF0000
#define ACCESS_REASON_DATA_MASK 0x0000FFFF

/* Security descriptor flags */
#define SE_SECURITY_DESCRIPTOR_FLAG_NO_OWNER_ACE    0x00000001L
#define SE_SECURITY_DESCRIPTOR_FLAG_NO_LABEL_ACE    0x00000002L
#define SE_SECURITY_DESCRIPTOR_VALID_FLAGS          0x00000003L

/* Privilege names */
#define SE_CREATE_TOKEN_NAME            TEXT("SeCreateTokenPrivilege")
#define SE_ASSIGNPRIMARYTOKEN_NAME      TEXT("SeAssignPrimaryTokenPrivilege")
#define SE_LOCK_MEMORY_NAME             TEXT("SeLockMemoryPrivilege")
#define SE_INCREASE_QUOTA_NAME          TEXT("SeIncreaseQuotaPrivilege")
#define SE_UNSOLICITED_INPUT_NAME       TEXT("SeUnsolicitedInputPrivilege")
#define SE_MACHINE_ACCOUNT_NAME         TEXT("SeMachineAccountPrivilege")
#define SE_TCB_NAME                     TEXT("SeTcbPrivilege")
#define SE_SECURITY_NAME                TEXT("SeSecurityPrivilege")
#define SE_TAKE_OWNERSHIP_NAME          TEXT("SeTakeOwnershipPrivilege")
#define SE_LOAD_DRIVER_NAME             TEXT("SeLoadDriverPrivilege")
#define SE_SYSTEM_PROFILE_NAME          TEXT("SeSystemProfilePrivilege")
#define SE_SYSTEMTIME_NAME              TEXT("SeSystemtimePrivilege")
#define SE_PROF_SINGLE_PROCESS_NAME     TEXT("SeProfileSingleProcessPrivilege")
#define SE_INC_BASE_PRIORITY_NAME       TEXT("SeIncreaseBasePriorityPrivilege")
#define SE_CREATE_PAGEFILE_NAME         TEXT("SeCreatePagefilePrivilege")
#define SE_CREATE_PERMANENT_NAME        TEXT("SeCreatePermanentPrivilege")
#define SE_BACKUP_NAME                  TEXT("SeBackupPrivilege")
#define SE_RESTORE_NAME                 TEXT("SeRestorePrivilege")
#define SE_SHUTDOWN_NAME                TEXT("SeShutdownPrivilege")
#define SE_DEBUG_NAME                   TEXT("SeDebugPrivilege")
#define SE_AUDIT_NAME                   TEXT("SeAuditPrivilege")
#define SE_SYSTEM_ENVIRONMENT_NAME      TEXT("SeSystemEnvironmentPrivilege")
#define SE_CHANGE_NOTIFY_NAME           TEXT("SeChangeNotifyPrivilege")
#define SE_REMOTE_SHUTDOWN_NAME         TEXT("SeRemoteShutdownPrivilege")
#define SE_UNDOCK_NAME                  TEXT("SeUndockPrivilege")
#define SE_SYNC_AGENT_NAME              TEXT("SeSyncAgentPrivilege")
#define SE_ENABLE_DELEGATION_NAME       TEXT("SeEnableDelegationPrivilege")
#define SE_MANAGE_VOLUME_NAME           TEXT("SeManageVolumePrivilege")
#define SE_IMPERSONATE_NAME             TEXT("SeImpersonatePrivilege")
#define SE_CREATE_GLOBAL_NAME           TEXT("SeCreateGlobalPrivilege")
#define SE_TRUSTED_CREDMAN_ACCESS_NAME  TEXT("SeTrustedCredManAccessPrivilege")
#define SE_RELABEL_NAME                 TEXT("SeRelabelPrivilege")
#define SE_INC_WORKING_SET_NAME         TEXT("SeIncreaseWorkingSetPrivilege")
#define SE_TIME_ZONE_NAME               TEXT("SeTimeZonePrivilege")
#define SE_CREATE_SYMBOLIC_LINK_NAME    TEXT("SeCreateSymbolicLinkPrivilege")

/* Token access rights */
#define TOKEN_ASSIGN_PRIMARY    0x0001L
#define TOKEN_DUPLICATE         0x0002L
#define TOKEN_IMPERSONATE       0x0004L
#define TOKEN_QUERY             0x0008L
#define TOKEN_QUERY_SOURCE      0x0010L
#define TOKEN_ADJUST_PRIVILEGES 0x0020L
#define TOKEN_ADJUST_GROUPS     0x0040L
#define TOKEN_ADJUST_DEFAULT    0x0080L
#define TOKEN_ADJUST_SESSIONID  0x0100L
#define TOKEN_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | TOKEN_ASSIGN_PRIMARY | TOKEN_DUPLICATE | \
    TOKEN_IMPERSONATE | TOKEN_QUERY | TOKEN_QUERY_SOURCE | TOKEN_ADJUST_PRIVILEGES | \
    TOKEN_ADJUST_GROUPS | TOKEN_ADJUST_DEFAULT | TOKEN_ADJUST_SESSIONID)
#define TOKEN_READ              (STANDARD_RIGHTS_READ | TOKEN_QUERY)
#define TOKEN_WRITE \
    (STANDARD_RIGHTS_WRITE | TOKEN_ADJUST_PRIVILEGES | TOKEN_ADJUST_GROUPS | \
    TOKEN_ADJUST_DEFAULT)
#define TOKEN_EXECUTE           (STANDARD_RIGHTS_EXECUTE)

/* Number of token audit policy subcategories */
#define POLICY_AUDIT_SUBCATEGORY_COUNT  53

/* Length of a token source name */
#define TOKEN_SOURCE_LENGTH 8

/* Token mandatory policy flags */
#define TOKEN_MANDATORY_POLICY_OFF              0x00000000L
#define TOKEN_MANDATORY_POLICY_NO_WRITE_UP      0x00000001L
#define TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN  0x00000002L
#define TOKEN_MANDATORY_POLICY_VALID_MASK \
    (TOKEN_MANDATORY_POLICY_NO_WRITE_UP | TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN)

/* Security tracking modes */
#define SECURITY_DYNAMIC_TRACKING   TRUE
#define SECURITY_STATIC_TRACKING    FALSE

/* Token privilege options */
#define DISABLE_MAX_PRIVILEGE   0x00000001L
#define SANDBOX_INERT           0x00000002L
#define LUA_TOKEN               0x00000004L
#define WRITE_RESTRICTED        0x00000008L

/* Security information types */
#define OWNER_SECURITY_INFORMATION              0x00000001L
#define GROUP_SECURITY_INFORMATION              0x00000002L
#define DACL_SECURITY_INFORMATION               0x00000004L
#define SACL_SECURITY_INFORMATION               0x00000008L
#define LABEL_SECURITY_INFORMATION              0x00000010L
#define PROTECTED_DACL_SECURITY_INFORMATION     0x80000000L
#define PROTECTED_SACL_SECURITY_INFORMATION     0x40000000L
#define UNPROTECTED_DACL_SECURITY_INFORMATION   0x20000000L
#define UNPROTECTED_SACL_SECURITY_INFORMATION   0x10000000L

/* Process access rights */
#define PROCESS_TERMINATE                   0x0001L
#define PROCESS_CREATE_THREAD               0x0002L
#define PROCESS_SET_SESSIONID               0x0004L
#define PROCESS_VM_OPERATION                0x0008L
#define PROCESS_VM_READ                     0x0010L
#define PROCESS_VM_WRITE                    0x0020L
#define PROCESS_DUP_HANDLE                  0x0040L
#define PROCESS_CREATE_PROCESS              0x0080L
#define PROCESS_SET_QUOTA                   0x0100L
#define PROCESS_SET_INFORMATION             0x0200L
#define PROCESS_QUERY_INFORMATION           0x0400L
#define PROCESS_SUSPEND_RESUME              0x0800L
#define PROCESS_QUERY_LIMITED_INFORMATION   0x1000L
#if (NTDDI_VERSION >= 0x06000000)
    #define PROCESS_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFFL)
#else
    #define PROCESS_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0FFFL)
#endif

/* Maximum number of processors */
#define MAXIMUM_PROC_PER_GROUP  32
#define MAXIMUM_PROCESSORS      MAXIMUM_PROC_PER_GROUP

/* Thread access rights */
#define THREAD_TERMINATE                    0x0001L
#define THREAD_SUSPEND_RESUME               0x0002L
#define THREAD_GET_CONTEXT                  0x0008L
#define THREAD_SET_CONTEXT                  0x0010L
#define THREAD_SET_INFORMATION              0x0020L
#define THREAD_QUERY_INFORMATION            0x0040L
#define THREAD_SET_THREAD_TOKEN             0x0080L
#define THREAD_IMPERSONATE                  0x0100L
#define THREAD_DIRECT_IMPERSONATION         0x0200L
#define THREAD_SET_LIMITED_INFORMATION      0x0400L
#define THREAD_QUERY_LIMITED_INFORMATION    0x0800L
#if (NTDDI_VERSION >= 0x06000000)
    #define THREAD_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFFFL)
#else
    #define THREAD_ALL_ACCESS \
        (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x03FFL)
#endif

/* Job object access rights */
#define JOB_OBJECT_ASSIGN_PROCESS           0x0001L
#define JOB_OBJECT_SET_ATTRIBUTES           0x0002L
#define JOB_OBJECT_QUERY                    0x0004L
#define JOB_OBJECT_TERMINATE                0x0008L
#define JOB_OBJECT_SET_SECURITY_ATTRIBUTES  0x0010L
#define JOB_OBJECT_ALL_ACCESS \
    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x001FL)

/* Maximum number of fiber local storage slots */
#define FLS_MAXIMUM_AVAILABLE   128

/* Minimum number of thread local storage slots */
#define TLS_MINIMUM_AVAILABLE   64

/* Thread base priority values */
#define THREAD_BASE_PRIORITY_LOWRT  15
#define THREAD_BASE_PRIORITY_MAX    2
#define THREAD_BASE_PRIORITY_MIN    (-2)
#define THREAD_BASE_PRIORITY_IDLE   (-15)

/* Quota limits flags */
#define QUOTA_LIMITS_HARDWS_MIN_ENABLE  0x00000001L
#define QUOTA_LIMITS_HARDWS_MIN_DISABLE 0x00000002L
#define QUOTA_LIMITS_HARDWS_MAX_ENABLE  0x00000004L
#define QUOTA_LIMITS_HARDWS_MAX_DISABLE 0x00000008L
#define QUOTA_LIMITS_USE_DEFAULT_LIMITS 0x00000010L

/* Maximum number of hardware counters */
#define MAX_HW_COUNTERS 16

/* Thread profiling flags */
#define THREAD_PROFILING_FLAG_DISPATCH  0x00000001L

/* End of job actions */
#define JOB_OBJECT_TERMINATE_AT_END_OF_JOB  0
#define JOB_OBJECT_POST_AT_END_OF_JOB       1

/* Job object messages */
#define JOB_OBJECT_MSG_END_OF_JOB_TIME          1
#define JOB_OBJECT_MSG_END_OF_PROCESS_TIME      2
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT     3
#define JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO      4
#define JOB_OBJECT_MSG_NEW_PROCESS              6
#define JOB_OBJECT_MSG_EXIT_PROCESS             7
#define JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS    8
#define JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT     9
#define JOB_OBJECT_MSG_JOB_MEMORY_LIMIT         10

/* Job object limits */
#define JOB_OBJECT_LIMIT_WORKINGSET                 0x00000001L
#define JOB_OBJECT_LIMIT_PROCESS_TIME               0x00000002L
#define JOB_OBJECT_LIMIT_JOB_TIME                   0x00000004L
#define JOB_OBJECT_LIMIT_ACTIVE_PROCESS             0x00000008L
#define JOB_OBJECT_LIMIT_AFFINITY                   0x00000010L
#define JOB_OBJECT_LIMIT_PRIORITY_CLASS             0x00000020L
#define JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME          0x00000040L
#define JOB_OBJECT_LIMIT_SCHEDULING_CLASS           0x00000080L
#define JOB_OBJECT_LIMIT_PROCESS_MEMORY             0x00000100L
#define JOB_OBJECT_LIMIT_JOB_MEMORY                 0x00000200L
#define JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION 0x00000400L
#define JOB_OBJECT_LIMIT_BREAKAWAY_OK               0x00000800L
#define JOB_OBJECT_LIMIT_SILENT_BREAKAWAY_OK        0x00001000L
#define JOB_OBJECT_LIMIT_KILL_ON_JOB_CLOSE          0x00002000L
#define JOB_OBJECT_LIMIT_SUBSET_AFFINITY            0x00004000L
#define JOB_OBJECT_LIMIT_VALID_FLAGS                0x0007FFFFL
#define JOB_OBJECT_BASIC_LIMIT_VALID_FLAGS          0x000000FFL
#define JOB_OBJECT_EXTENDED_LIMIT_VALID_FLAGS       0x00007FFFL
#define JOB_OBJECT_RESERVED_LIMIT_VALID_FLAGS       0x0007FFFFL

/* Job object UI restrictions */
#define JOB_OBJECT_UILIMIT_NONE             0x00000000L
#define JOB_OBJECT_UILIMIT_HANDLES          0x00000001L
#define JOB_OBJECT_UILIMIT_READCLIPBOARD    0x00000002L
#define JOB_OBJECT_UILIMIT_WRITECLIPBOARD   0x00000004L
#define JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS 0x00000008L
#define JOB_OBJECT_UILIMIT_DISPLAYSETTINGS  0x00000010L
#define JOB_OBJECT_UILIMIT_GLOBALATOMS      0x00000020L
#define JOB_OBJECT_UILIMIT_DESKTOP          0x00000040L
#define JOB_OBJECT_UILIMIT_EXITWINDOWS      0x00000080L
#define JOB_OBJECT_UILIMIT_ALL              0x000000FFL
#define JOB_OBJECT_UI_VALID_FLAGS           0x000000FFL

/* Job object security limits */
#define JOB_OBJECT_SECURITY_NO_ADMIN            0x00000001L
#define JOB_OBJECT_SECURITY_RESTRICTED_TOKEN    0x00000002L
#define JOB_OBJECT_SECURITY_ONLY_TOKEN          0x00000004L
#define JOB_OBJECT_SECURITY_FILTER_TOKENS       0x00000008L
#define JOB_OBJECT_SECURITY_VALID_FLAGS         0x0000000FL

/* Event access rights */
#define EVENT_MODIFY_STATE  0x0002L
#define EVENT_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* Mutant access rights */
#define MUTANT_QUERY_STATE  0x0001L
#define MUTANT_ALL_ACCESS   (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0001L)

/* Semaphore access rights */
#define SEMAPHORE_MODIFY_STATE  0x0002L
#define SEMAPHORE_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* Timer access rights */
#define TIMER_QUERY_STATE   0x0001L
#define TIMER_MODIFY_STATE  0x0002L
#define TIMER_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* Time zone identifiers */
#define TIME_ZONE_ID_UNKNOWN    0L
#define TIME_ZONE_ID_STANDARD   1L
#define TIME_ZONE_ID_DAYLIGHT   2L

/* Cache associativity special value */
#define CACHE_FULLY_ASSOCIATIVE 0xFF

/* Processor types */
#define PROCESSOR_INTEL_386     386L
#define PROCESSOR_INTEL_486     486L
#define PROCESSOR_INTEL_PENTIUM 586L
#define PROCESSOR_INTEL_IA64    2200L
#define PROCESSOR_AMD_X8664     8664L
#define PROCESSOR_MIPS_R4000    4000L
#define PROCESSOR_ALPHA_21064   21064L
#define PROCESSOR_PPC_601       601L
#define PROCESSOR_PPC_603       603L
#define PROCESSOR_PPC_604       604L
#define PROCESSOR_PPC_620       620L
#define PROCESSOR_HITACHI_SH3   10003L
#define PROCESSOR_HITACHI_SH3E  10004L
#define PROCESSOR_HITACHI_SH4   10005L
#define PROCESSOR_MOTOROLA_821  821L
#define PROCESSOR_SHx_SH3       103L
#define PROCESSOR_SHx_SH4       104L
#define PROCESSOR_STRONGARM     2577L
#define PROCESSOR_ARM720        1824L
#define PROCESSOR_ARM820        2080L
#define PROCESSOR_ARM920        2336L
#define PROCESSOR_ARM_7TDMI     70001L
#define PROCESSOR_OPTIL         0x0000494FL

/* Processor architectures */
#define PROCESSOR_ARCHITECTURE_INTEL            0
#define PROCESSOR_ARCHITECTURE_MIPS             1
#define PROCESSOR_ARCHITECTURE_ALPHA            2
#define PROCESSOR_ARCHITECTURE_PPC              3
#define PROCESSOR_ARCHITECTURE_SHX              4
#define PROCESSOR_ARCHITECTURE_ARM              5
#define PROCESSOR_ARCHITECTURE_IA64             6
#define PROCESSOR_ARCHITECTURE_ALPHA64          7
#define PROCESSOR_ARCHITECTURE_MSIL             8
#define PROCESSOR_ARCHITECTURE_AMD64            9
#define PROCESSOR_ARCHITECTURE_IA32_ON_WIN64    10
#define PROCESSOR_ARCHITECTURE_UNKNOWN          0xFFFF

/* Processor features */
#define PF_FLOATING_POINT_PRECISION_ERRATA  0L
#define PF_FLOATING_POINT_EMULATED          1L
#define PF_COMPARE_EXCHANGE_DOUBLE          2L
#define PF_MMX_INSTRUCTIONS_AVAILABLE       3L
#define PF_PPC_MOVEMEM_64BIT_OK             4L
#define PF_ALPHA_BYTE_INSTRUCTIONS          5L
#define PF_XMMI_INSTRUCTIONS_AVAILABLE      6L
#define PF_3DNOW_INSTRUCTIONS_AVAILABLE     7L
#define PF_RDTSC_INSTRUCTION_AVAILABLE      8L
#define PF_PAE_ENABLED                      9L
#define PF_XMMI64_INSTRUCTIONS_AVAILABLE    10L
#define PF_SSE_DAZ_MODE_AVAILABLE           11L
#define PF_NX_ENABLED                       12L
#define PF_SSE3_INSTRUCTIONS_AVAILABLE      13L
#define PF_COMPARE_EXCHANGE128              14L
#define PF_COMPARE64_EXCHANGE128            15L
#define PF_CHANNELS_ENABLED                 16L
#define PF_XSAVE_ENABLED                    17L

/* Extended state features */
#define XSTATE_LEGACY_FLOATING_POINT    0
#define XSTATE_LEGACY_SSE               1
#define XSTATE_GSSE                     2
#define MAXIMUM_XSTATE_FEATURES         64

/* Extended state feature masks */
#define XSTATE_MASK_LEGACY_FLOATING_POINT   (1LL << XSTATE_LEGACY_FLOATING_POINT)
#define XSTATE_MASK_LEGACY_SSE              (1LL << XSTATE_LEGACY_SSE)
#define XSTATE_MASK_GSSE                    (1LL << XSTATE_GSSE)
#define XSTATE_MASK_LEGACY \
    (XSTATE_MASK_LEGACY_FLOATING_POINT | XSTATE_MASK_LEGACY_SSE)

/* Section access rights */
#define SECTION_QUERY                   0x0001L
#define SECTION_MAP_WRITE               0x0002L
#define SECTION_MAP_READ                0x0004L
#define SECTION_MAP_EXECUTE             0x0008L
#define SECTION_EXTEND_SIZE             0x0010L
#define SECTION_MAP_EXECUTE_EXPLICIT    0x0020L
#define SECTION_ALL_ACCESS              (STANDARD_RIGHTS_REQUIRED | 0x001F)

/* Session access rights */
#define SESSION_QUERY_ACCESS    0x0001L
#define SESSION_MODIFY_ACCESS   0x0002L
#define SESSION_ALL_ACCESS      (STANDARD_RIGHTS_REQUIRED | 0x0003L)

/* Memory protection and allocation flags */
#define PAGE_NOACCESS           0x00000001L
#define PAGE_READONLY           0x00000002L
#define PAGE_READWRITE          0x00000004L
#define PAGE_WRITECOPY          0x00000008L
#define PAGE_EXECUTE            0x00000010L
#define PAGE_EXECUTE_READ       0x00000020L
#define PAGE_EXECUTE_READWRITE  0x00000040L
#define PAGE_EXECUTE_WRITECOPY  0x00000080L
#define PAGE_GUARD              0x00000100L
#define PAGE_NOCACHE            0x00000200L
#define PAGE_WRITECOMBINE       0x00000400L
#define MEM_COMMIT              0x00001000L
#define MEM_RESERVE             0x00002000L
#define MEM_DECOMMIT            0x00004000L
#define MEM_RELEASE             0x00008000L
#define MEM_FREE                0x00010000L
#define MEM_PRIVATE             0x00020000L
#define MEM_MAPPED              0x00040000L
#define MEM_RESET               0x00080000L
#define MEM_TOP_DOWN            0x00100000L
#define MEM_WRITE_WATCH         0x00200000L
#define MEM_PHYSICAL            0x00400000L
#define MEM_ROTATE              0x00800000L
#define MEM_LARGE_PAGES         0x20000000L
#define MEM_4MB_PAGES           0x80000000L
#define SEC_FILE                0x00800000L
#define SEC_IMAGE               0x01000000L
#define SEC_PROTECTED_IMAGE     0x02000000L
#define SEC_RESERVE             0x04000000L
#define SEC_COMMIT              0x08000000L
#define SEC_NOCACHE             0x10000000L
#define SEC_WRITECOMBINE        0x40000000L
#define SEC_LARGE_PAGES         0x80000000L
#define MEM_IMAGE               SEC_IMAGE

/* Write watch flags */
#define WRITE_WATCH_FLAG_RESET  0x00000001L

/* File access rights */
#define FILE_READ_DATA              0x0001L
#define FILE_LIST_DIRECTORY         0x0001L
#define FILE_WRITE_DATA             0x0002L
#define FILE_ADD_FILE               0x0002L
#define FILE_APPEND_DATA            0x0004L
#define FILE_ADD_SUBDIRECTORY       0x0004L
#define FILE_CREATE_PIPE_INSTANCE   0x0004L
#define FILE_READ_EA                0x0008L
#define FILE_WRITE_EA               0x0010L
#define FILE_EXECUTE                0x0020L
#define FILE_TRAVERSE               0x0020L
#define FILE_DELETE_CHILD           0x0040L
#define FILE_READ_ATTRIBUTES        0x0080L
#define FILE_WRITE_ATTRIBUTES       0x0100L
#define FILE_ALL_ACCESS             (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x01FFL)
#define FILE_GENERIC_READ \
    (STANDARD_RIGHTS_READ | SYNCHRONIZE | FILE_READ_DATA | FILE_READ_ATTRIBUTES | \
    FILE_READ_EA)
#define FILE_GENERIC_WRITE \
    (STANDARD_RIGHTS_WRITE | SYNCHRONIZE | FILE_WRITE_DATA | FILE_WRITE_ATTRIBUTES | \
    FILE_WRITE_EA | FILE_APPEND_DATA)
#define FILE_GENERIC_EXECUTE \
    (STANDARD_RIGHTS_EXECUTE | SYNCHRONIZE | FILE_READ_ATTRIBUTES | FILE_EXECUTE)

/* File sharing options */
#define FILE_SHARE_READ     0x00000001L
#define FILE_SHARE_WRITE    0x00000002L
#define FILE_SHARE_DELETE   0x00000004L

/* File attributes */
#define FILE_ATTRIBUTE_READONLY             0x00000001L
#define FILE_ATTRIBUTE_HIDDEN               0x00000002L
#define FILE_ATTRIBUTE_SYSTEM               0x00000004L
#define FILE_ATTRIBUTE_DIRECTORY            0x00000010L
#define FILE_ATTRIBUTE_ARCHIVE              0x00000020L
#define FILE_ATTRIBUTE_DEVICE               0x00000040L
#define FILE_ATTRIBUTE_NORMAL               0x00000080L
#define FILE_ATTRIBUTE_TEMPORARY            0x00000100L
#define FILE_ATTRIBUTE_SPARSE_FILE          0x00000200L
#define FILE_ATTRIBUTE_REPARSE_POINT        0x00000400L
#define FILE_ATTRIBUTE_COMPRESSED           0x00000800L
#define FILE_ATTRIBUTE_OFFLINE              0x00001000L
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED  0x00002000L
#define FILE_ATTRIBUTE_ENCRYPTED            0x00004000L
#define FILE_ATTRIBUTE_VIRTUAL              0x00010000L

/* File change notification flags */
#define FILE_NOTIFY_CHANGE_FILE_NAME    0x00000001L
#define FILE_NOTIFY_CHANGE_DIR_NAME     0x00000002L
#define FILE_NOTIFY_CHANGE_ATTRIBUTES   0x00000004L
#define FILE_NOTIFY_CHANGE_SIZE         0x00000008L
#define FILE_NOTIFY_CHANGE_LAST_WRITE   0x00000010L
#define FILE_NOTIFY_CHANGE_LAST_ACCESS  0x00000020L
#define FILE_NOTIFY_CHANGE_CREATION     0x00000040L
#define FILE_NOTIFY_CHANGE_SECURITY     0x00000100L

/* File actions */
#define FILE_ACTION_ADDED               0x00000001L
#define FILE_ACTION_REMOVED             0x00000002L
#define FILE_ACTION_MODIFIED            0x00000003L
#define FILE_ACTION_RENAMED_OLD_NAME    0x00000004L
#define FILE_ACTION_RENAMED_NEW_NAME    0x00000005L

/* Mailslot special values */
#define MAILSLOT_NO_MESSAGE     0xFFFFFFFFL
#define MAILSLOT_WAIT_FOREVER   0xFFFFFFFFL

/* File system flags */
#define FILE_CASE_SENSITIVE_SEARCH          0x00000001L
#define FILE_CASE_PRESERVED_NAMES           0x00000002L
#define FILE_UNICODE_ON_DISK                0x00000004L
#define FILE_PERSISTENT_ACLS                0x00000008L
#define FILE_FILE_COMPRESSION               0x00000010L
#define FILE_VOLUME_QUOTAS                  0x00000020L
#define FILE_SUPPORTS_SPARSE_FILES          0x00000040L
#define FILE_SUPPORTS_REPARSE_POINTS        0x00000080L
#define FILE_SUPPORTS_REMOTE_STORAGE        0x00000100L
#define FILE_VOLUME_IS_COMPRESSED           0x00008000L
#define FILE_SUPPORTS_OBJECT_IDS            0x00010000L
#define FILE_SUPPORTS_ENCRYPTION            0x00020000L
#define FILE_NAMED_STREAMS                  0x00040000L
#define FILE_READ_ONLY_VOLUME               0x00080000L
#define FILE_SEQUENTIAL_WRITE_ONCE          0x00100000L
#define FILE_SUPPORTS_TRANSACTIONS          0x00200000L
#define FILE_SUPPORTS_HARD_LINKS            0x00400000L
#define FILE_SUPPORTS_EXTENDED_ATTRIBUTES   0x00800000L
#define FILE_SUPPORTS_OPEN_BY_FILE_ID       0x01000000L
#define FILE_SUPPORTS_USN_JOURNAL           0x02000000L

/* Reparse tags */
#define IO_REPARSE_TAG_MOUNT_POINT      0xA0000003L
#define IO_REPARSE_TAG_HSM              0xC0000004L
#define IO_REPARSE_TAG_HSM2             0x80000006L
#define IO_REPARSE_TAG_SIS              0x80000007L
#define IO_REPARSE_TAG_WIM              0x80000008L
#define IO_REPARSE_TAG_CSV              0x80000009L
#define IO_REPARSE_TAG_DFS              0x8000000AL
#define IO_REPARSE_TAG_SYMLINK          0x8000000CL
#define IO_REPARSE_TAG_DFSR             0x80000012L

/* I/O completion port access rights */
#define IO_COMPLETION_MODIFY_STATE  0x0002L
#define IO_COMPLETION_ALL_ACCESS    (STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x0003L)

/* DuplicateHandle() flags */
#define DUPLICATE_CLOSE_SOURCE  0x00000001L
#define DUPLICATE_SAME_ACCESS   0x00000002L

/* Maximum power state value */
#define POWER_SYSTEM_MAXIMUM    7

/* Execution state values */
#define ES_SYSTEM_REQUIRED      0x00000001L
#define ES_DISPLAY_REQUIRED     0x00000002L
#define ES_USER_PRESENT         0x00000004L
#define ES_AWAYMODE_REQUIRED    0x00000040L
#define ES_CONTINUOUS           0x80000000L

/* Diagnostic reason version number */
#if (_WIN32_WINNT >= 0x0601)
    #define DIAGNOSTIC_REASON_VERSION   0L
#endif

/* Diagnostic reason flags */
#if (_WIN32_WINNT >= 0x0601)
    #define DIAGNOSTIC_REASON_SIMPLE_STRING     0x00000001L
    #define DIAGNOSTIC_REASON_DETAILED_STRING   0x00000002L
    #define DIAGNOSTIC_REASON_NOT_SPECIFIED     0x80000000L
#endif

/* Power request context version number */
#define POWER_REQUEST_CONTEXT_VERSION   0L

/* Power request context flags */
#define POWER_REQUEST_CONTEXT_SIMPLE_STRING     0x00000001L
#define POWER_REQUEST_CONTEXT_DETAILED_STRING   0x00000002L

/* Device power capabilities */
#if (NTDDI_VERSION >= 0x05010000)
    #define PDCAP_D0_SUPPORTED              0x00000001L
    #define PDCAP_D1_SUPPORTED              0x00000002L
    #define PDCAP_D2_SUPPORTED              0x00000004L
    #define PDCAP_D3_SUPPORTED              0x00000008L
    #define PDCAP_WAKE_FROM_D0_SUPPORTED    0x00000010L
    #define PDCAP_WAKE_FROM_D1_SUPPORTED    0x00000020L
    #define PDCAP_WAKE_FROM_D2_SUPPORTED    0x00000040L
    #define PDCAP_WAKE_FROM_D3_SUPPORTED    0x00000080L
    #define PDCAP_WARM_EJECT_SUPPORTED      0x00000100L
#endif

/* Version of the SET_POWER_SETTING_VALUE structure */
#define POWER_SETTING_VALUE_VERSION 0x00000001L

/* Number of idle buckets */
#define PROC_IDLE_BUCKET_COUNT      6
#define PROC_IDLE_BUCKET_COUNT_EX   16

/* Coordination types */
#define ACPI_PPM_SOFTWARE_ALL   0xFC
#define ACPI_PPM_SOFTWARE_ANY   0xFD
#define ACPI_PPM_HARDWARE_ALL   0xFE
#define MS_PPM_SOFTWARE_ALL     0x01

/* Firmware features */
#define PPM_FIRMWARE_ACPI1C2        0x00000001L
#define PPM_FIRMWARE_ACPI1C3        0x00000002L
#define PPM_FIRMWARE_ACPI1TSTATES   0x00000004L
#define PPM_FIRMWARE_CST            0x00000008L
#define PPM_FIRMWARE_CSD            0x00000010L
#define PPM_FIRMWARE_PCT            0x00000020L
#define PPM_FIRMWARE_PSS            0x00000040L
#define PPM_FIRMWARE_XPSS           0x00000080L
#define PPM_FIRMWARE_PPC            0x00000100L
#define PPM_FIRMWARE_PSD            0x00000200L
#define PPM_FIRMWARE_PTC            0x00000400L
#define PPM_FIRMWARE_TSS            0x00000800L
#define PPM_FIRMWARE_TPC            0x00001000L
#define PPM_FIRMWARE_TSD            0x00002000L
#define PPM_FIRMWARE_PCCH           0x00004000L
#define PPM_FIRMWARE_PCCP           0x00008000L

/* Power action policy flags */
#define POWER_ACTION_QUERY_ALLOWED      0x00000001L
#define POWER_ACTION_UI_ALLOWED         0x00000002L
#define POWER_ACTION_OVERRIDE_APPS      0x00000004L
#define POWER_ACTION_PSEUDO_TRANSITION  0x08000000L
#define POWER_ACTION_LIGHTEST_FIRST     0x10000000L
#define POWER_ACTION_LOCK_CONSOLE       0x20000000L
#define POWER_ACTION_DISABLE_WAKES      0x40000000L
#define POWER_ACTION_CRITICAL           0x80000000L

/* Power action policy event code flags */
#define POWER_LEVEL_USER_NOTIFY_TEXT        0x00000001L
#define POWER_LEVEL_USER_NOTIFY_SOUND       0x00000002L
#define POWER_LEVEL_USER_NOTIFY_EXEC        0x00000004L
#define POWER_USER_NOTIFY_BUTTON            0x00000008L
#define POWER_USER_NOTIFY_SHUTDOWN          0x00000010L
#define POWER_USER_NOTIFY_FORCED_SHUTDOWN   0x00000020L
#define POWER_FORCE_TRIGGER_RESET           0x80000000L

/* Battery discharge flags */
#define BATTERY_DISCHARGE_FLAGS_EVENTCODE_MASK  0x00000007
#define BATTERY_DISCHARGE_FLAGS_ENABLE          0x80000000

/* Maximum number of processor idle state policies */
#define PROCESSOR_IDLESTATE_POLICY_COUNT    3

/* Maximum number of discharge policies */
#define NUM_DISCHARGE_POLICIES  4

/* Discharge policy indices */
#define DISCHARGE_POLICY_CRITICAL   0
#define DISCHARGE_POLICY_LOW        1

/* Throttling policies */
#define PO_THROTTLE_NONE        0
#define PO_THROTTLE_CONSTANT    1
#define PO_THROTTLE_DEGRADE     2
#define PO_THROTTLE_ADAPTIVE    3
#define PO_THROTTLE_MAXIMUM     4

/* Image file signatures */
#define IMAGE_DOS_SIGNATURE     0x5A4D
#define IMAGE_OS2_SIGNATURE     0x454E
#define IMAGE_OS2_SIGNATURE_LE  0x454C
#define IMAGE_VXD_SIGNATURE     0x454C
#define IMAGE_NT_SIGNATURE      0x00004550

/* Size of image file header */
#define IMAGE_SIZEOF_FILE_HEADER    20

/* Image file characteristics */
#define IMAGE_FILE_RELOCS_STRIPPED          0x0001
#define IMAGE_FILE_EXECUTABLE_IMAGE         0x0002
#define IMAGE_FILE_LINE_NUMS_STRIPPED       0x0004
#define IMAGE_FILE_LOCAL_SYMS_STRIPPED      0x0008
#define IMAGE_FILE_AGGRESIVE_WS_TRIM        0x0010
#define IMAGE_FILE_LARGE_ADDRESS_AWARE      0x0020
#define IMAGE_FILE_BYTES_REVERSED_LO        0x0080
#define IMAGE_FILE_32BIT_MACHINE            0x0100
#define IMAGE_FILE_DEBUG_STRIPPED           0x0200
#define IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP  0x0400
#define IMAGE_FILE_NET_RUN_FROM_SWAP        0x0800
#define IMAGE_FILE_SYSTEM                   0x1000
#define IMAGE_FILE_DLL                      0x2000
#define IMAGE_FILE_UP_SYSTEM_ONLY           0x4000
#define IMAGE_FILE_BYTES_REVERSED_HI        0x8000

/* Image file machine types */
#define IMAGE_FILE_MACHINE_UNKNOWN      0x0000
#define IMAGE_FILE_MACHINE_I386         0x014C
#define IMAGE_FILE_MACHINE_R3000        0x0162
#define IMAGE_FILE_MACHINE_R4000        0x0166
#define IMAGE_FILE_MACHINE_R10000       0x0168
#define IMAGE_FILE_MACHINE_WCEMIPSV2    0x0169
#define IMAGE_FILE_MACHINE_ALPHA        0x0184
#define IMAGE_FILE_MACHINE_SH3          0x01A2
#define IMAGE_FILE_MACHINE_SH3DSP       0x01A3
#define IMAGE_FILE_MACHINE_SH3E         0x01A4
#define IMAGE_FILE_MACHINE_SH4          0x01A6
#define IMAGE_FILE_MACHINE_SH5          0x01A8
#define IMAGE_FILE_MACHINE_ARM          0x01C0
#define IMAGE_FILE_MACHINE_THUMB        0x01C2
#define IMAGE_FILE_MACHINE_AM33         0x01D3
#define IMAGE_FILE_MACHINE_POWERPC      0x01F0
#define IMAGE_FILE_MACHINE_POWERPCFP    0x01F1
#define IMAGE_FILE_MACHINE_IA64         0x0200
#define IMAGE_FILE_MACHINE_MIPS16       0x0266
#define IMAGE_FILE_MACHINE_ALPHA64      0x0284
#define IMAGE_FILE_MACHINE_MIPSFPU      0x0366
#define IMAGE_FILE_MACHINE_MIPSFPU16    0x0466
#define IMAGE_FILE_MACHINE_AXP64        IMAGE_FILE_MACHINE_ALPHA64
#define IMAGE_FILE_MACHINE_TRICORE      0x0520
#define IMAGE_FILE_MACHINE_CEF          0x0CEF
#define IMAGE_FILE_MACHINE_EBC          0x0EBC
#define IMAGE_FILE_MACHINE_AMD64        0x8664
#define IMAGE_FILE_MACHINE_M32R         0x9041
#define IMAGE_FILE_MACHINE_CEE          0xC0EE

/* Number of image directory entries */
#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES    16

/* Sizes of optional image headers */
#define IMAGE_SIZEOF_ROM_OPTIONAL_HEADER    56
#define IMAGE_SIZEOF_STD_OPTIONAL_HEADER    28
#define IMAGE_SIZEOF_NT_OPTIONAL32_HEADER   224
#define IMAGE_SIZEOF_NT_OPTIONAL64_HEADER   240
#define IMAGE_SIZEOF_NT_OPTIONAL_HEADER     IMAGE_SIZEOF_NT_OPTIONAL32_HEADER

/* Magic numbers for optional image headers */
#define IMAGE_NT_OPTIONAL_HDR32_MAGIC   0x010B
#define IMAGE_NT_OPTIONAL_HDR64_MAGIC   0x020B
#define IMAGE_ROM_OPTIONAL_HDR_MAGIC    0x0107
#define IMAGE_NT_OPTIONAL_HDR_MAGIC     IMAGE_NT_OPTIONAL_HDR32_MAGIC

/* Image subsystems */
#define IMAGE_SUBSYSTEM_UNKNOWN                     0
#define IMAGE_SUBSYSTEM_NATIVE                      1
#define IMAGE_SUBSYSTEM_WINDOWS_GUI                 2
#define IMAGE_SUBSYSTEM_WINDOWS_CUI                 3
#define IMAGE_SUBSYSTEM_OS2_CUI                     5
#define IMAGE_SUBSYSTEM_POSIX_CUI                   7
#define IMAGE_SUBSYSTEM_NATIVE_WINDOWS              8
#define IMAGE_SUBSYSTEM_WINDOWS_CE_GUI              9
#define IMAGE_SUBSYSTEM_EFI_APPLICATION             10
#define IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER     11
#define IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER          12
#define IMAGE_SUBSYSTEM_EFI_ROM                     13
#define IMAGE_SUBSYSTEM_XBOX                        14
#define IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION    16

/* Image DLL characteristics */
#define IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE           0x0040
#define IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY        0x0080
#define IMAGE_DLLCHARACTERISTICS_NX_COMPAT              0x0100
#define IMAGE_DLLCHARACTERISTICS_NO_ISOLATION           0x0200
#define IMAGE_DLLCHARACTERISTICS_NO_SEH                 0x0400
#define IMAGE_DLLCHARACTERISTICS_NO_BIND                0x0800
#define IMAGE_DLLCHARACTERISTICS_WDM_DRIVER             0x2000
#define IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE  0x8000

/* Image directory entry types */
#define IMAGE_DIRECTORY_ENTRY_EXPORT            0
#define IMAGE_DIRECTORY_ENTRY_IMPORT            1
#define IMAGE_DIRECTORY_ENTRY_RESOURCE          2
#define IMAGE_DIRECTORY_ENTRY_EXCEPTION         3
#define IMAGE_DIRECTORY_ENTRY_SECURITY          4
#define IMAGE_DIRECTORY_ENTRY_BASERELOC         5
#define IMAGE_DIRECTORY_ENTRY_DEBUG             6
#define IMAGE_DIRECTORY_ENTRY_ARCHITECTURE      7
#define IMAGE_DIRECTORY_ENTRY_GLOBALPTR         8
#define IMAGE_DIRECTORY_ENTRY_TLS               9
#define IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG       10
#define IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT      11
#define IMAGE_DIRECTORY_ENTRY_IAT               12
#define IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT      13
#define IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR    14

/* Length of an image short name */
#define IMAGE_SIZEOF_SHORT_NAME 8

/* Size of image section header */
#define IMAGE_SIZEOF_SECTION_HEADER 40

/* Image section characteristics */
#define IMAGE_SCN_SCALE_INDEX               0x00000001L
#define IMAGE_SCN_TYPE_NO_PAD               0x00000008L
#define IMAGE_SCN_CNT_CODE                  0x00000020L
#define IMAGE_SCN_CNT_INITIALIZED_DATA      0x00000040L
#define IMAGE_SCN_CNT_UNINITIALIZED_DATA    0x00000080L
#define IMAGE_SCN_LNK_OTHER                 0x00000100L
#define IMAGE_SCN_LNK_INFO                  0x00000200L
#define IMAGE_SCN_LNK_REMOVE                0x00000800L
#define IMAGE_SCN_LNK_COMDAT                0x00001000L
#define IMAGE_SCN_NO_DEFER_SPEC_EXC         0x00004000L
#define IMAGE_SCN_GPREL                     0x00008000L
#define IMAGE_SCN_MEM_FARDATA               0x00008000L
#define IMAGE_SCN_MEM_PURGEABLE             0x00020000L
#define IMAGE_SCN_MEM_16BIT                 0x00020000L
#define IMAGE_SCN_MEM_LOCKED                0x00040000L
#define IMAGE_SCN_MEM_PRELOAD               0x00080000L
#define IMAGE_SCN_ALIGN_1BYTES              0x00100000L
#define IMAGE_SCN_ALIGN_2BYTES              0x00200000L
#define IMAGE_SCN_ALIGN_4BYTES              0x00300000L
#define IMAGE_SCN_ALIGN_8BYTES              0x00400000L
#define IMAGE_SCN_ALIGN_16BYTES             0x00500000L
#define IMAGE_SCN_ALIGN_32BYTES             0x00600000L
#define IMAGE_SCN_ALIGN_64BYTES             0x00700000L
#define IMAGE_SCN_ALIGN_128BYTES            0x00800000L
#define IMAGE_SCN_ALIGN_256BYTES            0x00900000L
#define IMAGE_SCN_ALIGN_512BYTES            0x00A00000L
#define IMAGE_SCN_ALIGN_1024BYTES           0x00B00000L
#define IMAGE_SCN_ALIGN_2048BYTES           0x00C00000L
#define IMAGE_SCN_ALIGN_4096BYTES           0x00D00000L
#define IMAGE_SCN_ALIGN_8192BYTES           0x00E00000L
#define IMAGE_SCN_ALIGN_MASK                0x00F00000L
#define IMAGE_SCN_LNK_NRELOC_OVFL           0x01000000L
#define IMAGE_SCN_MEM_DISCARDABLE           0x02000000L
#define IMAGE_SCN_MEM_NOT_CACHED            0x04000000L
#define IMAGE_SCN_MEM_NOT_PAGED             0x08000000L
#define IMAGE_SCN_MEM_SHARED                0x10000000L
#define IMAGE_SCN_MEM_EXECUTE               0x20000000L
#define IMAGE_SCN_MEM_READ                  0x40000000L
#define IMAGE_SCN_MEM_WRITE                 0x80000000L

/* Size of image symbol */
#define IMAGE_SIZEOF_SYMBOL 18

/* Special image symbol section number values */
#define IMAGE_SYM_UNDEFINED         0x0000
#define IMAGE_SYM_ABSOLUTE          0xFFFF
#define IMAGE_SYM_DEBUG             0xFFFE
#define IMAGE_SYM_SECTION_MAX       0xFEFF
#define IMAGE_SYM_SECTION_MAX_EX    MAXLONG

/* Image symbol data types */
#define IMAGE_SYM_TYPE_NULL     0x0000
#define IMAGE_SYM_TYPE_VOID     0x0001
#define IMAGE_SYM_TYPE_CHAR     0x0002
#define IMAGE_SYM_TYPE_SHORT    0x0003
#define IMAGE_SYM_TYPE_INT      0x0004
#define IMAGE_SYM_TYPE_LONG     0x0005
#define IMAGE_SYM_TYPE_FLOAT    0x0006
#define IMAGE_SYM_TYPE_DOUBLE   0x0007
#define IMAGE_SYM_TYPE_STRUCT   0x0008
#define IMAGE_SYM_TYPE_UNION    0x0009
#define IMAGE_SYM_TYPE_ENUM     0x000A
#define IMAGE_SYM_TYPE_MOE      0x000B
#define IMAGE_SYM_TYPE_BYTE     0x000C
#define IMAGE_SYM_TYPE_WORD     0x000D
#define IMAGE_SYM_TYPE_UINT     0x000E
#define IMAGE_SYM_TYPE_DWORD    0x000F
#define IMAGE_SYM_TYPE_PCODE    0x8000

/* Image symbol derived data types */
#define IMAGE_SYM_DTYPE_NULL        0
#define IMAGE_SYM_DTYPE_POINTER     1
#define IMAGE_SYM_DTYPE_FUNCTION    2
#define IMAGE_SYM_DTYPE_ARRAY       3

/* Image symbol storage classes */
#define IMAGE_SYM_CLASS_END_OF_FUNCTION     0x00FF
#define IMAGE_SYM_CLASS_NULL                0x0000
#define IMAGE_SYM_CLASS_AUTOMATIC           0x0001
#define IMAGE_SYM_CLASS_EXTERNAL            0x0002
#define IMAGE_SYM_CLASS_STATIC              0x0003
#define IMAGE_SYM_CLASS_REGISTER            0x0004
#define IMAGE_SYM_CLASS_EXTERNAL_DEF        0x0005
#define IMAGE_SYM_CLASS_LABEL               0x0006
#define IMAGE_SYM_CLASS_UNDEFINED_LABEL     0x0007
#define IMAGE_SYM_CLASS_MEMBER_OF_STRUCT    0x0008
#define IMAGE_SYM_CLASS_ARGUMENT            0x0009
#define IMAGE_SYM_CLASS_STRUCT_TAG          0x000A
#define IMAGE_SYM_CLASS_MEMBER_OF_UNION     0x000B
#define IMAGE_SYM_CLASS_UNION_TAG           0x000C
#define IMAGE_SYM_CLASS_TYPE_DEFINITION     0x000D
#define IMAGE_SYM_CLASS_UNDEFINED_STATIC    0x000E
#define IMAGE_SYM_CLASS_ENUM_TAG            0x000F
#define IMAGE_SYM_CLASS_MEMBER_OF_ENUM      0x0010
#define IMAGE_SYM_CLASS_REGISTER_PARAM      0x0011
#define IMAGE_SYM_CLASS_BIT_FIELD           0x0012
#define IMAGE_SYM_CLASS_FAR_EXTERNAL        0x0044
#define IMAGE_SYM_CLASS_BLOCK               0x0064
#define IMAGE_SYM_CLASS_FUNCTION            0x0065
#define IMAGE_SYM_CLASS_END_OF_STRUCT       0x0066
#define IMAGE_SYM_CLASS_FILE                0x0067
#define IMAGE_SYM_CLASS_SECTION             0x0068
#define IMAGE_SYM_CLASS_WEAK_EXTERNAL       0x0069
#define IMAGE_SYM_CLASS_CLR_TOKEN           0x006B

/* Type packing constants */
#define N_BTMASK    0x000F
#define N_TMASK     0x0030
#define N_TMASK1    0x00C0
#define N_TMASK2    0x00F0
#define N_BTSHFT    4
#define N_TSHIFT    2

/* Size of image auxiliary symbol */
#define IMAGE_SIZEOF_AUX_SYMBOL 18

/* Image COMDAT selection types */
#define IMAGE_COMDAT_SELECT_NODUPLICATES    1
#define IMAGE_COMDAT_SELECT_ANY             2
#define IMAGE_COMDAT_SELECT_SAME_SIZE       3
#define IMAGE_COMDAT_SELECT_EXACT_MATCH     4
#define IMAGE_COMDAT_SELECT_ASSOCIATIVE     5
#define IMAGE_COMDAT_SELECT_LARGEST         6
#define IMAGE_COMDAT_SELECT_NEWEST          7

/* Image weak external search types */
#define IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY  1
#define IMAGE_WEAK_EXTERN_SEARCH_LIBRARY    2
#define IMAGE_WEAK_EXTERN_SEARCH_ALIAS      3

/* Size of image relocation */
#define IMAGE_SIZEOF_RELOCATION 10

/* Image relocation types for the x86 processor */
#define IMAGE_REL_I386_ABSOLUTE 0x0000
#define IMAGE_REL_I386_DIR16    0x0001
#define IMAGE_REL_I386_REL16    0x0002
#define IMAGE_REL_I386_DIR32    0x0006
#define IMAGE_REL_I386_DIR32NB  0x0007
#define IMAGE_REL_I386_SEG12    0x0009
#define IMAGE_REL_I386_SECTION  0x000A
#define IMAGE_REL_I386_SECREL   0x000B
#define IMAGE_REL_I386_TOKEN    0x000C
#define IMAGE_REL_I386_SECREL7  0x000D
#define IMAGE_REL_I386_REL32    0x0014

/* Image relocation types for the Mips processor */
#define IMAGE_REL_MIPS_ABSOLUTE     0x0000
#define IMAGE_REL_MIPS_REFHALF      0x0001
#define IMAGE_REL_MIPS_REFWORD      0x0002
#define IMAGE_REL_MIPS_JMPADDR      0x0003
#define IMAGE_REL_MIPS_REFHI        0x0004
#define IMAGE_REL_MIPS_REFLO        0x0005
#define IMAGE_REL_MIPS_GPREL        0x0006
#define IMAGE_REL_MIPS_LITERAL      0x0007
#define IMAGE_REL_MIPS_SECTION      0x000A
#define IMAGE_REL_MIPS_SECREL       0x000B
#define IMAGE_REL_MIPS_SECRELLO     0x000C
#define IMAGE_REL_MIPS_SECRELHI     0x000D
#define IMAGE_REL_MIPS_TOKEN        0x000E
#define IMAGE_REL_MIPS_JMPADDR16    0x0010
#define IMAGE_REL_MIPS_REFWORDNB    0x0022
#define IMAGE_REL_MIPS_PAIR         0x0025

/* Image relocation types for the Alpha processor */
#define IMAGE_REL_ALPHA_ABSOLUTE        0x0000
#define IMAGE_REL_ALPHA_REFLONG         0x0001
#define IMAGE_REL_ALPHA_REFQUAD         0x0002
#define IMAGE_REL_ALPHA_GPREL32         0x0003
#define IMAGE_REL_ALPHA_LITERAL         0x0004
#define IMAGE_REL_ALPHA_LITUSE          0x0005
#define IMAGE_REL_ALPHA_GPDISP          0x0006
#define IMAGE_REL_ALPHA_BRADDR          0x0007
#define IMAGE_REL_ALPHA_HINT            0x0008
#define IMAGE_REL_ALPHA_INLINE_REFLONG  0x0009
#define IMAGE_REL_ALPHA_REFHI           0x000A
#define IMAGE_REL_ALPHA_REFLO           0x000B
#define IMAGE_REL_ALPHA_PAIR            0x000C
#define IMAGE_REL_ALPHA_MATCH           0x000D
#define IMAGE_REL_ALPHA_SECTION         0x000E
#define IMAGE_REL_ALPHA_SECREL          0x000F
#define IMAGE_REL_ALPHA_REFLONGNB       0x0010
#define IMAGE_REL_ALPHA_SECRELLO        0x0011
#define IMAGE_REL_ALPHA_SECRELHI        0x0012
#define IMAGE_REL_ALPHA_REFQ3           0x0013
#define IMAGE_REL_ALPHA_REFQ2           0x0014
#define IMAGE_REL_ALPHA_REFQ1           0x0015
#define IMAGE_REL_ALPHA_GPRELLO         0x0016
#define IMAGE_REL_ALPHA_GPRELHI         0x0017

/* Image relocation types for the PowerPC processor */
#define IMAGE_REL_PPC_ABSOLUTE  0x0000
#define IMAGE_REL_PPC_ADDR64    0x0001
#define IMAGE_REL_PPC_ADDR32    0x0002
#define IMAGE_REL_PPC_ADDR24    0x0003
#define IMAGE_REL_PPC_ADDR16    0x0004
#define IMAGE_REL_PPC_ADDR14    0x0005
#define IMAGE_REL_PPC_REL24     0x0006
#define IMAGE_REL_PPC_REL14     0x0007
#define IMAGE_REL_PPC_TOCREL16  0x0008
#define IMAGE_REL_PPC_TOCREL14  0x0009
#define IMAGE_REL_PPC_ADDR32NB  0x000A
#define IMAGE_REL_PPC_SECREL    0x000B
#define IMAGE_REL_PPC_SECTION   0x000C
#define IMAGE_REL_PPC_IFGLUE    0x000D
#define IMAGE_REL_PPC_IMGLUE    0x000E
#define IMAGE_REL_PPC_SECREL16  0x000F
#define IMAGE_REL_PPC_REFHI     0x0010
#define IMAGE_REL_PPC_REFLO     0x0011
#define IMAGE_REL_PPC_PAIR      0x0012
#define IMAGE_REL_PPC_SECRELLO  0x0013
#define IMAGE_REL_PPC_SECRELHI  0x0014
#define IMAGE_REL_PPC_GPREL     0x0015
#define IMAGE_REL_PPC_TOKEN     0x0016
#define IMAGE_REL_PPC_TYPEMASK  0x00FF
#define IMAGE_REL_PPC_NEG       0x0100
#define IMAGE_REL_PPC_BRTAKEN   0x0200
#define IMAGE_REL_PPC_BRNTAKEN  0x0400
#define IMAGE_REL_PPC_TOCDEFN   0x0800

/* Image relocation types for the SH3 processor */
#define IMAGE_REL_SH3_ABSOLUTE          0x0000
#define IMAGE_REL_SH3_DIRECT16          0x0001
#define IMAGE_REL_SH3_DIRECT32          0x0002
#define IMAGE_REL_SH3_DIRECT8           0x0003
#define IMAGE_REL_SH3_DIRECT8_WORD      0x0004
#define IMAGE_REL_SH3_DIRECT8_LONG      0x0005
#define IMAGE_REL_SH3_DIRECT4           0x0006
#define IMAGE_REL_SH3_DIRECT4_WORD      0x0007
#define IMAGE_REL_SH3_DIRECT4_LONG      0x0008
#define IMAGE_REL_SH3_PCREL8_WORD       0x0009
#define IMAGE_REL_SH3_PCREL8_LONG       0x000A
#define IMAGE_REL_SH3_PCREL12_WORD      0x000B
#define IMAGE_REL_SH3_STARTOF_SECTION   0x000C
#define IMAGE_REL_SH3_SIZEOF_SECTION    0x000D
#define IMAGE_REL_SH3_SECTION           0x000E
#define IMAGE_REL_SH3_SECREL            0x000F
#define IMAGE_REL_SH3_DIRECT32_NB       0x0010
#define IMAGE_REL_SH3_GPREL4_LONG       0x0011
#define IMAGE_REL_SH3_TOKEN             0x0012
#define IMAGE_REL_SHM_PCRELPT           0x0013
#define IMAGE_REL_SHM_REFLO             0x0014
#define IMAGE_REL_SHM_REFHALF           0x0015
#define IMAGE_REL_SHM_RELLO             0x0016
#define IMAGE_REL_SHM_RELHALF           0x0017
#define IMAGE_REL_SHM_PAIR              0x0018
#define IMAGE_RLE_SH_NOMODE             0x8000

/* Image relocation types for the ARM processor */
#define IMAGE_REL_ARM_ABSOLUTE  0x0000
#define IMAGE_REL_ARM_ADDR32    0x0001
#define IMAGE_REL_ARM_ADDR32NB  0x0002
#define IMAGE_REL_ARM_BRANCH24  0x0003
#define IMAGE_REL_ARM_BRANCH11  0x0004
#define IMAGE_REL_ARM_TOKEN     0x0005
#define IMAGE_REL_ARM_GPREL12   0x0006
#define IMAGE_REL_ARM_GPREL7    0x0007
#define IMAGE_REL_ARM_BLX24     0x0008
#define IMAGE_REL_ARM_BLX11     0x0009
#define IMAGE_REL_ARM_SECTION   0x000E
#define IMAGE_REL_ARM_SECREL    0x000F

/* Image relocation types for the AM33 processor */
#define IMAGE_REL_AM_ABSOLUTE   0x0000
#define IMAGE_REL_AM_ADDR32     0x0001
#define IMAGE_REL_AM_ADDR32NB   0x0002
#define IMAGE_REL_AM_CALL32     0x0003
#define IMAGE_REL_AM_FUNCINFO   0x0004
#define IMAGE_REL_AM_REL32_1    0x0005
#define IMAGE_REL_AM_REL32_2    0x0006
#define IMAGE_REL_AM_SECREL     0x0007
#define IMAGE_REL_AM_SECTION    0x0008
#define IMAGE_REL_AM_TOKEN      0x0009

/* Image relocation types for the AMD64 processor */
#define IMAGE_REL_AMD64_ABSOLUTE    0x0000
#define IMAGE_REL_AMD64_ADDR64      0x0001
#define IMAGE_REL_AMD64_ADDR32      0x0002
#define IMAGE_REL_AMD64_ADDR32NB    0x0003
#define IMAGE_REL_AMD64_REL32       0x0004
#define IMAGE_REL_AMD64_REL32_1     0x0005
#define IMAGE_REL_AMD64_REL32_2     0x0006
#define IMAGE_REL_AMD64_REL32_3     0x0007
#define IMAGE_REL_AMD64_REL32_4     0x0008
#define IMAGE_REL_AMD64_REL32_5     0x0009
#define IMAGE_REL_AMD64_SECTION     0x000A
#define IMAGE_REL_AMD64_SECREL      0x000B
#define IMAGE_REL_AMD64_SECREL7     0x000C
#define IMAGE_REL_AMD64_TOKEN       0x000D
#define IMAGE_REL_AMD64_SREL32      0x000E
#define IMAGE_REL_AMD64_PAIR        0x000F
#define IMAGE_REL_AMD64_SSPAN32     0x0010

/* Image relocation types for the IA64 processor */
#define IMAGE_REL_IA64_ABSOLUTE     0x0000
#define IMAGE_REL_IA64_IMM14        0x0001
#define IMAGE_REL_IA64_IMM22        0x0002
#define IMAGE_REL_IA64_IMM64        0x0003
#define IMAGE_REL_IA64_DIR32        0x0004
#define IMAGE_REL_IA64_DIR64        0x0005
#define IMAGE_REL_IA64_PCREL21B     0x0006
#define IMAGE_REL_IA64_PCREL21M     0x0007
#define IMAGE_REL_IA64_PCREL21F     0x0008
#define IMAGE_REL_IA64_GPREL22      0x0009
#define IMAGE_REL_IA64_LTOFF22      0x000A
#define IMAGE_REL_IA64_SECTION      0x000B
#define IMAGE_REL_IA64_SECREL22     0x000C
#define IMAGE_REL_IA64_SECREL64I    0x000D
#define IMAGE_REL_IA64_SECREL32     0x000E
#define IMAGE_REL_IA64_DIR32NB      0x0010
#define IMAGE_REL_IA64_SREL14       0x0011
#define IMAGE_REL_IA64_SREL22       0x0012
#define IMAGE_REL_IA64_SREL32       0x0013
#define IMAGE_REL_IA64_UREL32       0x0014
#define IMAGE_REL_IA64_PCREL60X     0x0015
#define IMAGE_REL_IA64_PCREL60B     0x0016
#define IMAGE_REL_IA64_PCREL60F     0x0017
#define IMAGE_REL_IA64_PCREL60I     0x0018
#define IMAGE_REL_IA64_PCREL60M     0x0019
#define IMAGE_REL_IA64_IMMGPREL64   0x001A
#define IMAGE_REL_IA64_TOKEN        0x001B
#define IMAGE_REL_IA64_GPREL32      0x001C
#define IMAGE_REL_IA64_ADDEND       0x001F

/* Image relocation types for the CEF processor */
#define IMAGE_REL_CEF_ABSOLUTE  0x0000
#define IMAGE_REL_CEF_ADDR32    0x0001
#define IMAGE_REL_CEF_ADDR64    0x0002
#define IMAGE_REL_CEF_ADDR32NB  0x0003
#define IMAGE_REL_CEF_SECTION   0x0004
#define IMAGE_REL_CEF_SECREL    0x0005
#define IMAGE_REL_CEF_TOKEN     0x0006

/* Image relocation types for the Common Language Runtime */
#define IMAGE_REL_CEE_ABSOLUTE  0x0000
#define IMAGE_REL_CEE_ADDR32    0x0001
#define IMAGE_REL_CEE_ADDR64    0x0002
#define IMAGE_REL_CEE_ADDR32NB  0x0003
#define IMAGE_REL_CEE_SECTION   0x0004
#define IMAGE_REL_CEE_SECREL    0x0005
#define IMAGE_REL_CEE_TOKEN     0x0006

/* Image relocation types for the M32R processor */
#define IMAGE_REL_M32R_ABSOLUTE 0x0000
#define IMAGE_REL_M32R_ADDR32   0x0001
#define IMAGE_REL_M32R_ADDR32NB 0x0002
#define IMAGE_REL_M32R_ADDR24   0x0003
#define IMAGE_REL_M32R_GPREL16  0x0004
#define IMAGE_REL_M32R_PCREL24  0x0005
#define IMAGE_REL_M32R_PCREL16  0x0006
#define IMAGE_REL_M32R_PCREL8   0x0007
#define IMAGE_REL_M32R_REFHALF  0x0008
#define IMAGE_REL_M32R_REFHI    0x0009
#define IMAGE_REL_M32R_REFLO    0x000A
#define IMAGE_REL_M32R_PAIR     0x000B
#define IMAGE_REL_M32R_SECTION  0x000C
#define IMAGE_REL_M32R_SECREL32 0x000D
#define IMAGE_REL_M32R_TOKEN    0x000E

/* Image relocation types for the EBC processor */
#define IMAGE_REL_EBC_ABSOLUTE  0x0000
#define IMAGE_REL_EBC_ADDR32NB  0x0001
#define IMAGE_REL_EBC_REL32     0x0002
#define IMAGE_REL_EBC_SECTION   0x0003
#define IMAGE_REL_EBC_SECREL    0x0004

/* Size of image line number */
#define IMAGE_SIZEOF_LINENUMBER 6

/* Size of image base relocation */
#define IMAGE_SIZEOF_BASE_RELOCATION    8

/* Image base relocation types */
#define IMAGE_REL_BASED_ABSOLUTE        0
#define IMAGE_REL_BASED_HIGH            1
#define IMAGE_REL_BASED_LOW             2
#define IMAGE_REL_BASED_HIGHLOW         3
#define IMAGE_REL_BASED_HIGHADJ         4
#define IMAGE_REL_BASED_MIPS_JMPADDR    5
#define IMAGE_REL_BASED_MIPS_JMPADDR16  9
#define IMAGE_REL_BASED_IA64_IMM64      9
#define IMAGE_REL_BASED_DIR64           10

/* Image archive (static library) format constants */
#define IMAGE_ARCHIVE_START_SIZE        8
#define IMAGE_ARCHIVE_START             "!<arch>\n"
#define IMAGE_ARCHIVE_END               "`\n"
#define IMAGE_ARCHIVE_PAD               "\n"
#define IMAGE_ARCHIVE_LINKER_MEMBER     "/               "
#define IMAGE_ARCHIVE_LONGNAMES_MEMBER  "//              "

/* Size of image archive member header */
#define IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR 60

/* Image resource characteristics */
#define IMAGE_RESOURCE_NAME_IS_STRING       0x80000000L
#define IMAGE_RESOURCE_DATA_IS_DIRECTORY    0x80000000L

/* Image debugging information types */
#define IMAGE_DEBUG_TYPE_UNKNOWN        0L
#define IMAGE_DEBUG_TYPE_COFF           1L
#define IMAGE_DEBUG_TYPE_CODEVIEW       2L
#define IMAGE_DEBUG_TYPE_FPO            3L
#define IMAGE_DEBUG_TYPE_MISC           4L
#define IMAGE_DEBUG_TYPE_EXCEPTION      5L
#define IMAGE_DEBUG_TYPE_FIXUP          6L
#define IMAGE_DEBUG_TYPE_OMAP_TO_SRC    7L
#define IMAGE_DEBUG_TYPE_OMAP_FROM_SRC  8L
#define IMAGE_DEBUG_TYPE_BORLAND        9L
#define IMAGE_DEBUG_TYPE_CLSID          11L

/* Frame types */
#define FRAME_FPO       0
#define FRAME_TRAP      1
#define FRAME_TSS       2
#define FRAME_NONFPO    3

/* Signatures for separate debugging information file */
#define IMAGE_SEPARATE_DEBUG_SIGNATURE  0x4944
#define NON_PAGED_DEBUG_SIGNATURE       0x494E

/* Separate debugging information file header flags */
#define IMAGE_SEPARATE_DEBUG_FLAGS_MASK 0x8000
#define IMAGE_SEPARATE_DEBUG_MISMATCH   0x8000

/* Signature for import object header */
#define IMPORT_OBJECT_HDR_SIG2  0xFFFF

/* Common Language Runtime header flags */
#define COMIMAGE_FLAGS_ILONLY               0x00000001L
#define COMIMAGE_FLAGS_32BITREQUIRED        0x00000002L
#define COMIMAGE_FLAGS_IL_LIBRARY           0x00000004L
#define COMIMAGE_FLAGS_STRONGNAMESIGNED     0x00000008L
#define COMIMAGE_FLAGS_NATIVE_ENTRYPOINT    0x00000010L
#define COMIMAGE_FLAGS_TRACKDEBUGDATA       0x00010000L

/* Common Language Runtime header version numbers */
#define COR_VERSION_MAJOR_V2    2
#define COR_VERSION_MAJOR       COR_VERSION_MAJOR_V2
#define COR_VERSION_MINOR       0

/* Common Language Runtime name lengths */
#define COR_DELETED_NAME_LENGTH     8
#define COR_VTABLEGAP_NAME_LENGTH   8

/* Common Language Runtime header MIH flags */
#define IMAGE_COR_MIH_METHODRVA     0x01
#define IMAGE_COR_MIH_EHRVA         0x02
#define IMAGE_COR_MIH_BASICBLOCK    0x08

/* Common Language Runtime header virtual function table flags */
#define COR_VTABLE_32BIT                            0x01
#define COR_VTABLE_64BIT                            0x02
#define COR_VTABLE_FROM_UNMANAGED                   0x04
#define COR_VTABLE_FROM_UNMANAGED_RETAIN_APPDOMAIN  0x08
#define COR_VTABLE_CALL_MOST_DERIVED                0x10

/* Size of a jump thunk */
#define IMAGE_COR_EATJ_THUNK_SIZE   32

/* Maximum sizes of class and package names */
#define MAX_CLASS_NAME      1024
#define MAX_PACKAGE_NAME    1024

/* Run once flags */
#define RTL_RUN_ONCE_CHECK_ONLY     0x00000001L
#define RTL_RUN_ONCE_ASYNC          0x00000002L
#define RTL_RUN_ONCE_INIT_FAILED    0x00000004L

/* Heap flags */
#define HEAP_NO_SERIALIZE               0x00000001L
#define HEAP_GROWABLE                   0x00000002L
#define HEAP_GENERATE_EXCEPTIONS        0x00000004L
#define HEAP_ZERO_MEMORY                0x00000008L
#define HEAP_REALLOC_IN_PLACE_ONLY      0x00000010L
#define HEAP_TAIL_CHECKING_ENABLED      0x00000020L
#define HEAP_FREE_CHECKING_ENABLED      0x00000040L
#define HEAP_DISABLE_COALESCE_ON_FREE   0x00000080L
#define HEAP_CREATE_ALIGN_16            0x00010000L
#define HEAP_CREATE_ENABLE_TRACING      0x00020000L
#define HEAP_CREATE_ENABLE_EXECUTE      0x00040000L

/* IsTextUnicode() flags */
#define IS_TEXT_UNICODE_ASCII16             0x0001
#define IS_TEXT_UNICODE_REVERSE_ASCII16     0x0010
#define IS_TEXT_UNICODE_STATISTICS          0x0002
#define IS_TEXT_UNICODE_REVERSE_STATISTICS  0x0020
#define IS_TEXT_UNICODE_CONTROLS            0x0004
#define IS_TEXT_UNICODE_REVERSE_CONTROLS    0x0040
#define IS_TEXT_UNICODE_SIGNATURE           0x0008
#define IS_TEXT_UNICODE_REVERSE_SIGNATURE   0x0080
#define IS_TEXT_UNICODE_ILLEGAL_CHARS       0x0100
#define IS_TEXT_UNICODE_ODD_LENGTH          0x0200
#define IS_TEXT_UNICODE_DBCS_LEADBYTE       0x0400
#define IS_TEXT_UNICODE_NULL_BYTES          0x1000
#define IS_TEXT_UNICODE_UNICODE_MASK        0x000F
#define IS_TEXT_UNICODE_REVERSE_MASK        0x00F0
#define IS_TEXT_UNICODE_NOT_UNICODE_MASK    0x0F00
#define IS_TEXT_UNICODE_NOT_ASCII_MASK      0xF000

/* Compression formats */
#define COMPRESSION_FORMAT_NONE     0x0000
#define COMPRESSION_FORMAT_DEFAULT  0x0001
#define COMPRESSION_FORMAT_LZNT1    0x0002

/* Message resource entry flags */
#define MESSAGE_RESOURCE_UNICODE    0x0001

/* Version comparison operators */
#define VER_EQUAL           1
#define VER_GREATER         2
#define VER_GREATER_EQUAL   3
#define VER_LESS            4
#define VER_LESS_EQUAL      5
#define VER_AND             6
#define VER_OR              7

/* Version information types */
#define VER_MINORVERSION        0x00000001L
#define VER_MAJORVERSION        0x00000002L
#define VER_BUILDNUMBER         0x00000004L
#define VER_PLATFORMID          0x00000008L
#define VER_SERVICEPACKMINOR    0x00000010L
#define VER_SERVICEPACKMAJOR    0x00000020L
#define VER_SUITENAME           0x00000040L
#define VER_PRODUCT_TYPE        0x00000080L

/* Version product types */
#define VER_NT_WORKSTATION          0x01
#define VER_NT_DOMAIN_CONTROLLER    0x02
#define VER_NT_SERVER               0x03

/* Version platform identifiers */
#define VER_PLATFORM_WIN32s         0L
#define VER_PLATFORM_WIN32_WINDOWS  1L
#define VER_PLATFORM_WIN32_NT       2L

/* Debugging information types */
#define RTL_CRITSECT_TYPE   0L
#define RTL_RESOURCE_TYPE   1L

/* Critical section spin count flags */
#define RTL_CRITICAL_SECTION_FLAG_NO_DEBUG_INFO 0x01000000L
#define RTL_CRITICAL_SECTION_FLAG_DYNAMIC_SPIN  0x02000000L
#define RTL_CRITICAL_SECTION_FLAG_STATIC_INIT   0x04000000L
#define RTL_CRITICAL_SECTION_ALL_FLAG_BITS      0xFF000000L

/* Critical section debug flags */
#define RTL_CRITICAL_SECTION_DEBUG_FLAG_STATIC_INIT 0x00000001L

/* Security auto inherit flags */
#define SEF_DACL_AUTO_INHERIT               0x00000001L
#define SEF_SACL_AUTO_INHEIRT               0x00000002L
#define SEF_DEFAULT_DESCRIPTOR_FOR_OBJECT   0x00000004L
#define SEF_AVOID_PRIVILEGE_CHECK           0x00000008L
#define SEF_AVOID_OWNER_CHECK               0x00000010L
#define SEF_DEFAULT_OWNER_FROM_PARENT       0x00000020L
#define SEF_DEFAULT_GROUP_FROM_PARENT       0x00000040L
#define SEF_MACL_NO_WRITE_UP                0x00000100L
#define SEF_MACL_NO_READ_UP                 0x00000200L
#define SEF_MACL_NO_EXECUTE_UP              0x00000400L
#define SEF_AVOID_OWNER_RESTRICTION         0x00001000L
#define SEF_MACL_VALID_FLAGS \
    (SEF_MACL_NO_WRITE_UP | SEF_MACL_NO_READ_UP | SEF_MACL_NO_EXECUTE_UP)

/* Wait or timer flags */
#define WT_EXECUTEDEFAULT               0x00000000L
#define WT_EXECUTEINIOTHREAD            0x00000001L
#define WT_EXECUTEINUITHREAD            0x00000002L
#define WT_EXECUTEINWAITTHREAD          0x00000004L
#define WT_EXECUTEONLYONCE              0x00000008L
#define WT_EXECUTELONGFUNCTION          0x00000010L
#define WT_EXECUTEINTIMERTHREAD         0x00000020L
#define WT_EXECUTEINPERSISTENTIOTHREAD  0x00000040L
#define WT_EXECUTEINPERSISTENTTHREAD    0x00000080L
#define WT_TRANSFER_IMPERSONATION       0x00000100L

/* Activation context path types */
#define ACTIVATION_CONTEXT_PATH_TYPE_NONE           1L
#define ACTIVATION_CONTEXT_PATH_TYPE_WIN32_FILE     2L
#define ACTIVATION_CONTEXT_PATH_TYPE_URL            3L
#define ACTIVATION_CONTEXT_PATH_TYPE_ASSEMBLYREF    4L

/* Maximum number of supported operating systems */
#define MAX_SUPPORTED_OS_NUM    4

/* Operating system count special value */
#define INVALID_OS_COUNT    0xFFFF

/* Performance data version number */
#define PERFORMANCE_DATA_VERSION    1

/* ReadThreadProfilingData() flags */
#define READ_THREAD_PROFILING_FLAG_DISPATCHING          0x00000001L
#define READ_THREAD_PROFILING_FLAG_HARDWARE_COUNTERS    0x00000002L

/* DllMain() call reasons */
#define DLL_PROCESS_ATTACH  1L
#define DLL_THREAD_ATTACH   2L
#define DLL_THREAD_DETACH   3L
#define DLL_PROCESS_DETACH  0L

/* Event log read flags */
#define EVENTLOG_SEQUENTIAL_READ    0x00000001L
#define EVENTLOG_SEEK_READ          0x00000002L
#define EVENTLOG_FORWARDS_READ      0x00000004L
#define EVENTLOG_BACKWARDS_READ     0x00000008L

/* Event log event types */
#define EVENTLOG_SUCCESS            0x0000
#define EVENTLOG_ERROR_TYPE         0x0001
#define EVENTLOG_WARNING_TYPE       0x0002
#define EVENTLOG_INFORMATION_TYPE   0x0004
#define EVENTLOG_AUDIT_SUCCESS      0x0008
#define EVENTLOG_AUDIT_FAILURE      0x0010

/* Registry key access rights */
#define KEY_QUERY_VALUE         0x0001L
#define KEY_SET_VALUE           0x0002L
#define KEY_CREATE_SUB_KEY      0x0004L
#define KEY_ENUMERATE_SUB_KEYS  0x0008L
#define KEY_NOTIFY              0x0010L
#define KEY_CREATE_LINK         0x0020L
#define KEY_WOW64_64KEY         0x0100L
#define KEY_WOW64_32KEY         0x0200L
#define KEY_WOW64_RES           0x0300L
#define KEY_ALL_ACCESS          (STANDARD_RIGHTS_REQUIRED | 0x003FL)
#define KEY_READ \
    (STANDARD_RIGHTS_READ | KEY_QUERY_VALUE | KEY_ENUMERATE_SUB_KEYS | KEY_NOTIFY)
#define KEY_WRITE \
    (STANDARD_RIGHTS_WRITE | KEY_SET_VALUE | KEY_CREATE_SUB_KEY)
#define KEY_EXECUTE             KEY_READ

/* Registry key open/create flags */
#define REG_OPTION_RESERVED         0x00000000L
#define REG_OPTION_NON_VOLATILE     0x00000000L
#define REG_OPTION_VOLATILE         0x00000001L
#define REG_OPTION_CREATE_LINK      0x00000002L
#define REG_OPTION_BACKUP_RESTORE   0x00000004L
#define REG_OPTION_OPEN_LINK        0x00000008L
#define REG_LEGAL_OPTION \
    (REG_OPTION_RESERVED | REG_OPTION_NON_VOLATILE | REG_OPTION_VOLATILE | \
    REG_OPTION_CREATE_LINK | REG_OPTION_BACKUP_RESTORE | REG_OPTION_OPEN_LINK)
#define REG_OPEN_LEGAL_OPTION \
    (REG_OPTION_RESERVED | REG_OPTION_BACKUP_RESTORE | REG_OPTION_OPEN_LINK)

/* Registry key open/create dispositions */
#define REG_CREATED_NEW_KEY     0x00000001L
#define REG_OPENED_EXISTING_KEY 0x00000002L

/* Registry hive formats */
#define REG_STANDARD_FORMAT 0x00000001L
#define REG_LATEST_FORMAT   0x00000002L
#define REG_NO_COMPRESSION  0x00000004L

/* Registry key restore flags */
#define REG_WHOLE_HIVE_VOLATILE     0x00000001L
#define REG_REFRESH_HIVE            0x00000002L
#define REG_NO_LAZY_FLUSH           0x00000004L
#define REG_FORCE_RESTORE           0x00000008L
#define REG_APP_HIVE                0x00000010L
#define REG_PROCESS_PRIVATE         0x00000020L
#define REG_START_JOURNAL           0x00000040L
#define REG_HIVE_EXACT_FILE_GROWTH  0x00000080L
#define REG_HIVE_NO_RM              0x00000100L
#define REG_HIVE_SINGLE_LOG         0x00000200L
#define REG_BOOT_HIVE               0x00000400L

/* Registry key change notification flags */
#define REG_NOTIFY_CHANGE_NAME          0x00000001L
#define REG_NOTIFY_CHANGE_ATTRIBUTES    0x00000002L
#define REG_NOTIFY_CHANGE_LAST_SET      0x00000004L
#define REG_NOTIFY_CHANGE_SECURITY      0x00000008L
#define REG_LEGAL_CHANGE_FILTER \
    (REG_NOTIFY_CHANGE_NAME | REG_NOTIFY_CHANGE_ATTRIBUTES | \
    REG_NOTIFY_CHANGE_LAST_SET | REG_NOTIFY_CHANGE_SECURITY)

/* Registry value types */
#define REG_NONE                        0L
#define REG_SZ                          1L
#define REG_EXPAND_SZ                   2L
#define REG_BINARY                      3L
#define REG_DWORD                       4L
#define REG_DWORD_LITTLE_ENDIAN         4L
#define REG_DWORD_BIG_ENDIAN            5L
#define REG_LINK                        6L
#define REG_MULTI_SZ                    7L
#define REG_RESOURCE_LIST               8L
#define REG_FULL_RESOURCE_DESCRIPTOR    9L
#define REG_RESOURCE_REQUIREMENTS_LIST  10L
#define REG_QWORD                       11L
#define REG_QWORD_LITTLE_ENDIAN         11L

/* Service types */
#define SERVICE_KERNEL_DRIVER       0x00000001L
#define SERVICE_FILE_SYSTEM_DRIVER  0x00000002L
#define SERVICE_ADAPTER             0x00000004L
#define SERVICE_RECOGNIZER_DRIVER   0x00000008L
#define SERVICE_DRIVER \
    (SERVICE_KERNEL_DRIVER | SERVICE_FILE_SYSTEM_DRIVER | SERVICE_RECOGNIZER_DRIVER)
#define SERVICE_WIN32_OWN_PROCESS   0x00000010L
#define SERVICE_WIN32_SHARE_PROCESS 0x00000020L
#define SERVICE_WIN32 \
    (SERVICE_WIN32_OWN_PROCESS | SERVICE_WIN32_SHARE_PROCESS)
#define SERVICE_INTERACTIVE_PROCESS 0x00000100L
#define SERVICE_TYPE_ALL \
    (SERVICE_WIN32 | SERVICE_ADAPTER | SERVICE_DRIVER | SERVICE_INTERACTIVE_PROCESS)

/* Service start types */
#define SERVICE_BOOT_START      0x00000000L
#define SERVICE_SYSTEM_START    0x00000001L
#define SERVICE_AUTO_START      0x00000002L
#define SERVICE_DEMAND_START    0x00000003L
#define SERVICE_DISABLED        0x00000004L

/* Service error control types */
#define SERVICE_ERROR_IGNORE    0x00000000L
#define SERVICE_ERROR_NORMAL    0x00000001L
#define SERVICE_ERROR_SEVERE    0x00000002L
#define SERVICE_ERROR_CRITICAL  0x00000003L

/* Service node flags */
#define CM_SERVICE_NETWORK_BOOT_LOAD        0x00000001L
#define CM_SERVICE_VIRTUAL_DISK_BOOT_LOAD   0x00000002L
#define CM_SERVICE_USB_DISK_BOOT_LOAD       0x00000004L
#define CM_SERVICE_VALID_PROMOTION_MASK \
    (CM_SERVICE_NETWORK_BOOT_LOAD | CM_SERVICE_VIRTUAL_DISK_BOOT_LOAD | \
    CM_SERVICE_USB_DISK_BOOT_LOAD)

/* Tape erase modes */
#define TAPE_ERASE_SHORT    0L
#define TAPE_ERASE_LONG     1L

/* Tape preparation types */
#define TAPE_LOAD       0L
#define TAPE_UNLOAD     1L
#define TAPE_TENSION    2L
#define TAPE_LOCK       3L
#define TAPE_UNLOCK     4L
#define TAPE_FORMAT     5L

/* Tapemark types */
#define TAPE_SETMARKS           0L
#define TAPE_FILEMARKS          1L
#define TAPE_SHORT_FILEMARKS    2L
#define TAPE_LONG_FILEMARKS     3L

/* Tape get position modes */
#define TAPE_ABSOLUTE_POSITION          0L
#define TAPE_LOGICAL_POSITION           1L
#define TAPE_PSEUDO_LOGICAL_POSITION    2L

/* Tape set position modes */
#define TAPE_REWIND                 0L
#define TAPE_ABSOLUTE_BLOCK         1L
#define TAPE_LOGICAL_BLOCK          2L
#define TAPE_PSEUDO_LOGICAL_BLOCK   3L
#define TAPE_SPACE_END_OF_DATA      4L
#define TAPE_SPACE_RELATIVE_BLOCKS  5L
#define TAPE_SPACE_FILEMARKS        6L
#define TAPE_SPACE_SEQUENTIAL_FMKS  7L
#define TAPE_SPACE_SETMARKS         8L
#define TAPE_SPACE_SEQUENTIAL_SMKS  9L

/* Tape drive features (low) */
#define TAPE_DRIVE_FIXED            0x00000001L
#define TAPE_DRIVE_SELECT           0x00000002L
#define TAPE_DRIVE_INITIATOR        0x00000004L
#define TAPE_DRIVE_ERASE_SHORT      0x00000010L
#define TAPE_DRIVE_ERASE_LONG       0x00000020L
#define TAPE_DRIVE_ERASE_BOP_ONLY   0x00000040L
#define TAPE_DRIVE_ERASE_IMMEDIATE  0x00000080L
#define TAPE_DRIVE_TAPE_CAPACITY    0x00000100L
#define TAPE_DRIVE_TAPE_REMAINING   0x00000200L
#define TAPE_DRIVE_FIXED_BLOCK      0x00000400L
#define TAPE_DRIVE_VARIABLE_BLOCK   0x00000800L
#define TAPE_DRIVE_WRITE_PROTECT    0x00001000L
#define TAPE_DRIVE_EOT_WZ_SIZE      0x00002000L
#define TAPE_DRIVE_ECC              0x00010000L
#define TAPE_DRIVE_COMPRESSION      0x00020000L
#define TAPE_DRIVE_PADDING          0x00040000L
#define TAPE_DRIVE_REPORT_SMKS      0x00080000L
#define TAPE_DRIVE_GET_ABSOLUTE_BLK 0x00100000L
#define TAPE_DRIVE_GET_LOGICAL_BLK  0x00200000L
#define TAPE_DRIVE_SET_EOT_WZ_SIZE  0x00400000L
#define TAPE_DRIVE_EJECT_MEDIA      0x01000000L
#define TAPE_DRIVE_CLEAN_REQUESTS   0x02000000L
#define TAPE_DRIVE_SET_CMP_BOP_ONLY 0x04000000L

/* Tape drive features (high) */
#define TAPE_DRIVE_LOAD_UNLOAD      0x80000001L
#define TAPE_DRIVE_TENSION          0x80000002L
#define TAPE_DRIVE_LOCK_UNLOCK      0x80000004L
#define TAPE_DRIVE_REWIND_IMMEDIATE 0x80000008L
#define TAPE_DRIVE_SET_BLOCK_SIZE   0x80000010L
#define TAPE_DRIVE_LOAD_UNLD_IMMED  0x80000020L
#define TAPE_DRIVE_TENSION_IMMED    0x80000040L
#define TAPE_DRIVE_LOCK_UNLK_IMMED  0x80000080L
#define TAPE_DRIVE_SET_ECC          0x80000100L
#define TAPE_DRIVE_SET_COMPRESSION  0x80000200L
#define TAPE_DRIVE_SET_PADDING      0x80000400L
#define TAPE_DRIVE_SET_REPORT_SMKS  0x80000800L
#define TAPE_DRIVE_ABSOLUTE_BLK     0x80001000L
#define TAPE_DRIVE_ABS_BLK_IMMED    0x80002000L
#define TAPE_DRIVE_LOGICAL_BLK      0x80004000L
#define TAPE_DRIVE_LOG_BLK_IMMED    0x80008000L
#define TAPE_DRIVE_END_OF_DATA      0x80010000L
#define TAPE_DRIVE_RELATIVE_BLKS    0x80020000L
#define TAPE_DRIVE_FILEMARKS        0x80040000L
#define TAPE_DRIVE_SEQUENTIAL_FMKS  0x80080000L
#define TAPE_DRIVE_SETMARKS         0x80100000L
#define TAPE_DRIVE_SEQUENTIAL_SMKS  0x80200000L
#define TAPE_DRIVE_REVERSE_POSITION 0x80400000L
#define TAPE_DRIVE_SPACE_IMMEDIATE  0x80800000L
#define TAPE_DRIVE_WRITE_SETMARKS   0x81000000L
#define TAPE_DRIVE_WRITE_FILEMARKS  0x82000000L
#define TAPE_DRIVE_WRITE_SHORT_FMKS 0x84000000L
#define TAPE_DRIVE_WRITE_LONG_FMKS  0x88000000L
#define TAPE_DRIVE_WRITE_MARK_IMMED 0x90000000L
#define TAPE_DRIVE_FORMAT           0xA0000000L
#define TAPE_DRIVE_FORMAT_IMMEDIATE 0xB0000000L

/* Tape partition types */
#define TAPE_FIXED_PARTITIONS       0L
#define TAPE_SELECT_PARTITIONS      1L
#define TAPE_INITIATOR_PARTITIONS   2L

/* Tape drive WMI methods */
#define TAPE_QUERY_DRIVE_PARAMETERS     0L
#define TAPE_QUERY_MEDIA_CAPACITY       1L
#define TAPE_CHECK_FOR_DRIVE_PROBLEM    2L
#define TAPE_QUERY_IO_ERROR_DATA        3L
#define TAPE_QUERY_DEVICE_ERROR_DATA    4L

/* Activation context sections */
#define ACTIVATION_CONTEXT_SECTION_ASSEMBLY_INFORMATION         1L
#define ACTIVATION_CONTEXT_SECTION_DLL_REDIRECTION              2L
#define ACTIVATION_CONTEXT_SECTION_WINDOW_CLASS_REDIRECTION     3L
#define ACTIVATION_CONTEXT_SECTION_COM_SERVER_REDIRECTION       4L
#define ACTIVATION_CONTEXT_SECTION_COM_INTERFACE_REDIRECTION    5L
#define ACTIVATION_CONTEXT_SECTION_COM_TYPE_LIBRARY_REDIRECTION 6L
#define ACTIVATION_CONTEXT_SECTION_COM_PROGID_REDIRECTION       7L
#define ACTIVATION_CONTEXT_SECTION_GLOBAL_OBJECT_RENAME_TABLE   8L
#define ACTIVATION_CONTEXT_SECTION_CLR_SURROGATES               9L
#define ACTIVATION_CONTEXT_SECTION_APPLICATION_SETTINGS         10L
#define ACTIVATION_CONTEXT_SECTION_COMPATIBILITY_INFO           11L

/* Processor number */
typedef struct _PROCESSOR_NUMBER {
    WORD    Group;
    BYTE    Number;
    BYTE    Reserved;
} PROCESSOR_NUMBER;
typedef PROCESSOR_NUMBER    *PPROCESSOR_NUMBER;

/* Group affinity */
typedef struct _GROUP_AFFINITY {
    KAFFINITY   Mask;
    WORD        Group;
    WORD        Reserved[3];
} GROUP_AFFINITY;
typedef GROUP_AFFINITY  *PGROUP_AFFINITY;

/* Large integer */
typedef union _LARGE_INTEGER {
    struct {
        DWORD   LowPart;
        LONG    HighPart;
    };
    struct {
        DWORD   LowPart;
        LONG    HighPart;
    } u;
    LONGLONG    QuadPart;
} LARGE_INTEGER;
typedef LARGE_INTEGER   *PLARGE_INTEGER;

/* Unsigned large integer */
typedef union _ULARGE_INTEGER {
    struct {
        DWORD   LowPart;
        DWORD   HighPart;
    };
    struct {
        DWORD   LowPart;
        DWORD   HighPart;
    } u;
    ULONGLONG   QuadPart;
} ULARGE_INTEGER;
typedef ULARGE_INTEGER  *PULARGE_INTEGER;

/* Locally unique identifier */
typedef struct _LUID {
    DWORD   LowPart;
    LONG    HighPart;
} LUID;
typedef LUID    *PLUID;

/* Doubly linked list entry */
typedef struct _LIST_ENTRY {
    struct _LIST_ENTRY  *Flink;
    struct _LIST_ENTRY  *Blink;
} LIST_ENTRY;
typedef LIST_ENTRY  *PLIST_ENTRY;
typedef LIST_ENTRY  *RESTRICTED_POINTER PRLIST_ENTRY;

/* Singly linked list entry */
typedef struct _SINGLE_LIST_ENTRY {
    struct _SINGLE_LIST_ENTRY   *Next;
} SINGLE_LIST_ENTRY;
typedef SINGLE_LIST_ENTRY   *PSINGLE_LIST_ENTRY;

/* Doubly linked list (32-bit version) */
typedef struct _LIST_ENTRY32 {
    DWORD   Flink;
    DWORD   Blink;
} LIST_ENTRY32;
typedef LIST_ENTRY32    *PLIST_ENTRY32;

/* Doubly linked list (64-bit version) */
typedef struct _LIST_ENTRY64 {
    ULONGLONG   Flink;
    ULONGLONG   Blink;
} LIST_ENTRY64;
typedef LIST_ENTRY64    *PLIST_ENTRY64;

/* Context chunk */
typedef struct _CONTEXT_CHUNK {
    LONG    Offset;
    DWORD   Length;
} CONTEXT_CHUNK;
typedef CONTEXT_CHUNK   *PCONTEXT_CHUNK;

/* Extended context */
typedef struct _CONTEXT_EX {
    CONTEXT_CHUNK   All;
    CONTEXT_CHUNK   Legacy;
    CONTEXT_CHUNK   XState;
} CONTEXT_EX;
typedef CONTEXT_EX  *PCONTEXT_EX;

/* Floating save area for the x86 context */
#ifdef _X86_
typedef struct _FLOATING_SAVE_AREA {
    DWORD   ControlWord;
    DWORD   StatusWord;
    DWORD   TagWord;
    DWORD   ErrorOffset;
    DWORD   ErrorSelector;
    DWORD   DataOffset;
    DWORD   DataSelector;
    BYTE    RegisterArea[SIZE_OF_80387_REGISTERS];
    DWORD   Cr0NpxState;
} FLOATING_SAVE_AREA;
typedef FLOATING_SAVE_AREA  *PFLOATING_SAVE_AREA;
#endif

/* Context record for the x86 processor */
#ifdef _X86_
typedef struct _CONTEXT {
    DWORD               ContextFlags;
    DWORD               Dr0;
    DWORD               Dr1;
    DWORD               Dr2;
    DWORD               Dr3;
    DWORD               Dr6;
    DWORD               Dr7;
    FLOATING_SAVE_AREA  FloatSave;
    DWORD               SegGs;
    DWORD               SegFs;
    DWORD               SegEs;
    DWORD               SegDs;
    DWORD               Edi;
    DWORD               Esi;
    DWORD               Ebx;
    DWORD               Edx;
    DWORD               Ecx;
    DWORD               Eax;
    DWORD               Ebp;
    DWORD               Eip;
    DWORD               SegCs;
    DWORD               EFlags;
    DWORD               Esp;
    DWORD               SegSs;
    BYTE                ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
} CONTEXT;
typedef CONTEXT *PCONTEXT;
#endif

/* Context record for the Alpha processor */
#ifdef _ALPHA_
typedef struct _CONTEXT {
    ULONGLONG   FltF0;
    ULONGLONG   FltF1;
    ULONGLONG   FltF2;
    ULONGLONG   FltF3;
    ULONGLONG   FltF4;
    ULONGLONG   FltF5;
    ULONGLONG   FltF6;
    ULONGLONG   FltF7;
    ULONGLONG   FltF8;
    ULONGLONG   FltF9;
    ULONGLONG   FltF10;
    ULONGLONG   FltF11;
    ULONGLONG   FltF12;
    ULONGLONG   FltF13;
    ULONGLONG   FltF14;
    ULONGLONG   FltF15;
    ULONGLONG   FltF16;
    ULONGLONG   FltF17;
    ULONGLONG   FltF18;
    ULONGLONG   FltF19;
    ULONGLONG   FltF20;
    ULONGLONG   FltF21;
    ULONGLONG   FltF22;
    ULONGLONG   FltF23;
    ULONGLONG   FltF24;
    ULONGLONG   FltF25;
    ULONGLONG   FltF26;
    ULONGLONG   FltF27;
    ULONGLONG   FltF28;
    ULONGLONG   FltF29;
    ULONGLONG   FltF30;
    ULONGLONG   FltF31;
    ULONGLONG   IntV0;
    ULONGLONG   IntT0;
    ULONGLONG   IntT1;
    ULONGLONG   IntT2;
    ULONGLONG   IntT3;
    ULONGLONG   IntT4;
    ULONGLONG   IntT5;
    ULONGLONG   IntT6;
    ULONGLONG   IntT7;
    ULONGLONG   IntS0;
    ULONGLONG   IntS1;
    ULONGLONG   IntS2;
    ULONGLONG   IntS3;
    ULONGLONG   IntS4;
    ULONGLONG   IntS5;
    ULONGLONG   IntFp;
    ULONGLONG   IntA0;
    ULONGLONG   IntA1;
    ULONGLONG   IntA2;
    ULONGLONG   IntA3;
    ULONGLONG   IntA4;
    ULONGLONG   IntA5;
    ULONGLONG   IntT8;
    ULONGLONG   IntT9;
    ULONGLONG   IntT10;
    ULONGLONG   IntT11;
    ULONGLONG   IntRa;
    ULONGLONG   IntT12;
    ULONGLONG   IntAt;
    ULONGLONG   IntGp;
    ULONGLONG   IntSp;
    ULONGLONG   IntZero;
    ULONGLONG   Fpcr;
    ULONGLONG   SoftFpcr;
    ULONGLONG   Fir;
    DWORD       Psr;
    DWORD       ContextFlags;
    DWORD       Fill[4];
} CONTEXT;
typedef CONTEXT *PCONTEXT;
#endif

/* Selector entry */
typedef struct _LDT_ENTRY {
    WORD    LimitLow;
    WORD    BaseLow;
    union {
        struct {
            BYTE    BaseMid;
            BYTE    Flags1;
            BYTE    Flags2;
            BYTE    BaseHi;
        } Bytes;
        struct {
            DWORD   BaseMid     : 8;
            DWORD   Type        : 5;
            DWORD   Dpl         : 2;
            DWORD   Pres        : 1;
            DWORD   LimitHi     : 4;
            DWORD   Sys         : 1;
            DWORD   Reserved_0  : 1;
            DWORD   Default_Big : 1;
            DWORD   Granularity : 1;
            DWORD   BaseHi      : 8;
        } Bits;
    } HighWord;
} LDT_ENTRY;
typedef LDT_ENTRY   *PLDT_ENTRY;

/* WOW64 floating point area */
typedef struct _WOW64_FLOATING_SAVE_AREA {
    DWORD   ControlWord;
    DWORD   StatusWord;
    DWORD   TagWord;
    DWORD   ErrorOffset;
    DWORD   ErrorSelector;
    DWORD   DataOffset;
    DWORD   DataSelector;
    BYTE    RegisterArea[WOW64_SIZE_OF_80387_REGISTERS];
    DWORD   Cr0NpxState;
} WOW64_FLOATING_SAVE_AREA;
typedef WOW64_FLOATING_SAVE_AREA    *PWOW64_FLOATING_SAVE_AREA;

/* WOW64 context record */
typedef struct _WOW64_CONTEXT {
    DWORD                       ContextFlags;
    DWORD                       Dr0;
    DWORD                       Dr1;
    DWORD                       Dr2;
    DWORD                       Dr3;
    DWORD                       Dr6;
    DWORD                       Dr7;
    WOW64_FLOATING_SAVE_AREA    FloatSave;
    DWORD                       SegGs;
    DWORD                       SegFs;
    DWORD                       SegEs;
    DWORD                       SegDs;
    DWORD                       Edi;
    DWORD                       Esi;
    DWORD                       Ebx;
    DWORD                       Edx;
    DWORD                       Ecx;
    DWORD                       Eax;
    DWORD                       Ebp;
    DWORD                       Eip;
    DWORD                       SegCs;
    DWORD                       EFlags;
    DWORD                       Esp;
    DWORD                       SegSs;
    BYTE                        ExtendedRegisters[WOW64_MAXIMUM_SUPPORTED_EXTENSION];
} WOW64_CONTEXT;
typedef WOW64_CONTEXT   *PWOW64_CONTEXT;

/* WOW64 selector entry */
typedef struct _WOW64_LDT_ENTRY {
    WORD    LimitLow;
    WORD    BaseLow;
    union {
        struct {
            BYTE    BaseMid;
            BYTE    Flags1;
            BYTE    Flags2;
            BYTE    BaseHi;
        } Bytes;
        struct {
            DWORD   BaseMid     : 8;
            DWORD   Type        : 5;
            DWORD   Dpl         : 2;
            DWORD   Pres        : 1;
            DWORD   LimitHi     : 4;
            DWORD   Sys         : 1;
            DWORD   Reserved_0  : 1;
            DWORD   Default_Big : 1;
            DWORD   Granularity : 1;
            DWORD   BaseHi      : 8;
        } Bits;
    } HighWord;
} WOW64_LDT_ENTRY;
typedef WOW64_LDT_ENTRY *PWOW64_LDT_ENTRY;

/* WOW64 descriptor table entry */
typedef struct _WOW64_DESCRIPTOR_TABLE_ENTRY {
    DWORD           Selector;
    WOW64_LDT_ENTRY Descriptor;
} WOW64_DESCRIPTOR_TABLE_ENTRY;
typedef WOW64_DESCRIPTOR_TABLE_ENTRY    *PWOW64_DESCRIPTOR_TABLE_ENTRY;

/* Exception record */
typedef struct _EXCEPTION_RECORD {
    DWORD                       ExceptionCode;
    DWORD                       ExceptionFlags;
    struct _EXCEPTION_RECORD    *ExceptionRecord;
    PVOID                       ExceptionAddress;
    DWORD                       NumberParameters;
    ULONG_PTR                   ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD;
typedef EXCEPTION_RECORD    *PEXCEPTION_RECORD;

/* Exception record (32-bit version) */
typedef struct _EXCEPTION_RECORD32 {
    DWORD   ExceptionCode;
    DWORD   ExceptionFlags;
    DWORD   ExceptionRecord;
    DWORD   ExceptionAddress;
    DWORD   NumberParameters;
    DWORD   ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD32;
typedef EXCEPTION_RECORD32  *PEXCEPTION_RECORD32;

/* Exception record (64-bit version) */
typedef struct _EXCEPTION_RECORD64 {
    DWORD   ExceptionCode;
    DWORD   ExceptionFlags;
    DWORD64 ExceptionRecord;
    DWORD64 ExceptionAddress;
    DWORD   NumberParameters;
    DWORD   __unusedAlignment;
    DWORD64 ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD64;
typedef EXCEPTION_RECORD64  *PEXCEPTION_RECORD64;

/* Pointers to exception and context records */
typedef struct _EXCEPTION_POINTERS {
    PEXCEPTION_RECORD   ExceptionRecord;
    PCONTEXT            ContextRecord;
} EXCEPTION_POINTERS;
typedef EXCEPTION_POINTERS  *PEXCEPTION_POINTERS;

/* Opaque data types related to security */
typedef PVOID   PACCESS_TOKEN;
typedef PVOID   PSECURITY_DESCRIPTOR;
typedef PVOID   PSID;

/* Generic mapping */
typedef struct _GENERIC_MAPPING {
    ACCESS_MASK GenericRead;
    ACCESS_MASK GenericWrite;
    ACCESS_MASK GenericExecute;
    ACCESS_MASK GenericAll;
} GENERIC_MAPPING;
typedef GENERIC_MAPPING *PGENERIC_MAPPING;

/* LUID and attributes */
#include <pshpack4.h>
typedef struct _LUID_AND_ATTRIBUTES {
    LUID    Luid;
    DWORD   Attributes;
} LUID_AND_ATTRIBUTES;
typedef LUID_AND_ATTRIBUTES *PLUID_AND_ATTRIBUTES;
#include <poppack.h>

/* SID identifier authority */
typedef struct _SID_IDENTIFIER_AUTHORITY {
    BYTE    Value[6];
} SID_IDENTIFIER_AUTHORITY;
typedef SID_IDENTIFIER_AUTHORITY    *PSID_IDENTIFIER_AUTHORITY;

/* Security identifier */
typedef struct _SID {
    BYTE                        Revision;
    BYTE                        SubAuthorityCount;
    SID_IDENTIFIER_AUTHORITY    IdentifierAuthority;
    DWORD                       SubAuthority[ANYSIZE_ARRAY];
} SID;
typedef SID *PISID;

/* Maximum SID size */
#define SECURITY_MAX_SID_SIZE \
    (sizeof( SID ) + ((SID_MAX_SUB_AUTHORITIES - 1) * sizeof( DWORD )))

/* SID types */
typedef enum _SID_NAME_USE {
    SidTypeUser             = 1,
    SidTypeGroup            = 2,
    SidTypeDomain           = 3,
    SidTypeAlias            = 4,
    SidTypeWellKnownGroup   = 5,
    SidTypeDeletedAccount   = 6,
    SidTypeInvalid          = 7,
    SidTypeUnknown          = 8,
    SidTypeComputer         = 9,
    SidTypeLabel            = 10
} SID_NAME_USE;
typedef SID_NAME_USE    *PSID_NAME_USE;

/* SID and attributes */
typedef struct _SID_AND_ATTRIBUTES {
    PSID    Sid;
    DWORD   Attributes;
} SID_AND_ATTRIBUTES;
typedef SID_AND_ATTRIBUTES  *PSID_AND_ATTRIBUTES;

/* SID and attributes hash */
typedef struct _SID_AND_ATTRIBUTES_HASH {
    DWORD               SidCounty;
    PSID_AND_ATTRIBUTES SidAttr;
    SID_HASH_ENTRY      Hash[SID_HASH_SIZE];
} SID_AND_ATTRIBUTES_HASH;
typedef SID_AND_ATTRIBUTES_HASH *PSID_AND_ATTRIBUTES_HASH;

/* Well known SID types */
typedef enum {
    WinNullSid                                  = 0,
    WinWorldSid                                 = 1,
    WinLocalSid                                 = 2,
    WinCreatorOwnerSid                          = 3,
    WinCreatorGroupSid                          = 4,
    WinCreatorOwnerServerSid                    = 5,
    WinCreatorGroupServerSid                    = 6,
    WinNtAuthoritySid                           = 7,
    WinDialupSid                                = 8,
    WinNetworkSid                               = 9,
    WinBatchSid                                 = 10,
    WinInteractiveSid                           = 11,
    WinServiceSid                               = 12,
    WinAnonymousSid                             = 13,
    WinProxySid                                 = 14,
    WinEnterpriseControllersSid                 = 15,
    WinSelfSid                                  = 16,
    WinAuthenticatedUserSid                     = 17,
    WinRestrictedCodeSid                        = 18,
    WinTerminalServerSid                        = 19,
    WinRemoteLogonIdSid                         = 20,
    WinLogonIdsSid                              = 21,
    WinLocalSystemSid                           = 22,
    WinLocalServiceSid                          = 23,
    WinNetworkServiceSid                        = 24,
    WinBuiltinDomainSid                         = 25,
    WinBuiltinAdministratorsSid                 = 26,
    WinBuiltinUsersSid                          = 27,
    WinBuiltinGuestsSid                         = 28,
    WinBuiltinPowerUsersSid                     = 29,
    WinBuiltinAccountOperatorsSid               = 30,
    WinBuiltinSystemOperatorsSid                = 31,
    WinBuiltinPrintOperatorsSid                 = 32,
    WinBuiltinBackupOperatorsSid                = 33,
    WinBuiltinReplicatorSid                     = 34,
    WinBuiltinPreWindows2000CompatibleAccessSid = 35,
    WinBuiltinRemoteDesktopUsersSid             = 36,
    WinBuiltinNetworkConfigurationOperatorsSid  = 37,
    WinAccountAdministratorSid                  = 38,
    WinAccountGuestSid                          = 39,
    WinAccountKrbtgtSid                         = 40,
    WinAccountDomainAdminsSid                   = 41,
    WinAccountDomainUsersSid                    = 42,
    WinAccountDomainGuestsSid                   = 43,
    WinAccountComputersSid                      = 44,
    WinAccountControllersSid                    = 45,
    WinAccountCertAdminsSid                     = 46,
    WinAccountSchemaAdminsSid                   = 47,
    WinAccountEnterpriseAdminsSid               = 48,
    WinAccountPolicyAdminsSid                   = 49,
    WinAccountRasAndIasServersSid               = 50,
    WinNTLMAuthenticationSid                    = 51,
    WinDigestAuthenticationSid                  = 52,
    WinSChannelAuthenticationSid                = 53,
    WinThisOrganizationSid                      = 54,
    WinOtherOrganizationSid                     = 55,
    WinBuiltinIncomingForestTrustBuildersSid    = 56,
    WinBuiltinPerfMonitoringUsersSid            = 57,
    WinBuiltinPerfLoggingUsersSid               = 58,
    WinBuiltinAuthorizationAccessSid            = 59,
    WinBuiltinTerminalServerLicenseServersSid   = 60,
    WinBuiltinDCOMUsersSid                      = 61,
    WinBuiltinIUsersSid                         = 62,
    WinIUserSid                                 = 63,
    WinBuiltinCryptoOperatorsSid                = 64,
    WinUntrustedLabelSid                        = 65,
    WinLowLabelSid                              = 66,
    WinMediumLabelSid                           = 67,
    WinHighLabelSid                             = 68,
    WinSystemLabelSid                           = 69,
    WinWriteRestrictedCodeSid                   = 70,
    WinCreatorOwnerRightsSid                    = 71,
    WinCacheablePrincipalsGroupSid              = 72,
    WinNonCacheablePrincipalsGroupSid           = 73,
    WinEnterpriseReadonlyControllersSid         = 74,
    WinAccountReadonlyControllersSid            = 75,
    WinBuiltinEventLogReadersGroup              = 76,
    WinNewEnterpriseReadonlyControllersSid      = 77,
    WinBuiltinCertSvcDComAccessGroup            = 78,
    WinMediumPlusLabelSid                       = 79,
    WinLocalLogonSid                            = 80,
    WinConsoleLogonSid                          = 81,
    WinThisOrganizationCertificateSid           = 82
} WELL_KNOWN_SID_TYPE;

/* Access control list */
typedef struct _ACL {
    BYTE    AclRevision;
    BYTE    Sbz1;
    WORD    AclSize;
    WORD    AceCount;
    WORD    Sbz2;
} ACL;
typedef ACL *PACL;

/* ACE header */
typedef struct _ACE_HEADER {
    BYTE    AceType;
    BYTE    AceFlags;
    WORD    AceSize;
} ACE_HEADER;
typedef ACE_HEADER  *PACE_HEADER;

/* Access allowed ACE */
typedef struct _ACCESS_ALLOWED_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} ACCESS_ALLOWED_ACE;
typedef ACCESS_ALLOWED_ACE  *PACCESS_ALLOWED_ACE;

/* Access denied ACE */
typedef struct _ACCESS_DENIED_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} ACCESS_DENIED_ACE;
typedef ACCESS_DENIED_ACE   *PACCESS_DENIED_ACE;

/* System audit ACE */
typedef struct _SYSTEM_AUDIT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} SYSTEM_AUDIT_ACE;
typedef SYSTEM_AUDIT_ACE    *PSYSTEM_AUDIT_ACE;

/* System alarm ACE */
typedef struct _SYSTEM_ALARM_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} SYSTEM_ALARM_ACE;
typedef SYSTEM_ALARM_ACE    *PSYSTEM_ALARM_ACE;

/* System mandatory label ACE */
typedef struct _SYSTEM_MANDATORY_LABEL_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} SYSTEM_MANDATORY_LABEL_ACE;
typedef SYSTEM_MANDATORY_LABEL_ACE  *PSYSTEM_MANDATORY_LABEL_ACE;

/* Access allowed object ACE */
typedef struct _ACCESS_ALLOWED_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} ACCESS_ALLOWED_OBJECT_ACE;
typedef ACCESS_ALLOWED_OBJECT_ACE   *PACCESS_ALLOWED_OBJECT_ACE;

/* Access denied object ACE */
typedef struct _ACCESS_DENIED_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} ACCESS_DENIED_OBJECT_ACE;
typedef ACCESS_DENIED_OBJECT_ACE    *PACCESS_DENIED_OBJECT_ACE;

/* System audit object ACE */
typedef struct _SYSTEM_AUDIT_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} SYSTEM_AUDIT_OBJECT_ACE;
typedef SYSTEM_AUDIT_OBJECT_ACE *PSYSTEM_AUDIT_OBJECT_ACE;

/* System alarm object ACE */
typedef struct _SYSTEM_ALARM_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} SYSTEM_ALARM_OBJECT_ACE;
typedef SYSTEM_ALARM_OBJECT_ACE *PSYSTEM_ALARM_OBJECT_ACE;

/* Access allowed callback ACE */
typedef struct _ACCESS_ALLOWED_CALLBACK_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} ACCESS_ALLOWED_CALLBACK_ACE;
typedef ACCESS_ALLOWED_CALLBACK_ACE *PACCESS_ALLOWED_CALLBACK_ACE;

/* Access denied callback ACE */
typedef struct _ACCESS_DENIED_CALLBACK_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} ACCESS_DENIED_CALLBACK_ACE;
typedef ACCESS_DENIED_CALLBACK_ACE  *PACCESS_DENIED_CALLBACK_ACE;

/* System audit callback ACE */
typedef struct _SYSTEM_AUDIT_CALLBACK_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} SYSTEM_AUDIT_CALLBACK_ACE;
typedef SYSTEM_AUDIT_CALLBACK_ACE   *PSYSTEM_AUDIT_CALLBACK_ACE;

/* System alarm callback ACE */
typedef struct _SYSTEM_ALARM_CALLBACK_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       SidStart;
} SYSTEM_ALARM_CALLBACK_ACE;
typedef SYSTEM_ALARM_CALLBACK_ACE   *PSYSTEM_ALARM_CALLBACK_ACE;

/* Access allowed callback object ACE */
typedef struct _ACCESS_ALLOWED_CALLBACK_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} ACCESS_ALLOWED_CALLBACK_OBJECT_ACE;
typedef ACCESS_ALLOWED_CALLBACK_OBJECT_ACE  *PACCESS_ALLOWED_CALLBACK_OBJECT_ACE;

/* Access denied callback object ACE */
typedef struct _ACCESS_DENIED_CALLBACK_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} ACCESS_DENIED_CALLBACK_OBJECT_ACE;
typedef ACCESS_DENIED_CALLBACK_OBJECT_ACE   *PACCESS_DENIED_CALLBACK_OBJECT_ACE;

/* System audit callback object ACE */
typedef struct _SYSTEM_AUDIT_CALLBACK_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} SYSTEM_AUDIT_CALLBACK_OBJECT_ACE;
typedef SYSTEM_AUDIT_CALLBACK_OBJECT_ACE    *PSYSTEM_AUDIT_CALLBACK_OBJECT_ACE;

/* System alarm callback object ACE */
typedef struct _SYSTEM_ALARM_CALLBACK_OBJECT_ACE {
    ACE_HEADER  Header;
    ACCESS_MASK Mask;
    DWORD       Flags;
    GUID        ObjectType;
    GUID        InheritedObjectType;
    DWORD       SidStart;
} SYSTEM_ALARM_CALLBACK_OBJECT_ACE;
typedef SYSTEM_ALARM_CALLBACK_OBJECT_ACE    *PSYSTEM_ALARM_CALLBACK_OBJECT_ACE;

/* ACL information classes */
typedef enum _ACL_INFORMATION_CLASS {
    AclRevisionInformation  = 1,
    AclSizeInformation      = 2
} ACL_INFORMATION_CLASS;

/* ACL revision information */
typedef struct _ACL_REVISION_INFORMATION {
    DWORD   AclRevision;
} ACL_REVISION_INFORMATION;
typedef ACL_REVISION_INFORMATION    *PACL_REVISION_INFORMATION;

/* ACL size information */
typedef struct _ACL_SIZE_INFORMATION {
    DWORD   AceCount;
    DWORD   AclBytesInUse;
    DWORD   AclBytesFree;
} ACL_SIZE_INFORMATION;
typedef ACL_SIZE_INFORMATION    *PACL_SIZE_INFORMATION;

/* Relative security descriptor */
typedef struct _SECURITY_DESCRIPTOR_RELATIVE {
    BYTE                        Revision;
    BYTE                        Sbz1;
    SECURITY_DESCRIPTOR_CONTROL Control;
    DWORD                       Owner;
    DWORD                       Group;
    DWORD                       Sacl;
    DWORD                       Dacl;
} SECURITY_DESCRIPTOR_RELATIVE;
typedef SECURITY_DESCRIPTOR_RELATIVE    *PISECURITY_DESCRIPTOR_RELATIVE;

/* Security descriptor */
typedef struct _SECURITY_DESCRIPTOR {
    BYTE                        Revision;
    BYTE                        Sbz1;
    SECURITY_DESCRIPTOR_CONTROL Control;
    PSID                        Owner;
    PSID                        Group;
    PACL                        Sacl;
    PACL                        Dacl;
} SECURITY_DESCRIPTOR;
typedef SECURITY_DESCRIPTOR *PISECURITY_DESCRIPTOR;

/* Security descriptor minimum length */
#define SECURITY_DESCRIPTOR_MIN_LENGTH  sizeof( SECURITY_DESCRIPTOR )

/* Object type list */
typedef struct _OBJECT_TYPE_LIST {
    WORD    Level;
    WORD    Sbz;
    GUID    *ObjectType;
} OBJECT_TYPE_LIST;
typedef OBJECT_TYPE_LIST    *POBJECT_TYPE_LIST;

/* Audit event types */
typedef enum _AUDIT_EVENT_TYPE {
    AuditEventObjectAccess,
    AuditEventDirectoryServiceAccess
} AUDIT_EVENT_TYPE;

/* Privilege set */
typedef struct _PRIVILEGE_SET {
    DWORD               PrivilegeCount;
    DWORD               Control;
    LUID_AND_ATTRIBUTES Privilege[ANYSIZE_ARRAY];
} PRIVILEGE_SET;
typedef PRIVILEGE_SET   *PPRIVILEGE_SET;

/* Access reason types */
typedef enum _ACCESS_REASON_TYPE {
    AccessReasonNone                = 0x00000000,
    AccessReasonAllowedAce          = 0x00010000,
    AccessReasonDeniedAce           = 0x00020000,
    AccessReasonAllowedParentAce    = 0x00030000,
    AccessReasonDeniedParentAce     = 0x00040000,
    AccessReasonMissingPrivilege    = 0x00100000,
    AccessReasonFromPrivilege       = 0x00200000,
    AccessReasonIntegrityLevel      = 0x00300000,
    AccessReasonOwnership           = 0x00400000,
    AccessReasonNullDacl            = 0x00500000,
    AccessReasonEmptyDacl           = 0x00600000,
    AccessReasonNoSD                = 0x00700000,
    AccessReasonNoGrant             = 0x00800000
} ACCESS_REASON_TYPE;

/* Access reasons */
typedef struct _ACCESS_REASONS {
    ACCESS_REASON   Data[32];
} ACCESS_REASONS;
typedef ACCESS_REASONS  *PACCESS_REASONS;

/* Security descriptor */
typedef struct _SE_SECURITY_DESCRIPTOR {
    DWORD                   Size;
    DWORD                   Flags;
    PSECURITY_DESCRIPTOR    SecurityDescriptor;
} SE_SECURITY_DESCRIPTOR;
typedef SE_SECURITY_DESCRIPTOR  *PSE_SECURITY_DESCRIPTOR;

/* Security access request */
typedef struct _SE_ACCESS_REQUEST {
    DWORD                   Size;
    PSE_SECURITY_DESCRIPTOR SeSecurityDescriptor;
    ACCESS_MASK             DesiredAccess;
    ACCESS_MASK             PreviouslyGrantedAccess;
    PSID                    PrincipalSelfSid;
    PGENERIC_MAPPING        GenericMapping;
    DWORD                   ObjectTypeListCount;
    POBJECT_TYPE_LIST       ObjectTypeList;
} SE_ACCESS_REQUEST;
typedef SE_ACCESS_REQUEST   *PSE_ACCESS_REQUEST;

/* Security access reply */
typedef struct _SE_ACCESS_REPLY {
    DWORD           Size;
    DWORD           ResultListCount;
    PACCESS_MASK    GrantedAccess;
    PDWORD          AccessStatus;
    PACCESS_REASONS AccessReason;
    PPRIVILEGE_SET  *Privileges;
} SE_ACCESS_REPLY;
typedef SE_ACCESS_REPLY *PSE_ACCESS_REPLY;

/* Security impersonation levels */
typedef enum _SECURITY_IMPERSONATION_LEVEL {
    SecurityAnonymous,
    SecurityIdentification,
    SecurityImpersonation,
    SecurityDelegation
} SECURITY_IMPERSONATION_LEVEL;
typedef SECURITY_IMPERSONATION_LEVEL* PSECURITY_IMPERSONATION_LEVEL;

/* Token types */
typedef enum _TOKEN_TYPE {
    TokenPrimary        = 1,
    TokenImpersonation  = 2
} TOKEN_TYPE;
typedef TOKEN_TYPE  *PTOKEN_TYPE;

/* Token elevation types */
typedef enum _TOKEN_ELEVATION_TYPE {
    TokenElevationTypeDefault   = 1,
    TokenElevationTypeFull      = 2,
    TokenElevationTypeLimited   = 3
} TOKEN_ELEVATION_TYPE;
typedef TOKEN_ELEVATION_TYPE    *PTOKEN_ELEVATION_TYPE;

/* Token information classes */
typedef enum _TOKEN_INFORMATION_CLASS {
    TokenUser                   = 1,
    TokenGroups                 = 2,
    TokenPrivileges             = 3,
    TokenOwner                  = 4,
    TokenPrimaryGroup           = 5,
    TokenDefaultDacl            = 6,
    TokenSource                 = 7,
    TokenType                   = 8,
    TokenImpersonationLevel     = 9,
    TokenStatistics             = 10,
    TokenRestrictedSids         = 11,
    TokenSessionId              = 12,
    TokenGroupsAndPrivileges    = 13,
    TokenSessionReference       = 14,
    TokenSandBoxInert           = 15,
    TokenAuditPolicy            = 16,
    TokenOrigin                 = 17,
    TokenElevationType          = 18,
    TokenLinkedToken            = 19,
    TokenElevation              = 20,
    TokenHasRestrictions        = 21,
    TokenAccessInformation      = 22,
    TokenVirtualizationAllowed  = 23,
    TokenVirtualizationEnabled  = 24,
    TokenIntegrityLevel         = 25,
    TokenUIAccess               = 26,
    TokenMandatoryPolicy        = 27,
    TokenLogonSid               = 28,
    MaxTokenInfoClass           = 29
} TOKEN_INFORMATION_CLASS;
typedef TOKEN_INFORMATION_CLASS *PTOKEN_INFORMATION_CLASS;

/* Token user */
typedef struct _TOKEN_USER {
    SID_AND_ATTRIBUTES  User;
} TOKEN_USER;
typedef TOKEN_USER  *PTOKEN_USER;

/* Token groups */
typedef struct _TOKEN_GROUPS {
    DWORD               GroupCount;
    SID_AND_ATTRIBUTES  Groups[ANYSIZE_ARRAY];
} TOKEN_GROUPS;
typedef TOKEN_GROUPS    *PTOKEN_GROUPS;

/* Token privileges */
typedef struct _TOKEN_PRIVILEGES {
    DWORD               PrivilegeCount;
    LUID_AND_ATTRIBUTES Privileges[ANYSIZE_ARRAY];
} TOKEN_PRIVILEGES;
typedef TOKEN_PRIVILEGES    *PTOKEN_PRIVILEGES;

/* Token owner */
typedef struct _TOKEN_OWNER {
    PSID    Owner;
} TOKEN_OWNER;
typedef TOKEN_OWNER *PTOKEN_OWNER;

/* Token primary group */
typedef struct _TOKEN_PRIMARY_GROUP {
    PSID    PrimaryGroup;
} TOKEN_PRIMARY_GROUP;
typedef TOKEN_PRIMARY_GROUP *PTOKEN_PRIMARY_GROUP;

/* Token default DACL */
typedef struct _TOKEN_DEFAULT_DACL {
    PACL    DefaultDacl;
} TOKEN_DEFAULT_DACL;
typedef TOKEN_DEFAULT_DACL  *PTOKEN_DEFAULT_DACL;

/* Token groups and privileges */
typedef struct _TOKEN_GROUPS_AND_PRIVILEGES {
    DWORD                   SidCount;
    DWORD                   SidLength;
    PSID_AND_ATTRIBUTES     Sids;
    DWORD                   RestrictedSidCount;
    DWORD                   RestrictedSidLength;
    PSID_AND_ATTRIBUTES     RestrictedSids;
    DWORD                   PrivilegeCount;
    DWORD                   PrivilegeLength;
    PLUID_AND_ATTRIBUTES    Privileges;
    LUID                    AuthenticationId;
} TOKEN_GROUPS_AND_PRIVILEGES;
typedef TOKEN_GROUPS_AND_PRIVILEGES *PTOKEN_GROUPS_AND_PRIVILEGES;

/* Token audit policy */
typedef struct _TOKEN_AUDIT_POLICY {
    BYTE    PerUserPolicy[(POLICY_AUDIT_SUBCATEGORY_COUNT >> 1) + 1];
} TOKEN_AUDIT_POLICY;
typedef TOKEN_AUDIT_POLICY  *PTOKEN_AUDIT_POLICY;

/* Token source */
typedef struct _TOKEN_SOURCE {
    CHAR    SourceName[TOKEN_SOURCE_LENGTH];
    LUID    SourceIdentifier;
} TOKEN_SOURCE;
typedef TOKEN_SOURCE* PTOKEN_SOURCE;

/* Token statistics */
typedef struct _TOKEN_STATISTICS {
    LUID                            TokenId;
    LUID                            AuthenticationId;
    LARGE_INTEGER                   ExpirationTime;
    TOKEN_TYPE                      TokenType;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    DWORD                           DynamicCharged;
    DWORD                           DynamicAvailable;
    DWORD                           GroupCount;
    DWORD                           PrivilegeCount;
    LUID                            ModifiedId;
} TOKEN_STATISTICS;
typedef TOKEN_STATISTICS    *PTOKEN_STATISTICS;

/* Token control */
typedef struct _TOKEN_CONTROL {
    LUID            TokenId;
    LUID            AuthenticationId;
    LUID            ModifiedId;
    TOKEN_SOURCE    TokenSource;
} TOKEN_CONTROL;
typedef TOKEN_CONTROL   *PTOKEN_CONTROL;

/* Token origin */
typedef struct _TOKEN_ORIGIN {
    LUID    OriginatingLogonSession;
} TOKEN_ORIGIN;
typedef TOKEN_ORIGIN    *PTOKEN_ORIGIN;

/* Token linked token */
typedef struct _TOKEN_LINKED_TOKEN {
    HANDLE  LinkedToken;
} TOKEN_LINKED_TOKEN;
typedef TOKEN_LINKED_TOKEN  *PTOKEN_LINKED_TOKEN;

/* Token elevation */
typedef struct _TOKEN_ELEVATION {
    DWORD   TokenIsElevated;
} TOKEN_ELEVATION;
typedef TOKEN_ELEVATION *PTOKEN_ELEVATION;

/* Token mandatory label */
typedef struct _TOKEN_MANDATORY_LABEL {
    SID_AND_ATTRIBUTES  Label;
} TOKEN_MANDATORY_LABEL;
typedef TOKEN_MANDATORY_LABEL   *PTOKEN_MANDATORY_LABEL;

/* Token mandatory policy */
typedef struct _TOKEN_MANDATORY_POLICY {
    DWORD   Policy;
} TOKEN_MANDATORY_POLICY;
typedef TOKEN_MANDATORY_POLICY  *PTOKEN_MANDATORY_POLICY;

/* Token access information */
typedef struct _TOKEN_ACCESS_INFORMATION {
    PSID_AND_ATTRIBUTES_HASH        SidHash;
    PSID_AND_ATTRIBUTES_HASH        RestrictedSidHash;
    PTOKEN_PRIVILEGES               Privileges;
    LUID                            AuthenticationId;
    TOKEN_TYPE                      TokenType;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    TOKEN_MANDATORY_POLICY          MandatoryPolicy;
    DWORD                           Flags;
} TOKEN_ACCESS_INFORMATION;
typedef TOKEN_ACCESS_INFORMATION    *PTOKEN_ACCESS_INFORMATION;

/* Mandatory levels */
typedef enum _MANDATORY_LEVEL {
    MandatoryLevelUntrusted     = 0,
    MandatoryLevelLow           = 1,
    MandatoryLevelMedium        = 2,
    MandatoryLevelHigh          = 3,
    MandatoryLevelSystem        = 4,
    MandatoryLevelSecureProcess = 5,
    MandatoryLevelCount         = 6
} MANDATORY_LEVEL;
typedef MANDATORY_LEVEL *PMANDATORY_LEVEL;

/* Security quality of service */
typedef struct _SECURITY_QUALITY_OF_SERVICE {
    DWORD                           Length;
    SECURITY_IMPERSONATION_LEVEL    ImpersonationLevel;
    SECURITY_CONTEXT_TRACKING_MODE  ContextTrackingMode;
    BOOLEAN                         EffectiveOnly;
} SECURITY_QUALITY_OF_SERVICE;
typedef SECURITY_QUALITY_OF_SERVICE *PSECURITY_QUALITY_OF_SERVICE;

/* Security impersonation state */
typedef struct _SE_IMPERSONATION_STATE {
    PACCESS_TOKEN                   Token;
    BOOLEAN                         CopyOnOpen;
    BOOLEAN                         EffectiveOnly;
    SECURITY_IMPERSONATION_LEVEL    Level;
} SE_IMPERSONATION_STATE;
typedef SE_IMPERSONATION_STATE  *PSE_IMPERSONATION_STATE;

/* Job set array */
typedef struct _JOB_SET_ARRAY {
    HANDLE  JobHandle;
    DWORD   MemberLevel;
    DWORD   Flags;
} JOB_SET_ARRAY;
typedef JOB_SET_ARRAY   *PJOB_SET_ARRAY;

/* Quota limits */
typedef struct _QUOTA_LIMITS {
    SIZE_T          PagedPoolLimit;
    SIZE_T          NonPagedPoolLimit;
    SIZE_T          MinimumWorkingSetSize;
    SIZE_T          MaximumWorkingSetSize;
    SIZE_T          PagefileLimit;
    LARGE_INTEGER   TimeLimit;
} QUOTA_LIMITS;
typedef QUOTA_LIMITS    *PQUOTA_LIMITS;

/* Rate quota limit */
typedef union _RATE_QUOTA_LIMIT {
    DWORD   RateData;
    struct {
        DWORD   RatePercent : 7;
        DWORD   Reserved0   : 25;
    };
} RATE_QUOTA_LIMIT;
typedef RATE_QUOTA_LIMIT    *PRATE_QUOTA_LIMIT;

/* Quota limits (extended version) */
typedef struct _QUOTA_LIMITS_EX {
    SIZE_T              PagedPoolLimit;
    SIZE_T              NonPagedPoolLimit;
    SIZE_T              MinimumWorkingSetSize;
    SIZE_T              MaximumWorkingSetSize;
    SIZE_T              PagefileLimit;
    LARGE_INTEGER       TimeLimit;
    SIZE_T              WorkingSetLimit;
    SIZE_T              Reserved2;
    SIZE_T              Reserved3;
    SIZE_T              Reserved4;
    DWORD               Flags;
    RATE_QUOTA_LIMIT    CpuRateLimit;
} QUOTA_LIMITS_EX;
typedef QUOTA_LIMITS_EX *PQUOTA_LIMITS_EX;

/* I/O counters */
typedef struct _IO_COUNTERS {
    ULONGLONG   ReadOperationCount;
    ULONGLONG   WriteOperationCount;
    ULONGLONG   OtherOperationCount;
    ULONGLONG   ReadTransferCount;
    ULONGLONG   WriteTransferCount;
    ULONGLONG   OtherTransferCount;
} IO_COUNTERS;
typedef IO_COUNTERS *PIO_COUNTERS;

/* Hardware counter types */
typedef enum _HARDWARE_COUNTER_TYPE {
    PMCCounter              = 0,
    MaxHardwareCounterType  = 1
} HARDWARE_COUNTER_TYPE;
typedef HARDWARE_COUNTER_TYPE   *PHARDWARE_COUNTER_TYPE;

/* Job object basic accounting information */
typedef struct _JOBOBJECT_BASIC_ACCOUNTING_INFORMATION {
    LARGE_INTEGER   TotalUserTime;
    LARGE_INTEGER   TotalKernelTime;
    LARGE_INTEGER   ThisPeriodTotalUserTime;
    LARGE_INTEGER   ThisPeriodTotalKernelTime;
    DWORD           TotalPageFaultCount;
    DWORD           TotalProcesses;
    DWORD           ActiveProcesses;
    DWORD           TotalTerminatedProcesses;
} JOBOBJECT_BASIC_ACCOUNTING_INFORMATION;
typedef JOBOBJECT_BASIC_ACCOUNTING_INFORMATION  *PJOBOBJECT_BASIC_ACCOUNTING_INFORMATION;

/* Job object basic limit information */
typedef struct _JOBOBJECT_BASIC_LIMIT_INFORMATION {
    LARGE_INTEGER   PerProcessUserTimeLimit;
    LARGE_INTEGER   PerJobUserTimeLimit;
    DWORD           LimitFlags;
    SIZE_T          MinimumWorkingSetSize;
    SIZE_T          MaximumWorkingSetSize;
    DWORD           ActiveProcessLimit;
    ULONG_PTR       Affinity;
    DWORD           PriorityClass;
    DWORD           SchedulingClass;
} JOBOBJECT_BASIC_LIMIT_INFORMATION;
typedef JOBOBJECT_BASIC_LIMIT_INFORMATION   *PJOBOBJECT_BASIC_LIMIT_INFORMATION;

/* Job object extended limit information */
typedef struct _JOBOBJECT_EXTENDED_LIMIT_INFORMATION {
    JOBOBJECT_BASIC_LIMIT_INFORMATION   BasicLimitInformation;
    IO_COUNTERS                         IoInfo;
    SIZE_T                              ProcessMemoryLimit;
    SIZE_T                              JobMemoryLimit;
    SIZE_T                              PeakProcessMemoryUsed;
    SIZE_T                              PeakJobMemoryUsed;
} JOBOBJECT_EXTENDED_LIMIT_INFORMATION;
typedef JOBOBJECT_EXTENDED_LIMIT_INFORMATION    *PJOBOBJECT_EXTENDED_LIMIT_INFORMATION;

/* Job object basic process ID list */
typedef struct _JOBOBJECT_BASIC_PROCESS_ID_LIST {
    DWORD       NumberOfAssignedProcesses;
    DWORD       NumberOfProcessIdsInList;
    ULONG_PTR   ProcessIdList[1];
} JOBOBJECT_BASIC_PROCESS_ID_LIST;
typedef JOBOBJECT_BASIC_PROCESS_ID_LIST *PJOBOBJECT_BASIC_PROCESS_ID_LIST;

/* Job object basic UI restrictions */
typedef struct _JOBOBJECT_BASIC_UI_RESTRICTIONS {
    DWORD   UIRestrictionsClass;
} JOBOBJECT_BASIC_UI_RESTRICTIONS;
typedef JOBOBJECT_BASIC_UI_RESTRICTIONS *PJOBOBJECT_BASIC_UI_RESTRICTIONS;

/* Job object security limit information */
typedef struct _JOBOBJECT_SECURITY_LIMIT_INFORMATION {
    DWORD               SecurityLimitFlags;
    HANDLE              JobToken;
    PTOKEN_GROUPS       SidsToDisable;
    PTOKEN_PRIVILEGES   PrivilegesToDisable;
    PTOKEN_GROUPS       RestrictedSids;
} JOBOBJECT_SECURITY_LIMIT_INFORMATION;
typedef JOBOBJECT_SECURITY_LIMIT_INFORMATION    *PJOBOBJECT_SECURITY_LIMIT_INFORMATION;

/* Job object end of job time information */
typedef struct _JOBOBJECT_END_OF_JOB_TIME_INFORMATION {
    DWORD   EndOfJobTimeAction;
} JOBOBJECT_END_OF_JOB_TIME_INFORMATION;
typedef JOBOBJECT_END_OF_JOB_TIME_INFORMATION   *PJOBOBJECT_END_OF_JOB_TIME_INFORMATION;

/* Job object associate completion port information */
typedef struct _JOBOBJECT_ASSOCIATE_COMPLETION_PORT {
    PVOID   CompletionKey;
    HANDLE  CompletionPort;
} JOBOBJECT_ASSOCIATE_COMPLETION_PORT;
typedef JOBOBJECT_ASSOCIATE_COMPLETION_PORT *PJOBOBJECT_ASSOCIATE_COMPLETION_PORT;

/* Job object basic and I/O accounting information */
typedef struct _JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION {
    JOBOBJECT_BASIC_ACCOUNTING_INFORMATION  BasicInfo;
    IO_COUNTERS                             IoInfo;
} JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION;
typedef JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION   *PJOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION;

/* Job set information */
typedef struct _JOBOBJECT_JOBSET_INFORMATION {
    DWORD   MemberLevel;
} JOBOBJECT_JOBSET_INFORMATION;
typedef JOBOBJECT_JOBSET_INFORMATION    *PJOBOBJECT_JOBSET_INFORMATION;

/* Job object information classes */
typedef enum _JOBOBJECTINFOCLASS {
    JobObjectBasicAccountingInformation         = 1,
    JobObjectBasicLimitInformation              = 2,
    JobObjectBasicProcessIdList                 = 3,
    JobObjectBasicUIRestrictions                = 4,
    JobObjectSecurityLimitInformation           = 5,
    JobObjectEndOfJobTimeInformation            = 6,
    JobObjectAssociateCompletionPortInformation = 7,
    JobObjectBasicAndIoAccountingInformation    = 8,
    JobObjectExtendedLimitInformation           = 9,
    JobObjectJobSetInformation                  = 10,
    JobObjectGroupInformation                   = 11,
    MaxJobObjectInfoClass                       = 12
} JOBOBJECTINFOCLASS;

/* Logical processor relationships */
typedef enum _LOGICAL_PROCESSOR_RELATIONSHIP {
    RelationProcessorCore       = 0,
    RelationNumaNode            = 1,
    RelationCache               = 2,
    RelationProcessorPackage    = 3,
    RelationGroup               = 4,
    RelationAll                 = 0xFFFF
} LOGICAL_PROCESSOR_RELATIONSHIP;

/* Processor cache types */
typedef enum _PROCESSOR_CACHE_TYPE {
    CacheUnified,
    CacheInstruction,
    CacheData,
    CacheTrace
} PROCESSOR_CACHE_TYPE;

/* Cache descriptor */
typedef struct _CACHE_DESCRIPTOR {
    BYTE                    Level;
    BYTE                    Associativity;
    WORD                    LineSize;
    DWORD                   Size;
    PROCESSOR_CACHE_TYPE    Type;
} CACHE_DESCRIPTOR;
typedef CACHE_DESCRIPTOR    *PCACHE_DESCRIPTOR;

/* System logical processor information */
typedef struct _SYSTEM_LOGICAL_PROCESSOR_INFORMATION {
    ULONG_PTR                       ProcessorMask;
    LOGICAL_PROCESSOR_RELATIONSHIP  Relationship;
    union {
        struct {
            BYTE    Flags;
        } ProcessorFlags;
        struct {
            DWORD   NodeNumber;
        } NumaNode;
        CACHE_DESCRIPTOR    Cache;
        ULONGLONG           Reserved[2];
    };
} SYSTEM_LOGICAL_PROCESSOR_INFORMATION;
typedef SYSTEM_LOGICAL_PROCESSOR_INFORMATION    *PSYSTEM_LOGICAL_PROCESSOR_INFORMATION;

/* Processor relationship */
typedef struct _PROCESSOR_RELATIONSHIP {
    BYTE            Flags;
    BYTE            Reserved[21];
    WORD            GroupCount;
    GROUP_AFFINITY  GroupMask[ANYSIZE_ARRAY];
} PROCESSOR_RELATIONSHIP;
typedef PROCESSOR_RELATIONSHIP  *PPROCESSOR_RELATIONSHIP;

/* Numa node relationship */
typedef struct _NUMA_NODE_RELATIONSHIP {
    DWORD           NodeNumber;
    BYTE            Reserved[20];
    GROUP_AFFINITY  GroupMask;
} NUMA_NODE_RELATIONSHIP;
typedef NUMA_NODE_RELATIONSHIP  *PNUMA_NODE_RELATIONSHIP;

/* Cache relationship */
typedef struct _CACHE_RELATIONSHIP {
    BYTE                    Level;
    BYTE                    Associativity;
    WORD                    LineSize;
    DWORD                   CacheSize;
    PROCESSOR_CACHE_TYPE    Type;
    BYTE                    Reserved[20];
    GROUP_AFFINITY          GroupMask;
} CACHE_RELATIONSHIP;
typedef CACHE_RELATIONSHIP  *PCACHE_RELATIONSHIP;

/* Processor group information */
typedef struct _PROCESSOR_GROUP_INFO {
    BYTE        MaximumProcessorCount;
    BYTE        ActiveProcessorCount;
    BYTE        Reserved[38];
    KAFFINITY   ActiveProcessorMask;
} PROCESSOR_GROUP_INFO;
typedef PROCESSOR_GROUP_INFO    *PPROCESSOR_GROUP_INFO;

/* Group relationship */
typedef struct _GROUP_RELATIONSHIP {
    WORD                    MaximumGroupCount;
    WORD                    ActiveGroupCount;
    BYTE                    Reserved[20];
    PROCESSOR_GROUP_INFO    GroupInfo[ANYSIZE_ARRAY];
} GROUP_RELATIONSHIP;
typedef GROUP_RELATIONSHIP  *PGROUP_RELATIONSHIP;

/* System logical processor information (extended version) */
typedef struct _SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX {
    LOGICAL_PROCESSOR_RELATIONSHIP  Relationship;
    DWORD                           Size;
    union {
        PROCESSOR_RELATIONSHIP  Processor;
        NUMA_NODE_RELATIONSHIP  NumaNode;
        CACHE_RELATIONSHIP      Cache;
        GROUP_RELATIONSHIP      Group;
    };
} SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;
typedef SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX *PSYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;

/* System processor cycle time information */
typedef struct _SYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION {
    DWORD64 CycleTime;
} SYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION;
typedef SYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION *PSYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION;

/* Extended state feature */
typedef struct _XSTATE_FEATURE {
    DWORD   Offset;
    DWORD   Size;
} XSTATE_FEATURE;
typedef XSTATE_FEATURE  *PXSTATE_FEATURE;

/* Extended state configuration */
typedef struct _XSTATE_CONFIGURATION {
    DWORD64         EnabledFeatures;
    DWORD           Size;
    DWORD           OptimizedSave   : 1;
    XSTATE_FEATURE  Features[MAXIMUM_XSTATE_FEATURES];
} XSTATE_CONFIGURATION;
typedef XSTATE_CONFIGURATION    *PXSTATE_CONFIGURATION;

/* Memory basic information */
typedef struct _MEMORY_BASIC_INFORMATION {
    PVOID   BaseAddress;
    PVOID   AllocationBase;
    DWORD   AllocationProtect;
    SIZE_T  RegionSize;
    DWORD   State;
    DWORD   Protect;
    DWORD   Type;
} MEMORY_BASIC_INFORMATION;
typedef MEMORY_BASIC_INFORMATION    *PMEMORY_BASIC_INFORMATION;

/* Memory basic information (32-bit version) */
typedef struct _MEMORY_BASIC_INFORMATION32 {
    DWORD   BaseAddress;
    DWORD   AllocationBase;
    DWORD   AllocationProtect;
    DWORD   RegionSize;
    DWORD   State;
    DWORD   Protect;
    DWORD   Type;
} MEMORY_BASIC_INFORMATION32;
typedef MEMORY_BASIC_INFORMATION32  *PMEMORY_BASIC_INFORMATION32;

/* Memory basic information (64-bit version) */
typedef struct _MEMORY_BASIC_INFORMATION64 {
    ULONGLONG   BaseAddress;
    ULONGLONG   AllocationBase;
    DWORD       AllocationProtect;
    DWORD       __alignment1;
    ULONGLONG   RegionSize;
    DWORD       State;
    DWORD       Protect;
    DWORD       Type;
    DWORD       __alignment2;
} MEMORY_BASIC_INFORMATION64;
typedef MEMORY_BASIC_INFORMATION64  *PMEMORY_BASIC_INFORMATION64;

/* File change notification information */
typedef struct _FILE_NOTIFY_INFORMATION {
    DWORD   NextEntryOffset;
    DWORD   Action;
    DWORD   FileNameLength;
    WCHAR   FileName[1];
} FILE_NOTIFY_INFORMATION;
typedef FILE_NOTIFY_INFORMATION *PFILE_NOTIFY_INFORMATION;

/* File segment element */
typedef union _FILE_SEGMENT_ELEMENT {
    PVOID64     Buffer;
    ULONGLONG   Alignment;
} FILE_SEGMENT_ELEMENT;
typedef FILE_SEGMENT_ELEMENT    *PFILE_SEGMENT_ELEMENT;

/* Reparse GUID data buffer */
typedef struct _REPARSE_GUID_DATA_BUFFER {
    DWORD   ReparseTag;
    WORD    ReparseDataLength;
    WORD    Reserved;
    GUID    ReparseGuid;
    struct {
        BYTE    DataBuffer[1];
    } GenericReparseBuffer;
} REPARSE_GUID_DATA_BUFFER;
typedef REPARSE_GUID_DATA_BUFFER    *PREPARSE_GUID_DATA_BUFFER;

/* System power states */
typedef enum _SYSTEM_POWER_STATE {
    PowerSystemUnspecified  = 0,
    PowerSystemWorking      = 1,
    PowerSystemSleeping1    = 2,
    PowerSystemSleeping2    = 3,
    PowerSystemSleeping3    = 4,
    PowerSystemHibernate    = 5,
    PowerSystemShutdown     = 6,
    PowerSystemMaximum      = 7
} SYSTEM_POWER_STATE;
typedef SYSTEM_POWER_STATE  *PSYSTEM_POWER_STATE;

/* Power actions */
typedef enum {
    PowerActionNone             = 0,
    PowerActionReserved         = 1,
    PowerActionSleep            = 2,
    PowerActionHibernate        = 3,
    PowerActionShutdown         = 4,
    PowerActionShutdownReset    = 5,
    PowerActionShutdownOff      = 6,
    PowerActionWarmEject        = 7
} POWER_ACTION;
typedef POWER_ACTION    *PPOWER_ACTION;

/* Device power states */
typedef enum _DEVICE_POWER_STATE {
    PowerDeviceUnspecified  = 0,
    PowerDeviceD0           = 1,
    PowerDeviceD1           = 2,
    PowerDeviceD2           = 3,
    PowerDeviceD3           = 4,
    PowerDeviceMaximum      = 5
} DEVICE_POWER_STATE;
typedef DEVICE_POWER_STATE  *PDEVICE_POWER_STATE;

/* Monitor display states */
typedef enum _MONITOR_DISPLAY_STATE {
    PowerMonitorOff = 0,
    PowerMonitorOn  = 1,
    PowerMonitorDim = 2
} MONITOR_DISPLAY_STATE;
typedef MONITOR_DISPLAY_STATE   *PMONITOR_DISPLAY_STATE;

/* Latency time values */
typedef enum {
    LT_DONT_CARE,
    LT_LOWEST_LATENCY
} LATENCY_TIME;

/* Power request types */
typedef enum _POWER_REQUEST_TYPE {
    PowerRequestDisplayRequired     = 0,
    PowerRequestSystemRequired      = 1,
    PowerRequestAwayModeRequired    = 2
} POWER_REQUEST_TYPE;
typedef POWER_REQUEST_TYPE  *PPOWER_REQUEST_TYPE;

/* Power data */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct CM_Power_Data_s {
    DWORD               PD_Size;
    DEVICE_POWER_STATE  PD_MostRecentPowerState;
    DWORD               PD_Capabilities;
    DWORD               PD_D1Latency;
    DWORD               PD_D2Latency;
    DWORD               PD_D3Latency;
    DEVICE_POWER_STATE  PD_PowerStateMapping[POWER_SYSTEM_MAXIMUM];
    SYSTEM_POWER_STATE  PD_DeepestSystemWake;
} CM_POWER_DATA;
typedef CM_POWER_DATA   *PCM_POWER_DATA;
#endif

/* Power information levels */
typedef enum {
    SystemPowerPolicyAc             = 0,
    SystemPowerPolicyDc             = 1,
    VerifySystemPolicyAc            = 2,
    VerifySystemPolicyDc            = 3,
    SystemPowerCapabilities         = 4,
    SystemBatteryState              = 5,
    SystemPowerStateHandler         = 6,
    ProcessorStateHandler           = 7,
    SystemPowerPolicyCurrent        = 8,
    AdministratorPowerPolicy        = 9,
    SystemReserveHiberFile          = 10,
    ProcessorInformation            = 11,
    SystemPowerInformation          = 12,
    ProcessorStateHandler2          = 13,
    LastWakeTime                    = 14,
    LastSleepTime                   = 15,
    SystemExecutionState            = 16,
    SystemPowerStateNotifyHandler   = 17,
    ProcessorPowerPolicyAc          = 18,
    ProcessorPowerPolicyDc          = 19,
    VerifyProcessorPowerPolicyAc    = 20,
    VerifyProcessorPowerPolicyDc    = 21,
    ProcessorPowerPolicyCurrent     = 22,
    SystemPowerStateLogging         = 23,
    SystemPowerLoggingEntry         = 24,
    SetPowerSettingValue            = 25,
    NotifyUserPowerSetting          = 26,
    SystemVideoState                = 29,
    TraceApplicationPowerMessage    = 30,
    TraceApplicationPowerMessageEnd = 31,
    ProcessorPerfStates             = 32,
    ProcessorIdleStates             = 33,
    ProcessorCap                    = 34,
    SystemWakeSource                = 35,
    SystemHiberFileInformation      = 36,
    TraceServicePowerMessage        = 37,
    ProcessorLoad                   = 38,
    PowerShutdownNotification       = 39,
    MonitorCapabilities             = 40,
    SessionPowerInit                = 41,
    SessionDisplayState             = 42,
    PowerRequestCreate              = 43,
    PowerRequestAction              = 44,
    GetPowerRequestList             = 45,
    ProcessorInformationEx          = 46,
    NotifyUserModeLegacyPowerEvent  = 47,
    GroupPark                       = 48,
    ProcessorIdleDomains            = 49,
    WakeTimerList                   = 50,
    SystemHiberFileSize             = 51,
    PowerInformationLevelMaximum    = 52
} POWER_INFORMATION_LEVEL;

/* System power conditions */
typedef enum {
    PoAc,
    PoDc,
    PoHot,
    PoConditionMaximum
} SYSTEM_POWER_CONDITION;

/* Structure to set a power setting */
typedef struct {
    DWORD                   Version;
    GUID                    Guid;
    SYSTEM_POWER_CONDITION  PowerCondition;
    DWORD                   DataLength;
    BYTE                    Data[ANYSIZE_ARRAY];
} SET_POWER_SETTING_VALUE;
typedef SET_POWER_SETTING_VALUE *PSET_POWER_SETTING_VALUE;

/* User power setting notification information */
typedef struct {
    GUID    Guid;
} NOTIFY_USER_POWER_SETTING;
typedef NOTIFY_USER_POWER_SETTING   *PNOTIFY_USER_POWER_SETTING;

/* Application launch setting value */
typedef struct _APPLICATIONLAUNCH_SETTING_VALUE {
    LARGE_INTEGER   ActivationTime;
    DWORD           Flags;
    DWORD           ButtonInstanceID;
} APPLICATIONLAUNCH_SETTING_VALUE;
typedef APPLICATIONLAUNCH_SETTING_VALUE *PAPPLICATIONLAUNCH_SETTING_VALUE;

/* Power platform roles */
typedef enum {
    PlatformRoleUnspecified         = 0,
    PlatformRoleDesktop             = 1,
    PlatformRoleMobile              = 2,
    PlatformRoleWorkstation         = 3,
    PlatformRoleEnterpriseServer    = 4,
    PlatformRoleSOHOServer          = 5,
    PlatformRoleAppliancePC         = 6,
    PlatformRolePerformanceServer   = 7,
    PlatformRoleMaximum             = 8
} POWER_PLATFORM_ROLE;

/* Battery reporting scale */
#if (NTDDI_VERSION >= 0x05010000) || !defined( _BATCLASS_ )
typedef struct {
    DWORD   Granularity;
    DWORD   Capacity;
} BATTERY_REPORTING_SCALE;
typedef BATTERY_REPORTING_SCALE *PBATTERY_REPORTING_SCALE;
#endif

/* WMI legacy performance state */
typedef struct {
    DWORD   Frequency;
    DWORD   Flags;
    DWORD   PercentFrequency;
} PPM_WMI_LEGACY_PERFSTATE;
typedef PPM_WMI_LEGACY_PERFSTATE    *PPPM_WMI_LEGACY_PERFSTATE;

/* WMI idle state */
typedef struct {
    DWORD   Latency;
    DWORD   Power;
    DWORD   TimeCheck;
    BYTE    PromotePercent;
    BYTE    DemotePercent;
    BYTE    StateType;
    BYTE    Reserved;
    DWORD   StateFlags;
    DWORD   Context;
    DWORD   IdleHandler;
    DWORD   Reserved1;
} PPM_WMI_IDLE_STATE;
typedef PPM_WMI_IDLE_STATE  *PPPM_WMI_IDLE_STATE;

/* WMI idle state array */
typedef struct {
    DWORD               Type;
    DWORD               Count;
    DWORD               TargetState;
    DWORD               OldState;
    DWORD64             TargetProcessors;
    PPM_WMI_IDLE_STATE  State[ANYSIZE_ARRAY];
} PPM_WMI_IDLE_STATES;
typedef PPM_WMI_IDLE_STATES *PPPM_WMI_IDLE_STATES;

/* WMI idle state array (extended version) */
typedef struct {
    DWORD               Type;
    DWORD               Count;
    DWORD               TargetState;
    DWORD               OldState;
    PVOID               TargetProcessors;
    PPM_WMI_IDLE_STATE  State[ANYSIZE_ARRAY];
} PPM_WMI_IDLE_STATES_EX;
typedef PPM_WMI_IDLE_STATES_EX  *PPPM_WMI_IDLE_STATES_EX;

/* WMI performance state */
typedef struct {
    DWORD   Frequency;
    DWORD   Power;
    BYTE    PercentFrequency;
    BYTE    IncreaseLevel;
    BYTE    DecreaseLevel;
    BYTE    Type;
    DWORD   IncreaseTime;
    DWORD   DecreaseTime;
    DWORD64 Control;
    DWORD64 Status;
    DWORD   HitCount;
    DWORD   Reserved1;
    DWORD64 Reserved2;
    DWORD64 Reserved3;
} PPM_WMI_PERF_STATE;
typedef PPM_WMI_PERF_STATE  *PPPM_WMI_PERF_STATE;

/* WMI performance state array */
typedef struct {
    DWORD               Count;
    DWORD               MaxFrequency;
    DWORD               CurrentState;
    DWORD               MaxPerfState;
    DWORD               MinPerfState;
    DWORD               LowestPerfState;
    DWORD               ThermalConstraint;
    BYTE                BusyAdjThreshold;
    BYTE                PolicyType;
    BYTE                Type;
    BYTE                Reserved;
    DWORD               TimerInterval;
    DWORD64             TargetProcessors;
    DWORD               PStateHandler;
    DWORD               PStateContext;
    DWORD               TStateHandler;
    DWORD               TStateContext;
    DWORD               FeedbackHandler;
    DWORD               Reserved1;
    DWORD64             Reserved2;
    PPM_WMI_PERF_STATE  State[ANYSIZE_ARRAY];
} PPM_WMI_PERF_STATES;
typedef PPM_WMI_PERF_STATES *PPPM_WMI_PERF_STATES;

/* WMI performance state array (extended version) */
typedef struct {
    DWORD               Count;
    DWORD               MaxFrequency;
    DWORD               CurrentState;
    DWORD               MaxPerfState;
    DWORD               MinPerfState;
    DWORD               LowestPerfState;
    DWORD               ThermalConstraint;
    BYTE                BusyAdjThreshold;
    BYTE                PolicyType;
    BYTE                Type;
    BYTE                Reserved;
    DWORD               TimerInterval;
    PVOID               TargetProcessors;
    DWORD               PStateHandler;
    DWORD               PStateContext;
    DWORD               TStateHandler;
    DWORD               TStateContext;
    DWORD               FeedbackHandler;
    DWORD               Reserved1;
    DWORD64             Reserved2;
    PPM_WMI_PERF_STATE  State[ANYSIZE_ARRAY];
} PPM_WMI_PERF_STATES_EX;
typedef PPM_WMI_PERF_STATES_EX  *PPPM_WMI_PERF_STATES_EX;

/* Idle state accounting information */
typedef struct {
    DWORD   IdleTransitions;
    DWORD   FailedTransitions;
    DWORD   InvalidBucketIndex;
    DWORD64 TotalTime;
    DWORD   IdleTimeBuckets[PROC_IDLE_BUCKET_COUNT];
} PPM_IDLE_STATE_ACCOUNTING;
typedef PPM_IDLE_STATE_ACCOUNTING   *PPPM_IDLE_STATE_ACCOUNTING;

/* Idle accounting information */
typedef struct {
    DWORD                       StateCount;
    DWORD                       TotalTransitions;
    DWORD                       ResetCount;
    DWORD64                     StartTime;
    PPM_IDLE_STATE_ACCOUNTING   State[ANYSIZE_ARRAY];
} PPM_IDLE_ACCOUNTING;
typedef PPM_IDLE_ACCOUNTING *PPPM_IDLE_ACCOUNTING;

/* Idle state bucket (extended version) */
typedef struct {
    DWORD64 TotalTimeUs;
    DWORD   MinTimeUs;
    DWORD   MaxTimeUs;
    DWORD   Count;
} PPM_IDLE_STATE_BUCKET_EX;
typedef PPM_IDLE_STATE_BUCKET_EX    *PPPM_IDLE_STATE_BUCKET_EX;

/* Idle state accounting (extended version) */
typedef struct {
    DWORD64                     TotalTime;
    DWORD                       IdleTransitions;
    DWORD                       FailedTransitions;
    DWORD                       InvalidBucketIndex;
    DWORD                       MinTimeUs;
    DWORD                       MaxTimeUs;
    PPM_IDLE_STATE_BUCKET_EX    IdleTimeBuckets[PROC_IDLE_BUCKET_COUNT_EX];
} PPM_IDLE_STATE_ACCOUNTING_EX;
typedef PPM_IDLE_STATE_ACCOUNTING_EX    *PPPM_IDLE_STATE_ACCOUNTING_EX;

/* Idle accounting (extended version) */
typedef struct {
    DWORD                           StateCount;
    DWORD                           TotalTransitions;
    DWORD                           ResetCount;
    DWORD64                         StartTime;
    PPM_IDLE_STATE_ACCOUNTING_EX    State[ANYSIZE_ARRAY];
} PPM_IDLE_ACCOUNTING_EX;
typedef PPM_IDLE_ACCOUNTING_EX  *PPPM_IDLE_ACCOUNTING_EX;

/* Performance state event */
typedef struct {
    DWORD   State;
    DWORD   Status;
    DWORD   Latency;
    DWORD   Speed;
    DWORD   Processor;
} PPM_PERFSTATE_EVENT;
typedef PPM_PERFSTATE_EVENT *PPPM_PERFSTATE_EVENT;

/* Performance state domain event */
typedef struct {
    DWORD   State;
    DWORD   Latency;
    DWORD   Speed;
    DWORD64 Processors;
} PPM_PERFSTATE_DOMAIN_EVENT;
typedef PPM_PERFSTATE_DOMAIN_EVENT  *PPPM_PERFSTATE_DOMAIN_EVENT;

/* Idle state event */
typedef struct {
    DWORD   NewState;
    DWORD   OldState;
    DWORD64 Processors;
} PPM_IDLESTATE_EVENT;
typedef PPM_IDLESTATE_EVENT *PPPM_IDLESTATE_EVENT;

/* Thermal change event */
typedef struct {
    DWORD   ThermalConstraint;
    DWORD64 Processors;
} PPM_THERMALCHANGE_EVENT;
typedef PPM_THERMALCHANGE_EVENT *PPPM_THERMALCHANGE_EVENT;

/* Thermal policy event */
typedef struct {
    BYTE    Mode;
    DWORD64 Processors;
} PPM_THERMAL_POLICY_EVENT;
typedef PPM_THERMAL_POLICY_EVENT    *PPPM_THERMAL_POLICY_EVENT;

/* Power action policy */
typedef struct {
    POWER_ACTION    Action;
    DWORD           Flags;
    DWORD           EventCode;
} POWER_ACTION_POLICY;
typedef POWER_ACTION_POLICY *PPOWER_ACTION_POLICY;

/* System power level */
typedef struct {
    BOOLEAN             Enable;
    BYTE                Spare[3];
    DWORD               BatteryLevel;
    POWER_ACTION_POLICY PowerPolicy;
    SYSTEM_POWER_STATE  MinSystemState;
} SYSTEM_POWER_LEVEL;
typedef SYSTEM_POWER_LEVEL  *PSYSTEM_POWER_LEVEL;

/* System power policy */
typedef struct _SYSTEM_POWER_POLICY {
    DWORD               Revision;
    POWER_ACTION_POLICY PowerButton;
    POWER_ACTION_POLICY SleepButton;
    POWER_ACTION_POLICY LidClose;
    SYSTEM_POWER_STATE  LidOpenWake;
    DWORD               Reserved;
    POWER_ACTION_POLICY Idle;
    DWORD               IdleTimeout;
    BYTE                IdleSensitivity;
    BYTE                DynamicThrottle;
    BYTE                Spare2[2];
    SYSTEM_POWER_STATE  MinSleep;
    SYSTEM_POWER_STATE  MaxSleep;
    SYSTEM_POWER_STATE  ReducedLatencySleep;
    DWORD               WinLogonFlags;
    DWORD               Spare3;
    DWORD               DozeS4Timeout;
    DWORD               BroadcastCapacityResolution;
    SYSTEM_POWER_LEVEL  DischargePolicy[NUM_DISCHARGE_POLICIES];
    DWORD               VideoTimeout;
    BOOLEAN             VideoDimDisplay;
    DWORD               VideoReserved[3];
    DWORD               SpindownTimeout;
    BOOLEAN             OptimizeForPower;
    BYTE                FanThrottleTolerance;
    BYTE                ForcedThrottle;
    BYTE                MinThrottle;
    POWER_ACTION_POLICY OverThrottled;
} SYSTEM_POWER_POLICY;
typedef SYSTEM_POWER_POLICY *PSYSTEM_POWER_POLICY;

/* Processor idle state information */
typedef struct {
    DWORD   TimeCheck;
    BYTE    DemotePercent;
    BYTE    PromotePercent;
    BYTE    Spare[2];
} PROCESSOR_IDLESTATE_INFO;
typedef PROCESSOR_IDLESTATE_INFO    *PPROCESSOR_IDLESTATE_INFO;

/* Processor idle state policy */
typedef struct {
    WORD                        Revision;
    union {
        WORD    AsWORD;
        struct {
            WORD    AllowScaling    : 1;
            WORD    Disabled        : 1;
            WORD    Reserved        : 14;
        };
    } Flags;
    DWORD                       PolicyCount;
    PROCESSOR_IDLESTATE_INFO    Policy[PROCESSOR_IDLESTATE_POLICY_COUNT];
} PROCESSOR_IDLESTATE_POLICY;
typedef PROCESSOR_IDLESTATE_POLICY  *PPROCESSOR_IDLESTATE_POLICY;

/* Processor power policy information */
typedef struct _PROCESSOR_POWER_POLICY_INFO {
    DWORD   TimeCheck;
    DWORD   DemoteLimit;
    DWORD   PromoteLimit;
    BYTE    DemotePercent;
    BYTE    PromotePercent;
    BYTE    Spare[2];
    DWORD   AllowDemotion   : 1;
    DWORD   AllowPromotion  : 1;
    DWORD   Reserved        : 30;
} PROCESSOR_POWER_POLICY_INFO;
typedef PROCESSOR_POWER_POLICY_INFO *PPROCESSOR_POWER_POLICY_INFO;

/* Processor power policy */
typedef struct _PROCESSOR_POWER_POLICY {
    DWORD                       Revision;
    BYTE                        DynamicThrottle;
    BYTE                        Spare[3];
    DWORD                       DisableCStates  : 1;
    DWORD                       Reserved        : 31;
    DWORD                       PolicyCount;
    PROCESSOR_POWER_POLICY_INFO Policy[3];
} PROCESSOR_POWER_POLICY;
typedef PROCESSOR_POWER_POLICY  *PPROCESSOR_POWER_POLICY;

/* Processor performance state policy */
typedef struct {
    DWORD   Revision;
    BYTE    MaxThrottle;
    BYTE    MinThrottle;
    BYTE    BusyAdjThreshold;
    union {
        BYTE    Spare;
        union {
            BYTE AsBYTE;
            struct {
                BYTE    NoDomainAccounting  : 1;
                BYTE    IncreasePolicy      : 2;
                BYTE    DecreasePolicy      : 2;
                BYTE    Reserved            : 3;
            };
        } Flags;
    };
    DWORD   TimeCheck;
    DWORD   IncreaseTime;
    DWORD   DecreaseTime;
    DWORD   IncreasePercent;
    DWORD   DecreasePercent;
} PROCESSOR_PERFSTATE_POLICY;
typedef PROCESSOR_PERFSTATE_POLICY  *PPROCESSOR_PERFSTATE_POLICY;

/* Administrator power policy */
typedef struct _ADMINISTRATOR_POWER_POLICY {
    SYSTEM_POWER_STATE  MinSleep;
    SYSTEM_POWER_STATE  MaxSleep;
    DWORD               MinVideoTimeout;
    DWORD               MaxVideoTimeout;
    DWORD               MinSpindownTimeout;
    DWORD               MaxSpindownTimeout;
} ADMINISTRATOR_POWER_POLICY;
typedef ADMINISTRATOR_POWER_POLICY  *PADMINISTRATOR_POWER_POLICY;

/* System power capabilities */
typedef struct {
    BOOLEAN                 PowerButtonPresent;
    BOOLEAN                 SleepButtonPresent;
    BOOLEAN                 LidPresent;
    BOOLEAN                 SystemS1;
    BOOLEAN                 SystemS2;
    BOOLEAN                 SystemS3;
    BOOLEAN                 SystemS4;
    BOOLEAN                 SystemS5;
    BOOLEAN                 HiberFilePresent;
    BOOLEAN                 FullWake;
    BOOLEAN                 VideoDimPresent;
    BOOLEAN                 ApmPresent;
    BOOLEAN                 UpsPresent;
    BOOLEAN                 ThermalControl;
    BOOLEAN                 ProcessorThrottle;
    BYTE                    ProcessorMinThrottle;
#if (NTDDI_VERSION >= 0x05010000)
    BYTE                    ProcessorMaxThrottle;
    BOOLEAN                 FastSystemS4;
    BYTE                    spare2[3];
#else
    BYTE                    ProcessorThrottleScale;
    BYTE                    spare2[4];
#endif
    BOOLEAN                 DiskSpinDown;
    BYTE                    spare3[8];
    BOOLEAN                 SystemBatteriesPresent;
    BOOLEAN                 BatteriesAreShortTerm;
    BATTERY_REPORTING_SCALE BatteryScale[3];
    SYSTEM_POWER_STATE      AcOnLineWake;
    SYSTEM_POWER_STATE      SoftLidWake;
    SYSTEM_POWER_STATE      RtcWake;
    SYSTEM_POWER_STATE      MinDeviceWakeState;
    SYSTEM_POWER_STATE      DefaultLowLatencyWake;
} SYSTEM_POWER_CAPABILITIES;
typedef SYSTEM_POWER_CAPABILITIES   *PSYSTEM_POWER_CAPABILITIES;

/* System battery state */
typedef struct {
    BOOLEAN AcOnLine;
    BOOLEAN BatteryPresent;
    BOOLEAN Charging;
    BOOLEAN Discharging;
    BOOLEAN Spare1[4];
    DWORD   MaxCapacity;
    DWORD   RemainingCapacity;
    DWORD   Rate;
    DWORD   EstimatedTime;
    DWORD   DefaultAlert1;
    DWORD   DefaultAlert2;
} SYSTEM_BATTERY_STATE;
typedef SYSTEM_BATTERY_STATE    *PSYSTEM_BATTERY_STATE;

/* All image structures should get four-byte packing unless otherwise
 * specified.
 */
#include <pshpack4.h>

/* The following structures get one-byte packing. */
#include <pshpack1.h>

/* Header shared by DOS, Win16, Win32, and Win64 executables */
typedef struct _IMAGE_DOS_HEADER {
    WORD    e_magic;
    WORD    e_cblp;
    WORD    e_cp;
    WORD    e_crlc;
    WORD    e_cparhdr;
    WORD    e_minalloc;
    WORD    e_maxalloc;
    WORD    e_ss;
    WORD    e_sp;
    WORD    e_csum;
    WORD    e_ip;
    WORD    e_cs;
    WORD    e_lfarlc;
    WORD    e_ovno;
    WORD    e_res[4];
    WORD    e_oemid;
    WORD    e_oeminfo;
    WORD    e_res2[10];
    LONG    e_lfanew;
} IMAGE_DOS_HEADER;
typedef IMAGE_DOS_HEADER    *PIMAGE_DOS_HEADER;

/* Header for OS/2 executables */
typedef struct _IMAGE_OS2_HEADER {
    WORD    ne_magic;
    CHAR    ne_ver;
    CHAR    ne_rev;
    WORD    ne_enttab;
    WORD    ne_cbenttab;
    LONG    ne_crc;
    WORD    ne_flags;
    WORD    ne_autodata;
    WORD    ne_heap;
    WORD    ne_stack;
    LONG    ne_csip;
    LONG    ne_sssp;
    WORD    ne_cseg;
    WORD    ne_cmod;
    WORD    ne_cbnrestab;
    WORD    ne_segtab;
    WORD    ne_rsrctab;
    WORD    ne_restab;
    WORD    ne_modtab;
    WORD    ne_imptab;
    LONG    ne_nrestab;
    WORD    ne_cmovent;
    WORD    ne_align;
    WORD    ne_cres;
    BYTE    ne_exetyp;
    BYTE    ne_flagsothers;
    WORD    ne_pretthunks;
    WORD    ne_psegrefbytes;
    WORD    ne_swaparea;
    WORD    ne_expver;
} IMAGE_OS2_HEADER;
typedef IMAGE_OS2_HEADER    *PIMAGE_OS2_HEADER;

/* Header for VxD images */
typedef struct _IMAGE_VXD_HEADER {
    WORD    e32_magic;
    BYTE    e32_border;
    BYTE    e32_worder;
    DWORD   e32_level;
    WORD    e32_cpu;
    WORD    e32_os;
    DWORD   e32_ver;
    DWORD   e32_mflags;
    DWORD   e32_mpages;
    DWORD   e32_startobj;
    DWORD   e32_eip;
    DWORD   e32_stackobj;
    DWORD   e32_esp;
    DWORD   e32_pagesize;
    DWORD   e32_lastpagesize;
    DWORD   e32_fixupsize;
    DWORD   e32_fixupsum;
    DWORD   e32_ldrsize;
    DWORD   e32_ldrsum;
    DWORD   e32_objtab;
    DWORD   e32_objcnt;
    DWORD   e32_objmap;
    DWORD   e32_itermap;
    DWORD   e32_rsrctab;
    DWORD   e32_rsccnt;
    DWORD   e32_restab;
    DWORD   e32_enttab;
    DWORD   e32_dirtab;
    DWORD   e32_dircnt;
    DWORD   e32_fpagetab;
    DWORD   e32_frectab;
    DWORD   e32_impmod;
    DWORD   e32_impmodcnt;
    DWORD   e32_impproc;
    DWORD   e32_pagesum;
    DWORD   e32_datapage;
    DWORD   e32_preload;
    DWORD   e32_nrestab;
    DWORD   e32_cbnrestab;
    DWORD   e32_nressum;
    DWORD   e32_autodata;
    DWORD   e32_debuginfo;
    DWORD   e32_debuglen;
    DWORD   e32_instpreload;
    DWORD   e32_instdemand;
    DWORD   e32_heapsize;
    BYTE    e32_res3[12];
    DWORD   e32_winresoff;
    DWORD   e32_winreslen;
    WORD    e32_devid;
    WORD    e32_ddkver;
} IMAGE_VXD_HEADER;
typedef IMAGE_VXD_HEADER    *PIMAGE_VXD_HEADER;

/* Revert to default packing. */
#include <poppack.h>

/* Header for PE image files */
typedef struct _IMAGE_FILE_HEADER {
    WORD    Machine;
    WORD    NumberOfSections;
    DWORD   TimeDateStamp;
    DWORD   PointerToSymbolTable;
    DWORD   NumberOfSymbols;
    WORD    SizeOfOptionalHeader;
    WORD    Characteristics;
} IMAGE_FILE_HEADER;
typedef IMAGE_FILE_HEADER   *PIMAGE_FILE_HEADER;

/* Image data directory */
typedef struct _IMAGE_DATA_DIRECTORY {
    DWORD   VirtualAddress;
    DWORD   Size;
} IMAGE_DATA_DIRECTORY;
typedef IMAGE_DATA_DIRECTORY    *PIMAGE_DATA_DIRECTORY;

/* Optional header for PE image files (32-bit version) */
typedef struct _IMAGE_OPTIONAL_HEADER {
    WORD                    Magic;
    BYTE                    MajorLinkerVersion;
    BYTE                    MinorLinkerVersion;
    DWORD                   SizeOfCode;
    DWORD                   SizeOfInitializedData;
    DWORD                   SizeOfUninitializedData;
    DWORD                   AddressOfEntryPoint;
    DWORD                   BaseOfCode;
    DWORD                   BaseOfData;
    DWORD                   ImageBase;
    DWORD                   SectionAlignment;
    DWORD                   FileAlignment;
    WORD                    MajorOperatingSystemVersion;
    WORD                    MinorOperatingSystemVersion;
    WORD                    MajorImageVersion;
    WORD                    MinorImageVersion;
    WORD                    MajorSubsystemVersion;
    WORD                    MinorSubsystemVersion;
    DWORD                   Win32VersionValue;
    DWORD                   SizeOfImage;
    DWORD                   SizeOfHeaders;
    DWORD                   CheckSum;
    WORD                    Subsystem;
    WORD                    DllCharacteristics;
    DWORD                   SizeOfStackReserve;
    DWORD                   SizeOfStackCommit;
    DWORD                   SizeOfHeapReserve;
    DWORD                   SizeOfHeapCommit;
    DWORD                   LoaderFlags;
    DWORD                   NumberOfRvaAndSizes;
    IMAGE_DATA_DIRECTORY    DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
} IMAGE_OPTIONAL_HEADER32;
typedef IMAGE_OPTIONAL_HEADER32 *PIMAGE_OPTIONAL_HEADER32;

/* Optional header for PE image files (64-bit version) */
typedef struct _IMAGE_OPTIONAL_HEADER64 {
    WORD                    Magic;
    BYTE                    MajorLinkerVersion;
    BYTE                    MinorLinkerVersion;
    DWORD                   SizeOfCode;
    DWORD                   SizeOfInitializedData;
    DWORD                   SizeOfUninitializedData;
    DWORD                   AddressOfEntryPoint;
    DWORD                   BaseOfCode;
    ULONGLONG               ImageBase;
    DWORD                   SectionAlignment;
    DWORD                   FileAlignment;
    WORD                    MajorOperatingSystemVersion;
    WORD                    MinorOperatingSystemVersion;
    WORD                    MajorImageVersion;
    WORD                    MinorImageVersion;
    WORD                    MajorSubsystemVersion;
    WORD                    MinorSubsystemVersion;
    DWORD                   Win32VersionValue;
    DWORD                   SizeOfImage;
    DWORD                   SizeOfHeaders;
    DWORD                   CheckSum;
    WORD                    Subsystem;
    WORD                    DllCharacteristics;
    ULONGLONG               SizeOfStackReserve;
    ULONGLONG               SizeOfStackCommit;
    ULONGLONG               SizeOfHeapReserve;
    ULONGLONG               SizeOfHeapCommit;
    DWORD                   LoaderFlags;
    DWORD                   NumberOfRvaAndSizes;
    IMAGE_DATA_DIRECTORY    DataDirectory[IMAGE_NUMBEROF_DIRECTORY_ENTRIES];
} IMAGE_OPTIONAL_HEADER64;
typedef IMAGE_OPTIONAL_HEADER64 *PIMAGE_OPTIONAL_HEADER64;

/* Map generic names to the 32- or 64-bit version. */
typedef IMAGE_OPTIONAL_HEADER32     IMAGE_OPTIONAL_HEADER;
typedef PIMAGE_OPTIONAL_HEADER32    PIMAGE_OPTIONAL_HEADER;

/* Optional header for ROM image files */
typedef struct _IMAGE_ROM_OPTIONAL_HEADER {
    WORD    Magic;
    BYTE    MajorLinkerVersion;
    BYTE    MinorLinkerVersion;
    DWORD   SizeOfCode;
    DWORD   SizeOfInitializedData;
    DWORD   SizeOfUninitializedData;
    DWORD   AddressOfEntryPoint;
    DWORD   BaseOfCode;
    DWORD   BaseOfData;
    DWORD   BaseOfBss;
    DWORD   GprMask;
    DWORD   CprMask[4];
    DWORD   GpValue;
} IMAGE_ROM_OPTIONAL_HEADER;
typedef IMAGE_ROM_OPTIONAL_HEADER   *PIMAGE_ROM_OPTIONAL_HEADER;

/* Required and optional headers for PE images (32-bit version) */
typedef struct _IMAGE_NT_HEADERS {
    DWORD                   Signature;
    IMAGE_FILE_HEADER       FileHeader;
    IMAGE_OPTIONAL_HEADER32 OptionalHeader;
} IMAGE_NT_HEADERS32;
typedef IMAGE_NT_HEADERS32  *PIMAGE_NT_HEADERS32;

/* Required and optional headers for PE images (64-bit version) */
typedef struct _IMAGE_NT_HEADERS64 {
    DWORD                   Signature;
    IMAGE_FILE_HEADER       FileHeader;
    IMAGE_OPTIONAL_HEADER64 OptionalHeader;
} IMAGE_NT_HEADERS64;
typedef IMAGE_NT_HEADERS64  *PIMAGE_NT_HEADERS64;

/* Map generic names to the 32- or 64-bit version. */
typedef IMAGE_NT_HEADERS32  IMAGE_NT_HEADERS;
typedef PIMAGE_NT_HEADERS32 PIMAGE_NT_HEADERS;

/* Required and optional headers for ROM images */
typedef struct _IMAGE_ROM_HEADERS {
    IMAGE_FILE_HEADER           FileHeader;
    IMAGE_ROM_OPTIONAL_HEADER   OptionalHeader;
} IMAGE_ROM_HEADERS;
typedef IMAGE_ROM_HEADERS   *PIMAGE_ROM_HEADERS;

/* Header for non-COFF object files */
typedef struct ANON_OBJECT_HEADER {
    WORD    Sig1;
    WORD    Sig2;
    WORD    Version;
    WORD    Machine;
    DWORD   TimeDateStamp;
    CLSID   ClassID;
    DWORD   SizeOfData;
} ANON_OBJECT_HEADER;

/* Header for non-COFF object files (version 2) */
typedef struct ANON_OBJECT_HEADER_V2 {
    WORD    Sig1;
    WORD    Sig2;
    WORD    Version;
    WORD    Machine;
    DWORD   TimeDateStamp;
    CLSID   ClassID;
    DWORD   SizeOfData;
    DWORD   Flags;
    DWORD   MetaDataSize;
    DWORD   MetaDataOffset;
} ANON_OBJECT_HEADER_V2;

/* Header for non-COFF object files (big object) */
typedef struct ANON_OBJECT_HEADER_BIGOBJ {
    WORD    Sig1;
    WORD    Sig2;
    WORD    Version;
    WORD    Machine;
    DWORD   TimeDateStamp;
    CLSID   ClassID;
    DWORD   SizeOfData;
    DWORD   Flags;
    DWORD   MetaDataSize;
    DWORD   MetaDataOffset;
    DWORD   NumberOfSections;
    DWORD   PointerToSymbolTable;
    DWORD   NumberOfSymbols;
} ANON_OBJECT_HEADER_BIGOBJ;

/* Image section header */
typedef struct _IMAGE_SECTION_HEADER {
    BYTE    Name[IMAGE_SIZEOF_SHORT_NAME];
    union {
        DWORD   PhysicalAddress;
        DWORD   VirtualSize;
    } Misc;
    DWORD   VirtualAddress;
    DWORD   SizeOfRawData;
    DWORD   PointerToRawData;
    DWORD   PointerToRelocations;
    DWORD   PointerToLinenumbers;
    WORD    NumberOfRelocations;
    WORD    NumberOfLinenumbers;
    DWORD   Characteristics;
} IMAGE_SECTION_HEADER;
typedef IMAGE_SECTION_HEADER    *PIMAGE_SECTION_HEADER;

/* The following structures get two-byte packing. */
#include <pshpack2.h>

/* Image symbol */
typedef struct _IMAGE_SYMBOL {
    union {
        BYTE    ShortName[8];
        struct {
            DWORD   Short;
            DWORD   Long;
        } Name;
        DWORD   LongName[2];
    } N;
    DWORD   Value;
    SHORT   SectionNumber;
    WORD    Type;
    BYTE    StorageClass;
    BYTE    NumberOfAuxSymbols;
} IMAGE_SYMBOL;
typedef IMAGE_SYMBOL UNALIGNED  *PIMAGE_SYMBOL;

/* Image symbol (extended version) */
typedef struct _IMAGE_SYMBOL_EX {
    union {
        BYTE    ShortName[8];
        struct {
            DWORD   Short;
            DWORD   Long;
        } Name;
        DWORD   LongName[2];
    } N;
    DWORD   Value;
    LONG    SectionNumber;
    WORD    Type;
    BYTE    StorageClass;
    BYTE    NumberOfAuxSymbols;
} IMAGE_SYMBOL_EX;
typedef IMAGE_SYMBOL_EX UNALIGNED   *PIMAGE_SYMBOL_EX;

/* Image auxiliary symbol token definition */
typedef struct IMAGE_AUX_SYMBOL_TOKEN_DEF {
    BYTE    bAuxType;
    BYTE    bReserved;
    DWORD   SymbolTableIndex;
    BYTE    rgbReserved[12];
} IMAGE_AUX_SYMBOL_TOKEN_DEF;
typedef IMAGE_AUX_SYMBOL_TOKEN_DEF UNALIGNED    *PIMAGE_AUX_SYMBOL_TOKEN_DEF;

/* Image auxiliary symbol */
typedef union _IMAGE_AUX_SYMBOL {
    struct {
        DWORD   TagIndex;
        union {
            struct {
                WORD    Linenumber;
                WORD    Size;
            } LnSz;
            DWORD   TotalSize;
        } Misc;
        union {
            struct {
                DWORD   PointerToLinenumber;
                DWORD   PointerToNextFunction;
            } Function;
            struct {
                WORD    Dimension[4];
            } Array;
        } FcnAry;
        WORD    TvIndex;
    } Sym;
    struct {
        BYTE    Name[IMAGE_SIZEOF_SYMBOL];
    } File;
    struct {
        DWORD   Length;
        WORD    NumberOfRelocations;
        WORD    NumberOfLinenumbers;
        DWORD   CheckSum;
        SHORT   Number;
        BYTE    Selection;
        BYTE    bReserved;
        SHORT   HighNumber;
    } Section;
    IMAGE_AUX_SYMBOL_TOKEN_DEF  TokenDef;
    struct {
        DWORD   crc;
        BYTE    rgbReserved[14];
    } CRC;
} IMAGE_AUX_SYMBOL;
typedef IMAGE_AUX_SYMBOL UNALIGNED  *PIMAGE_AUX_SYMBOL;

/* Image auxiliary symbol (extended version) */
typedef union _IMAGE_AUX_SYMBOL_EX {
    struct {
        DWORD   WeakDefaultSymIndex;
        DWORD   WeakSearchType;
        BYTE    rgbReserved[12];
    } Sym;
    struct {
        BYTE    Name[20];
    } File;
    struct {
        DWORD   Length;
        WORD    NumberOfRelocations;
        WORD    NumberOfLinenumbers;
        DWORD   CheckSum;
        SHORT   Number;
        BYTE    Selection;
        BYTE    bReserved;
        SHORT   HighNumber;
        BYTE    rgbReserved[2];
    } Section;
    struct {
        IMAGE_AUX_SYMBOL_TOKEN_DEF  TokenDef;
        BYTE                        rgbReserved[2];
    };
    struct {
        DWORD   crc;
        BYTE    rgbReserved[16];
    } CRC;
} IMAGE_AUX_SYMBOL_EX;
typedef IMAGE_AUX_SYMBOL_EX UNALIGNED   *PIMAGE_AUX_SYMBOL_EX;

/* Image auxiliary symbol types */
typedef enum IMAGE_AUX_SYMBOL_TYPE {
    IMAGE_AUX_SYMBOL_TYPE_TOKEN_DEF = 1
} IMAGE_AUX_SYMBOL_TYPE;

/* Image relocation */
typedef struct _IMAGE_RELOCATION {
    union {
        DWORD   VirtualAddress;
        DWORD   RelocCount;
    };
    DWORD   SymbolTableIndex;
    WORD    Type;
} IMAGE_RELOCATION;
typedef IMAGE_RELOCATION UNALIGNED  *PIMAGE_RELOCATION;

/* Image line number */
typedef struct _IMAGE_LINENUMBER {
    union {
        DWORD   SymbolTableIndex;
        DWORD   VirtualAddress;
    } Type;
    WORD    Linenumber;
} IMAGE_LINENUMBER;
typedef IMAGE_LINENUMBER UNALIGNED  *PIMAGE_LINENUMBER;

/* Revert to default packing. */
#include <poppack.h>

/* Image base relocation */
typedef struct _IMAGE_BASE_RELOCATION {
    DWORD   VirtualAddress;
    DWORD   SizeOfBlock;
} IMAGE_BASE_RELOCATION;
typedef IMAGE_BASE_RELOCATION UNALIGNED *PIMAGE_BASE_RELOCATION;

/* Image archive (static library) member header */
typedef struct _IMAGE_ARCHIVE_MEMBER_HEADER {
    BYTE    Name[16];
    BYTE    Date[12];
    BYTE    UserID[6];
    BYTE    GroupID[6];
    BYTE    Mode[8];
    BYTE    Size[10];
    BYTE    EndHeader[2];
} IMAGE_ARCHIVE_MEMBER_HEADER;
typedef IMAGE_ARCHIVE_MEMBER_HEADER *PIMAGE_ARCHIVE_MEMBER_HEADER;

/* Image export directory */
typedef struct _IMAGE_EXPORT_DIRECTORY {
    DWORD   Characteristics;
    DWORD   TimeDateStamp;
    WORD    MajorVersion;
    WORD    MinorVersion;
    DWORD   Name;
    DWORD   Base;
    DWORD   NumberOfFunctions;
    DWORD   NumberOfNames;
    DWORD   AddressOfFunctions;
    DWORD   AddressOfNames;
    DWORD   AddressOfNameOrdinals;
} IMAGE_EXPORT_DIRECTORY;
typedef IMAGE_EXPORT_DIRECTORY  *PIMAGE_EXPORT_DIRECTORY;

/* Image import directory */
typedef struct _IMAGE_IMPORT_BY_NAME {
    WORD    Hint;
    BYTE    Name[1];
} IMAGE_IMPORT_BY_NAME;
typedef IMAGE_IMPORT_BY_NAME    *PIMAGE_IMPORT_BY_NAME;

/* Image thunk data (32-bit version) */
typedef struct _IMAGE_THUNK_DATA32 {
    union {
        DWORD   ForwarderString;
        DWORD   Function;
        DWORD   Ordinal;
        DWORD   AddressOfData;
    } u1;
} IMAGE_THUNK_DATA32;
typedef IMAGE_THUNK_DATA32  *PIMAGE_THUNK_DATA32;

/* Image thunk data (64-bit version) */
#include <pshpack8.h>
typedef struct _IMAGE_THUNK_DATA64 {
    union {
        ULONGLONG   ForwarderString;
        ULONGLONG   Function;
        ULONGLONG   Ordinal;
        ULONGLONG   AddressOfData;
    } u1;
} IMAGE_THUNK_DATA64;
typedef IMAGE_THUNK_DATA64  *PIMAGE_THUNK_DATA64;
#include <poppack.h>

/* Map generic names to the 32- or 64-bit version. */
typedef IMAGE_THUNK_DATA32  IMAGE_THUNK_DATA;
typedef PIMAGE_THUNK_DATA32 PIMAGE_THUNK_DATA;

/* Image thread local storage directory (32-bit version) */
typedef struct _IMAGE_TLS_DIRECTORY32 {
    DWORD   StartAddressOfRawData;
    DWORD   EndAddressOfRawData;
    DWORD   AddressOfIndex;
    DWORD   AddressOfCallBacks;
    DWORD   SizeOfZeroFill;
    DWORD   Characteristics;
} IMAGE_TLS_DIRECTORY32;
typedef IMAGE_TLS_DIRECTORY32   *PIMAGE_TLS_DIRECTORY32;

/* Image thread local storage directory (64-bit version) */
typedef struct _IMAGE_TLS_DIRECTORY64 {
    ULONGLONG   StartAddressOfRawData;
    ULONGLONG   EndAddressOfRawData;
    ULONGLONG   AddressOfIndex;
    ULONGLONG   AddressOfCallBacks;
    DWORD       SizeOfZeroFill;
    DWORD       Characteristics;
} IMAGE_TLS_DIRECTORY64;
typedef IMAGE_TLS_DIRECTORY64   *PIMAGE_TLS_DIRECTORY64;

/* Map generic names to the 32- or 64-bit version. */
typedef IMAGE_TLS_DIRECTORY32   IMAGE_TLS_DIRECTORY;
typedef PIMAGE_TLS_DIRECTORY32  PIMAGE_TLS_DIRECTORY;

/* Image import descriptor */
typedef struct _IMAGE_IMPORT_DESCRIPTOR {
    union {
        DWORD   Characteristics;
        DWORD   OriginalFirstThunk;
    };
    DWORD   TimeDateStamp;
    DWORD   ForwarderChain;
    DWORD   Name;
    DWORD   FirstThunk;
} IMAGE_IMPORT_DESCRIPTOR;
typedef IMAGE_IMPORT_DESCRIPTOR UNALIGNED   *PIMAGE_IMPORT_DESCRIPTOR;

/* Image bound import descriptor */
typedef struct _IMAGE_BOUND_IMPORT_DESCRIPTOR {
    DWORD   TimeDateStamp;
    WORD    OffsetModuleName;
    WORD    NumberOfModuleForwarderRefs;
} IMAGE_BOUND_IMPORT_DESCRIPTOR;
typedef IMAGE_BOUND_IMPORT_DESCRIPTOR   *PIMAGE_BOUND_IMPORT_DESCRIPTOR;

/* Image bound forwarder reference */
typedef struct _IMAGE_BOUND_FORWARDER_REF {
    DWORD   TimeDateStamp;
    WORD    OffsetModuleName;
    WORD    Reserved;
} IMAGE_BOUND_FORWARDER_REF;
typedef IMAGE_BOUND_FORWARDER_REF   *PIMAGE_BOUND_FORWARDER_REF;

/* Image resource directory */
typedef struct _IMAGE_RESOURCE_DIRECTORY {
    DWORD   Characteristics;
    DWORD   TimeDateStamp;
    WORD    MajorVersion;
    WORD    MinorVersion;
    WORD    NumberOfNamedEntries;
    WORD    NumberOfIdEntries;
} IMAGE_RESOURCE_DIRECTORY;
typedef IMAGE_RESOURCE_DIRECTORY    *PIMAGE_RESOURCE_DIRECTORY;

/* Image resource directory entry */
typedef struct _IMAGE_RESOURCE_DIRECTORY_ENTRY {
    union {
        struct {
            DWORD   NameOffset      : 31;
            DWORD   NameIsString    : 1;
        };
        DWORD   Name;
        WORD    Id;
    };
    union {
        DWORD   OffsetToData;
        struct {
            DWORD   OffsetToDirectory   : 31;
            DWORD   DataIsDirectory     : 1;
        };
    };
} IMAGE_RESOURCE_DIRECTORY_ENTRY;
typedef IMAGE_RESOURCE_DIRECTORY_ENTRY  *PIMAGE_RESOURCE_DIRECTORY_ENTRY;

/* Image resource directory string */
typedef struct _IMAGE_RESOURCE_DIRECTORY_STRING {
    WORD    Length;
    CHAR    NameString[1];
} IMAGE_RESOURCE_DIRECTORY_STRING;
typedef IMAGE_RESOURCE_DIRECTORY_STRING *PIMAGE_RESOURCE_DIRECTORY_STRING;

/* Image resource directory string (Unicode version) */
typedef struct _IMAGE_RESOURCE_DIR_STRING_U {
    WORD    Length;
    WCHAR   NameString[1];
} IMAGE_RESOURCE_DIR_STRING_U;
typedef IMAGE_RESOURCE_DIR_STRING_U *PIMAGE_RESOURCE_DIR_STRING_U;

/* Image resource data entry */
typedef struct _IMAGE_RESOURCE_DATA_ENTRY {
    DWORD   OffsetToData;
    DWORD   Size;
    DWORD   CodePage;
    DWORD   Reserved;
} IMAGE_RESOURCE_DATA_ENTRY;
typedef IMAGE_RESOURCE_DATA_ENTRY   *PIMAGE_RESOURCE_DATA_ENTRY;

/* Image load configuration directory (32-bit version) */
typedef struct {
    DWORD   Size;
    DWORD   TimeDateStamp;
    WORD    MajorVersion;
    WORD    MinorVersion;
    DWORD   GlobalFlagsClear;
    DWORD   GlobalFlagsSet;
    DWORD   CriticalSectionDefaultTimeout;
    DWORD   DeCommitFreeBlockThreshold;
    DWORD   DeCommitTotalFreeThreshold;
    DWORD   LockPrefixTable;
    DWORD   MaximumAllocationSize;
    DWORD   VirtualMemoryThreshold;
    DWORD   ProcessHeapFlags;
    DWORD   ProcessAffinityMask;
    WORD    CSDVersion;
    WORD    Reserved1;
    DWORD   EditList;
    DWORD   SecurityCookie;
    DWORD   SEHandlerTable;
    DWORD   SEHandlerCount;
} IMAGE_LOAD_CONFIG_DIRECTORY32;
typedef IMAGE_LOAD_CONFIG_DIRECTORY32   *PIMAGE_LOAD_CONFIG_DIRECTORY32;

/* Image load configuration directory (64-bit version) */
typedef struct {
    DWORD       Size;
    DWORD       TimeDateStamp;
    WORD        MajorVersion;
    WORD        MinorVersion;
    DWORD       GlobalFlagsClear;
    DWORD       GlobalFlagsSet;
    DWORD       CriticalSectionDefaultTimeout;
    ULONGLONG   DeCommitFreeBlockThreshold;
    ULONGLONG   DeCommitTotalFreeThreshold;
    ULONGLONG   LockPrefixTable;
    ULONGLONG   MaximumAllocationSize;
    ULONGLONG   VirtualMemoryThreshold;
    ULONGLONG   ProcessAffinityMask;
    DWORD       ProcessHeapFlags;
    WORD        CSDVersion;
    WORD        Reserved1;
    ULONGLONG   EditList;
    ULONGLONG   SecurityCookie;
    ULONGLONG   SEHandlerTable;
    ULONGLONG   SEHandlerCount;
} IMAGE_LOAD_CONFIG_DIRECTORY64;
typedef IMAGE_LOAD_CONFIG_DIRECTORY64   *PIMAGE_LOAD_CONFIG_DIRECTORY64;

/* Map generic names to the 32- or 64-bit version. */
typedef IMAGE_LOAD_CONFIG_DIRECTORY32   IMAGE_LOAD_CONFIG_DIRECTORY;
typedef PIMAGE_LOAD_CONFIG_DIRECTORY32  PIMAGE_LOAD_CONFIG_DIRECTORY;

/* Image runtime function entry for Windows CE */
typedef struct _IMAGE_CE_RUNTIME_FUNCTION_ENTRY {
    DWORD   FuncStart;
    DWORD   PrologLen       : 8;
    DWORD   FuncLen         : 22;
    DWORD   ThirtyTwoBit    : 1;
    DWORD   ExceptionFlag   : 1;
} IMAGE_CE_RUNTIME_FUNCTION_ENTRY;
typedef IMAGE_CE_RUNTIME_FUNCTION_ENTRY *PIMAGE_CE_RUNTIME_FUNCTION_ENTRY;

/* Image runtime function entry for the AXP64 processor */
typedef struct _IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY {
    ULONGLONG   BeginAddress;
    ULONGLONG   EndAddress;
    ULONGLONG   ExceptionHandler;
    ULONGLONG   HandlerData;
    ULONGLONG   PrologEndAddress;
} IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY;
typedef IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY    *PIMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY;

/* Image runtime function entry for the Alpha processor */
typedef struct _IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY {
    DWORD   BeginAddress;
    DWORD   EndAddress;
    DWORD   ExceptionHandler;
    DWORD   HandlerData;
    DWORD   PrologEndAddress;
} IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY;
typedef IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY  *PIMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY;

/* Image runtime function entry */
typedef struct _IMAGE_RUNTIME_FUNCTION_ENTRY {
    DWORD   BeginAddress;
    DWORD   EndAddress;
    DWORD   UnwindInfoAddress;
} _IMAGE_RUNTIME_FUNCTION_ENTRY;
typedef _IMAGE_RUNTIME_FUNCTION_ENTRY   *_PIMAGE_RUNTIME_FUNCTION_ENTRY;

/* Map generic names to the version for the current processor. */
#ifdef _ALPHA_
typedef IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY  IMAGE_RUNTIME_FUNCTION_ENTRY;
typedef PIMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY PIMAGE_RUNTIME_FUNCTION_ENTRY;
#else
typedef _IMAGE_RUNTIME_FUNCTION_ENTRY       IMAGE_RUNTIME_FUNCTION_ENTRY;
typedef _PIMAGE_RUNTIME_FUNCTION_ENTRY      PIMAGE_RUNTIME_FUNCTION_ENTRY;
#endif

/* Image debug directory */
typedef struct _IMAGE_DEBUG_DIRECTORY {
    DWORD   Characteristics;
    DWORD   TimeDateStamp;
    WORD    MajorVersion;
    WORD    MinorVersion;
    DWORD   Type;
    DWORD   SizeOfData;
    DWORD   AddressOfRawData;
    DWORD   PointerToRawData;
} IMAGE_DEBUG_DIRECTORY;
typedef IMAGE_DEBUG_DIRECTORY   *PIMAGE_DEBUG_DIRECTORY;

/* Image COFF symbols header */
typedef struct _IMAGE_COFF_SYMBOLS_HEADER {
    DWORD   NumberOfSymbols;
    DWORD   LvaToFirstSymbol;
    DWORD   NumberOfLinenumbers;
    DWORD   LvaToFirstLinenumber;
    DWORD   RvaToFirstByteOfCode;
    DWORD   RvaToLastByteOfCode;
    DWORD   RvaToFirstByteOfData;
    DWORD   RvaToLastByteOfData;
} IMAGE_COFF_SYMBOLS_HEADER;
typedef IMAGE_COFF_SYMBOLS_HEADER   *PIMAGE_COFF_SYMBOLS_HEADER;

/* FPO data */
typedef struct _FPO_DATA {
    DWORD   ulOffStart;
    DWORD   cbProcSize;
    DWORD   cdwLocals;
    WORD    cdwParams;
    WORD    cbProlog    : 8;
    WORD    cbRegs      : 3;
    WORD    fHasSEH     : 1;
    WORD    fUseBP      : 1;
    WORD    reserved    : 1;
    WORD    cbFrame     : 2;
} FPO_DATA;
typedef FPO_DATA    *PFPO_DATA;

/* Image miscellaneous debugging information */
typedef struct _IMAGE_DEBUG_MISC {
    DWORD   DataType;
    DWORD   Length;
    BOOLEAN Unicode;
    BYTE    Reserved[3];
    BYTE    Data[1];
} IMAGE_DEBUG_MISC;
typedef IMAGE_DEBUG_MISC    *PIMAGE_DEBUG_MISC;

/* Image function entry */
typedef struct _IMAGE_FUNCTION_ENTRY {
    DWORD   StartingAddress;
    DWORD   EndingAddress;
    DWORD   EndOfPrologue;
} IMAGE_FUNCTION_ENTRY;
typedef IMAGE_FUNCTION_ENTRY    *PIMAGE_FUNCTION_ENTRY;

/* Image function entry (64-bit version) */
typedef struct _IMAGE_FUNCTION_ENTRY64 {
    ULONGLONG   StartingAddress;
    ULONGLONG   EndingAddress;
    union {
        ULONGLONG   EndOfPrologue;
        ULONGLONG   UnwindInfoAddress;
    };
} IMAGE_FUNCTION_ENTRY64;
typedef IMAGE_FUNCTION_ENTRY64  *PIMAGE_FUNCTION_ENTRY64;

/* Header for separate debugging information files */
typedef struct _IMAGE_SEPARATE_DEBUG_HEADER {
    WORD    Signature;
    WORD    Flags;
    WORD    Machine;
    WORD    Characteristics;
    DWORD   TimeDateStamp;
    DWORD   CheckSum;
    DWORD   ImageBase;
    DWORD   SizeOfImage;
    DWORD   NumberOfSections;
    DWORD   ExportedNamesSize;
    DWORD   DebugDirectorySize;
    DWORD   SectionAlignment;
    DWORD   Reserved[2];
} IMAGE_SEPARATE_DEBUG_HEADER;
typedef IMAGE_SEPARATE_DEBUG_HEADER *PIMAGE_SEPARATE_DEBUG_HEADER;

/* Non-paged debugging information */
typedef struct _NON_PAGED_DEBUG_INFO {
    WORD        Signature;
    WORD        Flags;
    DWORD       Size;
    WORD        Machine;
    WORD        Characteristics;
    DWORD       TimeDateStamp;
    DWORD       CheckSum;
    DWORD       SizeOfImage;
    ULONGLONG   ImageBase;
} NON_PAGED_DEBUG_INFO;
typedef NON_PAGED_DEBUG_INFO    *PNON_PAGED_DEBUG_INFO;

/* Image architecture header */
typedef struct _ImageArchitectureHeader {
    unsigned int    AmaskValue  : 1;
    int                         : 7;
    unsigned int    AmaskShirt  : 8;
    int                         : 16;
    DWORD           FirstEntryRVA;
} IMAGE_ARCHITECTURE_HEADER;
typedef IMAGE_ARCHITECTURE_HEADER   *PIMAGE_ARCHITECTURE_HEADER;

/* Image architecture entry */
typedef struct _ImageArchitectureEntry {
    DWORD   FixupInstRVA;
    DWORD   NewInst;
} IMAGE_ARCHITECTURE_ENTRY;
typedef IMAGE_ARCHITECTURE_ENTRY    *PIMAGE_ARCHITECTURE_ENTRY;

/* Four-byte packing for image structures ends here. */
#include <poppack.h>

/* Import object header */
typedef struct IMPORT_OBJECT_HEADER {
    WORD    Sig1;
    WORD    Sig2;
    WORD    Version;
    WORD    Machine;
    DWORD   TimeDateStamp;
    DWORD   SizeOfData;
    union {
        WORD    Ordinal;
        WORD    Hint;
    };
    WORD    Type        : 2;
    WORD    NameType    : 3;
    WORD    Reserved    : 11;
} IMPORT_OBJECT_HEADER;

/* Import object types */
typedef enum IMPORT_OBJECT_TYPE {
    IMPORT_OBJECT_CODE  = 0,
    IMPORT_OBJECT_DATA  = 1,
    IMPORT_OBJECT_CONST = 2
} IMPORT_OBJECT_TYPE;

/* Import object name types */
typedef enum IMPORT_OBJECT_NAME_TYPE {
    IMPORT_OBJECT_ORDINAL           = 0,
    IMPORT_OBJECT_NAME              = 1,
    IMPORT_OBJECT_NAME_NO_PREFIX    = 2,
    IMPORT_OBJECT_NAME_UNDECORATE   = 3
} IMPORT_OBJECT_NAME_TYPE;

/* Header for managed code images */
typedef struct IMAGE_COR20_HEADER {
    DWORD                   cb;
    WORD                    MajorRuntimeVersion;
    WORD                    MinorRuntimeVersion;
    IMAGE_DATA_DIRECTORY    MetaData;
    DWORD                   Flags;
    union {
        DWORD   EntryPointToken;
        DWORD   EntryPointRVA;
    };
    IMAGE_DATA_DIRECTORY    Resources;
    IMAGE_DATA_DIRECTORY    StrongNameSignature;
    IMAGE_DATA_DIRECTORY    CodeManagerTable;
    IMAGE_DATA_DIRECTORY    VTableFixups;
    IMAGE_DATA_DIRECTORY    ExportAddressTableJumps;
    IMAGE_DATA_DIRECTORY    ManagedNativeHeader;
} IMAGE_COR20_HEADER;
typedef IMAGE_COR20_HEADER  *PIMAGE_COR20_HEADER;

/* Interlocked singly linked list entry */
typedef struct _SLIST_ENTRY {
    struct _SLIST_ENTRY *Next;
} SLIST_ENTRY;
typedef SLIST_ENTRY *PSLIST_ENTRY;
typedef SLIST_ENTRY SLIST_ENTRY32;
typedef SLIST_ENTRY *PSLIST_ENTRY32;

/* Interlocked singly linked list header */
typedef union _SLIST_HEADER {
    ULONGLONG Alignment;
    struct {
        SLIST_ENTRY Next;
        WORD        Depth;
        WORD        Sequence;
    };
} SLIST_HEADER;
typedef SLIST_HEADER    *PSLIST_HEADER;
typedef SLIST_HEADER    SLIST_HEADER32;
typedef SLIST_HEADER    *PSLIST_HEADER32;

/* Run once */
typedef struct _RTL_RUN_ONCE {
    PVOID   Ptr;
} RTL_RUN_ONCE;
typedef RTL_RUN_ONCE    *PRTL_RUN_ONCE;

/* Message resource entry */
typedef struct _MESSAGE_RESOURCE_ENTRY {
    WORD    Length;
    WORD    Flags;
    BYTE    Text[1];
} MESSAGE_RESOURCE_ENTRY;
typedef MESSAGE_RESOURCE_ENTRY  *PMESSAGE_RESOURCE_ENTRY;

/* Message resource block */
typedef struct _MESSAGE_RESOURCE_BLOCK {
    DWORD   LowId;
    DWORD   HighId;
    DWORD   OffsetToEntries;
} MESSAGE_RESOURCE_BLOCK;
typedef MESSAGE_RESOURCE_BLOCK  *PMESSAGE_RESOURCE_BLOCK;

/* Message resource data */
typedef struct _MESSAGE_RESOURCE_DATA {
    DWORD                   NumberOfBlocks;
    MESSAGE_RESOURCE_BLOCK  Blocks[1];
} MESSAGE_RESOURCE_DATA;
typedef MESSAGE_RESOURCE_DATA   *PMESSAGE_RESOURCE_DATA;

/* Operating system version information */
typedef struct _OSVERSIONINFOA {
    DWORD   dwOSVersionInfoSize;
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
    DWORD   dwBuildNumber;
    DWORD   dwPlatformId;
    CHAR    szCSDVersion[128];
} OSVERSIONINFOA;
typedef OSVERSIONINFOA      *POSVERSIONINFOA;
typedef OSVERSIONINFOA      *LPOSVERSIONINFOA;
typedef struct _OSVERSIONINFOW {
    DWORD   dwOSVersionInfoSize;
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
    DWORD   dwBuildNumber;
    DWORD   dwPlatformId;
    WCHAR   szCSDVersion[128];
} OSVERSIONINFOW;
typedef OSVERSIONINFOW      *POSVERSIONINFOW;
typedef OSVERSIONINFOW      *LPOSVERSIONINFOW;
#ifdef UNICODE
typedef OSVERSIONINFOW      OSVERSIONINFO;
typedef POSVERSIONINFOW     POSVERSIONINFO;
typedef LPOSVERSIONINFOW    LPOSVERSIONINFO;
#else
typedef OSVERSIONINFOA      OSVERSIONINFO;
typedef POSVERSIONINFOA     POSVERSIONINFO;
typedef LPOSVERSIONINFOA    LPOSVERSIONINFO;
#endif

/* Operating system version information (extended version) */
typedef struct _OSVERSIONINFOEXA {
    DWORD   dwOSVersionInfoSize;
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
    DWORD   dwBuildNumber;
    DWORD   dwPlatformId;
    CHAR    szCSDVersion[128];
    WORD    wServicePackMajor;
    WORD    wServicePackMinor;
    WORD    wSuiteMask;
    BYTE    wProductType;
    BYTE    wReserved;
} OSVERSIONINFOEXA;
typedef OSVERSIONINFOEXA    *POSVERSIONINFOEXA;
typedef OSVERSIONINFOEXA    *LPOSVERSIONINFOEXA;
typedef struct _OSVERSIONINFOEXW {
    DWORD   dwOSVersionInfoSize;
    DWORD   dwMajorVersion;
    DWORD   dwMinorVersion;
    DWORD   dwBuildNumber;
    DWORD   dwPlatformId;
    WCHAR   szCSDVersion[128];
    WORD    wServicePackMajor;
    WORD    wServicePackMinor;
    WORD    wSuiteMask;
    BYTE    wProductType;
    BYTE    wReserved;
} OSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    *POSVERSIONINFOEXW;
typedef OSVERSIONINFOEXW    *LPOSVERSIONINFOEXW;
#ifdef UNICODE
typedef OSVERSIONINFOEXW    OSVERSIONINFOEX;
typedef POSVERSIONINFOEXW   POSVERSIONINFOEX;
typedef LPOSVERSIONINFOEXW  LPOSVERSIONINFOEX;
#else
typedef OSVERSIONINFOEXA    OSVERSIONINFOEX;
typedef POSVERSIONINFOEXA   POSVERSIONINFOEX;
typedef LPOSVERSIONINFOEXA  LPOSVERSIONINFOEX;
#endif

/* Critical section debugging information */
typedef struct _RTL_CRITICAL_SECTION_DEBUG {
    WORD                            Type;
    WORD                            CreatorBackTraceIndex;
    struct _RTL_CRITICAL_SECTION    *CriticalSection;
    LIST_ENTRY                      ProcessLocksList;
    DWORD                           EntryCount;
    DWORD                           ContentionCount;
    DWORD                           Flags;
    WORD                            CreatorBackTraceIndexHigh;
    WORD                            SpareWORD;
} RTL_CRITICAL_SECTION_DEBUG;
typedef RTL_CRITICAL_SECTION_DEBUG  *PRTL_CRITICAL_SECTION_DEBUG;
typedef RTL_CRITICAL_SECTION_DEBUG  RTL_RESOURCE_DEBUG;
typedef RTL_CRITICAL_SECTION_DEBUG  *PRTL_RESOURCE_DEBUG;

/* Critical section */
#include <pshpack8.h>
typedef struct _RTL_CRITICAL_SECTION {
    PRTL_CRITICAL_SECTION_DEBUG DebugInfo;
    LONG                        LockCount;
    LONG                        RecursionCount;
    HANDLE                      OwningThread;
    HANDLE                      LockSemaphore;
    ULONG_PTR                   SpinCount;
} RTL_CRITICAL_SECTION;
typedef RTL_CRITICAL_SECTION    *PRTL_CRITICAL_SECTION;
#include <poppack.h>

/* Slim reader/writer lock */
typedef struct _RTL_SRWLOCK {
    PVOID   Ptr;
} RTL_SRWLOCK;
typedef RTL_SRWLOCK *PRTL_SRWLOCK;

/* Condition variable */
typedef struct _RTL_CONDITION_VARIABLE {
    PVOID   Ptr;
} RTL_CONDITION_VARIABLE;
typedef RTL_CONDITION_VARIABLE  *PRTL_CONDITION_VARIABLE;

/* Activation context information classes */
typedef enum _ACTIVATION_CONTEXT_INFO_CLASS {
    ActivationContextBasicInformation                       = 1,
    ActivationContextDetailedInformation                    = 2,
    AssemblyDetailedInformationInActivationContext          = 3,
    FileInformationInAssemblyOfAssemblyInActivationContext  = 4,
    RunlevelInformationInActivationContext                  = 5,
    CompatibilityInformationInActivationContext             = 6,
    ActivationContextManifestResourceName                   = 7,
    MaxActivationContextInfoClass                           = 8,
    AssemblyDetailedInformationInActivationContxt           = 3,
    FileInformationInAssemblyOfAssemblyInActivationContxt   = 4
} ACTIVATION_CONTEXT_INFO_CLASS;
typedef ACTIVATION_CONTEXT_INFO_CLASS   ACTIVATIONCONTEXTINFOCLASS;

/* Activation context query index */
typedef struct _ACTIVATION_CONTEXT_QUERY_INDEX {
    DWORD   ulAssemblyIndex;
    DWORD   ulFileIndexInAssembly;
} ACTIVATION_CONTEXT_QUERY_INDEX;
typedef ACTIVATION_CONTEXT_QUERY_INDEX          *PACTIVATION_CONTEXT_QUERY_INDEX;
typedef const ACTIVATION_CONTEXT_QUERY_INDEX    *PCACTIVATION_CONTEXT_QUERY_INDEX;

/* Assembly file detailed information */
typedef struct _ASSEMBLY_FILE_DETAILED_INFORMATION {
    DWORD   ulFlags;
    DWORD   ulFilenameLength;
    DWORD   ulPathLength;
    PCWSTR  lpFileName;
    PCWSTR  lpFilePath;
} ASSEMBLY_FILE_DETAILED_INFORMATION;
typedef ASSEMBLY_FILE_DETAILED_INFORMATION          *PASSEMBLY_FILE_DETAILED_INFORMATION;
typedef const ASSEMBLY_FILE_DETAILED_INFORMATION    *PCASSEMBLY_FILE_DETAILED_INFORMATION;

/* Old names for compatibility */
#define _ASSEMBLY_DLL_REDIRECTION_DETAILED_INFORMATION  _ASSEMBLY_FILE_DETAILED_INFORMATION
#define ASSEMBLY_DLL_REDIRECTION_DETAILED_INFORMATION   ASSEMBLY_FILE_DETAILED_INFORMATION
#define PASSEMBLY_DLL_REDIRECTION_DETAILED_INFORMATION  PASSEMBLY_FILE_DETAILED_INFORMATION
#define PCASSEMBLY_DLL_REDIRECTION_DETAILED_INFORMATION PCASSEMBLY_FILE_DETAILED_INFORMATION

/* Activation context assembly detailed information */
typedef struct _ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION {
    DWORD           ulFlags;
    DWORD           ulEncodedAssemblyIdentityLength;
    DWORD           ulManifestPathType;
    DWORD           ulManifestPathLength;
    LARGE_INTEGER   liManifestLastWriteTime;
    DWORD           ulPolicyPathType;
    DWORD           ulPolicyPathLength;
    LARGE_INTEGER   liPolicyLastWriteTime;
    DWORD           ulMetadataSatelliteRosterIndex;
    DWORD           ulManifestVersionMajor;
    DWORD           ulManifestVersionMinor;
    DWORD           ulPolicyVersionMajor;
    DWORD           ulPolicyVersionMinor;
    DWORD           ulAssemblyDirectoryNameLength;
    PCWSTR          lpAssemblyEncodedAssemblyIdentity;
    PCWSTR          lpAssemblyManifestPath;
    PCWSTR          lpAssemblyPolicyPath;
    PCWSTR          lpAssemblyDirectoryName;
    DWORD           ulFileCount;
} ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION;
typedef ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION        *PACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION;
typedef const ACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION  *PCACTIVATION_CONTEXT_ASSEMBLY_DETAILED_INFORMATION;

/* Activation context detailed information */
typedef struct _ACTIVATION_CONTEXT_DETAILED_INFORMATION {
    DWORD   dwFlags;
    DWORD   ulFormatVersion;
    DWORD   ulAssemblyCount;
    DWORD   ulRootManifestPathType;
    DWORD   ulRootManifestPathChars;
    DWORD   ulRootConfigurationPathType;
    DWORD   ulRootConfigurationPathChars;
    DWORD   ulAppDirPathType;
    DWORD   ulAppDirPathChars;
    PCWSTR  lpRootManifestPath;
    PCWSTR  lpRootConfigurationPath;
    PCWSTR  lpAppDirPath;
} ACTIVATION_CONTEXT_DETAILED_INFORMATION;
typedef ACTIVATION_CONTEXT_DETAILED_INFORMATION         *PACTIVATION_CONTEXT_DETAILED_INFORMATION;
typedef const ACTIVATION_CONTEXT_DETAILED_INFORMATION   *PCACTIVATION_CONTEXT_DETAILED_INFORMATION;

/* Activation context run levels */
typedef enum {
    ACTCTX_RUN_LEVEL_UNSPECIFIED        = 0,
    ACTCTX_RUN_LEVEL_AS_INVOKER         = 1,
    ACTCTX_RUN_LEVEL_HIGHEST_AVAILABLE  = 2,
    ACTCTX_RUN_LEVEL_REQUIRE_ADMIN      = 3,
    ACTCTX_RUN_LEVEL_NUMBERS            = 4
} ACTCTX_REQUESTED_RUN_LEVEL;

/* Activation context run level information */
typedef struct _ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION {
    DWORD                       ulFlags;
    ACTCTX_REQUESTED_RUN_LEVEL  RunLevel;
    DWORD                       UiAccess;
} ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION;
typedef ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION        *PACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION;
typedef const ACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION  *PCACTIVATION_CONTEXT_RUN_LEVEL_INFORMATION;

/* Activation context compatibility element types */
typedef enum {
    ACTCTX_COMPATIBILITY_ELEMENT_TYPE_UNKNOWN       = 0,
    ACTCTX_COMPATIBILITY_ELEMENT_TYPE_OS            = 1,
    ACTCTX_COMPATIBILITY_ELEMENT_TYPE_MITIGATION    = 2
} ACTCTX_COMPATIBILITY_ELEMENT_TYPE;

/* Compatibility context element */
typedef struct _COMPATIBILITY_CONTEXT_ELEMENT {
    GUID                                Id;
    ACTCTX_COMPATIBILITY_ELEMENT_TYPE   Type;
} COMPATIBILITY_CONTEXT_ELEMENT;
typedef COMPATIBILITY_CONTEXT_ELEMENT       *PCOMPATIBILITY_CONTEXT_ELEMENT;
typedef const COMPATIBILITY_CONTEXT_ELEMENT *PCCOMPATIBILITY_CONTEXT_ELEMENT;

/* Activation context compatibility information */
typedef struct _ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION {
    DWORD                           ElementCount;
    COMPATIBILITY_CONTEXT_ELEMENT   Elements[1];
} ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION;
typedef ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION        *PACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION;
typedef const ACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION  *PCACTIVATION_CONTEXT_COMPATIBILITY_INFORMATION;

/* Supported operating system information */
typedef struct _SUPPORTED_OS_INFO {
    WORD    OsCount;
    WORD    MitigationExist;
    WORD    OsList[MAX_SUPPORTED_OS_NUM];
} SUPPORTED_OS_INFO;
typedef SUPPORTED_OS_INFO   *PSUPPORTED_OS_INFO;

/* Hardware counter data */
typedef struct _HARDWARE_COUNTER_DATA {
    HARDWARE_COUNTER_TYPE   Type;
    DWORD                   Reserved;
    DWORD64                 Value;
} HARDWARE_COUNTER_DATA;
typedef HARDWARE_COUNTER_DATA   *PHARDWARE_COUNTER_DATA;

/* Performance data */
typedef struct _PERFORMANCE_DATA {
    WORD                    Size;
    BYTE                    Version;
    BYTE                    HwCountersCount;
    DWORD                   ContextSwitchCount;
    DWORD64                 WaitReasonBitMap;
    DWORD64                 CycleTime;
    DWORD                   RetryCount;
    DWORD                   Reserved;
    HARDWARE_COUNTER_DATA   HwCounters[MAX_HW_COUNTERS];
} PERFORMANCE_DATA;
typedef PERFORMANCE_DATA    *PPERFORMANCE_DATA;

/* Event log record */
typedef struct _EVENTLOGRECORD {
    DWORD   Length;
    DWORD   Reserved;
    DWORD   RecordNumber;
    DWORD   TimeGenerated;
    DWORD   TimeWritten;
    DWORD   EventID;
    WORD    EventType;
    WORD    NumStrings;
    WORD    EventCategory;
    WORD    ReservedFlags;
    DWORD   ClosingRecordNumber;
    DWORD   StringOffset;
    DWORD   UserSidLength;
    DWORD   UserSidOffset;
    DWORD   DataLength;
    DWORD   DataOffset;
} EVENTLOGRECORD;
typedef EVENTLOGRECORD  *PEVENTLOGRECORD;

/* Service node types */
typedef enum _CM_SERVICE_NODE_TYPE {
    DriverType                  = SERVICE_KERNEL_DRIVER,
    FileSystemType              = SERVICE_FILE_SYSTEM_DRIVER,
    Win32ServiceOwnProcess      = SERVICE_WIN32_OWN_PROCESS,
    Win32ServiceShareProcess    = SERVICE_WIN32_SHARE_PROCESS,
    AdapterType                 = SERVICE_ADAPTER,
    RecognizerType              = SERVICE_RECOGNIZER_DRIVER
} SERVICE_NODE_TYPE;

/* Service load types */
typedef enum _CM_SERVICE_LOAD_TYPE {
    BootLoad    = SERVICE_BOOT_START,
    SystemLoad  = SERVICE_SYSTEM_START,
    AutoLoad    = SERVICE_AUTO_START,
    DemandLoad  = SERVICE_DEMAND_START,
    DisableLoad = SERVICE_DISABLED
} SERVICE_LOAD_TYPE;

/* Service error control types */
typedef enum _CM_ERROR_CONTROL_TYPE {
    IgnoreError     = SERVICE_ERROR_IGNORE,
    NormalError     = SERVICE_ERROR_NORMAL,
    SevereError     = SERVICE_ERROR_SEVERE,
    CriticalError   = SERVICE_ERROR_CRITICAL
} SERVICE_ERROR_TYPE;

/* Structure used with IOCTL_TAPE_ERASE */
typedef struct _TAPE_ERASE {
    DWORD   Type;
    BOOLEAN Immediate;
} TAPE_ERASE;
typedef TAPE_ERASE  *PTAPE_ERASE;

/* Structure used with IOCTL_TAPE_PREPARE */
typedef struct _TAPE_PREPARE {
    DWORD   Operation;
    BOOLEAN Immediate;
} TAPE_PREPARE;
typedef TAPE_PREPARE    *PTAPE_PREPARE;

/* Structure used with IOCTL_TAPE_WRITE_MARKS */
typedef struct _TAPE_WRITE_MARKS {
    DWORD   Type;
    DWORD   Count;
    BOOLEAN Immediate;
} TAPE_WRITE_MARKS;
typedef TAPE_WRITE_MARKS    *PTAPE_WRITE_MARKS;

/* Structure used with IOCTL_TAPE_GET_POSITION */
typedef struct _TAPE_GET_POSITION {
    DWORD           Type;
    DWORD           Partition;
    LARGE_INTEGER   Offset;
} TAPE_GET_POSITION;
typedef TAPE_GET_POSITION   *PTAPE_GET_POSITION;

/* Structure used with IOCTL_TAPE_SET_POSITION */
typedef struct _TAPE_SET_POSITION {
    DWORD           Method;
    DWORD           Parition;
    LARGE_INTEGER   Offset;
    BOOLEAN         Immediate;
} TAPE_SET_POSITION;
typedef TAPE_SET_POSITION   *PTAPE_SET_POSITION;

/* Structure used with IOCTL_TAPE_GET_DRIVE_PARAMETERS */
typedef struct _TAPE_GET_DRIVE_PARAMETERS {
    BOOLEAN ECC;
    BOOLEAN Compression;
    BOOLEAN DataPadding;
    BOOLEAN ReportSetmarks;
    DWORD   DefaultBlockSize;
    DWORD   MaximumBlockSize;
    DWORD   MinimumBlockSize;
    DWORD   MaximumPartitionCount;
    DWORD   FeaturesLow;
    DWORD   FeaturesHigh;
    DWORD   EOTWarningZoneSize;
} TAPE_GET_DRIVE_PARAMETERS;
typedef TAPE_GET_DRIVE_PARAMETERS   *PTAPE_GET_DRIVE_PARAMETERS;

/* Structure used with IOCTL_TAPE_SET_DRIVE_PARAMETERS */
typedef struct _TAPE_SET_DRIVE_PARAMETERS {
    BOOLEAN ECC;
    BOOLEAN Compression;
    BOOLEAN DataPadding;
    BOOLEAN ReportSetmarks;
    DWORD   EOTWarningZoneSize;
} TAPE_SET_DRIVE_PARAMETERS;
typedef TAPE_SET_DRIVE_PARAMETERS   *PTAPE_SET_DRIVE_PARAMETERS;

/* Structure used with IOCTL_TAPE_GET_MEDIA_PARAMETERS */
typedef struct _TAPE_GET_MEDIA_PARAMETERS {
    LARGE_INTEGER   Capacity;
    LARGE_INTEGER   Remaining;
    DWORD           BlockSize;
    DWORD           PartitionCount;
    BOOLEAN         WriteProtected;
} TAPE_GET_MEDIA_PARAMETERS;
typedef TAPE_GET_MEDIA_PARAMETERS   *PTAPE_GET_MEDIA_PARAMETERS;

/* Structure used with IOCTL_TAPE_SET_MEDIA_PARAMETERS */
typedef struct _TAPE_SET_MEDIA_PARAMETERS {
    DWORD   BlockSize;
} TAPE_SET_MEDIA_PARAMETERS;
typedef TAPE_SET_MEDIA_PARAMETERS   *PTAPE_SET_MEDIA_PARAMETERS;

/* Structure used with IOCTL_TAPE_CREATE_PARTITION */
typedef struct _TAPE_CREATE_PARTITION {
    DWORD   Method;
    DWORD   Count;
    DWORD   Size;
} TAPE_CREATE_PARTITION;
typedef TAPE_CREATE_PARTITION   *PTAPE_CREATE_PARTITION;

/* Structure used with WMI for tape drives */
typedef struct _TAPE_WMI_OPERATIONS {
    DWORD   Method;
    DWORD   DataBufferSize;
    PVOID   DataBuffer;
} TAPE_WMI_OPERATIONS;
typedef TAPE_WMI_OPERATIONS *PTAPE_WMI_OPERATIONS;

/* Tape drive problem types */
typedef enum _TAPE_DRIVE_PROBLEM_TYPE {
    TapeDriveProblemNone,
    TapeDriveReadWriteWarning,
    TapeDriveReadWriteError,
    TapeDriveReadWarning,
    TapeDriveWriteWarning,
    TapeDriveReadError,
    TapeDriveWriteError,
    TapeDriveHardwareError,
    TapeDriveUnsupportedMedia,
    TapeDriveScsiConnectionError,
    TapeDriveTimetoClean,
    TapeDriveCleanDriveNow,
    TapeDriveMediaLifeExpired,
    TapeDriveSnappedTape
} TAPE_DRIVE_PROBLEM_TYPE;

/* Heap information classes */
typedef enum _HEAP_INFORMATION_CLASS {
    HeapCompatibilityInformation,
    HeapEnableTerminationOnCorruption
} HEAP_INFORMATION_CLASS;

/* Callback functions */
typedef VOID    (NTAPI *PAPCFUNC)( ULONG_PTR );
typedef LONG    (NTAPI *PVECTORED_EXCEPTION_HANDLER)( struct _EXCEPTION_POINTERS * );
typedef VOID    (NTAPI *WAITORTIMERCALLBACKFUNC)( PVOID, BOOLEAN );
typedef VOID    (NTAPI *PFLS_CALLBACK_FUNCTION)( PVOID );
typedef BOOLEAN (NTAPI *PSECURE_MEMORY_CACHE_CALLBACK)( PVOID, SIZE_T );

/* Thread pool abstract data types */
typedef struct _TP_CALLBACK_INSTANCE    TP_CALLBACK_INSTANCE;
typedef struct _TP_CALLBACK_INSTANCE    *PTP_CALLBACK_INSTANCE;
typedef struct _TP_POOL                 TP_POOL;
typedef struct _TP_POOL                 *PTP_POOL;
typedef struct _TP_CLEANUP_GROUP        TP_CLEANUP_GROUP;
typedef struct _TP_CLEANUP_GROUP        *PTP_CLEANUP_GROUP;
typedef struct _TP_WORK                 TP_WORK;
typedef struct _TP_WORK                 *PTP_WORK;
typedef struct _TP_TIMER                TP_TIMER;
typedef struct _TP_TIMER                *PTP_TIMER;
typedef struct _TP_WAIT                 TP_WAIT;
typedef struct _TP_WAIT                 *PTP_WAIT;
typedef struct _TP_IO                   TP_IO;
typedef struct _TP_IO                   *PTP_IO;

/* Thread pool callback functions */
typedef VOID (NTAPI *PTP_SIMPLE_CALLBACK)( PTP_CALLBACK_INSTANCE, PVOID );
typedef VOID (NTAPI *PTP_CLEANUP_GROUP_CANCEL_CALLBACK)( PVOID, PVOID );
typedef VOID (NTAPI *PTP_WORK_CALLBACK)( PTP_CALLBACK_INSTANCE, PVOID, PTP_WORK );
typedef VOID (NTAPI *PTP_TIMER_CALLBACK)( PTP_CALLBACK_INSTANCE, PVOID, PTP_TIMER );
typedef VOID (NTAPI *PTP_WAIT_CALLBACK)( PTP_CALLBACK_INSTANCE, PVOID, PTP_WAIT, TP_WAIT_RESULT );

/* Thread pool callback priorities */
typedef enum _TP_CALLBACK_PRIORITY {
    TP_CALLBACK_PRIORITY_HIGH       = 0,
    TP_CALLBACK_PRIORITY_NORMAL     = 1,
    TP_CALLBACK_PRIORITY_LOW        = 2,
    TP_CALLBACK_PRIORITY_INVALID    = 3
} TP_CALLBACK_PRIORITY;

/* Thread pool stack information */
typedef struct _TP_POOL_STACK_INFORMATION {
    SIZE_T  StackReserve;
    SIZE_T  StackCommit;
} TP_POOL_STACK_INFORMATION;
typedef TP_POOL_STACK_INFORMATION   *PTP_POOL_STACK_INFORMATION;

/* Thread pool callback environment */
typedef struct _TP_CALLBACK_ENVIRON {
    TP_VERSION                          Version;
    PTP_POOL                            Pool;
    PTP_CLEANUP_GROUP                   CleanupGroup;
    PTP_CLEANUP_GROUP_CANCEL_CALLBACK   CleanupGroupCancelCallback;
    PVOID                               RaceDll;
    struct _ACTIVATION_CONTEXT          *ActivationContext;
    PTP_SIMPLE_CALLBACK                 FinalizationCallback;
    union {
        DWORD   Flags;
        struct {
            DWORD   LongFunction    : 1;
            DWORD   Persistent      : 1;
            DWORD   Private         : 30;
        } s;
    } u;
#if (_WIN32_WINNT >= 0x0601)
    TP_CALLBACK_PRIORITY                CallbackPriority;
    DWORD                               Size;
#endif
} TP_CALLBACK_ENVIRON;
typedef TP_CALLBACK_ENVIRON *PTP_CALLBACK_ENVIRON;

/* Functions in NTDLL.DLL accessed through aliases in KERNEL32.DLL */
NTSYSAPI VOID NTAPI         RtlUnwind( PVOID, PVOID, PEXCEPTION_RECORD, PVOID );
#if (NTDDI_VERSION >= 0x05000000)
NTSYSAPI ULONGLONG NTAPI    VerSetConditionMask( ULONGLONG, DWORD, BYTE );
#endif
#if (NTDDI_VERSION > 0x05000000)
NTSYSAPI VOID NTAPI         RtlCaptureContext( PCONTEXT );
#endif
#if (NTDDI_VERSION > 0x05010000)
NTSYSAPI WORD NTAPI         RtlCaptureStackBackTrace( DWORD, DWORD, PVOID *, PDWORD );
#endif

/* Functions implemented with inline assembly code */
PVOID   GetCurrentFiber( void );
PVOID   GetFiberData( void );

/* Inline assembly implementation of functions defined above */
#ifdef _X86_
    #pragma aux GetCurrentFiber = \
        "mov eax, dword ptr fs:0x10" \
        value [eax] \
        modify [eax];
    #pragma aux GetFiberData = \
        "mov eax, dword ptr fs:0x10" \
        "mov eax, [eax]" \
        value [eax] \
        modify [eax];
#endif

/* Functions implemented as macros */
#define Int32x32To64( p1, p2 )          ((LONGLONG)(LONG)(p1) * (LONGLONG)(LONG)(p2))
#define UInt32x32To64( p1, p2 )         ((ULONGLONG)(DWORD)(p1) * (ULONGLONG)(DWORD)(p2))
#define Int64ShllMod32( p1, p2 )        ((ULONGLONG)(p1) << (p2))
#define Int64ShraMod32( p1, p2 )        ((LONGLONG)(p1) >> (p2))
#define Int64ShrlMod32( p1, p2 )        ((ULONGLONG)(p1) >> (p2))
#define RtlEqualMemory( p1, p2, p3 )    !memcmp( p1, p2, p3 )
#define RtlMoveMemory( p1, p2, p3 )     memmove( p1, p2, p3 )
#define RtlCopyMemory( p1, p2, p3 )     memcpy( p1, p2, p3 )
#define RtlFillMemory( p1, p2, p3 )     memset( p1, p3, p2 )
#define RtlZeroMemory( p1, p2 )         memset( p1, 0, p2 )
#if (_WIN32_WINNT >= 0x0601)
    #define TpInitializeCallbackEnviron( x ) \
        { \
            (x)->Version = 3; \
            (x)->Pool = NULL; \
            (x)->CleanupGroup = NULL; \
            (x)->CleanupGroupCancelCallback = NULL; \
            (x)->RaceDll = NULL; \
            (x)->ActivationContext = NULL; \
            (x)->FinalizationCallback = NULL; \
            (x)->u.Flags = 0; \
            (x)->CallbackPriority = TP_CALLBACK_PRIORITY_NORMAL; \
            (x)->Size = sizeof( TP_CALLBACK_ENVIRON ); \
        }
#else
    #define TpInitializeCallbackEnviron( x ) \
        { \
            (x)->Version = 1; \
            (x)->Pool = NULL; \
            (x)->CleanupGroup = NULL; \
            (x)->CleanupGroupCancelCallback = NULL; \
            (x)->RaceDll = NULL; \
            (x)->ActivationContext = NULL; \
            (x)->FinalizationCallback = NULL; \
            (x)->u.Flags = 0; \
        }
#endif
#define TpSetCallbackThreadpool( x, p ) \
    { (x)->Pool = p; }
#define TpSetCallbackCleanupGroup( x, p1, p2 ) \
    { \
        (x)->CleanupGroup = p1; \
        (x)->CleanupGroupCancelCallback = p2; \
    }
#define TpSetCallbackActivationContext( x, p ) \
    { (x)->ActivationContext = p; }
#define TpSetCallbackNoActivationContext( x ) \
    { (x)->ActivationContext = (struct _ACTIVATION_CONTEXT *)(LONG_PTR)(-1); }
#define TpSetCallbackLongFunction( x ) \
    { (x)->u.s.LongFunction = 1; }
#define TpSetCallbackRaceWithDll( x, p ) \
    { (x)->RaceDll = p; }
#define TpSetCallbackFinalizationCallback( x, p ) \
    { (x)->FinalizationCallback = p; }
#define TpSetCallbackPersistent( x ) \
    { (x)->u.s.Persistent = 1; }
#define TpDestroyCallbackEnviron( x ) \
    { (x); }
#if (_WIN32_WINNT >= 0x0601)
    #define TpSetCallbackPriority( x, p ) \
        { (x)->CallbackPriority = p; }
#endif

/* Other macros */
#define VER_SET_CONDITION( p1, p2, p3 ) \
    ((p1) = VerSetConditionMask( p1, p2, p3 ))
#define WT_SET_MAX_THREADPOOL_THREADS( p1, p2 ) ((p1) |= (p2) << 16)

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINNT_ */
