/*
 *  strmif.h    ActiveMovie interfaces
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#include <rpc.h>
#include <rpcndr.h>
#ifndef COM_NO_WINDOWS_H
    #include <windows.h>
    #include <ole2.h>
#endif

#ifndef __strmif_h__
#define __strmif_h__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <ddraw.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Forward declarations */
typedef interface IBaseFilter                       IBaseFilter;
typedef interface IEnumMediaTypes                   IEnumMediaTypes;
typedef interface IEnumFilters                      IEnumFilters;
typedef interface IReferenceClock                   IReferenceClock;
typedef interface IFilterGraph                      IFilterGraph;
typedef interface IMemAllocatorNotifyCallbackTemp   IMemAllocatorNotifyCallbackTemp;
typedef interface IAMCopyCaptureFileProgress        IAMCopyCaptureFileProgress;
typedef interface IAMTunerNotification              IAMTunerNotification;
typedef interface IDDrawExclModeVideoCallback       IDDrawExclModeVideoCallback;
typedef interface IGraphConfigCallback              IGraphConfigCallback;
typedef interface IVMRSurfaceAllocatorNotify        IVMRSurfaceAllocatorNotify;
typedef interface IVMRImageCompositor               IVMRImageCompositor;

/* Reference time data types */
typedef LONGLONG    REFERENCE_TIME;
typedef double      REFTIME;

/* Handle data types */
typedef DWORD_PTR   HSEMAPHORE;
typedef DWORD_PTR   HEVENT;

/* DVD register data types */
typedef WORD            DVD_REGISTER;
typedef DVD_REGISTER    GPRMARRAY[16];
typedef DVD_REGISTER    SPRMARRAY[24];

/* Valid UOP data type */
typedef DWORD   VALID_UOP_SOMTHING_OR_OTHER;

/* ICreateDevEnum::CreateClassEnumerator() flags */
#define CDEF_CLASS_DEFAULT          0x00000001L
#define CDEF_BYPASS_CLASS_MANAGER   0x00000002L
#define CDEF_MERIT_ABOVE_DO_NOT_USE 0x00000008L
#define CDEF_DEVMON_CMGR_DEVICE     0x00000010L
#define CDEF_DEVMON_DMO             0x00000020L
#define CDEF_DEVMON_PNP_DEVICE      0x00000040L
#define CDEF_DEVMON_FILTER          0x00000080L
#define CDEF_DEVMON_SELECTIVE_MASK  0x000000F0L

/* String lengths */
#define CHARS_IN_GUID   39
#define MAX_PIN_NAME    128
#define MAX_FILTER_NAME 128

/* IMemAllocator::GetBuffer() flags */
#define AM_GBF_PREVFRAMESKIPPED 1L
#define AM_GBF_NOTASYNCPOINT    2L
#define AM_GBF_NOWAIT           4L
#define AM_GBF_NODDSURFACELOCK  8L

/* IKsPropertySet::QuerySupported() return values */
#define KSPROPERTY_SUPPORT_GET  1
#define KSPROPERTY_SUPPORT_SET  2

/* Media sample content values */
#define MPEG2_PROGRAM_STREAM_MAP            0x00000000L
#define MPEG2_PROGRAM_ELEMENTARY_STREAM     0x00000001L
#define MPEG2_PROGRAM_DIRECTORY_PES_PACKET  0x00000002L
#define MPEG2_PROGRAM_PACK_HEADER           0x00000003L
#define MPEG2_PROGRAM_PES_STREAM            0x00000004L
#define MPEG2_PROGRAM_SYSTEM_HEADER         0x00000005L

/* Substream filter flags */
#define SUBSTREAM_FILTER_VAL_NONE   0x10000000L

/* Decoder capability indices */
#define AM_GETDECODERCAP_QUERY_VMR_SUPPORT  0x00000001L
#define AM_QUERY_DECODER_VMR_SUPPORT        0x00000001L
#define AM_QUERY_DECODER_DXVA_1_SUPPORT     0x00000002L
#define AM_QUERY_DECODER_DVD_SUPPORT        0x00000003L
#define AM_QUERY_DECODER_ATSC_SD_SUPPORT    0x00000004L
#define AM_QUERY_DECODER_ATSC_HD_SUPPORT    0x00000005L
#define AM_GETDECODERCAP_QUERY_VMR9_SUPPORT 0x00000006L
#define AM_GETDECODERCAP_QUERY_EVR_SUPPORT  0x00000007L

/* VMR support flags */
#define VMR_NOTSUPPORTED    0x00000000L
#define VMR_SUPPORTED       0x00000001L

/* Decoder capability flags */
#define DECODER_CAP_NOTSUPPORTED    0x00000000L
#define DECODER_CAP_SUPPORTED       0x00000001L

/* DVD flags */
#define DVD_TITLE_MENU              0x0000
#define DVD_STREAM_DATA_CURRENT     0x0800
#define DVD_STREAM_DATA_VMGM        0x0400
#define DVD_STREAM_DATA_VTSM        0x0401
#define DVD_DEFAULT_AUDIO_STREAM    0x000F

/* DVD audio capabilities */
#define DVD_AUDIO_CAPS_AC3      0x00000001L
#define DVD_AUDIO_CAPS_MPEG2    0x00000002L
#define DVD_AUDIO_CAPS_LPCM     0x00000004L
#define DVD_AUDIO_CAPS_DTS      0x00000008L
#define DVD_AUDIO_CAPS_SDDS     0x00000010L

/* VMR string lengths */
#define VMRDEVICENAMELEN        32
#define VMRDEVICEDESCRIPTIONLEN 256

/* VMR bitmap flags */
#define VMRBITMAP_DISABLE       0x00000001L
#define VMRBITMAP_HDC           0x00000002L
#define VMRBITMAP_ENTIREDDS     0x00000004L
#define VMRBITMAP_SRCCOLORKEY   0x00000008L
#define VMRBITMAP_SRCRECT       0x00000010L

/* ActiveMovie media type */
typedef struct _AMMediaType {
    GUID        majortype;
    GUID        subtype;
    BOOL        bFixedSizeSamples;
    BOOL        bTemporalCompression;
    ULONG       lSampleSize;
    GUID        formattype;
    IUnknown    *pUnk;
    ULONG       cbFormat;
    BYTE        *pbFormat;
} AM_MEDIA_TYPE;

/* Pin directions */
typedef enum _PinDirection {
    PINDIR_INPUT    = 0,
    PINDIR_OUTPUT   = 1
} PIN_DIRECTION;

/* Allocator properties */
typedef struct _AllocatorProperties {
    long    cBuffers;
    long    cbBuffer;
    long    cbAlign;
    long    cbPrefix;
} ALLOCATOR_PROPERTIES;

/* Pin information */
typedef struct _PinInfo {
    IBaseFilter     *pFilter;
    PIN_DIRECTION   dir;
    WCHAR           achName[MAX_PIN_NAME];
} PIN_INFO;

/* Filter states */
typedef enum _FilterState {
    State_Stopped   = 0,
    State_Paused    = 1,
    State_Running   = 2
} FILTER_STATE;

/* Filter information */
typedef struct _FilterInfo {
    WCHAR           achName[MAX_FILTER_NAME];
    IFilterGraph    *pGraph;
} FILTER_INFO;

/* ActiveMovie sample property flags */
enum tagAM_SAMPLE_PROPERTY_FLAGS {
    AM_SAMPLE_SPLICEPOINT       = 0x00000001,
    AM_SAMPLE_PREROLL           = 0x00000002,
    AM_SAMPLE_DATADISCONTINUITY = 0x00000004,
    AM_SAMPLE_TYPECHANGED       = 0x00000008,
    AM_SAMPLE_TIMEVALID         = 0x00000010,
    AM_SAMPLE_TIMEDISCONTINUITY = 0x00000040,
    AM_SAMPLE_FLUSH_ON_PAUSE    = 0x00000080,
    AM_SAMPLE_STOPVALID         = 0x00000100,
    AM_SAMPLE_ENDOFSTREAM       = 0x00000200,
    AM_STREAM_MEDIA             = 0,
    AM_STREAM_CONTROL           = 1
};

/* ActiveMovie sample properties */
typedef struct tagAM_SAMPLE2_PROPERTIES {
    DWORD           cbData;
    DWORD           dwTypeSpecificFlags;
    DWORD           dwSampleFlags;
    LONG            lActual;
    REFERENCE_TIME  tStart;
    REFERENCE_TIME  tStop;
    DWORD           dwStreamId;
    AM_MEDIA_TYPE   *pMediaType;
    BYTE            *pbBuffer;
    LONG            cbBuffer;
} AM_SAMPLE2_PROPERTIES;

/* ActiveMovie seeking flags */
typedef enum AM_SEEKING_SeekingFlags {
    AM_SEEKING_NoPositioning            = 0x00000000,
    AM_SEEKING_AbsolutePositioning      = 0x00000001,
    AM_SEEKING_RelativePositioning      = 0x00000002,
    AM_SEEKING_IncrementalPositioning   = 0x00000003,
    AM_SEEKING_PositioningBitsMask      = 0x00000003,
    AM_SEEKING_SeekToKeyFrame           = 0x00000004,
    AM_SEEKING_ReturnTime               = 0x00000008,
    AM_SEEKING_Segment                  = 0x00000010,
    AM_SEEKING_NoFlush                  = 0x00000020
} AM_SEEKING_SEEKING_FLAGS;

/* ActiveMovie seeking capabilities */
typedef enum AM_SEEKING_SeekingCapabilities {
    AM_SEEKING_CanSeekAbsolute  = 0x00000001,
    AM_SEEKING_CanSeekForwards  = 0x00000002,
    AM_SEEKING_CanSeekBackwards = 0x00000004,
    AM_SEEKING_CanGetCurrentPos = 0x00000008,
    AM_SEEKING_CanGetStopPos    = 0x00000010,
    AM_SEEKING_CanGetDuration   = 0x00000020,
    AM_SEEKING_CanPlayBackwards = 0x00000040,
    AM_SEEKING_CanDoSegments    = 0x00000080,
    AM_SEEKING_Source           = 0x00000100
} AM_SEEKING_SEEKING_CAPABILITIES;

/* ActiveMovie media event flags */
enum tagAM_MEDIAEVENT_FLAGS {
    AM_MEDIAEVENT_NONOTIFY  = 0x00000001
};

/* Registered filter */
typedef struct REGFILTER {
    CLSID   Clsid;
    LPWSTR  Name;
} REGFILTER;

/* Merit values */
enum {
    MERIT_PREFERRED     = 0x00800000,
    MERIT_NORMAL        = 0x00600000,
    MERIT_UNLIKELY      = 0x00400000,
    MERIT_DO_NOT_USE    = 0x00200000,
    MERIT_SW_COMPRESSOR = 0x00100000,
    MERIT_HW_COMPRESSOR = 0x00100050
};

/* Registered pin types */
typedef struct REGPINTYPES {
    const CLSID *clsMajorType;
    const CLSID *clsMinorType;
} REGPINTYPES;

/* Registered filter pins */
typedef struct REGFILTERPINS {
    LPWSTR              strName;
    BOOL                bRendered;
    BOOL                bOutput;
    BOOL                bZero;
    BOOL                bMany;
    const CLSID         *clsConnectsToFilter;
    const WCHAR         *strConnectsToPin;
    UINT                nMediaTypes;
    const REGPINTYPES   *lpMediaType;
} REGFILTERPINS;

/* Registered pin medium */
typedef struct REGPINMEDIUM {
    CLSID   clsMedium;
    DWORD   dw1;
    DWORD   dw2;
} REGPINMEDIUM;

/* Registered filter pin flags */
enum {
    REG_PINFLAG_B_ZERO      = 0x00000001,
    REG_PINFLAG_B_RENDERER  = 0x00000002,
    REG_PINFLAG_B_MANY      = 0x00000004,
    REG_PINFLAG_B_OUTPUT    = 0x00000008
};

/* Registered filter pins (version 2) */
typedef struct REGFILTERPINS2 {
    DWORD               dwFlags;
    UINT                cInstances;
    UINT                nMediaTypes;
    const REGPINTYPES   *lpMediaType;
    UINT                nMediums;
    const REGPINMEDIUM  *lpMedium;
    const CLSID         *clsPinCategory;
} REGFILTERPINS2;

/* Registered filter (version 2) */
typedef struct REGFILTER2 {
    DWORD   dwVersion;
    DWORD   dwMerit;
    union {
        struct {
            ULONG               cPins;
            const REGFILTERPINS *rgPins;
        };
        struct {
            ULONG                   cPins2;
            const REGFILTERPINS2    *rgPins2;
        };
    };
} REGFILTER2;

/* Quality message types */
typedef enum tagQualityMessageType {
    Famine  = 0,
    Flood   = 1
} QualityMessageType;

/* Quality */
typedef struct tagQuality {
    QualityMessageType  Type;
    long                Proportion;
    REFERENCE_TIME      Late;
    REFERENCE_TIME      TimeStamp;
} Quality;

/* Color key types */
enum {
    CK_NOCOLORKEY   = 0x00000000,
    CK_INDEX        = 0x00000001,
    CK_RGB          = 0x00000002
};

/* Color key */
typedef struct tagCOLORKEY {
    DWORD       KeyType;
    DWORD       PaletteIndex;
    COLORREF    LowColorValue;
    COLORREF    HighColorValue;
} COLORKEY;

/* Advise flags */
enum {
    ADVISE_NONE             = 0x00000000,
    ADVISE_CLIPPING         = 0x00000001,
    ADVISE_PALETTE          = 0x00000002,
    ADVISE_COLORKEY         = 0x00000004,
    ADVISE_POSITION         = 0x00000008,
    ADVISE_DISPLAY_CHANGE   = 0x00000010
};
#define ADVISE_ALL \
    (ADVISE_CLIPPING | ADVISE_PALETTE | ADVISE_COLORREY | ADVISE_POSITION)
#define ADVISE_ALL2 \
    (ADVISE_ALL | ADVISE_DISPLAY_CHANGE)

/* ActiveMovie file sink flags */
typedef enum AM_FILESINK_FLAGS {
    AM_FILE_OVERWRITE   = 0x00000001
} AM_FILESINK_FLAGS;

/* ActiveMovie extended render flags */
enum _AM_RENDEREXFLAGS {
    AM_RENDEREX_RENDERTOEXISTINGRENDERERS   = 0x00000001
};

/* ActiveMovie stream information flags */
typedef enum AM_STREAM_INFO_FLAGS {
    AM_STREAM_INFO_START_DEFINED    = 0x00000001,
    AM_STREAM_INFO_STOP_DEFINED     = 0x00000002,
    AM_STREAM_INFO_DISCARDING       = 0x00000004,
    AM_STREAM_INFO_STOP_SEND_EXTRA  = 0x00000010
} AM_STREAM_INFO_FLAGS;

/* ActiveMovie stream information */
typedef struct AM_STREAM_INFO {
    REFERENCE_TIME  tStart;
    REFERENCE_TIME  tStop;
    DWORD           dwStartCookie;
    DWORD           dwStopCookie;
    DWORD           dwFlags;
} AM_STREAM_INFO;

/* Video stream configuration capabilities */
typedef struct _VIDEO_STREAM_CONFIG_CAPS {
    GUID        guid;
    ULONG       VideoStandard;
    SIZE        InputSize;
    SIZE        MinCroppingSize;
    SIZE        MaxCroppingSize;
    int         CropGranularityX;
    int         CropGranularityY;
    int         CropAlignX;
    int         CropAlignY;
    SIZE        MinOutputSize;
    SIZE        MaxOutputSize;
    int         OutputGranularityX;
    int         OutputGranularityY;
    int         StretchTapsX;
    int         StretchTapsY;
    int         ShrinkTapsX;
    int         ShrinkTapsY;
    LONGLONG    MinFrameInterval;
    LONGLONG    MaxFrameInterval;
    LONG        MinBitsPerSecond;
    LONG        MaxBitsPerSecond;
} VIDEO_STREAM_CONFIG_CAPS;

/* Audio stream configuration capabilities */
typedef struct _AUDIO_STREAM_CONFIG_CAPS {
    GUID    guid;
    ULONG   MinimumChannels;
    ULONG   MaximumChannels;
    ULONG   ChannelsGranularity;
    ULONG   MinimumBitsPerSample;
    ULONG   MaximumBitsPerSample;
    ULONG   BitsPerSampleGranularity;
    ULONG   MinimumSampleFrequency;
    ULONG   MaximumSampleFrequency;
    ULONG   SampleFrequencyGranularity;
} AUDIO_STREAM_CONFIG_CAPS;

/* Interleaving modes */
typedef enum InterleavingMode {
    INTERLEAVE_NONE             = 0,
    INTERLEAVE_CAPTURE          = 1,
    INTERLEAVE_FULL             = 2,
    INTERLEAVE_NONE_BUFFERED    = 3
} InterleavingMode;

/* Compression capabilities */
typedef enum CompressionCaps {
    CompressionCaps_CanQuality  = 0x00000001,
    CompressionCaps_CanCrunch   = 0x00000002,
    CompressionCaps_CanKeyFrame = 0x00000004,
    CompressionCaps_CanBFrame   = 0x00000008,
    CompressionCaps_CanWindow   = 0x00000010
} CompressionCaps;

/* Video for Windows capture dialogs */
typedef enum VfwCaptureDialogs {
    VfwCaptureDialog_Source     = 0x00000001,
    VfwCaptureDialog_Format     = 0x00000002,
    VfwCaptureDialog_Display    = 0x00000004
} VfwCaptureDialogs;

/* Video for Windows compression dialogs */
typedef enum VfwCompressDialogs {
    VfwCompressDialog_Config        = 0x00000001,
    VfwCompressDialog_About         = 0x00000002,
    VfwCompressDialog_QueryConfig   = 0x00000004,
    VfwCompressDialog_QueryAbout    = 0x00000008
} VfwCompressDialog;

/* Analog video standards */
typedef enum tagAnalogVideoStandard {
    AnalogVideo_None            = 0x00000000,
    AnalogVideo_NTSC_M          = 0x00000001,
    AnalogVideo_NTSC_M_J        = 0x00000002,
    AnalogVideo_NTSC_433        = 0x00000004,
    AnalogVideo_PAL_B           = 0x00000010,
    AnalogVideo_PAL_D           = 0x00000020,
    AnalogVideo_PAL_G           = 0x00000040,
    AnalogVideo_PAL_H           = 0x00000080,
    AnalogVideo_PAL_I           = 0x00000100,
    AnalogVideo_PAL_M           = 0x00000200,
    AnalogVideo_PAL_N           = 0x00000400,
    AnalogVideo_PAL_60          = 0x00000800,
    AnalogVideo_SECAM_B         = 0x00001000,
    AnalogVideo_SECAM_D         = 0x00002000,
    AnalogVideo_SECAM_G         = 0x00004000,
    AnalogVideo_SECAM_H         = 0x00008000,
    AnalogVideo_SECAM_K         = 0x00010000,
    AnalogVideo_SECAM_K1        = 0x00020000,
    AnalogVideo_SECAM_L         = 0x00040000,
    AnalogVideo_SECAM_L1        = 0x00080000,
    AnalogVideo_PAL_N_COMBO     = 0x00100000,
    AnalogVideoMask_MCE_NTSC    = AnalogVideo_NTSC_M | AnalogVideo_NTSC_M_J |
        AnalogVideo_PAL_M | AnalogVideo_PAL_N | AnalogVideo_PAL_60 | 
        AnalogVideo_PAL_N_COMBO,
    AnalogVideoMask_MCE_PAL     = AnalogVideo_PAL_B | AnalogVideo_PAL_D |
        AnalogVideo_PAL_G | AnalogVideo_PAL_H | AnalogVideo_PAL_I,
    AnalogVideoMask_MCE_SECAM   = AnalogVideo_SECAM_B | AnalogVideo_SECAM_D |
        AnalogVideo_SECAM_G | AnalogVideo_SECAM_H | AnalogVideo_SECAM_K |
        AnalogVideo_SECAM_K1 | AnalogVideo_SECAM_L | AnalogVideo_SECAM_L1
} AnalogVideoStandard;
#define AnalogVideo_NTSC_Mask   0x00000007
#define AnalogVideo_PAL_Mask    0x00100FF0
#define AnalogVideo_SECAM_Mask  0x000FF000

/* Tuner input types */
typedef enum tagTunerInputType {
    TunerInputCable     = 0,
    TunerInputAntenna   = 1
} TunerInputType;

/* Video copy protection types */
typedef enum VideoCopyProtectionType {
    VideoCopyProtectionMacrovisionBasic = 0,
    VideoCopyProtectionMacrovisionCBI   = 1
} VideoCopyProtectionType;

/* Physical connector types */
typedef enum tagPhysicalConnectorType {
    PhysConn_Video_Tuner            = 0x0001,
    PhysConn_Video_Composite        = 0x0002,
    PhysConn_Video_SVideo           = 0x0003,
    PhysConn_Video_RGB              = 0x0004,
    PhysConn_Video_YRYBY            = 0x0005,
    PhysConn_Video_SerialDigital    = 0x0006,
    PhysConn_Video_ParallelDigital  = 0x0007,
    PhysConn_Video_SCSI             = 0x0008,
    PhysConn_Video_AUX              = 0x0009,
    PhysConn_Video_1394             = 0x000A,
    PhysConn_Video_USB              = 0x000B,
    PhysConn_Video_VideoDecoder     = 0x000C,
    PhysConn_Video_VideoEncoder     = 0x000D,
    PhysConn_Video_SCART            = 0x000E,
    PhysConn_Video_Black            = 0x000F,
    PhysConn_Audio_Tuner            = 0x1000,
    PhysConn_Audio_Line             = 0x1001,
    PhysConn_Audio_Mic              = 0x1002,
    PhysConn_Audio_AESDigital       = 0x1003,
    PhysConn_Audio_SPDIFDigital     = 0x1004,
    PhysConn_Audio_SCSI             = 0x1005,
    PhysConn_Audio_AUX              = 0x1006,
    PhysConn_Audio_1394             = 0x1007,
    PhysConn_Audio_USB              = 0x1008,
    PhysConn_Audio_AudioDecoder     = 0x1009
} PhysicalConnectorType;

/* Video procedure amplification properties */
typedef enum tagVideoProcAmpProperty {
    VideoProcAmp_Brightness             = 0,
    VideoProcAmp_Contrast               = 1,
    VideoProcAmp_Hue                    = 2,
    VideoProcAmp_Saturation             = 3,
    VideoProcAmp_Sharpness              = 4,
    VideoProcAmp_Gamma                  = 5,
    VideoProcAmp_ColorEnable            = 6,
    VideoProcAmp_WhiteBalance           = 7,
    VideoProcAmp_BacklightCompensation  = 8,
    VideoProcAmp_Gain                   = 9
} VideoProcAmpProperty;

/* Video procedure amplification flags */
typedef enum tagVideoProcAmpFlags {
    VideoProcAmp_Flags_Auto     = 0x00000001,
    VideoProcAmp_Flags_Manual   = 0x00000002
} VideoProcAmpFlags;

/* Camera control properties */
typedef enum tagCameraControlProperty {
    CameraControl_Pan       = 0,
    CameraControl_Tilt      = 1,
    CameraControl_Roll      = 2,
    CameraControl_Zoom      = 3,
    CameraControl_Exposure  = 4,
    CameraControl_Iris      = 5,
    CameraControl_Focus     = 6
} CameraControlProperty;

/* Camera control flags */
typedef enum tagCameraControlFlags {
    CameraControl_Flags_Auto    = 0x00000001,
    CameraControl_Flags_Manual  = 0x00000002
} CameraControlFlags;

/* Video control flags */
typedef enum tagVideoControlFlags {
    VideoControlFlags_FlipHorizontal        = 0x00000001,
    VideoControlFlags_FlipVertical          = 0x00000002,
    VideoControlFlags_ExternalTriggerEnable = 0x00000004,
    VideoControlFlags_Trigger               = 0x00000008
} VideoControlFlags;

/* ActiveMovie tuner subchannels */
typedef enum tagAMTunerSubchannel {
    AMTUNER_SUBCHAN_NO_TUNE = -2,
    AMTUNER_SUBCHAN_DEFAULT = -1
} AMTunerSubchannel;

/* ActiveMovie tuner signal strengths */
typedef enum tagAMTunerSignalStrength {
    AMTUNER_HASNOSIGNALSTRENGTH = -1,
    AMTUNER_NOSIGNAL            = 0,
    AMTUNER_SIGNALPRESENT       = 1
} AMTunerSignalStrength;

/* ActiveMovie tuner mode types */
typedef enum tagAMTunerModeType {
    AMTUNER_MODE_DEFAULT    = 0x00000000,
    AMTUNER_MODE_TV         = 0x00000001,
    AMTUNER_MODE_FM_RADIO   = 0x00000002,
    AMTUNER_MODE_AM_RADIO   = 0x00000004,
    AMTUNER_MODE_DSS        = 0x00000008
} AMTunerModeType;

/* ActiveMovie tuner event types */
typedef enum tagAMTunerEventType {
    AMTUNER_EVENT_CHANGED   = 0x00000001
} AMTunerEventType;

/* TV audio modes */
typedef enum tagTVAudioMode {
    AMTVAUDIO_MODE_MONO     = 0x00000001,
    AMTVAUDIO_MODE_STEREO   = 0x00000002,
    AMTVAUDIO_MODE_LANG_A   = 0x00000010,
    AMTVAUDIO_MODE_LANG_B   = 0x00000020,
    AMTVAUDIO_MODE_LANG_C   = 0x00000040,
    AMTVAUDIO_PRESET_STEREO = 0x00000200,
    AMTVAUDIO_PRESET_LANG_A = 0x00001000,
    AMTVAUDIO_PRESET_LANG_B = 0x00002000,
    AMTVAUDIO_PRESET_LANG_C = 0x00004000
} TVAudioMode;

/* ActiveMovie TV audio event types */
typedef enum tagAMTVAudioEventType {
    AMTVAUDIO_EVENT_CHANGED = 0x00000001
} AMTVAudioEventType;

/* ActiveMovie property pins */
typedef enum AMPROPERTY_PIN {
    AMPROPERTY_PIN_CATEGORY = 0,
    AMPROPERTY_PIN_MEDIUM   = 1
} AMPROPERTY_PIN;

#ifndef TIMECODE_DEFINED
#define TIMECODE_DEFINED

/* Time code */
typedef union _timecode {
    struct {
        WORD    wFrameRate;
        WORD    wFrameFract;
        DWORD   dwFrames;
    };
    DWORDLONG   qw;
} TIMECODE;
typedef TIMECODE    *PTIMECODE;

/* Time code sample */
typedef struct tagTIMECODE_SAMPLE {
    LONGLONG    qwTick;
    TIMECODE    timecode;
    DWORD       dwUser;
    DWORD       dwFlags;
} TIMECODE_SAMPLE;
typedef TIMECODE_SAMPLE *PTIMECODE_SAMPLE;

#endif /* TIMECODE_DEFINED */

/* IAMStreamSelection::Info() flags */
enum _AMSTREAMSELECTINFOFLAGS {
    AMSTREAMSELECTINFO_ENABLED      = 0x00000001,
    AMSTREAMSELECTINFO_EXCLUSIVE    = 0x00000002
};

/* IAMStreamSelection::Enable() flags */
enum _AMSTREAMSELECTENABLEFLAGS {
    AMSTREAMSELECTENABLE_ENABLE     = 0x00000001,
    AMSTREAMSELECTENABLE_ENABLEALL  = 0x00000002
};

/* ActiveMovie resource control reserve flags */
enum _ASRESCTL_RESERVEFLAGS {
    AMRESCTL_RESERVEFLAGS_RESERVE   = 0x00000000,
    AMRESCTL_RESERVEFLAGS_UNRESERVE = 0x00000001
};

/* ActiveMovie filter miscellaneous flags */
enum _AM_FILTER_MISC_FLAGS {
    AM_FILTER_MISC_FLAGS_IS_RENDERER    = 0x00000001,
    AM_FILTER_MISC_FLAGS_IS_SOURCE      = 0x00000002
} AM_FILTER_MISC_FLAGS;

/* Decimation usages */
typedef enum _DECIMATION_USAGE {
    DECIMATION_LEGACY               = 0,
    DECIMATION_USE_DECODER_ONLY     = 1,
    DECIMATION_USE_VIDEOPORT_ONLY   = 2,
    DECIMATION_USE_OVERLAY_ONLY     = 3,
    DECIMATION_DEFAULT              = 4
} DECIMATION_USAGE;

/* ActiveMovie push source flags */
enum _AM_PUSHSOURCE_FLAGS {
    AM_PUSHSOURCECAPS_INTERNAL_RM       = 0x00000001,
    AM_PUSHSOURCECAPS_NOT_LIVE          = 0x00000002,
    AM_PUSHSOURCECAPS_PRIVATE_CLOCK     = 0x00000004,
    AM_PUSHSOURCEREQS_USE_STREAM_CLOCK  = 0x00010000,
    AM_PUSHSOURCEREQS_USE_CLOCK_CHAIN   = 0x00020000
};

/* Digital video information */
typedef struct DVINFO {
    DWORD   dwDVAAuxSrc;
    DWORD   dwDVAAuxCtl;
    DWORD   dwDVAAuxSrc1;
    DWORD   dwDVAAuxCtl1;
    DWORD   dwDVVAuxSrc;
    DWORD   dwDVVAuxCtl;
    DWORD   dwDVReserved[2];
} DVINFO;
typedef DVINFO  *PDVINFO;

/* Digital video encoder resolutions */
enum _DVENCODERRESOLUTION {
    DVENCODERRESOLUTION_720x480 = 2012,
    DVENCODERRESOLUTION_360x240 = 2013,
    DVENCODERRESOLUTION_180x120 = 2014,
    DVENCODERRESOLUTION_88x60   = 2015
};

/* Digital video encoder video formats */
enum _DVENCODERVIDEOFORMAT {
    DVENCODERVIDEOFORMAT_NTSC   = 2000,
    DVENCODERVIDEOFORMAT_PAL    = 2001
};

/* Digital video encoder formats */
enum _DVENCODERFORMAT {
    DVENCODERFORMAT_DVSD    = 2007,
    DVENCODERFORMAT_DVHD    = 2008,
    DVENCODERFORMAT_DVSL    = 2009
};

/* Digital video decoder resolutions */
enum _DVDECODERRESOLUTION {
    DVDECODERRESOLUTION_720x480 = 1000,
    DVDECODERRESOLUTION_360x420 = 1001,
    DVDECODERRESOLUTION_180x120 = 1002,
    DVDECODERRESOLUTION_88x60   = 1003
};

/* Digital video resolution */
enum _DVRESOLUTION {
    DVRESOLUTION_FULL       = 1000,
    DVRESOLUTION_HALF       = 1001,
    DVRESOLUTION_QUARTER    = 1002,
    DVRESOLUTION_DC         = 1003
};

/* ActiveMovie audio renderer statistics parameters */
enum _AM_AUDIO_RENDERER_STAT_PARAM {
    AM_AUDREND_STAT_PARAM_BREAK_COUNT               = 1,
    AM_AUDREND_STAT_PARAM_SLAVE_MODE                = 2,
    AM_AUDREND_STAT_PARAM_SILENCE_DUR               = 3,
    AM_AUDREND_STAT_PARAM_LAST_BUFFER_DUR           = 4,
    AM_AUDREND_STAT_PARAM_DISCONTINUITIES           = 5,
    AM_AUDREND_STAT_PARAM_SLAVE_RATE                = 6,
    AM_AUDREND_STAT_PARAM_SLAVE_DROPWRITE_DUR       = 7,
    AM_AUDREND_STAT_PARAM_SLAVE_HIGHLOWERROR        = 8,
    AM_AUDREND_STAT_PARAM_SLAVE_LASTHIGHLOWERROR    = 9,
    AM_AUDREND_STAT_PARAM_SLAVE_ACCUMERROR          = 10,
    AM_AUDREND_STAT_PARAM_BUFFERFULLNESS            = 11,
    AM_AUDREND_STAT_PARAM_JITTER                    = 12
};

/* ActiveMovie interface search flags */
enum _AM_INTF_SEARCH_FLAGS {
    AM_INTF_SEARCH_INPUT_PIN    = 0x00000001,
    AM_INTF_SEARCH_OUTPUT_PIN   = 0x00000002,
    AM_INTF_SEARCH_FILTER       = 0x00000004
};

/* ActiveMovie overlay effects */
enum AMOVERLAYFX {
    AMOVERFX_NOFX               = 0x00000000,
    AMOVERFX_MIRRORLEFTRIGHT    = 0x00000002,
    AMOVERFX_MIRRORUPDOWN       = 0x00000004,
    AMOVERFX_DEINTERLACE        = 0x00000008
};

/* Stream identifier map */
typedef struct STREAM_ID_MAP {
    ULONG   stream_id;
    DWORD   dwMediaSampleContent;
    ULONG   ulSubstreamFilterValue;
    int     iDataOffset;
} STREAM_ID_MAP;

/* Codec API event data */
struct CodecAPIEventData {
    GUID    guid;
    DWORD   dataLength;
    DWORD   reserved[3];
};

/* Video encoder bit rate modes */
typedef enum VIDEOENCODER_BITRATE_MODE {
    ConstantBitRate         = 0,
    VariableBitRateAverage  = 1,
    VariableBitRatePeak     = 2
} VIDEOENCODER_BITRATE_MODE;

/* ActiveMovie COPP signature */
typedef struct _AMCOPPSignature {
    BYTE    Signature[256];
} AMCOPPSignature;

/* ActiveMovie COPP command */
typedef struct _AMCOPPCommand {
    GUID    macKDI;
    GUID    guidCommandID;
    DWORD   dwSequence;
    DWORD   cbSizeData;
    BYTE    CommandData[4056];
} AMCOPPCommand;
typedef AMCOPPCommand   *LPAMCOPPCommand;

/* ActiveMovie COPP status input */
typedef struct _AMCOPPStatusInput {
    GUID    rApp;
    GUID    guidStatusRequestID;
    DWORD   dwSequence;
    DWORD   cbSizeData;
    BYTE    StatusData[4056];
} AMCOPPStatusInput;
typedef AMCOPPStatusInput   *LPAMCOPPStatusInput;

/* ActiveMovie COPP status output */
typedef struct _AMCOPPStatusOutput {
    GUID    macKDI;
    DWORD   cbSizeData;
    BYTE    COPPStatus[4076];
} AMCOPPStatusOutput;
typedef AMCOPPStatusOutput  *LPAMCOPPStatusOutput;

/* DVD domains */
typedef enum tagDVD_DOMAIN {
    DVD_DOMAIN_FirstPlay            = 1,
    DVD_DOMAIN_VideoManagerMenu     = 2,
    DVD_DOMAIN_VideoTitleSetMenu    = 3,
    DVD_DOMAIN_Title                = 4,
    DVD_DOMAIN_Stop                 = 5
} DVD_DOMAIN;

/* DVD menu identifiers */
typedef enum tagDVD_MENU_ID {
    DVD_MENU_Title      = 2,
    DVD_MENU_Root       = 3,
    DVD_MENU_Subpicture = 4,
    DVD_MENU_Audio      = 5,
    DVD_MENU_Angle      = 6,
    DVD_MENU_Chapter    = 7
} DVD_MENU_ID;

/* DVD disc sides */
typedef enum tagDVD_DISC_SIDE {
    DVD_SIDE_A  = 1,
    DVD_SIDE_B  = 2
} DVD_DISC_SIDE;

/* DVD preferred display modes */
typedef enum tagDVD_PREFERRED_DISPLAY_MODE {
    DISPLAY_CONTENT_DEFAULT         = 0,
    DISPLAY_16x9                    = 1,
    DISPLAY_4x3_PANSCAN_PREFERRED   = 2,
    DISPLAY_4x3_LETTERBOX_PREFERRED = 3
} DVD_PREFERRED_DISPLAY_MODE;

/* DVD attribute */
typedef struct tagDVD_ATR {
    ULONG   ulCAT;
    BYTE    pbATRI[768];
} DVD_ATR;
typedef BYTE    DVD_VideoATR[2];
typedef BYTE    DVD_AudioATR[8];
typedef BYTE    DVD_SubpictureATR[6];

/* DVD frame rates */
typedef enum tagDVD_FRAMERATE {
    DVD_FPS_25          = 1,
    DVD_FPS_30NonDrop   = 3
} DVD_FRAMERATE;

/* DVD time code */
typedef struct tagDVD_TIMECODE {
    ULONG   Hours1          : 4;
    ULONG   Hours10         : 4;
    ULONG   Minutes1        : 4;
    ULONG   Minutes10       : 4;
    ULONG   Seconds1        : 4;
    ULONG   Seconds10       : 4;
    ULONG   Frames1         : 4;
    ULONG   Frames10        : 2;
    ULONG   FrameRateCode   : 2;
} DVD_TIMECODE;

/* DVD navigation command types */
typedef enum tagDVD_NavCmdType {
    DVD_NavCmdType_Pre      = 1,
    DVD_NavCmdType_Post     = 2,
    DVD_NavCmdType_Cell     = 3,
    DVD_NavCmdType_Button   = 4
} DVD_NavCmdType;

/* DVD time code flags */
typedef enum tagDVD_TIMECODE_FLAGS {
    DVD_TC_FLAG_25fps           = 0x00000001,
    DVD_TC_FLAG_30fps           = 0x00000002,
    DVD_TC_FLAG_DropFrame       = 0x00000004,
    DVD_TC_FLAG_Interpolated    = 0x00000008
} DVD_TIMECODE_FLAGS;

/* DVD HMSF time code */
typedef struct tagDVD_HMSF_TIMECODE {
    BYTE    bHours;
    BYTE    bMinutes;
    BYTE    bSeconds;
    BYTE    bFrames;
} DVD_HMSF_TIMECODE;

/* DVD playback location (version 2) */
typedef struct tagDVD_PLAYBACK_LOCATION2 {
    ULONG               TitleNum;
    ULONG               ChapterNum;
    DVD_HMSF_TIMECODE   TimeCode;
    ULONG               TimeCodeFlags;
} DVD_PLAYBACK_LOCATION2;

/* DVD playback location */
typedef struct tagDVD_PLAYBACK_LOCATION {
    ULONG   TitleNum;
    ULONG   ChapterNum;
    ULONG   TimeCode;
} DVD_PLAYBACK_LOCATION;

/* Valid UOP flags */
typedef enum {
    UOP_FLAG_Play_Title_Or_AtTime                   = 0x00000001,
    UOP_FLAG_Play_Chapter                           = 0x00000002,
    UOP_FLAG_Play_Title                             = 0x00000004,
    UOP_FLAG_Stop                                   = 0x00000008,
    UOP_FLAG_ReturnFromSubMenu                      = 0x00000010,
    UOP_FLAG_Play_Chapter_Or_AtTime                 = 0x00000020,
    UOP_FLAG_PlayPrev_Or_Replay_Chapter             = 0x00000040,
    UOP_FLAG_PlayNext_Chapter                       = 0x00000080,
    UOP_FLAG_Play_Forwards                          = 0x00000100,
    UOP_FLAG_Play_Backwards                         = 0x00000200,
    UOP_FLAG_ShowMenu_Title                         = 0x00000400,
    UOP_FLAG_ShowMenu_Root                          = 0x00000800,
    UOP_FLAG_ShowMenu_SubPic                        = 0x00001000,
    UOP_FLAG_ShowMenu_Audio                         = 0x00002000,
    UOP_FLAG_ShowMenu_Angle                         = 0x00004000,
    UOP_FLAG_ShowMenu_Chapter                       = 0x00008000,
    UOP_FLAG_Resume                                 = 0x00010000,
    UOP_FLAG_Select_Or_Activate_Button              = 0x00020000,
    UOP_FLAG_Still_Off                              = 0x00040000,
    UOP_FLAG_Pause_On                               = 0x00080000,
    UOP_FLAG_Select_Audio_Stream                    = 0x00100000,
    UOP_FLAG_Select_SubPic_Stream                   = 0x00200000,
    UOP_FLAG_Select_Angle                           = 0x00400000,
    UOP_FLAG_Select_Karaoke_Audio_Presentation_Mode = 0x00800000,
    UOP_FLAG_Select_Video_Mode_Preference           = 0x01000000
} VALID_UOP_FLAG;

/* DVD command flags */
typedef enum {
    DVD_CMD_FLAG_None               = 0x00000000,
    DVD_CMD_FLAG_Flush              = 0x00000001,
    DVD_CMD_FLAG_SendEvents         = 0x00000002,
    DVD_CMD_FLAG_Block              = 0x00000004,
    DVD_CMD_FLAG_StartWhenRendered  = 0x00000008,
    DVD_CMD_FLAG_EndAfterRendered   = 0x00000010
} DVD_CMD_FLAGS;

/* IDVDControl2::SetOption() flags */
typedef enum {
    DVD_ResetOnStop                     = 1,
    DVD_NotifyParentalLevelChange       = 2,
    DVD_HMSF_TimeCodeEvents             = 3,
    DVD_AudioDuringFFwdRew              = 4,
    DVD_EnableNonblockingAPIs           = 5,
    DVD_CacheSizeInMB                   = 6,
    DVD_EnablePortableBookmarks         = 7,
    DVD_EnableExtendedCopyProtectErrors = 8,
    DVD_NotifyPositionChange            = 9,
    DVD_IncreaseOutputControl           = 10,
    DVD_EnableStreaming                 = 11,
    DVD_EnableESOutput                  = 12,
    DVD_EnableTitleLength               = 13,
    DVD_DisableStillThrottle            = 14,
    DVD_EnableLoggingEvents             = 15,
    DVD_MaxReadBurstInKB                = 16,
    DVD_ReadBurstPeriodInMS             = 17
} DVD_OPTION_FLAG;

/* DVD relative button */
typedef enum {
    DVD_Relative_Upper  = 1,
    DVD_Relative_Lower  = 2,
    DVD_Relative_Left   = 3,
    DVD_Relative_Right  = 4
} DVD_RELATIVE_BUTTON;

/* DVD parental level */
typedef enum tagDVD_PARENTAL_LEVEL {
    DVD_PARENTAL_LEVEL_8    = 0x8000,
    DVD_PARENTAL_LEVEL_7    = 0x4000,
    DVD_PARENTAL_LEVEL_6    = 0x2000,
    DVD_PARENTAL_LEVEL_5    = 0x1000,
    DVD_PARENTAL_LEVEL_4    = 0x0800,
    DVD_PARENTAL_LEVEL_3    = 0x0400,
    DVD_PARENTAL_LEVEL_2    = 0x0200,
    DVD_PARENTAL_LEVEL_1    = 0x0100
} DVD_PARENTAL_LEVEL;

/* DVD audio language extensions */
typedef enum tagDVD_AUDIO_LANG_EXT {
    DVD_AUD_EXT_NotSpecified        = 0,
    DVD_AUD_EXT_Captions            = 1,
    DVD_AUD_EXT_VisuallyImpaired    = 2,
    DVD_AUD_EXT_DirectorComments1   = 3,
    DVD_AUD_EXT_DirectorComments2   = 4
} DVD_AUDIO_LANG_EXT;

/* DVD subpicture language extensions */
typedef enum tagDVD_SUBPICTURE_LANG_EXT {
    DVD_SP_EXT_NotSpecified                 = 0,
    DVD_SP_EXT_Caption_Normal               = 1,
    DVD_SP_EXT_Caption_Big                  = 2,
    DVD_SP_EXT_Caption_Children             = 3,
    DVD_SP_EXT_CC_Normal                    = 5,
    DVD_SP_EXT_CC_Big                       = 6,
    DVD_SP_EXT_CC_Children                  = 7,
    DVD_SP_EXT_Forced                       = 9,
    DVD_SP_EXT_DirectorComments_Normal      = 13,
    DVD_SP_EXT_DirectorComments_Big         = 14,
    DVD_SP_EXT_DirectorComments_Children    = 15
} DVD_SUBPICTURE_LANG_EXT;

/* DVD audio application modes */
typedef enum tagDVD_AUDIO_APPMODE {
    DVD_AudioMode_None      = 0,
    DVD_AudioMode_Karaoke   = 1,
    DVD_AudioMode_Surround  = 2,
    DVD_AudioMode_Other     = 3
} DVD_AUDIO_APPMODE;

/* DVD audio format */
typedef enum tagDVD_AUDIO_FORMAT {
    DVD_AudioFormat_AC3         = 0,
    DVD_AudioFormat_MPEG1       = 1,
    DVD_AudioFormat_MPEG1_DRC   = 2,
    DVD_AudioFormat_MPEG2       = 3,
    DVD_AudioFormat_MPEG2_DRC   = 4,
    DVD_AudioFormat_LPCM        = 5,
    DVD_AudioFormat_DTS         = 6,
    DVD_AudioFormat_SDDS        = 7,
    DVD_AudioFormat_Other       = 8
} DVD_AUDIO_FORMAT;

/* SelectKaraokeAudioPresentationMode() flags */
typedef enum tagDVD_KARAOKE_DOWNMIX {
    DVD_Mix_0to0    = 0x0001,
    DVD_Mix_1to0    = 0x0002,
    DVD_Mix_2to0    = 0x0004,
    DVD_Mix_3to0    = 0x0008,
    DVD_Mix_4to0    = 0x0010,
    DVD_Mix_Lto0    = 0x0020,
    DVD_Mix_Rto0    = 0x0040,
    DVD_Mix_0to1    = 0x0100,
    DVD_Mix_1to1    = 0x0200,
    DVD_Mix_2to1    = 0x0400,
    DVD_Mix_3to1    = 0x0800,
    DVD_Mix_4to1    = 0x1000,
    DVD_Mix_Lto1    = 0x2000,
    DVD_Mix_Rto1    = 0x4000
} DVD_KARAOKE_DOWNMIX;

/* DVD audio attributes */
typedef struct tagDVD_AudioAttributes {
    DVD_AUDIO_APPMODE   AppMode;
    BYTE                AppModeData;
    DVD_AUDIO_FORMAT    AudioFormat;
    LCID                Language;
    DVD_AUDIO_LANG_EXT  LanguageExtension;
    BOOL                fHasMultichannelInfo;
    DWORD               dwFrequency;
    BYTE                bQuantization;
    BYTE                bNumberOfChannels;
    DWORD               dwReserved[2];
} DVD_AudioAttributes;

/* DVD MUA mixing information */
typedef struct tagDVD_MUA_MixingInfo {
    BOOL    fMixTo0;
    BOOL    fMixTo1;
    BOOL    fMix0InPhase;
    BOOL    fMix1InPhase;
    DWORD   dwSpeakerPosition;
} DVD_MUA_MixingInfo;

/* DVD MUA coefficient */
typedef struct tagDVD_MUA_Coeff {
    double  log2_alpha;
    double  log2_beta;
} DVD_MUA_Coeff;

/* DVD multichannel audio attributes */
typedef struct tagDVD_MultichannelAudioAttributes {
    DVD_MUA_MixingInfo  Info[8];
    DVD_MUA_Coeff       Coeff[8];
} DVD_MultichannelAudioAttributes;

/* DVD karaoke contents */
typedef enum tagDVD_KARAOKE_CONTENTS {
    DVD_Karaoke_GuideVocal1     = 0x0001,
    DVD_Karaoke_GuideVocal2     = 0x0002,
    DVD_Karaoke_GuideMelody1    = 0x0004,
    DVD_Karaoke_GuideMelody2    = 0x0008,
    DVD_Karaoke_GuideMelodyA    = 0x0010,
    DVD_Karaoke_GuideMelodyB    = 0x0020,
    DVD_Karaoke_SoundEffectA    = 0x0040,
    DVD_Karaoke_SoundEffectB    = 0x0080
} DVD_KARAOKE_CONTENTS;

/* DVD karaoke assignments */
typedef enum tagDVD_KARAOKE_ASSIGNMENT {
    DVD_Assignment_reserved0    = 0,
    DVD_Assignment_reserved1    = 1,
    DVD_Assignment_LR           = 2,
    DVD_Assignment_LRM          = 3,
    DVD_Assignment_LR1          = 4,
    DVD_Assignment_LRM1         = 5,
    DVD_Assignment_LR12         = 6,
    DVD_Assignment_LRM12        = 7
} DVD_KARAOKE_ASSIGNMENT;

/* DVD karaoke attributes */
typedef struct tagDVD_KaraokeAttributes {
    BYTE                    bVersion;
    BOOL                    fMasterOfCeremoniesInGuideVocal1;
    BOOL                    fDuet;
    DVD_KARAOKE_ASSIGNMENT  ChannelAssignment;
    WORD                    wChannelContents[8];
} DVD_KaraokeAttributes;

/* DVD video compression */
typedef enum tagDVD_VIDEO_COMPRESSION {
    DVD_VideoCompression_Other  = 0,
    DVD_VideoCompression_MPEG1  = 1,
    DVD_VideoCompression_MPEG2  = 2
} DVD_VIDEO_COMPRESSION;

/* DVD video attributes */
typedef struct tagDVD_VideoAttributes {
    BOOL                    fPanscanPermitted;
    BOOL                    fLetterboxPermitted;
    ULONG                   ulAspectX;
    ULONG                   ulAspectY;
    ULONG                   ulFrameRate;
    ULONG                   ulFrameHeight;
    DVD_VIDEO_COMPRESSION   Compression;
    BOOL                    fLine21Field1InGOP;
    BOOL                    fLine21Field2InGOP;
    ULONG                   ulSourceResolutionX;
    ULONG                   ulSourceResolutionY;
    BOOL                    fIsSourceLetterboxed;
    BOOL                    fIsFilmMode;
} DVD_VideoAttributes;

/* DVD subpicture types */
typedef enum tagDVD_SUBPICTURE_TYPE {
    DVD_SPType_NotSpecified = 0,
    DVD_SPType_Language     = 1,
    DVD_SPType_Other        = 2
} DVD_SUBPICTURE_TYPE;

/* DVD subpicture codings */
typedef enum tagDVD_SUBPICTURE_CODING {
    DVD_SPCoding_RunLength  = 0,
    DVD_SPCoding_Extended   = 1,
    DVD_SPCoding_Other      = 2
} DVD_SUBPICTURE_CODING;

/* DVD subpicture attributes */
typedef struct tagDVD_SubpictureAttributes {
    DVD_SUBPICTURE_TYPE     Type;
    DVD_SUBPICTURE_CODING   CodingMode;
    LCID                    Language;
    DVD_SUBPICTURE_LANG_EXT LanguageExtension;
} DVD_SubpictureAttributes;

/* DVD title application modes */
typedef enum tagDVD_TITLE_APPMODE {
    DVD_AppMode_Not_Specified   = 0,
    DVD_AppMode_Karaoke         = 1,
    DVD_AppMode_Other           = 3
} DVD_TITLE_APPMODE;

/* DVD title main attributes */
typedef struct tagDVD_TitleMainAttributes {
    union {
        DVD_TITLE_APPMODE   AppMode;
        DVD_HMSF_TIMECODE   TitleLength;
    };
    DVD_VideoAttributes             VideoAttributes;
    ULONG                           ulNumberOfAudioStreams;
    DVD_AudioAttributes             AudioAttributes[8];
    DVD_MultichannelAudioAttributes MultichannelAudioAttributes[8];
    ULONG                           ulNumberOfSubpictureStreams;
    DVD_SubpictureAttributes        SubpictureAttributes[32];
} DVD_TitleAttributes;

/* DVD menu attributes */
typedef struct tagDVD_MenuAttributes {
    BOOL                        fCompatibleRegion[8];
    DVD_VideoAttributes         VideoAttributes;
    BOOL                        fAudioPresent;
    DVD_AudioAttributes         AudioAttributes;
    BOOL                        fSubpicturePresent;
    DVD_SubpictureAttributes    SubpictureAttributes;
} DVD_MenuAttributes;

/* DVD text string types */
enum DVD_TextStringType {
    DVD_Struct_Volume       = 0x01,
    DVD_Struct_Title        = 0x02,
    DVD_Struct_ParentalID   = 0x03,
    DVD_Struct_PartOfTitle  = 0x04,
    DVD_Struct_Cell         = 0x05,
    DVD_Stream_Audio        = 0x10,
    DVD_Stream_Subpicture   = 0x11,
    DVD_Stream_Angle        = 0x12,
    DVD_Channel_Audio       = 0x20,
    DVD_General_Name        = 0x30,
    DVD_General_Comments    = 0x31,
    DVD_Title_Series        = 0x38,
    DVD_Title_Movie         = 0x39,
    DVD_Title_Video         = 0x3A,
    DVD_Title_Album         = 0x3B,
    DVD_Title_Song          = 0x3C,
    DVD_Title_Other         = 0x3F,
    DVD_Title_Sub_Series    = 0x40,
    DVD_Title_Sub_Movie     = 0x41,
    DVD_Title_Sub_Video     = 0x42,
    DVD_Title_Sub_Album     = 0x43,
    DVD_Title_Sub_Song      = 0x44,
    DVD_Title_Sub_Other     = 0x47,
    DVD_Title_Orig_Series   = 0x48,
    DVD_Title_Orig_Movie    = 0x49,
    DVD_Title_Orig_Video    = 0x4A,
    DVD_Title_Orig_Album    = 0x4B,
    DVD_Title_Orig_Song     = 0x4C,
    DVD_Title_Orig_Other    = 0x4F,
    DVD_Other_Scene         = 0x50,
    DVD_Other_Cut           = 0x51,
    DVD_Other_Take          = 0x52
};

/* DVD text character sets */
enum DVD_TextCharSet {
    DVD_CharSet_Unicode                         = 0,
    DVD_CharSet_ISO646                          = 1,
    DVD_CharSet_JIS_Roman_Kanji                 = 2,
    DVD_CharSet_ISO8859_1                       = 3,
    DVD_CharSet_ShiftJIS_Kanji_Roman_Katakana   = 4
};

/* DVD decoder capabilities */
typedef struct tagDVD_DECODER_CAPS {
    DWORD   dwSize;
    DWORD   dwAudioCaps;
    double  dFwdMaxRateVideo;
    double  dFwdMaxRateAudio;
    double  dFwdMaxRateSP;
    double  dBwdMaxRateVideo;
    double  dBwdMaxRateAudio;
    double  dBwdMaxRateSP;
    DWORD   dwRes1;
    DWORD   dwRes2;
    DWORD   dwRes3;
    DWORD   dwRes4;
} DVD_DECODER_CAPS;

/* ActiveMovie DVD graph flags */
typedef enum _AM_DVD_GRAPH_FLAGS {
    AM_DVD_HWDEC_PREFER = 0x00000001,
    AM_DVD_HWDEC_ONLY   = 0x00000002,
    AM_DVD_SWDEC_PREFER = 0x00000004,
    AM_DVD_SWDEC_ONLY   = 0x00000008,
    AM_DVD_NOVPE        = 0x00000100,
    AM_DVD_DO_NOT_CLEAR = 0x00000200,
    AM_DVD_VMR9_ONLY    = 0x00000800,
    AM_DVD_EVR_ONLY     = 0x00001000,
    AM_DVD_EVR_QOS      = 0x00002000,
    AM_DVD_ADAPT_GRAPH  = 0x00004000,
    AM_DVD_MASK         = 0x0000FFFF
} AM_DVD_GRAPH_FLAGS;

/* ActiveMovie DVD stream flags */
typedef enum _AM_DVD_STREAM_FLAGS {
    AM_DVD_STREAM_VIDEO     = 0x00000001,
    AM_DVD_STREAM_AUDIO     = 0x00000002,
    AM_DVD_STREAM_SUBPIC    = 0x00000004
} AM_DVD_STREAM_FLAGS;

/* ActiveMovie DVD render status */
typedef struct {
    HRESULT hrVPEStatus;
    BOOL    bDvdVolInvalid;
    BOOL    bDvdVolUnknown;
    BOOL    bNoLine21In;
    BOOL    bNoLine21Out;
    int     iNumStreams;
    int     iNumStreamsFailed;
    DWORD   dwFailedStreamsFlag;
} AM_DVD_RENDERSTATUS;

/* ActiveMovie overlay notification flags */
enum _AM_OVERLAY_NOTIFY_FLAGS {
    AM_OVERLAY_NOTIFY_VISIBLE_CHANGE    = 0x00000001,
    AM_OVERLAY_NOTIFY_SOURCE_CHANGE     = 0x00000002,
    AM_OVERLAY_NOTIFY_DEST_CHANGE       = 0x00000004
};

/* IPinFlowControl::Block() flags */
enum _AM_PIN_FLOW_CONTROL_BLOCK_FLAGS {
    AM_PIN_FLOW_CONTROL_BLOCK   = 0x00000001
};

/* ActiveMovie graph configuration reconnect flags */
typedef enum _AM_GRAPH_CONFIG_RECONNECT_FLAGS {
    AM_GRAPH_CONFIG_RECONNECT_DIRECTCONNECT             = 0x00000001,
    AM_GRAPH_CONFIG_RECONNECT_CACHE_REMOVED_FILTERS     = 0x00000002,
    AM_GRAPH_CONFIG_RECONNECT_USE_ONLY_CACHED_FILTERS   = 0x00000004
} AM_GRAPH_CONFIG_RECONNECT_FLAGS;

/* Remove filter flags */
enum _REM_FILTER_FLAGS {
    REMFILTERF_LEAVECONNECTED   = 0x00000001
};

/* ActiveMovie filter flags */
typedef enum _AM_FILTER_FLAGS {
    AM_FILTER_FLAGS_REMOVABLE   = 0x00000001
} AM_FILTER_FLAGS;

/* VMR presentation flags */
typedef enum VMRPresentationFlags {
    VMRSample_SyncPoint         = 0x00000001,
    VMRSample_Preroll           = 0x00000002,
    VMRSample_Discontinuity     = 0x00000004,
    VMRSample_TimeValid         = 0x00000008,
    VMRSample_SrcDstRectsValid  = 0x00000010
} VMRPresentationFlags;

/* VMR presentation information */
typedef struct tagVMRPRESENTATIONINFO {
    DWORD                   dwFlags;
    LPDIRECTDRAWSURFACE7    lpSurf;
    REFERENCE_TIME          rtStart;
    REFERENCE_TIME          rtEnd;
    SIZE                    szAspectRatio;
    RECT                    rcSrc;
    RECT                    rcDst;
    DWORD                   dwTypeSpecificFlags;
    DWORD                   dwInterlaceFlags;
} VMRPRESENTATIONINFO;

/* VMR surface allocation flags */
typedef enum VMRSurfaceAllocationFlags {
    AMAP_PIXELFORMAT_VALID  = 0x00000001,
    AMAP_3D_TARGET          = 0x00000002,
    AMAP_ALLOW_SYSMEM       = 0x00000004,
    AMAP_FORCE_SYSMEM       = 0x00000008,
    AMAP_DIRECTED_FLIP      = 0x00000010,
    AMAP_DXVA_TARGET        = 0x00000020
} VMRSurfaceAllocationFlags;

/* VMR allocation information */
typedef struct tagVMRALLOCATIONINFO {
    DWORD               dwFlags;
    LPBITMAPINFOHEADER  lpHdr;
    LPDDPIXELFORMAT     lpPixFmt;
    SIZE                szAspectRatio;
    DWORD               dwMinBuffers;
    DWORD               dwMaxBuffers;
    DWORD               dwInterlaceFlags;
    SIZE                szNativeSize;
} VMRALLOCATIONINFO;

/* VMR aspect ratio modes */
typedef enum VMR_ASPECT_RATIO_MODE {
    VMR_ARMODE_NONE         = 0,
    VMR_ARMODE_LETTERBOX    = 1
} VMR_ASPECT_RATIO_MODE;

/* VMR mixer preferences */
typedef enum VMRMixerPrefs {
    MixerPref_NoDecimation          = 0x00000001,
    MixerPref_DecimateOutput        = 0x00000002,
    MixerPref_ARAdjustXorY          = 0x00000004,
    MixerPref_DecimateMask          = 0x0000000F,
    MixerPref_BiLinearFiltering     = 0x00000010,
    MixerPref_PointFiltering        = 0x00000020,
    MixerPref_FilteringMask         = 0x000000F0,
    MixerPref_RenderTargetRGB       = 0x00000100,
    MixerPref_RenderTargetYUV       = 0x00001000,
    MixerPref_RenderTargetYUV420    = 0x00000200,
    MixerPref_RenderTargetYUV422    = 0x00000400,
    MixerPref_RenderTargetYUV444    = 0x00000800,
    MixerPref_RenderTargetMask      = 0x0000FF00,
    MixerPref_DynamicSwitchToBOB    = 0x00010000,
    MixerPref_DynamicDecimateBy2    = 0x00020000,
    MixerPref_DynamicMask           = 0x000F0000
} VMRMixerPrefs;

/* Normalized rectangle */
typedef struct _NORMALIZEDRECT {
    float   left;
    float   top;
    float   right;
    float   bottom;
} NORMALIZEDRECT;
typedef NORMALIZEDRECT  *PNORMALIZEDRECT;

/* VMR GUID */
typedef struct tagVMRGUID {
    GUID    *pGUID;
    GUID    GUID;
} VMRGUID;

/* VMR monitor information */
typedef struct tagVMRMONITORINFO {
    VMRGUID         guid;
    RECT            rcMonitor;
    HMONITOR        hMon;
    DWORD           dwFlags;
    wchar_t         szDevice[VMRDEVICENAMELEN];
    wchar_t         szDescription[VMRDEVICEDESCRIPTIONLEN];
    LARGE_INTEGER   liDriverVersion;
    DWORD           dwVendorId;
    DWORD           dwDeviceId;
    DWORD           dwSubSysId;
    DWORD           dwRevision;
} VMRMONITORINFO;

/* VMR render preferences */
typedef enum VMRRenderPrefs {
    RenderPrefs_RestrictToInitialMonitor        = 0x00000000,
    RenderPrefs_ForceOffScreen                  = 0x00000001,
    RenderPrefs_ForceOverlays                   = 0x00000002,
    RenderPrefs_AllowOverlays                   = 0x00000000,
    RenderPrefs_AllowOffscreen                  = 0x00000000,
    RenderPrefs_DoNotRenderColorKeyAndBorder    = 0x00000008,
    RenderPrefs_PreferAGPMemWhenMixing          = 0x00000020,
    RenderPrefs_Mask                            = 0x0000003F
} VMRRenderPrefs;

/* VMR modes */
typedef enum VMRMode {
    VMRMode_Windowed    = 0x00000001,
    VMRMode_Windowless  = 0x00000002,
    VMRMode_Renderless  = 0x00000004,
    VMRMode_Mask        = 0x00000007
} VMRMode;

/* Maximum number of streams */
enum {
    MAX_NUMBER_OF_STREAMS   = 16
};

/* VMR deinterlace preferences */
typedef enum VMRDeinterlacePrefs {
    DeinterlacePref_NextBest    = 0x00000001,
    DeinterlacePref_BOB         = 0x00000002,
    DeinterlacePref_Weave       = 0x00000004,
    DeinterlacePref_Mask        = 0x00000007
} VMRDeinterlacePrefs;

/* VMR deinterlace technologies */
typedef enum VMRDeinterlaceTech {
    DeinterlaceTech_Unknown             = 0x00000000,
    DeinterlaceTech_BOBLineReplicate    = 0x00000001,
    DeinterlaceTech_BOBVerticalStretch  = 0x00000002,
    DeinterlaceTech_MedianFiltering     = 0x00000004,
    DeinterlaceTech_EdgeFiltering       = 0x00000010,
    DeinterlaceTech_FieldAdaptive       = 0x00000020,
    DeinterlaceTech_PixelAdaptive       = 0x00000040,
    DeinterlaceTech_MotionVectorSteered = 0x00000080
} VMRDeinterlaceTech;

/* VMR frequency */
typedef struct _VMRFrequency {
    DWORD   dwNumerator;
    DWORD   dwDenominator;
} VMRFrequency;

/* VMR video description */
typedef struct _VMRVideoDesc {
    DWORD           dwSize;
    DWORD           dwSampleWidth;
    DWORD           dwSampleHeight;
    BOOL            SingleFieldPerSample;
    DWORD           dwFourCC;
    VMRFrequency    InputSampleFreq;
    VMRFrequency    OutputFrameFreq;
} VMRVideoDesc;

/* VMR deinterlace capabilities */
typedef struct _VMRDeinterlaceCaps {
    DWORD               dwSize;
    DWORD               dwNumPreviousOutputFrames;
    DWORD               dwNumForwardRefSamples;
    DWORD               dwNumBackwardRefSamples;
    VMRDeinterlaceTech  DeinterlaceTechnology;
} VMRDeinterlaceCaps;

/* VMR alpha bitmap */
typedef struct _VMRALPHABITMAP {
    DWORD                   dwFlags;
    HDC                     hdc;
    LPDIRECTDRAWSURFACE7    pDDS;
    RECT                    rSrc;
    NORMALIZEDRECT          rDest;
    FLOAT                   fAlpha;
    COLORREF                clrSrcKey;
} VMRALPHABITMAP;
typedef VMRALPHABITMAP  *PVMRALPHABITMAP;

/* VMR video stream information */
typedef struct _VMRVIDEOSTREAMINFO {
    LPDIRECTDRAWSURFACE7    pddsVideoSurface;
    DWORD                   dwWidth;
    DWORD                   dwHeight;
    DWORD                   dwStrmID;
    FLOAT                   fAlpha;
    DDCOLORKEY              ddClrKey;
    NORMALIZEDRECT          rNormal;
} VMRVIDEOSTREAMINFO;

/* ICreateDevEnum interface */
#undef INTERFACE
#define INTERFACE   ICreateDevEnum
DECLARE_INTERFACE_( ICreateDevEnum, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICreateDevEnum methods */
    STDMETHOD( CreateClassEnumerator )( THIS_ REFCLSID, IEnumMoniker **, DWORD ) PURE;
};

/* IPin interface */
#undef INTERFACE
#define INTERFACE   IPin
DECLARE_INTERFACE_( IPin, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPin methods */
    STDMETHOD( Connect )( THIS_ IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( ReceiveConnection )( THIS_ IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( Disconnect )( THIS ) PURE;
    STDMETHOD( ConnectedTo )( THIS_ IPin ** ) PURE;
    STDMETHOD( ConnectionMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( QueryPinInfo )( THIS_ PIN_INFO * ) PURE;
    STDMETHOD( QueryDirection )( THIS_ PIN_DIRECTION * ) PURE;
    STDMETHOD( QueryId )( THIS_ LPWSTR * ) PURE;
    STDMETHOD( QueryAccept )( THIS_ const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( EnumMediaTypes )( THIS_ IEnumMediaTypes ** ) PURE;
    STDMETHOD( QueryInternalConnections )( THIS_ IPin **, ULONG * ) PURE;
    STDMETHOD( EndOfStream )( THIS ) PURE;
    STDMETHOD( BeginFlush )( THIS ) PURE;
    STDMETHOD( EndFlush )( THIS ) PURE;
    STDMETHOD( NewSegment )( THIS_ REFERENCE_TIME, REFERENCE_TIME, double ) PURE;
};
typedef IPin    *PPIN;

/* IEnumPins interface */
#undef INTERFACE
#define INTERFACE   IEnumPins
DECLARE_INTERFACE_( IEnumPins, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumPins methods */
    STDMETHOD( Next )( THIS_ ULONG, IPin **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumPins ** ) PURE;
};
typedef IEnumPins   *PENUMPINS;

/* IEnumMediaTypes interface */
#undef INTERFACE
#define INTERFACE   IEnumMediaTypes
DECLARE_INTERFACE_( IEnumMediaTypes, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumMediaTypes methods */
    STDMETHOD( Next )( THIS_ ULONG, AM_MEDIA_TYPE **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumMediaTypes ** ) PURE;
};
typedef IEnumMediaTypes *PENUMMEDIATYPES;

/* IFilterGraph interface */
#undef INTERFACE
#define INTERFACE   IFilterGraph
DECLARE_INTERFACE_( IFilterGraph, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterGraph methods */
    STDMETHOD( AddFilter )( THIS_ IBaseFilter *, LPCWSTR ) PURE;
    STDMETHOD( RemoveFilter )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( EnumFilters )( THIS_ IEnumFilters ** ) PURE;
    STDMETHOD( FindFilterByName )( THIS_ LPCWSTR, IBaseFilter ** v) PURE;
    STDMETHOD( ConnectDirect )( THIS_ IPin *, IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( Reconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( Disconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( SetDefaultSyncSource )( THIS ) PURE;
};
typedef IFilterGraph    *PFILTERGRAPH;

/* IEnumFilters interface */
#undef INTERFACE
#define INTERFACE   IEnumFilters
DECLARE_INTERFACE_( IEnumFilters, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumFilters methods */
    STDMETHOD( Next )( THIS_ ULONG, IBaseFilter **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS_ ULONG ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumFilters ** ) PURE;
};
typedef IEnumFilters    *PENUMFILTERS;

/* IMediaFilter interface */
#undef INTERFACE
#define INTERFACE   IMediaFilter
DECLARE_INTERFACE_( IMediaFilter, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IMediaFilter methods */
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Run )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( GetState )( THIS_ DWORD, FILTER_STATE * ) PURE;
    STDMETHOD( SetSyncSource )( THIS_ IReferenceClock * ) PURE;
    STDMETHOD( GetSyncSource )( THIS_ IReferenceClock ** ) PURE;
};
typedef IMediaFilter    *PMEDIAFILTER;

/* IBaseFilter interface */
#undef INTERFACE
#define INTERFACE   IBaseFilter
DECLARE_INTERFACE_( IBaseFilter, IMediaFilter ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IMediaFilter methods */
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Run )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( GetState )( THIS_ DWORD, FILTER_STATE * ) PURE;
    STDMETHOD( SetSyncSource )( THIS_ IReferenceClock * ) PURE;
    STDMETHOD( GetSyncSource )( THIS_ IReferenceClock ** ) PURE;

    /* IBaseFilter methods */
    STDMETHOD( EnumPins )( THIS_ IEnumPins ** ) PURE;
    STDMETHOD( FindPin )( THIS_ LPCWSTR, IPin ** ) PURE;
    STDMETHOD( QueryFilterInfo )( THIS_ FILTER_INFO * ) PURE;
    STDMETHOD( JoinFilterGraph )( THIS_ IFilterGraph *, LPCWSTR ) PURE;
    STDMETHOD( QueryVendorInfo )( THIS_ LPWSTR * ) PURE;
};
typedef IBaseFilter *PFILTER;

/* IReferenceClock interface */
#undef INTERFACE
#define INTERFACE   IReferenceClock
DECLARE_INTERFACE_( IReferenceClock, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IReferenceClock methods */
    STDMETHOD( GetTime )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( AdviseTime )( THIS_ REFERENCE_TIME, REFERENCE_TIME, HEVENT, DWORD_PTR * ) PURE;
    STDMETHOD( AdvisePeriodic )( THIS_ REFERENCE_TIME, REFERENCE_TIME, HSEMAPHORE, DWORD_PTR * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD_PTR ) PURE;
};
typedef IReferenceClock *PREFERENCECLOCK;

/* IReferenceClockTimerControl interface */
#undef INTERFACE
#define INTERFACE   IReferenceClockTimerControl
DECLARE_INTERFACE_( IReferenceClockTimerControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IReferenceClockTimerControl methods */
    STDMETHOD( SetDefaultTimerResolution )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( GetDefaultTimerResolution )( THIS_ REFERENCE_TIME * ) PURE;
};

/* IReferenceClock2 interface */
#undef INTERFACE
#define INTERFACE   IReferenceClock2
DECLARE_INTERFACE_( IReferenceClock2, IReferenceClock ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IReferenceClock methods */
    STDMETHOD( GetTime )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( AdviseTime )( THIS_ REFERENCE_TIME, REFERENCE_TIME, HEVENT, DWORD_PTR * ) PURE;
    STDMETHOD( AdvisePeriodic )( THIS_ REFERENCE_TIME, REFERENCE_TIME, HSEMAPHORE, DWORD_PTR * ) PURE;
    STDMETHOD( Unadvise )( THIS_ DWORD_PTR ) PURE;
};
typedef IReferenceClock2    *PREFERENCECLOCK2;

/* IMediaSample interface */
#undef INTERFACE
#define INTERFACE   IMediaSample
DECLARE_INTERFACE_( IMediaSample, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaSample methods */
    STDMETHOD( GetPointer )( THIS_ BYTE ** ) PURE;
    STDMETHOD_( long, GetSize )( THIS ) PURE;
    STDMETHOD( GetTime )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( SetTime )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( IsSyncPoint )( THIS ) PURE;
    STDMETHOD( SetSyncPoint )( THIS_ BOOL ) PURE;
    STDMETHOD( IsPreroll )( THIS ) PURE;
    STDMETHOD( SetPreroll )( THIS_ BOOL ) PURE;
    STDMETHOD_( long, GetActualDataLength )( THIS ) PURE;
    STDMETHOD( SetActualDataLength )( THIS_ long ) PURE;
    STDMETHOD( GetMediaType )( THIS_ AM_MEDIA_TYPE ** ) PURE;
    STDMETHOD( SetMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( IsDiscontinuity )( THIS ) PURE;
    STDMETHOD( SetDiscontinuity )( THIS_ BOOL ) PURE;
    STDMETHOD( GetMediaTime )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( SetMediaTime )( THIS_ LONGLONG *, LONGLONG * ) PURE;
};
typedef IMediaSample    *PMEDIASAMPLE;

/* IMediaSample2 interface */
#undef INTERFACE
#define INTERFACE   IMediaSample2
DECLARE_INTERFACE_( IMediaSample2, IMediaSample ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaSample methods */
    STDMETHOD( GetPointer )( THIS_ BYTE ** ) PURE;
    STDMETHOD_( long, GetSize )( THIS ) PURE;
    STDMETHOD( GetTime )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( SetTime )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
    STDMETHOD( IsSyncPoint )( THIS ) PURE;
    STDMETHOD( SetSyncPoint )( THIS_ BOOL ) PURE;
    STDMETHOD( IsPreroll )( THIS ) PURE;
    STDMETHOD( SetPreroll )( THIS_ BOOL ) PURE;
    STDMETHOD_( long, GetActualDataLength )( THIS ) PURE;
    STDMETHOD( SetActualDataLength )( THIS_ long ) PURE;
    STDMETHOD( GetMediaType )( THIS_ AM_MEDIA_TYPE ** ) PURE;
    STDMETHOD( SetMediaType )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( IsDiscontinuity )( THIS ) PURE;
    STDMETHOD( SetDiscontinuity )( THIS_ BOOL ) PURE;
    STDMETHOD( GetMediaTime )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( SetMediaTime )( THIS_ LONGLONG *, LONGLONG * ) PURE;

    /* IMediaSample2 methods */
    STDMETHOD( GetProperties )( THIS_ DWORD, BYTE * ) PURE;
    STDMETHOD( SetProperties )( THIS_ DWORD, const BYTE * ) PURE;
};
typedef IMediaSample2   *PMEDIASAMPLE2;

/* IMediaSample2Config interface */
#undef INTERFACE
#define INTERFACE   IMediaSample2Config
DECLARE_INTERFACE_( IMediaSample2Config, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaSample2Config methods */
    STDMETHOD( GetSurface )( THIS_ IUnknown ** ) PURE;
};

/* IMemAllocator interface */
#undef INTERFACE
#define INTERFACE   IMemAllocator
DECLARE_INTERFACE_( IMemAllocator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMemAllocator methods */
    STDMETHOD( SetProperties )( THIS_ ALLOCATOR_PROPERTIES *, ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( GetProperties )( THIS_ ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( Commit )( THIS ) PURE;
    STDMETHOD( Decommit )( THIS ) PURE;
    STDMETHOD( GetBuffer )( THIS_ IMediaSample **, REFERENCE_TIME *, REFERENCE_TIME *, DWORD ) PURE;
    STDMETHOD( ReleaseBuffer )( THIS_ IMediaSample * ) PURE;
};
typedef IMemAllocator   *PMEMALLOCATOR;

/* IMemAllocatorCallbackTemp interface */
#undef INTERFACE
#define INTERFACE   IMemAllocatorCallbackTemp
DECLARE_INTERFACE_( IMemAllocatorCallbackTemp, IMemAllocator ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMemAllocator methods */
    STDMETHOD( SetProperties )( THIS_ ALLOCATOR_PROPERTIES *, ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( GetProperties )( THIS_ ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( Commit )( THIS ) PURE;
    STDMETHOD( Decommit )( THIS ) PURE;
    STDMETHOD( GetBuffer )( THIS_ IMediaSample **, REFERENCE_TIME *, REFERENCE_TIME *, DWORD ) PURE;
    STDMETHOD( ReleaseBuffer )( THIS_ IMediaSample * ) PURE;

    /* IMemAllocatorCallbackTemp methods */
    STDMETHOD( SetNotify )( THIS_ IMemAllocatorNotifyCallbackTemp * ) PURE;
    STDMETHOD( GetFreeCount )( THIS_ LONG * ) PURE;
};

/* IMemAllocatorNotifyCallbackTemp interface */
#undef INTERFACE
#define INTERFACE   IMemAllocatorNotifyCallbackTemp
DECLARE_INTERFACE_( IMemAllocatorNotifyCallbackTemp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMemAllocatorNotifyCallbackTemp methods */
    STDMETHOD( NotifyRelease )( THIS ) PURE;
};

/* IMemInputPin interface */
#undef INTERFACE
#define INTERFACE   IMemInputPin
DECLARE_INTERFACE_( IMemInputPin, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMemInputPin methods */
    STDMETHOD( GetAllocator )( THIS_ IMemAllocator ** ) PURE;
    STDMETHOD( NotifyAllocator )( THIS_ IMemAllocator *, BOOL ) PURE;
    STDMETHOD( GetAllocatorRequirements )( THIS_ ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( Receive )( THIS_ IMediaSample * ) PURE;
    STDMETHOD( ReceiveMultiple )( THIS_ IMediaSample **, long, long * ) PURE;
    STDMETHOD( ReceiveCanBlock )( THIS ) PURE;
};
typedef IMemInputPin    *PMEMINPUTPIN;

/* IAMovieSetup interface */
#undef INTERFACE
#define INTERFACE   IAMovieSetup
DECLARE_INTERFACE_( IAMovieSetup, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMovieSetup methods */
    STDMETHOD( Register )( THIS ) PURE;
    STDMETHOD( Unregister )( THIS ) PURE;
};
typedef IAMovieSetup    *PAMOVIESETUP;

/* IMediaSeeking interface */
#undef INTERFACE
#define INTERFACE   IMediaSeeking
DECLARE_INTERFACE_( IMediaSeeking, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaSeeking methods */
    STDMETHOD( GetCapabilities )( THIS_ DWORD * ) PURE;
    STDMETHOD( CheckCapabilities )( THIS_ DWORD * ) PURE;
    STDMETHOD( IsFormatSupported )( THIS_ const GUID * ) PURE;
    STDMETHOD( QueryPreferredFormat )( THIS_ GUID * ) PURE;
    STDMETHOD( GetTimeFormat )( THIS_ GUID * ) PURE;
    STDMETHOD( IsUsingTimeFormat )( THIS_ const GUID * ) PURE;
    STDMETHOD( SetTimeFormat )( THIS_ const GUID * ) PURE;
    STDMETHOD( GetDuration )( THIS_ LONGLONG * ) PURE;
    STDMETHOD( GetStopPosition )( THIS_ LONGLONG * ) PURE;
    STDMETHOD( GetCurrentPosition )( THIS_ LONGLONG * ) PURE;
    STDMETHOD( ConvertTimeFormat )( THIS_ LONGLONG *, const GUID *, LONGLONG, const GUID * ) PURE;
    STDMETHOD( SetPositions )( THIS_ LONGLONG *, DWORD, LONGLONG *, DWORD ) PURE;
    STDMETHOD( GetPositions )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( GetAvailable )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( SetRate )( THIS_ double ) PURE;
    STDMETHOD( GetRate )( THIS_ double * ) PURE;
    STDMETHOD( GetPreroll )( THIS_ LONGLONG * ) PURE;
};
typedef IMediaSeeking   *PMEDIASEEKING;

/* IEnumRegFilters interface */
#undef INTERFACE
#define INTERFACE   IEnumRegFilters
DECLARE_INTERFACE_( IEnumRegFilters, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumRegFilters methods */
    STDMETHOD( Next )( THIS_ ULONG, REGFILTER **, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumRegFilters ** ) PURE;
};
typedef IEnumRegFilters *PENUMREGFILTERS;

/* IFilterMapper interface */
#undef INTERFACE
#define INTERFACE   IFilterMapper
DECLARE_INTERFACE_( IFilterMapper, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterMapper methods */
    STDMETHOD( RegisterFilter )( THIS_ CLSID, LPCWSTR, DWORD ) PURE;
    STDMETHOD( RegisterFilterInstance )( THIS_ CLSID, LPCWSTR, CLSID * ) PURE;
    STDMETHOD( RegisterPin )( THIS_ CLSID, LPCWSTR, BOOL, BOOL, BOOL, BOOL, CLSID, LPCWSTR ) PURE;
    STDMETHOD( RegisterPinType )( THIS_ CLSID, LPCWSTR, CLSID, CLSID ) PURE;
    STDMETHOD( UnregisterFilter )( THIS_ CLSID ) PURE;
    STDMETHOD( UnregisterFilterInstance )( THIS_ CLSID ) PURE;
    STDMETHOD( UnregisterPin )( THIS_ CLSID, LPCWSTR ) PURE;
    STDMETHOD( EnumMatchingFilters )( THIS_ IEnumRegFilters **, DWORD, BOOL, CLSID, CLSID, BOOL, BOOL, CLSID, CLSID ) PURE;
};

/* IFilterMapper2 interface */
#undef INTERFACE
#define INTERFACE   IFilterMapper2
DECLARE_INTERFACE_( IFilterMapper2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterMapper2 methods */
    STDMETHOD( CreateCategory )( THIS_ REFCLSID, DWORD, LPCWSTR ) PURE;
    STDMETHOD( UnregisterFilter )( THIS_ const CLSID *, LPCOLESTR, REFCLSID ) PURE;
    STDMETHOD( RegisterFilter )( THIS_ REFCLSID, LPCWSTR, IMoniker **, const CLSID *, LPCOLESTR, const REGFILTER2 * ) PURE;
    STDMETHOD( EnumMatchingFilters )( THIS_ IEnumMoniker **, DWORD, BOOL, DWORD, BOOL, DWORD, const GUID *, const REGPINMEDIUM *, const CLSID *, BOOL, BOOL, DWORD, const GUID *, const REGPINMEDIUM *, const CLSID * ) PURE;
};

/* IFilterMapper3 interface */
#undef INTERFACE
#define INTERFACE   IFilterMapper3
DECLARE_INTERFACE_( IFilterMapper3, IFilterMapper2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterMapper2 methods */
    STDMETHOD( CreateCategory )( THIS_ REFCLSID, DWORD, LPCWSTR ) PURE;
    STDMETHOD( UnregisterFilter )( THIS_ const CLSID *, LPCOLESTR, REFCLSID ) PURE;
    STDMETHOD( RegisterFilter )( THIS_ REFCLSID, LPCWSTR, IMoniker **, const CLSID *, LPCOLESTR, const REGFILTER2 * ) PURE;
    STDMETHOD( EnumMatchingFilters )( THIS_ IEnumMoniker **, DWORD, BOOL, DWORD, BOOL, DWORD, const GUID *, const REGPINMEDIUM *, const CLSID *, BOOL, BOOL, DWORD, const GUID *, const REGPINMEDIUM *, const CLSID * ) PURE;

    /* IFilterMapper3 methods */
    STDMETHOD( GetICreateDevEnum )( THIS_ ICreateDevEnum ** ) PURE;
};

/* IQualityControl interface */
#undef INTERFACE
#define INTERFACE   IQualityControl
DECLARE_INTERFACE_( IQualityControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IQualityControl methods */
    STDMETHOD( Notify )( THIS_ IBaseFilter *, Quality ) PURE;
    STDMETHOD( SetSink )( THIS_ IQualityControl * ) PURE;
};

/* IOverlayNotify interface */
#undef INTERFACE
#define INTERFACE   IOverlayNotify
DECLARE_INTERFACE_( IOverlayNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOverlayNotify methods */
    STDMETHOD( OnPaletteChange )( THIS_ DWORD, const PALETTEENTRY * ) PURE;
    STDMETHOD( OnClipChange )( THIS_ const RECT *, const RECT *, const RGNDATA * ) PURE;
    STDMETHOD( OnColorKeyChange )( THIS_ const COLORKEY * ) PURE;
    STDMETHOD( OnPositionChange )( THIS_ const RECT *, const RECT * ) PURE;
};
typedef IOverlayNotify  *LPOVERLAYNOTIFY;

/* IOverlayNotify2 interface */
#undef INTERFACE
#define INTERFACE   IOverlayNotify2
DECLARE_INTERFACE_( IOverlayNotify2, IOverlayNotify ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOverlayNotify methods */
    STDMETHOD( OnPaletteChange )( THIS_ DWORD, const PALETTEENTRY * ) PURE;
    STDMETHOD( OnClipChange )( THIS_ const RECT *, const RECT *, const RGNDATA * ) PURE;
    STDMETHOD( OnColorKeyChange )( THIS_ const COLORKEY * ) PURE;
    STDMETHOD( OnPositionChange )( THIS_ const RECT *, const RECT * ) PURE;

    /* IOverlayNotify2 methods */
    STDMETHOD( OnDisplayChange )( THIS_ HMONITOR ) PURE;
};
typedef IOverlayNotify2 *POVERLAYNOTIFY2;

/* IOverlay interface */
#undef INTERFACE
#define INTERFACE   IOverlay
DECLARE_INTERFACE_( IOverlay, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IOverlay methods */
    STDMETHOD( GetPalette )( THIS_ DWORD *, PALETTEENTRY ** ) PURE;
    STDMETHOD( SetPalette )( THIS_ DWORD, PALETTEENTRY * ) PURE;
    STDMETHOD( GetDefaultColorKey )( THIS_ COLORREF * ) PURE;
    STDMETHOD( GetColorKey )( THIS_ COLORREF * ) PURE;
    STDMETHOD( SetColorKey )( THIS_ COLORREF * ) PURE;
    STDMETHOD( GetWindowHandle )( THIS_ HWND * ) PURE;
    STDMETHOD( GetClipList )( THIS_ RECT *, RECT *, RGNDATA ** ) PURE;
    STDMETHOD( GetVideoPosition )( THIS_ RECT *, RECT * ) PURE;
    STDMETHOD( Advise )( THIS_ IOverlayNotify *, DWORD ) PURE;
    STDMETHOD( Unadvise )( THIS ) PURE;
};
typedef IOverlay    *POVERLAY;

/* IMediaEventSink interface */
#undef INTERFACE
#define INTERFACE   IMediaEventSink
DECLARE_INTERFACE_( IMediaEventSink, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMediaEventSink methods */
    STDMETHOD( Notify )( THIS_ long, LONG_PTR, LONG_PTR ) PURE;
};
typedef IMediaEventSink *PMEDIAEVENTSINK;

/* IFileSourceFilter interface */
#undef INTERFACE
#define INTERFACE   IFileSourceFilter
DECLARE_INTERFACE_( IFileSourceFilter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFileSourceFilter methods */
    STDMETHOD( Load )( THIS_ LPCOLESTR, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetCurFile )( THIS_ LPOLESTR *, AM_MEDIA_TYPE * ) PURE;
};
typedef IFileSourceFilter   *PFILESOURCEFILTER;

/* IFileSinkFilter interface */
#undef INTERFACE
#define INTERFACE   IFileSinkFilter
DECLARE_INTERFACE_( IFileSinkFilter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFileSinkFilter methods */
    STDMETHOD( SetFileName )( THIS_ LPCOLESTR, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetCurFile )( THIS_ LPOLESTR *, AM_MEDIA_TYPE * ) PURE;
};
typedef IFileSinkFilter *PFILESINKFILTER;

/* IFileSinkFilter2 interface */
#undef INTERFACE
#define INTERFACE   IFileSinkFilter2
DECLARE_INTERFACE_( IFileSinkFilter2, IFileSinkFilter ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFileSinkFilter methods */
    STDMETHOD( SetFileName )( THIS_ LPCOLESTR, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetCurFile )( THIS_ LPOLESTR *, AM_MEDIA_TYPE * ) PURE;

    /* IFileSinkFilter2 methods */
    STDMETHOD( SetMode )( THIS_ DWORD ) PURE;
    STDMETHOD( GetMode )( THIS_ DWORD * ) PURE;
};
typedef IFileSinkFilter2    *PFILESINKFILTER2;

/* IGraphBuilder interface */
#undef INTERFACE
#define INTERFACE   IGraphBuilder
DECLARE_INTERFACE_( IGraphBuilder, IFilterGraph ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterGraph methods */
    STDMETHOD( AddFilter )( THIS_ IBaseFilter *, LPCWSTR ) PURE;
    STDMETHOD( RemoveFilter )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( EnumFilters )( THIS_ IEnumFilters ** ) PURE;
    STDMETHOD( FindFilterByName )( THIS_ LPCWSTR, IBaseFilter ** v) PURE;
    STDMETHOD( ConnectDirect )( THIS_ IPin *, IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( Reconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( Disconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( SetDefaultSyncSource )( THIS ) PURE;

    /* IGraphBuilder methods */
    STDMETHOD( Connect )( THIS_ IPin *, IPin * ) PURE;
    STDMETHOD( Render )( THIS_ IPin * ) PURE;
    STDMETHOD( RenderFile )( THIS_ LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( AddSourceFilter )( THIS_ LPCWSTR, LPCWSTR, IBaseFilter ** ) PURE;
    STDMETHOD( SetLogFile )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( Abort )( THIS ) PURE;
    STDMETHOD( ShouldOperationContinue )( THIS ) PURE;
};

/* ICaptureGraphBuilder interface */
#undef INTERFACE
#define INTERFACE   ICaptureGraphBuilder
DECLARE_INTERFACE_( ICaptureGraphBuilder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICaptureGraphBuilder methods */
    STDMETHOD( SetFitlergraph )( THIS_ IGraphBuilder * ) PURE;
    STDMETHOD( GetFiltergraph )( THIS_ IGraphBuilder ** ) PURE;
    STDMETHOD( SetOutputFileName )( THIS_ const GUID *, LPCOLESTR, IBaseFilter **, IFileSinkFilter ** ) PURE;
    STDMETHOD( FindInterface )( THIS_ const GUID *, IBaseFilter *, REFIID, void ** ) PURE;
    STDMETHOD( RenderStream )( THIS_ const GUID *, IUnknown *, IBaseFilter *, IBaseFilter * ) PURE;
    STDMETHOD( ControlStream )( THIS_ const GUID *, IBaseFilter *, REFERENCE_TIME *, REFERENCE_TIME *, WORD, WORD ) PURE;
    STDMETHOD( AllocCapFile )( THIS_ LPCOLESTR, DWORDLONG ) PURE;
    STDMETHOD( CopyCaptureFile )( THIS_ LPOLESTR, LPOLESTR, int, IAMCopyCaptureFileProgress * ) PURE;
};

/* IAMCopyCaptureFileProgress interface */
#undef INTERFACE
#define INTERFACE   IAMCopyCaptureFileProgress
DECLARE_INTERFACE_( IAMCopyCaptureFileProgress, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMCopyCaptureFileProgress methods */
    STDMETHOD( Progress )( THIS_ int ) PURE;
};

/* ICaptureGraphBuilder2 interface */
#undef INTERFACE
#define INTERFACE   ICaptureGraphBuilder2
DECLARE_INTERFACE_( ICaptureGraphBuilder2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICaptureGraphBuilder2 methods */
    STDMETHOD( SetFiltergraph )( THIS_ IGraphBuilder * ) PURE;
    STDMETHOD( GetFiltergraph )( THIS_ IGraphBuilder ** ) PURE;
    STDMETHOD( SetOutputFileName )( THIS_ const GUID *, LPCOLESTR, IBaseFilter **, IFileSinkFilter ** ) PURE;
    STDMETHOD( FindInterface )( THIS_ const GUID *, const GUID *, IBaseFilter *, REFIID, void ** ) PURE;
    STDMETHOD( RenderStream )( THIS_ const GUID *, const GUID *, IUnknown *, IBaseFilter *, IBaseFilter * ) PURE;
    STDMETHOD( ControlStream )( THIS_ const GUID *, const GUID *, IBaseFilter *, REFERENCE_TIME *, REFERENCE_TIME *, WORD, WORD ) PURE;
    STDMETHOD( AllocCapFile )( THIS_ LPCOLESTR, DWORDLONG ) PURE;
    STDMETHOD( CopyCaptureFile )( THIS_ LPOLESTR, LPOLESTR, int, IAMCopyCaptureFileProgress * ) PURE;
    STDMETHOD( FindPin )( THIS_ IUnknown *, PIN_DIRECTION, const GUID *, const GUID *, BOOL, int, IPin ** ) PURE;
};

/* IFilterGraph2 interface */
#undef INTERFACE
#define INTERFACE   IFilterGraph2
DECLARE_INTERFACE_( IFilterGraph2, IGraphBuilder ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterGraph methods */
    STDMETHOD( AddFilter )( THIS_ IBaseFilter *, LPCWSTR ) PURE;
    STDMETHOD( RemoveFilter )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( EnumFilters )( THIS_ IEnumFilters ** ) PURE;
    STDMETHOD( FindFilterByName )( THIS_ LPCWSTR, IBaseFilter ** v) PURE;
    STDMETHOD( ConnectDirect )( THIS_ IPin *, IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( Reconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( Disconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( SetDefaultSyncSource )( THIS ) PURE;

    /* IGraphBuilder methods */
    STDMETHOD( Connect )( THIS_ IPin *, IPin * ) PURE;
    STDMETHOD( Render )( THIS_ IPin * ) PURE;
    STDMETHOD( RenderFile )( THIS_ LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( AddSourceFilter )( THIS_ LPCWSTR, LPCWSTR, IBaseFilter ** ) PURE;
    STDMETHOD( SetLogFile )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( Abort )( THIS ) PURE;
    STDMETHOD( ShouldOperationContinue )( THIS ) PURE;

    /* IFilterGraph2 methods */
    STDMETHOD( AddSourceFilterForMoniker )( THIS_ IMoniker *, IBindCtx *, LPCWSTR, IBaseFilter ** ) PURE;
    STDMETHOD( ReconnectEx )( THIS_ IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( RenderEx )( THIS_ IPin *, DWORD, DWORD * ) PURE;
};

/* IFilterGraph3 interface */
#undef INTERFACE
#define INTERFACE   IFilterGraph3
DECLARE_INTERFACE_( IFilterGraph3, IFilterGraph2 ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterGraph methods */
    STDMETHOD( AddFilter )( THIS_ IBaseFilter *, LPCWSTR ) PURE;
    STDMETHOD( RemoveFilter )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( EnumFilters )( THIS_ IEnumFilters ** ) PURE;
    STDMETHOD( FindFilterByName )( THIS_ LPCWSTR, IBaseFilter ** v) PURE;
    STDMETHOD( ConnectDirect )( THIS_ IPin *, IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( Reconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( Disconnect )( THIS_ IPin * ) PURE;
    STDMETHOD( SetDefaultSyncSource )( THIS ) PURE;

    /* IGraphBuilder methods */
    STDMETHOD( Connect )( THIS_ IPin *, IPin * ) PURE;
    STDMETHOD( Render )( THIS_ IPin * ) PURE;
    STDMETHOD( RenderFile )( THIS_ LPCWSTR, LPCWSTR ) PURE;
    STDMETHOD( AddSourceFilter )( THIS_ LPCWSTR, LPCWSTR, IBaseFilter ** ) PURE;
    STDMETHOD( SetLogFile )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( Abort )( THIS ) PURE;
    STDMETHOD( ShouldOperationContinue )( THIS ) PURE;

    /* IFilterGraph2 methods */
    STDMETHOD( AddSourceFilterForMoniker )( THIS_ IMoniker *, IBindCtx *, LPCWSTR, IBaseFilter ** ) PURE;
    STDMETHOD( ReconnectEx )( THIS_ IPin *, const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( RenderEx )( THIS_ IPin *, DWORD, DWORD * ) PURE;

    /* IFilterGraph3 methods */
    STDMETHOD( SetSyncSourceEx )( THIS_ IReferenceClock *, IReferenceClock *, IBaseFilter * ) PURE;
};

/* IStreamBuilder interface */
#undef INTERFACE
#define INTERFACE   IStreamBuilder
DECLARE_INTERFACE_( IStreamBuilder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IStreamBuilder methods */
    STDMETHOD( Render )( THIS_ IPin *, IGraphBuilder * ) PURE;
    STDMETHOD( Backout )( THIS_ IPin *, IGraphBuilder * ) PURE;
};

/* IAsyncReader interface */
#undef INTERFACE
#define INTERFACE   IAsyncReader
DECLARE_INTERFACE_( IAsyncReader, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAsyncReader methods */
    STDMETHOD( RequestAllocator )( THIS_ IMemAllocator *, ALLOCATOR_PROPERTIES *, IMemAllocator ** ) PURE;
    STDMETHOD( Request )( THIS_ IMediaSample *, DWORD_PTR ) PURE;
    STDMETHOD( WaitForNext )( THIS_ DWORD, IMediaSample **, DWORD_PTR * ) PURE;
    STDMETHOD( SyncReadAligned )( THIS_ IMediaSample * ) PURE;
    STDMETHOD( SyncRead )( THIS_ LONGLONG, LONG, BYTE * ) PURE;
    STDMETHOD( Length )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( BeginFlush )( THIS ) PURE;
    STDMETHOD( EndFlush )( THIS ) PURE;
};

/* IGraphVersion interface */
#undef INTERFACE
#define INTERFACE   IGraphVersion
DECLARE_INTERFACE_( IGraphVersion, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IGraphVersion methods */
    STDMETHOD( QueryVersion )( THIS_ LONG * ) PURE;
};

/* IResourceConsumer interface */
#undef INTERFACE
#define INTERFACE   IResourceConsumer
DECLARE_INTERFACE_( IResourceConsumer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IResourceConsumer methods */
    STDMETHOD( AcquireResource )( THIS_ LONG ) PURE;
    STDMETHOD( ReleaseResource )( THIS_ LONG ) PURE;
};

/* IResourceManager interface */
#undef INTERFACE
#define INTERFACE   IResourceManager
DECLARE_INTERFACE_( IResourceManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IResourceManager methods */
    STDMETHOD( Register )( THIS_ LPCWSTR, LONG, LONG * ) PURE;
    STDMETHOD( RegisterGroup )( THIS_ LPCWSTR, LONG, LONG *, LONG * ) PURE;
    STDMETHOD( RequestResource )( THIS_ LONG, IUnknown *, IResourceConsumer * ) PURE;
    STDMETHOD( NotifyAcquire )( THIS_ LONG, IResourceConsumer *, HRESULT ) PURE;
    STDMETHOD( NotifyRelease )( THIS_ LONG, IResourceConsumer *, BOOL ) PURE;
    STDMETHOD( CancelRequest )( THIS_ LONG, IResourceConsumer * ) PURE;
    STDMETHOD( SetFocus )( THIS_ IUnknown * ) PURE;
    STDMETHOD( ReleaseFocus )( THIS_ IUnknown * ) PURE;
};

/* IDistributorNotify interface */
#undef INTERFACE
#define INTERFACE   IDistributorNotify
DECLARE_INTERFACE_( IDistributorNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDistributorNotify methods */
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( Pause )( THIS ) PURE;
    STDMETHOD( Run )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( SetSyncSource )( THIS_ IReferenceClock * ) PURE;
    STDMETHOD( NotifyGraphChange )( THIS ) PURE;
};

/* IAMStreamControl interface */
#undef INTERFACE
#define INTERFACE   IAMStreamControl
DECLARE_INTERFACE_( IAMStreamControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMStreamControl methods */
    STDMETHOD( StartAt )( THIS_ const REFERENCE_TIME *, DWORD ) PURE;
    STDMETHOD( StopAt )( THIS_ const REFERENCE_TIME *, BOOL, DWORD ) PURE;
    STDMETHOD( GetInfo )( THIS_ AM_STREAM_INFO * ) PURE;
};

/* ISeekingPassThru interface */
#undef INTERFACE
#define INTERFACE   ISeekingPassThru
DECLARE_INTERFACE_( ISeekingPassThru, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ISeekingPassThru methods */
    STDMETHOD( Init )( THIS_ BOOL, IPin * ) PURE;
};

/* IAMStreamConfig interface */
#undef INTERFACE
#define INTERFACE   IAMStreamConfig
DECLARE_INTERFACE_( IAMStreamConfig, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMStreamConfig methods */
    STDMETHOD( SetFormat )( THIS_ AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( GetFormat )( THIS_ AM_MEDIA_TYPE ** ) PURE;
    STDMETHOD( GetNumberOfCapabilities )( THIS_ int *, int * ) PURE;
    STDMETHOD( GetStreamCaps )( THIS_ int, AM_MEDIA_TYPE **, BYTE * ) PURE;
};

/* IConfigInterleaving interface */
#undef INTERFACE
#define INTERFACE   IConfigInterleaving
DECLARE_INTERFACE_( IConfigInterleaving, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IConfigInterleaving methods */
    STDMETHOD( put_Mode )( THIS_ InterleavingMode ) PURE;
    STDMETHOD( get_Mode )( THIS_ InterleavingMode * ) PURE;
    STDMETHOD( put_Interleaving )( THIS_ const REFERENCE_TIME *, const REFERENCE_TIME * ) PURE;
    STDMETHOD( get_Interleaving )( THIS_ REFERENCE_TIME *, REFERENCE_TIME * ) PURE;
};

/* IConfigAviMux interface */
#undef INTERFACE
#define INTERFACE   IConfigAviMux
DECLARE_INTERFACE_( IConfigAviMux, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IConfigAviMux methods */
    STDMETHOD( SetMasterStream )( THIS_ LONG ) PURE;
    STDMETHOD( GetMasterStream )( THIS_ LONG * ) PURE;
    STDMETHOD( SetOutputCompatibilityIndex )( THIS_ BOOL ) PURE;
    STDMETHOD( GetOutputCompatibilityIndex )( THIS_ BOOL * ) PURE;
};

/* IAMVideoCompression interface */
#undef INTERFACE
#define INTERFACE   IAMVideoCompression
DECLARE_INTERFACE_( IAMVideoCompression, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVideoCompression methods */
    STDMETHOD( put_KeyFrameRate )( THIS_ long ) PURE;
    STDMETHOD( get_KeyFrameRate )( THIS_ long * ) PURE;
    STDMETHOD( put_PFramesPerKeyFrame )( THIS_ long ) PURE;
    STDMETHOD( get_PFramesPerKeyFrame )( THIS_ long * ) PURE;
    STDMETHOD( put_Quality )( THIS_ double ) PURE;
    STDMETHOD( get_Quality )( THIS_ double * ) PURE;
    STDMETHOD( put_WindowSize )( THIS_ DWORDLONG ) PURE;
    STDMETHOD( get_WindowSize )( THIS_ DWORDLONG * ) PURE;
    STDMETHOD( GetInfo )( THIS_ LPWSTR, int *, LPWSTR, int *, long *, long *, double *, long * ) PURE;
    STDMETHOD( OverrideKeyFrame )( THIS_ long ) PURE;
    STDMETHOD( OverrideFrameSize )( THIS_ long, long ) PURE;
};

/* IAMVfwCaptureDialogs interface */
#undef INTERFACE
#define INTERFACE   IAMVfwCaptureDialogs
DECLARE_INTERFACE_( IAMVfwCaptureDialogs, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVfwCaptureDialogs methods */
    STDMETHOD( HasDialog )( THIS_ int ) PURE;
    STDMETHOD( ShowDialog )( THIS_ int, HWND ) PURE;
    STDMETHOD( SendDriverMessage )( THIS_ int, int, long, long ) PURE;
};

/* IAMVfwCompressDialogs interface */
#undef INTERFACE
#define INTERFACE   IAMVfwCompressDialogs
DECLARE_INTERFACE_( IAMVfwCompressDialogs, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVfwCompressDialogs methods */
    STDMETHOD( ShowDialog )( THIS_ int, HWND ) PURE;
    STDMETHOD( GetState )( THIS_ LPVOID, int * ) PURE;
    STDMETHOD( SetState )( THIS_ LPVOID, int ) PURE;
    STDMETHOD( SendDriverMessage )( THIS_ int, long, long ) PURE;
};

/* IAMDroppedFrames interface */
#undef INTERFACE
#define INTERFACE   IAMDroppedFrames
DECLARE_INTERFACE_( IAMDroppedFrames, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMDroppedFrames methods */
    STDMETHOD( GetNumDropped )( THIS_ long * ) PURE;
    STDMETHOD( GetNumNotDropped )( THIS_ long * ) PURE;
    STDMETHOD( GetDroppedInfo )( THIS_ long, long *, long * ) PURE;
    STDMETHOD( GetAverageFrameSize )( THIS_ long * ) PURE;
};

/* IAMAudioInputMixer interface */
#undef INTERFACE
#define INTERFACE   IAMAudioInputMixer
DECLARE_INTERFACE_( IAMAudioInputMixer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMAudioInputMixer methods */
    STDMETHOD( put_Enable )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Enable )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Mono )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Mono )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_MixLevel )( THIS_ double ) PURE;
    STDMETHOD( get_MixLevel )( THIS_ double * ) PURE;
    STDMETHOD( put_Pan )( THIS_ double ) PURE;
    STDMETHOD( get_Pan )( THIS_ double * ) PURE;
    STDMETHOD( put_Loudness )( THIS_ BOOL ) PURE;
    STDMETHOD( get_Loudness )( THIS_ BOOL * ) PURE;
    STDMETHOD( put_Treble )( THIS_ double ) PURE;
    STDMETHOD( get_Treble )( THIS_ double * ) PURE;
    STDMETHOD( get_TrebleRange )( THIS_ double * ) PURE;
    STDMETHOD( put_Bass )( THIS_ double ) PURE;
    STDMETHOD( get_Bass )( THIS_ double * ) PURE;
    STDMETHOD( get_BassRange )( THIS_ double * ) PURE;
};

/* IAMBufferNegotiation interface */
#undef INTERFACE
#define INTERFACE   IAMBufferNegotiation
DECLARE_INTERFACE_( IAMBufferNegotiation, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMBufferNegotiation methods */
    STDMETHOD( SuggestAllocatorProperties )( THIS_ const ALLOCATOR_PROPERTIES * ) PURE;
    STDMETHOD( GetAllocatorProperties )( THIS_ ALLOCATOR_PROPERTIES * ) PURE;
};

/* IAMAnalogVideoDecoder interface */
#undef INTERFACE
#define INTERFACE   IAMAnalogVideoDecoder
DECLARE_INTERFACE_( IAMAnalogVideoDecoder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMAnalogVideoDecoder methods */
    STDMETHOD( get_AvailableTVFormats )( THIS_ long * ) PURE;
    STDMETHOD( put_TVFormat )( THIS_ long ) PURE;
    STDMETHOD( get_TVFormat )( THIS_ long * ) PURE;
    STDMETHOD( get_HorizontalLocked )( THIS_ long * ) PURE;
    STDMETHOD( put_VCRHorizontalLocking )( THIS_ long ) PURE;
    STDMETHOD( get_VCRHorizontalLocking )( THIS_ long * ) PURE;
    STDMETHOD( get_NumberOfLines )( THIS_ long * ) PURE;
    STDMETHOD( put_EnableOutput )( THIS_ long ) PURE;
    STDMETHOD( get_EnableOutput )( THIS_ long * ) PURE;
};

/* IAMVideoProcAmp interface */
#undef INTERFACE
#define INTERFACE   IAMVideoProcAmp
DECLARE_INTERFACE_( IAMVideoProcAmp, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVideoProcAmp methods */
    STDMETHOD( GetRange )( THIS_ long, long *, long *, long *, long *, long * ) PURE;
    STDMETHOD( Set )( THIS_ long, long, long ) PURE;
    STDMETHOD( Get )( THIS_ long, long *, long * ) PURE;
};

/* IAMCameraControl interface */
#undef INTERFACE
#define INTERFACE   IAMCameraControl
DECLARE_INTERFACE_( IAMCameraControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMCameraControl methods */
    STDMETHOD( GetRange )( THIS_ long, long *, long *, long *, long *, long * ) PURE;
    STDMETHOD( Set )( THIS_ long, long, long ) PURE;
    STDMETHOD( Get )( THIS_ long, long *, long * ) PURE;
};

/* IAMVideoControl interface */
#undef INTERFACE
#define INTERFACE   IAMVideoControl
DECLARE_INTERFACE_( IAMVideoControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVideoControl methods */
    STDMETHOD( GetCaps )( THIS_ IPin *, long * ) PURE;
    STDMETHOD( SetMode )( THIS_ IPin *, long ) PURE;
    STDMETHOD( GetMode )( THIS_ IPin *, long * ) PURE;
    STDMETHOD( GetCurrentActualFrameRate )( THIS_ IPin *, LONGLONG * ) PURE;
    STDMETHOD( GetMaxAvailableFrameRate )( THIS_ IPin *, long, SIZE, LONGLONG * ) PURE;
    STDMETHOD( GetFrameRateList )( THIS_ IPin *, long, SIZE, long *, LONGLONG ** ) PURE;
};

/* IAMCrossbar interface */
#undef INTERFACE
#define INTERFACE   IAMCrossbar
DECLARE_INTERFACE_( IAMCrossbar, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMCrossbar methods */
    STDMETHOD( get_PinCounts )( THIS_ long *, long * ) PURE;
    STDMETHOD( CanRoute )( THIS_ long, long ) PURE;
    STDMETHOD( Route )( THIS_ long, long ) PURE;
    STDMETHOD( get_IsRoutedTo )( THIS_ long, long * ) PURE;
    STDMETHOD( get_CrossbarPinInfo )( THIS_ BOOL, long, long *, long * ) PURE;
};

/* IAMTuner interface */
#undef INTERFACE
#define INTERFACE   IAMTuner
DECLARE_INTERFACE_( IAMTuner, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTuner methods */
    STDMETHOD( put_Channel )( THIS_ long, long, long ) PURE;
    STDMETHOD( get_Channel )( THIS_ long *, long *, long * ) PURE;
    STDMETHOD( ChannelMinMax )( THIS_ long *, long * ) PURE;
    STDMETHOD( put_CountryCode )( THIS_ long ) PURE;
    STDMETHOD( get_CountryCode )( THIS_ long * ) PURE;
    STDMETHOD( put_TuningSpace )( THIS_ long ) PURE;
    STDMETHOD( get_TuningSpace )( THIS_ long * ) PURE;
    STDMETHOD( Logon )( THIS_ HANDLE ) PURE;
    STDMETHOD( Logout )( THIS ) PURE;
    STDMETHOD( SignalPresent )( THIS_ long * ) PURE;
    STDMETHOD( put_Mode )( THIS_ AMTunerModeType ) PURE;
    STDMETHOD( get_Mode )( THIS_ AMTunerModeType * ) PURE;
    STDMETHOD( GetAvailableModes )( THIS_ long * ) PURE;
    STDMETHOD( RegisterNotificationCallBack )( THIS_ IAMTunerNotification *, long ) PURE;
    STDMETHOD( UnRegisterNotificationCallBack )( THIS_ IAMTunerNotification * ) PURE;
};

/* IAMTunerNotification interface */
#undef INTERFACE
#define INTERFACE   IAMTunerNotification
DECLARE_INTERFACE_( IAMTunerNotification, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTunerNotification methods */
    STDMETHOD( OnEvent )( THIS_ AMTunerEventType ) PURE;
};

/* IAMTVTuner interface */
#undef INTERFACE
#define INTERFACE   IAMTVTuner
DECLARE_INTERFACE_( IAMTVTuner, IAMTuner ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTuner methods */
    STDMETHOD( put_Channel )( THIS_ long, long, long ) PURE;
    STDMETHOD( get_Channel )( THIS_ long *, long *, long * ) PURE;
    STDMETHOD( ChannelMinMax )( THIS_ long *, long * ) PURE;
    STDMETHOD( put_CountryCode )( THIS_ long ) PURE;
    STDMETHOD( get_CountryCode )( THIS_ long * ) PURE;
    STDMETHOD( put_TuningSpace )( THIS_ long ) PURE;
    STDMETHOD( get_TuningSpace )( THIS_ long * ) PURE;
    STDMETHOD( Logon )( THIS_ HANDLE ) PURE;
    STDMETHOD( Logout )( THIS ) PURE;
    STDMETHOD( SignalPresent )( THIS_ long * ) PURE;
    STDMETHOD( put_Mode )( THIS_ AMTunerModeType ) PURE;
    STDMETHOD( get_Mode )( THIS_ AMTunerModeType * ) PURE;
    STDMETHOD( GetAvailableModes )( THIS_ long * ) PURE;
    STDMETHOD( RegisterNotificationCallBack )( THIS_ IAMTunerNotification *, long ) PURE;
    STDMETHOD( UnRegisterNotificationCallBack )( THIS_ IAMTunerNotification * ) PURE;

    /* IAMTVTuner methods */
    STDMETHOD( get_AvailableTVFormats )( THIS_ long * ) PURE;
    STDMETHOD( get_TVFormat )( THIS_ long * ) PURE;
    STDMETHOD( AutoTone )( THIS_ long, long * ) PURE;
    STDMETHOD( StoreAutoTone )( THIS ) PURE;
    STDMETHOD( get_NumInputConnections )( THIS_ long * ) PURE;
    STDMETHOD( put_InputType )( THIS_ long, TunerInputType ) PURE;
    STDMETHOD( get_InputType )( THIS_ long, TunerInputType * ) PURE;
    STDMETHOD( put_ConnectInput )( THIS_ long ) PURE;
    STDMETHOD( get_ConnectInput )( THIS_ long * ) PURE;
    STDMETHOD( get_VideoFrequency )( THIS_ long * ) PURE;
    STDMETHOD( get_AudioFrequency )( THIS_ long * ) PURE;
};

/* IBPCSatelliteTuner interface */
#undef INTERFACE
#define INTERFACE   IBPCSatelliteTuner
DECLARE_INTERFACE_( IBPCSatelliteTuner, IAMTuner ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTuner methods */
    STDMETHOD( put_Channel )( THIS_ long, long, long ) PURE;
    STDMETHOD( get_Channel )( THIS_ long *, long *, long * ) PURE;
    STDMETHOD( ChannelMinMax )( THIS_ long *, long * ) PURE;
    STDMETHOD( put_CountryCode )( THIS_ long ) PURE;
    STDMETHOD( get_CountryCode )( THIS_ long * ) PURE;
    STDMETHOD( put_TuningSpace )( THIS_ long ) PURE;
    STDMETHOD( get_TuningSpace )( THIS_ long * ) PURE;
    STDMETHOD( Logon )( THIS_ HANDLE ) PURE;
    STDMETHOD( Logout )( THIS ) PURE;
    STDMETHOD( SignalPresent )( THIS_ long * ) PURE;
    STDMETHOD( put_Mode )( THIS_ AMTunerModeType ) PURE;
    STDMETHOD( get_Mode )( THIS_ AMTunerModeType * ) PURE;
    STDMETHOD( GetAvailableModes )( THIS_ long * ) PURE;
    STDMETHOD( RegisterNotificationCallBack )( THIS_ IAMTunerNotification *, long ) PURE;
    STDMETHOD( UnRegisterNotificationCallBack )( THIS_ IAMTunerNotification * ) PURE;

    /* IBPCSatelliteTuner methods */
    STDMETHOD( get_DefaultSubChannelTypes )( THIS_ long *, long * ) PURE;
    STDMETHOD( put_DefaultSubChannelTypes )( THIS_ long, long ) PURE;
    STDMETHOD( IsTapingPermitted )( THIS ) PURE;
};

/* IAMTVAudio interface */
#undef INTERFACE
#define INTERFACE   IAMTVAudio
DECLARE_INTERFACE_( IAMTVAudio, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTVAudio methods */
    STDMETHOD( GetHardwareSupportedTVAudioModes )( THIS_ long * ) PURE;
    STDMETHOD( GetAvailableTVAudioModes )( THIS_ long * ) PURE;
    STDMETHOD( get_TVAudioMode )( THIS_ long * ) PURE;
    STDMETHOD( put_TVAudioMode )( THIS_ long ) PURE;
    STDMETHOD( RegisterNotificationCallBack )( THIS_ IAMTunerNotification *, long ) PURE;
    STDMETHOD( UnRegisterNotificationCallBack )( THIS_ IAMTunerNotification * ) PURE;
};

/* IAMTVAudioNotification interface */
#undef INTERFACE
#define INTERFACE   IAMTVAudioNotification
DECLARE_INTERFACE_( IAMTVAudioNotification, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTVAudioNotification methods */
    STDMETHOD( OnEvent )( THIS_ AMTVAudioEventType ) PURE;
};

/* IAMAnalogVideoEncoder interface */
#undef INTERFACE
#define INTERFACE   IAMAnalogVideoEncoder
DECLARE_INTERFACE_( IAMAnalogVideoEncoder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMAnalogVideoEncoder methods */
    STDMETHOD( get_AvailableTVFormats )( THIS_ long * ) PURE;
    STDMETHOD( put_TVFormat )( THIS_ long ) PURE;
    STDMETHOD( get_TVFormat )( THIS_ long * ) PURE;
    STDMETHOD( put_CopyProtection )( THIS_ long ) PURE;
    STDMETHOD( get_CopyProtection )( THIS_ long * ) PURE;
    STDMETHOD( put_CCEnable )( THIS_ long ) PURE;
    STDMETHOD( get_CCEnable )( THIS_ long * ) PURE;
};

/* IKsPropertySet interface */
#undef INTERFACE
#define INTERFACE   IKsPropertySet
DECLARE_INTERFACE_( IKsPropertySet, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IKsPropertySet methods */
    STDMETHOD( Set )( THIS_ REFGUID, DWORD, LPVOID, DWORD, LPVOID, DWORD ) PURE;
    STDMETHOD( Get )( THIS_ REFGUID, DWORD, LPVOID, DWORD, LPVOID, DWORD, DWORD * ) PURE;
    STDMETHOD( QuerySupported )( THIS_ REFGUID, DWORD, DWORD * ) PURE;
};

/* IMediaPropertyBag interface */
#undef INTERFACE
#define INTERFACE   IMediaPropertyBag
DECLARE_INTERFACE_( IMediaPropertyBag, IPropertyBag ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPropertyBag methods */
    STDMETHOD( Read )( THIS_ LPCOLESTR, VARIANT *, IErrorLog * ) PURE;
    STDMETHOD( Write )( THIS_ LPCOLESTR, VARIANT * ) PURE;

    /* IMediaPropertyBag methods */
    STDMETHOD( EnumProperty )( THIS_ ULONG, VARIANT *, VARIANT * ) PURE;
};
typedef IMediaPropertyBag   *LPMEDIAPROPERTYBAG;

/* IPersistMediaPropertyBag interface */
#undef INTERFACE
#define INTERFACE   IPersistMediaPropertyBag
DECLARE_INTERFACE_( IPersistMediaPropertyBag, IPersist ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;
    
    /* IPersist methods */
    STDMETHOD( GetClassID )( THIS_ CLSID * ) PURE;

    /* IPersistMediaPropertyBag methods */
    STDMETHOD( InitNew )( THIS ) PURE;
    STDMETHOD( Load )( THIS_ IMediaPropertyBag *, IErrorLog * ) PURE;
    STDMETHOD( Save )( THIS_ IMediaPropertyBag *, BOOL, BOOL ) PURE;
};
typedef IPersistMediaPropertyBag    *LPPERSISTMEDIAPROPERTYBAG;

/* IAMPhysicalPinInfo interface */
#undef INTERFACE
#define INTERFACE   IAMPhysicalPinInfo
DECLARE_INTERFACE_( IAMPhysicalPinInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMPhysicalPinInfo methods */
    STDMETHOD( GetPhysicalType )( THIS_ long *, LPOLESTR * ) PURE;
};
typedef IAMPhysicalPinInfo  *PAMPHYSICALPININFO;

/* IAMExtDevice interface */
#undef INTERFACE
#define INTERFACE   IAMExtDevice
DECLARE_INTERFACE_( IAMExtDevice, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMExtDevice methods */
    STDMETHOD( GetCapability )( THIS_ long, long *, double * ) PURE;
    STDMETHOD( get_ExternalDeviceID )( THIS_ LPOLESTR * ) PURE;
    STDMETHOD( get_ExternalDeviceVersion )( THIS_ LPOLESTR * ) PURE;
    STDMETHOD( put_DevicePower )( THIS_ long ) PURE;
    STDMETHOD( get_DevicePower )( THIS_ long * ) PURE;
    STDMETHOD( Calibrate )( THIS_ HEVENT, long, long * ) PURE;
    STDMETHOD( put_DevicePort )( THIS_ long ) PURE;
    STDMETHOD( get_DevicePort )( THIS_ long * ) PURE;
};
typedef IAMExtDevice    *PEXTDEVICE;

/* IAMExtTransport interface */
#undef INTERFACE
#define INTERFACE   IAMExtTransport
DECLARE_INTERFACE_( IAMExtTransport, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMExtTransport methods */
    STDMETHOD( GetCapability )( THIS_ long, long *, double * ) PURE;
    STDMETHOD( put_MediaState )( THIS_ long ) PURE;
    STDMETHOD( get_MediaState )( THIS_ long * ) PURE;
    STDMETHOD( put_LocalControl )( THIS_ long ) PURE;
    STDMETHOD( get_LocalControl )( THIS_ long * ) PURE;
    STDMETHOD( GetStatus )( THIS_ long, long * ) PURE;
    STDMETHOD( GetTransportBasicParameters )( THIS_ long, long *, LPOLESTR * ) PURE;
    STDMETHOD( SetTransportBasicParameters )( THIS_ long, long, LPCOLESTR ) PURE;
    STDMETHOD( GetTransportVideoParameters )( THIS_ long, long * ) PURE;
    STDMETHOD( SetTransportVideoParameters )( THIS_ long, long ) PURE;
    STDMETHOD( GetTransportAudioParameters )( THIS_ long, long * ) PURE;
    STDMETHOD( SetTransportAudioParameters )( THIS_ long, long ) PURE;
    STDMETHOD( put_Mode )( THIS_ long ) PURE;
    STDMETHOD( get_Mode )( THIS_ long * ) PURE;
    STDMETHOD( put_Rate )( THIS_ double ) PURE;
    STDMETHOD( get_Rate )( THIS_ double * ) PURE;
    STDMETHOD( GetChase )( THIS_ long *, long *, HEVENT * ) PURE;
    STDMETHOD( SetChase )( THIS_ long, long, HEVENT ) PURE;
    STDMETHOD( GetBump )( THIS_ long *, long * ) PURE;
    STDMETHOD( SetBump )( THIS_ long, long ) PURE;
    STDMETHOD( get_AntiClogControl )( THIS_ long * ) PURE;
    STDMETHOD( put_AntiClogControl )( THIS_ long ) PURE;
    STDMETHOD( GetEditPropertySet )( THIS_ long, long * ) PURE;
    STDMETHOD( SetEditPropertySet )( THIS_ long *, long ) PURE;
    STDMETHOD( GetEditProperty )( THIS_ long, long, long * ) PURE;
    STDMETHOD( SetEditProperty )( THIS_ long, long, long ) PURE;
    STDMETHOD( get_EditStart )( THIS_ long * ) PURE;
    STDMETHOD( put_EditStart )( THIS_ long ) PURE;
};
typedef IAMExtTransport *PIAMEXTTRANSPORT;

/* IAMTimecodeReader interface */
#undef INTERFACE
#define INTERFACE   IAMTimecodeReader
DECLARE_INTERFACE_( IAMTimecodeReader, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimecodeReader methods */
    STDMETHOD( GetTCRMode )( THIS_ long, long * ) PURE;
    STDMETHOD( SetTCRMode )( THIS_ long, long ) PURE;
    STDMETHOD( put_VITCLine )( THIS_ long ) PURE;
    STDMETHOD( get_VITCLine )( THIS_ long * ) PURE;
    STDMETHOD( GetTimecode )( THIS_ PTIMECODE_SAMPLE ) PURE;
};
typedef IAMTimecodeReader   *PIAMTIMECODEREADER;

/* IAMTimecodeGenerator interface */
#undef INTERFACE
#define INTERFACE   IAMTimecodeGenerator
DECLARE_INTERFACE_( IAMTimecodeGenerator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimecodeGenerator methods */
    STDMETHOD( GetTCGMode )( THIS_ long, long * ) PURE;
    STDMETHOD( SetTCGMode )( THIS_ long, long ) PURE;
    STDMETHOD( put_VITCLine )( THIS_ long ) PURE;
    STDMETHOD( get_VITCLine )( THIS_ long * ) PURE;
    STDMETHOD( SetTimecode )( THIS_ PTIMECODE_SAMPLE ) PURE;
    STDMETHOD( GetTimecode )( THIS_ PTIMECODE_SAMPLE ) PURE;
};
typedef IAMTimecodeGenerator    *LPIAMTIMECODEGENERATOR;

/* IAMTimecodeDisplay interface */
#undef INTERFACE
#define INTERFACE   IAMTimecodeDisplay
DECLARE_INTERFACE_( IAMTimecodeDisplay, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMTimecodeDisplay methods */
    STDMETHOD( GetTCDisplayEnable )( THIS_ long * ) PURE;
    STDMETHOD( SetTCDisplayEnable )( THIS_ long ) PURE;
    STDMETHOD( GetTCDisplay )( THIS_ long, long * ) PURE;
    STDMETHOD( SetTCDisplay )( THIS_ long, long ) PURE;
};
typedef IAMTimecodeDisplay  *PIAMTIMECODEDISPLAY;

/* IAMDevMemoryAllocator interface */
#undef INTERFACE
#define INTERFACE   IAMDevMemoryAllocator
DECLARE_INTERFACE_( IAMDevMemoryAllocator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMDevMemoryAllocator methods */
    STDMETHOD( GetInfo )( THIS_ DWORD *, DWORD *, DWORD *, DWORD * ) PURE;
    STDMETHOD( CheckMemory )( THIS_ const BYTE * ) PURE;
    STDMETHOD( Alloc )( THIS_ BYTE **, DWORD * ) PURE;
    STDMETHOD( Free )( THIS_ BYTE * ) PURE;
    STDMETHOD( GetDevMemoryObject )( THIS_ IUnknown **, IUnknown * ) PURE;
};
typedef IAMDevMemoryAllocator   *PAMDEVMEMORYALLOCATOR;

/* IAMDevMemoryControl interface */
#undef INTERFACE
#define INTERFACE   IAMDevMemoryControl
DECLARE_INTERFACE_( IAMDevMemoryControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMDevMemoryControl methods */
    STDMETHOD( QueryWriteSync )( THIS ) PURE;
    STDMETHOD( WriteSync )( THIS ) PURE;
    STDMETHOD( GetDevId )( THIS_ DWORD * ) PURE;
};
typedef IAMDevMemoryControl *PAMDEVMEMORYCONTROL;

/* IAMStreamSelect interface */
#undef INTERFACE
#define INTERFACE   IAMStreamSelect
DECLARE_INTERFACE_( IAMStreamSelect, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMStreamSelect methods */
    STDMETHOD( Count )( THIS_ DWORD * ) PURE;
    STDMETHOD( Info )( THIS_ long, AM_MEDIA_TYPE **, DWORD *, LCID *, DWORD *, LPWSTR *, IUnknown **, IUnknown ** ) PURE;
    STDMETHOD( Enable )( THIS_ long, DWORD ) PURE;
};
typedef IAMStreamSelect *PAMSTREAMSELECT;

/* IAMResourceControl interface */
#undef INTERFACE
#define INTERFACE   IAMResourceControl
DECLARE_INTERFACE_( IAMResourceControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMResourceControl methods */
    STDMETHOD( Reserve )( THIS_ DWORD, PVOID ) PURE;
};

/* IAMClockAdjust interface */
#undef INTERFACE
#define INTERFACE   IAMClockAdjust
DECLARE_INTERFACE_( IAMClockAdjust, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMClockAdjust methods */
    STDMETHOD( SetClockDelta )( THIS_ REFERENCE_TIME ) PURE;
};

/* IAMFilterMiscFlags interface */
#undef INTERFACE
#define INTERFACE   IAMFilterMiscFlags
DECLARE_INTERFACE_( IAMFilterMiscFlags, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMFilterMiscFlags methods */
    STDMETHOD_( ULONG, GetMiscFlags )( THIS ) PURE;
};

/* IDrawVideoImage interface */
#undef INTERFACE
#define INTERFACE   IDrawVideoImage
DECLARE_INTERFACE_( IDrawVideoImage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDrawVideoImage methods */
    STDMETHOD( DrawVideoImageBegin )( THIS ) PURE;
    STDMETHOD( DrawVideoImageEnd )( THIS ) PURE;
    STDMETHOD( DrawVideoImageDraw )( THIS_ HDC, LPRECT, LPRECT ) PURE;
};

/* IDecimateVideoImage interface */
#undef INTERFACE
#define INTERFACE   IDecimateVideoImage
DECLARE_INTERFACE_( IDecimateVideoImage, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDecimateVideoImage methods */
    STDMETHOD( SetDecimationImageSize )( THIS_ long, long ) PURE;
    STDMETHOD( ResetDecimationImageSize )( THIS ) PURE;
};

/* IAMVideoDecimationProperties interface */
#undef INTERFACE
#define INTERFACE   IAMVideoDecimationProperties
DECLARE_INTERFACE_( IAMVideoDecimationProperties, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMVideoDecimationProperties methods */
    STDMETHOD( QueryDecimationUsage )( THIS_ DECIMATION_USAGE * ) PURE;
    STDMETHOD( SetDecimationUsage )( THIS_ DECIMATION_USAGE ) PURE;
};

/* IVideoFrameStep interface */
#undef INTERFACE
#define INTERFACE   IVideoFrameStep
DECLARE_INTERFACE_( IVideoFrameStep, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVideoFrameStep methods */
    STDMETHOD( Step )( THIS_ DWORD, IUnknown * ) PURE;
    STDMETHOD( CanStep )( THIS_ long, IUnknown * ) PURE;
    STDMETHOD( CancelStep )( THIS ) PURE;
};

/* IAMLatency interface */
#undef INTERFACE
#define INTERFACE   IAMLatency
DECLARE_INTERFACE_( IAMLatency, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMLatency methods */
    STDMETHOD( GetLatency )( THIS_ REFERENCE_TIME * ) PURE;
};

/* IAMPushSource interface */
#undef INTERFACE
#define INTERFACE   IAMPushSource
DECLARE_INTERFACE_( IAMPushSource, IAMLatency ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMLatency methods */
    STDMETHOD( GetLatency )( THIS_ REFERENCE_TIME * ) PURE;

    /* IAMPushSource methods */
    STDMETHOD( GetPushSourceFlags )( THIS_ ULONG * ) PURE;
    STDMETHOD( SetPushSourceFlags )( THIS_ ULONG ) PURE;
    STDMETHOD( SetStreamOffset )( THIS_ REFERENCE_TIME ) PURE;
    STDMETHOD( GetStreamOffset )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( GetMaxStreamOffset )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( SetMaxStreamOffset )( THIS_ REFERENCE_TIME ) PURE;
};

/* IAMDeviceRemoval interface */
#undef INTERFACE
#define INTERFACE   IAMDeviceRemoval
DECLARE_INTERFACE_( IAMDeviceRemoval, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMDeviceRemoval methods */
    STDMETHOD( DeviceInfo )( THIS_ CLSID *, LPWSTR * ) PURE;
    STDMETHOD( Reassociate )( THIS ) PURE;
    STDMETHOD( Disassociate )( THIS ) PURE;
};

/* IDVEnc interface */
#undef INTERFACE
#define INTERFACE   IDVEnc
DECLARE_INTERFACE_( IDVEnc, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDVEnc methods */
    STDMETHOD( get_IFormatResolution )( THIS_ int *, int *, int *, BYTE, DVINFO * ) PURE;
    STDMETHOD( put_IFormatResolution )( THIS_ int, int, int, BYTE, DVINFO * ) PURE;
};

/* IIPDVDec interface */
#undef INTERFACE
#define INTERFACE   IIPDVDec
DECLARE_INTERFACE_( IIPDVDec, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IIPDVDec methods */
    STDMETHOD( get_IPDisplay )( THIS_ int * ) PURE;
    STDMETHOD( put_IPDisplay )( THIS_ int ) PURE;
};

/* IDVRGB219 interface */
#undef INTERFACE
#define INTERFACE   IDVRGB219
DECLARE_INTERFACE_( IDVRGB219, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDVRGB219 methods */
    STDMETHOD( SetRGB219 )( THIS_ BOOL ) PURE;
};

/* IDVSplitter interface */
#undef INTERFACE
#define INTERFACE   IDVSplitter
DECLARE_INTERFACE_( IDVSplitter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDVSplitter methods */
    STDMETHOD( DiscardAlternateVideoFrames )( THIS_ int ) PURE;
};

/* IAMAudioRendererStats interface */
#undef INTERFACE
#define INTERFACE   IAMAudioRendererStats
DECLARE_INTERFACE_( IAMAudioRendererStats, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMAudioRendererStats methods */
    STDMETHOD( GetStatParam )( THIS_ DWORD, DWORD *, DWORD * ) PURE;
};

/* IAMGraphStreams interface */
#undef INTERFACE
#define INTERFACE   IAMGraphStreams
DECLARE_INTERFACE_( IAMGraphStreams, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMGraphStreams methods */
    STDMETHOD( FindUpstreamInterface )( THIS_ IPin *, REFIID, void **, DWORD ) PURE;
    STDMETHOD( SyncUsingStreamOffset )( THIS_ BOOL ) PURE;
    STDMETHOD( SetMaxGraphLatency )( THIS_ REFERENCE_TIME ) PURE;
};

/* IAMOverlayFX interface */
#undef INTERFACE
#define INTERFACE   IAMOverlayFX
DECLARE_INTERFACE_( IAMOverlayFX, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMOverlayFX methods */
    STDMETHOD( QueryOverlayFXCaps )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetOverlayFX )( THIS_ DWORD ) PURE;
    STDMETHOD( GetOverlayFX )( THIS_ DWORD * ) PURE;
};

/* IAMOpenProgress interface */
#undef INTERFACE
#define INTERFACE   IAMOpenProgress
DECLARE_INTERFACE_( IAMOpenProgress, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMOpenProgress methods */
    STDMETHOD( QueryProgress )( THIS_ LONGLONG *, LONGLONG * ) PURE;
    STDMETHOD( AbortOperation )( THIS ) PURE;
};

/* IMpeg2Demultiplexer interface */
#undef INTERFACE
#define INTERFACE   IMpeg2Demultiplexer
DECLARE_INTERFACE_( IMpeg2Demultiplexer, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMpeg2Demultiplexer methods */
    STDMETHOD( CreateOutputPin )( THIS_ AM_MEDIA_TYPE *, LPWSTR, IPin ** ) PURE;
    STDMETHOD( SetOutputPinMediaType )( THIS_ LPWSTR, AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( DeleteOutputPin )( THIS_ LPWSTR ) PURE;
};

/* IEnumStreamIdMap interface */
#undef INTERFACE
#define INTERFACE   IEnumStreamIdMap
DECLARE_INTERFACE_( IEnumStreamIdMap, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEnumStreamIdMap methods */
    STDMETHOD( Next )( THIS_ ULONG, STREAM_ID_MAP *, ULONG * ) PURE;
    STDMETHOD( Skip )( THIS_ ULONG ) PURE;
    STDMETHOD( Reset )( THIS ) PURE;
    STDMETHOD( Clone )( THIS_ IEnumStreamIdMap ** ) PURE;
};

/* IMPEG2StreamIdMap interface */
#undef INTERFACE
#define INTERFACE   IMPEG2StreamIdMap
DECLARE_INTERFACE_( IMPEG2StreamIdMap, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IMPEG2StreamIdMap methods */
    STDMETHOD( MapStreamId )( THIS_ ULONG, DWORD, ULONG, int ) PURE;
    STDMETHOD( UnmapStreamId )( THIS_ ULONG, ULONG * ) PURE;
    STDMETHOD( EnumStreamIdMap )( THIS_ IEnumStreamIdMap ** ) PURE;
};

/* IRegisterServiceProvider interface */
#undef INTERFACE
#define INTERFACE   IRegisterServiceProvider
DECLARE_INTERFACE_( IRegisterServiceProvider, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IRegisterServiceProvider methods */
    STDMETHOD( RegisterService )( THIS_ REFGUID, IUnknown * ) PURE;
};

/* IAMClockSlave interface */
#undef INTERFACE
#define INTERFACE   IAMClockSlave
DECLARE_INTERFACE_( IAMClockSlave, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMClockSlave methods */
    STDMETHOD( SetErrorTolerance )( THIS_ DWORD ) PURE;
    STDMETHOD( GetErrorTolerance )( THIS_ DWORD * ) PURE;
};

/* IAMGraphBuilderCallback interface */
#undef INTERFACE
#define INTERFACE   IAMGraphBuilderCallback
DECLARE_INTERFACE_( IAMGraphBuilderCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMGraphBuilderCallback methods */
    STDMETHOD( SelectedFilter )( THIS_ IMoniker * ) PURE;
    STDMETHOD( CreatedFilter )( THIS_ IBaseFilter * ) PURE;
};

/* ICodecAPI interface */
#undef INTERFACE
#define INTERFACE   ICodecAPI
DECLARE_INTERFACE_( ICodecAPI, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* ICodecAPI methods */
    STDMETHOD( IsSupported )( THIS_ const GUID * ) PURE;
    STDMETHOD( IsModifiable )( THIS_ const GUID * ) PURE;
    STDMETHOD( GetParameterRange )( THIS_ const GUID *, VARIANT *, VARIANT *, VARIANT * ) PURE;
    STDMETHOD( GetParameterValues )( THIS_ const GUID *, VARIANT **, ULONG * ) PURE;
    STDMETHOD( GetDefaultValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( GetValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( SetValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( RegisterForEvent )( THIS_ const GUID *, LONG_PTR ) PURE;
    STDMETHOD( UnregisterForEvent )( THIS_ const GUID * ) PURE;
    STDMETHOD( SetAllDefaults )( THIS ) PURE;
    STDMETHOD( SetValueWithNotify )( THIS_ const GUID *, VARIANT *, GUID **, ULONG * ) PURE;
    STDMETHOD( SetAllDefaultsWithNotify )( THIS_ GUID **, ULONG * ) PURE;
    STDMETHOD( GetAllSettings )( THIS_ IStream * ) PURE;
    STDMETHOD( SetAllSettings )( THIS_ IStream * ) PURE;
    STDMETHOD( SetAllSettingsWithNotify )( THIS_ IStream *, GUID **, ULONG * ) PURE;
};

/* IGetCapabilitiesKey interface */
#undef INTERFACE
#define INTERFACE   IGetCapabilitiesKey
DECLARE_INTERFACE_( IGetCapabilitiesKey, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IGetCapabilitiesKey methods */
    STDMETHOD( GetCapabilitiesKey )( THIS_ HKEY * ) PURE;
};

/* IEncoderAPI interface */
#undef INTERFACE
#define INTERFACE   IEncoderAPI
DECLARE_INTERFACE_( IEncoderAPI, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEncoderAPI methods */
    STDMETHOD( IsSupported )( THIS_ const GUID * ) PURE;
    STDMETHOD( IsAvailable )( THIS_ const GUID * ) PURE;
    STDMETHOD( GetParameterRange )( THIS_ const GUID *, VARIANT *, VARIANT *, VARIANT * ) PURE;
    STDMETHOD( GetParameterValues )( THIS_ const GUID *, VARIANT **, ULONG * ) PURE;
    STDMETHOD( GetDefaultValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( GetValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( SetValue )( THIS_ const GUID *, VARIANT * ) PURE;
};

/* IVideoEncoder interface */
#undef INTERFACE
#define INTERFACE   IVideoEncoder
DECLARE_INTERFACE_( IVideoEncoder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IEncoderAPI methods */
    STDMETHOD( IsSupported )( THIS_ const GUID * ) PURE;
    STDMETHOD( IsAvailable )( THIS_ const GUID * ) PURE;
    STDMETHOD( GetParameterRange )( THIS_ const GUID *, VARIANT *, VARIANT *, VARIANT * ) PURE;
    STDMETHOD( GetParameterValues )( THIS_ const GUID *, VARIANT **, ULONG * ) PURE;
    STDMETHOD( GetDefaultValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( GetValue )( THIS_ const GUID *, VARIANT * ) PURE;
    STDMETHOD( SetValue )( THIS_ const GUID *, VARIANT * ) PURE;
};

/* IAMDecoderCaps interface */
#undef INTERFACE
#define INTERFACE   IAMDecoderCaps
DECLARE_INTERFACE_( IAMDecoderCaps, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMDecoderCaps methods */
    STDMETHOD( GetDecoderCaps )( THIS_ DWORD, DWORD * ) PURE;
};

/* IAMCertifiedOutputProtection interface */
#undef INTERFACE
#define INTERFACE   IAMCertifiedOutputProtection
DECLARE_INTERFACE_( IAMCertifiedOutputProtection, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMCertifiedOutputProtection methods */
    STDMETHOD( KeyExchange )( THIS_ GUID *, BYTE **, DWORD * ) PURE;
    STDMETHOD( SessionSequenceStart )( THIS_ AMCOPPSignature * ) PURE;
    STDMETHOD( ProtectionCommandCommand )( THIS_ const AMCOPPCommand * ) PURE;
    STDMETHOD( ProtectionStatus )( THIS_ const AMCOPPStatusInput *, AMCOPPStatusOutput * ) PURE;
};

/* IAMAsyncReaderTimestampScaling interface */
#undef INTERFACE
#define INTERFACE   IAMAsyncReaderTimestampScaling
DECLARE_INTERFACE_( IAMAsyncReaderTimestampScaling, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMAsyncReaderTimestampScaling methods */
    STDMETHOD( GetTimestampMode )( THIS_ BOOL * ) PURE;
    STDMETHOD( SetTimestampMode )( THIS_ BOOL ) PURE;
};

/* IAMPluginControl interface */
#undef INTERFACE
#define INTERFACE   IAMPluginControl
DECLARE_INTERFACE_( IAMPluginControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IAMPluginControl methods */
    STDMETHOD( GetPreferredClsid )( THIS_ REFGUID, CLSID * ) PURE;
    STDMETHOD( GetPreferredClsidByIndex )( THIS_ DWORD, GUID *, CLSID * ) PURE;
    STDMETHOD( SetPreferredClsid )( THIS_ REFGUID, const CLSID * ) PURE;
    STDMETHOD( IsDisabled )( THIS_ REFCLSID ) PURE;
    STDMETHOD( GetDisabledByIndex )( THIS_ DWORD, CLSID * ) PURE;
    STDMETHOD( SetDisabled )( THIS_ REFCLSID, BOOL ) PURE;
    STDMETHOD( IsLegacyDisabled )( THIS_ LPCWSTR ) PURE;
};

/* IDvdControl interface */
#undef INTERFACE
#define INTERFACE   IDvdControl
DECLARE_INTERFACE_( IDvdControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdControl methods */
    STDMETHOD( TitlePlay )( THIS_ ULONG ) PURE;
    STDMETHOD( ChapterPlay )( THIS_ ULONG, ULONG ) PURE;
    STDMETHOD( TimePlay )( THIS_ ULONG, ULONG ) PURE;
    STDMETHOD( StopForResume )( THIS ) PURE;
    STDMETHOD( GoUp )( THIS ) PURE;
    STDMETHOD( TimeSearch )( THIS_ ULONG ) PURE;
    STDMETHOD( ChapterSearch )( THIS_ ULONG ) PURE;
    STDMETHOD( PrevPGSearch )( THIS ) PURE;
    STDMETHOD( TopPGSearch )( THIS ) PURE;
    STDMETHOD( NextPGSearch )( THIS ) PURE;
    STDMETHOD( ForwardScan )( THIS_ double ) PURE;
    STDMETHOD( BackwardScan )( THIS_ double ) PURE;
    STDMETHOD( MenuCall )( THIS_ DVD_MENU_ID ) PURE;
    STDMETHOD( Resume )( THIS ) PURE;
    STDMETHOD( UpperButtonSelect )( THIS ) PURE;
    STDMETHOD( LowerButtonSelect )( THIS ) PURE;
    STDMETHOD( LeftButtonSelect )( THIS ) PURE;
    STDMETHOD( RightButtonSelect )( THIS ) PURE;
    STDMETHOD( ButtonActivate )( THIS ) PURE;
    STDMETHOD( ButtonSelectAndActivate )( THIS_ ULONG ) PURE;
    STDMETHOD( StillOff )( THIS ) PURE;
    STDMETHOD( PauseOn )( THIS ) PURE;
    STDMETHOD( PauseOff )( THIS ) PURE;
    STDMETHOD( MenuLanguageSelect )( THIS_ LCID ) PURE;
    STDMETHOD( AudioStreamChange )( THIS_ ULONG ) PURE;
    STDMETHOD( SubpictureStreamChange )( THIS_ ULONG, BOOL ) PURE;
    STDMETHOD( AngleChange )( THIS_ ULONG ) PURE;
    STDMETHOD( ParentalLevelSelect )( THIS_ ULONG ) PURE;
    STDMETHOD( ParentalCountrySelect )( THIS_ WORD ) PURE;
    STDMETHOD( KaraokeAudioPresentationModeChange )( THIS_ ULONG ) PURE;
    STDMETHOD( VideoModePreferrence )( THIS_ ULONG ) PURE;
    STDMETHOD( SetRoot )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( MouseActivate )( THIS_ POINT ) PURE;
    STDMETHOD( MouseSelect )( THIS_ POINT ) PURE;
    STDMETHOD( ChapterPlayAutoStop )( THIS_ ULONG, ULONG, ULONG ) PURE;
};

/* IDvdInfo interface */
#undef INTERFACE
#define INTERFACE   IDvdInfo
DECLARE_INTERFACE_( IDvdInfo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdInfo methods */
    STDMETHOD( GetCurrentDomain )( THIS_ DVD_DOMAIN * ) PURE;
    STDMETHOD( GetCurrentLocation )( THIS_ DVD_PLAYBACK_LOCATION * ) PURE;
    STDMETHOD( GetTotalTitleTime )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetCurrentButton )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentAngle )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentAudio )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentSubpicture )( THIS_ ULONG *, ULONG *, BOOL * ) PURE;
    STDMETHOD( GetCurrentUOPS )( THIS_ VALID_UOP_SOMTHING_OR_OTHER * ) PURE;
    STDMETHOD( GetAllSPRMs )( THIS_ SPRMARRAY * ) PURE;
    STDMETHOD( GetAllGPRMs )( THIS_ GPRMARRAY * ) PURE;
    STDMETHOD( GetAudioLanguage )( THIS_ ULONG, LCID * ) PURE;
    STDMETHOD( GetSubpictureLanguage )( THIS_ ULONG, LCID * ) PURE;
    STDMETHOD( GetTitleLanguage )( THIS_ ULONG, DVD_ATR * ) PURE;
    STDMETHOD( GetVMGAttributes )( THIS_ DVD_ATR * ) PURE;
    STDMETHOD( GetCurrentVideoAttributes )( THIS_ DVD_VideoATR * ) PURE;
    STDMETHOD( GetCurrentAudioAttributes )( THIS_ DVD_AudioATR * ) PURE;
    STDMETHOD( GetCurrentSubpictureAttributes )( THIS_ DVD_SubpictureATR * ) PURE;
    STDMETHOD( GetCurrentVolumeInfo )( THIS_ ULONG *, ULONG *, DVD_DISC_SIDE *, ULONG * ) PURE;
    STDMETHOD( GetDVDTextInfo )( THIS_ BYTE *, ULONG, ULONG * ) PURE;
    STDMETHOD( GetPlayerParentalLevel )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetNumberOfChapters )( THIS_ ULONG, ULONG * ) PURE;
    STDMETHOD( GetTitleParentalLevels )( THIS_ ULONG, ULONG * ) PURE;
    STDMETHOD( GetRoot )( THIS_ LPSTR, ULONG, ULONG * ) PURE;
};

/* IDvdCmd interface */
#undef INTERFACE
#define INTERFACE   IDvdCmd
DECLARE_INTERFACE_( IDvdCmd, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdCmd methods */
    STDMETHOD( WaitForStart )( THIS ) PURE;
    STDMETHOD( WaitForEnd )( THIS ) PURE;
};

/* IDvdState interface */
#undef INTERFACE
#define INTERFACE   IDvdState
DECLARE_INTERFACE_( IDvdState, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdState methods */
    STDMETHOD( GetDiscID )( THIS_ ULONGLONG * ) PURE;
    STDMETHOD( GetParentalLevel )( THIS_ ULONG * ) PURE;
};

/* IDvdControl2 interface */
#undef INTERFACE
#define INTERFACE   IDvdControl2
DECLARE_INTERFACE_( IDvdControl2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdControl2 methods */
    STDMETHOD( PlayTitle )( THIS_ ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayChapterInTitle )( THIS_ ULONG, ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayAtTimeInTitle )( THIS_ ULONG, DVD_HMSF_TIMECODE *, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( Stop )( THIS ) PURE;
    STDMETHOD( ReturnFromSubmenu )( THIS_ DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayAtTime )( THIS_ DVD_HMSF_TIMECODE *, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayChapter )( THIS_ ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayPrevChapter )( THIS_ DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( ReplayChapter )( THIS_ DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayNextChapter )( THIS_ DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayForwards )( THIS_ double, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayBackwards )( THIS_ double, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( ShowMenu )( THIS_ DVD_MENU_ID, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( Resume )( THIS_ DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SelectRelativeButton )( THIS_ DVD_RELATIVE_BUTTON ) PURE;
    STDMETHOD( ActivateButton )( THIS ) PURE;
    STDMETHOD( SelectButton )( THIS_ ULONG ) PURE;
    STDMETHOD( SelectAndActivateButton )( THIS_ ULONG ) PURE;
    STDMETHOD( StillOff )( THIS ) PURE;
    STDMETHOD( Pause )( THIS_ BOOL ) PURE;
    STDMETHOD( SelectAudioStream )( THIS_ ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SelectSubpictureStream )( THIS_ ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SetSubpictureState )( THIS_ BOOL, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SelectAngle )( THIS_ ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SelectParentalLevel )( THIS_ ULONG ) PURE;
    STDMETHOD( SelectParentalCountry )( THIS_ BYTE [2] ) PURE;
    STDMETHOD( SelectKarokeAudioPresentationMode )( THIS_ ULONG ) PURE;
    STDMETHOD( SelectVideoModePreference )( THIS_ ULONG ) PURE;
    STDMETHOD( SetDVDDirectory )( THIS_ LPCWSTR ) PURE;
    STDMETHOD( ActivateAtPosition )( THIS_ POINT ) PURE;
    STDMETHOD( SelectAtPosition )( THIS_ POINT ) PURE;
    STDMETHOD( PlayChaptersAutoStop )( THIS_ ULONG, ULONG, ULONG, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( AcceptParentalLevelChange )( THIS_ BOOL ) PURE;
    STDMETHOD( SetOption )( THIS_ DVD_OPTION_FLAG, BOOL ) PURE;
    STDMETHOD( SetState )( THIS_ IDvdState *, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( PlayPeriodInTitleAutoStop )( THIS_ ULONG, DVD_HMSF_TIMECODE *, DVD_HMSF_TIMECODE *, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SetGPRM )( THIS_ ULONG, WORD, DWORD, IDvdCmd ** ) PURE;
    STDMETHOD( SelectDefaultMenuLanguage )( THIS_ LCID ) PURE;
    STDMETHOD( SelectDefaultAudioLanguage )( THIS_ LCID, DVD_AUDIO_LANG_EXT ) PURE;
    STDMETHOD( SelectDefaultSubpictureLanguage )( THIS_ LCID, DVD_SUBPICTURE_LANG_EXT ) PURE;
};

/* IDvdInfo2 interface */
#undef INTERFACE
#define INTERFACE   IDvdInfo2
DECLARE_INTERFACE_( IDvdInfo2, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdInfo2 methods */
    STDMETHOD( GetCurrentDomain )( THIS_ DVD_DOMAIN * ) PURE;
    STDMETHOD( GetCurrentLocation )( THIS_ DVD_PLAYBACK_LOCATION2 * ) PURE;
    STDMETHOD( GetTotalTitleTime )( THIS_ DVD_HMSF_TIMECODE *, ULONG * ) PURE;
    STDMETHOD( GetCurrentButton )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentAngle )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentAudio )( THIS_ ULONG *, ULONG * ) PURE;
    STDMETHOD( GetCurrentSubpicture )( THIS_ ULONG *, ULONG *, BOOL * ) PURE;
    STDMETHOD( GetCurrentUOPS )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetAllSPRMs )( THIS_ SPRMARRAY * ) PURE;
    STDMETHOD( GetAllGPRMs )( THIS_ GPRMARRAY * ) PURE;
    STDMETHOD( GetAudioLanguage )( THIS_ ULONG, LCID * ) PURE;
    STDMETHOD( GetSubpictureLanguage )( THIS_ ULONG, LCID * ) PURE;
    STDMETHOD( GetTitleAttributes )( THIS_ ULONG, DVD_MenuAttributes *, DVD_TitleAttributes * ) PURE;
    STDMETHOD( GetVMGAttributes )( THIS_ DVD_MenuAttributes * ) PURE;
    STDMETHOD( GetCurrentVideoAttributes )( THIS_ DVD_VideoAttributes * ) PURE;
    STDMETHOD( GetAudioAttributes )( THIS_ ULONG, DVD_AudioAttributes * ) PURE;
    STDMETHOD( GetKaraokeAttributes )( THIS_ ULONG, DVD_KaraokeAttributes * ) PURE;
    STDMETHOD( GetSubpictureAttributes )( THIS_ ULONG, DVD_SubpictureAttributes * ) PURE;
    STDMETHOD( GetDVDVolumeInfo )( THIS_ ULONG *, ULONG *, DVD_DISC_SIDE *, ULONG * ) PURE;
    STDMETHOD( GetDVDTextNumberOfLanguages )( THIS_ ULONG * ) PURE;
    STDMETHOD( GetDVDTextLanguageInfo )( THIS_ ULONG, ULONG *, LCID *, enum DVD_TextCharSet * ) PURE;
    STDMETHOD( GetDVDTextStringAsNative )( THIS_ ULONG, ULONG, BYTE *, ULONG, ULONG *, enum DVD_TextStringType * ) PURE;
    STDMETHOD( GetDVDTextStringAsUnicode )( THIS_ ULONG, ULONG, WCHAR *, ULONG, ULONG *, enum DVD_TextStringType * ) PURE;
    STDMETHOD( GetPlayerParentalLevel )( THIS_ ULONG *, BYTE [2] ) PURE;
    STDMETHOD( GetNumberOfChapters )( THIS_ ULONG, ULONG * ) PURE;
    STDMETHOD( GetTitleParentalLevels )( THIS_ ULONG, ULONG * ) PURE;
    STDMETHOD( GetDVDDirectory )( THIS_ LPWSTR, ULONG, ULONG * ) PURE;
    STDMETHOD( IsAudioStreamEnabled )( THIS_ ULONG, BOOL * ) PURE;
    STDMETHOD( GetDiscID )( THIS_ LPCWSTR, ULONGLONG * ) PURE;
    STDMETHOD( GetState )( THIS_ IDvdState ** ) PURE;
    STDMETHOD( GetMenuLanguages )( THIS_ LCID *, ULONG, ULONG * ) PURE;
    STDMETHOD( GetButtonAtPosition )( THIS_ POINT, ULONG * ) PURE;
    STDMETHOD( GetCmdFromIndex )( THIS_ LONG_PTR, IDvdCmd ** ) PURE;
    STDMETHOD( GetDefaultMenuLanguage )( THIS_ LCID * ) PURE;
    STDMETHOD( GetDefaultAudioLanguage )( THIS_ LCID *, DVD_AUDIO_LANG_EXT * ) PURE;
    STDMETHOD( GetDefaultSubpictureLanguage )( THIS_ LCID *, DVD_SUBPICTURE_LANG_EXT * ) PURE;
    STDMETHOD( GetDecoderCaps )( THIS_ DVD_DECODER_CAPS * ) PURE;
    STDMETHOD( GetButtonRect )( THIS_ ULONG, RECT * ) PURE;
    STDMETHOD( IsSubpictureStreamEnabled )( THIS_ ULONG, BOOL * ) PURE;
};

/* IDvdGraphBuilder interface */
#undef INTERFACE
#define INTERFACE   IDvdGraphBuilder
DECLARE_INTERFACE_( IDvdGraphBuilder, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDvdGraphBuilder methods */
    STDMETHOD( GetFiltergraph )( THIS_ IGraphBuilder ** ) PURE;
    STDMETHOD( GetDvdInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD( RenderDvdVideoVolume )( THIS_ LPCWSTR, DWORD, AM_DVD_RENDERSTATUS * ) PURE;
};

/* IDDrawExclModeVideo interface */
#undef INTERFACE
#define INTERFACE   IDDrawExclModeVideo
DECLARE_INTERFACE_( IDDrawExclModeVideo, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDDrawExclModeVideo methods */
    STDMETHOD( SetDDrawObject )( THIS_ IDirectDraw * ) PURE;
    STDMETHOD( GetDDrawObject )( THIS_ IDirectDraw **, BOOL * ) PURE;
    STDMETHOD( SetDDrawSurface )( THIS_ IDirectDrawSurface * ) PURE;
    STDMETHOD( GetDDrawSurface )( THIS_ IDirectDrawSurface **, BOOL * ) PURE;
    STDMETHOD( SetDrawParameters )( THIS_ const RECT *, const RECT * ) PURE;
    STDMETHOD( GetNativeVideoProps )( THIS_ DWORD *, DWORD *, DWORD *, DWORD * ) PURE;
    STDMETHOD( SetCallbackInterface )( THIS_ IDDrawExclModeVideoCallback *, DWORD ) PURE;
};

/* IDDrawExclModeVideoCallback interface */
#undef INTERFACE
#define INTERFACE   IDDrawExclModeVideoCallback
DECLARE_INTERFACE_( IDDrawExclModeVideoCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IDDrawExclModeVideoCallback methods */
    STDMETHOD( OnUpdateOverlay )( THIS_ BOOL, DWORD, BOOL, const RECT *, const RECT *, BOOL, const RECT *, const RECT * ) PURE;
    STDMETHOD( OnUpdateColorKey )( THIS_ const COLORREF *, DWORD ) PURE;
    STDMETHOD( OnUpdateSize )( THIS_ DWORD, DWORD, DWORD, DWORD ) PURE;
};

/* IPinConnection interface */
#undef INTERFACE
#define INTERFACE   IPinConnection
DECLARE_INTERFACE_( IPinConnection, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPinConnection methods */
    STDMETHOD( DynamicQueryAccept )( THIS_ const AM_MEDIA_TYPE * ) PURE;
    STDMETHOD( NotifyEndOfStream )( THIS_ HANDLE ) PURE;
    STDMETHOD( IsEndPin )( THIS ) PURE;
    STDMETHOD( DynamicDisconnect )( THIS ) PURE;
};

/* IPinFlowControl interface */
#undef INTERFACE
#define INTERFACE   IPinFlowControl
DECLARE_INTERFACE_( IPinFlowControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IPinFlowControl methods */
    STDMETHOD( Block )( THIS_ DWORD, HANDLE ) PURE;
};

/* IGraphConfig interface */
#undef INTERFACE
#define INTERFACE   IGraphConfig
DECLARE_INTERFACE_( IGraphConfig, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IGraphConfig methods */
    STDMETHOD( Reconnect )( THIS_ IPin *, IPin *, const AM_MEDIA_TYPE *, IBaseFilter *, HANDLE, DWORD ) PURE;
    STDMETHOD( Reconfigure )( THIS_ IGraphConfigCallback *, PVOID, DWORD, HANDLE ) PURE;
    STDMETHOD( AddFilterToCache )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( EnumCacheFilter )( THIS_ IEnumFilters ** ) PURE;
    STDMETHOD( RemoveFilterFromCache )( THIS_ IBaseFilter * ) PURE;
    STDMETHOD( GetStartTime )( THIS_ REFERENCE_TIME * ) PURE;
    STDMETHOD( PushThroughData )( THIS_ IPin *, IPinConnection *, HANDLE ) PURE;
    STDMETHOD( SetFilterFlags )( THIS_ IBaseFilter *, DWORD ) PURE;
    STDMETHOD( GetFilterFlags )( THIS_ IBaseFilter *, DWORD * ) PURE;
    STDMETHOD( RemoveFilterEx )( THIS_ IBaseFilter *, DWORD ) PURE;
};

/* IGraphConfigCallback interface */
#undef INTERFACE
#define INTERFACE   IGraphConfigCallback
DECLARE_INTERFACE_( IGraphConfigCallback, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IGraphConfigCallback methods */
    STDMETHOD( Reconfigure )( THIS_ PVOID, DWORD ) PURE;
};

/* IFilterChain interface */
#undef INTERFACE
#define INTERFACE   IFilterChain
DECLARE_INTERFACE_( IFilterChain, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IFilterChain methods */
    STDMETHOD( StartChain )( THIS_ IBaseFilter *, IBaseFilter * ) PURE;
    STDMETHOD( PauseChain )( THIS_ IBaseFilter *, IBaseFilter * ) PURE;
    STDMETHOD( StopChain )( THIS_ IBaseFilter *, IBaseFilter * ) PURE;
    STDMETHOD( RemoveChain )( THIS_ IBaseFilter *, IBaseFilter * ) PURE;
};

/* IVMRImagePresenter interface */
#undef INTERFACE
#define INTERFACE   IVMRImagePresenter
DECLARE_INTERFACE_( IVMRImagePresenter, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRImagePresenter methods */
    STDMETHOD( StartPresenting )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( StopPresenting )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( PresentImage )( THIS_ DWORD_PTR, VMRPRESENTATIONINFO * ) PURE;
};

/* IVMRSurfaceAllocator interface */
#undef INTERFACE
#define INTERFACE   IVMRSurfaceAllocator
DECLARE_INTERFACE_( IVMRSurfaceAllocator, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRSurfaceAllocator methods */
    STDMETHOD( AllocateSurface )( THIS_ DWORD_PTR, VMRALLOCATIONINFO *, DWORD *, LPDIRECTDRAWSURFACE7 * ) PURE;
    STDMETHOD( FreeSurface )( THIS_ DWORD_PTR ) PURE;
    STDMETHOD( PrepareSurface )( THIS_ DWORD_PTR, LPDIRECTDRAWSURFACE7, DWORD ) PURE;
    STDMETHOD( AdviseNotify )( THIS_ IVMRSurfaceAllocatorNotify * ) PURE;
};

/* IVMRSurfaceAllocatorNotify interface */
#undef INTERFACE
#define INTERFACE   IVMRSurfaceAllocatorNotify
DECLARE_INTERFACE_( IVMRSurfaceAllocatorNotify, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRSurfaceAllocatorNotify methods */
    STDMETHOD( AdviseSurfaceAllocator )( THIS_ DWORD_PTR, IVMRSurfaceAllocator * ) PURE;
    STDMETHOD( SetDDrawDevice )( THIS_ LPDIRECTDRAW7, HMONITOR ) PURE;
    STDMETHOD( ChangeDDrawDevice )( THIS_ LPDIRECTDRAW7, HMONITOR ) PURE;
    STDMETHOD( RestoreDDrawSurfaces )( THIS ) PURE;
    STDMETHOD( NotifyEvent )( THIS_ LONG, LONG_PTR, LONG_PTR ) PURE;
    STDMETHOD( SetBorderColor )( THIS_ COLORREF ) PURE;
};

/* IVMRWindowlessControl interface */
#undef INTERFACE
#define INTERFACE   IVMRWindowlessControl
DECLARE_INTERFACE_( IVMRWindowlessControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRWindowlessControl methods */
    STDMETHOD( GetNativeVideoSize )( THIS_ LONG *, LONG *, LONG *, LONG * ) PURE;
    STDMETHOD( GetMinIdealVideoSize )( THIS_ LONG *, LONG * ) PURE;
    STDMETHOD( GetMaxIdealVideoSize )( THIS_ LONG *, LONG * ) PURE;
    STDMETHOD( SetVideoPosition )( THIS_ const LPRECT, const LPRECT ) PURE;
    STDMETHOD( GetVideoPosition )( THIS_ LPRECT, LPRECT ) PURE;
    STDMETHOD( GetAspectRatioMode )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetAspectRatioMode )( THIS_ DWORD ) PURE;
    STDMETHOD( SetVideoClippingWindow )( THIS_ HWND ) PURE;
    STDMETHOD( RepaintVideo )( THIS_ HWND, HDC ) PURE;
    STDMETHOD( DisplayModeChanged )( THIS ) PURE;
    STDMETHOD( GetCurrentImage )( THIS_ BYTE ** ) PURE;
    STDMETHOD( SetBorderColor )( THIS_ COLORREF ) PURE;
    STDMETHOD( GetBorderColor )( THIS_ COLORREF * ) PURE;
    STDMETHOD( SetColorKey )( THIS_ COLORREF ) PURE;
    STDMETHOD( GetColorKey )( THIS_ COLORREF * ) PURE;
};

/* IVMRMixerControl interface */
#undef INTERFACE
#define INTERFACE   IVMRMixerControl
DECLARE_INTERFACE_( IVMRMixerControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRMixerControl methods */
    STDMETHOD( SetAlpha )( THIS_ DWORD, float ) PURE;
    STDMETHOD( GetAlpha )( THIS_ DWORD, float * ) PURE;
    STDMETHOD( SetZOrder )( THIS_ DWORD, DWORD ) PURE;
    STDMETHOD( GetZOrder )( THIS_ DWORD, DWORD * ) PURE;
    STDMETHOD( SetOutputRect )( THIS_ DWORD, const NORMALIZEDRECT * ) PURE;
    STDMETHOD( GetOutputRect )( THIS_ DWORD, NORMALIZEDRECT * ) PURE;
    STDMETHOD( SetBackgroundClr )( THIS_ COLORREF ) PURE;
    STDMETHOD( GetBackgroundClr )( THIS_ COLORREF * ) PURE;
    STDMETHOD( SetMixingPrefs )( THIS_ DWORD ) PURE;
    STDMETHOD( GetMixingPrefs )( THIS_ DWORD * ) PURE;
};

/* IVMRMonitorConfig interface */
#undef INTERFACE
#define INTERFACE   IVMRMonitorConfig
DECLARE_INTERFACE_( IVMRMonitorConfig, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRMonitorConfig methods */
    STDMETHOD( SetMonitor )( THIS_ const VMRGUID * ) PURE;
    STDMETHOD( GetMonitor )( THIS_ VMRGUID * ) PURE;
    STDMETHOD( SetDefaultMonitor )( THIS_ const VMRGUID * ) PURE;
    STDMETHOD( GetDefaultMonitor )( THIS_ VMRGUID * ) PURE;
    STDMETHOD( GetAvailableMonitors )( THIS_ VMRMONITORINFO *, DWORD, DWORD * ) PURE;
};

/* IVMRFilterConfig interface */
#undef INTERFACE
#define INTERFACE   IVMRFilterConfig
DECLARE_INTERFACE_( IVMRFilterConfig, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRFilterConfig methods */
    STDMETHOD( SetImageCompositor )( THIS_ IVMRImageCompositor * ) PURE;
    STDMETHOD( SetNumberOfStreams )( THIS_ DWORD ) PURE;
    STDMETHOD( GetNumberOfStreams )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetRenderingPrefs )( THIS_ DWORD ) PURE;
    STDMETHOD( GetRenderingPrefs )( THIS_ DWORD * ) PURE;
    STDMETHOD( SetRenderingMode )( THIS_ DWORD ) PURE;
    STDMETHOD( GetRenderingMode )( THIS_ DWORD * ) PURE;
};

/* IVMRAspectRatioControl interface */
#undef INTERFACE
#define INTERFACE   IVMRAspectRatioControl
DECLARE_INTERFACE_( IVMRAspectRatioControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRAspectRatioControl methods */
    STDMETHOD( GetAspectRatioControl )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetAspectRatioControl )( THIS_ DWORD ) PURE;
};

/* IVMRDeinterlaceControl interface */
#undef INTERFACE
#define INTERFACE   IVMRDeinterlaceControl
DECLARE_INTERFACE_( IVMRDeinterlaceControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRDeinterlaceControl methods */
    STDMETHOD( GetNumberOfDeinterlaceModes )( THIS_ VMRVideoDesc *, LPDWORD, LPGUID ) PURE;
    STDMETHOD( GetDeinterlaceModeCaps )( THIS_ LPGUID, VMRVideoDesc *, VMRDeinterlaceCaps * ) PURE;
    STDMETHOD( GetDeinterlaceMode )( THIS_ DWORD, LPGUID ) PURE;
    STDMETHOD( SetDeinterlaceMode )( THIS_ DWORD, LPGUID ) PURE;
    STDMETHOD( GetDeinterlacePrefs )( THIS_ LPDWORD ) PURE;
    STDMETHOD( SetDeinterlacePrefs )( THIS_ DWORD ) PURE;
    STDMETHOD( GetActualDeinterlaceMode )( THIS_ DWORD, LPGUID ) PURE;
};

/* IVMRMixerBitmap interface */
#undef INTERFACE
#define INTERFACE   IVMRMixerBitmap
DECLARE_INTERFACE_( IVMRMixerBitmap, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRMixerBitmap methods */
    STDMETHOD( SetAlphaBitmap )( THIS_ const VMRALPHABITMAP * ) PURE;
    STDMETHOD( UpdateAlphaBitmapParameters )( THIS_ PVMRALPHABITMAP ) PURE;
    STDMETHOD( GetAlphaBitmapParameters )( THIS_ PVMRALPHABITMAP ) PURE;
};

/* IVMRImageCompositor interface */
#undef INTERFACE
#define INTERFACE   IVMRImageCompositor
DECLARE_INTERFACE_( IVMRImageCompositor, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRImageCompositor methods */
    STDMETHOD( InitCompositionTarget )( THIS_ IUnknown *, LPDIRECTDRAWSURFACE7 ) PURE;
    STDMETHOD( TermCompositionTarget )( THIS_ IUnknown *, LPDIRECTDRAWSURFACE7 ) PURE;
    STDMETHOD( SetStreamMediaType )( THIS_ DWORD, AM_MEDIA_TYPE *, BOOL ) PURE;
    STDMETHOD( CompositeImage )( THIS_ IUnknown *, LPDIRECTDRAWSURFACE7, AM_MEDIA_TYPE *, REFERENCE_TIME, REFERENCE_TIME, DWORD, VMRVIDEOSTREAMINFO *, UINT ) PURE;
};

/* IVMRVideoStreamControl interface */
#undef INTERFACE
#define INTERFACE   IVMRVideoStreamControl
DECLARE_INTERFACE_( IVMRVideoStreamControl, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRVideoStreamControl methods */
    STDMETHOD( SetColorKey )( THIS_ LPDDCOLORKEY ) PURE;
    STDMETHOD( GetColorKey )( THIS_ LPDDCOLORKEY ) PURE;
    STDMETHOD( SetStreamActiveState )( THIS_ BOOL ) PURE;
    STDMETHOD( GetStreamActiveState )( THIS_ BOOL * ) PURE;
};

/* IVMRSurface interface */
#undef INTERFACE
#define INTERFACE   IVMRSurface
DECLARE_INTERFACE_( IVMRSurface, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRSurface methods */
    STDMETHOD( IsSurfaceLocked )( THIS ) PURE;
    STDMETHOD( LockSurface )( THIS_ BYTE ** ) PURE;
    STDMETHOD( UnlockSurface )( THIS ) PURE;
    STDMETHOD( GetSurface )( THIS_ LPDIRECTDRAWSURFACE7 * ) PURE;
};

/* IVMRImagePresenterConfig interface */
#undef INTERFACE
#define INTERFACE   IVMRImagePresenterConfig
DECLARE_INTERFACE_( IVMRImagePresenterConfig, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRImagePresenterConfig methods */
    STDMETHOD( SetRenderingPrefs )( THIS_ DWORD ) PURE;
    STDMETHOD( GetRenderingPrefs )( THIS_ DWORD * ) PURE;
};

/* IVMRImagePresenterExclModeConfig interface */
#undef INTERFACE
#define INTERFACE   IVMRImagePresenterExclModeConfig
DECLARE_INTERFACE_( IVMRImagePresenterExclModeConfig, IVMRImagePresenterConfig ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVMRImagePresenterConfig methods */
    STDMETHOD( SetRenderingPrefs )( THIS_ DWORD ) PURE;
    STDMETHOD( GetRenderingPrefs )( THIS_ DWORD * ) PURE;

    /* IVMRImagePresenterExclModeConfig methods */
    STDMETHOD( SetXlcModeDDObjAndPrimarySurface )( THIS_ LPDIRECTDRAW7, LPDIRECTDRAWSURFACE7 ) PURE;
    STDMETHOD( GetXlcModeDDObjAndPrimarySurface )( THIS_ LPDIRECTDRAW7 *, LPDIRECTDRAWSURFACE7 * ) PURE;
};

/* IVPManager interface */
#undef INTERFACE
#define INTERFACE   IVPManager
DECLARE_INTERFACE_( IVPManager, IUnknown ) {
    /* IUnknown methods */
    STDMETHOD( QueryInterface )( THIS_ REFIID, void ** ) PURE;
    STDMETHOD_( ULONG, AddRef )( THIS ) PURE;
    STDMETHOD_( ULONG, Release )( THIS ) PURE;

    /* IVPManager methods */
    STDMETHOD( SetVideoPortIndex )( THIS_ DWORD ) PURE;
    STDMETHOD( GetVideoPortIndex )( THIS_ DWORD * ) PURE;
};

/* C object macros */
#if (!defined( __cplusplus ) || defined( CINTERFACE )) && defined( COBJMACROS )
    #define ICreateDevEnum_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICreateDevEnum_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICreateDevEnum_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICreateDevEnum_CreateClassEnumerator( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateClassEnumerator( x, p1, p2, p3 )
    #define IPin_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPin_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPin_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPin_Connect( x, p1, p2 ) \
        (x)->lpVtbl->Connect( x, p1, p2 )
    #define IPin_ReceiveConnection( x, p1, p2 ) \
        (x)->lpVtbl->ReceiveConnection( x, p1, p2 )
    #define IPin_Disconnect( x ) \
        (x)->lpVtbl->Disconnect( x )
    #define IPin_ConnectedTo( x, p ) \
        (x)->lpVtbl->ConnectedTo( x, p )
    #define IPin_ConnectionMediaType( x, p ) \
        (x)->lpVtbl->ConnectionMediaType( x, p )
    #define IPin_QueryPinInfo( x, p ) \
        (x)->lpVtbl->QueryPinInfo( x, p )
    #define IPin_QueryDirection( x, p ) \
        (x)->lpVtbl->QueryDirection( x, p )
    #define IPin_QueryId( x, p ) \
        (x)->lpVtbl->QueryId( x, p )
    #define IPin_QueryAccept( x, p ) \
        (x)->lpVtbl->QueryAccept( x, p )
    #define IPin_EnumMediaTypes( x, p ) \
        (x)->lpVtbl->EnumMediaTypes( x, p )
    #define IPin_EnumInternalConnections( x, p1, p2 ) \
        (x)->lpVtbl->EnumInternalConnections( x, p1, p2 )
    #define IPin_EndOfStream( x ) \
        (x)->lpVtbl->EndOfStream( x )
    #define IPin_BeginFlush( x ) \
        (x)->lpVtbl->BeginFlush( x )
    #define IPin_EndFlush( x ) \
        (x)->lpVtbl->EndFlush( x )
    #define IPin_NewSegment( x, p1, p2, p3 ) \
        (x)->lpVtbl->NewSegment( x, p1, p2, p3 )
    #define IEnumPins_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumPins_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumPins_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumPins_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumPins_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumPins_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumPins_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IEnumMediaTypes_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumMediaTypes_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumMediaTypes_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumMediaTypes_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumMediaTypes_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumMediaTypes_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumMediaTypes_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IFilterGraph_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterGraph_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterGraph_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterGraph_AddFilter( x, p1, p2 ) \
        (x)->lpVtbl->AddFilter( x, p1, p2 )
    #define IFilterGraph_RemoveFilter( x, p ) \
        (x)->lpVtbl->RemoveFilter( x, p )
    #define IFilterGraph_EnumFilters( x, p ) \
        (x)->lpVtbl->EnumFilters( x, p )
    #define IFilterGraph_FindFilterByName( x, p1, p2 ) \
        (x)->lpVtbl->FindFilterByName( x, p1, p2 )
    #define IFilterGraph_ConnectDirect( x, p1, p2, p3 ) \
        (x)->lpVtbl->ConnectDirect( x, p1, p2, p3 )
    #define IFilterGraph_Reconnect( x, p ) \
        (x)->lpVtbl->Reconnect( x, p )
    #define IFilterGraph_Disconnect( x, p ) \
        (x)->lpVtbl->Disconnect( x, p )
    #define IFilterGraph_SetDefaultSyncSource( x ) \
        (x)->lpVtbl->SetDefaultSyncSource( x )
    #define IEnumFilters_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumFilters_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumFilters_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumFilters_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumFilters_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumFilters_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumFilters_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IMediaFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaFilter_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IMediaFilter_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IMediaFilter_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IMediaFilter_Run( x, p ) \
        (x)->lpVtbl->Run( x, p )
    #define IMediaFilter_GetState( x, p1, p2 ) \
        (x)->lpVtbl->GetState( x, p1, p2 )
    #define IMediaFilter_SetSyncSource( x, p ) \
        (x)->lpVtbl->SetSyncSource( x, p )
    #define IMediaFilter_GetSyncSource( x, p ) \
        (x)->lpVtbl->GetSyncSource( x, p )
    #define IBaseFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBaseFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBaseFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBaseFilter_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IBaseFilter_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IBaseFilter_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IBaseFilter_Run( x, p ) \
        (x)->lpVtbl->Run( x, p )
    #define IBaseFilter_GetState( x, p1, p2 ) \
        (x)->lpVtbl->GetState( x, p1, p2 )
    #define IBaseFilter_SetSyncSource( x, p ) \
        (x)->lpVtbl->SetSyncSource( x, p )
    #define IBaseFilter_GetSyncSource( x, p ) \
        (x)->lpVtbl->GetSyncSource( x, p )
    #define IBaseFilter_EnumPins( x, p ) \
        (x)->lpVtbl->EnumPins( x, p )
    #define IBaseFilter_FindPin( x, p1, p2 ) \
        (x)->lpVtbl->FindPin( x, p1, p2 )
    #define IBaseFilter_QueryFilterInfo( x, p ) \
        (x)->lpVtbl->QueryFilterInfo( x, p )
    #define IBaseFilter_JoinFilterGraph( x, p1, p2 ) \
        (x)->lpVtbl->JoinFilterGraph( x, p1, p2 )
    #define IBaseFilter_QueryVendorInfo( x, p ) \
        (x)->lpVtbl->QueryVendorInfo( x, p )
    #define IReferenceClock_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IReferenceClock_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IReferenceClock_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IReferenceClock_GetTime( x, p ) \
        (x)->lpVtbl->GetTime( x, p )
    #define IReferenceClock_AdviseTime( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AdviseTime( x, p1, p2, p3, p4 )
    #define IReferenceClock_AdvisePeriodic( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AdvisePeriodic( x, p1, p2, p3, p4 )
    #define IReferenceClock_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IReferenceClockTimerControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IReferenceClockTimerControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IReferenceClockTimerControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IReferenceClockTimerControl_SetDefaultTimerResolution( x, p ) \
        (x)->lpVtbl->SetDefaultTimerResolution( x, p )
    #define IReferenceClockTimerControl_GetDefaultTimerResolution( x, p ) \
        (x)->lpVtbl->GetDefaultTimerResolution( x, p )
    #define IReferenceClock2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IReferenceClock2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IReferenceClock2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IReferenceClock2_GetTime( x, p ) \
        (x)->lpVtbl->GetTime( x, p )
    #define IReferenceClock2_AdviseTime( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AdviseTime( x, p1, p2, p3, p4 )
    #define IReferenceClock2_AdvisePeriodic( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AdvisePeriodic( x, p1, p2, p3, p4 )
    #define IReferenceClock2_Unadvise( x, p ) \
        (x)->lpVtbl->Unadvise( x, p )
    #define IMediaSample_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaSample_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaSample_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaSample_GetPointer( x, p ) \
        (x)->lpVtbl->GetPointer( x, p )
    #define IMediaSample_GetSize( x ) \
        (x)->lpVtbl->GetSize( x )
    #define IMediaSample_GetTime( x, p1, p2 ) \
        (x)->lpVtbl->GetTime( x, p1, p2 )
    #define IMediaSample_SetTime( x, p1, p2 ) \
        (x)->lpVtbl->SetTime( x, p1, p2 )
    #define IMediaSample_IsSyncPoint( x ) \
        (x)->lpVtbl->IsSyncPoint( x )
    #define IMediaSample_SetSyncPoint( x, p ) \
        (x)->lpVtbl->SetSyncPoint( x, p )
    #define IMediaSample_IsPreroll( x ) \
        (x)->lpVtbl->IsPreroll( x )
    #define IMediaSample_SetPreroll( x, p ) \
        (x)->lpVtbl->SetPreroll( x, p )
    #define IMediaSample_GetActualDataLength( x ) \
        (x)->lpVtbl->GetActualDataLength( x )
    #define IMediaSample_SetActualDataLength( x, p ) \
        (x)->lpVtbl->SetActualDataLength( x, p )
    #define IMediaSample_GetMediaType( x, p ) \
        (x)->lpVtbl->GetMediaType( x, p )
    #define IMediaSample_SetMediaType( x, p ) \
        (x)->lpVtbl->SetMediaType( x, p )
    #define IMediaSample_IsDiscontinuity( x ) \
        (x)->lpVtbl->IsDiscontinuity( x )
    #define IMediaSample_SetDiscontinuity( x, p ) \
        (x)->lpVtbl->SetDiscontinuity( x, p )
    #define IMediaSample_GetMediaTime( x, p1, p2 ) \
        (x)->lpVtbl->GetMediaTime( x, p1, p2 )
    #define IMediaSample_SetMediaTime( x, p1, p2 ) \
        (x)->lpVtbl->SetMediaTime( x, p1, p2 )
    #define IMediaSample2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaSample2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaSample2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaSample2_GetPointer( x, p ) \
        (x)->lpVtbl->GetPointer( x, p )
    #define IMediaSample2_GetSize( x ) \
        (x)->lpVtbl->GetSize( x )
    #define IMediaSample2_GetTime( x, p1, p2 ) \
        (x)->lpVtbl->GetTime( x, p1, p2 )
    #define IMediaSample2_SetTime( x, p1, p2 ) \
        (x)->lpVtbl->SetTime( x, p1, p2 )
    #define IMediaSample2_IsSyncPoint( x ) \
        (x)->lpVtbl->IsSyncPoint( x )
    #define IMediaSample2_SetSyncPoint( x, p ) \
        (x)->lpVtbl->SetSyncPoint( x, p )
    #define IMediaSample2_IsPreroll( x ) \
        (x)->lpVtbl->IsPreroll( x )
    #define IMediaSample2_SetPreroll( x, p ) \
        (x)->lpVtbl->SetPreroll( x, p )
    #define IMediaSample2_GetActualDataLength( x ) \
        (x)->lpVtbl->GetActualDataLength( x )
    #define IMediaSample2_SetActualDataLength( x, p ) \
        (x)->lpVtbl->SetActualDataLength( x, p )
    #define IMediaSample2_GetMediaType( x, p ) \
        (x)->lpVtbl->GetMediaType( x, p )
    #define IMediaSample2_SetMediaType( x, p ) \
        (x)->lpVtbl->SetMediaType( x, p )
    #define IMediaSample2_IsDiscontinuity( x ) \
        (x)->lpVtbl->IsDiscontinuity( x )
    #define IMediaSample2_SetDiscontinuity( x, p ) \
        (x)->lpVtbl->SetDiscontinuity( x, p )
    #define IMediaSample2_GetMediaTime( x, p1, p2 ) \
        (x)->lpVtbl->GetMediaTime( x, p1, p2 )
    #define IMediaSample2_SetMediaTime( x, p1, p2 ) \
        (x)->lpVtbl->SetMediaTime( x, p1, p2 )
    #define IMediaSample2_GetProperties( x, p1, p2 ) \
        (x)->lpVtbl->GetProperties( x, p1, p2 )
    #define IMediaSample2_SetProperties( x, p1, p2 ) \
        (x)->lpVtbl->SetProperties( x, p1, p2 )
    #define IMediaSample2Config_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaSample2Config_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaSample2Config_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaSample2Config_GetSurface( x, p ) \
        (x)->lpVtbl->GetSurface( x, p )
    #define IMemAllocator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMemAllocator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMemAllocator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMemAllocator_SetProperties( x, p1, p2 ) \
        (x)->lpVtbl->SetProperties( x, p1, p2 )
    #define IMemAllocator_GetProperties( x, p ) \
        (x)->lpVtbl->GetProperties( x, p )
    #define IMemAllocator_Commit( x ) \
        (x)->lpVtbl->Commit( x )
    #define IMemAllocator_Decommit( x ) \
        (x)->lpVtbl->Decommit( x )
    #define IMemAllocator_GetBuffer( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2, p3, p4 )
    #define IMemAllocator_ReleaseBuffer( x, p ) \
        (x)->lpVtbl->ReleaseBuffer( x, p )
    #define IMemAllocatorCallbackTemp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMemAllocatorCallbackTemp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMemAllocatorCallbackTemp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMemAllocatorCallbackTemp_SetProperties( x, p1, p2 ) \
        (x)->lpVtbl->SetProperties( x, p1, p2 )
    #define IMemAllocatorCallbackTemp_GetProperties( x, p ) \
        (x)->lpVtbl->GetProperties( x, p )
    #define IMemAllocatorCallbackTemp_Commit( x ) \
        (x)->lpVtbl->Commit( x )
    #define IMemAllocatorCallbackTemp_Decommit( x ) \
        (x)->lpVtbl->Decommit( x )
    #define IMemAllocatorCallbackTemp_GetBuffer( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetBuffer( x, p1, p2, p3, p4 )
    #define IMemAllocatorCallbackTemp_ReleaseBuffer( x, p ) \
        (x)->lpVtbl->ReleaseBuffer( x, p )
    #define IMemAllocatorCallbackTemp_SetNotify( x, p ) \
        (x)->lpVtbl->SetNotify( x, p )
    #define IMemAllocatorCallbackTemp_GetFreeCount( x, p ) \
        (x)->lpVtbl->GetFreeCount( x, p )
    #define IMemAllocatorNotifyCallbackTemp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMemAllocatorNotifyCallbackTemp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMemAllocatorNotifyCallbackTemp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMemAllocatorNotifyCallbackTemp_NotifyRelease( x ) \
        (x)->lpVtbl->NotifyRelease( x )
    #define IMemInputPin_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMemInputPin_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMemInputPin_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMemInputPin_GetAllocator( x, p ) \
        (x)->lpVtbl->GetAllocator( x, p )
    #define IMemInputPin_NotifyAllocator( x, p1, p2 ) \
        (x)->lpVtbl->NotifyAllocator( x, p1, p2 )
    #define IMemInputPin_GetAllocatorRequirements( x, p ) \
        (x)->lpVtbl->GetAllocatorRequirements( x, p )
    #define IMemInputPin_Receive( x, p ) \
        (x)->lpVtbl->Receive( x, p )
    #define IMemInputPin_ReceiveMultiple( x, p1, p2, p3 ) \
        (x)->lpVtbl->ReceiveMultiple( x, p1, p2, p3 )
    #define IMemInputPin_ReceiveCanBlock( x ) \
        (x)->lpVtbl->ReceiveCanBlock( x )
    #define IAMovieSetup_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMovieSetup_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMovieSetup_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMovieSetup_Register( x ) \
        (x)->lpVtbl->Register( x )
    #define IAMovieSetup_Unregister( x ) \
        (x)->lpVtbl->Unregister( x )
    #define IMediaSeeking_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaSeeking_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaSeeking_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaSeeking_GetCapabilities( x, p ) \
        (x)->lpVtbl->GetCapabilities( x, p )
    #define IMediaSeeking_CheckCapabilities( x, p ) \
        (x)->lpVtbl->CheckCapabilities( x, p )
    #define IMediaSeeking_IsFormatSupported( x, p ) \
        (x)->lpVtbl->IsFormatSupported( x, p )
    #define IMediaSeeking_QueryPreferredFormat( x, p ) \
        (x)->lpVtbl->QueryPreferredFormat( x, p )
    #define IMediaSeeking_GetTimeFormat( x, p ) \
        (x)->lpVtbl->GetTimeFormat( x, p )
    #define IMediaSeeking_IsUsingTimeFormat( x, p ) \
        (x)->lpVtbl->IsUsingTimeFormat( x, p )
    #define IMediaSeeking_SetTimeFormat( x, p ) \
        (x)->lpVtbl->SetTimeFormat( x, p )
    #define IMediaSeeking_GetDuration( x, p ) \
        (x)->lpVtbl->GetDuration( x, p )
    #define IMediaSeeking_GetStopPosition( x, p ) \
        (x)->lpVtbl->GetStopPosition( x, p )
    #define IMediaSeeking_GetCurrentPosition( x, p ) \
        (x)->lpVtbl->GetCurrentPosition( x, p )
    #define IMediaSeeking_ConvertTimeFormat( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->ConvertTimeFormat( x, p1, p2, p3, p4 )
    #define IMediaSeeking_SetPositions( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetPositions( x, p1, p2, p3, p4 )
    #define IMediaSeeking_GetPositions( x, p1, p2 ) \
        (x)->lpVtbl->GetPositions( x, p1, p2 )
    #define IMediaSeeking_GetAvailable( x, p1, p2 ) \
        (x)->lpVtbl->GetAvailable( x, p1, p2 )
    #define IMediaSeeking_SetRate( x, p ) \
        (x)->lpVtbl->SetRate( x, p )
    #define IMediaSeeking_GetRate( x, p ) \
        (x)->lpVtbl->GetRate( x, p )
    #define IMediaSeeking_GetPreroll( x, p ) \
        (x)->lpVtbl->GetPreroll( x, p )
    #define IEnumRegFilters_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumRegFilters_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumRegFilters_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumRegFilters_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumRegFilters_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumRegFilters_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumRegFilters_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IFilterMapper_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterMapper_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterMapper_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterMapper_RegisterFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterFilter( x, p1, p2, p3 )
    #define IFilterMapper_RegisterFilterInstance( x, p1, p2, p3 ) \
        (x)->lpVtbl->RegisterFilterInstance( x, p1, p2, p3 )
    #define IFilterMapper_RegisterPin( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->RegisterPin( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IFilterMapper_RegisterPinType( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterPinType( x, p1, p2, p3, p4 )
    #define IFilterMapper_UnregisterFilter( x, p ) \
        (x)->lpVtbl->UnregisterFilter( x, p )
    #define IFilterMapper_UnregisterFilterInstance( x, p ) \
        (x)->lpVtbl->UnregisterFilterInstance( x, p )
    #define IFilterMapper_UnregisterPin( x, p1, p2 ) \
        (x)->lpVtbl->UnregisterPin( x, p1, p2 )
    #define IFilterMapper_EnumMatchingFilters( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) \
        (x)->lpVtbl->EnumMatchingFilter( x, p1, p2, p3, p4, p5, p6, p7, p8, p9 )
    #define IFilterMapper2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterMapper2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterMapper2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterMapper2_CreateCategory( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateCategory( x, p1, p2, p3 )
    #define IFilterMapper2_UnregisterFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnregisterFilter( x, p1, p2, p3 )
    #define IFilterMapper2_RegisterFilter( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->RegisterFilter( x, p1, p2, p3, p4, p5, p6 )
    #define IFilterMapper2_EnumMatchingFilters( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15 ) \
        (x)->lpVtbl->EnumMatchingFilters( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15 )
    #define IFilterMapper3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterMapper3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterMapper3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterMapper3_CreateCategory( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateCategory( x, p1, p2, p3 )
    #define IFilterMapper3_UnregisterFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->UnregisterFilter( x, p1, p2, p3 )
    #define IFilterMapper3_RegisterFilter( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->RegisterFilter( x, p1, p2, p3, p4, p5, p6 )
    #define IFilterMapper3_EnumMatchingFilters( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15 ) \
        (x)->lpVtbl->EnumMatchingFilters( x, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15 )
    #define IFilterMapper3_GetICreateDevEnum( x, p ) \
        (x)->lpVtbl->GetICreateDevEnum( x, p )
    #define IQualityControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IQualityControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IQualityControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IQualityControl_Notify( x, p1, p2 ) \
        (x)->lpVtbl->Notify( x, p1, p2 )
    #define IQualityControl_SetSink( x, p ) \
        (x)->lpVtbl->SetSink( x, p )
    #define IOverlayNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOverlayNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOverlayNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOverlayNotify_OnPaletteChange( x, p1, p2 ) \
        (x)->lpVtbl->OnPaletteChange( x, p1, p2 )
    #define IOverlayNotify_OnClipChange( x, p1, p2, p3 ) \
        (x)->lpVtbl->OnClipChange( x, p1, p2, p3 )
    #define IOverlayNotify_OnColorKeyChange( x, p ) \
        (x)->lpVtbl->OnColorKeyChange( x, p )
    #define IOverlayNotify_OnPositionChange( x, p1, p2 ) \
        (x)->lpVtbl->OnPositionChange( x, p1, p2 )
    #define IOverlayNotify2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOverlayNotify2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOverlayNotify2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOverlayNotify2_OnPaletteChange( x, p1, p2 ) \
        (x)->lpVtbl->OnPaletteChange( x, p1, p2 )
    #define IOverlayNotify2_OnClipChange( x, p1, p2, p3 ) \
        (x)->lpVtbl->OnClipChange( x, p1, p2, p3 )
    #define IOverlayNotify2_OnColorKeyChange( x, p ) \
        (x)->lpVtbl->OnColorKeyChange( x, p )
    #define IOverlayNotify2_OnPositionChange( x, p1, p2 ) \
        (x)->lpVtbl->OnPositionChange( x, p1, p2 )
    #define IOverlayNotify2_OnDisplayChange( x, p ) \
        (x)->lpVtbl->OnDisplayChange( x, p )
    #define IOverlay_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IOverlay_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IOverlay_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IOverlay_GetPalette( x, p1, p2 ) \
        (x)->lpVtbl->GetPalette( x, p1, p2 )
    #define IOverlay_SetPalette( x, p1, p2 ) \
        (x)->lpVtbl->SetPalette( x, p1, p2 )
    #define IOverlay_GetDefaultColorKey( x, p ) \
        (x)->lpVtbl->GetDefaultColorKey( x, p )
    #define IOverlay_GetColorKey( x, p ) \
        (x)->lpVtbl->GetColorKey( x, p )
    #define IOverlay_SetColorKey( x, p ) \
        (x)->lpVtbl->SetColorKey( x, p )
    #define IOverlay_GetWindowHandle( x, p ) \
        (x)->lpVtbl->GetWindowHandle( x, p )
    #define IOverlay_GetClipList( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetClipList( x, p1, p2, p3 )
    #define IOverlay_GetVideoPosition( x, p1, p2 ) \
        (x)->lpVtbl->GetVideoPosition( x, p1, p2 )
    #define IOverlay_Advise( x, p1, p2 ) \
        (x)->lpVtbl->Advise( x, p1, p2 )
    #define IOverlay_Unadvise( x ) \
        (x)->lpVtbl->Unadvise( x )
    #define IMediaEventSink_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaEventSink_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaEventSink_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaEventSink_Notify( x, p1, p2, p3 ) \
        (x)->lpVtbl->Notify( x, p1, p2, p3 )
    #define IFileSourceFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFileSourceFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFileSourceFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFileSourceFilter_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IFileSourceFilter_GetCurFile( x, p1, p2 ) \
        (x)->lpVtbl->GetCurFile( x, p1, p2 )
    #define IFileSinkFilter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFileSinkFilter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFileSinkFilter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFileSinkFilter_SetFileName( x, p1, p2 ) \
        (x)->lpVtbl->SetFileName( x, p1, p2 )
    #define IFileSinkFilter_GetCurFile( x, p1, p2 ) \
        (x)->lpVtbl->GetCurFile( x, p1, p2 )
    #define IFileSinkFilter2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFileSinkFilter2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFileSinkFilter2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFileSinkFilter2_SetFileName( x, p1, p2 ) \
        (x)->lpVtbl->SetFileName( x, p1, p2 )
    #define IFileSinkFilter2_GetCurFile( x, p1, p2 ) \
        (x)->lpVtbl->GetCurFile( x, p1, p2 )
    #define IFileSinkFilter2_SetMode( x, p ) \
        (x)->lpVtbl->SetMode( x, p )
    #define IFileSinkFilter2_GetMode( x, p ) \
        (x)->lpVtbl->GetMode( x, p )
    #define IGraphBuilder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGraphBuilder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGraphBuilder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGraphBuilder_AddFilter( x, p1, p2 ) \
        (x)->lpVtbl->AddFilter( x, p1, p2 )
    #define IGraphBuilder_RemoveFilter( x, p ) \
        (x)->lpVtbl->RemoveFilter( x, p )
    #define IGraphBuilder_EnumFilters( x, p ) \
        (x)->lpVtbl->EnumFilters( x, p )
    #define IGraphBuilder_FindFilterByName( x, p1, p2 ) \
        (x)->lpVtbl->FindFilterByName( x, p1, p2 )
    #define IGraphBuilder_ConnectDirect( x, p1, p2, p3 ) \
        (x)->lpVtbl->ConnectDirect( x, p1, p2, p3 )
    #define IGraphBuilder_Reconnect( x, p ) \
        (x)->lpVtbl->Reconnect( x, p )
    #define IGraphBuilder_Disconnect( x, p ) \
        (x)->lpVtbl->Disconnect( x, p )
    #define IGraphBuilder_SetDefaultSyncSource( x ) \
        (x)->lpVtbl->SetDefaultSyncSource( x )
    #define IGraphBuilder_Connect( x, p1, p2 ) \
        (x)->lpVtbl->Connect( x, p1, p2 )
    #define IGraphBuilder_Render( x, p ) \
        (x)->lpVtbl->Render( x, p )
    #define IGraphBuilder_RenderFile( x, p1, p2 ) \
        (x)->lpVtbl->RenderFile( x, p1, p2 )
    #define IGraphBuilder_AddSourceFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->AddSourceFilter( x, p1, p2, p3 )
    #define IGraphBuilder_SetLogFile( x, p ) \
        (x)->lpVtbl->SetLogFile( x, p )
    #define IGraphBuilder_Abort( x ) \
        (x)->lpVtbl->Abort( x )
    #define IGraphBuilder_ShouldOperationContinue( x ) \
        (x)->lpVtbl->ShouldOperationContinue( x )
    #define ICaptureGraphBuilder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICaptureGraphBuilder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICaptureGraphBuilder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICaptureGraphBuilder_SetFiltergraph( x, p ) \
        (x)->lpVtbl->SetFiltergraph( x, p )
    #define ICaptureGraphBuilder_GetFiltergraph( x, p ) \
        (x)->lpVtbl->GetFiltergraph( x, p )
    #define ICaptureGraphBuilder_SetOutputFileName( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetOutputFileName( x, p1, p2, p3, p4 )
    #define ICaptureGraphBuilder_FindInterface( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FindInterface( x, p1, p2, p3, p4 )
    #define ICaptureGraphBuilder_RenderStream( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RenderStream( x, p1, p2, p3, p4 )
    #define ICaptureGraphBuilder_ControlStream( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->ControlStream( x, p1, p2, p3, p4, p5, p6 )
    #define ICaptureGraphBuilder_AllocCapFile( x, p1, p2 ) \
        (x)->lpVtbl->AllocCapFile( x, p1, p2 )
    #define ICaptureGraphBuilder_CopyCaptureFile( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CopyCaptureFile( x, p1, p2, p3, p4 )
    #define IAMCopyCaptureFileProgress_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMCopyCaptureFileProgress_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMCopyCaptureFileProgress_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMCopyCaptureFileProgress_Progress( x, p ) \
        (x)->lpVtbl->Progress( x, p )
    #define ICaptureGraphBuilder2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICaptureGraphBuilder2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICaptureGraphBuilder2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICaptureGraphBuilder2_SetFiltergraph( x, p ) \
        (x)->lpVtbl->SetFiltergraph( x, p )
    #define ICaptureGraphBuilder2_GetFiltergraph( x, p ) \
        (x)->lpVtbl->GetFiltergraph( x, p )
    #define ICaptureGraphBuilder2_SetOutputFileName( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetOutputFileName( x, p1, p2, p3, p4 )
    #define ICatpureGraphBuilder2_FindInterface( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->FindInterface( x, p1, p2, p3, p4, p5 )
    #define ICaptureGraphBuilder2_RenderStream( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->RenderStream( x, p1, p2, p3, p4, p5 )
    #define ICaptureGraphBuilder2_ControlStream( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->ControlStream( x, p1, p2, p3, p4, p5, p6, p7 )
    #define ICaptureGraphBuilder2_AllocCapFile( x, p1, p2 ) \
        (x)->lpVtbl->AllocCapFile( x, p1, p2 )
    #define ICaptureGraphBuilder2_CopyCaptureFile( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->CopyCaptureFile( x, p1, p2, p3, p4 )
    #define ICaptureGraphBuilder2_FindPin( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->FindPin( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IFilterGraph2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterGraph2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterGraph2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterGraph2_AddFilter( x, p1, p2 ) \
        (x)->lpVtbl->AddFilter( x, p1, p2 )
    #define IFilterGraph2_RemoveFilter( x, p ) \
        (x)->lpVtbl->RemoveFilter( x, p )
    #define IFilterGraph2_EnumFilters( x, p ) \
        (x)->lpVtbl->EnumFilters( x, p )
    #define IFilterGraph2_FindFilterByName( x, p1, p2 ) \
        (x)->lpVtbl->FindFilterByName( x, p1, p2 )
    #define IFilterGraph2_ConnectDirect( x, p1, p2, p3 ) \
        (x)->lpVtbl->ConnectDirect( x, p1, p2, p3 )
    #define IFilterGraph2_Reconnect( x, p ) \
        (x)->lpVtbl->Reconnect( x, p )
    #define IFilterGraph2_Disconnect( x, p ) \
        (x)->lpVtbl->Disconnect( x, p )
    #define IFilterGraph2_SetDefaultSyncSource( x ) \
        (x)->lpVtbl->SetDefaultSyncSource( x )
    #define IFilterGraph2_Connect( x, p1, p2 ) \
        (x)->lpVtbl->Connect( x, p1, p2 )
    #define IFilterGraph2_Render( x, p ) \
        (x)->lpVtbl->Render( x, p )
    #define IFilterGraph2_RenderFile( x, p1, p2 ) \
        (x)->lpVtbl->RenderFile( x, p1, p2 )
    #define IFilterGraph2_AddSourceFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->AddSourceFilter( x, p1, p2, p3 )
    #define IFilterGraph2_SetLogFile( x, p ) \
        (x)->lpVtbl->SetLogFile( x, p )
    #define IFilterGraph2_Abort( x ) \
        (x)->lpVtbl->Abort( x )
    #define IFilterGraph2_ShouldOperationContinue( x ) \
        (x)->lpVtbl->ShouldOperationContinue( x )
    #define IFilterGraph2_AddSourceFilterForMoniker( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AddSourceFilterForMoniker( x, p1, p2, p3, p4 )
    #define IFilterGraph2_ReconnectEx( x, p1, p2 ) \
        (x)->lpVtbl->ReconnectEx( x, p1, p2 )
    #define IFilterGraph2_RenderEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->RenderEx( x, p1, p2, p3 )
    #define IFilterGraph3_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterGraph3_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterGraph3_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterGraph3_AddFilter( x, p1, p2 ) \
        (x)->lpVtbl->AddFilter( x, p1, p2 )
    #define IFilterGraph3_RemoveFilter( x, p ) \
        (x)->lpVtbl->RemoveFilter( x, p )
    #define IFilterGraph3_EnumFilters( x, p ) \
        (x)->lpVtbl->EnumFilters( x, p )
    #define IFilterGraph3_FindFilterByName( x, p1, p2 ) \
        (x)->lpVtbl->FindFilterByName( x, p1, p2 )
    #define IFilterGraph3_ConnectDirect( x, p1, p2, p3 ) \
        (x)->lpVtbl->ConnectDirect( x, p1, p2, p3 )
    #define IFilterGraph3_Reconnect( x, p ) \
        (x)->lpVtbl->Reconnect( x, p )
    #define IFilterGraph3_Disconnect( x, p ) \
        (x)->lpVtbl->Disconnect( x, p )
    #define IFilterGraph3_SetDefaultSyncSource( x ) \
        (x)->lpVtbl->SetDefaultSyncSource( x )
    #define IFilterGraph3_Connect( x, p1, p2 ) \
        (x)->lpVtbl->Connect( x, p1, p2 )
    #define IFilterGraph3_Render( x, p ) \
        (x)->lpVtbl->Render( x, p )
    #define IFilterGraph3_RenderFile( x, p1, p2 ) \
        (x)->lpVtbl->RenderFile( x, p1, p2 )
    #define IFilterGraph3_AddSourceFilter( x, p1, p2, p3 ) \
        (x)->lpVtbl->AddSourceFilter( x, p1, p2, p3 )
    #define IFilterGraph3_SetLogFile( x, p ) \
        (x)->lpVtbl->SetLogFile( x, p )
    #define IFilterGraph3_Abort( x ) \
        (x)->lpVtbl->Abort( x )
    #define IFilterGraph3_ShouldOperationContinue( x ) \
        (x)->lpVtbl->ShouldOperationContinue( x )
    #define IFilterGraph3_AddSourceFilterForMoniker( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AddSourceFilterForMoniker( x, p1, p2, p3, p4 )
    #define IFilterGraph3_ReconnectEx( x, p1, p2 ) \
        (x)->lpVtbl->ReconnectEx( x, p1, p2 )
    #define IFilterGraph3_RenderEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->RenderEx( x, p1, p2, p3 )
    #define IFilterGraph3_SetSyncSourceEx( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetSyncSourceEx( x, p1, p2, p3 )
    #define IStreamBuilder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IStreamBuilder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IStreamBuilder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IStreamBuilder_Render( x, p1, p2 ) \
        (x)->lpVtbl->Render( x, p1, p2 )
    #define IStreamBuilder_Backout( x, p1, p2 ) \
        (x)->lpVtbl->Backout( x, p1, p2 )
    #define IAsyncReader_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAsyncReader_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAsyncReader_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAsyncReader_RequestAllocator( x, p1, p2, p3 ) \
        (x)->lpVtbl->RequestAllocator( x, p1, p2, p3 )
    #define IAsyncReader_Request( x, p1, p2 ) \
        (x)->lpVtbl->Request( x, p1, p2 )
    #define IAsyncReader_WaitForNext( x, p1, p2, p3 ) \
        (x)->lpVtbl->WaitForNext( x, p1, p2, p3 )
    #define IAsyncReader_SyncReadAligned( x, p ) \
        (x)->lpVtbl->SyncReadAligned( x, p )
    #define IAsyncReader_SyncRead( x, p1, p2, p3 ) \
        (x)->lpVtbl->SyncRead( x, p1, p2, p3 )
    #define IAsyncReader_Length( x, p1, p2 ) \
        (x)->lpVtbl->Length( x, p1, p2 )
    #define IAsyncReader_BeginFlush( x, p ) \
        (x)->lpVtbl->BeginFlush( x, p )
    #define IAsyncReader_EndFlush( x, p ) \
        (x)->lpVtbl->EndFlush( x, p )
    #define IGraphVersion_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGraphVersion_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGraphVersion_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGraphVersion_QueryVersion( x, p ) \
        (x)->lpVtbl->QueryVersion( x, p )
    #define IResourceConsumer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IResourceConsumer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IResourceConsumer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IResourceConsumer_AcquireResource( x, p ) \
        (x)->lpVtbl->AcquireResource( x, p )
    #define IResourceConsumer_ReleaseResource( x, p ) \
        (x)->lpVtbl->ReleaseResource( x, p )
    #define IResourceManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IResourceManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IResourceManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IResourceManager_Register( x, p1, p2, p3 ) \
        (x)->lpVtbl->Register( x, p1, p2, p3 )
    #define IResourceManager_RegisterGroup( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->RegisterGroup( x, p1, p2, p3, p4 )
    #define IResourceManager_RequestResource( x, p1, p2, p3 ) \
        (x)->lpVtbl->RequestResource( x, p1, p2, p3 )
    #define IResourceManager_NotifyAcquire( x, p1, p2, p3 ) \
        (x)->lpVtbl->NotifyAcquire( x, p1, p2, p3 )
    #define IResourceManager_NotifyRelease( x, p1, p2, p3 ) \
        (x)->lpVtbl->NotifyRelease( x, p1, p2, p3 )
    #define IResourceManager_CancelRequest( x, p1, p2 ) \
        (x)->lpVtbl->CancelRequest( x, p1, p2 )
    #define IResourceManager_SetFocus( x, p ) \
        (x)->lpVtbl->SetFocus( x, p )
    #define IResourceManager_ReleaseFocus( x, p ) \
        (x)->lpVtbl->ReleaseFocus( x, p )
    #define IDistributorNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDistributorNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDistributorNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDistributorNotify_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IDistributorNotify_Pause( x ) \
        (x)->lpVtbl->Pause( x )
    #define IDistributorNotify_Run( x, p ) \
        (x)->lpVtbl->Run( x, p )
    #define IDistributorNotify_SetSyncSource( x, p ) \
        (x)->lpVtbl->SetSyncSource( x, p )
    #define IDistributorNotify_NotifyGraphChange( x ) \
        (x)->lpVtbl->NotifyGraphChange( x )
    #define IAMStreamControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMStreamControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMStreamControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMStreamControl_StartAt( x, p1, p2 ) \
        (x)->lpVtbl->StartAt( x, p1, p2 )
    #define IAMStreamControl_StopAt( x, p1, p2, p3 ) \
        (x)->lpVtbl->StopAt( x, p1, p2, p3 )
    #define IAMStreamControl_GetInfo( x, p ) \
        (x)->lpVtbl->GetInfo( x, p )
    #define ISeekingPassThru_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ISeekingPassThru_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ISeekingPassThru_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ISeekingPassThru_Init( x, p1, p2 ) \
        (x)->lpVtbl->Init( x, p1, p2 )
    #define IAMStreamConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMStreamConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMStreamConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMStreamConfig_SetFormat( x, p ) \
        (x)->lpVtbl->SetFormat( x, p )
    #define IAMStreamConfig_GetFormat( x, p ) \
        (x)->lpVtbl->GetFormat( x, p )
    #define IAMStreamConfig_GetNumberOfCapabilities( x, p1, p2 ) \
        (x)->lpVtbl->GetNumberOfCapabilities( x, p1, p2 )
    #define IAMStreamConfig_GetStreamCaps( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetStreamCaps( x, p1, p2, p3 )
    #define IConfigInterleaving_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IConfigInterleaving_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IConfigInterleaving_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IConfigInterleaving_put_Mode( x, p ) \
        (x)->lpVtbl->put_Mode( x, p )
    #define IConfigInterleaving_get_Mode( x, p ) \
        (x)->lpVtbl->get_Mode( x, p )
    #define IConfigInterleaving_put_Interleaving( x, p ) \
        (x)->lpVtbl->put_Interleaving( x, p )
    #define IConfigInterleaving_get_Interleaving( x, p ) \
        (x)->lpVtbl->get_Interleaving( x, p )
    #define IConfigAviMux_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IConfigAviMux_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IConfigAviMux_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IConfigAviMux_SetMasterStream( x, p ) \
        (x)->lpVtbl->SetMasterStream( x, p )
    #define IConfigAviMux_GetMasterStream( x, p ) \
        (x)->lpVtbl->GetMasterStream( x, p )
    #define IConfigAviMux_SetOutputCompatibilityIndex( x, p ) \
        (x)->lpVtbl->SetOutputCompatibilityIndex( x, p )
    #define IConfigAviMux_GetOutputCompatibilityIndex( x, p ) \
        (x)->lpVtbl->GetOutputCompatibilityIndex( x, p )
    #define IAMVideoCompression_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVideoCompression_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVideoCompression_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVideoCompression_put_KeyFrameRate( x, p ) \
        (x)->lpVtbl->put_KeyFrameRate( x, p )
    #define IAMVideoCompression_get_KeyFrameRate( x, p ) \
        (x)->lpVtbl->get_KeyFrameRate( x, p )
    #define IAMVideoCompression_put_PFramesPerKeyFrame( x, p ) \
        (x)->lpVtbl->put_PFramesPerKeyFrame( x, p )
    #define IAMVideoCompression_get_PFramesPerKeyFrame( x, p ) \
        (x)->lpVtbl->get_PFramesPerKeyFrame( x, p )
    #define IAMVideoCompression_put_Quality( x, p ) \
        (x)->lpVtbl->put_Quality( x, p )
    #define IAMVideoCompression_get_Quality( x, p ) \
        (x)->lpVtbl->get_Quality( x, p )
    #define IAMVideoCompression_put_WindowSize( x, p ) \
        (x)->lpVtbl->put_WindowSize( x, p )
    #define IAMVideoCompression_get_WindowSize( x, p ) \
        (x)->lpVtbl->get_WindowSize( x, p )
    #define IAMVideoCompression_GetInfo( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->GetInfo( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IAMVideoCompression_OverrideKeyFrame( x, p ) \
        (x)->lpVtbl->OverrideKeyFrame( x, p )
    #define IAMVideoCompression_OverrideFrameSize( x, p1, p2 ) \
        (x)->lpVtbl->OverrideFrameSize( x, p1, p2 )
    #define IAMVfwCaptureDialogs_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVfwCaptureDialogs_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVfwCaptureDialogs_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVfwCaptureDialogs_HasDialog( x, p ) \
        (x)->lpVtbl->HasDialog( x, p )
    #define IAMVfwCaptureDialogs_ShowDialog( x, p1, p2 ) \
        (x)->lpVtbl->ShowDialog( x, p1, p2 )
    #define IAMVfwCaptureDialogs_SendDriverMessage( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SendDriverMessage( x, p1, p2, p3, p4 )
    #define IAMVfwCompressDialogs_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVfwCompressDialogs_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVfwCompressDialogs_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVfwCompressDialogs_ShowDialog( x, p1, p2 ) \
        (x)->lpVtbl->ShowDialog( x, p1, p2 )
    #define IAMVfwCompressDialogs_GetState( x, p1, p2 ) \
        (x)->lpVtbl->GetState( x, p1, p2 )
    #define IAMVfwCompressDialogs_SetState( x, p1, p2 ) \
        (x)->lpVtbl->SetState( x, p1, p2 )
    #define IAMVfwCompressDialogs_SendDriverMessage( x, p1, p2, p3 ) \
        (x)->lpVtbl->SendDriverMessage( x, p1, p2, p3 )
    #define IAMDroppedFrames_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMDroppedFrames_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMDroppedFrames_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMDroppedFrames_GetNumDropped( x, p ) \
        (x)->lpVtbl->GetNumDropped( x, p )
    #define IAMDroppedFrames_GetNumNotDropped( x, p ) \
        (x)->lpVtbl->GetNumNotDropped( x, p )
    #define IAMDroppedFrames_GetDroppedInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDroppedInfo( x, p1, p2, p3 )
    #define IAMDroppedFrames_GetAverageFrameSize( x, p ) \
        (x)->lpVtbl->GetAverageFrameSize( x, p )
    #define IAMAudioInputMixer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMAudioInputMixer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMAudioInputMixer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMAudioInputMixer_put_Enable( x, p ) \
        (x)->lpVtbl->put_Enable( x, p )
    #define IAMAudioInputMixer_get_Enable( x, p ) \
        (x)->lpVtbl->get_Enable( x, p )
    #define IAMAudioInputMixer_put_Mono( x, p ) \
        (x)->lpVtbl->put_Mono( x, p )
    #define IAMAudioInputMixer_get_Mono( x, p ) \
        (x)->lpVtbl->get_Mono( x, p )
    #define IAMAudioInputMixer_put_MixLevel( x, p ) \
        (x)->lpVtbl->put_MixLevel( x, p )
    #define IAMAudioInputMixer_get_MixLevel( x, p ) \
        (x)->lpVtbl->get_MixLevel( x, p )
    #define IAMAudioInputMixer_put_Pan( x, p ) \
        (x)->lpVtbl->put_Pan( x, p )
    #define IAMAudioInputMixer_get_Pan( x, p ) \
        (x)->lpVtbl->get_Pan( x, p )
    #define IAMAudioInputMixer_put_Loudness( x, p ) \
        (x)->lpVtbl->put_Loudness( x, p )
    #define IAMAudioInputMixer_get_Loudness( x, p ) \
        (x)->lpVtbl->get_Loudness( x, p )
    #define IAMAudioInputMixer_put_Treble( x, p ) \
        (x)->lpVtbl->put_Treble( x, p )
    #define IAMAudioInputMixer_get_Treble( x, p ) \
        (x)->lpVtbl->get_Treble( x, p )
    #define IAMAudioInputMixer_get_TrebleRange( x, p ) \
        (x)->lpVtbl->get_TrebleRange( x, p )
    #define IAMAudioInputMixer_put_Bass( x, p ) \
        (x)->lpVtbl->put_Bass( x, p )
    #define IAMAudioInputMixer_get_Bass( x, p ) \
        (x)->lpVtbl->get_Bass( x, p )
    #define IAMBufferNegotiation_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMBufferNegotiation_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMBufferNegotiation_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMBufferNegotiation_SuggestAllocatorProperties( x, p ) \
        (x)->lpVtbl->SuggestAllocatorProperties( x, p )
    #define IAMBufferNegotiation_GetAllocatorProperties( x, p ) \
        (x)->lpVtbl->GetAllocatorProperties( x, p )
    #define IAMAnalogVideoDecoder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMAnalogVideoDecoder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMAnalogVideoDecoder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMAnalogVideoDecoder_get_AvailableTVFormats( x, p ) \
        (x)->lpVtbl->get_AvailableTVFormats( x, p )
    #define IAMAnalogVideoDecoder_put_TVFormat( x, p ) \
        (x)->lpVtbl->put_TVFormat( x, p )
    #define IAMAnalogVideoDecoder_get_TVFormat( x, p ) \
        (x)->lpVtbl->get_TVFormat( x, p )
    #define IAMAnalogVideoDecoder_get_HorizontalLocked( x, p ) \
        (x)->lpVtbl->get_HorizontalLocked( x, p )
    #define IAMAnalogVideoDecoder_put_VCRHorizontalLocking( x, p ) \
        (x)->lpVtbl->put_VCRHorizontalLocking( x, p )
    #define IAMAnalogVideoDecoder_get_VCRHorizontalLocking( x, p ) \
        (x)->lpVtbl->get_VCRHorizontalLocking( x, p )
    #define IAMAnalogVideoDecoder_get_NumberOfLines( x, p ) \
        (x)->lpVtbl->get_NumberOfLines( x, p )
    #define IAMAnalogVideoDecoder_put_OutputEnable( x, p ) \
        (x)->lpVtbl->put_OutputEnable( x, p )
    #define IAMAnalogVideoDecoder_get_OutputEnable( x, p ) \
        (x)->lpVtbl->get_OutputEnable( x, p )
    #define IAMVideoProcAmp_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVideoProcAmp_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVideoProcAmp_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVideoProcAmp_GetRange( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetRange( x, p1, p2, p3, p4, p5, p6 )
    #define IAMVideoProcAmp_Set( x, p1, p2, p3 ) \
        (x)->lpVtbl->Set( x, p1, p2, p3 )
    #define IAMVideoProcAmp_Get( x, p1, p2, p3 ) \
        (x)->lpVtbl->Get( x, p1, p2, p3 )
    #define IAMCameraControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMCameraControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMCameraControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMCameraControl_GetRange( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetRange( x, p1, p2, p3, p4, p5, p6 )
    #define IAMCameraControl_Set( x, p1, p2, p3 ) \
        (x)->lpVtbl->Set( x, p1, p2, p3 )
    #define IAMCameraControl_Get( x, p1, p2, p3 ) \
        (x)->lpVtbl->Get( x, p1, p2, p3 )
    #define IAMVideoControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVideoControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVideoControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVideoControl_GetCaps( x, p1, p2 ) \
        (x)->lpVtbl->GetCaps( x, p1, p2 )
    #define IAMVideoControl_SetMode( x, p1, p2 ) \
        (x)->lpVtbl->SetMode( x, p1, p2 )
    #define IAMVideoControl_GetMode( x, p1, p2 ) \
        (x)->lpVtbl->GetMode( x, p1, p2 )
    #define IAMVideoControl_GetCurrentActualFrameRate( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentActualFrameRate( x, p1, p2 )
    #define IAMVideoControl_GetMaxAvailableFrameRate( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetMaxAvailableFrameRate( x, p1, p2, p3, p4 )
    #define IAMVideoControl_GetFrameRateList( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->GetFrameRateList( x, p1, p2, p3, p4, p5 )
    #define IAMCrossbar_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMCrossbar_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMCrossbar_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMCrossbar_get_PinCounts( x, p1, p2 ) \
        (x)->lpVtbl->get_PinCounts( x, p1, p2 )
    #define IAMCrossbar_CanRoute( x, p1, p2 ) \
        (x)->lpVtbl->CanRoute( x, p1, p2 )
    #define IAMCrossbar_Route( x, p1, p2 ) \
        (x)->lpVtbl->Route( x, p1, p2 )
    #define IAMCrossbar_get_IsRoutedTo( x, p1, p2 ) \
        (x)->lpVtbl->get_IsRoutedTo( x, p1, p2 )
    #define IAMCrossbar_get_CrossbarPinInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->get_CrossbarPinInfo( x, p1, p2, p3, p4 )
    #define IAMTuner_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTuner_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTuner_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTuner_put_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->put_Channel( x, p1, p2, p3 )
    #define IAMTuner_get_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->get_Channel( x, p1, p2, p3 )
    #define IAMTuner_ChannelMinMax( x, p1, p2 ) \
        (x)->lpVtbl->ChannelMinMax( x, p1, p2 )
    #define IAMTuner_put_CountryCode( x, p ) \
        (x)->lpVtbl->put_CountryCode( x, p )
    #define IAMTuner_get_CountryCode( x, p ) \
        (x)->lpVtbl->get_CountryCode( x, p )
    #define IAMTuner_put_TuningSpace( x, p ) \
        (x)->lpVtbl->put_TuningSpace( x, p )
    #define IAMTuner_get_TuningSpace( x, p ) \
        (x)->lpVtbl->get_TuningSpace( x, p )
    #define IAMTuner_Logon( x, p ) \
        (x)->lpVtbl->Logon( x, p )
    #define IAMTuner_Logoff( x ) \
        (x)->lpVtbl->Logoff( x )
    #define IAMTuner_SignalPresent( x, p ) \
        (x)->lpVtbl->SignalPresent( x, p )
    #define IAMTuner_put_Mode( x, p ) \
        (x)->lpVtbl->put_Mode( x, p )
    #define IAMTuner_get_Mode( x, p ) \
        (x)->lpVtbl->get_Mode( x, p )
    #define IAMTuner_GetAvailableModes( x, p ) \
        (x)->lpVtbl->GetAvailableModes( x, p )
    #define IAMTuner_RegisterNotificationCallBack( x, p1, p2 ) \
        (x)->lpVtbl->RegisterNotificationCallBack( x, p1, p2 )
    #define IAMTuner_UnRegisterNotificationCallBack( x, p ) \
        (x)->lpVtbl->UnRegisterNotificationCallBack( x, p )
    #define IAMTunerNotification_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTunerNotification_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTunerNotification_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTunerNotification_OnEvent( x, p ) \
        (x)->lpVtbl->OnEvent( x, p )
    #define IAMTVTuner_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTVTuner_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTVTuner_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTVTuner_put_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->put_Channel( x, p1, p2, p3 )
    #define IAMTVTuner_get_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->get_Channel( x, p1, p2, p3 )
    #define IAMTVTuner_ChannelMinMax( x, p1, p2 ) \
        (x)->lpVtbl->ChannelMinMax( x, p1, p2 )
    #define IAMTVTuner_put_CountryCode( x, p ) \
        (x)->lpVtbl->put_CountryCode( x, p )
    #define IAMTVTuner_get_CountryCode( x, p ) \
        (x)->lpVtbl->get_CountryCode( x, p )
    #define IAMTVTuner_put_TuningSpace( x, p ) \
        (x)->lpVtbl->put_TuningSpace( x, p )
    #define IAMTVTuner_get_TuningSpace( x, p ) \
        (x)->lpVtbl->get_TuningSpace( x, p )
    #define IAMTVTuner_Logon( x, p ) \
        (x)->lpVtbl->Logon( x, p )
    #define IAMTVTuner_Logoff( x ) \
        (x)->lpVtbl->Logoff( x )
    #define IAMTVTuner_SignalPresent( x, p ) \
        (x)->lpVtbl->SignalPresent( x, p )
    #define IAMTVTuner_put_Mode( x, p ) \
        (x)->lpVtbl->put_Mode( x, p )
    #define IAMTVTuner_get_Mode( x, p ) \
        (x)->lpVtbl->get_Mode( x, p )
    #define IAMTVTuner_GetAvailableModes( x, p ) \
        (x)->lpVtbl->GetAvailableModes( x, p )
    #define IAMTVTuner_RegisterNotificationCallBack( x, p1, p2 ) \
        (x)->lpVtbl->RegisterNotificationCallBack( x, p1, p2 )
    #define IAMTVTuner_UnRegisterNotificationCallBack( x, p ) \
        (x)->lpVtbl->UnRegisterNotificationCallBack( x, p )
    #define IAMTVTuner_get_AvailableTVFormats( x, p ) \
        (x)->lpVtbl->get_AvailableTVFormats( x, p )
    #define IAMTVTuner_get_TVFormat( x, p ) \
        (x)->lpVtbl->get_TVFormat( x, p )
    #define IAMTVTuner_AutoTune( x, p1, p2 ) \
        (x)->lpVtbl->AutoTune( x, p1, p2 )
    #define IAMTVTuner_StoreAutoTune( x ) \
        (x)->lpVtbl->StoreAutoTune( x )
    #define IAMTVTuner_get_NumInputConnections( x, p ) \
        (x)->lpVtbl->get_NumInputConnections( x, p )
    #define IAMTVTuner_put_InputType( x, p1, p2 ) \
        (x)->lpVtbl->put_InputType( x, p1, p2 )
    #define IAMTVTuner_get_InputType( x, p1, p2 ) \
        (x)->lpVtbl->get_InputType( x, p1, p2 )
    #define IAMTVTuner_put_ConnectInput( x, p ) \
        (x)->lpVtbl->put_ConnectInput( x, p )
    #define IAMTVTuner_get_ConnectInput( x, p ) \
        (x)->lpVtbl->get_ConnectInput( x, p )
    #define IAMTVTuner_get_VideoFrequency( x, p ) \
        (x)->lpVtbl->get_VideoFrequency( x, p )
    #define IAMTVTuner_get_AudioFrequency( x, p ) \
        (x)->lpVtbl->get_AudioFrequency( x, p )
    #define IBPCSatelliteTuner_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IBPCSatelliteTuner_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IBPCSatelliteTuner_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IBPCSatelliteTuner_put_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->put_Channel( x, p1, p2, p3 )
    #define IBPCSatelliteTuner_get_Channel( x, p1, p2, p3 ) \
        (x)->lpVtbl->get_Channel( x, p1, p2, p3 )
    #define IBPCSatelliteTuner_ChannelMinMax( x, p1, p2 ) \
        (x)->lpVtbl->ChannelMinMax( x, p1, p2 )
    #define IBPCSatelliteTuner_put_CountryCode( x, p ) \
        (x)->lpVtbl->put_CountryCode( x, p )
    #define IBPCSatelliteTuner_get_CountryCode( x, p ) \
        (x)->lpVtbl->get_CountryCode( x, p )
    #define IBPCSatelliteTuner_put_TuningSpace( x, p ) \
        (x)->lpVtbl->put_TuningSpace( x, p )
    #define IBPCSatelliteTuner_get_TuningSpace( x, p ) \
        (x)->lpVtbl->get_TuningSpace( x, p )
    #define IBPCSatelliteTuner_Logon( x, p ) \
        (x)->lpVtbl->Logon( x, p )
    #define IBPCSatelliteTuner_Logoff( x ) \
        (x)->lpVtbl->Logoff( x )
    #define IBPCSatelliteTuner_SignalPresent( x, p ) \
        (x)->lpVtbl->SignalPresent( x, p )
    #define IBPCSatelliteTuner_put_Mode( x, p ) \
        (x)->lpVtbl->put_Mode( x, p )
    #define IBPCSatelliteTuner_get_Mode( x, p ) \
        (x)->lpVtbl->get_Mode( x, p )
    #define IBPCSatelliteTuner_GetAvailableModes( x, p ) \
        (x)->lpVtbl->GetAvailableModes( x, p )
    #define IBPCSatelliteTuner_RegisterNotificationCallBack( x, p1, p2 ) \
        (x)->lpVtbl->RegisterNotificationCallBack( x, p1, p2 )
    #define IBPCSatelliteTuner_UnRegisterNotificationCallBack( x, p ) \
        (x)->lpVtbl->UnRegisterNotificationCallBack( x, p )
    #define IBPCSatelliteTuner_get_DefaultSubChannelTypes( x, p1, p2 ) \
        (x)->lpVtbl->get_DefaultSubChannelTypes( x, p1, p2 )
    #define IBPCSatelliteTuner_put_DefaultSubChannelTypes( x, p1, p2 ) \
        (x)->lpVtbl->put_DefaultSubChannelTypes( x, p1, p2 )
    #define IBPCSatelliteTuner_IsTapingPermitted( x ) \
        (x)->lpVtbl->IsTapingPermitted( x )
    #define IAMTVAudio_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTVAudio_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTVAudio_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTVAudio_GetHardwareSupportedTVAudioModes( x, p ) \
        (x)->lpVtbl->GetHardwareSupportedTVAudioModes( x, p )
    #define IAMTVAudio_GetAvailableTVAudioModes( x, p ) \
        (x)->lpVtbl->GetAvailableTVAudioModes( x, p )
    #define IAMTVAudio_get_TVAudioMode( x, p ) \
        (x)->lpVtbl->get_TVAudioMode( x, p )
    #define IAMTVAudio_put_TVAudioMode( x, p ) \
        (x)->lpVtbl->put_TVAudioMode( x, p )
    #define IAMTVAudio_RegisterNotificationCallBack( x, p1, p2 ) \
        (x)->lpVtbl->RegisterNotificationCallBack( x, p1, p2 )
    #define IAMTVAudio_UnRegisterNotificationCallBack( x, p ) \
        (x)->lpVtbl->UnRegisterNotificationCallBack( x, p )
    #define IAMTVAudioNotification_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTVAudioNotification_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTVAudioNotification_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTVAudioNotification_OnEvent( x, p ) \
        (x)->lpVtbl->OnEvent( x, p )
    #define IAMAnalogVideoEncoder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMAnalogVideoEncoder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMAnalogVideoEncoder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMAnalogVideoEncoder_get_AvailableTVFormats( x, p ) \
        (x)->lpVtbl->get_AvailableTVFormats( x, p )
    #define IAMAnalogVideoEncoder_put_TVFormat( x, p ) \
        (x)->lpVtbl->put_TVFormat( x, p )
    #define IAMAnalogVideoEncoder_get_TVFormat( x, p ) \
        (x)->lpVtbl->get_TVFormat( x, p )
    #define IAMAnalogVideoEncoder_put_CopyProtection( x, p ) \
        (x)->lpVtbl->put_CopyProtection( x, p )
    #define IAMAnalogVideoEncoder_get_CopyProtection( x, p ) \
        (x)->lpVtbl->get_CopyProtection( x, p )
    #define IAMAnalogVideoEncoder_put_CCEnable( x, p ) \
        (x)->lpVtbl->put_CCEnable( x, p )
    #define IAMAnalogVideoEncoder_get_CCEnable( x, p ) \
        (x)->lpVtbl->get_CCEnable( x, p )
    #define IKsPropertySet_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IKsPropertySet_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IKsPropertySet_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IKsPropertySet_Set( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->Set( x, p1, p2, p3, p4, p5, p6 )
    #define IKsPropertySet_Get( x, p1, p2, p3, p4, p5, p6, p7 ) \
        (x)->lpVtbl->Get( x, p1, p2, p3, p4, p5, p6, p7 )
    #define IKsPropertySet_QuerySupported( x, p1, p2, p3 ) \
        (x)->lpVtbl->QuerySupported( x, p1, p2, p3 )
    #define IMediaPropertyBag_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMediaPropertyBag_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMediaPropertyBag_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMediaPropertyBag_Read( x, p1, p2, p3 ) \
        (x)->lpVtbl->Read( x, p1, p2, p3 )
    #define IMediaPropertyBag_Write( x, p1, p2 ) \
        (x)->lpVtbl->Write( x, p1, p2 )
    #define IMediaPropertyBag_EnumProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->EnumProperty( x, p1, p2, p3 )
    #define IPersistMediaPropertyBag_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPersistMediaPropertyBag_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPersistMediaPropertyBag_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPersistMediaPropertyBag_GetClassID( x, p ) \
        (x)->lpVtbl->GetClassID( x, p )
    #define IPersistMediaPropertyBag_InitNew( x ) \
        (x)->lpVtbl->InitNew( x )
    #define IPersistMediaPropertyBag_Load( x, p1, p2 ) \
        (x)->lpVtbl->Load( x, p1, p2 )
    #define IPersistMediaPropertyBag_Save( x, p1, p2, p3 ) \
        (x)->lpVtbl->Save( x, p1, p2, p3 )
    #define IAMPhysicalPinInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMPhysicalPinInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMPhysicalPinInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMPhysicalPinInfo_GetPhysicalType( x, p1, p2 ) \
        (x)->lpVtbl->GetPhysicalType( x, p1, p2 )
    #define IAMExtDevice_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMExtDevice_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMExtDevice_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMExtDevice_GetCapability( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCapability( x, p1, p2, p3 )
    #define IAMExtDevice_get_ExternalDeviceID( x, p ) \
        (x)->lpVtbl->get_ExternalDeviceID( x, p )
    #define IAMExtDevice_get_ExternalDeviceVersion( x, p ) \
        (x)->lpVtbl->get_ExternalDeviceVersion( x, p )
    #define IAMExtDevice_put_DevicePower( x, p ) \
        (x)->lpVtbl->put_DevicePower( x, p )
    #define IAMExtDevice_get_DevicePower( x, p ) \
        (x)->lpVtbl->get_DevicePower( x, p )
    #define IAMExtDevice_Calibrate( x, p1, p2, p3 ) \
        (x)->lpVtbl->Calibrate( x, p1, p2, p3 )
    #define IAMExtDevice_put_DevicePort( x, p ) \
        (x)->lpVtbl->put_DevicePort( x, p )
    #define IAMExtDevice_get_DevicePort( x, p ) \
        (x)->lpVtbl->get_DevicePort( x, p )
    #define IAMExtTransport_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMExtTransport_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMExtTransport_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMExtTransport_GetCapability( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCapability( x, p1, p2, p3 )
    #define IAMExtTransport_put_MediaState( x, p ) \
        (x)->lpVtbl->put_MediaState( x, p )
    #define IAMExtTransport_get_MediaState( x, p ) \
        (x)->lpVtbl->get_MediaState( x, p )
    #define IAMExtTransport_put_LocalControl( x, p ) \
        (x)->lpVtbl->put_LocalControl( x, p )
    #define IAMExtTransport_get_LocalControl( x, p ) \
        (x)->lpVtbl->get_LocalControl( x, p )
    #define IAMExtTransport_GetStatus( x, p1, p2 ) \
        (x)->lpVtbl->GetStatus( x, p1, p2 )
    #define IAMExtTransport_GetTransportBasicParameters( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTransportBasicParameters( x, p1, p2, p3 )
    #define IAMExtTransport_SetTransportBasicParameters( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetTransportBasicParameters( x, p1, p2, p3 )
    #define IAMExtTransport_GetTransportVideoParameters( x, p1, p2 ) \
        (x)->lpVtbl->GetTransportVideoParameters( x, p1, p2 )
    #define IAMExtTransport_SetTransportVideoParameters( x, p1, p2 ) \
        (x)->lpVtbl->SetTransportVideoParameters( x, p1, p2 )
    #define IAMExtTransport_GetTransportAudioParameters( x, p1, p2 ) \
        (x)->lpVtbl->GetTransportAudioParameters( x, p1, p2 )
    #define IAMExtTransport_SetTransportAudioParameters( x, p1, p2 ) \
        (x)->lpVtbl->SetTransportAudioParameters( x, p1, p2 )
    #define IAMExtTransport_put_Mode( x, p ) \
        (x)->lpVtbl->put_Mode( x, p )
    #define IAMExtTransport_get_Mode( x, p ) \
        (x)->lpVtbl->get_Mode( x, p )
    #define IAMExtTransport_put_Rate( x, p ) \
        (x)->lpVtbl->put_Rate( x, p )
    #define IAMExtTransport_get_Rate( x, p ) \
        (x)->lpVtbl->get_Rate( x, p )
    #define IAMExtTransport_GetChase( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetChase( x, p1, p2, p3 )
    #define IAMExtTransport_SetChase( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetChase( x, p1, p2, p3 )
    #define IAMExtTransport_GetBump( x, p1, p2 ) \
        (x)->lpVtbl->GetBump( x, p1, p2 )
    #define IAMExtTransport_SetBump( x, p1, p2 ) \
        (x)->lpVtbl->SetBump( x, p1, p2 )
    #define IAMExtTransport_get_AntiClogControl( x, p ) \
        (x)->lpVtbl->get_AntiClogControl( x, p )
    #define IAMExtTransport_put_AntiClogControl( x, p ) \
        (x)->lpVtbl->put_AntiClogControl( x, p )
    #define IAMExtTransport_GetEditPropertySet( x, p1, p2 ) \
        (x)->lpVtbl->GetEditPropertySet( x, p1, p2 )
    #define IAMExtTransport_SetEditPropertySet( x, p1, p2 ) \
        (x)->lpVtbl->SetEditPropertySet( x, p1, p2 )
    #define IAMExtTransport_GetEditProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetEditProperty( x, p1, p2, p3 )
    #define IAMExtTransport_SetEditProperty( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetEditProperty( x, p1, p2, p3 )
    #define IAMExtTransport_get_EditStart( x, p ) \
        (x)->lpVtbl->get_EditStart( x, p )
    #define IAMExtTransport_put_EditStart( x, p ) \
        (x)->lpVtbl->put_EditStart( x, p )
    #define IAMTimecodeReader_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimecodeReader_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimecodeReader_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimecodeReader_GetTCRMode( x, p1, p2 ) \
        (x)->lpVtbl->GetTCRMode( x, p1, p2 )
    #define IAMTimecodeReader_SetTCRMode( x, p1, p2 ) \
        (x)->lpVtbl->SetTCRMode( x, p1, p2 )
    #define IAMTimecodeReader_put_VITCLine( x, p ) \
        (x)->lpVtbl->put_VITCLine( x, p )
    #define IAMTimecodeReader_get_VITCLine( x, p ) \
        (x)->lpVtbl->get_VITCLine( x, p )
    #define IAMTimecodeReader_GetTimecode( x, p ) \
        (x)->lpVtbl->GetTimecode( x, p )
    #define IAMTimecodeGenerator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimecodeGenerator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimecodeGenerator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimecodeGenerator_GetTCGMode( x, p1, p2 ) \
        (x)->lpVtbl->GetTCGMode( x, p1, p2 )
    #define IAMTimecodeGenerator_SetTCGMode( x, p1, p2 ) \
        (x)->lpVtbl->SetTCGMode( x, p1, p2 )
    #define IAMTimecodeGenerator_put_VITCLine( x, p ) \
        (x)->lpVtbl->put_VITCLine( x, p )
    #define IAMTimecodeGenerator_get_VITCLine( x, p ) \
        (x)->lpVtbl->get_VITCLine( x, p )
    #define IAMTimecodeGenerator_SetTimecode( x, p ) \
        (x)->lpVtbl->SetTimecode( x, p )
    #define IAMTimecodeGenerator_GetTimecode( x, p ) \
        (x)->lpVtbl->GetTimecode( x, p )
    #define IAMTimecodeDisplay_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMTimecodeDisplay_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMTimecodeDisplay_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMTimecodeDisplay_GetTCDisplayEnable( x, p ) \
        (x)->lpVtbl->GetTCDisplayEnable( x, p )
    #define IAMTimecodeDisplay_SetTCDisplayEnable( x, p ) \
        (x)->lpVtbl->SetTCDisplayEnable( x, p )
    #define IAMTimecodeDisplay_GetTCDisplay( x, p1, p2 ) \
        (x)->lpVtbl->GetTCDisplay( x, p1, p2 )
    #define IAMTimecodeDisplay_SetTCDisplay( x, p1, p2 ) \
        (x)->lpVtbl->SetTCDisplay( x, p1, p2 )
    #define IAMDevMemoryAllocator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMDevMemoryAllocator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMDevMemoryAllocator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMDevMemoryAllocator_GetInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetInfo( x, p1, p2, p3, p4 )
    #define IAMDevMemoryAllocator_CheckMemory( x, p ) \
        (x)->lpVtbl->CheckMemory( x, p )
    #define IAMDevMemoryAllocator_Alloc( x, p1, p2 ) \
        (x)->lpVtbl->Alloc( x, p1, p2 )
    #define IAMDevMemoryAllocator_Free( x, p ) \
        (x)->lpVtbl->Free( x, p )
    #define IAMDevMemoryAllocator_GetDevMemoryObject( x, p1, p2 ) \
        (x)->lpVtbl->GetDevMemoryObject( x, p1, p2 )
    #define IAMDevMemoryControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMDevMemoryControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMDevMemoryControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMDevMemoryControl_QueryWriteSync( x ) \
        (x)->lpVtbl->QueryWriteSync( x )
    #define IAMDevMemoryControl_WriteSync( x ) \
        (x)->lpVtbl->WriteSync( x )
    #define IAMDevMemoryControl_GetDevId( x, p ) \
        (x)->lpVtbl->GetDevId( x, p )
    #define IAMStreamSelect_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMStreamSelect_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMStreamSelect_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMStreamSelect_Count( x, p ) \
        (x)->lpVtbl->Count( x, p )
    #define IAMStreamSelect_Info( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->Info( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IAMStreamSelect_Enable( x, p1, p2 ) \
        (x)->lpVtbl->Enable( x, p1, p2 )
    #define IAMResourceControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMResourceControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMResourceControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMResourceControl_Reserve( x, p1, p2 ) \
        (x)->lpVtbl->Reserve( x, p1, p2 )
    #define IAMClockAdjust_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMClockAdjust_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMClockAdjust_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMClockAdjust_SetClockDelta( x, p ) \
        (x)->lpVtbl->SetClockDelta( x, p )
    #define IAMFilterMiscFlags_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMFilterMiscFlags_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMFilterMiscFlags_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMFilterMiscFlags_GetMiscFlags( x ) \
        (x)->lpVtbl->GetMiscFlags( x )
    #define IDrawVideoImage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDrawVideoImage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDrawVideoImage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDrawVideoImage_DrawVideoImageBegin( x ) \
        (x)->lpVtbl->DrawVideoImageBegin( x )
    #define IDrawVideoImage_DrawVideoImageEnd( x ) \
        (x)->lpVtbl->DrawVideoImageEnd( x )
    #define IDrawVideoImage_DrawVideoImageDraw( x, p1, p2, p3 ) \
        (x)->lpVtbl->DrawVideoImageDraw( x, p1, p2, p3 )
    #define IDecimateVideoImage_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDecimateVideoImage_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDecimateVideoImage_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDecimateVideoImage_SetDecimationImageSize( x, p1, p2 ) \
        (x)->lpVtbl->SetDecimationImageSize( x, p1, p2 )
    #define IDecimateVideoImage_ResetDecimationImageSize( x ) \
        (x)->lpVtbl->ResetDecimationImageSize( x )
    #define IAMVideoDecimationProperties_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMVideoDecimationProperties_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMVideoDecimationProperties_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMVideoDecimationProperties_QueryDecimationUsage( x, p ) \
        (x)->lpVtbl->QueryDecimationUsage( x, p )
    #define IAMVideoDecimationProperties_SetDecimationUsage( x, p ) \
        (x)->lpVtbl->SetDecimationUsage( x, p )
    #define IVideoFrameStep_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVideoFrameStep_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVideoFrameStep_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVideoFrameStep_Step( x, p1, p2 ) \
        (x)->lpVtbl->Step( x, p1, p2 )
    #define IVideoFrameStep_CanStep( x, p1, p2 ) \
        (x)->lpVtbl->CanStep( x, p1, p2 )
    #define IVideoFrameStep_CancelStep( x ) \
        (x)->lpVtbl->CancelStep( x )
    #define IAMLatency_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMLatency_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMLatency_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMLatency_GetLatency( x, p ) \
        (x)->lpVtbl->GetLatency( x, p )
    #define IAMPushSource_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMPushSource_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMPushSource_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMPushSource_GetLatency( x, p ) \
        (x)->lpVtbl->GetLatency( x, p )
    #define IAMPushSource_GetPushSourceFlags( x, p ) \
        (x)->lpVtbl->GetPushSourceFlags( x, p )
    #define IAMPushSource_SetPushSourceFlags( x, p ) \
        (x)->lpVtbl->SetPushSourceFlags( x, p )
    #define IAMPushSource_SetStreamOffset( x, p ) \
        (x)->lpVtbl->SetStreamOffset( x, p )
    #define IAMPushSource_GetStreamOffset( x, p ) \
        (x)->lpVtbl->GetStreamOffset( x, p )
    #define IAMPushSource_GetMaxStreamOffset( x, p ) \
        (x)->lpVtbl->GetMaxStreamOffset( x, p )
    #define IAMPushSource_SetMaxStreamOffset( x, p ) \
        (x)->lpVtbl->SetMaxStreamOffset( x, p )
    #define IAMDeviceRemoval_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMDeviceRemoval_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMDeviceRemoval_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMDeviceRemoval_DeviceInfo( x, p1, p2 ) \
        (x)->lpVtbl->DeviceInfo( x, p1, p2 )
    #define IAMDeviceRemoval_Reassociate( x ) \
        (x)->lpVtbl->Reassociate( x )
    #define IAMDeviceRemoval_Disassociate( x ) \
        (x)->lpVtbl->Disassociate( x )
    #define IDVEnc_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDVEnc_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDVEnc_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDVEnc_get_IFormatResolution( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->get_IFormatResolution( x, p1, p2, p3, p4, p5 )
    #define IDVEnc_put_IFormatResolution( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->put_IFormatResolution( x, p1, p2, p3, p4, p5 )
    #define IIPDVDec_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IIPDVDec_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IIPDVDec_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IIPDVDec_get_IPDisplay( x, p ) \
        (x)->lpVtbl->get_IPDisplay( x, p )
    #define IIPDVDec_put_IPDisplay( x, p ) \
        (x)->lpVtbl->put_IPDisplay( x, p )
    #define IDVRGB219_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDVRGB219_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDVRGB219_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDVRGB219_SetRGB219( x, p ) \
        (x)->lpVtbl->SetRGB219( x, p )
    #define IDVSplitter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDVSplitter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDVSplitter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDVSplitter_DiscardAlternateVideoFrames( x, p ) \
        (x)->lpVtbl->DiscardAlternateVideoFrames( x, p )
    #define IAMAudioRendererStats_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMAudioRendererStats_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMAudioRendererStats_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMAudioRendererStats_GetStatParam( x, p1, p2 ) \
        (x)->lpVtbl->GetStatParam( x, p1, p2 )
    #define IAMGraphStreams_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMGraphStreams_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMGraphStreams_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMGraphStreams_FindUpstreamInterface( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->FindUpstreamInterface( x, p1, p2, p3, p4 )
    #define IAMGraphStreams_SyncUsingStreamOffset( x, p ) \
        (x)->lpVtbl->SyncUsingStreamOffset( x, p )
    #define IAMGraphStreams_SetMaxGraphLatency( x, p ) \
        (x)->lpVtbl->SetMaxGraphLatency( x, p )
    #define IAMOverlayFX_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMOverlayFX_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMOverlayFX_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMOverlayFX_QueryOverlayFXCaps( x, p ) \
        (x)->lpVtbl->QueryOverlayFXCaps( x, p )
    #define IAMOverlayFX_SetOverlayFX( x, p ) \
        (x)->lpVtbl->SetOverlayFX( x, p )
    #define IAMOverlayFX_GetOverlayFX( x, p ) \
        (x)->lpVtbl->GetOverlayFX( x, p )
    #define IAMOpenProgress_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMOpenProgress_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMOpenProgress_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMOpenProgress_QueryProgress( x, p1, p2 ) \
        (x)->lpVtbl->OpenProgress( x, p1, p2 )
    #define IAMOpenProgress_AbortOperation( x ) \
        (x)->lpVtbl->AbortOperation( x )
    #define IMpeg2Demultiplexer_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMpeg2Demultiplexer_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMpeg2Demultiplexer_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMpeg2Demultiplexer_CreateOutputPin( x, p1, p2, p3 ) \
        (x)->lpVtbl->CreateOutputPin( x, p1, p2, p3 )
    #define IMpeg2Demultiplexer_SetOutputPinMediaType( x, p1, p2 ) \
        (x)->lpVtbl->SetOutputPinMediaType( x, p1, p2 )
    #define IMpeg2Demultiplexer_DeleteOutputPin( x, p ) \
        (x)->lpVtbl->DeleteOutputPin( x, p )
    #define IEnumStreamIdMap_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEnumStreamIdMap_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEnumStreamIdMap_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEnumStreamIdMap_Next( x, p1, p2, p3 ) \
        (x)->lpVtbl->Next( x, p1, p2, p3 )
    #define IEnumStreamIdMap_Skip( x, p ) \
        (x)->lpVtbl->Skip( x, p )
    #define IEnumStreamIdMap_Reset( x ) \
        (x)->lpVtbl->Reset( x )
    #define IEnumStreamIdMap_Clone( x, p ) \
        (x)->lpVtbl->Clone( x, p )
    #define IMPEG2StreamIdMap_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IMPEG2StreamIdMap_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IMPEG2StreamIdMap_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IMPEG2StreamIdMap_MapStreamId( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->MapStreamId( x, p1, p2, p3, p4 )
    #define IMPEG2StreamIdMap_UnmapStreamId( x, p1, p2 ) \
        (x)->lpVtbl->UnmapStreamId( x, p1, p2 )
    #define IMPEG2StreamIdMap_EnumStreamIdMap( x, p ) \
        (x)->lpVtbl->EnumStreamIdMap( x, p )
    #define IRegisterServiceProvider_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IRegisterServiceProvider_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IRegisterServiceProvider_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IRegisterServiceProvider_RegisterService( x, p1, p2 ) \
        (x)->lpVtbl->RegisterService( x, p1, p2 )
    #define IAMClockSlave_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMClockSlave_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMClockSlave_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMClockSlave_SetErrorTolerance( x, p ) \
        (x)->lpVtbl->SetErrorTolerance( x, p )
    #define IAMClockSlave_GetErrorTolerance( x, p ) \
        (x)->lpVtbl->GetErrorTolerance( x, p )
    #define IAMGraphBuilderCallback_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMGraphBuilderCallback_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMGraphBuilderCallback_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMGraphBuilderCallback_SelectedFilter( x, p ) \
        (x)->lpVtbl->SelectedFilter( x, p )
    #define IAMGraphBuilderCallback_CreatedFilter( x, p ) \
        (x)->lpVtbl->CreatedFilter( x, p )
    #define ICodecAPI_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define ICodecAPI_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define ICodecAPI_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define ICodecAPI_IsSupported( x, p ) \
        (x)->lpVtbl->IsSupported( x, p )
    #define ICodecAPI_IsModifiable( x, p ) \
        (x)->lpVtbl->IsModifiable( x, p )
    #define ICodecAPI_GetParameterRange( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetParameterRange( x, p1, p2, p3, p4 )
    #define ICodecAPI_GetParameterValues( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetParameterValues( x, p1, p2, p3 )
    #define ICodecAPI_GetDefaultValue( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultValue( x, p1, p2 )
    #define ICodecAPI_GetValue( x, p1, p2 ) \
        (x)->lpVtbl->GetValue( x, p1, p2 )
    #define ICodecAPI_SetValue( x, p1, p2 ) \
        (x)->lpVtbl->SetValue( x, p1, p2 )
    #define ICodecAPI_RegisterForEvent( x, p1, p2 ) \
        (x)->lpVtbl->RegisterForEvent( x, p1, p2 )
    #define ICodecAPI_UnregisterForEvent( x, p ) \
        (x)->lpVtbl->UnregisterForEvent( x, p )
    #define ICodecAPI_SetAllDefaults( x ) \
        (x)->lpVtbl->SetAllDefaults( x )
    #define ICodecAPI_SetValueWithNotify( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetValueWithNotify( x, p1, p2, p3, p4 )
    #define ICodecAPI_SetAllDefaultsWithNotify( x, p1, p2 ) \
        (x)->lpVtbl->SetAllDefaultsWithNotify( x, p1, p2 )
    #define ICodecAPI_GetAllSettings( x, p ) \
        (x)->lpVtbl->GetAllSettings( x, p )
    #define ICodecAPI_SetAllSettings( x, p ) \
        (x)->lpVtbl->SetAllSettings( x, p )
    #define ICodecAPI_SetAllSettingsWithNotify( x, p1, p2 ) \
        (x)->lpVtbl->SetAllSettingsWithNotify( x, p1, p2 )
    #define IGetCapabilitiesKey_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGetCapabilitiesKey_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGetCapabilitiesKey_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGetCapabilitiesKey_GetCapabilitiesKey( x, p ) \
        (x)->lpVtbl->GetCapabilitiesKey( x, p )
    #define IEncoderAPI_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IEncoderAPI_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IEncoderAPI_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IEncoderAPI_IsSupported( x, p ) \
        (x)->lpVtbl->IsSupported( x, p )
    #define IEncoderAPI_IsAvailable( x, p ) \
        (x)->lpVtbl->IsAvailable( x, p )
    #define IEncoderAPI_GetParameterRange( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetParameterRange( x, p1, p2, p3, p4 )
    #define IEncoderAPI_GetParameterValues( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetParameterValues( x, p1, p2, p3 )
    #define IEncoderAPI_GetDefaultValue( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultValue( x, p1, p2 )
    #define IEncoderAPI_GetValue( x, p1, p2 ) \
        (x)->lpVtbl->GetValue( x, p1, p2 )
    #define IEncoderAPI_SetValue( x, p1, p2 ) \
        (x)->lpVtbl->SetValue( x, p1, p2 )
    #define IVideoEncoder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVideoEncoder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVideoEncoder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVideoEncoder_IsSupported( x, p ) \
        (x)->lpVtbl->IsSupported( x, p )
    #define IVideoEncoder_IsAvailable( x, p ) \
        (x)->lpVtbl->IsAvailable( x, p )
    #define IVideoEncoder_GetParameterRange( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetParameterRange( x, p1, p2, p3, p4 )
    #define IVideoEncoder_GetParameterValues( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetParameterValues( x, p1, p2, p3 )
    #define IVideoEncoder_GetDefaultValue( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultValue( x, p1, p2 )
    #define IVideoEncoder_GetValue( x, p1, p2 ) \
        (x)->lpVtbl->GetValue( x, p1, p2 )
    #define IVideoEncoder_SetValue( x, p1, p2 ) \
        (x)->lpVtbl->SetValue( x, p1, p2 )
    #define IAMDecoderCaps_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMDecoderCaps_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMDecoderCaps_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMDecoderCaps_GetDecoderCaps( x, p1, p2 ) \
        (x)->lpVtbl->GetDecoderCaps( x, p1, p2 )
    #define IAMCertifiedOutputProtection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMCertifiedOutputProtection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMCertifiedOutputProtection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMCertifiedOutputProtection_KeyExchange( x, p1, p2, p3 ) \
        (x)->lpVtbl->KeyExchange( x, p1, p2, p3 )
    #define IAMCertifiedOutputProtection_SessionSequenceStart( x, p ) \
        (x)->lpVtbl->SessionSequenceStart( x, p )
    #define IAMCertifiedOutputProtection_ProtectionCommand( x, p ) \
        (x)->lpVtbl->ProtectionCommand( x, p )
    #define IAMCertifiedOutputProtection_ProtectionStatus( x, p1, p2 ) \
        (x)->lpVtbl->ProtectionStatus( x, p1, p2 )
    #define IAMAsyncReaderTimestampScaling_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMAsyncReaderTimestampScaling_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMAsyncReaderTimestampScaling_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMAsyncReaderTimestampScaling_GetTimestampMode( x, p ) \
        (x)->lpVtbl->GetTimestampMode( x, p )
    #define IAMAsyncReaderTimestampScaling_SetTimestampMode( x, p ) \
        (x)->lpVtbl->SetTimestampMode( x, p )
    #define IAMPluginControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IAMPluginControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IAMPluginControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IAMPluginControl_GetPreferredClsid( x, p1, p2 ) \
        (x)->lpVtbl->GetPreferredClsid( x, p1, p2 )
    #define IAMPluginControl_GetPreferredClsidByIndex( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetPreferredClsidByIndex( x, p1, p2, p3 )
    #define IAMPluginControl_SetPreferredClsid( x, p1, p2 ) \
        (x)->lpVtbl->SetPreferredClsid( x, p1, p2 )
    #define IAMPluginControl_IsDisabled( x, p ) \
        (x)->lpVtbl->IsDisabled( x, p )
    #define IAMPluginControl_GetDisabledByIndex( x, p1, p2 ) \
        (x)->lpVtbl->GetDisabledByIndex( x, p1, p2 )
    #define IAMPluginControl_SetDisabled( x, p1, p2 ) \
        (x)->lpVtbl->SetDisabled( x, p1, p2 )
    #define IAMPluginControl_IsLegacyDisabled( x, p ) \
        (x)->lpVtbl->IsLegacyDisabled( x, p )
    #define IDvdControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdControl_TitlePlay( x, p ) \
        (x)->lpVtbl->TitlePlay( x, p )
    #define IDvdControl_ChapterPlay( x, p1, p2 ) \
        (x)->lpVtbl->ChapterPlay( x, p1, p2 )
    #define IDvdControl_TimePlay( x, p1, p2 ) \
        (x)->lpVtbl->TimePlay( x, p1, p2 )
    #define IDvdControl_StopForResume( x ) \
        (x)->lpVtbl->StopForResume( x )
    #define IDvdControl_GoUp( x ) \
        (x)->lpVtbl->GoUp( x )
    #define IDvdControl_TimeSearch( x, p ) \
        (x)->lpVtbl->TimeSearch( x, p )
    #define IDvdControl_ChapterSearch( x, p ) \
        (x)->lpVtbl->ChapterSearch( x, p )
    #define IDvdControl_PrevPGSearch( x ) \
        (x)->lpVtbl->PrevPGSearch( x )
    #define IDvdControl_TopPGSearch( x ) \
        (x)->lpVtbl->TopPGSearch( x )
    #define IDvdControl_ForwardScan( x, p ) \
        (x)->lpVtbl->ForwardScan( x, p )
    #define IDvdControl_BackwardScan( x, p ) \
        (x)->lpVtbl->BackwardScan( x, p )
    #define IDvdControl_MenuCall( x, p ) \
        (x)->lpVtbl->MenuCall( x, p )
    #define IDvdControl_Resume( x ) \
        (x)->lpVtbl->Resume( x )
    #define IDvdControl_UpperButtonSelect( x ) \
        (x)->lpVtbl->UpperButtonSelect( x )
    #define IDvdControl_LowerButtonSelect( x ) \
        (x)->lpVtbl->LowerButtonSelect( x )
    #define IDvdControl_LeftButtonSelect( x ) \
        (x)->lpVtbl->LeftButtonSelect( x )
    #define IDvdControl_RightButtonSelect( x ) \
        (x)->lpVtbl->RightButtonSelect( x )
    #define IDvdControl_ButtonActivate( x ) \
        (x)->lpVtbl->ButtonActivate( x )
    #define IDvdControl_ButtonSelectAndActivate( x, p ) \
        (x)->lpVtbl->ButtonSelectAndActivate( x, p )
    #define IDvdControl_StillOff( x ) \
        (x)->lpVtbl->StillOff( x )
    #define IDvdControl_PauseOn( x ) \
        (x)->lpVtbl->PauseOn( x )
    #define IDvdControl_PauseOff( x ) \
        (x)->lpVtbl->PauseOff( x )
    #define IDvdControl_MenuLanguageSelect( x, p ) \
        (x)->lpVtbl->MenuLanguageSelect( x, p )
    #define IDvdControl_AudioStreamChange( x, p ) \
        (x)->lpVtbl->AudioStreamChange( x, p )
    #define IDvdControl_SubpictureStreamChange( x, p1, p2 ) \
        (x)->lpVtbl->SubpictureStreamChange( x, p1, p2 )
    #define IDvdControl_AngleChange( x, p ) \
        (x)->lpVtbl->AngleChange( x, p )
    #define IDvdControl_ParentalLevelSelect( x, p ) \
        (x)->lpVtbl->ParentalLevelSelect( x, p )
    #define IDvdControl_ParentalCountrySelect( x, p ) \
        (x)->lpVtbl->ParentalCountrySelect( x, p )
    #define IDvdControl_KaraokeAudioPresentationModeChange( x, p ) \
        (x)->lpVtbl->KaraokeAudioPresentationModeChange( x, p )
    #define IDvdControl_VideoModePreference( x, p ) \
        (x)->lpVtbl->VideoModePreference( x, p )
    #define IDvdControl_SetRoot( x, p ) \
        (x)->lpVtbl->SetRoot( x, p )
    #define IDvdControl_MouseActivate( x, p ) \
        (x)->lpVtbl->MouseActivate( x, p )
    #define IDvdControl_MouseSelect( x, p ) \
        (x)->lpVtbl->MouseSelect( x, p )
    #define IDvdControl_ChapterPlayAutoStop( x, p1, p2, p3 ) \
        (x)->lpVtbl->ChapterPlayAutoStop( x, p1, p2, p3 )
    #define IDvdInfo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdInfo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdInfo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdInfo_GetCurrentDomain( x, p ) \
        (x)->lpVtbl->GetCurrentDomain( x, p )
    #define IDvdInfo_GetCurrentLocation( x, p ) \
        (x)->lpVtbl->GetCurrentLocation( x, p )
    #define IDvdInfo_GetTotalTitleTime( x, p ) \
        (x)->lpVtbl->GetTotalTitleTime( x, p )
    #define IDvdInfo_GetCurrentButton( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentButton( x, p1, p2 )
    #define IDvdInfo_GetCurrentAngle( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentAngle( x, p1, p2 )
    #define IDvdInfo_GetCurrentAudio( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentAudio( x, p1, p2 )
    #define IDvdInfo_GetCurrentSubpicture( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCurrentSubpicture( x, p1, p2, p3 )
    #define IDvdInfo_GetCurrentUOPS( x, p ) \
        (x)->lpVtbl->GetCurrentUOPS( x, p )
    #define IDvdInfo_GetAllSPRMs( x, p ) \
        (x)->lpVtbl->GetAllSPRMs( x, p )
    #define IDvdInfo_GetAllGPRMs( x, p ) \
        (x)->lpVtbl->GetAllGPRMs( x, p )
    #define IDvdInfo_GetAudioLanguage( x, p ) \
        (x)->lpVtbl->GetAudioLanguage( x, p )
    #define IDvdInfo_GetSubpictureLanguage( x, p ) \
        (x)->lpVtbl->GetSubpictureLanguage( x, p )
    #define IDvdInfo_GetTitleAttributes( x, p1, p2 ) \
        (x)->lpVtbl->GetTitleAttributes( x, p1, p2 )
    #define IDvdInfo_GetVMGAttributes( x, p ) \
        (x)->lpVtbl->GetVMGAttributes( x, p )
    #define IDvdInfo_GetCurrentVideoAttributes( x, p ) \
        (x)->lpVtbl->GetCurrentVideoAttributes( x, p )
    #define IDvdInfo_GetCurrentAudioAttributes( x, p ) \
        (x)->lpVtbl->GetCurrentAudioAttributes( x, p )
    #define IDvdInfo_GetCurrentSubpictureAttributes( x, p ) \
        (x)->lpVtbl->GetCurrentSubpictureAttributes( x, p )
    #define IDvdInfo_GetCurrentVolumeInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetCurrentVolumeInfo( x, p1, p2, p3, p4 )
    #define IDvdInfo_GetDVDTextInfo( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDVDTextInfo( x, p1, p2, p3 )
    #define IDvdInfo_GetPlayerParentalLevel( x, p1, p2 ) \
        (x)->lpVtbl->GetPlayerParentalLevel( x, p1, p2 )
    #define IDvdInfo_GetNumberOfChapters( x, p1, p2 ) \
        (x)->lpVtbl->GetNumberOfChapters( x, p1, p2 )
    #define IDvdInfo_GetTitleParentalLevel( x, p1, p2 ) \
        (x)->lpVtbl->GetTitleParentalLevel( x, p1, p2 )
    #define IDvdInfo_GetRoot( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetRoot( x, p1, p2, p3 )
    #define IDvdCmd_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdCmd_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdCmd_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdCmd_WaitForStart( x ) \
        (x)->lpVtbl->WaitForStart( x )
    #define IDvdCmd_WaitForEnd( x ) \
        (x)->lpVtbl->WaitForEnd( x )
    #define IDvdState_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdState_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdState_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdState_GetDiscID( x, p ) \
        (x)->lpVtbl->GetDiscID( x, p )
    #define IDvdState_GetParentalLevel( x, p ) \
        (x)->lpVtbl->GetParentalLevel( x, p )
    #define IDvdControl2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdControl2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdControl2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdControl2_PlayTitle( x, p1, p2, p3 ) \
        (x)->lpVtbl->PlayTitle( x, p1, p2, p3 )
    #define IDvdControl2_PlayChapterInTitle( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PlayChapterInTitle( x, p1, p2, p3, p4 )
    #define IDvdControl2_PlayAtTimeInTitle( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->PlayAtTimeInTitle( x, p1, p2, p3, p4 )
    #define IDvdControl2_Stop( x ) \
        (x)->lpVtbl->Stop( x )
    #define IDvdControl2_ReturnFromSubmenu( x, p1, p2 ) \
        (x)->lpVtbl->ReturnFromSubmenu( x, p1, p2 )
    #define IDvdControl2_PlayAtTime( x, p1, p2, p3 ) \
        (x)->lpVtbl->PlayAtTime( x, p1, p2, p3 )
    #define IDvdControl2_PlayChapter( x, p1, p2, p3 ) \
        (x)->lpVtbl->PlayChapter( x, p1, p2, p3 )
    #define IDvdControl2_PlayPrevChapter( x, p1, p2 ) \
        (x)->lpVtbl->PlayPrevChapter( x, p1, p2 )
    #define IDvdControl2_ReplayChapter( x, p1, p2 ) \
        (x)->lpVtbl->ReplayChapter( x, p1, p2 )
    #define IDvdControl2_PlayNextChapter( x, p1, p2 ) \
        (x)->lpVtbl->PlayNextChapter( x, p1, p2 )
    #define IDvdControl2_PlayForwards( x, p1, p2, p3 ) \
        (x)->lpVtbl->PlayForwards( x, p1, p2, p3 )
    #define IDvdControl2_PlayBackwards( x, p1, p2, p3 ) \
        (x)->lpVtbl->PlayBackwards( x, p1, p2, p3 )
    #define IDvdControl2_ShowMenu( x, p1, p2, p3 ) \
        (x)->lpVtbl->ShowMenu( x, p1, p2, p3 )
    #define IDvdControl2_Resume( x, p1, p2 ) \
        (x)->lpVtbl->Resume( x, p1, p2 )
    #define IDvdControl2_SelectRelativeButton( x, p ) \
        (x)->lpVtbl->SelectRelativeButton( x, p )
    #define IDvdControl2_ActivateButton( x ) \
        (x)->lpVtbl->ActivateButton( x )
    #define IDvdControl2_SelectButton( x, p ) \
        (x)->lpVtbl->SelectButton( x, p )
    #define IDvdControl2_SelectAndActivateButton( x, p ) \
        (x)->lpVtbl->SelectAndActivateButton( x, p )
    #define IDvdControl2_StillOff( x ) \
        (x)->lpVtbl->StillOff( x )
    #define IDvdControl2_Pause( x, p ) \
        (x)->lpVtbl->Pause( x, p )
    #define IDvdControl2_SelectAudioStream( x, p1, p2, p3 ) \
        (x)->lpVtbl->SelectAudioStream( x, p1, p2, p3 )
    #define IDvdControl2_SelectSubpictureStream( x, p1, p2, p3 ) \
        (x)->lpVtbl->SelectSubpictureStream( x, p1, p2, p3 )
    #define IDvdControl2_SetSubpictureState( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetSubpictureState( x, p1, p2, p3 )
    #define IDvdControl2_SelectAngle( x, p1, p2, p3 ) \
        (x)->lpVtbl->SelectAngle( x, p1, p2, p3 )
    #define IDvdControl2_SelectParentalLevel( x, p ) \
        (x)->lpVtbl->SelectParentalLevel( x, p )
    #define IDvdControl2_SelectParentalCountry( x, p ) \
        (x)->lpVtbl->SelectParentalCountry( x, p )
    #define IDvdControl2_SelectKaraokeAudioPresentationMode( x, p ) \
        (x)->lpVtbl->SelectKaraokeAudioPresentationMode( x, p )
    #define IDvdControl2_SelectVideoModePreference( x, p ) \
        (x)->lpVtbl->SelectVideoModePreference( x, p )
    #define IDvdControl2_SetDVDDirectory( x, p ) \
        (x)->lpVtbl->SetDVDDirectory( x, p )
    #define IDvdControl2_ActivateAtPosition( x, p ) \
        (x)->lpVtbl->ActivateAtPosition( x, p )
    #define IDvdControl2_SelectAtPosition( x, p ) \
        (x)->lpVtbl->SelectAtPosition( x, p )
    #define IDvdControl2_PlayChaptersAutoStop( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->PlayChaptersAutoStop( x, p1, p2, p3, p4, p5 )
    #define IDvdControl2_AcceptParentalLevelChange( x, p ) \
        (x)->lpVtbl->AcceptParentalLevelChange( x, p )
    #define IDvdControl2_SetOption( x, p1, p2 ) \
        (x)->lpVtbl->SetOption( x, p1, p2 )
    #define IDvdControl2_SetState( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetState( x, p1, p2, p3 )
    #define IDvdControl2_PlayPeriodInTitleAutoStop( x, p1, p2, p3, p4, p5 ) \
        (x)->lpVtbl->PlayPeriodInTitleAutoStop( x, p1, p2, p3, p4, p5 )
    #define IDvdControl2_SetGPRM( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->SetGPRM( x, p1, p2, p3, p4 )
    #define IDvdControl2_SelectDefaultMenuLanguage( x, p ) \
        (x)->lpVtbl->SelectDefaultMenuLanguage( x, p )
    #define IDvdControl2_SelectDefaultAudioLanguage( x, p1, p2 ) \
        (x)->lpVtbl->SelectDefaultAudioLanguage( x, p1, p2 )
    #define IDvdControl2_SelectDefaultSubpictureLanguage( x, p1, p2 ) \
        (x)->lpVtbl->SelectDefaultSubpictureLanguage( x, p1, p2 )
    #define IDvdInfo2_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdInfo2_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdInfo2_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdInfo2_GetCurrentDomain( x, p ) \
        (x)->lpVtbl->GetCurrentDomain( x, p )
    #define IDvdInfo2_GetCurrentLocation( x, p ) \
        (x)->lpVtbl->GetCurrentLocation( x, p )
    #define IDvdInfo2_GetTotalTitleTime( x, p1, p2 ) \
        (x)->lpVtbl->GetTotalTitleTime( x, p1, p2 )
    #define IDvdInfo2_GetCurrentButton( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentButton( x, p1, p2 )
    #define IDvdInfo2_GetCurrentAngle( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentAngle( x, p1, p2 )
    #define IDvdInfo2_GetCurrentAudio( x, p1, p2 ) \
        (x)->lpVtbl->GetCurrentAudio( x, p1, p2 )
    #define IDvdInfo2_GetCurrentSubpicture( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetCurrentSubpicture( x, p1, p2, p3 )
    #define IDvdInfo2_GetCurrentUOPS( x, p ) \
        (x)->lpVtbl->GetCurrentUOPS( x, p )
    #define IDvdInfo2_GetAllSPRMs( x, p ) \
        (x)->lpVtbl->GetAllSPRMs( x, p )
    #define IDvdInfo2_GetAllGPRMs( x, p ) \
        (x)->lpVtbl->GetAllGPRMs( x, p )
    #define IDvdInfo2_GetAudioLanguage( x, p1, p2 ) \
        (x)->lpVtbl->GetAudioLanguage( x, p1, p2 )
    #define IDvdInfo2_GetSubpictureLanguage( x, p1, p2 ) \
        (x)->lpVtbl->GetSubpictureLangauge( x, p1, p2 )
    #define IDvdInfo2_GetTitleAttributes( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetTitleAttributes( x, p1, p2, p3 )
    #define IDvdInfo2_GetVMGAttributes( x, p ) \
        (x)->lpVtbl->GetVMGAttributes( x, p )
    #define IDvdInfo2_GetCurrentVideoAttributes( x, p ) \
        (x)->lpVtbl->GetCurrentVideoAttributes( x, p )
    #define IDvdInfo2_GetAudioAttributes( x, p1, p2 ) \
        (x)->lpVtbl->GetAudioAttributes( x, p1, p2 )
    #define IDvdInfo2_GetKaraokeAttributes( x, p1, p2 ) \
        (x)->lpVtbl->GetKaraokeAttributes( x, p1, p2 )
    #define IDvdInfo2_GetSubpictureAttributes( x, p1, p2 ) \
        (x)->lpVtbl->GetSubpictureAttributes( x, p1, p2 )
    #define IDvdInfo2_GetDVDVolumeInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDVDVolumeInfo( x, p1, p2, p3, p4 )
    #define IDvdInfo2_GetDVDTextNumberOfLanguages( x, p ) \
        (x)->lpVtbl->GetDVDTextNumberOfLanguages( x, p )
    #define IDvdInfo2_GetDVDTextLanguageInfo( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetDVDTextLanguageInfo( x, p1, p2, p3, p4 )
    #define IDvdInfo2_GetDVDTextStringAsNative( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetDVDTextStringAsNative( x, p1, p2, p3, p4, p5, p6 )
    #define IDvdInfo2_GetDVDTextStringAsUnicode( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->GetDVDTextStringAsUnicode( x, p1, p2, p3, p4, p5, p6 )
    #define IDvdInfo2_GetPlayerParentalLevel( x, p1, p2 ) \
        (x)->lpVtbl->GetPlayerParentalLevel( x, p1, p2 )
    #define IDvdInfo2_GetNumberOfChapters( x, p1, p2 ) \
        (x)->lpVtbl->GetNumberOfChapters( x, p1, p2 )
    #define IDvdInfo2_GetTitleParentalLevels( x, p1, p2 ) \
        (x)->lpVtbl->GetTitleParentalLevels( x, p1, p2 )
    #define IDvdInfo2_GetDVDDirectory( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDVDDirectory( x, p1, p2, p3 )
    #define IDvdInfo2_IsAudioStreamEnabled( x, p1, p2 ) \
        (x)->lpVtbl->IsAudioStreamEnabled( x, p1, p2 )
    #define IDvdInfo2_GetDiscID( x, p1, p2 ) \
        (x)->lpVtbl->GetDiscID( x, p1, p2 )
    #define IDvdInfo2_GetState( x, p ) \
        (x)->lpVtbl->GetState( x, p )
    #define IDvdInfo2_GetMenuLanguages( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetMenuLanguages( x, p1, p2, p3 )
    #define IDvdInfo2_GetButtonAtPosition( x, p1, p2 ) \
        (x)->lpVtbl->GetButtonAtPosition( x, p1, p2 )
    #define IDvdInfo2_GetCmdFromEvent( x, p1, p2 ) \
        (x)->lpVtbl->GetCmdFromEvent( x, p1, p2 )
    #define IDvdInfo2_GetDefaultMenuLanguage( x, p ) \
        (x)->lpVtbl->GetDefaultMenuLanguage( x, p )
    #define IDvdInfo2_GetDefaultAudioLanguage( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultAudioLanguage( x, p1, p2 )
    #define IDvdInfo2_GetDefaultSubpictureLanguage( x, p1, p2 ) \
        (x)->lpVtbl->GetDefaultSubpictureLanguage( x, p1, p2 )
    #define IDvdInfo2_GetDecoderCaps( x, p ) \
        (x)->lpVtbl->GetDecoderCaps( x, p )
    #define IDvdInfo2_GetButtonRect( x, p1, p2 ) \
        (x)->lpVtbl->GetButtonRect( x, p1, p2 )
    #define IDvdInfo2_IsSubpictureStreamEnabled( x, p1, p2 ) \
        (x)->lpVtbl->IsSubpictureStreamEnabled( x, p1, p2 )
    #define IDvdGraphBuilder_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDvdGraphBuilder_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDvdGraphBuilder_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDvdGraphBuilder_GetFiltergraph( x, p ) \
        (x)->lpVtbl->GetFiltergraph( x, p )
    #define IDvdGraphBuilder_GetDvdInterface( x, p1, p2 ) \
        (x)->lpVtbl->GetDvdInterface( x, p1, p2 )
    #define IDvdGraphBuilder_RenderDvdVideoVolume( x, p1, p2, p3 ) \
        (x)->lpVtbl->RenderDvdVideoVolume( x, p1, p2, p3 )
    #define IDDrawExclModeVideo_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDDrawExclModeVideo_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDDrawExclModeVideo_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDDrawExclModeVideo_SetDDrawObject( x, p ) \
        (x)->lpVtbl->SetDDrawObject( x, p )
    #define IDDrawExclModeVideo_GetDDrawObject( x, p1, p2 ) \
        (x)->lpVtbl->GetDDrawObject( x, p1, p2 )
    #define IDDrawExclModeVideo_SetDDrawSurface( x, p ) \
        (x)->lpVtbl->SetDDrawSurface( x, p )
    #define IDDrawExclModeVideo_GetDDrawSurface( x, p1, p2 ) \
        (x)->lpVtbl->GetDDrawSurface( x, p1, p2 )
    #define IDDrawExclModeVideo_SetDrawParameters( x, p1, p2 ) \
        (x)->lpVtbl->SetDrawParameters( x, p1, p2 )
    #define IDDrawExclModeVideo_GetNativeVideoProps( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetNativeVideoProps( x, p1, p2, p3, p4 )
    #define IDDrawExclModeVideo_SetCallbackInterface( x, p1, p2 ) \
        (x)->lpVtbl->SetCallbackInterface( x, p1, p2 )
    #define IDDrawExclModeVideoCallback_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IDDrawExclModeVideoCallback_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IDDrawExclModeVideoCallback_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IDDrawExclModeVideoCallback_OnUpdateOverlay( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->OnUpdateOverlay( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IDDrawExclModeVideoCallback_OnUpdateColorKey( x, p1, p2 ) \
        (x)->lpVtbl->OnUpdateColorKey( x, p1, p2 )
    #define IDDrawExclModeVideoCallback_OnUpdateSize( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->OnUpdateSize( x, p1, p2, p3, p4 )
    #define IPinConnection_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPinConnection_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPinConnection_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPinConnection_DynamicQueryAccept( x, p ) \
        (x)->lpVtbl->DynamicQueryAccept( x, p )
    #define IPinConnection_NotifyEndOfStream( x, p ) \
        (x)->lpVtbl->NotifyEndOfStream( x, p )
    #define IPinConnection_IsEndPin( x ) \
        (x)->lpVtbl->IsEndPin( x )
    #define IPinConnection_DynamicDisconnect( x ) \
        (x)->lpVtbl->DynamicDisconnect( x )
    #define IPinFlowControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IPinFlowControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IPinFlowControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IPinFlowControl_Block( x, p1, p2 ) \
        (x)->lpVtbl->Block( x, p1, p2 )
    #define IGraphConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGraphConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGraphConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGraphConfig_Reconnect( x, p1, p2, p3, p4, p5, p6 ) \
        (x)->lpVtbl->Reconnect( x, p1, p2, p3, p4, p5, p6 )
    #define IGraphConfig_Reconfigure( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->Reconfigure( x, p1, p2, p3, p4 )
    #define IGraphConfig_AddFilterToCache( x, p ) \
        (x)->lpVtbl->AddFilterToCache( x, p )
    #define IGraphConfig_EnumCacheFilter( x, p ) \
        (x)->lpVtbl->EnumCacheFilter( x, p )
    #define IGraphConfig_RemoveFilterFromCache( x, p ) \
        (x)->lpVtbl->RemoveFilterFromCache( x, p )
    #define IGraphConfig_GetStartTime( x, p ) \
        (x)->lpVtbl->GetStartTime( x, p )
    #define IGraphConfig_PushThroughData( x, p1, p2, p3 ) \
        (x)->lpVtbl->PushThroughData( x, p1, p2, p3 )
    #define IGraphConfig_SetFilterFlags( x, p1, p2 ) \
        (x)->lpVtbl->SetFilterFlags( x, p1, p2 )
    #define IGraphConfig_GetFilterFlags( x, p1, p2 ) \
        (x)->lpVtbl->GetFilterFlags( x, p1, p2 )
    #define IGraphConfig_RemoveFilterEx( x, p1, p2 ) \
        (x)->lpVtbl->RemoveFilterEx( x, p1, p2 )
    #define IGraphConfigCallback_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IGraphConfigCallback_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IGraphConfigCallback_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IGraphConfigCallback_Reconfigure( x, p1, p2 ) \
        (x)->lpVtbl->Reconfigure( x, p1, p2 )
    #define IFilterChain_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IFilterChain_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IFilterChain_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IFilterChain_StartChain( x, p1, p2 ) \
        (x)->lpVtbl->StartChain( x, p1, p2 )
    #define IFilterChain_PauseChain( x, p1, p2 ) \
        (x)->lpVtbl->PauseChain( x, p1, p2 )
    #define IFilterChain_StopChain( x, p1, p2 ) \
        (x)->lpVtbl->StopChain( x, p1, p2 )
    #define IFilterChain_RemoveChain( x, p1, p2 ) \
        (x)->lpVtbl->RemoveChain( x, p1, p2 )
    #define IVMRImagePresenter_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRImagePresenter_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRImagePresenter_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRImagePresenter_StartPresenting( x, p ) \
        (x)->lpVtbl->StartPresenting( x, p )
    #define IVMRImagePresenter_StopPresenting( x, p ) \
        (x)->lpVtbl->StopPresenting( x, p )
    #define IVMRImagePresenter_PresentImage( x, p1, p2 ) \
        (x)->lpVtbl->PresentImage( x, p1, p2 )
    #define IVMRSurfaceAllocator_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRSurfaceAllocator_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRSurfaceAllocator_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRSurfaceAllocator_AllocateSurface( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->AllocateSurface( x, p1, p2, p3, p4 )
    #define IVMRSurfaceAllocator_FreeSurface( x, p ) \
        (x)->lpVtbl->FreeSurface( x, p )
    #define IVMRSurfaceAllocator_PrepareSurface( x, p1, p2, p3 ) \
        (x)->lpVtbl->PrepareSurface( x, p1, p2, p3 )
    #define IVMRSurfaceAllocator_AdviseNotify( x, p ) \
        (x)->lpVtbl->AdviseNotify( x, p )
    #define IVMRSurfaceAllocatorNotify_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRSurfaceAllocatorNotify_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRSurfaceAllocatorNotify_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRSurfaceAllocatorNotify_AdviseSurfaceAllocator( x, p1, p2 ) \
        (x)->lpVtbl->AdviseSurfaceAllocator( x, p1, p2 )
    #define IVMRSurfaceAllocatorNotify_SetDDrawDevice( x, p1, p2 ) \
        (x)->lpVtbl->SetDDrawDevice( x, p1, p2 )
    #define IVMRSurfaceAllocatorNotify_ChangeDDrawDevice( x, p1, p2 ) \
        (x)->lpVtbl->ChangeDDrawDevice( x, p1, p2 )
    #define IVMRSurfaceAllocatorNotify_RestoreDDrawSurfaces( x ) \
        (x)->lpVtbl->RestoreDDrawSurfaces( x )
    #define IVMRSurfaceAllocatorNotify_NotifyEvent( x, p1, p2, p3 ) \
        (x)->lpVtbl->NotifyEvent( x, p1, p2, p3 )
    #define IVMRSurfaceAllocatorNotify_SetBorderColor( x, p ) \
        (x)->lpVtbl->SetBorderColor( x, p )
    #define IVMRWindowlessControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRWindowlessControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRWindowlessControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRWindowlessControl_GetNativeVideoSize( x, p1, p2, p3, p4 ) \
        (x)->lpVtbl->GetNativeVideoSize( x, p1, p2, p3, p4 )
    #define IVMRWindowlessControl_GetMinIdealVideoSize( x, p1, p2 ) \
        (x)->lpVtbl->GetMinIdealVideoSize( x, p1, p2 )
    #define IVMRWindowlessControl_GetMaxIdealVideoSize( x, p1, p2 ) \
        (x)->lpVtbl->GetMaxIdealVideoSize( x, p1, p2 )
    #define IVMRWindowlessControl_SetVideoPosition( x, p1, p2 ) \
        (x)->lpVtbl->SetVideoPosition( x, p1, p2 )
    #define IVMRWindowlessControl_GetVideoPosition( x, p1, p2 ) \
        (x)->lpVtbl->GetVideoPosition( x, p1, p2 )
    #define IVMRWindowlessControl_GetAspectRatioMode( x, p ) \
        (x)->lpVtbl->GetAspectRatioMode( x, p )
    #define IVMRWindowlessControl_SetAspectRatioMode( x, p ) \
        (x)->lpVtbl->SetAspectRatioMode( x, p )
    #define IVMRWindowlessControl_SetVideoClippingWindow( x, p ) \
        (x)->lpVtbl->SetVideoClippingWindow( x, p )
    #define IVMRWindowlessControl_RepaintVideo( x, p1, p2 ) \
        (x)->lpVtbl->RepaintVideo( x, p1, p2 )
    #define IVMRWindowlessControl_DisplayModeChanged( x ) \
        (x)->lpVtbl->DisplayModeChanged( x )
    #define IVMRWindowlessControl_GetCurrentImage( x, p ) \
        (x)->lpVtbl->GetCurrentImage( x, p )
    #define IVMRWindowlessControl_SetBorderColor( x, p ) \
        (x)->lpVtbl->SetBorderColor( x, p )
    #define IVMRWindowlessControl_GetBorderColor( x, p ) \
        (x)->lpVtbl->GetBorderColor( x, p )
    #define IVMRWindowlessControl_SetColorKey( x, p ) \
        (x)->lpVtbl->SetColorKey( x, p )
    #define IVMRWindowlessControl_GetColorKey( x, p ) \
        (x)->lpVtbl->GetColorKey( x, p )
    #define IVMRMixerControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRMixerControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRMixerControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRMixerControl_SetAlpha( x, p1, p2 ) \
        (x)->lpVtbl->SetAlpha( x, p1, p2 )
    #define IVMRMixerControl_GetAlpha( x, p1, p2 ) \
        (x)->lpVtbl->GetAlpha( x, p1, p2 )
    #define IVMRMixerControl_SetZOrder( x, p1, p2 ) \
        (x)->lpVtbl->SetZOrder( x, p1, p2 )
    #define IVMRMixerControl_GetZOrder( x, p1, p2 ) \
        (x)->lpVtbl->GetZOrder( x, p1, p2 )
    #define IVMRMixerControl_SetOutputRect( x, p1, p2 ) \
        (x)->lpVtbl->SetOutputRect( x, p1, p2 )
    #define IVMRMixerControl_GetOutputRect( x, p1, p2 ) \
        (x)->lpVtbl->GetOutputRect( x, p1, p2 )
    #define IVMRMixerControl_SetBackgroundClr( x, p ) \
        (x)->lpVtbl->SetBackgroundClr( x, p )
    #define IVMRMixerControl_GetBackgroundClr( x, p ) \
        (x)->lpVtbl->GetBackgroundClr( x, p )
    #define IVMRMixerControl_SetMixingPrefs( x, p ) \
        (x)->lpVtbl->SetMixingPrefs( x, p )
    #define IVMRMixerControl_GetMixingPrefs( x, p ) \
        (x)->lpVtbl->GetMixingPrefs( x, p )
    #define IVMRMonitorConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRMonitorConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRMonitorConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRMonitorConfig_SetMonitor( x, p ) \
        (x)->lpVtbl->SetMonitor( x, p )
    #define IVMRMonitorConfig_GetMonitor( x, p ) \
        (x)->lpVtbl->GetMonitor( x, p )
    #define IVMRMonitorConfig_SetDefaultMonitor( x, p ) \
        (x)->lpVtbl->SetDefaultMonitor( x, p )
    #define IVMRMonitorConfig_GetDefaultMonitor( x, p ) \
        (x)->lpVtbl->GetDefaultMonitor( x, p )
    #define IVMRMonitorConfig_GetAvailableMonitors( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetAvailableMonitors( x, p1, p2, p3 )
    #define IVMRFilterConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRFilterConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRFilterConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRFilterConfig_SetImageCompositor( x, p ) \
        (x)->lpVtbl->SetImageCompositor( x, p )
    #define IVMRFilterConfig_SetNumberOfStreams( x, p ) \
        (x)->lpVtbl->SetNumberOfStreams( x, p )
    #define IVMRFilterConfig_GetNumberOfStreams( x, p ) \
        (x)->lpVtbl->GetNumberOfStreams( x, p )
    #define IVMRFilterConfig_SetRenderingPrefs( x, p ) \
        (x)->lpVtbl->SetRenderingPrefs( x, p )
    #define IVMRFilterConfig_GetRenderingPrefs( x, p ) \
        (x)->lpVtbl->GetRenderingPrefs( x, p )
    #define IVMRFilterConfig_SetRenderingMode( x, p ) \
        (x)->lpVtbl->SetRenderingMode( x, p )
    #define IVMRFilterConfig_GetRenderingMode( x, p ) \
        (x)->lpVtbl->GetRenderingMode( x, p )
    #define IVMRAspectRatioControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRAspectRatioControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRAspectRatioControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRAspectRatioControl_GetAspectRatioControl( x, p ) \
        (x)->lpVtbl->GetAspectRatioControl( x, p )
    #define IVMRAspectRatioControl_SetAspectRatioControl( x, p ) \
        (x)->lpVtbl->SetAspectRatioControl( x, p )
    #define IVMRDeinterlaceControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRDeinterlaceControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRDeinterlaceControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRDeinterlaceControl_GetNumberOfDeinterlaceModes( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetNumberOfDeinterlaceModes( x, p1, p2, p3 )
    #define IVMRDeinterlaceControl_GetDeinterlaceModeCaps( x, p1, p2, p3 ) \
        (x)->lpVtbl->GetDeinterlaceModeCaps( x, p1, p2, p3 )
    #define IVMRDeinterlaceControl_GetDeinterlaceMode( x, p1, p2 ) \
        (x)->lpVtbl->GetDeinterlaceMode( x, p1, p2 )
    #define IVMRDeinterlaceControl_SetDeinterlaceMode( x, p1, p2 ) \
        (x)->lpVtbl->SetDeinterlaceMode( x, p1, p2 )
    #define IVMRDeinterlaceControl_GetDeinterlacePrefs( x, p1, p2 ) \
        (x)->lpVtbl->GetDeinterlacePrefs( x, p1, p2 )
    #define IVMRDeinterlaceControl_SetDeinterlacePrefs( x, p1, p2 ) \
        (x)->lpVtbl->SetDeinterlacePrefs( x, p1, p2 )
    #define IVMRDeinterlaceControl_GetActualDeinterlaceMode( x, p1, p2 ) \
        (x)->lpVtbl->GetActualDeinterlaceMode( x, p1, p2 )
    #define IVMRMixerControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRMixerControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRMixerControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRMixerControl_SetAlphaBitmap( x, p ) \
        (x)->lpVtbl->SetAlphaBitmap( x, p )
    #define IVMRMixerControl_UpdateAlphaBitmapParameters( x, p ) \
        (x)->lpVtbl->UpdateAlphaBitmapParameters( x, p )
    #define IVMRMixerControl_GetAlphaBitmapParameters( x, p ) \
        (x)->lpVtbl->GetAlphaBitmapParameters( x, p )
    #define IVMRImageCompositor_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRImageCompositor_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRImageCompositor_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRImageCompositor_InitCompositionTarget( x, p1, p2 ) \
        (x)->lpVtbl->InitCompositionTarget( x, p1, p2 )
    #define IVMRImageCompositor_TermCompositionTarget( x, p1, p2 ) \
        (x)->lpVtbl->TermCompositionTarget( x, p1, p2 )
    #define IVMRImageCompositor_SetStreamMediaType( x, p1, p2, p3 ) \
        (x)->lpVtbl->SetStreamMediaType( x, p1, p2, p3 )
    #define IVMRImageCompositor_CompositeImage( x, p1, p2, p3, p4, p5, p6, p7, p8 ) \
        (x)->lpVtbl->CompositeImage( x, p1, p2, p3, p4, p5, p6, p7, p8 )
    #define IVMRVideoStreamControl_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRVideoStreamControl_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRVideoStreamControl_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRVideoStreamControl_SetColorKey( x, p ) \
        (x)->lpVtbl->SetColorKey( x, p )
    #define IVMRVideoStreamControl_GetColorKey( x, p ) \
        (x)->lpVtbl->GetColorKey( x, p )
    #define IVMRVideoStreamControl_SetStreamActiveState( x, p ) \
        (x)->lpVtbl->SetStreamActiveState( x, p )
    #define IVMRVideoStreamControl_GetStreamActiveState( x, p ) \
        (x)->lpVtbl->GetStreamActiveState( x, p )
    #define IVMRSurface_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRSurface_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRSurface_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRSurface_IsSurfaceLocked( x ) \
        (x)->lpVtbl->IsSurfaceLocked( x )
    #define IVMRSurface_LockSurface( x, p ) \
        (x)->lpVtbl->LockSurface( x, p )
    #define IVMRSurface_UnlockSurface( x ) \
        (x)->lpVtbl->UnlockSurface( x )
    #define IVMRSurface_GetSurface( x, p ) \
        (x)->lpVtbl->GetSurface( x, p )
    #define IVMRImagePresenterConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRImagePresenterConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRImagePresenterConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRImagePresenterConfig_SetRenderingFlags( x, p ) \
        (x)->lpVtbl->SetRenderingFlags( x, p )
    #define IVMRImagePresenterConfig_GetRenderingFlags( x, p ) \
        (x)->lpVtbl->GetRenderingFlags( x, p )
    #define IVMRImagePresenterExclModeConfig_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVMRImagePresenterExclModeConfig_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVMRImagePresenterExclModeConfig_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVMRImagePresenterExclModeConfig_SetRenderingFlags( x, p ) \
        (x)->lpVtbl->SetRenderingFlags( x, p )
    #define IVMRImagePresenterExclModeConfig_GetRenderingFlags( x, p ) \
        (x)->lpVtbl->GetRenderingFlags( x, p )
    #define IVMRImagePresenterExclModeConfig_SetXlcModeDDObjAndPrimarySurface( x, p1, p2 ) \
        (x)->lpVtbl->SetXlcModeDDObjAndPrimarySurface( x, p1, p2 )
    #define IVMRImagePresenterExclModeConfig_GetXlcModeDDObjAndPrimarySurface( x, p1, p2 ) \
        (x)->lpVtbl->GetXlcModeDDObjAndPrimarySurface( x, p1, p2 )
    #define IVPManager_QueryInterface( x, p1, p2 ) \
        (x)->lpVtbl->QueryInterface( x, p1, p2 )
    #define IVPManager_AddRef( x ) \
        (x)->lpVtbl->AddRef( x )
    #define IVPManager_Release( x ) \
        (x)->lpVtbl->Release( x )
    #define IVPManager_SetVideoPortIndex( x, p ) \
        (x)->lpVtbl->SetVideoPortIndex( x, p )
    #define IVPManager_GetVideoPortIndex( x, p ) \
        (x)->lpVtbl->GetVideoPortIndex( x, p )
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

/* GUIDs */
EXTERN_C const IID  __cdecl IID_ICreateDevEnum;
EXTERN_C const IID  __cdecl IID_IPin;
EXTERN_C const IID  __cdecl IID_IEnumPins;
EXTERN_C const IID  __cdecl IID_IEnumMediaTypes;
EXTERN_C const IID  __cdecl IID_IFilterGraph;
EXTERN_C const IID  __cdecl IID_IEnumFilters;
EXTERN_C const IID  __cdecl IID_IMediaFilter;
EXTERN_C const IID  __cdecl IID_IBaseFilter;
EXTERN_C const IID  __cdecl IID_IReferenceClock;
EXTERN_C const IID  __cdecl IID_IReferenceClockTimerControl;
EXTERN_C const IID  __cdecl IID_IReferenceClock2;
EXTERN_C const IID  __cdecl IID_IMediaSample;
EXTERN_C const IID  __cdecl IID_IMediaSample2;
EXTERN_C const IID  __cdecl IID_IMediaSample2Config;
EXTERN_C const IID  __cdecl IID_IMemAllocator;
EXTERN_C const IID  __cdecl IID_IMemAllocatorCallbackTemp;
EXTERN_C const IID  __cdecl IID_IMemAllocatorNotifyCallbackTemp;
EXTERN_C const IID  __cdecl IID_IMemInputPin;
EXTERN_C const IID  __cdecl IID_IAMovieSetup;
EXTERN_C const IID  __cdecl IID_IMediaSeeking;
EXTERN_C const IID  __cdecl IID_IEnumRegFilters;
EXTERN_C const IID  __cdecl IID_IFilterMapper;
EXTERN_C const IID  __cdecl IID_IFilterMapper2;
EXTERN_C const IID  __cdecl IID_IFilterMapper3;
EXTERN_C const IID  __cdecl IID_IQualityControl;
EXTERN_C const IID  __cdecl IID_IOverlayNotify;
EXTERN_C const IID  __cdecl IID_IOverlayNotify2;
EXTERN_C const IID  __cdecl IID_IOverlay;
EXTERN_C const IID  __cdecl IID_IMediaEventSink;
EXTERN_C const IID  __cdecl IID_IFileSourceFilter;
EXTERN_C const IID  __cdecl IID_IFileSinkFilter;
EXTERN_C const IID  __cdecl IID_IFileSinkFilter2;
EXTERN_C const IID  __cdecl IID_IGraphBuilder;
EXTERN_C const IID  __cdecl IID_ICaptureGraphBuilder;
EXTERN_C const IID  __cdecl IID_IAMCopyCaptureFileProgress;
EXTERN_C const IID  __cdecl IID_ICaptureGraphBuilder2;
EXTERN_C const IID  __cdecl IID_IFilterGraph2;
EXTERN_C const IID  __cdecl IID_IFilterGraph3;
EXTERN_C const IID  __cdecl IID_IStreamBuilder;
EXTERN_C const IID  __cdecl IID_IAsyncReader;
EXTERN_C const IID  __cdecl IID_IGraphVersion;
EXTERN_C const IID  __cdecl IID_IResourceConsumer;
EXTERN_C const IID  __cdecl IID_IResourceManager;
EXTERN_C const IID  __cdecl IID_IDistributorNotify;
EXTERN_C const IID  __cdecl IID_IAMStreamControl;
EXTERN_C const IID  __cdecl IID_ISeekingPassThru;
EXTERN_C const IID  __cdecl IID_IAMStreamConfig;
EXTERN_C const IID  __cdecl IID_IConfigInterleaving;
EXTERN_C const IID  __cdecl IID_IConfigAviMux;
EXTERN_C const IID  __cdecl IID_IAMVideoCompression;
EXTERN_C const IID  __cdecl IID_IAMVfwCaptureDialogs;
EXTERN_C const IID  __cdecl IID_IAMVfwCompressDialogs;
EXTERN_C const IID  __cdecl IID_IAMDroppedFrames;
EXTERN_C const IID  __cdecl IID_IAMAudioInputMixer;
EXTERN_C const IID  __cdecl IID_IAMBufferNegotiation;
EXTERN_C const IID  __cdecl IID_IAMAnalogVideoDecoder;
EXTERN_C const IID  __cdecl IID_IAMVideoProcAmp;
EXTERN_C const IID  __cdecl IID_IAMCameraControl;
EXTERN_C const IID  __cdecl IID_IAMVideoControl;
EXTERN_C const IID  __cdecl IID_IAMCrossbar;
EXTERN_C const IID  __cdecl IID_IAMTuner;
EXTERN_C const IID  __cdecl IID_IAMTunerNotification;
EXTERN_C const IID  __cdecl IID_IAMTVTuner;
EXTERN_C const IID  __cdecl IID_IBPCSatelliteTuner;
EXTERN_C const IID  __cdecl IID_IAMTVAudio;
EXTERN_C const IID  __cdecl IID_IAMTVAudioNotification;
EXTERN_C const IID  __cdecl IID_IAMAnalogVideoEncoder;
EXTERN_C const IID  __cdecl IID_IKsPropertySet;
EXTERN_C const IID  __cdecl IID_IMediaPropertyBag;
EXTERN_C const IID  __cdecl IID_IPersistMediaPropertyBag;
EXTERN_C const IID  __cdecl IID_IAMPhysicalPinInfo;
EXTERN_C const IID  __cdecl IID_IAMExtDevice;
EXTERN_C const IID  __cdecl IID_IAMExtTransport;
EXTERN_C const IID  __cdecl IID_IAMTimecodeReader;
EXTERN_C const IID  __cdecl IID_IAMTimecodeGenerator;
EXTERN_C const IID  __cdecl IID_IAMTimecodeDisplay;
EXTERN_C const IID  __cdecl IID_IAMDevMemoryAllocator;
EXTERN_C const IID  __cdecl IID_IAMDevMemoryControl;
EXTERN_C const IID  __cdecl IID_IAMStreamSelect;
EXTERN_C const IID  __cdecl IID_IAMResourceControl;
EXTERN_C const IID  __cdecl IID_IAMClockAdjust;
EXTERN_C const IID  __cdecl IID_IAMFilterMiscFlags;
EXTERN_C const IID  __cdecl IID_IDrawVideoImage;
EXTERN_C const IID  __cdecl IID_IDecimateVideoImage;
EXTERN_C const IID  __cdecl IID_IAMVideoDecimationProperties;
EXTERN_C const IID  __cdecl IID_IVideoFrameStep;
EXTERN_C const IID  __cdecl IID_IAMLatency;
EXTERN_C const IID  __cdecl IID_IAMPushSource;
EXTERN_C const IID  __cdecl IID_IAMDeviceRemoval;
EXTERN_C const IID  __cdecl IID_IDVEnc;
EXTERN_C const IID  __cdecl IID_IIPDVDec;
EXTERN_C const IID  __cdecl IID_IDVRGB219;
EXTERN_C const IID  __cdecl IID_IDVSplitter;
EXTERN_C const IID  __cdecl IID_IAMAudioRendererStats;
EXTERN_C const IID  __cdecl IID_IAMGraphStreams;
EXTERN_C const IID  __cdecl IID_IAMOverlayFX;
EXTERN_C const IID  __cdecl IID_IAMOpenProgress;
EXTERN_C const IID  __cdecl IID_IMpeg2Demultiplexer;
EXTERN_C const IID  __cdecl IID_IEnumStreamIdMap;
EXTERN_C const IID  __cdecl IID_IMPEG2StreamIdMap;
EXTERN_C const IID  __cdecl IID_IRegisterServiceProvider;
EXTERN_C const IID  __cdecl IID_IAMClockSlave;
EXTERN_C const IID  __cdecl IID_IAMGraphBuilderCallback;
EXTERN_C const IID  __cdecl IID_ICodecAPI;
EXTERN_C const IID  __cdecl IID_IGetCapabilitiesKey;
EXTERN_C const IID  __cdecl IID_IEncoderAPI;
EXTERN_C const IID  __cdecl IID_IVideoEncoder;
EXTERN_C const IID  __cdecl IID_IAMDecoderCaps;
EXTERN_C const IID  __cdecl IID_IAMCertifiedOutputProtection;
EXTERN_C const IID  __cdecl IID_IAMAsyncReaderTimestampScaling;
EXTERN_C const IID  __cdecl IID_IAMPluginControl;
EXTERN_C const IID  __cdecl IID_IDvdControl;
EXTERN_C const IID  __cdecl IID_IDvdInfo;
EXTERN_C const IID  __cdecl IID_IDvdCmd;
EXTERN_C const IID  __cdecl IID_IDvdState;
EXTERN_C const IID  __cdecl IID_IDvdControl2;
EXTERN_C const IID  __cdecl IID_IDvdInfo2;
EXTERN_C const IID  __cdecl IID_IDvdGraphBuilder;
EXTERN_C const IID  __cdecl IID_IDDrawExclModeVideo;
EXTERN_C const IID  __cdecl IID_IDDrawExclModeVideoCallback;
EXTERN_C const IID  __cdecl IID_IPinConnection;
EXTERN_C const IID  __cdecl IID_IPinFlowControl;
EXTERN_C const IID  __cdecl IID_IGraphConfig;
EXTERN_C const IID  __cdecl IID_IGraphConfigCallback;
EXTERN_C const IID  __cdecl IID_IFilterChain;
EXTERN_C const IID  __cdecl IID_IVMRImagePresenter;
EXTERN_C const IID  __cdecl IID_IVMRSurfaceAllocator;
EXTERN_C const IID  __cdecl IID_IVMRSurfaceAllocatorNotify;
EXTERN_C const IID  __cdecl IID_IVMRWindowlessControl;
EXTERN_C const IID  __cdecl IID_IVMRMixerControl;
EXTERN_C const IID  __cdecl IID_IVMRMonitorConfig;
EXTERN_C const IID  __cdecl IID_IVMRFilterConfig;
EXTERN_C const IID  __cdecl IID_IVMRAspectRatioControl;
EXTERN_C const IID  __cdecl IID_IVMRDeinterlaceControl;
EXTERN_C const IID  __cdecl IID_IVMRMixerBitmap;
EXTERN_C const IID  __cdecl IID_IVMRImageCompositor;
EXTERN_C const IID  __cdecl IID_IVMRVideoStreamControl;
EXTERN_C const IID  __cdecl IID_IVMRSurface;
EXTERN_C const IID  __cdecl IID_IVMRImagePresenterConfig;
EXTERN_C const IID  __cdecl IID_IVMRImagePresenterExclModeConfig;
EXTERN_C const IID  __cdecl IID_IVPManager;

#endif /* __strmif_h__ */
