/*
 *  stralign.h  String alignment macros
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __STRALIGN_H_
#define __STRALIGN_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Aliases */
#define ua_CharUpperW   CharUpperW
#define ua_lstrcmpiW    lstrcmpiW
#define ua_lstrcmpW     lstrcmpW
#define ua_lstrlenW     lstrlenW
#define ua_wcschr       wcschr
#define ua_wcsicmp      wcsicmp
#define ua_wcslen       wcslen
#define ua_wcsrchr      wcsrchr
#define ua_wcscpy_s     wcscpy_s
#define ua_wcscpy       wcscpy

/* String alignment macros */
#define WSTR_ALIGNED( x )                   TRUE
#define __UA_WCSLEN                         ua_wcslen
#define __UA_WSTRSIZE( x )                  ((__UA_WCSLEN( x ) + 1) * sizeof( WCHAR ))
#define __UA_STACKCOPY( p1, p2 )            memcpy( _alloca( p2 ), p1, p2 )
#define WSTR_ALIGNED_STACK_COPY( p1, p2 )   (*(p1) = (PCWSTR)(p2))
#define ASTR_ALIGNED_STACK_COPY( p1, p2 )   (*(p1) = (PCSTR)(p2))
#define STRUC_ALIGNED_STACK_COPY( p1, p2 )  ((CONST p1 *)(p2))
#ifdef UNICODE
    #define TSTR_ALIGNED_STACK_COPY( p1, p2 )   WSTR_ALIGNED_STACK_COPY( p1, p2 )
    #define TSTR_ALIGNED( x )                   WSTR_ALIGNED( x )
#else
    #define TSTR_ALIGNED_STACK_COPY( p1, p2 )   ASTR_ALIGNED_STACK_COPY( p1, p2 )
    #define TSTR_ALIGNED( x )                   TRUE
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define ua_CharUpper    ua_CharUpperW
    #define ua_lstrcmp      ua_lstrcmpW
    #define ua_lstrcmpi     ua_lstrcmpiW
    #define ua_lstrlen      ua_lstrlenW
    #define ua_tcscpy       ua_wcscpy
    #define ua_tcscpy_s     ua_wcscpy_s
#else
    #define ua_CharUpper    CharUpperA
    #define ua_lstrcmp      lstrcmpA
    #define ua_lstrcmpi     lstrcmpiA
    #define ua_lstrlen      lstrlenA
    #define ua_tcscpy       strcpy
    #define ua_tcscpy_s     strcpy_s
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __STRALIGN_H_ */
