/*
 *  shellapi.h  Shell functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _INC_SHELLAPI
#define _INC_SHELLAPI

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <pshpack1.h>

#ifdef __cplusplus
extern "C" {
#endif

/* The following macros make it possible to disable nameless unions in certain structures
 * by defining NONAMELESSUNION.  They are shared with several other header files.
 */
#ifndef DUMMYUNIONNAME
    #ifdef NONAMELESSUNION
        #define DUMMYUNIONNAME  u
        #define DUMMYUNIONNAME2 u2
        #define DUMMYUNIONNAME3 u3
        #define DUMMYUNIONNAME4 u4
        #define DUMMYUNIONNAME5 u5
    #else
        #define DUMMYUNIONNAME
        #define DUMMYUNIONNAME2
        #define DUMMYUNIONNAME3
        #define DUMMYUNIONNAME4
        #define DUMMYUNIONNAME5
    #endif
#endif

/* These macro is used by other macros to invoke SendMessage().  It is shared with
 * several other header files.
 */
#ifndef SNDMSG
    #ifdef __cplusplus
        #define SNDMSG  ::SendMessage
    #else
        #define SNDMSG  SendMessage
    #endif
#endif

/* Macros to specify shell functions */
#ifndef WINSHELLAPI
    #define WINSHELLAPI     DECLSPEC_IMPORT
#endif
#ifndef SHSTDAPI
    #define SHSTDAPI        EXTERN_C DECLSPEC_IMPORT HRESULT STDAPICALLTYPE
    #define SHSTDAPI_( x )  EXTERN_C DECLSPEC_IMPORT x STDAPICALLTYPE
#endif

/* Shell primitive data types */
#if (WINVER >= 0x0400)
typedef WORD    FILEOP_FLAGS;
typedef WORD    PRINTEROP_FLAGS;
#endif

/* Drop handle data type */
DECLARE_HANDLE( HDROP );

/* Appbar messages */
#if (WINVER >= 0x0400)
    #define ABM_NEW                 0x00000000L
    #define ABM_REMOVE              0x00000001L
    #define ABM_QUERYPOS            0x00000002L
    #define ABM_SETPOS              0x00000003L
    #define ABM_GETSTATE            0x00000004L
    #define ABM_GETTASKBARPOS       0x00000005L
    #define ABM_ACTIVATE            0x00000006L
    #define ABM_GETAUTOHIDEBAR      0x00000007L
    #define ABM_SETAUTOHIDEBAR      0x00000008L
    #define ABM_WINDOWPOSCHANGED    0x00000009L
    #if (NTDDI_VERSION >= 0x05010000)
        #define ABM_SETSTATE        0x0000000AL
    #endif
#endif

/* Appbar notifications */
#if (WINVER >= 0x0400)
    #define ABN_STATECHANGE     0x00000000
    #define ABN_POSCHANGED      0x00000001
    #define ABN_FULLSCREENAPP   0x00000002
    #define ABN_WINDOWARRANGE   0x00000003
#endif

/* Appbar state flags */
#if (WINVER >= 0x0400)
    #define ABS_AUTOHIDE    0x00000001
    #define ABS_ALWAYSONTOP 0x00000002
#endif

/* Appbar edges */
#if (WINVER >= 0x0400)
    #define ABE_LEFT    0
    #define ABE_TOP     1
    #define ABE_RIGHT   2
    #define ABE_BOTTOM  3
#endif

/* Shell file operations */
#if (WINVER >= 0x0400)
    #define FO_MOVE     0x00000001
    #define FO_COPY     0x00000002
    #define FO_DELETE   0x00000003
    #define FO_RENAME   0x00000004
#endif

/* Shell file operation flags */
#if (WINVER >= 0x0400)
    #define FOF_MULTIDESTFILES              0x00000001
    #define FOF_CONFIRMMOUSE                0x00000002
    #define FOF_SILENT                      0x00000004
    #define FOF_RENAMEONCOLLISION           0x00000008
    #define FOF_NOCONFIRMATION              0x00000010
    #define FOF_WANTMAPPINGHANDLE           0x00000020
    #define FOF_ALLOWUNDO                   0x00000040
    #define FOF_FILESONLY                   0x00000080
    #define FOF_SIMPLEPROGRESS              0x00000100
    #define FOF_NOCONFIRMMKDIR              0x00000200
    #define FOF_NOERRORUI                   0x00000400
    #if (_WIN32_IE >= 0x0500)
        #define FOF_NOCOPYSECURITYATTRIBS   0x00000800
        #define FOF_NORECURSION             0x00001000
        #define FOF_NO_CONNECTED_ELEMENTS   0x00002000
        #define FOF_WANTNUKEWARNING         0x00004000
    #endif
    #if (_WIN32_IE >= 0x0501)
        #define FOF_NORECURSEREPARSE        0x00008000
    #endif
#endif

/* Shell printer operations */
#if (WINVER >= 0x0400)
    #define PO_DELETE       0x00000013
    #define PO_RENAME       0x00000014
    #define PO_PORTCHANGE   0x00000020
    #define PO_REN_PORT     0x00000034
#endif

/* ShellExecute() error codes */
#if (WINVER >= 0x0400)
    #define SE_ERR_FNF          2
    #define SE_ERR_PNF          3
    #define SE_ERR_ACCESSDENIED 5
    #define SE_ERR_OOM          8
    #define SE_ERR_DLLNOTFOUND  32
#endif
#define SE_ERR_SHARE            26
#define SE_ERR_ASSOCINCOMPLETE  27
#define SE_ERR_DDETIMEOUT       28
#define SE_ERR_DDEFAIL          29
#define SE_ERR_DDEBUSY          30
#define SE_ERR_NOASSOC          31

/* SHELLEXECUTEINFO mask flags */
#if (WINVER >= 0x0400)
    #define SEE_MASK_DEFAULT                0x00000000L
    #define SEE_MASK_CLASSNAME              0x00000001L
    #define SEE_MASK_CLASSKEY               0x00000003L
    #define SEE_MASK_IDLIST                 0x00000004L
    #define SEE_MASK_INVOKEIDLIST           0x0000000CL
    #if (NTDDI_VERSION < 0x06000000)
        #define SEE_MASK_ICON               0x00000010L
    #endif
    #define SEE_MASK_HOTKEY                 0x00000020L
    #define SEE_MASK_NOCLOSEPROCESS         0x00000040L
    #define SEE_MASK_CONNECTNETDRV          0x00000080L
    #define SEE_MASK_NOASYNC                0x00000100L
    #define SEE_MASK_FLAG_DDEWAIT           SEE_MASK_NOASYNC
    #define SEE_MASK_DOENVSUBST             0x00000200L
    #define SEE_MASK_FLAG_NO_UI             0x00000400L
    #define SEE_MASK_UNICODE                0x00004000L
    #define SEE_MASK_NO_CONSOLE             0x00008000L
    #define SEE_MASK_ASYNCOK                0x00100000L
    #if (NTDDI_VERSION >= 0x05000000)
        #define SEE_MASK_HMONITOR           0x00200000L
    #endif
    #if (NTDDI_VERSION >= 0x05010100)
        #define SEE_MASK_NOZONECHECKS       0x00800000L
    #endif
    #if (NTDDI_VERSION >= 0x05000000)
        #define SEE_MASK_NOQUERYCLASSSTORE  0x01000000L
        #define SEE_MASK_WAITFORINPUTIDLE   0x02000000L
    #endif
    #if (NTDDI_VERSION >= 0x05010000)
        #define SEE_MASK_FLAG_LOG_USAGE     0x04000000L
    #endif
#endif

/* SHEmptyRecycleBin() flags */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x05000000)
    #define SHERB_NOCONFIRMATION    0x00000001L
    #define SHERB_NOPROGRESSUI      0x00000002L
    #define SHERB_NOSOUND           0x00000004L
#endif

/* Shell_NotifyIcon() notification messages */
#if (WINVER >= 0x0400)
    #if (_WIN32_IE >= 0x0500)
        #define NIN_SELECT              (WM_USER + 0)
        #define NIN_KEYSELECT           (WM_USER + 1)
    #endif
    #if (_WIN32_IE >= 0x0501)
        #define NIN_BALLOONSHOW         (WM_USER + 2)
        #define NIN_BALLOONHIDE         (WM_USER + 3)
        #define NIN_BALLOONTIMEOUT      (WM_USER + 4)
        #define NIN_BALLOONUSERCLICK    (WM_USER + 5)
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define NIN_POPUPOPEN           (WM_USER + 6)
        #define NIN_POPUPCLOSE          (WM_USER + 7)
    #endif
#endif

/* Shell_NotifyIcon() messages */
#if (WINVER >= 0x0400)
    #define NIM_ADD             0x00000000L
    #define NIM_MODIFY          0x00000001L
    #define NIM_DELETE          0x00000002L
    #if (_WIN32_IE >= 0x0500)
        #define NIM_SETFOCUS    0x00000003L
        #define NIM_SETVERSION  0x00000004L
    #endif
#endif

/* NOTIFYICONDATA versions */
#if (WINVER >= 0x0400)
    #if (_WIN32_IE >= 0x0500)
        #define NOTIFYICON_VERSION  3
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define NOTIFYICON_VERSION4 4
    #endif
#endif

/* Shell_NotifyIcon() flags */
#if (WINVER >= 0x0400)
    #define NIF_MESSAGE         0x00000001
    #define NIF_ICON            0x00000002
    #define NIF_TIP             0x00000004
    #if (_WIN32_IE >= 0x0500)
        #define NIF_STATE       0x00000008
        #define NIF_INFO        0x00000010
    #endif
    #if (_WIN32_IE >= 0x0600)
        #define NIF_GUID        0x00000020
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define NIF_REALTIME    0x00000040
        #define NIF_SHOWTIP     0x00000080
    #endif
#endif

/* Shell_NotifyIcon() states */
#if (WINVER >= 0x0400) && (_WIN32_IE >= 0x0500)
    #define NIS_HIDDEN      0x00000001L
    #define NIS_SHAREDICON  0x00000002L
#endif

/* Shell_NotifyIcon() icon flags */
#if (WINVER >= 0x0400) 
    #if (_WIN32_IE >= 0x0500)
        #define NIIF_NONE               0x00000000L
        #define NIIF_INFO               0x00000001L
        #define NIIF_WARNING            0x00000002L
        #define NIIF_ERROR              0x00000003L
        #if (NTDDI_VERSION >= 0x05010200)
            #define NIIF_USER           0x00000004L
        #endif
        #define NIIF_ICON_MASK          0x0000000FL
    #endif
    #if (_WIN32_IE >= 0x0501)
        #define NIIF_NOSOUND            0x00000010L
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define NIIF_LARGE_ICON         0x00000020L
    #endif
    #if (NTDDI_VERSION >= 0x06010000)
        #define NIIF_RESPECT_QUIET_TIME 0x00000080L
    #endif
#endif

/* SHGetFileInfo() flags */
#if (WINVER >= 0x0400)
    #define SHGFI_LARGEICON             0x00000000
    #define SHGFI_SMALLICON             0x00000001
    #define SHGFI_OPENICON              0x00000002
    #define SHGFI_SHELLICONSIZE         0x00000004
    #define SHGFI_PIDL                  0x00000008
    #define SHGFI_USEFILEATTRIBUTES     0x00000010
    #if (_WIN32_IE >= 0x0500)
        #define SHGFI_ADDOVERLAYS       0x00000020
        #define SHGFI_OVERLAYINDEX      0x00000040
    #endif
    #define SHGFI_ICON                  0x00000100
    #define SHGFI_DISPLAYNAME           0x00000200
    #define SHGFI_TYPENAME              0x00000400
    #define SHGFI_ATTRIBUTES            0x00000800
    #define SHGFI_ICONLOCATION          0x00001000
    #define SHGFI_EXETYPE               0x00002000
    #define SHGFI_SYSICONINDEX          0x00004000
    #define SHGFI_LINKOVERLAY           0x00008000
    #define SHGFI_SELECTED              0x00010000
    #if (NTDDI_VERSION >= 0x05000000)
        #define SHGFI_ATTR_SPECIFIED    0x00020000
    #endif
#endif

/* SHGetStockIconInfo() flags */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
    #define SHGSI_ICONLOCATION  0
    #define SHGSI_ICON          SHGFI_ICON
    #define SHGSI_SYSICONINDEX  SHGFI_SYSICONINDEX
    #define SHGSI_LINKOVERLAY   SHGFI_LINKOVERLAY
    #define SHGSI_SELECTED      SHGFI_SELECTED
    #define SHGSI_LARGEICON     SHGFI_LARGEICON
    #define SHGSI_SMALLICON     SHGFI_SMALLICON
    #define SHGSI_SMALLICONSIZE SHGDI_SMALLICONSIZE
#endif

/* SHGetNewLinkInfo() flags */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x05000000)
    #define SHGNLI_PIDL             0x00000001
    #define SHGNLI_PREFIXNAME       0x00000002
    #define SHGNLI_NOUNIQUE         0x00000004
    #if (_WIN32_IE >= 0x0501)
        #define SHGNLI_NOLNK        0x00000008
    #endif
    #if (_WIN32_IE >= 0x0600)
        #define SHGNLI_NOLOCNAME    0x00000010
    #endif
    #if (NTDDI_VERSION >= 0x06010000)
        #define SHGNLI_USEURLEXT    0x00000020
    #endif
#endif

/* Print actions */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x05000000)
    #define PRINTACTION_OPEN                0
    #define PRINTACTION_PROPERTIES          1
    #define PRINTACTION_NETINSTALL          2
    #define PRINTACTION_NETINSTALLLINK      3
    #define PRINTACTION_TESTPAGE            4
    #define PRINTACTION_OPENNETPRN          5
    #define PRINTACTION_DOCUMENTDEFAULTS    6
    #define PRINTACTION_SERVERPROPERTIES    7
#endif

/* Printer property flags */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
    #define PRINT_PROP_FORCE_NAME   0x00000001L
#endif

/* Offline status values */
#if ((_WIN32_WINNT >= 0x0500) || (_WIN32_WINDOWS >= 0x0500))
    #define OFFLINE_STATUS_LOCAL        0x00000001L
    #define OFFLINE_STATUS_REMOTE       0x00000002L
    #define OFFLINE_STATUS_INCOMPLETE   0x00000004L
#endif

/* Shell image lists */
#if (WIN32_IE >= 0x0600)
    #if (NTDDI_VERSION >= 0x05010000)
        #define SHIL_LARGE      0
        #define SHIL_SMALL      1
        #define SHIL_EXTRALARGE 2
        #define SHIL_SYSSMALL   3
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define SHIL_JUMBO      4
        #define SHIL_LAST       SHIL_JUMBO
    #elif (NTDDI_VERSION >= 0x05010000)
        #define SHIL_LAST       SHIL_SYSSMALL
    #endif
#endif

/* Network address control window class */
#if (NTDDI_VERSION >= 0x06000000)
    #define WC_NETADDRESS   L"msctls_netaddress"
#endif

/* Network address control messages */
#if (NTDDI_VERSION >= 0x06000000)
    #define NCM_GETADDRESS      (WM_USER + 1)
    #define NCM_SETALLOWTYPE    (WM_USER + 2)
    #define NCM_GETALLOWTYPE    (WM_USER + 3)
    #define NCM_DISPLAYERRORTIP (WM_USER + 4)
#endif

/* Drag information */
#if (WINVER >= 0x0400)
typedef struct _DRAGINFOA {
    UINT    uSize;
    POINT   pt;
    BOOL    fNC;
    LPSTR   lpFileList;
    DWORD   grfKeyState;
} DRAGINFOA;
typedef DRAGINFOA   *LPDRAGINFOA;
typedef struct _DRAGINFOW {
    UINT    uSize;
    POINT   pt;
    BOOL    fNC;
    LPWSTR  lpFileList;
    DWORD   grfKeyState;
} DRAGINFOW;
typedef DRAGINFOW   *LPDRAGINFOW;
#ifdef UNICODE
typedef DRAGINFOW   DRAGINFO;
typedef LPDRAGINFOW LPDRAGINFO;
#else
typedef DRAGINFOA   DRAGINFO;
typedef LPDRAGINFOA LPDRAGINFO;
#endif
#endif

/* Appbar data */
#if (WINVER >= 0x0400)
typedef struct _AppBarData {
    DWORD   cbSize;
    HWND    hWnd;
    UINT    uCallbackMessage;
    UINT    uEdge;
    RECT    rc;
    LPARAM  lParam;
} APPBARDATA;
typedef APPBARDATA  *PAPPBARDATA;
#endif

/* Shell file operation parameters */
#if (WINVER >= 0x0400)
typedef struct _SHFILEOPSTRUCTA {
    HWND            hwnd;
    UINT            wFunc;
    LPCSTR          pFrom;
    LPCSTR          pTo;
    FILEOP_FLAGS    fFlags;
    BOOL            fAnyOperationsAborted;
    LPVOID          hNameMappings;
    LPCSTR          lpszProgressTitle;
} SHFILEOPSTRUCTA;
typedef SHFILEOPSTRUCTA     *LPSHFILEOPSTRUCTA;
typedef struct _SHFILEOPSTRUCTW {
    HWND            hwnd;
    UINT            wFunc;
    LPCWSTR         pFrom;
    LPCWSTR         pTo;
    FILEOP_FLAGS    fFlags;
    BOOL            fAnyOperationsAborted;
    LPVOID          hNameMappings;
    LPCWSTR         lpszProgressTitle;
} SHFILEOPSTRUCTW;
typedef SHFILEOPSTRUCTW     *LPSHFILEOPSTRUCTW;
#ifdef UNICODE
typedef SHFILEOPSTRUCTW     SHFILEOPSTRUCT;
typedef LPSHFILEOPSTRUCTW   LPSHFILEOPSTRUCT;
#else
typedef SHFILEOPSTRUCTA     SHFILEOPSTRUCT;
typedef LPSHFILEOPSTRUCTA   LPSHFILEOPSTRUCT;
#endif
#endif

/* Shell name mapping */
#if (WINVER >= 0x0400)
typedef struct _SHNAMEMAPPINGA {
    LPSTR   pszOldPath;
    LPSTR   pszNewPath;
    int     cchOldPath;
    int     cchNewPath;
} SHNAMEMAPPINGA;
typedef SHNAMEMAPPINGA      *LPSHNAMEMAPPINGA;
typedef struct _SHNAMEMAPPINGW {
    LPWSTR  pszOldPath;
    LPWSTR  pszNewPath;
    int     cchOldPath;
    int     cchNewPath;
} SHNAMEMAPPINGW;
typedef SHNAMEMAPPINGW      *LPSHNAMEMAPPINGW;
#ifdef UNICODE
typedef SHNAMEMAPPINGW      SHNAMEMAPPING;
typedef LPSHNAMEMAPPINGW    LPSHNAMEMAPPING;
#else
typedef SHNAMEMAPPINGA      SHNAMEMAPPING;
typedef LPSHNAMEMAPPINGA    LPSHNAMEMAPPING;
#endif
#endif

/* ShellExecuteEx() parameters */
#if (WINVER >= 0x0400)
typedef struct _SHELLEXECUTEINFOA {
    DWORD       cbSize;
    ULONG       fMask;
    HWND        hwnd;
    LPCSTR      lpVerb;
    LPCSTR      lpFile;
    LPCSTR      lpParameters;
    LPCSTR      lpDirectory;
    int         nShow;
    HINSTANCE   hInstApp;
    void        *lpIDList;
    LPCSTR      lpClass;
    HKEY        hkeyClass;
    DWORD       dwHotKey;
    union {
        HANDLE  hIcon;
#if (NTDDI_VERSION >= 0x05000000)
        HANDLE  hMonitor;
#endif
    } DUMMYUNIONNAME;
    HANDLE      hProcess;
} SHELLEXECUTEINFOA;
typedef SHELLEXECUTEINFOA   *LPSHELLEXECUTEINFOA;
typedef struct _SHELLEXECUTEINFOW {
    DWORD       cbSize;
    ULONG       fMask;
    HWND        hwnd;
    LPCWSTR     lpVerb;
    LPCWSTR     lpFile;
    LPCWSTR     lpParameters;
    LPCWSTR     lpDirectory;
    int         nShow;
    HINSTANCE   hInstApp;
    void        *lpIDList;
    LPCWSTR     lpClass;
    HKEY        hkeyClass;
    DWORD       dwHotKey;
    union {
        HANDLE  hIcon;
#if (NTDDI_VERSION >= 0x05000000)
        HANDLE  hMonitor;
#endif
    } DUMMYUNIONNAME;
    HANDLE      hProcess;
} SHELLEXECUTEINFOW;
typedef SHELLEXECUTEINFOW   *LPSHELLEXECUTEINFOW;
#ifdef UNICODE
typedef SHELLEXECUTEINFOW   SHELLEXECUTEINFO;
typedef LPSHELLEXECUTEINFOW LPSHELLEXECUTEINFO;
#else
typedef SHELLEXECUTEINFOA   SHELLEXECUTEINFO;
typedef LPSHELLEXECUTEINFOA LPSHELLEXECUTEINFO;
#endif
#endif

/* SHCreateProcessAsUserW() parameters */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x05000000)
typedef struct _SHCREATEPROCESSINFOW {
    DWORD                   cbSize;
    ULONG                   fMask;
    HWND                    hwnd;
    LPCWSTR                 pszFile;
    LPCWSTR                 pszParameters;
    LPCWSTR                 pszCurrentDirectory;
    HANDLE                  hUserToken;
    LPSECURITY_ATTRIBUTES   lpProcessAttributes;
    LPSECURITY_ATTRIBUTES   lpThreadAttributes;
    BOOL                    bInheritHandles;
    DWORD                   dwCreationFlags;
    LPSTARTUPINFOW          lpStartupInfo;
    LPPROCESS_INFORMATION   lpProcessInformation;
} SHCREATEPROCESSINFOW;
typedef SHCREATEPROCESSINFOW    *PSHCREATEPROCESSINFOW;
#endif

/* Association classes */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef enum ASSOCCLASS {
    ASSOCCLASS_SHELL_KEY    = 0,
    ASSOCCLASS_PROGID_KEY   = 1,
    ASSOCCLASS_PROGID_STR   = 2,
    ASSOCCLASS_CLSID_KEY    = 3,
    ASSOCCLASS_CLSID_STR    = 4,
    ASSOCCLASS_APP_KEY      = 5,
    ASSOCCLASS_APP_STR      = 6,
    ASSOCCLASS_SYSTEM_STR   = 7,
    ASSOCCLASS_FOLDER       = 8,
    ASSOCCLASS_STAR         = 9
} ASSOCCLASS;
#endif

/* Association element */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef struct ASSOCIATIONELEMENT_ {
    ASSOCCLASS  ac;
    HKEY        hkClass;
    PCWSTR      pszClass;
} ASSOCIATIONELEMENT;
#endif

/* SHQueryRecycleBin() information */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x05000000)
typedef struct _SHQUERYRBINFO {
    DWORD   cbSize;
    __int64 i64Size;
    __int64 i64NumItems;
} SHQUERYRBINFO;
typedef SHQUERYRBINFO   *LPSHQUERYRBINFO;
#endif

/* SHQueryUserNotificationState() return values */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef enum {
    QUNS_NOT_PRESENT                = 1,
    QUNS_BUSY                       = 2,
    QUNS_RUNNING_D3D_FULL_SCREEN    = 3,
    QUNS_PRESENTATION_MODE          = 4,
#if (NTDDI_VERSION >= 0x06010000)
    QUNS_ACCEPTS_NOTIFICATIONS      = 5,
    QUNS_QUIET_TIME                 = 6,
#else
    QUNS_ACCEPTS_NOTIFICATIONS      = 5
#endif
} QUERY_USER_NOTIFICATION_STATE;
#endif

/* Shell_NotifyIcon() parameters */
#if (WINVER >= 0x0400)
typedef struct _NOTIFYICONDATAA {
    DWORD   cbSize;
    HWND    hWnd;
    UINT    uID;
    UINT    uFlags;
    UINT    uCallbackMessage;
    HICON   hIcon;
#if (NTDDI_VERSION >= 0x05000000)
    CHAR    szTip[128];
    DWORD   dwState;
    DWORD   dwStateMask;
    CHAR    szInfo[256];
    union {
        UINT    uTimeout;
        UINT    uVersion;
    } DUMMYUNIONNAME;
    CHAR    szInfoTitle[64];
    DWORD   dwInfoFlags;
#else
    CHAR    szTip[64];
#endif
#if (NTDDI_VERSION >= 0x05010000)
    GUID    guidItem;
#endif
#if (NTDDI_VERSION >= 0x06000000)
    HICON   hBalloonIcon;
#endif
} NOTIFYICONDATAA;
typedef NOTIFYICONDATAA     *PNOTIFYICONDATAA;
typedef struct _NOTIFYICONDATAW {
    DWORD   cbSize;
    HWND    hWnd;
    UINT    uID;
    UINT    uFlags;
    UINT    uCallbackMessage;
    HICON   hIcon;
#if (NTDDI_VERSION >= 0x05000000)
    WCHAR   szTip[128];
    DWORD   dwState;
    DWORD   dwStateMask;
    WCHAR   szInfo[256];
    union {
        UINT    uTimeout;
        UINT    uVersion;
    } DUMMYUNIONNAME;
    WCHAR   szInfoTitle[64];
    DWORD   dwInfoFlags;
#else
    WCHAR   szTip[64];
#endif
#if (NTDDI_VERSION >= 0x05010000)
    GUID    guidItem;
#endif
#if (NTDDI_VERSION >= 0x06000000)
    HICON   hBalloonIcon;
#endif
} NOTIFYICONDATAW;
typedef NOTIFYICONDATAW     *PNOTIFYICONDATAW;
#ifdef UNICODE
typedef NOTIFYICONDATAW     NOTIFYICONDATA;
typedef PNOTIFYICONDATAW    PNOTIFYICONDATA;
#else
typedef NOTIFYICONDATAA     NOTIFYICONDATA;
typedef PNOTIFYICONDATAA    PNOTIFYICONDATA;
#endif
#endif

/* Shell_NotifyIcon() parameter structure sizes */
#define NOTIFYICONDATAA_V1_SIZE     FIELD_OFFSET( NOTIFYICONDATAA, szTip[64] )
#define NOTIFYICONDATAW_V1_SIZE     FIELD_OFFSET( NOTIFYICONDATAW, szTip[64] )
#define NOTIFYICONDATAA_V2_SIZE     FIELD_OFFSET( NOTIFYICONDATAA, guidItem )
#define NOTIFYICONDATAW_V2_SIZE     FIELD_OFFSET( NOTIFYICONDATAW, guidItem )
#define NOTIFYICONDATAA_V3_SIZE     FIELD_OFFSET( NOTIFYICONDATAA, hBalloonIcon )
#define NOTIFYICONDATAW_V3_SIZE     FIELD_OFFSET( NOTIFYICONDATAW, hBalloonIcon )
#ifdef UNICODE
    #define NOTIFYICONDATA_V1_SIZE  NOTIFYICONDATAW_V1_SIZE
    #define NOTIFYICONDATA_V2_SIZE  NOTIFYICONDATAW_V2_SIZE
    #define NOTIFYICONDATA_V3_SIZE  NOTIFYICONDATAW_V3_SIZE
#else
    #define NOTIFYICONDATA_V1_SIZE  NOTIFYICONDATAA_V1_SIZE
    #define NOTIFYICONDATA_V2_SIZE  NOTIFYICONDATAA_V2_SIZE
    #define NOTIFYICONDATA_V3_SIZE  NOTIFYICONDATAA_V3_SIZE
#endif

/* Shell_NotifyIconGetRect() identifier */
#if (WINVER >= 0x0400)
typedef struct _NOTIFYICONIDENTIFIER {
    DWORD   cbSize;
    HWND    hWnd;
    UINT    uID;
    GUID    guidItem;
} NOTIFYICONIDENTIFIER;
typedef NOTIFYICONIDENTIFIER    *PNOTIFYICONIDENTIFIER;
#endif

/* Shell file information */
#if (WINVER >= 0x0400)
typedef struct _SHFILEINFOA {
    HICON   hIcon;
    int     iIcon;
    DWORD   dwAttributes;
    CHAR    szDisplayName[MAX_PATH];
    CHAR    szTypeName[80];
} SHFILEINFOA;
typedef struct _SHFILEINFOW {
    HICON   hIcon;
    int     iIcon;
    DWORD   dwAttributes;
    WCHAR   szDisplayName[MAX_PATH];
    WCHAR   szTypeName[80];
} SHFILEINFOW;
#ifdef UNICODE
typedef SHFILEINFOW SHFILEINFO;
#else
typedef SHFILEINFOA SHFILEINFO;
#endif
#endif

/* Shell stock icon information */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef struct _SHSTOCKICONINFO {
    DWORD   cbSize;
    HICON   hIcon;
    int     iSysImageIndex;
    int     iIcon;
    WCHAR   szPath[MAX_PATH];
} SHSTOCKICONINFO;
#endif

/* Shell stock info identifiers */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef enum SHSTOCKICONID {
    SIID_DOCNOASSOC         = 0,
    SIID_DOCASSOC           = 1,
    SIID_APPLICATION        = 2,
    SIID_FOLDER             = 3,
    SIID_FOLDEROPEN         = 4,
    SIID_DRIVE525           = 5,
    SIID_DRIVE35            = 6,
    SIID_DRIVEREMOVE        = 7,
    SIID_DRIVEFIXED         = 8,
    SIID_DRIVENET           = 9,
    SIID_DRIVENETDISABLED   = 10,
    SIID_DRIVECD            = 11,
    SIID_DRIVERAM           = 12,
    SIID_WORLD              = 13,
    SIID_SERVER             = 15,
    SIID_PRINTER            = 16,
    SIID_MYNETWORK          = 17,
    SIID_FIND               = 22,
    SIID_HELP               = 23,
    SIID_SHARE              = 28,
    SIID_LINK               = 29,
    SIID_SLOWFILE           = 30,
    SIID_RECYCLER           = 31,
    SIID_RECYCLERFULL       = 32,
    SIID_MEDIACDAUDIO       = 40,
    SIID_LOCK               = 47,
    SIID_AUTOLIST           = 49,
    SIID_PRINTERNET         = 50,
    SIID_SERVERSHARE        = 51,
    SIID_PRINTERFAX         = 52,
    SIID_PRINTERFAXNET      = 53,
    SIID_PRINTERFILE        = 54,
    SIID_STACK              = 55,
    SIID_MEDIASVCD          = 56,
    SIID_STUFFEDFOLDER      = 57,
    SIID_DRIVEUNKNOWN       = 58,
    SIID_DRIVEDVD           = 59,
    SIID_MEDIADVD           = 60,
    SIID_MEDIADVDRAM        = 61,
    SIID_MEDIADVDRW         = 62,
    SIID_MEDIADVDR          = 63,
    SIID_MEDIADVDROM        = 64,
    SIID_MEDIACDAUDIOPLUS   = 65,
    SIID_MEDIACDRW          = 66,
    SIID_MEDIACDR           = 67,
    SIID_MEDIACDBURN        = 68,
    SIID_MEDIABLANKCD       = 69,
    SIID_MEDIACDROM         = 70,
    SIID_AUDIOFILES         = 71,
    SIID_IMAGEFILES         = 72,
    SIID_VIDEOFILES         = 73,
    SIID_MIXEDFILES         = 74,
    SIID_FOLDERBACK         = 75,
    SIID_FOLDERFRONT        = 76,
    SIID_SHIELD             = 77,
    SIID_WARNING            = 78,
    SIID_INFO               = 79,
    SIID_ERROR              = 80,
    SIID_KEY                = 81,
    SIID_SOFTWARE           = 82,
    SIID_RENAME             = 83,
    SIID_DELETE             = 84,
    SIID_MEDIAAUDIODVD      = 85,
    SIID_MEDIAMOVIEDVD      = 86,
    SIID_MEDIAENHANCEDCD    = 87,
    SIID_MEDIAENHANCEDDVD   = 88,
    SIID_MEDIAHDDVD         = 89,
    SIID_MEDIABLURAY        = 90,
    SIID_MEDIAVCD           = 91,
    SIID_MEDIADVDPLUSR      = 92,
    SIID_MEDIADVDPLUSRW     = 93,
    SIID_DESKTOPPC          = 94,
    SIID_MOBILEPC           = 95,
    SIID_USERS              = 96,
    SIID_MEDIASMARTMEDIA    = 97,
    SIID_MEDIACOMPACTFLASH  = 98,
    SIID_DEVICECELLPHONE    = 99,
    SIID_DEVICECAMERA       = 100,
    SIID_DEVICEVIDEOCAMERA  = 101,
    SIID_DEVICEAUDIOPLAYER  = 102,
    SIID_NETWORKCONNECT     = 103,
    SIID_INTERNET           = 104,
    SIID_ZIPFILE            = 105,
    SIID_SETTINGS           = 106,
    SIID_DRIVEHDDVD         = 132,
    SIID_DRIVEBD            = 133,
    SIID_MEDIAHDDVDROM      = 134,
    SIID_MEDIAHDDVDR        = 135,
    SIID_MEDIAHDDVDRAM      = 136,
    SIID_MEDIABDROM         = 137,
    SIID_MEDIABDR           = 138,
    SIID_MEDIABDRE          = 139,
    SIID_CLUSTEREDDRIVE     = 140,
    SIID_MAX_ICONS          = 174
} SHSTOCKICONID;
#define SIID_INVALID    ((SHSTOCKICONID)-1)
#endif

/* Open printer properties information */
#if (WINVER >= 0x0400) && (NTDDI_VERSION >= 0x06000000)
typedef struct _OPEN_PRINTER_PROPS_INFOA {
    DWORD   dwSize;
    LPSTR   pszSheetName;
    UINT    uSheetIndex;
    DWORD   dwFlags;
    BOOL    bModal;
} OPEN_PRINTER_PROPS_INFOA;
typedef OPEN_PRINTER_PROPS_INFOA    *POPEN_PRINTER_PROPS_INFOA;
typedef struct _OPEN_PRINTER_PROPS_INFOW {
    DWORD   dwSize;
    LPWSTR  pszSheetName;
    UINT    uSheetIndex;
    DWORD   dwFlags;
    BOOL    bModal;
} OPEN_PRINTER_PROPS_INFOW;
typedef OPEN_PRINTER_PROPS_INFOW    *POPEN_PRINTER_PROPS_INFOW;
#ifdef UNICODE
typedef OPEN_PRINTER_PROPS_INFOW    OPEN_PRINTER_PROPS_INFO;
typedef POPEN_PRINTER_PROPS_INFOW   POPEN_PRINTER_PROPS_INFO;
#else
typedef OPEN_PRINTER_PROPS_INFOA    OPEN_PRINTER_PROPS_INFO;
typedef POPEN_PRINTER_PROPS_INFOA   POPEN_PRINTER_PROPS_INFO;
#endif
#endif

/* Network address control address */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct tagNC_ADDRESS {
    struct NET_ADDRESS_INFO_    *pAddrInfo;
    USHORT                      PortNumber;
    BYTE                        PrefixLength;
} NC_ADDRESS;
typedef NC_ADDRESS  *PNC_ADDRESS;
#endif

/* Functions in SHELL32.DLL */
SHSTDAPI_( LPWSTR * )   CommandLineToArgvW( LPCWSTR, int * );
SHSTDAPI_( void )       DragAcceptFiles( HWND, BOOL );
SHSTDAPI_( void )       DragFinish( HDROP );
SHSTDAPI_( UINT )       DragQueryFileA( HDROP, UINT, LPSTR, UINT );
SHSTDAPI_( UINT )       DragQueryFileW( HDROP, UINT, LPWSTR, UINT );
SHSTDAPI_( BOOL )       DragQueryPoint( HDROP, LPPOINT );
SHSTDAPI_( HICON )      DuplicateIcon( HINSTANCE, HICON );
SHSTDAPI_( HICON )      ExtractAssociatedIconA( HINSTANCE, LPSTR, WORD * );
SHSTDAPI_( HICON )      ExtractAssociatedIconExA( HINSTANCE, LPSTR, WORD *, WORD * );
SHSTDAPI_( HICON )      ExtractAssociatedIconExW( HINSTANCE, LPWSTR, WORD *, WORD * );
SHSTDAPI_( HICON )      ExtractAssociatedIconW( HINSTANCE, LPWSTR, WORD * );
SHSTDAPI_( HICON )      ExtractIconA( HINSTANCE, LPCSTR, UINT );
SHSTDAPI_( HICON )      ExtractIconW( HINSTANCE, LPCWSTR, UINT );
SHSTDAPI_( HINSTANCE )  FindExecutableA( LPCSTR, LPCSTR, LPSTR );
SHSTDAPI_( HINSTANCE )  FindExecutableW( LPCWSTR, LPCWSTR, LPWSTR );
SHSTDAPI_( INT )        ShellAboutA( HWND, LPCSTR, LPCSTR, HICON );
SHSTDAPI_( INT )        ShellAboutW( HWND, LPCWSTR, LPCWSTR, HICON );
SHSTDAPI_( HINSTANCE )  ShellExecuteA( HWND, LPCSTR, LPCSTR, LPCSTR, LPCSTR, INT );
SHSTDAPI_( HINSTANCE )  ShellExecuteW( HWND, LPCWSTR, LPCWSTR, LPCWSTR, LPCWSTR, INT );
#if (WINVER >= 0x0400)
SHSTDAPI_( DWORD )      DoEnvironmentSubstA( LPSTR, UINT );
SHSTDAPI_( DWORD )      DoEnvironmentSubstW( LPWSTR, UINT );
SHSTDAPI_( UINT )       ExtractIconExA( LPCSTR, int, HICON *, HICON *, UINT );
SHSTDAPI_( UINT )       ExtractIconExW( LPCWSTR, int, HICON *, HICON *, UINT );
SHSTDAPI_( UINT_PTR )   SHAppBarMessage( DWORD, PAPPBARDATA );
SHSTDAPI_( int )        SHFileOperationA( LPSHFILEOPSTRUCTA );
SHSTDAPI_( int )        SHFileOperationW( LPSHFILEOPSTRUCTW );
SHSTDAPI_( void )       SHFreeNameMappings( HANDLE );
SHSTDAPI_( DWORD_PTR )  SHGetFileInfoA( LPCSTR, DWORD, SHFILEINFOA *, UINT, UINT );
SHSTDAPI_( DWORD_PTR )  SHGetFileInfoW( LPCWSTR, DWORD, SHFILEINFOW *, UINT, UINT );
SHSTDAPI_( BOOL )       ShellExecuteExA( SHELLEXECUTEINFOA * );
SHSTDAPI_( BOOL )       ShellExecuteExW( SHELLEXECUTEINFOW * );
SHSTDAPI_( BOOL )       Shell_NotifyIconA( DWORD, PNOTIFYICONDATA );
SHSTDAPI                Shell_NotifyIconGetRect( const NOTIFYICONIDENTIFIER *, RECT * );
SHSTDAPI_( BOOL )       Shell_NotifyIconW( DWORD, PNOTIFYICONDATA );
#if (NTDDI_VERSION >= 0x05000000)
SHSTDAPI_( BOOL )       SHCreateProcessAsUserW( PSHCREATEPROCESSINFOW );
SHSTDAPI                SHEmptyRecycleBinA( HWND, LPCSTR, DWORD );
SHSTDAPI                SHEmptyRecycleBinW( HWND, LPCWSTR, DWORD );
SHSTDAPI_( BOOL )       SHGetDiskFreeSpaceExA( LPCSTR, ULARGE_INTEGER *, ULARGE_INTEGER *, ULARGE_INTEGER * );
SHSTDAPI_( BOOL )       SHGetDiskFreeSpaceExW( LPCWSTR, ULARGE_INTEGER *, ULARGE_INTEGER *, ULARGE_INTEGER * );
SHSTDAPI_( BOOL )       SHGetNewLinkInfoA( LPCSTR, LPCSTR, LPSTR, BOOL *, UINT );
SHSTDAPI_( BOOL )       SHGetNewLinkInfoW( LPCWSTR, LPCWSTR, LPWSTR, BOOL *, UINT );
SHSTDAPI_( BOOL )       SHInvokePrinterCommandA( HWND, UINT, LPCSTR, LPCSTR, BOOL );
SHSTDAPI_( BOOL )       SHInvokePrinterCommandW( HWND, UINT, LPCWSTR, LPCWSTR, BOOL );
SHSTDAPI                SHQueryRecycleBinA( LPCSTR, LPSHQUERYRBINFO );
SHSTDAPI                SHQueryRecycleBinW( LPCWSTR, LPSHQUERYRBINFO );
#endif
#if (NTDDI_VERSION >= 0x06000000)
SHSTDAPI                AssocCreateForClasses( ASSOCIATIONELEMENT *, ULONG, REFIID, void ** );
SHSTDAPI                SHEvaluateSystemCommandTemplate( PCWSTR, PWSTR *, PWSTR *, PWSTR * );
SHSTDAPI                SHGetStockIconInfo( SHSTOCKICONID, UINT, SHSTOCKICONINFO * );
SHSTDAPI                SHQueryUserNotificationState( QUERY_USER_NOTIFICATION_STATE * );
#endif
#endif
#if (_WIN32_WINNT >= 0x0500) || (_WIN32_WINDOWS >= 0x0500)
SHSTDAPI                SHIsFileAvailableOffline( LPCWSTR, LPDWORD );
SHSTDAPI                SHLoadNonloadedIconOverlayIdentifiers( void );
#endif
#if (_WIN32_IE >= 0x0600)
SHSTDAPI                SHEnumerateUnreadMailAccountsW( HKEY, DWORD, LPWSTR, int );
SHSTDAPI                SHGetUnreadMailCountW( HKEY, LPCWSTR, DWORD *, FILETIME *, LPWSTR, int );
SHSTDAPI                SHSetUnreadMailCountW( LPCWSTR, DWORD, LPCWSTR );
#if (NTDDI_VERSION >= 0x05010000)
SHSTDAPI                SHGetImageList( int, REFIID, void ** );
#endif
#endif
#if (_WIN32_IE >= 0x0601)
SHSTDAPI_( BOOL )       SHTestTokenMembership( HANDLE, ULONG );
#endif
#if (NTDDI_VERSION >= 0x05000000)
SHSTDAPI_( BOOL )       IsLFNDriveA( LPCSTR );
SHSTDAPI_( BOOL )       IsLFNDriveW( LPCWSTR );
#endif
#if (NTDDI_VERSION >= 0x05010000)
SHSTDAPI                SHSetLocalizedName( LPCWSTR, LPCWSTR, int );
#endif
#if (NTDDI_VERSION >= 0x06000000)
SHSTDAPI_( BOOL )       InitNetworkAddressControl( void );
SHSTDAPI                SHGetDriveMedia( LPCWSTR, DWORD * );
SHSTDAPI                SHGetLocalizedName( LPCWSTR, LPWSTR, UINT, int * );
SHSTDAPI                SHRemoveLocalizedName( LPCWSTR );
#endif
#if (NTDDI_VERSION >= 0x06010000)
SHSTDAPI                SHGetPropertyStoreForWindow( HWND, REFIID, void ** );
#endif

/* Functions in SHELL32.DLL with variable argument lists */
WINSHELLAPI int WINAPIV ShellMessageBoxA( HINSTANCE, HWND, LPCSTR, LPCSTR, UINT, ... );
WINSHELLAPI int WINAPIV ShellMessageBoxW( HINSTANCE, HWND, LPCWSTR, LPCWSTR, UINT, ... );

/* Functions in NTSHRUI.DLL (These need to be accessed using GetProcAddress().) */
#if (_WIN32_IE >= 0x0600)
typedef HRESULT (STDMETHODCALLTYPE *PFNCANSHAREFOLDERW)( LPCWSTR );
typedef HRESULT (STDMETHODCALLTYPE *PFNSHOWSHAREFOLDERUIW)( HWND, LPCWSTR );
#endif

/* Functions implemented as macros */
#if (NTDDI_VERSION >= 0x06000000)
    #define NetAddr_GetAddress( x, p ) \
        (HRESULT)SNDMSG( x, NCM_GETADDRESS, 0, (LPARAM)(p) )
    #define NetAddr_SetAllowType( x, p ) \
        (HRESULT)SNDMSG( x, NCM_SETALLOWTYPE, (WPARAM)(p), 0 )
    #define NetAddr_GetAllowType( x ) \
        (DWORD)SNDMSG( x, NCM_GETALLOWTYPE, 0, 0 )
    #define NetAddr_DisplayErrorTip( x ) \
        (HRESULT)SNDMSG( x, NCM_DISPLAYERRORTIP, 0, 0 )
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define DragQueryFile                           DragQueryFileW
    #define ExtractAssociatedIcon                   ExtractAssociatedIconW
    #define ExtractAssociatedIconEx                 ExtractAssociatedIconExW
    #define ExtractIcon                             ExtractIconW
    #define FindExecutable                          FindExecutableW
    #define ShellAbout                              ShellAboutW
    #define ShellExecute                            ShellExecuteW
    #if (WINVER >= 0x0400)
        #define DoEnvironmentSubst                  DoEnvironmentSubstW
        #define ExtractIconEx                       ExtractIconExW
        #define SHFileOperation                     SHFileOperationW
        #define SHGetFileInfo                       SHGetFileInfoW
        #define ShellExecuteEx                      ShellExecuteExW
        #define ShellMessageBox                     ShellMessageBoxW
        #define Shell_NotifyIcon                    Shell_NotifyIconW
        #if (NTDDI_VERSION >= 0x05000000)
            #define SHEmptyRecycleBin               SHEmptyRecycleBinW
            #define SHGetDiskFreeSpaceEx            SHGetDiskFreeSpaceExW
            #define SHGetNewLinkInfo                SHGetNewLinkInfoW
            #define SHInvokePrinterCommand          SHInvokePrinterCommandW
            #define SHQueryRecycleBin               SHQueryRecycleBinW
        #endif
    #endif
    #if (_WIN32_IE >= 0x0600)
        #define SHEnumerateUnreadMailAccounts   SHEnumerateUnreadMailAccountsW
        #define SHGetUnreadMailCount            SHGetUnreadMailCountW
        #define SHSetUnreadMailCount            SHSetUnreadMailCountW
    #endif
    #if (NTDDI_VERSION >= 0x05000000)
        #define IsLFNDrive                          IsLFNDriveW
    #endif
#else
    #define DragQueryFile                           DragQueryFileA
    #define ExtractAssociatedIcon                   ExtractAssociatedIconA
    #define ExtractAssociatedIconEx                 ExtractAssociatedIconExA
    #define ExtractIcon                             ExtractIconA
    #define FindExecutable                          FindExecutableA
    #define ShellAbout                              ShellAboutA
    #define ShellExecute                            ShellExecuteA
    #if (WINVER >= 0x0400)
        #define DoEnvironmentSubst                  DoEnvironmentSubstA
        #define ExtractIconEx                       ExtractIconExA
        #define SHFileOperation                     SHFileOperationA
        #define SHGetFileInfo                       SHGetFileInfoA
        #define ShellExecuteEx                      ShellExecuteExA
        #define ShellMessageBox                     ShellMessageBoxA
        #define Shell_NotifyIcon                    Shell_NotifyIconA
        #if (NTDDI_VERSION >= 0x05000000)
            #define SHEmptyRecycleBin               SHEmptyRecycleBinA
            #define SHGetDiskFreeSpaceEx            SHGetDiskFreeSpaceExA
            #define SHGetNewLinkInfo                SHGetNewLinkInfoA
            #define SHInvokePrinterCommand          SHInvokePrinterCommandA
            #define SHQueryRecycleBin               SHQueryRecycleBinA
        #endif
    #endif
    #if (NTDDI_VERSION >= 0x05000000)
        #define IsLFNDrive                          IsLFNDriveA
    #endif
#endif

/* SHGetDiskFreeSpace() is an alias for SHGetDiskFreeSpaceEx(). */
#define SHGetDiskFreeSpace  SHGetDiskFreeSpaceEx

#include <poppack.h>

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _INC_SHELLAPI */
