/*
 *  rpcasync.h  RPC asynchronous functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef __RPCASYNC_H__
#define __RPCASYNC_H__

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* RPC asynchronous state flags */
#define RPC_C_NOTIFY_ON_SEND_COMPLETE   0x00000001L
#define RPC_C_INFINITE_TIMEOUT          INFINITE

/* RPC extender error information constants */
#if (NTDDI_VERSION >= 0x05010000)
    #define MaxNumberOfEEInfoParams 4
    #define RPC_EEINFO_VERSION      1
#endif

/* RPC extended error information flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define EEInfoPreviousRecordsMissing    1
    #define EEInfoNextRecordsMissing        2
    #define EEInfoUseFileTime               4
    #define EEInfoGCCOM                     11
#endif
#if (NTDDI_VERSION >= 0x05020000)
    #define EEInfoGCFRS                     12
#endif

/* RPC call attributes version number */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_CALL_ATTRIBUTES_VERSION 2
#elif (NTDDI_VERSION >= 0x05010000)
    #define RPC_CALL_ATTRIBUTES_VERSION 1
#endif

/* RPC call attributes flags */
#if (NTDDI_VERSION >= 0x05010000)
    #define RPC_QUERY_SERVER_PRINCIPAL_NAME 0x00000002L
    #define RPC_QUERY_CLIENT_PRINCIPAL_NAME 0x00000004L
#endif
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_QUERY_CALL_LOCAL_ADDRESS    0x00000008L
    #define RPC_QUERY_CLIENT_PID            0x00000010L
    #define RPC_QUERY_IS_CLIENT_LOCAL       0x00000020L
    #define RPC_QUERY_NO_AUTH_REQUIRED      0x00000040L
#endif

/* RPC call status flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_CALL_STATUS_CANCELLED       0x00000001L
    #define RPC_CALL_STATUS_DISCONNECTED    0x00000002L
#endif

/* RpcDiagnoseError() flags */
#if (NTDDI_VERSION >= 0x06000000)
    #define RPC_DE_USE_CURRENT_EEINFO   0x00000001L
#endif

/* RPC notification types */
typedef enum _RPC_NOTIFICATION_TYPES {
    RpcNotificationTypeNone,
    RpcNotificationTypeEvent,
    RpcNotificationTypeApc,
    RpcNotificationTypeIoc,
    RpcNotificationTypeHwnd,
    RpcNotificationTypeCallback
} RPC_NOTIFICATION_TYPES;

/* RPC asynchronous events */
typedef enum _RPC_ASYNC_EVENT {
    RpcCallComplete,
    RpcSendComplete,
    RpcReceiveComplete,
#if (NTDDI_VERSION >= 0x06000000)
    RpcClientDisconnect,
    RpcClientCancel
#else
    RpcClientDisconnect
#endif
} RPC_ASYNC_EVENT;

/* RPC notification routine */
struct _RPC_ASYNC_STATE;
typedef void (RPC_ENTRY RPCNOTIFICATION_ROUTINE)( struct _RPC_ASYNC_STATE *, void *, RPC_ASYNC_EVENT );
typedef RPCNOTIFICATION_ROUTINE *PFN_RPCNOTIFICATION_ROUTINE;

/* RPC asynchronous notification information */
typedef union _RPC_ASYNC_NOTIFICATION_INFO {
    struct {
        PFN_RPCNOTIFICATION_ROUTINE NotificationRoutine;
        HANDLE                      hThread;
    } APC;
    struct {
        HANDLE          hIOPort;
        DWORD           dwNumberOfBytesTransferred;
        DWORD_PTR       dwCompletionKey;
        LPOVERLAPPED    lpOverlapped;
    } IOC;
    struct {
        HWND    hWnd;
        UINT    Msg;
    } HWND;
    HANDLE                      hEvent;
    PFN_RPCNOTIFICATION_ROUTINE NotificationRoutine;
} RPC_ASYNC_NOTIFICATION_INFO;
typedef RPC_ASYNC_NOTIFICATION_INFO *PRPC_ASYNC_NOTIFICATION_INFO;

/* RPC asynchronous state */
typedef struct _RPC_ASYNC_STATE {
    unsigned int                Size;
    unsigned long               Signature;
    long                        Lock;
    unsigned long               Flags;
    void                        *StubInfo;
    void                        *UserInfo;
    void                        *RuntimeInfo;
    RPC_ASYNC_EVENT             Event;
    RPC_NOTIFICATION_TYPES      NotificationType;
    RPC_ASYNC_NOTIFICATION_INFO u;
    LONG_PTR                    Reserved[4];
} RPC_ASYNC_STATE;
typedef RPC_ASYNC_STATE *PRPC_ASYNC_STATE;

/* Extended error parameter types */
#if (NTDDI_VERSION >= 0x05010000)
typedef enum tagExtendedErrorParamTypes {
    eeptAnsiString      = 1,
    eeptUnicodeString   = 2,
    eeptLongVal         = 3,
    eeptShortVal        = 4,
    eeptPointerVal      = 5,
    eeptNone            = 6,
    eeptBinary          = 7
} ExtendedErrorParamTypes;
#endif

/* Binary parameter */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagBinaryParam {
    void    *Buffer;
    short   Size;
} BinaryParam;
#endif

/* RPC extended error information parameter */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagRPC_EE_INFO_PARAM {
    ExtendedErrorParamTypes ParameterType;
    union {
        LPSTR       AnsiString;
        LPWSTR      UnicodeString;
        long        LVal;
        short       SVal;
        ULONGLONG   PVal;
        BinaryParam BVal;
    } u;
} RPC_EE_INFO_PARAM;
#endif

/* RPC extended error information */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagRPC_EXTENDED_ERROR_INFO {
    ULONG               Version;
    LPWSTR              ComputerName;
    ULONG               ProcessID;
    union {
        SYSTEMTIME  SystemTime;
        FILETIME    FileTime;
    } u;
    ULONG               GeneratingComponent;
    ULONG               Status;
    USHORT              DetectionLocation;
    USHORT              Flags;
    int                 NumberOfParameters;
    RPC_EE_INFO_PARAM   Parameters[MaxNumberOfEEInfoParams];
} RPC_EXTENDED_ERROR_INFO;
#endif

/* RPC error enumeration handle */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagRPC_ERROR_ENUM_HANDLE {
    ULONG   Signature;
    void    *CurrentPos;
    void    *Head;
} RPC_ERROR_ENUM_HANDLE;
#endif

/* RPC local address format */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum tagRpcLocalAddressFormat {
    rlafInvalid = 0,
    rlafIPv4    = 1,
    rlafIPv6    = 2
} RpcLocalAddressFormat;
#endif

/* RPC call local address */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct _RPC_CALL_LOCAL_ADDRESS_V1 {
    unsigned int            Version;
    void                    *Buffer;
    unsigned long           BufferSize;
    RpcLocalAddressFormat   AddressFormat;
} RPC_CALL_LOCAL_ADDRESS_V1;
typedef RPC_CALL_LOCAL_ADDRESS_V1   *PRPC_CALL_LOCAL_ADDRESS_V1;
#endif

/* RPC call attributes (version 1) */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct tagRPC_CALL_ATTRIBUTES_V1_A {
    unsigned int    Version;
    unsigned long   Flags;
    unsigned long   ServerPrincipalNameBufferLength;
    unsigned char   *ServerPrincipalName;
    unsigned long   ClientPrincipalNameBufferLength;
    unsigned char   *ClientPrincipalName;
    unsigned long   AuthenticationLevel;
    unsigned long   AuthenticationService;
    BOOL            NullSession;
} RPC_CALL_ATTRIBUTES_V1_A;
typedef struct tagRPC_CALL_ATTRIBUTES_V1_W {
    unsigned int    Version;
    unsigned long   Flags;
    unsigned long   ServerPrincipalNameBufferLength;
    unsigned short  *ServerPrincipalName;
    unsigned long   ClientPrincipalNameBufferLength;
    unsigned short  *ClientPrincipalName;
    unsigned long   AuthenticationLevel;
    unsigned long   AuthenticationService;
    BOOL            NullSession;
} RPC_CALL_ATTRIBUTES_V1_W;
#ifdef UNICODE
typedef RPC_CALL_ATTRIBUTES_V1_W    RPC_CALL_ATTRIBUTES_V1;
#else
typedef RPC_CALL_ATTRIBUTES_V1_A    RPC_CALL_ATTRIBUTES_V1;
#endif
#endif

/* RPC call types */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum tagRpcCallType {
    rtcInvalid      = 0,
    rtcNormal       = 1,
    rtcTraining     = 2,
    rtcGuaranteed   = 3
} RpcCallType;
#endif

/* RPC call client locality */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum tagRpcCallClientLocality {
    rcclInvalid                 = 0,
    rcclLocal                   = 1,
    rcclRemote                  = 2,
    rcclClientUnknownLocality   = 3
} RpcCallClientLocality;
#endif

/* RPC call attributes (version 2) */
#if (NTDDI_VERSION >= 0x06000000)
typedef struct tagRPC_CALL_ATTRIBUTES_V2_A {
    unsigned int                Version;
    unsigned long               Flags;
    unsigned long               ServerPrincipalNameBufferLength;
    unsigned char               *ServerPrincipalName;
    unsigned long               ClientPrincipalNameBufferLength;
    unsigned char               *ClientPrincipalName;
    unsigned long               AuthenticationLevel;
    unsigned long               AuthenticationService;
    BOOL                        NullSession;
    BOOL                        KernelModeCaller;
    unsigned long               ProtocolSequence;
    RpcCallClientLocality       IsClientLocal;
    HANDLE                      ClientPID;
    unsigned long               CallStatus;
    RpcCallType                 CallType;
    RPC_CALL_LOCAL_ADDRESS_V1   *CallLocalAddress;
    unsigned short              OpNum;
    UUID                        InterfaceUuid;
} RPC_CALL_ATTRIBUTES_V2_A;
typedef struct tagRPC_CALL_ATTRIBUTES_V2_W {
    unsigned int                Version;
    unsigned long               Flags;
    unsigned long               ServerPrincipalNameBufferLength;
    unsigned short              *ServerPrincipalName;
    unsigned long               ClientPrincipalNameBufferLength;
    unsigned short              *ClientPrincipalName;
    unsigned long               AuthenticationLevel;
    unsigned long               AuthenticationService;
    BOOL                        NullSession;
    BOOL                        KernelModeCaller;
    unsigned long               ProtocolSequence;
    RpcCallClientLocality       IsClientLocal;
    HANDLE                      ClientPID;
    unsigned long               CallStatus;
    RpcCallType                 CallType;
    RPC_CALL_LOCAL_ADDRESS_V1   *CallLocalAddress;
    unsigned short              OpNum;
    UUID                        InterfaceUuid;
} RPC_CALL_ATTRIBUTES_V2_W;
#ifdef UNICODE
typedef RPC_CALL_ATTRIBUTES_V2_W    RPC_CALL_ATTRIBUTES_V2;
#else
typedef RPC_CALL_ATTRIBUTES_V2_A    RPC_CALL_ATTRIBUTES_V2;
#endif
#endif

/* RPC notifications */
#if (NTDDI_VERSION >= 0x06000000)
typedef enum _RPC_NOTIFICATIONS {
    RpcNotificationCallNone         = 0,
    RpcNotificationClientDisconnect = 1,
    RpcNotificationCallCancel       = 2,
    RpcNotificationCallStatusChange = RpcNotificationClientDisconnect
} RPC_NOTIFICATIONS;
#endif

/* Functions in RPCRT4.DLL */
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcAsyncAbortCall( PRPC_ASYNC_STATE, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   I_RpcAsyncSetHandle( PRPC_MESSAGE, PRPC_ASYNC_STATE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncAbortCall( PRPC_ASYNC_STATE, unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncCancelCall( PRPC_ASYNC_STATE, BOOL );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncCompleteCall( PRPC_ASYNC_STATE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncGetCallStatus( PRPC_ASYNC_STATE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncInitializeHandle( PRPC_ASYNC_STATE, unsigned int );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcAsyncRegisterInfo( PRPC_ASYNC_STATE );
#if (NTDDI_VERSION >= 0x05010000)
RPCRTAPI int RPC_ENTRY          I_RpcExceptionFilter( unsigned long );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorAddRecord( RPC_EXTENDED_ERROR_INFO * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorClearInformation( void );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorEndEnumeration( RPC_ERROR_ENUM_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorGetNextRecord( RPC_ERROR_ENUM_HANDLE *, BOOL, RPC_EXTENDED_ERROR_INFO * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorGetNumberOfRecords( RPC_ERROR_ENUM_HANDLE *, int * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorLoadErrorInfo( PVOID, size_t, RPC_ERROR_ENUM_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorResetEnumeration( RPC_ERROR_ENUM_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorSaveErrorInfo( RPC_ERROR_ENUM_HANDLE *, PVOID *, size_t * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcErrorStartEnumeration( RPC_ERROR_ENUM_HANDLE * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcFreeAuthorizationContext( PVOID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcGetAuthorizationContextForClient( RPC_BINDING_HANDLE, BOOL, PVOID, PLARGE_INTEGER, LUID, DWORD, PVOID, PVOID * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqCallAttributesA( RPC_BINDING_HANDLE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerInqCallAttributesW( RPC_BINDING_HANDLE, void * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcSsContextLockExclusive( RPC_BINDING_HANDLE, PVOID );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcSsContextLockShared( RPC_BINDING_HANDLE, PVOID );
#endif
#if (NTDDI_VERSION >= 0x06000000)
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingBind( PRPC_ASYNC_STATE, RPC_BINDING_HANDLE, RPC_IF_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcBindingUnbind( RPC_BINDING_HANDLE );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerSubscribeForNotification( RPC_BINDING_HANDLE, RPC_NOTIFICATIONS, RPC_NOTIFICATION_TYPES, RPC_ASYNC_NOTIFICATION_INFO * );
RPCRTAPI RPC_STATUS RPC_ENTRY   RpcServerUnsubscribeForNotification( RPC_BINDING_HANDLE, RPC_NOTIFICATIONS, unsigned long * );
#endif

/* Functions implemented as macros */
#define RpcAsyncGetCallHandle( x )  (((PRPC_ASYNC_STATE)x)->RuntimeInfo)

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #if (NTDDI_VERSION >= 0x05010000)
        #define RpcServerInqCallAttributes  RpcServerInqCallAttributesW
    #else
        #define RpcServerInqCallAttributes  RpcServerInqCallAttributesA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __RPCASYNC_H__ */
