/*
 *  ole2.h      Object Linking and Embedding (OLE) 2.0 functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2014 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _OLE2_H_
#define _OLE2_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file;
#endif

#include <objbase.h>
#include <oleauto.h>
#include <oleidl.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Error codes */
#define E_DRAW              VIEW_E_DRAW
#define DATA_E_FORMATETC    DV_E_FORMATETC

/* OLE verbs */
#define OLEIVERB_PRIMARY            0L
#define OLEIVERB_SHOW               (-1L)
#define OLEIVERB_OPEN               (-2L)
#define OLEIVERB_HIDE               (-3L)
#define OLEIVERB_UIACTIVATE         (-4L)
#define OLEIVERB_INPLACEACTIVATE    (-5L)
#define OLEIVERB_DISCARDUNDOSTATE   (-6L)

/* OleCreateEmbeddingHelper() flags */
#define EMBDHLP_INPROC_HANDLER  0x00000000L
#define EMBDHLP_INPROC_SERVER   0x00000001L
#define EMBDHLP_CREATE_NOW      0x00000000L
#define EMBDHLP_DELAYCREATE     0x00010000L

/* OleCreate() flags */
#define OLECREATE_LEAVERUNNING  0x00000001L

/* OLE stream for compatibility with OLE 1.0 */
typedef struct _OLESTREAM {
    struct _OLESTREAMVTBL   *lpstbl;
} OLESTREAM;
typedef OLESTREAM       *LPOLESTREAM;
typedef struct _OLESTREAMVTBL {
    DWORD   (CALLBACK *Get)( LPOLESTREAM, void *, DWORD );
    DWORD   (CALLBACK *Put)( LPOLESTREAM, const void *, DWORD );
} OLESTREAMVTBL;
typedef OLESTREAMVTBL   *LPOLESTREAMVTBL;

/* Functions in OLE32.DLL */
WINOLEAPI               CreateILockBytesOnHGlobal( HGLOBAL, BOOL, LPLOCKBYTES * );
WINOLEAPI               CreateOleAdviseHolder( LPOLEADVISEHOLDER * );
WINOLEAPI               CreateStreamOnHGlobal( HGLOBAL, BOOL, LPSTREAM * );
WINOLEAPI               DoDragDrop( LPDATAOBJECT, LPDROPSOURCE, DWORD, LPDWORD );
WINOLEAPI               GetConvertStg( LPSTORAGE );
WINOLEAPI               GetHGlobalFromILockBytes( LPLOCKBYTES, HGLOBAL * );
WINOLEAPI               GetHGlobalFromStream( LPSTREAM, HGLOBAL * );
WINOLEAPI_( BOOL )      IsAccelerator( HACCEL, int, LPMSG, WORD * );
WINOLEAPI_( DWORD )     OleBuildVersion( VOID );
WINOLEAPI               OleConvertIStorageToOLESTREAM( LPSTORAGE, LPOLESTREAM );
WINOLEAPI               OleConvertIStorageToOLESTREAMEx( LPSTORAGE, CLIPFORMAT, LONG, LONG, DWORD, LPSTGMEDIUM, LPOLESTREAM );
WINOLEAPI               OleConvertOLESTREAMToIStorage( LPOLESTREAM, LPSTORAGE, const DVTARGETDEVICE * );
WINOLEAPI               OleConvertOLESTREAMToIStorageEx( LPOLESTREAM, LPSTORAGE, CLIPFORMAT *, LONG *, LONG *, DWORD *, LPSTGMEDIUM );
WINOLEAPI               OleCreate( REFCLSID, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateDefaultHandler( REFCLSID, LPUNKNOWN, REFIID, LPVOID * );
WINOLEAPI               OleCreateEmbeddingHelper( REFCLSID, LPUNKNOWN, DWORD, LPCLASSFACTORY, REFIID, LPVOID * );
WINOLEAPI               OleCreateEx( REFCLSID, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, IAdviseSink *, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateFromData( LPDATAOBJECT, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateFromDataEx( LPDATAOBJECT, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, IAdviseSink *, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateFromFile( REFCLSID, LPCOLESTR, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateFromFileEx( REFCLSID, LPCOLESTR, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, IAdviseSink *, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLink( LPMONIKER, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLinkEx( LPMONIKER, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLinkFromData( LPDATAOBJECT, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLinkFromDataEx( LPDATAOBJECT, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, IAdviseSink *, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLinkToFile( LPCOLESTR, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleCreateLinkToFileEx( LPCOLESTR, REFIID, DWORD, DWORD, ULONG, DWORD *, LPFORMATETC, IAdviseSink *, DWORD *, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI_( HOLEMENU )  OleCreateMenuDescriptor( HMENU, LPOLEMENUGROUPWIDTHS );
WINOLEAPI               OleCreateStaticFromData( LPDATAOBJECT, REFIID, DWORD, LPFORMATETC, LPOLECLIENTSITE, LPSTORAGE, LPVOID * );
WINOLEAPI               OleDestroyMenuDescriptor( HOLEMENU );
WINOLEAPI               OleDoAutoConvert( LPSTORAGE, LPCLSID );
WINOLEAPI               OleDraw( LPUNKNOWN, DWORD, HDC, LPCRECT );
WINOLEAPI_( HANDLE )    OleDuplicateData( HANDLE, CLIPFORMAT, UINT );
WINOLEAPI               OleFlushClipboard( void );
WINOLEAPI               OleGetAutoConvert( REFCLSID, LPCLSID );
WINOLEAPI               OleGetClipboard( LPDATAOBJECT * );
WINOLEAPI_( HGLOBAL )   OleGetIconOfClass( REFCLSID, LPOLESTR, BOOL );
WINOLEAPI_( HGLOBAL )   OleGetIconOfFile( LPOLESTR, BOOL );
WINOLEAPI               OleInitialize( LPVOID );
WINOLEAPI               OleIsCurrentClipboard( LPDATAOBJECT );
WINOLEAPI_( BOOL )      OleIsRunning( LPOLEOBJECT );
WINOLEAPI               OleLoad( LPSTORAGE, REFIID, LPOLECLIENTSITE, LPVOID * );
WINOLEAPI               OleLoadFromStream( LPSTREAM, REFIID, LPVOID * );
WINOLEAPI               OleLockRunning( LPUNKNOWN, BOOL, BOOL );
WINOLEAPI_( HGLOBAL )   OleMetafilePictFromIconAndLabel( HICON, LPOLESTR, LPOLESTR, UINT );
WINOLEAPI               OleNoteObjectVisible( LPUNKNOWN, BOOL );
WINOLEAPI               OleQueryCreateFromData( LPDATAOBJECT );
WINOLEAPI               OleQueryLinkFromData( LPDATAOBJECT );
WINOLEAPI               OleRegEnumFormatEtc( REFCLSID, DWORD, LPENUMFORMATETC * );
WINOLEAPI               OleRegEnumVerbs( REFCLSID, LPENUMOLEVERB * );
WINOLEAPI               OleRegGetMiscStatus( REFCLSID, DWORD, DWORD * );
WINOLEAPI               OleRegGetUserType( REFCLSID, DWORD, LPOLESTR * );
WINOLEAPI               OleRun( LPUNKNOWN );
WINOLEAPI               OleSave( LPPERSISTSTORAGE, LPSTORAGE, BOOL );
WINOLEAPI               OleSaveToStream( LPPERSISTSTREAM, LPSTREAM );
WINOLEAPI               OleSetAutoConvert( REFCLSID, REFCLSID );
WINOLEAPI               OleSetClipboard( LPDATAOBJECT );
WINOLEAPI               OleSetContainedObject( LPUNKNOWN, BOOL );
WINOLEAPI               OleSetMenuDescriptor( HOLEMENU, HWND, HWND, LPOLEINPLACEFRAME, LPOLEINPLACEACTIVEOBJECT );
WINOLEAPI               OleTranslateAccelerator( LPOLEINPLACEFRAME, LPOLEINPLACEFRAMEINFO, LPMSG );
WINOLEAPI_( void )      OleUninitialize( void );
WINOLEAPI               ReadClassStg( LPSTORAGE, CLSID * );
WINOLEAPI               ReadClassStm( LPSTREAM, CLSID * );
WINOLEAPI               ReadFmtUserTypeStg( LPSTORAGE, CLIPFORMAT *, LPOLESTR * );
WINOLEAPI               RegisterDragDrop( HWND, LPDROPTARGET );
WINOLEAPI_( void )      ReleaseStgMedium( LPSTGMEDIUM );
WINOLEAPI               RevokeDragDrop( HWND );
WINOLEAPI               SetConvertStg( LPSTORAGE, BOOL );
WINOLEAPI               WriteClassStg( LPSTORAGE, REFCLSID );
WINOLEAPI               WriteClassStm( LPSTREAM, REFCLSID );
WINOLEAPI               WriteFmtUserTypeStg( LPSTORAGE, CLIPFORMAT, LPOLESTR );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _OLE2_H_ */
